<?php
/**
 * Kkart Admin: Kkart Subscriptions.
 *
 * Adds a note to learn more about Kkart Subscriptions.
 */

namespace Automattic\Kkart\Admin\Notes;

defined( 'ABSPATH' ) || exit;

use \Automattic\Kkart\Admin\Features\Onboarding;

/**
 * Kkart_Subscriptions.
 */
class KkartSubscriptions {
	/**
	 * Note traits.
	 */
	use NoteTraits;

	/**
	 * Name of the note for use in the database.
	 */
	const NOTE_NAME = 'kkart-admin-kkart-subscriptions';

	/**
	 * Get the note.
	 *
	 * @return Note|null
	 */
	public static function get_note() {
		$onboarding_data = get_option( Onboarding::PROFILE_DATA_OPTION, array() );

		if ( ! isset( $onboarding_data['product_types'] ) || ! in_array( 'subscriptions', $onboarding_data['product_types'], true ) ) {
			return;
		}

		if ( ! self::kkart_admin_active_for( DAY_IN_SECONDS ) ) {
			return;
		}

		$note = new Note();
		$note->set_title( __( 'Do you need more info about Kkart Subscriptions?', 'kkart' ) );
		$note->set_content( __( 'Kkart Subscriptions allows you to introduce a variety of subscriptions for physical or virtual products and services. Create product-of-the-month clubs, weekly service subscriptions or even yearly software billing packages. Add sign-up fees, offer free trials, or set expiration periods.', 'kkart' ) );
		$note->set_type( Note::E_KKART_ADMIN_NOTE_MARKETING );
		$note->set_name( self::NOTE_NAME );
		$note->set_content_data( (object) array() );
		$note->set_source( 'kkart-admin' );
		$note->add_action(
			'learn-more',
			__( 'Learn More', 'kkart' ),
			'https://kkart.com/products/kkart-subscriptions/?utm_source=inbox',
			Note::E_KKART_ADMIN_NOTE_UNACTIONED,
			true
		);
		return $note;
	}
}
