/**
 * External dependencies
 */
import { __ } from '@wordpress/i18n';
import { Icon, external } from '@kkart/icons';
import { ADMIN_URL } from '@kkart/settings';
import { InspectorControls } from '@wordpress/block-editor';
import { useProductDataContext } from '@kkart/shared-context';

/**
 * Component to render an edit product link in the sidebar.
 *
 * @param {Object} props Component props.
 */
const EditProductLink = ( props ) => {
	const productDataContext = useProductDataContext();
	const product = productDataContext.product || {};
	const productId = product.id || props.productId || 0;

	if ( ! productId ) {
		return null;
	}

	return (
		<InspectorControls>
			<div className="kkart-block-single-product__edit-card">
				<div className="kkart-block-single-product__edit-card-title">
					<a
						href={ `${ ADMIN_URL }post.php?post=${ productId }&action=edit` }
						target="_blank"
						rel="noopener noreferrer"
					>
						{ __(
							"Edit this product's details",
							'kkart'
						) }
						<Icon srcElement={ external } size={ 16 } />
					</a>
				</div>
				<div className="kkart-block-single-product__edit-card-description">
					{ __(
						'Edit details such as title, price, description and more.',
						'kkart'
					) }
				</div>
			</div>
		</InspectorControls>
	);
};

export default EditProductLink;
