<?php
/**
 * Customer invoice email
 *
 * This template can be overridden by copying it to yourtheme/kkart/emails/customer-invoice.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates\Emails
 * @version 3.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Executes the e-mail header.
 *
 * @hooked KKART_Emails::email_header() Output the email header
 */
do_action( 'kkart_email_header', $email_heading, $email ); ?>

<?php /* translators: %s: Customer first name */ ?>
<p><?php printf( esc_html__( 'Hi %s,', 'kkart' ), esc_html( $order->get_billing_first_name() ) ); ?></p>

<?php if ( $order->has_status( 'pending' ) ) { ?>
	<p>
	<?php
	printf(
		wp_kses(
			/* translators: %1$s Site title, %2$s Order pay link */
			__( 'An order has been created for you on %1$s. Your invoice is below, with a link to make payment when you’re ready: %2$s', 'kkart' ),
			array(
				'a' => array(
					'href' => array(),
				),
			)
		),
		esc_html( get_bloginfo( 'name', 'display' ) ),
		'<a href="' . esc_url( $order->get_checkout_payment_url() ) . '">' . esc_html__( 'Pay for this order', 'kkart' ) . '</a>'
	);
	?>
	</p>

<?php } else { ?>
	<p>
	<?php
	/* translators: %s Order date */
	printf( esc_html__( 'Here are the details of your order placed on %s:', 'kkart' ), esc_html( kkart_format_datetime( $order->get_date_created() ) ) );
	?>
	</p>
	<?php
}

/**
 * Hook for the kkart_email_order_details.
 *
 * @hooked KKART_Emails::order_details() Shows the order details table.
 * @hooked KKART_Structured_Data::generate_order_data() Generates structured data.
 * @hooked KKART_Structured_Data::output_structured_data() Outputs structured data.
 * @since 2.5.0
 */
do_action( 'kkart_email_order_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Hook for the kkart_email_order_meta.
 *
 * @hooked KKART_Emails::order_meta() Shows order meta data.
 */
do_action( 'kkart_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

/**
 * Hook for kkart_email_customer_details.
 *
 * @hooked KKART_Emails::customer_details() Shows customer details
 * @hooked KKART_Emails::email_address() Shows email address
 */
do_action( 'kkart_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

/**
 * Show user-defined additional content - this is set in each email's settings.
 */
if ( $additional_content ) {
	echo wp_kses_post( wpautop( wptexturize( $additional_content ) ) );
}

/**
 * Executes the email footer.
 *
 * @hooked KKART_Emails::email_footer() Output the email footer
 */
do_action( 'kkart_email_footer', $email );
