<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/kkart/myaccount/form-login.php.
 *
 * HOWEVER, on occasion Kkart will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.kkart.com/document/template-structure/
 * @package Kkart\Templates
 * @version 4.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

do_action( 'kkart_before_customer_login_form' ); ?>

<?php if ( 'yes' === get_option( 'kkart_enable_myaccount_registration' ) ) : ?>

<div class="u-columns col2-set" id="customer_login">

	<div class="u-column1 col-1">

<?php endif; ?>

		<h2><?php esc_html_e( 'Login', 'kkart' ); ?></h2>

		<form class="kkart-form kkart-form-login login" method="post">

			<?php do_action( 'kkart_login_form_start' ); ?>

			<p class="kkart-form-row kkart-form-row--wide form-row form-row-wide">
				<label for="username"><?php esc_html_e( 'Username or email address', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="text" class="kkart-Input kkart-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>
			<p class="kkart-form-row kkart-form-row--wide form-row form-row-wide">
				<label for="password"><?php esc_html_e( 'Password', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
				<input class="kkart-Input kkart-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
			</p>

			<?php do_action( 'kkart_login_form' ); ?>

			<p class="form-row">
				<label class="kkart-form__label kkart-form__label-for-checkbox kkart-form-login__rememberme">
					<input class="kkart-form__input kkart-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'kkart' ); ?></span>
				</label>
				<?php wp_nonce_field( 'kkart-login', 'kkart-login-nonce' ); ?>
				<button type="submit" class="kkart-button button kkart-form-login__submit" name="login" value="<?php esc_attr_e( 'Log in', 'kkart' ); ?>"><?php esc_html_e( 'Log in', 'kkart' ); ?></button>
			</p>
			<p class="kkart-LostPassword lost_password">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'kkart' ); ?></a>
			</p>

			<?php do_action( 'kkart_login_form_end' ); ?>

		</form>

<?php if ( 'yes' === get_option( 'kkart_enable_myaccount_registration' ) ) : ?>

	</div>

	<div class="u-column2 col-2">

		<h2><?php esc_html_e( 'Register', 'kkart' ); ?></h2>

		<form method="post" class="kkart-form kkart-form-register register" <?php do_action( 'kkart_register_form_tag' ); ?> >

			<?php do_action( 'kkart_register_form_start' ); ?>

			<?php if ( 'no' === get_option( 'kkart_registration_generate_username' ) ) : ?>

				<p class="kkart-form-row kkart-form-row--wide form-row form-row-wide">
					<label for="reg_username"><?php esc_html_e( 'Username', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="text" class="kkart-Input kkart-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</p>

			<?php endif; ?>

			<p class="kkart-form-row kkart-form-row--wide form-row form-row-wide">
				<label for="reg_email"><?php esc_html_e( 'Email address', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
				<input type="email" class="kkart-Input kkart-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>

			<?php if ( 'no' === get_option( 'kkart_registration_generate_password' ) ) : ?>

				<p class="kkart-form-row kkart-form-row--wide form-row form-row-wide">
					<label for="reg_password"><?php esc_html_e( 'Password', 'kkart' ); ?>&nbsp;<span class="required">*</span></label>
					<input type="password" class="kkart-Input kkart-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
				</p>

			<?php else : ?>

				<p><?php esc_html_e( 'A password will be sent to your email address.', 'kkart' ); ?></p>

			<?php endif; ?>

			<?php do_action( 'kkart_register_form' ); ?>

			<p class="kkart-form-row form-row">
				<?php wp_nonce_field( 'kkart-register', 'kkart-register-nonce' ); ?>
				<button type="submit" class="kkart-Button kkart-button button kkart-form-register__submit" name="register" value="<?php esc_attr_e( 'Register', 'kkart' ); ?>"><?php esc_html_e( 'Register', 'kkart' ); ?></button>
			</p>

			<?php do_action( 'kkart_register_form_end' ); ?>

		</form>

	</div>

</div>
<?php endif; ?>

<?php do_action( 'kkart_after_customer_login_form' ); ?>
