import { useState } from '@wordpress/element';
import { LabelControl } from './label';

export const RadioControl = (props) =>{
	
	const { prop, label, value, setAttributes	} = props;
	const { name } = prop['c']; 
	
	// Radio Click handler
	const handleRadioClick = (newValue) => {
		setAttributes({ [name]: newValue });
	};
	
	return (
		<div className="components-base-control pagelayer-base-control">
			<LabelControl {...props}/>
			<div className="pagelayer-elp-radio-div">
				{Object.keys(prop.list).map((item) => (
					<a
					className={`pagelayer-elp-radio ${value === item ? 'pagelayer-elp-radio-active' : ''}`}
					onClick={() => handleRadioClick(item)}
					>
					{prop.list[item]}
					</a>
				) ) }
			</div>
		</div>
	);	
}