<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 * States should be defined in English and translated native through localisation files.
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/country-names).
 * Countries defined with empty arrays have no states.
 *
 * @package Kkart\i18n
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'kkart' ),
		'BLU' => __( 'Benguela', 'kkart' ),
		'BIE' => __( 'Bié', 'kkart' ),
		'CAB' => __( 'Cabinda', 'kkart' ),
		'CNN' => __( 'Cunene', 'kkart' ),
		'HUA' => __( 'Huambo', 'kkart' ),
		'HUI' => __( 'Huíla', 'kkart' ),
		'CCU' => __( 'Kuando Kubango', 'kkart' ),
		'CNO' => __( 'Kwanza-Norte', 'kkart' ),
		'CUS' => __( 'Kwanza-Sul', 'kkart' ),
		'LUA' => __( 'Luanda', 'kkart' ),
		'LNO' => __( 'Lunda-Norte', 'kkart' ),
		'LSU' => __( 'Lunda-Sul', 'kkart' ),
		'MAL' => __( 'Malanje', 'kkart' ),
		'MOX' => __( 'Moxico', 'kkart' ),
		'NAM' => __( 'Namibe', 'kkart' ),
		'UIG' => __( 'Uíge', 'kkart' ),
		'ZAI' => __( 'Zaire', 'kkart' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'kkart' ),
		'B' => __( 'Buenos Aires', 'kkart' ),
		'K' => __( 'Catamarca', 'kkart' ),
		'H' => __( 'Chaco', 'kkart' ),
		'U' => __( 'Chubut', 'kkart' ),
		'X' => __( 'Córdoba', 'kkart' ),
		'W' => __( 'Corrientes', 'kkart' ),
		'E' => __( 'Entre Ríos', 'kkart' ),
		'P' => __( 'Formosa', 'kkart' ),
		'Y' => __( 'Jujuy', 'kkart' ),
		'L' => __( 'La Pampa', 'kkart' ),
		'F' => __( 'La Rioja', 'kkart' ),
		'M' => __( 'Mendoza', 'kkart' ),
		'N' => __( 'Misiones', 'kkart' ),
		'Q' => __( 'Neuquén', 'kkart' ),
		'R' => __( 'Río Negro', 'kkart' ),
		'A' => __( 'Salta', 'kkart' ),
		'J' => __( 'San Juan', 'kkart' ),
		'D' => __( 'San Luis', 'kkart' ),
		'Z' => __( 'Santa Cruz', 'kkart' ),
		'S' => __( 'Santa Fe', 'kkart' ),
		'G' => __( 'Santiago del Estero', 'kkart' ),
		'V' => __( 'Tierra del Fuego', 'kkart' ),
		'T' => __( 'Tucumán', 'kkart' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'kkart' ),
		'NSW' => __( 'New South Wales', 'kkart' ),
		'NT'  => __( 'Northern Territory', 'kkart' ),
		'QLD' => __( 'Queensland', 'kkart' ),
		'SA'  => __( 'South Australia', 'kkart' ),
		'TAS' => __( 'Tasmania', 'kkart' ),
		'VIC' => __( 'Victoria', 'kkart' ),
		'WA'  => __( 'Western Australia', 'kkart' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'kkart' ),
		'BD-01' => __( 'Bandarban', 'kkart' ),
		'BD-02' => __( 'Barguna', 'kkart' ),
		'BD-06' => __( 'Barishal', 'kkart' ),
		'BD-07' => __( 'Bhola', 'kkart' ),
		'BD-03' => __( 'Bogura', 'kkart' ),
		'BD-04' => __( 'Brahmanbaria', 'kkart' ),
		'BD-09' => __( 'Chandpur', 'kkart' ),
		'BD-10' => __( 'Chattogram', 'kkart' ),
		'BD-12' => __( 'Chuadanga', 'kkart' ),
		'BD-11' => __( "Cox's Bazar", 'kkart' ),
		'BD-08' => __( 'Cumilla', 'kkart' ),
		'BD-13' => __( 'Dhaka', 'kkart' ),
		'BD-14' => __( 'Dinajpur', 'kkart' ),
		'BD-15' => __( 'Faridpur ', 'kkart' ),
		'BD-16' => __( 'Feni', 'kkart' ),
		'BD-19' => __( 'Gaibandha', 'kkart' ),
		'BD-18' => __( 'Gazipur', 'kkart' ),
		'BD-17' => __( 'Gopalganj', 'kkart' ),
		'BD-20' => __( 'Habiganj', 'kkart' ),
		'BD-21' => __( 'Jamalpur', 'kkart' ),
		'BD-22' => __( 'Jashore', 'kkart' ),
		'BD-25' => __( 'Jhalokati', 'kkart' ),
		'BD-23' => __( 'Jhenaidah', 'kkart' ),
		'BD-24' => __( 'Joypurhat', 'kkart' ),
		'BD-29' => __( 'Khagrachhari', 'kkart' ),
		'BD-27' => __( 'Khulna', 'kkart' ),
		'BD-26' => __( 'Kishoreganj', 'kkart' ),
		'BD-28' => __( 'Kurigram', 'kkart' ),
		'BD-30' => __( 'Kushtia', 'kkart' ),
		'BD-31' => __( 'Lakshmipur', 'kkart' ),
		'BD-32' => __( 'Lalmonirhat', 'kkart' ),
		'BD-36' => __( 'Madaripur', 'kkart' ),
		'BD-37' => __( 'Magura', 'kkart' ),
		'BD-33' => __( 'Manikganj ', 'kkart' ),
		'BD-39' => __( 'Meherpur', 'kkart' ),
		'BD-38' => __( 'Moulvibazar', 'kkart' ),
		'BD-35' => __( 'Munshiganj', 'kkart' ),
		'BD-34' => __( 'Mymensingh', 'kkart' ),
		'BD-48' => __( 'Naogaon', 'kkart' ),
		'BD-43' => __( 'Narail', 'kkart' ),
		'BD-40' => __( 'Narayanganj', 'kkart' ),
		'BD-42' => __( 'Narsingdi', 'kkart' ),
		'BD-44' => __( 'Natore', 'kkart' ),
		'BD-45' => __( 'Nawabganj', 'kkart' ),
		'BD-41' => __( 'Netrakona', 'kkart' ),
		'BD-46' => __( 'Nilphamari', 'kkart' ),
		'BD-47' => __( 'Noakhali', 'kkart' ),
		'BD-49' => __( 'Pabna', 'kkart' ),
		'BD-52' => __( 'Panchagarh', 'kkart' ),
		'BD-51' => __( 'Patuakhali', 'kkart' ),
		'BD-50' => __( 'Pirojpur', 'kkart' ),
		'BD-53' => __( 'Rajbari', 'kkart' ),
		'BD-54' => __( 'Rajshahi', 'kkart' ),
		'BD-56' => __( 'Rangamati', 'kkart' ),
		'BD-55' => __( 'Rangpur', 'kkart' ),
		'BD-58' => __( 'Satkhira', 'kkart' ),
		'BD-62' => __( 'Shariatpur', 'kkart' ),
		'BD-57' => __( 'Sherpur', 'kkart' ),
		'BD-59' => __( 'Sirajganj', 'kkart' ),
		'BD-61' => __( 'Sunamganj', 'kkart' ),
		'BD-60' => __( 'Sylhet', 'kkart' ),
		'BD-63' => __( 'Tangail', 'kkart' ),
		'BD-64' => __( 'Thakurgaon', 'kkart' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'kkart' ),
		'BG-02' => __( 'Burgas', 'kkart' ),
		'BG-08' => __( 'Dobrich', 'kkart' ),
		'BG-07' => __( 'Gabrovo', 'kkart' ),
		'BG-26' => __( 'Haskovo', 'kkart' ),
		'BG-09' => __( 'Kardzhali', 'kkart' ),
		'BG-10' => __( 'Kyustendil', 'kkart' ),
		'BG-11' => __( 'Lovech', 'kkart' ),
		'BG-12' => __( 'Montana', 'kkart' ),
		'BG-13' => __( 'Pazardzhik', 'kkart' ),
		'BG-14' => __( 'Pernik', 'kkart' ),
		'BG-15' => __( 'Pleven', 'kkart' ),
		'BG-16' => __( 'Plovdiv', 'kkart' ),
		'BG-17' => __( 'Razgrad', 'kkart' ),
		'BG-18' => __( 'Ruse', 'kkart' ),
		'BG-27' => __( 'Shumen', 'kkart' ),
		'BG-19' => __( 'Silistra', 'kkart' ),
		'BG-20' => __( 'Sliven', 'kkart' ),
		'BG-21' => __( 'Smolyan', 'kkart' ),
		'BG-23' => __( 'Sofia', 'kkart' ),
		'BG-22' => __( 'Sofia-Grad', 'kkart' ),
		'BG-24' => __( 'Stara Zagora', 'kkart' ),
		'BG-25' => __( 'Targovishte', 'kkart' ),
		'BG-03' => __( 'Varna', 'kkart' ),
		'BG-04' => __( 'Veliko Tarnovo', 'kkart' ),
		'BG-05' => __( 'Vidin', 'kkart' ),
		'BG-06' => __( 'Vratsa', 'kkart' ),
		'BG-28' => __( 'Yambol', 'kkart' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'kkart' ),
		'AK' => __( 'Atakora', 'kkart' ),
		'AQ' => __( 'Atlantique', 'kkart' ),
		'BO' => __( 'Borgou', 'kkart' ),
		'CO' => __( 'Collines', 'kkart' ),
		'KO' => __( 'Kouffo', 'kkart' ),
		'DO' => __( 'Donga', 'kkart' ),
		'LI' => __( 'Littoral', 'kkart' ),
		'MO' => __( 'Mono', 'kkart' ),
		'OU' => __( 'Ouémé', 'kkart' ),
		'PL' => __( 'Plateau', 'kkart' ),
		'ZO' => __( 'Zou', 'kkart' ),
	),
	'BO' => array( // Bolivian states.
		'B' => __( 'Chuquisaca', 'kkart' ),
		'H' => __( 'Beni', 'kkart' ),
		'C' => __( 'Cochabamba', 'kkart' ),
		'L' => __( 'La Paz', 'kkart' ),
		'O' => __( 'Oruro', 'kkart' ),
		'N' => __( 'Pando', 'kkart' ),
		'P' => __( 'Potosí', 'kkart' ),
		'S' => __( 'Santa Cruz', 'kkart' ),
		'T' => __( 'Tarija', 'kkart' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'kkart' ),
		'AL' => __( 'Alagoas', 'kkart' ),
		'AP' => __( 'Amapá', 'kkart' ),
		'AM' => __( 'Amazonas', 'kkart' ),
		'BA' => __( 'Bahia', 'kkart' ),
		'CE' => __( 'Ceará', 'kkart' ),
		'DF' => __( 'Distrito Federal', 'kkart' ),
		'ES' => __( 'Espírito Santo', 'kkart' ),
		'GO' => __( 'Goiás', 'kkart' ),
		'MA' => __( 'Maranhão', 'kkart' ),
		'MT' => __( 'Mato Grosso', 'kkart' ),
		'MS' => __( 'Mato Grosso do Sul', 'kkart' ),
		'MG' => __( 'Minas Gerais', 'kkart' ),
		'PA' => __( 'Pará', 'kkart' ),
		'PB' => __( 'Paraíba', 'kkart' ),
		'PR' => __( 'Paraná', 'kkart' ),
		'PE' => __( 'Pernambuco', 'kkart' ),
		'PI' => __( 'Piauí', 'kkart' ),
		'RJ' => __( 'Rio de Janeiro', 'kkart' ),
		'RN' => __( 'Rio Grande do Norte', 'kkart' ),
		'RS' => __( 'Rio Grande do Sul', 'kkart' ),
		'RO' => __( 'Rondônia', 'kkart' ),
		'RR' => __( 'Roraima', 'kkart' ),
		'SC' => __( 'Santa Catarina', 'kkart' ),
		'SP' => __( 'São Paulo', 'kkart' ),
		'SE' => __( 'Sergipe', 'kkart' ),
		'TO' => __( 'Tocantins', 'kkart' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'kkart' ),
		'BC' => __( 'British Columbia', 'kkart' ),
		'MB' => __( 'Manitoba', 'kkart' ),
		'NB' => __( 'New Brunswick', 'kkart' ),
		'NL' => __( 'Newfoundland and Labrador', 'kkart' ),
		'NT' => __( 'Northwest Territories', 'kkart' ),
		'NS' => __( 'Nova Scotia', 'kkart' ),
		'NU' => __( 'Nunavut', 'kkart' ),
		'ON' => __( 'Ontario', 'kkart' ),
		'PE' => __( 'Prince Edward Island', 'kkart' ),
		'QC' => __( 'Quebec', 'kkart' ),
		'SK' => __( 'Saskatchewan', 'kkart' ),
		'YT' => __( 'Yukon Territory', 'kkart' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'kkart' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'kkart' ),
		'AI' => __( 'Appenzell Innerrhoden', 'kkart' ),
		'BL' => __( 'Basel-Landschaft', 'kkart' ),
		'BS' => __( 'Basel-Stadt', 'kkart' ),
		'BE' => __( 'Bern', 'kkart' ),
		'FR' => __( 'Fribourg', 'kkart' ),
		'GE' => __( 'Geneva', 'kkart' ),
		'GL' => __( 'Glarus', 'kkart' ),
		'GR' => __( 'Graubünden', 'kkart' ),
		'JU' => __( 'Jura', 'kkart' ),
		'LU' => __( 'Luzern', 'kkart' ),
		'NE' => __( 'Neuchâtel', 'kkart' ),
		'NW' => __( 'Nidwalden', 'kkart' ),
		'OW' => __( 'Obwalden', 'kkart' ),
		'SH' => __( 'Schaffhausen', 'kkart' ),
		'SZ' => __( 'Schwyz', 'kkart' ),
		'SO' => __( 'Solothurn', 'kkart' ),
		'SG' => __( 'St. Gallen', 'kkart' ),
		'TG' => __( 'Thurgau', 'kkart' ),
		'TI' => __( 'Ticino', 'kkart' ),
		'UR' => __( 'Uri', 'kkart' ),
		'VS' => __( 'Valais', 'kkart' ),
		'VD' => __( 'Vaud', 'kkart' ),
		'ZG' => __( 'Zug', 'kkart' ),
		'ZH' => __( 'Zürich', 'kkart' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'kkart' ),
		'CN2'  => __( 'Beijing / 北京', 'kkart' ),
		'CN3'  => __( 'Tianjin / 天津', 'kkart' ),
		'CN4'  => __( 'Hebei / 河北', 'kkart' ),
		'CN5'  => __( 'Shanxi / 山西', 'kkart' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'kkart' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'kkart' ),
		'CN8'  => __( 'Jilin / 吉林', 'kkart' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'kkart' ),
		'CN10' => __( 'Shanghai / 上海', 'kkart' ),
		'CN11' => __( 'Jiangsu / 江苏', 'kkart' ),
		'CN12' => __( 'Zhejiang / 浙江', 'kkart' ),
		'CN13' => __( 'Anhui / 安徽', 'kkart' ),
		'CN14' => __( 'Fujian / 福建', 'kkart' ),
		'CN15' => __( 'Jiangxi / 江西', 'kkart' ),
		'CN16' => __( 'Shandong / 山东', 'kkart' ),
		'CN17' => __( 'Henan / 河南', 'kkart' ),
		'CN18' => __( 'Hubei / 湖北', 'kkart' ),
		'CN19' => __( 'Hunan / 湖南', 'kkart' ),
		'CN20' => __( 'Guangdong / 广东', 'kkart' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'kkart' ),
		'CN22' => __( 'Hainan / 海南', 'kkart' ),
		'CN23' => __( 'Chongqing / 重庆', 'kkart' ),
		'CN24' => __( 'Sichuan / 四川', 'kkart' ),
		'CN25' => __( 'Guizhou / 贵州', 'kkart' ),
		'CN26' => __( 'Shaanxi / 陕西', 'kkart' ),
		'CN27' => __( 'Gansu / 甘肃', 'kkart' ),
		'CN28' => __( 'Qinghai / 青海', 'kkart' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'kkart' ),
		'CN30' => __( 'Macao / 澳门', 'kkart' ),
		'CN31' => __( 'Tibet / 西藏', 'kkart' ),
		'CN32' => __( 'Xinjiang / 新疆', 'kkart' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'kkart' ),
		'DZ-02' => __( 'Chlef', 'kkart' ),
		'DZ-03' => __( 'Laghouat', 'kkart' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'kkart' ),
		'DZ-05' => __( 'Batna', 'kkart' ),
		'DZ-06' => __( 'Béjaïa', 'kkart' ),
		'DZ-07' => __( 'Biskra', 'kkart' ),
		'DZ-08' => __( 'Béchar', 'kkart' ),
		'DZ-09' => __( 'Blida', 'kkart' ),
		'DZ-10' => __( 'Bouira', 'kkart' ),
		'DZ-11' => __( 'Tamanghasset', 'kkart' ),
		'DZ-12' => __( 'Tébessa', 'kkart' ),
		'DZ-13' => __( 'Tlemcen', 'kkart' ),
		'DZ-14' => __( 'Tiaret', 'kkart' ),
		'DZ-15' => __( 'Tizi Ouzou', 'kkart' ),
		'DZ-16' => __( 'Algiers', 'kkart' ),
		'DZ-17' => __( 'Djelfa', 'kkart' ),
		'DZ-18' => __( 'Jijel', 'kkart' ),
		'DZ-19' => __( 'Sétif', 'kkart' ),
		'DZ-20' => __( 'Saïda', 'kkart' ),
		'DZ-21' => __( 'Skikda', 'kkart' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'kkart' ),
		'DZ-23' => __( 'Annaba', 'kkart' ),
		'DZ-24' => __( 'Guelma', 'kkart' ),
		'DZ-25' => __( 'Constantine', 'kkart' ),
		'DZ-26' => __( 'Médéa', 'kkart' ),
		'DZ-27' => __( 'Mostaganem', 'kkart' ),
		'DZ-28' => __( 'M’Sila', 'kkart' ),
		'DZ-29' => __( 'Mascara', 'kkart' ),
		'DZ-30' => __( 'Ouargla', 'kkart' ),
		'DZ-31' => __( 'Oran', 'kkart' ),
		'DZ-32' => __( 'El Bayadh', 'kkart' ),
		'DZ-33' => __( 'Illizi', 'kkart' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'kkart' ),
		'DZ-35' => __( 'Boumerdès', 'kkart' ),
		'DZ-36' => __( 'El Tarf', 'kkart' ),
		'DZ-37' => __( 'Tindouf', 'kkart' ),
		'DZ-38' => __( 'Tissemsilt', 'kkart' ),
		'DZ-39' => __( 'El Oued', 'kkart' ),
		'DZ-40' => __( 'Khenchela', 'kkart' ),
		'DZ-41' => __( 'Souk Ahras', 'kkart' ),
		'DZ-42' => __( 'Tipasa', 'kkart' ),
		'DZ-43' => __( 'Mila', 'kkart' ),
		'DZ-44' => __( 'Aïn Defla', 'kkart' ),
		'DZ-45' => __( 'Naama', 'kkart' ),
		'DZ-46' => __( 'Aïn Témouchent', 'kkart' ),
		'DZ-47' => __( 'Ghardaïa', 'kkart' ),
		'DZ-48' => __( 'Relizane', 'kkart' ),
	),
	'EE' => array(),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'kkart' ),
		'EGASN' => __( 'Aswan', 'kkart' ),
		'EGAST' => __( 'Asyut', 'kkart' ),
		'EGBA'  => __( 'Red Sea', 'kkart' ),
		'EGBH'  => __( 'Beheira', 'kkart' ),
		'EGBNS' => __( 'Beni Suef', 'kkart' ),
		'EGC'   => __( 'Cairo', 'kkart' ),
		'EGDK'  => __( 'Dakahlia', 'kkart' ),
		'EGDT'  => __( 'Damietta', 'kkart' ),
		'EGFYM' => __( 'Faiyum', 'kkart' ),
		'EGGH'  => __( 'Gharbia', 'kkart' ),
		'EGGZ'  => __( 'Giza', 'kkart' ),
		'EGIS'  => __( 'Ismailia', 'kkart' ),
		'EGJS'  => __( 'South Sinai', 'kkart' ),
		'EGKB'  => __( 'Qalyubia', 'kkart' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'kkart' ),
		'EGKN'  => __( 'Qena', 'kkart' ),
		'EGLX'  => __( 'Luxor', 'kkart' ),
		'EGMN'  => __( 'Minya', 'kkart' ),
		'EGMNF' => __( 'Monufia', 'kkart' ),
		'EGMT'  => __( 'Matrouh', 'kkart' ),
		'EGPTS' => __( 'Port Said', 'kkart' ),
		'EGSHG' => __( 'Sohag', 'kkart' ),
		'EGSHR' => __( 'Al Sharqia', 'kkart' ),
		'EGSIN' => __( 'North Sinai', 'kkart' ),
		'EGSUZ' => __( 'Suez', 'kkart' ),
		'EGWAD' => __( 'New Valley', 'kkart' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'kkart' ),
		'VI' => __( 'Araba/Álava', 'kkart' ),
		'AB' => __( 'Albacete', 'kkart' ),
		'A'  => __( 'Alicante', 'kkart' ),
		'AL' => __( 'Almería', 'kkart' ),
		'O'  => __( 'Asturias', 'kkart' ),
		'AV' => __( 'Ávila', 'kkart' ),
		'BA' => __( 'Badajoz', 'kkart' ),
		'PM' => __( 'Baleares', 'kkart' ),
		'B'  => __( 'Barcelona', 'kkart' ),
		'BU' => __( 'Burgos', 'kkart' ),
		'CC' => __( 'Cáceres', 'kkart' ),
		'CA' => __( 'Cádiz', 'kkart' ),
		'S'  => __( 'Cantabria', 'kkart' ),
		'CS' => __( 'Castellón', 'kkart' ),
		'CE' => __( 'Ceuta', 'kkart' ),
		'CR' => __( 'Ciudad Real', 'kkart' ),
		'CO' => __( 'Córdoba', 'kkart' ),
		'CU' => __( 'Cuenca', 'kkart' ),
		'GI' => __( 'Girona', 'kkart' ),
		'GR' => __( 'Granada', 'kkart' ),
		'GU' => __( 'Guadalajara', 'kkart' ),
		'SS' => __( 'Gipuzkoa', 'kkart' ),
		'H'  => __( 'Huelva', 'kkart' ),
		'HU' => __( 'Huesca', 'kkart' ),
		'J'  => __( 'Jaén', 'kkart' ),
		'LO' => __( 'La Rioja', 'kkart' ),
		'GC' => __( 'Las Palmas', 'kkart' ),
		'LE' => __( 'León', 'kkart' ),
		'L'  => __( 'Lleida', 'kkart' ),
		'LU' => __( 'Lugo', 'kkart' ),
		'M'  => __( 'Madrid', 'kkart' ),
		'MA' => __( 'Málaga', 'kkart' ),
		'ML' => __( 'Melilla', 'kkart' ),
		'MU' => __( 'Murcia', 'kkart' ),
		'NA' => __( 'Navarra', 'kkart' ),
		'OR' => __( 'Ourense', 'kkart' ),
		'P'  => __( 'Palencia', 'kkart' ),
		'PO' => __( 'Pontevedra', 'kkart' ),
		'SA' => __( 'Salamanca', 'kkart' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'kkart' ),
		'SG' => __( 'Segovia', 'kkart' ),
		'SE' => __( 'Sevilla', 'kkart' ),
		'SO' => __( 'Soria', 'kkart' ),
		'T'  => __( 'Tarragona', 'kkart' ),
		'TE' => __( 'Teruel', 'kkart' ),
		'TO' => __( 'Toledo', 'kkart' ),
		'V'  => __( 'Valencia', 'kkart' ),
		'VA' => __( 'Valladolid', 'kkart' ),
		'BI' => __( 'Biscay', 'kkart' ),
		'ZA' => __( 'Zamora', 'kkart' ),
		'Z'  => __( 'Zaragoza', 'kkart' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'kkart' ),
		'AH' => __( 'Ashanti', 'kkart' ),
		'BA' => __( 'Brong-Ahafo', 'kkart' ),
		'BO' => __( 'Bono', 'kkart' ),
		'BE' => __( 'Bono East', 'kkart' ),
		'CP' => __( 'Central', 'kkart' ),
		'EP' => __( 'Eastern', 'kkart' ),
		'AA' => __( 'Greater Accra', 'kkart' ),
		'NE' => __( 'North East', 'kkart' ),
		'NP' => __( 'Northern', 'kkart' ),
		'OT' => __( 'Oti', 'kkart' ),
		'SV' => __( 'Savannah', 'kkart' ),
		'UE' => __( 'Upper East', 'kkart' ),
		'UW' => __( 'Upper West', 'kkart' ),
		'TV' => __( 'Volta', 'kkart' ),
		'WP' => __( 'Western', 'kkart' ),
		'WN' => __( 'Western North', 'kkart' ),
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'kkart' ),
		'A' => __( 'East Macedonia and Thrace', 'kkart' ),
		'B' => __( 'Central Macedonia', 'kkart' ),
		'C' => __( 'West Macedonia', 'kkart' ),
		'D' => __( 'Epirus', 'kkart' ),
		'E' => __( 'Thessaly', 'kkart' ),
		'F' => __( 'Ionian Islands', 'kkart' ),
		'G' => __( 'West Greece', 'kkart' ),
		'H' => __( 'Central Greece', 'kkart' ),
		'J' => __( 'Peloponnese', 'kkart' ),
		'K' => __( 'North Aegean', 'kkart' ),
		'L' => __( 'South Aegean', 'kkart' ),
		'M' => __( 'Crete', 'kkart' ),
	),
	'GF' => array(),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'kkart' ),
		'KOWLOON'         => __( 'Kowloon', 'kkart' ),
		'NEW TERRITORIES' => __( 'New Territories', 'kkart' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'kkart' ),
		'BE' => __( 'Békés', 'kkart' ),
		'BA' => __( 'Baranya', 'kkart' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'kkart' ),
		'BU' => __( 'Budapest', 'kkart' ),
		'CS' => __( 'Csongrád-Csanád', 'kkart' ),
		'FE' => __( 'Fejér', 'kkart' ),
		'GS' => __( 'Győr-Moson-Sopron', 'kkart' ),
		'HB' => __( 'Hajdú-Bihar', 'kkart' ),
		'HE' => __( 'Heves', 'kkart' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'kkart' ),
		'KE' => __( 'Komárom-Esztergom', 'kkart' ),
		'NO' => __( 'Nógrád', 'kkart' ),
		'PE' => __( 'Pest', 'kkart' ),
		'SO' => __( 'Somogy', 'kkart' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'kkart' ),
		'TO' => __( 'Tolna', 'kkart' ),
		'VA' => __( 'Vas', 'kkart' ),
		'VE' => __( 'Veszprém', 'kkart' ),
		'ZA' => __( 'Zala', 'kkart' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'kkart' ),
		'SU' => __( 'Sumatera Utara', 'kkart' ),
		'SB' => __( 'Sumatera Barat', 'kkart' ),
		'RI' => __( 'Riau', 'kkart' ),
		'KR' => __( 'Kepulauan Riau', 'kkart' ),
		'JA' => __( 'Jambi', 'kkart' ),
		'SS' => __( 'Sumatera Selatan', 'kkart' ),
		'BB' => __( 'Bangka Belitung', 'kkart' ),
		'BE' => __( 'Bengkulu', 'kkart' ),
		'LA' => __( 'Lampung', 'kkart' ),
		'JK' => __( 'DKI Jakarta', 'kkart' ),
		'JB' => __( 'Jawa Barat', 'kkart' ),
		'BT' => __( 'Banten', 'kkart' ),
		'JT' => __( 'Jawa Tengah', 'kkart' ),
		'JI' => __( 'Jawa Timur', 'kkart' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'kkart' ),
		'BA' => __( 'Bali', 'kkart' ),
		'NB' => __( 'Nusa Tenggara Barat', 'kkart' ),
		'NT' => __( 'Nusa Tenggara Timur', 'kkart' ),
		'KB' => __( 'Kalimantan Barat', 'kkart' ),
		'KT' => __( 'Kalimantan Tengah', 'kkart' ),
		'KI' => __( 'Kalimantan Timur', 'kkart' ),
		'KS' => __( 'Kalimantan Selatan', 'kkart' ),
		'KU' => __( 'Kalimantan Utara', 'kkart' ),
		'SA' => __( 'Sulawesi Utara', 'kkart' ),
		'ST' => __( 'Sulawesi Tengah', 'kkart' ),
		'SG' => __( 'Sulawesi Tenggara', 'kkart' ),
		'SR' => __( 'Sulawesi Barat', 'kkart' ),
		'SN' => __( 'Sulawesi Selatan', 'kkart' ),
		'GO' => __( 'Gorontalo', 'kkart' ),
		'MA' => __( 'Maluku', 'kkart' ),
		'MU' => __( 'Maluku Utara', 'kkart' ),
		'PA' => __( 'Papua', 'kkart' ),
		'PB' => __( 'Papua Barat', 'kkart' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'kkart' ),
		'CN' => __( 'Cavan', 'kkart' ),
		'CE' => __( 'Clare', 'kkart' ),
		'CO' => __( 'Cork', 'kkart' ),
		'DL' => __( 'Donegal', 'kkart' ),
		'D'  => __( 'Dublin', 'kkart' ),
		'G'  => __( 'Galway', 'kkart' ),
		'KY' => __( 'Kerry', 'kkart' ),
		'KE' => __( 'Kildare', 'kkart' ),
		'KK' => __( 'Kilkenny', 'kkart' ),
		'LS' => __( 'Laois', 'kkart' ),
		'LM' => __( 'Leitrim', 'kkart' ),
		'LK' => __( 'Limerick', 'kkart' ),
		'LD' => __( 'Longford', 'kkart' ),
		'LH' => __( 'Louth', 'kkart' ),
		'MO' => __( 'Mayo', 'kkart' ),
		'MH' => __( 'Meath', 'kkart' ),
		'MN' => __( 'Monaghan', 'kkart' ),
		'OY' => __( 'Offaly', 'kkart' ),
		'RN' => __( 'Roscommon', 'kkart' ),
		'SO' => __( 'Sligo', 'kkart' ),
		'TA' => __( 'Tipperary', 'kkart' ),
		'WD' => __( 'Waterford', 'kkart' ),
		'WH' => __( 'Westmeath', 'kkart' ),
		'WX' => __( 'Wexford', 'kkart' ),
		'WW' => __( 'Wicklow', 'kkart' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'kkart' ),
		'AR' => __( 'Arunachal Pradesh', 'kkart' ),
		'AS' => __( 'Assam', 'kkart' ),
		'BR' => __( 'Bihar', 'kkart' ),
		'CT' => __( 'Chhattisgarh', 'kkart' ),
		'GA' => __( 'Goa', 'kkart' ),
		'GJ' => __( 'Gujarat', 'kkart' ),
		'HR' => __( 'Haryana', 'kkart' ),
		'HP' => __( 'Himachal Pradesh', 'kkart' ),
		'JK' => __( 'Jammu and Kashmir', 'kkart' ),
		'JH' => __( 'Jharkhand', 'kkart' ),
		'KA' => __( 'Karnataka', 'kkart' ),
		'KL' => __( 'Kerala', 'kkart' ),
		'MP' => __( 'Madhya Pradesh', 'kkart' ),
		'MH' => __( 'Maharashtra', 'kkart' ),
		'MN' => __( 'Manipur', 'kkart' ),
		'ML' => __( 'Meghalaya', 'kkart' ),
		'MZ' => __( 'Mizoram', 'kkart' ),
		'NL' => __( 'Nagaland', 'kkart' ),
		'OR' => __( 'Orissa', 'kkart' ),
		'PB' => __( 'Punjab', 'kkart' ),
		'RJ' => __( 'Rajasthan', 'kkart' ),
		'SK' => __( 'Sikkim', 'kkart' ),
		'TN' => __( 'Tamil Nadu', 'kkart' ),
		'TS' => __( 'Telangana', 'kkart' ),
		'TR' => __( 'Tripura', 'kkart' ),
		'UK' => __( 'Uttarakhand', 'kkart' ),
		'UP' => __( 'Uttar Pradesh', 'kkart' ),
		'WB' => __( 'West Bengal', 'kkart' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'kkart' ),
		'CH' => __( 'Chandigarh', 'kkart' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'kkart' ),
		'DD' => __( 'Daman and Diu', 'kkart' ),
		'DL' => __( 'Delhi', 'kkart' ),
		'LD' => __( 'Lakshadeep', 'kkart' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'kkart' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan  (خوزستان)', 'kkart' ),
		'THR' => __( 'Tehran  (تهران)', 'kkart' ),
		'ILM' => __( 'Ilaam (ایلام)', 'kkart' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'kkart' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'kkart' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'kkart' ),
		'YZD' => __( 'Yazd (یزد)', 'kkart' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'kkart' ),
		'KRN' => __( 'Kerman (کرمان)', 'kkart' ),
		'HDN' => __( 'Hamadan (همدان)', 'kkart' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'kkart' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'kkart' ),
		'LRS' => __( 'Luristan (لرستان)', 'kkart' ),
		'ABZ' => __( 'Alborz (البرز)', 'kkart' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'kkart' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'kkart' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'kkart' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'kkart' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'kkart' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'kkart' ),
		'SMN' => __( 'Semnan (سمنان)', 'kkart' ),
		'FRS' => __( 'Fars (فارس)', 'kkart' ),
		'QHM' => __( 'Qom (قم)', 'kkart' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'kkart' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'kkart' ),
		'GLS' => __( 'Golestan (گلستان)', 'kkart' ),
		'GIL' => __( 'Gilan (گیلان)', 'kkart' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'kkart' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'kkart' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'kkart' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'kkart' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'kkart' ),
		'AL' => __( 'Alessandria', 'kkart' ),
		'AN' => __( 'Ancona', 'kkart' ),
		'AO' => __( 'Aosta', 'kkart' ),
		'AR' => __( 'Arezzo', 'kkart' ),
		'AP' => __( 'Ascoli Piceno', 'kkart' ),
		'AT' => __( 'Asti', 'kkart' ),
		'AV' => __( 'Avellino', 'kkart' ),
		'BA' => __( 'Bari', 'kkart' ),
		'BT' => __( 'Barletta-Andria-Trani', 'kkart' ),
		'BL' => __( 'Belluno', 'kkart' ),
		'BN' => __( 'Benevento', 'kkart' ),
		'BG' => __( 'Bergamo', 'kkart' ),
		'BI' => __( 'Biella', 'kkart' ),
		'BO' => __( 'Bologna', 'kkart' ),
		'BZ' => __( 'Bolzano', 'kkart' ),
		'BS' => __( 'Brescia', 'kkart' ),
		'BR' => __( 'Brindisi', 'kkart' ),
		'CA' => __( 'Cagliari', 'kkart' ),
		'CL' => __( 'Caltanissetta', 'kkart' ),
		'CB' => __( 'Campobasso', 'kkart' ),
		'CE' => __( 'Caserta', 'kkart' ),
		'CT' => __( 'Catania', 'kkart' ),
		'CZ' => __( 'Catanzaro', 'kkart' ),
		'CH' => __( 'Chieti', 'kkart' ),
		'CO' => __( 'Como', 'kkart' ),
		'CS' => __( 'Cosenza', 'kkart' ),
		'CR' => __( 'Cremona', 'kkart' ),
		'KR' => __( 'Crotone', 'kkart' ),
		'CN' => __( 'Cuneo', 'kkart' ),
		'EN' => __( 'Enna', 'kkart' ),
		'FM' => __( 'Fermo', 'kkart' ),
		'FE' => __( 'Ferrara', 'kkart' ),
		'FI' => __( 'Firenze', 'kkart' ),
		'FG' => __( 'Foggia', 'kkart' ),
		'FC' => __( 'Forlì-Cesena', 'kkart' ),
		'FR' => __( 'Frosinone', 'kkart' ),
		'GE' => __( 'Genova', 'kkart' ),
		'GO' => __( 'Gorizia', 'kkart' ),
		'GR' => __( 'Grosseto', 'kkart' ),
		'IM' => __( 'Imperia', 'kkart' ),
		'IS' => __( 'Isernia', 'kkart' ),
		'SP' => __( 'La Spezia', 'kkart' ),
		'AQ' => __( "L'Aquila", 'kkart' ),
		'LT' => __( 'Latina', 'kkart' ),
		'LE' => __( 'Lecce', 'kkart' ),
		'LC' => __( 'Lecco', 'kkart' ),
		'LI' => __( 'Livorno', 'kkart' ),
		'LO' => __( 'Lodi', 'kkart' ),
		'LU' => __( 'Lucca', 'kkart' ),
		'MC' => __( 'Macerata', 'kkart' ),
		'MN' => __( 'Mantova', 'kkart' ),
		'MS' => __( 'Massa-Carrara', 'kkart' ),
		'MT' => __( 'Matera', 'kkart' ),
		'ME' => __( 'Messina', 'kkart' ),
		'MI' => __( 'Milano', 'kkart' ),
		'MO' => __( 'Modena', 'kkart' ),
		'MB' => __( 'Monza e della Brianza', 'kkart' ),
		'NA' => __( 'Napoli', 'kkart' ),
		'NO' => __( 'Novara', 'kkart' ),
		'NU' => __( 'Nuoro', 'kkart' ),
		'OR' => __( 'Oristano', 'kkart' ),
		'PD' => __( 'Padova', 'kkart' ),
		'PA' => __( 'Palermo', 'kkart' ),
		'PR' => __( 'Parma', 'kkart' ),
		'PV' => __( 'Pavia', 'kkart' ),
		'PG' => __( 'Perugia', 'kkart' ),
		'PU' => __( 'Pesaro e Urbino', 'kkart' ),
		'PE' => __( 'Pescara', 'kkart' ),
		'PC' => __( 'Piacenza', 'kkart' ),
		'PI' => __( 'Pisa', 'kkart' ),
		'PT' => __( 'Pistoia', 'kkart' ),
		'PN' => __( 'Pordenone', 'kkart' ),
		'PZ' => __( 'Potenza', 'kkart' ),
		'PO' => __( 'Prato', 'kkart' ),
		'RG' => __( 'Ragusa', 'kkart' ),
		'RA' => __( 'Ravenna', 'kkart' ),
		'RC' => __( 'Reggio Calabria', 'kkart' ),
		'RE' => __( 'Reggio Emilia', 'kkart' ),
		'RI' => __( 'Rieti', 'kkart' ),
		'RN' => __( 'Rimini', 'kkart' ),
		'RM' => __( 'Roma', 'kkart' ),
		'RO' => __( 'Rovigo', 'kkart' ),
		'SA' => __( 'Salerno', 'kkart' ),
		'SS' => __( 'Sassari', 'kkart' ),
		'SV' => __( 'Savona', 'kkart' ),
		'SI' => __( 'Siena', 'kkart' ),
		'SR' => __( 'Siracusa', 'kkart' ),
		'SO' => __( 'Sondrio', 'kkart' ),
		'SU' => __( 'Sud Sardegna', 'kkart' ),
		'TA' => __( 'Taranto', 'kkart' ),
		'TE' => __( 'Teramo', 'kkart' ),
		'TR' => __( 'Terni', 'kkart' ),
		'TO' => __( 'Torino', 'kkart' ),
		'TP' => __( 'Trapani', 'kkart' ),
		'TN' => __( 'Trento', 'kkart' ),
		'TV' => __( 'Treviso', 'kkart' ),
		'TS' => __( 'Trieste', 'kkart' ),
		'UD' => __( 'Udine', 'kkart' ),
		'VA' => __( 'Varese', 'kkart' ),
		'VE' => __( 'Venezia', 'kkart' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'kkart' ),
		'VC' => __( 'Vercelli', 'kkart' ),
		'VR' => __( 'Verona', 'kkart' ),
		'VV' => __( 'Vibo Valentia', 'kkart' ),
		'VI' => __( 'Vicenza', 'kkart' ),
		'VT' => __( 'Viterbo', 'kkart' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
		'JM-01' => __( 'Kingston', 'kkart' ),
		'JM-02' => __( 'Saint Andrew', 'kkart' ),
		'JM-03' => __( 'Saint Thomas', 'kkart' ),
		'JM-04' => __( 'Portland', 'kkart' ),
		'JM-05' => __( 'Saint Mary', 'kkart' ),
		'JM-06' => __( 'Saint Ann', 'kkart' ),
		'JM-07' => __( 'Trelawny', 'kkart' ),
		'JM-08' => __( 'Saint James', 'kkart' ),
		'JM-09' => __( 'Hanover', 'kkart' ),
		'JM-10' => __( 'Westmoreland', 'kkart' ),
		'JM-11' => __( 'Saint Elizabeth', 'kkart' ),
		'JM-12' => __( 'Manchester', 'kkart' ),
		'JM-13' => __( 'Clarendon', 'kkart' ),
		'JM-14' => __( 'Saint Catherine', 'kkart' ),
	),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'kkart' ),
		'JP02' => __( 'Aomori', 'kkart' ),
		'JP03' => __( 'Iwate', 'kkart' ),
		'JP04' => __( 'Miyagi', 'kkart' ),
		'JP05' => __( 'Akita', 'kkart' ),
		'JP06' => __( 'Yamagata', 'kkart' ),
		'JP07' => __( 'Fukushima', 'kkart' ),
		'JP08' => __( 'Ibaraki', 'kkart' ),
		'JP09' => __( 'Tochigi', 'kkart' ),
		'JP10' => __( 'Gunma', 'kkart' ),
		'JP11' => __( 'Saitama', 'kkart' ),
		'JP12' => __( 'Chiba', 'kkart' ),
		'JP13' => __( 'Tokyo', 'kkart' ),
		'JP14' => __( 'Kanagawa', 'kkart' ),
		'JP15' => __( 'Niigata', 'kkart' ),
		'JP16' => __( 'Toyama', 'kkart' ),
		'JP17' => __( 'Ishikawa', 'kkart' ),
		'JP18' => __( 'Fukui', 'kkart' ),
		'JP19' => __( 'Yamanashi', 'kkart' ),
		'JP20' => __( 'Nagano', 'kkart' ),
		'JP21' => __( 'Gifu', 'kkart' ),
		'JP22' => __( 'Shizuoka', 'kkart' ),
		'JP23' => __( 'Aichi', 'kkart' ),
		'JP24' => __( 'Mie', 'kkart' ),
		'JP25' => __( 'Shiga', 'kkart' ),
		'JP26' => __( 'Kyoto', 'kkart' ),
		'JP27' => __( 'Osaka', 'kkart' ),
		'JP28' => __( 'Hyogo', 'kkart' ),
		'JP29' => __( 'Nara', 'kkart' ),
		'JP30' => __( 'Wakayama', 'kkart' ),
		'JP31' => __( 'Tottori', 'kkart' ),
		'JP32' => __( 'Shimane', 'kkart' ),
		'JP33' => __( 'Okayama', 'kkart' ),
		'JP34' => __( 'Hiroshima', 'kkart' ),
		'JP35' => __( 'Yamaguchi', 'kkart' ),
		'JP36' => __( 'Tokushima', 'kkart' ),
		'JP37' => __( 'Kagawa', 'kkart' ),
		'JP38' => __( 'Ehime', 'kkart' ),
		'JP39' => __( 'Kochi', 'kkart' ),
		'JP40' => __( 'Fukuoka', 'kkart' ),
		'JP41' => __( 'Saga', 'kkart' ),
		'JP42' => __( 'Nagasaki', 'kkart' ),
		'JP43' => __( 'Kumamoto', 'kkart' ),
		'JP44' => __( 'Oita', 'kkart' ),
		'JP45' => __( 'Miyazaki', 'kkart' ),
		'JP46' => __( 'Kagoshima', 'kkart' ),
		'JP47' => __( 'Okinawa', 'kkart' ),
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'kkart' ),
		'KE02' => __( 'Bomet', 'kkart' ),
		'KE03' => __( 'Bungoma', 'kkart' ),
		'KE04' => __( 'Busia', 'kkart' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'kkart' ),
		'KE06' => __( 'Embu', 'kkart' ),
		'KE07' => __( 'Garissa', 'kkart' ),
		'KE08' => __( 'Homa Bay', 'kkart' ),
		'KE09' => __( 'Isiolo', 'kkart' ),
		'KE10' => __( 'Kajiado', 'kkart' ),
		'KE11' => __( 'Kakamega', 'kkart' ),
		'KE12' => __( 'Kericho', 'kkart' ),
		'KE13' => __( 'Kiambu', 'kkart' ),
		'KE14' => __( 'Kilifi', 'kkart' ),
		'KE15' => __( 'Kirinyaga', 'kkart' ),
		'KE16' => __( 'Kisii', 'kkart' ),
		'KE17' => __( 'Kisumu', 'kkart' ),
		'KE18' => __( 'Kitui', 'kkart' ),
		'KE19' => __( 'Kwale', 'kkart' ),
		'KE20' => __( 'Laikipia', 'kkart' ),
		'KE21' => __( 'Lamu', 'kkart' ),
		'KE22' => __( 'Machakos', 'kkart' ),
		'KE23' => __( 'Makueni', 'kkart' ),
		'KE24' => __( 'Mandera', 'kkart' ),
		'KE25' => __( 'Marsabit', 'kkart' ),
		'KE26' => __( 'Meru', 'kkart' ),
		'KE27' => __( 'Migori', 'kkart' ),
		'KE28' => __( 'Mombasa', 'kkart' ),
		'KE29' => __( 'Murang’a', 'kkart' ),
		'KE30' => __( 'Nairobi County', 'kkart' ),
		'KE31' => __( 'Nakuru', 'kkart' ),
		'KE32' => __( 'Nandi', 'kkart' ),
		'KE33' => __( 'Narok', 'kkart' ),
		'KE34' => __( 'Nyamira', 'kkart' ),
		'KE35' => __( 'Nyandarua', 'kkart' ),
		'KE36' => __( 'Nyeri', 'kkart' ),
		'KE37' => __( 'Samburu', 'kkart' ),
		'KE38' => __( 'Siaya', 'kkart' ),
		'KE39' => __( 'Taita-Taveta', 'kkart' ),
		'KE40' => __( 'Tana River', 'kkart' ),
		'KE41' => __( 'Tharaka-Nithi', 'kkart' ),
		'KE42' => __( 'Trans Nzoia', 'kkart' ),
		'KE43' => __( 'Turkana', 'kkart' ),
		'KE44' => __( 'Uasin Gishu', 'kkart' ),
		'KE45' => __( 'Vihiga', 'kkart' ),
		'KE46' => __( 'Wajir', 'kkart' ),
		'KE47' => __( 'West Pokot', 'kkart' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'kkart' ),
		'BK' => __( 'Bokeo', 'kkart' ),
		'BL' => __( 'Bolikhamsai', 'kkart' ),
		'CH' => __( 'Champasak', 'kkart' ),
		'HO' => __( 'Houaphanh', 'kkart' ),
		'KH' => __( 'Khammouane', 'kkart' ),
		'LM' => __( 'Luang Namtha', 'kkart' ),
		'LP' => __( 'Luang Prabang', 'kkart' ),
		'OU' => __( 'Oudomxay', 'kkart' ),
		'PH' => __( 'Phongsaly', 'kkart' ),
		'SL' => __( 'Salavan', 'kkart' ),
		'SV' => __( 'Savannakhet', 'kkart' ),
		'VI' => __( 'Vientiane Province', 'kkart' ),
		'VT' => __( 'Vientiane', 'kkart' ),
		'XA' => __( 'Sainyabuli', 'kkart' ),
		'XE' => __( 'Sekong', 'kkart' ),
		'XI' => __( 'Xiangkhouang', 'kkart' ),
		'XS' => __( 'Xaisomboun', 'kkart' ),
	),
	'LB' => array(),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'kkart' ),
		'BN' => __( 'Bong', 'kkart' ),
		'GA' => __( 'Gbarpolu', 'kkart' ),
		'GB' => __( 'Grand Bassa', 'kkart' ),
		'GC' => __( 'Grand Cape Mount', 'kkart' ),
		'GG' => __( 'Grand Gedeh', 'kkart' ),
		'GK' => __( 'Grand Kru', 'kkart' ),
		'LO' => __( 'Lofa', 'kkart' ),
		'MA' => __( 'Margibi', 'kkart' ),
		'MY' => __( 'Maryland', 'kkart' ),
		'MO' => __( 'Montserrado', 'kkart' ),
		'NM' => __( 'Nimba', 'kkart' ),
		'RV' => __( 'Rivercess', 'kkart' ),
		'RG' => __( 'River Gee', 'kkart' ),
		'SN' => __( 'Sinoe', 'kkart' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'kkart' ),
		'BL' => __( 'Bălți', 'kkart' ),
		'AN' => __( 'Anenii Noi', 'kkart' ),
		'BS' => __( 'Basarabeasca', 'kkart' ),
		'BR' => __( 'Briceni', 'kkart' ),
		'CH' => __( 'Cahul', 'kkart' ),
		'CT' => __( 'Cantemir', 'kkart' ),
		'CL' => __( 'Călărași', 'kkart' ),
		'CS' => __( 'Căușeni', 'kkart' ),
		'CM' => __( 'Cimișlia', 'kkart' ),
		'CR' => __( 'Criuleni', 'kkart' ),
		'DN' => __( 'Dondușeni', 'kkart' ),
		'DR' => __( 'Drochia', 'kkart' ),
		'DB' => __( 'Dubăsari', 'kkart' ),
		'ED' => __( 'Edineț', 'kkart' ),
		'FL' => __( 'Fălești', 'kkart' ),
		'FR' => __( 'Florești', 'kkart' ),
		'GE' => __( 'UTA Găgăuzia', 'kkart' ),
		'GL' => __( 'Glodeni', 'kkart' ),
		'HN' => __( 'Hîncești', 'kkart' ),
		'IL' => __( 'Ialoveni', 'kkart' ),
		'LV' => __( 'Leova', 'kkart' ),
		'NS' => __( 'Nisporeni', 'kkart' ),
		'OC' => __( 'Ocnița', 'kkart' ),
		'OR' => __( 'Orhei', 'kkart' ),
		'RZ' => __( 'Rezina', 'kkart' ),
		'RS' => __( 'Rîșcani', 'kkart' ),
		'SG' => __( 'Sîngerei', 'kkart' ),
		'SR' => __( 'Soroca', 'kkart' ),
		'ST' => __( 'Strășeni', 'kkart' ),
		'SD' => __( 'Șoldănești', 'kkart' ),
		'SV' => __( 'Ștefan Vodă', 'kkart' ),
		'TR' => __( 'Taraclia', 'kkart' ),
		'TL' => __( 'Telenești', 'kkart' ),
		'UN' => __( 'Ungheni', 'kkart' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'kkart' ),
		'JA' => __( 'Jalisco', 'kkart' ),
		'NL' => __( 'Nuevo León', 'kkart' ),
		'AG' => __( 'Aguascalientes', 'kkart' ),
		'BC' => __( 'Baja California', 'kkart' ),
		'BS' => __( 'Baja California Sur', 'kkart' ),
		'CM' => __( 'Campeche', 'kkart' ),
		'CS' => __( 'Chiapas', 'kkart' ),
		'CH' => __( 'Chihuahua', 'kkart' ),
		'CO' => __( 'Coahuila', 'kkart' ),
		'CL' => __( 'Colima', 'kkart' ),
		'DG' => __( 'Durango', 'kkart' ),
		'GT' => __( 'Guanajuato', 'kkart' ),
		'GR' => __( 'Guerrero', 'kkart' ),
		'HG' => __( 'Hidalgo', 'kkart' ),
		'MX' => __( 'Estado de México', 'kkart' ),
		'MI' => __( 'Michoacán', 'kkart' ),
		'MO' => __( 'Morelos', 'kkart' ),
		'NA' => __( 'Nayarit', 'kkart' ),
		'OA' => __( 'Oaxaca', 'kkart' ),
		'PU' => __( 'Puebla', 'kkart' ),
		'QT' => __( 'Querétaro', 'kkart' ),
		'QR' => __( 'Quintana Roo', 'kkart' ),
		'SL' => __( 'San Luis Potosí', 'kkart' ),
		'SI' => __( 'Sinaloa', 'kkart' ),
		'SO' => __( 'Sonora', 'kkart' ),
		'TB' => __( 'Tabasco', 'kkart' ),
		'TM' => __( 'Tamaulipas', 'kkart' ),
		'TL' => __( 'Tlaxcala', 'kkart' ),
		'VE' => __( 'Veracruz', 'kkart' ),
		'YU' => __( 'Yucatán', 'kkart' ),
		'ZA' => __( 'Zacatecas', 'kkart' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'kkart' ),
		'KDH' => __( 'Kedah', 'kkart' ),
		'KTN' => __( 'Kelantan', 'kkart' ),
		'LBN' => __( 'Labuan', 'kkart' ),
		'MLK' => __( 'Malacca (Melaka)', 'kkart' ),
		'NSN' => __( 'Negeri Sembilan', 'kkart' ),
		'PHG' => __( 'Pahang', 'kkart' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'kkart' ),
		'PRK' => __( 'Perak', 'kkart' ),
		'PLS' => __( 'Perlis', 'kkart' ),
		'SBH' => __( 'Sabah', 'kkart' ),
		'SWK' => __( 'Sarawak', 'kkart' ),
		'SGR' => __( 'Selangor', 'kkart' ),
		'TRG' => __( 'Terengganu', 'kkart' ),
		'PJY' => __( 'Putrajaya', 'kkart' ),
		'KUL' => __( 'Kuala Lumpur', 'kkart' ),
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'kkart' ),
		'MZG'   => __( 'Gaza', 'kkart' ),
		'MZI'   => __( 'Inhambane', 'kkart' ),
		'MZB'   => __( 'Manica', 'kkart' ),
		'MZL'   => __( 'Maputo Province', 'kkart' ),
		'MZMPM' => __( 'Maputo', 'kkart' ),
		'MZN'   => __( 'Nampula', 'kkart' ),
		'MZA'   => __( 'Niassa', 'kkart' ),
		'MZS'   => __( 'Sofala', 'kkart' ),
		'MZT'   => __( 'Tete', 'kkart' ),
		'MZQ'   => __( 'Zambézia', 'kkart' ),
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'kkart' ),
		'HA' => __( 'Hardap', 'kkart' ),
		'KA' => __( 'Karas', 'kkart' ),
		'KE' => __( 'Kavango East', 'kkart' ),
		'KW' => __( 'Kavango West', 'kkart' ),
		'KH' => __( 'Khomas', 'kkart' ),
		'KU' => __( 'Kunene', 'kkart' ),
		'OW' => __( 'Ohangwena', 'kkart' ),
		'OH' => __( 'Omaheke', 'kkart' ),
		'OS' => __( 'Omusati', 'kkart' ),
		'ON' => __( 'Oshana', 'kkart' ),
		'OT' => __( 'Oshikoto', 'kkart' ),
		'OD' => __( 'Otjozondjupa', 'kkart' ),
		'CA' => __( 'Zambezi', 'kkart' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'kkart' ),
		'FC' => __( 'Abuja', 'kkart' ),
		'AD' => __( 'Adamawa', 'kkart' ),
		'AK' => __( 'Akwa Ibom', 'kkart' ),
		'AN' => __( 'Anambra', 'kkart' ),
		'BA' => __( 'Bauchi', 'kkart' ),
		'BY' => __( 'Bayelsa', 'kkart' ),
		'BE' => __( 'Benue', 'kkart' ),
		'BO' => __( 'Borno', 'kkart' ),
		'CR' => __( 'Cross River', 'kkart' ),
		'DE' => __( 'Delta', 'kkart' ),
		'EB' => __( 'Ebonyi', 'kkart' ),
		'ED' => __( 'Edo', 'kkart' ),
		'EK' => __( 'Ekiti', 'kkart' ),
		'EN' => __( 'Enugu', 'kkart' ),
		'GO' => __( 'Gombe', 'kkart' ),
		'IM' => __( 'Imo', 'kkart' ),
		'JI' => __( 'Jigawa', 'kkart' ),
		'KD' => __( 'Kaduna', 'kkart' ),
		'KN' => __( 'Kano', 'kkart' ),
		'KT' => __( 'Katsina', 'kkart' ),
		'KE' => __( 'Kebbi', 'kkart' ),
		'KO' => __( 'Kogi', 'kkart' ),
		'KW' => __( 'Kwara', 'kkart' ),
		'LA' => __( 'Lagos', 'kkart' ),
		'NA' => __( 'Nasarawa', 'kkart' ),
		'NI' => __( 'Niger', 'kkart' ),
		'OG' => __( 'Ogun', 'kkart' ),
		'ON' => __( 'Ondo', 'kkart' ),
		'OS' => __( 'Osun', 'kkart' ),
		'OY' => __( 'Oyo', 'kkart' ),
		'PL' => __( 'Plateau', 'kkart' ),
		'RI' => __( 'Rivers', 'kkart' ),
		'SO' => __( 'Sokoto', 'kkart' ),
		'TA' => __( 'Taraba', 'kkart' ),
		'YO' => __( 'Yobe', 'kkart' ),
		'ZA' => __( 'Zamfara', 'kkart' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'kkart' ),
		'BHE' => __( 'Bheri', 'kkart' ),
		'DHA' => __( 'Dhaulagiri', 'kkart' ),
		'GAN' => __( 'Gandaki', 'kkart' ),
		'JAN' => __( 'Janakpur', 'kkart' ),
		'KAR' => __( 'Karnali', 'kkart' ),
		'KOS' => __( 'Koshi', 'kkart' ),
		'LUM' => __( 'Lumbini', 'kkart' ),
		'MAH' => __( 'Mahakali', 'kkart' ),
		'MEC' => __( 'Mechi', 'kkart' ),
		'NAR' => __( 'Narayani', 'kkart' ),
		'RAP' => __( 'Rapti', 'kkart' ),
		'SAG' => __( 'Sagarmatha', 'kkart' ),
		'SET' => __( 'Seti', 'kkart' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'kkart' ),
		'AK' => __( 'Auckland', 'kkart' ),
		'WA' => __( 'Waikato', 'kkart' ),
		'BP' => __( 'Bay of Plenty', 'kkart' ),
		'TK' => __( 'Taranaki', 'kkart' ),
		'GI' => __( 'Gisborne', 'kkart' ),
		'HB' => __( 'Hawke’s Bay', 'kkart' ),
		'MW' => __( 'Manawatu-Wanganui', 'kkart' ),
		'WE' => __( 'Wellington', 'kkart' ),
		'NS' => __( 'Nelson', 'kkart' ),
		'MB' => __( 'Marlborough', 'kkart' ),
		'TM' => __( 'Tasman', 'kkart' ),
		'KKART' => __( 'West Coast', 'kkart' ),
		'CT' => __( 'Canterbury', 'kkart' ),
		'OT' => __( 'Otago', 'kkart' ),
		'SL' => __( 'Southland', 'kkart' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'kkart' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'kkart' ),
		'AMA' => __( 'Amazonas', 'kkart' ),
		'ANC' => __( 'Ancash', 'kkart' ),
		'APU' => __( 'Apurímac', 'kkart' ),
		'ARE' => __( 'Arequipa', 'kkart' ),
		'AYA' => __( 'Ayacucho', 'kkart' ),
		'CAJ' => __( 'Cajamarca', 'kkart' ),
		'CUS' => __( 'Cusco', 'kkart' ),
		'HUV' => __( 'Huancavelica', 'kkart' ),
		'HUC' => __( 'Huánuco', 'kkart' ),
		'ICA' => __( 'Ica', 'kkart' ),
		'JUN' => __( 'Junín', 'kkart' ),
		'LAL' => __( 'La Libertad', 'kkart' ),
		'LAM' => __( 'Lambayeque', 'kkart' ),
		'LIM' => __( 'Lima', 'kkart' ),
		'LOR' => __( 'Loreto', 'kkart' ),
		'MDD' => __( 'Madre de Dios', 'kkart' ),
		'MOQ' => __( 'Moquegua', 'kkart' ),
		'PAS' => __( 'Pasco', 'kkart' ),
		'PIU' => __( 'Piura', 'kkart' ),
		'PUN' => __( 'Puno', 'kkart' ),
		'SAM' => __( 'San Martín', 'kkart' ),
		'TAC' => __( 'Tacna', 'kkart' ),
		'TUM' => __( 'Tumbes', 'kkart' ),
		'UCA' => __( 'Ucayali', 'kkart' ),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'kkart' ),
		'AGN' => __( 'Agusan del Norte', 'kkart' ),
		'AGS' => __( 'Agusan del Sur', 'kkart' ),
		'AKL' => __( 'Aklan', 'kkart' ),
		'ALB' => __( 'Albay', 'kkart' ),
		'ANT' => __( 'Antique', 'kkart' ),
		'APA' => __( 'Apayao', 'kkart' ),
		'AUR' => __( 'Aurora', 'kkart' ),
		'BAS' => __( 'Basilan', 'kkart' ),
		'BAN' => __( 'Bataan', 'kkart' ),
		'BTN' => __( 'Batanes', 'kkart' ),
		'BTG' => __( 'Batangas', 'kkart' ),
		'BEN' => __( 'Benguet', 'kkart' ),
		'BIL' => __( 'Biliran', 'kkart' ),
		'BOH' => __( 'Bohol', 'kkart' ),
		'BUK' => __( 'Bukidnon', 'kkart' ),
		'BUL' => __( 'Bulacan', 'kkart' ),
		'CAG' => __( 'Cagayan', 'kkart' ),
		'CAN' => __( 'Camarines Norte', 'kkart' ),
		'CAS' => __( 'Camarines Sur', 'kkart' ),
		'CAM' => __( 'Camiguin', 'kkart' ),
		'CAP' => __( 'Capiz', 'kkart' ),
		'CAT' => __( 'Catanduanes', 'kkart' ),
		'CAV' => __( 'Cavite', 'kkart' ),
		'CEB' => __( 'Cebu', 'kkart' ),
		'COM' => __( 'Compostela Valley', 'kkart' ),
		'NCO' => __( 'Cotabato', 'kkart' ),
		'DAV' => __( 'Davao del Norte', 'kkart' ),
		'DAS' => __( 'Davao del Sur', 'kkart' ),
		'DAC' => __( 'Davao Occidental', 'kkart' ),
		'DAO' => __( 'Davao Oriental', 'kkart' ),
		'DIN' => __( 'Dinagat Islands', 'kkart' ),
		'EAS' => __( 'Eastern Samar', 'kkart' ),
		'GUI' => __( 'Guimaras', 'kkart' ),
		'IFU' => __( 'Ifugao', 'kkart' ),
		'ILN' => __( 'Ilocos Norte', 'kkart' ),
		'ILS' => __( 'Ilocos Sur', 'kkart' ),
		'ILI' => __( 'Iloilo', 'kkart' ),
		'ISA' => __( 'Isabela', 'kkart' ),
		'KAL' => __( 'Kalinga', 'kkart' ),
		'LUN' => __( 'La Union', 'kkart' ),
		'LAG' => __( 'Laguna', 'kkart' ),
		'LAN' => __( 'Lanao del Norte', 'kkart' ),
		'LAS' => __( 'Lanao del Sur', 'kkart' ),
		'LEY' => __( 'Leyte', 'kkart' ),
		'MAG' => __( 'Maguindanao', 'kkart' ),
		'MAD' => __( 'Marinduque', 'kkart' ),
		'MAS' => __( 'Masbate', 'kkart' ),
		'MSC' => __( 'Misamis Occidental', 'kkart' ),
		'MSR' => __( 'Misamis Oriental', 'kkart' ),
		'MOU' => __( 'Mountain Province', 'kkart' ),
		'NEC' => __( 'Negros Occidental', 'kkart' ),
		'NER' => __( 'Negros Oriental', 'kkart' ),
		'NSA' => __( 'Northern Samar', 'kkart' ),
		'NUE' => __( 'Nueva Ecija', 'kkart' ),
		'NUV' => __( 'Nueva Vizcaya', 'kkart' ),
		'MDC' => __( 'Occidental Mindoro', 'kkart' ),
		'MDR' => __( 'Oriental Mindoro', 'kkart' ),
		'PLW' => __( 'Palawan', 'kkart' ),
		'PAM' => __( 'Pampanga', 'kkart' ),
		'PAN' => __( 'Pangasinan', 'kkart' ),
		'QUE' => __( 'Quezon', 'kkart' ),
		'QUI' => __( 'Quirino', 'kkart' ),
		'RIZ' => __( 'Rizal', 'kkart' ),
		'ROM' => __( 'Romblon', 'kkart' ),
		'WSA' => __( 'Samar', 'kkart' ),
		'SAR' => __( 'Sarangani', 'kkart' ),
		'SIQ' => __( 'Siquijor', 'kkart' ),
		'SOR' => __( 'Sorsogon', 'kkart' ),
		'SCO' => __( 'South Cotabato', 'kkart' ),
		'SLE' => __( 'Southern Leyte', 'kkart' ),
		'SUK' => __( 'Sultan Kudarat', 'kkart' ),
		'SLU' => __( 'Sulu', 'kkart' ),
		'SUN' => __( 'Surigao del Norte', 'kkart' ),
		'SUR' => __( 'Surigao del Sur', 'kkart' ),
		'TAR' => __( 'Tarlac', 'kkart' ),
		'TAW' => __( 'Tawi-Tawi', 'kkart' ),
		'ZMB' => __( 'Zambales', 'kkart' ),
		'ZAN' => __( 'Zamboanga del Norte', 'kkart' ),
		'ZAS' => __( 'Zamboanga del Sur', 'kkart' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'kkart' ),
		'00'  => __( 'Metro Manila', 'kkart' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'kkart' ),
		'BA' => __( 'Balochistan', 'kkart' ),
		'TA' => __( 'FATA', 'kkart' ),
		'GB' => __( 'Gilgit Baltistan', 'kkart' ),
		'IS' => __( 'Islamabad Capital Territory', 'kkart' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'kkart' ),
		'PB' => __( 'Punjab', 'kkart' ),
		'SD' => __( 'Sindh', 'kkart' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'kkart' ),
		'PY-1'   => __( 'Concepción', 'kkart' ),
		'PY-2'   => __( 'San Pedro', 'kkart' ),
		'PY-3'   => __( 'Cordillera', 'kkart' ),
		'PY-4'   => __( 'Guairá', 'kkart' ),
		'PY-5'   => __( 'Caaguazú', 'kkart' ),
		'PY-6'   => __( 'Caazapá', 'kkart' ),
		'PY-7'   => __( 'Itapúa', 'kkart' ),
		'PY-8'   => __( 'Misiones', 'kkart' ),
		'PY-9'   => __( 'Paraguarí', 'kkart' ),
		'PY-10'  => __( 'Alto Paraná', 'kkart' ),
		'PY-11'  => __( 'Central', 'kkart' ),
		'PY-12'  => __( 'Ñeembucú', 'kkart' ),
		'PY-13'  => __( 'Amambay', 'kkart' ),
		'PY-14'  => __( 'Canindeyú', 'kkart' ),
		'PY-15'  => __( 'Presidente Hayes', 'kkart' ),
		'PY-16'  => __( 'Alto Paraguay', 'kkart' ),
		'PY-17'  => __( 'Boquerón', 'kkart' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'kkart' ),
		'AR' => __( 'Arad', 'kkart' ),
		'AG' => __( 'Argeș', 'kkart' ),
		'BC' => __( 'Bacău', 'kkart' ),
		'BH' => __( 'Bihor', 'kkart' ),
		'BN' => __( 'Bistrița-Năsăud', 'kkart' ),
		'BT' => __( 'Botoșani', 'kkart' ),
		'BR' => __( 'Brăila', 'kkart' ),
		'BV' => __( 'Brașov', 'kkart' ),
		'B'  => __( 'București', 'kkart' ),
		'BZ' => __( 'Buzău', 'kkart' ),
		'CL' => __( 'Călărași', 'kkart' ),
		'CS' => __( 'Caraș-Severin', 'kkart' ),
		'CJ' => __( 'Cluj', 'kkart' ),
		'CT' => __( 'Constanța', 'kkart' ),
		'CV' => __( 'Covasna', 'kkart' ),
		'DB' => __( 'Dâmbovița', 'kkart' ),
		'DJ' => __( 'Dolj', 'kkart' ),
		'GL' => __( 'Galați', 'kkart' ),
		'GR' => __( 'Giurgiu', 'kkart' ),
		'GJ' => __( 'Gorj', 'kkart' ),
		'HR' => __( 'Harghita', 'kkart' ),
		'HD' => __( 'Hunedoara', 'kkart' ),
		'IL' => __( 'Ialomița', 'kkart' ),
		'IS' => __( 'Iași', 'kkart' ),
		'IF' => __( 'Ilfov', 'kkart' ),
		'MM' => __( 'Maramureș', 'kkart' ),
		'MH' => __( 'Mehedinți', 'kkart' ),
		'MS' => __( 'Mureș', 'kkart' ),
		'NT' => __( 'Neamț', 'kkart' ),
		'OT' => __( 'Olt', 'kkart' ),
		'PH' => __( 'Prahova', 'kkart' ),
		'SJ' => __( 'Sălaj', 'kkart' ),
		'SM' => __( 'Satu Mare', 'kkart' ),
		'SB' => __( 'Sibiu', 'kkart' ),
		'SV' => __( 'Suceava', 'kkart' ),
		'TR' => __( 'Teleorman', 'kkart' ),
		'TM' => __( 'Timiș', 'kkart' ),
		'TL' => __( 'Tulcea', 'kkart' ),
		'VL' => __( 'Vâlcea', 'kkart' ),
		'VS' => __( 'Vaslui', 'kkart' ),
		'VN' => __( 'Vrancea', 'kkart' ),
	),
	'RS' => array(),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'kkart' ),
		'TH-15' => __( 'Ang Thong', 'kkart' ),
		'TH-14' => __( 'Ayutthaya', 'kkart' ),
		'TH-10' => __( 'Bangkok', 'kkart' ),
		'TH-38' => __( 'Bueng Kan', 'kkart' ),
		'TH-31' => __( 'Buri Ram', 'kkart' ),
		'TH-24' => __( 'Chachoengsao', 'kkart' ),
		'TH-18' => __( 'Chai Nat', 'kkart' ),
		'TH-36' => __( 'Chaiyaphum', 'kkart' ),
		'TH-22' => __( 'Chanthaburi', 'kkart' ),
		'TH-50' => __( 'Chiang Mai', 'kkart' ),
		'TH-57' => __( 'Chiang Rai', 'kkart' ),
		'TH-20' => __( 'Chonburi', 'kkart' ),
		'TH-86' => __( 'Chumphon', 'kkart' ),
		'TH-46' => __( 'Kalasin', 'kkart' ),
		'TH-62' => __( 'Kamphaeng Phet', 'kkart' ),
		'TH-71' => __( 'Kanchanaburi', 'kkart' ),
		'TH-40' => __( 'Khon Kaen', 'kkart' ),
		'TH-81' => __( 'Krabi', 'kkart' ),
		'TH-52' => __( 'Lampang', 'kkart' ),
		'TH-51' => __( 'Lamphun', 'kkart' ),
		'TH-42' => __( 'Loei', 'kkart' ),
		'TH-16' => __( 'Lopburi', 'kkart' ),
		'TH-58' => __( 'Mae Hong Son', 'kkart' ),
		'TH-44' => __( 'Maha Sarakham', 'kkart' ),
		'TH-49' => __( 'Mukdahan', 'kkart' ),
		'TH-26' => __( 'Nakhon Nayok', 'kkart' ),
		'TH-73' => __( 'Nakhon Pathom', 'kkart' ),
		'TH-48' => __( 'Nakhon Phanom', 'kkart' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'kkart' ),
		'TH-60' => __( 'Nakhon Sawan', 'kkart' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'kkart' ),
		'TH-55' => __( 'Nan', 'kkart' ),
		'TH-96' => __( 'Narathiwat', 'kkart' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'kkart' ),
		'TH-43' => __( 'Nong Khai', 'kkart' ),
		'TH-12' => __( 'Nonthaburi', 'kkart' ),
		'TH-13' => __( 'Pathum Thani', 'kkart' ),
		'TH-94' => __( 'Pattani', 'kkart' ),
		'TH-82' => __( 'Phang Nga', 'kkart' ),
		'TH-93' => __( 'Phatthalung', 'kkart' ),
		'TH-56' => __( 'Phayao', 'kkart' ),
		'TH-67' => __( 'Phetchabun', 'kkart' ),
		'TH-76' => __( 'Phetchaburi', 'kkart' ),
		'TH-66' => __( 'Phichit', 'kkart' ),
		'TH-65' => __( 'Phitsanulok', 'kkart' ),
		'TH-54' => __( 'Phrae', 'kkart' ),
		'TH-83' => __( 'Phuket', 'kkart' ),
		'TH-25' => __( 'Prachin Buri', 'kkart' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'kkart' ),
		'TH-85' => __( 'Ranong', 'kkart' ),
		'TH-70' => __( 'Ratchaburi', 'kkart' ),
		'TH-21' => __( 'Rayong', 'kkart' ),
		'TH-45' => __( 'Roi Et', 'kkart' ),
		'TH-27' => __( 'Sa Kaeo', 'kkart' ),
		'TH-47' => __( 'Sakon Nakhon', 'kkart' ),
		'TH-11' => __( 'Samut Prakan', 'kkart' ),
		'TH-74' => __( 'Samut Sakhon', 'kkart' ),
		'TH-75' => __( 'Samut Songkhram', 'kkart' ),
		'TH-19' => __( 'Saraburi', 'kkart' ),
		'TH-91' => __( 'Satun', 'kkart' ),
		'TH-17' => __( 'Sing Buri', 'kkart' ),
		'TH-33' => __( 'Sisaket', 'kkart' ),
		'TH-90' => __( 'Songkhla', 'kkart' ),
		'TH-64' => __( 'Sukhothai', 'kkart' ),
		'TH-72' => __( 'Suphan Buri', 'kkart' ),
		'TH-84' => __( 'Surat Thani', 'kkart' ),
		'TH-32' => __( 'Surin', 'kkart' ),
		'TH-63' => __( 'Tak', 'kkart' ),
		'TH-92' => __( 'Trang', 'kkart' ),
		'TH-23' => __( 'Trat', 'kkart' ),
		'TH-34' => __( 'Ubon Ratchathani', 'kkart' ),
		'TH-41' => __( 'Udon Thani', 'kkart' ),
		'TH-61' => __( 'Uthai Thani', 'kkart' ),
		'TH-53' => __( 'Uttaradit', 'kkart' ),
		'TH-95' => __( 'Yala', 'kkart' ),
		'TH-35' => __( 'Yasothon', 'kkart' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'kkart' ),
		'TR02' => __( 'Adıyaman', 'kkart' ),
		'TR03' => __( 'Afyon', 'kkart' ),
		'TR04' => __( 'Ağrı', 'kkart' ),
		'TR05' => __( 'Amasya', 'kkart' ),
		'TR06' => __( 'Ankara', 'kkart' ),
		'TR07' => __( 'Antalya', 'kkart' ),
		'TR08' => __( 'Artvin', 'kkart' ),
		'TR09' => __( 'Aydın', 'kkart' ),
		'TR10' => __( 'Balıkesir', 'kkart' ),
		'TR11' => __( 'Bilecik', 'kkart' ),
		'TR12' => __( 'Bingöl', 'kkart' ),
		'TR13' => __( 'Bitlis', 'kkart' ),
		'TR14' => __( 'Bolu', 'kkart' ),
		'TR15' => __( 'Burdur', 'kkart' ),
		'TR16' => __( 'Bursa', 'kkart' ),
		'TR17' => __( 'Çanakkale', 'kkart' ),
		'TR18' => __( 'Çankırı', 'kkart' ),
		'TR19' => __( 'Çorum', 'kkart' ),
		'TR20' => __( 'Denizli', 'kkart' ),
		'TR21' => __( 'Diyarbakır', 'kkart' ),
		'TR22' => __( 'Edirne', 'kkart' ),
		'TR23' => __( 'Elazığ', 'kkart' ),
		'TR24' => __( 'Erzincan', 'kkart' ),
		'TR25' => __( 'Erzurum', 'kkart' ),
		'TR26' => __( 'Eskişehir', 'kkart' ),
		'TR27' => __( 'Gaziantep', 'kkart' ),
		'TR28' => __( 'Giresun', 'kkart' ),
		'TR29' => __( 'Gümüşhane', 'kkart' ),
		'TR30' => __( 'Hakkari', 'kkart' ),
		'TR31' => __( 'Hatay', 'kkart' ),
		'TR32' => __( 'Isparta', 'kkart' ),
		'TR33' => __( 'İçel', 'kkart' ),
		'TR34' => __( 'İstanbul', 'kkart' ),
		'TR35' => __( 'İzmir', 'kkart' ),
		'TR36' => __( 'Kars', 'kkart' ),
		'TR37' => __( 'Kastamonu', 'kkart' ),
		'TR38' => __( 'Kayseri', 'kkart' ),
		'TR39' => __( 'Kırklareli', 'kkart' ),
		'TR40' => __( 'Kırşehir', 'kkart' ),
		'TR41' => __( 'Kocaeli', 'kkart' ),
		'TR42' => __( 'Konya', 'kkart' ),
		'TR43' => __( 'Kütahya', 'kkart' ),
		'TR44' => __( 'Malatya', 'kkart' ),
		'TR45' => __( 'Manisa', 'kkart' ),
		'TR46' => __( 'Kahramanmaraş', 'kkart' ),
		'TR47' => __( 'Mardin', 'kkart' ),
		'TR48' => __( 'Muğla', 'kkart' ),
		'TR49' => __( 'Muş', 'kkart' ),
		'TR50' => __( 'Nevşehir', 'kkart' ),
		'TR51' => __( 'Niğde', 'kkart' ),
		'TR52' => __( 'Ordu', 'kkart' ),
		'TR53' => __( 'Rize', 'kkart' ),
		'TR54' => __( 'Sakarya', 'kkart' ),
		'TR55' => __( 'Samsun', 'kkart' ),
		'TR56' => __( 'Siirt', 'kkart' ),
		'TR57' => __( 'Sinop', 'kkart' ),
		'TR58' => __( 'Sivas', 'kkart' ),
		'TR59' => __( 'Tekirdağ', 'kkart' ),
		'TR60' => __( 'Tokat', 'kkart' ),
		'TR61' => __( 'Trabzon', 'kkart' ),
		'TR62' => __( 'Tunceli', 'kkart' ),
		'TR63' => __( 'Şanlıurfa', 'kkart' ),
		'TR64' => __( 'Uşak', 'kkart' ),
		'TR65' => __( 'Van', 'kkart' ),
		'TR66' => __( 'Yozgat', 'kkart' ),
		'TR67' => __( 'Zonguldak', 'kkart' ),
		'TR68' => __( 'Aksaray', 'kkart' ),
		'TR69' => __( 'Bayburt', 'kkart' ),
		'TR70' => __( 'Karaman', 'kkart' ),
		'TR71' => __( 'Kırıkkale', 'kkart' ),
		'TR72' => __( 'Batman', 'kkart' ),
		'TR73' => __( 'Şırnak', 'kkart' ),
		'TR74' => __( 'Bartın', 'kkart' ),
		'TR75' => __( 'Ardahan', 'kkart' ),
		'TR76' => __( 'Iğdır', 'kkart' ),
		'TR77' => __( 'Yalova', 'kkart' ),
		'TR78' => __( 'Karabük', 'kkart' ),
		'TR79' => __( 'Kilis', 'kkart' ),
		'TR80' => __( 'Osmaniye', 'kkart' ),
		'TR81' => __( 'Düzce', 'kkart' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'kkart' ),
		'TZ02' => __( 'Dar es Salaam', 'kkart' ),
		'TZ03' => __( 'Dodoma', 'kkart' ),
		'TZ04' => __( 'Iringa', 'kkart' ),
		'TZ05' => __( 'Kagera', 'kkart' ),
		'TZ06' => __( 'Pemba North', 'kkart' ),
		'TZ07' => __( 'Zanzibar North', 'kkart' ),
		'TZ08' => __( 'Kigoma', 'kkart' ),
		'TZ09' => __( 'Kilimanjaro', 'kkart' ),
		'TZ10' => __( 'Pemba South', 'kkart' ),
		'TZ11' => __( 'Zanzibar South', 'kkart' ),
		'TZ12' => __( 'Lindi', 'kkart' ),
		'TZ13' => __( 'Mara', 'kkart' ),
		'TZ14' => __( 'Mbeya', 'kkart' ),
		'TZ15' => __( 'Zanzibar West', 'kkart' ),
		'TZ16' => __( 'Morogoro', 'kkart' ),
		'TZ17' => __( 'Mtwara', 'kkart' ),
		'TZ18' => __( 'Mwanza', 'kkart' ),
		'TZ19' => __( 'Coast', 'kkart' ),
		'TZ20' => __( 'Rukwa', 'kkart' ),
		'TZ21' => __( 'Ruvuma', 'kkart' ),
		'TZ22' => __( 'Shinyanga', 'kkart' ),
		'TZ23' => __( 'Singida', 'kkart' ),
		'TZ24' => __( 'Tabora', 'kkart' ),
		'TZ25' => __( 'Tanga', 'kkart' ),
		'TZ26' => __( 'Manyara', 'kkart' ),
		'TZ27' => __( 'Geita', 'kkart' ),
		'TZ28' => __( 'Katavi', 'kkart' ),
		'TZ29' => __( 'Njombe', 'kkart' ),
		'TZ30' => __( 'Simiyu', 'kkart' ),
	),
	'LK' => array( // Sri Lanka 
		'CE' => __( 'Central', 'kkart' ),
		'EA' => __( 'Eastern', 'kkart' ),
		'NC' => __( 'North Central', 'kkart' ),
		'NO' => __( 'Northern', 'kkart' ),
		'NW' => __( 'North Western', 'kkart' ),
		'SA' => __( 'Sabaragamuwa', 'kkart' ),
		'SO' => __( 'Southern', 'kkart' ),
		'UV' => __( 'Uva', 'kkart' ),
		'WE' => __( 'Western', 'kkart' ),
	),
	'RS' => array( // Serbia districts Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
		'RS00' => _x( 'Belgrade', 'district', 'kkart' ),
		'RS14' => _x( 'Bor', 'district', 'kkart' ),
		'RS11' => _x( 'Braničevo', 'district', 'kkart' ),
		'RS02' => _x( 'Central Banat', 'district', 'kkart' ),
		'RS10' => _x( 'Danube', 'district', 'kkart' ),
		'RS23' => _x( 'Jablanica', 'district', 'kkart' ),
		'RS09' => _x( 'Kolubara', 'district', 'kkart' ),
		'RS08' => _x( 'Mačva', 'district', 'kkart' ),
		'RS17' => _x( 'Morava', 'district', 'kkart' ),
		'RS20' => _x( 'Nišava', 'district', 'kkart' ),
		'RS01' => _x( 'North Bačka', 'district', 'kkart' ),
		'RS03' => _x( 'North Banat', 'district', 'kkart' ),
		'RS24' => _x( 'Pčinja', 'district', 'kkart' ),
		'RS22' => _x( 'Pirot', 'district', 'kkart' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'kkart' ),
		'RS19' => _x( 'Rasina', 'district', 'kkart' ),
		'RS18' => _x( 'Raška', 'district', 'kkart' ),
		'RS06' => _x( 'South Bačka', 'district', 'kkart' ),
		'RS04' => _x( 'South Banat', 'district', 'kkart' ),
		'RS07' => _x( 'Srem', 'district', 'kkart' ),
		'RS12' => _x( 'Šumadija', 'district', 'kkart' ),
		'RS21' => _x( 'Toplica', 'district', 'kkart' ),
		'RS05' => _x( 'West Bačka', 'district', 'kkart' ),
		'RS15' => _x( 'Zaječar', 'district', 'kkart' ),
		'RS16' => _x( 'Zlatibor', 'district', 'kkart' ),
		'RS25' => _x( 'Kosovo', 'district', 'kkart' ),
		'RS26' => _x( 'Peć', 'district', 'kkart' ),
		'RS27' => _x( 'Prizren', 'district', 'kkart' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'kkart' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'kkart' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'kkart' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'kkart' ),
	),
	'SE' => array(),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'kkart' ),
		'UG301' => __( 'Adjumani', 'kkart' ),
		'UG322' => __( 'Agago', 'kkart' ),
		'UG323' => __( 'Alebtong', 'kkart' ),
		'UG315' => __( 'Amolatar', 'kkart' ),
		'UG324' => __( 'Amudat', 'kkart' ),
		'UG216' => __( 'Amuria', 'kkart' ),
		'UG316' => __( 'Amuru', 'kkart' ),
		'UG302' => __( 'Apac', 'kkart' ),
		'UG303' => __( 'Arua', 'kkart' ),
		'UG217' => __( 'Budaka', 'kkart' ),
		'UG218' => __( 'Bududa', 'kkart' ),
		'UG201' => __( 'Bugiri', 'kkart' ),
		'UG235' => __( 'Bugweri', 'kkart' ),
		'UG420' => __( 'Buhweju', 'kkart' ),
		'UG117' => __( 'Buikwe', 'kkart' ),
		'UG219' => __( 'Bukedea', 'kkart' ),
		'UG118' => __( 'Bukomansimbi', 'kkart' ),
		'UG220' => __( 'Bukwa', 'kkart' ),
		'UG225' => __( 'Bulambuli', 'kkart' ),
		'UG416' => __( 'Buliisa', 'kkart' ),
		'UG401' => __( 'Bundibugyo', 'kkart' ),
		'UG430' => __( 'Bunyangabu', 'kkart' ),
		'UG402' => __( 'Bushenyi', 'kkart' ),
		'UG202' => __( 'Busia', 'kkart' ),
		'UG221' => __( 'Butaleja', 'kkart' ),
		'UG119' => __( 'Butambala', 'kkart' ),
		'UG233' => __( 'Butebo', 'kkart' ),
		'UG120' => __( 'Buvuma', 'kkart' ),
		'UG226' => __( 'Buyende', 'kkart' ),
		'UG317' => __( 'Dokolo', 'kkart' ),
		'UG121' => __( 'Gomba', 'kkart' ),
		'UG304' => __( 'Gulu', 'kkart' ),
		'UG403' => __( 'Hoima', 'kkart' ),
		'UG417' => __( 'Ibanda', 'kkart' ),
		'UG203' => __( 'Iganga', 'kkart' ),
		'UG418' => __( 'Isingiro', 'kkart' ),
		'UG204' => __( 'Jinja', 'kkart' ),
		'UG318' => __( 'Kaabong', 'kkart' ),
		'UG404' => __( 'Kabale', 'kkart' ),
		'UG405' => __( 'Kabarole', 'kkart' ),
		'UG213' => __( 'Kaberamaido', 'kkart' ),
		'UG427' => __( 'Kagadi', 'kkart' ),
		'UG428' => __( 'Kakumiro', 'kkart' ),
		'UG101' => __( 'Kalangala', 'kkart' ),
		'UG222' => __( 'Kaliro', 'kkart' ),
		'UG122' => __( 'Kalungu', 'kkart' ),
		'UG102' => __( 'Kampala', 'kkart' ),
		'UG205' => __( 'Kamuli', 'kkart' ),
		'UG413' => __( 'Kamwenge', 'kkart' ),
		'UG414' => __( 'Kanungu', 'kkart' ),
		'UG206' => __( 'Kapchorwa', 'kkart' ),
		'UG236' => __( 'Kapelebyong', 'kkart' ),
		'UG126' => __( 'Kasanda', 'kkart' ),
		'UG406' => __( 'Kasese', 'kkart' ),
		'UG207' => __( 'Katakwi', 'kkart' ),
		'UG112' => __( 'Kayunga', 'kkart' ),
		'UG407' => __( 'Kibaale', 'kkart' ),
		'UG103' => __( 'Kiboga', 'kkart' ),
		'UG227' => __( 'Kibuku', 'kkart' ),
		'UG432' => __( 'Kikuube', 'kkart' ),
		'UG419' => __( 'Kiruhura', 'kkart' ),
		'UG421' => __( 'Kiryandongo', 'kkart' ),
		'UG408' => __( 'Kisoro', 'kkart' ),
		'UG305' => __( 'Kitgum', 'kkart' ),
		'UG319' => __( 'Koboko', 'kkart' ),
		'UG325' => __( 'Kole', 'kkart' ),
		'UG306' => __( 'Kotido', 'kkart' ),
		'UG208' => __( 'Kumi', 'kkart' ),
		'UG333' => __( 'Kwania', 'kkart' ),
		'UG228' => __( 'Kween', 'kkart' ),
		'UG123' => __( 'Kyankwanzi', 'kkart' ),
		'UG422' => __( 'Kyegegwa', 'kkart' ),
		'UG415' => __( 'Kyenjojo', 'kkart' ),
		'UG125' => __( 'Kyotera', 'kkart' ),
		'UG326' => __( 'Lamwo', 'kkart' ),
		'UG307' => __( 'Lira', 'kkart' ),
		'UG229' => __( 'Luuka', 'kkart' ),
		'UG104' => __( 'Luwero', 'kkart' ),
		'UG124' => __( 'Lwengo', 'kkart' ),
		'UG114' => __( 'Lyantonde', 'kkart' ),
		'UG223' => __( 'Manafwa', 'kkart' ),
		'UG320' => __( 'Maracha', 'kkart' ),
		'UG105' => __( 'Masaka', 'kkart' ),
		'UG409' => __( 'Masindi', 'kkart' ),
		'UG214' => __( 'Mayuge', 'kkart' ),
		'UG209' => __( 'Mbale', 'kkart' ),
		'UG410' => __( 'Mbarara', 'kkart' ),
		'UG423' => __( 'Mitooma', 'kkart' ),
		'UG115' => __( 'Mityana', 'kkart' ),
		'UG308' => __( 'Moroto', 'kkart' ),
		'UG309' => __( 'Moyo', 'kkart' ),
		'UG106' => __( 'Mpigi', 'kkart' ),
		'UG107' => __( 'Mubende', 'kkart' ),
		'UG108' => __( 'Mukono', 'kkart' ),
		'UG334' => __( 'Nabilatuk', 'kkart' ),
		'UG311' => __( 'Nakapiripirit', 'kkart' ),
		'UG116' => __( 'Nakaseke', 'kkart' ),
		'UG109' => __( 'Nakasongola', 'kkart' ),
		'UG230' => __( 'Namayingo', 'kkart' ),
		'UG234' => __( 'Namisindwa', 'kkart' ),
		'UG224' => __( 'Namutumba', 'kkart' ),
		'UG327' => __( 'Napak', 'kkart' ),
		'UG310' => __( 'Nebbi', 'kkart' ),
		'UG231' => __( 'Ngora', 'kkart' ),
		'UG424' => __( 'Ntoroko', 'kkart' ),
		'UG411' => __( 'Ntungamo', 'kkart' ),
		'UG328' => __( 'Nwoya', 'kkart' ),
		'UG331' => __( 'Omoro', 'kkart' ),
		'UG329' => __( 'Otuke', 'kkart' ),
		'UG321' => __( 'Oyam', 'kkart' ),
		'UG312' => __( 'Pader', 'kkart' ),
		'UG332' => __( 'Pakwach', 'kkart' ),
		'UG210' => __( 'Pallisa', 'kkart' ),
		'UG110' => __( 'Rakai', 'kkart' ),
		'UG429' => __( 'Rubanda', 'kkart' ),
		'UG425' => __( 'Rubirizi', 'kkart' ),
		'UG431' => __( 'Rukiga', 'kkart' ),
		'UG412' => __( 'Rukungiri', 'kkart' ),
		'UG111' => __( 'Sembabule', 'kkart' ),
		'UG232' => __( 'Serere', 'kkart' ),
		'UG426' => __( 'Sheema', 'kkart' ),
		'UG215' => __( 'Sironko', 'kkart' ),
		'UG211' => __( 'Soroti', 'kkart' ),
		'UG212' => __( 'Tororo', 'kkart' ),
		'UG113' => __( 'Wakiso', 'kkart' ),
		'UG313' => __( 'Yumbe', 'kkart' ),
		'UG330' => __( 'Zombo', 'kkart' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'kkart' ),
		'84' => __( 'Howland Island', 'kkart' ),
		'86' => __( 'Jarvis Island', 'kkart' ),
		'67' => __( 'Johnston Atoll', 'kkart' ),
		'89' => __( 'Kingman Reef', 'kkart' ),
		'71' => __( 'Midway Atoll', 'kkart' ),
		'76' => __( 'Navassa Island', 'kkart' ),
		'95' => __( 'Palmyra Atoll', 'kkart' ),
		'79' => __( 'Wake Island', 'kkart' ),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'kkart' ),
		'AK' => __( 'Alaska', 'kkart' ),
		'AZ' => __( 'Arizona', 'kkart' ),
		'AR' => __( 'Arkansas', 'kkart' ),
		'CA' => __( 'California', 'kkart' ),
		'CO' => __( 'Colorado', 'kkart' ),
		'CT' => __( 'Connecticut', 'kkart' ),
		'DE' => __( 'Delaware', 'kkart' ),
		'DC' => __( 'District Of Columbia', 'kkart' ),
		'FL' => __( 'Florida', 'kkart' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'kkart' ),
		'HI' => __( 'Hawaii', 'kkart' ),
		'ID' => __( 'Idaho', 'kkart' ),
		'IL' => __( 'Illinois', 'kkart' ),
		'IN' => __( 'Indiana', 'kkart' ),
		'IA' => __( 'Iowa', 'kkart' ),
		'KS' => __( 'Kansas', 'kkart' ),
		'KY' => __( 'Kentucky', 'kkart' ),
		'LA' => __( 'Louisiana', 'kkart' ),
		'ME' => __( 'Maine', 'kkart' ),
		'MD' => __( 'Maryland', 'kkart' ),
		'MA' => __( 'Massachusetts', 'kkart' ),
		'MI' => __( 'Michigan', 'kkart' ),
		'MN' => __( 'Minnesota', 'kkart' ),
		'MS' => __( 'Mississippi', 'kkart' ),
		'MO' => __( 'Missouri', 'kkart' ),
		'MT' => __( 'Montana', 'kkart' ),
		'NE' => __( 'Nebraska', 'kkart' ),
		'NV' => __( 'Nevada', 'kkart' ),
		'NH' => __( 'New Hampshire', 'kkart' ),
		'NJ' => __( 'New Jersey', 'kkart' ),
		'NM' => __( 'New Mexico', 'kkart' ),
		'NY' => __( 'New York', 'kkart' ),
		'NC' => __( 'North Carolina', 'kkart' ),
		'ND' => __( 'North Dakota', 'kkart' ),
		'OH' => __( 'Ohio', 'kkart' ),
		'OK' => __( 'Oklahoma', 'kkart' ),
		'OR' => __( 'Oregon', 'kkart' ),
		'PA' => __( 'Pennsylvania', 'kkart' ),
		'RI' => __( 'Rhode Island', 'kkart' ),
		'SC' => __( 'South Carolina', 'kkart' ),
		'SD' => __( 'South Dakota', 'kkart' ),
		'TN' => __( 'Tennessee', 'kkart' ),
		'TX' => __( 'Texas', 'kkart' ),
		'UT' => __( 'Utah', 'kkart' ),
		'VT' => __( 'Vermont', 'kkart' ),
		'VA' => __( 'Virginia', 'kkart' ),
		'WA' => __( 'Washington', 'kkart' ),
		'WV' => __( 'West Virginia', 'kkart' ),
		'WI' => __( 'Wisconsin', 'kkart' ),
		'WY' => __( 'Wyoming', 'kkart' ),
		'AA' => __( 'Armed Forces (AA)', 'kkart' ),
		'AE' => __( 'Armed Forces (AE)', 'kkart' ),
		'AP' => __( 'Armed Forces (AP)', 'kkart' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'kkart' ),
		'FS'  => __( 'Free State', 'kkart' ),
		'GP'  => __( 'Gauteng', 'kkart' ),
		'KZN' => __( 'KwaZulu-Natal', 'kkart' ),
		'LP'  => __( 'Limpopo', 'kkart' ),
		'MP'  => __( 'Mpumalanga', 'kkart' ),
		'NC'  => __( 'Northern Cape', 'kkart' ),
		'NW'  => __( 'North West', 'kkart' ),
		'KKART'  => __( 'Western Cape', 'kkart' ),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'kkart' ),
		'ZM-02' => __( 'Central', 'kkart' ),
		'ZM-03' => __( 'Eastern', 'kkart' ),
		'ZM-04' => __( 'Luapula', 'kkart' ),
		'ZM-05' => __( 'Northern', 'kkart' ),
		'ZM-06' => __( 'North-Western', 'kkart' ),
		'ZM-07' => __( 'Southern', 'kkart' ),
		'ZM-08' => __( 'Copperbelt', 'kkart' ),
		'ZM-09' => __( 'Lusaka', 'kkart' ),
		'ZM-10' => __( 'Muchinga', 'kkart' ),
	),
);
