<?php
/**
 * Admin View: Notice - PHP & WP minimum requirements.
 *
 * @package Kkart\Admin\Notices
 */

defined( 'ABSPATH' ) || exit;
?>
<div id="message" class="updated kkart-message">
	<a class="kkart-message-close notice-dismiss" href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'kkart-hide-notice', KKART_PHP_MIN_REQUIREMENTS_NOTICE ), 'kkart_hide_notices_nonce', '_kkart_notice_nonce' ) ); ?>"><?php esc_html_e( 'Dismiss', 'kkart' ); ?></a>

	<p>
		<?php
		echo wp_kses_post(
			sprintf(
				$msg . '<p><a href="%s" class="button button-primary">' . __( 'Learn how to upgrade', 'kkart' ) . '</a></p>',
				add_query_arg(
					array(
						'utm_source'   => 'wpphpupdatebanner',
						'utm_medium'   => 'product',
						'utm_campaign' => 'kkartplugin',
						'utm_content'  => 'docs',
					),
					'https://docs.kkart.com/document/update-php-wordpress/'
				)
			)
		);
		?>
	</p>
</div>
