<?php
/**
 * Handle cron events.
 * NOTE: DO NOT edit this file in Kkart core, this is generated from kkart-admin.
 */

namespace Automattic\Kkart\Admin;

defined( 'ABSPATH' ) || exit;

use \Automattic\Kkart\Admin\Notes\ChooseNiche;
use \Automattic\Kkart\Admin\Notes\GivingFeedbackNotes;
use \Automattic\Kkart\Admin\Notes\MobileApp;
use \Automattic\Kkart\Admin\Notes\NewSalesRecord;
use \Automattic\Kkart\Admin\Notes\TrackingOptIn;
use \Automattic\Kkart\Admin\Notes\OnboardingEmailMarketing;
use \Automattic\Kkart\Admin\Notes\OnboardingPayments;
use \Automattic\Kkart\Admin\Notes\PersonalizeStore;
use \Automattic\Kkart\Admin\Notes\EUVATNumber;
use \Automattic\Kkart\Admin\Notes\KkartPayments;
use \Automattic\Kkart\Admin\Notes\Marketing;
use \Automattic\Kkart\Admin\Notes\StartDropshippingBusiness;
use \Automattic\Kkart\Admin\Notes\KkartSubscriptions;
use \Automattic\Kkart\Admin\Notes\MigrateFromShopify;
use \Automattic\Kkart\Admin\Notes\LaunchChecklist;
use \Automattic\Kkart\Admin\Notes\RealTimeOrderAlerts;
use \Automattic\Kkart\Admin\RemoteInboxNotifications\DataSourcePoller;
use \Automattic\Kkart\Admin\RemoteInboxNotifications\RemoteInboxNotificationsEngine;
use \Automattic\Kkart\Admin\Loader;
use \Automattic\Kkart\Admin\Notes\InsightFirstSale;
use \Automattic\Kkart\Admin\Notes\HomeScreenFeedback;
use \Automattic\Kkart\Admin\Notes\NeedSomeInspiration;
use \Automattic\Kkart\Admin\Notes\OnlineClothingStore;
use \Automattic\Kkart\Admin\Notes\FirstProduct;
use \Automattic\Kkart\Admin\Notes\CustomizeStoreWithBlocks;
use \Automattic\Kkart\Admin\Notes\GoogleAdsAndMarketing;
use \Automattic\Kkart\Admin\Notes\TestCheckout;
use \Automattic\Kkart\Admin\Notes\EditProductsOnTheMove;
use \Automattic\Kkart\Admin\Notes\PerformanceOnMobile;
use \Automattic\Kkart\Admin\Notes\ManageOrdersOnTheGo;
use \Automattic\Kkart\Admin\Notes\NavigationFeedback;
use \Automattic\Kkart\Admin\Notes\NavigationFeedbackFollowUp;

/**
 * Events Class.
 */
class Events {
	/**
	 * The single instance of the class.
	 *
	 * @var object
	 */
	protected static $instance = null;

	/**
	 * Constructor
	 *
	 * @return void
	 */
	protected function __construct() {}

	/**
	 * Get class instance.
	 *
	 * @return object Instance.
	 */
	final public static function instance() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	/**
	 * Cron event handlers.
	 */
	public function init() {
		add_action( 'kkart_admin_daily', array( $this, 'do_kkart_admin_daily' ) );
	}

	/**
	 * Daily events to run.
	 *
	 * Note: Order_Milestones::other_milestones is hooked to this as well.
	 */
	public function do_kkart_admin_daily() {
		NewSalesRecord::possibly_add_note();
		MobileApp::possibly_add_note();
		TrackingOptIn::possibly_add_note();
		OnboardingEmailMarketing::possibly_add_note();
		OnboardingPayments::possibly_add_note();
		PersonalizeStore::possibly_add_note();
		KkartPayments::possibly_add_note();
		EUVATNumber::possibly_add_note();
		Marketing::possibly_add_note();
		GivingFeedbackNotes::possibly_add_note();
		StartDropshippingBusiness::possibly_add_note();
		KkartSubscriptions::possibly_add_note();
		MigrateFromShopify::possibly_add_note();
		InsightFirstSale::possibly_add_note();
		LaunchChecklist::possibly_add_note();
		HomeScreenFeedback::possibly_add_note();
		NeedSomeInspiration::possibly_add_note();
		OnlineClothingStore::possibly_add_note();
		FirstProduct::possibly_add_note();
		ChooseNiche::possibly_add_note();
		RealTimeOrderAlerts::possibly_add_note();
		CustomizeStoreWithBlocks::possibly_add_note();
		GoogleAdsAndMarketing::possibly_add_note();
		TestCheckout::possibly_add_note();
		EditProductsOnTheMove::possibly_add_note();
		PerformanceOnMobile::possibly_add_note();
		ManageOrdersOnTheGo::possibly_add_note();
		NavigationFeedback::possibly_add_note();
		NavigationFeedbackFollowUp::possibly_add_note();

		if ( $this->is_remote_inbox_notifications_enabled() ) {
			DataSourcePoller::read_specs_from_data_sources();
			RemoteInboxNotificationsEngine::run();
		}
	}

	/**
	 * Checks if remote inbox notifications are enabled.
	 *
	 * @return bool Whether remote inbox notifications are enabled.
	 */
	protected function is_remote_inbox_notifications_enabled() {
		// Check if the feature flag is disabled.
		if ( ! Loader::is_feature_enabled( 'remote-inbox-notifications' ) ) {
			return false;
		}

		// Check if the site has opted out of marketplace suggestions.
		if ( 'yes' !== get_option( 'kkart_show_marketplace_suggestions', 'yes' ) ) {
			return false;
		}

		// All checks have passed.
		return true;
	}
}
