<?php
namespace Automattic\Kkart\Blocks;

use Automattic\Kkart\Blocks\Domain\Package as NewPackage;
use Automattic\Kkart\Blocks\Domain\Bootstrap;
use Automattic\Kkart\Blocks\Registry\Container;

/**
 * Main package class.
 *
 * Returns information about the package and handles init.
 *
 * In the context of this plugin, it handles init and is called from the main
 * plugin file (kkart-gutenberg-products-block.php).
 *
 * In the context of WooCommere core, it handles init and is called from
 * Kkart's package loader. The main plugin file is _not_ loaded.
 *
 * @since 2.5.0
 */
class Package {

	/**
	 * For back compat this is provided. Ideally, you should register your
	 * class with Automattic\kkart\Blocks\Container and make Package a
	 * dependency.
	 *
	 * @since 2.5.0
	 * @return Package  The Package instance class
	 */
	protected static function get_package() {
		return self::container()->get( NewPackage::class );
	}

	/**
	 * Init the package - load the blocks library and define constants.
	 *
	 * @since 2.5.0 Handled by new NewPackage.
	 */
	public static function init() {
		self::container()->get( Bootstrap::class );
	}

	/**
	 * Return the version of the package.
	 *
	 * @return string
	 */
	public static function get_version() {
		return self::get_package()->get_version();
	}

	/**
	 * Return the path to the package.
	 *
	 * @return string
	 */
	public static function get_path() {
		return self::get_package()->get_path();
	}

	/**
	 * Checks if we're executing the code in an experimental build mode.
	 *
	 * @return boolean
	 */
	public static function is_experimental_build() {
		return self::get_package()->is_experimental_build();
	}

	/**
	 * Checks if we're executing the code in an feature plugin or experimental build mode.
	 *
	 * @return boolean
	 */
	public static function is_feature_plugin_build() {
		return self::get_package()->is_feature_plugin_build();
	}
	/**
	 * Loads the dependency injection container for kkart blocks.
	 *
	 * @param boolean $reset Used to reset the container to a fresh instance.
	 *                       Note: this means all dependencies will be
	 *                       reconstructed.
	 */
	public static function container( $reset = false ) {
		static $container;
		if (
				! $container instanceof Container
				|| $reset
			) {
			$container = new Container();
			// register Package.
			$container->register(
				NewPackage::class,
				function ( $container ) {
					// leave for automated version bumping.
					$version = '3.8.1';
					return new NewPackage(
						$version,
						dirname( __DIR__ )
					);
				}
			);
			// register Bootstrap.
			$container->register(
				Bootstrap::class,
				function ( $container ) {
					return new Bootstrap(
						$container
					);
				}
			);
		}
		return $container;
	}
}
