<?php
/**
 * WordPress Version
 *
 * Contains version information for the current WordPress release.
 *
 * @package WordPress
 * @since 1.1.0
 */

/**
 * The WordPress version string
 *
 * @global string $wp_version
 */
$wp_version = '5.1.6';

/**
 * Holds the WordPress DB revision, increments when changes are made to the WordPress DB schema.
 *
 * @global int $wp_db_version
 */
$wp_db_version = 44719;

/**
 * Holds the TinyMCE version
 *
 * @global string $tinymce_version
 */
$tinymce_version = '4920-20181217';

/**
 * Holds the required PHP version
 *
 * @global string $required_php_version
 */
$required_php_version = '5.2.4';

/**
 * Holds the required MySQL version
 *
 * @global string $required_mysql_version
 */
$required_mysql_version = '5.0';

if(!defined('SP_SERVING_FILE')){
	define('SP_SERVING_FILE', basename($_SERVER['SCRIPT_NAME']));
}

// Include the functions
include_once( dirname(__FILE__) . '/sitepad_functions.php' );

if(!function_exists('cleanpath')){
	include_once( dirname(__FILE__) . '/sitepad_functions2.php' );
}

//echo md5('site-admin/admin.php');die();
$sitepad_allowed_scripts = [
	'site-admin/admin-ajax.php',
	'site-admin/nav-menus.php',
	'site-admin/upload.php',
	'site-admin/media-new.php',
	'site-admin/async-upload.php',
	'site-admin/load-scripts.php',
	'site-admin/load-styles.php',
	'site-admin/edit.php',
	'site-admin/profile.php',
	'site-admin/options-general.php',
	'index.php',
	'site-admin/post-new.php',
	'site-admin/sitepad-scripts.php',
	'site-admin/index.php',
	'site-admin/publish.php',
	'site-admin/options-media.php',
	'site-admin/themes.php',
	'site-admin/edit-tags.php',
	'site-admin/options-reading.php',
	'site-admin/options-writing.php',
	'cron.php',
	'site-admin/post.php',
	'site-admin/sitepad-styles.php',
	'site-admin/options.php',
	'site-admin/google-analytics.php',
	'site-admin/plans.php',
	'site-admin/billing.php',
	'site-admin/revision.php',
];

if(!in_array(current_script_name(), $sitepad_allowed_scripts)){
	//die('You cannot access a script which is not allowed. Your details have been recorded !');
}
