
package Mail::SpamAssassin::CompiledRegexps::body_0;

use strict;

use XSLoader ();

BEGIN {
our $VERSION = '1.0';
our @ISA = qw(XSLoader);
our @EXPORT_OK = qw();

our $HAS_RULES = {
    q#ACT_NOW_CAPS,[l=1]# => q#(?aa)\bA(?i:ct) N(?i:ow)\b#,
  q#BAD_CREDIT,[l=1]# => q#(?aa)(?i)\b(?:(?:bad|poor|eliminate|repair|(?:re)?establish|damag).{0,10} (?:credit|debt)|no credit (?:check|histor|need))#,
  q#BANG_GUAR,[l=1]# => q#(?aa)(?i)\bguaranteed?\!#,
  q#BANG_OPRAH,[l=1]# => q#(?aa)(?i)\boprah!#,
  q#BANKING_LAWS,[l=0]# => q#(?aa)(?i)banking laws#,
  q#BILLION_DOLLARS,[l=1]# => q#(?aa)[BM]ILLION DOLLAR#,
  q#BILL_1618,[l=1]# => q#(?aa)(?i)\bUnder Bill\s?s?.1618(?: Title III)? passed by the 105th U\.S\. Congress\b#,
  q#BODY_ENHANCEMENT,[l=1]# => q#(?aa)(?i)\b(?:enlarge|increase|grow|lengthen|larger\b|bigger\b|longer\b|thicker\b|\binches\b).{0,50}\b(?:penis|male organ|pee[ -]?pee|dick|sc?hlong|wh?anger|breast(?!\s+cancer))#,
  q#BODY_ENHANCEMENT2,[l=1]# => q#(?aa)(?i)\b(?:penis|male organ|pee[ -]?pee|dick|sc?hlong|wh?anger|breast(?!\s+cancer)).{0,50}\b(?:enlarge|increase|grow|lengthen|larger\b|bigger\b|longer\b|thicker\b|\binches\b|size)#,
  q#CUM_SHOT,[l=1]# => q#(?aa)(?i)\bcum[ -]?shots?\b#,
  q#CURR_PRICE,[l=1]# => q#(?aa)\bCurrent Price:#,
  q#DEAR_BENEFICIARY,[l=1]# => q#(?aa)(?i)\b(?:De[ae]r\s|At+(?:ention|n):?\s?)(?:\S+\s)?Ben[ei]ficiary\b#,
  q#DEAR_SOMETHING,[l=1]# => q#(?aa)(?i)\bDear (?:IT\W|Internet|candidate|sirs?|madam|investor|travell?er|car shopper|web)\b#,
  q#DEAR_WINNER,[l=1]# => q#(?aa)(?i)\bdear.{1,20}winner#,
  q#DIET_1,[l=1]# => q#(?aa)(?i)\b(?:(?:without|no) (?:exercis(?:e(?! price)|ing)|dieting)|weight.?loss|(?:extra|lose|lost|losing).{0,10}(?:pounds|weight|inches|lbs)|burn.{1,10}fat)\b#,
  q#DRUGS_SMEAR1,[l=1]# => q#(?aa)(?i)(?:Viagra|Valium|Xanax|Soma|Cialis){2}#,
  q#DRUG_ED_CAPS,[l=1]# => q#(?aa)\b(?:CIALIS|LEVITRA|VIAGRA)#,
  q#DRUG_ED_GENERIC,[l=1]# => q#(?aa)\bGeneric Viagra\b#,
  q#DRUG_ED_ONLINE,[l=1]# => q#(?aa)(?i)\bviagra .{0,25}(?:express|online|overnight)#,
  q#DRUG_ED_SILD,[l=1]# => q#(?aa)(?i)\bsildenafil\b#,
  q#DX_TEXT_03,[l=1]# => q#(?aa)\b[A-Z]{3} Media (?:Group|Relations)\b#,
  q#EMRCP,[l=1]# => q#(?aa)(?i)\bExcess (?:Maximum )?Return Capital (?:Profits?|Funds?)\b#,
  q#EM_ROLEX,[l=1]# => q#(?aa)(?i)[^\s\w.]rolex#,
  q#EXCUSE_24,[l=1]# => q#(?aa)(?i)you(?:'ve|'re| have| are)? receiv(?:e|ed|ing) this (?:advertisement|offer|special|recurring|paid).{0,16}\b(?:by either|because)#,
  q#EXCUSE_4,[l=1]# => q#(?aa)(?i)To Be Removed,? Please#,
  q#EXCUSE_REMOVE,[l=1]# => q#(?aa)(?i)to be removed from.{0,20}(?:mailings|offers)#,
  q#FIN_FREE,[l=1]# => q#(?aa)(?i)\bfinancial(?:ly)? (?:free|independen)#,
  q#FORWARD_LOOKING,[l=1]# => q#(?aa)(?i)\bcontains forward-looking statements\b#,
  q#FREE_PORN,[l=1]# => q#(?aa)(?i)\bfree (?:porn|xxx|adult)#,
  q#FREE_QUOTE_INSTANT,[l=1]# => q#(?aa)(?i)free.{0,12}(?:(?:instant|express|online|no.?obligation).{0,4})+.{0,32}\bquote#,
  q#GTUBE,[l=1]# => q#(?aa)XJS\*C4JDBQADN1\.NSBN3\*2IDNEN\*GTUBE-STANDARD-ANTI-UBE-TEST-EMAIL\*C\.34X#,
  q#GUARANTEED_100_PERCENT,[l=0]# => q#(?aa)(?i)100% GUARANTEED#,
  q#IMPOTENCE,[l=1]# => q#(?aa)(?i)\b(?:impotence (?:problem|cure|solution)|Premature Ejaculation|erectile dysfunction)#,
  q#INVESTMENT_ADVICE,[l=1]# => q#(?aa)(?i)\binvestment advice#,
  q#JOIN_MILLIONS,[l=1]# => q#(?aa)(?i)\bjoin (?:millions|thousands)\b#,
  q#KAM_ADVERT2,[l=1]# => q#(?aa)(?is)No longer interested in our offers|This (message|email)? is an Ad|Continue in your Secure Web Browser|Can\'t see the images( below|, continue)|To view this email as a webpage|see images for this offer|support best practices in responsible email marketing|This email is not unsolicited|You registered with one of our partners websites|a d v e r t i s (?:e )?m e n t|No\-?Images? Click|Program is not endorsed, sponsored by or affiliated|can\'t read or see this email|By clicking any image and\/or text link in this Email|This is a (commercial|commericial)|This message brought to you|THIS EMAIL IS A COMMERCIAL|If you no longer wish to receive further offers|business solicitation message|link is for removal|end these weekly ad\-messages|cancel these Ads go|This is an email advertisement|end all Advertisements go below|We are not spammers|Unsolicited email\?|Quit receiving these admail|I.{0,3}am not spamming|commercial.advertisement|adv.ertisement|if.you.are.not.interested|Brought to you by\:|This (message|entire message|communication) is an ad|removal from further update|inbox by requesting removal|No more incoming messages will be delivered|Never receive these again|This is an ad\-coresspondance|this page is an advertise?ment|this is an \(adver\-?tisement\)|this page are an.ad|statements above are an.ad|advertis.e.ment|share your contact#,
  q#KAM_ADVERT3,[l=1]# => q#(?aa)(?i)AllExpiringDomains.com#,
  q#KAM_ADVERT4,[l=0]# => q#(?aa)(?i)This is an ad#,
  q#KAM_BODY,[l=0]# => q#(?aa)(?i){_BODY_HTML}#,
  q#KAM_CANSPAM,[l=1]# => q#(?aa)(?is)(full compliance with the U.S. Federal\-?Can\-?Spam\-Act|provides CAN\-SPAM compliant email|consistent with the provisions of the CAN\-SPAM Act|compliance with the CanSpam Act|no deceptive subject lines|compliant with all legal provisions of the CAN\-SPAM Act)#,
  q#KAM_CBTSCRAP,[l=0]# => q#(?aa)(?i)CBT (website scraper|Email Extractor)#,
  q#KAM_FILE,[l=0]# => q#(?aa)(?i)file:\/\/\/\/#,
  q#KAM_HOLLY,[l=0]# => q#(?aa)(?i)1 0 2 0 N H o l l y w o o d W a y #,
  q#KAM_LEAD_SUPPLY,[l=0]# => q#(?aa)(?i)The Lead Supply via marketing services from The Email Bureau|The Email Bureau Limited#,
  q#KAM_NOT_INTERESTED,[l=0]# => q#(?aa)(?i)reply \"Not Interested\"#,
  q#KAM_OBFU_LOANS,[l=0]# => q#(?aa)(?i)Stüdént Lóans#,
  q#KAM_OVERPAY,[l=1]# => q#(?aa)(?i)O . V . E . R . P . A . Y#,
  q#KAM_PERPARK,[l=0]# => q#(?aa)(?i)P e r i m e t e r P a r k C e n t e r#,
  q#KAM_PUBLIC,[l=1]# => q#(?aa)(?is)obtained your email address from a publicly available list|find your mail in public forum#,
  q#KAM_REACHBASE,[l=0]# => q#(?aa)(?i)ReachBase is committed to providing you with relevant business information#,
  q#KAM_TRUTHINESS,[l=1]# => q#(?aa)[Tt]he TRUTH#,
  q#KAM_VIAGRA2,[l=0]# => q#(?aa)(?i)(?:Xan|Som|CIA|VAL|VIA|Pro|Amb|Lev|Mer) (?:Xan|Som|CIA|VAL|VIA|Pro|Amb|Lev|Mer) (?:Xan|Som|CIA|VAL|VIA|Pro|Amb|Lev|Mer)#,
  q#KAM_VIAGRA5,[l=1]# => q#(?aa)(?i)(V [1li|\]] [a&] G R A|VljAG+R+A)#,
  q#LIVE_PORN,[l=1]# => q#(?aa)(?i)\blive .{0,9}(?:fuck(?:ing)?|sex|naked|girls?|virgins?|teens?|porno?)\b#,
  q#LONG_TERM_PRICE,[l=1]# => q#(?aa)(?i)long\W+term\W+(?:target|projected)(?:\W+price)?#,
  q#LOOPHOLE_1,[l=1]# => q#(?aa)(?i)loop-?hole in the banking#,
  q#LOW_PRICE,[l=1]# => q#(?aa)(?i)\blow.{0,4} (?-i:P)rice#,
  q#MALE_ENHANCE,[l=0]# => q#(?aa)(?i)male enhancement#,
  q#MARKETING_PARTNERS,[l=1]# => q#(?aa)(?i)\b(?:marketing|network) partner|\bpartner (?:web)?site#,
  q#MILLION_HUNDRED,[l=1]# => q#(?aa)(?i)Million\s+\S+\s+Hundred#,
  q#MILLION_USD,[l=1]# => q#(?aa)(?i)Million\b.{0,40}\b(?:United States? Dollars?|USD)#,
  q#MONEY_BACK,[l=0]# => q#(?aa)(?i)money back guarantee#,
  q#MORE_SEX,[l=1]# => q#(?aa)(?i)increased?.{0,9}(?:sex|stamina)#,
  q#NOT_ADVISOR,[l=0]# => q#(?aa)(?i)not a registered investment advisor#,
  q#NOT_SPAM,[l=1]# => q#(?aa)(?i)\b(?:(?:this (?:e?-?mail|message)|we) (?:is not|are not|cannot be considered) Spam|ESTE CORREO NO PUEDE SER CONSIDERADO (?:INTRUSIVO|spam)|Diese Nachricht ist KEIN SPAM)#,
  q#NO_MEDICAL,[l=1]# => q#(?aa)(?i)\bno medical exam#,
  q#NO_PRESCRIPTION,[l=1]# => q#(?aa)(?i)N[o0].{1,10}P(?:er|re)scr[i1]pt[i1][o0]n.{1,10}(?:n[e3][e3]d[e3]d|requ[1i]re|n[e3]c[e3]ssary)#,
  q#ONE_TIME,[l=1]# => q#(?aa)(?i)\bone\W+time (?:charge|investment|offer|promotion)#,
  q#ONLINE_PHARMACY,[l=1]# => q#(?aa)(?i)\bonline pharmacy|\b(?:drugs|medications) online#,
  q#PREST_NON_ACCREDITED,[l=1]# => q#(?aa)(?i)prestigi?ous\b.{0,20}\bnon-accredited\b.{0,20}\buniversities#,
  q#PRICES_ARE_AFFORDABLE,[l=1]# => q#(?aa)(?i)\baffordable .{0,10}prices\b#,
  q#REFINANCE_NOW,[l=1]# => q#(?aa)(?i)time to refinance|refinanc\w{1,3}\b.{0,16}\bnow\b#,
  q#REFINANCE_YOUR_HOME,[l=1]# => q#(?aa)(?i)\brefinance your(?: current)? (?:home|house)\b#,
  q#REMOVE_BEFORE_LINK,[l=1]# => q#(?aa)(?i)(?:no thanks|not interested|unsubscribe here).{0,5}http://#,
  q#REPLICA_WATCH,[l=1]# => q#(?aa)(?i)\breplica.{1,20}rolex#,
  q#SHORT_TERM_PRICE,[l=1]# => q#(?aa)(?i)short\W+term\W+(?:target|projected)(?:\W+price)?#,
  q#STOCK_ALERT,[l=1]# => q#(?aa)(?i)\bstock alert#,
  q#STRONG_BUY,[l=0]# => q#(?aa)(?i)strong buy#,
  q#TVD_ACT_193,[l=1]# => q#(?aa)(?i)\bact of (?:193|nineteen thirty)#,
  q#TVD_APPROVED,[l=1]# => q#(?aa)(?i)you.{1,2}re .{0,20}approved#,
  q#TVD_INCREASE_SIZE,[l=1]# => q#(?aa)(?i)\bsize of .{1,20}(?:penis|dick|manhood)#,
  q#TVD_LINK_SAVE,[l=1]# => q#(?aa)(?i)\blink to save\b#,
  q#TVD_PH_REC,[l=1]# => q#(?aa)(?i)\byour .{0,40}account .{0,40}record#,
  q#TVD_PH_SEC,[l=1]# => q#(?aa)(?i)\byour .{0,40}account .{0,40}security#,
  q#TVD_QUAL_MEDS,[l=1]# => q#(?aa)(?i)\bquality med(?:ication)?s\b#,
  q#TVD_SECTION,[l=1]# => q#(?aa)(?i)\bSection (?:27A|21B)#,
  q#TVD_VISIT_PHARMA,[l=1]# => q#(?aa)(?i)Online Ph.rmacy#,
  q#UNCLAIMED_MONEY,[l=1]# => q#(?aa)(?i)\bunclaimed\s(?:assets?|accounts?|mon(?:ey|ies)|balance|funds?|prizes?|rewards?|payments?|deposits?)\b#,
  q#VIA_GAP_GRA,[l=1]# => q#(?aa)(?i)\bvia.gra\b#,
  q#__ACCESS_RESTORE,[l=1]# => q#(?aa)(?i)\bto (?:(?:restore|regain) access|(?:remove|uplift) (?:the|this) suspens|continue using your (?:account|online|mailbox)|zugreifen wiederhergestellt)#,
  q#__ACCESS_REVOKE,[l=1]# => q#(?aa)(?i)(?:(?:temporary|permanent) (?:de-?activation|removal) of your (?:\w{1,30} )?(?:access|account)|Ihre Kreditkarte wird gesperrt)#,
  q#__ACCOUNT_ERROR,[l=1]# => q#(?aa)(?i)\b(?:your account (?:is|appears to be) (?:incorrect|missing|in error|invalid))\b#,
  q#__ACCOUNT_SECURE,[l=1]# => q#(?aa)(?i)\b(?:make your (?:"?[^\@\s]+\@\S+"? |e-?mail )?account more secure|Ihre Kreditkarte weist einige Sicherheitsprobleme)\b#,
  q#__ACCOUNT_UPGRADE,[l=1]# => q#(?aa)(?i)\b(?:upgrade (?:of )your (?:account|access)|your (?:access|account) is[\w\s]{0,40}being upgraded|Weiter zur Aktualisierung)\b#,
  q#__ACH_CANCELLED_02,[l=1]# => q#(?aa)(?i)(?:rejected|cancel+ed|declined|your)[-_ ](?:(?-i:ACH)|direct[-_ ]deposit)[-_ ](?:payment|transfer|transaction|declin(?:ed|ing))#,
  q#__ACH_CANCELLED_03,[l=1]# => q#(?aa)(?i)\bwire[-_ ]?(?:payment|transfer|transaction)[-_ ](?:(?:was|is)[-_ ])?(?:rejected|cancel+ed|declined|disabled|not[-_ ]accepted|(?:technical )?error)#,
  q#__ACH_CANCELLED_04,[l=1]# => q#(?aa)(?i)\bregarding[-_ ]your[-_ ]direct[-_ ]deposit[-_ ]via[-_ ](?-i:ACH)#,
  q#__ADMAIL,[l=1]# => q#(?aa)(?i)(?:\b|_)ad-?(?:mail|message)s?(?:\b|_)#,
  q#__ADMITS_SPAM,[l=1]# => q#(?aa)(?i)\bth(?:e[- ]+above|is)(?:\?+s|[- ]+is)[- ]+(?:intended[- ]+as[- ]+)?an?[- ]+(?:e-?mail[- ]+)?[a@]dvert[i1l]sement\b#,
  q#__ADULTDATINGCOMPANY_BODY,[l=1]# => q#(?aa)(?i)\bAdultDatingCompany\b#,
  q#__AFF_LOTTERY,[l=0]# => q#(?aa)(?i)(?:lottery|winner)#,
  q#__AFR_UNION,[l=1]# => q#(?aa)(?i)\bafrican\sunion\b#,
  q#__AGREED_RATIO,[l=1]# => q#(?aa)(?i)\b(?:agreed|sharing)\s(?:ratios?|percent\w+)\b#,
  q#__AM_DYING,[l=1]# => q#(?aa)(?i)\b(?:am\s(?:\S+\s)?dying|terminally\sill|cancer|en\sphase\sterminale|(?:become|is|devenu|maladie)\sincurable|que\sje\smeurs)\b#,
  q#__AUTO_ACCIDENT,[l=0]# => q#(?aa)(?i)auto(?:mobile)? accident#,
  q#__BACK_SCRATCH,[l=1]# => q#(?aa)(?i)\bmutual+y?\s(?:benefi(?:t|cial)|interest)\b#,
  q#__BANK_DRAFT,[l=1]# => q#(?aa)(?i)\bbank\sdraft#,
  q#__BARRISTER,[l=1]# => q#(?aa)(?i)\b(?:barrister|solicitor at law|barr\.)#,
  q#__BENIN,[l=1]# => q#(?aa)(?i)\bb(?:e|=E9|[\xe9]|[\xc3][\xa9])nin\b#,
  q#__BONUS_LAST_DAY,[l=1]# => q#(?aa)(?i)\b(?:last|final) day of the (?:\$\d+ |\d+ dollars? )?bonus offer(?:ing)?\b#,
  q#__BOUNCE_OOO_B1,[l=1]# => q#(?aa)\bI ?.m away until .{10,20} and am unable to read your message\b#,
  q#__BOUNCE_OOO_B2,[l=1]# => q#(?aa)\bI am currently out of the office\b#,
  q#__BOUNCE_OOO_CB1,[l=1]# => q#(?aa)(?i)\bout of (?:the )?office\b#,
  q#__BOUNCE_OOO_CB2,[l=1]# => q#(?aa)(?i)\bon (?:vacation|holiday)\b#,
  q#__BOUNCE_OOO_CB3,[l=1]# => q#(?aa)(?i)\bolen lomalla\b#,
  q#__BOUNCE_OOO_CB4,[l=1]# => q#(?aa)(?i)\breturn to (?:the )?office\b#,
  q#__BTC_OBFU_5,[l=0]# => q#(?aa)(?i)&[hash]x62;&[hash]x69;&[hash]x74;&[hash]x63;&[hash]x6F;&[hash]x69;&[hash]x6E;#,
  q#__BURKINA_FASO,[l=1]# => q#(?aa)(?i)\bburkina\s?faso\b#,
  q#__CAN_HELP,[l=1]# => q#(?aa)(?i)\bcan help\b#,
  q#__CASHPRZ,[l=1]# => q#(?aa)cash prize of#,
  q#__CHARITY,[l=1]# => q#(?aa)(?i)\b(?:charit(?:y|[ai]ble)|orphans?|homeless|orphelins|sans\sabri)\b#,
  q#__COMPENSATION,[l=1]# => q#(?aa)(?i)\b(?:compensat(?:e|ion)|recompensed?|ausgleich)\b#,
  q#__CONTACT_ATTY,[l=1]# => q#(?aa)(?i)\bcontact(?:er)?\s(?:my|(?:de\s)?mon)\s(?:barrister|attou?rney|lawyer|avocat|gestionnaire)\b#,
  q#__CONTACT_YOU,[l=1]# => q#(?aa)(?i)\b(?:contact(?:ing)\syou|vous\scontacter?)\b#,
  q#__COURIER,[l=1]# => q#(?aa)(?i)\bcourier\s(?:company|service)\b#,
  q#__DAY_I_EARNED,[l=1]# => q#(?aa)(?i)day,?\sI\s(?:earned|got|received|made|brought\sin)\s\$\s?\d{3}#,
  q#__DBLCLAIM,[l=1]# => q#(?aa)avoid double claiming#,
  q#__DEAL,[l=1]# => q#(?aa)(?i)\b(?:(?:business|financial|this|the|mutual|die(?:se)?r?|cette|profitable)\s(?:deal|transa[ck]tion|proposal|off[er]{2}|venture|suggestion|partnership)|your\spartnership)#,
  q#__DECEASED,[l=1]# => q#(?aa)(?i)\b(?:the|my|your|der|du|le|meu?)\s(?:deceased|late|verstorbenen|d(?:i|e|=E9|[\xe9]|[\xc3][\xa9])funto?|d(?:e|=E9|[\xe9]|[\xc3][\xa9])nt|falecido)\b#,
  q#__DESTROY_ME,[l=1]# => q#(?aa)(?i)\b(?:destroy|hunt|quemar)\sm[eyi]\b#,
  q#__DESTROY_YOU,[l=1]# => q#(?aa)(?i)\b(?:destroy\syou|deine Zukunft zerst\S{1,3}ren)#,
  q#__DIED_IN,[l=1]# => q#(?aa)(?i)\bdied\sin\b#,
  q#__DIPLOMATIC,[l=1]# => q#(?aa)(?i)\bdiplomatic\b#,
  q#__DLND_ATTACH,[l=1]# => q#(?aa)(?i)\bdownload\sthe\sattach(?:ed|ment)\b#,
  q#__DORMANT_ACCT,[l=1]# => q#(?aa)(?i)\b(?:(?:dormant|abandoned|left\s?over)\s(?:account|fund|transaction|sum|deposit)|fonds\sdorment)#,
  q#__DOS_BODY_FRI,[l=1]# => q#(?aa)(?i)\bfri(?:day)?\b#,
  q#__DOS_BODY_MON,[l=1]# => q#(?aa)(?i)\bmon(?:day)?\b#,
  q#__DOS_BODY_SAT,[l=1]# => q#(?aa)(?i)\bsat(?:day)?\b#,
  q#__DOS_BODY_STOCK,[l=1]# => q#(?aa)(?i)\bstock\b#,
  q#__DOS_BODY_SUN,[l=1]# => q#(?aa)(?i)\bsun(?:day)?\b#,
  q#__DOS_BODY_THU,[l=1]# => q#(?aa)(?i)\bthu(?:r(?:s(?:day)?)?)?\b#,
  q#__DOS_BODY_TICKER,[l=1]# => q#(?aa)\b[A-Z]{4}\.(?:OB|PK)\b#,
  q#__DOS_BODY_TUE,[l=1]# => q#(?aa)(?i)\btue(?:s(?:day)?)?\b#,
  q#__DOS_BODY_WED,[l=1]# => q#(?aa)(?i)\bwed(?:nesday)?\b#,
  q#__DOS_CORRESPOND_EMAIL,[l=1]# => q#(?aa)correspond with me using my email#,
  q#__DOS_DROP_ME_A_LINE,[l=1]# => q#(?aa)Drop me a line at#,
  q#__DOS_EMAIL_DIRECTLY,[l=1]# => q#(?aa)(?:Email m[a-z]?e|address) direc(?:tl|lt)y at#,
  q#__DOS_FIN_ADVANTAGE,[l=1]# => q#(?aa)(?i)\bfinancial advantage#,
  q#__DOS_I_AM_25,[l=1]# => q#(?aa)I a.?m 25#,
  q#__DOS_I_DRIVE_A,[l=1]# => q#(?aa)I drive a#,
  q#__DOS_LET_GO_JOB,[l=1]# => q#(?aa)I was (?:let go|fired|layed off|dismissed) from a job I h(?:el|a)d for (?:2\d years|\d{3} months)#,
  q#__DOS_LINK,[l=1]# => q#(?aa)\blink\b#,
  q#__DOS_MEET_EACH_OTHER,[l=1]# => q#(?aa)(?:meet each other|[Mm]ay ?be we can meet)#,
  q#__DOS_MY_OLD_JOB,[l=1]# => q#(?aa)my old job#,
  q#__DOS_PERSONAL_EMAIL,[l=1]# => q#(?aa)personal email at#,
  q#__DOS_STEADY_COURSE,[l=1]# => q#(?aa)(?i)\bsteady (?:and increasing )?course\b#,
  q#__DOS_STRONG_CF,[l=1]# => q#(?aa)(?i)\bstrong cash flow#,
  q#__DOS_TAKING_HOME,[l=1]# => q#(?aa)Taking home \d (?:digit level|figures) in \d{1,2} months#,
  q#__DOS_WRITE_ME_AT,[l=1]# => q#(?aa)[Ww].?r.?i.?t.?e me at#,
  q#__DRUGS_ANXIETY2,[l=1]# => q#(?aa)(?i)\bAlprazolam\b#,
  q#__DRUGS_ANXIETY8,[l=1]# => q#(?aa)(?i)\bklonopin\b#,
  q#__DRUGS_ANXIETY9,[l=1]# => q#(?aa)(?i)\brivotril\b#,
  q#__DRUGS_ANXIETY_VAL,[l=0]# => q#(?aa)(?i)valium#,
  q#__DRUGS_ANXIETY_XAN,[l=1]# => q#(?aa)(?i)xan[ae]x#,
  q#__DRUGS_DIET3,[l=1]# => q#(?aa)(?i)\bbontril\b#,
  q#__DRUGS_DIET4,[l=1]# => q#(?aa)(?i)\bphendimetrazine\b#,
  q#__DRUGS_DIET5,[l=1]# => q#(?aa)(?i)\bdiethylpropion\b#,
  q#__DRUGS_DIET_PHEN,[l=1]# => q#(?aa)(?i)\bphentermine\b#,
  q#__DRUGS_ERECTILE2,[l=1]# => q#(?aa)(?i)\bV(?:agira|igara|iaggra|iaegra)\b#,
  q#__DRUGS_ERECTILE4,[l=1]# => q#(?aa)(?i)\bC(?:alis|ilias|ilais)\b#,
  q#__DRUGS_ERECTILE5,[l=1]# => q#(?aa)(?i)\b_{0,3}s[_\W]?[i1!|l\xEC-\xEF][_\W]?l[_\W]?d[_\W]?[e3\xE8-\xEB][_\W]?n[_\W]?[a4\xE0-\xE6@][_\W]?f[_\W]?[i1!|l\xEC-\xEF][_\W]?l c[_\W]?[i1!|l\xEC-\xEF][_\W]?t[_\W]?r[_\W]?[a4\xE0-\xE6@][_\W]?t[_\W]?[e3\xE8-\xEB]_{0,3}(?:\b|\s)#,
  q#__DRUGS_ERECTILE_C,[l=1]# => q#(?aa)(?i)\bCialis(?!\xc3\xa9|\xe9)\b#,
  q#__DRUGS_ERECTILE_L,[l=1]# => q#(?aa)(?i)\bLevitra\b#,
  q#__DRUGS_ERECTILE_V,[l=1]# => q#(?aa)(?i)\bViagra\b#,
  q#__DRUGS_MUSCLE2,[l=1]# => q#(?aa)(?i)\b_{0,3}cycl[o0\xF2-\xF6]b[e3\xE8-\xEB]nz[a4\xE0-\xE6@]pr[i1!|l\xEC-\xEF]n[e3\xE8-\xEB]_{0,3}(?:\b|\s)#,
  q#__DRUGS_MUSCLE5,[l=1]# => q#(?aa)(?i)\bskelaxin\b#,
  q#__DRUGS_PAIN11,[l=1]# => q#(?aa)(?i)\bzebutal\b#,
  q#__DRUGS_PAIN12,[l=1]# => q#(?aa)(?i)\besgic plus\b#,
  q#__DRUGS_PAIN2,[l=1]# => q#(?aa)(?i)\b_{0,3}c[o0\xF2-\xF6]deine_{0,3}\b#,
  q#__DRUGS_PAIN_VICO,[l=0]# => q#(?aa)(?i)vicodin#,
  q#__DRUGS_PAIN_VIOXX,[l=0]# => q#(?aa)(?i)vioxx#,
  q#__EARLY_DEMISE,[l=1]# => q#(?aa)(?i)\buntimely\sdeath\b#,
  q#__FAILED_LOGINS,[l=1]# => q#(?aa)(?i)unsuc+es+ful log-?[io]n at+empts#,
  q#__FB_COST,[l=1]# => q#(?aa)(?i)\bcost\b#,
  q#__FB_S_STOCK,[l=1]# => q#(?aa)(?i)\bstock#,
  q#__FB_TOUR,[l=1]# => q#(?aa)(?i)\btour#,
  q#__FEES,[l=1]# => q#(?aa)(?i)\b(?:security|safe\w*|courier|registration|pay|paid|up-?front|processing|delivery|transfer|keeping)[\s\w]{0,15}\s(?:fee|charge)s?\b#,
  q#__FOR_SALE_LTP,[l=1]# => q#(?aa)(?i)00\.? (?:less 10%|LTP)#,
  q#__FOR_SALE_NET,[l=1]# => q#(?aa)(?i)00\.? NET#,
  q#__FOR_SALE_OBO,[l=1]# => q#(?aa)(?i)\bor best offer\b#,
  q#__FOR_SALE_PRC_100K,[l=1]# => q#(?aa)(?i)\bprice:? \$\d\d\d,\d\d\d#,
  q#__FOR_SALE_PRC_10K,[l=1]# => q#(?aa)(?i)\bprice:? \$\d\d,\d\d\d#,
  q#__FOR_SALE_PRC_1K,[l=1]# => q#(?aa)(?i)\bprice:? \$\d,?\d\d\d[.\s]#,
  q#__FOUND_YOU,[l=1]# => q#(?aa)(?i)\b(?:I|we)\sfound\syour?\b#,
  q#__FRAUD,[l=1]# => q#(?aa)(?i)\b(?:de)?fraud#,
  q#__FRAUD_AON,[l=1]# => q#(?aa)(?i)\b(?:confidential|private|alternate|alternative) (?:(?:e-? *)?mail)\b#,
  q#__FRAUD_AUM,[l=1]# => q#(?aa)(?i)\bthe desk of\b#,
  q#__FRAUD_AXF,[l=0]# => q#(?aa)(?i)magnanimity#,
  q#__FRAUD_BEP,[l=1]# => q#(?aa)(?i)\b(?:bank of nigeria|central bank of|trust bank|apex bank|amalgamated bank)\b#,
  q#__FRAUD_BGP,[l=1]# => q#(?aa)(?i)\battached to ticket number\b#,
  q#__FRAUD_CKF,[l=0]# => q#(?aa)(?i)computer ballot system#,
  q#__FRAUD_DPR,[l=1]# => q#(?aa)(?i)\b(?:(?:respond|reply) (?:urgently|immediately)|(?:urgent|immediate|earliest) (?:reply|response))\b#,
  q#__FRAUD_ETX,[l=1]# => q#(?aa)(?i)\byour\b[^.]{0,99}\b(?:contact (?:details|information)|private (?:e?[- ]?mail|telephone|tel|phone|fax))\b#,
  q#__FRAUD_EZY,[l=1]# => q#(?aa)(?i)\b(?:of|the) late president\b#,
  q#__FRAUD_FBI,[l=1]# => q#(?aa)(?i)\bdisburs#,
  q#__FRAUD_FCW,[l=0]# => q#(?aa)(?i)fiduciary agent#,
  q#__FRAUD_FVU,[l=0]# => q#(?aa)(?i)award notification#,
  q#__FRAUD_GBW,[l=1]# => q#(?aa)(?i)god gives .{1,10}second chance#,
  q#__FRAUD_IOU,[l=1]# => q#(?aa)(?i)\b(?:no risks?|risk-? *free|free of risks?|100% safe)\b#,
  q#__FRAUD_IOV,[l=1]# => q#(?aa)(?i)\b(?:no risks?|risky?[- ]{0,3}free|free of risks?|100% safe|v\S{1,3}llig Risikofrei ist)\b#,
  q#__FRAUD_IPK,[l=1]# => q#(?aa)(?i)\b(?:in|to|visit) your country\b#,
  q#__FRAUD_IRJ,[l=0]# => q#(?aa)(?i)(?:finance|holding|securit(?:ies|y)) (?:company|firm|storage house)#,
  q#__FRAUD_IRT,[l=1]# => q#(?aa)(?i)\b(?:compliments? of the|dear friend|dear sir|yours faithfully|season'?s greetings)\b#,
  q#__FRAUD_JBU,[l=1]# => q#(?aa)(?i)\bforeign account\b#,
  q#__FRAUD_JNB,[l=1]# => q#(?aa)(?i)\boperat(?:e|ing)\b[^.]{0,99}\b(?:for(?:ei|ie)gn|off-? ?shore|over-? ?seas?) (?:bank )?accounts?\b#,
  q#__FRAUD_JYG,[l=1]# => q#(?aa)(?i)\bgive\s+you .{0,15}(?:fund|money|total|sum|contact|percent)\b#,
  q#__FRAUD_KJV,[l=0]# => q#(?aa)(?i)(?:claim|concerning) (?:the|this) money#,
  q#__FRAUD_LTX,[l=1]# => q#(?aa)(?i)\bmilli?on (?:.{1,25} thousand\s*)?(?:(?:united states|u\.?s\.?) dollars|(?i:U\.?S\.?D?))\b#,
  q#__FRAUD_MCQ,[l=1]# => q#(?aa)(?i)\btransaction\b.{1,30}\b(?:magnitude|diplomatic|strict|absolute|secret|confiden(?:tial|ce)|guarantee)#,
  q#__FRAUD_MLY,[l=1]# => q#(?aa)(?i)\b(?:reply|respond)\b[^.]{0,50}\b(?:to|through)\b[^.]{0,50}\@\b#,
  q#__FRAUD_MQO,[l=0]# => q#(?aa)(?i)foreign (?:business partner|customer)#,
  q#__FRAUD_NEB,[l=0]# => q#(?aa)(?i)(?:government|bank) of nigeria#,
  q#__FRAUD_NRG,[l=0]# => q#(?aa)(?i)i am contacting you#,
  q#__FRAUD_PTS,[l=1]# => q#(?aa)(?i)\b(?:ass?ass?inat(?:ed|ion)|murder(?:e?d)?|kill(?:ed|ing)\b[^.]{0,99}\b(?:war veterans|rebels?))\b#,
  q#__FRAUD_PTX,[l=1]# => q#(?aa)(?i)\b(?:ass?ass?inat(?:ed|ion)|murder(?:e?d)?|poison(?:e?d)?|kill(?:ed|ing|ers)\b[^.]{0,99}\b(?:war veterans|rebels?)|les tueurs)\b#,
  q#__FRAUD_PVN,[l=0]# => q#(?aa)(?i)as the beneficiary#,
  q#__FRAUD_QFY,[l=1]# => q#(?aa)(?i)\bover-? *(?:invoiced?|cost(?:s|ing)?)\b#,
  q#__FRAUD_QXX,[l=1]# => q#(?aa)(?i)\b(?:my name is|i am) (?:mrs?|engr|barrister|dr|prince(?:ss)?)[. ]#,
  q#__FRAUD_RLX,[l=1]# => q#(?aa)(?i)lott(?:o|ery) (?:co,?ordinator|international)#,
  q#__FRAUD_SNT,[l=1]# => q#(?aa)(?i)\blocate(?: .{1,20})? extended relative#,
  q#__FRAUD_TCC,[l=0]# => q#(?aa)(?i)foreign (?:offshore )?(?:bank|account)#,
  q#__FRAUD_TDP,[l=1]# => q#(?aa)(?i)\b(?:business partner(?:s|ship)?|silent partner(?:s|ship)?)\b#,
  q#__FRAUD_THJ,[l=0]# => q#(?aa)(?i)modalit(?:y|ies)#,
  q#__FRAUD_ULK,[l=1]# => q#(?aa)(?i)\baffidavits?\b#,
  q#__FRAUD_UOQ,[l=0]# => q#(?aa)(?i)vital documents#,
  q#__FRAUD_UUY,[l=1]# => q#(?aa)(?i)\blegitimate business(?:es)?\b#,
  q#__FRAUD_WDR,[l=1]# => q#(?aa)(?i)\bprivate lawyer\b#,
  q#__FRAUD_WFC,[l=1]# => q#(?aa)(?i)\bsecur(?:e|ing) (?:the )?(?:funds?|monies)\b#,
  q#__FRAUD_WNY,[l=1]# => q#(?aa)(?i)\b(?:disburse?(?:ment)?|incurr?(?:ed)?|remunerr?at(?:ed?|ion)|remm?itt?(?:ed|ance|ing)?)\b#,
  q#__FRAUD_XJR,[l=0]# => q#(?aa)(?i)(?:who was a|as a|an? honest|you being a|to any) foreigner#,
  q#__FRAUD_XVW,[l=1]# => q#(?aa)(?i)\bhonest cooperation\b#,
  q#__FRAUD_XWW,[l=1]# => q#(?aa)(?i)\b(?:honest(?:ly)?\sco(?:-?operat(?:e|ion)|llaborat(?:e|ion))|ehrliche\szusammenarbeit|sichere [kc]o+p[eo]ration|col+aboration\swith\sme)\b#,
  q#__FRAUD_YJA,[l=0]# => q#(?aa)(?i)over-invoice#,
  q#__FRAUD_YPO,[l=0]# => q#(?aa)(?i)the total sum#,
  q#__FRAUD_YQV,[l=0]# => q#(?aa)(?i)nigerian? (?:national|government)#,
  q#__FRAUD_YWW,[l=1]# => q#(?aa)(?i)\bfurnish you with\b#,
  q#__FRAUD_ZFJ,[l=1]# => q#(?aa)(?i)\b(?:wife|son|brother|daughter) of the late\b#,
  q#__GAPPY_SALES_LEADS,[l=1]# => q#(?aa)(?i)\b(?:business|e?-?mail|your|marketing|advertising)\s(?!sales|leads|campaign)(?:s\s?a\s?l\s?e\s?s|l\s?e\s?a\s?d\s?s|c\s?a\s?m\s?p\s?a\s?i\s?g\s?n)\b#,
  q#__GB_FAKE_DOCUSIGNB,[l=1]# => q#(?aa)(?i)review(?:\s+|\_)document|view (completed\s+)?document#,
  q#__GHANA,[l=1]# => q#(?aa)(?i)\bghana\b#,
  q#__HAS_WON_01,[l=1]# => q#(?aa)(?i)\bque ha ganado\b#,
  q#__HELLO_EMAILADDR_COM,[l=1]# => q#(?aa)Hello,\s+\w+\@(?:\w+\.\s*)+(?i:com)#,
  q#__HK_LOTTO_2,[l=1]# => q#(?aa)(?i)\blot(?:eri[ej]|t(?:ery|o)) ?(?:(?:inter)?national|foundation|mercato|univers|euro ?million|e-?mail|euro-pw|bill ?gates|swiss|prestige|cristal|am.ricaine|coca.?cola|fiduciary|department)#,
  q#__HK_LOTTO_BALLOT,[l=1]# => q#(?aa)(?i)\b(?:promotional|on.?line|computer|internet|e-?mail|fran.aise) (?:ballot|draw|sweepstake)#,
  q#__HK_LOTTO_STAATS,[l=1]# => q#(?aa)(?i)\bstaatsloteri#,
  q#__HK_SCAM_N15,[l=1]# => q#(?aa)(?i)\b(?:account (?:overseas?|offshore)|(?:overseas?|offshore) account)\b#,
  q#__HK_SCAM_N16,[l=1]# => q#(?aa)(?i)\b(?:arrangement secret|secret arrangement)\b#,
  q#__HK_SCAM_N2,[l=1]# => q#(?aa)(?i)\bnext of kin\b#,
  q#__HK_SCAM_N3,[l=1]# => q#(?aa)(?i)\bdirect telephone numbers?\b#,
  q#__HK_SCAM_N8,[l=1]# => q#(?aa)(?i)\byour compensation\b#,
  q#__HK_SCAM_S1,[l=0]# => q#(?aa)(?i)pay you the sum of#,
  q#__HK_SCAM_S15,[l=0]# => q#(?aa)(?i)(?:discovered a dormant account|can you be my partner)#,
  q#__HK_SCAM_S25,[l=1]# => q#(?aa)(?i)\bbank (?:in|of) ghana#,
  q#__HUSH_HUSH,[l=1]# => q#(?aa)(?i)\b(?:confiden[tc]i[ae]l(?:\b|ity\b|it(?:=E9|[\xe9]|[\xc3][\xa9]))|private\b|secr[e\xe8](?:te?|cy)\b|sensitive\b|concealed\b|obscured?\b|discre(?:et|tion)\b|very\sdiscrete|top\ssecret|vertraulich(?:en)?\b|geheim\b|priv(?:e|=E9|[\xe9]|[\xc3][\xa9]))#,
  q#__INHERIT_PMT,[l=1]# => q#(?aa)(?i)\binheritance\spayment\s#,
  q#__INTL_BANK,[l=1]# => q#(?aa)(?i)\b(?:international\s(?:\w+\s)?bank|banque\sinternationale)\b#,
  q#__INVEST_COUNTRY,[l=1]# => q#(?aa)(?i)\binvest\sin\syour?\scountry\b#,
  q#__INVEST_MONEY,[l=1]# => q#(?aa)(?i)\binvest(?:ir)?\s(?:this|ces|d[ae]s|sur ce|de ces)\s(?:money|f[ou]nds?)\b#,
  q#__ISO_2022_JP_DELIM,[l=1]# => q#(?aa)\e\$B#,
  q#__IVORY_COAST,[l=1]# => q#(?aa)(?i)\b(?:Cote\s?D.Ivoire|Ivory\s?Coast|Costa\sde\sMarfil)\b#,
  q#__I_INHERIT,[l=1]# => q#(?aa)(?i)\b(?:I|eu)\s[a-z\s]{0,30}(?:inherited|herdei)\b#,
  q#__I_WILL_YOU,[l=1]# => q#(?aa)(?i)\bwill(?:ed)?\s(?:[a-z\s]{0,20}(?:fortune|money|\$[\d,]+[a-z]{0,9})\s)?to\syou\b#,
  q#__JAPANESE_UCE_BODY,[l=1]# => q#(?aa)(?:L\$>5Bz|EE;R%a!<%k)(?:8x|9-)9p#,
  q#__JMQ_DROPBOX3,[l=1]# => q#(?aa)(?i)ach.(payment|transfer)#,
  q#__JMQ_HEARINGLOSS3,[l=1]# => q#(?aa)(?i)going.crazy|natural.formula|restore.your.hearing|click.here.to.see|off.hearing.aid|mineral to restore#,
  q#__JMQ_IMPORTANT2,[l=0]# => q#(?aa)(?i)important message#,
  q#__JMQ_IMPORTANT3,[l=0]# => q#(?aa)(?i)please visit#,
  q#__JMQ_PICKUP2,[l=1]# => q#(?aa)(?i)(dirty|freaky|naughty|good)(pix|pic)|hey.cutie#,
  q#__JMQ_PICKUP4,[l=1]# => q#(?aa)(?i)\d+.year.old|female#,
  q#__JMQ_REALESTATE3,[l=1]# => q#(?aa)(?i)preferred.choice|looking.for.real.estate|online.platform|systems.placement#,
  q#__JMQ_RESUME2,[l=0]# => q#(?aa)(?i)hello my name|my name is#,
  q#__JMQ_RESUME3,[l=1]# => q#(?aa)(?i)appreciate.your.cooperation|my.resume.is.pdf|resume.attach|pdf.file.is|is.my.resume#,
  q#__JMQ_TRACKR3,[l=1]# => q#(?aa)(?i)locate anything|find.anything|never.lose.anything|new.invention|never.lose.your|tired.of.losing|find.any.lost#,
  q#__JMQ_WIRE2,[l=1]# => q#(?aa)(?i)medical.support|payment.sent#,
  q#__JMQ_WIRE3,[l=1]# => q#(?aa)(?i)bank.wire|sent.out.asap#,
  q#__KAM_1LINE1,[l=1]# => q#(?aa)(?is)(free score and report|Did you overpay\?)#,
  q#__KAM_2020_2,[l=1]# => q#(?aa)(?i)printed in the US|stink stank stunk|officially licensed|star wars|funny (guinea pig|science|tee|teacher|fishing|halloween)|\d+ designs|let.?s go brandon|blood of jesus|support truckers|freedom convoy#,
  q#__KAM_2ND_1,[l=1]# => q#(?aa)(?i)police can no longer be trusted|protect yourself|anti-?gun ban|no classes#,
  q#__KAM_2ND_2,[l=0]# => q#(?aa)(?i)2nd am?mendment|concealed carry|right to carry#,
  q#__KAM_ABOUT2,[l=0]# => q#(?aa)(?i)Spyware#,
  q#__KAM_ACCOUNTPHISH3,[l=1]# => q#(?aa)(?i)update.your.information|problems.with.your|billing.information|order.details|personal.data|detailed.order|order.information|for.activation|account.{1,30}.inactive|information.required|secure.browser|recently.compromised|classified.document|with.your.email|complete.your.account|account.confirmed|claim.your.order|free.money|forced.to.cancel|immediate.access|upgrading.all.staff|advice.to.update|confirm.your.account#,
  q#__KAM_ACCOUNTPHISH4,[l=1]# => q#(?aa)(?i)webmail|all.systems|storage.limit|get.back.into|update.your.account|kindly.click|very.private.message|this.is.honest|fill.the.form|click.on.send|follow.here|for.all.user|one.click.away|mail.desk#,
  q#__KAM_ACNE3,[l=0]# => q#(?aa)(?i)proactiv#,
  q#__KAM_ACNE4,[l=0]# => q#(?aa)(?i)Online Gift Rewards#,
  q#__KAM_ADHD3,[l=0]# => q#(?aa)(?i)struggling with adh?d|treatment options#,
  q#__KAM_ADMIN3,[l=0]# => q#(?aa)(?i)next tax return#,
  q#__KAM_ADMIN4,[l=0]# => q#(?aa)(?i)read this document#,
  q#__KAM_ADVANCE2,[l=0]# => q#(?aa)(?i)Advance Details#,
  q#__KAM_ADVANCE3,[l=0]# => q#(?aa)(?i)Pre\-Approved#,
  q#__KAM_ADVERT1,[l=1]# => q#(?aa)(?is)email advertising|\d{3}%.roi#,
  q#__KAM_ADVERT2,[l=1]# => q#(?aa)(?is)instant traffic (to your website|and sales)|demand.generation#,
  q#__KAM_ADVERT3,[l=1]# => q#(?aa)(?is)Email Ad Broadcast|Double OPT IN list|making.some.changes#,
  q#__KAM_ADVERTISE3,[l=1]# => q#(?aa)(?i)advertising.for.samsung|no.application.fee|carry.this.advert#,
  q#__KAM_ADVIDS2,[l=0]# => q#(?aa)(?i)video (production|examples|ads|design|ideas)|design explainer|design capabilit|(business|demo) video#,
  q#__KAM_ADVIDS4,[l=0]# => q#(?aa)(?i)(video|content) (director|producer)#,
  q#__KAM_AI_SOCIAL_AGENTS1,[l=0]# => q#(?aa)(?i)Written by AI Social Agents#,
  q#__KAM_ALARM2,[l=1]# => q#(?aa)(?i)free Quote|burglaries|wireless.security.camera|(Guard|protect) Your Family|ADT is Number One|monitored security system|install from ADT|with ADT security|keep(ing)?.your.home.safe|home.is.your.castle|sleep.with.security|home.security.system|remote.access|video.security#,
  q#__KAM_ALERT3,[l=0]# => q#(?aa)(?i)help button#,
  q#__KAM_ALLSCRIPTS4,[l=0]# => q#(?aa)(?i)membership|recurring monthly#,
  q#__KAM_ALT1,[l=1]# => q#(?aa)(?is)reply to my alternative E-?mail#,
  q#__KAM_ANA1,[l=1]# => q#(?aa)(?i)(anatrim|Green ?Tea|cortitherm|PHENTERTHIN|Phentremine|Acai Ultra|Civ\-xR|WuYi Tea|Wu\-?Yi Source|FRS Healthy Energy|Acai Berry|Chinese secret|Ephedra|Cholestapro|ColonMedic|Pure Cleanse|AcaiBurn|Acai Elite|Garcinia|Chlorogenic Acid|green coffee)#,
  q#__KAM_ANALYTICO2,[l=0]# => q#(?aa)(?i)Training Manager#,
  q#__KAM_ANALYTICO3,[l=0]# => q#(?aa)(?i)Analytico Academy#,
  q#__KAM_ANATA3,[l=0]# => q#(?aa)(?i)Doctor (expose|shock|fix)|conglomerates threatening#,
  q#__KAM_ANCESTOR3,[l=1]# => q#(?aa)(?i)family.history|your family|share.the.stories#,
  q#__KAM_ANDROGEL3,[l=1]# => q#(?aa)(?i)healthcare|medwatch|drug|testosterone|therapy|manhood|your.woman#,
  q#__KAM_AP3,[l=0]# => q#(?aa)(?i)American Grants and Loans Catalog#,
  q#__KAM_APP2,[l=0]# => q#(?aa)(?i)IT Based company#,
  q#__KAM_APP3,[l=0]# => q#(?aa)(?i)App devel#,
  q#__KAM_APP4,[l=1]# => q#(?aa)(?i)pocket.?friendly#,
  q#__KAM_APP5,[l=0]# => q#(?aa)(?i)requirements in detail#,
  q#__KAM_APPDEV2,[l=1]# => q#(?aa)(?i)(companies|company|based) in India|Indian.?Based|Rani$|(handyman|fitness|Entertainment|Shopping|hospital|real.?estate|Taxi|custom business|store|booking|lifestyle|ecommerce|ios|game|gaming|Web) App|App and Website Devel|are you looking for responsive mobile app#,
  q#__KAM_APPDEV3,[l=1]# => q#(?aa)(?i)My name is|chance to review my (previous )?email|I work with \d+\+ experienced IT|if you are interested|chance to peruse through it|interested in developing a mobile app|are you trying to find apps|wondering if you wanted an app|connect you with the right person|company with over \d+ years of experience|We specialize in high\-quality android|looking for creating an app#,
  q#__KAM_APPDEV4,[l=1]# => q#(?aa)(?i)app develop(ment|er)|app for your domain|best mobile app devel|app development manager|app development service|develop your web project|apps for your company|experts in app.?dev|build a mobile? app|apps we have successfully developed|mobile apps and game devel|apps development manager#,
  q#__KAM_APPDEV5,[l=0]# => q#(?aa)(?i)mobile app price list|cost efficient|price list \& sample|catalog price|meeting to discuss details|share ballpark estimat|share your requirement|discuss the further steps|see our portfolio|portfolio and pricing|send you our price|price list|requirement, please do share|(let me know|discuss) your requirements|send you more details on (sample|package|portfolio)|offer a detailed pric|hear more about project req|forward you our price \& latest work|app prices? list|we can discuss pricing#,
  q#__KAM_AQUA1,[l=1]# => q#(?aa)(?is)Aqua Globe#,
  q#__KAM_AQUA2,[l=1]# => q#(?aa)(?is)watering your plants#,
  q#__KAM_AQUA3,[l=1]# => q#(?aa)(?is)while on vacation#,
  q#__KAM_AQUARUG3,[l=1]# => q#(?aa)(?i)stop.slipping|unique.carpet|aqua.rug|bare.feet.love#,
  q#__KAM_ARREST2,[l=1]# => q#(?aa)(?i)Instant Checkmate|dirty Truth|\brapist\b|criminal.(background|record)|predator|stay.safe|child.offender|think.you.know|know.everything|database.screening|know.something|wanted.to.know|arrest.record#,
  q#__KAM_ASIAN2,[l=1]# => q#(?aa)(?i)Adoring Asian|(\d\+|thousands of) Asian (women|Girls)|Asian Girlfriend|pics of hot|date an? asian|chat and cam#,
  q#__KAM_ASSASSIN2,[l=0]# => q#(?aa)(?i)my identity#,
  q#__KAM_ASSASSIN3,[l=0]# => q#(?aa)(?i)assassinate#,
  q#__KAM_ASSASSIN4,[l=1]# => q#(?aa)(?i)like.an.accident#,
  q#__KAM_ATTORNEY3,[l=1]# => q#(?aa)(?i)find.a.\b[a-z]+\b.attorney#,
  q#__KAM_AUGER2,[l=0]# => q#(?aa)(?i)Awesome Auger#,
  q#__KAM_AUTO3,[l=1]# => q#(?aa)(?i)(car|truck).dealer|clearance.price|shop.cars|\d+.vehicles|dealership|deep.discount|liquidating|vehicle.options|auto.news|old.clunker|dream.car|clearance.inventory|dealer.clearance|special.clearance|auto(mobile?).recall|clearance.pric|new.ride|dealers.{1,40}.scrambling|sell.yours.for.more|car.is.worth|auto.parts.brand|blowout|incredible.discount#,
  q#__KAM_AUTONEW2,[l=1]# => q#(?aa)(?i)car.{1,2}insurance.{1,2}payment|monthly.payment|plan.has.expired|auto.loan|auto.coverage|coverage.benefits|premium.reduc|compare.quote|financing.your.way#,
  q#__KAM_AUTONEW3,[l=1]# => q#(?aa)(?i)just.{1,2}been.{1,2}lowered|reduced.recently|has been reduced|free.repair|easy.steps|overpaying|view.plan|overpaid.your|premiums?.as.low|lenders.compete#,
  q#__KAM_BACK1,[l=1]# => q#(?aa)(?i)backgrounds in seconds|Instant..?Checkmate|federal.record|background.report|reputation#,
  q#__KAM_BACK2,[l=1]# => q#(?aa)(?is)(Property & Personal history|Asset & Background) (Investigation|Search)|check anyone|know.anything|registered.offense|their.name|publicly.available#,
  q#__KAM_BACK3,[l=1]# => q#(?aa)(?is)(background check|detective|investigator|investigate backgrounds|arrest.record|public.record)|remain.anonymous|anonymous.report|says.about.you|instant.database|the.truth|reveal.the.information|screening.services#,
  q#__KAM_BACKUP3,[l=1]# => q#(?aa)(?i)backup.necessary|marketing|infographic|charge.more#,
  q#__KAM_BADCRED_1,[l=0]# => q#(?aa)(?i)bad credit#,
  q#__KAM_BADUNSUB,[l=0]# => q#(?aa)(?i)(?:remove|Unsubscribe) from (?:MindTCommunications|LunarMessages)#,
  q#__KAM_BADZIP1,[l=0]# => q#(?aa)(?i)attached (to email|document)|take a look|send this fax#,
  q#__KAM_BADZIP2,[l=0]# => q#(?aa)(?i)Encrypted zip|File password#,
  q#__KAM_BADZIP3,[l=0]# => q#(?aa)(?i)(order|urgent|report|dialogue|reminder)#,
  q#__KAM_BADZIP4,[l=0]# => q#(?aa)(?i)password:#,
  q#__KAM_BAD_CANVA2,[l=0]# => q#(?aa)(?i)link will not work for only recipients#,
  q#__KAM_BAD_PRODUCT2,[l=0]# => q#(?aa)(?i)Dolphin sealer|hotstreak plug|Rapid thaw tray#,
  q#__KAM_BAD_REVIEW2,[l=0]# => q#(?aa)(?i)Reputation Giant#,
  q#__KAM_BAD_SCAN1,[l=1]# => q#(?aa)(?i)scanned from MFP|\(\d+\) scanned#,
  q#__KAM_BANK_2,[l=0]# => q#(?aa)(?i)beneficiary|agent|investment group|deceased|\x{C3}\x{A9}viter tout inconv\x{C3}\x{A9}nient#,
  q#__KAM_BANK_3,[l=1]# => q#(?aa)(?i)re\-?verification|clearance tax|possible funding|same last name|nominated bank account|mes informations bancaires#,
  q#__KAM_BARK1,[l=1]# => q#(?aa)(?i)Bark.Off|petzoom sonic|comfy control harness|dogs? behavior|four legged#,
  q#__KAM_BEAUTY1,[l=1]# => q#(?aa)(?i)she now looks \d+#,
  q#__KAM_BEAUTY2,[l=0]# => q#(?aa)(?i)reveals exactly#,
  q#__KAM_BEAUTY3,[l=0]# => q#(?aa)(?i)most amazing transformation#,
  q#__KAM_BENEFICIARY3,[l=1]# => q#(?aa)(?i)(gold|diamonds|inherit|foreign customer|risk.?free|less.privilege|next of kin|nearest airport|certain funds|partnership to transfer|repatriation|co.fiscate|separate account|christian activit|receiving bank|donate the sum|money left|sweepstakes|lucky winner|get rich|\d% of the total|investment fund)|moving some money|god has blessed|contributions to humanity|partake in the deal|pledge dep|over-?due compensation|left your check|invest(ment)? in your country|abandoned shipment#,
  q#__KAM_BENEFICIARY3A,[l=0]# => q#(?aa)(?i)(e\-|ELECTRONIC )TICKET RECeipt#,
  q#__KAM_BENEFICIARY3_1,[l=0]# => q#(?aa)(?i)Mikhail Fridman#,
  q#__KAM_BENEFICIARY4,[l=1]# => q#(?aa)(?i)(Ghana|\b(?:South\s)?Africa\b|China|Greece|Estonia|United kingdom|foreign|(your|my) country\b|\bBenin\b|Foreign Op|international Airport|portugal|business trip|Ivory Coast|Royal Bank|\bSyria\b|Libyan|Ministry of |Buffett Foundation|audit unit)|postmaster general#,
  q#__KAM_BENEFICIARY6,[l=0]# => q#(?aa)(?i)(deceased|late) (customer|husband|client|father)|death of my husband|cancer|power of attorney|customer who died|orphan|no beneficiary|terminal|family treasure|not criminal|send (you )?more (information|details)|wife ran away|inability to release|terrorist attack|sterile|foreigner who died|corrupt officials|could not complete|Diplomat from|seized all my#,
  q#__KAM_BIDEST1A,[l=1]# => q#(?aa)(?i)CSI Estimati(ng|on)|crossland estimating|Williams Estimating|Global Estimation|bolt estimating|prestige estimation|bidding estimating|define estimating|dreamland estimation|swift estimating LLC|define estimating,? LLC|perfect estimation.? llc|estimating solutions.? LLC|rockford estimation.? LLC|define estimating LLC|Rise Estimating LLC|american estimating|maple professionals|international estimating, llc|international estimates, llc|Estemanians, LLC|Dream Estimations|universal estimating llc|unity estimating|Cannon Estimation, LLC|Estimen LLC|The Global Estimation LLC|USA ESTIMATION LLC|Estimate Builders LLC|Quantify Bids, LLC#,
  q#__KAM_BIDEST2,[l=1]# => q#(?aa)(?i)need assistance with a project|like more information|bidding and estimating service|estimate your projects|project for estimat|need of cost estimation|low cost detailed cost estimates|providing estimation|you really want take-offs|outsourced cost estimation|need any take.?off service|looking for accurate estimat|Take.?off services for any project|need a detailed estimate|offering budget cost estimates|cost estimating services|show you some sample|estimating.?take-offs? service|forward us the bid|quote on your project|(fair|sample) (take.?off|estimate)|complimentary detail from|send (me|us) the drawing|quick introductory call|send us the project's construction plans|quotes for your project|see attached sample|our example work|need any samples|provide detailed quantity take.?off|professional services in Quantity take.?off|provide material take.?off|estimates \& take.?off|20\% discount on your first estimate|cost estimating|architectural projects for us|need of expert construction estimating|handle your construction (take.?offs|estimat)|any job for us regarding estimat|benefit from our estimat|construction estimation service|estimation services are tailored|offer the most precise estimat|detailed commercial estimate|costing \& take\-?off|too much time on construction take-?off|send us plans for proposal|construction estimates and takeoffs|share your project drawings|require samples or a quotation#,
  q#__KAM_BIDEST3,[l=1]# => q#(?aa)(?i)Business Development Manager|(senior|certified) estimator|certified software|(office|marketing) manager|estimation (department|dept|company)|head of business devel|estimating (manager|service)|estimator|project +manager|Civil, MEP, Architectural|manager of business dev|Sales team|estimation department#,
  q#__KAM_BIDEST4,[l=0]# => q#(?aa)(?i)\(dot\)#,
  q#__KAM_BINANCE2,[l=0]# => q#(?aa)(?i)affiliate link#,
  q#__KAM_BINANCE3,[l=0]# => q#(?aa)(?i)lifetime commission#,
  q#__KAM_BINANCE4,[l=0]# => q#(?aa)(?i)Friends and associates#,
  q#__KAM_BINANCE5,[l=0]# => q#(?aa)(?i)Binance#,
  q#__KAM_BITCOIN2,[l=1]# => q#(?aa)(?i)price.of.bitcoin|bitcoin.price|crypto.?currenc(y|ies)|currency.pioneer|cartel|financial.security|abandoned.our.dollar|money.map#,
  q#__KAM_BIZ1,[l=1]# => q#(?aa)(?is)You always need new cards|free full color business cards|get 250 more ?\- ?free|business card offer|500 business cards#,
  q#__KAM_BLOOD3,[l=1]# => q#(?aa)(?i)Secret Big Pharma|conspiracy|Breaking.Health.Stories#,
  q#__KAM_BLOOD4,[l=1]# => q#(?aa)(?i)Marine Essentials|this mineral|drug.companies.hate#,
  q#__KAM_BLOOD5,[l=1]# => q#(?aa)(?i)Anti\-Aging Expert|worst.food#,
  q#__KAM_BLOOD6,[l=0]# => q#(?aa)(?i)Blood pressure#,
  q#__KAM_BOOKKEEP2,[l=0]# => q#(?aa)(?i)sent you a message|my name is|reply with an optimal number for me to reach|helped a business in your state|reply with a good time\/number to reach|respond a time for us to talk|helping businesses outsource all their bookkeeping|give you a quick call|assisted a company (organize|manage) two years of books|follow back on my message|reply back with a good line|give you a brief line|convenient time to connect|brief minute to discuss|follow up on my last email|received my note from a couple of days|what time works best|set up a time to chat|reached out a couple of days ago|schedule a time to connect|interested in seeing our work#,
  q#__KAM_BOOKKEEP3,[l=1]# => q#(?aa)(?im)(explore|see|check) if (we\'?re|we are) a (match|fit)|paying huge amounts of money for bookkeeping|open to a quick call|streamline bookkeeping needs|fed up with keeping your own books|transform your bookkeeping|accounting for (tons|thousands) of companies just like|no\-stress bookkeeping solution|wasting a lot of time doing bookkeeping|benefit from help keeping books|manag(e|ing) bookkeeping \& accounting requirements for lots of (companies|customers)|interested to hire a dedicated remote (tax|accountant|bookkeeper)|assist businesses handle their books|extra hand with bookkeeping|client in your state|we saved \d+ hours a month|already serving \d+ plus business|we specialize in:? bookkeeping#,
  q#__KAM_BOXQUOTA,[l=1]# => q#(?aa)(?i)mailbox.{0,5}exceeded.{4,14}quota|low email storage#,
  q#__KAM_BOXVERIFY,[l=1]# => q#(?aa)(?i)Verify.{0,10}Mail.?box|retrieve messages#,
  q#__KAM_BTC2,[l=0]# => q#(?aa)(?i)passive income#,
  q#__KAM_BUS1,[l=0]# => q#(?aa)(?i)business proposal#,
  q#__KAM_BUS2,[l=0]# => q#(?aa)(?i)sensitive by nature#,
  q#__KAM_BUS3,[l=0]# => q#(?aa)(?i)have not met#,
  q#__KAM_BUS4,[l=0]# => q#(?aa)(?i)view my attach#,
  q#__KAM_BUSINESSPHONE3,[l=0]# => q#(?aa)(?i)business phone system#,
  q#__KAM_CAD2,[l=1]# => q#(?aa)(?i)we.specialize.in#,
  q#__KAM_CAD3,[l=1]# => q#(?aa)(?i)our.products#,
  q#__KAM_CALLING_2,[l=0]# => q#(?aa)(?i)Itotogit#,
  q#__KAM_CALLING_3,[l=0]# => q#(?aa)(?i)answering associate#,
  q#__KAM_CAMERA3,[l=0]# => q#(?aa)(?i)super telephoto zoom#,
  q#__KAM_CANDY3,[l=0]# => q#(?aa)(?i)you deserve a treat|sweet tooth#,
  q#__KAM_CAR2,[l=0]# => q#(?aa)(?i)buying a new car|dream car|new car you want|free auto insurance(?:-| )quote|save money on your auto|roadside assistance|extended warranty#,
  q#__KAM_CAR3,[l=1]# => q#(?aa)(?i)unbelievable payment terms|no commitment|free price quote|get competitive quotes|offering better rates|no obligation quote|Pay Later|No risk|save up to \d+%#,
  q#__KAM_CARD2,[l=1]# => q#(?aa)(?i)(laughing kitty|crazy cat) card|enjoy your awesome card|Click on your .{0,15}card('s)? (link|direct www address) below|To see your custom .{0,15}card, simply click on the (link below|following)|(as you can see on the ecard)|^your .{1,15}card link:$|I bet your wife won\'?t do this for you|Your temporary Login Info|temp\.? password id|pics I took of my Ex\-Wife|card will be aviailable|our.new.collection#,
  q#__KAM_CARD3,[l=1]# => q#(?aa)(?i)I['`]m in hurry, but i still love you...|has (issued you a greeting|made you an Ecard)|^(Follow this link:|click (here to enter our secure server:))?\s*?http:\/\/\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}|eCard, open attached#,
  q#__KAM_CARDEAL3,[l=1]# => q#(?aa)(?i)201\d Closeout pricing|New Vehicles near you|new automobiles|brand new car|\d{4} makes and models#,
  q#__KAM_CAREER1,[l=1]# => q#(?aa)(?is)Hospitals need you|Medical Billing and Coding|medical.coding#,
  q#__KAM_CAREER2,[l=1]# => q#(?aa)(?is)Get your Healthcare Degree|Billing and Coding degree|job.placement|great.opportunity|training.start(s|ing).soon|job.growth#,
  q#__KAM_CAREER3,[l=1]# => q#(?aa)(?is)unstable.economy|secure.a.position|fast.growing|extraordinary.benefits|work.from.home#,
  q#__KAM_CARING2,[l=1]# => q#(?aa)(?i)shagged|lovemate|online dating|affair|hook.?up#,
  q#__KAM_CARING3,[l=0]# => q#(?aa)(?i)(recent|my) (contact|picture|photo)#,
  q#__KAM_CARING4,[l=0]# => q#(?aa)(?i)unsub#,
  q#__KAM_CASINO1,[l=0]# => q#(?aa)(?i)Elite World Casino#,
  q#__KAM_CASINO2,[l=0]# => q#(?aa)(?i)Online Casino#,
  q#__KAM_CBD1,[l=0]# => q#(?aa)(?i)(Prosper|Meridian) CBD#,
  q#__KAM_CELEB2,[l=0]# => q#(?aa)(?i)resugar#,
  q#__KAM_CELEB3,[l=1]# => q#(?aa)(?i)fat.burning#,
  q#__KAM_CELL3,[l=1]# => q#(?aa)(?i)phone.(information|deals|reviews)|(free|latest|hottest)..?(cell)?.?phone|selection.of.phones|hottest.(brands|models)|check.out.these.smartphones|smartphones.do.more|refurbished.phone|bored.with.your.phone#,
  q#__KAM_CEP1,[l=1]# => q#(?aa)(?i)Job Prospect Newsletter|training.workshop#,
  q#__KAM_CEP2,[l=1]# => q#(?aa)(?i)legitimate verifiable degree|build a better you|domain.knowledge#,
  q#__KAM_CEP3,[l=1]# => q#(?aa)(?i)Career Education program|customize a learning program|certified.instructor#,
  q#__KAM_CEP4,[l=1]# => q#(?aa)(MBA|CEP)#,
  q#__KAM_CEP5,[l=0]# => q#(?aa)(?i)degree\/certificates|certification#,
  q#__KAM_CEP6,[l=1]# => q#(?aa)(?i)\d (week|month)#,
  q#__KAM_CERT2,[l=0]# => q#(?aa)(?i)review this certificate#,
  q#__KAM_CERT3,[l=0]# => q#(?aa)(?i)link below#,
  q#__KAM_CHANGELOG2,[l=0]# => q#(?aa)(?i)as promised chnglog update#,
  q#__KAM_CHEAT3,[l=0]# => q#(?aa)(?i)(Erectile Dysfunction|erection)#,
  q#__KAM_CHECK1,[l=0]# => q#(?aa)(?i)delivery fee for your che(que|ck) draft#,
  q#__KAM_CHECK2,[l=0]# => q#(?aa)(?i)let me know when you recieve your money#,
  q#__KAM_CHECKFILE1,[l=1]# => q#(?aa)(?i)(File|Document)\: https?\:\/\/.{8,128}\/.{2,5}\/\?#,
  q#__KAM_CHECKFILE2_1,[l=0]# => q#(?aa)(?i)(See|View|check|check) attach(ment|ed) (document|file)#,
  q#__KAM_CHICKEN3,[l=1]# => q#(?aa)(?i)your.own.chicken|fresh.egg|chicken.coop|build.your.own#,
  q#__KAM_CHOSEN3,[l=1]# => q#(?aa)(?i)You (were|have been|are) (recently )?(chosen|invited)|you.are.(very.)?welcome#,
  q#__KAM_CIGAR3,[l=0]# => q#(?aa)(?i)Thompson Cigar|Premium Cigar#,
  q#__KAM_CLAIMS3,[l=1]# => q#(?aa)(?i)claim.payment|claim.processing|kindly.confirm#,
  q#__KAM_CLARITOX3,[l=0]# => q#(?aa)(?i)claritox#,
  q#__KAM_CLARITOX4,[l=0]# => q#(?aa)(?i)brain infection#,
  q#__KAM_CLICK,[l=0]# => q#(?aa)(?i)Please click on the link below|Copy and paste this link into your internet browser#,
  q#__KAM_CLOUD3,[l=1]# => q#(?aa)(?i)big data|powering apps|reduce.tech.costs|backup.solution|bundling.the.service#,
  q#__KAM_CLOUD4,[l=1]# => q#(?aa)(?i)hacking|complimentary.(lunch|breakfast)#,
  q#__KAM_COBRA3,[l=0]# => q#(?aa)(?i)find cobra health#,
  q#__KAM_COLLECT2,[l=0]# => q#(?aa)(?i)No Fee#,
  q#__KAM_COLLECT3,[l=0]# => q#(?aa)(?i)collection professionals#,
  q#__KAM_COLLECT4,[l=0]# => q#(?aa)(?i)recovery rate#,
  q#__KAM_COMPANY2_1,[l=1]# => q#(?aa)(?is)Member Services MGM, LLC#,
  q#__KAM_COMPROMISED3,[l=1]# => q#(?aa)\d{1,2}[\\\/]\d{1,2}[\\\/]\d{2,4} \d{1,2}\:\d{1,2}\:\d{1,2} (AM|PM)#,
  q#__KAM_COMPROMISED4,[l=1]# => q#(?aa)(?i)How are you\? Look at this.{0,70}Do you know about this site|look at this site right now|I found (an amazing|great) site|hey\. please have a look|have a look right now|breaking news#,
  q#__KAM_CONTACTME2,[l=0]# => q#(?aa)(?i)read the attached letter#,
  q#__KAM_CONTRACT3,[l=0]# => q#(?aa)(?i)buy you out|service management|management solution#,
  q#__KAM_COPOUT1,[l=0]# => q#(?aa)(?i)MARKETING COMMUNICATION#,
  q#__KAM_COPOUT2,[l=0]# => q#(?aa)(?i)sources believed reliable#,
  q#__KAM_COPOUT3,[l=0]# => q#(?aa)(?i)We have not verified#,
  q#__KAM_COVID1,[l=0]# => q#(?aa)(?i)International Monetary fund|world health organization|empowerment fund#,
  q#__KAM_COVID2_1,[l=0]# => q#(?aa)(?i)COVID-19 (CHARITY )?(fund|donated relief)#,
  q#__KAM_COVID3,[l=1]# => q#(?aa)(?i)COVID.{0,12}(empowerment|payment)|W\.?H\.?O\.? trust.?fund#,
  q#__KAM_COVID3_1,[l=0]# => q#(?aa)(?i)Prince#,
  q#__KAM_COVID3_2,[l=0]# => q#(?aa)(?i)reliable source#,
  q#__KAM_COVID3_3,[l=1]# => q#(?aa)(?i)\$[\d\.,]+ mil#,
  q#__KAM_COVID3_4,[l=0]# => q#(?aa)(?i)assist me#,
  q#__KAM_COVID3_5,[l=0]# => q#(?aa)(?i)Saudi Arabia#,
  q#__KAM_COVID5,[l=1]# => q#(?aa)(?i)00 ?(EUR|USD|Dollar)#,
  q#__KAM_CREDIT2,[l=1]# => q#(?aa)(?i)View (all 3 reports|your credit score|your up.to.the.minute credit)|(EXPERIAN|Transunion|Equifax) report|check my credit score|3.free credit scores|credit restoration|changes in your.score|get your \d+ score online|3 major sources|all three bureau|all 3 credit score|credit (may )?ha(ve|s) been revised|payment.options|complimentary 3 scores|credit scores? in seconds|TRANSUNION,\s+EQUIFAX,\s+(and|.)\s+EXPERIAN|just (been )?changed|score.breakdown|credit.summary|score.is.waiting|confirmation [hash]\d+|average.credit.score|what.?s.your.score|(3|three).free.score|check.your.score|we.can.help|credit.record|complimentary.score#,
  q#__KAM_CREDIT3,[l=1]# => q#(?aa)(?i)NO COST|it's on us|3 companies for free|freescore360|Scoresense|score.report(?:ing)?.team|stand in the rating scales|view your higher credit|(score|credit).alert|provide.faster.service|your credit score|free.credit.score|score.generation|new.score.immediately|score.notification|your report#,
  q#__KAM_CREDIT4,[l=1]# => q#(?aa)(?i)CHANGES TO YOUR CREDIT[- ]SCORE|credit score has changed|Triple Bureau Credit Alerts|score\s+may\s+have\s+(been)?\s*changed|ThinkCredit|Debunk Credit Card Processing Myths|costs for your business|TransUnion,? Experian and Equifax Scores|ha(s|ve).been.updated|what.?s.your.credit|sensitive.information#,
  q#__KAM_CRIM2_1,[l=1]# => q#(?aa)(?i)bit.{0,2}coin#,
  q#__KAM_CRIM2_2,[l=0]# => q#(?aa)(?i)address\:#,
  q#__KAM_CRIM2_3,[l=1]# => q#(?aa)(?is)adult.{0,2}video|sex.{0,2}sites|site for adult#,
  q#__KAM_CRYPTO1,[l=1]# => q#(?aa)(?i)swiss.?coin|[{(]SIC[)}]#,
  q#__KAM_CRYPTODRIVE2,[l=0]# => q#(?aa)(?i)bitcoin (earn|min)|automatic bitcoin#,
  q#__KAM_CRYPTOFAKE1A,[l=0]# => q#(?aa)(?i)wallet will be suspended#,
  q#__KAM_CRYPTOFAKE1B,[l=0]# => q#(?aa)(?i)assets (require action|will be frozen|failed to merge)|merge your assets|action required for your assets|upgrade failure|submit your claim#,
  q#__KAM_CRYPTOFAKE2B,[l=0]# => q#(?aa)(?i)ethereum merge|Community Token Allocation Program|redistributed XRP#,
  q#__KAM_CRYPTOFAKE3B,[l=1]# => q#(?aa)(?i)(trezor.io|exodus\.com)\/merge|blogpost instructions#,
  q#__KAM_CVS2,[l=1]# => q#(?aa)CVS#,
  q#__KAM_DATING1,[l=0]# => q#(?aa)(?i)women seeking happiness#,
  q#__KAM_DATING2,[l=0]# => q#(?aa)(?i)18\+ platform#,
  q#__KAM_DATINGTIPS3,[l=1]# => q#(?aa)(?i)seduction|certain.type.of.guy|secret to their hearts|women.excited|real.love|one.night.stand#,
  q#__KAM_DEALS3,[l=1]# => q#(?aa)(?i)exclusive.savings#,
  q#__KAM_DEATH1,[l=1]# => q#(?aa)(?i)prevent early.death#,
  q#__KAM_DEATH3,[l=1]# => q#(?aa)(?i)Eating this|before it.?s too late#,
  q#__KAM_DEATH4,[l=1]# => q#(?aa)(?i)heart.(attack|stops)#,
  q#__KAM_DEATHINSURE3,[l=1]# => q#(?aa)(?i)inheritance.tax|your.loved.ones|funeral.costs#,
  q#__KAM_DEBT1,[l=1]# => q#(?aa)(?is)(debts disappear|reduce your payments|piling bills|creditors|late bills|vanish some of your bills|reduce your payments|looming bills|all that debt|outstanding debt|debt.{0,7}accumulated|all my debt|penalties,? and fees are gone|banking laws|select legal|change your life|get out of .?d.?e.?b.?t|Free[- ]Credit Report|debt relief options|are you in debt|pay off all your debt|get better rates|credit card debt|could.be.easy)#,
  q#__KAM_DENTIST3,[l=0]# => q#(?aa)(?i)Find a dentist#,
  q#__KAM_DESZY2,[l=0]# => q#(?aa)(?i)Deszy#,
  q#__KAM_DETOX3,[l=1]# => q#(?aa)(?i)detox.program|right.for.you|clean(ing)? up your life|a.little.easier#,
  q#__KAM_DIABETES1,[l=1]# => q#(?aa)(?i)Diabetes News Today|diabetes.health|blood.sugar#,
  q#__KAM_DIABETES2,[l=1]# => q#(?aa)(?i)Reverse.{0,10}(Diabetes|type.2|type.1)|reverse.type.2|beat.type.2|conventional.medical|doctors don't know|home solution|yellow spice|shocked doctors#,
  q#__KAM_DIDYOUBODY,[l=0]# => q#(?aa)(?i)Did you (receive it|get my message)#,
  q#__KAM_DIET2_3,[l=1]# => q#(?aa)(?i)secret to being skinny|doctors? are raving|testosterone|could be \d+ ?lbs? lighter|feeling chubby|burn stubborn fat|lose weight fast#,
  q#__KAM_DIRECT3,[l=0]# => q#(?aa)(?i)(Complimentary|Visitor|attend our open house|30\-day member|VIP Pass|Wholesale Direct Pricing|guest pass and catalog)#,
  q#__KAM_DIRECT4,[l=1]# => q#(?aa)(?i)Direct.?Buy#,
  q#__KAM_DIRECTDEPOSIT1,[l=0]# => q#(?aa)(?i)payroll|pay account#,
  q#__KAM_DIRECTDEPOSIT2,[l=0]# => q#(?aa)(?i)(update|Change) my (pay account|Direct deposit)#,
  q#__KAM_DISCAIR3,[l=0]# => q#(?aa)(?i)Fly Cheap in Business Class#,
  q#__KAM_DISCLAIMER1,[l=0]# => q#(?aa)(?i)receives compensation#,
  q#__KAM_DISCLOSE1,[l=0]# => q#(?aa)(?i)enable me disclose|indicate your? interest|something important#,
  q#__KAM_DISPATCH1,[l=1]# => q#(?aa)(?i)dis+patch(ed)? a (material|file)|Document\:#,
  q#__KAM_DOCUSIGN5A,[l=0]# => q#(?aa)(?i)scan the QR Code#,
  q#__KAM_DOCUSIGN5B,[l=0]# => q#(?aa)(?i)secure link to docusign#,
  q#__KAM_DOMAIN1,[l=1]# => q#(?aa)(?i)Domain (opportunity|notification|release|Availability|club)|Notification for Domain|availability.notice|time.draws.near|submit.a.bid|exclusive.rights|free.registration|the.domain.provider|website.wizard|increase.your.{0,50}.traffic|domain.extension|brand.can.leverage|like.to.obtain|buy(ing)?.this.domain#,
  q#__KAM_DOMAIN2,[l=1]# => q#(?aa)(?i)(?:available|listed) (?:by|for|at|in) auction|confirm interest in (this domain|owning)|capturing this domain|proposal.on.the.domain|exclusive.owner|online.search|web.form|counting.down|potential.buyer|interested.parties|secure.{1,50}.today|drive.more.leads|targeted.traffic|similar.domain|exclusive.regis#,
  q#__KAM_DOMAIN3,[l=1]# => q#(?aa)(?i)(?:have|own) a domain (that is )?.{0,5}similar|(have|own) a similar domain|offer on the Domain|similar to your (current )?domain|Domain Division|all.domains|main.webpage|visibility.platform|solicitation|potential.owner|your.offer|domain.match|domain.notification|domain.will.be|interest.{1,20}.domain.name|fully.responsive|website.included|list.your.website|opportt?unity.regarding|courtesy.notification#,
  q#__KAM_DOMAINBROKER1,[l=0]# => q#(?aa)(?i)DomainBroker#,
  q#__KAM_DOMAINEXPIRY2,[l=0]# => q#(?aa)(?i)Attached letter#,
  q#__KAM_DOMAIN_SALE1,[l=1]# => q#(?aa)(?i)\b(related|similar) domain\b#,
  q#__KAM_DOMAIN_SALE2,[l=1]# => q#(?aa)(?i)\b(interested in|obtaining) .{5,20} domain\b#,
  q#__KAM_DOMAIN_SALE3,[l=1]# => q#(?aa)(?i)\bdomain (name owner|advanced avail|backordering)\b#,
  q#__KAM_DOMAIN_SALE4,[l=1]# => q#(?aa)(?i)\b(domain you might be interested|interested in the domain|interested in obtain|benefit acquiring|complete ownership transfer|brokering the domain)\b#,
  q#__KAM_DON3,[l=1]# => q#(?aa)(?i)donnob\.(?:biz|net)|emarketnow.com|watersolutiontoday.com#,
  q#__KAM_DON4,[l=0]# => q#(?aa)(?i)\$1,000 A Day ATM|J\.O\.B\.#,
  q#__KAM_DRAPES3,[l=1]# => q#(?aa)(?i)banner.stand|print.project#,
  q#__KAM_DRILL1,[l=0]# => q#(?aa)(?i)drilling#,
  q#__KAM_DRILL2,[l=0]# => q#(?aa)(?i)oil (company|partnership|and gas rights)#,
  q#__KAM_DRILL3,[l=1]# => q#(?aa)(?i)(exceed(ed)? .{0,10}expectations|see your brokers website)#,
  q#__KAM_DRILL4,[l=0]# => q#(?aa)(?i)(buy today|Check this deal out)#,
  q#__KAM_DRIVE3,[l=1]# => q#(?aa)(?i)to.be.furnished|office.equipment.item#,
  q#__KAM_DRONE2_3,[l=1]# => q#(?aa)(?i)(best|x.?pro) drone|drone x.?pro#,
  q#__KAM_DRONE3,[l=0]# => q#(?aa)(?i)arrange the (shipment|dispatch)|contact the logistics|logistics to arrange|address for shipping|touch with logistics|location of your shipment#,
  q#__KAM_DRONE4,[l=0]# => q#(?aa)(?i)new drone (information|here)|information about the drone|for (two|three) drones|email about this drone#,
  q#__KAM_DRONE5,[l=0]# => q#(?aa)(?i)grasp our goods|take one or more|three or more|receiving one or two#,
  q#__KAM_DRONE6,[l=0]# => q#(?aa)(?i)GPS Brushless Drone|optical flow#,
  q#__KAM_DROPBOX3,[l=1]# => q#(?aa)(?i)shared.a.folder|download the file#,
  q#__KAM_DRUG1,[l=1]# => q#(?aa)(?is)Quality and cheap|premier quality|supor\-collosal mixture|Discount\-?Pharmacy|hi.quality.drug#,
  q#__KAM_DRUG2,[l=1]# => q#(?aa)(?is)cheaper|redeem in bulk and save|bigger quantities and Save|drugstore accredi[dt]ations|economical (?:value|amount)|drug.online.supplies#,
  q#__KAM_DRUG2_3,[l=1]# => q#(?aa)(?i)Medi?cati[o0]ns|desired meds|favou?red (rx)?med|buy remedies|drug store|medicants|medicaments|sexual stim|sex stim|pain killer|(purchase|loved|preferred|favou?rite) (?:rx.?)?(deal|med)[sz]|rx.?Meds?.?deal|buy your meds|choice of meds|Rx.?(deal|Med|Sale)|v[i1]agra|medz.special|loved meds|(rx|medication) ?discount|Get the edge|joint.pain.relief|neuropathy|nerve.pain#,
  q#__KAM_DRUG2_4,[l=1]# => q#(?aa)(?i)grab hold|at[_ ~]your[_ ~]finger[_ ~]?tip|placing your order|questions about drugs|prescription is not|don't care about prescription|without a doctor|no need for a doctor|affor[df]able.prices|best daily rx|Fav.Prescript|unmatched.prices|rx.med|millions.are.praising#,
  q#__KAM_DRUG2_5,[l=1]# => q#(?aa)(?i)0nline|hassle[~-]free|favored rx|branded solutions|branded remedies|v[1i]cod[!i]n|Penhtremine|prxpills|ultimaterxhere|insanerx|speedymed4u|mightymeds1|coolestrxhere|hotrxmedspot|topshoprx|mightyrxhere|qualityrxmedz|legitrxlife|dealsformeds|simplyrxdeals|bestrxlight|ezprescriptz|reliablerxsource1|freetrusted\-rx|hotmedsourcehere|CabinetOfMeds|mytrusted\-rx|RxwarehouseHere|WarehouseofRxMeds|GreatrxMedsRus|rxmedsrus|(come by|Come to|Check Out) our web site|browse [0o]ur (website|selection)|Visit_0ur Web|Order_Now|available_this week|(buy|order) (n[0o]w|today|right.now|instantly|at [0o]nce|immediately)|check it out today|ord3r|0rder|0rd3r|browseour|rx ?unit#,
  q#__KAM_DRUG2_6,[l=1]# => q#(?aa)(?i)\b(Express|Prompt|Day|Trusty|Trustworthy|Reliable|fast|true|discreet|confidential|rapid)[_ ~\.]?Shippin|anonymous packing|shipped.right.away|adderrx|clinically.proven|support.formula#,
  q#__KAM_DRUG4,[l=1]# => q#(?aa)(?is)click to buy|no previous doctors direction|No prescript[oi]{2}n needed|no script necessary|medicine assistance supplier|mail[- ]?order medicine#,
  q#__KAM_DUCHESS3,[l=1]# => q#(?aa)(?i)Mr. Media Group|BLM Marketing Services|4801 l[yi]nton b#,
  q#__KAM_DUCHESS6,[l=0]# => q#(?aa)(?i)For account number:#,
  q#__KAM_DUJOUR2,[l=0]# => q#(?aa)(?i)(Worst Food|Tinnitus|Reflux|CVS Gift Card)#,
  q#__KAM_DUTCHGLOW3,[l=1]# => q#(?aa)(?i)wood milk|dutch glow|wood's natural beauty|nourish wood|wax build up|your furniture|woodworking.plans#,
  q#__KAM_EBAY1,[l=0]# => q#(?aa)(?i)Succeed on ebay|thousands with ebay|ebay success|money\-making secret#,
  q#__KAM_EBAY2,[l=0]# => q#(?aa)(?i)Auction success kit|Great Money Maker|documented program|Chuck Mullaney|more bills than money#,
  q#__KAM_EGG1,[l=1]# => q#(?aa)(?is)Egg Genie#,
  q#__KAM_EMAILPHISH1,[l=0]# => q#(?aa)(?i)Please login to complete update process#,
  q#__KAM_ENCRYPTED_LIVE2,[l=0]# => q#(?aa)(?i)password:#,
  q#__KAM_ENGINEER2,[l=1]# => q#(?aa)(?i)email.list|target.audience|databank|verified.email#,
  q#__KAM_ENGINEER3,[l=1]# => q#(?aa)(?i)construction.engineering|engineering . architect|marketing.manager#,
  q#__KAM_ERP2,[l=0]# => q#(?aa)(?i)K9ERP#,
  q#__KAM_EVIL_NUMBERS2,[l=0]# => q#(?aa)(?i)\(845\)-458-6\.4\.9\.1|850 3285 455|229 5154 934|585 3660 399#,
  q#__KAM_EVIL_NUMBERS3,[l=1]# => q#(?aa)(?i)(888\s5\s?3\s?1\s?4\s?0\s?3\s?0|855\s5\s?4\s?5\s?6\s?2\s?0\s?1)#,
  q#__KAM_EVIL_NUMBERS4B,[l=1]# => q#(?aa)\(\d\d\d\)-\(\d\d\d\)-\(\d\d\d\d\)#,
  q#__KAM_EXPLOIT1,[l=0]# => q#(?aa)(?i)wallet:#,
  q#__KAM_EXPLOIT2,[l=0]# => q#(?aa)(?i)you have three days#,
  q#__KAM_EXPLOIT3,[l=0]# => q#(?aa)(?i)countdown will begin#,
  q#__KAM_EXPOPIRATE2,[l=0]# => q#(?aa)(?i)Business Traveller#,
  q#__KAM_FAKEAD2,[l=0]# => q#(?aa)(?i)click here to UNSUBSCRIBE|start shopping|here\'s how#,
  q#__KAM_FAKEAD4,[l=0]# => q#(?aa)(?i)Sweet passion|no plastic surgery#,
  q#__KAM_FAKEBBB2,[l=1]# => q#(?aa)(?i)(Fair Labor Standards Act|Safety and Health act|Better Business Bureau|(\b|$)BBB(\b|^))#,
  q#__KAM_FAKEBBB3,[l=0]# => q#(?aa)(?i)(complaint|compliant|Abuse) ID#,
  q#__KAM_FAKEBBB4,[l=1]# => q#(?aa)(?i)(incident:|case:)[\d:;]{6,}#,
  q#__KAM_FAKEINV2,[l=0]# => q#(?aa)(?i)dearest client#,
  q#__KAM_FAKEINV2_2,[l=0]# => q#(?aa)(?i)(find|see) (the )?attach#,
  q#__KAM_FAKEINV2_3,[l=0]# => q#(?aa)(?i)not mail the check|typeform\.com#,
  q#__KAM_FAKEPDF1,[l=1]# => q#(?aa)(?is)Download PDF Reader.Writer#,
  q#__KAM_FAKEPDF2,[l=1]# => q#(?aa)(?is)Reader 2010#,
  q#__KAM_FAKEVOUCHER2,[l=1]# => q#(?aa)(?i)\$\d+ amazon(.com)? Card|redeem.your.\$\d+|join.amazon|bonus voucher|spring.rewards|new.gift.card|exclusive.for|shopper.bucks|activate.here|cash.in.your#,
  q#__KAM_FAKEVOUCHER4,[l=1]# => q#(?aa)(?i)your.opinion|submit.your.email#,
  q#__KAM_FAKEWEST2,[l=0]# => q#(?aa)(?i)Western Union#,
  q#__KAM_FAKEWEST3,[l=0]# => q#(?aa)(?i)United Nation#,
  q#__KAM_FAKEWEST4,[l=0]# => q#(?aa)(?i)Wrong Transfer#,
  q#__KAM_FAKEWEST5,[l=1]# => q#(?aa)(?i)0[\.,]?000[\.,]?00\s?USD#,
  q#__KAM_FAKE_ADOBE3,[l=0]# => q#(?aa)(?i)sign in required|download to view#,
  q#__KAM_FAKE_ADOBE4,[l=0]# => q#(?aa)(?i)received a pdf|pdf document has been shared#,
  q#__KAM_FAKE_AGING2,[l=0]# => q#(?aa)(?i)current aging report#,
  q#__KAM_FAKE_AGING3,[l=0]# => q#(?aa)(?i)treat it as urgent#,
  q#__KAM_FAKE_AGING4,[l=0]# => q#(?aa)(?i)email addresses in an excel#,
  q#__KAM_FAKE_AIRDROP1,[l=0]# => q#(?aa)(?i)claim airdrop#,
  q#__KAM_FAKE_AMAZON2,[l=0]# => q#(?aa)(?i)have an (Amazon account|account with amazon)#,
  q#__KAM_FAKE_AMAZON2_3,[l=0]# => q#(?aa)(?i)Receipt Id|Bill no#,
  q#__KAM_FAKE_APPLE3,[l=0]# => q#(?aa)(?i)a\.p\.p\.l\.e|i\.c\.l\.o\.u\.d|app store team#,
  q#__KAM_FAKE_BENEFIT1,[l=0]# => q#(?aa)(?i)attached#,
  q#__KAM_FAKE_BENEFIT2,[l=0]# => q#(?aa)(?i)benefits? enrollment#,
  q#__KAM_FAKE_BILL3,[l=0]# => q#(?aa)(?i)Payment mode: Paypal pro\-credits|paypal billing team#,
  q#__KAM_FAKE_BILL4,[l=0]# => q#(?aa)(?i)issues with the transaction#,
  q#__KAM_FAKE_CAN_POST1,[l=0]# => q#(?aa)(?i)package is (waiting|on hold)#,
  q#__KAM_FAKE_CAN_POST3,[l=0]# => q#(?aa)(?i)require additional details|online verification#,
  q#__KAM_FAKE_CAN_POST4,[l=0]# => q#(?aa)(?i)redelivery|confirm the payment#,
  q#__KAM_FAKE_CHASE2,[l=0]# => q#(?aa)(?i)chase online#,
  q#__KAM_FAKE_CHASE3,[l=0]# => q#(?aa)(?i)Fraud Protection|unusual activity#,
  q#__KAM_FAKE_CITIZEN2,[l=0]# => q#(?aa)(?i)Important (message|Notice) From Citizens#,
  q#__KAM_FAKE_COINBASE2_2,[l=0]# => q#(?aa)(?i)sent a payment#,
  q#__KAM_FAKE_COINBASE2_3,[l=0]# => q#(?aa)(?i)BTC|paypal#,
  q#__KAM_FAKE_COINBASE4_1,[l=0]# => q#(?aa)(?i)Coinbase at risk#,
  q#__KAM_FAKE_COINBASE4_2,[l=0]# => q#(?aa)(?i)Coinbase\.com\/verify#,
  q#__KAM_FAKE_CRYPTO1,[l=0]# => q#(?aa)(?i)join our platform and start stak|tokens are waiting|Steth rewards|stake now#,
  q#__KAM_FAKE_DELIVER1,[l=1]# => q#(?aa)(?i)courier couldn.?t make the delivery|Courier was unable to deliver|courier company was not able to deliver|memo.of.application|delivering.address|make.the.delivery|see.attached.file|attention.please|event.invitation|could not deliver|delivery.label|postal.noti(fication|ce)|parcels.(has|have).been.shipped|shipment.label.is.attached|confirm your shipping|view file in attach|unable to locate your address|stored in our local depot|delivery failed#,
  q#__KAM_FAKE_DELIVER11,[l=0]# => q#(?aa)(?i)DPD#,
  q#__KAM_FAKE_DELIVER13A,[l=0]# => q#(?aa)(?i)open the enclosed receipt|print the receipt#,
  q#__KAM_FAKE_DELIVER4A,[l=0]# => q#(?aa)(?i)dhl team#,
  q#__KAM_FAKE_DELIVER7,[l=0]# => q#(?aa)(?i)USPS#,
  q#__KAM_FAKE_DELIVER9,[l=1]# => q#(?aa)CARGO#,
  q#__KAM_FAKE_DMCA3,[l=0]# => q#(?aa)(?i)text of the complaint#,
  q#__KAM_FAKE_DMCA4,[l=0]# => q#(?aa)(?i)your device violates#,
  q#__KAM_FAKE_DMCA5,[l=0]# => q#(?aa)(?i)cancel subscription#,
  q#__KAM_FAKE_DOCUSIGN2_3,[l=0]# => q#(?aa)(?i)docusign#,
  q#__KAM_FAKE_EFAX3,[l=0]# => q#(?aa)(?i)efax#,
  q#__KAM_FAKE_EXCEL1,[l=0]# => q#(?aa)(?i)details is in Excel File#,
  q#__KAM_FAKE_FAX2,[l=0]# => q#(?aa)(?i)(new|incoming) fax|fax received#,
  q#__KAM_FAKE_FAX4,[l=0]# => q#(?aa)(?i)invoice|xerox scanner|recipient view only|click below to view your fax|refer to attachment#,
  q#__KAM_FAKE_FICO1A,[l=0]# => q#(?aa)(?i)complimentary\-review#,
  q#__KAM_FAKE_FIDELITY1,[l=0]# => q#(?aa)(?i)we are brokers#,
  q#__KAM_FAKE_HOLD3,[l=0]# => q#(?aa)(?i)account has been put on hold#,
  q#__KAM_FAKE_HOLD4,[l=0]# => q#(?aa)(?i)verify your identity#,
  q#__KAM_FAKE_INVOICE2,[l=1]# => q#(?aa)(?i)(remittance|Payment) (advice|confirmation|breakdown)|past due invoice|new pro.?forma|attach(ed|ment)|balance paid|proforma invoice#,
  q#__KAM_FAKE_INVOICEMS2,[l=0]# => q#(?aa)(?i)process ACH#,
  q#__KAM_FAKE_LOWES3,[l=1]# => q#(?aa)(?i)\d buck|your \d+\.0|\d+ dols|sent with joy|chosen as winer|spend you \$|(huge|massive) (thank you|thanks)|tough times|humble gift|evouch|\bepoint|ereward|we are loved|sending some love|(difficult|turbulent) times|nearest-pharm|weekend is on us|wish you a happy (August)|starbucks wishes you|spend bonus|inspire your dreams|unsuscribe here|want to give back|Enjoy_your_weekend|all the-best|e-?vouch|weekly gift.?card|big thanks for (Ace|costco|cvs)|\d+ sent to you by (Ace|costco|cvs)|rewards balance = \d+ USD|this make it better|Ace.?hardware style|awaiting to be spend|dols-voucher|you have been chosen|scary.?reward|tuff times|super.?(monday|tuesday|wednesday|thursday|friday|saturday|sunday).?mega|send a postcard|day-vouch|\d+ bucks coupon|inside = \$\d+|\d+ coupon|\%Subscriber|as an important customer|glft|here is a thanks|202\d has been difficult|how we celebrate|available for download|points\-can be used#,
  q#__KAM_FAKE_LOWES4,[l=1]# => q#(?aa)(?i)will be expiring|expires|(finishes|change by) (mon|tue|wed|thu|fri|sat|sun)|pending to activate|(use by|until) (Jan|Feb|mar|apr|may|jun|Jul|aug|sep|oct|nov|dec|mon|tue|wed|thu|fri|sat|sun)|pending (to|your) activat|(valid until|(redeem|use|spend) (before|by)) (mid.?night|mon|tue|wed|thu|fri|sat|sun|aug|sep|oct|nov|dec|jan|feb|mar|apr|may|jun|jul)|ending tomorrow|before midnight|received before \d|activat(e|ion) (today|by|before)|end of month giveaway|ends (today|tomorrow)|valid for (today|the weekend|\d+ hours)|August Help|pending to use|by next (Mon|tue|Wed|Thu|Fri|Sat|sun)|(received?|used?) as soon as possible|ends the \d+(nd|th)|yet to be used|this.? (Mon|Tue|Wed|Thu|Fri|Sat|Sun)|use before|used? \d+\.\d+ by (Sun|Mon|Tue|Wed|Thu|Fri|Sat)|last day to activate|ends (Oct(ober)?|Nov(ember)?|Dec(ember)?) \d|\d+ hours to change|grab your \d+|\d hours left|use now|end of today|used today|this week|\d is available since|before christmas|act fast|will go quickly#,
  q#__KAM_FAKE_METAMASK4,[l=0]# => q#(?aa)(?i)Up(grade|date) (here|Now)|activate and verify|complete the migration#,
  q#__KAM_FAKE_MT2,[l=0]# => q#(?aa)(?i)Important (message|Notice) From #,
  q#__KAM_FAKE_NORTON3_3,[l=1]# => q#(?aa)(?i)auto(matic)?.?renew#,
  q#__KAM_FAKE_NORTON_OBFU1,[l=0]# => q#(?aa)(?i)contact Norton Support at#,
  q#__KAM_FAKE_NORTON_OBFU3,[l=0]# => q#(?aa)(?i)Requesting Payment#,
  q#__KAM_FAKE_PAYPAL2_1,[l=0]# => q#(?aa)(?i)PayPal (customer service|Support) Team#,
  q#__KAM_FAKE_PAYPAL2_2,[l=0]# => q#(?aa)(?i)void this (transaction|order) within#,
  q#__KAM_FAKE_PAYPAL3,[l=0]# => q#(?aa)(?i)paypal#,
  q#__KAM_FAKE_PAYPAL4,[l=1]# => q#(?aa)(?i)if any concern|in order to cancel|(any|open a) dispute|(exact|usual) location|used by someone else|regular IP address|(haven'?t|not) made this purchase|contact us immediately|trust & safety|not authorized|file an issue|cancellation|to cancel#,
  q#__KAM_FAKE_PAYPAL5,[l=1]# => q#(?aa)(?i)(accepted|confirmed|USD|purchase) (at|to|by) (Walmart|Target)|(Walmart|Target),?( Inc.?)? has (accepted|received|confirmed)|charge will appear|auto debited|paid instantly|credit wallet balance#,
  q#__KAM_FAKE_PAYPAL6,[l=1]# => q#(?aa)(?i)help by phone|call paypal ?(usa|team)|paypal fraud dep|paypal support immediately|before dispatch|paypal consumer credit#,
  q#__KAM_FAKE_PAYROLL2,[l=0]# => q#(?aa)(?i)new payroll directory#,
  q#__KAM_FAKE_PAYROLL3,[l=0]# => q#(?aa)(?i)required directive#,
  q#__KAM_FAKE_PAY_UPDATE2,[l=1]# => q#(?aa)(?i)(for|before|against) (my|the) (subsequent|current|next|upcoming) pay|for next payroll|kindly review (payroll|your) statement|when the next payday|prochaine date de paiement|current pay cycle|next pay (run|date)|Inactive in a few day|on-?time for any ongoing|what data is required|urgent help|next salary|(upcoming|forthcoming) payroll|effective (for this|this|on) pay.?(day|period)|effect for next pay|made right now|closed in (a )?few day|for the current pay|next pay period|prompt attention|subsequent payroll|finish the update|can ?not afford any more delay|before the pay.?(roll|date)|straight away|against the upcoming pay|before payroll is run|timely payment|for my current pay|prochain ch.que de paie|quick assistance|account will not be difficult|next pay cycle|immediate effect|before next pay|for the next (check|pay)|(the|this) coming payroll|before the current check|issues with the bank|submit the new banking details to you|before processing the next pay|prochaine paie|let me know how to proceed|recently changed (account|bank)|ahead of payroll|before.{5,10}the next pay|before the pay cycle#,
  q#__KAM_FAKE_PO1,[l=0]# => q#(?aa)(?i)status on our purchase order#,
  q#__KAM_FAKE_PO3,[l=0]# => q#(?aa)(?i)attached#,
  q#__KAM_FAKE_REGISTRY1,[l=0]# => q#(?aa)(?i)www(\.|\(dot\))(chinanameregistry|china\-registry|domainregistryasia)(\.|\(dot\))(net|com)#,
  q#__KAM_FAKE_REIMB2,[l=0]# => q#(?aa)(?i)mobile transfer#,
  q#__KAM_FAKE_REIMB4,[l=0]# => q#(?aa)(?i)reimbursement cheque#,
  q#__KAM_FAKE_REIMB5,[l=0]# => q#(?aa)(?i)details for the transfer#,
  q#__KAM_FAKE_SAFESENDER1,[l=1]# => q#(?aa)This sender has been verified from the.{1,32}safe senders? list#,
  q#__KAM_FAKE_SAISON1,[l=0]# => q#(?aa)(?i)Saison Gold Premium|saison card#,
  q#__KAM_FAKE_SCORE3,[l=0]# => q#(?aa)(?i)account deactivation|balance will be (reset|cleared|zeroed)|block inactive account#,
  q#__KAM_FAKE_SCORE4,[l=1]# => q#(?aa)(?i)(sign in.?to|log.?in.?to|enter|access) your account#,
  q#__KAM_FAKE_SECURITY1,[l=0]# => q#(?aa)(?i)Security Alert#,
  q#__KAM_FAKE_SHARE2,[l=0]# => q#(?aa)(?i)sent you the following#,
  q#__KAM_FAKE_SHAREPOINT2_3,[l=1]# => q#(?aa)(?i)REAL DATING NETWORK|bad partner|single.hot.mom|chat room|escort girl|hi there|hook.?up|flirty singles|sweet.?heart|(\b|^|\s)sex|(\b|^|\s)dick|escort|Open me\.? asap|intercourse|seeking male|real relationship|suck my kitty|F.ck me|single girl|real man|need a partner|lonely mom|adults? classified|screw many girls|bang.?meetup|(chat|meet) for sex#,
  q#__KAM_FAKE_SHAREPOINT4,[l=1]# => q#(?aa)(?i)Sharepoint Fileshare|open.me.{0,3}asap|link will only work#,
  q#__KAM_FAKE_SHAREPOINT_PRODUCTS1,[l=0]# => q#(?aa)(?i)bitdefender security cloud#,
  q#__KAM_FAKE_SHAREPOINT_PRODUCTS2,[l=0]# => q#(?aa)(?i)renewed#,
  q#__KAM_FAKE_STIM3,[l=1]# => q#(?aa)(?i)stimu[1i]us|stimulus (benefit|fund|check)#,
  q#__KAM_FAKE_SURVEY2,[l=0]# => q#(?aa)(?i)gift card (opp|promo)#,
  q#__KAM_FAKE_SURVEY3,[l=1]# => q#(?aa)(?i)\d second survey#,
  q#__KAM_FAKE_TREZOR3,[l=0]# => q#(?aa)(?i)Ethereum merge|new device paired#,
  q#__KAM_FAKE_TREZOR4,[l=0]# => q#(?aa)(?i)as soon as possible|lost forever#,
  q#__KAM_FAKE_TREZOR5,[l=1]# => q#(?aa)(?i)trezor|satoshi.?labs.?group#,
  q#__KAM_FAKE_TREZOR7,[l=0]# => q#(?aa)(?i)confirm it was you#,
  q#__KAM_FAKE_TREZOR8,[l=0]# => q#(?aa)(?i)new (paired )?application|new device paired#,
  q#__KAM_FAKE_TRUST1,[l=1]# => q#(?aa)(?i)Message is from a .{0,40}trusted source#,
  q#__KAM_FAKE_WALMART2,[l=0]# => q#(?aa)(?i)Your order#,
  q#__KAM_FAKE_WALMART3,[l=0]# => q#(?aa)(?i)WALMART INC#,
  q#__KAM_FAKE_WEBROOT2,[l=0]# => q#(?aa)(?i)Webroot#,
  q#__KAM_FAKE_WEBROOT3,[l=0]# => q#(?aa)(?i)Total Securities|Webroot (security|premium)#,
  q#__KAM_FAKE_WEBROOT4,[l=0]# => q#(?aa)(?i)not authorized|should there be any concern|terminate your service|discontinuing this transaction#,
  q#__KAM_FAKE_ZIX3,[l=0]# => q#(?aa)(?i)security system|view document#,
  q#__KAM_FARM3,[l=0]# => q#(?aa)(?i)(blueberry|Tomatoe?) giant#,
  q#__KAM_FAT3,[l=0]# => q#(?aa)(?i)island tonic|maverick doctor#,
  q#__KAM_FAVOR2,[l=0]# => q#(?aa)(?i)I need a favor from you|Are you available to work on a request for me today#,
  q#__KAM_FAVOR3,[l=0]# => q#(?aa)(?i)email me back as soon as possible|send me your personal cell phone number#,
  q#__KAM_FDA1,[l=1]# => q#(?aa)(?i)statements.{1,10}not.{1,10}evaluated.{1,10}(FDA|Food ?(and|&) ?Drug Administration)#,
  q#__KAM_FDA2,[l=1]# => q#(?aa)(?i)not intended to diagnose,? treat,? cure,? or prevent#,
  q#__KAM_FDA3,[l=0]# => q#(?aa)(?i)FDA Recall#,
  q#__KAM_FINGERHUT3,[l=1]# => q#(?aa)(?i)important.message|what.you.want|monthly.pay|your.account|credit.account|holiday.shopping|are.you.approved|fingerhut.buying#,
  q#__KAM_FLAG3,[l=1]# => q#(?aa)(?i)performance.flags|shopping.online|scoop on flags|need your flag|best flag|flag design|new flag|flag.needs|flags?.you.need#,
  q#__KAM_FLASH1,[l=1]# => q#(?aa)(?i)Flash Player Code: \d\d#,
  q#__KAM_FLASH2,[l=0]# => q#(?aa)(?i)Flash Player Update#,
  q#__KAM_FOOTBALL2_2,[l=0]# => q#(?aa)(?i)look at (the thing I brought|this product|what I sent you)#,
  q#__KAM_FOOTBALL2_3,[l=1]# => q#(?aa)(?i)foo[st]ball table pric#,
  q#__KAM_FOOTBALL3,[l=0]# => q#(?aa)(?i)Mercato#,
  q#__KAM_FOOTBALL4,[l=0]# => q#(?aa)(?i)Football#,
  q#__KAM_FOREX2,[l=0]# => q#(?aa)(?i)1000pipbuilder#,
  q#__KAM_FOREX3,[l=0]# => q#(?aa)(?i)Forex (trading|signals)#,
  q#__KAM_FOUNTAINOFYOUTH3,[l=1]# => q#(?aa)(?i)look & feel old|\d+.years.of.aging|weird.\d+.second.trick#,
  q#__KAM_FRIEND2,[l=1]# => q#(?aa)(?i)wants.to.follow#,
  q#__KAM_FUN2,[l=1]# => q#(?aa)(?i)Addify Link|Kennett Pike|PetPlan|Newton Sq|1st Avenue|Jones Blvd|permanently opt-out from our all newsletters|(wish|prefer) (to not|not to|to) receive (these|future) (messages|emails)|purehealth|leave any time|too good to be true|try(ing)? this trick|doesn?'t like this update|(click here|wish) +to unsub|send post-mail to|to be removed from receiving|to unsubscribe.+click|no longer like to receive#,
  q#__KAM_FUN3,[l=1]# => q#(?aa)(?i)This Offer is (only )?for (unite. state|USA)|(can ?not|won\'t|can\'t|unable to) see (the|this)? ?image|visit the page below|Continue Reading|watch now|this is an ad|click here now#,
  q#__KAM_FUN5,[l=1]# => q#(?aa)(?i)\d million americans|less than \d{1,32} (weeks|days|hours)|temporary feeling|\d{1,32} ?lbs|[\d+,]{1,32} Asian babes#,
  q#__KAM_FUN6,[l=0]# => q#(?aa)(?i)finds the secret|new discovery|natural medicine|health channel|medicinal plants|simple tweak|doctors are shocked|mysterious liquid|massive mistake|scientifically shown|chronic pain#,
  q#__KAM_FUN7,[l=1]# => q#(?aa)(?i)nerve pain|poor vision|lasik|sleep deeper|smart.?watch|fever|hearing aids|diabetes|gum problem|blood sugar|sugar disease|bad breath|fish oil|ultra ?boost|soothing relief|older women|belly fat|reverse alzheimer|personal safety|gadget.?junk|Insta ?heater|need boyfriends|audiobooks#,
  q#__KAM_FUNERAL3,[l=1]# => q#(?aa)(?i)untimely death|death notification|funeral.costs#,
  q#__KAM_GALLERY2,[l=1]# => q#(?aa)(?i)(?:Infinite|Multi|Elite|Extreme|Complete|Instant|Ultimate|Multi|approved|Free|HD|Guaranteed|Unreal) Access|(?:Ultimate|Babes|Elite|Extreme|P.?o.?r.?n) Collection|(?:Girls|Adu.?lt|Babes|Celeb.?rities) Passwords|(?:Ultimate|p.?o.?r.?n|extreme|elite|Girls) gallery|HD Video|Access Now#,
  q#__KAM_GALLERY4,[l=1]# => q#(?aa)(?i)(Fantastic|Insane|Mega|Extreme|Extreme|New|Many|Fresh|Your|Check) P.?o.?r.?n|cele.?brities elite|(Insane|P.?o.?r.?n|More|Awesome|All|Mega) Model|(Your|Mega|Asian|Bad|Cool|Fresh|Real|Awesome|More) Girl|(Sweet|Incredible|Insane|The|Grand) chick|(Many|New|Infinite|Cool|All) Cele.?b|The N.?u.?des|(Infinite|Awesome|Many|Sweet|Bad|Get|Fresh|Hot|More|Black) Babe|Amat.?e.?urs|(All|Fresh|Fantastic|The|Mega) Adu.?lt|(Extraordinary) Chicks#,
  q#__KAM_GARAGE3,[l=1]# => q#(?aa)(?i)surface protection plus|industrial strength|Concrete.{0,5}metal.{0,8}wood|protect.and.beautify|industrial.grade|common.flooring|treat.your.deck|professional.coating#,
  q#__KAM_GAS1,[l=1]# => q#(?aa)(?i)Gas prices are at an? all time high|\$\d per gallon|gasoline cards#,
  q#__KAM_GAS2,[l=1]# => q#(?aa)(?i)We have a solution|save \d+ cents per gallon|competitive rewards#,
  q#__KAM_GEEKSERVICES2A,[l=0]# => q#(?aa)(?i)bitcoin|coinbase#,
  q#__KAM_GERMAN_BUSINESS_CONTACTS3,[l=0]# => q#(?aa)(?i)German business phone numbers#,
  q#__KAM_GERMAN_BUSINESS_CONTACTS4,[l=0]# => q#(?aa)(?i)Unlimited exportation capabilities#,
  q#__KAM_GEVALIA1,[l=1]# => q#(?aa)(?is)Gevalia Kaffe|premium coffee delivered#,
  q#__KAM_GEVALIA2,[l=1]# => q#(?aa)(?is)(Gevalia coffee lover's|I love coffee) kit#,
  q#__KAM_GEVALIA3,[l=1]# => q#(?aa)(?is)No Further Obligation#,
  q#__KAM_GIFT1,[l=1]# => q#(?aa)(?is)(Claim your free \$500 Target Gift Card|complimentary gift\-?card|received a Victoria's Secret Giftcard|\$500 airline gift card|\$1000 gift card for you to shop|\$\d+.{0,50}gift card|Secret gift card)|costco.coupon|facebook.gift|claim.my.credit#,
  q#__KAM_GIFT2,[l=1]# => q#(?aa)(?is)(unsubscribe from this advertiseme(tn|nt)|exit future communications|to unsubscribe from this|to stop any offers from us)#,
  q#__KAM_GIFT3,[l=1]# => q#(?aa)(?i)every girl loves to buy|do you need a new|offer pass you by|shopping.online|best.price|activate.my|valued.{0,20}user|extra.deals|sign.up.today#,
  q#__KAM_GIFT4,[l=1]# => q#(?aa)(?i)card will be yours free|card on us|buy you the dyson animal|amazon.gift.?card|superstore|starbucks.card|card.egift|redeem.before|offering.you.this|enter.promo.code#,
  q#__KAM_GIFT5,[l=1]# => q#(?aa)(?i)member incentive program|complet(e|ing) the survey|your.customer.id|security.code|promotional.points#,
  q#__KAM_GIFTCERT1,[l=0]# => q#(?aa)(?i)Our gift to you#,
  q#__KAM_GIFTCERT2,[l=1]# => q#(?aa)(?i)\$\d+ gift certificate#,
  q#__KAM_GINA3,[l=0]# => q#(?aa)(?i)Genetic Information Nondiscrimination Act#,
  q#__KAM_GINA4,[l=0]# => q#(?aa)(?i)mandatory poster|remain in compliance|GINA regulations#,
  q#__KAM_GIRLS1,[l=0]# => q#(?aa)(?i)Lack of sex#,
  q#__KAM_GIVE1,[l=0]# => q#(?aa)(?i)receive your gift#,
  q#__KAM_GIVE2,[l=1]# => q#(?aa)(?i)laptop giveaway|deliver your dell.? laptop#,
  q#__KAM_GIVE3,[l=0]# => q#(?aa)(?i)answering a short survey#,
  q#__KAM_GIVE4,[l=0]# => q#(?aa)(?i)verify your shipping address#,
  q#__KAM_GOOGLE2,[l=0]# => q#(?aa)(?i)learn how to earn|automated income kit|online from home|as much money as you wish|be the boss#,
  q#__KAM_GOOGLE3,[l=1]# => q#(?aa)(?i)tons of money|making \$[\d,]*s with Google|extra cash|making serious money#,
  q#__KAM_GOOGLE4,[l=0]# => q#(?aa)(?i)with Google|Google Pie|Google Cash#,
  q#__KAM_GOOGLEFORM_2,[l=0]# => q#(?aa)(?i)Untitled|Formulaire sans titre#,
  q#__KAM_GOOGLEFORM_3,[l=0]# => q#(?aa)(?i)foundation is donating#,
  q#__KAM_GOOGLEPHISH1,[l=0]# => q#(?aa)(?i)copy of the signed agreement#,
  q#__KAM_GOOGLE_AWARD2,[l=0]# => q#(?aa)(?i)selected as a winner#,
  q#__KAM_GOOGLE_AWARD3,[l=0]# => q#(?aa)(?i)Dear Google#,
  q#__KAM_GOOGLE_AWARD4,[l=0]# => q#(?aa)(?i)Official Notification Letter#,
  q#__KAM_GOVT2,[l=0]# => q#(?aa)(?i)government funding#,
  q#__KAM_GOVT3,[l=0]# => q#(?aa)(?i)complimentary information kit#,
  q#__KAM_GOVT4,[l=1]# => q#(?aa)(?i)No.Money?.{0,4}No.Problem#,
  q#__KAM_GRANT1,[l=0]# => q#(?aa)(?i)government grant#,
  q#__KAM_GRANT2,[l=0]# => q#(?aa)(?i)find out if you qualify#,
  q#__KAM_GRANT3,[l=0]# => q#(?aa)(?i)discontinue from this promotion#,
  q#__KAM_GRASS3,[l=0]# => q#(?aa)(?i)Grass Seed On Steroids|rich beautiful lawn|Patch Perfect Seeds|Grow Grass (anywhere|in the shade)#,
  q#__KAM_GREYEAGLE_2,[l=0]# => q#(?aa)(?i)grey eagle funding#,
  q#__KAM_GRIPPY3,[l=1]# => q#(?aa)(?i)gripeez.bonus|interior.decorator|sticky.grip#,
  q#__KAM_GUN1,[l=0]# => q#(?aa)(?i)Keep and Bear Arms#,
  q#__KAM_HACK1,[l=0]# => q#(?aa)(?i)(phone|electronic|computer) have been hacked|suspected online scam#,
  q#__KAM_HACK2,[l=0]# => q#(?aa)(?i)read attached|click here for verification#,
  q#__KAM_HACK3,[l=0]# => q#(?aa)(?i)save yourself|lead to your arrest#,
  q#__KAM_HAIRTRANS3,[l=1]# => q#(?aa)(?i)hair restoration|man look as young|losing your hair|hair ?loss|get.your.hair|(look|feel).younger#,
  q#__KAM_HANGOVER3,[l=0]# => q#(?aa)(?i)hangover patch#,
  q#__KAM_HAPPYTALK2,[l=1]# => q#(?aa)(?i)honest.and.nice#,
  q#__KAM_HAPPYTALK3,[l=1]# => q#(?aa)(?i)beautiful.mail#,
  q#__KAM_HEALTH1,[l=1]# => q#(?aa)(?i)as low as \$\d+\s*(per|\/)\s*month|at \$\d+ including dental#,
  q#__KAM_HEALTH2,[l=1]# => q#(?aa)(?i)save up to \d+% on health insurance|affordable health coverage|quality term life insurance|nationalhealthxchange.com|view.rate|no.obligation|start.saving#,
  q#__KAM_HEALTH2_1,[l=0]# => q#(?aa)(?i)affordable health coverage#,
  q#__KAM_HEART3,[l=1]# => q#(?aa)(?i)Knowing this could very well save your life|\d+.second trick|[hash]1 Trick|Prevent(ing)? A Heart Attack|will you be killed|heart disease|silent heart attack#,
  q#__KAM_HEARTPROD1,[l=1]# => q#(?aa)(?i)heart ?attack#,
  q#__KAM_HEARTPROD2,[l=0]# => q#(?aa)(?i)enzyme#,
  q#__KAM_HERPES3,[l=1]# => q#(?aa)(?i)permanent.remedy|ugly.sores|herpes.episode|got.herpes|your.herpes|herpes.issue#,
  q#__KAM_HIDDEN_URI1,[l=1]# => q#(?aa)(?is)\[DOT\]com#,
  q#__KAM_HIDDEN_URI2,[l=1]# => q#(?aa)(?is)replace "?\[DOT\]#,
  q#__KAM_HIP1,[l=0]# => q#(?aa)(?i)hip replacement|medical alert#,
  q#__KAM_HIP2,[l=0]# => q#(?aa)(?i)implant recall|recall list#,
  q#__KAM_HIRE3,[l=1]# => q#(?aa)(?i)hiring.situation|recruiting|plans.to.hire|altera.staff#,
  q#__KAM_HOLIDAY2020_2,[l=0]# => q#(?aa)(?i)(illusional|Vortex|3d) Rug|wireless earbuds|canvas print|get your (personalized christmas )?ornament|holiday novelty|personalized ornament|rising laptop|HOME Ear endoscope|Gadget ?Junk#,
  q#__KAM_HOLIDAY3,[l=0]# => q#(?aa)(?i)star special|Hotel Opening|(Request|order) a brochure#,
  q#__KAM_HOME1,[l=1]# => q#(?aa)(?i)YOUR HOME|Federal Housing Assistance Program|near.your.area#,
  q#__KAM_HOME2,[l=1]# => q#(?aa)(?i)Build your equity faster|refund is not reversible|rent.to.own#,
  q#__KAM_HOME3,[l=1]# => q#(?aa)(?i)tax saving plans|\d+K Mortgage Credit|no.more.of#,
  q#__KAM_HOMESALE3,[l=0]# => q#(?aa)(?i)Cash Offer for Your Home#,
  q#__KAM_HONOR1,[l=0]# => q#(?aa)(?i)greatest thing of your life#,
  q#__KAM_HONOR3,[l=0]# => q#(?aa)(?i)profession women#,
  q#__KAM_HONOR4,[l=0]# => q#(?aa)(?i)invitation#,
  q#__KAM_HOODIA3,[l=1]# => q#(?aa)(?is)(?:fat loss product|sur?p?press appetite|Reduce Your Appetite)#,
  q#__KAM_HOOKUP3,[l=1]# => q#(?aa)(?i)match.?me.?networks#,
  q#__KAM_HOSE3,[l=1]# => q#(?aa)(?i)(pocket|garden|expandable).hose|(anti|never).kink|FLEX Technology|hydroeasy#,
  q#__KAM_HOWRU2,[l=0]# => q#(?aa)(?i)My name is|what's your name|ask your name|keep company with you#,
  q#__KAM_HOWRU3,[l=0]# => q#(?aa)(?i)visit the site|visit this site|visiting this website|have some social networks|meet you in private|write me tomorrow#,
  q#__KAM_HOWRU4,[l=1]# => q#(?aa)(?i)gmx.com|rambler.ru#,
  q#__KAM_HSR1,[l=1]# => q#(?aa)(?i)hsrupdates.com|progressiverailroading.com#,
  q#__KAM_IDENTNET2,[l=0]# => q#(?aa)(?i)ADVERTISE WITH IDENTITY NETWORK#,
  q#__KAM_INK1,[l=1]# => q#(?aa)(?is)Ink (and|&|n) Toner|SimplyInk|101 inks|1ink|printer ink sale|full.price#,
  q#__KAM_INQUIRY_1,[l=0]# => q#(?aa)(?i)inquiry for purchase|product catalog|price list|reply with catalog#,
  q#__KAM_INQUIRY_3,[l=0]# => q#(?aa)(?i)terms? (\&|and) conditions?|rightful dep#,
  q#__KAM_INQUIRY_4,[l=0]# => q#(?aa)(?i)certificate of origin|import\export|trading company#,
  q#__KAM_INSURE2,[l=1]# => q#(?aa)(?i)find better Health Insurance Rates Today|get information about health coverage|protect your family|overpay for auto insurance|been recently,? lowered|gas prices are going up|Auto Insurnace go with it|no examination|get (?:a )?free quote|have been.{0,2}reduced|AutoWarranty|plans as low as|plans starting at|complete your health profile|Secure \d+k coverage|growing.family|milestone|special.enroll|updated.rate|lifeinsurance|no.medical.exam|accuquote|no.tobacco.rate|denied.coverage|business.policy|reduced.rate|coverage.starts.immediately|obama|respect.your.privacy#,
  q#__KAM_INSURE4,[l=1]# => q#(?aa)(?i)why pay more for.{0,30}coverage|save up to \d+%|accuquote|Life Insurance Coverage|protect.your.family.{1,20}insurance|Protect home and belonging|Affordable Care Act|new health insurance plan for you|home.?.?protection|\d+k.life.insurance|eligible for auto.coverage|set to expire|\$\d+\/mo|new.rate|your.auto.?insurance.policy|term.life|update.policy|legacy|estate|your.package|your.own.life|prepared.for.anything|paying.(far.)?too#,
  q#__KAM_INTRUDE,[l=1]# => q#(?aa)(?i)\b(hope I am not intruding|out of the blue|I will never contact you again if you go here)\b#,
  q#__KAM_INVEST2,[l=1]# => q#(?aa)(?i)apprehensive|unstable investment|(honest|well.?established|reliable) (individual|partner|person)|wealthy client|legal paper|branch manager|director finance|business man|family asset|personal assistant|found your (detail|contact)|consultant|project financing|my name is|i am the lawyer|need your assistance|investment officer#,
  q#__KAM_INVEST3,[l=1]# => q#(?aa)(?i)earn \d+\%|(more|full|elaborate) details|discuss further|risk.?free|give details|profitable|\% (yearly|ROI|commission)|bank draft|remuneration|(needs|seek|seeks|seeking) fund|employ you|split.?ration|(receive|secure) my fund#,
  q#__KAM_INVEST4,[l=1]# => q#(?aa)(?i)malta|oil company|joint venture|(fund|business) proposal|dubai|mutual business|bahrain|compensation fund|barrister|minister of|ghana|strategic development|your region|Mineral.Rich|non.?european|your country|outside UAE#,
  q#__KAM_INVESTCOUNTRY2,[l=0]# => q#(?aa)(?i)invest in your country|investment purpose#,
  q#__KAM_INVOICE4,[l=1]# => q#(?aa)(?i)(billing error|problem with the address).{2,10}invoice#,
  q#__KAM_INVOICEPO2,[l=0]# => q#(?aa)(?i)invoice copies|EFT PROCESS|contract signed|attached enquiry|see the attached|Company name\:#,
  q#__KAM_ITC2,[l=0]# => q#(?aa)(?i)International Trade Council#,
  q#__KAM_ITC3,[l=0]# => q#(?aa)(?i)enclosed#,
  q#__KAM_JESUS1,[l=1]# => q#(?aa)(?i)jesus lovely|the.lord|touched.by.christ#,
  q#__KAM_JESUS2,[l=1]# => q#(?aa)(?i)sister.in.the.lord|need for bible#,
  q#__KAM_JESUS3,[l=1]# => q#(?aa)(?i)nigeria|muslim.women#,
  q#__KAM_JOB1,[l=1]# => q#(?aa)(?is)let go from (a job|my employment) I held for.{1,19} (month|year|forever|life)#,
  q#__KAM_JOB2,[l=1]# => q#(?aa)(?is)twice as much#,
  q#__KAM_JOB2_2,[l=0]# => q#(?aa)(?i)represent the company#,
  q#__KAM_JOB2_3,[l=0]# => q#(?aa)(?i)Singapore#,
  q#__KAM_JOB2_4,[l=1]# => q#(?aa)(?i)\d,?000 USD (monthly|weekly)#,
  q#__KAM_JOINT3,[l=1]# => q#(?aa)(?i)TFX.?(?:health|flex)|tflex#,
  q#__KAM_JOINT4,[l=0]# => q#(?aa)(?i)Joint Relief|effective as glucosamine#,
  q#__KAM_JOINT5,[l=0]# => q#(?aa)(?i)free bottle#,
  q#__KAM_JUDGE1,[l=1]# => q#(?aa)(?is)(unpaid court|(un-?collected|unsatisfied) judgments)#,
  q#__KAM_JUDGE2,[l=1]# => q#(?aa)(?is)(funds|receive what) you are (due|owed)#,
  q#__KAM_JUDGE3,[l=1]# => q#(?aa)(?is)collect your money#,
  q#__KAM_JUDGE4,[l=0]# => q#(?aa)(?i)judgment#,
  q#__KAM_JUNK_INVOICE2,[l=1]# => q#(?aa)(?i)\[image\:\s+invoice#,
  q#__KAM_JURY4,[l=1]# => q#(?aa)(?i)in Court|hearing date|notice to appear|Pretrial notice|compulsory.attendance|court.notice#,
  q#__KAM_KALENDAR1,[l=0]# => q#(?aa)(?i)introduce KalendarAI#,
  q#__KAM_KALENDAR2,[l=0]# => q#(?aa)(?i)(director|VP) of (strategic|growth|sales)#,
  q#__KAM_KALENDAR3,[l=0]# => q#(?aa)(?i)(reply \'stop\'|opt\-out of our campaigns)#,
  q#__KAM_KITCHEN3,[l=1]# => q#(?aa)(?i)special.gift|kitchen.remodel|special.offer#,
  q#__KAM_KIWIBANK3,[l=1]# => q#(?aa)(?i)security.procedure|customer.safety|security.details#,
  q#__KAM_KN_1,[l=1]# => q#(?aa)(?i)(respirator|KN95) .{0,25}Mask|Ultramasx|upgrade your mask#,
  q#__KAM_KN_2,[l=0]# => q#(?aa)(?i)get your|for the public|biden wants to curb|Prevent Corona|quick delivery|do your part|while supplies last|(smart|your) mask#,
  q#__KAM_KORS3,[l=0]# => q#(?aa)(?i)sent you this item|register to receive|latest updates|win great prizes|shop michael kors|kors insider|handbag collection#,
  q#__KAM_LABEL2,[l=0]# => q#(?aa)(?i)meet (you )?at your (home|office)|quick lead time#,
  q#__KAM_LABEL3,[l=1]# => q#(?aa)(?i)(custom.?tailored|make custom) (shirts|sports|jackets|suits)#,
  q#__KAM_LABEL4,[l=0]# => q#(?aa)(?i)(suits start at \$|shirts at \$|upgrad(e|ing) your wardrobe)#,
  q#__KAM_LABEL5,[l=0]# => q#(?aa)(?i)(premier|top|luxury) (clothing|fabric)|fortune 500#,
  q#__KAM_LABEL6,[l=0]# => q#(?aa)(?i)\| Label|Company, Label,#,
  q#__KAM_LANDSCAPE3,[l=1]# => q#(?aa)(?i)landscape.designs|(simple|cheap).strategies|design.troph#,
  q#__KAM_LANDSCAPE4,[l=1]# => q#(?aa)(?i)stone.carving#,
  q#__KAM_LANG3,[l=1]# => q#(?aa)(?i)pimsleur|Language in just \d+ Day#,
  q#__KAM_LASIK3,[l=1]# => q#(?aa)(?i)free (?:Lasik )?eval|\d+ per eye|get lasik info|L.SI. V....n In.t.tut. Summ.r S.v.ng.|works.faster.than#,
  q#__KAM_LAWSUIT3,[l=0]# => q#(?aa)(?i)you or a loved one#,
  q#__KAM_LAWSUIT4,[l=0]# => q#(?aa)(?i)(roundup|diagnosed with cancer)#,
  q#__KAM_LEAD_FORENSICS1,[l=1]# => q#(?aa)(?i)leadforensics.{1,32}com|Lead Forensics#,
  q#__KAM_LED2,[l=1]# => q#(?aa)(?i)(garage|LED Fan) Light|sun-?like|\dx the brightness|security "?must have#,
  q#__KAM_LENS1,[l=0]# => q#(?aa)(?i)pro quality (pho|pic)|Bill gates|best camera#,
  q#__KAM_LENS3,[l=0]# => q#(?aa)(?i)amazing lens|hdx-lens|hdrx#,
  q#__KAM_LIKE1,[l=1]# => q#(?aa)(?is)been working (extremely|very) hard on my friend's website#,
  q#__KAM_LIKE2,[l=1]# => q#(?aa)(?is)a link from .{1,54} would be greatly appreciated#,
  q#__KAM_LIKE3,[l=1]# => q#(?aa)(?is)(link exchange|in return to me linking back)#,
  q#__KAM_LIKE4,[l=1]# => q#(?aa)(?is)HTML code for the link#,
  q#__KAM_LIKE5,[l=1]# => q#(?aa)(?is)I apologize if this message was sent, in error#,
  q#__KAM_LIST1,[l=1]# => q#(?aa)(?is)((Hospital|MD) directory|Nursing Home (List|directory)|doctor lists|marketing lists|Licensed Physicians|practicing MDs|practicing Medical doctors|Physicians in America|emails for every state|(vip|laywers|planners|Business Email|HR Directors Email|Sales & Marketing Directors|Managing Director Email) database)#,
  q#__KAM_LIST2,[l=1]# => q#(?aa)(?is)(?:hospital|dentist|chiropractor|physician|medical doctors|nursing directors|medical marketing|\d sortable fields|records all with emails|business director(y|ies)|direct marketing data)|nursing assistant#,
  q#__KAM_LIST3,[l=1]# => q#(?aa)(?is)price\:|prices for our director#,
  q#__KAM_LIST3_2,[l=1]# => q#(?aa)(?i)list (consultant|services)|email campaign|global marketing|(event|campaign|success|purchasing) mana?ger|(tradeshow|marketing) (coordinator|campaign|manager|exec|project|team)|(lead|demand) gen|(business|Data|event|research|marketing) (analyst|coordinator)|(potential|professionals?|qualified) lead|(business development|marketing|lead|attendees?|data|prospect|intelligence|event).(executive|consultant|specialist)|(marketing|Business) Co-?ordinator|marketing (\&|and) comm|inside sales|pre-?sales|global leads|data dep(t|artment)|marketing exec|(right|appropriate) person|info solutions|Sales executive|database coordinator|list provider|(leads|business development|BD|Biz.?Dev) manager|cd services|data intelligence specialist#,
  q#__KAM_LIST3_3,[l=1]# => q#(?aa)(?i)(information|data|list\'s) (count|field)|verified e?-?mail|with email address|counts and pric|decision maker|specific parameters|job titles|Specific lists|each record|post show attendee|(List|contacts|fields) (consists?|Contains?|includes?)|visitors and price|pricing, counts|information about the list|sample (file|record)|direct email|100\% populated|installed users|(compiled|selling) (a )?list|pricing and further|(validated|buy a) dataset|counts, pricing|procure the list|samples for (your )?review|attendees who might|decision.makers|samples and pricing|pricing details|demographics|few (examples|samples)|database (organization|provider)|(cost|expense) (\&|and) count|(samples|counts?) and cost|multichannel marketing|count of email|users of the following|your marketing campaign|\d\d% on emails|acquiring (email|the) list|list of retailers|decision maker mailing list|B2B( data)? list|acquiring email|interested (in )?acquiring|quality lists|potential (client|customer)|database and list management|pricing and count|audience you would like to reach|data cleansing|job titles you wish to contact|leverage competitive intelligence|business contacts? list|verified direct contact numbers|our list comes with|comprehensive email list#,
  q#__KAM_LIST4,[l=1]# => q#(?aa)(?is)(?:database|list|[\d,]{1,32} (total records|e\-?mails))#,
  q#__KAM_LIST5,[l=1]# => q#(?aa)(?is)(reply with "stop" as a subject|Send an email with "rem" in the subject to discontinue|put "cease" in the subject of an email|for termination of this e?mail|reply with .{1,8} in the subject)|you will have your email taken off|for the datacard|send.a.reply#,
  q#__KAM_LISTSALE1,[l=0]# => q#(?aa)(?i)interested in acquiring#,
  q#__KAM_LISTSALE2,[l=0]# => q#(?aa)(?i)contact list|list of customers|list of decision makers|list for marketing#,
  q#__KAM_LISTSALE3,[l=0]# => q#(?aa)(?i)share counts and samples|send focused campaigns|compiled a dataset#,
  q#__KAM_LOAN3,[l=1]# => q#(?aa)(?i)Financial Relief|need to borrow|Business Loan|instant.funds|approval department|\$\d+ down|loan option|offer.loan|expenses|times.are.tough|money.problems|zippy ?loan|advanced lender|pay off debt|development.project|just.been.approved|for.your.business|loan.solution|ease your stress#,
  q#__KAM_LOGO1,[l=1]# => q#(?aa)(?i)guru.level logo#,
  q#__KAM_LOGO3,[l=1]# => q#(?aa)(?i)(guru.level|ready.made) logo#,
  q#__KAM_LOTTO2,[l=1]# => q#(?aa)(?is)((ticket|serial|lucky) number|secret pin ?code|pin number|batch number|reference number|promotion date|lottery|sweepstake|\d+ lucky recipients|for claim and inquiring)|Micros(oft)? ID#,
  q#__KAM_LOTTO3,[l=1]# => q#(?aa)(?is)(won|claim|cash prize|pounds? sterling|over \$500|award sum of US\$|NOTIFICATION FOR CASH AID)#,
  q#__KAM_LOTTO4,[l=1]# => q#(?aa)(?is)(claims (office|agent|manager|requirement)|lottery coordinator|(certificate|fiduciary) (officer|agent|claims)|accredited agent|payment agency board|promotion manager|promotions? department|Name of +Agent:|executive secretary|claims & Management|lottery approved courier|promo.team)#,
  q#__KAM_LOTTO5,[l=1]# => q#(?aa)(?is)(POWERBALL\-?LOTTO|freelotto group|(microsoft|Royal Heritage) (promotion|Lottery)|(British|UK) National( Online)? Lottery|U\.?K\.? Grand Promotions|Lottery Department UK|Euromillion Loteria|Luckyday International Lottery|International Lottery|Euro \- Afro Asian Sweepstake|urawinner|Free Lotto Sweepstakes|PROMOTION DEPARTMENT|PROMOTION\/PRIZE AWARD|Nederlandse Internationale Loterij|EURO MILLIONS|APPLE LOTTERY ONLINE|MSW MEGA JACKPOT|MICROSOFT EMAIL PROMO|MSNlottery|ECOWAS|Nigeria|National Lottery|claim.{1,10}your.gbp|won.you.{1,10}gbp)|cola lotto online|on\-?line promotion#,
  q#__KAM_LOTTO6,[l=1]# => q#(?aa)(?is)(Dear (Award|Consultation Prize|Lucky) Winner|Winning Notification|Attention:Winner|Dear:? Winner|Amount won:|Sincere Congratulations|Lucky Numbers:|you are a winner|prize attached|prize notification|claims requirement|winning number|winning sum|payout of|qualification number)|attached.file|numbers.on.email|active email address|dear e\-?mail#,
  q#__KAM_LUNAR4,[l=1]# => q#(?aa)(?i)sleep you really need|sleep(ing)? aid|trouble.sleeping|miracle.sleep|lunar.?sleep|all.natural|fall.asleep|refreshed|sleep.cycle|sleep.aid|lack.of.sleep|stay.asleep|somnapure|weird.trick#,
  q#__KAM_MAID3,[l=1]# => q#(?aa)(?i)Pre\-Screened Housekeepers|local.maid#,
  q#__KAM_MAILER1,[l=0]# => q#(?aa)(?i)\{\!firstname_fix\}|\{\{email\}\}|\{\{name\}\}#,
  q#__KAM_MAILER2,[l=0]# => q#(?aa)(?i)(Hi|Dear) \[Recipient('s name)?\]#,
  q#__KAM_MARIJUANA1,[l=0]# => q#(?aa)(?i)marijuana|cannabis#,
  q#__KAM_MARIJUANA2,[l=1]# => q#(?aa)(?i)medicinal|recreational|legal.cannabis#,
  q#__KAM_MARIJUANA3,[l=1]# => q#(?aa)(?i)colorado|washington|profit|without.a.(prescription|doctor)|lets.you.vape|no.doctor#,
  q#__KAM_MASCARA3,[l=0]# => q#(?aa)(?i)smartlash#,
  q#__KAM_MED1,[l=1]# => q#(?aa)(?i)e.?c.?o.?n.?o.?m.?i.?z.?e.{1,10}med#,
  q#__KAM_MEDICAL1,[l=0]# => q#(?aa)(?i)million who suffer from|suffered from organ failure|Medical Billing and Coding|medical doctor#,
  q#__KAM_MEDICAL2,[l=0]# => q#(?aa)(?i)Safe \- Natural \- Effective#,
  q#__KAM_MEDICARE3,[l=1]# => q#(?aa)(?i)medicare.(plan|recipient|annual election)#,
  q#__KAM_MEDICARE4,[l=1]# => q#(?aa)(?i)over.(65|sixty.?five)|most.affordable|lower.your.premium|medicare basics guide#,
  q#__KAM_MEDTOUR1,[l=1]# => q#(?aa)(?i)medical.tourism#,
  q#__KAM_MEDTOUR2,[l=0]# => q#(?aa)(?i)lowest cost in India#,
  q#__KAM_MEMBER3,[l=1]# => q#(?aa)(?i)(\b|^)dating|eharmony|Find.Your.Perfect.Match|thousands.of.single.women|singles?.photos?|local.cougar|successfully matched|blind date|(available|black|latin[oa]|jewish).singles|photos of 50\+#,
  q#__KAM_MERCHANT2,[l=1]# => q#(?aa)(?i)business.owner|merchant.processor|processing.fee|average.bank|interchange.fee#,
  q#__KAM_MERCHANT3,[l=1]# => q#(?aa)(?i)merchant.processing|small.business|yearly.credit|monthly.fee|100%.free#,
  q#__KAM_MESH3,[l=0]# => q#(?aa)(?i)have a mesh implant|entitled to compensation|consumer injury|injured consumer#,
  q#__KAM_MILLIONAIRE1,[l=0]# => q#(?aa)(?i)internet millionai?re#,
  q#__KAM_MILLIONAIRE2,[l=0]# => q#(?aa)(?i)huge success stor(y|ies)|controversial#,
  q#__KAM_MM_FOREX_1,[l=1]# => q#(?aa)(?i)program.{0,10}ktory\ssam\sgra\sna\sgieldzie|program\sdo\sgry\sna\sgieldzie|Potega\stego\sprogramu\stkwi|program.{0,10}handluje.{0,10}zarabia.{0,10}gieldzie.{0,10}udzialu.{0,10}czlowieka|zarabiaj.{0,10}program.{0,10}nie.{0,10}jest.{0,10}zabroniony|Program.{0,10}zrobi.{0,10}wszystko.{0,10}sam|handluj.{0,10}na.{0,10}gieldzie.{0,10}programowi|100.{0,10}%.{0,10}pewnych.{0,10}transakcji|program.{0,10}100.{0,10}%.{0,10}zysk|handel.{0,10}bedzie.{0,10}zabroniony|program.{0,10}odmieni.{0,10}twoje.{0,10}zycie|system.{0,10}finansow.{0,10}przed.{0,10}upadkiem|grupa.{0,10}niemieckich.{0,10}matematykow.{0,10}inteligentny.{0,10}program|zostan\sobrzydliwie\sbogaty|technologia.{0,10}100%.{0,10}pewne.{0,10}decyzje|zarabianie.{0,10}w.{0,10}sieci|swoja.{0,10}szanse.{0,10}zarabianie|internet.{0,10}doprowadzil.{0,10}pieniedzy|zarabia.{0,10}(w|przez).{0,10}internet|karaluch.{0,10}dom.{0,10}brzeg.{0,10}morza|odmieni.{0,10}zycie|pieniadz|pieniedz|zarabia|zarobi#,
  q#__KAM_MOP3,[l=1]# => q#(?aa)(?i)filthy floor|cut cleaning time+absorbs \d+x its own weight|the mop that#,
  q#__KAM_MOTHER3,[l=1]# => q#(?aa)(?i)pro.?flowers|flowers.fresh|freshness.guarantee|shop.now|mom.?s.delight#,
  q#__KAM_MOVIE2,[l=0]# => q#(?aa)(?i)Movie Extra#,
  q#__KAM_NEUROLOGICAL3,[l=0]# => q#(?aa)(?i)at risk for alzheimers|alzheimers conspiracy|doctors hate him#,
  q#__KAM_NEWNOTICE1,[l=1]# => q#(?aa)(?i)- - -\s?(start |begin )?(of |new )?(notification|notice)( \d\d\/\d\d\/\d\d)?\s?- - -|notice of#,
  q#__KAM_NEWNOTICE2,[l=1]# => q#(?aa)(?i)- - -\s?(finish |end )?(of |new )?(notification|notice)( \d\d\/\d\d\/\d\d)?\s?- - -|end notice:#,
  q#__KAM_NEWS2,[l=0]# => q#(?aa)(?i)(?:Hello|hey|hi)!#,
  q#__KAM_NEW_CREDITCARD3,[l=1]# => q#(?aa)(?i)Select your new card|Increase Your Spending|Higher Limit|rewards|business credit|which.credit.card|find.out.now#,
  q#__KAM_NIGERIAN1,[l=1]# => q#(?aa)(?is)(?:payment officer|personal treasurer|experienced marketers|Chairman of the Finance Committee|contact my secretary|field of Financial Services|Head of Human Resources|Public Relation Officer|field of Business Services|payment agent|representing partner|vacancy in my company|representative\/book ?keeper|executor|search and selection of both experienced|retired chief economist|foreign partner|diplomatic courier|senior auditor|online book\-?keeper)|in.your.country|united.state[^s]|states?.citizen|retired.ceo|nigeria|origin.finland|serious.illness|brain.(tumor|cancer)|former.minister|investment.partner|got.mugged|losing.my.(wife|only.son)#,
  q#__KAM_NIGERIAN2,[l=1]# => q#(?aa)(?is)(?:looking for dynamic representative|seek your partnership|new online business model|seek to transfer this money|completely legal activity|never ask you to pay or invest|in search of trustworthy representatives|establishing a new liaison network|rec[ei]{2}ving payment on our behalf|assist me in transferring those funds|make money at home|requiring rep to work on a part time|part time job\/full time|organization for the good work of the lord|job search directory|investor willing to invest in lebanon|invest in Real Estate|Your kind assistance|next of kin|gold.exportation|calgary.lotto)|oil.producing|import.firm|oil.and.gas|petroleum|asset.available|urgent.reply|(cash|credit.cards?|cell(.phone)?).(were|was).stolen#,
  q#__KAM_NIGERIAN2_2,[l=1]# => q#(?aa)(?i)barrister|director of central bank|bank director|former.minister|gold.dealer#,
  q#__KAM_NIGERIAN2_3,[l=1]# => q#(?aa)(?i)high court|central bank|payment center|customs?.officer#,
  q#__KAM_NIGERIAN2_4,[l=1]# => q#(?aa)(?i)e\-?mail id is found among those that have been scammed|paid the fee for your cheque draft|contact the bank director#,
  q#__KAM_NIGERIAN2_5,[l=1]# => q#(?aa)(?i)fund code|cheque|bank draft|oil.and.gas#,
  q#__KAM_NIGERIAN2_6,[l=1]# => q#(?aa)(?i)full contact information requested|need your contacts informations|your bank account information|out.of.the.country#,
  q#__KAM_NIGERIAN2_7,[l=0]# => q#(?aa)(?i)bank|smuggle#,
  q#__KAM_NIGERIAN2_8,[l=1]# => q#(?aa)(?i)courier|diplomat agent|direct wire transfer|my.gold|the.gold#,
  q#__KAM_NIGERIAN2_9,[l=0]# => q#(?aa)(?i)scam|don't let them know that it is money|bank transfer charges#,
  q#__KAM_NIGERIAN3,[l=1]# => q#(?aa)(?is)(?:\d{1,2}\% (?:commission on each transaction|of the total will be set|will be mapped out|is made available to you|of the total sum for your partner|of the money for your effort|for\s+sales)|pay for performance|floating deficit|for your compensation|financial independence|their financial dreams|work from home part\s*\-?\s*time|employing your services|get extra income|deduct your weekly salary \d\d%|transfer of the funds|make successful career at us|you will get \d{1,2}% on each|funds can be directed to your account as a grant|reasonable parentage|dormant domiciliary account|share would be \d+\%|pay you \d+%)|invest|have.a.sum|make.a.donation|immense.benefits|transact.a?.?business|company.sponsor|loan me \$#,
  q#__KAM_NIGERIAN3_1,[l=0]# => q#(?aa)(?i)congo#,
  q#__KAM_NIGERIAN4,[l=1]# => q#(?aa)(?is)(?:American oil merchant|independent contractor|removallink|claim the funds|international corporation|bank draft|becoming our contract staff|contractual employment|customers\s*in Europe,\s*America|new partner from UK|great investment site|money orders|cashiers check|access to the funds|piloting the business|moving the funds|next of kin|syrian.refugees|reply.for.detail)|security.reason|(his|her).account|new.investor|directly.beneficial|business.discussion|promise.to|need.to.spend#,
  q#__KAM_NIGERIAN5,[l=1]# => q#(?aa)(?i)Western Union Money Transfer|Money Gram|form of Money Orders|to apply for this job, please send the following|process our payments|not traceable|risk free transation|transfer to a designated bank account|inheritance return|my.inheritance|my.wealth|donation.to.you|out.of.country|charitable.trust#,
  q#__KAM_NOCONFIDENCE1,[l=1]# => q#(?aa)(?i)confidential.information#,
  q#__KAM_NOMORE1,[l=1]# => q#(?aa)(?i)no.more.of.this#,
  q#__KAM_NOMORE2,[l=1]# => q#(?aa)(?i)no.more.at.all#,
  q#__KAM_NOTIFY2,[l=1]# => q#(?aa)(?i)[2-9] friend request( |\b)|sell your personal|mandatory validation|verify your Account|unread messages#,
  q#__KAM_NUMEROLOGY3,[l=0]# => q#(?aa)(?i)Control your destiny#,
  q#__KAM_NURSE3,[l=1]# => q#(?aa)(?i)nurses (?:are NOW in high.?demand|are needed)|nursing Degree|indispensable.position|growing.career|nursing.assist|certified.nurs#,
  q#__KAM_NUWAVE3,[l=1]# => q#(?aa)(?i)nuwave|energy.saving|temperature.control|meal.prep|cooktop#,
  q#__KAM_OBFURL1,[l=1]# => q#(?aa)(?i)A\s+D\s+I\s+L\s+I\s+Z\+E\s+R\s+.\s+C\s+O\s+M|insidesaleswiz\.\s+com#,
  q#__KAM_OCEANSBOUNTY3,[l=1]# => q#(?aa)(?i)years.of.aging|medical.doctor|age.revers|turn.back.the.clock|reactivate.your.heart#,
  q#__KAM_ODDNAME_1,[l=1]# => q#(?aa)(?i)(Respond|Message back|reply).{0,4}(OPT.?OUT|NOT INTERESTED)#,
  q#__KAM_ODDNAME_2,[l=0]# => q#(?aa)(?i)we offer|how about a quote|connect for a quote|good time in mind|number to quickly connect|best time to contact|direct line to connect#,
  q#__KAM_ODDNAME_4,[l=1]# => q#(?aa)(?i)high.?speed internet|payroll solution|x more visit|inbound call|marketing (division|arm)|reduce its phone#,
  q#__KAM_OILCHANGE3,[l=1]# => q#(?aa)(?i)fresh savings|find your favorite|discount.coupons|oil.change.is.due|local.provider|favorite.location|coupon#,
  q#__KAM_OPRAH1,[l=0]# => q#(?aa)(?i)airfare#,
  q#__KAM_OPRAH2,[l=0]# => q#(?aa)(?i)hotel#,
  q#__KAM_OPRAH3,[l=0]# => q#(?aa)(?i)oprah#,
  q#__KAM_ORDER1,[l=0]# => q#(?aa)(?i)Please find document attached#,
  q#__KAM_PACKAGE1,[l=1]# => q#(?aa)(?i)dysfunction|\dx longer#,
  q#__KAM_PACKAGE2,[l=1]# => q#(?aa)(?i)sexual.performance|longer.in.bed#,
  q#__KAM_PAGE_GROUP1,[l=0]# => q#(?aa)(?i)Talent Acquisition Specialist#,
  q#__KAM_PAGE_GROUP2,[l=0]# => q#(?aa)(?i)Michael Page Recruitment#,
  q#__KAM_PAPERLESS3,[l=1]# => q#(?aa)(?i)fax service|service plan|view.(fax|this.fax)|\d.page.fax|voice.message#,
  q#__KAM_PAPERLESS4,[l=0]# => q#(?aa)(?i)link expires#,
  q#__KAM_PASSEXP1,[l=0]# => q#(?aa)(?i)expires today|about to expire#,
  q#__KAM_PASSEXP2,[l=0]# => q#(?aa)(?i)(continue with|Keep my) same password#,
  q#__KAM_PASSWORD2,[l=1]# => q#(?aa)(?i)validate.your.email#,
  q#__KAM_PASSWORDSCAM1,[l=0]# => q#(?aa)(?i)pass word#,
  q#__KAM_PATHOS1,[l=0]# => q#(?aa)(?i)PR firm|spots left for an article#,
  q#__KAM_PATHOS2,[l=0]# => q#(?aa)(?i)(Pathos|Pay on Results) (PR|Media)#,
  q#__KAM_PATHOS3,[l=1]# => q#(?aa)(?i)(\b|^)((managing|marketing) (director|partner)|team lead|Partner)(\b|$)#,
  q#__KAM_PATHOS4,[l=1]# => q#(?aa)(?i)opt-?out|opt-?ing out#,
  q#__KAM_PATRIOT3,[l=1]# => q#(?aa)(?i)the truth about|financial collapse|your guns|hidden agenda|unprecedented.crisis|disaster|fema (stock.?piling|storing)|Gor?vernment Not Telling|survival.plan|nation.gone.under|blind.with.patriotism|government shutdown|only chance|civil.unrest|high.crimes|behind.our.back|know.the.truth|PatriotNewsNet|second civil war|for.the.cia|market.crash|american.meltdown|concerned.american|military force|we.were.right|our.suspicions|vindicated|abuse.of.power|american.empire#,
  q#__KAM_PATRIOT4,[l=1]# => q#(?aa)(?i)projectprophet|financial.threat|nuke.deal#,
  q#__KAM_PAYMENTSCAM2,[l=0]# => q#(?aa)(?i)attached (payment|herewith)|ready for release#,
  q#__KAM_PAYMENT_LOWERED2,[l=1]# => q#(?aa)(?i)new monthly payment|just.recently.been..?lowered#,
  q#__KAM_PAYPAL3D,[l=1]# => q#(?aa)(?i)security.process|more.information|has.limitation|verify.your.information|bitcoin|\d\d hours from today#,
  q#__KAM_PAYROLL1,[l=0]# => q#(?aa)(?i)(Leveragewages|Savingcredits)#,
  q#__KAM_PAYROLL2,[l=0]# => q#(?aa)(?i)(companies|businesses) in CA#,
  q#__KAM_PAYROLL_SCANNER3,[l=1]# => q#(?aa)(?i)e-?mail was sent from \"#,
  q#__KAM_PEEL1,[l=1]# => q#(?aa)(?is)Titan Peeler#,
  q#__KAM_PENPAL2,[l=0]# => q#(?aa)(?i)my name is|I\'m from Sweden#,
  q#__KAM_PENPAL3,[l=1]# => q#(?aa)(?i)pen.?pal#,
  q#__KAM_PENPAL4,[l=1]# => q#(?aa)(?i)talk *anything|talk about (everything|anything)|look forward to hear|contact details online#,
  q#__KAM_PEST3,[l=0]# => q#(?aa)(?i)revolutionary pes?t control system#,
  q#__KAM_PET3,[l=1]# => q#(?aa)(?i)pet health insurance|doggy.loot|coupon.notice|reduce.your.cost#,
  q#__KAM_PHARMA_2,[l=0]# => q#(?aa)(?i)Online Pharmacy|No Prescription#,
  q#__KAM_PHISH2_2,[l=1]# => q#(?aa)(?is)Virginia Credit Union|Lloyds|HSBC|usaa|barclay|credit card account#,
  q#__KAM_PHISH2_4,[l=1]# => q#(?aa)(?i)unauthori[sz]ed use|security.enhancement|dropbox|hold.(on.)?your.fund#,
  q#__KAM_PHISH2_5,[l=1]# => q#(?aa)(?i)account suspension|temporary locked|temporarily.suspend|your.reference|accurately.detail#,
  q#__KAM_PHISH2_6,[l=1]# => q#(?aa)(?i)confirm your online banking details|payment.advice|online.fraud|billing.information#,
  q#__KAM_PHISH2_7,[l=1]# => q#(?aa)(?i)extra security check|security.tip#,
  q#__KAM_PHISH3_2,[l=1]# => q#(?aa)accessed by someone else.#,
  q#__KAM_PHISH4_2,[l=1]# => q#(?aa)(?i)dear.{0,50}customer|automated.message|spam.activities|attempted.gaining.access|your.account.expires|authorized.government|important.message|message.alert|suspended#,
  q#__KAM_PHISH4_3,[l=1]# => q#(?aa)(?i)(confirm|verify|update).your.(identity|account)|account.password|credit.(bureau|profile)|identity.theft|accredited.commission|security.concern|kindly.find.enclosed|owner of this account#,
  q#__KAM_PHISHCP3_1,[l=1]# => q#(?aa)cPanel Cloud Service#,
  q#__KAM_PHONE1,[l=0]# => q#(?aa)(?i)reduce your company phone expense#,
  q#__KAM_PHONE2,[l=1]# => q#(?aa)(?i)changes? that takes? less than \d+ min#,
  q#__KAM_PHONESYS1,[l=1]# => q#(?aa)(?i)(reduced|lower your) rate|\d+% lower|lower (your|its) telecom#,
  q#__KAM_PHONESYS2,[l=1]# => q#(?aa)(?i)Business Dev|tech associate|tele.?specialist|growth dev#,
  q#__KAM_PHONESYS3,[l=1]# => q#(?aa)(?i)Top-regarded carriers|(T1|Cloud) (lines|phone)|cloud.?based phone|voip service#,
  q#__KAM_PHONESYS4,[l=1]# => q#(?aa)(?i)(worth|Have) \d+ minute|reply with rule.?out|open to this#,
  q#__KAM_PHONESYS5,[l=0]# => q#(?aa)(?i)best number to quickly get in touch|quick number to reach you|may i send some info|best direct line to reach#,
  q#__KAM_PHOTO2,[l=0]# => q#(?aa)(?i)I am very lonely#,
  q#__KAM_PHOTO4,[l=0]# => q#(?aa)(?i)This is my photo#,
  q#__KAM_PHOTO5,[l=0]# => q#(?aa)(?i)get to know you#,
  q#__KAM_PHOTOPHISH1,[l=0]# => q#(?aa)(?i)here are the(se)? (pics|pictures|images|photo)|(here is|forwarded|sent) (this|that) (photo|pic)|have a look|send these pics before|photos from last week#,
  q#__KAM_PHOTOPHISH2,[l=0]# => q#(?aa)(?i)(guess|not sure if|hope|presume) (it\'s|they\'re|they are) still (appropriate|related|needed|relevant)|still the right time for them|send them to you way sooner|just occurred to me#,
  q#__KAM_PHOTOPHISH3,[l=1]# => q#(?aa)(?i)remember the (m[ae]n|wom[ea]n|girls) (in|on) (the|this) (pic|image|photo)|recall the (guys|girls) on the last \d+\s+pictures|assume you know most of these (guys|girls)#,
  q#__KAM_PIANO1,[l=0]# => q#(?aa)(?i)(dead|late) (spouse|husband)#,
  q#__KAM_PIANO2,[l=0]# => q#(?aa)(?i)(Yamaha|grand) piano|baby grand#,
  q#__KAM_PIANO3,[l=0]# => q#(?aa)(?i)free|gifting|offering|give away#,
  q#__KAM_PIC1,[l=1]# => q#(?aa)(?is)(tired|bored) (this )?(today|tonight|evening|morning|afternoon)|saw your email address|online right now|can name me|found you on this site|I am alone|my next boyfriend|blonde with blue|like the girls|crush on you|(wish|hope) (you're|you are) (free|able) to talk#,
  q#__KAM_PIC2,[l=1]# => q#(?aa)(?is)(nice girl|2\d years old|25 y.o. girl|pretty russian|I russian girl|age is 25|long legs, cute|see my pictures|I'm 19|searching for a bad girl|meet with such attractive|(solitary|cute) lady|(female|girl born) in Russia)#,
  q#__KAM_PIC3,[l=1]# => q#(?aa)(?is)like to chat|feelings can be true|like to have friendship|friendly guy|gave me your photos|waiting on you|found your pictures|send me a note|more information about you|text me ASAP|corking male|(find a good|uncomparable|waiting for a good) (man|mister)#,
  q#__KAM_PIC4,[l=1]# => q#(?aa)(?is)(like to share some of my pics|some (?:great )?pictures of me|sending some of my pictures|To see my pic|hope you like my pic|will reply with my pics|show you some pic|chat with me and see|that's my photo)|(reply to|will send) you my picture|view my profile|describe yourself|chat with me|bad girl|view your snapshot|want to watch video|erotic pics|e.?mail to me at#,
  q#__KAM_PIC5,[l=0]# => q#(?aa)(?i)picture|photo|my pics|appended my pic#,
  q#__KAM_PIC6,[l=0]# => q#(?aa)(?i)where (are|r) (you|u) live#,
  q#__KAM_PILLS2,[l=0]# => q#(?aa)(?i)be (thrifty|smart|clever), buy your (pills|drugs|medications)#,
  q#__KAM_PIZZA3,[l=1]# => q#(?aa)(?i)free.pizza.coupon#,
  q#__KAM_POLICY3,[l=0]# => q#(?aa)(?i)Attached policy|section can proceed#,
  q#__KAM_POLITICS2,[l=1]# => q#(?aa)(?i)Minuteman Civil Defense Corps|National Campaign Fund|Right vs Left|Restore America PAC|penntransportation.com|getliberty.org|Americans for Limited Government|radical|true.conservative|true.liberal|job.killing|wasteful.spending|senate.takeover|liberal.agenda|smear.campaign|america.s future|liberty|obama|governor|election.day|v\-o\-t\-e|sign.the.petition|paid.for.by|dear.conservative|dear.liberal|winning.the.senate|election.cycle|return.power|failed.policy|(left|right).is.claiming|bigwigs|favorable.voters#,
  q#__KAM_POLY2,[l=0]# => q#(?aa)(?i)The End of Barack Obama#,
  q#__KAM_POWER1,[l=0]# => q#(?aa)(?i)hoveround#,
  q#__KAM_PRIV1,[l=0]# => q#(?aa)(?i)private message|horny|sweet ass#,
  q#__KAM_PRIV2,[l=0]# => q#(?aa)(?i)(personal|private) video#,
  q#__KAM_PRIV3,[l=0]# => q#(?aa)(?i)the attache?ment|attached file#,
  q#__KAM_PRODUCT2,[l=0]# => q#(?aa)(?i)phones for discerning individuals#,
  q#__KAM_PRODUCT2_2,[l=1]# => q#(?aa)(?i)meal delivery|no chopping|i ?can ?read|zippy ?loan|car ?shield|Lick their paws|excessive scratching|trugreen|slice.?n.?seal|kitchen (device|gadget)|Better Butter|(elongation|growth) secret|savage.?grow|coolair|Wifi Booster|sleeplab|belly.flat|solar ?bright flood|space Cooler|coolair#,
  q#__KAM_PROFORMA2,[l=0]# => q#(?aa)(?i)no responds#,
  q#__KAM_PROFORMA3,[l=0]# => q#(?aa)(?i)highly encrypted#,
  q#__KAM_PROFORMA4,[l=0]# => q#(?aa)(?i)Proforma Invoice#,
  q#__KAM_PROJECT2,[l=0]# => q#(?aa)(?i)business project#,
  q#__KAM_PROJECT3,[l=0]# => q#(?aa)(?i)email is active#,
  q#__KAM_PROJECT4,[l=0]# => q#(?aa)(?i)please respond#,
  q#__KAM_PROPERTY3,[l=1]# => q#(?aa)(?i)convenient.location#,
  q#__KAM_PROPHET3,[l=1]# => q#(?aa)(?i)Dear Christian Friend|revelation \d+\:#,
  q#__KAM_PROPHET4,[l=1]# => q#(?aa)(?i)Christian ?Media\*? ?(Daily|Ministry|Prophecy)|spiritualisraelnumber\d#,
  q#__KAM_PROPHET5,[l=0]# => q#(?aa)(?i)prophecy|rapture#,
  q#__KAM_PSYCHIC3,[l=0]# => q#(?aa)(?i)psychic Chris|free psychic reading#,
  q#__KAM_QTJARS3,[l=1]# => q#(?aa)qtjars#,
  q#__KAM_QTJARS4,[l=1]# => q#(?aa)private message#,
  q#__KAM_QUOTA1,[l=0]# => q#(?aa)(?i)Mailbox Quota Has Exceeded|exceeded its storage limit#,
  q#__KAM_QUOTA2,[l=1]# => q#(?aa)(?i)Limited Access|termination of your email|restore.your.account|will.not.be.able#,
  q#__KAM_RAT2_1,[l=0]# => q#(?aa)(?i)job description#,
  q#__KAM_RAT2_2,[l=0]# => q#(?aa)(?i)dear shopper#,
  q#__KAM_RBL_OBFU1,[l=1]# => q#(?aa)(?i)b2b.{1,4}salesprospects.{1,4}com#,
  q#__KAM_RBL_OBFU2,[l=1]# => q#(?aa)(?i)quin.{0,3}for.{0,3}ce.com#,
  q#__KAM_RBL_OBFU3,[l=0]# => q#(?aa)(?i)jrgpartners\(\.\)com#,
  q#__KAM_REAL1,[l=1]# => q#(?aa)(?is)(^|\b)RE market#,
  q#__KAM_REAL2,[l=0]# => q#(?aa)(?i)(crashing|declining)#,
  q#__KAM_REAL2_1,[l=1]# => q#(?aa)(?i)(?:Property available|on the water|costa rica|mountain.top)#,
  q#__KAM_REAL2_2,[l=1]# => q#(?aa)(?i)(?:pre\-development prices|finish building|torn down to build|exclusive place|ready.for.construction)#,
  q#__KAM_REAL2_3,[l=1]# => q#(?aa)(?i)(?:unbelievable deals|buyer with CA[s\$]h|pennies.on.the.dollar)#,
  q#__KAM_REAL2_4,[l=1]# => q#(?aa)(?i)(?:home sites|raw land|vacation home|wooded.property)#,
  q#__KAM_REAL2_5,[l=0]# => q#(?aa)(?i)(?:developers|estates|buyer flying in|retirement plans|liquidation)#,
  q#__KAM_REAL3,[l=1]# => q#(?aa)(?is)(vacation|second) (home|place)#,
  q#__KAM_RECALL3,[l=1]# => q#(?aa)(?i)protect.your.dog|recall?s.on.dog.?food|processing.standards|commercial.food#,
  q#__KAM_REFI2,[l=1]# => q#(?aa)(?is)(Free Evaluation (?:online|on your (?:current )?home loan)|No hidden costs|no strings attached|good credit or not|personalized consultation|in need of loan|consolidation loan|loan processing|apply by sending|loan of any amount|clean up any inacccuracies|lock in saving|save on monthly mortgage|absolutely no cost|underwater)|Reverse.?Mortgage|qualify for a VA loan|Refi now.? and Save|obama..?announces|rate.calculator|save.thousands|update: \d.\d\d..available|homeowner|over.your.head|rate.service|now.eligi?[bl]{2}e|a.second.mortgage|urgent.loan|loan.offer#,
  q#__KAM_REFI3,[l=1]# => q#(?aa)(?is)(restructure (?:proposal|program|opportunity|your loan)|switch from an adjustable rate to a fixed|new lending program|(low|reasonable) interest (loan|rate)|lowest monthly payment|\d% interest|unsecured personal|better credit terms|lower your mortgage|low\-interest refinance|see your credit score|credit score.{1,15}updated|refi with HARP)|obama announce(s|d) (the )?harp program|obama'?s.refi|a.fortune.off|lower.home.rate|your.home|home.loan|gov.program|official.harp|currently.overpaying#,
  q#__KAM_REFI5,[l=1]# => q#(?aa)(?is)([\d,]{5,6}|\d{2}\s*%) savings|principal \d+% less|\d+\.\d+%.fixed|refi.calculator|lowered.requirements#,
  q#__KAM_REFI6,[l=1]# => q#(?aa)(?is)((?:reduce your monthly payment|save you) (between )?\d{2}\s*%|save yourself hundreds of dollars|great rate available|completely unsecured|instantly connect with\s+lenders|get you back on the right financial|get report today|protect against identity|know your credit score|crazy payments)|u.?s.? homeowners|drop.your.rate|in.your.pocket|our.records|apply.for.your#,
  q#__KAM_REFINEW2,[l=1]# => q#(?aa)(?i)(rate|payment).reduction|score-update#,
  q#__KAM_REHAB3,[l=0]# => q#(?aa)(?i)(?:drug|alcohol) (recovery|rehab|dependenc|addict|treatment)|help for alcoholism|life from alcohol|end your drinking|think about rehab#,
  q#__KAM_RELIGION3,[l=0]# => q#(?aa)(?i)Dear Christian|Christian Media#,
  q#__KAM_REMEMBERWHEN2,[l=1]# => q#(?aa)(?i)hello.brother|remember(ed)?.you|i.remember#,
  q#__KAM_REMEMBERWHEN3,[l=1]# => q#(?aa)(?i)medication|\d+%.discount|lots?.of.drug#,
  q#__KAM_REP1,[l=1]# => q#(?aa)(?is)Replace \[?[-!~\.]\]? with \.#,
  q#__KAM_REP2,[l=1]# => q#(?aa)(?i)www\s+[-!~\.]#,
  q#__KAM_REP2_1,[l=1]# => q#(?aa)(?is)(Just|Please|all you need to do is to) (copy|type):? (www\s)?.{0,10}[\[\(]([-!~\.]|dot)[\]\)]#,
  q#__KAM_REP2_2,[l=0]# => q#(?aa)(?i)in your (IE|internet|explorer|browser)#,
  q#__KAM_REP3_1,[l=1]# => q#(?aa)(?is)\*omit empty spaces#,
  q#__KAM_REP3_2,[l=1]# => q#(?aa)(?i).\s+(COM|org|net|info)$#,
  q#__KAM_REPAIR1_3,[l=1]# => q#(?aa)(?i)car.repair|Auto Protection|repair.bill|lowest.rates|need.repairs|cost.you.thousands|auto.warranty|costs.keep.rising|repair.cost|do.it.yourself|auto.body|body.repair|protection.quote#,
  q#__KAM_REPAIR2_3,[l=1]# => q#(?aa)(?i)never.pay|covered.home.repair|the.trouble|warning.signs|roofing.problem|roof.repair#,
  q#__KAM_REVIEW3,[l=1]# => q#(?aa)(?i)unverified|major.local.search|search.sites|company(.s)?.information#,
  q#__KAM_REWARD1,[l=1]# => q#(?aa)(?i)walgreens|ikea|sephora|sams.?club#,
  q#__KAM_RICH1,[l=1]# => q#(?aa)(?i)financial.success story#,
  q#__KAM_RICH2,[l=1]# => q#(?aa)(?i)see me on the channel \d news#,
  q#__KAM_RICH3,[l=0]# => q#(?aa)(?i)talking about my blog#,
  q#__KAM_RICH4,[l=1]# => q#(?aa)(?i)bec.me financially independent#,
  q#__KAM_RUIN1,[l=0]# => q#(?aa)(?i)do not deposit#,
  q#__KAM_RUIN3,[l=0]# => q#(?aa)(?i)banking institutions#,
  q#__KAM_RXPLAN3,[l=0]# => q#(?aa)(?i)gap coverage#,
  q#__KAM_SALE3,[l=1]# => q#(?aa)(?i)\d{1,32}%.off|just.shipped|touch.?fire|just.became.perfect|transform.your.ipad#,
  q#__KAM_SALEA_3,[l=1]# => q#(?aa)(?i)touchfire|just.became.perfect|never.be.the.same#,
  q#__KAM_SANDAL3,[l=0]# => q#(?aa)(?i)quickdry sandal#,
  q#__KAM_SANTA2,[l=0]# => q#(?aa)(?i)Santa Letter|Letter from Santa|sent by Santa#,
  q#__KAM_SANTA3,[l=1]# => q#(?aa)(?i)the .?perfect.? gift|personalized letter#,
  q#__KAM_SCOOTER3,[l=0]# => q#(?aa)(?i)the scooter store#,
  q#__KAM_SEARCH3,[l=1]# => q#(?aa)(?i)(first on|all of) the major search|not ranked number one|Website promotion|popular keywords|mobile.website|complete.solution|back.link|company in india|india.based|\(India\)|surfing|not.ranking.on|(?:top in|page \d\-\d of) Google|1st page|more (clients|customers)|organic search|generate leads|specialization includes SEO|rank on page (1|one)|top page ranking|white.?hat SEO#,
  q#__KAM_SEARCH4,[l=1]# => q#(?aa)(?i)guaranteed type of exposure|free website (analysis|report|search engine optimiz)|increase your revenue|improve your website traffice|website rank higher|marketing service|popular.keyword|media.presence|media.portal|brand.awareness|analytics.certified|optimized.content|white.label|website.optimization|digital.marketing|in.your.industry|high.revenue|plans? and pric|keyword|full proposal|online reputation|(blog|article|pr|search engine) (promotion|submission)|competitive quote|send you (our past work|quote)|website audit|seo (package|campaign)|package for \d+ keyword|website\'s high rank#,
  q#__KAM_SECURITY3,[l=1]# => q#(?aa)(?i)information.security|cyber.?criminal#,
  q#__KAM_SEENTHIS1,[l=1]# => q#(?aa)(?i)have.you.seen|seen.this#,
  q#__KAM_SELL2,[l=0]# => q#(?aa)(?i)Easy Money#,
  q#__KAM_SELL3,[l=0]# => q#(?aa)(?i)Selling Credit Cards#,
  q#__KAM_SELLPHONE1,[l=0]# => q#(?aa)(?i)Turn iphones into cash#,
  q#__KAM_SELLPHONE2,[l=0]# => q#(?aa)(?i)used or broken|pre\-paid envelope#,
  q#__KAM_SEO2,[l=1]# => q#(?aa)(?i)(?:top|(1st|first) page) (?:in|of) (?:Google|MSN|Yahoo|Bing)|rank number one|top page rank|guarantee you 1st|link.building|business SEO|(audit|ranking) report|higher search rank|top \d+ search engine rank|top rank(ings?)? (on|in) Google|free audit report|new clients every day#,
  q#__KAM_SEO3,[l=1]# => q#(?aa)(?i)(came across|never find) your web.?site|major search engines|paid access to tools|WEBSITE AUDIT REPORT|specific.keyword|targeted.email|visited.your.website|not ranking well|Google rankings|issues bugging your website|increase your organic traffic|targeted keywords on page|your website rank#,
  q#__KAM_SEO4,[l=1]# => q#(?aa)(?i)SEO Specialists|online marketing services|S.?E.?O.? Company in INDIA|google.panda|google.penguin|not.ranking|SEO Packages#,
  q#__KAM_SEO5,[l=1]# => q#(?aa)(?i)more traffic guaranteed|results in thirty day|top 5 organic|high revenue|free.analysis|guaranteed.top|price.?list|completely free|No upfront fees|free trial|(plan of action|proposal) for your website#,
  q#__KAM_SEO6,[l=1]# => q#(?aa)(?i)will not get your website banned|Google.?s SEO policies|six month ongoing campaign|web.promotion|quality junk spam|promotional online marketing|panda.?safe|digital marketing#,
  q#__KAM_SETTING2,[l=0]# => q#(?aa)(?i)security upgrade|Maintenance Process on our email system #,
  q#__KAM_SETTING3,[l=1]# => q#(?aa)(?i)settings?.zip#,
  q#__KAM_SETTLEMENT3,[l=1]# => q#(?aa)(?i)lawsuit.information#,
  q#__KAM_SEX04_1,[l=1]# => q#(?aa)(?is)(curative|medicinal|salutary|wholesome|beneficial|satisfaction) effect|(first\-rated|splendid) drugs|(yellow|blue|famos) (tablet|pill)|good medical supplies|(commendable|valuable) medicines|canadian pharmacy|GNC|nugenix#,
  q#__KAM_SEX04_2,[l=1]# => q#(?aa)(?is)fun in bed|(bed|night) adventures|aid your bed|(lift|heave|ascent|hoist|raise|boost|aid) your (belove|love|darling|sex|sweet)|sexuality with assistance|ascent your sweet|bed experience|love sexuality#,
  q#__KAM_SEX04_4,[l=1]# => q#(?aa)(?is)longer your tool|sexual experience|empower your (belove|sex)|sweet sex|(not bad|great|nice|special|awesome|free) bonus|sex all night|lovers package|male.vitality|sex with new boys#,
  q#__KAM_SEX05_2,[l=0]# => q#(?aa)(?i)buy rubber friends|big bait in your pants|she sees your size|women will be funk|biggest tool|immense monster|women will be daydreaming|have so much meat|prolonging your size|last a lot longer#,
  q#__KAM_SEX06_1,[l=0]# => q#(?aa)(?i)more fire and passion#,
  q#__KAM_SEX1,[l=1]# => q#(?aa)(?i)(?:double[ -]?headed|pornstar|huge weenie|male power|\d\dper\. of men|male enhancement product|enlarge patch|boost up your virility|clinically tested|improve manhood|Bigger Pen..is|Big Penis|incredible gains to your manhood|muscular manhood|nights unsatisfied|climaxes|sensual enhancer|love instrument|bigger member|excitement with girls|fucker|animal sex)|adds \d inches to your manhood|pussy licked|hard.erection#,
  q#__KAM_SEX2,[l=1]# => q#(?aa)(?i)(?:(\b|^)cunt(\b|$)|busty|interracial|hardcore|peni(s|le) enlarge|generic quality|enlarge your manhood|stone\-hard manhood|XXL Dick|intense pleasure|spend a night with you|efficient medicine|turn on your wife|with your boner|dick dangl)|\d.(extra.)?inches.of.girth|best.sex#,
  q#__KAM_SEX2_2,[l=0]# => q#(?aa)(?i)dating site|bad girls|sexual community|discreet dating|pay for a chat|lover|horny|(adult|sex) chat|free women|i am discreet#,
  q#__KAM_SEX2_3,[l=1]# => q#(?aa)(?i)flirt for free|Fuck.?Free|sex.?club|naked glory|free.?sex|start writing me|canada.?sex|hot greetings|private hangout|get a massage#,
  q#__KAM_SEX2_4A,[l=0]# => q#(?aa)(?i)my pics#,
  q#__KAM_SEX4,[l=0]# => q#(?aa)(?i)(?:bring your girlfriend back|satisfied with their size|penis so huge and heavy|more semen|volume of your loads|wondercum|ejaculate|bargain offers on medic|improve xxx|improve your lovemaking|youngest teen|teen pics|monster in his pants|(female|multiple) orgasms|extreme penetration)#,
  q#__KAM_SEXEMOJI2,[l=0]# => q#(?aa)(?i)\x{F0}\x{9F}\x{8D}\x{91}|\x{F0}\x{9F}\x{92}\x{8B}#,
  q#__KAM_SEX_EXPLICIT4,[l=1]# => q#(?aa)(?i)(?:fucked hardcore|dildoes her tight ass|kinky watersports|schoolgirls? slut|teens? porn|first anal(\b|$)|pussy lips|kinky lesbian|sucks? cock|rub puss|spreads? cunt|fetish babe|kinky pee|muffdived \& fuck|deepthroat on knees|hello.naughty.boy|certain.type.of.guy|girlfriend.trick|sexual.stamina|sex...toy|porn.link|cunt.fuck|c\-o\-c\-k|non.stop.sex|porn.industry|stronger.erection|make.her.moan|extreme.pro.abortion|erection.problem|your.erection|get.an.erection|hardest.erection|get.erect|xxx gay|asian porn|blow ?job (comm?unity|porn)|anal xxx|huge tits tube|xxx tube|porn tube|fuckbook|portal for xxx|3d porn|DrPEnterprise|girlfriends.porn|\bsex.galler|pussy.eaten|shemale|(\b|^)anal.adventure|black.girls.video|gay.porn|pussy.wet|make.her.horny|crave sex|women.fuck|women.horny|wanting.to.bang|getting.laid.is.simple|woman.on.her.knees|b r e a s t|generic.ed.product|best.sex|f[^a-z]cking.you|f[^a-z]ckbuddy|F[hash]ckFriends|Milf Selfies|need.a.horny.man|cute.sex.lover|horny.as.f.ck|fun.in.the.bedroom|my.tits.are|be.horny|horny.girl|horny.i.am|horny.latina|huge.dildo|made.me.climax|sex in my office|a.good.f\@ck|married.horny.woman|sucked.your.d\@ck|(naughty|horny).milf|suck.you.off|horny.stories|all.my.h[o0]les|cum.heavily|sucking.your.c[o0]ck|to.get.f[^a-z]cked)|h00kup|s\*xy|\bh0rny|ch0ked|pu\$\$y|f\*cked|F\*ck_|find milfs|girls (from|in) your city|rock.?hard boner|reclaiming your manhood|sexy and horny|bad girls from your city|awesome in bed|turbo\-charge your bed|shocking erection|stiffening tonic|anal fun|fingering videos|willing to pay for sex|c\*ck size#,
  q#__KAM_SEX_EXPLICIT6,[l=0]# => q#(?aa)(?i)virus on a porn web#,
  q#__KAM_SEX_GROUPS3,[l=0]# => q#(?aa)(?i)(escort (company|job|section)|sexual needs|sexy lady|sexual?ly fit|fucked hard|local hotties|secret community|hq escorts|good fuck|naughty date|male escort)#,
  q#__KAM_SHADYCC1,[l=1]# => q#(?aa)(?i)(transactions?|purchases?) from your (online store|web-?shop)#,
  q#__KAM_SHADYCC3,[l=0]# => q#(?aa)(?i)(four|4) of (my|the) (master)?card#,
  q#__KAM_SHADYCC4,[l=0]# => q#(?aa)(?i)(detailed|full) statement#,
  q#__KAM_SHAM3,[l=0]# => q#(?aa)(?i)ShamWow#,
  q#__KAM_SHAM4,[l=0]# => q#(?aa)(?i)20(X| times) its weight#,
  q#__KAM_SHARKTANK_BODY,[l=0]# => q#(?aa)(?i)shark tank#,
  q#__KAM_SHARP1,[l=0]# => q#(?aa)(?i)sharp for life#,
  q#__KAM_SHARP2,[l=0]# => q#(?aa)(?i)yoshiblade#,
  q#__KAM_SHARP3,[l=0]# => q#(?aa)(?i)zirconium oxide#,
  q#__KAM_SHARP4,[l=0]# => q#(?aa)(?i)ceramic knife#,
  q#__KAM_SHOCK1,[l=1]# => q#(?aa)(?i)shocking.beverage#,
  q#__KAM_SHOCK3,[l=0]# => q#(?aa)(?i)drinking this beverage#,
  q#__KAM_SHOP2,[l=1]# => q#(?aa)(?is)Do you like to shop#,
  q#__KAM_SHOP3,[l=1]# => q#(?aa)(?is)make money while you shop#,
  q#__KAM_SIGN2,[l=0]# => q#(?aa)(?i)review your account#,
  q#__KAM_SIGN3,[l=0]# => q#(?aa)(?i)verification is processed#,
  q#__KAM_SILD2,[l=0]# => q#(?aa)(?i)(XtraSize\+|Sildenafil Citrate)#,
  q#__KAM_SINGING3,[l=1]# => q#(?aa)(?i)terrible.singer|more.talent|love.songs#,
  q#__KAM_SKIN4,[l=1]# => q#(?aa)(?i)feet feel smooth and healthy|calluses and dead skin|silky smooth skin|tighter skin|\d.years.younger|anti[- ]aging|look younger|free trial|lose 25 years|angered plastic surge|quick and easy trick|anti-?aging|blood pressure low|heart rate monitor|selfies|just.one.month|just.four.weeks|medical.research|rebuild.your.skin|decades.younger|erase.time|gossip|smooth.lines#,
  q#__KAM_SKINCELL1,[l=1]# => q#(?aa)(?i)Skincell.Pro#,
  q#__KAM_SKYPE4,[l=1]# => q#(?aa)(?i)Promo Code: \d#,
  q#__KAM_SKYTECH3,[l=0]# => q#(?aa)(?i)skytech wifi|Wifi Booster#,
  q#__KAM_SLICEOMATIC3,[l=0]# => q#(?aa)(?i)Slice\-o\-matic#,
  q#__KAM_SMOKE1,[l=1]# => q#(?aa)(?i)smoke.anywhere|electronic cig|smoking alternative|prado|\be.?\-?cig|wanting to quit#,
  q#__KAM_SMOKE4,[l=1]# => q#(?aa)(?i)No carbon monoxide|Smokeless Direct|No Tobacco|no tar|no cancer|quit smoking|electronic cig|sinless.vapor#,
  q#__KAM_SMOKE5,[l=0]# => q#(?aa)(?i)you have qualified#,
  q#__KAM_SNORE3,[l=1]# => q#(?aa)(?i)stop snoring|zquiet|Jaw Supporter|get.rest|end.snoring|more.rest|to.be.tired#,
  q#__KAM_SOCKET3,[l=0]# => q#(?aa)(?i)side socket#,
  q#__KAM_SOFTWARE3,[l=0]# => q#(?aa)(?i)Fix file errors#,
  q#__KAM_SOFTWARE4,[l=0]# => q#(?aa)(?i)download for no cost|FREE Software|Free Analysis|Free Report#,
  q#__KAM_SOLAR3,[l=1]# => q#(?aa)(?i)power bill in half|go solar|approved for solar|solar system saves|reduce your electric|energy.cost|energy.bill|government.incentive|can.profit|utility.bill|switch(ing)?.to.solar|solar.incentive|solar.now|US Solar Dept|your.electric.bill|your.home.qualifies|yard lights|solarglow#,
  q#__KAM_SOMETLD_ARE_BAD_TLD_PROGRAM_REF,[l=1]# => q#(?aa)(?i)\.date ?\{#,
  q#__KAM_SPAMKING1,[l=1]# => q#(?aa)(?is)This advertisement is presented by#,
  q#__KAM_SPAMKING2,[l=1]# => q#(?aa)(?is)If you have any questions or concerns regarding this communication, please send correspondence#,
  q#__KAM_SPAMKING3,[l=1]# => q#(?aa)(?is)To .{0,30}(?:unsubscribe|stop|remove) .{0,35}(?:email|messages) from third party advertisers#,
  q#__KAM_SPAMKING4,[l=1]# => q#(?aa)(?is)notify .{0,30} that you no longer wish to receive (?:promotional )?messages#,
  q#__KAM_SPAMKING5,[l=1]# => q#(?aa)(?is)This (communication|message) was delivered to you by#,
  q#__KAM_SPAMKING6,[l=1]# => q#(?aa)(?is)(?:please send|Forward postal) correspondence to#,
  q#__KAM_SPO2_1,[l=0]# => q#(?aa)(?i)pulse oximeter|touchless thermometer#,
  q#__KAM_SPY3,[l=1]# => q#(?aa)(?i)spy.?camera.?system|hidden.spy.camera|valuables.safe|protect.your.children|smartcam pro#,
  q#__KAM_STAR1,[l=0]# => q#(?aa)(?i)REMOVE ("\*"|space) (in the above|to make the) link#,
  q#__KAM_STATLER3,[l=0]# => q#(?aa)(?i)Mike Statler#,
  q#__KAM_STOCK2_1,[l=1]# => q#(?aa)(?i)(good trader|trading experience|bad trading day|hard trading day|FREE Stock Market Outlook|Market Watch)|more.than.\d+%|most.valuable|morning.report|real.?estate.authority|commercial.real.estate#,
  q#__KAM_STOCK2_2,[l=1]# => q#(?aa)(?i)(easy cash|losses and victories|backstage trading|market facts|succeed in trading|destined to skyrocket|make traders rich|times your principal)|good.investment|overvalued.companies|company.is.soaring|economic.opportunity|amazing.company|take.notice|rental.yield|high.return#,
  q#__KAM_STOCK2_3,[l=0]# => q#(?aa)(?i)stock#,
  q#__KAM_STOCK2_4,[l=0]# => q#(?aa)(?i)trader|investor|analyst|royalties#,
  q#__KAM_STOCK3,[l=1]# => q#(?aa)([sS].?ymbol|Sym|SYM|SYMB|Symb|SYMBOL|SYmN|SYMN|Symn|Ticker|TICKER|Lookup|PINKSHEETS)\s*[-_:]\s*[A-Z0-9][-\._ ]?[A-Z0-9][-\._ ]?[A-Z0-9][-\._ ]?[A-Z0-9]#,
  q#__KAM_STOCKOBFU1,[l=1]# => q#(?aa)(?i)make up the \d letter symbol#,
  q#__KAM_STOCKOBFU2,[l=0]# => q#(?aa)(?i)first letter#,
  q#__KAM_STOCKTIP121,[l=1]# => q#(?aa)(?is)(VISION AIRSHIPS|(\b|^)VPSN(\b|$))#,
  q#__KAM_STOCKTIP122,[l=1]# => q#(?aa)(?is)(Shandong Zhouyuan Seed and Nursery|(\b|^)SZSN(\b|$))#,
  q#__KAM_STOCKTIP124,[l=1]# => q#(?aa)(?is)((\b|^)VGPM(\b|$)|Vega Promotional Sys)#,
  q#__KAM_STOCKTIP127,[l=1]# => q#(?aa)(?is)(Physical Property Holdings|(\b|^)PPYH(\b|$))#,
  q#__KAM_STOCKTIP128,[l=1]# => q#(?aa)(?is)(MONUMENTAL MARKETING|(\b|^)MNUM(\b|$))#,
  q#__KAM_STOCKTIP129,[l=1]# => q#(?aa)(?is)(EnerBrite Technologies Group|(\b|^)eTgU(\b|$))#,
  q#__KAM_STOCKTIP130,[l=1]# => q#(?aa)(?is)(Pricester|(\b|^)PRCC(\b|$))#,
  q#__KAM_STOCKTIP131,[l=1]# => q#(?aa)(?is)(Greenstone Holdings|(\b|^)GSHN(\b|$))#,
  q#__KAM_STOCKTIP132,[l=1]# => q#(?aa)(?is)((\b|^)AGMS(\b|$)|Angstrom[- ]Microsystems)#,
  q#__KAM_STOCKTIP133,[l=1]# => q#(?aa)(?is)(Pluris Energy|(\b|^)PEYG(\b|$))#,
  q#__KAM_STOCKTIP134,[l=1]# => q#(?aa)(?is)(United Consortium|(\b|^)UCSO(\b|$))#,
  q#__KAM_STOCKTIP135,[l=1]# => q#(?aa)(?is)(Dominion Minerals|(\b|^)DMNM(\b|$))#,
  q#__KAM_STOCKTIP136,[l=1]# => q#(?aa)(?is)(PrimeGen Energy|(\b|$)PGNE(\b|^))#,
  q#__KAM_STOCKTIP137,[l=1]# => q#(?aa)(?is)Dynamic Response Group|(\b|^)DRGZ(\b|$)#,
  q#__KAM_STOCKTIP138,[l=1]# => q#(?aa)(?is)Cobra Oil (and|&) Gas|(\b|^)CGCA(\b|$)#,
  q#__KAM_STOCKTIP139,[l=1]# => q#(?aa)(?is)Solanex Management|(\b|^)SLNX(\b|$)#,
  q#__KAM_STOCKTIP140,[l=1]# => q#(?aa)(?is)BIO\-SOLUTIONS|(\b|^)BISU(\b|$)#,
  q#__KAM_STOCKTIP142,[l=1]# => q#(?aa)(?is)Hawk Systems Inc|(\b|^)HWSYD(\b|$)#,
  q#__KAM_STOCKTIP143,[l=1]# => q#(?aa)(?is)AmeriLithium#,
  q#__KAM_STOCKTIP144,[l=1]# => q#(?aa)(?is)Fleet Management Solutions|(\b|^)FLMG(\b|$)#,
  q#__KAM_STOCKTIP146,[l=1]# => q#(?aa)(?is)Plandai|(\b|^)PLPL(\b|$)#,
  q#__KAM_STOCKTIP147,[l=1]# => q#(?aa)(?is)Beamz Interactive|(\b|^)BZIC(\b|$)#,
  q#__KAM_STOCKTIP148,[l=1]# => q#(?aa)(?i)(\b|^)STBV(\b|$)#,
  q#__KAM_STOCKTIP149,[l=1]# => q#(?aa)(?i)LifeApps|(\b|^)LFAP(\b|$)#,
  q#__KAM_STOCKTIP150,[l=0]# => q#(?aa)(?i)MONARCHY RESOURCES#,
  q#__KAM_STOCKTIP151,[l=0]# => q#(?aa)(?i)Alanco Tech#,
  q#__KAM_STOCKTIP152,[l=0]# => q#(?aa)(?i)Siga Resources#,
  q#__KAM_STOCKTIP153,[l=1]# => q#(?aa)(?is)INSCOR|(\b|^)IOGA(\b|$)#,
  q#__KAM_STOCKTIP154,[l=1]# => q#(?aa)(?is)mLight Tech|(\b|^)MLGT(\b|$)#,
  q#__KAM_STOCKTIP155,[l=1]# => q#(?aa)(?is)Alanco Technologies#,
  q#__KAM_STOCKTIP156,[l=1]# => q#(?aa)(?is)Progress Watch|(\b|^)PROW(\b|$)#,
  q#__KAM_STOCKTIP163,[l=1]# => q#(?aa)(?is)(\b|^)(brixmor)(\b|$)#,
  q#__KAM_STOCKTIP166,[l=1]# => q#(?aa)(?is)(\b|^)(INCT|Incapta)(\b|$)#,
  q#__KAM_STOCKTIP167,[l=1]# => q#(?aa)(?is)(\b|^)(QSMS|Quest Science Management Gate)(\b|$)#,
  q#__KAM_STUDENT3,[l=1]# => q#(?aa)(?i)penalt(y|ies)|garnish|your.debt|president.loan|reduce.(your.)?(student.)?loan|forgiveness.plan|qualify.for|federal.program|low.monthly#,
  q#__KAM_STUDENTLOAN1,[l=0]# => q#(?aa)(?i)(National|Federal) Student Loan Status#,
  q#__KAM_STUDENTLOAN2,[l=0]# => q#(?aa)(?i)consolidate your loan#,
  q#__KAM_STUDENTLOAN3,[l=0]# => q#(?aa)(?i)doesn't injured#,
  q#__KAM_STUDENTLOAN4,[l=0]# => q#(?aa)(?i)866-351-4693#,
  q#__KAM_STUDENTLOAN5,[l=0]# => q#(?aa)(?i)(financial troubles|debt) is (understood|forgiven)#,
  q#__KAM_SUNGLASSES2,[l=1]# => q#(?aa)(?i)great ray|hot.deal#,
  q#__KAM_SUNGLASSES3,[l=1]# => q#(?aa)(?i)style rocks|today.only#,
  q#__KAM_SUPERHUMAN3,[l=1]# => q#(?aa)(?i)reclaim your glory|stay hot and sexy|unfair.advantage|better sex|weird trick|testosterone#,
  q#__KAM_SURVEY3,[l=0]# => q#(?aa)(?i)Do You Use Instagram|Complete the survey|win a great prize#,
  q#__KAM_SWIFT2,[l=0]# => q#(?aa)(?i)swift copy#,
  q#__KAM_SWIFT3,[l=0]# => q#(?aa)(?i)balance payment#,
  q#__KAM_SWIPE3,[l=1]# => q#(?aa)(?i)pennies on the dollar|join, bid|penny (auctions|stock)|\d% .{0,10}retail|ipads on auction|bid now|factory sealed ipads|cheap ipads|for pennies|ebay killer|Inventory Clearance on iPads|crazy auctions|XPS for \d\dUSD|iphone.{1,10}clearance|the.hottest#,
  q#__KAM_SWIPE4,[l=1]# => q#(?aa)(?i)SwipeBids|Swipe Auction|CIRCLE MEDIA BIDS|Wavee|BIGGER BIDDER|Bidooka|Sellmoo|overstocked auctions|for pennies|\d{1,2} cent#,
  q#__KAM_TAX3,[l=1]# => q#(?aa)(?i)File your taxes for free|need more time|back.taxes|tax relief|irs offer|avoid penalty|stop.aggressive.collections|relief.(program|package)|tax.settlement|settlement.package|paying.bills|paying.tax|back.tax|wage..?garnish|tax.help|remove.lien|bankrupt|urgent.tax.notice|could.change.everything|instantly.save.you#,
  q#__KAM_TAX4,[l=1]# => q#(?aa)(?i)MSNBC|fox news|\bCNN\b|please.confirm|you.qualify|obtain.now|must.see.tax#,
  q#__KAM_TELEWORK1,[l=1]# => q#(?aa)(?is)(generate|make) .{0,10}1.5K? (to|-) 3.5K (a day|daily|per day|per month)|makes? \$[\d,]+\/month|upgrade your salary#,
  q#__KAM_TELEWORK2,[l=1]# => q#(?aa)(?is)have a (?:tele)?phone|money making challenge|has full internet#,
  q#__KAM_TELEWORK3,[l=1]# => q#(?aa)(?is)return(?:ing)? (phone )?calls|working a few hours each day|positive work environment#,
  q#__KAM_TELEWORK4,[l=1]# => q#(?aa)(?is)fully qualified|no experience needed|all the training|managing expectations|accountability|stronger results#,
  q#__KAM_TELEWORK5,[l=1]# => q#(?aa)(?is)work (?:online )?from home|process(?:ing)? rebates (?:at|from) home|set your own hours|100% no risk|Western Union fees|new job or career#,
  q#__KAM_TELEWORK6,[l=1]# => q#(?aa)(?is)earning up to \d+USD|earn thousands of dollars|\d% commission|get rich quick|manager training|real.payoff#,
  q#__KAM_TESTOSTERONE3,[l=1]# => q#(?aa)(?i)Boost your testosterone|get your body back|low.testosterone#,
  q#__KAM_TESTOSTERONE4,[l=1]# => q#(?aa)(?i)Testoril|sexual confidence|androgel|axiron+androderm#,
  q#__KAM_TIME2,[l=1]# => q#(?aa)(?is)(replica(\b|$)|diamond|designer[-_ ](piece|collections|watch)|time[-_ ]piece|wrist|time\-keeper|\/\/atch)#,
  q#__KAM_TIME4,[l=1]# => q#(?aa)(?i)(\b|^)(time|watch)(\b|$)#,
  q#__KAM_TIME5,[l=1]# => q#(?aa)(?i)(funny|low) price|treat.yourself#,
  q#__KAM_TIME6,[l=0]# => q#(?aa)(?i)(Cx?ARTIER|Bx?REITLING|Px?ATEK|Rx?OLEX|Bx?VLGARI|Tx?IFFANY)#,
  q#__KAM_TIMESHARE1,[l=1]# => q#(?aa)(?is)Get[- ]Cash for Your Timeshare|not using your timeshare|(unwanted|ugly) timeshare|cash out quickly#,
  q#__KAM_TIMESHARE2,[l=1]# => q#(?aa)(?is)goldmine|sell or rent it|we pay cash|sell\/rent your time|own a timeshare or condo|get.cash|find.your.value#,
  q#__KAM_TINNI1,[l=0]# => q#(?aa)(?i)TinniFix#,
  q#__KAM_TINNI2,[l=0]# => q#(?aa)(?i)Stop the ringing in your ears#,
  q#__KAM_TINNITUS3,[l=1]# => q#(?aa)(?i)scientifically.proven|end.tinnitus|get rid of the ringing|shocking presentation|IVY League|doctors are baffled|restores your hearing|no more buzzing#,
  q#__KAM_TIP3,[l=0]# => q#(?aa)(?i)undereye bags#,
  q#__KAM_TIP4,[l=0]# => q#(?aa)(?i)Find Out This Quick New Trick#,
  q#__KAM_TIRES3,[l=0]# => q#(?aa)(?i)savings on tire|new tires#,
  q#__KAM_TLDSCHINA1,[l=1]# => q#(?aa)(?i)t ?l ?d ?s ?c ?h ?i ?n ?a\[\.\]com|0086\-21\-619\-18\-696#,
  q#__KAM_TOLL3,[l=1]# => q#(?aa)(?i)have.not.paid|your.debt|invoice#,
  q#__KAM_TOURS3,[l=1]# => q#(?aa)(?i)your.adventure.tour|your.event#,
  q#__KAM_TRADEBOT3,[l=1]# => q#(?aa)(?i)(auto|crypto|new|trader?|unique).?bot|automatic machine|pro tariff|free monthly tariff|fully automatic#,
  q#__KAM_TRADEBOT4,[l=0]# => q#(?aa)(?i)initial deposit|crytpocurrency trading|(field|world) of (trading|crypto)|make money on trading|solution for the trader|without investing|no investment|(find|news) for trader|traders can relax|lazy trader|currency trading#,
  q#__KAM_TRADEBOT5,[l=1]# => q#(?aa)(?i)(make|earn) from \d+ (\$+|USD|Eur|dollar)|(earn|make) \d+ (\$+|USD|Eur|dollar)|(over|more than) [\d,]+ (dollar|USD|Eur)#,
  q#__KAM_TRADEBOT6B,[l=0]# => q#(?aa)(?i)(personal|private|your) (secure )?link|link (below )?from PDF#,
  q#__KAM_TRAINING2,[l=0]# => q#(?aa)(?i)intranet|training calendar#,
  q#__KAM_TRAINING3,[l=0]# => q#(?aa)(?i)Human Resources#,
  q#__KAM_TRIAL,[l=1]# => q#(?aa)(?i)RISK-FREE Trial|Free \d+ day trial|try it free|free.dvd.info|free.info.kit|limited..?trial|claim.package#,
  q#__KAM_TRUMPCOIN1,[l=0]# => q#(?aa)(?i)Donald Trump#,
  q#__KAM_TRUMPCOIN3,[l=0]# => q#(?aa)(?i)special colored coin#,
  q#__KAM_TUB3,[l=1]# => q#(?aa)(?i)Walk.?in (hot.?|bath.?)?tub|bath and massage|easy transfer from a wheelchair#,
  q#__KAM_TUPPERWARE3,[l=0]# => q#(?aa)(?i)tupperware lid|food storage|storage container#,
  q#__KAM_TV1,[l=1]# => q#(?aa)(?i)watch unlimited television|DTV4PC|Online TV Code|Free DVD\-CD Burner|100% legal|Rabbit TV|reliable.cable.service|existing.smart.tv#,
  q#__KAM_TV2,[l=1]# => q#(?aa)(?i)without a monthly fee|pay a cable or satellite bill|no monthly fee|watch uncensored|movies online|no censorship|favorite.channels|online.television|\d{3}.channels|high.speed|sysview#,
  q#__KAM_TVDOCTOR3,[l=1]# => q#(?aa)(?i)clinical|miracle|dermatologist|anti.?.?aging.tip|\d+.years.younger|wrinkle.(reduction|prevention)|\bOMG!\b|loose.\d+.lb|tv.doctor#,
  q#__KAM_UKINV2,[l=0]# => q#(?aa)(?i)View (and pay )?(scan|invoice)#,
  q#__KAM_UKINV3,[l=1]# => q#(?aa)(?i)INV-\d+|Check out what .{4,30} shared with you#,
  q#__KAM_UKINV4,[l=0]# => q#(?aa)(?i)&pound;#,
  q#__KAM_UNIV1,[l=1]# => q#(?aa)(?is)(University Administration|University Enrollment|Education Assessment|Faculty Assessment|University Degree|Administration Office|Education office|Schools office|Enrollment Office|Online University)#,
  q#__KAM_UNIV12,[l=1]# => q#(?aa)(?is)(obtain your diploma|diploma that you want|Criminal Justice or Homeland Security degree)#,
  q#__KAM_UNIV13,[l=1]# => q#(?aa)(?is)(degree|field|diploma) of your (choice|expertise)#,
  q#__KAM_UNIV14,[l=1]# => q#(?aa)(?is)(earn a|full) transcript#,
  q#__KAM_UNIV16,[l=1]# => q#(?aa)(?is)\d weeks.{0,30}graduated#,
  q#__KAM_UNIV18,[l=1]# => q#(?aa)(?is)100% discrete#,
  q#__KAM_UNIV1B,[l=1]# => q#(?aa)(?i)\d (months|weeks)#,
  q#__KAM_UNIV2,[l=1]# => q#(?aa)(?is)\d (week|month).{0,30}degree#,
  q#__KAM_UNIV3,[l=1]# => q#(?aa)(?is)(past work|based on your|earned from|life|life and work|present work) experience#,
  q#__KAM_UNIV4,[l=1]# => q#(?aa)(?is)not official degree|non[ -]?accredited#,
  q#__KAM_UNIV4B,[l=1]# => q#(?aa)(?is)1.?0.?0.?% (legit|verifiable|online|no pre|non[- ]?accredited)#,
  q#__KAM_UNIV5,[l=1]# => q#(?aa)(?is)novelty (degree|use)#,
  q#__KAM_UNIV5B,[l=1]# => q#(?aa)(?is)F A S T[ ]{0,4}T R A C K#,
  q#__KAM_UNIV6,[l=1]# => q#(?aa)(?is)verifiable University Degree#,
  q#__KAM_UNIV6B,[l=1]# => q#(?aa)DIP\sLOMA#,
  q#__KAM_UNIV7,[l=1]# => q#(?aa)(?is)(life|work) experience (diploma|degree|transcript)#,
  q#__KAM_UNIV8,[l=1]# => q#(?aa)(?is)Career Path#,
  q#__KAM_UNIV9,[l=1]# => q#(?aa)(?is)non[- ]?ac(creditee?d)?.{1,10}universit#,
  q#__KAM_UNREAD2,[l=0]# => q#(?aa)(?i)relationship status#,
  q#__KAM_UNREAD3,[l=0]# => q#(?aa)(?i)(see more of me here|photo album)#,
  q#__KAM_UNSOLICITED1,[l=0]# => q#(?aa)(?i)Sorry for the unsolicited email#,
  q#__KAM_UNSUB1,[l=0]# => q#(?aa)(?i)cancel 0ffers#,
  q#__KAM_UNSUBSCRIBE,[l=1]# => q#(?aa)(?i)can always unsubscribe|unsubscribe here|stop receiving e?mail|send post-?mail#,
  q#__KAM_UPS3,[l=1]# => q#(?aa)(?i)invoice copy attached|\d in UPS Rewards#,
  q#__KAM_URGENT2,[l=0]# => q#(?aa)(?i)urgent respond#,
  q#__KAM_URGENT3,[l=0]# => q#(?aa)(?i)private e?mail#,
  q#__KAM_URGENT4,[l=0]# => q#(?aa)(?i)god bless#,
  q#__KAM_URGENT5,[l=0]# => q#(?aa)(?i)address still valid#,
  q#__KAM_URI_OBFU1,[l=1]# => q#(?aa)(?i)w ?w ?w\[?.\]?asiane ?twork\[?.\]?org\[?.\]?cn#,
  q#__KAM_URI_OBFU2,[l=1]# => q#(?aa)(?i)w ?w ?w\[?.\]?netchin ?a\[?.\]?org#,
  q#__KAM_URONLINE1,[l=1]# => q#(?aa)(?i)(chat|chat with me|hook ?up) on Y ?A ?H ?O ?O (tonight|or MSN)|add me with yahoo or msn|view now|press this web link|send me your? photo|can u turn me on|kissing you|begin.a.chat#,
  q#__KAM_URONLINE2,[l=1]# => q#(?aa)(?i)wanna talk|ur info|found your mail|found ur profile|mutual friend|katya from russia|you came to russia|my gentle sun|see this page I made|match making heaven|meet that special|comee see it over here|hexten.net|looking for a man|waiting for ur mail|found ur account|waiting for your message|casual.hookup#,
  q#__KAM_URONLINE3,[l=1]# => q#(?aa)(?i)get (naked|naughty)|horny|naughty toys|I will do anything|TOTALLY msg me on MSN|tell me your mobile|I remember you|let's talk|ran across someone like u|sexywebdating|chatting with someone|saw you by BJs|private e\-?mail|dating portal|looking.for.fun#,
  q#__KAM_URUNIT1,[l=1]# => q#(?aa)(?is)\bur (unit|liveliness|energy level|endurance level)#,
  q#__KAM_URUNIT2,[l=1]# => q#(?aa)(?is)\bur (gf|girl|wife|size|thing|partner|significant other)#,
  q#__KAM_URUNIT3,[l=1]# => q#(?aa)(?is)(unsatisfied|not satisfied|nagging|complaining|complaints|complained|unlimited prowess|increase your volume)#,
  q#__KAM_URUNIT3A,[l=1]# => q#(?aa)(?is)\b(exasperated|fatigued|drained|tired) all the time#,
  q#__KAM_URUNIT4,[l=1]# => q#(?aa)(?is)(bedroom|the bed|nighttime activit|male power|show your girl)#,
  q#__KAM_URUNIT5,[l=1]# => q#(?aa)(?is)(size of (there|their|your) .{0,11}(unit|thing)|using them for a couple months|enhancing formula)#,
  q#__KAM_URUNIT6,[l=1]# => q#(?aa)(?is)(majority of women|shrinking .{0,12} baby fat|winning guy|huge explosion)#,
  q#__KAM_URZEST2,[l=0]# => q#(?aa)(?i)or still (?:jaded|worn|drained|exasperated) all the time#,
  q#__KAM_URZEST3,[l=0]# => q#(?aa)(?i)(?:(?:wanting|looking|seeking) to get in the gym|(?:dreaming|seeking|hoping) to get (?:into shape|fit))#,
  q#__KAM_URZEST4,[l=0]# => q#(?aa)(?i)(wks it has been|been mos) since we('| ha)ve chatted#,
  q#__KAM_URZEST5,[l=0]# => q#(?aa)(?i)(back into shape|made me healthier after my disease)#,
  q#__KAM_USB1,[l=0]# => q#(?aa)(?i)(debi|deborah brown|Melissa Sylvan)#,
  q#__KAM_USB2,[l=0]# => q#(?aa)(?i)person (that|who) handles the promotions#,
  q#__KAM_USB3,[l=1]# => q#(?aa)(?i)usbsmg.com#,
  q#__KAM_VACATION3,[l=1]# => q#(?aa)(?i)Resorts FOR FREE|(carr?ibb?ean|alaskan?).cruise|top deals#,
  q#__KAM_VERIZON4,[l=0]# => q#(?aa)(?i)Update required immediately#,
  q#__KAM_VERIZON5,[l=0]# => q#(?aa)(?i)update your account information#,
  q#__KAM_VERIZON6,[l=0]# => q#(?aa)(?i)deactivated#,
  q#__KAM_VERIZON7,[l=0]# => q#(?aa)(?i)credit card|bank account#,
  q#__KAM_VEST1,[l=0]# => q#(?aa)(?i)(heated|thermal) vest#,
  q#__KAM_VIAGRA1,[l=0]# => q#(?aa)(?i)V I A G R A|C I A L I S|V A L I U M|X A N A X#,
  q#__KAM_VIAGRA4A,[l=1]# => q#(?aa)(?i)V (. )?A (. )?L (. )?[I\/t] (. )?U (. )?M#,
  q#__KAM_VIAGRA4B,[l=1]# => q#(?aa)(?i)V (. )?[I\/t] (. )?A (. )?G (. )?R (. )?A#,
  q#__KAM_VIAGRA7A,[l=1]# => q#(?aa)(?i)(^|\b)V[ij]+AGRA($|\b)#,
  q#__KAM_VIAGRA7C,[l=1]# => q#(?aa)(?i)(^|\b)AMB[ij]+EN($|\b)#,
  q#__KAM_VIAGRA7D,[l=1]# => q#(?aa)(?i)(^|\b)VAL[ij]+UM($|\b)#,
  q#__KAM_VIAGRA8A,[l=1]# => q#(?aa)(?i)VI...?AGRA#,
  q#__KAM_VIAGRA8B,[l=1]# => q#(?aa)(?i)AM...?BIEN#,
  q#__KAM_VIAGRA8C,[l=1]# => q#(?aa)(?i)VA...?LIUM#,
  q#__KAM_VIAGRA8D,[l=1]# => q#(?aa)(?i)CI...?ALIS#,
  q#__KAM_VIAGRA9A,[l=1]# => q#(?aa)(?i)V[IL1]A..GRA#,
  q#__KAM_VIAGRA9B,[l=1]# => q#(?aa)(?i)AMB..IEN#,
  q#__KAM_VIAGRA9C,[l=1]# => q#(?aa)(?i)VAL..IUM#,
  q#__KAM_VIAGRA9D,[l=1]# => q#(?aa)(?i)C[IL1]A..LIS#,
  q#__KAM_VISION3,[l=1]# => q#(?aa)(?i)100%.natural|vision.restored|currently.wear.(glasses|contacts)|perfect.vision|risky.surgery|corrective.surgery|dangers.of.surgery|laser.eye|eye.care|making.your.eyes.worse|your.glasses|worsen.your.vision|special.prices|vision.in.\d+.day|vision.in.\d+.week#,
  q#__KAM_VM4,[l=1]# => q#(?aa)(?i)recorded voice|audio message|Caller.?id|CID:|mailbox \d|sign document|new vm on#,
  q#__KAM_WALKINTUB3,[l=1]# => q#(?aa)(?i)walk.?in.?tub#,
  q#__KAM_WARRANTY2,[l=0]# => q#(?aa)(?i)Protect your home|choice home warranty|unexpected repair#,
  q#__KAM_WARRANTY3,[l=0]# => q#(?aa)(?i)home warrant|complimentary insurance quote#,
  q#__KAM_WATER1,[l=0]# => q#(?aa)(?i)Never Drink Water#,
  q#__KAM_WATER3,[l=0]# => q#(?aa)(?i)filtered tap water#,
  q#__KAM_WATERHACK2,[l=0]# => q#(?aa)(?i)water hack#,
  q#__KAM_WEB2,[l=1]# => q#(?aa)(?i)indian?.based.(web|it)|certified.it.company|offering Website Design|(expert|based) in india|software development.{0,2}firm|develop your web|(app|android|pad|phone) development#,
  q#__KAM_WEB2_2,[l=1]# => q#(?aa)(?i)(inexpensive|affordable) (quot|price)|cheap website|less than half|free of cost|low package price|indian web.?design|\(India\)|i am a professional|team of experts|i am from india|development company#,
  q#__KAM_WEB2_3,[l=0]# => q#(?aa)(?i)web(site)? (design|develop)|(better|new|refreshed) website|website audit|fresh look|redesign your website|mobile application devel|redesign your existing web|apps solution#,
  q#__KAM_WEB2_4,[l=1]# => q#(?aa)(?i)portfolio|sample|insights|special offer|page 1|(any|your) requirements|anything you can imagine|send you a quote|share a few example|you'?re? requirement|share your requirement#,
  q#__KAM_WEB3,[l=1]# => q#(?aa)(?i)Online Marketing (Executive|Consultant)|possible.redesign|seo.service|mobiles?.app|business.develop|commerce.solution#,
  q#__KAM_WEBINAR4,[l=1]# => q#(?aa)(?i)executive.education|contactid|register now|\d+.minute webinar|management.position|supervising.skills|discover.tips|register.early|take.control|marketing.capabilit|drive.more.sales|leveraging.cloud|solution.provider|have.a.handle|plan.to.divest|being.informed|upcoming.webinar|spearfishing.email|increase.revenue|industry.podcast|\d+.in.depth.tips|early.bird.offer|pmp.certified|lunch.briefing#,
  q#__KAM_WEB_OBFUSCATION1,[l=1]# => q#(?aa)(?i)check over this commercial|see the commercial.advertisement#,
  q#__KAM_WEED1,[l=1]# => q#(?aa)(?i)legal.weed|jim kramer|kevin james#,
  q#__KAM_WEED3,[l=0]# => q#(?aa)(?i)doubled? (there|their) money|Triple this afternoon#,
  q#__KAM_WEED4,[l=1]# => q#(?aa)(?i)(weed|pot).stock#,
  q#__KAM_WEIGHT1,[l=1]# => q#(?aa)(?is)(overweight|extra weight|glutting|shed fat|burns fat|burn calories|appetite suppressant|stimulate your metabolism|unwanted weight|duet of the year|healthy energy boost|Suppresses Appetite|internal cleansing|detoxify|cellulite|unsightly bulges|fat burn|Diet of the year|acai|cuts cholesterol|cleanse excess waste|free sample|unwanted weight|Acai suppl[ie]ments|Diet\/Detox|[hash]1 Weight Loss|lose body fat|(lose|drop) (about )?\d+\s*[li]b|calorie burning machine|before eating carbs)|flush.fat.away|slimming.down|\d+.pounds.gone|lose.\dx|highest.rated.episode|unwanted..?gain|too.goo?d.to.be.true|get.slim|tv.segment|weird.solution#,
  q#__KAM_WEIGHT2,[l=1]# => q#(?aa)(?is)\b(\d pounds|lose[_ ]weight|suppress appetite|appetite out of control|Oprah|for cancer patients|colon cure|colon cleanse|colonmate|avai berry|acai burn|ultraslim|feel energized|excess[_ ]weight|no diet changes|no exercise|hollywood'?s hottest \-?diet|acai berry edge|Acai Diet|top secret diet|Power HCG|Sensa|shocking method|Jennifer Aniston|before eating carbs|all natural weight.?loss|green fruit|top celeb's diet)|one.secret|enjoying.food|f\-a\-t|melt.fat|squeeze into them|crazy.workout|celebs.everywhere|zero.effort|nothing.to.lose#,
  q#__KAM_WEIGHT2_1,[l=0]# => q#(?aa)(?i)goodbye to her waist|wild transformation|researcher has just discovered|weight loss is wrong#,
  q#__KAM_WEIGHT2_3,[l=1]# => q#(?aa)(?i)melissa mccarthy|now looks \d+|lbs every \d+ hour|(pound|lb)s in \d+ days|melts pounds#,
  q#__KAM_WEIRDC19_3,[l=0]# => q#(?aa)(?i)The virus that causes COVID-19#,
  q#__KAM_WEIRDTRICK2,[l=1]# => q#(?aa)(?i)'?(weird|odd|strange)'?.(new.)?(trick|tip)|strange trick|shocking.truth#,
  q#__KAM_WHATS3,[l=1]# => q#(?aa)WhatsApp#,
  q#__KAM_WHITEN2,[l=0]# => q#(?aa)(?i)whitener#,
  q#__KAM_WHITEN3,[l=0]# => q#(?aa)(?i)(Celebrity Smile|Carbamide Peroxide)#,
  q#__KAM_WHOSWHO3,[l=1]# => q#(?aa)(?i)(global|executive) who.s who|represent your community|you have been selected|complete your listing|prominent registry|accomplished individuals#,
  q#__KAM_WIFE2,[l=1]# => q#(?aa)(?i)marry a Russian|sizzling photos|(russian|asian|ukrai?nian) (women|beaut|bride|girl)|Slavic babes|Russian ?lad(y|ies)|sexy photos|actively seeking men#,
  q#__KAM_WINDOWS3,[l=1]# => q#(?aa)(?i)Find Your Windows|replacement.window|window.design|home.a.new.look|dingy.old.windows|high.heating|high.cooling|let a draft|energy.efficient|double.pane.window|shop.windows|energy.tax|window.(installation|discount|replacement)|summer.is.coming#,
  q#__KAM_WORKFROMHOME1,[l=0]# => q#(?aa)(?i)work from home#,
  q#__KAM_WORKHOME1,[l=0]# => q#(?aa)(?i)online jobs|Full\-time (and|&) Part\-time|at home employment#,
  q#__KAM_WORKHOME2,[l=0]# => q#(?aa)(?i)[hash]1 site|view here|information here#,
  q#__KAM_WRITING3,[l=0]# => q#(?aa)(?i)Professional Writing|world famous (writer|poet)#,
  q#__KAM_WTA2,[l=1]# => q#(?aa)(?is)Alliance for Retirement Prosperity Association|Social Security Institute#,
  q#__KAM_ZOHO2,[l=0]# => q#(?aa)(?i)congrats on win|selected as the winner|expiration notice#,
  q#__KAM_ZOHO3,[l=0]# => q#(?aa)(?i)sweepstakes|password#,
  q#__KAM_ZWNJ3,[l=0]# => q#(?aa)(?i)\&[hash]x200B;#,
  q#__KB_WAM_LONELY_WOMEN_PHRASE_01,[l=1]# => q#(?aa)(?i)\b(I am missing you all the time|I am waiting for your answer|I send you my tender love|I would really like to know you|quest of love|I am lonely and tired)\b#,
  q#__LARGE_PERCENT_AFTER,[l=1]# => q#(?aa)(?i)\d{3}% after#,
  q#__LOTSA_MONEY_05,[l=1]# => q#(?aa)(?i)(?:(?:sum|value|amount)\sof\s)<NUM_NOT_DATE_IP>[\d.,\sO]{7,20}[\dO\.][\)\]\(\s]{0,3}(?:pounds?|dollars?|euros?|bucks)\b#,
  q#__LOTTO_ADMITS_2,[l=1]# => q#(?aa)(?i)\b(?:free)?(?:lot(?:to|tery|erie)|sweepstakes)\s(?:(?:inter)?na[tz]ional|department|bureau|group|award|microsoft)#,
  q#__LOTTO_AGENT_02,[l=1]# => q#(?aa)(?i)\blot+ery[^\.]{1,40} ticket agent#,
  q#__LOTTO_DEPT,[l=1]# => q#(?aa)(?i)\b(?:claim(?:s|ing)?(?:\sprocessing)?|fiducia\w+|reimbursement|(?:international|foreign|win+ing)(?:\s(?:rem+it+ance|settlement|payment|award))+|payment|award|compensation|lot+ery)(?:\s\w+)?\s?(?:department|dept|unit|group|committee|bureau)#,
  q#__LOTTO_WIN_01,[l=1]# => q#(?aa)(?i)\bwin+ing\s(?:prize|number|notification|draw|check|cheque|details|information|payment)#,
  q#__LUCKY_WINNER,[l=1]# => q#(?aa)(?i)\b(?:lucky|gl.cklich(?:en)?|afortunados)\s(?:(?:ge)?win+ers?|ganador(?:es)?|individuals?)\b#,
  q#__LUCRATIVE,[l=1]# => q#(?aa)(?i)\b(?:lucrative|profitable|tr[\xe8]s\ssalutaire)\b#,
  q#__MAIL_ACCT_ACCESS1,[l=1]# => q#(?aa)(?i)\b(?:your (?:web ?|e-?)?mail (?:account|log-?in) (?:has )?been accessed|r(?:=F3|[\xf3])zne komputery zalogowaniu sie)\b#,
  q#__MAIL_ACCT_ACCESS2,[l=1]# => q#(?aa)(?i)\blo+se ac+es+ to your (?:web|e-?)?mail ?(?:account|log-?in|box|address)\b#,
  q#__MAKE_XTRA_DOLLAR,[l=1]# => q#(?aa)(?i)\bmake an extra dollar\b#,
  q#__MILLIONS,[l=1]# => q#(?aa)(?i)\bmillions\sof\s(?:dollar|euro|pound)#,
  q#__MONERO_CURNCY,[l=1]# => q#(?aa)Monero \(XMR\)#,
  q#__MY_FORTUNE,[l=1]# => q#(?aa)(?i)\b(?:my|his|her)\s(?:fortune|heritage)\b#,
  q#__NEXT_OF_KIN,[l=1]# => q#(?aa)(?i)\bnext[-\s]of[-\s]kin\b#,
  q#__NIGERIA,[l=1]# => q#(?aa)(?i)\bnigeria\b#,
  q#__NOT_DEAD_YET,[l=1]# => q#(?aa)(?i)\b(?:will\sinherit|que\sherede|your\sdeath|your?\sbeing\sdead)\b#,
  q#__NOT_SCAM,[l=1]# => q#(?aa)(?i)\b(?:not\sa\sscam|(?:not|never)\sscam\syou)\b#,
  q#__OBFU_UNSUB_UL,[l=1]# => q#(?aa)(?:click_here|remove_your|our_e?mail|this_list|to_unsubscribe|future_e?mail|our_list)#,
  q#__ORDER_TODAY,[l=1]# => q#(?aa)(?i)\border (?:it|one|yours|this) (?:today|now|right\saway)\b#,
  q#__OUR_BEHALF,[l=1]# => q#(?aa)(?i)\b(?:on\s(?:my|our)\sbehalf|of\sbehalf\sof)\b#,
  q#__PASSIVE_INCOME,[l=1]# => q#(?aa)(?i)\bpassive income\b#,
  q#__PASSWORD_EXP_CLUMSY,[l=1]# => q#(?aa)(?i)\bpassword is due for expiration yesterday\b#,
  q#__PASSWORD_UPGRADE,[l=1]# => q#(?aa)(?i)\bpassword upgrade\b#,
  q#__PAY_YOU,[l=1]# => q#(?aa)\bpay\syou\b#,
  q#__PDS_EXPIRATION_NOTICE,[l=1]# => q#(?aa)(?i)\bexpiration (?:notice|alert|date)\b#,
  q#__PDS_OFFER_ONLY_AMERICA,[l=0]# => q#(?aa)(?i)This offer (?:is )?(?:only )?for (?:United States|USA)#,
  q#__PDS_SENT_TO_EMAIL_ADDR,[l=0]# => q#(?aa)(?i)This message was sent to Email Address\.#,
  q#__PDS_SEO2,[l=1]# => q#(?aa)(?i)(?:losing your|your website) (?:[a-z]+ )?(?:rank(?:ing)?|results)|rank well on [a-z]+\b#,
  q#__PERFECT_BINARY,[l=1]# => q#(?aa)(?i)\bperfect binary option\b#,
  q#__PILL_PRICE_01,[l=1]# => q#(?aa)(?i)(?=[\d .f])(?:free|[\d .]{3}(?:/|per|each)) ?(?=[ptc])(?:pill|tablet|cap(?:sule|let))s?\b#,
  q#__PILL_PRICE_02,[l=1]# => q#(?aa)(?i)(?=[ptc])(?:pill|tablet|cap(?:sule|let))s[-= :]{1,5}\$?[\d .]{3}#,
  q#__PLS_REVIEW,[l=1]# => q#(?aa)(?i)\b(?:please|kindly)\s(?:(?:re)?view|see)(?:\s\w+)?\sattach(?:ed|ment)\b#,
  q#__PUMPDUMP_01,[l=1]# => q#(?aa)(?i)\b(?:times|multiply|tripl(?:e|ing)|quadrupl(?:e|ing)|quintupl(?:e|ing)) (?:your|an) (?:princip(?:al|le)|investment)\b#,
  q#__PUMPDUMP_03,[l=1]# => q#(?aa)(?i)\bbuy (?:[^.!]{1,30} )?(?:(?:(?:mon|tues|wednes|thurs|fri)day|tomorrow) (?:first thing|open|morning)|(?:first thing|opens|before) (?:(?:mon|tues|wednes|thurs|fri)day|tomorrow))#,
  q#__PUMPDUMP_04,[l=1]# => q#(?aa)(?i)\bmake you (?:big bucks|hundreds|thousands)\b#,
  q#__PUMPDUMP_06,[l=1]# => q#(?aa)(?i)\brecommend(?:ed|s)? (?:a|this) (?:company|stock)\b#,
  q#__PUMPDUMP_07,[l=1]# => q#(?aa)(?i)\b(?:buy|grab it) for (?:around |about |less than )?\d+ cents\b#,
  q#__PUMPDUMP_08,[l=1]# => q#(?aa)(?i)\b(?:sto[ck]{2}|sotk) of the year#,
  q#__PUMPDUMP_09,[l=1]# => q#(?aa)(?i)\b(?:buy|get|snap up|grab) as many shares (?:of it )?as (?:you|I) can\b#,
  q#__PUMPDUMP_10,[l=1]# => q#(?aa)(?i)\btrading at (?:such )?a (?:bargain|cheap|low)\b#,
  q#__RANDOM_PICK,[l=1]# => q#(?aa)(?i)\b(?:random(?:ly)?\s(?:\w+\s)?(?:select(?:ion|ed)|pick(?:ed)?|computer)|(?:select|pick)ed\s(?:at\s)?random(?:ly)?|(?:esco(?:g|lh)idos|seleccion) (?:aleatoria(?:mente)?|al azar))\b#,
  q#__RECEIVE_BONUS,[l=1]# => q#(?aa)(?i)\byou(?:'ll)?(?: also| will)* (?:rec[ei]*ve|get|earn|collect|be (?:awarded|handed|remitted|given|paid|(?:greeted|welcomed|started) with)) (?:an? )?(?:gift|bonus|extra)(?: of|:)? \$[\d,]+#,
  q#__RELEASE_MESSAGES,[l=1]# => q#(?aa)(?i)\b(?:release messages|(?:retrieve|release|download) your(?: undelivered|unreceived|held|pending)? e?-?mails|(?:e?-?mails|messages).{1,20}download them now)\b#,
  q#__RUDE_HTML_1,[l=0]# => q#(?aa)(?i)Get a capable html e-mailer#,
  q#__RUDE_HTML_2,[l=1]# => q#(?aa)(?i)not support the display of HTML. Please view this message in a different#,
  q#__RUDE_HTML_3,[l=0]# => q#(?aa)(?i)This message contains an HTML formatted message but your email client does#,
  q#__RUDE_HTML_4,[l=1]# => q#(?aa)(?i)Your mailer do not support HTML messages. Switch to a better mailer#,
  q#__SCAM,[l=1]# => q#(?aa)(?i)\bscam(?:m?e[dr])?s?\b#,
  q#__SECURITY_DEPT,[l=1]# => q#(?aa)(?i)\bsecurity dep(?:artmen)?t\b#,
  q#__STAY_HOME,[l=1]# => q#(?aa)(?i)\b(?:going out of|leaving)(?: your)? (?:home|house|residence)\b#,
  q#__STOCK_TIP,[l=1]# => q#(?aa)(?i)\bsto[ck]{2}\s?tip\b#,
  q#__SUBSCRIPTION_INFO,[l=1]# => q#(?aa)(?i)\b(?:e?newsletters?|(?:un)?(?:subscrib|register)|you(?:r| are) subscri(?:b|ption)|opt(?:.|ing)?out\b|further info|you do ?n[o']t w(?:ish|ant)|remov\w{1,3}.{1,9}\blists?\b|to your white.?list)#,
  q#__SUM_OF_FUND,[l=1]# => q#(?aa)(?i)\b(?:sum|release|freigabe)\s(?:of|der)\s(?:amount|fund|investment|mittel)\b#,
  q#__SURVEY,[l=1]# => q#(?aa)(?i)\bsurvey\b#,
  q#__SUSPICION_LOGIN,[l=1]# => q#(?aa)(?i)\bsuspicion login\b#,
  q#__SYSADMIN,[l=1]# => q#(?aa)(?i)\b(?:help?[- ]?desk|(?:(?:web ?)?mail ?|sys(?:tem )?)admin(?:istrator)|local[- ]host|(?:support|upgrade|management|security|admin(?:istrat(?:or|ion))?) (?:team|center)|message from administrator|university mail server copyright|suporte t(?:=E9|[\xe9]|[\xc3][\xa9])cnico|administrador do sistema)\b#,
  q#__THEY_INHERIT,[l=1]# => q#(?aa)(?i)\b(?:inherit\sth(?:e|is)\smoney|herede\sest[ea]\sdinero)\b#,
  q#__THIS_AD,[l=1]# => q#(?aa)(?i)(?:\b|_)this[- _]+(?:ad(?:vert[i1l]sement)?|promo(?:tion)?)s?(?:\b|_)#,
  q#__TO_YOUR_ORG,[l=1]# => q#(?aa)(?i)\b(?:to|for) your organi[sz]ation\b#,
  q#__TRANSFORM_LIFE,[l=1]# => q#(?aa)(?i)\b(?:transform|change) your (?:daily )?life(?:style)?\b#,
  q#__TRAVEL_AGENT,[l=1]# => q#(?aa)(?i)\btravel\sagen(?:t|cy)\b#,
  q#__TRAVEL_BUSINESS,[l=1]# => q#(?aa)(?i)\bbusiness\stravel\b#,
  q#__TRAVEL_ITINERARY,[l=0]# => q#(?aa)(?i)(?:travel|ticketed|your|current) itinerary#,
  q#__TRAVEL_RESERV,[l=1]# => q#(?aa)(?i)\b(?:reservation\s(?:confirmed|number)|travel\sreservations?)\b#,
  q#__TRTMT_DEFILED,[l=1]# => q#(?aa)(?i)\bdefiled\sall\s(?:forms\sof\s)?(?:medical\s)?treatments?\b#,
  q#__TRUNK_BOX,[l=1]# => q#(?aa)(?i)\b(?:(?:trunk|metallic|proof|security|consignment)\sbox(?:es)?|sealed\ssafe|une mallette m(?:e|=E9|[\xe9]|[\xc3][\xa9])tallique)\b#,
  q#__TRUSTED_CHECK,[l=1]# => q#(?aa)(?i)\b(?:cashier'?s?|certified)\sche(?:ck|que)#,
  q#__TVD_PH_BODY_01,[l=1]# => q#(?aa)(?i)\baccount .{0,20}placed? [io]n restricted status#,
  q#__TVD_PH_BODY_02,[l=1]# => q#(?aa)(?i)\brecords (?:[a-z_,-]+ )+?(?:feature|(?:a|re)ward)#,
  q#__TVD_PH_BODY_03,[l=1]# => q#(?aa)(?i)\byou(?:'ve| have) been (?:[a-z_,-]+ )+?payment#,
  q#__TVD_PH_BODY_04,[l=1]# => q#(?aa)(?i)\bfunds? (?!transfer from)(?!from)(?!in)(?!via)(?:[a-z_,-]+ )+?to your (?:[a-z_,-]+ )*?account#,
  q#__TVD_PH_BODY_05,[l=1]# => q#(?aa)(?i)\bthis is (?:[a-z_,-]+ )+?protect (?:[a-z_,-]+ )+?your#,
  q#__TVD_PH_BODY_06,[l=1]# => q#(?aa)(?i)Dear [a-z]+ bank (?:member|customer)#,
  q#__TVD_PH_BODY_07,[l=1]# => q#(?aa)(?i)\bguarantee the safety of your (?:[a-z_,-]+ )*?account#,
  q#__TVD_PH_BODY_08,[l=1]# => q#(?aa)(?i)\bmultiple password failures#,
  q#__TVD_PH_BODY_ACCOUNTS_POST,[l=1]# => q#(?aa)(?i)\b(?:(?:[dr]e-?)?activat[a-z]*|(?:re-?)?validate|secure|restore|confirm|update|suspend) (?!your)(?:[a-z_,-]+ )+?accounts?\b#,
  q#__TVD_PH_BODY_ACCOUNTS_PRE,[l=1]# => q#(?aa)(?i)\baccounts? (?:[a-z_,-]+ )+?(?:record[a-z]*|suspen[a-z]+|notif(?:y|ication)|updated|verifications?|credited)\b#,
  q#__UN,[l=1]# => q#(?aa)(?i)\bunited\snations?\b#,
  q#__UNSUB_GOOG_FORM,[l=1]# => q#(?aa)(?i)Unsub?sc?ribe\s<?https?://docs\.google\.com/forms/#,
  q#__URG_BIZ,[l=1]# => q#(?aa)(?i)urgent.{0,16}(?:assistance|business|buy|confidential|notice|proposal|reply|request|response)#,
  q#__VBOUNCE_AMAVISD2,[l=1]# => q#(?aa)\bV I R U S\b#,
  q#__VBOUNCE_ATTACHMENT0,[l=1]# => q#(?aa)(?:Attachment.{0,40}was Deleted|the infected attachment)#,
  q#__VBOUNCE_AVREPORT0,[l=0]# => q#(?aa)(?i)(?:antivirus system report|the antivirus module has|illegal attachment|Unrepairable Virus Detected)#,
  q#__VBOUNCE_MAILSWEEP2,[l=1]# => q#(?aa)(?i)\bblocked by Mailsweeper\b#,
  q#__WEBMAIL_ACCT,[l=1]# => q#(?aa)(?i)\byour web ?mail account#,
  q#__WE_PAID,[l=1]# => q#(?aa)(?i)\bwe have (?:already )?(?:paid|sent|remitted|issued) \$?\d+(?:,\d+)* (?:thousand )?(?:dollars )?to our (?:users|subscribers|members|clients|affiliates|partners)\b#,
  q#__WIDOW,[l=1]# => q#(?aa)(?i)\b(?:widow(?:e[rd])'?s?|veuve)\b#,
  q#__WILL_LEGAL,[l=1]# => q#(?aa)(?i)\b(?:codicil|last\stestament|probate|executor|intestate|bequest|mandamus)\b#,
  q#__WIRE_XFR,[l=1]# => q#(?aa)(?i)\b(?:wire|telegraph(?:ic)?|bank)\s?transfer#,
  q#__WITHOUT_EFFORT,[l=1]# => q#(?aa)(?i)\bwith(?:out(?: a(?:ny)?| the)?| no)(?: great| special| extra)? effort\b#,
  q#__YOUR_BANK,[l=1]# => q#(?aa)(?i)\byour?\s(?:full\s)?bank(?:ing)?\sinformations?\b#,
  q#__YOUR_CONSIGNMENT,[l=1]# => q#(?aa)(?i)\b(?:received?|pa(?:y|id)|sen[dt]|h[oe]ld|delay(?:ed)?|impound(?:ed)?|released?|ship(?:ped)?)\syour(?:\s\w+)?\sconsignment\b#,
  q#__YOUR_FUND,[l=1]# => q#(?aa)(?i)\b(?:your|ihr)\s(?:unpaid\s|win+ing\s|ap+roved\s|foreign\s|overdue\s|outstanding\s|contract\s|inheritance\s|nicht\sausbezahlten\s){0,3}(?:fund|f\su\sn\sd|payment|geld)\b#,
  q#__YOUR_PERM,[l=1]# => q#(?aa)(?i)\byour\spermission\b#,
  q#__YOUR_PROFIT,[l=1]# => q#(?aa)(?i)\byour?\sprofit#,
  q#__YOU_ASSIST,[l=1]# => q#(?aa)(?i)\b(?:your\sas+istan(?:ce|t)|votre\s(?:as+istance|aide))\b#,
  q#__YOU_INHERIT,[l=1]# => q#(?aa)(?i)\byour\s[a-z\s]{0,30}inherit+ance\b#,
  q#__YOU_WON_01,[l=1]# => q#(?aa)(?i)\byou(?:r|'re|'ve|'ll|\shave|\sdid)?\s(?:e-?mail\s)?(?:\w+\s){0,2}(?:a\s)?w[io]n+(?:er|ing)?(?!\xe2\x80\x99t)(?![`'\x92]t)\b#,
  q#__YOU_WON_02,[l=1]# => q#(?aa)(?i)\bw[io]n\s(?:(?:for|by)\s)?your?\b#,
  q#__YOU_WON_04,[l=1]# => q#(?aa)(?i)\bqu[ei]\s?(?:vous (?:[\xc3][\xaa]|=C3=AA|[\xea]|e)tes\s?gagnant|en\scons(?:e|=E9|[\xe9]|[\xc3][\xa9])quence\sgagne)\b#,
  q#__YOU_WON_05,[l=1]# => q#(?aa)(?i)\bI won(?!\xe2\x80\x99t)(?![`'\x92]t)\b#,
  q#__freemail_safe_fwd,[l=1]# => q#(?aa)(?i)---\s?(?:(?:Forwarded|Original) message|Alkuper(?:\xe4|\xc3\xa4)inen viesti)#,
  q#__hk_win_0,[l=1]# => q#(?aa)(?i)\byour? e-?mail just w[oi]n#,
  q#__hk_win_2,[l=1]# => q#(?aa)(?i)\battn.{0,10}winner#,
  q#__hk_win_3,[l=1]# => q#(?aa)(?i)\bhappily aa?nnounce#,
  q#__hk_win_4,[l=1]# => q#(?aa)(?i)\bpleas(?:ure|ed) to inform#,
  q#__hk_win_5,[l=1]# => q#(?aa)(?i)\b(?:notice the|your) winning#,
  q#__hk_win_7,[l=1]# => q#(?aa)(?i)\bcongratulations? to your#,
  q#__hk_win_8,[l=1]# => q#(?aa)(?i)\bunexpected luck#,
  q#__hk_win_9,[l=1]# => q#(?aa)(?i)\blucky (?:nl )number#,
  q#__hk_win_a,[l=1]# => q#(?aa)(?i)\bwinning (?:e-?mail|numbers|information)#,
  q#__hk_win_b,[l=1]# => q#(?aa)(?i)\byour e-?mail (?:address )?(?:has )?w[io]n#,
  q#__hk_win_i,[l=1]# => q#(?aa)(?i)\bfunds? transfer#,
  q#__hk_win_j,[l=1]# => q#(?aa)(?i)\b(?:winning|ready for|sum) pay ?out#,
  q#__hk_win_l,[l=1]# => q#(?aa)(?i)\b(?:make|file) (?:for )?your claim#,
  q#__hk_win_n,[l=1]# => q#(?aa)(?i)\bcollect your prize#,
  q#__hk_win_o,[l=1]# => q#(?aa)(?i)\bclarification and procedure#,

};

XSLoader::load 'Mail::SpamAssassin::CompiledRegexps::body_0', $VERSION;
}

1;
__END__

=head1 NAME

Mail::SpamAssassin::CompiledRegexps::body_0 - Efficient string matching for regexps found in bases_body_0.in

=head1 SYNOPSIS

  use Mail::SpamAssassin::CompiledRegexps::body_0;
  
  ...
  my $match = Mail::SpamAssassin::CompiledRegexps::body_0::scan($string);

=head1 DESCRIPTION

This module was created by SpamAssassin with the aid of re2xs, which uses re2c
to create an XS library capable of scanning through a bunch of regular
expressions as defined in F<bases_body_0.in>.

See C<sa-compile> for more details.

=cut
