
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `spip444`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_articles`
--

CREATE TABLE `[[dbprefix]]_articles` (
  `id_article` bigint(21) NOT NULL AUTO_INCREMENT,
  `surtitre` text NOT NULL,
  `titre` text NOT NULL,
  `soustitre` text NOT NULL,
  `id_rubrique` bigint(21) NOT NULL DEFAULT '0',
  `descriptif` text NOT NULL,
  `chapo` mediumtext NOT NULL,
  `texte` longtext NOT NULL,
  `ps` mediumtext NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statut` varchar(10) NOT NULL DEFAULT '0',
  `id_secteur` bigint(21) NOT NULL DEFAULT '0',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `export` varchar(10) DEFAULT 'oui',
  `date_redac` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `visites` int(11) NOT NULL DEFAULT '0',
  `referers` int(11) NOT NULL DEFAULT '0',
  `popularite` double NOT NULL DEFAULT '0',
  `accepter_forum` char(3) NOT NULL DEFAULT '',
  `date_modif` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL DEFAULT '',
  `langue_choisie` varchar(3) DEFAULT 'non',
  `id_trad` bigint(21) NOT NULL DEFAULT '0',
  `nom_site` tinytext NOT NULL,
  `url_site` text NOT NULL,
  `virtuel` text NOT NULL,
  PRIMARY KEY (`id_article`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `id_trad` (`id_trad`),
  KEY `lang` (`lang`),
  KEY `statut` (`statut`,`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_auteurs`
--

CREATE TABLE `[[dbprefix]]_auteurs` (
  `id_auteur` bigint(21) NOT NULL AUTO_INCREMENT,
  `nom` text NOT NULL,
  `bio` text NOT NULL,
  `email` tinytext NOT NULL,
  `nom_site` tinytext NOT NULL,
  `url_site` text NOT NULL,
  `login` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `pass` tinytext NOT NULL,
  `low_sec` tinytext NOT NULL,
  `statut` varchar(255) NOT NULL DEFAULT '0',
  `webmestre` varchar(3) NOT NULL DEFAULT 'non',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `pgp` text NOT NULL,
  `htpass` tinytext NOT NULL,
  `en_ligne` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `alea_actuel` tinytext,
  `alea_futur` tinytext,
  `prefs` text,
  `cookie_oubli` tinytext,
  `source` varchar(10) NOT NULL DEFAULT 'spip',
  `lang` varchar(10) NOT NULL DEFAULT '',
  `imessage` varchar(3) NOT NULL DEFAULT '',
  `backup_cles` mediumtext NOT NULL,
  PRIMARY KEY (`id_auteur`),
  KEY `login` (`login`),
  KEY `statut` (`statut`),
  KEY `en_ligne` (`en_ligne`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]_auteurs`
--

INSERT INTO `[[dbprefix]]_auteurs` VALUES
(1, '[[admin_realname]]', '', '[[admin_email]]', '', '', '[[admin_username]]', '[[admin_pass]]', '', '0minirezo', 'oui', '[[regtime]]', '', '', '[[regtime]]', '[[alea_actuel]]', '[[alea_futur]]', 'a:2:{s:7:"couleur";i:2;s:3:"cnx";s:0:"";}', NULL, 'spip', '[[language]]', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_auteurs_liens`
--

CREATE TABLE `[[dbprefix]]_auteurs_liens` (
  `id_auteur` bigint(21) NOT NULL DEFAULT '0',
  `id_objet` bigint(21) NOT NULL DEFAULT '0',
  `objet` varchar(25) NOT NULL DEFAULT '',
  `vu` varchar(6) NOT NULL DEFAULT 'non',
  PRIMARY KEY (`id_auteur`,`id_objet`,`objet`),
  KEY `id_auteur` (`id_auteur`),
  KEY `id_objet` (`id_objet`),
  KEY `objet` (`objet`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_depots`
--

CREATE TABLE `[[dbprefix]]_depots` (
  `id_depot` bigint(21) NOT NULL AUTO_INCREMENT,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT '',
  `url_serveur` varchar(255) NOT NULL DEFAULT '',
  `url_brouteur` varchar(255) NOT NULL DEFAULT '',
  `url_archives` varchar(255) NOT NULL DEFAULT '',
  `url_commits` varchar(255) NOT NULL DEFAULT '',
  `xml_paquets` varchar(255) NOT NULL DEFAULT '',
  `sha_paquets` varchar(40) NOT NULL DEFAULT '',
  `nbr_paquets` int(11) NOT NULL DEFAULT '0',
  `nbr_plugins` int(11) NOT NULL DEFAULT '0',
  `nbr_autres` int(11) NOT NULL DEFAULT '0',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_depot`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_depots_plugins`
--

CREATE TABLE `[[dbprefix]]_depots_plugins` (
  `id_depot` bigint(21) NOT NULL,
  `id_plugin` bigint(21) NOT NULL,
  PRIMARY KEY (`id_depot`,`id_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_documents`
--

CREATE TABLE `[[dbprefix]]_documents` (
  `id_document` bigint(21) NOT NULL AUTO_INCREMENT,
  `id_vignette` bigint(21) NOT NULL DEFAULT '0',
  `extension` varchar(10) NOT NULL DEFAULT '',
  `titre` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `descriptif` text NOT NULL,
  `fichier` text NOT NULL,
  `taille` bigint(20) DEFAULT NULL,
  `largeur` int(11) DEFAULT NULL,
  `hauteur` int(11) DEFAULT NULL,
  `duree` int(11) DEFAULT NULL,
  `media` varchar(10) NOT NULL DEFAULT 'file',
  `mode` varchar(10) NOT NULL DEFAULT 'document',
  `distant` varchar(3) DEFAULT 'non',
  `statut` varchar(10) NOT NULL DEFAULT '0',
  `credits` text NOT NULL,
  `alt` text NOT NULL,
  `date_publication` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `brise` tinyint(4) DEFAULT '0',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_document`),
  KEY `id_vignette` (`id_vignette`),
  KEY `mode` (`mode`),
  KEY `extension` (`extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_documents_liens`
--

CREATE TABLE `[[dbprefix]]_documents_liens` (
  `id_document` bigint(21) NOT NULL DEFAULT '0',
  `id_objet` bigint(21) NOT NULL DEFAULT '0',
  `objet` varchar(25) NOT NULL DEFAULT '',
  `vu` enum('non','oui') NOT NULL DEFAULT 'non',
  `rang_lien` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_document`,`id_objet`,`objet`),
  KEY `id_document` (`id_document`),
  KEY `id_objet` (`id_objet`),
  KEY `objet` (`objet`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_forum`
--

CREATE TABLE `[[dbprefix]]_forum` (
  `id_forum` bigint(21) NOT NULL AUTO_INCREMENT,
  `id_objet` bigint(21) NOT NULL DEFAULT '0',
  `objet` varchar(25) NOT NULL DEFAULT '',
  `id_parent` bigint(21) NOT NULL DEFAULT '0',
  `id_thread` bigint(21) NOT NULL DEFAULT '0',
  `date_heure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_thread` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `titre` text NOT NULL,
  `texte` mediumtext NOT NULL,
  `auteur` text NOT NULL,
  `email_auteur` text NOT NULL,
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `statut` varchar(8) NOT NULL DEFAULT '0',
  `ip` varchar(40) NOT NULL DEFAULT '',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `id_auteur` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_forum`),
  KEY `id_auteur` (`id_auteur`),
  KEY `id_parent` (`id_parent`),
  KEY `id_thread` (`id_thread`),
  KEY `optimal` (`statut`,`id_parent`,`id_objet`,`objet`,`date_heure`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_groupes_mots`
--

CREATE TABLE `[[dbprefix]]_groupes_mots` (
  `id_groupe` bigint(21) NOT NULL AUTO_INCREMENT,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `unseul` varchar(3) NOT NULL DEFAULT '',
  `obligatoire` varchar(3) NOT NULL DEFAULT '',
  `tables_liees` text NOT NULL,
  `minirezo` varchar(3) NOT NULL DEFAULT '',
  `comite` varchar(3) NOT NULL DEFAULT '',
  `forum` varchar(3) NOT NULL DEFAULT '',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_groupe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_jobs`
--

CREATE TABLE `[[dbprefix]]_jobs` (
  `id_job` bigint(21) NOT NULL AUTO_INCREMENT,
  `descriptif` text NOT NULL,
  `fonction` varchar(255) NOT NULL,
  `args` longblob NOT NULL,
  `md5args` char(32) NOT NULL DEFAULT '',
  `inclure` varchar(255) NOT NULL,
  `priorite` smallint(6) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `status` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_job`),
  KEY `date` (`date`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[dbprefix]]_jobs`
--

INSERT INTO `[[dbprefix]]_jobs` VALUES
(1, 'CRON task queue_watch (every 86400 s)', 'queue_watch', '[[queue_watch_args]]', '[[queue_watch_md5]]', 'genie/', 0, '[[regtime]]', 1),
(2, 'CRON task optimiser (every 172800 s)', 'optimiser', '[[optimiser_args]]', '[[optimiser_md5]]', 'genie/', 0, '[[regtime]]', 1),
(3, 'CRON task maintenance (every 7200 s)', 'maintenance', '[[maintenance_args]]', '[[maintenance_md5]]', 'genie/', 0, '[[regtime]]', 1),
(4, 'CRON task mise_a_jour (every 259200 s)', 'mise_a_jour', '[[mise_a_jour_args]]', '[[mise_a_jour_md5]]', 'genie/', 0, '[[regtime]]', 1),
(5, 'CRON task revisions_optimiser_revisions (every 86400 s)', 'revisions_optimiser_revisions', '[[revisions_optimiser_revisions_args]]', '[[revisions_optimiser_revisions_md5]]', 'genie/', 0, '[[regtime]]', 1),
(6, 'CRON task bigup_nettoyer_repertoire_upload (every 86400 s)', 'bigup_nettoyer_repertoire_upload', '[[bigup_nettoyer_repertoire_upload_args]]', '[[bigup_nettoyer_repertoire_upload_md5]]', 'genie/', 0, '[[regtime]]', 1),
(7, 'CRON task medias_nettoyer_repertoire_upload (every 86400 s)', 'medias_nettoyer_repertoire_upload', '[[medias_nettoyer_repertoire_upload_args]]', '[[medias_nettoyer_repertoire_upload_md5]]', 'genie/', 0, '[[regtime]]', 1),
(8, 'CRON task svp_actualiser_depots (every 21600 s)', 'svp_actualiser_depots', '[[svp_actualiser_depots_args]]', '[[svp_actualiser_depots_md5]]', 'genie/', 0, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_jobs_liens`
--

CREATE TABLE `[[dbprefix]]_jobs_liens` (
  `id_job` bigint(21) NOT NULL DEFAULT '0',
  `id_objet` bigint(21) NOT NULL DEFAULT '0',
  `objet` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_job`,`id_objet`,`objet`),
  KEY `id_job` (`id_job`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_meta`
--

CREATE TABLE `[[dbprefix]]_meta` (
  `nom` varchar(255) NOT NULL,
  `valeur` text,
  `impt` enum('non','oui') NOT NULL DEFAULT 'oui',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`nom`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_meta`
--

INSERT INTO `[[dbprefix]]_meta` VALUES
('accepter_inscriptions', 'non', 'oui', '[[regtime]]'),
('accepter_visiteurs', 'non', 'oui', '[[regtime]]'),
('activer_captures_referers', 'non', 'oui', '[[regtime]]'),
('activer_logos', 'oui', 'oui', '[[regtime]]'),
('activer_logos_survol', 'non', 'oui', '[[regtime]]'),
('activer_referers', 'oui', 'oui', '[[regtime]]'),
('activer_sites', 'non', 'oui', '[[regtime]]'),
('activer_statistiques', 'non', 'oui', '[[regtime]]'),
('activer_syndic', 'oui', 'oui', '[[regtime]]'),
('adresse_neuf', '', 'oui', '[[regtime]]'),
('adresse_site', '[[softurl]]', 'non', '[[regtime]]'),
('adresse_suivi', '', 'oui', '[[regtime]]'),
('adresse_suivi_inscription', '', 'oui', '[[regtime]]'),
('alea_ephemere', '[[alea_ephemere]]', 'non', '[[regtime]]'),
('alea_ephemere_ancien', NULL, 'non', '[[regtime]]'),
('alea_ephemere_date', '[[timestamp]]', 'non', '[[regtime]]'),
('articles_chapeau', 'non', 'oui', '[[regtime]]'),
('articles_descriptif', 'non', 'oui', '[[regtime]]'),
('articles_modif', 'non', 'oui', '[[regtime]]'),
('articles_mots', 'non', 'oui', '[[regtime]]'),
('articles_ps', 'non', 'oui', '[[regtime]]'),
('articles_redac', 'non', 'oui', '[[regtime]]'),
('articles_redirection', 'non', 'oui', '[[regtime]]'),
('articles_soustitre', 'non', 'oui', '[[regtime]]'),
('articles_surtitre', 'non', 'oui', '[[regtime]]'),
('articles_texte', 'oui', 'oui', '[[regtime]]'),
('articles_urlref', 'non', 'oui', '[[regtime]]'),
('auto_compress_css', 'non', 'oui', '[[regtime]]'),
('auto_compress_http', 'non', 'oui', '[[regtime]]'),
('auto_compress_js', 'non', 'oui', '[[regtime]]'),
('barre_outils_public', 'oui', 'oui', '[[regtime]]'),
('bigup', 'a:1:{s:13:"max_file_size";i:20;}', 'oui', '[[regtime]]'),
('bigup_base_version', '1.0.1', 'oui', '[[regtime]]'),
('charset', 'utf-8', 'oui', '[[regtime]]'),
('charset_collation_sql_base', 'utf8_general_ci', 'non', '[[regtime]]'),
('charset_sql_base', 'utf8', 'non', '[[regtime]]'),
('charset_sql_connexion', 'utf8', 'non', '[[regtime]]'),
('compagnon', 'a:1:{s:6:"config";a:1:{s:7:"activer";s:3:"oui";}}', 'oui', '[[regtime]]'),
('compagnon_base_version', '1.0.0', 'oui', '[[regtime]]'),
('config_precise_groupes', 'non', 'oui', '[[regtime]]'),
('creer_preview', 'non', 'non', '[[regtime]]'),
('descriptif_site', '', 'oui', '[[regtime]]'),
('dir_img', 'IMG/', 'oui', '[[regtime]]'),
('documents_date', 'non', 'oui', '[[regtime]]'),
('documents_objets', 'spip_articles', 'oui', '[[regtime]]'),
('email_envoi', '', 'oui', '[[regtime]]'),
('email_webmaster', '[[admin_email]]', 'oui', '[[regtime]]'),
('formats_documents_forum', '', 'oui', '[[regtime]]'),
('forums_afficher_barre', 'oui', 'oui', '[[regtime]]'),
('forums_forcer_previsu', 'oui', 'oui', '[[regtime]]'),
('forums_publics', 'posteriori', 'oui', '[[regtime]]'),
('forums_texte', 'oui', 'oui', '[[regtime]]'),
('forums_titre', 'oui', 'oui', '[[regtime]]'),
('forums_urlref', 'non', 'oui', '[[regtime]]'),
('forum_base_version', '1.2.2', 'oui', '[[regtime]]'),
('forum_prive', 'oui', 'oui', '[[regtime]]'),
('forum_prive_admin', 'non', 'oui', '[[regtime]]'),
('forum_prive_objets', 'oui', 'oui', '[[regtime]]'),
('gerer_trad', 'non', 'oui', '[[regtime]]'),
('jours_neuf', '', 'oui', '[[regtime]]'),
('langues_multilingue', '', 'oui', '[[regtime]]'),
('langues_proposees', 'ar,ast,ay,bg,br,bs,ca,co,cpf,cpf_hat,cs,da,de,en,eo,es,eu,fa,fon,fr,fr_fem,fr_tu,gl,he,hr,hu,id,it,it_fem,ja,km,lb,my,nl,oc_auv,oc_gsc,oc_lms,oc_lnc,oc_ni,oc_ni_la,oc_ni_mis,oc_prv,oc_va,pl,pt,pt_br,ro,ru,sk,sv,tr,uk,vi,zh', 'non', '[[regtime]]'),
('langues_utilisees', 'fr', 'oui', '[[regtime]]'),
('langue_site', '[[language]]', 'non', '[[regtime]]'),
('medias_base_version', '1.8.0', 'oui', '[[regtime]]'),
('moderation_sites', 'non', 'oui', '[[regtime]]'),
('mots_base_version', '2.1.1', 'oui', '[[regtime]]'),
('mots_cles_forums', 'non', 'oui', '[[regtime]]'),
('multi_rubriques', 'non', 'oui', '[[regtime]]'),
('multi_secteurs', 'non', 'oui', '[[regtime]]'),
('nom_site', '[[site_name]]', 'oui', '[[regtime]]'),
('nouvelle_install', '1', 'non', '[[regtime]]'),
('objets_versions', 'a:0:{}', 'oui', '[[regtime]]'),
('pcre_u', 'u', 'oui', '[[regtime]]'),
('plugin', '', 'non', '[[regtime]]'),
('plugin_attente', 'a:0:{}', 'oui', '[[regtime]]'),
('plugin_installes', 'a:10:{i:0;s:9:"compagnon";i:1;s:5:"forum";i:2;s:4:"mots";i:3;s:9:"revisions";i:4;s:5:"sites";i:5;s:12:"statistiques";i:6;s:3:"svp";i:7;s:13:"urls_etendues";i:8;s:5:"bigup";i:9;s:6:"medias";}', 'oui', '[[regtime]]'),
('post_dates', 'non', 'oui', '[[regtime]]'),
('prevenir_auteurs', 'non', 'oui', '[[regtime]]'),
('preview', ',0minirezo,1comite,', 'oui', '[[regtime]]'),
('proposer_sites', '0', 'oui', '[[regtime]]'),
('quoi_de_neuf', 'non', 'oui', '[[regtime]]'),
('revisions_base_version', '1.2.0', 'oui', '[[regtime]]'),
('rubriques_descriptif', 'non', 'oui', '[[regtime]]'),
('rubriques_texte', 'oui', 'oui', '[[regtime]]'),
('sites_base_version', '1.2.0', 'oui', '[[regtime]]'),
('slogan_site', '', 'oui', '[[regtime]]'),
('stats_base_version', '1.0.1', 'oui', '[[regtime]]'),
('suivi_edito', 'non', 'oui', '[[regtime]]'),
('svp_base_version', '0.6.2', 'oui', '[[regtime]]'),
('syndication_integrale', 'oui', 'oui', '[[regtime]]'),
('taille_preview', '150', 'non', '[[regtime]]'),
('type_urls', 'page', 'oui', '[[regtime]]'),
('urls_base_version', '2.0.1', 'oui', '[[regtime]]'),
('url_statique_ressources', '', 'oui', '[[regtime]]'),
('version_html_max', 'html4', 'oui', '[[regtime]]'),
('version_installee', '2022022303', 'non', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_mots`
--

CREATE TABLE `[[dbprefix]]_mots` (
  `id_mot` bigint(21) NOT NULL AUTO_INCREMENT,
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `id_groupe` bigint(21) NOT NULL DEFAULT '0',
  `type` text NOT NULL,
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_mot`),
  KEY `id_groupe` (`id_groupe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_mots_liens`
--

CREATE TABLE `[[dbprefix]]_mots_liens` (
  `id_mot` bigint(21) NOT NULL DEFAULT '0',
  `id_objet` bigint(21) NOT NULL DEFAULT '0',
  `objet` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_mot`,`id_objet`,`objet`),
  KEY `id_mot` (`id_mot`),
  KEY `id_objet` (`id_objet`),
  KEY `objet` (`objet`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_paquets`
--

CREATE TABLE `[[dbprefix]]_paquets` (
  `id_paquet` bigint(21) NOT NULL AUTO_INCREMENT,
  `id_plugin` bigint(21) NOT NULL,
  `prefixe` varchar(48) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(24) NOT NULL DEFAULT '',
  `version_base` varchar(24) NOT NULL DEFAULT '',
  `compatibilite_spip` varchar(24) NOT NULL DEFAULT '',
  `branches_spip` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `auteur` text NOT NULL,
  `credit` text NOT NULL,
  `licence` text NOT NULL,
  `copyright` text NOT NULL,
  `lien_doc` text NOT NULL,
  `lien_demo` text NOT NULL,
  `lien_dev` text NOT NULL,
  `etat` varchar(16) NOT NULL DEFAULT '',
  `etatnum` int(1) NOT NULL DEFAULT '0',
  `dependances` text NOT NULL,
  `procure` text NOT NULL,
  `date_crea` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modif` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `id_depot` bigint(21) NOT NULL DEFAULT '0',
  `nom_archive` varchar(255) NOT NULL DEFAULT '',
  `nbo_archive` int(11) NOT NULL DEFAULT '0',
  `maj_archive` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `src_archive` varchar(255) NOT NULL DEFAULT '',
  `traductions` text NOT NULL,
  `actif` varchar(3) NOT NULL DEFAULT 'non',
  `installe` varchar(3) NOT NULL DEFAULT 'non',
  `recent` int(2) NOT NULL DEFAULT '0',
  `maj_version` varchar(255) NOT NULL DEFAULT '',
  `superieur` varchar(3) NOT NULL DEFAULT 'non',
  `obsolete` varchar(3) NOT NULL DEFAULT 'non',
  `attente` varchar(3) NOT NULL DEFAULT 'non',
  `constante` varchar(30) NOT NULL DEFAULT '',
  `signature` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_paquet`),
  KEY `id_plugin` (`id_plugin`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_plugins`
--

CREATE TABLE `[[dbprefix]]_plugins` (
  `id_plugin` bigint(21) NOT NULL AUTO_INCREMENT,
  `prefixe` varchar(48) NOT NULL DEFAULT '',
  `nom` text NOT NULL,
  `slogan` text NOT NULL,
  `vmax` varchar(24) NOT NULL DEFAULT '',
  `date_crea` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modif` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `compatibilite_spip` varchar(24) NOT NULL DEFAULT '',
  `branches_spip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_plugin`),
  KEY `prefixe` (`prefixe`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_referers`
--

CREATE TABLE `[[dbprefix]]_referers` (
  `referer_md5` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `referer` varchar(255) DEFAULT NULL,
  `visites` int(10) unsigned NOT NULL,
  `visites_jour` int(10) unsigned NOT NULL,
  `visites_veille` int(10) unsigned NOT NULL,
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`referer_md5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_referers_articles`
--

CREATE TABLE `[[dbprefix]]_referers_articles` (
  `id_article` int(10) unsigned NOT NULL,
  `referer_md5` bigint(20) unsigned NOT NULL,
  `referer` varchar(255) NOT NULL DEFAULT '',
  `visites` int(10) unsigned NOT NULL,
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_article`,`referer_md5`),
  KEY `referer_md5` (`referer_md5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_resultats`
--

CREATE TABLE `[[dbprefix]]_resultats` (
  `recherche` char(16) NOT NULL DEFAULT '',
  `id` int(10) unsigned NOT NULL,
  `points` int(10) unsigned NOT NULL DEFAULT '0',
  `table_objet` varchar(30) NOT NULL DEFAULT '',
  `serveur` char(16) NOT NULL DEFAULT '',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_rubriques`
--

CREATE TABLE `[[dbprefix]]_rubriques` (
  `id_rubrique` bigint(21) NOT NULL AUTO_INCREMENT,
  `id_parent` bigint(21) NOT NULL DEFAULT '0',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `texte` longtext NOT NULL,
  `id_secteur` bigint(21) NOT NULL DEFAULT '0',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statut` varchar(10) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lang` varchar(10) NOT NULL DEFAULT '',
  `langue_choisie` varchar(3) DEFAULT 'non',
  `statut_tmp` varchar(10) NOT NULL DEFAULT '0',
  `date_tmp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `profondeur` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_rubrique`),
  KEY `lang` (`lang`),
  KEY `id_parent` (`id_parent`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_syndic`
--

CREATE TABLE `[[dbprefix]]_syndic` (
  `id_syndic` bigint(21) NOT NULL AUTO_INCREMENT,
  `id_rubrique` bigint(21) NOT NULL DEFAULT '0',
  `id_secteur` bigint(21) NOT NULL DEFAULT '0',
  `nom_site` text NOT NULL,
  `url_site` text NOT NULL,
  `url_syndic` text NOT NULL,
  `descriptif` text NOT NULL,
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `syndication` varchar(3) NOT NULL DEFAULT '',
  `statut` varchar(10) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_syndic` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_index` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `moderation` varchar(3) DEFAULT 'non',
  `miroir` varchar(3) DEFAULT 'non',
  `oubli` varchar(3) DEFAULT 'non',
  `resume` varchar(3) DEFAULT 'oui',
  PRIMARY KEY (`id_syndic`),
  KEY `id_rubrique` (`id_rubrique`),
  KEY `id_secteur` (`id_secteur`),
  KEY `statut` (`statut`,`date_syndic`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_syndic_articles`
--

CREATE TABLE `[[dbprefix]]_syndic_articles` (
  `id_syndic_article` bigint(21) NOT NULL AUTO_INCREMENT,
  `id_syndic` bigint(21) NOT NULL DEFAULT '0',
  `titre` text NOT NULL,
  `url` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lesauteurs` text NOT NULL,
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statut` varchar(10) NOT NULL DEFAULT '0',
  `descriptif` text NOT NULL,
  `lang` varchar(10) NOT NULL DEFAULT '',
  `url_source` tinytext NOT NULL,
  `source` tinytext NOT NULL,
  `tags` text NOT NULL,
  `raw_data` text NOT NULL,
  `raw_format` tinytext NOT NULL,
  `raw_methode` tinytext NOT NULL,
  PRIMARY KEY (`id_syndic_article`),
  KEY `id_syndic` (`id_syndic`),
  KEY `statut` (`statut`),
  KEY `url` (`url`(255))
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_types_documents`
--

CREATE TABLE `[[dbprefix]]_types_documents` (
  `extension` varchar(10) NOT NULL DEFAULT '',
  `titre` text NOT NULL,
  `descriptif` text NOT NULL,
  `mime_type` varchar(100) NOT NULL DEFAULT '',
  `inclus` enum('non','image','embed') NOT NULL DEFAULT 'non',
  `upload` enum('oui','non') NOT NULL DEFAULT 'oui',
  `media_defaut` varchar(10) NOT NULL DEFAULT 'file',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`extension`),
  KEY `inclus` (`inclus`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]_types_documents`
--

INSERT INTO `[[dbprefix]]_types_documents` VALUES
('3ga', '3GP Audio File', '', 'audio/3ga', 'embed', 'oui', 'audio', '[[regtime]]'),
('3gp', '3rd Generation Partnership Project', '', 'video/3gpp', 'embed', 'oui', 'video', '[[regtime]]'),
('7z', '7 Zip', '', 'application/x-7z-compressed', 'non', 'oui', 'file', '[[regtime]]'),
('aac', 'Advanced Audio Coding', '', 'audio/mp4a-latm', 'embed', 'oui', 'audio', '[[regtime]]'),
('abw', 'Abiword', '', 'application/abiword', 'non', 'oui', 'file', '[[regtime]]'),
('ac3', 'AC-3 Compressed Audio', '', 'audio/x-aac', 'embed', 'oui', 'audio', '[[regtime]]'),
('ai', 'Adobe Illustrator', '', 'application/illustrator', 'non', 'oui', 'image', '[[regtime]]'),
('aifc', 'Compressed AIFF Audio', '', 'audio/x-aifc', 'embed', 'oui', 'audio', '[[regtime]]'),
('aiff', 'AIFF', '', 'audio/x-aiff', 'embed', 'oui', 'audio', '[[regtime]]'),
('amr', 'Adaptive Multi-Rate Audio', '', 'audio/amr', 'embed', 'oui', 'audio', '[[regtime]]'),
('anx', 'Annodex', '', 'application/annodex', 'embed', 'oui', 'file', '[[regtime]]'),
('ape', 'Monkey''s Audio File', '', 'audio/x-monkeys-audio', 'embed', 'oui', 'audio', '[[regtime]]'),
('asf', 'Windows Media', '', 'video/x-ms-asf', 'embed', 'oui', 'video', '[[regtime]]'),
('asx', 'Advanced Stream Redirector', '', 'video/x-ms-asf', 'non', 'oui', 'video', '[[regtime]]'),
('avi', 'AVI', '', 'video/x-msvideo', 'embed', 'oui', 'video', '[[regtime]]'),
('axa', 'Annodex Audio', '', 'audio/annodex', 'embed', 'oui', 'audio', '[[regtime]]'),
('axv', 'Annodex Video', '', 'video/annodex', 'embed', 'oui', 'video', '[[regtime]]'),
('bib', 'BibTeX', '', 'application/x-bibtex', 'non', 'oui', 'file', '[[regtime]]'),
('bin', 'Binary Data', '', 'application/octet-stream', 'non', 'oui', 'file', '[[regtime]]'),
('blend', 'Blender', '', 'application/x-blender', 'non', 'oui', 'file', '[[regtime]]'),
('bmp', 'BMP', '', 'image/x-ms-bmp', 'image', 'oui', 'image', '[[regtime]]'),
('bz2', 'BZip', '', 'application/x-bzip2', 'non', 'oui', 'file', '[[regtime]]'),
('c', 'C source', '', 'text/x-csrc', 'non', 'oui', 'file', '[[regtime]]'),
('cls', 'LaTeX Class', '', 'text/x-tex', 'non', 'oui', 'file', '[[regtime]]'),
('csl', 'Citation Style Language', '', 'application/xml', 'non', 'oui', 'file', '[[regtime]]'),
('css', 'Cascading Style Sheet', '', 'text/css', 'non', 'oui', 'file', '[[regtime]]'),
('csv', 'Comma Separated Values', '', 'text/csv', 'non', 'oui', 'file', '[[regtime]]'),
('deb', 'Debian', '', 'application/x-debian-package', 'non', 'oui', 'file', '[[regtime]]'),
('djvu', 'DjVu', '', 'image/vnd.djvu', 'non', 'oui', 'image', '[[regtime]]'),
('doc', 'Word', '', 'application/msword', 'non', 'oui', 'file', '[[regtime]]'),
('docm', 'Word', '', 'application/vnd.ms-word.document.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('docx', 'Word', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'non', 'oui', 'file', '[[regtime]]'),
('dot', 'Word Template', '', 'application/msword', 'non', 'oui', 'file', '[[regtime]]'),
('dotm', 'Word template', '', 'application/vnd.ms-word.template.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('dotx', 'Word template', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'non', 'oui', 'file', '[[regtime]]'),
('dv', 'Digital Video', '', 'video/x-dv', 'embed', 'oui', 'video', '[[regtime]]'),
('dvi', 'LaTeX DVI', '', 'application/x-dvi', 'non', 'oui', 'file', '[[regtime]]'),
('emf', 'Enhanced Metafile', '', 'image/x-emf', 'non', 'oui', 'image', '[[regtime]]'),
('enl', 'EndNote Library', '', 'application/octet-stream', 'non', 'oui', 'file', '[[regtime]]'),
('ens', 'EndNote Style', '', 'application/octet-stream', 'non', 'oui', 'file', '[[regtime]]'),
('eps', 'PostScript', '', 'application/postscript', 'non', 'oui', 'file', '[[regtime]]'),
('epub', 'EPUB', '', 'application/epub+zip', 'non', 'oui', 'file', '[[regtime]]'),
('f4a', 'Audio for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', 'audio', '[[regtime]]'),
('f4b', 'Audio Book for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', 'audio', '[[regtime]]'),
('f4p', 'Protected Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', 'video', '[[regtime]]'),
('f4v', 'Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', 'video', '[[regtime]]'),
('flac', 'Free Lossless Audio Codec', '', 'audio/x-flac', 'embed', 'oui', 'audio', '[[regtime]]'),
('flv', 'Flash Video', '', 'video/x-flv', 'embed', 'oui', 'video', '[[regtime]]'),
('geojson', 'GeoJSON', '', 'application/json', 'non', 'oui', 'file', '[[regtime]]'),
('gif', 'GIF', '', 'image/gif', 'image', 'oui', 'image', '[[regtime]]'),
('gpx', 'GPS eXchange Format', '', 'application/gpx+xml', 'non', 'oui', 'file', '[[regtime]]'),
('gz', 'GZ', '', 'application/x-gzip', 'non', 'oui', 'file', '[[regtime]]'),
('h', 'C header', '', 'text/x-chdr', 'non', 'oui', 'file', '[[regtime]]'),
('html', 'HTML', '', 'text/html', 'non', 'oui', 'file', '[[regtime]]'),
('ics', 'iCalendar', '', 'text/calendar', 'non', 'oui', 'file', '[[regtime]]'),
('jar', 'Java Archive', '', 'application/java-archive', 'non', 'oui', 'file', '[[regtime]]'),
('jpg', 'JPEG', '', 'image/jpeg', 'image', 'oui', 'image', '[[regtime]]'),
('json', 'JSON', '', 'application/json', 'non', 'oui', 'file', '[[regtime]]'),
('kml', 'Keyhole Markup Language', '', 'application/vnd.google-earth.kml+xml', 'non', 'oui', 'file', '[[regtime]]'),
('kmz', 'Google Earth Placemark File', '', 'application/vnd.google-earth.kmz', 'non', 'oui', 'file', '[[regtime]]'),
('lyx', 'Lyx file', '', 'application/x-lyx', 'non', 'oui', 'file', '[[regtime]]'),
('m2p', 'MPEG-PS', '', 'video/MP2P', 'embed', 'oui', 'video', '[[regtime]]'),
('m2ts', 'BDAV MPEG-2 Transport Stream', '', 'video/MP2T', 'embed', 'oui', 'video', '[[regtime]]'),
('m3u', 'M3U Playlist', '', 'text/plain', 'non', 'oui', 'file', '[[regtime]]'),
('m3u8', 'M3U8 Playlist', '', 'text/plain', 'non', 'oui', 'file', '[[regtime]]'),
('m4a', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', 'audio', '[[regtime]]'),
('m4b', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', 'audio', '[[regtime]]'),
('m4p', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', 'audio', '[[regtime]]'),
('m4r', 'iPhone Ringtone', '', 'audio/aac', 'embed', 'oui', 'audio', '[[regtime]]'),
('m4u', 'MPEG4 Playlist', '', 'video/vnd.mpegurl', 'non', 'oui', 'video', '[[regtime]]'),
('m4v', 'MPEG4 Video', '', 'video/x-m4v', 'embed', 'oui', 'video', '[[regtime]]'),
('mathml', 'MathML', '', 'application/mathml+xml', 'non', 'oui', 'file', '[[regtime]]'),
('mbtiles', 'MBTiles', '', 'application/x-sqlite3', 'non', 'oui', 'file', '[[regtime]]'),
('md', 'Markdown Document', '', 'text/x-markdown', 'non', 'oui', 'file', '[[regtime]]'),
('mid', 'Midi', '', 'audio/midi', 'embed', 'oui', 'audio', '[[regtime]]'),
('mka', 'Matroska Audio', '', 'audio/mka', 'embed', 'oui', 'audio', '[[regtime]]'),
('mkv', 'Matroska Video', '', 'video/mkv', 'embed', 'oui', 'video', '[[regtime]]'),
('mng', 'MNG', '', 'video/x-mng', 'embed', 'oui', 'video', '[[regtime]]'),
('mov', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', 'video', '[[regtime]]'),
('mp3', 'MP3', '', 'audio/mpeg', 'embed', 'oui', 'audio', '[[regtime]]'),
('mp4', 'MPEG4', '', 'application/mp4', 'embed', 'oui', 'video', '[[regtime]]'),
('mpc', 'Musepack', '', 'audio/x-musepack', 'embed', 'oui', 'audio', '[[regtime]]'),
('mpg', 'MPEG', '', 'video/mpeg', 'embed', 'oui', 'video', '[[regtime]]'),
('mts', 'AVCHD MPEG-2 transport stream', '', 'video/MP2T', 'embed', 'oui', 'video', '[[regtime]]'),
('odb', 'OpenDocument Database', '', 'application/vnd.oasis.opendocument.database', 'non', 'oui', 'file', '[[regtime]]'),
('odc', 'OpenDocument Chart', '', 'application/vnd.oasis.opendocument.chart', 'non', 'oui', 'file', '[[regtime]]'),
('odf', 'OpenDocument Formula', '', 'application/vnd.oasis.opendocument.formula', 'non', 'oui', 'file', '[[regtime]]'),
('odg', 'OpenDocument Graphics', '', 'application/vnd.oasis.opendocument.graphics', 'non', 'oui', 'file', '[[regtime]]'),
('odi', 'OpenDocument Image', '', 'application/vnd.oasis.opendocument.image', 'non', 'oui', 'file', '[[regtime]]'),
('odm', 'OpenDocument Text-master', '', 'application/vnd.oasis.opendocument.text-master', 'non', 'oui', 'file', '[[regtime]]'),
('odp', 'OpenDocument Presentation', '', 'application/vnd.oasis.opendocument.presentation', 'non', 'oui', 'file', '[[regtime]]'),
('ods', 'OpenDocument Spreadsheet', '', 'application/vnd.oasis.opendocument.spreadsheet', 'non', 'oui', 'file', '[[regtime]]'),
('odt', 'OpenDocument Text', '', 'application/vnd.oasis.opendocument.text', 'non', 'oui', 'file', '[[regtime]]'),
('oga', 'Ogg Audio', '', 'audio/ogg', 'embed', 'oui', 'audio', '[[regtime]]'),
('ogg', 'Ogg Vorbis', '', 'audio/ogg', 'embed', 'oui', 'audio', '[[regtime]]'),
('ogv', 'Ogg Video', '', 'video/ogg', 'embed', 'oui', 'video', '[[regtime]]'),
('ogx', 'Ogg Multiplex', '', 'application/ogg', 'embed', 'oui', 'video', '[[regtime]]'),
('otg', 'OpenDocument Graphics-template', '', 'application/vnd.oasis.opendocument.graphics-template', 'non', 'oui', 'file', '[[regtime]]'),
('otp', 'OpenDocument Presentation-template', '', 'application/vnd.oasis.opendocument.presentation-template', 'non', 'oui', 'file', '[[regtime]]'),
('ots', 'OpenDocument Spreadsheet-template', '', 'application/vnd.oasis.opendocument.spreadsheet-template', 'non', 'oui', 'file', '[[regtime]]'),
('ott', 'OpenDocument Text-template', '', 'application/vnd.oasis.opendocument.text-template', 'non', 'oui', 'file', '[[regtime]]'),
('pas', 'Pascal', '', 'text/x-pascal', 'non', 'oui', 'file', '[[regtime]]'),
('pdf', 'PDF', '', 'application/pdf', 'non', 'oui', 'file', '[[regtime]]'),
('pgn', 'Portable Game Notation', '', 'application/x-chess-pgn', 'non', 'oui', 'file', '[[regtime]]'),
('pls', 'Playlist', '', 'text/plain', 'non', 'oui', 'file', '[[regtime]]'),
('png', 'PNG', '', 'image/png', 'image', 'oui', 'image', '[[regtime]]'),
('pot', 'PowerPoint Template', '', 'application/vnd.ms-powerpoint', 'non', 'oui', 'file', '[[regtime]]'),
('potm', 'Powerpoint template', '', 'application/vnd.ms-powerpoint.template.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('potx', 'Powerpoint template', '', 'application/vnd.openxmlformats-officedocument.presentationml.template', 'non', 'oui', 'file', '[[regtime]]'),
('ppam', 'Powerpoint addin', '', 'application/vnd.ms-powerpoint.addin.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('ppsm', 'Powerpoint slideshow', '', 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('ppsx', 'Powerpoint slideshow', '', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'non', 'oui', 'file', '[[regtime]]'),
('ppt', 'PowerPoint', '', 'application/vnd.ms-powerpoint', 'non', 'oui', 'file', '[[regtime]]'),
('pptm', 'Powerpoint', '', 'application/vnd.ms-powerpoint.presentation.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('pptx', 'Powerpoint', '', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'non', 'oui', 'file', '[[regtime]]'),
('ps', 'PostScript', '', 'application/postscript', 'non', 'oui', 'file', '[[regtime]]'),
('psd', 'Photoshop', '', 'image/x-photoshop', 'non', 'oui', 'image', '[[regtime]]'),
('qt', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', 'video', '[[regtime]]'),
('ra', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', 'audio', '[[regtime]]'),
('ram', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', 'audio', '[[regtime]]'),
('rar', 'WinRAR', '', 'application/x-rar-compressed', 'non', 'oui', 'file', '[[regtime]]'),
('rdf', 'Resource Description Framework', '', 'application/rdf+xml', 'non', 'oui', 'file', '[[regtime]]'),
('ris', 'RIS', '', 'application/x-research-info-systems', 'non', 'oui', 'file', '[[regtime]]'),
('rm', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', 'audio', '[[regtime]]'),
('rpm', 'RedHat/Mandrake/SuSE', '', 'application/x-redhat-package-manager', 'non', 'oui', 'file', '[[regtime]]'),
('rtf', 'RTF', '', 'application/rtf', 'non', 'oui', 'file', '[[regtime]]'),
('sdc', 'StarOffice Spreadsheet', '', 'application/vnd.stardivision.calc', 'non', 'oui', 'file', '[[regtime]]'),
('sdd', 'StarOffice Presentation', '', 'application/vnd.stardivision.impress', 'non', 'oui', 'file', '[[regtime]]'),
('sdw', 'StarOffice Writer document', '', 'application/vnd.stardivision.writer', 'non', 'oui', 'file', '[[regtime]]'),
('sit', 'Stuffit', '', 'application/x-stuffit', 'non', 'oui', 'file', '[[regtime]]'),
('sla', 'Scribus', '', 'application/x-scribus', 'non', 'oui', 'file', '[[regtime]]'),
('spx', 'Ogg Speex', '', 'audio/ogg', 'embed', 'oui', 'audio', '[[regtime]]'),
('srt', 'SubRip Subtitle', '', 'text/plain', 'non', 'oui', 'file', '[[regtime]]'),
('ssa', 'SubStation Alpha Subtitle', '', 'text/plain', 'non', 'oui', 'file', '[[regtime]]'),
('sty', 'LaTeX Style Sheet', '', 'text/x-tex', 'non', 'oui', 'file', '[[regtime]]'),
('svg', 'SVG', '', 'image/svg+xml', 'image', 'oui', 'image', '[[regtime]]'),
('svgz', 'Compressed Scalable Vector Graphic', '', 'image/svg+xml', 'embed', 'oui', 'image', '[[regtime]]'),
('swf', 'Flash', '', 'application/x-shockwave-flash', 'embed', 'oui', 'video', '[[regtime]]'),
('sxc', 'OpenOffice.org Calc', '', 'application/vnd.sun.xml.calc', 'non', 'oui', 'file', '[[regtime]]'),
('sxi', 'OpenOffice.org Impress', '', 'application/vnd.sun.xml.impress', 'non', 'oui', 'file', '[[regtime]]'),
('sxw', 'OpenOffice.org', '', 'application/vnd.sun.xml.writer', 'non', 'oui', 'file', '[[regtime]]'),
('tar', 'Tar', '', 'application/x-tar', 'non', 'oui', 'file', '[[regtime]]'),
('tex', 'LaTeX', '', 'text/x-tex', 'non', 'oui', 'file', '[[regtime]]'),
('tgz', 'TGZ', '', 'application/x-gtar', 'non', 'oui', 'file', '[[regtime]]'),
('tif', 'TIFF', '', 'image/tiff', 'embed', 'oui', 'image', '[[regtime]]'),
('torrent', 'BitTorrent', '', 'application/x-bittorrent', 'non', 'oui', 'file', '[[regtime]]'),
('ts', 'MPEG transport stream', '', 'video/MP2T', 'embed', 'oui', 'video', '[[regtime]]'),
('ttf', 'TTF Font', '', 'application/x-font-ttf', 'non', 'oui', 'file', '[[regtime]]'),
('txt', 'Texte', '', 'text/plain', 'non', 'oui', 'file', '[[regtime]]'),
('usf', 'Universal Subtitle Format', '', 'application/xml', 'non', 'oui', 'file', '[[regtime]]'),
('vcf', 'vCard', '', 'text/vcard', 'non', 'oui', 'file', '[[regtime]]'),
('vtt', 'WebVTT', '', 'text/vtt', 'non', 'oui', 'file', '[[regtime]]'),
('wav', 'WAV', '', 'audio/x-wav', 'embed', 'oui', 'audio', '[[regtime]]'),
('webm', 'WebM', '', 'video/webm', 'embed', 'oui', 'video', '[[regtime]]'),
('webp', 'WEBP', '', 'image/webp', 'image', 'oui', 'image', '[[regtime]]'),
('wma', 'Windows Media Audio', '', 'audio/x-ms-wma', 'embed', 'oui', 'audio', '[[regtime]]'),
('wmf', 'Windows Metafile', '', 'image/x-emf', 'non', 'oui', 'image', '[[regtime]]'),
('wmv', 'Windows Media Video', '', 'video/x-ms-wmv', 'embed', 'oui', 'video', '[[regtime]]'),
('wpl', 'Windows Media Player Playlist', '', 'application/vnd.ms-wpl', 'non', 'oui', 'file', '[[regtime]]'),
('xcf', 'GIMP multi-layer', '', 'application/x-xcf', 'non', 'oui', 'file', '[[regtime]]'),
('xlam', 'Excel', '', 'application/vnd.ms-excel.addin.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('xls', 'Excel', '', 'application/vnd.ms-excel', 'non', 'oui', 'file', '[[regtime]]'),
('xlsb', 'Excel binary', '', 'application/vnd.ms-excel.sheet.binary.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('xlsm', 'Excel', '', 'application/vnd.ms-excel.sheet.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('xlsx', 'Excel', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'non', 'oui', 'file', '[[regtime]]'),
('xlt', 'Excel Template', '', 'application/vnd.ms-excel', 'non', 'oui', 'file', '[[regtime]]'),
('xltm', 'Excel template', '', 'application/vnd.ms-excel.template.macroEnabled.12', 'non', 'oui', 'file', '[[regtime]]'),
('xltx', 'Excel template', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'non', 'oui', 'file', '[[regtime]]'),
('xml', 'XML', '', 'application/xml', 'non', 'oui', 'file', '[[regtime]]'),
('xspf', 'XSPF', '', 'application/xspf+xml', 'non', 'oui', 'file', '[[regtime]]'),
('y4m', 'YUV4MPEG2', '', 'video/x-raw-yuv', 'embed', 'oui', 'video', '[[regtime]]'),
('yaml', 'YAML', '', 'text/yaml', 'non', 'oui', 'file', '[[regtime]]'),
('zip', 'Zip', '', 'application/zip', 'non', 'oui', 'file', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_urls`
--

CREATE TABLE `[[dbprefix]]_urls` (
  `id_parent` bigint(21) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL,
  `type` varchar(25) NOT NULL DEFAULT 'article',
  `id_objet` bigint(21) NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `segments` smallint(3) NOT NULL DEFAULT '1',
  `perma` tinyint(1) NOT NULL DEFAULT '0',
  `langue` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id_parent`,`url`),
  KEY `type` (`type`,`id_objet`),
  KEY `langue` (`langue`),
  KEY `url` (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_versions`
--

CREATE TABLE `[[dbprefix]]_versions` (
  `id_version` bigint(21) NOT NULL DEFAULT '0',
  `id_objet` bigint(21) NOT NULL DEFAULT '0',
  `objet` varchar(25) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `id_auteur` varchar(23) NOT NULL DEFAULT '',
  `titre_version` text NOT NULL,
  `permanent` char(3) NOT NULL DEFAULT '',
  `champs` text NOT NULL,
  PRIMARY KEY (`id_version`,`id_objet`,`objet`),
  KEY `id_version` (`id_version`),
  KEY `id_objet` (`id_objet`),
  KEY `objet` (`objet`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_versions_fragments`
--

CREATE TABLE `[[dbprefix]]_versions_fragments` (
  `id_fragment` int(10) unsigned NOT NULL DEFAULT '0',
  `version_min` int(10) unsigned NOT NULL DEFAULT '0',
  `version_max` int(10) unsigned NOT NULL DEFAULT '0',
  `id_objet` bigint(21) NOT NULL,
  `objet` varchar(25) NOT NULL DEFAULT '',
  `compress` tinyint(4) NOT NULL,
  `fragment` longblob,
  PRIMARY KEY (`id_objet`,`objet`,`id_fragment`,`version_min`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_visites`
--

CREATE TABLE `[[dbprefix]]_visites` (
  `date` date NOT NULL,
  `visites` int(10) unsigned NOT NULL DEFAULT '0',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_visites_articles`
--

CREATE TABLE `[[dbprefix]]_visites_articles` (
  `date` date NOT NULL,
  `id_article` int(10) unsigned NOT NULL,
  `visites` int(10) unsigned NOT NULL DEFAULT '0',
  `maj` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`date`,`id_article`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
