<?php 
 $GLOBALS["dictionary"]["Reminder"]=array (
  'table' => 'reminders',
  'audited' => false,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'reportable' => true,
      'comment' => 'Unique identifier',
      'inline_edit' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'unified_search' => true,
      'full_text_search' => 
      array (
        'boost' => 3,
      ),
      'required' => true,
      'importable' => 'required',
      'duplicate_merge' => 'enabled',
      'merge_filter' => 'selected',
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'reminders_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'reminders_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'assigned_user_id' => 
    array (
      'name' => 'assigned_user_id',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'vname' => 'LBL_ASSIGNED_TO_ID',
      'group' => 'assigned_user_name',
      'type' => 'relate',
      'table' => 'users',
      'module' => 'Users',
      'reportable' => true,
      'isnull' => 'false',
      'dbType' => 'id',
      'audited' => true,
      'comment' => 'User ID assigned to record',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_name' => 
    array (
      'name' => 'assigned_user_name',
      'link' => 'assigned_user_link',
      'vname' => 'LBL_ASSIGNED_TO_NAME',
      'rname' => 'user_name',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'assigned_user_id',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
    ),
    'assigned_user_link' => 
    array (
      'name' => 'assigned_user_link',
      'type' => 'link',
      'relationship' => 'reminders_assigned_user',
      'vname' => 'LBL_ASSIGNED_TO_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
      'duplicate_merge' => 'enabled',
      'rname' => 'user_name',
      'id_name' => 'assigned_user_id',
      'table' => 'users',
    ),
    'popup' => 
    array (
      'name' => 'popup',
      'vname' => 'LBL_POPUP',
      'type' => 'bool',
      'required' => false,
      'massupdate' => false,
      'studio' => false,
    ),
    'email' => 
    array (
      'name' => 'email',
      'vname' => 'LBL_EMAIL',
      'type' => 'bool',
      'required' => false,
      'massupdate' => false,
      'studio' => false,
    ),
    'email_sent' => 
    array (
      'name' => 'email_sent',
      'vname' => 'LBL_EMAIL_SENT',
      'type' => 'bool',
      'required' => false,
      'massupdate' => false,
      'studio' => false,
    ),
    'timer_popup' => 
    array (
      'name' => 'timer_popup',
      'vname' => 'LBL_TIMER_POPUP',
      'type' => 'varchar',
      'len' => 32,
      'required' => true,
      'massupdate' => false,
      'studio' => false,
    ),
    'timer_email' => 
    array (
      'name' => 'timer_email',
      'vname' => 'LBL_TIMER_EMAIL',
      'type' => 'varchar',
      'len' => 32,
      'required' => true,
      'massupdate' => false,
      'studio' => false,
    ),
    'related_event_module' => 
    array (
      'name' => 'related_event_module',
      'vname' => 'LBL_RELATED_EVENT_MODULE',
      'type' => 'varchar',
      'len' => 32,
      'required' => true,
      'massupdate' => false,
      'studio' => false,
    ),
    'related_event_module_id' => 
    array (
      'name' => 'related_event_module_id',
      'vname' => 'LBL_RELATED_EVENT_MODULE_ID',
      'type' => 'id',
      'required' => true,
      'massupdate' => false,
      'studio' => false,
    ),
    'date_willexecute' => 
    array (
      'name' => 'date_willexecute',
      'vname' => 'LBL_DATE_WILLEXECUTE',
      'type' => 'int',
      'default' => -1,
      'len' => 60,
      'required' => false,
      'massupdate' => false,
      'studio' => false,
    ),
    'popup_viewed' => 
    array (
      'name' => 'popup_viewed',
      'type' => 'bool',
      'default' => '0',
      'importable' => true,
      'duplicate_merge' => 'disabled',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'reminderspk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
    0 => 
    array (
      'name' => 'idx_reminder_name',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'name',
      ),
    ),
    1 => 
    array (
      'name' => 'idx_reminder_deleted',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'deleted',
      ),
    ),
    2 => 
    array (
      'name' => 'idx_reminder_related_event_module',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'related_event_module',
      ),
    ),
    3 => 
    array (
      'name' => 'idx_reminder_related_event_module_id',
      'type' => 'index',
      'fields' => 
      array (
        0 => 'related_event_module_id',
      ),
    ),
  ),
  'relationships' => 
  array (
    'reminders_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Reminders',
      'rhs_table' => 'reminders',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'reminders_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Reminders',
      'rhs_table' => 'reminders',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'reminders_assigned_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'Reminders',
      'rhs_table' => 'reminders',
      'rhs_key' => 'assigned_user_id',
      'relationship_type' => 'one-to-many',
    ),
  ),
  'templates' => 
  array (
    'assignable' => 'assignable',
    'basic' => 'basic',
  ),
);