<?php 
 $GLOBALS["dictionary"]["ExternalOAuthProvider"]=array (
  'table' => 'external_oauth_providers',
  'comment' => 'External OAuth Provider',
  'audited' => false,
  'inline_edit' => false,
  'massupdate' => false,
  'exportable' => false,
  'importable' => false,
  'fields' => 
  array (
    'id' => 
    array (
      'name' => 'id',
      'vname' => 'LBL_ID',
      'type' => 'id',
      'required' => true,
      'comment' => 'Unique identifier',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'name' => 
    array (
      'name' => 'name',
      'vname' => 'LBL_NAME',
      'type' => 'name',
      'link' => true,
      'dbType' => 'varchar',
      'len' => 255,
      'required' => true,
      'duplicate_merge' => 'disabled',
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'date_entered' => 
    array (
      'name' => 'date_entered',
      'vname' => 'LBL_DATE_ENTERED',
      'type' => 'datetime',
      'group' => 'created_by_name',
      'comment' => 'Date record created',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'date_modified' => 
    array (
      'name' => 'date_modified',
      'vname' => 'LBL_DATE_MODIFIED',
      'type' => 'datetime',
      'group' => 'modified_by_name',
      'comment' => 'Date record last modified',
      'enable_range_search' => true,
      'options' => 'date_range_search_dom',
      'inline_edit' => false,
    ),
    'modified_user_id' => 
    array (
      'name' => 'modified_user_id',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_MODIFIED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'group' => 'modified_by_name',
      'dbType' => 'id',
      'reportable' => true,
      'comment' => 'User who last modified record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'modified_by_name' => 
    array (
      'name' => 'modified_by_name',
      'vname' => 'LBL_MODIFIED_NAME',
      'type' => 'relate',
      'reportable' => false,
      'source' => 'non-db',
      'rname' => 'user_name',
      'table' => 'users',
      'id_name' => 'modified_user_id',
      'module' => 'Users',
      'link' => 'modified_user_link',
      'duplicate_merge' => 'disabled',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by' => 
    array (
      'name' => 'created_by',
      'rname' => 'user_name',
      'id_name' => 'modified_user_id',
      'vname' => 'LBL_CREATED',
      'type' => 'assigned_user_name',
      'table' => 'users',
      'isnull' => 'false',
      'dbType' => 'id',
      'group' => 'created_by_name',
      'comment' => 'User who created record',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'created_by_name' => 
    array (
      'name' => 'created_by_name',
      'vname' => 'LBL_CREATED',
      'type' => 'relate',
      'reportable' => false,
      'link' => 'created_by_link',
      'rname' => 'user_name',
      'source' => 'non-db',
      'table' => 'users',
      'id_name' => 'created_by',
      'module' => 'Users',
      'duplicate_merge' => 'disabled',
      'importable' => 'false',
      'massupdate' => false,
      'inline_edit' => false,
    ),
    'description' => 
    array (
      'name' => 'description',
      'vname' => 'LBL_DESCRIPTION',
      'type' => 'text',
      'comment' => 'Full text of the note',
      'rows' => 6,
      'cols' => 80,
    ),
    'deleted' => 
    array (
      'name' => 'deleted',
      'vname' => 'LBL_DELETED',
      'type' => 'bool',
      'default' => '0',
      'reportable' => false,
      'comment' => 'Record deletion indicator',
    ),
    'created_by_link' => 
    array (
      'name' => 'created_by_link',
      'type' => 'link',
      'relationship' => 'externaloauthprovider_created_by',
      'vname' => 'LBL_CREATED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'modified_user_link' => 
    array (
      'name' => 'modified_user_link',
      'type' => 'link',
      'relationship' => 'externaloauthprovider_modified_user',
      'vname' => 'LBL_MODIFIED_USER',
      'link_type' => 'one',
      'module' => 'Users',
      'bean_name' => 'User',
      'source' => 'non-db',
    ),
    'SecurityGroups' => 
    array (
      'name' => 'SecurityGroups',
      'type' => 'link',
      'relationship' => 'securitygroups_externaloauthprovider',
      'module' => 'SecurityGroups',
      'bean_name' => 'SecurityGroup',
      'source' => 'non-db',
      'vname' => 'LBL_SECURITYGROUPS',
    ),
    'type' => 
    array (
      'name' => 'type',
      'vname' => 'LBL_TYPE',
      'type' => 'enum',
      'options' => 'dom_external_oauth_provider_types',
      'display' => 'readonly',
      'inline_edit' => false,
      'reportable' => false,
      'massupdate' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'connector' => 
    array (
      'name' => 'connector',
      'vname' => 'LBL_CONNECTOR',
      'function' => 
      array (
        'name' => 'getExternalOAuthProviderConnectors',
        'returns' => 'html',
        'include' => 'modules/ExternalOAuthProvider/utils.php',
      ),
      'type' => 'varchar',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'redirect_uri' => 
    array (
      'name' => 'redirect_uri',
      'vname' => 'LBL_REDIRECT_URI',
      'function' => 
      array (
        'name' => 'getExternalOAuthProviderRedirectURI',
        'returns' => 'html',
        'include' => 'modules/ExternalOAuthProvider/utils.php',
      ),
      'type' => 'varchar',
      'source' => 'non-db',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'client_id' => 
    array (
      'name' => 'client_id',
      'vname' => 'LBL_CLIENT_ID',
      'type' => 'varchar',
      'required' => true,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'client_secret' => 
    array (
      'name' => 'client_secret',
      'vname' => 'LBL_CLIENT_SECRET',
      'type' => 'varchar',
      'display' => 'writeonly',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
      'sensitive' => true,
      'api-visible' => false,
      'db_encrypted' => true,
    ),
    'scope' => 
    array (
      'name' => 'scope',
      'vname' => 'LBL_SCOPE',
      'type' => 'stringmap',
      'dbType' => 'text',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'url_authorize' => 
    array (
      'name' => 'url_authorize',
      'vname' => 'LBL_URL_AUTHORIZE',
      'type' => 'varchar',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'authorize_url_options' => 
    array (
      'name' => 'authorize_url_options',
      'vname' => 'LBL_AUTHORIZE_URL_OPTIONS',
      'type' => 'stringmap',
      'dbType' => 'text',
      'show_keys' => true,
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'url_access_token' => 
    array (
      'name' => 'url_access_token',
      'vname' => 'LBL_URL_ACCESS_TOKEN',
      'type' => 'varchar',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'extra_provider_params' => 
    array (
      'name' => 'extra_provider_params',
      'vname' => 'LBL_EXTRA_PROVIDER_PARAMS',
      'type' => 'stringmap',
      'dbType' => 'text',
      'show_keys' => true,
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'get_token_request_grant' => 
    array (
      'name' => 'get_token_request_grant',
      'vname' => 'LBL_GET_TOKEN_REQUEST_GRANT',
      'type' => 'varchar',
      'default' => 'authorization_code',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'get_token_request_options' => 
    array (
      'name' => 'get_token_request_options',
      'vname' => 'LBL_GET_TOKEN_REQUEST_OPTIONS',
      'type' => 'stringmap',
      'dbType' => 'text',
      'show_keys' => true,
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'refresh_token_request_grant' => 
    array (
      'name' => 'refresh_token_request_grant',
      'vname' => 'LBL_REFRESH_TOKEN_REQUEST_GRANT',
      'type' => 'varchar',
      'default' => 'refresh_token',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'refresh_token_request_options' => 
    array (
      'name' => 'refresh_token_request_options',
      'vname' => 'LBL_REFRESH_TOKEN_REQUEST_OPTIONS',
      'type' => 'stringmap',
      'dbType' => 'text',
      'show_keys' => true,
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'access_token_mapping' => 
    array (
      'name' => 'access_token_mapping',
      'vname' => 'LBL_ACCESS_TOKEN_MAPPING',
      'type' => 'varchar',
      'default' => 'access_token',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'expires_in_mapping' => 
    array (
      'name' => 'expires_in_mapping',
      'vname' => 'LBL_EXPIRES_IN_MAPPING',
      'type' => 'varchar',
      'default' => 'expires_in',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'refresh_token_mapping' => 
    array (
      'name' => 'refresh_token_mapping',
      'vname' => 'LBL_REFRESH_TOKEN_MAPPING',
      'type' => 'varchar',
      'default' => 'refresh_token',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
    'token_type_mapping' => 
    array (
      'name' => 'token_type_mapping',
      'vname' => 'LBL_TOKEN_TYPE_MAPPING',
      'type' => 'varchar',
      'required' => false,
      'reportable' => false,
      'massupdate' => false,
      'inline_edit' => false,
      'importable' => false,
      'exportable' => false,
      'unified_search' => false,
    ),
  ),
  'relationships' => 
  array (
    'externaloauthprovider_modified_user' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'ExternalOAuthProvider',
      'rhs_table' => 'external_oauth_providers',
      'rhs_key' => 'modified_user_id',
      'relationship_type' => 'one-to-many',
    ),
    'externaloauthprovider_created_by' => 
    array (
      'lhs_module' => 'Users',
      'lhs_table' => 'users',
      'lhs_key' => 'id',
      'rhs_module' => 'ExternalOAuthProvider',
      'rhs_table' => 'external_oauth_providers',
      'rhs_key' => 'created_by',
      'relationship_type' => 'one-to-many',
    ),
    'securitygroups_externaloauthprovider' => 
    array (
      'lhs_module' => 'SecurityGroups',
      'lhs_table' => 'securitygroups',
      'lhs_key' => 'id',
      'rhs_module' => 'ExternalOAuthProvider',
      'rhs_table' => 'external_oauth_providers',
      'rhs_key' => 'id',
      'relationship_type' => 'many-to-many',
      'join_table' => 'securitygroups_records',
      'join_key_lhs' => 'securitygroup_id',
      'join_key_rhs' => 'record_id',
      'relationship_role_column' => 'module',
      'relationship_role_column_value' => 'ExternalOAuthProvider',
    ),
  ),
  'indices' => 
  array (
    'id' => 
    array (
      'name' => 'externaloauthproviderpk',
      'type' => 'primary',
      'fields' => 
      array (
        0 => 'id',
      ),
    ),
  ),
  'templates' => 
  array (
    'security_groups' => 'security_groups',
    'basic' => 'basic',
  ),
);