
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `tastyigniter377`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]activities`
--

CREATE TABLE `[[dbprefix]]activities` (
  `activity_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `log_name` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text COLLATE utf8mb4_unicode_ci,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `updated_at` datetime NOT NULL,
  `type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` datetime DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `user_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`activity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]addresses`
--

CREATE TABLE `[[dbprefix]]addresses` (
  `address_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `address_1` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address_2` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`address_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]allergenables`
--

CREATE TABLE `[[dbprefix]]allergenables` (
  `allergen_id` int(10) unsigned NOT NULL,
  `allergenable_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allergenable_id` bigint(20) unsigned NOT NULL,
  UNIQUE KEY `allergenable_unique` (`allergen_id`,`allergenable_id`,`allergenable_type`),
  KEY `allergenable_index` (`allergenable_type`,`allergenable_id`),
  KEY `[[dbprefix]]allergenables_allergen_id_index` (`allergen_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]allergens`
--

CREATE TABLE `[[dbprefix]]allergens` (
  `allergen_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`allergen_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]assignable_logs`
--

CREATE TABLE `[[dbprefix]]assignable_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `assignable_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `assignable_id` bigint(20) unsigned NOT NULL,
  `assignee_id` int(10) unsigned DEFAULT NULL,
  `assignee_group_id` int(10) unsigned DEFAULT NULL,
  `status_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]assignable_logs_assignable_type_assignable_id_index` (`assignable_type`,`assignable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]banners`
--

CREATE TABLE `[[dbprefix]]banners` (
  `banner_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` char(8) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_url` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `language_id` int(11) NOT NULL,
  `alt_text` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_code` text COLLATE utf8mb4_unicode_ci,
  `custom_code` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]cache`
--

CREATE TABLE `[[dbprefix]]cache` (
  `key` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL,
  UNIQUE KEY `[[dbprefix]]cache_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]categories`
--

CREATE TABLE `[[dbprefix]]categories` (
  `category_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `parent_id` int(11) DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `nest_left` int(11) DEFAULT NULL,
  `nest_right` int(11) DEFAULT NULL,
  `permalink_slug` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]countries`
--

CREATE TABLE `[[dbprefix]]countries` (
  `country_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso_code_2` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iso_code_3` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `format` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=240 ;

--
-- Dumping data for table `[[dbprefix]]countries`
--

INSERT INTO `[[dbprefix]]countries` VALUES
(1, 'Afghanistan', 'AF', 'AFG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(2, 'Albania', 'AL', 'ALB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(3, 'Algeria', 'DZ', 'DZA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(4, 'American Samoa', 'AS', 'ASM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(5, 'Andorra', 'AD', 'AND', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(6, 'Angola', 'AO', 'AGO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(7, 'Anguilla', 'AI', 'AIA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(8, 'Antarctica', 'AQ', 'ATA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(9, 'Antigua and Barbuda', 'AG', 'ATG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(10, 'Argentina', 'AR', 'ARG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(11, 'Armenia', 'AM', 'ARM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(12, 'Aruba', 'AW', 'ABW', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(13, 'Australia', 'AU', 'AUS', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(14, 'Austria', 'AT', 'AUT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(15, 'Azerbaijan', 'AZ', 'AZE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(16, 'Bahamas', 'BS', 'BHS', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(17, 'Bahrain', 'BH', 'BHR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(18, 'Bangladesh', 'BD', 'BGD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(19, 'Barbados', 'BB', 'BRB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(20, 'Belarus', 'BY', 'BLR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(21, 'Belgium', 'BE', 'BEL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(22, 'Belize', 'BZ', 'BLZ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(23, 'Benin', 'BJ', 'BEN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(24, 'Bermuda', 'BM', 'BMU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(25, 'Bhutan', 'BT', 'BTN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(26, 'Bolivia', 'BO', 'BOL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(28, 'Botswana', 'BW', 'BWA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(29, 'Bouvet Island', 'BV', 'BVT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(30, 'Brazil', 'BR', 'BRA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(32, 'Brunei Darussalam', 'BN', 'BRN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(33, 'Bulgaria', 'BG', 'BGR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(34, 'Burkina Faso', 'BF', 'BFA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(35, 'Burundi', 'BI', 'BDI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(36, 'Cambodia', 'KH', 'KHM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(37, 'Cameroon', 'CM', 'CMR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(38, 'Canada', 'CA', 'CAN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(39, 'Cape Verde', 'CV', 'CPV', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(40, 'Cayman Islands', 'KY', 'CYM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(41, 'Central African Republic', 'CF', 'CAF', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(42, 'Chad', 'TD', 'TCD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(43, 'Chile', 'CL', 'CHL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(44, 'China', 'CN', 'CHN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(45, 'Christmas Island', 'CX', 'CXR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(47, 'Colombia', 'CO', 'COL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(48, 'Comoros', 'KM', 'COM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(49, 'Congo', 'CG', 'COG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(50, 'Cook Islands', 'CK', 'COK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(51, 'Costa Rica', 'CR', 'CRI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(52, 'Cote D''Ivoire', 'CI', 'CIV', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(53, 'Croatia', 'HR', 'HRV', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(54, 'Cuba', 'CU', 'CUB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(55, 'Cyprus', 'CY', 'CYP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(56, 'Czech Republic', 'CZ', 'CZE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(57, 'Denmark', 'DK', 'DNK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(58, 'Djibouti', 'DJ', 'DJI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(59, 'Dominica', 'DM', 'DMA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(60, 'Dominican Republic', 'DO', 'DOM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(61, 'East Timor', 'TP', 'TMP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(62, 'Ecuador', 'EC', 'ECU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(63, 'Egypt', 'EG', 'EGY', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(64, 'El Salvador', 'SV', 'SLV', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(66, 'Eritrea', 'ER', 'ERI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(67, 'Estonia', 'EE', 'EST', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(68, 'Ethiopia', 'ET', 'ETH', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(70, 'Faroe Islands', 'FO', 'FRO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(71, 'Fiji', 'FJ', 'FJI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(72, 'Finland', 'FI', 'FIN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(73, 'France', 'FR', 'FRA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(74, 'France, Metropolitan', 'FX', 'FXX', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(75, 'French Guiana', 'GF', 'GUF', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(76, 'French Polynesia', 'PF', 'PYF', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(77, 'French Southern Territories', 'TF', 'ATF', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(78, 'Gabon', 'GA', 'GAB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(79, 'Gambia', 'GM', 'GMB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(80, 'Georgia', 'GE', 'GEO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(81, 'Germany', 'DE', 'DEU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(82, 'Ghana', 'GH', 'GHA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(83, 'Gibraltar', 'GI', 'GIB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(84, 'Greece', 'GR', 'GRC', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(85, 'Greenland', 'GL', 'GRL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(86, 'Grenada', 'GD', 'GRD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(87, 'Guadeloupe', 'GP', 'GLP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(88, 'Guam', 'GU', 'GUM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(89, 'Guatemala', 'GT', 'GTM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(90, 'Guinea', 'GN', 'GIN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(91, 'Guinea-bissau', 'GW', 'GNB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(92, 'Guyana', 'GY', 'GUY', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(93, 'Haiti', 'HT', 'HTI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(95, 'Honduras', 'HN', 'HND', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(96, 'Hong Kong', 'HK', 'HKG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(97, 'Hungary', 'HU', 'HUN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(98, 'Iceland', 'IS', 'ISL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(99, 'India', 'IN', 'IND', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(100, 'Indonesia', 'ID', 'IDN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(102, 'Iraq', 'IQ', 'IRQ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(103, 'Ireland', 'IE', 'IRL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(104, 'Israel', 'IL', 'ISR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(105, 'Italy', 'IT', 'ITA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(106, 'Jamaica', 'JM', 'JAM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(107, 'Japan', 'JP', 'JPN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(108, 'Jordan', 'JO', 'JOR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(109, 'Kazakhstan', 'KZ', 'KAZ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(110, 'Kenya', 'KE', 'KEN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(111, 'Kiribati', 'KI', 'KIR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(112, 'North Korea', 'KP', 'PRK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(113, 'Korea, Republic of', 'KR', 'KOR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(114, 'Kuwait', 'KW', 'KWT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(115, 'Kyrgyzstan', 'KG', 'KGZ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(116, 'Lao People''s Democratic Republic', 'LA', 'LAO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(117, 'Latvia', 'LV', 'LVA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(118, 'Lebanon', 'LB', 'LBN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(119, 'Lesotho', 'LS', 'LSO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(120, 'Liberia', 'LR', 'LBR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(122, 'Liechtenstein', 'LI', 'LIE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(123, 'Lithuania', 'LT', 'LTU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(124, 'Luxembourg', 'LU', 'LUX', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(125, 'Macau', 'MO', 'MAC', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(126, 'FYROM', 'MK', 'MKD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(127, 'Madagascar', 'MG', 'MDG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(128, 'Malawi', 'MW', 'MWI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(129, 'Malaysia', 'MY', 'MYS', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(130, 'Maldives', 'MV', 'MDV', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(131, 'Mali', 'ML', 'MLI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(132, 'Malta', 'MT', 'MLT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(133, 'Marshall Islands', 'MH', 'MHL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(134, 'Martinique', 'MQ', 'MTQ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(135, 'Mauritania', 'MR', 'MRT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(136, 'Mauritius', 'MU', 'MUS', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(137, 'Mayotte', 'YT', 'MYT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(138, 'Mexico', 'MX', 'MEX', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(140, 'Moldova, Republic of', 'MD', 'MDA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(141, 'Monaco', 'MC', 'MCO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(142, 'Mongolia', 'MN', 'MNG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(143, 'Montserrat', 'MS', 'MSR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(144, 'Morocco', 'MA', 'MAR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(145, 'Mozambique', 'MZ', 'MOZ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(146, 'Myanmar', 'MM', 'MMR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(147, 'Namibia', 'NA', 'NAM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(148, 'Nauru', 'NR', 'NRU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(149, 'Nepal', 'NP', 'NPL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(150, 'Netherlands', 'NL', 'NLD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(151, 'Netherlands Antilles', 'AN', 'ANT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(152, 'New Caledonia', 'NC', 'NCL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(153, 'New Zealand', 'NZ', 'NZL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(154, 'Nicaragua', 'NI', 'NIC', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(155, 'Niger', 'NE', 'NER', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(156, 'Nigeria', 'NG', 'NGA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(157, 'Niue', 'NU', 'NIU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(158, 'Norfolk Island', 'NF', 'NFK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(159, 'Northern Mariana Islands', 'MP', 'MNP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(160, 'Norway', 'NO', 'NOR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(161, 'Oman', 'OM', 'OMN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(162, 'Pakistan', 'PK', 'PAK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(163, 'Palau', 'PW', 'PLW', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(164, 'Panama', 'PA', 'PAN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(165, 'Papua New Guinea', 'PG', 'PNG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(166, 'Paraguay', 'PY', 'PRY', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(167, 'Peru', 'PE', 'PER', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(168, 'Philippines', 'PH', 'PHL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(169, 'Pitcairn', 'PN', 'PCN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(170, 'Poland', 'PL', 'POL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(171, 'Portugal', 'PT', 'PRT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(172, 'Puerto Rico', 'PR', 'PRI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(173, 'Qatar', 'QA', 'QAT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(174, 'Reunion', 'RE', 'REU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(175, 'Romania', 'RO', 'ROM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(176, 'Russian Federation', 'RU', 'RUS', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(177, 'Rwanda', 'RW', 'RWA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(179, 'Saint Lucia', 'LC', 'LCA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(181, 'Samoa', 'WS', 'WSM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(182, 'San Marino', 'SM', 'SMR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(183, 'Sao Tome and Principe', 'ST', 'STP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(184, 'Saudi Arabia', 'SA', 'SAU', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(185, 'Senegal', 'SN', 'SEN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(186, 'Seychelles', 'SC', 'SYC', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(187, 'Sierra Leone', 'SL', 'SLE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(188, 'Singapore', 'SG', 'SGP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(189, 'Slovak Republic', 'SK', 'SVK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(190, 'Slovenia', 'SI', 'SVN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(191, 'Solomon Islands', 'SB', 'SLB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(192, 'Somalia', 'SO', 'SOM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(193, 'South Africa', 'ZA', 'ZAF', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(194, 'South Georgia &amp; South Sandwich Islands', 'GS', 'SGS', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(195, 'Spain', 'ES', 'ESP', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(196, 'Sri Lanka', 'LK', 'LKA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(197, 'St. Helena', 'SH', 'SHN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(199, 'Sudan', 'SD', 'SDN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(200, 'Suriname', 'SR', 'SUR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(202, 'Swaziland', 'SZ', 'SWZ', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(203, 'Sweden', 'SE', 'SWE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(204, 'Switzerland', 'CH', 'CHE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(205, 'Syrian Arab Republic', 'SY', 'SYR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(206, 'Taiwan', 'TW', 'TWN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(207, 'Tajikistan', 'TJ', 'TJK', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(209, 'Thailand', 'TH', 'THA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(210, 'Togo', 'TG', 'TGO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(211, 'Tokelau', 'TK', 'TKL', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(212, 'Tonga', 'TO', 'TON', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(213, 'Trinidad and Tobago', 'TT', 'TTO', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(214, 'Tunisia', 'TN', 'TUN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(215, 'Turkey', 'TR', 'TUR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(216, 'Turkmenistan', 'TM', 'TKM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(218, 'Tuvalu', 'TV', 'TUV', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(219, 'Uganda', 'UG', 'UGA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(220, 'Ukraine', 'UA', 'UKR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(221, 'United Arab Emirates', 'AE', 'ARE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(222, 'United Kingdom', 'GB', 'GBR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(223, 'United States', 'US', 'USA', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(225, 'Uruguay', 'UY', 'URY', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(226, 'Uzbekistan', 'UZ', 'UZB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(227, 'Vanuatu', 'VU', 'VUT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(229, 'Venezuela', 'VE', 'VEN', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(230, 'Viet Nam', 'VN', 'VNM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(231, 'Virgin Islands (British)', 'VG', 'VGB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(234, 'Western Sahara', 'EH', 'ESH', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(235, 'Yemen', 'YE', 'YEM', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(236, 'Yugoslavia', 'YU', 'YUG', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(237, 'Democratic Republic of Congo', 'CD', 'COD', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(238, 'Zambia', 'ZM', 'ZMB', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]'),
(239, 'Zimbabwe', 'ZW', 'ZWE', '{address_1}\\n{address_2}\\n{city} {postcode} {state}\\n{country}', 1, 999, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]currencies`
--

CREATE TABLE `[[dbprefix]]currencies` (
  `currency_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `currency_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_code` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_rate` decimal(15,8) NOT NULL,
  `symbol_position` tinyint(1) DEFAULT NULL,
  `thousand_sign` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_sign` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_position` char(1) COLLATE utf8mb4_unicode_ci NOT NULL,
  `iso_alpha2` varchar(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iso_alpha3` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `iso_numeric` int(11) DEFAULT NULL,
  `currency_status` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`currency_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]currencies`
--

INSERT INTO `[[dbprefix]]currencies` VALUES
(1, 222, 'Pound Sterling', 'GBP', '£', '0.00000000', 0, ',', '.', '2', 'GB', 'GBR', 826, 1, '[[regtime]]', '[[regtime]]'),
(2, 223, 'US Dollar', 'USD', '$', '0.00000000', 0, ',', '.', '2', 'US', 'USA', 840, 0, '[[regtime]]', '[[regtime]]'),
(3, 44, 'Yuan Renminbi', 'CNY', '¥', '0.00000000', 0, ',', '.', '2', 'CN', 'CHN', 156, 0, '[[regtime]]', '[[regtime]]'),
(4, 13, 'Australian Dollar', 'AUD', '$', '0.00000000', 0, ',', '.', '2', 'AU', 'AUS', 36, 1, '[[regtime]]', '[[regtime]]'),
(5, 156, 'Naira', 'NGN', '₦', '0.00000000', 0, ',', '.', '2', 'NG', 'NGA', 566, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customers`
--

CREATE TABLE `[[dbprefix]]customers` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address_id` int(11) DEFAULT NULL,
  `newsletter` tinyint(1) DEFAULT NULL,
  `customer_group_id` int(11) NOT NULL,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  `reset_code` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reset_time` datetime DEFAULT NULL,
  `activation_code` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_activated` tinyint(1) DEFAULT NULL,
  `date_activated` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_seen` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `[[dbprefix]]customers_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]customer_groups`
--

CREATE TABLE `[[dbprefix]]customer_groups` (
  `customer_group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `approval` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`customer_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]customer_groups`
--

INSERT INTO `[[dbprefix]]customer_groups` VALUES
(1, 'Default group', NULL, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extensions`
--

CREATE TABLE `[[dbprefix]]extensions` (
  `extension_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '1.0.0',
  PRIMARY KEY (`extension_id`),
  UNIQUE KEY `[[dbprefix]]extensions_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]extension_settings`
--

CREATE TABLE `[[dbprefix]]extension_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `item` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]extension_settings_item_unique` (`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]failed_jobs`
--

CREATE TABLE `[[dbprefix]]failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]jobs`
--

CREATE TABLE `[[dbprefix]]jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]job_batches`
--

CREATE TABLE `[[dbprefix]]job_batches` (
  `id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]languages`
--

CREATE TABLE `[[dbprefix]]languages` (
  `language_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idiom` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  `can_delete` tinyint(1) NOT NULL,
  `original_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `version` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`language_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]languages`
--

INSERT INTO `[[dbprefix]]languages` VALUES
(1, 'en', 'English', NULL, 'english', 1, 0, NULL, '[[regtime]]', '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]language_translations`
--

CREATE TABLE `[[dbprefix]]language_translations` (
  `translation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `locale` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `namespace` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '*',
  `group` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `unstable` tinyint(1) NOT NULL DEFAULT '0',
  `locked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `[[dbprefix]]language_translations_locale_namespace_group_item_unique` (`locale`,`namespace`,`group`,`item`),
  KEY `[[dbprefix]]language_translations_group_index` (`group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locationables`
--

CREATE TABLE `[[dbprefix]]locationables` (
  `location_id` int(11) NOT NULL,
  `locationable_id` int(11) NOT NULL,
  `locationable_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]locationables`
--

INSERT INTO `[[dbprefix]]locationables` VALUES
(1, 1, 'tables', NULL),
(1, 2, 'tables', NULL),
(1, 3, 'tables', NULL),
(1, 4, 'tables', NULL),
(1, 5, 'tables', NULL),
(1, 6, 'tables', NULL),
(1, 7, 'tables', NULL),
(1, 8, 'tables', NULL),
(1, 9, 'tables', NULL),
(1, 10, 'tables', NULL),
(1, 11, 'tables', NULL),
(1, 12, 'tables', NULL),
(1, 13, 'tables', NULL),
(1, 14, 'tables', NULL),
(1, 1, 'staffs', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]locations`
--

CREATE TABLE `[[dbprefix]]locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `location_address_1` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_address_2` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_city` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_state` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_postcode` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_country_id` int(11) DEFAULT NULL,
  `location_telephone` text COLLATE utf8mb4_unicode_ci,
  `location_lat` double DEFAULT NULL,
  `location_lng` double DEFAULT NULL,
  `location_radius` int(11) DEFAULT NULL,
  `location_status` tinyint(1) DEFAULT NULL,
  `permalink_slug` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`location_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]locations`
--

INSERT INTO `[[dbprefix]]locations` VALUES
(1, 'Default', '[[admin_email]]', NULL, 'Broad Ln', NULL, 'Coventry', NULL, NULL, 222, '8765456789', 52.415884, -1.603648, NULL, 1, 'default', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_areas`
--

CREATE TABLE `[[dbprefix]]location_areas` (
  `area_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `boundaries` json NOT NULL,
  `conditions` json NOT NULL,
  `color` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`area_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]location_options`
--

CREATE TABLE `[[dbprefix]]location_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` bigint(20) unsigned NOT NULL,
  `item` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `[[dbprefix]]location_options_location_id_item_unique` (`location_id`,`item`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_layouts`
--

CREATE TABLE `[[dbprefix]]mail_layouts` (
  `layout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_id` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `layout` text COLLATE utf8mb4_unicode_ci,
  `plain_layout` text COLLATE utf8mb4_unicode_ci,
  `layout_css` text COLLATE utf8mb4_unicode_ci,
  `is_locked` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`layout_id`),
  UNIQUE KEY `[[dbprefix]]mail_layouts_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_partials`
--

CREATE TABLE `[[dbprefix]]mail_partials` (
  `partial_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `html` text COLLATE utf8mb4_unicode_ci,
  `text` text COLLATE utf8mb4_unicode_ci,
  `is_custom` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`partial_id`),
  UNIQUE KEY `[[dbprefix]]mail_partials_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mail_templates`
--

CREATE TABLE `[[dbprefix]]mail_templates` (
  `template_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `layout_id` int(11) NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `label` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_custom` tinyint(1) DEFAULT NULL,
  `plain_body` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`template_id`),
  UNIQUE KEY `[[dbprefix]]mail_templates_data_template_id_code_unique` (`layout_id`,`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]mealtimes`
--

CREATE TABLE `[[dbprefix]]mealtimes` (
  `mealtime_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mealtime_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` time NOT NULL DEFAULT '00:00:00',
  `end_time` time NOT NULL DEFAULT '23:59:59',
  `mealtime_status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`mealtime_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]mealtimes`
--

INSERT INTO `[[dbprefix]]mealtimes` VALUES
(1, 'Breakfast', '07:00:00', '10:00:00', 1, '[[regtime]]', '[[regtime]]'),
(2, 'Lunch', '12:00:00', '14:30:00', 1, '[[regtime]]', '[[regtime]]'),
(3, 'Dinner', '18:00:00', '20:00:00', 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]media_attachments`
--

CREATE TABLE `[[dbprefix]]media_attachments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `disk` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `tag` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment_id` bigint(20) unsigned DEFAULT NULL,
  `is_public` tinyint(1) NOT NULL DEFAULT '1',
  `custom_properties` text COLLATE utf8mb4_unicode_ci,
  `priority` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]media_attachments_attachment_type_attachment_id_index` (`attachment_type`,`attachment_id`),
  KEY `[[dbprefix]]media_attachments_tag_index` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menus`
--

CREATE TABLE `[[dbprefix]]menus` (
  `menu_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_price` decimal(15,4) NOT NULL,
  `minimum_qty` int(11) NOT NULL DEFAULT '0',
  `menu_status` tinyint(1) NOT NULL,
  `menu_priority` int(11) NOT NULL DEFAULT '0',
  `order_restriction` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menus_specials`
--

CREATE TABLE `[[dbprefix]]menus_specials` (
  `special_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `end_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `special_price` decimal(15,4) DEFAULT NULL,
  `special_status` tinyint(1) NOT NULL,
  `type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `validity` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recurring_every` text COLLATE utf8mb4_unicode_ci,
  `recurring_from` time DEFAULT NULL,
  `recurring_to` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`special_id`),
  UNIQUE KEY `[[dbprefix]]menus_specials_special_id_menu_id_unique` (`special_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_categories`
--

CREATE TABLE `[[dbprefix]]menu_categories` (
  `menu_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `[[dbprefix]]menu_categories_menu_id_category_id_unique` (`menu_id`,`category_id`),
  KEY `[[dbprefix]]menu_categories_menu_id_index` (`menu_id`),
  KEY `[[dbprefix]]menu_categories_category_id_index` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_item_options`
--

CREATE TABLE `[[dbprefix]]menu_item_options` (
  `menu_option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `min_selected` int(11) NOT NULL DEFAULT '0',
  `max_selected` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`menu_option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_item_option_values`
--

CREATE TABLE `[[dbprefix]]menu_item_option_values` (
  `menu_option_value_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `menu_option_id` int(11) NOT NULL,
  `option_value_id` int(11) NOT NULL,
  `new_price` decimal(15,4) DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`menu_option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_mealtimes`
--

CREATE TABLE `[[dbprefix]]menu_mealtimes` (
  `menu_id` int(10) unsigned NOT NULL,
  `mealtime_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `[[dbprefix]]menu_mealtimes_menu_id_mealtime_id_unique` (`menu_id`,`mealtime_id`),
  KEY `[[dbprefix]]menu_mealtimes_menu_id_index` (`menu_id`),
  KEY `[[dbprefix]]menu_mealtimes_mealtime_id_index` (`mealtime_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_options`
--

CREATE TABLE `[[dbprefix]]menu_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  `update_related_menu_item` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]menu_option_values`
--

CREATE TABLE `[[dbprefix]]menu_option_values` (
  `option_value_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_id` int(11) NOT NULL,
  `value` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(15,4) DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`option_value_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]migrations`
--

CREATE TABLE `[[dbprefix]]migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `migration` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=76 ;

--
-- Dumping data for table `[[dbprefix]]migrations`
--

INSERT INTO `[[dbprefix]]migrations` VALUES
(1, 'System', '2015_03_25_000001_create_tables', 1),
(2, 'System', '2016_11_29_000300_optimize_tables_columns', 1),
(3, 'System', '2017_04_13_000300_modify_columns_on_users_and_customers_tables', 1),
(4, 'System', '2017_05_08_000300_add_columns', 1),
(5, 'System', '2017_06_11_000300_create_payments_and_payment_logs_table', 1),
(6, 'System', '2017_08_23_000300_create_themes_table', 1),
(7, 'System', '2018_01_23_000300_create_language_translations_table', 1),
(8, 'System', '2018_03_30_000300_create_extension_settings_table', 1),
(9, 'System', '2018_06_12_000300_rename_model_class_names_to_morph_map_custom_names', 1),
(10, 'System', '2018_10_19_000300_create_media_attachments_table', 1),
(11, 'System', '2018_10_21_131033_create_queue_table', 1),
(12, 'System', '2018_10_21_131044_create_sessions_table', 1),
(13, 'System', '2019_04_16_000300_nullify_customer_id_on_addresses_table', 1),
(14, 'System', '2019_07_01_000300_delete_unused_columns_from_activities_table', 1),
(15, 'System', '2019_07_22_000300_add_user_type_column_to_activities_table', 1),
(16, 'System', '2019_07_30_000300_create_mail_partials_table', 1),
(17, 'System', '2020_02_05_000300_delete_stale_unused_table', 1),
(18, 'System', '2020_04_16_000300_drop_stale_unused_columns', 1),
(19, 'System', '2020_05_24_000300_create_request_logs_table', 1),
(20, 'System', '2021_07_20_000300_add_uuid_column_to_failed_jobs_table', 1),
(21, 'System', '2021_07_20_172212_create_job_batches_table', 1),
(22, 'System', '2021_07_20_172321_create_cache_table', 1),
(23, 'System', '2021_09_06_010000_add_timestamps_to_tables', 1),
(24, 'System', '2021_10_22_010000_make_primary_key_bigint_all_tables', 1),
(25, 'System', '2021_10_25_010000_add_foreign_key_constraints_to_tables', 1),
(26, 'System', '2022_04_20_000300_add_version_column_to_languages_table', 1),
(27, 'System', '2022_06_30_010000_drop_foreign_key_constraints_on_all_tables', 1),
(28, 'Admin', '2017_08_25_000300_create_location_areas_table', 1),
(29, 'Admin', '2017_08_25_000300_create_menu_categories_table', 1),
(30, 'Admin', '2018_01_19_000300_add_hash_columns_on_orders_reservations_table', 1),
(31, 'Admin', '2018_04_06_000300_drop_unique_on_order_totals_table', 1),
(32, 'Admin', '2018_04_12_000300_modify_columns_on_orders_reservations_table', 1),
(33, 'Admin', '2018_05_21_000300_drop_redundant_columns_on_kitchen_tables', 1),
(34, 'Admin', '2018_05_29_000300_add_columns_on_location_areas_table', 1),
(35, 'Admin', '2018_06_12_000300_create_locationables_table', 1),
(36, 'Admin', '2018_07_04_000300_create_user_preferences_table', 1),
(37, 'Admin', '2018_10_09_000300_auto_increment_on_order_totals_table', 1),
(38, 'Admin', '2019_04_09_000300_auto_increment_on_user_preferences_table', 1),
(39, 'Admin', '2019_07_02_000300_add_columns_on_menu_specials_table', 1),
(40, 'Admin', '2019_07_16_000300_create_reservation_tables_table', 1),
(41, 'Admin', '2019_07_21_000300_change_sort_value_ratings_to_config_on_settings_table', 1),
(42, 'Admin', '2019_11_08_000300_add_selected_columns_to_menu_options_table', 1),
(43, 'Admin', '2020_02_18_000400_create_staffs_groups_and_locations_table', 1),
(44, 'Admin', '2020_02_21_000400_create_staff_roles_table', 1),
(45, 'Admin', '2020_02_22_000300_remove_add_columns_on_staff_staff_groups_table', 1),
(46, 'Admin', '2020_02_25_000300_create_assignable_logs_table', 1),
(47, 'Admin', '2020_03_18_000300_add_quantity_column_to_order_menu_options_table', 1),
(48, 'Admin', '2020_04_05_000300_create_payment_profiles_table', 1),
(49, 'Admin', '2020_04_16_000300_drop_stale_unused_columns', 1),
(50, 'Admin', '2020_05_31_000300_drop_more_unused_columns', 1),
(51, 'Admin', '2020_06_11_000300_create_menu_mealtimes_table', 1),
(52, 'Admin', '2020_08_16_000300_modify_columns_on_tables_reservations_table', 1),
(53, 'Admin', '2020_08_18_000300_create_allergens_table', 1),
(54, 'Admin', '2020_09_28_000300_add_refund_columns_to_payment_logs_table', 1),
(55, 'Admin', '2020_12_13_000300_merge_staffs_locations_into_locationables_table', 1),
(56, 'Admin', '2020_12_22_000300_add_priority_column_to_location_areas_table', 1),
(57, 'Admin', '2021_01_04_000300_add_update_related_column_to_menu_options_table', 1),
(58, 'Admin', '2021_01_04_010000_add_order_time_is_asap_on_orders_table', 1),
(59, 'Admin', '2021_04_23_010000_remove_unused_columns', 1),
(60, 'Admin', '2021_05_26_010000_alter_order_type_columns', 1),
(61, 'Admin', '2021_05_29_010000_add_is_summable_on_order_totals_table', 1),
(62, 'Admin', '2021_07_20_010000_add_columns_default_value', 1),
(63, 'Admin', '2021_09_03_010000_make_serialize_columns_json', 1),
(64, 'Admin', '2021_09_06_010000_add_timestamps_to_tables', 1),
(65, 'Admin', '2021_10_22_010000_make_primary_key_bigint_all_tables', 1),
(66, 'Admin', '2021_10_25_010000_add_foreign_key_constraints_to_tables', 1),
(67, 'Admin', '2021_11_28_000300_create_stocks_table', 1),
(68, 'Admin', '2022_02_07_010000_add_low_stock_alerted_on_stocks_table', 1),
(69, 'Admin', '2022_04_27_000300_create_location_options_table', 1),
(70, 'Admin', '2022_05_10_000300_add_primary_key_to_working_hours_table', 1),
(71, 'Admin', '2022_06_30_010000_drop_foreign_key_constraints_on_all_tables', 1),
(72, 'Admin', '2022_09_03_000300_make_location_options_fields_unique', 1),
(73, 'Admin', '2022_10_26_000300_make_code_field_unique_mail_layouts_partials_table', 1),
(74, 'Admin', '2023_01_10_000400_add_delivery_comment_orders_table', 1),
(75, 'Admin', '2023_06_06_000400_update_dashboard_widget_properties_on_user_preferences_table', 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]orders`
--

CREATE TABLE `[[dbprefix]]orders` (
  `order_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `first_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_id` int(11) NOT NULL,
  `address_id` int(11) DEFAULT NULL,
  `cart` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_items` int(11) NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `payment` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `order_time` time NOT NULL,
  `order_date` date NOT NULL,
  `order_total` decimal(15,4) DEFAULT NULL,
  `status_id` int(11) NOT NULL,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `assignee_id` int(11) DEFAULT NULL,
  `assignee_group_id` int(10) unsigned DEFAULT NULL,
  `invoice_prefix` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_date` datetime DEFAULT NULL,
  `hash` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `processed` tinyint(1) DEFAULT NULL,
  `status_updated_at` datetime DEFAULT NULL,
  `assignee_updated_at` datetime DEFAULT NULL,
  `order_time_is_asap` tinyint(1) NOT NULL DEFAULT '0',
  `delivery_comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`order_id`),
  KEY `[[dbprefix]]orders_hash_index` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_menus`
--

CREATE TABLE `[[dbprefix]]order_menus` (
  `order_menu_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(15,4) DEFAULT NULL,
  `subtotal` decimal(15,4) DEFAULT NULL,
  `option_values` text COLLATE utf8mb4_unicode_ci,
  `comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`order_menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_menu_options`
--

CREATE TABLE `[[dbprefix]]order_menu_options` (
  `order_option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `order_option_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_option_price` decimal(15,4) DEFAULT NULL,
  `order_menu_id` int(11) NOT NULL,
  `order_menu_option_id` int(11) NOT NULL,
  `menu_option_value_id` int(11) NOT NULL,
  `quantity` int(11) DEFAULT '1',
  PRIMARY KEY (`order_option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]order_totals`
--

CREATE TABLE `[[dbprefix]]order_totals` (
  `order_total_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(15,4) NOT NULL,
  `priority` tinyint(1) NOT NULL DEFAULT '0',
  `is_summable` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_total_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]pages`
--

CREATE TABLE `[[dbprefix]]pages` (
  `page_id` int(11) NOT NULL AUTO_INCREMENT,
  `language_id` int(11) NOT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `heading` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_description` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_keywords` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `layout_id` int(11) DEFAULT NULL,
  `navigation` text COLLATE utf8mb4_unicode_ci,
  `date_added` datetime NOT NULL,
  `date_updated` datetime NOT NULL,
  `status` tinyint(1) NOT NULL,
  `permalink_slug` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payments`
--

CREATE TABLE `[[dbprefix]]payments` (
  `payment_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `class_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `data` json DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`payment_id`),
  UNIQUE KEY `[[dbprefix]]payments_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_logs`
--

CREATE TABLE `[[dbprefix]]payment_logs` (
  `payment_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `payment_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` text COLLATE utf8mb4_unicode_ci,
  `response` text COLLATE utf8mb4_unicode_ci,
  `is_success` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `payment_code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_refundable` tinyint(1) NOT NULL DEFAULT '0',
  `refunded_at` datetime DEFAULT NULL,
  PRIMARY KEY (`payment_log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]payment_profiles`
--

CREATE TABLE `[[dbprefix]]payment_profiles` (
  `payment_profile_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `payment_id` int(10) unsigned DEFAULT NULL,
  `card_brand` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_last4` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `profile_data` text COLLATE utf8mb4_unicode_ci,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`payment_profile_id`),
  KEY `[[dbprefix]]payment_profiles_customer_id_index` (`customer_id`),
  KEY `[[dbprefix]]payment_profiles_payment_id_index` (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]request_logs`
--

CREATE TABLE `[[dbprefix]]request_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status_code` int(11) DEFAULT NULL,
  `referrer` text COLLATE utf8mb4_unicode_ci,
  `count` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reservations`
--

CREATE TABLE `[[dbprefix]]reservations` (
  `reservation_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` int(11) NOT NULL,
  `table_id` int(11) NOT NULL,
  `guest_num` int(11) NOT NULL,
  `occasion_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `first_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telephone` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `reserve_time` time NOT NULL,
  `reserve_date` date NOT NULL,
  `created_at` date NOT NULL,
  `updated_at` date NOT NULL,
  `assignee_id` int(11) DEFAULT NULL,
  `assignee_group_id` int(10) unsigned DEFAULT NULL,
  `notify` tinyint(1) DEFAULT NULL,
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_id` tinyint(1) NOT NULL,
  `hash` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `processed` tinyint(1) DEFAULT NULL,
  `status_updated_at` datetime DEFAULT NULL,
  `assignee_updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`reservation_id`),
  KEY `[[dbprefix]]reservations_location_id_table_id_index` (`location_id`,`table_id`),
  KEY `[[dbprefix]]reservations_hash_index` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]reservation_tables`
--

CREATE TABLE `[[dbprefix]]reservation_tables` (
  `reservation_id` int(10) unsigned NOT NULL,
  `table_id` int(10) unsigned NOT NULL,
  UNIQUE KEY `[[dbprefix]]reservation_tables_reservation_id_table_id_unique` (`reservation_id`,`table_id`),
  KEY `[[dbprefix]]reservation_tables_reservation_id_index` (`reservation_id`),
  KEY `[[dbprefix]]reservation_tables_table_id_index` (`table_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sessions`
--

CREATE TABLE `[[dbprefix]]sessions` (
  `id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci,
  `last_activity` int(11) DEFAULT NULL,
  UNIQUE KEY `[[dbprefix]]sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]settings`
--

CREATE TABLE `[[dbprefix]]settings` (
  `setting_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sort` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `serialized` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`setting_id`),
  UNIQUE KEY `[[dbprefix]]settings_sort_item_unique` (`sort`,`item`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=71 ;

--
-- Dumping data for table `[[dbprefix]]settings`
--

INSERT INTO `[[dbprefix]]settings` VALUES
(1, 'prefs', 'default_location_id', '1', NULL),
(2, 'config', 'site_logo', 'no_photo.png', NULL),
(3, 'config', 'country_id', '222', NULL),
(4, 'config', 'timezone', 'Europe/London', NULL),
(5, 'config', 'default_currency_code', 'GBP', NULL),
(6, 'config', 'default_language', 'en', NULL),
(7, 'config', 'detect_language', '0', NULL),
(9, 'config', 'allow_registration', '1', NULL),
(10, 'config', 'customer_group_id', '1', NULL),
(14, 'config', 'maps_api_key', '', NULL),
(15, 'config', 'distance_unit', 'mi', NULL),
(16, 'config', 'location_order', '0', NULL),
(17, 'config', 'location_order_email', '0', NULL),
(18, 'config', 'location_reserve_email', '0', NULL),
(19, 'config', 'default_order_status', '1', NULL),
(22, 'config', 'menus_page', 'local/menus', NULL),
(23, 'config', 'reservation_page', 'reservation/reservation', NULL),
(24, 'config', 'guest_order', '1', NULL),
(25, 'config', 'default_reservation_status', '8', NULL),
(26, 'config', 'confirmed_reservation_status', '6', NULL),
(27, 'config', 'canceled_order_status', '9', NULL),
(28, 'config', 'canceled_reservation_status', '7', NULL),
(30, 'config', 'tax_mode', '0', NULL),
(31, 'config', 'invoice_prefix', 'INV-{year}-00', NULL),
(32, 'config', 'protocol', 'log', NULL),
(33, 'config', 'smtp_host', 'smtp.mailgun.org', NULL),
(34, 'config', 'smtp_port', '587', NULL),
(35, 'config', 'smtp_user', '', NULL),
(36, 'config', 'smtp_pass', '', NULL),
(37, 'config', 'log_threshold', '1', NULL),
(38, 'config', 'permalink', '1', NULL),
(39, 'config', 'maintenance_mode', '0', NULL),
(40, 'config', 'maintenance_message', 'Site is under maintenance. Please check back later.', NULL),
(41, 'config', 'cache_mode', '0', NULL),
(42, 'config', 'cache_time', '0', NULL),
(43, 'prefs', 'default_themes', 'a:1:{s:4:"main";s:19:"demo";}', NULL),
(44, 'prefs', 'ti_setup', 'installed', NULL),
(45, 'config', 'supported_languages.0', 'en', NULL),
(46, 'config', 'registration_email.0', 'customer', NULL),
(47, 'config', 'order_email.0', 'customer', NULL),
(48, 'config', 'order_email.1', 'admin', NULL),
(49, 'config', 'reservation_email.0', 'customer', NULL),
(50, 'config', 'reservation_email.1', 'admin', NULL),
(51, 'config', 'processing_order_status.0', '2', NULL),
(52, 'config', 'processing_order_status.1', '3', NULL),
(53, 'config', 'processing_order_status.2', '4', NULL),
(54, 'config', 'completed_order_status.0', '5', NULL),
(55, 'config', 'image_manager.max_size', '300', NULL),
(56, 'config', 'image_manager.thumb_width', '320', NULL),
(57, 'config', 'image_manager.thumb_height', '220', NULL),
(58, 'config', 'image_manager.uploads', '1', NULL),
(59, 'config', 'image_manager.new_folder', '1', NULL),
(60, 'config', 'image_manager.copy', '1', NULL),
(61, 'config', 'image_manager.move', '1', NULL),
(62, 'config', 'image_manager.rename', '1', NULL),
(63, 'config', 'image_manager.delete', '1', NULL),
(64, 'config', 'image_manager.transliteration', '0', NULL),
(65, 'config', 'image_manager.remember_days', '7', NULL),
(66, 'config', 'site_name', '[[site_name]]', NULL),
(67, 'config', 'site_email', '[[admin_email]]', NULL),
(68, 'config', 'sender_name', '[[site_name]]', NULL),
(69, 'config', 'sender_email', '[[admin_email]]', NULL),
(70, 'prefs', 'ti_version', 'v3.7.7', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]staffs`
--

CREATE TABLE `[[dbprefix]]staffs` (
  `staff_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `staff_email` varchar(96) COLLATE utf8mb4_unicode_ci NOT NULL,
  `staff_role_id` int(11) NOT NULL,
  `language_id` int(11) DEFAULT NULL,
  `created_at` date NOT NULL,
  `staff_status` tinyint(1) NOT NULL,
  `sale_permission` tinyint(4) DEFAULT '1',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`staff_id`),
  UNIQUE KEY `staff_email` (`staff_email`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]staffs`
--

INSERT INTO `[[dbprefix]]staffs` VALUES
(1, '[[admin_realname]]', '[[admin_email]]', 1, 1, '[[regdate]]', 1, 1, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]staffs_groups`
--

CREATE TABLE `[[dbprefix]]staffs_groups` (
  `staff_id` int(10) unsigned NOT NULL,
  `staff_group_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`staff_id`,`staff_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `[[dbprefix]]staffs_groups`
--

INSERT INTO `[[dbprefix]]staffs_groups` VALUES
(1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]staff_groups`
--

CREATE TABLE `[[dbprefix]]staff_groups` (
  `staff_group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_group_name` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `auto_assign` tinyint(1) DEFAULT '0',
  `auto_assign_mode` tinyint(4) DEFAULT '1',
  `auto_assign_limit` int(11) DEFAULT '20',
  `auto_assign_availability` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`staff_group_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]staff_groups`
--

INSERT INTO `[[dbprefix]]staff_groups` VALUES
(1, 'Owners', 'Default group for owners', 0, 1, 20, 1, '[[regtime]]', '[[regtime]]'),
(2, 'Managers', 'Default group for managers', 0, 1, 20, 1, '[[regtime]]', '[[regtime]]'),
(3, 'Waiters', 'Default group for waiters.', 0, 1, 20, 1, '[[regtime]]', '[[regtime]]'),
(4, 'Delivery', 'Default group for delivery drivers.', 0, 1, 20, 1, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]staff_roles`
--

CREATE TABLE `[[dbprefix]]staff_roles` (
  `staff_role_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`staff_role_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]staff_roles`
--

INSERT INTO `[[dbprefix]]staff_roles` VALUES
(1, 'Owner', 'owner', 'Default role for restaurant owners', NULL, '[[regtime]]', '[[regtime]]'),
(2, 'Manager', 'manager', 'Default role for restaurant managers.', 'a:16:{s:15:"Admin.Dashboard";s:1:"1";s:16:"Admin.Categories";s:1:"1";s:14:"Admin.Statuses";s:1:"1";s:12:"Admin.Staffs";s:1:"1";s:17:"Admin.StaffGroups";s:1:"1";s:15:"Admin.Customers";s:1:"1";s:20:"Admin.CustomerGroups";s:1:"1";s:14:"Admin.Payments";s:1:"1";s:18:"Admin.Reservations";s:1:"1";s:12:"Admin.Orders";s:1:"1";s:12:"Admin.Tables";s:1:"1";s:15:"Admin.Locations";s:1:"1";s:15:"Admin.Mealtimes";s:1:"1";s:11:"Admin.Menus";s:1:"1";s:11:"Site.Themes";s:1:"1";s:18:"Admin.MediaManager";s:1:"1";}', '[[regtime]]', '[[regtime]]'),
(3, 'Waiter', 'waiter', 'Default role for restaurant waiters.', 'a:4:{s:16:"Admin.Categories";s:1:"1";s:18:"Admin.Reservations";s:1:"1";s:12:"Admin.Orders";s:1:"1";s:11:"Admin.Menus";s:1:"1";}', '[[regtime]]', '[[regtime]]'),
(4, 'Delivery', 'delivery', 'Default role for restaurant delivery.', 'a:3:{s:14:"Admin.Statuses";s:1:"1";s:18:"Admin.Reservations";s:1:"1";s:12:"Admin.Orders";s:1:"1";}', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]statuses`
--

CREATE TABLE `[[dbprefix]]statuses` (
  `status_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_comment` text COLLATE utf8mb4_unicode_ci,
  `notify_customer` tinyint(1) DEFAULT NULL,
  `status_for` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status_color` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=10 ;

--
-- Dumping data for table `[[dbprefix]]statuses`
--

INSERT INTO `[[dbprefix]]statuses` VALUES
(1, 'Received', 'Your order has been received.', 1, 'order', '#686663', '[[regtime]]', '[[regtime]]'),
(2, 'Pending', 'Your order is pending', 1, 'order', '#f0ad4e', '[[regtime]]', '[[regtime]]'),
(3, 'Preparation', 'Your order is in the kitchen', 1, 'order', '#00c0ef', '[[regtime]]', '[[regtime]]'),
(4, 'Delivery', 'Your order will be with you shortly.', 0, 'order', '#00a65a', '[[regtime]]', '[[regtime]]'),
(5, 'Completed', '', 0, 'order', '#00a65a', '[[regtime]]', '[[regtime]]'),
(6, 'Confirmed', 'Your table reservation has been confirmed.', 0, 'reserve', '#00a65a', '[[regtime]]', '[[regtime]]'),
(7, 'Canceled', 'Your table reservation has been canceled.', 0, 'reserve', '#dd4b39', '[[regtime]]', '[[regtime]]'),
(8, 'Pending', 'Your table reservation is pending.', 0, 'reserve', '', '[[regtime]]', '[[regtime]]'),
(9, 'Canceled', '', 0, 'order', '#ea0b29', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]status_history`
--

CREATE TABLE `[[dbprefix]]status_history` (
  `status_history_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL,
  `object_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `status_id` int(11) NOT NULL,
  `notify` tinyint(1) DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `created_at` datetime NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`status_history_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stocks`
--

CREATE TABLE `[[dbprefix]]stocks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_id` bigint(20) unsigned NOT NULL,
  `stockable_id` bigint(20) unsigned NOT NULL,
  `stockable_type` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` bigint(20) DEFAULT NULL,
  `low_stock_alert` tinyint(1) NOT NULL DEFAULT '0',
  `low_stock_threshold` int(11) NOT NULL DEFAULT '0',
  `is_tracked` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `low_stock_alert_sent` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]stock_history`
--

CREATE TABLE `[[dbprefix]]stock_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `stock_id` bigint(20) unsigned NOT NULL,
  `staff_id` bigint(20) unsigned DEFAULT NULL,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `state` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` bigint(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]stock_history_stock_id_foreign` (`stock_id`),
  KEY `[[dbprefix]]stock_history_order_id_foreign` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]tables`
--

CREATE TABLE `[[dbprefix]]tables` (
  `table_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `table_name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `min_capacity` int(11) NOT NULL,
  `max_capacity` int(11) NOT NULL,
  `table_status` tinyint(1) NOT NULL,
  `extra_capacity` int(11) NOT NULL DEFAULT '0',
  `is_joinable` tinyint(1) NOT NULL DEFAULT '1',
  `priority` int(11) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`table_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]tables`
--

INSERT INTO `[[dbprefix]]tables` VALUES
(1, 'Table 1', 3, 10, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(2, 'Table 2', 4, 6, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(3, 'Table 3', 4, 10, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(4, 'Table 4', 2, 8, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(5, 'Table 5', 3, 11, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(6, 'Table 6', 5, 8, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(7, 'Table 7', 4, 9, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(8, 'Table 8', 4, 6, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(9, 'Table 9', 3, 9, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(10, 'Table 10', 2, 9, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(11, 'Table 11', 3, 11, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(12, 'Table 12', 2, 7, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(13, 'Table 13', 3, 9, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]'),
(14, 'Table 14', 5, 8, 1, 0, 1, 0, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]themes`
--

CREATE TABLE `[[dbprefix]]themes` (
  `theme_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `version` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT '0.0.1',
  `data` json DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`theme_id`),
  UNIQUE KEY `[[dbprefix]]themes_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]users`
--

CREATE TABLE `[[dbprefix]]users` (
  `user_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `username` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `super_user` tinyint(1) DEFAULT NULL,
  `reset_code` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reset_time` datetime DEFAULT NULL,
  `activation_code` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_activated` tinyint(1) DEFAULT NULL,
  `date_activated` datetime DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `last_seen` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `[[dbprefix]]users_staff_id_unique` (`staff_id`),
  UNIQUE KEY `[[dbprefix]]users_username_unique` (`username`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]users`
--

INSERT INTO `[[dbprefix]]users` VALUES
(1, 1, '[[admin_username]]', '[[admin_pass]]', 1, NULL, NULL, NULL, NULL, 1, '[[regtime]]', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_preferences`
--

CREATE TABLE `[[dbprefix]]user_preferences` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `item` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]working_hours`
--

CREATE TABLE `[[dbprefix]]working_hours` (
  `location_id` int(11) NOT NULL,
  `weekday` int(11) NOT NULL,
  `opening_time` time NOT NULL DEFAULT '00:00:00',
  `closing_time` time NOT NULL DEFAULT '00:00:00',
  `status` tinyint(1) NOT NULL,
  `type` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `[[dbprefix]]working_hours_location_id_weekday_type_index` (`location_id`,`weekday`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `[[dbprefix]]stock_history`
--
ALTER TABLE `[[dbprefix]]stock_history`
  ADD CONSTRAINT `[[dbprefix]]stock_history_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `[[dbprefix]]orders` (`order_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `[[dbprefix]]stock_history_stock_id_foreign` FOREIGN KEY (`stock_id`) REFERENCES `[[dbprefix]]stocks` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
