SET FOREIGN_KEY_CHECKS = 0;

UPDATE `config` SET `value`='2.1.0-alpha1' WHERE `name`='thelia_version';
UPDATE `config` SET `value`='1' WHERE `name`='thelia_minus_version';
UPDATE `config` SET `value`='0' WHERE `name`='thelia_release_version';
UPDATE `config` SET `value`='alpha1' WHERE `name`='thelia_extra_version';


# ======================================================================================================================
# Add sale related tables
# ======================================================================================================================

-- ---------------------------------------------------------------------
-- sale
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `sale`;

CREATE TABLE `sale`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `active` TINYINT(1) DEFAULT 0 NOT NULL,
    `display_initial_price` TINYINT(1) DEFAULT 1 NOT NULL,
    `start_date` DATETIME,
    `end_date` DATETIME,
    `price_offset_type` TINYINT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `idx_sales_active_start_end_date` (`active`, `start_date`, `end_date`),
    INDEX `idx_sales_active` (`active`)
) ENGINE=InnoDB CHARACTER SET='utf8';

-- ---------------------------------------------------------------------
-- sale_i18n
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `sale_i18n`;

CREATE TABLE `sale_i18n`
(
    `id` INTEGER NOT NULL,
    `locale` VARCHAR(5) DEFAULT 'en_US' NOT NULL,
    `title` VARCHAR(255),
    `description` LONGTEXT,
    `chapo` TEXT,
    `postscriptum` TEXT,
    `sale_label` VARCHAR(255),
    PRIMARY KEY (`id`,`locale`),
    CONSTRAINT `sale_i18n_FK_1`
        FOREIGN KEY (`id`)
        REFERENCES `sale` (`id`)
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

-- ---------------------------------------------------------------------
-- sale_offset_currency
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `sale_offset_currency`;

CREATE TABLE `sale_offset_currency`
(
    `sale_id` INTEGER NOT NULL,
    `currency_id` INTEGER NOT NULL,
    `price_offset_value` FLOAT DEFAULT 0,
    PRIMARY KEY (`sale_id`,`currency_id`),
    INDEX `fk_sale_offset_currency_currency1_idx` (`currency_id`),
    CONSTRAINT `fk_sale_offset_currency_sales_id`
        FOREIGN KEY (`sale_id`)
        REFERENCES `sale` (`id`)
        ON DELETE CASCADE,
    CONSTRAINT `fk_sale_offset_currency_currency_id`
        FOREIGN KEY (`currency_id`)
        REFERENCES `currency` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

-- ---------------------------------------------------------------------
-- sale_product
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `sale_product`;

CREATE TABLE `sale_product`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `sale_id` INTEGER NOT NULL,
    `product_id` INTEGER NOT NULL,
    `attribute_av_id` INTEGER,
    PRIMARY KEY (`id`),
    INDEX `fk_sale_product_product_idx` (`product_id`),
    INDEX `fk_sale_product_attribute_av_idx` (`attribute_av_id`),
    INDEX `idx_sale_product_sales_id_product_id` (`sale_id`, `product_id`),
    CONSTRAINT `fk_sale_product_sales_id`
        FOREIGN KEY (`sale_id`)
        REFERENCES `sale` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE,
    CONSTRAINT `fk_sale_product_product_id`
        FOREIGN KEY (`product_id`)
        REFERENCES `product` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE,
    CONSTRAINT `fk_sale_product_attribute_av_id`
        FOREIGN KEY (`attribute_av_id`)
        REFERENCES `attribute_av` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';


# ======================================================================================================================
# Product sale elements images and documents
# ======================================================================================================================

-- ---------------------------------------------------------------------
-- product_sale_elements_product_image
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `product_sale_elements_product_image`;

CREATE TABLE `product_sale_elements_product_image`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `product_sale_elements_id` INTEGER NOT NULL,
    `product_image_id` INTEGER NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `fk_pse_product_image_product_image_id_idx` (`product_image_id`),
    INDEX `fk_pse_product_image_product_sale_element_idx` (`product_sale_elements_id`),
    CONSTRAINT `fk_pse_product_image_product_sale_elements_id`
        FOREIGN KEY (`product_sale_elements_id`)
        REFERENCES `product_sale_elements` (`id`),
    CONSTRAINT `fk_pse_product_image_product_image_id`
        FOREIGN KEY (`product_image_id`)
        REFERENCES `product_image` (`id`)
) ENGINE=InnoDB CHARACTER SET='utf8';

-- ---------------------------------------------------------------------
-- product_sale_elements_product_document
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `product_sale_elements_product_document`;

CREATE TABLE `product_sale_elements_product_document`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `product_sale_elements_id` INTEGER NOT NULL,
    `product_document_id` INTEGER NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `fk_pse_product_document_product_document__idx` (`product_document_id`),
    INDEX `fk_pse_product_document_product_sale_elem_idx` (`product_sale_elements_id`),
    CONSTRAINT `fk_pse_product_document_product_sale_elements_id`
        FOREIGN KEY (`product_sale_elements_id`)
        REFERENCES `product_sale_elements` (`id`),
    CONSTRAINT `fk_pse_product_document_product_document_id`
        FOREIGN KEY (`product_document_id`)
        REFERENCES `product_document` (`id`)
) ENGINE=InnoDB CHARACTER SET='utf8';


# ======================================================================================================================
# Hooks
# ======================================================================================================================

SELECT @max_pos := IFNULL(MAX(`position`),0) FROM `module`;
SELECT @max_id := IFNULL(MAX(`id`),0) FROM `module`;

INSERT INTO `module` (`id`, `code`, `type`, `activate`, `position`, `full_namespace`, `created_at`, `updated_at`) VALUES
  (@max_id+1, 'HookNavigation', 1, 1, @max_pos+1, 'HookNavigation\\HookNavigation', NOW(), NOW()),
  (@max_id+2, 'HookCurrency', 1, 1, @max_pos+2, 'HookCurrency\\HookCurrency', NOW(), NOW()),
  (@max_id+3, 'HookLang', 1, 1, @max_pos+3, 'HookLang\\HookLang', NOW(), NOW()),
  (@max_id+4, 'HookSearch', 1, 1, @max_pos+4, 'HookSearch\\HookSearch', NOW(), NOW()),
  (@max_id+5, 'HookCustomer', 1, 1, @max_pos+5, 'HookCustomer\\HookCustomer', NOW(), NOW()),
  (@max_id+6, 'HookCart', 1, 1, @max_pos+6, 'HookCart\\HookCart', NOW(), NOW()),
  (@max_id+7, 'HookAnalytics', 1, 1, @max_pos+7, 'HookAnalytics\\HookAnalytics', NOW(), NOW()),
  (@max_id+8, 'HookContact', 1, 1, @max_pos+8, 'HookContact\\HookContact', NOW(), NOW()),
  (@max_id+9, 'HookLinks', 1, 1, @max_pos+9, 'HookLinks\\HookLinks', NOW(), NOW()),
  (@max_id+10, 'HookNewsletter', 1, 1, @max_pos+10, 'HookNewsletter\\HookNewsletter', NOW(), NOW()),
  (@max_id+11, 'HookSocial', 1, 1, @max_pos+11, 'HookSocial\\HookSocial', NOW(), NOW()),
  (@max_id+12, 'HookProductsNew', 1, 1, @max_pos+12, 'HookProductsNew\\HookProductsNew', NOW(), NOW()),
  (@max_id+13, 'HookProductsOffer', 1, 1, @max_pos+13, 'HookProductsOffer\\HookProductsOffer', NOW(), NOW())
;

INSERT INTO  `module_i18n` (`id`, `locale`, `title`, `description`, `chapo`, `postscriptum`) VALUES
  (@max_id+1, 'de_DE', 'Menü Block', NULL,  NULL,  NULL),
  (@max_id+2, 'de_DE', 'Währungensblock', NULL,  NULL,  NULL),
  (@max_id+3, 'de_DE', 'Sprachen Block', NULL,  NULL,  NULL),
  (@max_id+4, 'de_DE', 'Suche-Block', NULL,  NULL,  NULL),
  (@max_id+5, 'de_DE', 'Kundenkonto-Block', NULL,  NULL,  NULL),
  (@max_id+6, 'de_DE', 'Warenkorb Block', NULL,  NULL,  NULL),
  (@max_id+7, 'de_DE', 'Google Analytics Block', NULL,  NULL,  NULL),
  (@max_id+8, 'de_DE', 'Kontakt-Block', NULL,  NULL,  NULL),
  (@max_id+9, 'de_DE', 'Links Block', NULL,  NULL,  NULL),
  (@max_id+10, 'de_DE', 'Newsletter Block', NULL,  NULL,  NULL),
  (@max_id+11, 'de_DE', 'Social Networks Block', NULL,  NULL,  NULL),
  (@max_id+12, 'de_DE', 'Neue Produkte Block', NULL,  NULL,  NULL),
  (@max_id+13, 'de_DE', 'Sonderangebot-Block', NULL,  NULL,  NULL),
  (@max_id+1, 'en_US', 'Navigation block', NULL,  NULL,  NULL),
  (@max_id+2, 'en_US', 'Currency block', NULL,  NULL,  NULL),
  (@max_id+3, 'en_US', 'Languages block', NULL,  NULL,  NULL),
  (@max_id+4, 'en_US', 'Search block', NULL,  NULL,  NULL),
  (@max_id+5, 'en_US', 'Customer account block', NULL,  NULL,  NULL),
  (@max_id+6, 'en_US', 'Cart block', NULL,  NULL,  NULL),
  (@max_id+7, 'en_US', 'Google Analytics block', NULL,  NULL,  NULL),
  (@max_id+8, 'en_US', 'Contact block', NULL,  NULL,  NULL),
  (@max_id+9, 'en_US', 'Links block', NULL,  NULL,  NULL),
  (@max_id+10, 'en_US', 'Newsletter block', NULL,  NULL,  NULL),
  (@max_id+11, 'en_US', 'Social Networks block', NULL,  NULL,  NULL),
  (@max_id+12, 'en_US', 'New Products block', NULL,  NULL,  NULL),
  (@max_id+13, 'en_US', 'Products offer block', NULL,  NULL,  NULL),
  (@max_id+1, 'es_ES', 'Bloque de navegación', NULL,  NULL,  NULL),
  (@max_id+2, 'es_ES', 'Bloque de monedas', NULL,  NULL,  NULL),
  (@max_id+3, 'es_ES', 'Bloque de idiomas', NULL,  NULL,  NULL),
  (@max_id+4, 'es_ES', 'Bloque de búsqueda', NULL,  NULL,  NULL),
  (@max_id+5, 'es_ES', 'Bloque de cuenta de cliente', NULL,  NULL,  NULL),
  (@max_id+6, 'es_ES', 'Bloque de carrito', NULL,  NULL,  NULL),
  (@max_id+7, 'es_ES', 'Bloque Google Analytics', NULL,  NULL,  NULL),
  (@max_id+8, 'es_ES', 'Bloque de contacto', NULL,  NULL,  NULL),
  (@max_id+9, 'es_ES', 'Bloque de enlaces', NULL,  NULL,  NULL),
  (@max_id+10, 'es_ES', 'Bloque del boletín de noticias', NULL,  NULL,  NULL),
  (@max_id+11, 'es_ES', 'Bloque de Redes Sociales', NULL,  NULL,  NULL),
  (@max_id+12, 'es_ES', 'Bloque de nuevos productos', NULL,  NULL,  NULL),
  (@max_id+13, 'es_ES', 'Bloque de oferta de productos', NULL,  NULL,  NULL),
  (@max_id+1, 'fr_FR', 'Bloc menu', NULL,  NULL,  NULL),
  (@max_id+2, 'fr_FR', 'Bloc des devises', NULL,  NULL,  NULL),
  (@max_id+3, 'fr_FR', 'Bloc des langues', NULL,  NULL,  NULL),
  (@max_id+4, 'fr_FR', 'Bloc de recherche', NULL,  NULL,  NULL),
  (@max_id+5, 'fr_FR', 'Bloc compte client', NULL,  NULL,  NULL),
  (@max_id+6, 'fr_FR', 'Bloc panier', NULL,  NULL,  NULL),
  (@max_id+7, 'fr_FR', 'Bloc Google Analytics', NULL,  NULL,  NULL),
  (@max_id+8, 'fr_FR', 'Bloc contact', NULL,  NULL,  NULL),
  (@max_id+9, 'fr_FR', 'Bloc liens', NULL,  NULL,  NULL),
  (@max_id+10, 'fr_FR', 'Bloc newsletter', NULL,  NULL,  NULL),
  (@max_id+11, 'fr_FR', 'Bloc réseaux sociaux', NULL,  NULL,  NULL),
  (@max_id+12, 'fr_FR', 'Bloc nouveaux produits', NULL,  NULL,  NULL),
  (@max_id+13, 'fr_FR', 'Bloc promotions', NULL,  NULL,  NULL)
;



-- ---------------------------------------------------------------------
-- hook
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `hook`;

CREATE TABLE `hook`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `code` VARCHAR(255) NOT NULL,
    `type` TINYINT,
    `by_module` TINYINT(1),
    `native` TINYINT(1),
    `activate` TINYINT(1),
    `block` TINYINT(1),
    `position` INTEGER,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `code_UNIQUE` (`code`, `type`),
    INDEX `idx_module_activate` (`activate`)
) ENGINE=InnoDB CHARACTER SET='utf8';

-- ---------------------------------------------------------------------
-- module_hook
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `module_hook`;

CREATE TABLE `module_hook`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `module_id` INTEGER NOT NULL,
    `hook_id` INTEGER NOT NULL,
    `classname` VARCHAR(255),
    `method` VARCHAR(255),
    `active` TINYINT(1) NOT NULL,
    `hook_active` TINYINT(1) NOT NULL,
    `module_active` TINYINT(1) NOT NULL,
    `position` INTEGER NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `idx_module_hook_active` (`active`),
    INDEX `fk_module_hook_module_id_idx` (`module_id`),
    INDEX `fk_module_hook_hook_id_idx` (`hook_id`),
    CONSTRAINT `fk_module_hook_module_id`
        FOREIGN KEY (`module_id`)
        REFERENCES `module` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE,
    CONSTRAINT `fk_module_hook_hook_id`
        FOREIGN KEY (`hook_id`)
        REFERENCES `hook` (`id`)
        ON UPDATE RESTRICT
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';


-- ---------------------------------------------------------------------
-- hook_i18n
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `hook_i18n`;

CREATE TABLE `hook_i18n`
(
    `id` INTEGER NOT NULL,
    `locale` VARCHAR(5) DEFAULT 'en_US' NOT NULL,
    `title` VARCHAR(255),
    `description` LONGTEXT,
    `chapo` TEXT,
    PRIMARY KEY (`id`,`locale`),
    CONSTRAINT `hook_i18n_FK_1`
        FOREIGN KEY (`id`)
        REFERENCES `hook` (`id`)
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';


INSERT INTO `hook` (`id`, `code`, `type`, `by_module`, `block`, `native`, `activate`, `position`, `created_at`, `updated_at`) VALUES
  (1, 'order-invoice.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2, 'order-invoice.delivery-address', 1, 1, 0, 1, 1, 1, NOW(), NOW()),
  (3, 'order-invoice.payment-extra', 1, 1, 0, 1, 1, 1, NOW(), NOW()),
  (4, 'order-invoice.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (5, 'order-invoice.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (6, 'order-invoice.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (7, 'order-invoice.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (8, 'order-payment-gateway.body', 1, 1, 0, 1, 1, 1, NOW(), NOW()),
  (9, 'order-payment-gateway.javascript', 1, 1, 0, 1, 1, 1, NOW(), NOW()),
  (10, 'order-payment-gateway.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (11, 'order-payment-gateway.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (12, 'order-payment-gateway.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (13, 'sitemap.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (14, 'currency.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (15, 'currency.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (16, 'currency.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (17, 'currency.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (18, 'currency.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (19, 'login.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (20, 'login.main-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (21, 'login.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (22, 'login.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (23, 'login.main-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (24, 'login.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (25, 'login.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (26, 'login.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (27, 'login.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (28, 'account-update.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (29, 'account-update.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (30, 'account-update.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (31, 'account-update.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (32, 'account-update.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (33, 'account-update.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (34, 'account-update.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (35, 'cart.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (36, 'cart.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (37, 'cart.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (38, 'cart.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (39, 'cart.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (40, 'contact.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (41, 'contact.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (42, 'contact.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (43, 'contact.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (44, 'contact.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (45, 'contact.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (46, 'contact.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (47, 'order-placed.body', 1, 1, 0, 1, 1, 1, NOW(), NOW()),
  (48, 'order-placed.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (49, 'order-placed.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (50, 'order-placed.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (51, 'search.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (52, 'search.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (53, 'search.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (54, 'register.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (55, 'register.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (56, 'register.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (57, 'register.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (58, 'register.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (59, 'register.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (60, 'register.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (61, 'password.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (62, 'password.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (63, 'password.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (64, 'password.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (65, 'password.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (66, 'password.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (67, 'password.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (68, 'language.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (69, 'language.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (70, 'language.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (71, 'language.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (72, 'language.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (73, 'contact.success', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (74, 'newsletter.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (75, 'newsletter.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (76, 'newsletter.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (77, 'newsletter.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (78, 'newsletter.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (79, 'badresponseorder.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (80, 'badresponseorder.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (81, 'badresponseorder.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (82, 'content.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (83, 'content.main-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (84, 'content.main-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (85, 'content.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (86, 'content.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (87, 'content.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (88, 'content.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (89, 'main.head-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (90, 'main.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (91, 'main.head-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (92, 'main.body-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (93, 'main.header-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (94, 'main.navbar-secondary', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (95, 'main.navbar-primary', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (96, 'main.header-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (97, 'main.content-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (98, 'main.content-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (99, 'main.footer-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (100, 'main.footer-body', 1, 0, 1, 1, 1, 1, NOW(), NOW()),
  (101, 'main.footer-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (102, 'main.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (103, 'main.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (104, 'main.body-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (105, '404.content', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (106, '404.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (107, '404.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (108, '404.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (109, 'order-delivery.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (110, 'order-delivery.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (111, 'order-delivery.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (112, 'order-delivery.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (113, 'order-delivery.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (114, 'order-delivery.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (115, 'order-delivery.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (116, 'address-create.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (117, 'address-create.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (118, 'address-create.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (119, 'address-create.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (120, 'address-create.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (121, 'address-create.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (122, 'address-create.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (123, 'folder.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (124, 'folder.main-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (125, 'folder.main-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (126, 'folder.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (127, 'folder.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (128, 'folder.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (129, 'folder.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (130, 'order-failed.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (131, 'order-failed.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (132, 'order-failed.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (133, 'order-failed.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (134, 'order-failed.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (135, 'category.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (136, 'category.main-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (137, 'category.main-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (138, 'category.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (139, 'category.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (140, 'category.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (141, 'category.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (142, 'address-update.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (143, 'address-update.form-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (144, 'address-update.form-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (145, 'address-update.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (146, 'address-update.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (147, 'address-update.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (148, 'address-update.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (149, 'home.body', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (150, 'home.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (151, 'home.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (152, 'home.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (153, 'account-password.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (154, 'account-password.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (155, 'account-password.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (156, 'account-password.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (157, 'account-password.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (158, 'product.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (159, 'product.gallery', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (160, 'product.details-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (161, 'product.details-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (162, 'product.additional', 1, 0, 1, 1, 1, 1, NOW(), NOW()),
  (163, 'product.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (164, 'product.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (165, 'product.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (166, 'product.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (167, 'account.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (168, 'account.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (169, 'account.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (170, 'account.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (171, 'account.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (172, 'viewall.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (173, 'viewall.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (174, 'viewall.stylesheet', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (175, 'viewall.after-javascript-include', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (176, 'viewall.javascript-initialization', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (177, 'singleproduct.top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (178, 'singleproduct.bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (179, 'category.sidebar-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (180, 'category.sidebar-body', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (181, 'category.sidebar-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (182, 'content.sidebar-top', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (183, 'content.sidebar-body', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (184, 'content.sidebar-bottom', 1, 0, 0, 1, 1, 1, NOW(), NOW()),
  (185, 'order-delivery.extra', 1, 1, 0, 1, 1, 1, NOW(), NOW()),
  (186, 'order-delivery.javascript', 1, 1, 0, 1, 1, 1, NOW(), NOW()),

  (1000, 'category.tab-content', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1001, 'content.tab-content', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1002, 'folder.tab-content', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1003, 'order.tab-content', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1004, 'product.tab-content', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1005, 'features-value.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1006, 'features-value.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1007, 'feature.value-create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1008, 'feature.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1009, 'product.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1010, 'coupon.create-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1011, 'taxes.update-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1012, 'tax-rule.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1013, 'tools.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1014, 'tools.col1-top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1015, 'tools.col1-bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1016, 'tools.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1017, 'tools.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1018, 'messages.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1019, 'messages.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1020, 'messages.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1021, 'messages.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1022, 'message.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1023, 'message.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1024, 'messages.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1025, 'taxes-rules.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1026, 'taxes-rules.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1027, 'tax.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1028, 'tax.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1029, 'tax-rule.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1030, 'tax-rule.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1031, 'taxes-rules.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1032, 'exports.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1033, 'exports.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1034, 'exports.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1035, 'exports.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1036, 'export.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1037, 'product.folders-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1038, 'product.folders-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1039, 'product.details-pricing-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1040, 'product.details-details-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1041, 'product.details-promotion-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1042, 'product.before-combinations', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1043, 'product.combinations-list-caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1044, 'product.after-combinations', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1045, 'product.combination-delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1046, 'modules.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1047, 'modules.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1048, 'currency.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1049, 'category.contents-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1050, 'category.contents-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1051, 'category.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1052, 'document.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1053, 'customer.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1054, 'customers.caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1055, 'customers.header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1056, 'customers.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1057, 'customer.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1058, 'customer.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1059, 'customer.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1060, 'customers.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1061, 'product.contents-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1062, 'product.contents-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1063, 'product.accessories-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1064, 'product.accessories-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1065, 'product.categories-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1066, 'product.categories-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1067, 'product.attributes-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1068, 'product.attributes-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1069, 'product.features-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1070, 'product.features-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1071, 'template.attributes-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1072, 'template.attributes-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1073, 'template.features-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1074, 'template.features-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1075, 'templates.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1076, 'templates.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1077, 'templates.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1078, 'templates.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1079, 'template.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1080, 'template.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1081, 'templates.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1082, 'configuration.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1083, 'configuration.catalog-top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1084, 'configuration.catalog-bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1085, 'configuration.shipping-top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1086, 'configuration.shipping-bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1087, 'configuration.system-top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1088, 'configuration.system-bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1089, 'configuration.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1090, 'configuration.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1091, 'index.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1092, 'index.middle', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1093, 'index.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1094, 'orders.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1095, 'orders.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1096, 'orders.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1097, 'orders.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1098, 'orders.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1099, 'shipping-zones.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1100, 'shipping-zones.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1101, 'shipping-zones.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1102, 'shipping-zones.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1103, 'shipping-zones.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1104, 'content.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1105, 'home.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1106, 'home.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1107, 'home.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1108, 'modules.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1109, 'modules.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1110, 'modules.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1111, 'languages.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1112, 'languages.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1113, 'language.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1114, 'languages.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1115, 'languages.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1116, 'zone.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1117, 'shipping-zones.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1118, 'system.logs-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1119, 'search.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1120, 'search.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1121, 'search.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1122, 'administrators.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1123, 'administrators.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1124, 'administrator.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1125, 'administrator.update-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1126, 'administrator.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1127, 'administrators.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1128, 'module-hook.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1129, 'shipping-configuration.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1130, 'shipping-configuration.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1131, 'shipping-configuration.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1132, 'shipping-configuration.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1133, 'shipping-configuration.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1134, 'shipping-configuration.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1135, 'shipping-configuration.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1136, 'features.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1137, 'features.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1138, 'features.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1139, 'features.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1140, 'feature.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1141, 'feature.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1142, 'feature.add-to-all-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1143, 'feature.remove-to-all-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1144, 'features.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1145, 'module.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1146, 'module-hook.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1147, 'module-hook.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1148, 'module-hook.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1149, 'shipping-configuration.edit', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1150, 'shipping-configuration.country-delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1151, 'shipping-configuration.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1152, 'mailing-system.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1153, 'mailing-system.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1154, 'mailing-system.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1155, 'categories.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1156, 'categories.caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1157, 'categories.header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1158, 'categories.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1159, 'products.caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1160, 'products.header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1161, 'products.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1162, 'categories.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1163, 'categories.catalog-bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1164, 'category.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1165, 'product.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1166, 'category.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1167, 'product.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1168, 'categories.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1169, 'variables.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1170, 'variables.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1171, 'variables.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1172, 'variables.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1173, 'variable.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1174, 'variable.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1175, 'variables.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1176, 'order.product-list', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1177, 'order.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1178, 'config-store.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1179, 'translations.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1180, 'folders.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1181, 'folders.caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1182, 'folders.header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1183, 'folders.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1184, 'contents.caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1185, 'contents.header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1186, 'contents.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1187, 'folders.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1188, 'folder.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1189, 'content.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1190, 'folder.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1191, 'content.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1192, 'folders.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1193, 'template.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1194, 'tax.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1195, 'hook.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1196, 'countries.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1197, 'countries.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1198, 'countries.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1199, 'countries.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1200, 'country.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1201, 'country.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1202, 'countries.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1203, 'currencies.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1204, 'currencies.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1205, 'currencies.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1206, 'currencies.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1207, 'currency.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1208, 'currency.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1209, 'currencies.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1210, 'customer.edit', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1211, 'customer.address-create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1212, 'customer.address-update-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1213, 'customer.address-delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1214, 'customer.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1215, 'attributes-value.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1216, 'attributes-value.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1217, 'attribute-value.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1218, 'attribute.id-delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1219, 'attribute.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1220, 'profiles.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1221, 'profiles.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1222, 'profile.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1223, 'profile.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1224, 'profiles.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1225, 'country.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1226, 'profile.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1227, 'variable.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1228, 'coupon.update-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1229, 'coupon.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1230, 'coupon.list-caption', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1231, 'coupon.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1232, 'coupon.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1233, 'coupon.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1234, 'coupon.list-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1235, 'module.configuration', 2, 1, 0, 1, 1, 1, NOW(), NOW()),
  (1236, 'module.config-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1237, 'message.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1238, 'image.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1239, 'attributes.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1240, 'attributes.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1241, 'attributes.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1242, 'attributes.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1243, 'attribute.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1244, 'attribute.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1245, 'attribute.add-to-all-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1246, 'attribute.remove-to-all-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1247, 'attributes.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1248, 'admin-logs.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1249, 'admin-logs.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1250, 'admin-logs.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1251, 'folder.edit-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1252, 'hooks.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1253, 'hooks.table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1254, 'hooks.table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1255, 'hooks.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1256, 'hook.create-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1257, 'hook.delete-form', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1258, 'hooks.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1259, 'main.head-css', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1260, 'main.before-topbar', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1261, 'main.inside-topbar', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1262, 'main.after-topbar', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1263, 'main.before-top-menu', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1264, 'main.in-top-menu-items', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1265, 'main.after-top-menu', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1266, 'main.before-footer', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1267, 'main.in-footer', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1268, 'main.after-footer', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1269, 'main.footer-js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1270, 'main.topbar-top', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1271, 'main.topbar-bottom', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1272, 'main.top-menu-customer', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1273, 'main.top-menu-order', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1274, 'main.top-menu-catalog', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1275, 'main.top-menu-content', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1276, 'main.top-menu-tools', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1277, 'main.top-menu-modules', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1278, 'main.top-menu-configuration', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1279, 'brand.edit-js', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1280, 'home.block', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1281, 'brands.top', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1282, 'brands.table-header', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1283, 'brands.table-row', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1284, 'brands.bottom', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1285, 'brand.create-form', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1286, 'brand.delete-form', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1287, 'brand.js', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1288, 'imports.top', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1289, 'imports.row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1290, 'imports.bottom', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1291, 'imports.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1292, 'import.js', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1293, 'brand.tab-content', 2, 0, 1, 1, 1, 1, NOW(), NOW()),
  (1294, 'customer.orders-table-header', 2, 0, 0, 1, 1, 1, NOW(), NOW()),
  (1295, 'customer.orders-table-row', 2, 0, 0, 1, 1, 1, NOW(), NOW()),

  (2001, 'invoice.css', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2002, 'invoice.header', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2003, 'invoice.footer-top', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2004, 'invoice.imprint', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2005, 'invoice.footer-bottom', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2006, 'invoice.information', 3, 0, 1, 1, 1, 1, NOW(), NOW()),
  (2007, 'invoice.after-information', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2008, 'invoice.delivery-address', 3, 1, 0, 1, 1, 1, NOW(), NOW()),
  (2009, 'invoice.after-addresses', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2010, 'invoice.after-products', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2011, 'invoice.after-summary', 3, 0, 0, 1, 1, 1, NOW(), NOW()),

  (2012, 'delivery.css', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2013, 'delivery.header', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2014, 'delivery.footer-top', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2015, 'delivery.imprint', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2016, 'delivery.footer-bottom', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2017, 'delivery.information', 3, 0, 1, 1, 1, 1, NOW(), NOW()),
  (2018, 'delivery.after-information', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2019, 'delivery.delivery-address', 3, 1, 0, 1, 1, 1, NOW(), NOW()),
  (2020, 'delivery.after-addresses', 3, 0, 0, 1, 1, 1, NOW(), NOW()),
  (2021, 'delivery.after-summary', 3, 0, 0, 1, 1, 1, NOW(), NOW()),

  (2022, 'order-placed.additional-payment-info', 1, 1, 0, 1, 1, 1, NOW(), NOW()),

  (2023, 'wysiwyg.js', 2, 0, 0, 1, 1, 1, NOW(), NOW())
;


INSERT INTO  `hook_i18n` (`id`, `locale`, `title`, `description`, `chapo`) VALUES
  (1, 'de_DE', 'Bezahlungsmethode - oben', '', ''),
  (2, 'de_DE', 'Bezahlungsmethode - Lieferadresse', '', ''),
  (3, 'de_DE', 'Bezahlungsmethode - extra payment zone', '', ''),
  (4, 'de_DE', 'Bezahlungsmethode - unten', '', ''),
  (5, 'de_DE', 'Bezahlungsmethode - nach der Initialisierung von Javascript', '', ''),
  (6, 'de_DE', 'Bezahlungsmethode - CSS-Stylesheet', '', ''),
  (7, 'de_DE', 'Bezahlungsmethode - Nach Integration von JavaScript', '', ''),
  (8, 'de_DE', 'Zahlung-Gateway - Hauptbereich', '', ''),
  (9, 'de_DE', 'Zahlung-Gateway - Javascript', '', ''),
  (10, 'de_DE', 'Zahlung-Gateway - nach der Initialisierung von Javascript', '', ''),
  (11, 'de_DE', 'Zahlung-Gateway - CSS-Stylesheet', '', ''),
  (12, 'de_DE', 'Zahlung-Gateway - Nach Integration von JavaScript', '', ''),
  (13, 'de_DE', 'Sitemap - unten', '', ''),
  (14, 'de_DE', 'Währungswahl-Seite - oben', '', ''),
  (15, 'de_DE', 'Währungswahl-Seite - unten', '', ''),
  (16, 'de_DE', 'Währungswahl-Seite - CSS-Stylesheet', '', ''),
  (17, 'de_DE', 'Währungswahl-Seite - Nach Integration von JavaScript', '', ''),
  (18, 'de_DE', 'Währungswahl-Seite - nach der Initialisierung von Javascript', '', ''),
  (19, 'de_DE', 'Anmeldeseite - oben', '', ''),
  (20, 'de_DE', 'Anmeldeseite - oben an dem Hauptbereich', '', ''),
  (21, 'de_DE', 'Anmeldeseite - oben im Formular', '', ''),
  (22, 'de_DE', 'Anmeldeseite - unten an dem Formular', '', ''),
  (23, 'de_DE', 'Anmeldeseite - unten an dem Hauptbereich', '', ''),
  (24, 'de_DE', 'Anmeldeseite - unten', '', ''),
  (25, 'de_DE', 'Anmeldeseite - CSS-Stylesheet', '', ''),
  (26, 'de_DE', 'Anmeldeseite - Nach Integration von JavaScript', '', ''),
  (27, 'de_DE', 'Anmeldeseite - nach der Initialisierung von Javascript', '', ''),
  (28, 'de_DE', 'Kundenkonto Änderung - oben', '', ''),
  (29, 'de_DE', 'Kundenkonto Änderung - oben im Formular', '', ''),
  (30, 'de_DE', 'Kundenkonto Änderung - unten an dem Formular', '', ''),
  (31, 'de_DE', 'Kundenkonto Änderung - unten', '', ''),
  (32, 'de_DE', 'Kundenkonto Änderung - CSS-Stylesheet', '', ''),
  (33, 'de_DE', 'Kundenkonto Änderung - Nach Integration von JavaScript', '', ''),
  (34, 'de_DE', 'Kundenkonto Änderung - nach der Initialisierung von Javascript', '', ''),
  (35, 'de_DE', 'Warenkorb - oben ', '', ''),
  (36, 'de_DE', 'Warenkorb - unten', '', ''),
  (37, 'de_DE', 'Warenkorb - Nach Integration von JavaScript', '', ''),
  (38, 'de_DE', 'Warenkorb - CSS-Stylesheet', '', ''),
  (39, 'de_DE', 'Warenkorb - Initialisierung von Javascript', '', ''),
  (40, 'de_DE', 'Kontaktseite - oben', '', ''),
  (41, 'de_DE', 'Kontaktseite - oben an dem Formular', '', ''),
  (42, 'de_DE', 'Kontaktseite - unten an dem Formular', '', ''),
  (43, 'de_DE', 'Kontaktseite - unten', '', ''),
  (44, 'de_DE', 'Kontaktseite - CSS-Stylesheet', '', ''),
  (45, 'de_DE', 'Kontaktseite - Nach Integration von JavaScript', '', ''),
  (46, 'de_DE', 'Kontaktseite - nach der Initialisierung von Javascript', '', ''),
  (47, 'de_DE', 'Erteilten Auftrag - Hauptbereich', '', ''),
  (48, 'de_DE', 'Erteilten Auftrag - CSS-Stylesheet', '', ''),
  (49, 'de_DE', 'Erteilten Auftrag - nach Integration von JavaScript', '', ''),
  (50, 'de_DE', 'Erteilten Auftrag - nach der Initialisierung von Javascript', '', ''),
  (51, 'de_DE', 'Suche-Seite - CSS-Stylesheet', '', ''),
  (52, 'de_DE', 'Suche-Seite - Nach Integration von JavaScript', '', ''),
  (53, 'de_DE', 'Suche-Seite - nach der Initialisierung von Javascript', '', ''),
  (54, 'de_DE', 'Konto-Erstellung - oben', '', ''),
  (55, 'de_DE', 'Konto-Erstellung - oben im Formular', '', ''),
  (56, 'de_DE', 'Konto-Erstellung - unten an dem Formular', '', ''),
  (57, 'de_DE', 'Konto-Erstellung - unten', '', ''),
  (58, 'de_DE', 'Konto-Erstellung - CSS-Stylesheet', '', ''),
  (59, 'de_DE', 'Konto-Erstellung - Nach Integration von JavaScript', '', ''),
  (60, 'de_DE', 'Konto-Erstellung - nach der Initialisierung von Javascript', '', ''),
  (61, 'de_DE', 'Passwort verloren - oben', '', ''),
  (62, 'de_DE', 'Passwort verloren - oben im Formular', '', ''),
  (63, 'de_DE', 'Passwort verloren - unten an dem Formular', '', ''),
  (64, 'de_DE', 'Passwort verloren - unten', '', ''),
  (65, 'de_DE', 'Passwort verloren - CSS-Stylesheet', '', ''),
  (66, 'de_DE', 'Passwort verloren - Nach Integration von JavaScript', '', ''),
  (67, 'de_DE', 'Passwort verloren - Initialisierung von Javascript', '', ''),
  (68, 'de_DE', 'Sprachwahl Seite - oben', '', ''),
  (69, 'de_DE', 'Sprachwahl Seite - unten', '', ''),
  (70, 'de_DE', 'Sprachwahl Seite - CSS-Stylesheet', '', ''),
  (71, 'de_DE', 'Sprachwahl Seite - Nach Integration von JavaScript', '', ''),
  (72, 'de_DE', 'Sprachwahl Seite - nach der Initialisierung von Javascript', '', ''),
  (73, 'de_DE', 'Kontaktseite - wenn erfolgreich', '', ''),
  (74, 'de_DE', 'Newletter-Seite - oben', '', ''),
  (75, 'de_DE', 'Newletter-Seite - unten', '', ''),
  (76, 'de_DE', 'Newletter-Seite - CSS-Stylesheet', '', ''),
  (77, 'de_DE', 'Newletter-Seite - Nach Integration von JavaScript', '', ''),
  (78, 'de_DE', 'Newletter-Seite - nach der Initialisierung von Javascript', '', ''),
  (79, 'de_DE', 'Bezahlungs-Fehlschlagen - CSS-Stylesheet', '', ''),
  (80, 'de_DE', 'Bezahlungs-Fehlschlagen - Nach Integration von JavaScript', '', ''),
  (81, 'de_DE', 'Bezahlungs-Fehlschlagen - Initialisierung von Javascript', '', ''),
  (82, 'de_DE', 'Inhaltseite - oben', '', ''),
  (83, 'de_DE', 'Inhaltseite - oben an dem Hauptbereich', '', ''),
  (84, 'de_DE', 'Inhaltseite - unten an dem Hauptbereich', '', ''),
  (85, 'de_DE', 'Inhaltseite - unten', '', ''),
  (86, 'de_DE', 'Inhaltseite - CSS-Stylesheet', '', ''),
  (87, 'de_DE', 'Inhaltseite - Nach Integration von JavaScript', '', ''),
  (88, 'de_DE', 'Inhaltseite - nach der Initialisierung von Javascript', '', ''),
  (89, 'de_DE', 'HTML Struktur - nach der Eröffnung des Head-Tag', '', ''),
  (90, 'de_DE', 'HTML Struktur - CSS-Stylesheet', '', ''),
  (91, 'de_DE', 'HTML Struktur - vor dem Ende des Head-Tag', '', ''),
  (92, 'de_DE', 'HTML Struktur - nach der Eröffnung des Body-Tag', '', ''),
  (93, 'de_DE', 'HTML Struktur - oben an dem Header', '', ''),
  (94, 'de_DE', 'HTML Struktur - Sekundärenavigation', '', ''),
  (95, 'de_DE', 'HTML Struktur - Hauptnavigation', '', ''),
  (96, 'de_DE', 'HTML Struktur - unten an dem Header', '', ''),
  (97, 'de_DE', 'HTML Struktur - vor dem Hauptinhaltsbereich', '', ''),
  (98, 'de_DE', 'HTML Struktur - nach dem Hauptinhaltsbereich', '', ''),
  (99, 'de_DE', 'HTML Struktur - oben an dem Footer', '', ''),
  (100, 'de_DE', 'HTML Struktur - Footer Body', '', ''),
  (101, 'de_DE', 'HTML Struktur - unten an dem Footer', '', ''),
  (102, 'de_DE', 'HTML Struktur - Nach Integration von JavaScript', '', ''),
  (103, 'de_DE', 'HTML Struktur - Initialisierung von Javascript', '', ''),
  (104, 'de_DE', 'HTML Struktur - vor dem Ende des Body-Tag', '', ''),
  (105, 'de_DE', 'Seite nicht gefunden - Inhalts-Bereich', '', ''),
  (106, 'de_DE', 'Seite nicht gefunden - CSS-Stylesheet', '', ''),
  (107, 'de_DE', 'Seite nicht gefunden - Nach Integration von JavaScript', '', ''),
  (108, 'de_DE', 'Seite nicht gefunden - nach der Initialisierung von Javascript', '', ''),
  (109, 'de_DE', 'Lieferwahl - oben', '', ''),
  (110, 'de_DE', 'Lieferwahl - oben an dem Formular', '', ''),
  (111, 'de_DE', 'Lieferwahl - unten an dem Formular', '', ''),
  (112, 'de_DE', 'Lieferwahl - unten', '', ''),
  (113, 'de_DE', 'Lieferwahl - nach der Initialisierung von Javascript', '', ''),
  (114, 'de_DE', 'Lieferwahl - CSS-Stylesheet', '', ''),
  (115, 'de_DE', 'Lieferwahl - Nach Integration von JavaScript', '', ''),
  (116, 'de_DE', 'Adresse Erstellung - oben', '', ''),
  (117, 'de_DE', 'Adresse Erstellung - oben im Formular', '', ''),
  (118, 'de_DE', 'Adresse Erstellung - unten im Formular', '', ''),
  (119, 'de_DE', 'Adresse Erstellung - unten', '', ''),
  (120, 'de_DE', 'Adresse Erstellung - CSS-Stylesheet', '', ''),
  (121, 'de_DE', 'Adresse Erstellung - nach der Integration von Javascript', '', ''),
  (122, 'de_DE', 'Adresse Erstellung - nach der Initialisierung von Javascript', '', ''),
  (123, 'de_DE', 'Ordnerseite - oben', '', ''),
  (124, 'de_DE', 'Ordnerseite - oben an dem Hauptbereich', '', ''),
  (125, 'de_DE', 'Ordnerseite - unten an dem Hauptbereich', '', ''),
  (126, 'de_DE', 'Ordnerseite - unten', '', ''),
  (127, 'de_DE', 'Ordnerseite - CSS-Stylesheet', '', ''),
  (128, 'de_DE', 'Ordnerseite - Nach Integration von JavaScript', '', ''),
  (129, 'de_DE', 'Ordnerseite - nach der Initialisierung von Javascript', '', ''),
  (130, 'de_DE', 'Fehlschlag der Bestellung - oben', '', ''),
  (131, 'de_DE', 'Fehlschlag der Bestellung - unten', '', ''),
  (132, 'de_DE', 'Fehlschlag der Bestellung - CSS-Stylesheet', '', ''),
  (133, 'de_DE', 'Fehlschlag der Bestellung - Nach Integration von JavaScript', '', ''),
  (134, 'de_DE', 'Fehlschlag der Bestellung - nach der Initialisierung von Javascript', '', ''),
  (135, 'de_DE', 'Kategorieseite - oben', '', ''),
  (136, 'de_DE', 'Kategorieseite - oben an dem Hauptbereich', '', ''),
  (137, 'de_DE', 'Kategorieseite - unten an dem Hauptbereich', '', ''),
  (138, 'de_DE', 'Kategorieseite - unten', '', ''),
  (139, 'de_DE', 'Kategorieseite - CSS-Stylesheet', '', ''),
  (140, 'de_DE', 'Kategorieseite - Nach Integration von JavaScript', '', ''),
  (141, 'de_DE', 'Kategorieseite - nach der Initialisierung von Javascript', '', ''),
  (142, 'de_DE', 'Adresseänderung - oben', '', ''),
  (143, 'de_DE', 'Adressänderung - oben im Formular', '', ''),
  (144, 'de_DE', 'Adresseänderung - unten im Formular', '', ''),
  (145, 'de_DE', 'Adresseänderung - unten', '', ''),
  (146, 'de_DE', 'Adresseänderung - CSS-Stylesheet', '', ''),
  (147, 'de_DE', 'Adresseänderung - nach der Integration von Javascript', '', ''),
  (148, 'de_DE', 'Adresseänderung - nach der Initialisierung von Javascript', '', ''),
  (149, 'de_DE', 'Startseite - Hauptbereich', '', ''),
  (150, 'de_DE', 'Startseite - CSS-Stylesheet', '', ''),
  (151, 'de_DE', 'Startseite - Nach Integration von JavaScript', '', ''),
  (152, 'de_DE', 'Startseite - nach der Initialisierung von Javascript', '', ''),
  (153, 'de_DE', 'Passwort Änderung - oben', '', ''),
  (154, 'de_DE', 'Passwort Änderung - unten', '', ''),
  (155, 'de_DE', 'Passwort Änderung - CSS-Stylesheet', '', ''),
  (156, 'de_DE', 'Passwort Änderung - Nach Integration von JavaScript', '', ''),
  (157, 'de_DE', 'Passwort Änderung - nach der Initialisierung von Javascript', '', ''),
  (158, 'de_DE', 'Produktseite - oben', '', ''),
  (159, 'de_DE', 'Produktseite - Bilder-Gallerie', '', ''),
  (160, 'de_DE', 'Produktseite - oben dem Details-Bereich', '', ''),
  (161, 'de_DE', 'Produktseite - unten dem Details-Bereich', '', ''),
  (162, 'de_DE', 'Produktseite - erweitere Informationen', '', ''),
  (163, 'de_DE', 'Produktseite - unten', '', ''),
  (164, 'de_DE', 'Produktseite - CSS-Stylesheet', '', ''),
  (165, 'de_DE', 'Produktseite - Nach Integration von JavaScript', '', ''),
  (166, 'de_DE', 'Produktseite - nach der Initialisierung von Javascript', '', ''),
  (167, 'de_DE', 'Kundenkonto - oben', '', ''),
  (168, 'de_DE', 'Kundenkonto - unten', '', ''),
  (169, 'de_DE', 'Kundenkonto - CSS-Stylesheet', '', ''),
  (170, 'de_DE', 'Kundenkonto - Nach Integration von JavaScript', '', ''),
  (171, 'de_DE', 'Kundenkonto - nach der Initialisierung von Javascript', '', ''),
  (172, 'de_DE', 'Alle Produkte - oben', '', ''),
  (173, 'de_DE', 'Alle Produkte - unten', '', ''),
  (174, 'de_DE', 'Alle Produkte - CSS-Stylesheet', '', ''),
  (175, 'de_DE', 'Alle Produkte - nach der Integration von Javascript', '', ''),
  (176, 'de_DE', 'Alle Produkte - nach der Initialisierung von Javascript', '', ''),
  (177, 'de_DE', 'Produkt-Loop - oben', '', ''),
  (178, 'de_DE', 'Produkt-Loop - unten', '', ''),
  (179, 'de_DE', 'Kategorieseite - oben an der Sidebar', '', ''),
  (180, 'de_DE', 'Kategorieseite - Sidebars Body', '', ''),
  (181, 'de_DE', 'Kategorieseite - unten an der Sidebar', '', ''),
  (182, 'de_DE', 'Inhaltseite - oben an der Sidebar', '', ''),
  (183, 'de_DE', 'Inhaltseite - Sidebars Body', '', ''),
  (184, 'de_DE', 'Inhaltseite - unten an der Sidebar', '', ''),
  (185, 'de_DE', 'Lieferwahl - Erweiteren Bereich', '', ''),
  (186, 'de_DE', 'Lieferwahl - Javascript', '', ''),
  (1000, 'de_DE', 'Kategorie - Inhalt', '', ''),
  (1001, 'de_DE', 'Inhalt - Inhalt', '', ''),
  (1002, 'de_DE', 'Ordner - Inhalt', '', ''),
  (1003, 'de_DE', 'Bestellung - Inhalt', '', ''),
  (1004, 'de_DE', 'Produkt - Inhalt', '', ''),
  (1005, 'de_DE', 'Karakteristiken-Angaben - Tabellenkopf', '', ''),
  (1006, 'de_DE', 'Karakteristiken-Angaben - Tabellenzeile', '', ''),
  (1007, 'de_DE', 'Karakteristik - Angabe-Erstellungsformular', '', ''),
  (1008, 'de_DE', 'Karakteristik - JavaScript Änderung', '', ''),
  (1009, 'de_DE', 'Produkt - JavaScript Änderung', '', ''),
  (1010, 'de_DE', 'Gutschein - JavaScript erstellen', '', ''),
  (1011, 'de_DE', 'Taxes - Änderungs-Formular', '', ''),
  (1012, 'de_DE', 'Taxregel - JavaScript Änderung', '', ''),
  (1013, 'de_DE', 'Tools - oben', '', ''),
  (1014, 'de_DE', 'Tools - oben der Spalte', '', ''),
  (1015, 'de_DE', 'Tools - unten der Spalte 1', '', ''),
  (1016, 'de_DE', 'Tools - unten', '', ''),
  (1017, 'de_DE', 'Tools - JavaScript', '', ''),
  (1018, 'de_DE', 'Nachrichten - oben', '', ''),
  (1019, 'de_DE', 'Nachrichten - Tabellenkopf', '', ''),
  (1020, 'de_DE', 'Nachrichten - Tabellenzeile', '', ''),
  (1021, 'de_DE', 'Nachrichten - unten', '', ''),
  (1022, 'de_DE', 'Nachricht - Erstellungsformular', '', ''),
  (1023, 'de_DE', 'Nachricht - Löschungsformular', '', ''),
  (1024, 'de_DE', 'Nachrichten - JavaScript', '', ''),
  (1025, 'de_DE', 'Taxeregeln - oben', '', ''),
  (1026, 'de_DE', 'Taxeregeln - unten', '', ''),
  (1027, 'de_DE', 'Taxe - Erstellungsformular', '', ''),
  (1028, 'de_DE', 'Taxe - Löschungsformular', '', ''),
  (1029, 'de_DE', 'Taxregel - Erstellungsformular', '', ''),
  (1030, 'de_DE', 'Taxregel - Löschungsformular', '', ''),
  (1031, 'de_DE', 'Taxeregeln - JavaScript', '', ''),
  (1032, 'de_DE', 'Exporte - oben', '', ''),
  (1033, 'de_DE', 'Exporte - unten einer Kategorie', '', ''),
  (1034, 'de_DE', 'Exporte - unten der Spalte 1', '', ''),
  (1035, 'de_DE', 'Exporte - JavaScript', '', ''),
  (1036, 'de_DE', 'Export - JavaScript', '', ''),
  (1037, 'de_DE', 'Produkt - Ordner Tabellenkopf', '', ''),
  (1038, 'de_DE', 'Produkt - Ordner Tabellenzeile', '', ''),
  (1039, 'de_DE', 'Produkt - Preisedetails Formular', '', ''),
  (1040, 'de_DE', 'Produkt - Bestandänderung Formular', '', ''),
  (1041, 'de_DE', 'Produkt - Sonderangebotdetails Formular', '', ''),
  (1042, 'de_DE', 'Produkt - vor den Kombinationen', '', ''),
  (1043, 'de_DE', 'Produkt - Kombinationsliste-Bildunterschrift', '', ''),
  (1044, 'de_DE', 'Produkt - nach den Kombinationen', '', ''),
  (1045, 'de_DE', 'Produkt - Kombinations-Löschungsformular', '', ''),
  (1046, 'de_DE', 'Modulen - Tabellenkopf', '', ''),
  (1047, 'de_DE', 'Modulen - Tabellenzeile', '', ''),
  (1048, 'de_DE', 'Währung - JavaScript Änderung', '', ''),
  (1049, 'de_DE', 'Kategorie - Inhalts Tabellenkopf', '', ''),
  (1050, 'de_DE', 'Kategorie - Inhalts Tabellenzeile', '', ''),
  (1051, 'de_DE', 'Kategorie - JavaScript Änderung', '', ''),
  (1052, 'de_DE', 'Dokument - JavaScript Änderung', '', ''),
  (1053, 'de_DE', 'Kunde - oben', '', ''),
  (1054, 'de_DE', 'Kunden - Bildunterschrift', '', ''),
  (1055, 'de_DE', 'Kunden - Tabellenkopf', '', ''),
  (1056, 'de_DE', 'Kunden - Zeile', '', ''),
  (1057, 'de_DE', 'Kunde - unten', '', ''),
  (1058, 'de_DE', 'Kunde - Erstellungsformular', '', ''),
  (1059, 'de_DE', 'Kunde - Löschungsformular', '', ''),
  (1060, 'de_DE', 'Kunden - JavaScript', '', ''),
  (1061, 'de_DE', 'Produkt - Inhalte Tabellenkopf', '', ''),
  (1062, 'de_DE', 'Produkt - Inhalte Tabellenzeile', '', ''),
  (1063, 'de_DE', 'Produkt - Zubehör Tabellenkopf', '', ''),
  (1064, 'de_DE', 'Produkt - Zubehör Tabellenzeile', '', ''),
  (1065, 'de_DE', 'Produkt - Kategorien Tabellenkopf', '', ''),
  (1066, 'de_DE', 'Produkt - Kategorien Tabellenzeile', '', ''),
  (1067, 'de_DE', 'Produkt - Deklination Tabellenkopf', '', ''),
  (1068, 'de_DE', 'Produkt - Deklination Tabellenzeile', '', ''),
  (1069, 'de_DE', 'Produkt - Charakteristiken Tabellenkopf', '', ''),
  (1070, 'de_DE', 'Produkt - Charakteristiken Tabellenzeile', '', ''),
  (1071, 'de_DE', 'Template - Tabellenkopf attributs', '', ''),
  (1072, 'de_DE', 'Template - Tabellenzeile attributs', '', ''),
  (1073, 'de_DE', 'Template - Charakteristiken Tabellenkopf', '', ''),
  (1074, 'de_DE', 'Template - Charakteristiken Tabellenzeile', '', ''),
  (1075, 'de_DE', 'Templates - oben', '', ''),
  (1076, 'de_DE', 'Templates - Tabellenkopf', '', ''),
  (1077, 'de_DE', 'Templates - Tabellenzeile', '', ''),
  (1078, 'de_DE', 'Templates - unten', '', ''),
  (1079, 'de_DE', 'Template - Erstellungsformular', '', ''),
  (1080, 'de_DE', 'Template - Löschungsformular', '', ''),
  (1081, 'de_DE', 'Templates - JavaScript', '', ''),
  (1082, 'de_DE', 'Konfiguration - oben', '', ''),
  (1083, 'de_DE', 'Konfiguration - oben an dem Katalogsbereich', '', ''),
  (1084, 'de_DE', 'Konfiguration - unten an dem katalog', '', ''),
  (1085, 'de_DE', 'Konfiguration - oben an der Lieferzone', '', ''),
  (1086, 'de_DE', 'Konfiguration - unten an der Lieferzone', '', ''),
  (1087, 'de_DE', 'Konfiguration - oben an dem Systembereich', '', ''),
  (1088, 'de_DE', 'Konfiguration - unten an dem Systembereich', '', ''),
  (1089, 'de_DE', 'Konfiguration - unten', '', ''),
  (1090, 'de_DE', 'Konfiguration - JavaScript', '', ''),
  (1091, 'de_DE', 'Dashboard - oben', '', ''),
  (1092, 'de_DE', 'Dashboard - in der Mitte', '', ''),
  (1093, 'de_DE', 'Dashboard - unten', '', ''),
  (1094, 'de_DE', 'Bestellungen - oben', '', ''),
  (1095, 'de_DE', 'Bestellungen - Tabellenkopf', '', ''),
  (1096, 'de_DE', 'Bestellungen - Tabellenzeile', '', ''),
  (1097, 'de_DE', 'Bestellungen - unten', '', ''),
  (1098, 'de_DE', 'Bestellungen - JavaScript', '', ''),
  (1099, 'de_DE', 'Lieferzone - oben', '', ''),
  (1100, 'de_DE', 'Lieferzone - Tabellenkopf', '', ''),
  (1101, 'de_DE', 'Lieferzone - Tabellenzeile', '', ''),
  (1102, 'de_DE', 'Lieferzone - unten', '', ''),
  (1103, 'de_DE', 'Lieferzone - JavaScript', '', ''),
  (1104, 'de_DE', 'Inhalt - JavaScript Änderung', '', ''),
  (1105, 'de_DE', 'Accueil - oben', '', ''),
  (1106, 'de_DE', 'Accueil - unten', '', ''),
  (1107, 'de_DE', 'Accueil - JavaScript', '', ''),
  (1108, 'de_DE', 'Modulen - oben', '', ''),
  (1109, 'de_DE', 'Modulen - unten', '', ''),
  (1110, 'de_DE', 'Modulen - JavaScript', '', ''),
  (1111, 'de_DE', 'Sprachen - oben', '', ''),
  (1112, 'de_DE', 'Sprachen - unten', '', ''),
  (1113, 'de_DE', 'Sprache - Erstellungsformular', '', ''),
  (1114, 'de_DE', 'Sprachen - Löschungsformular', '', ''),
  (1115, 'de_DE', 'Sprachen - JavaScript', '', ''),
  (1116, 'de_DE', 'Zone - Löschungsformular', '', ''),
  (1117, 'de_DE', 'Lieferzone - JavaScript Änderung', '', ''),
  (1118, 'de_DE', 'System - JavaScript Logs', '', ''),
  (1119, 'de_DE', 'Suche - oben', '', ''),
  (1120, 'de_DE', 'Suche - unten', '', ''),
  (1121, 'de_DE', 'Suche - JavaScript', '', ''),
  (1122, 'de_DE', 'Administratoren - oben', '', ''),
  (1123, 'de_DE', 'Administratoren - unten', '', ''),
  (1124, 'de_DE', 'Administrator - Erstellungsformular', '', ''),
  (1125, 'de_DE', 'Administrator - Änderungsformular', '', ''),
  (1126, 'de_DE', 'Administrator - Löschungsformular', '', ''),
  (1127, 'de_DE', 'Administratoren - JavaScript', '', ''),
  (1128, 'de_DE', 'Modul Hook - JavaScript Änderung', '', ''),
  (1129, 'de_DE', 'Versandkonfiguration - oben', '', ''),
  (1130, 'de_DE', 'Versandkonfiguration - Tabellenkopf', '', ''),
  (1131, 'de_DE', 'Versandkonfiguration - Tabellenzeile', '', ''),
  (1132, 'de_DE', 'Versandkonfiguration - unten', '', ''),
  (1133, 'de_DE', 'Versandkonfiguration - Erstellungsformular', '', ''),
  (1134, 'de_DE', 'Versandkonfiguration - Löschungsformular', '', ''),
  (1135, 'de_DE', 'Versandkonfiguration - JavaScript', '', ''),
  (1136, 'de_DE', 'Karakteristiken - oben', '', ''),
  (1137, 'de_DE', 'Karakteristiken - Tabellenkopf', '', ''),
  (1138, 'de_DE', 'Karakteristiken - Tabellenzeile', '', ''),
  (1139, 'de_DE', 'Karakteristiken - unten', '', ''),
  (1140, 'de_DE', 'Karakteristik - Erstellungsformular', '', ''),
  (1141, 'de_DE', 'Karakteristik - Löschungsformular', '', ''),
  (1142, 'de_DE', 'Karakteristik - zu allen hinzufügen Formular', '', ''),
  (1143, 'de_DE', 'Karakteristik - multipel Löschungsformular', '', ''),
  (1144, 'de_DE', 'Karakteristiken - JavaScript', '', ''),
  (1145, 'de_DE', 'Modul - JavaScript Änderung', '', ''),
  (1146, 'de_DE', 'Modul Hook - Erstellungsformular', '', ''),
  (1147, 'de_DE', 'Modul Hook - Löschungsformular', '', ''),
  (1148, 'de_DE', 'Modul Hook - JavaScript', '', ''),
  (1149, 'de_DE', 'Versandkonfiguration - Änderung', '', ''),
  (1150, 'de_DE', 'Versandkonfiguration - Länder Löschungsfomular', '', ''),
  (1151, 'de_DE', 'Versandkonfiguration - JavaScript Änderung', '', ''),
  (1152, 'de_DE', 'E-Mail Sendung - oben', '', ''),
  (1153, 'de_DE', 'E-Mail Sendung - unten', '', ''),
  (1154, 'de_DE', 'E-Mail Sendung - JavaScript', '', ''),
  (1155, 'de_DE', 'Kategorien - oben', '', ''),
  (1156, 'de_DE', 'Kategorien - Bildunterschrift', '', ''),
  (1157, 'de_DE', 'Kategorien - Kopfzeile', '', ''),
  (1158, 'de_DE', 'Kategorien - Zeile', '', ''),
  (1159, 'de_DE', 'Produkte - Bildunterschrift', '', ''),
  (1160, 'de_DE', 'Produkte - Header', '', ''),
  (1161, 'de_DE', 'Produkte - Zeile', '', ''),
  (1162, 'de_DE', 'Kategorien - unten', '', ''),
  (1163, 'de_DE', 'Kategorien - unten an dem Katalog', '', ''),
  (1164, 'de_DE', 'Kategorie - Erstellungsformular', '', ''),
  (1165, 'de_DE', 'Produkt - Erstellungsformular', '', ''),
  (1166, 'de_DE', 'Kategorie - Löschungsformular', '', ''),
  (1167, 'de_DE', 'Produkt - Löschungsformular', '', ''),
  (1168, 'de_DE', 'Kategorien - JavaScript', '', ''),
  (1169, 'de_DE', 'Variablen - oben', '', ''),
  (1170, 'de_DE', 'Variablen - Tabellenkopf', '', ''),
  (1171, 'de_DE', 'Variablen - Tabellenzeile', '', ''),
  (1172, 'de_DE', 'Variablen - unten', '', ''),
  (1173, 'de_DE', 'Variable - Erstellungsformular', '', ''),
  (1174, 'de_DE', 'Variable - Löschungsformular', '', ''),
  (1175, 'de_DE', 'Variablen - JavaScript', '', ''),
  (1176, 'de_DE', 'Bestellung - Produktliste', '', ''),
  (1177, 'de_DE', 'Bestellung - JavaScript Änderung', '', ''),
  (1178, 'de_DE', 'Shop Informationen - JavaScript', '', ''),
  (1179, 'de_DE', 'Übersetzungen - JavaScript', '', ''),
  (1180, 'de_DE', 'Ordner - oben', '', ''),
  (1181, 'de_DE', 'Ordner - Bildunterschrift', '', ''),
  (1182, 'de_DE', 'Ordner - Header', '', ''),
  (1183, 'de_DE', 'Ordner - Zeile', '', ''),
  (1184, 'de_DE', 'Inhalte - Bildunterschrift', '', ''),
  (1185, 'de_DE', 'Inhalte - Kopfzeile', '', ''),
  (1186, 'de_DE', 'Inhalte - Zeile', '', ''),
  (1187, 'de_DE', 'Ordner - unten', '', ''),
  (1188, 'de_DE', 'Ordner - Erstellungsformular', '', ''),
  (1189, 'de_DE', 'Inhalt - Erstellungsformular', '', ''),
  (1190, 'de_DE', 'Ordner - Löschungsformular', '', ''),
  (1191, 'de_DE', 'Inhalt - Löschungsformular', '', ''),
  (1192, 'de_DE', 'Ordner - JavaScript', '', ''),
  (1193, 'de_DE', 'Template - JavaScript Änderung', '', ''),
  (1194, 'de_DE', 'Taxe - JavaScript Änderung', '', ''),
  (1195, 'de_DE', 'Hook - JavaScript Änderung', '', ''),
  (1196, 'de_DE', 'Länder - oben', '', ''),
  (1197, 'de_DE', 'Länder - Tabellenkopf', '', ''),
  (1198, 'de_DE', 'Länder - Tabellenzeile', '', ''),
  (1199, 'de_DE', 'Länder - unten', '', ''),
  (1200, 'de_DE', 'Land - Erstellungsformular', '', ''),
  (1201, 'de_DE', 'Land - Löschungsformular', '', ''),
  (1202, 'de_DE', 'Länder - JavaScript', '', ''),
  (1203, 'de_DE', 'Währungen - oben', '', ''),
  (1204, 'de_DE', 'Währungen - Tabellenkopf', '', ''),
  (1205, 'de_DE', 'Währungen - Tabellenzeile', '', ''),
  (1206, 'de_DE', 'Währungen - unten', '', ''),
  (1207, 'de_DE', 'Währung - Erstellungsformular', '', ''),
  (1208, 'de_DE', 'Währung - Löschungsformular', '', ''),
  (1209, 'de_DE', 'Währungen - JavaScript', '', ''),
  (1210, 'de_DE', 'Kunde - Modification', '', ''),
  (1211, 'de_DE', 'Kunde - Adresse-Erstellungsformular', '', ''),
  (1212, 'de_DE', 'Kunde - Adresse-Änderungsformular', '', ''),
  (1213, 'de_DE', 'Kunde - Adresse-Löschungsformular', '', ''),
  (1214, 'de_DE', 'Kunde - JavaScript Änderung', '', ''),
  (1215, 'de_DE', 'Deklinationenangaben - Tabellenkopf', '', ''),
  (1216, 'de_DE', 'Deklinationenangaben - Tabellenzeile', '', ''),
  (1217, 'de_DE', 'Deklinationsangabe - Erstellungsformular', '', ''),
  (1218, 'de_DE', 'Deklination - ID Löschungsformular', '', ''),
  (1219, 'de_DE', 'Deklination - JavaScript Änderung', '', ''),
  (1220, 'de_DE', 'Profile - oben', '', ''),
  (1221, 'de_DE', 'Profile - unten', '', ''),
  (1222, 'de_DE', 'Profil - Erstellungsformular', '', ''),
  (1223, 'de_DE', 'Profil - Löschungsformular', '', ''),
  (1224, 'de_DE', 'Profile - JavaScript', '', ''),
  (1225, 'de_DE', 'Land - JavaScript Änderung', '', ''),
  (1226, 'de_DE', 'Profil - JavaScript Änderung', '', ''),
  (1227, 'de_DE', 'Variable - JavaScript Änderung', '', ''),
  (1228, 'de_DE', 'Gutschein - JavaScript Änderung', '', ''),
  (1229, 'de_DE', 'Gutschein - oben', '', ''),
  (1230, 'de_DE', 'Gutschein - Bildunterschrift', '', ''),
  (1231, 'de_DE', 'Gutschein - Tabellenkopf', '', ''),
  (1232, 'de_DE', 'Gutschein - Tabellenzeile', '', ''),
  (1233, 'de_DE', 'Gutschein - unten', '', ''),
  (1234, 'de_DE', 'Gutschein - JavaScript den Listen', '', ''),
  (1235, 'de_DE', 'Modul - Konfiguration', '', ''),
  (1236, 'de_DE', 'Modul - JavaScript Konfiguration', '', ''),
  (1237, 'de_DE', 'Nachricht - JavaScript Änderung', '', ''),
  (1238, 'de_DE', 'Bild - JavaScript Änderung', '', ''),
  (1239, 'de_DE', 'Deklinationen - oben', '', ''),
  (1240, 'de_DE', 'Deklinationen - Tabellenkopf', '', ''),
  (1241, 'de_DE', 'Deklinationen - Tabellenzeile', '', ''),
  (1242, 'de_DE', 'Deklinationen - unten', '', ''),
  (1243, 'de_DE', 'Deklination - Erstellungsformular', '', ''),
  (1244, 'de_DE', 'Deklination - Löschungsformular', '', ''),
  (1245, 'de_DE', 'Deklination - zu allen hinzufügen Formular', '', ''),
  (1246, 'de_DE', 'Deklination - multipel Löschungsformular', '', ''),
  (1247, 'de_DE', 'Deklinationen - JavaScript', '', ''),
  (1248, 'de_DE', 'Logs - oben', '', ''),
  (1249, 'de_DE', 'Logs - unten', '', ''),
  (1250, 'de_DE', 'Protokolle - JavaScript', '', ''),
  (1251, 'de_DE', 'Ordner - JavaScript Änderung', '', ''),
  (1252, 'de_DE', 'Hooks - oben', '', ''),
  (1253, 'de_DE', 'Hooks - Tabellenkopf', '', ''),
  (1254, 'de_DE', 'Hooks - Tabellenzeile', '', ''),
  (1255, 'de_DE', 'Hooks - unten', '', ''),
  (1256, 'de_DE', 'Hook - Erstellungsformular', '', ''),
  (1257, 'de_DE', 'Hook - Löschungsformular', '', ''),
  (1258, 'de_DE', 'Hooks - JavaScript', '', ''),
  (1259, 'de_DE', 'Layout - CSS', '', ''),
  (1260, 'de_DE', 'Layout - vor der Titelleiste', '', ''),
  (1261, 'de_DE', 'Layout - in der Titelleiste', '', ''),
  (1262, 'de_DE', 'Layout - nach der Titelleiste', '', ''),
  (1263, 'de_DE', 'Layout - vor dem Top Menü', '', ''),
  (1264, 'de_DE', 'Layout - in Top-Menü Elementen', '', ''),
  (1265, 'de_DE', 'Layout - nach dem Top Menü', '', ''),
  (1266, 'de_DE', 'Layout - vor dem Footer', '', ''),
  (1267, 'de_DE', 'Layout - Im Footer', '', ''),
  (1268, 'de_DE', 'Layout - nach dem Footer', '', ''),
  (1269, 'de_DE', 'Layout - JavaScript', '', ''),
  (1270, 'de_DE', 'Layout - oben an der Titelleiste', '', ''),
  (1271, 'de_DE', 'Layout - unten an der Titelleiste', '', ''),
  (1272, 'de_DE', 'Layout - im Kundes-Menü', '', ''),
  (1273, 'de_DE', 'Layout - im Bestellungsmenü', '', ''),
  (1274, 'de_DE', 'Layout - im Katalogs-Menü', '', ''),
  (1275, 'de_DE', 'Layout - im Ordners-Menü', '', ''),
  (1276, 'de_DE', 'Layout - im Tools-Menü', '', ''),
  (1277, 'de_DE', 'Layout - im Moduls-Menü', '', ''),
  (1278, 'de_DE', 'Layout - im konfigurations-Menü', '', ''),
  (1279, 'de_DE', 'Marke - JavaScript Änderung', '', ''),
  (1280, 'de_DE', 'Accueil - Block', '', ''),
  (1281, 'de_DE', 'Marken - oben', '', ''),
  (1282, 'de_DE', 'Marken - Tabellenkopf', '', ''),
  (1283, 'de_DE', 'Marken - Tabellzeilen', '', ''),
  (1284, 'de_DE', 'Marken - unten', '', ''),
  (1285, 'de_DE', 'Marke - Erstellungsformular', '', ''),
  (1286, 'de_DE', 'Marke - Löschungsformular', '', ''),
  (1287, 'de_DE', 'Marke - JavaScript', '', ''),
  (1288, 'de_DE', 'Exporte - oben', '', ''),
  (1289, 'de_DE', 'Exporte - unten einer Kategorie', '', ''),
  (1290, 'de_DE', 'Exporte - unten der Spalte 1', '', ''),
  (1291, 'de_DE', 'Exporte - JavaScript', '', ''),
  (1292, 'de_DE', 'Export - JavaScript', '', ''),
  (1293, 'de_DE', 'Marke - Inhalt', '', ''),
  (1294, 'de_DE', 'Kunde - Bestellungs-Tabellenkopf', '', ''),
  (1295, 'de_DE', 'Kunde - Bestellungs-Tabellenzeile', '', ''),

  (2001, 'de_DE', 'Rechnung - CSS', '', ''),
  (2002, 'de_DE', 'Rechnung - im Header', '', ''),
  (2003, 'de_DE', 'Rechnung - oben an dem Footer', '', ''),
  (2004, 'de_DE', 'Rechnung - Impressum', '', ''),
  (2005, 'de_DE', 'Rechnung - unten an dem Footer', '', ''),
  (2006, 'de_DE', 'Rechnung - unten an dem Informationsbereich', '', ''),
  (2007, 'de_DE', 'Rechnung - nach dem Informationsbereich', '', ''),
  (2008, 'de_DE', 'Rechnung - Bestellungsadresse', '', ''),
  (2009, 'de_DE', 'Rechnung - nach dem Adressebereich', '', ''),
  (2010, 'de_DE', 'Rechnung - nach der Produktliste', '', ''),
  (2011, 'de_DE', 'Rechnung - nach der Bestellungs-Zusammenfassung', '', ''),
  (2012, 'de_DE', 'Lieferung - CSS', '', ''),
  (2013, 'de_DE', 'Lieferung - im Header', '', ''),
  (2014, 'de_DE', 'Lieferung - oben an dem Footer', '', ''),
  (2015, 'de_DE', 'Lieferung - Impressum', '', ''),
  (2016, 'de_DE', 'Lieferung - unten an dem Footer', '', ''),
  (2017, 'de_DE', 'Lieferung - unten an dem Informationsbereich', '', ''),
  (2018, 'de_DE', 'Lieferung - Nach dem Informationsbereich', '', ''),
  (2019, 'de_DE', 'Lieferung - Lieferadresse', '', ''),
  (2020, 'de_DE', 'Lieferung - Nach dem Adresse-Bereich', '', ''),
  (2021, 'de_DE', 'Lieferung - Nach der Zusammenfassung der Bestellung', '', ''),

  (2022, 'de_DE', 'Bestellbestätigung - nach den Bestellungszusammenfassungen', '', ''),

  (2023, 'de_DE', 'Überall wo WYSIWYG editor ist nötig', '', ''),
  (1, 'en_US', 'Invoice choice - at the top', '', ''),
  (2, 'en_US', 'Invoice choice - delivery address', '', ''),
  (3, 'en_US', 'Invoice choice - extra payment zone', '', ''),
  (4, 'en_US', 'Invoice choice - at the bottom', '', ''),
  (5, 'en_US', 'Invoice choice - after javascript initialisation', '', ''),
  (6, 'en_US', 'Invoice choice - CSS stylesheet', '', ''),
  (7, 'en_US', 'Invoice choice - after javascript include', '', ''),
  (8, 'en_US', 'Payment gateway - main area', '', ''),
  (9, 'en_US', 'Payment gateway - javascript', '', ''),
  (10, 'en_US', 'Payment gateway - after javascript initialisation', '', ''),
  (11, 'en_US', 'Payment gateway - CSS stylesheet', '', ''),
  (12, 'en_US', 'Payment gateway - after javascript include', '', ''),
  (13, 'en_US', 'Sitemap - at the bottom', '', ''),
  (14, 'en_US', 'Curency selection page - at the top', '', ''),
  (15, 'en_US', 'Curency selection page - at the bottom', '', ''),
  (16, 'en_US', 'Curency selection page - CSS stylesheet', '', ''),
  (17, 'en_US', 'Curency selection page - after javascript include', '', ''),
  (18, 'en_US', 'Curency selection page - after javascript initialisation', '', ''),
  (19, 'en_US', 'Login page - at the top', '', ''),
  (20, 'en_US', 'Login page - at the top of the main area', '', ''),
  (21, 'en_US', 'Login page - at the top of the form', '', ''),
  (22, 'en_US', 'Login page - at the bottom of the form', '', ''),
  (23, 'en_US', 'Login page - at the bottom of the main area', '', ''),
  (24, 'en_US', 'Login page - at the bottom', '', ''),
  (25, 'en_US', 'Login page - CSS stylesheet', '', ''),
  (26, 'en_US', 'Login page - after javascript include', '', ''),
  (27, 'en_US', 'Login page - after javascript initialisation', '', ''),
  (28, 'en_US', 'Update customer account - at the top', '', ''),
  (29, 'en_US', 'Update customer account - at the top of the form', '', ''),
  (30, 'en_US', 'Update customer account - at the bottom of the form', '', ''),
  (31, 'en_US', 'Update customer account - at the bottom', '', ''),
  (32, 'en_US', 'Update customer account - CSS stylesheet', '', ''),
  (33, 'en_US', 'Update customer account - after javascript include', '', ''),
  (34, 'en_US', 'Update customer account - after javascript initialisation', '', ''),
  (35, 'en_US', 'Cart - at the top', '', ''),
  (36, 'en_US', 'Cart - at the bottom', '', ''),
  (37, 'en_US', 'Cart - after javascript include', '', ''),
  (38, 'en_US', 'Cart - CSS stylesheet', '', ''),
  (39, 'en_US', 'Cart - javascript initialization', '', ''),
  (40, 'en_US', 'Contact page - at the top', '', ''),
  (41, 'en_US', 'Contact page - at the top of the form', '', ''),
  (42, 'en_US', 'Contact page - at the bottom of the form', '', ''),
  (43, 'en_US', 'Contact page - at the bottom', '', ''),
  (44, 'en_US', 'Contact page - CSS stylesheet', '', ''),
  (45, 'en_US', 'Contact page - after javascript include', '', ''),
  (46, 'en_US', 'Contact page - after javascript initialisation', '', ''),
  (47, 'en_US', 'Placed order - main area', '', ''),
  (48, 'en_US', 'Placed order - CSS stylesheet', '', ''),
  (49, 'en_US', 'Placed order - after javascript include', '', ''),
  (50, 'en_US', 'Placed order - after javascript initialisation', '', ''),
  (51, 'en_US', 'Search page - CSS stylesheet', '', ''),
  (52, 'en_US', 'Search page - after javascript include', '', ''),
  (53, 'en_US', 'Search page - after javascript initialisation', '', ''),
  (54, 'en_US', 'Register - at the top', '', ''),
  (55, 'en_US', 'Register - at the top of the form', '', ''),
  (56, 'en_US', 'Register - at the bottom of the form', '', ''),
  (57, 'en_US', 'Register - at the bottom', '', ''),
  (58, 'en_US', 'Register - CSS stylesheet', '', ''),
  (59, 'en_US', 'Register - after javascript include', '', ''),
  (60, 'en_US', 'Register - after javascript initialisation', '', ''),
  (61, 'en_US', 'Lost password - at the top', '', ''),
  (62, 'en_US', 'Lost password - at the top of the form', '', ''),
  (63, 'en_US', 'Lost password - at the bottom of the form', '', ''),
  (64, 'en_US', 'Lost password - at the bottom', '', ''),
  (65, 'en_US', 'Lost password - CSS stylesheet', '', ''),
  (66, 'en_US', 'Lost password - after javascript include', '', ''),
  (67, 'en_US', 'Lost password - javascript initialization', '', ''),
  (68, 'en_US', 'language selection page - at the top', '', ''),
  (69, 'en_US', 'language selection page - at the bottom', '', ''),
  (70, 'en_US', 'language selection page - CSS stylesheet', '', ''),
  (71, 'en_US', 'language selection page - after javascript include', '', ''),
  (72, 'en_US', 'language selection page - after javascript initialisation', '', ''),
  (73, 'en_US', 'Contact page - if successful response', '', ''),
  (74, 'en_US', 'Newsletter page - at the top', '', ''),
  (75, 'en_US', 'Newsletter page - at the bottom', '', ''),
  (76, 'en_US', 'Newsletter page - CSS stylesheet', '', ''),
  (77, 'en_US', 'Newsletter page - after javascript include', '', ''),
  (78, 'en_US', 'Newsletter page - after javascript initialisation', '', ''),
  (79, 'en_US', 'Payment failed - CSS stylesheet', '', ''),
  (80, 'en_US', 'Payment failed - after javascript include', '', ''),
  (81, 'en_US', 'Payment failed - javascript initialization', '', ''),
  (82, 'en_US', 'Content page - at the top', '', ''),
  (83, 'en_US', 'Content page - at the top of the main area', '', ''),
  (84, 'en_US', 'Content page - at the bottom of the main area', '', ''),
  (85, 'en_US', 'Content page - at the bottom', '', ''),
  (86, 'en_US', 'Content page - CSS stylesheet', '', ''),
  (87, 'en_US', 'Content page - after javascript include', '', ''),
  (88, 'en_US', 'Content page - after javascript initialisation', '', ''),
  (89, 'en_US', 'HTML layout - after the opening of the head tag', '', ''),
  (90, 'en_US', 'HTML layout - CSS stylesheet', '', ''),
  (91, 'en_US', 'HTML layout - before the end of the head tag', '', ''),
  (92, 'en_US', 'HTML layout - after the opening of the body tag', '', ''),
  (93, 'en_US', 'HTML layout - at the top of the header', '', ''),
  (94, 'en_US', 'HTML layout - secondary navigation', '', ''),
  (95, 'en_US', 'HTML layout - primary navigation', '', ''),
  (96, 'en_US', 'HTML layout - at the bottom of the header', '', ''),
  (97, 'en_US', 'HTML layout - before the main content area', '', ''),
  (98, 'en_US', 'HTML layout - after the main content area', '', ''),
  (99, 'en_US', 'HTML layout - at the top of the footer', '', ''),
  (100, 'en_US', 'HTML layout - footer body', '', ''),
  (101, 'en_US', 'HTML layout - bottom of the footer', '', ''),
  (102, 'en_US', 'HTML layout - after javascript include', '', ''),
  (103, 'en_US', 'HTML layout - javascript initialization', '', ''),
  (104, 'en_US', 'HTML layout - before the end body tag', '', ''),
  (105, 'en_US', 'Page 404 - content area', '', ''),
  (106, 'en_US', 'Page 404 - CSS stylesheet', '', ''),
  (107, 'en_US', 'Page 404 - after javascript include', '', ''),
  (108, 'en_US', 'Page 404 - after javascript initialisation', '', ''),
  (109, 'en_US', 'Delivery choice - at the top', '', ''),
  (110, 'en_US', 'Delivery choice - at the top of the form', '', ''),
  (111, 'en_US', 'Delivery choice - at the bottom of the form', '', ''),
  (112, 'en_US', 'Delivery choice - at the bottom', '', ''),
  (113, 'en_US', 'Delivery choice - after javascript initialisation', '', ''),
  (114, 'en_US', 'Delivery choice - CSS stylesheet', '', ''),
  (115, 'en_US', 'Delivery choice - after javascript include', '', ''),
  (116, 'en_US', 'Address creation - at the top', '', ''),
  (117, 'en_US', 'Address creation - at the top of the form', '', ''),
  (118, 'en_US', 'Address creation - at the bottom of the form', '', ''),
  (119, 'en_US', 'Address creation - at the bottom', '', ''),
  (120, 'en_US', 'Address creation - CSS stylesheet', '', ''),
  (121, 'en_US', 'Address creation - after javascript include', '', ''),
  (122, 'en_US', 'Address creation - after javascript initialisation', '', ''),
  (123, 'en_US', 'Folder page - at the top', '', ''),
  (124, 'en_US', 'Folder page - at the top of the main area', '', ''),
  (125, 'en_US', 'Folder page - at the bottom of the main area', '', ''),
  (126, 'en_US', 'Folder page - at the bottom', '', ''),
  (127, 'en_US', 'Folder page - CSS stylesheet', '', ''),
  (128, 'en_US', 'Folder page - after javascript include', '', ''),
  (129, 'en_US', 'Folder page - after javascript initialisation', '', ''),
  (130, 'en_US', 'Order failed - at the top', '', ''),
  (131, 'en_US', 'Order failed - at the bottom', '', ''),
  (132, 'en_US', 'Order failed - CSS stylesheet', '', ''),
  (133, 'en_US', 'Order failed - after javascript include', '', ''),
  (134, 'en_US', 'Order failed - after javascript initialisation', '', ''),
  (135, 'en_US', 'Category page - at the top', '', ''),
  (136, 'en_US', 'Category page - at the top of the main area', '', ''),
  (137, 'en_US', 'Category page - at the bottom of the main area', '', ''),
  (138, 'en_US', 'Category page - at the bottom', '', ''),
  (139, 'en_US', 'Category page - CSS stylesheet', '', ''),
  (140, 'en_US', 'Category page - after javascript include', '', ''),
  (141, 'en_US', 'Category page - after javascript initialisation', '', ''),
  (142, 'en_US', 'Address update - at the top', '', ''),
  (143, 'en_US', 'Address update - at the top of the form', '', ''),
  (144, 'en_US', 'Address update - at the bottom of the form', '', ''),
  (145, 'en_US', 'Address update - at the bottom', '', ''),
  (146, 'en_US', 'Address update - CSS stylesheet', '', ''),
  (147, 'en_US', 'Address update - after javascript include', '', ''),
  (148, 'en_US', 'Address update - after javascript initialisation', '', ''),
  (149, 'en_US', 'Home page - main area', '', ''),
  (150, 'en_US', 'Home page - CSS stylesheet', '', ''),
  (151, 'en_US', 'Home page - after javascript include', '', ''),
  (152, 'en_US', 'Home page - after javascript initialisation', '', ''),
  (153, 'en_US', 'Change password - at the top', '', ''),
  (154, 'en_US', 'Change password - at the bottom', '', ''),
  (155, 'en_US', 'Change password - CSS stylesheet', '', ''),
  (156, 'en_US', 'Change password - after javascript include', '', ''),
  (157, 'en_US', 'Change password - after javascript initialisation', '', ''),
  (158, 'en_US', 'Product page - at the top', '', ''),
  (159, 'en_US', 'Product page - photo gallery', '', ''),
  (160, 'en_US', 'Product page - at the top of the detail', '', ''),
  (161, 'en_US', 'Product page - at the bottom of the detail area', '', ''),
  (162, 'en_US', 'Product page - additional information', '', ''),
  (163, 'en_US', 'Product page - at the bottom', '', ''),
  (164, 'en_US', 'Product page - CSS stylesheet', '', ''),
  (165, 'en_US', 'Product page - after javascript include', '', ''),
  (166, 'en_US', 'Product page - after javascript initialisation', '', ''),
  (167, 'en_US', 'customer account - at the top', '', ''),
  (168, 'en_US', 'customer account - at the bottom', '', ''),
  (169, 'en_US', 'customer account - CSS stylesheet', '', ''),
  (170, 'en_US', 'customer account - after javascript include', '', ''),
  (171, 'en_US', 'customer account - after javascript initialisation', '', ''),
  (172, 'en_US', 'All Products - at the top', '', ''),
  (173, 'en_US', 'All Products - at the bottom', '', ''),
  (174, 'en_US', 'All Products - CSS stylesheet', '', ''),
  (175, 'en_US', 'All Products - after javascript include', '', ''),
  (176, 'en_US', 'All Products - after javascript initialisation', '', ''),
  (177, 'en_US', 'Product loop - at the top', '', ''),
  (178, 'en_US', 'Product loop - at the bottom', '', ''),
  (179, 'en_US', 'Category page - at the top of the sidebar', '', ''),
  (180, 'en_US', 'Category page - the body of the sidebar', '', ''),
  (181, 'en_US', 'Category page - at the bottom of the sidebar', '', ''),
  (182, 'en_US', 'Content page - at the top of the sidebar', '', ''),
  (183, 'en_US', 'Content page - the body of the sidebar', '', ''),
  (184, 'en_US', 'Content page - at the bottom of the sidebar', '', ''),
  (185, 'en_US', 'Delivery choice - extra area', '', ''),
  (186, 'en_US', 'Delivery choice - javascript', '', ''),
  (1000, 'en_US', 'Category - content', '', ''),
  (1001, 'en_US', 'Content - content', '', ''),
  (1002, 'en_US', 'Folder - content', '', ''),
  (1003, 'en_US', 'Order - content', '', ''),
  (1004, 'en_US', 'Product - content', '', ''),
  (1005, 'en_US', 'Features value - table header', '', ''),
  (1006, 'en_US', 'Features value - table row', '', ''),
  (1007, 'en_US', 'Feature - Value create form', '', ''),
  (1008, 'en_US', 'Feature - Edit JavaScript', '', ''),
  (1009, 'en_US', 'Product - Edit JavaScript', '', ''),
  (1010, 'en_US', 'Coupon - create JavaScript', '', ''),
  (1011, 'en_US', 'Taxes - update form', '', ''),
  (1012, 'en_US', 'tax rule - Edit JavaScript', '', ''),
  (1013, 'en_US', 'Tools - at the top', '', ''),
  (1014, 'en_US', 'Tools - at the top of the column', '', ''),
  (1015, 'en_US', 'Tools - at the bottom of column 1', '', ''),
  (1016, 'en_US', 'Tools - bottom', '', ''),
  (1017, 'en_US', 'Tools - JavaScript', '', ''),
  (1018, 'en_US', 'Messages - at the top', '', ''),
  (1019, 'en_US', 'Messages - table header', '', ''),
  (1020, 'en_US', 'Messages - table row', '', ''),
  (1021, 'en_US', 'Messages - bottom', '', ''),
  (1022, 'en_US', 'Message - create form', '', ''),
  (1023, 'en_US', 'Message - delete form', '', ''),
  (1024, 'en_US', 'Messages - JavaScript', '', ''),
  (1025, 'en_US', 'Taxes rules - at the top', '', ''),
  (1026, 'en_US', 'Taxes rules - bottom', '', ''),
  (1027, 'en_US', 'Tax - create form', '', ''),
  (1028, 'en_US', 'Tax - delete form', '', ''),
  (1029, 'en_US', 'tax rule - create form', '', ''),
  (1030, 'en_US', 'tax rule - delete form', '', ''),
  (1031, 'en_US', 'Taxes rules - JavaScript', '', ''),
  (1032, 'en_US', 'Exports - at the top', '', ''),
  (1033, 'en_US', 'Exports - at the bottom of a category', '', ''),
  (1034, 'en_US', 'Exports - at the bottom of column 1', '', ''),
  (1035, 'en_US', 'Exports - JavaScript', '', ''),
  (1036, 'en_US', 'Export - JavaScript', '', ''),
  (1037, 'en_US', 'Product - folders table header', '', ''),
  (1038, 'en_US', 'Product - folders table row', '', ''),
  (1039, 'en_US', 'Product - details pricing form', '', ''),
  (1040, 'en_US', 'Product - stock edit form', '', ''),
  (1041, 'en_US', 'Product - details promotion form', '', ''),
  (1042, 'en_US', 'Product - before combinations', '', ''),
  (1043, 'en_US', 'Product - combinations list caption', '', ''),
  (1044, 'en_US', 'Product - after combinations', '', ''),
  (1045, 'en_US', 'Product - combination delete form', '', ''),
  (1046, 'en_US', 'Modules - table header', '', ''),
  (1047, 'en_US', 'Modules - table row', '', ''),
  (1048, 'en_US', 'Currency - Edit JavaScript', '', ''),
  (1049, 'en_US', 'Category - contents table header', '', ''),
  (1050, 'en_US', 'Category - contents table row', '', ''),
  (1051, 'en_US', 'Category - Edit JavaScript', '', ''),
  (1052, 'en_US', 'Document - Edit JavaScript', '', ''),
  (1053, 'en_US', 'Customer - at the top', '', ''),
  (1054, 'en_US', 'Customers - caption', '', ''),
  (1055, 'en_US', 'Customers - header', '', ''),
  (1056, 'en_US', 'Customers - row', '', ''),
  (1057, 'en_US', 'Customer - bottom', '', ''),
  (1058, 'en_US', 'Customer - create form', '', ''),
  (1059, 'en_US', 'Customer - delete form', '', ''),
  (1060, 'en_US', 'Customers - JavaScript', '', ''),
  (1061, 'en_US', 'Product - contents table header', '', ''),
  (1062, 'en_US', 'Product - contents table row', '', ''),
  (1063, 'en_US', 'Product - accessories table header', '', ''),
  (1064, 'en_US', 'Product - accessories table row', '', ''),
  (1065, 'en_US', 'Product - categories table header', '', ''),
  (1066, 'en_US', 'Product - categories table row', '', ''),
  (1067, 'en_US', 'Product - attributes table header', '', ''),
  (1068, 'en_US', 'Product - attributes table row', '', ''),
  (1069, 'en_US', 'Product - features-table-header', '', ''),
  (1070, 'en_US', 'Product - features table row', '', ''),
  (1071, 'en_US', 'Template - attributes table header', '', ''),
  (1072, 'en_US', 'Template - attributes table row', '', ''),
  (1073, 'en_US', 'Template - features-table-header', '', ''),
  (1074, 'en_US', 'Template - features table row', '', ''),
  (1075, 'en_US', 'Templates - at the top', '', ''),
  (1076, 'en_US', 'Templates - table header', '', ''),
  (1077, 'en_US', 'Templates - table row', '', ''),
  (1078, 'en_US', 'Templates - bottom', '', ''),
  (1079, 'en_US', 'Template - create form', '', ''),
  (1080, 'en_US', 'Template - delete form', '', ''),
  (1081, 'en_US', 'Templates - JavaScript', '', ''),
  (1082, 'en_US', 'Configuration - at the top', '', ''),
  (1083, 'en_US', 'Configuration - at the top of the catalog area', '', ''),
  (1084, 'en_US', 'Configuration - at the bottom of the catalog', '', ''),
  (1085, 'en_US', 'Configuration - at the top of the shipping area', '', ''),
  (1086, 'en_US', 'Configuration - at the bottom of the shipping area', '', ''),
  (1087, 'en_US', 'Configuration - at the top of the system area', '', ''),
  (1088, 'en_US', 'Configuration - at the bottom of the system area', '', ''),
  (1089, 'en_US', 'Configuration - bottom', '', ''),
  (1090, 'en_US', 'Configuration - JavaScript', '', ''),
  (1091, 'en_US', 'Dashboard - at the top', '', ''),
  (1092, 'en_US', 'Dashboard - middle', '', ''),
  (1093, 'en_US', 'Dashboard - bottom', '', ''),
  (1094, 'en_US', 'Orders - at the top', '', ''),
  (1095, 'en_US', 'Orders - table header', '', ''),
  (1096, 'en_US', 'Orders - table row', '', ''),
  (1097, 'en_US', 'Orders - bottom', '', ''),
  (1098, 'en_US', 'Orders - JavaScript', '', ''),
  (1099, 'en_US', 'Delivery zone - at the top', '', ''),
  (1100, 'en_US', 'Delivery zone - table header', '', ''),
  (1101, 'en_US', 'Delivery zone - table row', '', ''),
  (1102, 'en_US', 'Delivery zone - bottom', '', ''),
  (1103, 'en_US', 'Delivery zone - JavaScript', '', ''),
  (1104, 'en_US', 'Content - Edit JavaScript', '', ''),
  (1105, 'en_US', 'Home - at the top', '', ''),
  (1106, 'en_US', 'Home - bottom', '', ''),
  (1107, 'en_US', 'Home - JavaScript', '', ''),
  (1108, 'en_US', 'Modules - at the top', '', ''),
  (1109, 'en_US', 'Modules - bottom', '', ''),
  (1110, 'en_US', 'Modules - JavaScript', '', ''),
  (1111, 'en_US', 'Languages - at the top', '', ''),
  (1112, 'en_US', 'Languages - bottom', '', ''),
  (1113, 'en_US', 'Language - create form', '', ''),
  (1114, 'en_US', 'Languages - delete form', '', ''),
  (1115, 'en_US', 'Languages - JavaScript', '', ''),
  (1116, 'en_US', 'Zone - delete form', '', ''),
  (1117, 'en_US', 'Delivery zone - Edit JavaScript', '', ''),
  (1118, 'en_US', 'System - logs JavaScript', '', ''),
  (1119, 'en_US', 'Search - at the top', '', ''),
  (1120, 'en_US', 'Search - bottom', '', ''),
  (1121, 'en_US', 'Search - JavaScript', '', ''),
  (1122, 'en_US', 'Administrators - at the top', '', ''),
  (1123, 'en_US', 'Administrators - bottom', '', ''),
  (1124, 'en_US', 'Administrator - create form', '', ''),
  (1125, 'en_US', 'Administrator - update form', '', ''),
  (1126, 'en_US', 'Administrator - delete form', '', ''),
  (1127, 'en_US', 'Administrators - JavaScript', '', ''),
  (1128, 'en_US', 'Module hook - Edit JavaScript', '', ''),
  (1129, 'en_US', 'Shipping configuration - at the top', '', ''),
  (1130, 'en_US', 'Shipping configuration - table header', '', ''),
  (1131, 'en_US', 'Shipping configuration - table row', '', ''),
  (1132, 'en_US', 'Shipping configuration - bottom', '', ''),
  (1133, 'en_US', 'Shipping configuration - create form', '', ''),
  (1134, 'en_US', 'Shipping configuration - delete form', '', ''),
  (1135, 'en_US', 'Shipping configuration - JavaScript', '', ''),
  (1136, 'en_US', 'Features - at the top', '', ''),
  (1137, 'en_US', 'Features - table header', '', ''),
  (1138, 'en_US', 'Features - table row', '', ''),
  (1139, 'en_US', 'Features - bottom', '', ''),
  (1140, 'en_US', 'Feature - create form', '', ''),
  (1141, 'en_US', 'Feature - delete form', '', ''),
  (1142, 'en_US', 'Feature - add to all form', '', ''),
  (1143, 'en_US', 'Feature - remove to all form', '', ''),
  (1144, 'en_US', 'Features - JavaScript', '', ''),
  (1145, 'en_US', 'Module - Edit JavaScript', '', ''),
  (1146, 'en_US', 'Module hook - create form', '', ''),
  (1147, 'en_US', 'Module hook - delete form', '', ''),
  (1148, 'en_US', 'Module hook - JavaScript', '', ''),
  (1149, 'en_US', 'Shipping configuration - Edit', '', ''),
  (1150, 'en_US', 'Shipping configuration - country delete form', '', ''),
  (1151, 'en_US', 'Shipping configuration - Edit JavaScript', '', ''),
  (1152, 'en_US', 'Mailing system - at the top', '', ''),
  (1153, 'en_US', 'Mailing system - bottom', '', ''),
  (1154, 'en_US', 'Mailing system - JavaScript', '', ''),
  (1155, 'en_US', 'Categories - at the top', '', ''),
  (1156, 'en_US', 'Categories - caption', '', ''),
  (1157, 'en_US', 'Categories - header', '', ''),
  (1158, 'en_US', 'Categories - row', '', ''),
  (1159, 'en_US', 'Products - caption', '', ''),
  (1160, 'en_US', 'Products - header', '', ''),
  (1161, 'en_US', 'Products - row', '', ''),
  (1162, 'en_US', 'Categories - bottom', '', ''),
  (1163, 'en_US', 'Categories - at the bottom of the catalog', '', ''),
  (1164, 'en_US', 'Category - create form', '', ''),
  (1165, 'en_US', 'Product - create form', '', ''),
  (1166, 'en_US', 'Category - delete form', '', ''),
  (1167, 'en_US', 'Product - delete form', '', ''),
  (1168, 'en_US', 'Categories - JavaScript', '', ''),
  (1169, 'en_US', 'Variables - at the top', '', ''),
  (1170, 'en_US', 'Variables - table header', '', ''),
  (1171, 'en_US', 'Variables - table row', '', ''),
  (1172, 'en_US', 'Variables - bottom', '', ''),
  (1173, 'en_US', 'Variable - create form', '', ''),
  (1174, 'en_US', 'Variable - delete form', '', ''),
  (1175, 'en_US', 'Variables - JavaScript', '', ''),
  (1176, 'en_US', 'Order - product list', '', ''),
  (1177, 'en_US', 'Order - Edit JavaScript', '', ''),
  (1178, 'en_US', 'Store Information - JavaScript', '', ''),
  (1179, 'en_US', 'Translations - JavaScript', '', ''),
  (1180, 'en_US', 'Folder - at the top', '', ''),
  (1181, 'en_US', 'Folder - caption', '', ''),
  (1182, 'en_US', 'Folder - header', '', ''),
  (1183, 'en_US', 'Folder - row', '', ''),
  (1184, 'en_US', 'Contents - caption', '', ''),
  (1185, 'en_US', 'Contents - header', '', ''),
  (1186, 'en_US', 'Contents - row', '', ''),
  (1187, 'en_US', 'Folder - bottom', '', ''),
  (1188, 'en_US', 'Folder - create form', '', ''),
  (1189, 'en_US', 'Content - create form', '', ''),
  (1190, 'en_US', 'Folder - delete form', '', ''),
  (1191, 'en_US', 'Content - delete form', '', ''),
  (1192, 'en_US', 'Folder - JavaScript', '', ''),
  (1193, 'en_US', 'Template - Edit JavaScript', '', ''),
  (1194, 'en_US', 'Tax - Edit JavaScript', '', ''),
  (1195, 'en_US', 'Hook - Edit JavaScript', '', ''),
  (1196, 'en_US', 'Countries - at the top', '', ''),
  (1197, 'en_US', 'Countries - table header', '', ''),
  (1198, 'en_US', 'Countries - table row', '', ''),
  (1199, 'en_US', 'Countries - bottom', '', ''),
  (1200, 'en_US', 'Country - create form', '', ''),
  (1201, 'en_US', 'Country - delete form', '', ''),
  (1202, 'en_US', 'Countries - JavaScript', '', ''),
  (1203, 'en_US', 'Currencies - at the top', '', ''),
  (1204, 'en_US', 'Currencies - table header', '', ''),
  (1205, 'en_US', 'Currencies - table row', '', ''),
  (1206, 'en_US', 'Currencies - bottom', '', ''),
  (1207, 'en_US', 'Currency - create form', '', ''),
  (1208, 'en_US', 'Currency - delete form', '', ''),
  (1209, 'en_US', 'Currencies - JavaScript', '', ''),
  (1210, 'en_US', 'Customer - Edit', '', ''),
  (1211, 'en_US', 'Customer - address create form', '', ''),
  (1212, 'en_US', 'Customer - address update form', '', ''),
  (1213, 'en_US', 'Customer - address delete form', '', ''),
  (1214, 'en_US', 'Customer - Edit JavaScript', '', ''),
  (1215, 'en_US', 'Attributes value - table header', '', ''),
  (1216, 'en_US', 'Attributes value - table row', '', ''),
  (1217, 'en_US', 'Attribute value - create form', '', ''),
  (1218, 'en_US', 'Attribut - id delete form', '', ''),
  (1219, 'en_US', 'Attribut - Edit JavaScript', '', ''),
  (1220, 'en_US', 'Profiles - at the top', '', ''),
  (1221, 'en_US', 'Profiles - bottom', '', ''),
  (1222, 'en_US', 'Profile - create form', '', ''),
  (1223, 'en_US', 'Profile - delete form', '', ''),
  (1224, 'en_US', 'Profiles - JavaScript', '', ''),
  (1225, 'en_US', 'Country - Edit JavaScript', '', ''),
  (1226, 'en_US', 'Profile - Edit JavaScript', '', ''),
  (1227, 'en_US', 'Variable - Edit JavaScript', '', ''),
  (1228, 'en_US', 'Coupon - update JavaScript', '', ''),
  (1229, 'en_US', 'Coupon - at the top', '', ''),
  (1230, 'en_US', 'Coupon - list caption', '', ''),
  (1231, 'en_US', 'Coupon - table header', '', ''),
  (1232, 'en_US', 'Coupon - table row', '', ''),
  (1233, 'en_US', 'Coupon - bottom', '', ''),
  (1234, 'en_US', 'Coupon - list JavaScript', '', ''),
  (1235, 'en_US', 'Module - configuration', '', ''),
  (1236, 'en_US', 'Module - configuration JavaScript', '', ''),
  (1237, 'en_US', 'Message - Edit JavaScript', '', ''),
  (1238, 'en_US', 'Image - Edit JavaScript', '', ''),
  (1239, 'en_US', 'Attributes - at the top', '', ''),
  (1240, 'en_US', 'Attributes - table header', '', ''),
  (1241, 'en_US', 'Attributes - table row', '', ''),
  (1242, 'en_US', 'Attributes - bottom', '', ''),
  (1243, 'en_US', 'Attribut - create form', '', ''),
  (1244, 'en_US', 'Attribut - delete form', '', ''),
  (1245, 'en_US', 'Attribut - add to all form', '', ''),
  (1246, 'en_US', 'Attribut - remove to all form', '', ''),
  (1247, 'en_US', 'Attributes - JavaScript', '', ''),
  (1248, 'en_US', 'Logs - at the top', '', ''),
  (1249, 'en_US', 'Logs - bottom', '', ''),
  (1250, 'en_US', 'Logs - JavaScript', '', ''),
  (1251, 'en_US', 'Folder - Edit JavaScript', '', ''),
  (1252, 'en_US', 'Hooks - at the top', '', ''),
  (1253, 'en_US', 'Hooks - table header', '', ''),
  (1254, 'en_US', 'Hooks - table row', '', ''),
  (1255, 'en_US', 'Hooks - bottom', '', ''),
  (1256, 'en_US', 'Hook - create form', '', ''),
  (1257, 'en_US', 'Hook - delete form', '', ''),
  (1258, 'en_US', 'Hooks - JavaScript', '', ''),
  (1259, 'en_US', 'Layout - CSS', '', ''),
  (1260, 'en_US', 'Layout - before topbar', '', ''),
  (1261, 'en_US', 'Layout - inside top bar', '', ''),
  (1262, 'en_US', 'Layout - after top bar', '', ''),
  (1263, 'en_US', 'Layout - before top menu', '', ''),
  (1264, 'en_US', 'Layout - in top menu items', '', ''),
  (1265, 'en_US', 'Layout - after top menu', '', ''),
  (1266, 'en_US', 'Layout - before footer', '', ''),
  (1267, 'en_US', 'Layout - in footer', '', ''),
  (1268, 'en_US', 'Layout - after footer', '', ''),
  (1269, 'en_US', 'Layout - JavaScript', '', ''),
  (1270, 'en_US', 'Layout - at the top of the top bar', '', ''),
  (1271, 'en_US', 'Layout - at the bottom of the top bar', '', ''),
  (1272, 'en_US', 'Layout - in the menu customers', '', ''),
  (1273, 'en_US', 'Layout - in the menu orders', '', ''),
  (1274, 'en_US', 'Layout - in the menu catalog', '', ''),
  (1275, 'en_US', 'Layout - in the menu folders', '', ''),
  (1276, 'en_US', 'Layout - in the menu tools', '', ''),
  (1277, 'en_US', 'Layout - in the menu modules', '', ''),
  (1278, 'en_US', 'Layout - in the menu configuration', '', ''),
  (1279, 'en_US', 'Brand - Edit JavaScript', '', ''),
  (1280, 'en_US', 'Home - block', '', ''),
  (1281, 'en_US', 'Brands - at the top', '', ''),
  (1282, 'en_US', 'Brands - table header', '', ''),
  (1283, 'en_US', 'Brands - table row', '', ''),
  (1284, 'en_US', 'Brands - bottom', '', ''),
  (1285, 'en_US', 'Brand - create form', '', ''),
  (1286, 'en_US', 'Brand - delete form', '', ''),
  (1287, 'en_US', 'Brand - JavaScript', '', ''),
  (1288, 'en_US', 'Exports - at the top', '', ''),
  (1289, 'en_US', 'Exports - at the bottom of a category', '', ''),
  (1290, 'en_US', 'Exports - at the bottom of column 1', '', ''),
  (1291, 'en_US', 'Exports - JavaScript', '', ''),
  (1292, 'en_US', 'Export - JavaScript', '', ''),
  (1293, 'en_US', 'Brand - content', '', ''),
  (1294, 'en_US', 'Customer - order table header', '', ''),
  (1295, 'en_US', 'Customer - order table row', '', ''),

  (2001, 'en_US', 'Invoice - CSS', '', ''),
  (2002, 'en_US', 'Invoice - in the header', '', ''),
  (2003, 'en_US', 'Invoice - at the top of the footer', '', ''),
  (2004, 'en_US', 'Invoice - imprint', '', ''),
  (2005, 'en_US', 'Invoice - at the bottom of the footer', '', ''),
  (2006, 'en_US', 'Invoice - at the bottom of information area', '', ''),
  (2007, 'en_US', 'Invoice - after the information area', '', ''),
  (2008, 'en_US', 'Invoice - delivery address', '', ''),
  (2009, 'en_US', 'Invoice - after addresse area', '', ''),
  (2010, 'en_US', 'Invoice - after product listing', '', ''),
  (2011, 'en_US', 'Invoice - after the order summary', '', ''),
  (2012, 'en_US', 'Delivery - CSS', '', ''),
  (2013, 'en_US', 'Delivery - in the header', '', ''),
  (2014, 'en_US', 'Delivery - at the top of the footer', '', ''),
  (2015, 'en_US', 'Delivery - imprint', '', ''),
  (2016, 'en_US', 'Delivery - at the bottom of the footer', '', ''),
  (2017, 'en_US', 'Delivery - at the bottom of information area', '', ''),
  (2018, 'en_US', 'Delivery - after the information area', '', ''),
  (2019, 'en_US', 'Delivery - delivery address', '', ''),
  (2020, 'en_US', 'Delivery - after addresse area', '', ''),
  (2021, 'en_US', 'Delivery - after the order summary', '', ''),

  (2022, 'en_US', 'Order confirmation - after the order summary', '', ''),

  (2023, 'en_US', 'Where the WYSIWYG editor is required', '', ''),
  (1, 'es_ES', 'Opción de factura - en la parte superior', '', ''),
  (2, 'es_ES', 'Opción de factura - dirección de envío', '', ''),
  (3, 'es_ES', 'Opción de factura - zona de pago extra', '', ''),
  (4, 'es_ES', 'Opción de factura - en la parte inferior de la factura', '', ''),
  (5, 'es_ES', 'Opción de factura - después de la inicialización de javascript', '', ''),
  (6, 'es_ES', 'Opción de factura - hoja de estilos CSS', '', ''),
  (7, 'es_ES', 'Opción de factura - después de incluir javascript', '', ''),
  (8, 'es_ES', 'Pasarela de pago - área principal', '', ''),
  (9, 'es_ES', 'Pasarela de pago - JavaScript', '', ''),
  (10, 'es_ES', 'Pasarela de pago - después de inicializar JavaScript', '', ''),
  (11, 'es_ES', 'Pasarela de pago - Hoja de estilos CSS', '', ''),
  (12, 'es_ES', 'Pasarela de pago - después de incluir JavaScript', '', ''),
  (13, 'es_ES', 'Mapa de sitio - en la base', '', ''),
  (14, 'es_ES', 'Página de selección de divisa - en la parte superior', '', ''),
  (15, 'es_ES', 'Página de selección de divisa - en la parte inferior', '', ''),
  (16, 'es_ES', 'Página de selección de divisa - hoja de estilos CSS', '', ''),
  (17, 'es_ES', 'Página de selección de divisa - después de inclusión javascript', '', ''),
  (18, 'es_ES', 'Página de selección de divisa - después de la inicialización de javascript', '', ''),
  (19, 'es_ES', 'Página de inicio de sesión - en la parte superior', '', ''),
  (20, 'es_ES', 'Página de inicio de sesión - en la parte superior del área principal', '', ''),
  (21, 'es_ES', 'Página de inicio de sesión - en la parte superior del formulario', '', ''),
  (22, 'es_ES', 'Página de inicio de sesión - en la parte inferior del formulario', '', ''),
  (23, 'es_ES', 'Página de inicio de sesión - en la parte inferior del área principal', '', ''),
  (24, 'es_ES', 'Página de inicio de sesión - en la parte inferior', '', ''),
  (25, 'es_ES', 'Página de inicio de sesión - hoja de estilos CSS', '', ''),
  (26, 'es_ES', 'Página de inicio de sesión - después de incluir JavaScript', '', ''),
  (27, 'es_ES', 'Página de inicio de sesión - después de la inicialización de JavaScript', '', ''),
  (28, 'es_ES', 'Actualización de cuenta de cliente - encabezado', '', ''),
  (29, 'es_ES', 'Actualización de cuenta de cliente - encabezado del formulario', '', ''),
  (30, 'es_ES', 'Actualización de cuenta de cliente - al pie del formulario', '', ''),
  (31, 'es_ES', 'Actualización de cuenta de cliente - al pie', '', ''),
  (32, 'es_ES', 'Actualización de cuenta del cliente - Hoja de estilos CSS', '', ''),
  (33, 'es_ES', 'Actualización de cuenta del cliente - después de incluir JavaScript', '', ''),
  (34, 'es_ES', 'Actualización de cuenta de cliente - después de inicializar JavaScript', '', ''),
  (35, 'es_ES', 'Carrito - En la parte superior', '', ''),
  (36, 'es_ES', 'Carrito - En la parte inferior', '', ''),
  (37, 'es_ES', 'Carro - después de inclusión javascript', '', ''),
  (38, 'es_ES', 'Carrito - hoja de estilos CSS', '', ''),
  (39, 'es_ES', 'Carro - inicialización de javascript', '', ''),
  (40, 'es_ES', 'Página de contacto - en la parte superior', '', ''),
  (41, 'es_ES', 'Página de contacto - en la parte superior del formulario', '', ''),
  (42, 'es_ES', 'Página de contacto - en la parte inferior del formulario', '', ''),
  (43, 'es_ES', 'Página de contacto - en la parte inferior', '', ''),
  (44, 'es_ES', 'Página de contacto - hoja de estilos CSS', '', ''),
  (45, 'es_ES', 'Página de contacto - después del include de javascript', '', ''),
  (46, 'es_ES', 'Página de contacto - después de la inicialización de javascript', '', ''),
  (47, 'es_ES', 'Orden registrada - área principal', '', ''),
  (48, 'es_ES', 'Orden registrada - Hoja de estilo CSS', '', ''),
  (49, 'es_ES', 'Orden registrada - después del javascript include', '', ''),
  (50, 'es_ES', 'Orden registrada - después de la inicialización de Javascript', '', ''),
  (51, 'es_ES', 'Página de búsqueda - Hoja de Estilos en Cascada', '', ''),
  (52, 'es_ES', 'Página de búsqueda - después de incluir JavaScript', '', ''),
  (53, 'es_ES', 'Página de búsqueda - después de inicializar JavaScript', '', ''),
  (54, 'es_ES', 'Registro - en la parte superior', '', ''),
  (55, 'es_ES', 'Registro - en la parte superior del formulario', '', ''),
  (56, 'es_ES', 'Registro - en la parte inferior del formulario', '', ''),
  (57, 'es_ES', 'Registro - en la parte inferior', '', ''),
  (58, 'es_ES', 'Registro - hoja de estilos CSS', '', ''),
  (59, 'es_ES', 'Registro - después de incluir JavaScript', '', ''),
  (60, 'es_ES', 'Registro - después de la inicialización de JavaScript', '', ''),
  (61, 'es_ES', 'Contraseña perdida - en la parte superior', '', ''),
  (62, 'es_ES', 'Contraseña perdida - en la parte superior del formulario', '', ''),
  (63, 'es_ES', 'Contraseña perdida - en la parte inferior del formulario', '', ''),
  (64, 'es_ES', 'Contraseña perdida - en la parte inferior', '', ''),
  (65, 'es_ES', 'Contraseña perdida - hoja de estilos CSS', '', ''),
  (66, 'es_ES', 'Contraseña perdida - después de incluir javascript', '', ''),
  (67, 'es_ES', 'Contraseña perdida - inicialización de JavaScript', '', ''),
  (68, 'es_ES', 'página de selección de idioma - en la parte superior', '', ''),
  (69, 'es_ES', 'página de selección de idioma - en la parte inferior', '', ''),
  (70, 'es_ES', 'página de selección de idioma - hoja de estilos CSS', '', ''),
  (71, 'es_ES', 'página de selección de idioma - después de incluir JavaScript', '', ''),
  (72, 'es_ES', 'página de selección de idioma - después de la inicialización de JavaScript', '', ''),
  (73, 'es_ES', 'Página de contacto - si la respuesta es exitosa', '', ''),
  (74, 'es_ES', 'Página del boletín de noticias - en la parte superior', '', ''),
  (75, 'es_ES', 'Página del boletín de noticias - en la parte inferior', '', ''),
  (76, 'es_ES', 'Página del boletín de noticias - hoja de estilos CSS', '', ''),
  (77, 'es_ES', 'Página del boletín de noticias - después de incluir JavaScript', '', ''),
  (78, 'es_ES', 'Página del boletín de noticias - después de la inicialización de JavaScript', '', ''),
  (79, 'es_ES', 'Pago erróneo - Hoja de Estilos CSS', '', ''),
  (80, 'es_ES', 'Pago erróneo - después de incluir JavaScript', '', ''),
  (81, 'es_ES', 'Pago erróneo - inicialización de JavaScript', '', ''),
  (82, 'es_ES', 'Página de contacto - en la parte superior', '', ''),
  (83, 'es_ES', 'Página de contenido - en la parte superior de la zona principal', '', ''),
  (84, 'es_ES', 'Página de contenido - en la parte inferior de la zona principal', '', ''),
  (85, 'es_ES', 'Página de contacto - en la parte inferior', '', ''),
  (86, 'es_ES', 'Página de contacto - hoja de estilos CSS', '', ''),
  (87, 'es_ES', 'Página de contacto - después del include de javascript', '', ''),
  (88, 'es_ES', 'Página de contacto - después de la inicialización de javascript', '', ''),
  (89, 'es_ES', 'Diseño HTML - después de la etiqueta head de apertura', '', ''),
  (90, 'es_ES', 'Diseño HTML - hojas de estilo CSS', '', ''),
  (91, 'es_ES', 'Diseño HTML - antes de la etiqueta head de cierre', '', ''),
  (92, 'es_ES', 'Diseño HTML - después de la etiqueta body de apertura', '', ''),
  (93, 'es_ES', 'Diseño HTML - en la parte superior de la cabecera', '', ''),
  (94, 'es_ES', 'Diseño HTML - navegación secundaria', '', ''),
  (95, 'es_ES', 'Diseño HTML - navegación principal', '', ''),
  (96, 'es_ES', 'Diseño HTML - en la parte inferior de la cabecera', '', ''),
  (97, 'es_ES', 'Diseño HTML - antes el área de contenido principal', '', ''),
  (98, 'es_ES', 'Diseño HTML - después del área de contenido principal', '', ''),
  (99, 'es_ES', 'Diseño HTML - en la parte superior del pie de página', '', ''),
  (100, 'es_ES', 'Diseño HTML - cuerpo del pie de página', '', ''),
  (101, 'es_ES', 'Diseño HTML - parte inferior del pie de página', '', ''),
  (102, 'es_ES', 'Diseño HTML - después de incluir javascript', '', ''),
  (103, 'es_ES', 'Diseño HTML - inicialización de JavaScript', '', ''),
  (104, 'es_ES', 'Diseño HTML - antes de la etiqueta body de cierre', '', ''),
  (105, 'es_ES', 'Página 404 - área de contenido', '', ''),
  (106, 'es_ES', 'Página 404 - CSS Hoja de estilos', '', ''),
  (107, 'es_ES', 'Página 404 - después de incluir JavaScript', '', ''),
  (108, 'es_ES', 'Página 404 - después de inicializar JavaScript', '', ''),
  (109, 'es_ES', 'Opción de entrega - en la cabecera', '', ''),
  (110, 'es_ES', 'Opción de entrega - en la cabecera del formulario', '', ''),
  (111, 'es_ES', 'Opción de entrega - en el pie del formulario', '', ''),
  (112, 'es_ES', 'Elección de entrega - en el pie', '', ''),
  (113, 'es_ES', 'Opción de entrega - despues de inicializar el javascript', '', ''),
  (114, 'es_ES', 'Opción de entrega - CSS', '', ''),
  (115, 'es_ES', 'Opción de entrega - después de incluir el javascript', '', ''),
  (116, 'es_ES', 'Creación de dirección - en la parte superior', '', ''),
  (117, 'es_ES', 'Creación de dirección - en la parte superior del formulario', '', ''),
  (118, 'es_ES', 'Creación de dirección - en la parte inferior del formulario', '', ''),
  (119, 'es_ES', 'Creación de dirección - en la parte inferior', '', ''),
  (120, 'es_ES', 'Creación de dirección - hoja de estilos CSS', '', ''),
  (121, 'es_ES', 'Creación de dirección- después del include javascript', '', ''),
  (122, 'es_ES', 'Creación de dirección - después de la inicialización de javascript', '', ''),
  (123, 'es_ES', 'Carpeta de página - en la parte superior', '', ''),
  (124, 'es_ES', 'Carpeta de página - en la parte superior del área principal', '', ''),
  (125, 'es_ES', 'Carpeta de página - al final del área principal', '', ''),
  (126, 'es_ES', 'Carpeta de página - al final', '', ''),
  (127, 'es_ES', 'Página de la carpeta - hoja de estilos CSS', '', ''),
  (128, 'es_ES', 'Carpeta de página - después de incluir JavaScript', '', ''),
  (129, 'es_ES', 'Carpeta de página - después de inicialización de JavaScript', '', ''),
  (130, 'es_ES', 'Pedido erróneo - al tope', '', ''),
  (131, 'es_ES', 'Pedido erróneo - al pie', '', ''),
  (132, 'es_ES', 'Pedido erróneo - Hoja de Estilos CSS', '', ''),
  (133, 'es_ES', 'Pedido erróneo - después de incluir JavaScript', '', ''),
  (134, 'es_ES', 'Pedido erróneo - después de la inicialización de JavaScript', '', ''),
  (135, 'es_ES', 'Página de la categoría - en la parte superior', '', ''),
  (136, 'es_ES', 'Página de categoría - en la parte superior de la zona principal', '', ''),
  (137, 'es_ES', 'Página de la categoría - en la parte inferior de la zona principal', '', ''),
  (138, 'es_ES', 'Página de la categoría - en la parte inferior', '', ''),
  (139, 'es_ES', 'Página de la categoría - hoja de estilos CSS', '', ''),
  (140, 'es_ES', 'Página de la categoría - después de inclusión javascript', '', ''),
  (141, 'es_ES', 'Página de la categoría - después de la inicialización de javascript', '', ''),
  (142, 'es_ES', 'Actualizar dirección - en la parte superior', '', ''),
  (143, 'es_ES', 'Actualizar dirección - en la parte superior del formulario', '', ''),
  (144, 'es_ES', 'Actualización de dirección - en la parte inferior del formulario', '', ''),
  (145, 'es_ES', 'Actualización de dirección - en la parte inferior', '', ''),
  (146, 'es_ES', 'Actualización de dirección - hoja de estilos CSS', '', ''),
  (147, 'es_ES', 'Actualización de dirección - tras el include javascript', '', ''),
  (148, 'es_ES', 'Actualización de dirección - después de la inicialización de javascript', '', ''),
  (149, 'es_ES', 'Página de inicio - Área Principal', '', ''),
  (150, 'es_ES', 'Página de inicio - hoja de estilos CSS', '', ''),
  (151, 'es_ES', 'Página de inicio - después de incluir JavaScript', '', ''),
  (152, 'es_ES', 'Página de inicio - después de la inicialización de JavaScript', '', ''),
  (153, 'es_ES', 'Cambiar contraseña - en la parte superior', '', ''),
  (154, 'es_ES', 'Cambiar contraseña - en la parte inferior', '', ''),
  (155, 'es_ES', 'Cambiar contraseña - hoja de estilos CSS', '', ''),
  (156, 'es_ES', 'Cambiar contraseña - después de inclusión javascript', '', ''),
  (157, 'es_ES', 'Cambiar contraseña - después de la inicialización de javascript', '', ''),
  (158, 'es_ES', 'Página de producto - en la parte superior', '', ''),
  (159, 'es_ES', 'Página de producto - Galería de fotos', '', ''),
  (160, 'es_ES', 'Página de producto - en la parte superior del detalle', '', ''),
  (161, 'es_ES', 'Página de producto - en la parte inferior del área de detalle', '', ''),
  (162, 'es_ES', 'Página de producto - información adicional', '', ''),
  (163, 'es_ES', 'Página de producto - en la parte inferior', '', ''),
  (164, 'es_ES', 'Página de producto - hoja de estilos CSS', '', ''),
  (165, 'es_ES', 'Página de producto - después de incluir JavaScript', '', ''),
  (166, 'es_ES', 'Página de producto - después de la inicialización de Javascript', '', ''),
  (167, 'es_ES', 'cuenta de cliente - en la parte superior', '', ''),
  (168, 'es_ES', 'cuenta de cliente - en la parte inferior', '', ''),
  (169, 'es_ES', 'cuenta de cliente - hoja de estilos CSS', '', ''),
  (170, 'es_ES', 'cuenta de cliente - después de incluir JavaScript', '', ''),
  (171, 'es_ES', 'cuenta de cliente - después de la inicialización de JavaScript', '', ''),
  (172, 'es_ES', 'Todos los productos - en la parte superior', '', ''),
  (173, 'es_ES', 'Todos los productos - en la parte inferior', '', ''),
  (174, 'es_ES', 'Todos los productos - hoja de estilos CSS', '', ''),
  (175, 'es_ES', 'Todos los productos - después de include javascript', '', ''),
  (176, 'es_ES', 'Todos los productos - después de la inicialización de javascript', '', ''),
  (177, 'es_ES', 'Ciclo del producto - en la parte superior', '', ''),
  (178, 'es_ES', 'Ciclo del producto - en la parte inferior', '', ''),
  (179, 'es_ES', 'Página de categoría - en la parte inferior de la barra lateral', '', ''),
  (180, 'es_ES', 'Página de categoría - el cuerpo de la barra lateral', '', ''),
  (181, 'es_ES', 'Página de la categoría - en la parte inferior de la barra lateral', '', ''),
  (182, 'es_ES', 'Página de contenido - en la parte superior de la barra lateral', '', ''),
  (183, 'es_ES', 'Página de contenido - cuerpo de la barra lateral', '', ''),
  (184, 'es_ES', 'Página de contenido - en la parte inferior de la barra lateral', '', ''),
  (185, 'es_ES', 'Opción de entrega - área extra', '', ''),
  (186, 'es_ES', 'Opción de entrega - javascript', '', ''),
  (1000, 'es_ES', 'Categoría - contenido', '', ''),
  (1001, 'es_ES', 'Contenido - contenido', '', ''),
  (1002, 'es_ES', 'Carpeta - contenido', '', ''),
  (1003, 'es_ES', 'Orden - contenido', '', ''),
  (1004, 'es_ES', 'Producto - contenido', '', ''),
  (1005, 'es_ES', 'Valor Característica - encabezado de tabla', '', ''),
  (1006, 'es_ES', 'Valor Característica - fila de tabla', '', ''),
  (1007, 'es_ES', 'Característica - Formulario para crear valor', '', ''),
  (1008, 'es_ES', 'Característica - Editar JavaScript', '', ''),
  (1009, 'es_ES', 'Producto - Editar JavaScript', '', ''),
  (1010, 'es_ES', 'Cupón - crear JavaScript', '', ''),
  (1011, 'es_ES', 'Impuestos - formulario de actualización', '', ''),
  (1012, 'es_ES', 'regla de impuesto - Editar JavaScript', '', ''),
  (1013, 'es_ES', 'Herramientas - en la parte superior', '', ''),
  (1014, 'es_ES', 'Herramientas - en la parte superior de la columna', '', ''),
  (1015, 'es_ES', 'Herramientas - en la parte inferior de la columna 1', '', ''),
  (1016, 'es_ES', 'Herramientas - parte inferior', '', ''),
  (1017, 'es_ES', 'Herramientas - JavaScript', '', ''),
  (1018, 'es_ES', 'Mensajes - al tope', '', ''),
  (1019, 'es_ES', 'Mensajes - encabezado de la tabla', '', ''),
  (1020, 'es_ES', 'Mensajes - fila de la tabla', '', ''),
  (1021, 'es_ES', 'Mensajes - base', '', ''),
  (1022, 'es_ES', 'Mensaje - formulario de creación', '', ''),
  (1023, 'es_ES', 'Mensaje - formulario de borrado', '', ''),
  (1024, 'es_ES', 'Mensajes - JavaScript', '', ''),
  (1025, 'es_ES', 'Reglas de impuestos - en la parte superior', '', ''),
  (1026, 'es_ES', 'Reglas de impuestos - parte inferior', '', ''),
  (1027, 'es_ES', 'Impuesto - formulario de creación', '', ''),
  (1028, 'es_ES', 'Impuesto - formulario de borrado', '', ''),
  (1029, 'es_ES', 'regla de impuesto - formulario de creación', '', ''),
  (1030, 'es_ES', 'regla de impuesto - formulario de borrado', '', ''),
  (1031, 'es_ES', 'Reglas de impuestos - JavaScript', '', ''),
  (1032, 'es_ES', 'Exportar - en la parte superior', '', ''),
  (1033, 'es_ES', 'Exportar - en la parte inferior de una categoría', '', ''),
  (1034, 'es_ES', 'Exportar - en la parte inferior de la columna 1', '', ''),
  (1035, 'es_ES', 'Exportar JavaScript', '', ''),
  (1036, 'es_ES', 'Exportación - JavaScript', '', ''),
  (1037, 'es_ES', 'Producto - encabezado de la tabla de carpetas', '', ''),
  (1038, 'es_ES', 'Producto - fila de la tabla de carpetas', '', ''),
  (1039, 'es_ES', 'Producto - formato de detalles del precio', '', ''),
  (1040, 'es_ES', 'Producto - Editar formulario de stock', '', ''),
  (1041, 'es_ES', 'Producto - formulario de detalles de la promoción', '', ''),
  (1042, 'es_ES', 'Producto - después de las combinaciones', '', ''),
  (1043, 'es_ES', 'Producto - título de la lista de combinaciones', '', ''),
  (1044, 'es_ES', 'Producto - después de las combinaciones', '', ''),
  (1045, 'es_ES', 'Producto - Formulario para borrar combinaciones', '', ''),
  (1046, 'es_ES', 'Módulos - encabezado de la tabla', '', ''),
  (1047, 'es_ES', 'Módulos - fila de la tabla', '', ''),
  (1048, 'es_ES', 'Divisas - Editar javaScript', '', ''),
  (1049, 'es_ES', 'Categoría - encabezado de tabla de contenido', '', ''),
  (1050, 'es_ES', 'Categoría - fila de la tabla de contenido', '', ''),
  (1051, 'es_ES', 'Categoría - edición JavaScript', '', ''),
  (1052, 'es_ES', 'Documento - edición JavaScript', '', ''),
  (1053, 'es_ES', 'Cliente - en la cabecera', '', ''),
  (1054, 'es_ES', 'Clientes - texto', '', ''),
  (1055, 'es_ES', 'Clientes - encabezado', '', ''),
  (1056, 'es_ES', 'Clientes - fila', '', ''),
  (1057, 'es_ES', 'Cliente - pie', '', ''),
  (1058, 'es_ES', 'Cliente - formulario creación', '', ''),
  (1059, 'es_ES', 'Cliente - formulario eliminación', '', ''),
  (1060, 'es_ES', 'Clientes - JavaScript', '', ''),
  (1061, 'es_ES', 'Producto - contenidos del encabezado de tabla', '', ''),
  (1062, 'es_ES', 'Producto - contenidos de la fila de la tabla', '', ''),
  (1063, 'es_ES', 'Producto - encabezado de la tabla accesoria', '', ''),
  (1064, 'es_ES', 'Producto - fila de la tabla de accesorios', '', ''),
  (1065, 'es_ES', 'Producto - encabezado de la tabla de categorías', '', ''),
  (1066, 'es_ES', 'Producto - fila de la tabla de categorías', '', ''),
  (1067, 'es_ES', 'Producto - encabezado de la tabla de atributos', '', ''),
  (1068, 'es_ES', 'Producto - fila de la tabla de atributos', '', ''),
  (1069, 'es_ES', 'Producto - encabezado de la tabla de características', '', ''),
  (1070, 'es_ES', 'Producto - fila de la tabla de características', '', ''),
  (1071, 'es_ES', 'Plantilla - cabecera de la tabla de atributos', '', ''),
  (1072, 'es_ES', 'Plantilla - fila de la tabla de atributos', '', ''),
  (1073, 'es_ES', 'Plantilla - encabezado de tabla de características', '', ''),
  (1074, 'es_ES', 'Plantilla - fila de la tabla de características', '', ''),
  (1075, 'es_ES', 'Plantillas - en la parte superior', '', ''),
  (1076, 'es_ES', 'Plantillas - encabezado de tabla', '', ''),
  (1077, 'es_ES', 'Plantillas - fila de la tabla', '', ''),
  (1078, 'es_ES', 'Plantillas - parte inferior', '', ''),
  (1079, 'es_ES', 'Plantilla - formulario de creación', '', ''),
  (1080, 'es_ES', 'Plantilla - formulario de borrado', '', ''),
  (1081, 'es_ES', 'Plantillas - JavaScript', '', ''),
  (1082, 'es_ES', 'Configuración - en la parte superior', '', ''),
  (1083, 'es_ES', 'Configuración - en la parte superior de la zona de catálogo', '', ''),
  (1084, 'es_ES', 'Configuración - en la parte inferior del catálogo', '', ''),
  (1085, 'es_ES', 'Configuración - en la parte superior del área de envío', '', ''),
  (1086, 'es_ES', 'Configuración - en la parte inferior de la zona de envío', '', ''),
  (1087, 'es_ES', 'Configuración - en la parte superior del área del sistema', '', ''),
  (1088, 'es_ES', 'Configuración - en la parte inferior de la zona del sistema', '', ''),
  (1089, 'es_ES', 'Configuración - parte inferior', '', ''),
  (1090, 'es_ES', 'Configuración - JavaScript', '', ''),
  (1091, 'es_ES', 'Dashboard - en la parte superior', '', ''),
  (1092, 'es_ES', 'Dashboard - medio', '', ''),
  (1093, 'es_ES', 'Dashboard - fondo', '', ''),
  (1094, 'es_ES', 'Pedidos - encabezado', '', ''),
  (1095, 'es_ES', 'Pedidos - encabezado de tabla', '', ''),
  (1096, 'es_ES', 'Pedidos - fila de tabla', '', ''),
  (1097, 'es_ES', 'Pedidos - pie de página', '', ''),
  (1098, 'es_ES', 'Pedidos - JavaScript', '', ''),
  (1099, 'es_ES', 'Zona de entrega - En la cabecera', '', ''),
  (1100, 'es_ES', 'Zona de entrega - en el encabezado de tabla', '', ''),
  (1101, 'es_ES', 'Zona de entrega - en la fila de la tabla', '', ''),
  (1102, 'es_ES', 'Zona de entrega - en el pie', '', ''),
  (1103, 'es_ES', 'Zona de entrega - JavaScript', '', ''),
  (1104, 'es_ES', 'Contenido - Editar JavaScript', '', ''),
  (1105, 'es_ES', 'Inicio - en la parte superior', '', ''),
  (1106, 'es_ES', 'Inicio - fondo', '', ''),
  (1107, 'es_ES', 'Inicio - JavaScript', '', ''),
  (1108, 'es_ES', 'Módulos - al inicio', '', ''),
  (1109, 'es_ES', 'Módulos - base', '', ''),
  (1110, 'es_ES', 'Módulos - JavaScript', '', ''),
  (1111, 'es_ES', 'Idiomas - en la parte superior', '', ''),
  (1112, 'es_ES', 'Idiomas - parte inferior', '', ''),
  (1113, 'es_ES', 'Idioma - formulario de creación', '', ''),
  (1114, 'es_ES', 'Idiomas - Formulario de borrar', '', ''),
  (1115, 'es_ES', 'Idiomas - JavaScript', '', ''),
  (1116, 'es_ES', 'Zona - formulario de borrado', '', ''),
  (1117, 'es_ES', 'Zona de entrega - Editar JavasCript', '', ''),
  (1118, 'es_ES', 'Sistema - registros de JavaScript', '', ''),
  (1119, 'es_ES', 'Búsqueda - al inicio', '', ''),
  (1120, 'es_ES', 'Búsqueda - base', '', ''),
  (1121, 'es_ES', 'Búsqueda - JavaScript', '', ''),
  (1122, 'es_ES', 'Administradores - en la parte superior', '', ''),
  (1123, 'es_ES', 'Administradores - inferior', '', ''),
  (1124, 'es_ES', 'Administrador - formulario de creación', '', ''),
  (1125, 'es_ES', 'Administrador - formulario de actualización', '', ''),
  (1126, 'es_ES', 'Administrador - formulario de eliminación', '', ''),
  (1127, 'es_ES', 'Administradores - JavaScript', '', ''),
  (1128, 'es_ES', NULL, '', ''),
  (1129, 'es_ES', 'Configuración de envío - al inicio', '', ''),
  (1130, 'es_ES', 'Configuración de envío - encabezado de tabla', '', ''),
  (1131, 'es_ES', 'Configuración de envío - fila de tabla', '', ''),
  (1132, 'es_ES', 'Configuración de envío - base', '', ''),
  (1133, 'es_ES', 'Configuración de envío - formulario de creación', '', ''),
  (1134, 'es_ES', 'Configuración de envío - formulario de borrado', '', ''),
  (1135, 'es_ES', 'Configuración de envío - JavaScript', '', ''),
  (1136, 'es_ES', 'Característica - ir arriba', '', ''),
  (1137, 'es_ES', 'Característica - Encabezado de tabla', '', ''),
  (1138, 'es_ES', 'Característica - Fila de tabla', '', ''),
  (1139, 'es_ES', 'Característica - inferior', '', ''),
  (1140, 'es_ES', 'Característica - formulario crear', '', ''),
  (1141, 'es_ES', 'Característica - formulario borrar', '', ''),
  (1142, 'es_ES', 'Característica - Agregar a todos los formularios', '', ''),
  (1143, 'es_ES', 'Característica - eliminar todos los formularios', '', ''),
  (1144, 'es_ES', 'Característica - JavaScript', '', ''),
  (1145, 'es_ES', 'Módulo - Editar JavaScript', '', ''),
  (1146, 'es_ES', NULL, '', ''),
  (1147, 'es_ES', NULL, '', ''),
  (1148, 'es_ES', NULL, '', ''),
  (1149, 'es_ES', 'Configuración de envío - Editar', '', ''),
  (1150, 'es_ES', 'Configuración de envío - formulario de borrado de país', '', ''),
  (1151, 'es_ES', 'Configuración de envío - Editar JavaScript', '', ''),
  (1152, 'es_ES', 'Sistema de correo - en la parte superior', '', ''),
  (1153, 'es_ES', 'Sistema de correo - fondo', '', ''),
  (1154, 'es_ES', 'Sistema de correo - JavaScript', '', ''),
  (1155, 'es_ES', 'Categorías - en la parte superior', '', ''),
  (1156, 'es_ES', 'Categorías - título', '', ''),
  (1157, 'es_ES', 'Categorías - header', '', ''),
  (1158, 'es_ES', 'Categorías - fila', '', ''),
  (1159, 'es_ES', 'Productos - leyenda', '', ''),
  (1160, 'es_ES', 'Productos - encabezado', '', ''),
  (1161, 'es_ES', 'Productos - fila', '', ''),
  (1162, 'es_ES', 'Categorías - inferior', '', ''),
  (1163, 'es_ES', 'Categorías - en la parte inferior del catálogo', '', ''),
  (1164, 'es_ES', 'Formulario de creación de la categoría-', '', ''),
  (1165, 'es_ES', 'Producto - formulario de creación', '', ''),
  (1166, 'es_ES', 'Categoría - formulario de eliminación', '', ''),
  (1167, 'es_ES', 'Producto - formulario de borrado', '', ''),
  (1168, 'es_ES', 'Categorías - JavaScript', '', ''),
  (1169, 'es_ES', 'Variables - en la parte superior', '', ''),
  (1170, 'es_ES', 'Variables - encabezado de tabla', '', ''),
  (1171, 'es_ES', 'Variables - fila de la tabla', '', ''),
  (1172, 'es_ES', 'Variables - parte inferior', '', ''),
  (1173, 'es_ES', 'Variable - formulario de creación', '', ''),
  (1174, 'es_ES', 'Variable - formulario de borrado', '', ''),
  (1175, 'es_ES', 'Variables - JavaScript', '', ''),
  (1176, 'es_ES', 'Orden - lista de productos', '', ''),
  (1177, 'es_ES', 'Orden - editar JavaScript', '', ''),
  (1178, 'es_ES', 'Información de tienda - JavaScript', '', ''),
  (1179, 'es_ES', 'Traducciones - JavaScript', '', ''),
  (1180, 'es_ES', 'Carpeta - ir arriba', '', ''),
  (1181, 'es_ES', 'Carpeta - título', '', ''),
  (1182, 'es_ES', 'Carpeta - encabezado', '', ''),
  (1183, 'es_ES', 'Carpeta - fila', '', ''),
  (1184, 'es_ES', 'Contenido - leyenda', '', ''),
  (1185, 'es_ES', 'Contenido - encabezado', '', ''),
  (1186, 'es_ES', 'Contenido - fila', '', ''),
  (1187, 'es_ES', 'Carpeta - abajo', '', ''),
  (1188, 'es_ES', NULL, '', ''),
  (1189, 'es_ES', 'Contenido - formulario de creación', '', ''),
  (1190, 'es_ES', NULL, '', ''),
  (1191, 'es_ES', 'Contenido - Formulario para eliminar', '', ''),
  (1192, 'es_ES', 'Carpeta - JavaScript', '', ''),
  (1193, 'es_ES', 'Plantilla - editar JavaScript', '', ''),
  (1194, 'es_ES', 'Editar JavaScript', '', ''),
  (1195, 'es_ES', 'Hook - editar JavaScript', '', ''),
  (1196, 'es_ES', 'Países - en la parte superior', '', ''),
  (1197, 'es_ES', 'Países - encabezado de la tabla', '', ''),
  (1198, 'es_ES', 'Países - fila de la tabla', '', ''),
  (1199, 'es_ES', 'Países - parte inferior', '', ''),
  (1200, 'es_ES', 'País - formulario de creación', '', ''),
  (1201, 'es_ES', 'País - formulario para eliminar', '', ''),
  (1202, 'es_ES', 'Países - JavaScript', '', ''),
  (1203, 'es_ES', 'Divisas - en la parte superior', '', ''),
  (1204, 'es_ES', 'Divisas - encabezado de tabla', '', ''),
  (1205, 'es_ES', 'Divisas - fila de tabla', '', ''),
  (1206, 'es_ES', 'Divisas - inferior', '', ''),
  (1207, 'es_ES', 'Divisas - formulario de creación', '', ''),
  (1208, 'es_ES', 'Moneda - Formulario de eliminación', '', ''),
  (1209, 'es_ES', 'Divisas - JavaScript', '', ''),
  (1210, 'es_ES', 'Cliente - Editar', '', ''),
  (1211, 'es_ES', 'Cliente - formulario crear dirección', '', ''),
  (1212, 'es_ES', 'Cliente - formulario de actualización de dirección', '', ''),
  (1213, 'es_ES', 'Cliente - Formulario borrar dirección', '', ''),
  (1214, 'es_ES', 'Cliente - Editar JavaScript', '', ''),
  (1215, 'es_ES', 'Valor de atributos - encabezado de tabla', '', ''),
  (1216, 'es_ES', 'Valor de atributos - fila de la tabla', '', ''),
  (1217, 'es_ES', 'Valor de atributo - formulario de creación', '', ''),
  (1218, 'es_ES', 'Atributo - Formulario de eliminación de id', '', ''),
  (1219, 'es_ES', 'Atributo - editar JavaScript', '', ''),
  (1220, 'es_ES', 'Perfiles - en la parte superior', '', ''),
  (1221, 'es_ES', 'Perfiles - parte inferior', '', ''),
  (1222, 'es_ES', 'Perfil - formulario de alta', '', ''),
  (1223, 'es_ES', 'Perfil - formulario de borrado', '', ''),
  (1224, 'es_ES', 'Perfiles - JavaScript', '', ''),
  (1225, 'es_ES', 'País - editar JavaScript', '', ''),
  (1226, 'es_ES', 'Perfil - editar JavaScript', '', ''),
  (1227, 'es_ES', 'Variable - Editar JavaScript', '', ''),
  (1228, 'es_ES', 'Cupón - actualizar JavaScript', '', ''),
  (1229, 'es_ES', 'Cupón - en la parte superior', '', ''),
  (1230, 'es_ES', 'Cupón - titulo de la lista', '', ''),
  (1231, 'es_ES', 'Cupón - encabezado de tabla', '', ''),
  (1232, 'es_ES', 'Cupón - fila de la tabla', '', ''),
  (1233, 'es_ES', 'Cupón - parte inferior', '', ''),
  (1234, 'es_ES', 'Cupón - enlistar JavaScript', '', ''),
  (1235, 'es_ES', 'Módulo - configuración', '', ''),
  (1236, 'es_ES', 'Módulo - configuración de JavaScript', '', ''),
  (1237, 'es_ES', 'Mensaje - Editar JavaScript', '', ''),
  (1238, 'es_ES', 'Imagen - Editar JavaScript', '', ''),
  (1239, 'es_ES', 'Atributos - en la parte superior', '', ''),
  (1240, 'es_ES', 'Atributos - encabezado de tabla', '', ''),
  (1241, 'es_ES', 'Atributos - fila de la tabla', '', ''),
  (1242, 'es_ES', 'Atributos - inferior', '', ''),
  (1243, 'es_ES', 'Atributo - formulario de creación', '', ''),
  (1244, 'es_ES', 'Atributo - formulario de eliminación', '', ''),
  (1245, 'es_ES', 'Atributo - agregar a todos los formularios', '', ''),
  (1246, 'es_ES', 'Atributo - quitar a todos', '', ''),
  (1247, 'es_ES', 'Atributos - JavaScript', '', ''),
  (1248, 'es_ES', 'Registros - en la parte superior', '', ''),
  (1249, 'es_ES', 'Registros - inferior', '', ''),
  (1250, 'es_ES', 'Registros - JavaScript', '', ''),
  (1251, 'es_ES', 'Carpeta - Editar JavaScript', '', ''),
  (1252, 'es_ES', 'Hooks - en la parte superior', '', ''),
  (1253, 'es_ES', 'Hooks - encabezado de tabla', '', ''),
  (1254, 'es_ES', 'Hooks - fila de la tabla', '', ''),
  (1255, 'es_ES', 'Hooks - inferior', '', ''),
  (1256, 'es_ES', NULL, '', ''),
  (1257, 'es_ES', NULL, '', ''),
  (1258, 'es_ES', 'Hooks - JavaScript', '', ''),
  (1259, 'es_ES', 'Diseño - CSS', '', ''),
  (1260, 'es_ES', 'Diseño - antes de la barra superior', '', ''),
  (1261, 'es_ES', 'Diseño - en la barra superior', '', ''),
  (1262, 'es_ES', 'Diseño - después de la barra superior', '', ''),
  (1263, 'es_ES', 'Diseño - antes del menú principal', '', ''),
  (1264, 'es_ES', 'Diseño - en la parte superior del menú artículos', '', ''),
  (1265, 'es_ES', 'Diseño - después del menú principal', '', ''),
  (1266, 'es_ES', 'Diseño - antes del pie de página', '', ''),
  (1267, 'es_ES', 'Diseño - en el pie de página', '', ''),
  (1268, 'es_ES', 'Diseño - después de pie de página', '', ''),
  (1269, 'es_ES', 'Diseño - JavaScript', '', ''),
  (1270, 'es_ES', 'Diseño - en la parte superior de la barra superior', '', ''),
  (1271, 'es_ES', 'Diseño - en la parte inferior de la barra superior', '', ''),
  (1272, 'es_ES', 'Diseño - en el menú de cliente', '', ''),
  (1273, 'es_ES', 'Diseño - en el menú de pedidos', '', ''),
  (1274, 'es_ES', 'Diseño - en el menú de catálogo', '', ''),
  (1275, 'es_ES', 'Diseño - en el menú de carpetas', '', ''),
  (1276, 'es_ES', 'Diseño - en el menú de herramientas', '', ''),
  (1277, 'es_ES', 'Diseño - en el menú de módulos', '', ''),
  (1278, 'es_ES', 'Diseño - en el menú de configuración', '', ''),
  (1279, 'es_ES', 'Marca - editar JavaScript', '', ''),
  (1280, 'es_ES', 'Inicio - bloque', '', ''),
  (1281, 'es_ES', 'Marcas - en parte superior', '', ''),
  (1282, 'es_ES', 'Marcas - encabezado de tabla', '', ''),
  (1283, 'es_ES', 'Marcas - file de la tabla', '', ''),
  (1284, 'es_ES', 'Marcas - inferior', '', ''),
  (1285, 'es_ES', 'Marca - formulario de creación', '', ''),
  (1286, 'es_ES', 'Marca - formulario de eliminación', '', ''),
  (1287, 'es_ES', 'Marca - JavaScript', '', ''),
  (1288, 'es_ES', 'Exportar - en la parte superior', '', ''),
  (1289, 'es_ES', 'Exportar - en la parte inferior de una categoría', '', ''),
  (1290, 'es_ES', 'Exportar - en la parte inferior de la columna 1', '', ''),
  (1291, 'es_ES', 'Exportar JavaScript', '', ''),
  (1292, 'es_ES', 'Exportación - JavaScript', '', ''),
  (1293, 'es_ES', 'Marca - contenido', '', ''),
  (1294, 'es_ES', 'Cliente - cabecera tabla de pedidos', '', ''),
  (1295, 'es_ES', 'Cliente - celda tabla pedidos', '', ''),

  (2001, 'es_ES', 'Factura - CSS', '', ''),
  (2002, 'es_ES', 'Factura - en la cabecera', '', ''),
  (2003, 'es_ES', 'Factura - en la parte superior del pie de página', '', ''),
  (2004, 'es_ES', 'Factura - pie de imprenta', '', ''),
  (2005, 'es_ES', 'Factura - en la parte inferior del pie de página', '', ''),
  (2006, 'es_ES', 'Factura - en la parte inferior del área de la información', '', ''),
  (2007, 'es_ES', 'Factura - después del área de información', '', ''),
  (2008, 'es_ES', 'Factura - dirección de envío', '', ''),
  (2009, 'es_ES', 'Factura - después del área de dirección', '', ''),
  (2010, 'es_ES', 'Factura - después de listado de productos', '', ''),
  (2011, 'es_ES', 'Factura - después del resumen de la orden', '', ''),
  (2012, 'es_ES', 'Entrega - CSS', '', ''),
  (2013, 'es_ES', 'Envío - en la cabecera', '', ''),
  (2014, 'es_ES', 'Envío - en la parte superior del footer', '', ''),
  (2015, 'es_ES', 'Envío - imprimir', '', ''),
  (2016, 'es_ES', 'Envío - En el pie del footer', '', ''),
  (2017, 'es_ES', 'Envío - en el pié del área de información', '', ''),
  (2018, 'es_ES', 'Entrega - después del área de información', '', ''),
  (2019, 'es_ES', 'Envío - dirección de entrega', '', ''),
  (2020, 'es_ES', 'Entrega - tras el área de dirección', '', ''),
  (2021, 'es_ES', 'Envío - después del resumen de pedido', '', ''),

  (2022, 'es_ES', 'Confirmación de la orden - después del Resumen de la orden', '', ''),

  (2023, 'es_ES', 'Donde se requiere el editor WYSIWYG', '', ''),
  (1, 'fr_FR', 'Choix du mode de paiement - en haut', '', ''),
  (2, 'fr_FR', 'Choix du mode de paiement - adresse de livraison', '', ''),
  (3, 'fr_FR', 'Choix du mode de paiement - zone de paiement supplémentaire', '', ''),
  (4, 'fr_FR', 'Choix du mode de paiement - en bas', '', ''),
  (5, 'fr_FR', 'Choix du mode de paiement - après l\'initialisation du JavaScript', '', ''),
  (6, 'fr_FR', 'Choix du mode de paiement - feuille de style CSS', '', ''),
  (7, 'fr_FR', 'Choix du mode de paiement - après l\'inclusion du JavaScript', '', ''),
  (8, 'fr_FR', 'Passerelle de paiement - zone principale', '', ''),
  (9, 'fr_FR', 'Passerelle de paiement - javascript', '', ''),
  (10, 'fr_FR', 'Passerelle de paiement - après l\'initialisation du JavaScript', '', ''),
  (11, 'fr_FR', 'Passerelle de paiement - feuille de style CSS', '', ''),
  (12, 'fr_FR', 'Passerelle de paiement - après l\'inclusion du JavaScript', '', ''),
  (13, 'fr_FR', 'Sitemap - en bas', '', ''),
  (14, 'fr_FR', 'Page du choix de la device - en haut', '', ''),
  (15, 'fr_FR', 'Page du choix de la device - en bas', '', ''),
  (16, 'fr_FR', 'Page du choix de la device - feuille de style CSS', '', ''),
  (17, 'fr_FR', 'Page du choix de la device - après l\'inclusion du JavaScript', '', ''),
  (18, 'fr_FR', 'Page du choix de la device - après l\'initialisation du JavaScript', '', ''),
  (19, 'fr_FR', 'Page de connexion - en haut', '', ''),
  (20, 'fr_FR', 'Page de connexion - en haut de la zone principal', '', ''),
  (21, 'fr_FR', 'Page de connexion - en haut du formulaire', '', ''),
  (22, 'fr_FR', 'Page de connexion - en bas du formulaire', '', ''),
  (23, 'fr_FR', 'Page de connexion - en bas de la zone principal', '', ''),
  (24, 'fr_FR', 'Page de connexion - en bas', '', ''),
  (25, 'fr_FR', 'Page de connexion - feuille de style CSS', '', ''),
  (26, 'fr_FR', 'Page de connexion - après l\'inclusion du JavaScript', '', ''),
  (27, 'fr_FR', 'Page de connexion - après l\'initialisation du JavaScript', '', ''),
  (28, 'fr_FR', 'Modification compte client - en haut', '', ''),
  (29, 'fr_FR', 'Modification compte client - en haut du formulaire', '', ''),
  (30, 'fr_FR', 'Modification compte client - en bas du formulaire', '', ''),
  (31, 'fr_FR', 'Modification compte client - en bas', '', ''),
  (32, 'fr_FR', 'Modification compte client - feuille de style CSS', '', ''),
  (33, 'fr_FR', 'Modification compte client - après l\'inclusion du JavaScript', '', ''),
  (34, 'fr_FR', 'Modification compte client - après l\'initialisation du JavaScript', '', ''),
  (35, 'fr_FR', 'Panier - en haut', '', ''),
  (36, 'fr_FR', 'Panier - en bas', '', ''),
  (37, 'fr_FR', 'Panier - après l\'inclusion du JavaScript', '', ''),
  (38, 'fr_FR', 'Panier - feuille de style CSS', '', ''),
  (39, 'fr_FR', 'Panier - initialisation du JavaScript', '', ''),
  (40, 'fr_FR', 'Page contact - en haut', '', ''),
  (41, 'fr_FR', 'Page contact - en haut du formulaire', '', ''),
  (42, 'fr_FR', 'Page contact - en bas du formulaire', '', ''),
  (43, 'fr_FR', 'Page contact - en bas', '', ''),
  (44, 'fr_FR', 'Page contact - feuille de style CSS', '', ''),
  (45, 'fr_FR', 'Page contact - après l\'inclusion du JavaScript', '', ''),
  (46, 'fr_FR', 'Page contact - après l\'initialisation du JavaScript', '', ''),
  (47, 'fr_FR', 'Commande terminée - zone principale', '', ''),
  (48, 'fr_FR', 'Commande terminée - feuille de style CSS', '', ''),
  (49, 'fr_FR', 'Commande terminée - après l\'inclusion du JavaScript', '', ''),
  (50, 'fr_FR', 'Commande terminée - après l\'initialisation du JavaScript', '', ''),
  (51, 'fr_FR', 'Page de recherche - feuille de style CSS', '', ''),
  (52, 'fr_FR', 'Page de recherche - après l\'inclusion du JavaScript', '', ''),
  (53, 'fr_FR', 'Page de recherche - après l\'initialisation du JavaScript', '', ''),
  (54, 'fr_FR', 'Création de compte - en haut', '', ''),
  (55, 'fr_FR', 'Création de compte - en haut du formulaire', '', ''),
  (56, 'fr_FR', 'Création de compte - en bas du formulaire', '', ''),
  (57, 'fr_FR', 'Création de compte - en bas', '', ''),
  (58, 'fr_FR', 'Création de compte - feuille de style CSS', '', ''),
  (59, 'fr_FR', 'Création de compte - après l\'inclusion du JavaScript', '', ''),
  (60, 'fr_FR', 'Création de compte - après l\'initialisation du JavaScript', '', ''),
  (61, 'fr_FR', 'Mot de passe perdu - en haut', '', ''),
  (62, 'fr_FR', 'Mot de passe perdu - en haut du formulaire', '', ''),
  (63, 'fr_FR', 'Mot de passe perdu - en bas du formulaire', '', ''),
  (64, 'fr_FR', 'Mot de passe perdu - en bas', '', ''),
  (65, 'fr_FR', 'Mot de passe perdu - feuille de style CSS', '', ''),
  (66, 'fr_FR', 'Mot de passe perdu - après l\'inclusion du JavaScript', '', ''),
  (67, 'fr_FR', 'Mot de passe perdu - initialisation du JavaScript', '', ''),
  (68, 'fr_FR', 'Page du choix du langage - en haut', '', ''),
  (69, 'fr_FR', 'Page du choix du langage - en bas', '', ''),
  (70, 'fr_FR', 'Page du choix du langage - feuille de style CSS', '', ''),
  (71, 'fr_FR', 'Page du choix du langage - après l\'inclusion du JavaScript', '', ''),
  (72, 'fr_FR', 'Page du choix du langage - après l\'initialisation du JavaScript', '', ''),
  (73, 'fr_FR', 'Page contact - en cas de succès', '', ''),
  (74, 'fr_FR', 'Page newsletter - en haut', '', ''),
  (75, 'fr_FR', 'Page newsletter - en bas', '', ''),
  (76, 'fr_FR', 'Page newsletter - feuille de style CSS', '', ''),
  (77, 'fr_FR', 'Page newsletter - après l\'inclusion du JavaScript', '', ''),
  (78, 'fr_FR', 'Page newsletter - après l\'initialisation du JavaScript', '', ''),
  (79, 'fr_FR', 'Échec du paiement - feuille de style CSS', '', ''),
  (80, 'fr_FR', 'Echec du paiement - après l\'inclusion du JavaScript', '', ''),
  (81, 'fr_FR', 'Echec du paiement - initialisation du JavaScript', '', ''),
  (82, 'fr_FR', 'Page de contenu - en haut', '', ''),
  (83, 'fr_FR', 'Page de contenu - en haut de la zone principal', '', ''),
  (84, 'fr_FR', 'Page de contenu - en bas de la zone principal', '', ''),
  (85, 'fr_FR', 'Page de contenu - en bas', '', ''),
  (86, 'fr_FR', 'Page de contenu - feuille de style CSS', '', ''),
  (87, 'fr_FR', 'Page de contenu - après l\'inclusion du JavaScript', '', ''),
  (88, 'fr_FR', 'Page de contenu - après l\'initialisation du JavaScript', '', ''),
  (89, 'fr_FR', 'Structure HTML - après l\'ouverture de la balise head', '', ''),
  (90, 'fr_FR', 'Structure HTML - feuille de style CSS', '', ''),
  (91, 'fr_FR', 'Structure HTML - avant la fin de la balise head', '', ''),
  (92, 'fr_FR', 'Structure HTML - après l\'ouverture de la balise body', '', ''),
  (93, 'fr_FR', 'Structure HTML - en haut du header', '', ''),
  (94, 'fr_FR', 'Structure HTML - navigation secondaire', '', ''),
  (95, 'fr_FR', 'Structure HTML - navigation principale', '', ''),
  (96, 'fr_FR', 'Structure HTML - en bas du header', '', ''),
  (97, 'fr_FR', 'Structure HTML - au dessus de la zone de contenu principale', '', ''),
  (98, 'fr_FR', 'Structure HTML - en dessous de la zone de contenu principale', '', ''),
  (99, 'fr_FR', 'Structure HTML - en haut du pied de page', '', ''),
  (100, 'fr_FR', 'Structure HTML - corps du pied de page', '', ''),
  (101, 'fr_FR', 'Structure HTML - en bas du pied de page', '', ''),
  (102, 'fr_FR', 'Structure HTML - après l\'inclusion du JavaScript', '', ''),
  (103, 'fr_FR', 'Structure HTML - initialisation du JavaScript', '', ''),
  (104, 'fr_FR', 'Structure HTML - avant la fin de la balise body', '', ''),
  (105, 'fr_FR', 'Page introuvable - zone de contenu', '', ''),
  (106, 'fr_FR', 'Page introuvable - feuille de style CSS', '', ''),
  (107, 'fr_FR', 'Page introuvable - après l\'inclusion du JavaScript', '', ''),
  (108, 'fr_FR', 'Page introuvable - après l\'initialisation du JavaScript', '', ''),
  (109, 'fr_FR', 'Choix du transporteur - en haut', '', ''),
  (110, 'fr_FR', 'Choix du transporteur - en haut du formulaire', '', ''),
  (111, 'fr_FR', 'Choix du transporteur - en bas du formulaire', '', ''),
  (112, 'fr_FR', 'Choix du transporteur - en bas', '', ''),
  (113, 'fr_FR', 'Choix du transporteur - après l\'initialisation du JavaScript', '', ''),
  (114, 'fr_FR', 'Choix du transporteur - feuille de style CSS', '', ''),
  (115, 'fr_FR', 'Choix du transporteur - après l\'inclusion du JavaScript', '', ''),
  (116, 'fr_FR', 'Création d\'adresse - en haut', '', ''),
  (117, 'fr_FR', 'Création d\'adresse - en haut du formulaire', '', ''),
  (118, 'fr_FR', 'Création d\'adresse - en bas du formulaire', '', ''),
  (119, 'fr_FR', 'Création d\'adresse - en bas', '', ''),
  (120, 'fr_FR', 'Création d\'adresse - feuille de style CSS', '', ''),
  (121, 'fr_FR', 'Création d\'adresse - après l\'inclusion du JavaScript', '', ''),
  (122, 'fr_FR', 'Création d\'adresse - après l\'initialisation du JavaScript', '', ''),
  (123, 'fr_FR', 'Page dossier - en haut', '', ''),
  (124, 'fr_FR', 'Page dossier - en haut de la zone principale', '', ''),
  (125, 'fr_FR', 'Page dossier - en bas de la zone principale', '', ''),
  (126, 'fr_FR', 'Page dossier - en bas', '', ''),
  (127, 'fr_FR', 'Page dossier - feuille de style CSS', '', ''),
  (128, 'fr_FR', 'Page dossier - après l\'inclusion du JavaScript', '', ''),
  (129, 'fr_FR', 'Page dossier - après l\'initialisation du JavaScript', '', ''),
  (130, 'fr_FR', 'Échec de la commande - en haut', '', ''),
  (131, 'fr_FR', 'Échec de la commande - en bas', '', ''),
  (132, 'fr_FR', 'Échec de la commande - feuille de style CSS', '', ''),
  (133, 'fr_FR', 'Echec de la commande - après l\'inclusion du JavaScript', '', ''),
  (134, 'fr_FR', 'Echec de la commande - après l\'initialisation du JavaScript', '', ''),
  (135, 'fr_FR', 'Page catégorie - en haut', '', ''),
  (136, 'fr_FR', 'Page catégorie - en haut de la zone principal', '', ''),
  (137, 'fr_FR', 'Page catégorie - en bas de la zone principal', '', ''),
  (138, 'fr_FR', 'Page catégorie - en bas', '', ''),
  (139, 'fr_FR', 'Page catégorie - feuille de style CSS', '', ''),
  (140, 'fr_FR', 'Page catégorie - après l\'inclusion du JavaScript', '', ''),
  (141, 'fr_FR', 'Page catégorie - après l\'initialisation du JavaScript', '', ''),
  (142, 'fr_FR', 'Modification d\'adresse - en haut', '', ''),
  (143, 'fr_FR', 'Modification d\'adresse - en haut du formulaire', '', ''),
  (144, 'fr_FR', 'Modification d\'adresse - en bas du formulaire', '', ''),
  (145, 'fr_FR', 'Modification d\'adresse - en bas', '', ''),
  (146, 'fr_FR', 'Modification d\'adresse - feuille de style CSS', '', ''),
  (147, 'fr_FR', 'Modification d\'adresse - après l\'inclusion du JavaScript', '', ''),
  (148, 'fr_FR', 'Modification d\'adresse - après l\'initialisation du JavaScript', '', ''),
  (149, 'fr_FR', 'Page d\'accueil - zone principale', '', ''),
  (150, 'fr_FR', 'Page d\'accueil - feuille de style CSS', '', ''),
  (151, 'fr_FR', 'Page d\'accueil - après l\'inclusion du JavaScript', '', ''),
  (152, 'fr_FR', 'Page d\'accueil - après l\'initialisation du JavaScript', '', ''),
  (153, 'fr_FR', 'Changement de mot de passe - en haut', '', ''),
  (154, 'fr_FR', 'Changement de mot de passe - en bas', '', ''),
  (155, 'fr_FR', 'Changement de mot de passe - feuille de style CSS', '', ''),
  (156, 'fr_FR', 'Changement de mot de passe - après l\'inclusion du JavaScript', '', ''),
  (157, 'fr_FR', 'Changement de mot de passe - après l\'initialisation du JavaScript', '', ''),
  (158, 'fr_FR', 'Page produit - en haut', '', ''),
  (159, 'fr_FR', 'Page produit - galerie photos', '', ''),
  (160, 'fr_FR', 'Page produit - en haut de la zone détail', '', ''),
  (161, 'fr_FR', 'Page produit - en dessous de la zone de détail', '', ''),
  (162, 'fr_FR', 'Page produit - informations additionnelles', '', ''),
  (163, 'fr_FR', 'Page produit - en bas', '', ''),
  (164, 'fr_FR', 'Page produit - feuille de style CSS', '', ''),
  (165, 'fr_FR', 'Page produit - après l\'inclusion du JavaScript', '', ''),
  (166, 'fr_FR', 'Page produit - après l\'initialisation du JavaScript', '', ''),
  (167, 'fr_FR', 'Compte client - en haut', '', ''),
  (168, 'fr_FR', 'Compte client - en bas', '', ''),
  (169, 'fr_FR', 'Compte client - feuille de style CSS', '', ''),
  (170, 'fr_FR', 'Compte client - après l\'inclusion du JavaScript', '', ''),
  (171, 'fr_FR', 'Compte client - après l\'initialisation du JavaScript', '', ''),
  (172, 'fr_FR', 'Tous les produits - en haut', '', ''),
  (173, 'fr_FR', 'Tous les produits - en bas', '', ''),
  (174, 'fr_FR', 'Tous les produits - feuille de style CSS', '', ''),
  (175, 'fr_FR', 'Tous les produits - après l\'inclusion du JavaScript', '', ''),
  (176, 'fr_FR', 'Tous les produits - après l\'initialisation du JavaScript', '', ''),
  (177, 'fr_FR', 'Boucle produit - en haut', '', ''),
  (178, 'fr_FR', 'Boucle produit - en bas', '', ''),
  (179, 'fr_FR', 'Page catégorie - en haut de la sidebar', '', ''),
  (180, 'fr_FR', 'Page catégorie - le corps de la sidebar', '', ''),
  (181, 'fr_FR', 'Page catégorie - en bas de la sidebar', '', ''),
  (182, 'fr_FR', 'Page de contenu - en haut de la sidebar', '', ''),
  (183, 'fr_FR', 'Page de contenu - le corps de la sidebar', '', ''),
  (184, 'fr_FR', 'Page de contenu - en bas de la sidebar', '', ''),
  (185, 'fr_FR', 'Choix du transporteur - zone supplémentaire', '', ''),
  (186, 'fr_FR', 'Choix du transporteur - javascript', '', ''),
  (1000, 'fr_FR', 'Catégorie - contenu', '', ''),
  (1001, 'fr_FR', 'Contenu - contenu', '', ''),
  (1002, 'fr_FR', 'Dossier - contenu', '', ''),
  (1003, 'fr_FR', 'Commande - contenu', '', ''),
  (1004, 'fr_FR', 'Produit - contenu', '', ''),
  (1005, 'fr_FR', 'Valeur de caractéristiques - colonne tableau', '', ''),
  (1006, 'fr_FR', 'Valeur de caractéristiques - ligne tableau', '', ''),
  (1007, 'fr_FR', 'Caractéristique - Formulaire de création de valeur', '', ''),
  (1008, 'fr_FR', 'Caractéristique - JavaScript modification', '', ''),
  (1009, 'fr_FR', 'Produit - Modification de JavaScript', '', ''),
  (1010, 'fr_FR', 'Code promo - JavaScript création', '', ''),
  (1011, 'fr_FR', 'Taxes - formulaire de modification', '', ''),
  (1012, 'fr_FR', 'Règle de taxe - Modification de JavaScript', '', ''),
  (1013, 'fr_FR', 'Outils - en haut', '', ''),
  (1014, 'fr_FR', 'Outils - en haut de la colonne', '', ''),
  (1015, 'fr_FR', 'Outils - en bas de la colonne 1', '', ''),
  (1016, 'fr_FR', 'Outils - en bas', '', ''),
  (1017, 'fr_FR', 'Outils - JavaScript', '', ''),
  (1018, 'fr_FR', 'Messages - en haut', '', ''),
  (1019, 'fr_FR', 'Messages - colonne tableau', '', ''),
  (1020, 'fr_FR', 'Messages - ligne tableau', '', ''),
  (1021, 'fr_FR', 'Messages - bas', '', ''),
  (1022, 'fr_FR', 'Message - formulaire de création', '', ''),
  (1023, 'fr_FR', 'Message - formulaire de suppression', '', ''),
  (1024, 'fr_FR', 'Messages - JavaScript', '', ''),
  (1025, 'fr_FR', 'Règles de taxes - en haut', '', ''),
  (1026, 'fr_FR', 'Règles de taxes - en bas', '', ''),
  (1027, 'fr_FR', 'Taxe - formulaire de création', '', ''),
  (1028, 'fr_FR', 'Taxe - formulaire de suppression', '', ''),
  (1029, 'fr_FR', 'Règle de taxe - formulaire de création', '', ''),
  (1030, 'fr_FR', 'Règle de taxe - formulaire de suppression', '', ''),
  (1031, 'fr_FR', 'Règles de taxes - JavaScript', '', ''),
  (1032, 'fr_FR', 'Exports - en haut', '', ''),
  (1033, 'fr_FR', 'Exports - en bas d\'une catégorie', '', ''),
  (1034, 'fr_FR', 'Exports - en bas de la colonne 1', '', ''),
  (1035, 'fr_FR', 'Exports - JavaScript', '', ''),
  (1036, 'fr_FR', 'Export - JavaScript', '', ''),
  (1037, 'fr_FR', 'Produit - colonne tableau dossiers', '', ''),
  (1038, 'fr_FR', 'Produit - ligne tableau dossiers', '', ''),
  (1039, 'fr_FR', 'Produit - Formulaire détail des prix', '', ''),
  (1040, 'fr_FR', 'Produit - formulaire de modification du stock', '', ''),
  (1041, 'fr_FR', 'Produit - Formulaire détail des promotions', '', ''),
  (1042, 'fr_FR', 'Produit - avant les déclinaisons', '', ''),
  (1043, 'fr_FR', 'Produit - légende liste des déclinaisons', '', ''),
  (1044, 'fr_FR', 'Produit - après les déclinaisons', '', ''),
  (1045, 'fr_FR', 'Produit - formulaire de suppression de combinaison', '', ''),
  (1046, 'fr_FR', 'Modules - colonne tableau', '', ''),
  (1047, 'fr_FR', 'Modules - ligne tableau', '', ''),
  (1048, 'fr_FR', 'Devise - JavaScript modification', '', ''),
  (1049, 'fr_FR', 'Catégorie - colonne tableau contenus', '', ''),
  (1050, 'fr_FR', 'Catégorie - ligne tableau contenus', '', ''),
  (1051, 'fr_FR', 'Catégorie - JavaScript modification', '', ''),
  (1052, 'fr_FR', 'Document - JavaScript modification', '', ''),
  (1053, 'fr_FR', 'Client - en haut', '', ''),
  (1054, 'fr_FR', 'Clients - légende', '', ''),
  (1055, 'fr_FR', 'Clients - en-tête', '', ''),
  (1056, 'fr_FR', 'Clients - ligne', '', ''),
  (1057, 'fr_FR', 'Client - bas', '', ''),
  (1058, 'fr_FR', 'Client - formulaire de création', '', ''),
  (1059, 'fr_FR', 'Client - formulaire de suppression', '', ''),
  (1060, 'fr_FR', 'Clients - JavaScript', '', ''),
  (1061, 'fr_FR', 'Produit - colonne tableau contenus', '', ''),
  (1062, 'fr_FR', 'Produit - ligne tableau contenus', '', ''),
  (1063, 'fr_FR', 'Produit - colonne tableau accessoires', '', ''),
  (1064, 'fr_FR', 'Produit - ligne tableau accessoires', '', ''),
  (1065, 'fr_FR', 'Produit - colonne tableau catégories', '', ''),
  (1066, 'fr_FR', 'Produit - ligne tableau catégories', '', ''),
  (1067, 'fr_FR', 'Produit - colonne tableau attributs', '', ''),
  (1068, 'fr_FR', 'Produit - ligne tableau attributs', '', ''),
  (1069, 'fr_FR', 'Produit - colonne tableau caractéristiques', '', ''),
  (1070, 'fr_FR', 'Produit - ligne tableau caractéristiques', '', ''),
  (1071, 'fr_FR', 'Gabarit - colonne tableau attributs', '', ''),
  (1072, 'fr_FR', 'Gabarit - ligne tableau attributs', '', ''),
  (1073, 'fr_FR', 'Gabarit - colonne tableau caractéristiques', '', ''),
  (1074, 'fr_FR', 'Gabarit - ligne tableau caractéristiques', '', ''),
  (1075, 'fr_FR', 'Gabarits - en haut', '', ''),
  (1076, 'fr_FR', 'Gabarits - colonne tableau', '', ''),
  (1077, 'fr_FR', 'Gabarits - ligne tableau', '', ''),
  (1078, 'fr_FR', 'Gabarits - en bas', '', ''),
  (1079, 'fr_FR', 'Gabarit - formulaire de création', '', ''),
  (1080, 'fr_FR', 'Gabarit - formulaire de suppression', '', ''),
  (1081, 'fr_FR', 'Gabarits - JavaScript', '', ''),
  (1082, 'fr_FR', 'Configuration - en haut', '', ''),
  (1083, 'fr_FR', 'Configuration - en haut de la zone catalogue', '', ''),
  (1084, 'fr_FR', 'Configuration - en bas du catlogue', '', ''),
  (1085, 'fr_FR', 'Configuration - en haut de la zone livraison', '', ''),
  (1086, 'fr_FR', 'Configuration - en bas de la zone livraison', '', ''),
  (1087, 'fr_FR', 'Configuration - en haut de la zone système', '', ''),
  (1088, 'fr_FR', 'Configuration - en bas de la zone système', '', ''),
  (1089, 'fr_FR', 'Configuration - bas', '', ''),
  (1090, 'fr_FR', 'Configuration - JavaScript', '', ''),
  (1091, 'fr_FR', 'Tableau de bord - en haut', '', ''),
  (1092, 'fr_FR', 'Tableau de bord - au milieu', '', ''),
  (1093, 'fr_FR', 'Tableau de bord - bas', '', ''),
  (1094, 'fr_FR', 'Commandes - en haut', '', ''),
  (1095, 'fr_FR', 'Commandes - colonne tableau', '', ''),
  (1096, 'fr_FR', 'Commandes - ligne tableau', '', ''),
  (1097, 'fr_FR', 'Commandes - en bas', '', ''),
  (1098, 'fr_FR', 'Commandes - JavaScript', '', ''),
  (1099, 'fr_FR', 'Zone de livraison - en haut', '', ''),
  (1100, 'fr_FR', 'Zone de livraison - colonne tableau', '', ''),
  (1101, 'fr_FR', 'Zone de livraison - ligne tableau', '', ''),
  (1102, 'fr_FR', 'Zone de livraison - bas', '', ''),
  (1103, 'fr_FR', 'Zone de livraison - JavaScript', '', ''),
  (1104, 'fr_FR', 'Contenu - JavaScript modification', '', ''),
  (1105, 'fr_FR', 'Accueil - en haut', '', ''),
  (1106, 'fr_FR', 'Accueil - bas', '', ''),
  (1107, 'fr_FR', 'Accueil - JavaScript', '', ''),
  (1108, 'fr_FR', 'Modules - en haut', '', ''),
  (1109, 'fr_FR', 'Modules - bas', '', ''),
  (1110, 'fr_FR', 'Modules - JavaScript', '', ''),
  (1111, 'fr_FR', 'Langages - en haut', '', ''),
  (1112, 'fr_FR', 'Langages - bas', '', ''),
  (1113, 'fr_FR', 'Langage - formulaire de création', '', ''),
  (1114, 'fr_FR', 'Langages - formulaire de suppression', '', ''),
  (1115, 'fr_FR', 'Langages - JavaScript', '', ''),
  (1116, 'fr_FR', 'Zone - formulaire de suppression', '', ''),
  (1117, 'fr_FR', 'Zone de livraison - JavaScript modification', '', ''),
  (1118, 'fr_FR', 'Système - logs JavaScript', '', ''),
  (1119, 'fr_FR', 'Recherche - en haut', '', ''),
  (1120, 'fr_FR', 'Recherche - en bas', '', ''),
  (1121, 'fr_FR', 'Recherche - JavaScript', '', ''),
  (1122, 'fr_FR', 'Administateurs - en haut', '', ''),
  (1123, 'fr_FR', 'Administateurs - bas', '', ''),
  (1124, 'fr_FR', 'Administateur - formulaire de création', '', ''),
  (1125, 'fr_FR', 'Administateur - formulaire de modification', '', ''),
  (1126, 'fr_FR', 'Administateur - formulaire de suppression', '', ''),
  (1127, 'fr_FR', 'Administateurs - JavaScript', '', ''),
  (1128, 'fr_FR', 'Module hook - Modification de JavaScript', '', ''),
  (1129, 'fr_FR', 'Configuration du transport - en haut', '', ''),
  (1130, 'fr_FR', 'Configuration du transport - colonne tableau', '', ''),
  (1131, 'fr_FR', 'Configuration du transport - ligne tableau', '', ''),
  (1132, 'fr_FR', 'Configuration du transport - en bas', '', ''),
  (1133, 'fr_FR', 'Configuration du transport - formulaire de création', '', ''),
  (1134, 'fr_FR', 'Configuration du transport - formulaire de suppression', '', ''),
  (1135, 'fr_FR', 'Configuration du transport - JavaScript', '', ''),
  (1136, 'fr_FR', 'Caractéristiques - en haut', '', ''),
  (1137, 'fr_FR', 'Caractéristiques - colonne tableau', '', ''),
  (1138, 'fr_FR', 'Caractéristiques - ligne tableau', '', ''),
  (1139, 'fr_FR', 'Caractéristiques - bas', '', ''),
  (1140, 'fr_FR', 'Caractéristique - formulaire de création', '', ''),
  (1141, 'fr_FR', 'Caractéristique - formulaire de suppression', '', ''),
  (1142, 'fr_FR', 'Caractéristique - formulaire ajouter à tous', '', ''),
  (1143, 'fr_FR', 'Caractéristique - formulaire de suppression multiple', '', ''),
  (1144, 'fr_FR', 'Caractéristiques - JavaScript', '', ''),
  (1145, 'fr_FR', 'Module - Modification de JavaScript', '', ''),
  (1146, 'fr_FR', 'Module hook - formulaire de création', '', ''),
  (1147, 'fr_FR', 'Module hook - formulaire de suppression', '', ''),
  (1148, 'fr_FR', 'Point d\'accroche des modules - Javascript', '', ''),
  (1149, 'fr_FR', 'Configuration du transport - Modification', '', ''),
  (1150, 'fr_FR', 'Configuration du transport - formulaire de suppression de pays', '', ''),
  (1151, 'fr_FR', 'Configuration du transport - Modification de JavaScript', '', ''),
  (1152, 'fr_FR', 'Envoi des e-mails - en haut', '', ''),
  (1153, 'fr_FR', 'Envoi des e-mails - en bas', '', ''),
  (1154, 'fr_FR', 'Envoi des e-mails - JavaScript', '', ''),
  (1155, 'fr_FR', 'Catégories - en haut', '', ''),
  (1156, 'fr_FR', 'Catégories - légende', '', ''),
  (1157, 'fr_FR', 'Catégories - en-tête', '', ''),
  (1158, 'fr_FR', 'Catégories - ligne', '', ''),
  (1159, 'fr_FR', 'Produits - légende', '', ''),
  (1160, 'fr_FR', 'Produits - en-tête', '', ''),
  (1161, 'fr_FR', 'Produits - ligne', '', ''),
  (1162, 'fr_FR', 'Catégories - bas', '', ''),
  (1163, 'fr_FR', 'Catégories - en bas du catalogue', '', ''),
  (1164, 'fr_FR', 'Catégorie - formulaire de création', '', ''),
  (1165, 'fr_FR', 'Produit - formulaire de création', '', ''),
  (1166, 'fr_FR', 'Catégorie - formulaire de suppression', '', ''),
  (1167, 'fr_FR', 'Produit - formulaire de suppression', '', ''),
  (1168, 'fr_FR', 'Catégories - JavaScript', '', ''),
  (1169, 'fr_FR', 'Variables - en haut', '', ''),
  (1170, 'fr_FR', 'Variables - colonne tableau', '', ''),
  (1171, 'fr_FR', 'Variables - ligne tableau', '', ''),
  (1172, 'fr_FR', 'Variables - en bas', '', ''),
  (1173, 'fr_FR', 'Variable - formulaire de création', '', ''),
  (1174, 'fr_FR', 'Variable - formulaire de suppression', '', ''),
  (1175, 'fr_FR', 'Variables - JavaScript', '', ''),
  (1176, 'fr_FR', 'Commande - liste produit', '', ''),
  (1177, 'fr_FR', 'Commande - Modification de JavaScript', '', ''),
  (1178, 'fr_FR', 'Information boutique - JavaScript', '', ''),
  (1179, 'fr_FR', 'Traductions - JavaScript', '', ''),
  (1180, 'fr_FR', 'Dossiers - en haut', '', ''),
  (1181, 'fr_FR', 'Dossiers - légende', '', ''),
  (1182, 'fr_FR', 'Dossiers - en-tête', '', ''),
  (1183, 'fr_FR', 'Dossiers - ligne', '', ''),
  (1184, 'fr_FR', 'Contenus - légende', '', ''),
  (1185, 'fr_FR', 'Contenus - en-tête', '', ''),
  (1186, 'fr_FR', 'Contenus - ligne', '', ''),
  (1187, 'fr_FR', 'Dossiers - bas', '', ''),
  (1188, 'fr_FR', 'Dossier - formulaire de création', '', ''),
  (1189, 'fr_FR', 'Contenu - formulaire de création', '', ''),
  (1190, 'fr_FR', 'Dossier - formulaire de suppression', '', ''),
  (1191, 'fr_FR', 'Contenu - formulaire de suppression', '', ''),
  (1192, 'fr_FR', 'Dossiers - JavaScript', '', ''),
  (1193, 'fr_FR', 'Gabarit - Modification de JavaScript', '', ''),
  (1194, 'fr_FR', 'Taxe - Modification de JavaScript', '', ''),
  (1195, 'fr_FR', 'Point d\'accroche - JavaScript modification', '', ''),
  (1196, 'fr_FR', 'Pays - en haut', '', ''),
  (1197, 'fr_FR', 'Pays - colonne tableau', '', ''),
  (1198, 'fr_FR', 'Pays - ligne tableau', '', ''),
  (1199, 'fr_FR', 'Pays - bas', '', ''),
  (1200, 'fr_FR', 'Pays - formulaire de création', '', ''),
  (1201, 'fr_FR', 'Pays - formulaire de suppression', '', ''),
  (1202, 'fr_FR', 'Pays - JavaScript', '', ''),
  (1203, 'fr_FR', 'Devises - en haut', '', ''),
  (1204, 'fr_FR', 'Devises - colonne tableau', '', ''),
  (1205, 'fr_FR', 'Devises - ligne tableau', '', ''),
  (1206, 'fr_FR', 'Devises - bas', '', ''),
  (1207, 'fr_FR', 'Devise - formulaire de création', '', ''),
  (1208, 'fr_FR', 'Devise - formulaire de suppression', '', ''),
  (1209, 'fr_FR', 'Devises - JavaScript', '', ''),
  (1210, 'fr_FR', 'Client - Modification', '', ''),
  (1211, 'fr_FR', 'Client - formulaire de création d\'adresse', '', ''),
  (1212, 'fr_FR', 'Client - formulaire de Modification d\'adresse', '', ''),
  (1213, 'fr_FR', 'Client - formulaire de suppression adresse', '', ''),
  (1214, 'fr_FR', 'Client - JavaScript modification', '', ''),
  (1215, 'fr_FR', 'Valeurs des attributs - colonne tableau', '', ''),
  (1216, 'fr_FR', 'Valeurs des attributs - ligne tableau', '', ''),
  (1217, 'fr_FR', 'Valeur d\'attribut - formulaire de création', '', ''),
  (1218, 'fr_FR', 'Attribut - formulaire de suppression ID', '', ''),
  (1219, 'fr_FR', 'Attribut - JavaScript modification', '', ''),
  (1220, 'fr_FR', 'Profils - en haut', '', ''),
  (1221, 'fr_FR', 'Profils - en bas', '', ''),
  (1222, 'fr_FR', 'Profil - formulaire de création', '', ''),
  (1223, 'fr_FR', 'Profil - formulaire de suppression', '', ''),
  (1224, 'fr_FR', 'Profils - JavaScript', '', ''),
  (1225, 'fr_FR', 'Pays - JavaScript modification', '', ''),
  (1226, 'fr_FR', 'Profil - Modification de JavaScript', '', ''),
  (1227, 'fr_FR', 'Variable - Modification de JavaScript', '', ''),
  (1228, 'fr_FR', 'Code promo - JavaScript modification', '', ''),
  (1229, 'fr_FR', 'Code promo - en haut', '', ''),
  (1230, 'fr_FR', 'Code promo - légende liste', '', ''),
  (1231, 'fr_FR', 'Code promo - colonne tableau', '', ''),
  (1232, 'fr_FR', 'Code promo - ligne tableau', '', ''),
  (1233, 'fr_FR', 'Code promo - bas', '', ''),
  (1234, 'fr_FR', 'Code promo - JavaScript des listes', '', ''),
  (1235, 'fr_FR', 'Module - configuration', '', ''),
  (1236, 'fr_FR', 'Module - JavaScript configuration', '', ''),
  (1237, 'fr_FR', 'Message - Modification de JavaScript', '', ''),
  (1238, 'fr_FR', 'Image - Modification de JavaScript', '', ''),
  (1239, 'fr_FR', 'Attributs - en haut', '', ''),
  (1240, 'fr_FR', 'Attributs - colonne tableau', '', ''),
  (1241, 'fr_FR', 'Attributs - ligne tableau', '', ''),
  (1242, 'fr_FR', 'Attributs - bas', '', ''),
  (1243, 'fr_FR', 'Attribut - formulaire de création', '', ''),
  (1244, 'fr_FR', 'Attribut - formulaire de suppression', '', ''),
  (1245, 'fr_FR', 'Attribut - formulaire ajouter à tous', '', ''),
  (1246, 'fr_FR', 'Attribut - formulaire de suppression multiple', '', ''),
  (1247, 'fr_FR', 'Attributs - JavaScript', '', ''),
  (1248, 'fr_FR', 'Logs - en haut', '', ''),
  (1249, 'fr_FR', 'Logs - bas', '', ''),
  (1250, 'fr_FR', 'Journaux - JavaScript', '', ''),
  (1251, 'fr_FR', 'Dossier - JavaScript modification', '', ''),
  (1252, 'fr_FR', 'Point d\'accroches - en haut', '', ''),
  (1253, 'fr_FR', 'Point d\'accroches - colonne tableau', '', ''),
  (1254, 'fr_FR', 'Point d\'accroches - ligne tableau', '', ''),
  (1255, 'fr_FR', 'Point d\'accroches - bas', '', ''),
  (1256, 'fr_FR', 'Point d\'accroche - formulaire de création', '', ''),
  (1257, 'fr_FR', 'Point d\'accroche - formulaire de suppression', '', ''),
  (1258, 'fr_FR', 'Points d\'accroche - Javascript', '', ''),
  (1259, 'fr_FR', 'Mise en page - CSS', '', ''),
  (1260, 'fr_FR', 'Mise en page - avant la barre de titre', '', ''),
  (1261, 'fr_FR', 'Mise en page - dans la barre de titre', '', ''),
  (1262, 'fr_FR', 'Mise en page - après la barre de titre', '', ''),
  (1263, 'fr_FR', 'Mise en page - avant le menu haut', '', ''),
  (1264, 'fr_FR', 'Mise en page - éléments du menu haut', '', ''),
  (1265, 'fr_FR', 'Mise en page - après le menu haut', '', ''),
  (1266, 'fr_FR', 'Mise en page - avant le pied de page', '', ''),
  (1267, 'fr_FR', 'Mise en page - dans le pied de page', '', ''),
  (1268, 'fr_FR', 'Mise en page - après le pied de page', '', ''),
  (1269, 'fr_FR', 'Mise en page - JavaScript', '', ''),
  (1270, 'fr_FR', 'Mise en page - en haut de la barre supérieure', '', ''),
  (1271, 'fr_FR', 'Mise en page - en bas de la barre supérieure', '', ''),
  (1272, 'fr_FR', 'Mise en page - dans le menu clients', '', ''),
  (1273, 'fr_FR', 'Mise en page - dans le menu commandes', '', ''),
  (1274, 'fr_FR', 'Mise en page - dans le menu catalogue', '', ''),
  (1275, 'fr_FR', 'Mise en page - dans le menu dossiers', '', ''),
  (1276, 'fr_FR', 'Mise en page - dans le menu outils', '', ''),
  (1277, 'fr_FR', 'Mise en page - dans le menu modules', '', ''),
  (1278, 'fr_FR', 'Mise en page - dans le menu configuration', '', ''),
  (1279, 'fr_FR', 'Marque - Modification du JavaScript', '', ''),
  (1280, 'fr_FR', 'Accueil - bloc', '', ''),
  (1281, 'fr_FR', 'Marques - en haut', '', ''),
  (1282, 'fr_FR', 'Marques - colonne tableau', '', ''),
  (1283, 'fr_FR', 'Marques - ligne tableau', '', ''),
  (1284, 'fr_FR', 'Marques - bas', '', ''),
  (1285, 'fr_FR', 'Marque - formulaire de création', '', ''),
  (1286, 'fr_FR', 'Marque - formulaire de suppression', '', ''),
  (1287, 'fr_FR', 'Marque - JavaScript', '', ''),
  (1288, 'fr_FR', 'Exports - en haut', '', ''),
  (1289, 'fr_FR', 'Exports - en bas d\'une catégorie', '', ''),
  (1290, 'fr_FR', 'Exports - en bas de la colonne 1', '', ''),
  (1291, 'fr_FR', 'Exports - JavaScript', '', ''),
  (1292, 'fr_FR', 'Export - JavaScript', '', ''),
  (1293, 'fr_FR', 'Marque - contenu', '', ''),
  (1294, 'fr_FR', 'Client - colonne tableau commande', '', ''),
  (1295, 'fr_FR', 'Client - ligne tableau commande', '', ''),

  (2001, 'fr_FR', 'Facture - CSS', '', ''),
  (2002, 'fr_FR', 'Facture - dans l\'en-tête', '', ''),
  (2003, 'fr_FR', 'Facture - en haut du pied de page', '', ''),
  (2004, 'fr_FR', 'Facture - mentions légales', '', ''),
  (2005, 'fr_FR', 'Facture - en bas du pied de page', '', ''),
  (2006, 'fr_FR', 'Facture - en bas de la zone d\'informations', '', ''),
  (2007, 'fr_FR', 'Facture - après la zone d\'informations', '', ''),
  (2008, 'fr_FR', 'Facture - adresse de livraison', '', ''),
  (2009, 'fr_FR', 'Facture - après la zone d\'adresses', '', ''),
  (2010, 'fr_FR', 'Facture - après la liste des produits', '', ''),
  (2011, 'fr_FR', 'Facture - après le résumé de la commande', '', ''),
  (2012, 'fr_FR', 'Bon de livraison - CSS', '', ''),
  (2013, 'fr_FR', 'Bon de livraison - dans l\'en-tête', '', ''),
  (2014, 'fr_FR', 'Bon de livraison - en haut du pied de page', '', ''),
  (2015, 'fr_FR', 'Bon de livraison - mentions légales', '', ''),
  (2016, 'fr_FR', 'Bon de livraison - en bas du pied de page', '', ''),
  (2017, 'fr_FR', 'Bon de livraison - en bas de la zone d\'informations', '', ''),
  (2018, 'fr_FR', 'Bon de livraison - après la zone d\'informations', '', ''),
  (2019, 'fr_FR', 'Bon de livraison - adresse de livraison', '', ''),
  (2020, 'fr_FR', 'Bon de livraison - après la zone d\'adresses', '', ''),
  (2021, 'fr_FR', 'Bon de livraison - après le résumé de la commande', '', ''),

  (2022, 'fr_FR', 'Confirmation de commande - après les récapitulatif de commande', '', ''),

  (2023, 'fr_FR', 'Partout ou l\'éditeur WYSIWYG est nécessaire', '', '')
;

# ======================================================================================================================
# Image / Document visible
# ======================================================================================================================

ALTER TABLE `product_document`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `product_image`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `category_document`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `category_image`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `content_document`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `content_image`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `folder_document`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `folder_image`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `module_image`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;
ALTER TABLE `brand_document`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

ALTER TABLE `brand_image`
  ADD COLUMN `visible` TINYINT DEFAULT 1 NOT NULL
  AFTER `file`
;

-- Add version to customer
ALTER TABLE `customer`
  ADD COLUMN `version` INTEGER DEFAULT 0
;

ALTER TABLE `customer`
  ADD COLUMN `version_created_at` DATETIME
;

ALTER TABLE `customer`
  ADD COLUMN `version_created_by` VARCHAR(100)
;

-- ---------------------------------------------------------------------
-- customer_version
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `customer_version`;

CREATE TABLE `customer_version`
(
    `id` INTEGER NOT NULL,
    `ref` VARCHAR(50),
    `title_id` INTEGER NOT NULL,
    `firstname` VARCHAR(255) NOT NULL,
    `lastname` VARCHAR(255) NOT NULL,
    `email` VARCHAR(255),
    `password` VARCHAR(255),
    `algo` VARCHAR(128),
    `reseller` TINYINT,
    `lang` VARCHAR(10),
    `sponsor` VARCHAR(50),
    `discount` FLOAT,
    `remember_me_token` VARCHAR(255),
    `remember_me_serial` VARCHAR(255),
    `created_at` DATETIME,
    `updated_at` DATETIME,
    `version` INTEGER DEFAULT 0 NOT NULL,
    `version_created_at` DATETIME,
    `version_created_by` VARCHAR(100),
    `order_ids` TEXT,
    `order_versions` TEXT,
    PRIMARY KEY (`id`,`version`),
    CONSTRAINT `customer_version_FK_1`
        FOREIGN KEY (`id`)
        REFERENCES `customer` (`id`)
        ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';



# ======================================================================================================================
# Order placed notification
# ======================================================================================================================

SELECT @store_email := `value` FROM `config` where name='store_email';

INSERT INTO `config` (`name`, `value`, `secured`, `hidden`, `created_at`, `updated_at`) VALUES
('store_notification_emails', IFNULL(@store_email, ''), 1, 1, NOW(), NOW());

SELECT @max_id := MAX(`id`) FROM `message`;

INSERT INTO `message` (`id`, `name`, `secured`, `text_layout_file_name`, `text_template_file_name`, `html_layout_file_name`, `html_template_file_name`, `created_at`, `updated_at`) VALUES
  (@max_id+1, 'order_notification', NULL, NULL, 'order_notification.txt', NULL, 'order_notification.html', NOW(), NOW()),
  (@max_id+2, 'customer_account_changed', 0, NULL, 'account_changed_by_admin.txt', NULL, 'account_changed_by_admin.html', NOW(), NOW()),
  (@max_id+3, 'customer_account_created', 0, NULL, 'account_created_by_admin.txt', NULL, 'account_created_by_admin.html', NOW(), NOW());

INSERT INTO `message_i18n` (`id`, `locale`, `title`, `subject`, `text_message`, `html_message`) VALUES
  (@max_id+1, 'de_DE', 'Gesendete Nachricht wenn eine neue Bestellung erteilt wird.', 'Neue Bestellung {$order_ref} für {config key=\"store_name\"}', NULL, NULL),
  (@max_id+2, 'de_DE', 'Mail an den Kunden geschickt, wenn sein Passwort oder E-Mail von einem Administrator im Back-Office geändert werden', 'Ihre Konto-Zugriff für {config key=\"store_name\"} wurde geändert', NULL, NULL),
  (@max_id+3, 'de_DE', 'Mail an den Kunden geschickt, wenn sein Konto von einem Administrator im Back-Office erstellt wird', 'Ein Konto {config key=\"store_name\"} wurde für Sie erstellt.', NULL, NULL),
  (@max_id+1, 'en_US', 'Message sent to the shop owner when a new order is placed', 'New order {$order_ref} placed on {config key=\"store_name\"}', NULL, NULL),
  (@max_id+2, 'en_US', 'Mail sent to the customer when its password or email is changed in the back-office', 'Your account information on {config key=\"store_name\"} has been changed.', NULL, NULL),
  (@max_id+3, 'en_US', 'Mail sent to the customer when its account is created by an administrator in the back-office', 'A {config key=\"store_name\"} account has been created for you', NULL, NULL),
  (@max_id+1, 'es_ES', 'Mensaje enviado al propietario de la tienda cuando se envía una nueva orden', 'Nueva orden {$order_ref} ubicada en {tecla config = \"store_name\"}', NULL, NULL),
  (@max_id+2, 'es_ES', 'Correo enviado al cliente cuando se cambia su contraseña o correo electrónico en el back-office', 'La información de su cuenta en {tecla config = \"store_name\"} ha sido cambiada.', NULL, NULL),
  (@max_id+3, 'es_ES', 'Correo enviado al cliente cuando se crea su cuenta por un administrador en el back-office', 'Una {config key=\"store_name\"} cuenta ha sido creada para ti', NULL, NULL),
  (@max_id+1, 'fr_FR', 'Message envoyé au gestionnaire de la boutique lors d\'une nouvelle commande.', 'Nouvelle commande {$order_ref} reçue sur {config key=\"store_name\"}', NULL, NULL),
  (@max_id+2, 'fr_FR', 'Message envoyé au client lorsque son mot de passe ou son email est changé dans le back-office', 'L\'accès à votre compte {config key=\"store_name\"} a changé', NULL, NULL),
  (@max_id+3, 'fr_FR', 'Mail envoyé au client lorsque son compte est créé depuis le back-office par un administrateur', 'Un compte {config key=\"store_name\"} vient d\'être créé pour vous.', NULL, NULL)
;

# ======================================================================================================================
# Add Virtual product
# ======================================================================================================================

ALTER TABLE  `product`
  ADD  `virtual` TINYINT DEFAULT 0 NOT NULL
  AFTER  `ref`;

ALTER TABLE  `product_version`
  ADD  `virtual` TINYINT DEFAULT 0 NOT NULL
  AFTER  `ref`;


ALTER TABLE  `order_product`
  ADD  `virtual` TINYINT DEFAULT 0 NOT NULL
  AFTER  `postscriptum`;

ALTER TABLE  `order_product`
  ADD  `virtual_document` VARCHAR(255)
  AFTER  `virtual`;


# ======================================================================================================================
# Add Meta data
# ======================================================================================================================

DROP TABLE IF EXISTS `meta_data`;

CREATE TABLE `meta_data`
(
    `id` INTEGER NOT NULL AUTO_INCREMENT,
    `meta_key` VARCHAR(100) NOT NULL,
    `element_key` VARCHAR(100) NOT NULL,
    `element_id` INTEGER NOT NULL,
    `is_serialized` TINYINT(1) NOT NULL,
    `value` LONGTEXT NOT NULL,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`),
    INDEX `meta_data_key_element_idx` (`meta_key`, `element_key`, `element_id`)
) ENGINE=InnoDB CHARACTER SET='utf8';


# ======================================================================================================================
# Allow negative stock
# ======================================================================================================================

INSERT INTO `config` (`name`, `value`, `secured`, `hidden`, `created_at`, `updated_at`) VALUES
  ('allow_negative_stock', '0', 0, 0, NOW(), NOW());

SELECT @max_id := MAX(`id`) FROM `config`;

INSERT INTO `config_i18n` (`id`, `locale`, `title`, `description`, `chapo`, `postscriptum`) VALUES
(@max_id, 'de_DE', 'Negativen Lagerbestand erlauben (1) oder nicht (0)(Standartwert 0)', NULL, NULL, NULL),
(@max_id, 'en_US', 'Allow negative product stock (1) or not (0, default)', NULL, NULL, NULL),
(@max_id, 'es_ES', 'Permite valores negativos producto (1) o no (valor por defecto 0,)', NULL, NULL, NULL),
(@max_id, 'fr_FR', 'Autoriser le stock négatif (1) ou pas (0) (0 par défaut)', NULL, NULL, NULL)
;

# ======================================================================================================================
# Module configuration
# ======================================================================================================================

-- ---------------------------------------------------------------------
-- module_config
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `module_config`;

CREATE TABLE `module_config`
(
  `id` INTEGER NOT NULL AUTO_INCREMENT,
  `module_id` INTEGER NOT NULL,
  `name` VARCHAR(255) NOT NULL,
  `created_at` DATETIME,
  `updated_at` DATETIME,
  PRIMARY KEY (`id`),
  INDEX `idx_module_id_name` (`module_id`, `name`),
  CONSTRAINT `fk_module_config_module_id`
  FOREIGN KEY (`module_id`)
  REFERENCES `module` (`id`)
    ON UPDATE RESTRICT
    ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

-- ---------------------------------------------------------------------
-- module_config_i18n
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `module_config_i18n`;

CREATE TABLE `module_config_i18n`
(
  `id` INTEGER NOT NULL,
  `locale` VARCHAR(5) DEFAULT 'en_US' NOT NULL,
  `value` TEXT,
  PRIMARY KEY (`id`,`locale`),
  CONSTRAINT `module_config_i18n_FK_1`
  FOREIGN KEY (`id`)
  REFERENCES `module_config` (`id`)
    ON DELETE CASCADE
) ENGINE=InnoDB CHARACTER SET='utf8';

# ======================================================================================================================
# Update of short title Mister
# ======================================================================================================================

-- en_US
UPDATE `customer_title_i18n`
  SET `short` = 'Mr.'
  WHERE `customer_title_i18n`.`id` = 1
    AND `customer_title_i18n`.`locale` = 'en_US';
-- fr_FR
UPDATE `customer_title_i18n`
  SET `short` = 'M.'
  WHERE `customer_title_i18n`.`id` = 1
    AND `customer_title_i18n`.`locale` = 'fr_FR';


# ======================================================================================================================
# Adding missing resources
# ======================================================================================================================

SELECT @max_id := MAX(`id`) FROM `resource`;

INSERT INTO resource (`id`, `code`, `created_at`, `updated_at`) VALUES
(@max_id+1, 'admin.hook', NOW(), NOW()),
(@max_id+2, 'admin.module-hook', NOW(), NOW()),
(@max_id+3, 'admin.sales', NOW(), NOW()),
(@max_id+4, 'admin.administrator', NOW(), NOW()),
(@max_id+5, 'admin.configuration.category', NOW(), NOW()),
(@max_id+6, 'admin.configuration.shipping-configuration', NOW(), NOW()),
(@max_id+7, 'admin.configuration.tax-rule', NOW(), NOW()),
(@max_id+8, 'admin.hooks', NOW(), NOW()),
(@max_id+9, 'admin.import', NOW(), NOW()),
(@max_id+10, 'admin.modules', NOW(), NOW()),
(@max_id+11, 'admin.profile', NOW(), NOW())
;

INSERT INTO resource_i18n (`id`, `locale`, `title`) VALUES
  (@max_id+1, 'de_DE', 'Andockpunkte'),
  (@max_id+2, 'de_DE', 'Hook Positionen'),
  (@max_id+3, 'de_DE', 'Sonderangebotsmanagement'),
  (@max_id+4, 'de_DE', 'Administratorenliste'),
  (@max_id+5, 'de_DE', 'Kategorie-Konfiguration'),
  (@max_id+6, 'de_DE', 'Lieferungskonfiguration'),
  (@max_id+7, 'de_DE', 'Taxeregelung-Konfiguration'),
  (@max_id+8, 'de_DE', 'Hooks Verwendung'),
  (@max_id+9, 'de_DE', 'Importation / Exportation von Daten'),
  (@max_id+10, 'de_DE', 'Modul Verwendung'),
  (@max_id+11, 'de_DE', 'Administration-Profilverwaltung'),
  (@max_id+1, 'en_US', 'Hooks'),
  (@max_id+2, 'en_US', 'Hook positions'),
  (@max_id+3, 'en_US', 'Sales management'),
  (@max_id+4, 'en_US', 'Administrator list'),
  (@max_id+5, 'en_US', 'Category configuration'),
  (@max_id+6, 'en_US', 'Shipping configuration'),
  (@max_id+7, 'en_US', 'Tax rules configuration'),
  (@max_id+8, 'en_US', 'Hooks management'),
  (@max_id+9, 'en_US', 'Data import / export'),
  (@max_id+10, 'en_US', 'Modules management'),
  (@max_id+11, 'en_US', 'Administration profiles management'),
  (@max_id+1, 'es_ES', 'Hooks'),
  (@max_id+2, 'es_ES', 'Posiciones de hook'),
  (@max_id+3, 'es_ES', 'Administración de ventas'),
  (@max_id+4, 'es_ES', 'Lista de administrador'),
  (@max_id+5, 'es_ES', 'Configuración de la categoría'),
  (@max_id+6, 'es_ES', 'Configuración de envío'),
  (@max_id+7, 'es_ES', 'Configuración de las reglas de impuestos'),
  (@max_id+8, 'es_ES', 'Gestión de Hooks'),
  (@max_id+9, 'es_ES', 'Importación/ exportación de datos'),
  (@max_id+10, 'es_ES', 'Administración de módulos'),
  (@max_id+11, 'es_ES', 'Gestión de perfiles de administración'),
  (@max_id+1, 'fr_FR', 'Points d\'accroche'),
  (@max_id+2, 'fr_FR', 'Positions des points d\'accroche'),
  (@max_id+3, 'fr_FR', 'Gestion des promotions'),
  (@max_id+4, 'fr_FR', 'Liste des administrateurs'),
  (@max_id+5, 'fr_FR', 'Configuration d\'une catégorie'),
  (@max_id+6, 'fr_FR', 'Configuration du transport'),
  (@max_id+7, 'fr_FR', 'Configuration des règles de taxes'),
  (@max_id+8, 'fr_FR', 'Gestion des hooks'),
  (@max_id+9, 'fr_FR', 'Importation / exportation de données'),
  (@max_id+10, 'fr_FR', 'Gestion des modules'),
  (@max_id+11, 'fr_FR', 'Gestion des profils d\'administration')
;

# ======================================================================================================================
# Adding cart id in order table
# ======================================================================================================================

ALTER TABLE  `order_version`
  ADD  `customer_id_version` INTEGER DEFAULT 0
  AFTER  `version_created_by`;


# ======================================================================================================================
# End of changes
# ======================================================================================================================

SET FOREIGN_KEY_CHECKS = 1;
