<?php

/*
 * This file is part of the Thelia package.
 * http://www.thelia.net
 *
 * (c) OpenStudio <info@thelia.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Thelia\Core\Event\Category;

class CategoryUpdateEvent extends CategoryCreateEvent
{
    /** @var int */
    protected $category_id;

    protected $chapo;
    protected $description;
    protected $postscriptum;

    protected $parent;

    protected $defaultTemplateId;

    /**
     * @param int $category_id
     */
    public function __construct($category_id)
    {
        $this->category_id = $category_id;
    }

    public function getCategoryId()
    {
        return $this->category_id;
    }

    public function setCategoryId($category_id)
    {
        $this->category_id = $category_id;

        return $this;
    }

    public function getChapo()
    {
        return $this->chapo;
    }

    public function setChapo($chapo)
    {
        $this->chapo = $chapo;

        return $this;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    public function getPostscriptum()
    {
        return $this->postscriptum;
    }

    public function setPostscriptum($postscriptum)
    {
        $this->postscriptum = $postscriptum;

        return $this;
    }

    public function getParent()
    {
        return $this->parent;
    }

    public function setParent($parent)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * @return int
     */
    public function getDefaultTemplateId()
    {
        return $this->defaultTemplateId;
    }

    /**
     * @param int $defaultTemplateId
     *
     * @return $this
     */
    public function setDefaultTemplateId($defaultTemplateId)
    {
        $this->defaultTemplateId = $defaultTemplateId;

        return $this;
    }
}
