<?php

/*
 * This file is part of the Thelia package.
 * http://www.thelia.net
 *
 * (c) OpenStudio <info@thelia.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Thelia\Core\Event\Contact;

use Symfony\Component\Form\Form;
use Thelia\Core\Event\ActionEvent;

/**
 * Class ContactController.
 *
 * @author Vincent Lopes-Vicente <vlopesvicente@gmail.com>
 *
 * @since 2.4
 */
class ContactEvent extends ActionEvent
{
    /** @var Form */
    protected $form;

    /** @var string */
    protected $subject;

    /** @var string */
    protected $message;

    /** @var string */
    protected $email;

    /** @var string */
    protected $name;

    public function __construct(Form $form)
    {
        $this->form = $form;

        $this->subject = $form->get('subject')->getData();
        $this->message = $form->get('message')->getData();
        $this->email = $form->get('email')->getData();
        $this->name = $form->get('name')->getData();
    }

    /**
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     *
     * @return ContactEvent
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     *
     * @return ContactEvent
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return ContactEvent
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return ContactEvent
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }
}
