<?php

/*
 * This file is part of the Thelia package.
 * http://www.thelia.net
 *
 * (c) OpenStudio <info@thelia.net>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Thelia\Log;

use Thelia\Model\ConfigQuery;

class TlogDestinationConfig
{
    public const TYPE_TEXTAREA = 1;
    public const TYPE_TEXTFIELD = 2;

    protected $name;
    protected $title;
    protected $label;
    protected $default;
    protected $type;
    protected $value;

    public function __construct($name, $title, $label, $default, $type)
    {
        $this->name = $name;
        $this->title = $title;
        $this->label = $label;
        $this->default = $default;
        $this->type = $type;
        $this->value = ConfigQuery::read($this->name, $this->default);
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name): void
    {
        $this->name = $name;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function setTitle($title): void
    {
        $this->title = $title;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label): void
    {
        $this->label = $label;
    }

    public function getDefault()
    {
        return $this->default;
    }

    public function setDefault($default): void
    {
        $this->default = $default;
    }

    public function getType()
    {
        return $this->type;
    }

    public function setType($type): void
    {
        $this->type = $type;
    }

    public function getValue()
    {
        return $this->value;
    }

    public function setValue($value): void
    {
        $this->value = $value;
    }
}
