<?php

/**
 * GIT VERSION: 10813
 *
 * Some of the following constants are automatically filled in when
 * the build process is run. If you change them in site/index.php
 * and rerun the build process your changes will be lost
 *
 * APP_PATH   absolute path to the php files of the app
 * DEBUG_MODE flag to enable easier debugging and development
 * CACHE_ID   unique string to bust js/css browser caching for a new build
 * SITE_ID    random site id used for page keys
 */
define('APP_PATH', '/Users/rodriguezny/tikipack/21.12/tiki-21.12/vendor_bundled/vendor/jason-munro/cypht/');
define('VENDOR_PATH', APP_PATH.'vendor/');
define('WEB_ROOT', '');
define('DEBUG_MODE', false);
define('CACHE_ID', 'SQGRokp9QXfou7d4lcJEp33PCJ%2FuALoLfN7CYrDG5R4%3D');
define('SITE_ID', 'UcUcFYwyw5Ep1XUKn%2Fty%2FdRc21ti6uUwEO5Q4Zkq9EPju%2FL7upsyOZfO%2Br3mBlbXqTkA67B0P4%2BQqUYQpszW2w%3D%3D');
define('JS_HASH', 'sha512-dT7LbPSHOSvgv0uR4+p215GbojkxpVHZ4k36vAZbqclxKmSywzz7XmWHQNqp30vrsm0Kpic+DlgIykQ/Xv7OfQ==');
define('CSS_HASH', 'sha512-oPNr5jKyXJWdiGhj84zTwRR8pG+imW7WQsFfe4CV9hK7KmiIRbgDmXx+40Yd8Rg5yliSkkYdZdXBP6CKLUH2WQ==');

/* show all warnings in debug mode */
if (DEBUG_MODE) {
    error_reporting(E_ALL | E_STRICT);
}

/* config file location */
define('CONFIG_FILE', APP_PATH.'hm3.rc');

/* don't let anything output content until we are ready */
ob_start();

/* set default TZ */
date_default_timezone_set( 'UTC' );

/* get includes */
require APP_PATH.'lib/framework.php';

/* get configuration */
$config = new Hm_Site_Config_File(CONFIG_FILE);

/* setup ini settings */
if (!$config->get('disable_ini_settings')) {
    require APP_PATH.'lib/ini_set.php';
}

/* process the request */
new Hm_Dispatch($config);

/* log some debug stats about the page */
if (DEBUG_MODE) {
    Hm_Debug::load_page_stats();
    Hm_Debug::show();
}
