<?php

// (c) Copyright by authors of the Tiki Wiki CMS Groupware Project
//
// All Rights Reserved. See copyright.txt for details and a complete list of authors.
// Licensed under the GNU LESSER GENERAL PUBLIC LICENSE. See license.txt for details.
function prefs_tracker_list()
{
    return [
        'tracker_remote_sync' => [
            'name' => tr('Synchronize remote tracker'),
            'description' => tr('Enable a tracker to be cloned on a remote host, and synchronize the data locally on demand.'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_refresh_itemlink_detail' => [
            'name' => tr('Refresh item link items when the master is modified'),
            'description' => tr('To be used when item link is used in trackers so that the index remains in good shape when data on the master that is indexed with the detail is modified and used to search on.'),
            'type' => 'flag',
            'default' => 'y',
        ],
        'tracker_refresh_itemslist_detail' => [
            'name' => tr('Refresh items list items when related items are created or modified'),
            'description' => tr('Use this to enable the ItemsList fields to refresh their content in the search index when related tracker items are created or modified.'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_clone_item' => [
            'name' => tr('Duplicate tracker items'),
            'description' => tr('Allow copying tracker item information to a new tracker item. If the item has an item-link linked, it will automatically create new child item. This last can be turned on and off per case on the item-link tracker fields options.'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_insert_allowed' => [
            'name' => tr('Trackers available for insertion from wiki pages'),
            'description' => tr('List of tracker IDs made available when attempting to insert'),
            'type' => 'text',
            'filter' => 'int',
            'separator' => ',',
            'default' => [],
            'profile_reference' => 'tracker',
        ],
        'tracker_change_field_type' => [
            'name' => tr('Change field types'),
            'description' => tr('Allow field type to be changed after creation.'),
            'type' => 'flag',
            'default' => 'y',
            'warning' => tra('Use with care!'),
        ],
        'tracker_show_comments_below' => [
            'name' => tr('Show comments below items'),
            'description' => tr('Show comments for a tracker item below the item itself as in other trackers, instead of enclosed in a tab'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_legacy_insert' => [
            'name' => tr('Insert and edit items in a tab'),
            'description' => tr('Edit tracker items in a tab instead of a popup dialog.'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_status_in_objectlink' => [
            'name' => tr('Show tracker status in objectlink'),
            'description' => tr('Show the status when doing an objectlink. This can be used to show the status in tracker screens but not in outputs.'),
            'type' => 'flag',
            'default' => 'y',
        ],
        'tracker_wikirelation_synctitle' => [
            'name' => tr('Sync wiki page name to linked tracker field'),
            'description' => tr('When the wiki page is renamed or when the value of the tracker field that is linked to the wiki page is changed, make the corresponding change as well to the other linked via tiki.wiki.linkedfield relation.'),
            'type' => 'flag',
            'tags' => ['advanced'],
            'default' => 'n',
        ],
        'tracker_wikirelation_redirectpage' => [
            'name' => tr('Redirect page views to the linked tracker item'),
            'description' => tr('Redirect the user to the tracker item when trying to view a wiki page that has a linked tracker item via tiki.wiki.linkeditem relation. Can be bypassed by adding &admin (?admin in sefurl) to the URL.'),
            'warning' => tra('To get to the wiki page after activation, you can add &admin (?admin in sefurl) to the URL.'),
            'type' => 'flag',
            'tags' => ['advanced'],
            'default' => 'n',
        ],
        'tracker_article_tracker' => [
             'name' => tr('Tracker for articles'),
             'description' => tr('Have a tracker to supplement article information'),
             'type' => 'flag',
            'tags' => ['advanced'],
             'default' => 'n',
             'dependencies' => ['feature_articles', 'feature_trackers', 'tracker_article_trackerId'],
         ],
         'tracker_article_trackerId' => [
             'name' => tr('Tracker ID of tracker for articles'),
             'description' => tr('A tracker for articles must contain an "Articles" field'),
             'type' => 'text',
            'tags' => ['advanced'],
             'size' => '3',
             'filter' => 'digits',
             'default' => '',
             'profile_reference' => 'tracker',
         ],
        'tracker_article_indexing' => [
            'name' => tr("Index article info in tracker item"),
            'description' => tr('Sets whether the article info should be indexed in the tracker item. This automatically sets the article field to read-only and sets up categorization synchronization between articles and tracker items.'),
            'type' => 'flag',
            'tags' => ['advanced'],
            'default' => 'n',
            'dependencies' => ['feature_articles', 'feature_trackers', 'tracker_article_trackerId', 'tracker_article_tracker'],
        ],
        'tracker_tabular_enabled' => [
            'name' => tr('Tracker Import-Export'),
            'description' => tr('Allows management of import/export tracker profiles and management of custom list formats.'),
            'type' => 'flag',
            'default' => 'y',
            'dependencies' => ['feature_trackers'],
            'tags' => ['advanced'],
            'help' => 'Tracker-Import-Export',
        ],
        'tracker_always_notify' => [
            'name' => tr('Always notify watchers'),
            'description' => tr('Send item updated notifications to watchers even if nothing has changed.'),
            'type' => 'flag',
            'default' => 'n',
            'dependencies' => ['feature_trackers'],
        ],
        'tracker_force_fill' => [
            'name' => tr('Require users to fill in tracker information'),
            'description' => tr("Require users to fill in a tracker form if not done already by prompting them with a modal dialog."),
            'help' => 'Force-Fill-Tracker',
            'type' => 'flag',
            'tags' => ['advanced'],
            'default' => 'n',
            'dependencies' => ['feature_trackers'],
        ],
        'tracker_force_tracker_id' => [
            'name' => tr('Tracker ID of tracker required to be filled in'),
            'description' => tr('A tracker for articles must contain an "Articles" field'),
            'type' => 'text',
            'tags' => ['advanced'],
            'size' => '3',
            'filter' => 'digits',
            'default' => '',
            'dependencies' => ['tracker_force_fill'],
        ],
        'tracker_force_mandatory_field' => [
            'name' => tr('Mandatory tracker field to check for required filling in'),
            'description' => tr('The permname of field that is checked to see if user has completed the form. If field is empty, user has not completed it.'),
            'type' => 'text',
            'tags' => ['advanced'],
            'default' => '',
            'dependencies' => ['tracker_force_fill'],
        ],
        'tracker_force_tracker_fields' => [
            'name' => tr('Fields that are asked for in the modal for force-filling'),
            'description' => tr('Comma-separated permanent names of fields that are requested in the modal for required filling in. If empty, all fields are requested'),
            'type' => 'text',
            'tags' => ['advanced'],
            'default' => '',
            'dependencies' => ['tracker_force_fill'],
        ],
        'tracker_prefixalias_on_links' => [
            'name' => tr('Tracker item links use prefix alias'),
            'description' => tr('Links for tracker items will use the prefix alias automatically everywhere.'),
            'type' => 'flag',
            'default' => 'y',
            'dependencies' => ['feature_trackers','feature_sefurl', 'feature_sefurl_tracker_prefixalias'],
        ],
        'tracker_adminonlyviewedititem_by_default' => [
            'name' => tr('All new trackers are restricted to wiki page access only by default'),
            'description' => tr('Option "Restrict non admins to wiki page access only" is not checked by default.'),
            'type' => 'flag',
            'default' => 'n',
            'dependencies' => ['feature_trackers'],
        ],
        'tracker_display_categories' => [
            'name' => tr('Display categories in trackers list'),
            'description' => tr('Add a new column with tracker categories in the admin trackers list.'),
            'type' => 'flag',
            'default' => 'n',
            'dependencies' => ['feature_categories'],
        ],
        'tracker_display_wiki_only_status' => [
            'name' => tr('Display Wiki-Only status in trackers list'),
            'description' => tr('Show whether trackers are restricted to wiki page access for non-admin users.'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_report_resize_button' => [
            'name' => tr('Tracker report resize button'),
            'description' => tr('Add a button to resize long tracker reports.'),
            'type' => 'flag',
            'default' => 'n',
        ],
        'tracker_list_order' => [
            'name' => tr('Tracker list order'),
            'description' => tr('Default order for the main tracker list.'),
            'type' => 'list',
            'perspective' => false,
            'options' => [
                'trackerId_asc' => tra('Id Ascending'),
                'trackerId_desc' => tra('Id Descending'),
                'created_asc' => tra('Created Ascending'),
                'created_desc' => tra('Created Descending'),
                'name_asc' => tra('Name Ascending'),
                'name_desc' => tra('Name Descending'),
                'lastModif_asc' => tra('Last Modified Ascending'),
                'lastModif_desc' => tra('Last Modified Descending'),
                'items_asc' => tra('Number of Items Ascending'),
                'items_desc' => tra('Number of Items Descending'),
            ],
            'default' => 'created_desc',
        ],
        'tracker_history_diff_style' => [
            'name' => tr('Tracker History Diff Style'),
            'description' => tr('Default style for tracker history.'),
            'type' => 'list',
            'perspective' => false,
            'options' => [
                '' => tr('Original'),
                'sidediff' => tr('Side-by-side diff'),
                'inlinediff' => tr('Inline diff'),
                'unidiff' => tr('Unified diff'),
            ],
            'default' => 'sidediff',
        ],
        'tracker_field_rules' => [
            'name' => tr('Tracker Field Rules'),
            'description' => tr('Conditional rules for tracker fields.'),
            'type' => 'flag',
            'default' => 'y',
            'dependencies' => [
                'feature_trackers',
                'vuejs_enable',
                'feature_jquery_validation',
            ],
            'tags' => [ 'experimental' ],
            'warning' => tra('Experimental new feature, expect some issues.'),
        ],
        'tracker_autoincrement_resettable' => [
            'name' => tr('Allow autoincrement fields start value to be reset to a new value'),
            'description' => tr('In some use cases like sequential numbers that begin by the current year, e.g. 20210001, the autoincrement value may have to be annually reset. In this case, just update the start value in the field definition.'),
            'type' => 'flag',
            'default' => 'n',
            'tags' => ['experimental'],
            'warning' => tra('Use with care, potential for data loss.'),
        ],
        'tracker_currency_default_locale' => [
            'name' => tr('Default locale for currency formatting'),
            'description' => tr('Currency fields use a system locale to format the output of currency values. Set the default one here when none is selected in the field themselves. Visit "Server Check" page for a list of available system locales.'),
            'type' => 'text',
            'default' => '',
        ],
        'tracker_system_currency' => [
            'name' => tr('Exchange rates tracker'),
            'description' => tr('Allow defining a specific tracker to hold the exchange rates for currency calculations. You should manually create a tracker with at least 3 fields to hold Currency, Rate and Date.'),
            'type' => 'flag',
            'dependencies' => [
                'trackerfield_currency',
            ],
            'default' => 'n',
        ],
        'tracker_system_currency_tracker' => [
            'name' => tr('Choose tracker'),
            'description' => tr('Choose which tracker will store the currency conversion rates used for currency calculations.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_currency',
            ],
            'default' => '',
            'profile_reference' => 'tracker',
        ],
        'tracker_system_currency_rate' => [
            'name' => tr('Rate field'),
            'description' => tr('Choose the field that stores the exchange rate in the system currency tracker.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_currency',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_currency_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_currency_currency' => [
            'name' => tr('Currency field'),
            'description' => tr('Choose the field that stores the currency in the system currency tracker.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_currency',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_currency_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_currency_date' => [
            'name' => tr('Date field'),
            'description' => tr('Choose the field that stores the exchange rate date in the system currency tracker.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_currency',
            ],
            'default' => '',
            'parent' => '[name=tracker_system_currency_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_currency_direction' => [
            'name' => tr('Rate direction'),
            'description' => tr('Straight means Base currency is equal to Target multiplied by the exchange rate. Reverse means Base is equal to Target divided by the exchange rate. In both cases, the Base currency should have an exchange rate of 1.00'),
            'type' => 'list',
            'options' => [
                'straight' => tr('Straight (Target/Base)'),
                'reverse' => tr('Reverse (Base/Target)'),
            ],
            'default' => 'straight',
        ],
        'tracker_system_bounces' => [
            'name' => tr('Email bounces tracker'),
            'description' => tr('Allow defining a specific tracker to hold email bounces registered in Tiki and block sending emails out of Tiki to specific mailboxes.'),
            'type' => 'flag',
            'dependencies' => [
                'trackerfield_currency',
            ],
            'default' => 'n',
        ],
        'tracker_system_bounces_tracker' => [
            'name' => tr('Choose tracker'),
            'description' => tr('Choose which tracker will store the bounced emails and statistics.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_bounces',
            ],
            'default' => '',
            'profile_reference' => 'tracker',
        ],
        'tracker_system_bounces_mailbox' => [
            'name' => tr('Mailbox field'),
            'description' => tr('Choose an email field that stores the email address that bounced.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_bounces',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_bounces_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_bounces_emailfolder' => [
            'name' => tr('Email folder field'),
            'description' => tr('Choose an email folder field that stores the bounced messages read by Tiki.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_bounces',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_bounces_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_bounces_soft_total' => [
            'name' => tr('Total soft bounces field'),
            'description' => tr('Choose a numeric field that stores the total number of soft bounces occured for an email address.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_bounces',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_bounces_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_bounces_hard_total' => [
            'name' => tr('Total hard bounces field'),
            'description' => tr('Choose a numeric field that stores the total number of hard bounces occured for an email address.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_bounces',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_bounces_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
        'tracker_system_bounces_blacklisted' => [
            'name' => tr('Blacklisted field'),
            'description' => tr('Choose a checkbox field that stores the blacklist state for an email address - whether Tiki should skip sending emails to that email address or not.'),
            'type' => 'text',
            'dependencies' => [
                'tracker_system_bounces',
            ],
            'default' => '',
            'parent' => 'input[name=tracker_system_bounces_tracker]',
            'parentkey' => 'tracker_id',
            'profile_reference' => 'tracker_field',
        ],
    ];
}
