<?php

namespace garethp\ews\API\Type;

use garethp\ews\API\Type;

/**
 * Class representing FindMessageTrackingSearchResultType
 *
 *
 * XSD Type: FindMessageTrackingSearchResultType
 *
 * @method string getSubject()
 * @method FindMessageTrackingSearchResultType setSubject(string $subject)
 * @method EmailAddressType getSender()
 * @method FindMessageTrackingSearchResultType setSender(EmailAddressType $sender)
 * @method EmailAddressType getPurportedSender()
 * @method FindMessageTrackingSearchResultType setPurportedSender(EmailAddressType $purportedSender)
 * @method FindMessageTrackingSearchResultType addRecipients(EmailAddressType $recipients)
 * @method EmailAddressType[] getRecipients()
 * @method FindMessageTrackingSearchResultType setRecipients(array $recipients)
 * @method \DateTime getSubmittedTime()
 * @method FindMessageTrackingSearchResultType setSubmittedTime(\DateTime $submittedTime)
 * @method string getMessageTrackingReportId()
 * @method FindMessageTrackingSearchResultType setMessageTrackingReportId(string $messageTrackingReportId)
 * @method string getPreviousHopServer()
 * @method FindMessageTrackingSearchResultType setPreviousHopServer(string $previousHopServer)
 * @method string getFirstHopServer()
 * @method FindMessageTrackingSearchResultType setFirstHopServer(string $firstHopServer)
 * @method FindMessageTrackingSearchResultType addProperties(TrackingPropertyType $properties)
 * @method TrackingPropertyType[] getProperties()
 * @method FindMessageTrackingSearchResultType setProperties(array $properties)
 */
class FindMessageTrackingSearchResultType extends Type
{

    /**
     * @var string
     */
    protected $subject = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $sender = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType
     */
    protected $purportedSender = null;

    /**
     * @var \garethp\ews\API\Type\EmailAddressType[]
     */
    protected $recipients = null;

    /**
     * @var \DateTime
     */
    protected $submittedTime = null;

    protected $_typeMap = array(
        'submittedTime' => 'dateTime',
    );

    /**
     * @var string
     */
    protected $messageTrackingReportId = null;

    /**
     * @var string
     */
    protected $previousHopServer = null;

    /**
     * @var string
     */
    protected $firstHopServer = null;

    /**
     * @var \garethp\ews\API\Type\TrackingPropertyType[]
     */
    protected $properties = null;
}
