
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `tiki284`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[indexName]]`
--

CREATE TABLE `[[indexName]]` (
  `id` int NOT NULL AUTO_INCREMENT,
  `object_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` varchar(235) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `creation_date` datetime DEFAULT NULL,
  `modification_date` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `language` text COLLATE utf8mb4_unicode_ci,
  `gallery_id` text COLLATE utf8mb4_unicode_ci,
  `view_permission` text COLLATE utf8mb4_unicode_ci,
  `attachments` text COLLATE utf8mb4_unicode_ci,
  `primary_image` text COLLATE utf8mb4_unicode_ci,
  `comment_count` float DEFAULT NULL,
  `categories` text COLLATE utf8mb4_unicode_ci,
  `deep_categories` text COLLATE utf8mb4_unicode_ci,
  `geo_located` text COLLATE utf8mb4_unicode_ci,
  `geo_location` text COLLATE utf8mb4_unicode_ci,
  `allowed_groups` text COLLATE utf8mb4_unicode_ci,
  `allowed_users` text COLLATE utf8mb4_unicode_ci,
  `relations` text COLLATE utf8mb4_unicode_ci,
  `relation_types` text COLLATE utf8mb4_unicode_ci,
  `relation_count` text COLLATE utf8mb4_unicode_ci,
  `title_initial` text COLLATE utf8mb4_unicode_ci,
  `title_firstword` text COLLATE utf8mb4_unicode_ci,
  `searchable` text COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `contents` mediumtext COLLATE utf8mb4_unicode_ci,
  `title_unstemmed` text COLLATE utf8mb4_unicode_ci,
  `lastlogin_date` datetime DEFAULT NULL,
  `currentlogin_date` datetime DEFAULT NULL,
  `user_country` text COLLATE utf8mb4_unicode_ci,
  `user_gender` text COLLATE utf8mb4_unicode_ci,
  `user_homepage` text COLLATE utf8mb4_unicode_ci,
  `user_realName` text COLLATE utf8mb4_unicode_ci,
  `user_allowmsgs` text COLLATE utf8mb4_unicode_ci,
  `user_language` text COLLATE utf8mb4_unicode_ci,
  `user_style` text COLLATE utf8mb4_unicode_ci,
  `user_page` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `object_type` (`object_type`,`object_id`(160))
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[indexName]]`
--

INSERT INTO `[[indexName]]` VALUES
(1, 'file gallery', '1', 'File Galleries', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'F', 'File', 'y', 'tiki-list_file_gallery.php?galleryId=1', '  File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'file gallery', '2', 'Users File Galleries', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'U', 'Users', 'y', 'tiki-list_file_gallery.php?galleryId=2', '  Users File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'file gallery', '3', 'Wiki Attachments', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'W', 'Wiki', 'y', 'tiki-list_file_gallery.php?galleryId=3', '  Wiki Attachments  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'group', 'Anonymous', 'Anonymous', NULL, NULL, NULL, 'Public users not logged', NULL, NULL, 'tiki_p_group_view', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Anonymous', 'n', 'Anonymous', '  Anonymous Public users not logged ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'group', 'Registered', 'Registered', NULL, NULL, NULL, 'Users logged into the system', NULL, NULL, 'tiki_p_group_view', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'R', 'Registered', 'n', 'Registered', '  Registered Users logged into the system ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, 'group', 'Admins', 'Admins', NULL, NULL, NULL, 'Administrator and accounts managers.', NULL, NULL, 'tiki_p_group_view', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Admins', 'n', 'Admins', '  Admins Administrator and accounts managers. ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 'user', 'admin', 'System Administrator', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 'tiki_p_list_users', '', '', 0, 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'tokenucxadpytbzfzrzqfuaxaqcrbfuzqdcbq', 'n', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf', '', '', '', '', 'S', 'System', 'n', 'admin', '  System Administrator [[regtime]]   ', 'System Administrator', '[[regtime]]', '[[regtime]]', '', '', '', 'System Administrator', 'y', 'tokenycfefedxfbytywbaaucdupydwdqbbudw', '', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf');

-- --------------------------------------------------------

--
-- Table structure for table `messu_archive`
--

CREATE TABLE `messu_archive` (
  `msgId` int NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_messages`
--

CREATE TABLE `messu_messages` (
  `msgId` int NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  PRIMARY KEY (`msgId`),
  KEY `userIsRead` (`user`(190),`isRead`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_sent`
--

CREATE TABLE `messu_sent` (
  `msgId` int NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int unsigned NOT NULL,
  `expireref` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob NOT NULL,
  PRIMARY KEY (`sesskey`),
  KEY `expiry` (`expiry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_account`
--

CREATE TABLE `tiki_acct_account` (
  `accountBookId` int unsigned NOT NULL,
  `accountId` int unsigned NOT NULL DEFAULT '0',
  `accountName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `accountNotes` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `accountBudget` double NOT NULL DEFAULT '0',
  `accountLocked` int NOT NULL DEFAULT '0',
  `accountTax` int NOT NULL DEFAULT '0',
  `accountUserId` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`accountBookId`,`accountId`),
  KEY `accountTax` (`accountTax`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_bankaccount`
--

CREATE TABLE `tiki_acct_bankaccount` (
  `bankBookId` int unsigned NOT NULL,
  `bankAccountId` int unsigned NOT NULL,
  `externalNumber` int NOT NULL,
  `bankCountry` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankCode` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankIBAN` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankBIC` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankDelimeter` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ';',
  `bankDecPoint` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `bankThousand` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `bankHasHeader` tinyint(1) NOT NULL DEFAULT '1',
  `fieldNameAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameBookingDate` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `formatBookingDate` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameValueDate` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `formatValueDate` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameBookingText` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameReason` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartName` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartBankCode` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameAmount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amountType` int unsigned NOT NULL,
  `fieldNameAmountSign` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SignPositive` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SignNegative` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`bankBookId`,`bankAccountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_book`
--

CREATE TABLE `tiki_acct_book` (
  `bookId` int unsigned NOT NULL AUTO_INCREMENT,
  `bookName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bookClosed` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `bookStartDate` date DEFAULT NULL,
  `bookEndDate` date DEFAULT NULL,
  `bookCurrency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'EUR',
  `bookCurrencyPos` int NOT NULL,
  `bookDecimals` int NOT NULL DEFAULT '2',
  `bookDecPoint` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `bookThousand` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `exportSeparator` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ';',
  `exportEOL` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LF',
  `exportQuote` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '"',
  `bookAutoTax` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`bookId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_item`
--

CREATE TABLE `tiki_acct_item` (
  `itemId` int NOT NULL AUTO_INCREMENT,
  `itemBookId` int unsigned NOT NULL,
  `itemJournalId` int unsigned NOT NULL DEFAULT '0',
  `itemAccountId` int unsigned NOT NULL DEFAULT '0',
  `itemType` int NOT NULL DEFAULT '-1',
  `itemAmount` double NOT NULL DEFAULT '0',
  `itemText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_journal`
--

CREATE TABLE `tiki_acct_journal` (
  `journalBookId` int unsigned NOT NULL,
  `journalId` int unsigned NOT NULL AUTO_INCREMENT,
  `journalDate` date DEFAULT NULL,
  `journalDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `journalCancelled` int NOT NULL DEFAULT '0',
  `journalTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`journalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stack`
--

CREATE TABLE `tiki_acct_stack` (
  `stackBookId` int unsigned NOT NULL,
  `stackId` int unsigned NOT NULL AUTO_INCREMENT,
  `stackDate` date DEFAULT NULL,
  `stackDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stackTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`stackId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stackitem`
--

CREATE TABLE `tiki_acct_stackitem` (
  `stackBookId` int unsigned NOT NULL,
  `stackItemStackId` int unsigned NOT NULL DEFAULT '0',
  `stackItemAccountId` int unsigned NOT NULL DEFAULT '0',
  `stackItemType` int NOT NULL DEFAULT '-1',
  `stackItemAmount` double NOT NULL DEFAULT '0',
  `stackItemText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stackBookId`,`stackItemStackId`,`stackItemAccountId`,`stackItemType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_statement`
--

CREATE TABLE `tiki_acct_statement` (
  `statementBookId` int unsigned NOT NULL,
  `statementAccountId` int unsigned NOT NULL DEFAULT '0',
  `statementId` int unsigned NOT NULL AUTO_INCREMENT,
  `statementBookingDate` date DEFAULT NULL,
  `statementValueDate` date DEFAULT NULL,
  `statementBookingText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementReason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpart` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpartAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpartBankCode` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementAmount` double NOT NULL,
  `statementJournalId` int unsigned NOT NULL DEFAULT '0',
  `statementStackId` int NOT NULL,
  PRIMARY KEY (`statementId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_tax`
--

CREATE TABLE `tiki_acct_tax` (
  `taxBookId` int unsigned NOT NULL,
  `taxId` int unsigned NOT NULL AUTO_INCREMENT,
  `taxText` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxAmount` double NOT NULL DEFAULT '0',
  `taxIsFix` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog`
--

CREATE TABLE `tiki_actionlog` (
  `actionId` int NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastModif` int DEFAULT NULL,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `categId` int NOT NULL DEFAULT '0',
  `client` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`actionId`),
  KEY `lastModif` (`lastModif`),
  KEY `object` (`object`(100),`objectType`,`action`(100)),
  KEY `actionforuser` (`user`(100),`objectType`,`action`(100))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_actionlog`
--


-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_conf`
--

CREATE TABLE `tiki_actionlog_conf` (
  `id` int NOT NULL AUTO_INCREMENT,
  `action` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_action_obj` (`action`,`objectType`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=63 ;

--
-- Dumping data for table `tiki_actionlog_conf`
--

INSERT INTO `tiki_actionlog_conf` VALUES
(1, 'Created', 'wiki page', 'y'),
(2, 'Updated', 'wiki page', 'y'),
(3, 'Removed', 'wiki page', 'y'),
(4, 'Viewed', 'wiki page', 'n'),
(5, 'Viewed', 'forum', 'n'),
(6, 'Posted', 'forum', 'n'),
(7, 'Replied', 'forum', 'n'),
(8, 'Updated', 'forum', 'n'),
(9, 'Viewed', 'file gallery', 'n'),
(10, 'Uploaded', 'file gallery', 'n'),
(11, '%', 'category', 'n'),
(12, 'login', 'system', 'y'),
(13, 'Posted', 'message', 'n'),
(14, 'Replied', 'message', 'n'),
(15, 'Viewed', 'message', 'n'),
(16, 'Removed version', 'wiki page', 'n'),
(17, 'Removed last version', 'wiki page', 'n'),
(18, 'Rollback', 'wiki page', 'n'),
(19, 'Removed', 'forum', 'n'),
(20, 'Downloaded', 'file gallery', 'n'),
(21, 'Posted', 'comment', 'n'),
(22, 'Replied', 'comment', 'n'),
(23, 'Updated', 'comment', 'n'),
(24, 'Removed', 'comment', 'n'),
(25, 'Renamed', 'wiki page', 'n'),
(26, 'Created', 'sheet', 'n'),
(27, 'Updated', 'sheet', 'n'),
(28, 'Removed', 'sheet', 'n'),
(29, 'Viewed', 'sheet', 'n'),
(30, 'Viewed', 'blog', 'n'),
(31, 'Posted', 'blog', 'n'),
(32, 'Updated', 'blog', 'n'),
(33, 'Removed', 'blog', 'n'),
(34, 'Removed', 'file', 'n'),
(35, 'Viewed', 'article', 'n'),
(36, '%', 'system', 'y'),
(37, 'feature', 'system', 'y'),
(38, 'Updated', 'trackeritem', 'y'),
(39, 'Created', 'trackeritem', 'y'),
(40, 'Viewed', 'trackeritem', 'y'),
(41, 'Removed', 'trackeritem', 'y'),
(42, 'Created', 'wiki page attachment', 'n'),
(43, 'Removed', 'wiki page attachment', 'n'),
(44, 'Categorized', 'wiki page', 'n'),
(45, 'Uncategorized', 'wiki page', 'n'),
(46, 'Flagged', 'wiki page', 'n'),
(47, 'Fetch', 'url', 'n'),
(48, 'Refresh', 'url', 'n'),
(49, 'Joined Room', 'bigbluebutton', 'n'),
(50, 'Left Room', 'bigbluebutton', 'n'),
(51, 'Created', 'tracker', 'y'),
(52, 'Updated', 'tracker', 'y'),
(53, 'Removed', 'tracker', 'y'),
(54, 'Created', 'category', 'y'),
(55, 'Updated', 'category', 'y'),
(56, 'Removed', 'category', 'y'),
(57, 'Created', 'calendar event', 'n'),
(58, 'Updated', 'calendar event', 'n'),
(59, 'Removed', 'calendar event', 'n'),
(60, 'Sync', 'file gallery', 'y'),
(61, 'CRSF Error', 'system', 'y'),
(62, 'api', 'system', 'y');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_params`
--

CREATE TABLE `tiki_actionlog_params` (
  `actionId` int NOT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  KEY `actionId` (`actionId`),
  KEY `nameValue` (`name`,`value`(151))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream`
--

CREATE TABLE `tiki_activity_stream` (
  `activityId` int NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eventDate` int NOT NULL,
  `arguments` mediumblob,
  PRIMARY KEY (`activityId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_mapping`
--

CREATE TABLE `tiki_activity_stream_mapping` (
  `field_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`field_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_rules`
--

CREATE TABLE `tiki_activity_stream_rules` (
  `ruleId` int NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruleType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ruleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_address_books`
--

CREATE TABLE `tiki_address_books` (
  `addressBookId` int unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varbinary(200) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`addressBookId`),
  UNIQUE KEY `user` (`user`(141),`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_address_cards`
--

CREATE TABLE `tiki_address_cards` (
  `addressCardId` int unsigned NOT NULL AUTO_INCREMENT,
  `addressBookId` int unsigned NOT NULL,
  `carddata` mediumblob,
  `uri` varbinary(200) DEFAULT NULL,
  `lastmodified` int unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int unsigned NOT NULL,
  PRIMARY KEY (`addressCardId`),
  KEY `addressBookId` (`addressBookId`,`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_api_tokens`
--

CREATE TABLE `tiki_api_tokens` (
  `tokenId` int NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'manual',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parameters` text COLLATE utf8mb4_unicode_ci,
  `created` int NOT NULL,
  `lastModif` int NOT NULL,
  `expireAfter` int DEFAULT NULL,
  `hits` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tokenId`),
  KEY `token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_areas`
--

CREATE TABLE `tiki_areas` (
  `categId` int NOT NULL,
  `perspectives` text COLLATE utf8mb4_unicode_ci,
  `exclusive` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `share_common` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `enabled` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  KEY `categId` (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_articles`
--

CREATE TABLE `tiki_articles` (
  `articleId` int NOT NULL AUTO_INCREMENT,
  `topline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 's',
  `authorName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topicId` int DEFAULT NULL,
  `topicName` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int DEFAULT NULL,
  `useImage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_caption` text COLLATE utf8mb4_unicode_ci,
  `image_type` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int DEFAULT NULL,
  `image_x` int DEFAULT NULL,
  `image_y` int DEFAULT NULL,
  `list_image_x` int DEFAULT NULL,
  `list_image_y` int DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int DEFAULT NULL,
  `expireDate` int DEFAULT NULL,
  `created` int DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `body` text COLLATE utf8mb4_unicode_ci,
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nbreads` int DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `points` int DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(5,2) DEFAULT NULL,
  `isfloat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ispublished` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`articleId`),
  KEY `title` (`title`(191)),
  KEY `heading` (`heading`(191)),
  KEY `body` (`body`(191)),
  KEY `nbreads` (`nbreads`),
  KEY `author` (`author`(32)),
  KEY `topicId` (`topicId`),
  KEY `publishDate` (`publishDate`),
  KEY `expireDate` (`expireDate`),
  KEY `type` (`type`),
  FULLTEXT KEY `ft` (`title`,`heading`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_article_types`
--

CREATE TABLE `tiki_article_types` (
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_ratings` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_pre_publ` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_post_expire` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `heading_only` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_comments` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_image` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_avatar` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_author` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_pubdate` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_expdate` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_reads` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_size` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_topline` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_subtitle` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_linkto` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_image_caption` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `creator_edit` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_can_rate_article` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`type`),
  KEY `show_pre_publ` (`show_pre_publ`),
  KEY `show_post_expire` (`show_post_expire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_article_types`
--

INSERT INTO `tiki_article_types` VALUES
('Article', NULL, NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Review', 'y', NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Event', NULL, NULL, 'n', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Classified', NULL, NULL, 'n', 'y', 'n', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_auth_tokens`
--

CREATE TABLE `tiki_auth_tokens` (
  `tokenId` int NOT NULL AUTO_INCREMENT,
  `creation` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timeout` int NOT NULL DEFAULT '0',
  `hits` int NOT NULL DEFAULT '1',
  `maxhits` int NOT NULL DEFAULT '1',
  `token` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry` mediumtext COLLATE utf8mb4_unicode_ci,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameters` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  `createUser` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `userPrefix` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '_token',
  PRIMARY KEY (`tokenId`),
  KEY `tiki_auth_tokens_token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banners`
--

CREATE TABLE `tiki_banners` (
  `bannerId` int NOT NULL AUTO_INCREMENT,
  `client` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `which` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageData` longblob,
  `imageType` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageName` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `HTMLData` text COLLATE utf8mb4_unicode_ci,
  `fixedURLData` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `textData` text COLLATE utf8mb4_unicode_ci,
  `fromDate` int DEFAULT NULL,
  `toDate` int DEFAULT NULL,
  `useDates` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tue` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wed` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thu` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fri` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sun` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourFrom` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourTo` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int DEFAULT NULL,
  `maxImpressions` int DEFAULT NULL,
  `impressions` int DEFAULT NULL,
  `maxUserImpressions` int DEFAULT '-1',
  `maxClicks` int DEFAULT NULL,
  `clicks` int DEFAULT NULL,
  `zone` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onlyInURIs` text COLLATE utf8mb4_unicode_ci,
  `exceptInURIs` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`bannerId`),
  KEY `ban1` (`zone`,`useDates`,`impressions`,`maxImpressions`,`hourFrom`,`hourTo`,`fromDate`,`toDate`,`mon`,`tue`,`wed`,`thu`,`fri`,`sat`,`sun`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning`
--

CREATE TABLE `tiki_banning` (
  `banId` int NOT NULL AUTO_INCREMENT,
  `mode` enum('user','ip') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip1` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip2` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip3` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip4` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `date_from` timestamp NULL DEFAULT NULL,
  `date_to` timestamp NULL DEFAULT NULL,
  `use_dates` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `attempts` int DEFAULT NULL,
  PRIMARY KEY (`banId`),
  KEY `ban` (`use_dates`,`date_from`,`date_to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning_sections`
--

CREATE TABLE `tiki_banning_sections` (
  `banId` int NOT NULL DEFAULT '0',
  `section` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`banId`,`section`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blogs`
--

CREATE TABLE `tiki_blogs` (
  `blogId` int NOT NULL AUTO_INCREMENT,
  `created` int DEFAULT NULL,
  `lastModif` int DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `posts` int DEFAULT NULL,
  `maxPosts` int DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `activity` decimal(4,2) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `post_heading` text COLLATE utf8mb4_unicode_ci,
  `use_find` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_title` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_title_in_post` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_breadcrumbs` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `use_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_excerpt` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_date` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_poster` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_comments` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_post_categorization` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `always_owner` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_related` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_max` int DEFAULT '5',
  PRIMARY KEY (`blogId`),
  KEY `title` (`title`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_activity`
--

CREATE TABLE `tiki_blog_activity` (
  `blogId` int NOT NULL DEFAULT '0',
  `day` int NOT NULL DEFAULT '0',
  `posts` int DEFAULT NULL,
  PRIMARY KEY (`blogId`,`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts`
--

CREATE TABLE `tiki_blog_posts` (
  `postId` int NOT NULL AUTO_INCREMENT,
  `blogId` int NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `data_size` int unsigned NOT NULL DEFAULT '0',
  `excerpt` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` bigint DEFAULT '0',
  `trackbacks_to` text COLLATE utf8mb4_unicode_ci,
  `trackbacks_from` text COLLATE utf8mb4_unicode_ci,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priv` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `wysiwyg` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`postId`),
  KEY `data` (`data`(191)),
  KEY `blogId` (`blogId`),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`data`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts_images`
--

CREATE TABLE `tiki_blog_posts_images` (
  `imgId` int NOT NULL AUTO_INCREMENT,
  `postId` int NOT NULL DEFAULT '0',
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`imgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendars`
--

CREATE TABLE `tiki_calendars` (
  `calendarId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `customlocations` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customcategories` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customlanguages` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `custompriorities` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customparticipants` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customsubscription` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customstatus` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `created` int NOT NULL DEFAULT '0',
  `lastmodif` int NOT NULL DEFAULT '0',
  `personal` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `private` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_categories`
--

CREATE TABLE `tiki_calendar_categories` (
  `calcatId` int NOT NULL AUTO_INCREMENT,
  `calendarId` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `backgroundColor` varchar(1000) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Background color to use for classification',
  PRIMARY KEY (`calcatId`),
  UNIQUE KEY `catname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_changes`
--

CREATE TABLE `tiki_calendar_changes` (
  `changeId` int unsigned NOT NULL AUTO_INCREMENT,
  `calitemId` int unsigned NOT NULL,
  `synctoken` int unsigned NOT NULL,
  `calendarId` int unsigned NOT NULL,
  `operation` tinyint(1) NOT NULL,
  PRIMARY KEY (`changeId`),
  KEY `calendarId` (`calendarId`,`synctoken`),
  KEY `calitemId` (`calitemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_instances`
--

CREATE TABLE `tiki_calendar_instances` (
  `calendarInstanceId` int unsigned NOT NULL AUTO_INCREMENT,
  `calendarId` int unsigned NOT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 = owner, 2 = read, 3 = readwrite',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varbinary(200) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `color` varbinary(10) DEFAULT NULL,
  `timezone` text COLLATE utf8mb4_unicode_ci,
  `transparent` tinyint(1) NOT NULL DEFAULT '0',
  `share_href` varbinary(100) DEFAULT NULL,
  `share_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `share_invite_status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1 = noresponse, 2 = accepted, 3 = declined, 4 = invalid',
  PRIMARY KEY (`calendarInstanceId`),
  UNIQUE KEY `calendarId_2` (`calendarId`,`share_href`),
  UNIQUE KEY `user` (`user`(141),`uri`),
  UNIQUE KEY `calendarId` (`calendarId`,`user`(189))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_items`
--

CREATE TABLE `tiki_calendar_items` (
  `calitemId` int NOT NULL AUTO_INCREMENT,
  `calendarId` int NOT NULL DEFAULT '0',
  `start` int NOT NULL DEFAULT '0',
  `end` int NOT NULL DEFAULT '0',
  `locationId` int DEFAULT NULL,
  `categoryId` int DEFAULT NULL,
  `nlId` int NOT NULL DEFAULT '0',
  `priority` enum('0','1','2','3','4','5','6','7','8','9') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Tentative',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `recurrenceId` int DEFAULT NULL,
  `changed` tinyint(1) DEFAULT '0',
  `recurrenceStart` int DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created` int NOT NULL DEFAULT '0',
  `lastmodif` int NOT NULL DEFAULT '0',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `uid` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calitemId`),
  KEY `calendarId` (`calendarId`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_locations`
--

CREATE TABLE `tiki_calendar_locations` (
  `callocId` int NOT NULL AUTO_INCREMENT,
  `calendarId` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  PRIMARY KEY (`callocId`),
  UNIQUE KEY `locname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_options`
--

CREATE TABLE `tiki_calendar_options` (
  `calendarId` int NOT NULL DEFAULT '0',
  `optionName` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calendarId`,`optionName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_propertystorage`
--

CREATE TABLE `tiki_calendar_propertystorage` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` varbinary(1024) NOT NULL,
  `name` varbinary(100) NOT NULL,
  `valuetype` int unsigned DEFAULT NULL,
  `value` mediumblob,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_property` (`path`(600),`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_recurrence`
--

CREATE TABLE `tiki_calendar_recurrence` (
  `recurrenceId` int NOT NULL AUTO_INCREMENT,
  `calendarId` int NOT NULL DEFAULT '0',
  `start` int NOT NULL DEFAULT '0',
  `end` int NOT NULL DEFAULT '2359',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `locationId` int DEFAULT NULL,
  `categoryId` int DEFAULT NULL,
  `nlId` int NOT NULL DEFAULT '0',
  `priority` enum('1','2','3','4','5','6','7','8','9') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Tentative',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  `daily` tinyint(1) DEFAULT '0',
  `days` int DEFAULT NULL,
  `weekly` tinyint(1) DEFAULT '0',
  `weeks` int DEFAULT NULL,
  `weekdays` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monthly` tinyint(1) DEFAULT '0',
  `months` int DEFAULT NULL,
  `dayOfMonth` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monthlyType` enum('date','weekday','firstlastweekday') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monthlyWeekdayValue` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Format => (-) + 1digit + 2 letters for weekday (1MO for every 1st Monday or -1TH for last Thursday of each month )',
  `monthlyFirstlastWeekdayValue` int DEFAULT NULL,
  `yearly` tinyint(1) DEFAULT '0',
  `years` int DEFAULT NULL,
  `yearlyType` enum('date','weekday','firstlastweekday') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dateOfYear` int DEFAULT NULL,
  `yearlyWeekdayValue` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Format => (-) + 1digit + 2 letters for weekday (1MO for every 1st Monday or -1TH for last Thursday of each month)',
  `yearlyFirstlastWeekdayValue` int DEFAULT NULL,
  `yearlyWeekMonth` int DEFAULT NULL,
  `nbRecurrences` int DEFAULT NULL,
  `startPeriod` int DEFAULT NULL,
  `endPeriod` int DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created` int NOT NULL DEFAULT '0',
  `lastmodif` int NOT NULL DEFAULT '0',
  `uid` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurrenceDstTimezone` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'If a recurring event, event recurrences will move so the event is always at the same time of the day in that timezone',
  PRIMARY KEY (`recurrenceId`),
  KEY `calendarId` (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_roles`
--

CREATE TABLE `tiki_calendar_roles` (
  `calitemId` int NOT NULL DEFAULT '0',
  `username` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `role` enum('0','1','2','3','6') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `partstat` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calitemId`,`username`(16),`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_scheduling_objects`
--

CREATE TABLE `tiki_calendar_scheduling_objects` (
  `schedulingObjectId` int unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calendardata` mediumblob,
  `uri` varbinary(200) DEFAULT NULL,
  `lastmodif` int unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int unsigned NOT NULL,
  PRIMARY KEY (`schedulingObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_subscriptions`
--

CREATE TABLE `tiki_calendar_subscriptions` (
  `subscriptionId` int unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` text COLLATE utf8mb4_unicode_ci,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh_rate` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `color` varbinary(10) DEFAULT NULL,
  `strip_todos` tinyint(1) DEFAULT NULL,
  `strip_alarms` tinyint(1) DEFAULT NULL,
  `strip_attachments` tinyint(1) DEFAULT NULL,
  `lastmodif` int unsigned DEFAULT NULL,
  `last_sync` int unsigned DEFAULT NULL,
  `vcalendar` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`subscriptionId`),
  KEY `uri` (`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cart_inventory_hold`
--

CREATE TABLE `tiki_cart_inventory_hold` (
  `productId` int NOT NULL,
  `quantity` int NOT NULL,
  `timeHeld` int NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories`
--

CREATE TABLE `tiki_categories` (
  `categId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int DEFAULT NULL,
  `rootId` int NOT NULL DEFAULT '0',
  `hits` int DEFAULT NULL,
  `tplGroupContainerId` int DEFAULT NULL,
  `tplGroupPattern` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories_roles`
--

CREATE TABLE `tiki_categories_roles` (
  `categId` int NOT NULL,
  `categRoleId` int NOT NULL,
  `groupRoleId` int NOT NULL,
  `groupId` int NOT NULL,
  PRIMARY KEY (`categId`,`categRoleId`,`groupRoleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories_roles_available`
--

CREATE TABLE `tiki_categories_roles_available` (
  `categId` int NOT NULL,
  `categRoleId` int NOT NULL,
  PRIMARY KEY (`categId`,`categRoleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categorized_objects`
--

CREATE TABLE `tiki_categorized_objects` (
  `catObjectId` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_objects`
--

CREATE TABLE `tiki_category_objects` (
  `catObjectId` int NOT NULL DEFAULT '0',
  `categId` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_sites`
--

CREATE TABLE `tiki_category_sites` (
  `categId` int NOT NULL DEFAULT '0',
  `siteId` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`siteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_channels`
--

CREATE TABLE `tiki_chat_channels` (
  `channelId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_users` int DEFAULT NULL,
  `mode` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh` int DEFAULT NULL,
  PRIMARY KEY (`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_messages`
--

CREATE TABLE `tiki_chat_messages` (
  `messageId` int NOT NULL AUTO_INCREMENT,
  `channelId` int NOT NULL DEFAULT '0',
  `data` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int DEFAULT NULL,
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_users`
--

CREATE TABLE `tiki_chat_users` (
  `nickname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `channelId` int NOT NULL DEFAULT '0',
  `timestamp` int DEFAULT NULL,
  PRIMARY KEY (`nickname`(183),`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_comments`
--

CREATE TABLE `tiki_comments` (
  `threadId` int NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parentId` int DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `commentDate` int DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `average` decimal(8,4) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smiley` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_id` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_rating` tinyint DEFAULT NULL,
  `archived` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `locked` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`threadId`),
  UNIQUE KEY `no_repeats` (`parentId`,`userName`(40),`title`(43),`commentDate`,`message_id`(40),`in_reply_to`(40)),
  KEY `title` (`title`(191)),
  KEY `data` (`data`(191)),
  KEY `hits` (`hits`),
  KEY `tc_pi` (`parentId`),
  KEY `objectType` (`object`(160),`objectType`),
  KEY `commentDate` (`commentDate`),
  KEY `threaded` (`message_id`(89),`in_reply_to`(88),`parentId`),
  FULLTEXT KEY `ft` (`title`,`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_connect`
--

CREATE TABLE `tiki_connect` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  `guid` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `server` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `server` (`server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content`
--

CREATE TABLE `tiki_content` (
  `contentId` int NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `contentLabel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`contentId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates`
--

CREATE TABLE `tiki_content_templates` (
  `templateId` int NOT NULL AUTO_INCREMENT,
  `template_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `content` longblob,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int DEFAULT NULL,
  PRIMARY KEY (`templateId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates_sections`
--

CREATE TABLE `tiki_content_templates_sections` (
  `templateId` int NOT NULL DEFAULT '0',
  `section` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`templateId`,`section`(181))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions`
--

CREATE TABLE `tiki_contributions` (
  `contributionId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions_assigned`
--

CREATE TABLE `tiki_contributions_assigned` (
  `contributionId` int NOT NULL,
  `objectId` int NOT NULL,
  PRIMARY KEY (`objectId`,`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cookies`
--

CREATE TABLE `tiki_cookies` (
  `cookieId` int NOT NULL AUTO_INCREMENT,
  `cookie` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`cookieId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_copyrights`
--

CREATE TABLE `tiki_copyrights` (
  `copyrightId` int NOT NULL AUTO_INCREMENT,
  `page` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` int DEFAULT NULL,
  `authors` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `holder` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright_order` int DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`copyrightId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits`
--

CREATE TABLE `tiki_credits` (
  `creditId` int unsigned NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiration_date` timestamp NULL DEFAULT NULL,
  `total_amount` float NOT NULL DEFAULT '0',
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int DEFAULT NULL,
  `goalId` int DEFAULT NULL,
  PRIMARY KEY (`creditId`),
  KEY `userId` (`userId`,`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_types`
--

CREATE TABLE `tiki_credits_types` (
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_text` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_text` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_static_level` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `scaling_divisor` float NOT NULL DEFAULT '1',
  PRIMARY KEY (`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_usage`
--

CREATE TABLE `tiki_credits_usage` (
  `usageId` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `usage_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int DEFAULT NULL,
  PRIMARY KEY (`usageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_custom_color_modes`
--

CREATE TABLE `tiki_custom_color_modes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `css_variables` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_custom_color_modes`
--

INSERT INTO `tiki_custom_color_modes` VALUES
(1, 'light', 'sun', 'n', NULL),
(2, 'dark', 'moon', 'n', NULL),
(3, 'auto', 'circle-half', 'n', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_custom_route`
--

CREATE TABLE `tiki_custom_route` (
  `id` int NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `short_url` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_db_status`
--

CREATE TABLE `tiki_db_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `objectId` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tableName` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `other` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_db_status`
--

INSERT INTO `tiki_db_status` VALUES
(1, '1', 'tiki_pages', 'new9.0+', NULL),
(2, '1', 'tiki_history', 'new9.0+', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_categories`
--

CREATE TABLE `tiki_directory_categories` (
  `categId` int NOT NULL AUTO_INCREMENT,
  `parent` int DEFAULT NULL,
  `name` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `childrenType` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sites` int DEFAULT NULL,
  `viewableChildren` int DEFAULT NULL,
  `allowSites` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `showCount` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `editorGroup` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_search`
--

CREATE TABLE `tiki_directory_search` (
  `term` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int DEFAULT NULL,
  PRIMARY KEY (`term`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_sites`
--

CREATE TABLE `tiki_directory_sites` (
  `siteId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `isValid` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int DEFAULT NULL,
  `lastModif` int DEFAULT NULL,
  `cache` longblob,
  `cache_timestamp` int DEFAULT NULL,
  PRIMARY KEY (`siteId`),
  KEY `isValid` (`isValid`),
  KEY `url` (`url`(191)),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_discount`
--

CREATE TABLE `tiki_discount` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max` int DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `code` (`code`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_download`
--

CREATE TABLE `tiki_download` (
  `id` int NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userId` int NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` int NOT NULL DEFAULT '0',
  `IP` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `object` (`object`(163),`userId`,`type`),
  KEY `userId` (`userId`),
  KEY `type` (`type`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dsn`
--

CREATE TABLE `tiki_dsn` (
  `dsnId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dsn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`dsnId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dynamic_variables`
--

CREATE TABLE `tiki_dynamic_variables` (
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_encryption_keys`
--

CREATE TABLE `tiki_encryption_keys` (
  `keyId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `algo` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shares` int NOT NULL,
  `users` text COLLATE utf8mb4_unicode_ci,
  `secret` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`keyId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_extwiki`
--

CREATE TABLE `tiki_extwiki` (
  `extwikiId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extwiki` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `indexname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`extwikiId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faqs`
--

CREATE TABLE `tiki_faqs` (
  `faqId` int NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `questions` int DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `canSuggest` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`faqId`),
  KEY `title` (`title`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faq_questions`
--

CREATE TABLE `tiki_faq_questions` (
  `questionId` int NOT NULL AUTO_INCREMENT,
  `faqId` int DEFAULT NULL,
  `position` int DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  PRIMARY KEY (`questionId`),
  KEY `faqId` (`faqId`),
  KEY `question` (`question`(191)),
  KEY `answer` (`answer`(191)),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`question`,`answer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_feature`
--

CREATE TABLE `tiki_feature` (
  `feature_id` mediumint NOT NULL AUTO_INCREMENT,
  `feature_name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` mediumint NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `setting_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feature_type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'feature',
  `template` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permission` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordinal` mediumint NOT NULL DEFAULT '1',
  `depends_on` mediumint DEFAULT NULL,
  `keyword` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tip` text COLLATE utf8mb4_unicode_ci,
  `feature_count` mediumint NOT NULL DEFAULT '0',
  `feature_path` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_featured_links`
--

CREATE TABLE `tiki_featured_links` (
  `url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `hits` int DEFAULT NULL,
  `position` int DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_files`
--

CREATE TABLE `tiki_files` (
  `fileId` int NOT NULL AUTO_INCREMENT,
  `galleryId` int NOT NULL DEFAULT '0',
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `author` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `maxhits` int DEFAULT NULL,
  `lastDownload` int DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_reference` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `search_data` longtext COLLATE utf8mb4_unicode_ci,
  `metadata` longtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int DEFAULT NULL,
  `lastModifUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `comment` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `archiveId` int DEFAULT '0',
  `deleteAfter` int DEFAULT NULL,
  `ocr_state` tinyint(1) DEFAULT NULL,
  `ocr_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ocr_data` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fileId`),
  KEY `name` (`name`(191)),
  KEY `description` (`description`(191)),
  KEY `created` (`created`),
  KEY `archiveId` (`archiveId`),
  KEY `galleryIdAndPath` (`galleryId`,`path`(188)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`name`,`description`,`search_data`,`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_backlinks`
--

CREATE TABLE `tiki_file_backlinks` (
  `fileId` int NOT NULL,
  `objectId` int NOT NULL,
  KEY `objectId` (`objectId`),
  KEY `fileId` (`fileId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_drafts`
--

CREATE TABLE `tiki_file_drafts` (
  `fileId` int NOT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`fileId`,`user`(177))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_galleries`
--

CREATE TABLE `tiki_file_galleries` (
  `galleryId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `direct` text COLLATE utf8mb4_unicode_ci,
  `template` int DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `visible` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastModif` int DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` int DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `maxRows` int DEFAULT NULL,
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_id` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_icon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_name` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_size` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_desc` int DEFAULT NULL,
  `show_created` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_hits` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_lastDownload` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int NOT NULL DEFAULT '-1',
  `lockable` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_lockedby` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `archives` int DEFAULT '0',
  `sort_mode` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_modified` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_creator` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subgal_conf` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_last_user` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_comment` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_files` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_explorer` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_path` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_slideshow` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_ocr_state` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_view` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quota` int DEFAULT '0',
  `size` int DEFAULT NULL,
  `wiki_syntax` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backlinkPerms` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_backlinks` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_deleteAfter` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_checked` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_share` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_max_size_x` int NOT NULL DEFAULT '0',
  `image_max_size_y` int NOT NULL DEFAULT '0',
  `show_source` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'o',
  `icon_fileId` int unsigned DEFAULT NULL,
  `ocr_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`galleryId`),
  KEY `parentIdAndName` (`parentId`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_file_galleries`
--

INSERT INTO `tiki_file_galleries` VALUES
(1, 'File Galleries', 'system', NULL, NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL),
(2, 'Users File Galleries', 'system', NULL, NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL),
(3, 'Wiki Attachments', 'system', NULL, NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_handlers`
--

CREATE TABLE `tiki_file_handlers` (
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cmd` varchar(238) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums`
--

CREATE TABLE `tiki_forums` (
  `forumId` int NOT NULL AUTO_INCREMENT,
  `parentId` int NOT NULL DEFAULT '0',
  `forumOrder` int NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `lastPost` int DEFAULT NULL,
  `threads` int DEFAULT NULL,
  `comments` int DEFAULT NULL,
  `controlFlood` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floodInterval` int DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `mail` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `useMail` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `section` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `usePruneUnreplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pruneUnrepliedAge` int DEFAULT NULL,
  `usePruneOld` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pruneMaxAge` int DEFAULT NULL,
  `topicsPerPage` int DEFAULT NULL,
  `topicOrdering` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `threadOrdering` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_store` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_store_dir` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_max_size` int DEFAULT NULL,
  `att_list_nb` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_level` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_password` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_use_password` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moderator_group` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_address` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_mails_for_inbound_mails` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_mails_reply_link` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_from` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_server` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_port` int DEFAULT NULL,
  `inbound_pop_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_password` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_smileys` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_rating_choice_topic` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_posts` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_email` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_online` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_summary` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_replies` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_reads` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_pts` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_title` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_author_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vote_threads` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_last_n` int DEFAULT '0',
  `threadStyle` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentsPerPage` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_flat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mandatory_contribution` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forumLanguage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`forumId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_queue`
--

CREATE TABLE `tiki_forums_queue` (
  `qId` int NOT NULL AUTO_INCREMENT,
  `object` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int DEFAULT NULL,
  `forumId` int DEFAULT NULL,
  `timestamp` int DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `title` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_smiley` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_title` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tags` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`qId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_reported`
--

CREATE TABLE `tiki_forums_reported` (
  `threadId` int NOT NULL DEFAULT '0',
  `forumId` int NOT NULL DEFAULT '0',
  `parentId` int NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestamp` int DEFAULT NULL,
  `reason` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`threadId`,`forumId`,`parentId`,`user`(182))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_attachments`
--

CREATE TABLE `tiki_forum_attachments` (
  `attId` int NOT NULL AUTO_INCREMENT,
  `threadId` int NOT NULL DEFAULT '0',
  `qId` int NOT NULL DEFAULT '0',
  `forumId` int DEFAULT NULL,
  `filename` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int DEFAULT NULL,
  `data` longblob,
  `dir` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int DEFAULT NULL,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attId`),
  KEY `threadId` (`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_reads`
--

CREATE TABLE `tiki_forum_reads` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `threadId` int NOT NULL DEFAULT '0',
  `forumId` int DEFAULT NULL,
  `timestamp` int DEFAULT NULL,
  PRIMARY KEY (`user`(177),`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetagged_objects`
--

CREATE TABLE `tiki_freetagged_objects` (
  `tagId` int NOT NULL AUTO_INCREMENT,
  `objectId` int NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagId`,`user`(168),`objectId`),
  KEY `tagId` (`tagId`),
  KEY `user` (`user`(191)),
  KEY `objectId` (`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetags`
--

CREATE TABLE `tiki_freetags` (
  `tagId` int unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `raw_tag` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`tagId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goals`
--

CREATE TABLE `tiki_goals` (
  `goalId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `description` text COLLATE utf8mb4_unicode_ci,
  `enabled` int NOT NULL DEFAULT '0',
  `daySpan` int NOT NULL DEFAULT '14',
  `from` datetime DEFAULT NULL,
  `to` datetime DEFAULT NULL,
  `eligible` blob,
  `conditions` blob,
  `rewards` blob,
  PRIMARY KEY (`goalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goal_events`
--

CREATE TABLE `tiki_goal_events` (
  `eventId` int NOT NULL AUTO_INCREMENT,
  `eventDate` int NOT NULL,
  `eventType` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `targetType` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetObject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `groups` blob NOT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_groupalert`
--

CREATE TABLE `tiki_groupalert` (
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectId` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `displayEachuser` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`groupName`(161),`objectType`,`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_inclusion`
--

CREATE TABLE `tiki_group_inclusion` (
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `includeGroup` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`groupName`(120),`includeGroup`(120))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_group_inclusion`
--

INSERT INTO `tiki_group_inclusion` VALUES
('Registered', 'Anonymous');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_watches`
--

CREATE TABLE `tiki_group_watches` (
  `watchId` int NOT NULL AUTO_INCREMENT,
  `group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `event` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `object` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`watchId`),
  KEY `event-object-group` (`event`,`object`(100),`group`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_contents`
--

CREATE TABLE `tiki_h5p_contents` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `file_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `library_id` int unsigned NOT NULL,
  `parameters` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `filtered` longtext COLLATE utf8mb4_unicode_ci,
  `slug` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `embed_type` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disable` int unsigned NOT NULL DEFAULT '0',
  `content_type` varchar(127) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authors` mediumtext COLLATE utf8mb4_unicode_ci,
  `license` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `source` varchar(2083) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year_from` int unsigned DEFAULT NULL,
  `year_to` int unsigned DEFAULT NULL,
  `license_version` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_extras` longtext COLLATE utf8mb4_unicode_ci,
  `author_comments` longtext COLLATE utf8mb4_unicode_ci,
  `changes` mediumtext COLLATE utf8mb4_unicode_ci,
  `default_language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `a11y_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fileId` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_contents_libraries`
--

CREATE TABLE `tiki_h5p_contents_libraries` (
  `content_id` int unsigned NOT NULL,
  `library_id` int unsigned NOT NULL,
  `dependency_type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` smallint unsigned NOT NULL DEFAULT '0',
  `drop_css` tinyint unsigned NOT NULL,
  PRIMARY KEY (`content_id`,`library_id`,`dependency_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries`
--

CREATE TABLE `tiki_h5p_libraries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major_version` int unsigned NOT NULL,
  `minor_version` int unsigned NOT NULL,
  `patch_version` int unsigned NOT NULL,
  `runnable` int unsigned NOT NULL,
  `restricted` int unsigned NOT NULL DEFAULT '0',
  `fullscreen` int unsigned NOT NULL,
  `embed_types` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `preloaded_js` text COLLATE utf8mb4_unicode_ci,
  `preloaded_css` text COLLATE utf8mb4_unicode_ci,
  `drop_library_css` text COLLATE utf8mb4_unicode_ci,
  `semantics` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tutorial_url` varchar(1023) COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_icon` int unsigned NOT NULL DEFAULT '0',
  `metadata_settings` text COLLATE utf8mb4_unicode_ci,
  `add_to` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `name_version` (`name`,`major_version`,`minor_version`,`patch_version`),
  KEY `runnable` (`runnable`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_cachedassets`
--

CREATE TABLE `tiki_h5p_libraries_cachedassets` (
  `library_id` int unsigned NOT NULL,
  `hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_hub_cache`
--

CREATE TABLE `tiki_h5p_libraries_hub_cache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `machine_name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major_version` int unsigned NOT NULL,
  `minor_version` int unsigned NOT NULL,
  `patch_version` int unsigned NOT NULL,
  `h5p_major_version` int unsigned DEFAULT NULL,
  `h5p_minor_version` int unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(511) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int unsigned NOT NULL,
  `updated_at` int unsigned NOT NULL,
  `is_recommended` int unsigned NOT NULL,
  `popularity` int unsigned NOT NULL,
  `screenshots` text COLLATE utf8mb4_unicode_ci,
  `license` text COLLATE utf8mb4_unicode_ci,
  `example` varchar(511) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tutorial` varchar(511) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  `categories` text COLLATE utf8mb4_unicode_ci,
  `owner` varchar(511) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name_version` (`machine_name`,`major_version`,`minor_version`,`patch_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_languages`
--

CREATE TABLE `tiki_h5p_libraries_languages` (
  `library_id` int unsigned NOT NULL,
  `language_code` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`language_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_libraries`
--

CREATE TABLE `tiki_h5p_libraries_libraries` (
  `library_id` int unsigned NOT NULL,
  `required_library_id` int unsigned NOT NULL,
  `dependency_type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`required_library_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_results`
--

CREATE TABLE `tiki_h5p_results` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `score` int unsigned NOT NULL,
  `max_score` int unsigned NOT NULL,
  `opened` int unsigned NOT NULL,
  `finished` int unsigned NOT NULL,
  `time` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `content_user` (`content_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_tmpfiles`
--

CREATE TABLE `tiki_h5p_tmpfiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `path` (`path`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_history`
--

CREATE TABLE `tiki_history` (
  `historyId` int NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `lastModif` int DEFAULT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`historyId`),
  UNIQUE KEY `uk_version_pageName` (`pageName`,`version`),
  KEY `k_user` (`user`(191))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_history`
--

INSERT INTO `tiki_history` VALUES
(1, 'HomePage', 1, 0, [[timestamp]], '', 'admin', '0.0.0.0', 'Tiki initialization', '!Congratulations\nThis is the default homepage for your Tiki. If you are seeing this page, your installation was successful.\n\nYou can change this page after logging in. Please review the [http://doc.tiki.org/Wiki-syntax|wiki syntax] for editing details.\n\n\n!!Get started.\nTo begin configuring your site:\n{FANCYLIST()}\n1) Log in with your newly created password.\n2) Manually [tiki-admin.php?page=features|Enable specific Tiki features] that you didn''t enable with the Admin wizard.\n3) Run [tiki-admin.php?page=profiles|Tiki Profiles] to quickly get up and running.\n{FANCYLIST}\n\n!!Need help?\nFor more information:\n*[https://tiki.org/Introduction|Learn more about Tiki].\n*[https://tiki.org/|Get help], including the [http://doc.tiki.org|official documentation] and [http://tiki.org/forums|support forums].\n*[https://tiki.org/Join|Join the Tiki community].\n', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_hotwords`
--

CREATE TABLE `tiki_hotwords` (
  `word` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`word`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages`
--

CREATE TABLE `tiki_html_pages` (
  `pageName` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` longblob,
  `refresh` int DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int DEFAULT NULL,
  PRIMARY KEY (`pageName`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages_dynamic_zones`
--

CREATE TABLE `tiki_html_pages_dynamic_zones` (
  `pageName` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `zone` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pageName`,`zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_reps`
--

CREATE TABLE `tiki_integrator_reps` (
  `repID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `css_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visibility` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `cacheable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `expiration` int NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_integrator_reps`
--

INSERT INTO `tiki_integrator_reps` VALUES
(1, 'Doxygened (1.3.4) Documentation', '', 'index.html', 'doxygen.css', 'n', 'y', 0, 'Use this repository as rule source for all your repositories based on doxygened docs. To setup yours just add new repository and copy rules from this repository :)');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_rules`
--

CREATE TABLE `tiki_integrator_rules` (
  `ruleID` int NOT NULL AUTO_INCREMENT,
  `repID` int NOT NULL DEFAULT '0',
  `ord` int unsigned NOT NULL DEFAULT '0',
  `srch` blob NOT NULL,
  `repl` blob NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `casesense` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `rxmod` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enabled` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ruleID`),
  KEY `repID` (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_integrator_rules`
--

INSERT INTO `tiki_integrator_rules` VALUES
(1, 1, 1, '.*<body[^>]*?>(.*?)</body.*', '1', 'y', 'n', 'i', 'y', 'Extract code between <body> and </body> tags'),
(2, 1, 2, 'img src=("|'')(?!http://)', 'img src=1{path}/', 'y', 'n', 'i', 'y', 'Fix image paths'),
(3, 1, 3, 'href=("|'')(?!(#|(http|ftp)://))', 'href=1tiki-integrator.php?repID={repID}&file=', 'y', 'n', 'i', 'y', 'Replace internal links to integrator. Don not touch an external link.');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invite`
--

CREATE TABLE `tiki_invite` (
  `id` int NOT NULL AUTO_INCREMENT,
  `inviter` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `groups` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ts` int NOT NULL,
  `emailsubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `emailcontent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `wikicontent` text COLLATE utf8mb4_unicode_ci,
  `wikipageafter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invited`
--

CREATE TABLE `tiki_invited` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_invite` int NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastname` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used` enum('no','registered','logged') COLLATE utf8mb4_unicode_ci NOT NULL,
  `used_on_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_invite` (`id_invite`),
  KEY `used_on_user` (`used_on_user`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_iot_apps`
--

CREATE TABLE `tiki_iot_apps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `app_uuid` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trackerId` int NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `scenario_config` longtext COLLATE utf8mb4_unicode_ci,
  `dashboard_config` longtext COLLATE utf8mb4_unicode_ci,
  `state_object` longtext COLLATE utf8mb4_unicode_ci,
  `iot_bridge_access_token` text COLLATE utf8mb4_unicode_ci,
  `iot_bridge_access_token_expire_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_uuid` (`app_uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_iot_apps_actions_logs`
--

CREATE TABLE `tiki_iot_apps_actions_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `app_uuid` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_message` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_language`
--

CREATE TABLE `tiki_language` (
  `id` int NOT NULL AUTO_INCREMENT,
  `source` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tran` text COLLATE utf8mb4_unicode_ci,
  `changed` tinyint(1) DEFAULT NULL,
  `general` tinyint(1) DEFAULT NULL COMMENT 'true if this translation is general and can be contributed to the Tiki community, false if it is specific to this instance',
  `userId` int DEFAULT NULL,
  `lastModif` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_links`
--

CREATE TABLE `tiki_links` (
  `fromPage` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `toPage` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastModif` int NOT NULL,
  PRIMARY KEY (`fromPage`(96),`toPage`(95)),
  KEY `toPage` (`toPage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_link_cache`
--

CREATE TABLE `tiki_link_cache` (
  `cacheId` int NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `refresh` int DEFAULT NULL,
  PRIMARY KEY (`cacheId`),
  KEY `url` (`url`(191)),
  KEY `urlindex` (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_events`
--

CREATE TABLE `tiki_live_support_events` (
  `eventId` int NOT NULL AUTO_INCREMENT,
  `reqId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seqId` int DEFAULT NULL,
  `senderId` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_messages`
--

CREATE TABLE `tiki_live_support_messages` (
  `msgId` int NOT NULL AUTO_INCREMENT,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_to` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` int DEFAULT NULL,
  `email` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_message_comments`
--

CREATE TABLE `tiki_live_support_message_comments` (
  `cId` int NOT NULL AUTO_INCREMENT,
  `msgId` int DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int DEFAULT NULL,
  PRIMARY KEY (`cId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_modules`
--

CREATE TABLE `tiki_live_support_modules` (
  `modId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`modId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `tiki_live_support_modules`
--

INSERT INTO `tiki_live_support_modules` VALUES
(1, 'wiki'),
(2, 'forums'),
(3, 'file galleries'),
(4, 'directory');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_operators`
--

CREATE TABLE `tiki_live_support_operators` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `accepted_requests` int DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longest_chat` int DEFAULT NULL,
  `shortest_chat` int DEFAULT NULL,
  `average_chat` int DEFAULT NULL,
  `last_chat` int DEFAULT NULL,
  `time_online` int DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `points` int DEFAULT NULL,
  `status_since` int DEFAULT NULL,
  PRIMARY KEY (`user`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_requests`
--

CREATE TABLE `tiki_live_support_requests` (
  `reqId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tiki_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` text COLLATE utf8mb4_unicode_ci,
  `req_timestamp` int DEFAULT NULL,
  `timestamp` int DEFAULT NULL,
  `status` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chat_started` int DEFAULT NULL,
  `chat_ended` int DEFAULT NULL,
  PRIMARY KEY (`reqId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_logs`
--

CREATE TABLE `tiki_logs` (
  `logId` int NOT NULL AUTO_INCREMENT,
  `logtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logmessage` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `loguser` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logip` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logclient` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `logtime` int NOT NULL,
  PRIMARY KEY (`logId`),
  KEY `logtype` (`logtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_machine_learning_models`
--

CREATE TABLE `tiki_machine_learning_models` (
  `mlmId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `sourceTrackerId` int NOT NULL,
  `trackerFields` text COLLATE utf8mb4_unicode_ci,
  `labelField` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ignoreEmpty` tinyint(1) DEFAULT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`mlmId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mailin_accounts`
--

CREATE TABLE `tiki_mailin_accounts` (
  `accountId` int NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `protocol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pop',
  `host` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` int DEFAULT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pass` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `anonymous` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `admin` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `attachments` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `routing` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `article_topicId` int DEFAULT NULL,
  `article_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discard_after` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_inlineImages` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `save_html` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `categoryId` int DEFAULT NULL,
  `namespace` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `respond_email` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `leave_email` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `galleryId` int DEFAULT NULL,
  `trackerId` int DEFAULT NULL,
  `preferences` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`accountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_events`
--

CREATE TABLE `tiki_mail_events` (
  `event` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_queue`
--

CREATE TABLE `tiki_mail_queue` (
  `messageId` int NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci,
  `attempts` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menus`
--

CREATE TABLE `tiki_menus` (
  `menuId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_items_icons` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `parse` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`menuId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=43 ;

--
-- Dumping data for table `tiki_menus`
--

INSERT INTO `tiki_menus` VALUES
(42, 'Application menu', 'Main extensive navigation menu', 'd', NULL, 'y', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_languages`
--

CREATE TABLE `tiki_menu_languages` (
  `menuId` int NOT NULL AUTO_INCREMENT,
  `language` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`menuId`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_options`
--

CREATE TABLE `tiki_menu_options` (
  `optionId` int NOT NULL AUTO_INCREMENT,
  `menuId` int DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int DEFAULT NULL,
  `section` text COLLATE utf8mb4_unicode_ci,
  `perm` text COLLATE utf8mb4_unicode_ci,
  `groupname` text COLLATE utf8mb4_unicode_ci,
  `userlevel` int DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`optionId`),
  UNIQUE KEY `uniq_menu` (`menuId`,`name`(30),`url`(50),`position`,`section`(60),`perm`(50),`groupname`(50))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=192 ;

--
-- Dumping data for table `tiki_menu_options`
--

INSERT INTO `tiki_menu_options` VALUES
(1, 42, 'o', 'Home', './', 10, '', '', '', 0, 'home48x48', NULL),
(2, 42, 'o', 'Search', 'tiki-searchindex.php', 13, 'feature_search', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(3, 42, 'o', 'Contact Us', 'tiki-contact.php', 20, 'feature_contact,feature_messages', '', '', 0, 'contactus48x48', NULL),
(4, 42, 'o', 'Stats', 'tiki-stats.php', 23, 'feature_stats', 'tiki_p_view_stats', '', 0, 'stats48x48', NULL),
(5, 42, 'o', 'Categories', 'tiki-browse_categories.php', 25, 'feature_categories', 'tiki_p_view_category', '', 0, 'categories48x48', NULL),
(6, 42, 'o', 'Tags', 'tiki-browse_freetags.php', 27, 'feature_freetags', 'tiki_p_view_freetags', '', 0, 'vcard48x48', NULL),
(7, 42, 'o', 'Calendar', 'tiki-calendar.php', 35, 'feature_calendar', 'tiki_p_view_calendar', '', 0, 'date48x48', NULL),
(8, 42, 'o', 'Tiki Calendar', 'tiki-action_calendar.php', 37, 'feature_action_calendar', 'tiki_p_view_tiki_calendar', '', 0, 'tikicalendar48x48', NULL),
(9, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_view', '', 0, NULL, NULL),
(10, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_request', '', 0, NULL, NULL),
(11, 42, 'o', '(debug)', 'javascript:toggle(''debugconsole'')', 40, 'feature_debug_console', 'tiki_p_admin', '', 0, 'debug48x48', NULL),
(12, 42, 'o', 'User Wizard', 'tiki-wizard_user.php', 45, 'feature_wizard_user', '', 'Registered', 0, 'wizard_user48x48', NULL),
(13, 42, 's', 'My Account', 'tiki-my_tiki.php', 50, 'feature_mytiki', '', 'Registered', 0, 'userfiles48x48', NULL),
(14, 42, 'o', 'My Account Home', 'tiki-my_tiki.php', 51, 'feature_mytiki', '', 'Registered', 0, NULL, NULL),
(15, 42, 'o', 'Preferences', 'tiki-user_preferences.php', 55, 'feature_mytiki,feature_userPreferences', '', 'Registered', 0, NULL, NULL),
(16, 42, 'o', 'Messages', 'messu-mailbox.php', 60, 'feature_mytiki,feature_messages', 'tiki_p_messages', 'Registered', 0, NULL, NULL),
(17, 42, 'o', 'Tasks', 'tiki-user_tasks.php', 65, 'feature_mytiki,feature_tasks', 'tiki_p_tasks', 'Registered', 0, NULL, NULL),
(18, 42, 'o', 'Bookmarks', 'tiki-user_bookmarks.php', 70, 'feature_mytiki,feature_user_bookmarks', 'tiki_p_create_bookmarks', 'Registered', 0, NULL, NULL),
(19, 42, 'o', 'Modules', 'tiki-user_assigned_modules.php', 75, 'feature_mytiki,user_assigned_modules', 'tiki_p_configure_modules', 'Registered', 0, NULL, NULL),
(20, 42, 'o', 'Webmail', 'tiki-webmail.php', 85, 'feature_mytiki,feature_webmail', 'tiki_p_use_webmail', 'Registered', 0, NULL, NULL),
(21, 42, 'o', 'Contacts', 'tiki-contacts.php', 87, 'feature_mytiki,feature_contacts', '', 'Registered', 0, NULL, NULL),
(22, 42, 'o', 'Mail-in', 'tiki-user_mailin.php', 88, 'feature_mytiki,feature_mailin', '', 'Registered', 0, NULL, NULL),
(23, 42, 'o', 'Notepad', 'tiki-notepad_list.php', 90, 'feature_mytiki,feature_notepad', 'tiki_p_notepad', 'Registered', 0, NULL, NULL),
(24, 42, 'o', 'My Files', 'tiki-userfiles.php', 95, 'feature_mytiki,feature_userfiles', 'tiki_p_userfiles', 'Registered', 0, NULL, NULL),
(25, 42, 'o', 'User Menu', 'tiki-usermenu.php', 100, 'feature_mytiki,feature_usermenu', 'tiki_p_usermenu', 'Registered', 0, NULL, NULL),
(26, 42, 'o', 'Mini Calendar', 'tiki-minical.php', 105, 'feature_mytiki,feature_minical', 'tiki_p_minical', 'Registered', 0, NULL, NULL),
(27, 42, 'o', 'My Watches', 'tiki-user_watches.php', 110, 'feature_mytiki,feature_user_watches', '', 'Registered', 0, NULL, NULL),
(28, 42, 's', 'Community', 'tiki-list_users.php', 187, 'feature_friends', 'tiki_p_list_users', '', 0, 'users48x48', NULL),
(29, 42, 'o', 'User List', 'tiki-list_users.php', 188, 'feature_friends', 'tiki_p_list_users', '', 0, NULL, NULL),
(30, 42, 'o', 'Friendship Network', 'tiki-friends.php', 189, 'feature_friends', '', 'Registered', 0, NULL, NULL),
(31, 42, 's', 'Wiki', 'tiki-index.php', 200, 'feature_wiki', 'tiki_p_view', '', 0, 'wikipages48x48', NULL),
(32, 42, 'o', 'Wiki Home', 'tiki-index.php', 202, 'feature_wiki', 'tiki_p_view', '', 0, NULL, NULL),
(33, 42, 'o', 'Last Changes', 'tiki-lastchanges.php', 205, 'feature_wiki,feature_lastChanges', 'tiki_p_view', '', 0, NULL, NULL),
(34, 42, 'o', 'Rankings', 'tiki-wiki_rankings.php', 215, 'feature_wiki,feature_wiki_rankings', 'tiki_p_view', '', 0, NULL, NULL),
(35, 42, 'o', 'List Pages', 'tiki-listpages.php?cookietab=1#tab1', 220, 'feature_wiki,feature_listPages', 'tiki_p_view', '', 0, NULL, NULL),
(36, 42, 'o', 'Create a Wiki Page', 'tiki-listpages.php?cookietab=2#tab2', 222, 'feature_wiki,feature_listPages', 'tiki_p_view,tiki_p_edit', '', 0, NULL, NULL),
(37, 42, 'o', 'Orphan Pages', 'tiki-orphan_pages.php', 225, 'feature_wiki,feature_listorphanPages', 'tiki_p_view', '', 0, NULL, NULL),
(38, 42, 'o', 'Sandbox', 'tiki-editpage.php?page=sandbox', 230, 'feature_wiki,feature_sandbox', 'tiki_p_view', '', 0, NULL, NULL),
(39, 42, 'o', 'Multiple Print', 'tiki-print_pages.php', 235, 'feature_wiki,feature_wiki_multiprint', 'tiki_p_view', '', 0, NULL, NULL),
(40, 42, 'o', 'Send Pages', 'tiki-send_objects.php', 240, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_send_pages', '', 0, NULL, NULL),
(41, 42, 'o', 'Received Pages', 'tiki-received_pages.php', 245, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_admin_received_pages', '', 0, NULL, NULL),
(42, 42, 'o', 'Structures', 'tiki-admin_structures.php', 250, 'feature_wiki,feature_wiki_structure', 'tiki_p_view', '', 0, NULL, NULL),
(43, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_read_article', '', 0, 'stock_bold48x48', NULL),
(44, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, 'stock_bold48x48', NULL),
(45, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(46, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(47, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(48, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(49, 42, 'o', 'Rankings', 'tiki-cms_rankings.php', 365, 'feature_articles,feature_cms_rankings', 'tiki_p_read_article', '', 0, NULL, NULL),
(50, 42, 'o', 'Submit Article', 'tiki-edit_submission.php', 370, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(51, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(52, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_approve_submission', '', 0, NULL, NULL),
(53, 42, 'o', 'View Submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_remove_submission', '', 0, NULL, NULL),
(54, 42, 'o', 'New Article', 'tiki-edit_article.php', 380, 'feature_articles', 'tiki_p_read_article,tiki_p_edit_article', '', 0, NULL, NULL),
(55, 42, 'o', 'Send Articles', 'tiki-send_objects.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_send_articles', '', 0, NULL, NULL),
(56, 42, 'o', 'Received Articles', 'tiki-received_articles.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_admin_received_articles', '', 0, NULL, NULL),
(57, 42, 'o', 'Admin Types', 'tiki-article_types.php', 395, 'feature_articles', 'tiki_p_articles_admin_types', '', 0, NULL, NULL),
(58, 42, 'o', 'Admin Topics', 'tiki-admin_topics.php', 390, 'feature_articles', 'tiki_p_articles_admin_topics', '', 0, NULL, NULL),
(59, 42, 's', 'Blogs', 'tiki-list_blogs.php', 450, 'feature_blogs', 'tiki_p_read_blog', '', 0, 'blogs48x48', NULL),
(60, 42, 'o', 'List Blogs', 'tiki-list_blogs.php', 455, 'feature_blogs', 'tiki_p_read_blog', '', 0, NULL, NULL),
(61, 42, 'o', 'Rankings', 'tiki-blog_rankings.php', 460, 'feature_blogs,feature_blog_rankings', 'tiki_p_read_blog', '', 0, NULL, NULL),
(62, 42, 'o', 'Create Blog', 'tiki-edit_blog.php', 465, 'feature_blogs', 'tiki_p_read_blog,tiki_p_create_blogs', '', 0, NULL, NULL),
(63, 42, 'o', 'New Blog Post', 'tiki-blog_post.php', 470, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_post', '', 0, NULL, NULL),
(64, 42, 'o', 'List Blog Posts', 'tiki-list_posts.php', 475, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_admin', '', 0, NULL, NULL),
(65, 42, 's', 'Forums', 'tiki-forums.php', 500, 'feature_forums', 'tiki_p_forum_read', '', 0, 'stock_index48x48', NULL),
(66, 42, 'o', 'List Forums', 'tiki-forums.php', 505, 'feature_forums', 'tiki_p_forum_read', '', 0, NULL, NULL),
(67, 42, 'o', 'Rankings', 'tiki-forum_rankings.php', 510, 'feature_forums,feature_forum_rankings', 'tiki_p_forum_read', '', 0, NULL, NULL),
(68, 42, 'o', 'Admin Forums', 'tiki-admin_forums.php', 515, 'feature_forums', 'tiki_p_forum_read,tiki_p_admin_forum', '', 0, NULL, NULL),
(69, 42, 's', 'Directory', 'tiki-directory_browse.php', 550, 'feature_directory', 'tiki_p_view_directory', '', 0, 'directory48x48', NULL),
(70, 42, 'o', 'Submit a new link', 'tiki-directory_add_site.php', 555, 'feature_directory', 'tiki_p_submit_link', '', 0, NULL, NULL),
(71, 42, 'o', 'Browse Directory', 'tiki-directory_browse.php', 560, 'feature_directory', 'tiki_p_view_directory', '', 0, NULL, NULL),
(72, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_cats', '', 0, NULL, NULL),
(73, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_sites', '', 0, NULL, NULL),
(74, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_validate_links', '', 0, NULL, NULL),
(75, 42, 's', 'File Galleries', 'tiki-list_file_gallery.php', 600, 'feature_file_galleries', 'tiki_p_list_file_galleries|tiki_p_view_file_gallery|tiki_p_upload_files', '', 0, 'file-manager48x48', NULL),
(76, 42, 'o', 'List Galleries', 'tiki-list_file_gallery.php', 605, 'feature_file_galleries', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(77, 42, 'o', 'Rankings', 'tiki-file_galleries_rankings.php', 610, 'feature_file_galleries,feature_file_galleries_rankings', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(78, 42, 'o', 'Upload File', 'tiki-upload_file.php', 615, 'feature_file_galleries', 'tiki_p_upload_files', '', 0, NULL, NULL),
(79, 42, 'o', 'Directory batch', 'tiki-batch_upload_files.php', 617, 'feature_file_galleries_batch', 'tiki_p_batch_upload_file_dir', '', 0, NULL, NULL),
(80, 42, 's', 'FAQs', 'tiki-list_faqs.php', 650, 'feature_faqs', 'tiki_p_view_faqs', '', 0, 'stock_dialog_question48x48', NULL),
(81, 42, 'o', 'List FAQs', 'tiki-list_faqs.php', 665, 'feature_faqs', 'tiki_p_view_faqs', '', 0, NULL, NULL),
(82, 42, 'o', 'Admin FAQs', 'tiki-list_faqs.php', 660, 'feature_faqs', 'tiki_p_admin_faqs', '', 0, NULL, NULL),
(83, 42, 's', 'Quizzes', 'tiki-list_quizzes.php', 750, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, 'quizzes48x48', NULL),
(84, 42, 'o', 'List Quizzes', 'tiki-list_quizzes.php', 755, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, NULL, NULL),
(85, 42, 'o', 'Quiz Stats', 'tiki-quiz_stats.php', 760, 'feature_quizzes', 'tiki_p_view_quiz_stats', '', 0, NULL, NULL),
(86, 42, 'o', 'Admin Quizzes', 'tiki-edit_quiz.php', 765, 'feature_quizzes', 'tiki_p_admin_quizzes', '', 0, NULL, NULL),
(87, 42, 's', 'Spreadsheets', 'tiki-sheets.php', 780, 'feature_sheet', 'tiki_p_view_sheet', '', 0, 'spreadsheet48x48', NULL),
(88, 42, 'o', 'List Sheets', 'tiki-sheets.php', 782, 'feature_sheet', 'tiki_p_view_sheet', '', 0, NULL, NULL),
(89, 42, 's', 'Trackers', 'tiki-list_trackers.php', 800, 'feature_trackers', 'tiki_p_list_trackers', '', 0, 'gnome-settings-font48x48', NULL),
(90, 42, 'o', 'List Trackers', 'tiki-list_trackers.php', 805, 'feature_trackers', 'tiki_p_list_trackers', '', 0, NULL, NULL),
(91, 42, 'o', 'Offline mode', 'tiki-offline.php', 807, 'feature_trackers', 'tiki_p_view_trackers', '', 0, NULL, NULL),
(92, 42, 'o', 'Manage Tabular Formats', 'tiki-ajax_services.php?controller=tabular&action=manage', 810, 'tracker_tabular_enabled', 'tiki_p_tabular_admin', '', 0, NULL, NULL),
(93, 42, 's', 'Machine Learning', 'tiki-ml-list', 820, 'feature_machine_learning', 'tiki_p_machine_learning', '', 0, NULL, NULL),
(94, 42, 'o', 'List Models', 'tiki-ml-list', 825, 'feature_machine_learning', 'tiki_p_machine_learning', '', 0, NULL, NULL),
(95, 42, 's', 'Accounting', 'tiki-accounting_books.php', 830, 'feature_accounting', 'tiki_p_acct_view', '', 0, 'accounting48x48', NULL),
(96, 42, 'o', 'Accounting books', 'tiki-accounting_books.php', 835, 'feature_accounting', 'tiki_p_acct_view', '', 0, NULL, NULL),
(97, 42, 's', 'Surveys', 'tiki-list_surveys.php', 850, 'feature_surveys', 'tiki_p_take_survey', '', 0, 'surveys48x48', NULL),
(98, 42, 'o', 'List Surveys', 'tiki-list_surveys.php', 855, 'feature_surveys', 'tiki_p_take_survey', '', 0, NULL, NULL),
(99, 42, 'o', 'Stats', 'tiki-survey_stats.php', 860, 'feature_surveys', 'tiki_p_view_survey_stats', '', 0, 'stats48x48', NULL),
(100, 42, 'o', 'Admin Surveys', 'tiki-admin_surveys.php', 865, 'feature_surveys', 'tiki_p_admin_surveys', '', 0, NULL, NULL),
(101, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_subscribe_newsletters', '', 0, 'messages48x48', NULL),
(102, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, 'messages48x48', NULL),
(103, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, 'messages48x48', NULL),
(104, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_list_newsletters', '', 0, 'messages48x48', NULL),
(105, 42, 'o', 'Send Newsletters', 'tiki-send_newsletters.php', 905, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, NULL, NULL),
(106, 42, 'o', 'Admin Newsletters', 'tiki-admin_newsletters.php', 910, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, NULL, NULL),
(107, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin', '', 0, 'icon-configuration48x48', NULL),
(108, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_categories', '', 0, 'icon-configuration48x48', NULL),
(109, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_banners', '', 0, 'icon-configuration48x48', NULL),
(110, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(111, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_cookies', '', 0, 'icon-configuration48x48', NULL),
(112, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_dynamic', '', 0, 'icon-configuration48x48', NULL),
(113, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_mailin', '', 0, 'icon-configuration48x48', NULL),
(114, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_content_templates', '', 0, 'icon-configuration48x48', NULL),
(115, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_html_pages', '', 0, 'icon-configuration48x48', NULL),
(116, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_view_referer_stats', '', 0, 'icon-configuration48x48', NULL),
(117, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_shoutbox', '', 0, 'icon-configuration48x48', NULL),
(118, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_live_support_admin', '', 0, 'icon-configuration48x48', NULL),
(119, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'user_is_operator', '', 0, 'icon-configuration48x48', NULL),
(120, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, 'icon-configuration48x48', NULL),
(121, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(122, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_view_tpl', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(123, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_editcss', 'tiki_p_create_css', '', 0, 'icon-configuration48x48', NULL),
(124, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_contribution', '', 0, 'icon-configuration48x48', NULL),
(125, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_users', '', 0, 'icon-configuration48x48', NULL),
(126, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_toolbars', '', 0, 'icon-configuration48x48', NULL),
(127, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_menu', '', 0, 'icon-configuration48x48', NULL),
(128, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_clean_cache', '', 0, 'icon-configuration48x48', NULL),
(129, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_modules', '', 0, 'icon-configuration48x48', NULL),
(130, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_webservices', '', 0, 'icon-configuration48x48', NULL),
(131, 42, 'o', ' Control Panels', 'tiki-admin.php', 1051, '', 'tiki_p_admin', '', 0, NULL, NULL),
(132, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'tiki_p_live_support_admin', '', 0, NULL, NULL),
(133, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'user_is_operator', '', 0, NULL, NULL),
(134, 42, 'o', 'Banning', 'tiki-admin_banning.php', 1060, 'feature_banning', 'tiki_p_admin_banning', '', 0, NULL, NULL),
(135, 42, 'o', 'Calendar', 'tiki-admin_calendars.php', 1065, 'feature_calendar', 'tiki_p_admin_calendar', '', 0, NULL, NULL),
(136, 42, 'o', 'Admin credits', 'tiki-admin_credits.php', 1067, 'payment_feature', 'tiki_p_admin_users', '', 0, NULL, NULL),
(137, 42, 'o', 'Users', 'tiki-adminusers.php', 1070, '', 'tiki_p_admin_users', '', 0, NULL, NULL),
(138, 42, 'o', 'Groups', 'tiki-admingroups.php', 1075, '', 'tiki_p_admin', '', 0, NULL, NULL),
(139, 42, 'o', 'External Pages Cache', 'tiki-list_cache.php', 1080, 'cachepages', 'tiki_p_admin', '', 0, NULL, NULL),
(140, 42, 'o', 'Modules', 'tiki-admin_modules.php', 1085, '', 'tiki_p_admin_modules', '', 0, NULL, NULL),
(141, 42, 'o', 'Performance', 'tiki-performance_stats.php', 1088, '', 'tiki_monitor_performance', '', 0, NULL, NULL),
(142, 42, 'o', 'Hotwords', 'tiki-admin_hotwords.php', 1095, 'feature_hotwords', 'tiki_p_admin', '', 0, NULL, NULL),
(143, 42, 'o', 'Edit languages', 'tiki-edit_languages.php', 1098, 'lang_use_db', 'tiki_p_edit_languages', '', 0, NULL, NULL),
(144, 42, 'o', 'External Feeds', 'tiki-admin_rssmodules.php', 1100, '', 'tiki_p_admin_rssmodules', '', 0, NULL, NULL),
(145, 42, 'o', 'External Wikis', 'tiki-admin_external_wikis.php', 1102, '', 'tiki_p_admin', '', 0, NULL, NULL),
(146, 42, 'o', 'Menus', 'tiki-admin_menus.php', 1105, '', 'tiki_p_edit_menu', '', 0, NULL, NULL),
(147, 42, 'o', 'Polls', 'tiki-admin_polls.php', 1110, 'feature_polls', 'tiki_p_admin_polls', '', 0, NULL, NULL),
(148, 42, 'o', 'Mail Notifications', 'tiki-admin_notifications.php', 1120, '', 'tiki_p_admin_notifications', '', 0, NULL, NULL),
(149, 42, 'o', 'Search Stats', 'tiki-search_stats.php', 1125, 'feature_search_stats', 'tiki_p_admin', '', 0, NULL, NULL),
(150, 42, 'o', 'Theme Control', 'tiki-theme_control.php', 1130, 'feature_theme_control', 'tiki_p_admin', '', 0, NULL, NULL),
(151, 42, 'o', 'Tokens', 'tiki-admin_tokens.php', 1132, 'auth_token_access', 'tiki_p_admin', '', 0, NULL, NULL),
(152, 42, 'o', 'Toolbars', 'tiki-admin_toolbars.php', 1135, '', 'tiki_p_admin_toolbars', '', 0, NULL, NULL),
(153, 42, 'o', 'Transitions', 'tiki-admin_transitions.php', 1140, '', 'tiki_p_admin', '', 0, NULL, NULL),
(154, 42, 'o', 'Categories', 'tiki-admin_categories.php', 1145, 'feature_categories', 'tiki_p_admin_categories', '', 0, 'categories48x48', NULL),
(155, 42, 'o', 'Banners', 'tiki-list_banners.php', 1150, 'feature_banners', 'tiki_p_admin_banners', '', 0, NULL, NULL),
(156, 42, 'o', 'Edit Templates', 'tiki-edit_templates.php', 1155, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, NULL, NULL),
(157, 42, 'o', 'View Templates', 'tiki-edit_templates.php', 1155, 'feature_view_tpl', 'tiki_p_edit_templates', '', 2, NULL, NULL),
(158, 42, 'o', 'Edit CSS', 'tiki-edit_css.php', 1158, 'feature_editcss', 'tiki_p_create_css', '', 2, NULL, NULL),
(159, 42, 'o', 'Dynamic content', 'tiki-list_contents.php', 1165, 'feature_dynamic_content', 'tiki_p_admin_dynamic', '', 0, NULL, NULL),
(160, 42, 'o', 'Mail-in', 'tiki-admin_mailin.php', 1175, 'feature_mailin', 'tiki_p_admin_mailin', '', 0, NULL, NULL),
(161, 42, 'o', 'HTML Pages', 'tiki-admin_html_pages.php', 1185, 'feature_html_pages', 'tiki_p_edit_html_pages', '', 0, NULL, NULL),
(162, 42, 'o', 'Shoutbox', 'tiki-shoutbox.php', 1190, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(163, 42, 'o', 'Shoutbox Words', 'tiki-admin_shoutbox_words.php', 1191, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(164, 42, 'o', 'Referer Stats', 'tiki-referer_stats.php', 1195, 'feature_referer_stats', 'tiki_p_view_referer_stats', '', 0, NULL, NULL),
(165, 42, 'o', 'Integrator', 'tiki-admin_integrator.php', 1205, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, NULL, NULL),
(166, 42, 'o', 'phpinfo', 'tiki-phpinfo.php', 1215, '', 'tiki_p_admin', '', 0, NULL, NULL),
(167, 42, 'o', 'Tiki Cache/Sys Admin', 'tiki-admin_system.php', 1230, '', 'tiki_p_clean_cache', '', 0, NULL, NULL),
(168, 42, 'o', 'Tiki Importer', 'tiki-importer.php', 1240, '', 'tiki_p_admin_importer', '', 0, NULL, NULL),
(169, 42, 'o', 'Tiki Logs', 'tiki-syslog.php', 1245, '', 'tiki_p_admin', '', 0, NULL, NULL),
(170, 42, 'o', 'Tiki Manager', 'tiki-ajax_services.php?controller=manager&action=index', 1247, 'feature_tiki_manager', 'tiki_p_admin', '', 0, NULL, NULL),
(171, 42, 'o', 'Security Admin', 'tiki-admin_security.php', 1250, '', 'tiki_p_admin', '', 0, NULL, NULL),
(172, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_admin', '', 0, NULL, NULL),
(173, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog', '', 0, NULL, NULL),
(174, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog_owngroups', '', 0, NULL, NULL),
(175, 42, 'o', 'Content Templates', 'tiki-admin_content_templates.php', 1256, 'feature_wiki_templates', 'tiki_p_edit_content_templates', '', 0, NULL, NULL),
(176, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_wiki_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(177, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_article_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(178, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_file_galleries_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(179, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_poll_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(180, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_faq_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(181, 42, 'o', 'Contribution', 'tiki-admin_contribution.php', 1265, 'feature_contribution', 'tiki_p_admin_contribution', '', 0, NULL, NULL),
(182, 42, 's', 'Kaltura Video', 'tiki-list_kaltura_entries.php', 950, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, 'kaltura48x48', NULL),
(183, 42, 'o', 'List Media', 'tiki-list_kaltura_entries.php', 952, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, NULL, NULL),
(184, 42, 'o', 'Permissions', 'tiki-objectpermissions.php', 1077, '', 'tiki_p_admin|tiki_p_admin_objects', '', 0, NULL, NULL),
(185, 42, 'o', 'Perspectives', 'tiki-edit_perspective.php', 1081, 'feature_perspective', 'tiki_p_admin', '', 0, NULL, NULL),
(186, 42, 'o', 'Social networks', 'tiki-socialnetworks.php', 115, 'feature_mytiki,feature_socialnetworks', 'tiki_p_socialnetworks|tiki_p_admin_socialnetworks', 'Registered', 0, NULL, NULL),
(187, 42, 'o', 'Scheduler', 'tiki-admin_schedulers.php', 1270, '', 'tiki_p_admin', '', 0, NULL, NULL),
(188, 42, 'o', 'Webservices', 'tiki-admin_webservices.php', 1280, 'feature_webservices', 'tiki_p_admin_webservices', '', 0, NULL, NULL),
(189, 42, 'o', 'References', 'tiki-references.php', 255, 'feature_wiki,feature_references', 'tiki_p_edit_references', '', 0, NULL, NULL),
(190, 42, 'o', 'Custom Routes', 'tiki-admin_routes.php', 1290, 'feature_sefurl_routes', 'tiki_p_admin', '', 0, NULL, NULL),
(191, 42, 'o', 'Admin Icons Dashboard', 'tiki-admin.php?admin_dashboard_icons=y', 1053, 'theme_unified_admin_backend', 'tiki_p_admin', '', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_events`
--

CREATE TABLE `tiki_minical_events` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `eventId` int NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `start` int DEFAULT NULL,
  `end` int DEFAULT NULL,
  `security` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` int DEFAULT NULL,
  `topicId` int DEFAULT NULL,
  `reminded` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_topics`
--

CREATE TABLE `tiki_minical_topics` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `topicId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isIcon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`topicId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minichat`
--

CREATE TABLE `tiki_minichat` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `channel` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ts` int unsigned NOT NULL,
  `user` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nick` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `msg` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `channel` (`channel`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_modules`
--

CREATE TABLE `tiki_modules` (
  `moduleId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ord` int NOT NULL DEFAULT '0',
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cache_time` int DEFAULT NULL,
  `rows` int DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`moduleId`),
  KEY `positionType` (`position`,`type`),
  KEY `namePosOrdParam` (`name`(100),`position`,`ord`,`params`(120))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `tiki_modules`
--

INSERT INTO `tiki_modules` VALUES
(1, 'menu', 'left', 1, NULL, NULL, 7200, NULL, 'id=42&title=System+Menu', 'a:1:{i:0;s:10:"Registered";}'),
(2, 'logo', 'top', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(3, 'login_box', 'top', 2, NULL, NULL, 0, NULL, 'mode=popup&nobox=y', 'a:0:{}'),
(4, 'rsslist', 'bottom', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(5, 'poweredby', 'bottom', 2, NULL, NULL, 7200, NULL, 'nobox=y&icons=n&version=n', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletters`
--

CREATE TABLE `tiki_newsletters` (
  `nlId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `lastSent` int DEFAULT NULL,
  `editions` int DEFAULT NULL,
  `users` int DEFAULT NULL,
  `allowUserSub` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `allowAnySub` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unsubMsg` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `validateAddr` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `frequency` int DEFAULT NULL,
  `allowTxt` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allowArticleClip` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `autoArticleClip` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `articleClipTypes` text COLLATE utf8mb4_unicode_ci,
  `articleClipRange` int DEFAULT NULL,
  `emptyClipBlocksSend` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  PRIMARY KEY (`nlId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_groups`
--

CREATE TABLE `tiki_newsletter_groups` (
  `nlId` int NOT NULL DEFAULT '0',
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `include_groups` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  PRIMARY KEY (`nlId`,`groupName`(179))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_included`
--

CREATE TABLE `tiki_newsletter_included` (
  `nlId` int NOT NULL DEFAULT '0',
  `includedId` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`nlId`,`includedId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_pages`
--

CREATE TABLE `tiki_newsletter_pages` (
  `nlId` int NOT NULL,
  `wikiPageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `validateAddrs` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `addToList` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`wikiPageName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_subscriptions`
--

CREATE TABLE `tiki_newsletter_subscriptions` (
  `nlId` int NOT NULL DEFAULT '0',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valid` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscribed` int DEFAULT NULL,
  `isUser` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `included` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`email`(178),`isUser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_oauthserver_clients`
--

CREATE TABLE `tiki_oauthserver_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_secret` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `redirect_uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `client_id` (`client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_objects`
--

CREATE TABLE `tiki_objects` (
  `objectId` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `href` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `comments_locked` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`objectId`),
  KEY `type` (`type`,`objectId`),
  KEY `itemId` (`itemId`(141),`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_attributes`
--

CREATE TABLE `tiki_object_attributes` (
  `attributeId` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attributeId`),
  UNIQUE KEY `item_attribute_uq` (`type`,`itemId`(91),`attribute`(50)),
  KEY `attribute_lookup_ix` (`attribute`,`value`(121))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_object_attributes`
--

INSERT INTO `tiki_object_attributes` VALUES
(1, 'wiki page', 'HomePage', 'tiki.wiki.page_hide_title', '0', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_ratings`
--

CREATE TABLE `tiki_object_ratings` (
  `catObjectId` int NOT NULL DEFAULT '0',
  `pollId` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_relations`
--

CREATE TABLE `tiki_object_relations` (
  `relationId` int NOT NULL AUTO_INCREMENT,
  `relation` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_fieldId` int DEFAULT NULL,
  `target_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata_itemId` int DEFAULT NULL,
  PRIMARY KEY (`relationId`),
  KEY `relation_source_ix` (`source_type`,`source_itemId`,`source_fieldId`),
  KEY `relation_target_ix` (`target_type`,`target_itemId`),
  KEY `metadata_itemId` (`metadata_itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_scores`
--

CREATE TABLE `tiki_object_scores` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `triggerObjectType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerObjectId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerUser` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerEvent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruleId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipientObjectType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipientObjectId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pointsAssigned` int NOT NULL,
  `pointsBalance` int NOT NULL,
  `date` int NOT NULL,
  `reversalOf` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_output`
--

CREATE TABLE `tiki_output` (
  `entityId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `outputType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int NOT NULL DEFAULT '0',
  `outputId` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`outputId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages`
--

CREATE TABLE `tiki_pages` (
  `page_id` int NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pageSlug` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int DEFAULT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int DEFAULT NULL,
  `comment` mediumtext COLLATE utf8mb4_unicode_ci,
  `version` int NOT NULL DEFAULT '0',
  `version_minor` int NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` int DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `cache` longtext COLLATE utf8mb4_unicode_ci,
  `wiki_cache` int DEFAULT NULL,
  `cache_timestamp` int DEFAULT NULL,
  `pageRank` decimal(4,3) DEFAULT NULL,
  `creator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_size` int unsigned DEFAULT '0',
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) DEFAULT '0',
  `created` int DEFAULT NULL,
  `wysiwyg` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wiki_authors_style` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `comments_enabled` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `pageName` (`pageName`),
  UNIQUE KEY `pageSlug` (`pageSlug`),
  KEY `data` (`data`(191)),
  KEY `pageRank` (`pageRank`),
  KEY `lastModif` (`lastModif`),
  FULLTEXT KEY `ft` (`pageName`,`description`,`data`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_pages`
--

INSERT INTO `tiki_pages` VALUES
(1, 'HomePage', 'HomePage', 0, '!Congratulations\nThis is the default homepage for your Tiki. If you are seeing this page, your installation was successful.\n\nYou can change this page after logging in. Please review the [http://doc.tiki.org/Wiki-syntax|wiki syntax] for editing details.\n\n\n!!Get started.\nTo begin configuring your site:\n{FANCYLIST()}\n1) Log in with your newly created password.\n2) Manually [tiki-admin.php?page=features|Enable specific Tiki features] that you didn''t enable with the Admin wizard.\n3) Run [tiki-admin.php?page=profiles|Tiki Profiles] to quickly get up and running.\n{FANCYLIST}\n\n!!Need help?\nFor more information:\n*[https://tiki.org/Introduction|Learn more about Tiki].\n*[https://tiki.org/|Get help], including the [http://doc.tiki.org|official documentation] and [http://tiki.org/forums|support forums].\n*[https://tiki.org/Join|Join the Tiki community].\n', '', [[timestamp]], 'Tiki initialization', 1, 0, 'admin', '0.0.0.0', '', NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 851, 'en', '', 0, [[timestamp]], 'n', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_changes`
--

CREATE TABLE `tiki_pages_changes` (
  `page_id` int NOT NULL DEFAULT '0',
  `version` int NOT NULL DEFAULT '0',
  `segments_added` int DEFAULT NULL,
  `segments_removed` int DEFAULT NULL,
  `segments_total` int DEFAULT NULL,
  PRIMARY KEY (`page_id`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_translation_bits`
--

CREATE TABLE `tiki_pages_translation_bits` (
  `translation_bit_id` int NOT NULL AUTO_INCREMENT,
  `page_id` int NOT NULL,
  `version` int NOT NULL,
  `source_translation_bit` int DEFAULT NULL,
  `original_translation_bit` int DEFAULT NULL,
  `flags` set('critical') COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`translation_bit_id`),
  KEY `page_id` (`page_id`),
  KEY `original_translation_bit` (`original_translation_bit`),
  KEY `source_translation_bit` (`source_translation_bit`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pageviews`
--

CREATE TABLE `tiki_pageviews` (
  `day` int NOT NULL DEFAULT '0',
  `pageviews` int DEFAULT NULL,
  PRIMARY KEY (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_footnotes`
--

CREATE TABLE `tiki_page_footnotes` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pageName` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`user`(150),`pageName`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_references`
--

CREATE TABLE `tiki_page_references` (
  `ref_id` int NOT NULL AUTO_INCREMENT,
  `page_id` int DEFAULT NULL,
  `biblio_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `part` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publisher` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `style` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ref_id`),
  UNIQUE KEY `uk1_tiki_page_ref_biblio_code` (`page_id`,`biblio_code`),
  KEY `PageId` (`page_id`),
  KEY `idx_tiki_page_ref_title` (`title`(191)),
  KEY `idx_tiki_page_ref_author` (`author`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_password_blacklist`
--

CREATE TABLE `tiki_password_blacklist` (
  `password` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`password`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_received`
--

CREATE TABLE `tiki_payment_received` (
  `paymentReceivedId` int NOT NULL AUTO_INCREMENT,
  `paymentRequestId` int NOT NULL,
  `payment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `amount` decimal(7,2) DEFAULT NULL,
  `type` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'paid',
  `details` text COLLATE utf8mb4_unicode_ci,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`paymentReceivedId`),
  KEY `payment_request_ix` (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_requests`
--

CREATE TABLE `tiki_payment_requests` (
  `paymentRequestId` int NOT NULL AUTO_INCREMENT,
  `amount` decimal(7,2) NOT NULL,
  `amount_paid` decimal(7,2) NOT NULL DEFAULT '0.00',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `due_date` timestamp NULL DEFAULT NULL,
  `authorized_until` timestamp NULL DEFAULT NULL,
  `cancel_date` timestamp NULL DEFAULT NULL,
  `description` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions` text COLLATE utf8mb4_unicode_ci,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `userId` int DEFAULT NULL,
  PRIMARY KEY (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_performance`
--

CREATE TABLE `tiki_performance` (
  `id` int NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_taken` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspectives`
--

CREATE TABLE `tiki_perspectives` (
  `perspectiveId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`perspectiveId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspective_preferences`
--

CREATE TABLE `tiki_perspective_preferences` (
  `perspectiveId` int NOT NULL,
  `pref` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`perspectiveId`,`pref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_plugin_security`
--

CREATE TABLE `tiki_plugin_security` (
  `fingerprint` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_by` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_objectId` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` mediumtext COLLATE utf8mb4_unicode_ci,
  `arguments` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fingerprint`(191)),
  KEY `last_object` (`last_objectType`,`last_objectId`(171))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_polls`
--

CREATE TABLE `tiki_polls` (
  `pollId` int NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `votes` int DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publishDate` int DEFAULT NULL,
  `voteConsiderationSpan` int DEFAULT '0',
  PRIMARY KEY (`pollId`),
  KEY `tiki_poll_lookup` (`active`,`title`(190))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_objects`
--

CREATE TABLE `tiki_poll_objects` (
  `catObjectId` int NOT NULL DEFAULT '0',
  `pollId` int NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_options`
--

CREATE TABLE `tiki_poll_options` (
  `pollId` int NOT NULL DEFAULT '0',
  `optionId` int NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int NOT NULL DEFAULT '0',
  `votes` int DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_preferences`
--

CREATE TABLE `tiki_preferences` (
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`name`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_preferences`
--

INSERT INTO `tiki_preferences` VALUES
('browsertitle', '[[site_name]]'),
('server_domain', '[[domhost]]'),
('sender_email', '[[admin_email]]'),
('https_login', 'allowed'),
('https_port', '443'),
('error_reporting_level', '2039'),
('use_proxy', 'n'),
('proxy_host', ''),
('proxy_port', ''),
('proxy_user', ''),
('proxy_pass', ''),
('error_reporting_adminonly', 'y'),
('smarty_notice_reporting', 'n'),
('log_tpl', 'n'),
('feature_switch_ssl_mode', 'n'),
('feature_show_stay_in_ssl_mode', 'n'),
('smarty_enable_string_eval', 'n'),
('language', '[[end_language]]'),
('unified_mysql_index_rebuilding', '[[indexName]]'),
('unified_total_fields', '39'),
('unified_field_count', '39'),
('unified_identifier_fields', 'a:13:{i:0;s:8:"language";i:1;s:10:"gallery_id";i:2;s:15:"view_permission";i:3;s:13:"primary_image";i:4;s:13:"comment_count";i:5;s:11:"geo_located";i:6;s:12:"geo_location";i:7;s:13:"title_initial";i:8;s:15:"title_firstword";i:9;s:10:"searchable";i:10;s:3:"url";i:11;s:11:"object_type";i:12;s:9:"object_id";}'),
('unified_mysql_index_current', '[[indexName]]'),
('unified_last_rebuild', '[[timestamp]]'),
('unified_last_rebuild_stats', 'a:1:{s:7:"default";a:3:{s:6:"counts";a:10:{s:11:"trackeritem";i:0;s:7:"tracker";i:0;s:12:"trackerfield";i:0;s:4:"file";i:0;s:12:"file gallery";i:3;s:7:"comment";i:0;s:4:"user";i:1;s:5:"group";i:3;s:9:"wiki page";i:0;s:8:"category";i:0;}s:5:"times";a:11:{s:11:"trackeritem";d:0.0009801387786865234375;s:7:"tracker";d:0.00038814544677734375;s:12:"trackerfield";d:0.000544071197509765625;s:4:"file";d:9.70363616943359375E-5;s:12:"file gallery";d:0.1630649566650390625;s:7:"comment";d:0.000277042388916015625;s:4:"user";d:0.0668628215789794921875;s:5:"group";d:0.0263531208038330078125;s:9:"wiki page";d:0.0001609325408935546875;s:8:"category";d:0.0015819072723388671875;s:5:"total";d:0.26031017303466796875;}s:25:"total tiki fields indexed";i:39;}}'),
('wizard_admin_hide_on_login', 'n'),
('language_admin', '[[admin_language]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_private_messages`
--

CREATE TABLE `tiki_private_messages` (
  `messageId` int NOT NULL AUTO_INCREMENT,
  `toNickname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `poster` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int DEFAULT NULL,
  `received` tinyint(1) NOT NULL DEFAULT '0',
  `message` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`messageId`),
  KEY `received` (`received`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_profile_symbols`
--

CREATE TABLE `tiki_profile_symbols` (
  `domain` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `named` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`domain`,`profile`(70),`object`(71)),
  KEY `named` (`named`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_programmed_content`
--

CREATE TABLE `tiki_programmed_content` (
  `pId` int NOT NULL AUTO_INCREMENT,
  `contentId` int NOT NULL DEFAULT '0',
  `content_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `publishDate` int NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_queue`
--

CREATE TABLE `tiki_queue` (
  `entryId` int NOT NULL AUTO_INCREMENT,
  `queue` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int NOT NULL,
  `handler` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`entryId`),
  KEY `queue_name_ix` (`queue`),
  KEY `queue_handler_ix` (`handler`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quizzes`
--

CREATE TABLE `tiki_quizzes` (
  `quizId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `canRepeat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `storeResults` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `questionsPerPage` int DEFAULT NULL,
  `timeLimited` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timeLimit` int DEFAULT NULL,
  `created` int DEFAULT NULL,
  `taken` int DEFAULT NULL,
  `immediateFeedback` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `showAnswers` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shuffleQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shuffleAnswers` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publishDate` int DEFAULT NULL,
  `expireDate` int DEFAULT NULL,
  `bDeleted` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nAuthor` int DEFAULT NULL,
  `bOnline` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bRandomQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nRandomQuestions` tinyint DEFAULT NULL,
  `bLimitQuestionsPerPage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nLimitQuestionsPerPage` tinyint DEFAULT NULL,
  `bMultiSession` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nCanRepeat` tinyint DEFAULT NULL,
  `sGradingMethod` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sShowScore` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sShowCorrectAnswers` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sPublishStats` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bAdditionalQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bForum` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sForum` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sPrologue` text COLLATE utf8mb4_unicode_ci,
  `sData` text COLLATE utf8mb4_unicode_ci,
  `sEpilogue` text COLLATE utf8mb4_unicode_ci,
  `passingperct` int DEFAULT '0',
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_questions`
--

CREATE TABLE `tiki_quiz_questions` (
  `questionId` int NOT NULL AUTO_INCREMENT,
  `quizId` int DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `position` int DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `maxPoints` int DEFAULT NULL,
  PRIMARY KEY (`questionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_question_options`
--

CREATE TABLE `tiki_quiz_question_options` (
  `optionId` int NOT NULL AUTO_INCREMENT,
  `questionId` int DEFAULT NULL,
  `optionText` text COLLATE utf8mb4_unicode_ci,
  `points` int DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_results`
--

CREATE TABLE `tiki_quiz_results` (
  `resultId` int NOT NULL AUTO_INCREMENT,
  `quizId` int DEFAULT NULL,
  `fromPoints` int DEFAULT NULL,
  `toPoints` int DEFAULT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`resultId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats`
--

CREATE TABLE `tiki_quiz_stats` (
  `quizId` int NOT NULL DEFAULT '0',
  `questionId` int NOT NULL DEFAULT '0',
  `optionId` int NOT NULL DEFAULT '0',
  `votes` int DEFAULT NULL,
  PRIMARY KEY (`quizId`,`questionId`,`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats_sum`
--

CREATE TABLE `tiki_quiz_stats_sum` (
  `quizId` int NOT NULL DEFAULT '0',
  `quizName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timesTaken` int DEFAULT NULL,
  `avgpoints` float DEFAULT NULL,
  `avgavg` float DEFAULT NULL,
  `avgtime` float DEFAULT NULL,
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_configs`
--

CREATE TABLE `tiki_rating_configs` (
  `ratingConfigId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int NOT NULL DEFAULT '3600',
  `formula` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `callbacks` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_obtained`
--

CREATE TABLE `tiki_rating_obtained` (
  `ratingId` int NOT NULL AUTO_INCREMENT,
  `ratingConfigId` int NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` int NOT NULL,
  `expire` int NOT NULL,
  `value` float NOT NULL,
  PRIMARY KEY (`ratingId`),
  UNIQUE KEY `tiki_obtained_rating_uq` (`type`,`object`,`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_articles`
--

CREATE TABLE `tiki_received_articles` (
  `receivedArticleId` int NOT NULL AUTO_INCREMENT,
  `receivedFromSite` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedDate` int DEFAULT NULL,
  `title` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int DEFAULT NULL,
  `useImage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_type` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int DEFAULT NULL,
  `image_x` int DEFAULT NULL,
  `image_y` int DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int DEFAULT NULL,
  `expireDate` int DEFAULT NULL,
  `created` int DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `body` longblob,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  PRIMARY KEY (`receivedArticleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_pages`
--

CREATE TABLE `tiki_received_pages` (
  `receivedPageId` int NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` longblob,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromSite` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedDate` int DEFAULT NULL,
  `parent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `structureName` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentName` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_alias` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `pos` int DEFAULT NULL,
  PRIMARY KEY (`receivedPageId`),
  KEY `structureName` (`structureName`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_referer_stats`
--

CREATE TABLE `tiki_referer_stats` (
  `referer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int DEFAULT NULL,
  `last` int DEFAULT NULL,
  `lasturl` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`referer`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_registration_fields`
--

CREATE TABLE `tiki_registration_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `show` tinyint(1) NOT NULL DEFAULT '1',
  `size` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_related_categories`
--

CREATE TABLE `tiki_related_categories` (
  `categId` int NOT NULL DEFAULT '0',
  `relatedTo` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`relatedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_feeds`
--

CREATE TABLE `tiki_rss_feeds` (
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rssVer` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `refresh` int DEFAULT '300',
  `lastUpdated` int DEFAULT NULL,
  `cache` longblob,
  PRIMARY KEY (`name`,`rssVer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_items`
--

CREATE TABLE `tiki_rss_items` (
  `rssItemId` int NOT NULL AUTO_INCREMENT,
  `rssId` int NOT NULL,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `publication_date` int unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `categories` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rssItemId`),
  KEY `tiki_rss_items_rss` (`rssId`),
  KEY `tiki_rss_items_item` (`rssId`,`guid`(177))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_modules`
--

CREATE TABLE `tiki_rss_modules` (
  `rssId` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `refresh` int DEFAULT NULL,
  `lastUpdated` int DEFAULT NULL,
  `showTitle` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `showPubDate` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `sitetitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `siteurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actions` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rssId`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_scheduler`
--

CREATE TABLE `tiki_scheduler` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `run_time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `re_run` tinyint DEFAULT NULL,
  `run_only_once` tinyint DEFAULT NULL,
  `creation_date` int DEFAULT NULL,
  `user_run_now` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_scheduler_run`
--

CREATE TABLE `tiki_scheduler_run` (
  `id` int NOT NULL AUTO_INCREMENT,
  `scheduler_id` int NOT NULL,
  `start_time` int DEFAULT NULL,
  `end_time` int DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `output` text COLLATE utf8mb4_unicode_ci,
  `stalled` tinyint DEFAULT '0',
  `healed` tinyint DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_schema`
--

CREATE TABLE `tiki_schema` (
  `patch_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `install_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patch_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_schema`
--

INSERT INTO `tiki_schema` VALUES
('00000000_schema_change_tiki', '[[regtime]]'),
('20080227_invite_tiki', '[[regtime]]'),
('20080809_semlinks_tiki', '[[regtime]]'),
('20080827_bigfeaturetype_tiki', '[[regtime]]'),
('20080829_pagealiasdata_tiki', '[[regtime]]'),
('20080829_pluginvalidation_tiki', '[[regtime]]'),
('20080901_pluginvalidation_tiki', '[[regtime]]'),
('20080902_trackerparsedesc_tiki', '[[regtime]]'),
('20080905_feature_tip_tiki', '[[regtime]]'),
('20080916_webservice_registry_tiki', '[[regtime]]'),
('20080922_calendar_customstatus_tiki', '[[regtime]]'),
('20080924_webmail_tiki', '[[regtime]]'),
('20080926_bannerindex_tiki', '[[regtime]]'),
('20081004_mindmap_menu_tiki', '[[regtime]]'),
('20081006_comments_moderation_tiki', '[[regtime]]'),
('20081008_bit_flags_nullable_tiki', '[[regtime]]'),
('20081010_filter_perms_tiki', '[[regtime]]'),
('20081014_trust_input_perm_tiki', '[[regtime]]'),
('20081018_filter_perms_tiki', '[[regtime]]'),
('20081019_score_tiki', '[[regtime]]'),
('20081022_application_menu_tiki', '[[regtime]]'),
('20081024_fulltext_file_tiki', '[[regtime]]'),
('20081027_calendar_tiki', '[[regtime]]'),
('20081027_file_galleries_tiki', '[[regtime]]'),
('20081027_groupalert_tiki', '[[regtime]]'),
('20081027_surveys_tiki', '[[regtime]]'),
('20081027_trackers_tiki', '[[regtime]]'),
('20081027_wysiwyg_history_tiki', '[[regtime]]'),
('20081029_tracker_index_tiki', '[[regtime]]'),
('20081102_application_menu_structures_tiki', '[[regtime]]'),
('20081105_calendar_items_allday_tiki', '[[regtime]]'),
('20081107_menu42_tiki', '[[regtime]]'),
('20081112_tiki_p_tracker_view_comments_tiki', '[[regtime]]'),
('20081114_tiki_banner_tiki', '[[regtime]]'),
('20081119_tiki_p_export_tracker_tiki', '[[regtime]]'),
('20081120_showCategories_tiki', '[[regtime]]'),
('20081120_tiki_poll_structures_update_tiki', '[[regtime]]'),
('20081125_tiki_tracker_types_tiki', '[[regtime]]'),
('20081127_calendar_recurrence_tiki', '[[regtime]]'),
('20081130_tiki_users_permission_tiki', '[[regtime]]'),
('20081211_newsletter_files_tiki', '[[regtime]]'),
('20081211_score_tiki', '[[regtime]]'),
('20081212_tiki_p_view_backlinks_tiki', '[[regtime]]'),
('20081214_webservice_post_tiki', '[[regtime]]'),
('20090106_group_watch_tiki', '[[regtime]]'),
('20090120_sefurl_rules_tiki', '[[regtime]]'),
('20090129_callendar_search_tiki', '[[regtime]]'),
('20090203_null_tiki', '[[regtime]]'),
('20090205_forum_and_comments_locking_tiki', '[[regtime]]'),
('20090205_menucase_tiki', '[[regtime]]'),
('20090205_menus_items_icons_tiki', '[[regtime]]'),
('20090206_content_tpl_menu_tiki', '[[regtime]]'),
('20090206_poll_tiki', '[[regtime]]'),
('20090211_mailnotification_tiki', '[[regtime]]'),
('20090212_forum_tiki', '[[regtime]]'),
('20090220_admin_section_tiki', '[[regtime]]'),
('20090226_admin_menu_tiki', '[[regtime]]'),
('20090301_browsertitle_tiki', '[[regtime]]'),
('20090304_tiki_p_view_backlink_without_s_tiki', '[[regtime]]'),
('20090306_menu_perms_tiki', '[[regtime]]'),
('20090306_text_for_menu_options_tiki', '[[regtime]]'),
('20090310_application_menu_tiki', '[[regtime]]'),
('20090310_feature_search_show_object_filter_tiki', '[[regtime]]'),
('20090311_remove_mod_menu_application_menu_tiki', '[[regtime]]'),
('20090316_index_tiki', '[[regtime]]'),
('20090323_maxUserImpressions_banners_tiki', '[[regtime]]'),
('20090330_quicktags_renames_tiki', '[[regtime]]'),
('20090401_newsletters_included_tiki', '[[regtime]]'),
('20090401_replace_shoutjax_with_shoutbox_tiki', '[[regtime]]'),
('20090401_replace_switch_lang2_with_switch_lang_tiki', '[[regtime]]'),
('20090416_plugin_security_tiki', '[[regtime]]'),
('20090416_quicktags_kil_email_tiki', '[[regtime]]'),
('20090416_quicktags_plugin_helpers_tiki', '[[regtime]]'),
('20090427_filegal_optionalize_tiki', '[[regtime]]'),
('20090429_groupId_tiki', '[[regtime]]'),
('20090513_calendar_priority_tiki', '[[regtime]]'),
('20090513_swffix_tiki', '[[regtime]]'),
('20090513_wiki_similar_permission_tiki', '[[regtime]]'),
('20090515_score_tiki', '[[regtime]]'),
('20090602_webmail_protocols_tiki', '[[regtime]]'),
('20090605_tiki_p_modify_tracker_items_pending_closed_tiki', '[[regtime]]'),
('20090617_add_new_table_for_reports_tiki', '[[regtime]]'),
('20090623_actionlog_view_article_tiki', '[[regtime]]'),
('20090626_change_pear_auth_preferences_to_ldap_tiki', '[[regtime]]'),
('20090707_tiki_p_delete_account_tiki', '[[regtime]]'),
('20090713_tiki_importer_permission_and_menu_entry_tiki', '[[regtime]]'),
('20090715_sefurl_for_filegalleries_tiki', '[[regtime]]'),
('20090720_perspectives_tiki', '[[regtime]]'),
('20090721_webmail_ext_public_tiki', '[[regtime]]'),
('20090727_category_permissions_tiki', '[[regtime]]'),
('20090727_user_votings_index_tiki', '[[regtime]]'),
('20090730_p_list_newsletters_tiki', '[[regtime]]'),
('20090803_perspective_permission_tiki', '[[regtime]]'),
('20090804_kaltura_permissions_tiki', '[[regtime]]'),
('20090804_menu_search_tiki', '[[regtime]]'),
('20090805_kill_newsreader_tiki', '[[regtime]]'),
('20090805_remove_drawings_prefs_etc_tiki', '[[regtime]]'),
('20090805_remove_games_tiki', '[[regtime]]'),
('20090806_group_permissions_tiki', '[[regtime]]'),
('20090806_menu_list_trackers_tiki', '[[regtime]]'),
('20090806_perms_featurechecks_tiki', '[[regtime]]'),
('20090806_remove_charts_tiki', '[[regtime]]'),
('20090806_remove_latin_collations_tiki', '[[regtime]]'),
('20090806_strasa_option_rename_tiki', '[[regtime]]'),
('20090807_transitions_tiki', '[[regtime]]'),
('20090808_add_wiki_minor_edits_tiki', '[[regtime]]'),
('20090809_marc_needs_more_space_tiki', '[[regtime]]'),
('20090811_filegals_container_tiki', '[[regtime]]'),
('20090811_kaltura_editor_pref_tiki', '[[regtime]]'),
('20090811_quizzes_tiki', '[[regtime]]'),
('20090811_rename_quicktags_to_toolbars_tiki', '[[regtime]]'),
('20090823_kaltura_menu_options_tiki', '[[regtime]]'),
('20090826_group_expiration_tiki', '[[regtime]]'),
('20090904_wysiwyg_newsletters_tiki', '[[regtime]]'),
('20090911_tracker_item_change_user_tiki', '[[regtime]]'),
('20090912_change_feature_name_for_lesser_magic_tiki', '[[regtime]]'),
('20090913_plugin_security_addedby_tiki', '[[regtime]]'),
('20090915_change_perms_for_browse_cats_tiki', '[[regtime]]'),
('20090921_logo_tiki', '[[regtime]]'),
('20090923_mod_change_category_defaults_tiki', '[[regtime]]'),
('20090925_online_logged_users_modules_merge_tiki', '[[regtime]]'),
('20090927_top_images_modules_merge_tiki', '[[regtime]]'),
('20090928_galaxia_leftovers_tiki', '[[regtime]]'),
('20090928_last_images_modules_merge_tiki', '[[regtime]]'),
('20090928_transition_guards_text_tiki', '[[regtime]]'),
('20091004_last_tracker_items_modules_merge_tiki', '[[regtime]]'),
('20091007_update_database_structure_tiki', '[[regtime]]'),
('20091008_reg_group_includes_anon_tiki', '[[regtime]]'),
('20091011_serurl_dl_order_tiki', '[[regtime]]'),
('20091013_fix_perms_tiki', '[[regtime]]'),
('20091015_application_menu_admin_renames_tiki', '[[regtime]]'),
('20091016_categorization_tracker_item_tiki', '[[regtime]]'),
('20091019_article_by_rating_modules_merge_tiki', '[[regtime]]'),
('20091019_last_articles_modules_merge_tiki', '[[regtime]]'),
('20091019_users_perms_types_tidying_tiki', '[[regtime]]'),
('20091020_bigger_user_prefs_tiki', '[[regtime]]'),
('20091020_faq_created_tiki', '[[regtime]]'),
('20091020_kaltura_tiki', '[[regtime]]'),
('20091020_remove_charts_tiki', '[[regtime]]'),
('20091020_sefurl_trackeritem_tiki', '[[regtime]]'),
('20091021_moz_pagelist_tiki', '[[regtime]]'),
('20091023_bookmarks_name_lengthen_tiki', '[[regtime]]'),
('20091023_nul_categ_tiki', '[[regtime]]'),
('20091023_report_tiki', '[[regtime]]'),
('20091027_multiple_session_handler_tiki', '[[regtime]]'),
('20091028_quota_tiki', '[[regtime]]'),
('20091030_wiki_watch_tiki', '[[regtime]]'),
('20091103_upgrade_categperm_tiki', '[[regtime]]'),
('20091105_auth_tokens_tiki', '[[regtime]]'),
('20091111_fgal_size_tiki', '[[regtime]]'),
('20091112_rename_mnu_application_menu_tiki', '[[regtime]]'),
('20091112_template_type_tiki', '[[regtime]]'),
('20091113_old_categ_perm_tiki', '[[regtime]]'),
('20091118_sefurl_tiki', '[[regtime]]'),
('20091120_poll_lookup_index_tiki', '[[regtime]]'),
('20091120_username_pattern_tiki', '[[regtime]]'),
('20091123_dns_permission_tiki', '[[regtime]]'),
('20091123_metrics_tiki', '[[regtime]]'),
('20091123_upgrade_categperm_2_tiki', '[[regtime]]'),
('20091124_fgal_backlink_tiki', '[[regtime]]'),
('20091124_metrics_dsn_tiki', '[[regtime]]'),
('20091125_wiki_comments_per_page_tiki', '[[regtime]]'),
('20091126_dynamic_variables_i18n_tiki', '[[regtime]]'),
('20091204_filegal_wiki_syntax_tiki', '[[regtime]]'),
('20091204_tiki_p_view_newsletter_tiki', '[[regtime]]'),
('20091208_backlink_perms_tiki', '[[regtime]]'),
('20091209_rss_feeds_name_tiki', '[[regtime]]'),
('20091210_charset_tiki', '[[regtime]]'),
('20091210_dcs_type_tiki', '[[regtime]]'),
('20091214_perspective_management_tiki', '[[regtime]]'),
('20091216_show_backlinks_tiki', '[[regtime]]'),
('20091228_page_keywords_tiki', '[[regtime]]'),
('20100101_search_modules_merge_tiki', '[[regtime]]'),
('20100101_search_wiki_page_modules_merge_tiki', '[[regtime]]'),
('20100104_tiki_p_tracker_revote_ratings_tiki', '[[regtime]]'),
('20100106_forum_att_list_nb_tiki', '[[regtime]]'),
('20100107_payment_tiki', '[[regtime]]'),
('20100113_forum_display_tiki', '[[regtime]]'),
('20100114_tiki_actionlog_merge_tiki', '[[regtime]]'),
('20100115_admin_modules_menu_tiki', '[[regtime]]'),
('20100115_tiki_p_admin_modules_tiki', '[[regtime]]'),
('20100115_translations_in_progress_tiki', '[[regtime]]'),
('20100117_old_doc_tw_o_url_tiki', '[[regtime]]'),
('20100118_blog_use_author_tiki', '[[regtime]]'),
('20100118_forum_display_tiki', '[[regtime]]'),
('20100126_file_lastDownload_tiki', '[[regtime]]'),
('20100128_tiki_p_blog_view_ref_tiki', '[[regtime]]'),
('20100129_clean_up_tiki', '[[regtime]]'),
('20100129_events_kil_tiki', '[[regtime]]'),
('20100203_payment_detail_tiki', '[[regtime]]'),
('20100205_tiki_p_wiki_view_ref_tiki', '[[regtime]]'),
('20100207_repair_file_galleries_tiki', '[[regtime]]'),
('20100211_rss_items_tiki', '[[regtime]]'),
('20100211_tiki_perms_menu_item_tiki', '[[regtime]]'),
('20100211_tiki_sheet_add_parseValues_tiki', '[[regtime]]'),
('20100212_rss_automation_tiki', '[[regtime]]'),
('20100213_group_inclusion_key_tiki', '[[regtime]]'),
('20100214_workspaces_remove_menu_items_tiki', '[[regtime]]'),
('20100215_create_tiki_user_login_cookies_tiki', '[[regtime]]'),
('20100215_rating_permissions_tiki', '[[regtime]]'),
('20100216_attributes_tiki', '[[regtime]]'),
('20100216_kil_moz_screencast_tiki', '[[regtime]]'),
('20100216_rename_tikisheet_tiki', '[[regtime]]'),
('20100217_rating_config_tiki', '[[regtime]]'),
('20100218_auth_token_reuse_tiki', '[[regtime]]'),
('20100222_add_webmail_fromEmail_field_tiki', '[[regtime]]'),
('20100222_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100223_blog_always_owner_tiki', '[[regtime]]'),
('20100224_object_relations_tiki', '[[regtime]]'),
('20100226_menu_template_feature_check_tiki', '[[regtime]]'),
('20100226_tracker_dump_perm_tiki', '[[regtime]]'),
('20100302_filegal_images_max_sizes_tiki', '[[regtime]]'),
('20100308_file_delete_after_tiki', '[[regtime]]'),
('20100309_add_sheet_parent_tiki', '[[regtime]]'),
('20100312_emailPattern_tiki', '[[regtime]]'),
('20100324_newsletters_clippings_tiki', '[[regtime]]'),
('20100409_bigger_module_params_tiki', '[[regtime]]'),
('20100414_actionlog_pref_tiki', '[[regtime]]'),
('20100414_actionlog_system_tiki', '[[regtime]]'),
('20100419_bigbluebutton_tiki', '[[regtime]]'),
('20100422_tracker_log_tiki', '[[regtime]]'),
('20100429_newsletter_pages_tiki', '[[regtime]]'),
('20100507_flash_banner_tiki', '[[regtime]]'),
('20100519_actionlog_tiki', '[[regtime]]'),
('20100525_tracker_validation_message_tiki', '[[regtime]]'),
('20100525_tracker_validation_tiki', '[[regtime]]'),
('20100611_rss_items_url_tiki', '[[regtime]]'),
('20100617_sefurl_user_info_tiki', '[[regtime]]'),
('20100618_calendar_participation_tiki', '[[regtime]]'),
('20100621_pageprefixaliasdata_tiki', '[[regtime]]'),
('20100622_pageprefixtrackeritemid_tiki', '[[regtime]]'),
('20100623_semantic_to_relation_tiki', '[[regtime]]'),
('20100624_banning_index_tiki', '[[regtime]]'),
('20100628_payment_user_tiki', '[[regtime]]'),
('20100629_remove_feature_blog_comments_tiki', '[[regtime]]'),
('20100702_discount_tiki', '[[regtime]]'),
('20100712_remove_unsupported_feed_formats_tiki', '[[regtime]]'),
('20100713_rename_feed_prefs_tiki', '[[regtime]]'),
('20100714_batch_transition_tiki', '[[regtime]]'),
('20100716_user_selector_pref_rename_tiki', '[[regtime]]'),
('20100720_tiki_p_view_page_contribution_tiki', '[[regtime]]'),
('20100721_batch_transition_rollback_tiki', '[[regtime]]'),
('20100721_todo_tiki', '[[regtime]]'),
('20100721_todonotif_tiki', '[[regtime]]'),
('20100727_tiki_p_promote_page_tiki', '[[regtime]]'),
('20100730_list_image_article_tiki', '[[regtime]]'),
('20100802_tiki_p_share_tiki', '[[regtime]]'),
('20100802_url_shortener_tiki', '[[regtime]]'),
('20100804_remove_tiki_languages_tiki', '[[regtime]]'),
('20100806_blog_posts_header_tiki', '[[regtime]]'),
('20100807_alter_tiki_translate_fields_to_text_tiki', '[[regtime]]'),
('20100810_title_comments_upgrade_tiki', '[[regtime]]'),
('20100812_blog_control_max_related_content_tiki', '[[regtime]]'),
('20100812_blog_show_related_content_tiki', '[[regtime]]'),
('20100817_add_email_and_website_fields_to_comments_tiki', '[[regtime]]'),
('20100817_credits_tiki', '[[regtime]]'),
('20100817_rename_preference_wiki_comments_notitle_tiki', '[[regtime]]'),
('20100818_watch_tiki', '[[regtime]]'),
('20100820_blog_posts_wysiwyg_tiki', '[[regtime]]'),
('20100820_feed_fields_text_and_desc_are_not_empty_tiki', '[[regtime]]'),
('20100824_blog_post_excerpt_tiki', '[[regtime]]'),
('20100825_add_changed_column_to_tiki_language_table_tiki', '[[regtime]]'),
('20100825_remove_blog_option_use_title_tiki', '[[regtime]]'),
('20100830_sheet_add_styles_and_classes_tiki', '[[regtime]]'),
('20100831_freetag_tiki', '[[regtime]]'),
('20100901_duplic_actionlog_tiki', '[[regtime]]'),
('20100901_expire_tiki', '[[regtime]]'),
('20100902_invit_tiki', '[[regtime]]'),
('20100903_article_ispublished_tiki', '[[regtime]]'),
('20100906_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100909_alter_tiki_language_fields_to_text_tiki', '[[regtime]]'),
('20100909_ckeditor_upgrade_tiki', '[[regtime]]'),
('20100909_lengthen_wiki_attachments_filename_tiki', '[[regtime]]'),
('20100910_new_fields_for_tiki_blogs_tiki', '[[regtime]]'),
('20100912_rename_autosave_pref_tiki', '[[regtime]]'),
('20100915_add_edit_languages_menu_option_tiki', '[[regtime]]'),
('20100919_tiki_page_contribution_tiki', '[[regtime]]'),
('20100920_ckeditor_remove_pref_tiki', '[[regtime]]'),
('20100920_jq_sheet_remove_pref_tiki', '[[regtime]]'),
('20100920_todo_event_tiki', '[[regtime]]'),
('20100923_fix_column_position_tiki', '[[regtime]]'),
('20100923_social_networking_permission_and_menuitem_tiki', '[[regtime]]'),
('20100925_fix_some_default_value_tiki', '[[regtime]]'),
('20100927_better_column_fix2_tiki', '[[regtime]]'),
('20100927_better_column_fix_tiki', '[[regtime]]'),
('20100928_sefurl_regex_reordering_tiki', '[[regtime]]'),
('20101008_user_id_for_tiki_language_tiki', '[[regtime]]'),
('20101014_tiki_language_add_lastModif_column_tiki', '[[regtime]]'),
('20101015_tiki_admin_perms_tiki', '[[regtime]]'),
('20101021_rename_blog_post_comment_object_type_tiki', '[[regtime]]'),
('20101025_fgal_show_deleteAfter_tiki', '[[regtime]]'),
('20101025_profile_sources_pref_tikiwiki_to_tiki', '[[regtime]]'),
('20101025_rename_create_blog_menu_entry_tiki', '[[regtime]]'),
('20101026_auth_token_add_columns_tiki', '[[regtime]]'),
('20101027_add_file_gallery_columns_tiki', '[[regtime]]'),
('20101027_rename_invit_to_invite_tiki', '[[regtime]]'),
('20101028_p_invit_tiki', '[[regtime]]'),
('20101110_actionlog_tiki', '[[regtime]]'),
('20101117_actionlog_tiki', '[[regtime]]'),
('20101119_categ_perm_tiki', '[[regtime]]'),
('20101126_fgal_add_gallerie_user_tiki', '[[regtime]]'),
('20101130_recreate_tiki_accounting_tables_tiki', '[[regtime]]'),
('20101130_tiki_accounting_tiki', '[[regtime]]'),
('20101201_tiki_accounting_fix_index_tiki', '[[regtime]]'),
('20101203_fgal_archive_default_tiki', '[[regtime]]'),
('20101207_feature_file_drafts_tiki', '[[regtime]]'),
('20101208_webservice_soap_tiki', '[[regtime]]'),
('20101210_fgal_add_wiki_attachments_tiki', '[[regtime]]'),
('20101210_sync_users_ldap_tiki', '[[regtime]]'),
('20101211_filegal_maxhits_column_tiki', '[[regtime]]'),
('20101211_kil_feature_phplayers_tiki', '[[regtime]]'),
('20101215_remove_files_tiki', '[[regtime]]'),
('20101215_template_file_galleries_tiki', '[[regtime]]'),
('20101219_kill_feature_mobile_tiki', '[[regtime]]'),
('20101230_create_top_modules_tiki', '[[regtime]]'),
('20110103_include_in_history_tiki', '[[regtime]]'),
('20110104_flagged_revision_log_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_again_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_tiki', '[[regtime]]'),
('20110112_approval_permissions_tiki', '[[regtime]]'),
('20110115_create_bottom_modules_tiki', '[[regtime]]'),
('20110118_p_remove_tracker_items_tiki', '[[regtime]]'),
('20110124_update_sheet_to_support_cloning_tiki', '[[regtime]]'),
('20110201_c_code_to_user_modules_tiki', '[[regtime]]'),
('20110209_p_list_users_tiki', '[[regtime]]'),
('20110220_p_tracker_view_attachments_tiki', '[[regtime]]'),
('20110223_queue_tiki', '[[regtime]]'),
('20110224_tiki_cart_inventory_hold_tiki', '[[regtime]]'),
('20110307_remove_calendar_reminder_tiki', '[[regtime]]'),
('20110308_rss_item_key_tiki', '[[regtime]]'),
('20110317_attributes_increase_length_tiki', '[[regtime]]'),
('20110411_banner_tiki', '[[regtime]]'),
('20110412_permissions_out_of_db_tiki', '[[regtime]]'),
('20110413_blog_post_priv_default_value_tiki', '[[regtime]]'),
('20110419_kill_old_search_tiki', '[[regtime]]'),
('20110420_newsletter_optional_group_inclusion_tiki', '[[regtime]]'),
('20110421_compact_search_in_topbar_tiki', '[[regtime]]'),
('20110507_remove_module_style_params_tiki', '[[regtime]]'),
('20110513_banner_tiki', '[[regtime]]'),
('20110519_quick_edit_categ_params_merge_tiki', '[[regtime]]'),
('20110603_convert_tracker_comments_tiki', '[[regtime]]'),
('20110606_convert_ip_fields_to_ipv6_tiki', '[[regtime]]'),
('20110609_batch_update_tracker_item_links_tiki', '[[regtime]]'),
('20110609_missing_sql_tiki', '[[regtime]]'),
('20110609_unique_login_tiki', '[[regtime]]'),
('20110610_readd_sefurl_index_left_tiki', '[[regtime]]'),
('20110610_revert_poll_additions_tiki', '[[regtime]]'),
('20110611_accounting_fix_primarykeys_tiki', '[[regtime]]'),
('20110613_filegal_source_display_tiki', '[[regtime]]'),
('20110614_provider_authentication_tiki', '[[regtime]]'),
('20110615_structure_alias_tiki', '[[regtime]]'),
('20110622_file_from_url_log_tiki', '[[regtime]]'),
('20110630_fix_blogs_copyright_frencho_tiki', '[[regtime]]'),
('20110717_invoice_menu_options_tiki', '[[regtime]]'),
('20110725_tracker_field_permname_tiki', '[[regtime]]'),
('20110727_tracker_multilingual_convert_tiki', '[[regtime]]'),
('20110803_objectpermissions_tiki', '[[regtime]]'),
('20110808_default_perm_name_tiki', '[[regtime]]'),
('20110808_tracker_tiki', '[[regtime]]'),
('20110815_creator_lost_7_tiki', '[[regtime]]'),
('20110819_group_max_length_tiki', '[[regtime]]'),
('20110823_tiki_connect_create_tiki', '[[regtime]]'),
('20110830_default_enable_in_use_tiki', '[[regtime]]'),
('20110830_tiki_connect_longer_guid_tiki', '[[regtime]]'),
('20110902_revert_rootCategId_addition_tiki', '[[regtime]]'),
('20110904_shoutbox_def_tweetid_tiki', '[[regtime]]'),
('20110905_extend_actionlog_comment_tiki', '[[regtime]]'),
('20110905_multibyte_lc_fix_tiki', '[[regtime]]'),
('20110908_author_submission_tiki', '[[regtime]]'),
('20110909_tiki_forums_add_language_tiki', '[[regtime]]'),
('20110911_add_missing_engine_specs_tiki', '[[regtime]]'),
('20110912_groupsexpiryanniversary_tiki', '[[regtime]]'),
('20110912_remove_unused_fields_tiki', '[[regtime]]'),
('20110923_referer_stats_tiki', '[[regtime]]'),
('20110926_tracker_menu_feature_reports_tiki', '[[regtime]]'),
('20111001_add_tiki_areas_tiki', '[[regtime]]'),
('20111006_drop_useless_key_tiki', '[[regtime]]'),
('20111010_revert_fix_user_bookmarks_folders_key_tiki', '[[regtime]]'),
('20111014_menu_feature_time_sheet_tiki', '[[regtime]]'),
('20111118_remove_versionOfPreferencesCache_tiki', '[[regtime]]'),
('20111210_add_blog_hits_tiki', '[[regtime]]'),
('20111217_on_value_tracker_tiki', '[[regtime]]'),
('20111231_change_datetime_defaults_to_null_tiki', '[[regtime]]'),
('20120115_remove_article_show_lang_tiki', '[[regtime]]'),
('20120118_remove_users_prefs_language_tiki', '[[regtime]]'),
('20120123_remove_column_from_tiki_user_reports_tiki', '[[regtime]]'),
('20120315_list_image_article_y_tiki', '[[regtime]]'),
('20120319_remove_sheets_with_no_relation_tiki', '[[regtime]]'),
('20120320_remove_admin_trackers_application_menu_tiki', '[[regtime]]'),
('20120323_add_reports_to_application_menu_tiki', '[[regtime]]'),
('20120323_remove_tracker_reports_from_application_menu_tiki', '[[regtime]]'),
('20120324_add_filegals_icon_tiki', '[[regtime]]'),
('20120401_kaltura_prefs_rename_tiki', '[[regtime]]'),
('20120408_add_forumthread_sefurl_tiki', '[[regtime]]'),
('20120421_autoincementtoautoincrement_tiki', '[[regtime]]'),
('20120422_mime_tiki', '[[regtime]]'),
('20120423_add_page_refs_tiki', '[[regtime]]'),
('20120423_add_status_attr_tiki', '[[regtime]]'),
('20120426_perspectives_menu_entry_tiki', '[[regtime]]'),
('20120426_tiki_db_status_tiki', '[[regtime]]'),
('20120429_fix_collation_tiki', '[[regtime]]'),
('20120510_mailqueue_tiki', '[[regtime]]'),
('20120604_add_holder_to_copyright_tiki', '[[regtime]]'),
('20120628_correct_admin_user_createdate_tiki', '[[regtime]]'),
('20120823_admin_user_credit_menu_entry_tiki', '[[regtime]]'),
('20120823_workspace_template_tiki', '[[regtime]]'),
('20120824_advanced_mode_flag_tiki', '[[regtime]]'),
('20120825_accounting_menu_entry_tiki', '[[regtime]]'),
('20120826_store_metadata_tiki', '[[regtime]]'),
('20120904_category_root_tiki', '[[regtime]]'),
('20120927_add_area_exclusive_and_common_tiki', '[[regtime]]'),
('20120927_add_menu_parse_tiki', '[[regtime]]'),
('20120930_tiki_p_view_poll_choices_tiki', '[[regtime]]'),
('20121009_module_search_box_to_search_tiki', '[[regtime]]'),
('20121016_actionlog_comment_text_tiki', '[[regtime]]'),
('20121027_tracker_samerow_fix_tiki', '[[regtime]]'),
('20121210_add_missing_index_user_assigned_modules_tiki', '[[regtime]]'),
('20121210_better_forum_reported_index_tiki', '[[regtime]]'),
('20121213_module_zone_enlarge_tiki', '[[regtime]]'),
('20130220_wiki_attachments_tiki', '[[regtime]]'),
('20130228_bigger_token_groups_tiki', '[[regtime]]'),
('20130301_sefurl_tracker_type_tiki', '[[regtime]]'),
('20130314_keep_search_pref_settings_tiki', '[[regtime]]'),
('20130322_app_menu_timesheet_pos_tiki', '[[regtime]]'),
('20130322_restore_lost_filegals_tiki', '[[regtime]]'),
('20130328_extend_actionlog_bbb_tiki', '[[regtime]]'),
('20130410_keep_wysiwyg_htmltowiki_setting_tiki', '[[regtime]]'),
('20130415_repair_file_galleries_again_tiki', '[[regtime]]'),
('20130417_score_alter_tiki', '[[regtime]]'),
('20130417_score_tiki', '[[regtime]]'),
('20130419_newsletters_clippings_tiki', '[[regtime]]'),
('20130513_convert_tracker_field_parameters_tiki', '[[regtime]]'),
('20130530_category_log_tiki', '[[regtime]]'),
('20130530_tracker_modification_log_tiki', '[[regtime]]'),
('20130605_mailin_show_inline_tiki', '[[regtime]]'),
('20130606_mailin_add_categoryId_tiki', '[[regtime]]'),
('20130608_convert_mailin_pwd_tiki', '[[regtime]]'),
('20130608_mailin_response_tiki', '[[regtime]]'),
('20130611_mailin_add_html_tiki', '[[regtime]]'),
('20130614_mailin_add_admin_tiki', '[[regtime]]'),
('20130616_mailin_add_namespace_tiki', '[[regtime]]'),
('20130623_create_mailin_user_struct_tiki', '[[regtime]]'),
('20130624_mailin_add_attr_tiki', '[[regtime]]'),
('20130704_catname_tiki', '[[regtime]]'),
('20130705_activity_stream_tiki', '[[regtime]]'),
('20130715_activity_stream_rules_tiki', '[[regtime]]'),
('20130730_friendship_conversion_tiki', '[[regtime]]'),
('20130730_wiki_para_format_default_change_tiki', '[[regtime]]'),
('20130807_tracker_files_display_param_change_tiki', '[[regtime]]'),
('20130809_limit_name_lengths_in_objects_tiki', '[[regtime]]'),
('20131007_menus_items_missing_icons_tiki', '[[regtime]]'),
('20131108_mytiki_add_mailin_tiki', '[[regtime]]'),
('20131117_unified_engine_default_change_tiki', '[[regtime]]'),
('20131218_stored_queries_tiki', '[[regtime]]'),
('20131231_add_sheet_metadata_tiki', '[[regtime]]'),
('20140109_query_unique_name_tiki', '[[regtime]]'),
('20140117_monitor_tiki', '[[regtime]]'),
('20140129_bigger_target_monitor_tiki', '[[regtime]]'),
('20140203_menu_item_and_icon_user_wizard_tiki', '[[regtime]]'),
('20140206_add_parser_column_tiki', '[[regtime]]'),
('20140210_user_wizard_add_section_name_tiki', '[[regtime]]'),
('20140214_goals_tiki', '[[regtime]]'),
('20140219_full_goal_events_tiki', '[[regtime]]'),
('20140301_add_column_rating_choice_topic_on_forums_tiki', '[[regtime]]'),
('20140318_user_wizard_add_groupname_tiki', '[[regtime]]'),
('20140402_mailin_protocol_option_tiki', '[[regtime]]'),
('20140402_payment_authorization_tiki', '[[regtime]]'),
('20140402_remove_mailin_smtp_tiki', '[[regtime]]'),
('20140509_rss_add_categories_tiki', '[[regtime]]'),
('20140625_survey_tiki', '[[regtime]]'),
('20140705_page_slug_tiki', '[[regtime]]'),
('20140807_federated_search_tiki', '[[regtime]]'),
('20140812_convert_tiki_connect_data_to_json_tiki', '[[regtime]]'),
('20140914_addon_profiles_tiki', '[[regtime]]'),
('20141003_change_style_pref_to_theme_tiki', '[[regtime]]'),
('20141106_menu_configuration_panel_tiki', '[[regtime]]'),
('20141114_remove_babelfish_tiki', '[[regtime]]'),
('20141120_tracker_tabular_tiki', '[[regtime]]'),
('20141122_change_prefname_availblestyles_to_availablethemes_tiki', '[[regtime]]'),
('20141125_menu_control_panels_tiki', '[[regtime]]'),
('20150109_tabular_filters_tiki', '[[regtime]]'),
('20150112_theme_option_etc_tiki', '[[regtime]]'),
('20150203_add_menu_option_class_tiki', '[[regtime]]'),
('20150310_rename_freetags_in_menu_42_tiki', '[[regtime]]'),
('20150310_rename_mytiki_in_menu_42_tiki', '[[regtime]]'),
('20150327_tracker_showPopup_option_fix_tiki', '[[regtime]]'),
('20150414_profile_symbol_tooshort_fix_tiki', '[[regtime]]'),
('20150426_menu_item_external_wikis_restored_tiki', '[[regtime]]'),
('20150508_perspectives_style_to_theme_tiki', '[[regtime]]'),
('20150730_menu_item_tabular_trackers_tiki', '[[regtime]]'),
('20150901_prefname_char_length_tiki', '[[regtime]]'),
('20150929_make_hotwords_longer_tiki', '[[regtime]]'),
('20151203_tiki_score_revamp_tiki', '[[regtime]]'),
('20151203_tokens_create_user_tiki', '[[regtime]]'),
('20160120_remove_gmap_menu_item_tiki', '[[regtime]]'),
('20160201_remove_maps_menus_tiki', '[[regtime]]'),
('20160206_theme_option_modules_tiki', '[[regtime]]'),
('20160315_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160325_menu_42_list_pages_tiki', '[[regtime]]'),
('20160420_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160519_calendar_events_action_log_tiki', '[[regtime]]'),
('20160527_menu_item_payment_tiki', '[[regtime]]'),
('20160604_remove_unwanted_files_tiki', '[[regtime]]'),
('20160608_menu_item_admin_tokens_tiki', '[[regtime]]'),
('20160612_new_password_implementation_tiki', '[[regtime]]'),
('20160612_remove_feature_challenge_pref_tiki', '[[regtime]]'),
('20160614_clear_password_removal_tiki', '[[regtime]]'),
('20160627_remove_more_unwanted_files_tiki', '[[regtime]]'),
('20160817_fix_dymanic_list_field_values_tiki', '[[regtime]]'),
('20160914_extwiki_missing_columns_fix_tiki', '[[regtime]]'),
('20160915_extwiki_indexname_length_tiki', '[[regtime]]'),
('20161109_remove_old_password_tiki', '[[regtime]]'),
('20161117_favicon_tiki', '[[regtime]]'),
('20161206_larger_comment_field_tiki', '[[regtime]]'),
('20161220_add_h5p_tables_tiki', '[[regtime]]'),
('20170122_schedulers_tiki', '[[regtime]]'),
('20170127_remove_templates_c_tiki', '[[regtime]]'),
('20170129_feature_dump_tiki', '[[regtime]]'),
('20170207_iefix_rem_tiki', '[[regtime]]'),
('20170213_footnotearea_tiki', '[[regtime]]'),
('20170218_schedulers_menu_tiki', '[[regtime]]'),
('20170305_webservices_menu_tiki', '[[regtime]]'),
('20170307_kill_wikilingo_tiki', '[[regtime]]'),
('20170319_kill_jcapture_tiki', '[[regtime]]'),
('20170322_fix_allocate_memory_prefs_tiki', '[[regtime]]'),
('20170329_add_color_to_groups_tiki', '[[regtime]]'),
('20170329_larger_category_descriptions_tiki', '[[regtime]]'),
('20170330_merge_hiddenlinks_into_headinglinks_tiki', '[[regtime]]'),
('20170427_update_accounting_journal_cols_tiki', '[[regtime]]'),
('20170531_feature_usability_tiki', '[[regtime]]'),
('20170628_schedulers_menu_tiki', '[[regtime]]'),
('20170702_wiki_url_scheme_pref_default_tiki', '[[regtime]]'),
('20170717_add_missing_trackeritem_attachment_backlinks_tiki', '[[regtime]]'),
('20170726_remove_article_hashes_tiki', '[[regtime]]'),
('20170726_tabular_config_tiki', '[[regtime]]'),
('20170829_custom_routes_tiki', '[[regtime]]'),
('20170920_admin_webservices_menu_option_tiki', '[[regtime]]'),
('20170925_add_general_to_language_tiki', '[[regtime]]'),
('20170930_custom_routes_menu_tiki', '[[regtime]]'),
('20171002_queue_handler_size_increase_tiki', '[[regtime]]'),
('20171010_action_log_info_new_column_tiki', '[[regtime]]'),
('20171016_no_homepage_specificed_tiki', '[[regtime]]'),
('20171121_create_plugin_include_relations_tiki', '[[regtime]]'),
('20171122_h5p_update_add_hub_table_tiki', '[[regtime]]'),
('20171123_create_object_links_tiki', '[[regtime]]'),
('20171129_backlinks_for_object_types_admin_options_tiki', '[[regtime]]'),
('20171130_plugin_include_link_original_tiki', '[[regtime]]'),
('20171204_update_geo_enabled_tiki', '[[regtime]]'),
('20171231_add_short_url_tiki', '[[regtime]]'),
('20180228_comment_on_object_attributes_tiki', '[[regtime]]'),
('20180331_rename_custom_route_object_type_tiki', '[[regtime]]'),
('20180405_custom_routes_menu_tiki', '[[regtime]]'),
('20180405_remove_unused_user_id_tiki', '[[regtime]]'),
('20180410_install_piwik_plugin_tiki', '[[regtime]]'),
('20180411_schedulers_change_column_to_text_tiki', '[[regtime]]'),
('20180412_rename_short_url_prefs_tiki', '[[regtime]]'),
('20180419_scheduler_run_stalled_column_tiki', '[[regtime]]'),
('20180421_scheduler_run_healed_column_tiki', '[[regtime]]'),
('20180503_fix_throttled_newsletters_tiki', '[[regtime]]'),
('20180609_change_log_column_type_tiki', '[[regtime]]'),
('20180625_user_reports_null_last_reports_tiki', '[[regtime]]'),
('20180705_fix_calendaritem_tracker_attributes_tiki', '[[regtime]]'),
('20180706_remove_menu_reports_tiki', '[[regtime]]'),
('20180803_semaphore_value_tiki', '[[regtime]]'),
('20180808_ocr_tiki', '[[regtime]]'),
('20180815_merge_topic_read_perm_tiki', '[[regtime]]'),
('20180909_remove_page_content_fetch_readability_tiki', '[[regtime]]'),
('20180918_remove_poweredby_module_tiki', '[[regtime]]'),
('20180921_php_upgrade_fix_from_older_tiki', '[[regtime]]'),
('20180921_sql_upgrade_fix_from_older_tiki', '[[regtime]]'),
('20180923_convert_collation_to_utf8mb4_tiki', '[[regtime]]'),
('20180925_feature_jquery_superfish_pref_default_tiki', '[[regtime]]'),
('20181114_ocr_uff8mb4_tiki', '[[regtime]]'),
('20181127_convert_db_local_to_utf8mb4_tiki', '[[regtime]]'),
('20181130_update_column_name_size_tracker_table_tiki', '[[regtime]]'),
('20190117_create_oauthserver_clients_table_tiki', '[[regtime]]'),
('20190121_h5p_add_new_library_fields_tiki', '[[regtime]]'),
('20190121_h5p_allow_null_in_filtered_tiki', '[[regtime]]'),
('20190123_h5p_move_storage_assets_to_new_dir_tiki', '[[regtime]]'),
('20190129_fix_ambiguity_on_oauthserver_id_column_tiki', '[[regtime]]'),
('20190226_change_xmpp_auth_pref_name_tiki', '[[regtime]]'),
('20190303_make_tiki_object_href_larger_tiki', '[[regtime]]'),
('20190401_add_support_database_strict_mode_tiki', '[[regtime]]'),
('20190425_add_creation_date_schedule_tiki', '[[regtime]]'),
('20190425_set_creation_date_to_scheduler_tiki', '[[regtime]]'),
('20190523_migrate_webmail_accounts_tiki', '[[regtime]]'),
('20190526_remove_tiki_addon_profiles_tiki', '[[regtime]]'),
('20190620_add_role_groups_tiki', '[[regtime]]'),
('20190627_add_ocr_fgal_status_tiki', '[[regtime]]'),
('20190717_add_role_categ_available_tiki', '[[regtime]]'),
('20190722_ocr_fgal_tiki', '[[regtime]]'),
('20190723_add_is_tlp_group_tiki', '[[regtime]]'),
('20190729_add_tlp_group_category_tiki', '[[regtime]]'),
('20190831_add_two_factor_secret_tiki', '[[regtime]]'),
('20190913_caldav_tiki', '[[regtime]]'),
('20190925_caldav_updates_tiki', '[[regtime]]'),
('20191114_caldav_recurring_updates_tiki', '[[regtime]]'),
('20191116_scheduler_run_only_once_tiki', '[[regtime]]'),
('20191126_add_forum_parent_tiki', '[[regtime]]'),
('20191218_carddav_tiki', '[[regtime]]'),
('20200113_tracker_field_rules_column_tiki', '[[regtime]]'),
('20200123_calendar_rsvp_tiki', '[[regtime]]'),
('20200126_remove_invoice_menu_options_tiki', '[[regtime]]'),
('20200205_mailin_add_galleryid_tiki', '[[regtime]]'),
('20200218_mailin_add_trackerid_tiki', '[[regtime]]'),
('20200309_fix_sefurl_regex_out_issues_tiki', '[[regtime]]'),
('20200311_add_forum_order_tiki', '[[regtime]]'),
('20200513_expand_sessions_data_column_tiki', '[[regtime]]'),
('20200601_carddav_contact_uri_tiki', '[[regtime]]'),
('20200613_scheduler_run_now_tiki', '[[regtime]]'),
('20200614_expand_mail_queue_message_column_tiki', '[[regtime]]'),
('20200701_rename_pref_unified_lucene_default_operator_tiki', '[[regtime]]'),
('20200710_feature_templated_groups_tiki', '[[regtime]]'),
('20200820_performance_table_creation_tiki', '[[regtime]]'),
('20200903_create_encryption_keys_tiki', '[[regtime]]'),
('20200903_create_machine_learning_models_tiki', '[[regtime]]'),
('20200910_add_encryption_key_to_tracker_fields_tiki', '[[regtime]]'),
('20200928_add_machine_learning_menu_options_tiki', '[[regtime]]'),
('20201024_h5p_add_a11y_title_tiki', '[[regtime]]'),
('20201024_h5p_add_default_lang_tiki', '[[regtime]]'),
('20201118_add_odbc_tabulars_tiki', '[[regtime]]'),
('20201212_remove_comment_hash_tiki', '[[regtime]]'),
('20210115_add_trackerfields_sefurl_tiki', '[[regtime]]'),
('20210316_preference_replace_chosen_with_select2_tiki', '[[regtime]]'),
('20210410_alter_activity_stream_arguments_column_tiki', '[[regtime]]'),
('20210421_add_ml_label_field_tiki', '[[regtime]]'),
('20210428_mailin_add_preferences_tiki', '[[regtime]]'),
('20210605_image_gallery_removal_tiki', '[[regtime]]'),
('20210608_timesheet_menu_removal_tiki', '[[regtime]]'),
('20210819_theme_unified_admin_backend_pref_default_tiki', '[[regtime]]'),
('20211004_calendar_weekly_multiple_tiki', '[[regtime]]'),
('20211020_mark_image_gallery_tables_as_unused_tiki', '[[regtime]]'),
('20211110_create_api_tokens_tiki', '[[regtime]]'),
('20211126_timezone_date_update_tiki', '[[regtime]]'),
('20220111_backlinks_tiki', '[[regtime]]'),
('20220112_extend_api_tokens_tiki', '[[regtime]]'),
('20220112_extend_oauthserver_clients_tiki', '[[regtime]]'),
('20220113_password_blacklist_tiki', '[[regtime]]'),
('20220119_make_user_nullable_api_tokens_tiki', '[[regtime]]'),
('20220301_add_manager_menu_option_tiki', '[[regtime]]'),
('20220503_add_api_tabulars_tiki', '[[regtime]]'),
('20220601_discard_hash_column_from_articles_tiki', '[[regtime]]'),
('20220726_create_webhooks_tiki', '[[regtime]]'),
('20220808_add_user_to_auth_sources_tiki', '[[regtime]]'),
('20220811_http_prefs_default_tiki', '[[regtime]]'),
('20220811_permissions_print_and_pdf_export_tiki', '[[regtime]]'),
('20220909_remove_tiki_mindmap_feature_tiki', '[[regtime]]'),
('20220923_increase_prefs_value_size_tiki', '[[regtime]]'),
('20221020_add_direct_to_file_galleries_tiki', '[[regtime]]'),
('20221024_add_indexes_to_file_galleries_tiki', '[[regtime]]'),
('20221026_add_fgal_sync_to_action_log_tiki', '[[regtime]]'),
('20221028_remove_openid_url_tiki', '[[regtime]]'),
('20221102_add_exclude_from_notification_tiki', '[[regtime]]'),
('20221110_add_actionforuser_index_on_actionlog_tiki', '[[regtime]]'),
('20221111_ft_rename_tracker_tabular_tiki', '[[regtime]]'),
('20221128_force_refresh_of_mapping_for_forum_section_tiki', '[[regtime]]'),
('20221218_add_field_properties_visible_mode_tiki', '[[regtime]]'),
('20230118_add_notification_sent_on_plugin_security_tiki', '[[regtime]]'),
('20230120_add_plugin_details_on_plugin_security_tiki', '[[regtime]]'),
('20230125_add_goalid_to_credits_tiki', '[[regtime]]'),
('20230217_mailin_alter_leave_email_tiki', '[[regtime]]'),
('20230224_plugin_security_tiki_change_arguments_default_value_tiki', '[[regtime]]'),
('20230327_update_tiki_manager_menu_section_tiki', '[[regtime]]'),
('20230504_add_attemps_on_tiki_banning_tiki', '[[regtime]]'),
('20230510_recurringevent_bymonth_based_on_weekday_tiki', '[[regtime]]'),
('20230515_larger_rating_field_articles_tiki', '[[regtime]]'),
('20230520_add_blog_allow_post_categorization_tiki', '[[regtime]]'),
('20230522_relation_metadata_tiki', '[[regtime]]'),
('20230608_add_timezone_picker_recurrenctevent_tiki', '[[regtime]]'),
('20230625_multiprint_fix_error_data_too_long_for_column_parameters_tiki', '[[regtime]]'),
('20230703_fix_error_data_too_long_for_column_body_thrown_on_long_page_saving_tiki', '[[regtime]]'),
('20230709_create_tiki_custom_color_modes_tiki', '[[regtime]]'),
('20230803_tiki_menu_options_rename_url_import_export_formats_tiki', '[[regtime]]'),
('20230807_sefurl_fix_error_of_wrong_url_for_column_stats_tiki', '[[regtime]]'),
('20230815_fix_error_data_too_long_for_column_comment_and_entry_thrown_on_long_page_saving_tiki', '[[regtime]]'),
('20230816_fix_wrong_primary_key_setting_on_several_table_tiki', '[[regtime]]'),
('20230822_create_calendar_propertystorage_tiki', '[[regtime]]'),
('20230824_calendar_calssification_pattern_background_ui_tiki', '[[regtime]]'),
('20230825_calendar_recurrence_fields_tiki', '[[regtime]]'),
('20230828_add_restriction_tiki_surveys_tiki', '[[regtime]]'),
('20230831_remove_calendarid_from_subscriptions_tiki', '[[regtime]]'),
('20230906_add_sync_to_calendar_subscriptions_tiki', '[[regtime]]'),
('20231008_fix_primary_key_issues_on_several_tables_tiki', '[[regtime]]'),
('20231025_remove_upload_option_from_kaltura_feature_tiki', '[[regtime]]'),
('20231026_remove_pref_kaltura_kcwuiconf_tiki', '[[regtime]]'),
('20231108_add_private_to_calendars_tiki', '[[regtime]]'),
('20231110_remove_searchresults_tiki', '[[regtime]]'),
('20231119_extend_actionlog_conf_crsf_error_tiki', '[[regtime]]'),
('20240126_calendar_recurrence_dayofmonth_tiki', '[[regtime]]'),
('20240311_various_pref_default_tiki27_tiki', '[[regtime]]'),
('20240312_fix_usage_implicit_timestamp_tiki', '[[regtime]]'),
('20240405_modify_tiki_pages_description_type_tiki', '[[regtime]]'),
('20240408_add_api_to_action_log_tiki', '[[regtime]]'),
('20240412_recurringevent_bymonth_based_on_firstlastweekday_tiki', '[[regtime]]'),
('20240412_recurringevent_byyear_based_on_firstlastweekday_tiki', '[[regtime]]'),
('20240418_fix_included_plugins_pref_default_tiki', '[[regtime]]'),
('20240419_tabular_itemlink_lookup_simple_rename_tiki', '[[regtime]]'),
('20240502_fix_out_of_range_issue_on_tikiquizstatssum_table_tiki', '[[regtime]]'),
('20240505_fix_tracker_visibility_fields_tiki', '[[regtime]]'),
('20240531_tiki_file_attach_relation_to_emails_tiki', '[[regtime]]'),
('20240620_offline_trackers_menu_option_tiki', '[[regtime]]'),
('20240719_keep_link_to_legacy_icons_admin_dashboard_tiki', '[[regtime]]'),
('20240818_add_custom_status_to_calendar_item_tiki', '[[regtime]]'),
('20240828_create_tiki_iot_apps_tables_tiki', '[[regtime]]'),
('20240829_increase_user_prefs_value_size_tiki', '[[regtime]]'),
('20240923_create_tiki_sql_query_logs_tiki', '[[regtime]]'),
('20240923_update_unified_trackerfield_keys_tiki', '[[regtime]]'),
('20241015_expand_sql_query_column_tiki', '[[regtime]]'),
('20241018_theme_unified_admin_backend_pref_default_tiki', '[[regtime]]'),
('20241107_update_right_column_for_file_type_in_sefurl_tiki', '[[regtime]]'),
('20241114_update_url_type_from_rss_module_tiki', '[[regtime]]'),
('20250104_add_password_management_history_tiki', '[[regtime]]'),
('999999991_decode_pages_sources_tiki', '[[regtime]]'),
('99999999_image_plugins_kill_tiki', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_score`
--

CREATE TABLE `tiki_score` (
  `event` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  `reversalEvent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_score`
--

INSERT INTO `tiki_score` VALUES
('tiki.user.login', '[\n    {"ruleId":"User logs in","recipientType":"user","recipient":"user","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.view', '[\n    {"ruleId":"See other user''s profile","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your profile seen","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.friend', '[\n    {"ruleId":"Make friends","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.message', '[\n    {"ruleId":"Send message","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Receive message","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.create', '[\n    {"ruleId":"Publish new article","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.view', '[\n    {"ruleId":"Read an article","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your article read","recipientType":"user","recipient":"author","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.filegallery.create', '[\n    {"ruleId":"Create new file gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.create', '[\n    {"ruleId":"Upload new file to gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.download', '[\n    {"ruleId":"Download other user''s file","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your file downloaded","recipientType":"user","recipient":"owner","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.create', '[\n    {"ruleId":"Create new blog","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blogpost.create', '[\n    {"ruleId":"Post in a blog","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.view', '[\n    {"ruleId":"Read other user''s blog","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your blog read","recipientType":"user","recipient":"author","score":"3","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.create', '[\n    {"ruleId":"Create a wiki page","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.update', '[\n    {"ruleId":"Edit an existing wiki page","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.attachfile', '[\n    {"ruleId":"Attach file to wiki page","recipientType":"user","recipient":"user","score":"3","validObjectIds":[""],"expiration":""}\n]', '');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_queries`
--

CREATE TABLE `tiki_search_queries` (
  `queryId` int NOT NULL AUTO_INCREMENT,
  `userId` int NOT NULL,
  `lastModif` int DEFAULT NULL,
  `label` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` blob,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`queryId`),
  UNIQUE KEY `tiki_user_query_uq` (`userId`,`label`),
  KEY `query_userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_stats`
--

CREATE TABLE `tiki_search_stats` (
  `term` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int DEFAULT NULL,
  PRIMARY KEY (`term`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_secdb`
--

CREATE TABLE `tiki_secdb` (
  `md5_value` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tiki_version` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `severity` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`filename`(171),`tiki_version`(20)),
  KEY `sdb_fn` (`filename`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_secdb`
--

INSERT INTO `tiki_secdb` VALUES
('c94a2803140338162737442f39b534bf', './.phpstorm.meta.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './_custom_dist/index.php', '28.4', 0),
('62544beb47f4e11a57e6a7567610a46b', './_custom_dist/shared/custom.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './_custom_dist/shared/index.php', '28.4', 0),
('f83300a1c12140dbf6d3cdb5342c9e72', './_custom_dist/shared/js/custom.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './_custom_dist/shared/js/index.php', '28.4', 0),
('142cf4d5b691afa1a0201e779c156b39', './_custom_dist/shared/lang/en/custom.js', '28.4', 0),
('d620b38f3606eb017ff5c62f51e6b4a1', './_custom_dist/shared/lang/en/custom.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './_custom_dist/shared/lang/en/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './_custom_dist/shared/lang/index.php', '28.4', 0),
('37c4c8441a4009edf314bb24a1d6a43c', './_custom_dist/shared/templates/footer.tpl', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './_custom_dist/shared/templates/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './_custom_dist/shared/wiki-plugins/index.php', '28.4', 0),
('452ea26ea41881d1aea86e32c857d638', './_custom_dist/shared/wiki-plugins/wikiplugin_helloworld.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './_custom_dist/sites/default_site/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './_custom_dist/sites/default_site/themes/customizationstest/css/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './_custom_dist/sites/default_site/themes/customizationstest/images/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './_custom_dist/sites/default_site/themes/customizationstest/index.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './_custom_dist/sites/default_site/themes/customizationstest/lang/en/index.php', '28.4', 0),
('cc2ee82911db208d99afc99992e67296', './_custom_dist/sites/default_site/themes/customizationstest/lang/en/language.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './_custom_dist/sites/default_site/themes/customizationstest/lang/index.php', '28.4', 0),
('c171256f32ccc8c5a580e3c415798ee8', './_custom_dist/sites/default_site/themes/customizationstest/options/blue/css/blue.css', '28.4', 0),
('ae1ca7e7618014a7056b4cfef3362afd', './_custom_dist/sites/default_site/themes/customizationstest/options/blue/css/index.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './_custom_dist/sites/default_site/themes/customizationstest/options/blue/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './_custom_dist/sites/default_site/themes/customizationstest/options/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './_custom_dist/sites/default_site/themes/customizationstest/scss/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './_custom_dist/sites/default_site/themes/customizationstest/templates/index.php', '28.4', 0),
('ae1ca7e7618014a7056b4cfef3362afd', './_custom_dist/sites/default_site/themes/customizationstest/templates/layouts/hello_world/index.php', '28.4', 0),
('bfe6148896828563cc43dd96384430e8', './_custom_dist/sites/default_site/themes/customizationstest/templates/layouts/hello_world/layout_view.tpl', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './_custom_dist/sites/default_site/themes/customizationstest/templates/layouts/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './_custom_dist/sites/default_site/themes/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './_custom_dist/sites/index.php', '28.4', 0),
('17e13a10570498e39a318a5f711d6641', './about.php', '28.4', 0),
('c5f4a407f904e850ce0d7585d27e3835', './admin/define_admin_icons.php', '28.4', 0),
('7e201be2d15c26f6fbe80d6e14e38203', './admin/include_articles.php', '28.4', 0),
('6eeeeb7dbefaf4fb44566976e3e683ef', './admin/include_category.php', '28.4', 0),
('42680289a313591ec37e17683e06d208', './admin/include_connect.php', '28.4', 0),
('a1c1c81768b28cd43aa30ce184073483', './admin/include_credits.php', '28.4', 0),
('c809be60a5df1e081c82d018d75378c8', './admin/include_features.php', '28.4', 0),
('0bac741af585985cb8d35c6e5ec94afa', './admin/include_fgal.php', '28.4', 0),
('0ddbb810408f0c412ec5f66218c93437', './admin/include_freetags.php', '28.4', 0),
('eee7a12a3c4d0084688b2f8d18e7dcd0', './admin/include_general.php', '28.4', 0),
('d6b0271ec42c1c0d9c8a44b9f47be06d', './admin/include_i18n.php', '28.4', 0),
('1f614d6edf4f4a2f73e9cde5415c53b6', './admin/include_intertiki.php', '28.4', 0),
('e11fecdef61eb5e158250c91218c9b2f', './admin/include_login.php', '28.4', 0),
('c114e9923412fb0f7b778e7dd683fa3a', './admin/include_look.php', '28.4', 0),
('9ec86035735e5a30b72be1dae7226e9d', './admin/include_mautic.php', '28.4', 0),
('d8e6bd334cd8799dadbbb93b756199b7', './admin/include_orphanprefs.php', '28.4', 0),
('1ce1d56605189420bb07af1d7735106e', './admin/include_packages.php', '28.4', 0),
('adccd1eab733c244552374b3c655c950', './admin/include_performance.php', '28.4', 0),
('35c372be875e8f59086a75bdb10bf89c', './admin/include_profiles.php', '28.4', 0),
('a0a33916e8a6ad35443cb474fcf46d13', './admin/include_rating.php', '28.4', 0),
('c701f7fa0335141b129f0fddddc08a98', './admin/include_score.php', '28.4', 0),
('4e7467e5d5a54d85a88a9bf1f184c560', './admin/include_search.php', '28.4', 0),
('d53bfc79c9fd0293ab49b616033f07c1', './admin/include_security.php', '28.4', 0),
('5a886e4cd05c788ffcd9bb5133d04568', './admin/include_sefurl.php', '28.4', 0),
('bc2c10a3ca06ca4c55d72040e67218a8', './admin/include_semantic.php', '28.4', 0),
('173f435ce555cadef2fdd92240c97710', './admin/include_seoprefs.php', '28.4', 0),
('840b06c30be89d1f64e3f8e0725941ef', './admin/include_socialnetworks.php', '28.4', 0),
('bc36cf8798ff45f93c13f6330ff780b2', './admin/include_socnets.php', '28.4', 0),
('f1cef7253accd0b2f2b9965a0c7283f3', './admin/include_textarea.php', '28.4', 0),
('4b0c2706368570743add96976db05b07', './admin/include_trackers.php', '28.4', 0),
('220f3bd910cec2e105bc338b63b9577f', './admin/include_user.php', '28.4', 0),
('9fd43c7752889fece550f2d8115ddae1', './admin/include_video.php', '28.4', 0),
('6823dc50f304c8e011defd4a6b7c497c', './admin/include_wiki.php', '28.4', 0),
('5f4e250b51c772547f904e67a2d707a6', './admin/include_wikiatt.php', '28.4', 0),
('d957905f0425442c8b3dd736d8a36662', './admin/include_workspace.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './admin/index.php', '28.4', 0),
('49c9641b821d33414e73ab92f2dd3d02', './antibot.php', '28.4', 0),
('c63a8e45b81402942a502469097843af', './article_image.php', '28.4', 0),
('ee849d724218fbfb6e9a1ece6a69a470', './banner_click.php', '28.4', 0),
('36aec1cbc8e06231a3fd3e9678d8759c', './banner_image.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './bin/index.php', '28.4', 0),
('9e6db4022a2e1e144f22ec20cf5b952e', './categorize.php', '28.4', 0),
('0ddf271f1c74ceee455ff90b5f40192c', './categorize_list.php', '28.4', 0),
('a71d677283fd1a71aedee7be19d3e6a9', './check_composer_exists.php', '28.4', 0),
('fde29736983ed2cfd20c53be25f8d500', './comments.php', '28.4', 0),
('f2c27a23125ce8605342f2e43698d85b', './commxmlrpc.php', '28.4', 0),
('2f59caf7b5112353452d75c3ab719829', './console.php', '28.4', 0),
('927463e10b710e394f5212ba77c89f1d', './contribution.php', '28.4', 0),
('b53ecc52edf1dba64c3477b997333b90', './copyrights.php', '28.4', 0),
('70cb16162f865c80d9230183cb83351f', './cron.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './db/cert/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './db/config/index.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './db/index.php', '28.4', 0),
('20570c08e6373ededde60d1b0d40342a', './db/preconfiguration.php', '28.4', 0),
('86d6bb6e9bbec7e52746234e9ef3403c', './db/tiki-db.php', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './db/tiki-secdb_28.4_mysql.sql', '28.4', 0),
('8c931d4c51947be856d9da01965402ef', './db/tiki.sql', '28.4', 0),
('f80245cedb6e5ed6de7825559fcc1d97', './db/tiki_1.8to1.9.sql', '28.4', 0),
('67556440f34bfcffa2e4a848e441b8de', './db/tiki_1.9to2.0.sql', '28.4', 0),
('3daf2274785419d1c2deb4d5968e6b7f', './db/tiki_2.0to3.0.sql', '28.4', 0),
('f2556cbae3bf7dc6289acd8e816d7010', './db/tiki_convert_myisam_to_innodb.sql', '28.4', 0),
('98fc57f81014805c5c2a5db9ee5d3138', './db/tiki_fulltext_indexes.sql', '28.4', 0),
('bc963d873675f317030d37452a895b6f', './db/tiki_innodb.sql', '28.4', 0),
('9425e37fc31a591c10cf3dea5717bb43', './db/tiki_myisam.sql', '28.4', 0),
('5b212a7e2b9bfa98a2b5473d8772534f', './display_banner.php', '28.4', 0),
('4683085d195889a15754fc5557450898', './doc/devtools/20160715_trim50_tracker_permanent_names_for_mysqlfts_tiki.sql', '28.4', 0),
('09d9269151042eff6c6ae072db4c5f0a', './doc/devtools/check_bom_encoding.php', '28.4', 0),
('f89f9fac40a246da657f3a9455b1a762', './doc/devtools/check_composer_dist_urls.php', '28.4', 0),
('c16dff2df163da7e7f54c7bb9ecc3498', './doc/devtools/check_satis_validation.php', '28.4', 0),
('2f94061d1a63ff2ed5625f936ebb2108', './doc/devtools/check_schema_naming_convention.php', '28.4', 0),
('c49a8376a9019330968a40726a1d4476', './doc/devtools/check_schema_sql_drop.php', '28.4', 0),
('30c7db9e0dd551a40cc700c7729abf7b', './doc/devtools/check_schema_upgrade.php', '28.4', 0),
('a61021e5dce951ca7303d68e33e6660f', './doc/devtools/check_sql_engine.php', '28.4', 0),
('9fb99aa94c6cb27741eb127715145730', './doc/devtools/check_sql_engine_conversion.php', '28.4', 0),
('67fe063bc07630859af11e0bf4fda4ae', './doc/devtools/check_template_translation_standards.php', '28.4', 0),
('251dfc1db781cf4bc4da48089582e65a', './doc/devtools/check_tiki-new.php', '28.4', 0),
('d7d3972b836bf3bd0627ab5c1a777e93', './doc/devtools/check_tiki.php', '28.4', 0),
('2a3e3b58ecde206266d2c362e379cbdb', './doc/devtools/check_unix_ending_line.php', '28.4', 0),
('264b95dc0b6ac817fda1e2fe797d7731', './doc/devtools/clear_tracker_fast.sql', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/codesniffer/index.php', '28.4', 0),
('0b2156bbdfd036e48e87ddb7d9d9cdaa', './doc/devtools/codesniffer/standards/Tiki/Sniffs/Wrapper/DisallowSymfonyProcessSniff.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './doc/devtools/codesniffer/standards/Tiki/Sniffs/Wrapper/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './doc/devtools/codesniffer/standards/Tiki/Sniffs/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './doc/devtools/codesniffer/standards/Tiki/index.php', '28.4', 0),
('4b043053d4726628908a85fb53c75be7', './doc/devtools/codesniffer/standards/TikiIgnore/Helpers/IgnoreListTrait.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './doc/devtools/codesniffer/standards/TikiIgnore/Helpers/index.php', '28.4', 0),
('6b4dadc65e918e83413ac7025134152e', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/Classes/IgnoreClassDeclarationSniff.php', '28.4', 0),
('8bc10b2ca69ec1a5e802f8363dfa70ff', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/Classes/IgnoreValidClassNameSniff.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/Classes/index.php', '28.4', 0),
('0bcade6430687cbb194259826de2c927', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/Methods/IgnoreCamelCapsMethodNameSniff.php', '28.4', 0),
('8e1f8f3e1de4cf93ec1ea4df221f814d', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/Methods/IgnoreMethodDeclarationSniff.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/Methods/index.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './doc/devtools/codesniffer/standards/TikiIgnore/Sniffs/index.php', '28.4', 0),
('59eed3220cd17168161edb60c4edf6af', './doc/devtools/codesniffer/standards/TikiIgnore/generate_ignore_list.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './doc/devtools/codesniffer/standards/TikiIgnore/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './doc/devtools/codesniffer/standards/index.php', '28.4', 0),
('1796005542c0703025e2f2693410d944', './doc/devtools/commit_translations_by_lang.php', '28.4', 0),
('20d07c1793a933ad57bb82963e583d34', './doc/devtools/composer_http_mode.php', '28.4', 0),
('15ebcf36bee60f34acc697e8296596c8', './doc/devtools/composer_packages_in_use.php', '28.4', 0),
('21fa4b26c65536764e66ff8b3679e2df', './doc/devtools/convert_templates_prefs-2.0.php', '28.4', 0),
('ccfb12d852c69a2aecd5c2c7cce0e255', './doc/devtools/convert_tpl_ajax.php', '28.4', 0),
('4be61db8e0405455922dfb87b3c085da', './doc/devtools/convert_user_logins_from_email.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/dbdiff/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/etc/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './doc/devtools/etc/update/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/experimental/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './doc/devtools/experimental/unzip/index.php', '28.4', 0),
('3ecde8b7ad790d9fa8df191720be469a', './doc/devtools/experimental/unzip/unzipper.php', '28.4', 0),
('a7ec6c718daaaf31f259ae06947d616e', './doc/devtools/export_all_translation_to_file.php', '28.4', 0),
('0076bf83b593777464380b5d2d5fd15b', './doc/devtools/export_translations_to_file.php', '28.4', 0),
('e040134592ba58ded9e454a1376440e5', './doc/devtools/extract-img-db-to-fs.php', '28.4', 0),
('233b0361e298ded2517c92ea30c06a78', './doc/devtools/fgal_revamp_archive_fix.php', '28.4', 0),
('7e3fa3f7319f4c6eea27f569ec88ac30', './doc/devtools/fix-encoding.php', '28.4', 0),
('e50d3af7d5d1c4ecd5c37a63663f4234', './doc/devtools/get_translation_percentage.php', '28.4', 0),
('dc82fa2877aab2e5bd7fd8c3e901c184', './doc/devtools/ggg-trace.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/gitlab/index.php', '28.4', 0),
('d3ffb2200737e782afc8a71519e84529', './doc/devtools/gittools.php', '28.4', 0),
('29d9eab0cced72126f4b5166110c8b52', './doc/devtools/h5p_reset_all_data.sql', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './doc/devtools/index.php', '28.4', 0),
('857e41970d45355cfeb3b9f09cb00aec', './doc/devtools/invert_relations.php', '28.4', 0),
('cf5b5679abe92114d85857a5ab4692c9', './doc/devtools/ks_prefreport.php', '28.4', 0),
('c8ab811d380bfea8db68f9b60c57e4ec', './doc/devtools/make_db_local.sql', '28.4', 0),
('66ebc6d999b79d40e01333fbcccfd31b', './doc/devtools/mergelang.php', '28.4', 0),
('2595f16eebfb3fee05e24a3621db3f52', './doc/devtools/parse_tiki.php', '28.4', 0),
('3d30ea0e26d18eb39f0d186d9478d12d', './doc/devtools/prefreport.php', '28.4', 0),
('a2be3a260506242c821c0f7e09acf8fb', './doc/devtools/process_user_logins.php', '28.4', 0),
('ae395ce23d980f6bb40f878b6ebbb5a8', './doc/devtools/rebuild_search_index.php', '28.4', 0),
('edca0f5799c19a5cd42d361fed801f7b', './doc/devtools/remove_empty_wiki_attachment_filegals.php', '28.4', 0),
('efe525fb9e533f0019f3ccd86a670a27', './doc/devtools/rescue_wiki_changes_from_elastic.php', '28.4', 0),
('f6e5af1e29d94e94b70ae80df840f087', './doc/devtools/restorehelp.php', '28.4', 0),
('6d1c1cce89fc038d08c05f52b0065170', './doc/devtools/rewritesecdb.php', '28.4', 0),
('37e56272a7b44ceeb53063675a2cad10', './doc/devtools/satis_composer_packages_gitlab.php', '28.4', 0),
('ae905bcde00cc818de9f6040ec7901d0', './doc/devtools/satis_packages_cleanup.php', '28.4', 0),
('345b842bc4dc1591f5b095f036dc8db9', './doc/devtools/search_smarty_prefs-2.0.php', '28.4', 0),
('e4c3bc73c923450c1a717828c631b3c3', './doc/devtools/securitycheck.php', '28.4', 0),
('245684548efdace2047b792d05f14413', './doc/devtools/stripcomments.php', '28.4', 0),
('a4fb075329c19e05ff9be33064241407', './doc/devtools/sync.php', '28.4', 0),
('615170e37bd893748693dd1e70fdd7a3', './doc/devtools/tiki-create_md5.php', '28.4', 0),
('cb92ea97bda53db4fc3211ec7e9aa1a4', './doc/devtools/tiki-show_raw_links.php', '28.4', 0),
('f7a46967bf6f526743dce3117903dc4d', './doc/devtools/tiki-sync_ldap.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/tim/index.php', '28.4', 0),
('c614da53630181b416a40a3164cafd87', './doc/devtools/update_composer_lock.php', '28.4', 0),
('89b422322c99687c4bb6519dfda4ce16', './doc/devtools/update_english_strings.php', '28.4', 0),
('e658a9fc03c2745c0aedd534bafa5051', './doc/devtools/update_vendor_bundled.php', '28.4', 0),
('c95b1d56a06cafba4f73eb3f6daf0034', './doc/devtools/upto_18_drop_unused_tables.sql', '28.4', 0),
('214a3022a15d52cb769682000b45ae55', './doc/devtools/upto_4.1_delete_all_cetgory_perms.sql', '28.4', 0),
('d20bb5a10ce694a47c9ddc3a595615e7', './doc/devtools/upto_4.1_drop_unused_4.0_tables.sql', '28.4', 0),
('58572000763181f94d8101a459c40a14', './doc/devtools/upto_7_drop_unused_6.x_tables.sql', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './doc/devtools/var/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './doc/devtools/var/lock/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './doc/devtools/var/log/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './doc/devtools/var/log/update/index.php', '28.4', 0),
('ddd11563bb0a8007b0ed0e405e48728f', './doc/devtools/vcscommons.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './doc/index.php', '28.4', 0),
('3754aa4d7ed514e2e16ecbfeb4861edc', './eslint.config.js', '28.4', 0),
('63cacbece548b1b017b7345b7a4a63e7', './export-tracker_schema.php', '28.4', 0),
('d4d79098cb08480286806c73e2bc7110', './fgal_listing_conf.php', '28.4', 0),
('4c52fa7b08b2bb5dac55e831e01a70a0', './freetag_apply.php', '28.4', 0),
('86daea0217796526a0a7cfa8405b11a6', './freetag_list.php', '28.4', 0),
('94f980c451404890bdc15847dfd8ff11', './get_strings.php', '28.4', 0),
('8bb27355c9f5135f00e3fdc7a7e14729', './group_tracker_ajax.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/avatars/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/ckeditor/index.php', '28.4', 0),
('6f78447138863e22a666f7c0fb7f00d6', './img/flags/flagnames.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/flags/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/icons/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './img/icons/large/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './img/icons/mime/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './img/icons/mime/large/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './img/icons/sprite/index.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './img/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/poweredby/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/profiles/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/rating_smiles/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/tiki/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/tikihelp/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/webmail/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/wiki/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './img/wiki_up/index.php', '28.4', 0),
('093313ebe8d8e8e7c27731794e3079b4', './index.php', '28.4', 0),
('904a99bbba7560f0b2b03d797d4669bd', './installer/Installer.php', '28.4', 0),
('af989d2561ca4cc5c7759b99ab7a3370', './installer/InstallerDatabaseErrorHandler.php', '28.4', 0),
('4ce908d47224ade47d5af7cb12daeb48', './installer/Patch.php', '28.4', 0),
('9ede68ff6c3aada7a5544b61cb23d917', './installer/ProgressBar.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './installer/composer-patches/index.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './installer/index.php', '28.4', 0),
('ac6df34ea5837da81d2049e6ae87fc83', './installer/installlib.php', '28.4', 0),
('2bb856c10f0c98e0a6e8bc5be5bf7e6b', './installer/schema/00000000_schema_change_tiki.sql', '28.4', 0),
('006c768f38fb584f81a9577977988c40', './installer/schema/20080227_invite_tiki.sql', '28.4', 0),
('2d0b98a6482de21d7da2aa51becf84dc', './installer/schema/20080809_semlinks_tiki.sql', '28.4', 0),
('b7bc39833ff6498a7f2810f6ba477c7c', './installer/schema/20080827_bigfeaturetype_tiki.sql', '28.4', 0),
('2398106f99b68b3767b9719765489233', './installer/schema/20080829_pagealiasdata_tiki.sql', '28.4', 0),
('c4f4acac0dc6cbc2ebfb2f9c0be7e529', './installer/schema/20080829_pluginvalidation_tiki.sql', '28.4', 0),
('b3e9d8bf2668aefc4771dab17d0a24a2', './installer/schema/20080901_pluginvalidation_tiki.sql', '28.4', 0),
('ff79e407ffb5b00ff4d1e89a73c9704a', './installer/schema/20080902_trackerparsedesc_tiki.sql', '28.4', 0),
('7f8b965f930f78a8bddcef926ae47037', './installer/schema/20080905_feature_tip_tiki.sql', '28.4', 0),
('3f86cfb1dc64d6b19c54c28019102ca7', './installer/schema/20080916_webservice_registry_tiki.sql', '28.4', 0),
('32603465e3345c4fb4135313fd639fed', './installer/schema/20080922_calendar_customstatus_tiki.sql', '28.4', 0),
('b5ab53b9f57092bca8ea8592fa037f7b', './installer/schema/20080924_webmail_tiki.sql', '28.4', 0),
('a692f6c42ad0de8abb9d754288dec8d2', './installer/schema/20080926_bannerindex_tiki.sql', '28.4', 0),
('bc29e3e80740fc29e33d27defbcbc97f', './installer/schema/20081004_mindmap_menu_tiki.sql', '28.4', 0),
('536631185aad52c71ef92899b5c5b62f', './installer/schema/20081006_comments_moderation_tiki.sql', '28.4', 0),
('97837099f4b69a93e84f567d3c56d257', './installer/schema/20081008_bit_flags_nullable_tiki.sql', '28.4', 0),
('e8ce3139d3e2b292ee37e8ce885e1705', './installer/schema/20081010_filter_perms_tiki.sql', '28.4', 0),
('2e63a1b5e05aab6502e083ce82c0dc79', './installer/schema/20081014_trust_input_perm_tiki.sql', '28.4', 0),
('a360c4d3bf674a0701ab7f4280f5c3a8', './installer/schema/20081018_filter_perms_tiki.sql', '28.4', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20081019_score_tiki.sql', '28.4', 0),
('9936db192fac5ee273acfe31dec15cf9', './installer/schema/20081022_application_menu_tiki.sql', '28.4', 0),
('9a97cd6ca26d30c0b9d05c4aa537084d', './installer/schema/20081024_fulltext_file_tiki.sql', '28.4', 0),
('8d701d07641ef5d3f7b69d7e6d5a33a9', './installer/schema/20081027_calendar_tiki.sql', '28.4', 0),
('3d53e3b67422f25ff924fbe763538155', './installer/schema/20081027_file_galleries_tiki.sql', '28.4', 0),
('2d1a37d08e6f39946a6dc2e1cfb0737a', './installer/schema/20081027_groupalert_tiki.sql', '28.4', 0),
('58df86055cb0233d2b7d32defd83828b', './installer/schema/20081027_surveys_tiki.sql', '28.4', 0),
('9ec9d1e68f44edbf587713bcd1e456c7', './installer/schema/20081027_trackers_tiki.sql', '28.4', 0),
('b716c67361eacf1a987e1bb40f6316ee', './installer/schema/20081027_wysiwyg_history_tiki.sql', '28.4', 0),
('dca26112be92a3177d122e04f6fa959a', './installer/schema/20081029_tracker_index_tiki.sql', '28.4', 0),
('00c60bf6063b7c4d89e0c9ead79abf75', './installer/schema/20081102_application_menu_structures_tiki.sql', '28.4', 0),
('1ef6d37f65c50ed067481f95baf4fd09', './installer/schema/20081105_calendar_items_allday_tiki.sql', '28.4', 0),
('27788e1efb7a90034e8950fd8f4354bd', './installer/schema/20081107_menu42_tiki.sql', '28.4', 0),
('d4c56d850365c4b6acf6ad25b90d4c73', './installer/schema/20081112_tiki_p_tracker_view_comments_tiki.sql', '28.4', 0),
('43d6558ec8576961ad0fa57eea6ec549', './installer/schema/20081114_tiki_banner_tiki.sql', '28.4', 0),
('dafa2c29eca3f81a8cb59ee6208de018', './installer/schema/20081119_tiki_p_export_tracker_tiki.sql', '28.4', 0),
('910db98348db50f457bcd220e6b94d96', './installer/schema/20081120_showCategories_tiki.sql', '28.4', 0),
('b96d9c4717c53493180e1b3bba0448ac', './installer/schema/20081120_tiki_poll_structures_update_tiki.sql', '28.4', 0),
('89c22600772bbf20691a784f5abafb0b', './installer/schema/20081125_tiki_tracker_types_tiki.sql', '28.4', 0),
('5982d5bdb4eebc0d9c987c202318e8e6', './installer/schema/20081127_calendar_recurrence_tiki.sql', '28.4', 0),
('87e87aca605d69c54c0144768facb548', './installer/schema/20081130_tiki_users_permission_tiki.sql', '28.4', 0),
('f0f9c1466b9330c3a4fa41680a9a63e4', './installer/schema/20081211_newsletter_files_tiki.sql', '28.4', 0),
('fd50074486eece74754eff0e24fa8cc7', './installer/schema/20081211_score_tiki.sql', '28.4', 0),
('419cfa4072a49c9712f047c6d00019e7', './installer/schema/20081212_tiki_p_view_backlinks_tiki.sql', '28.4', 0),
('5671f4746f9ab96caf1673eaabfc8134', './installer/schema/20081214_webservice_post_tiki.sql', '28.4', 0),
('fa760fbadd8b8611db93629587f4c856', './installer/schema/20090106_group_watch_tiki.sql', '28.4', 0),
('91eaa83db90f06582180cd14355122b4', './installer/schema/20090120_sefurl_rules_tiki.sql', '28.4', 0),
('c26a0ce1737db912d15bf60e52b22d1d', './installer/schema/20090129_callendar_search_tiki.sql', '28.4', 0),
('78e3b5aa3c867fa9b6bc5766c70ee9eb', './installer/schema/20090203_null_tiki.sql', '28.4', 0),
('c635a46b0df03ad6549eb3aa555ef0c3', './installer/schema/20090205_forum_and_comments_locking_tiki.sql', '28.4', 0),
('ae4896884f1506b3aef47977d105a445', './installer/schema/20090205_menucase_tiki.sql', '28.4', 0),
('7767c3b7b399c9c01a2687a136c90c6b', './installer/schema/20090205_menus_items_icons_tiki.sql', '28.4', 0),
('500233565a264f3160e0d76034b5bbb2', './installer/schema/20090206_content_tpl_menu_tiki.sql', '28.4', 0),
('70324c0efc3a3fa7d82966f01050c621', './installer/schema/20090206_poll_tiki.sql', '28.4', 0),
('526e7e62f79d0a3a303661f107ab8c50', './installer/schema/20090211_mailnotification_tiki.sql', '28.4', 0),
('7803cbadaa3504e48ab96d2073b85a9f', './installer/schema/20090212_forum_tiki.sql', '28.4', 0),
('b9996cda2a892f43f736e15331321b44', './installer/schema/20090220_admin_section_tiki.sql', '28.4', 0),
('e2e57d5445fccb30772d339a4b6b3e4a', './installer/schema/20090226_admin_menu_tiki.sql', '28.4', 0),
('270f4a015a19424cef2cc35021be8572', './installer/schema/20090301_browsertitle_tiki.sql', '28.4', 0),
('e0d61c3cc6c9b77a755c891d85cb177c', './installer/schema/20090304_tiki_p_view_backlink_without_s_tiki.sql', '28.4', 0),
('f7bd45395c2ff0fd2798e35562df924a', './installer/schema/20090306_menu_perms_tiki.sql', '28.4', 0),
('06fd6cb8f5d2b047ea709ad02c625170', './installer/schema/20090306_text_for_menu_options_tiki.sql', '28.4', 0),
('ce4a78cdeb27a383ce8810ee4fa0d964', './installer/schema/20090310_application_menu_tiki.sql', '28.4', 0),
('cbbffca4f72b5728da74826e7837f286', './installer/schema/20090310_feature_search_show_object_filter_tiki.sql', '28.4', 0),
('667061194dd0bf84dfb4d1dcabeea9b1', './installer/schema/20090311_remove_mod_menu_application_menu_tiki.sql', '28.4', 0),
('956e0e696703ab32441f8ee6f8a6ab77', './installer/schema/20090316_index_tiki.sql', '28.4', 0),
('cbe4979f2306bafb7cbd672dd1cf01d8', './installer/schema/20090323_maxUserImpressions_banners_tiki.sql', '28.4', 0),
('54b66f96391a42d5708064e4ef4c8f97', './installer/schema/20090330_quicktags_renames_tiki.sql', '28.4', 0),
('6b2b361cdf76da968df937fa7376a181', './installer/schema/20090401_newsletters_included_tiki.sql', '28.4', 0),
('39598df227aa9dc8bdadd488df7bbee8', './installer/schema/20090401_replace_shoutjax_with_shoutbox_tiki.sql', '28.4', 0),
('bef61fb68a07da74003ff4afe066c802', './installer/schema/20090401_replace_switch_lang2_with_switch_lang_tiki.sql', '28.4', 0),
('e42b7cf769782d2fb366f09a4ecfeb72', './installer/schema/20090416_plugin_security_tiki.php', '28.4', 0),
('5998f3e1edb3d82c17cccde4533fcd30', './installer/schema/20090416_plugin_security_tiki.sql', '28.4', 0),
('c90f5078217322adfb556675fa934a82', './installer/schema/20090416_quicktags_kil_email_tiki.sql', '28.4', 0),
('93c12b32158f54c0633bf753269b6494', './installer/schema/20090416_quicktags_plugin_helpers_tiki.sql', '28.4', 0),
('bf02c6a99bf51c768fa4cd2078bb985b', './installer/schema/20090427_filegal_optionalize_tiki.sql', '28.4', 0),
('55df14def9249a255c63a08a413e8d52', './installer/schema/20090429_groupId_tiki.sql', '28.4', 0),
('47b2e95f6c75fc43dd02ec7cb3d3ce7c', './installer/schema/20090513_calendar_priority_tiki.sql', '28.4', 0),
('d9a996de940eb309bf773b52303d825f', './installer/schema/20090513_swffix_tiki.sql', '28.4', 0),
('32809522a429ac7b66f2f96d06d45a8f', './installer/schema/20090513_wiki_similar_permission_tiki.sql', '28.4', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20090515_score_tiki.sql', '28.4', 0),
('22a74480ae1b46cad78ec1df893ccea0', './installer/schema/20090602_webmail_protocols_tiki.sql', '28.4', 0),
('442aa44b3f6f263b01edc9228dcad2ce', './installer/schema/20090605_tiki_p_modify_tracker_items_pending_closed_tiki.sql', '28.4', 0),
('337e0cfb80b1d8dc0a41385b9d3ac655', './installer/schema/20090617_add_new_table_for_reports_tiki.sql', '28.4', 0),
('9f92fa8fa2b8160595b2ac1381fae55a', './installer/schema/20090623_actionlog_view_article_tiki.sql', '28.4', 0),
('cb7026c21dbab9aeec235fff9f1a06b6', './installer/schema/20090626_change_pear_auth_preferences_to_ldap_tiki.sql', '28.4', 0),
('420b72a12e9646cae3b236144528f393', './installer/schema/20090707_tiki_p_delete_account_tiki.sql', '28.4', 0),
('ba933dc23124eb6cc7252fa0fceaa90c', './installer/schema/20090713_tiki_importer_permission_and_menu_entry_tiki.sql', '28.4', 0),
('62dd644b6e39e612d19f540e44282414', './installer/schema/20090715_sefurl_for_filegalleries_tiki.sql', '28.4', 0),
('531d11e98da6639283564c0e9ed17077', './installer/schema/20090720_perspectives_tiki.sql', '28.4', 0),
('e9b19e102e3eedad9ef8e8f7d032792c', './installer/schema/20090721_webmail_ext_public_tiki.sql', '28.4', 0),
('8139d5f5e562aafc301fe9e64a721c02', './installer/schema/20090727_category_permissions_tiki.sql', '28.4', 0),
('52d147c0e3a28323ddeae7728a6cd2d9', './installer/schema/20090727_user_votings_index_tiki.sql', '28.4', 0),
('628613b2da84a05f443544eaa6b99424', './installer/schema/20090730_p_list_newsletters_tiki.sql', '28.4', 0),
('b92b91a727e9bfb7a7fbe4ad11953a33', './installer/schema/20090803_perspective_permission_tiki.sql', '28.4', 0),
('82f33550024286cdc27d2915604e9158', './installer/schema/20090804_kaltura_permissions_tiki.sql', '28.4', 0),
('d5dc1e57a3396aef995cf2a910469897', './installer/schema/20090804_menu_search_tiki.sql', '28.4', 0),
('f72547e2cb4c194b8fa32d3bec3c9018', './installer/schema/20090805_kill_newsreader_tiki.sql', '28.4', 0),
('cc5c96b09f7b9706036f9bf9b9b73fac', './installer/schema/20090805_remove_drawings_prefs_etc_tiki.sql', '28.4', 0),
('c3f351efc86fb06230ecb11592ed2e9a', './installer/schema/20090805_remove_games_tiki.sql', '28.4', 0),
('cb13f0c90d7565566ffddedd17449dc0', './installer/schema/20090806_group_permissions_tiki.sql', '28.4', 0),
('4fffdf190d26d20a72f384036f924cbf', './installer/schema/20090806_menu_list_trackers_tiki.sql', '28.4', 0),
('0a52e5782358430e557664b7d5aa5c1c', './installer/schema/20090806_perms_featurechecks_tiki.sql', '28.4', 0),
('ee38952775b551eacf1bb72da93c5acb', './installer/schema/20090806_remove_charts_tiki.sql', '28.4', 0),
('8b5d955462daed16192cd422fc514590', './installer/schema/20090806_remove_latin_collations_tiki.sql', '28.4', 0),
('e1e6b59348c4e6ceb064d2af676b3620', './installer/schema/20090806_strasa_option_rename_tiki.sql', '28.4', 0),
('167fcb355e27d0813aa3c7f2ad1bb2d7', './installer/schema/20090807_transitions_tiki.sql', '28.4', 0),
('6adbc7a739c0fd262f6600bfc9630510', './installer/schema/20090808_add_wiki_minor_edits_tiki.sql', '28.4', 0),
('0067c2b32ca47ce7b42ea5d45f64cdf4', './installer/schema/20090809_marc_needs_more_space_tiki.sql', '28.4', 0),
('e0a7048d37a6f4ae95fe246a70935e6f', './installer/schema/20090811_filegals_container_tiki.sql', '28.4', 0),
('90cbc20466a1dcd55a42f4532099a4b3', './installer/schema/20090811_kaltura_editor_pref_tiki.sql', '28.4', 0),
('0c64b4b6661d1601b4b1d847b1e6810c', './installer/schema/20090811_quizzes_tiki.sql', '28.4', 0),
('b97dac6447ab14c1278a80bfef18d0d6', './installer/schema/20090811_rename_quicktags_to_toolbars_tiki.sql', '28.4', 0),
('4795abe4f54b97fe2fe1e851d1665031', './installer/schema/20090823_kaltura_menu_options_tiki.sql', '28.4', 0),
('4c19a550fa670b8680b4536491de9f58', './installer/schema/20090826_group_expiration_tiki.sql', '28.4', 0),
('c456caa0febc6f77a02d7202820b6878', './installer/schema/20090904_wysiwyg_newsletters_tiki.sql', '28.4', 0),
('055a4c9f0da1ea66388257c95851fd37', './installer/schema/20090911_tracker_item_change_user_tiki.sql', '28.4', 0),
('647c88b4faa510131fd775b6fd494129', './installer/schema/20090912_change_feature_name_for_lesser_magic_tiki.sql', '28.4', 0),
('97dea83392a7fde1ab54f1ce3df0f26a', './installer/schema/20090913_plugin_security_addedby_tiki.sql', '28.4', 0),
('fd23b4fc2cb7b31f09fcd533ec21f264', './installer/schema/20090915_change_perms_for_browse_cats_tiki.sql', '28.4', 0),
('1f07cce9c277e528d55fb4554f28cea1', './installer/schema/20090921_logo_tiki.sql', '28.4', 0),
('b1227c9bd58285d50270e5bd299cdc45', './installer/schema/20090923_mod_change_category_defaults_tiki.php', '28.4', 0),
('f580a5bdef3c93176c9fcc963d6f7ee5', './installer/schema/20090925_online_logged_users_modules_merge_tiki.sql', '28.4', 0),
('b74f2d4a9ac9b184868809defef17b9e', './installer/schema/20090927_top_images_modules_merge_tiki.sql', '28.4', 0),
('d581271bb2b939b62a9c7d3468d71363', './installer/schema/20090928_galaxia_leftovers_tiki.sql', '28.4', 0),
('a9b31268ede9a9d19bad4b3e9a560858', './installer/schema/20090928_last_images_modules_merge_tiki.sql', '28.4', 0),
('47512729ed5702c29ebf674158b7dd22', './installer/schema/20090928_transition_guards_text_tiki.sql', '28.4', 0),
('e7068eb09d69d5607585dca6be7cf429', './installer/schema/20091004_last_tracker_items_modules_merge_tiki.php', '28.4', 0),
('566e10ed8016fd2ae2e77017a6af5bc5', './installer/schema/20091007_update_database_structure_tiki.sql', '28.4', 0),
('44c61ac918cc1385b7640393c138efff', './installer/schema/20091008_reg_group_includes_anon_tiki.sql', '28.4', 0),
('1a6e2252aefc8b4549eea766c4681418', './installer/schema/20091011_serurl_dl_order_tiki.sql', '28.4', 0),
('2e691f9f536276faf13b3e7708f77863', './installer/schema/20091013_fix_perms_tiki.sql', '28.4', 0),
('c7ca3defd20741232a8c11b89d2250ab', './installer/schema/20091015_application_menu_admin_renames_tiki.sql', '28.4', 0),
('273bebc06180dcf99c0fbb6f57f32cae', './installer/schema/20091016_categorization_tracker_item_tiki.sql', '28.4', 0),
('37319b555886403020f10c007c1adf83', './installer/schema/20091019_article_by_rating_modules_merge_tiki.php', '28.4', 0),
('3574b2e7d48f0e9a48e5e806300e23e7', './installer/schema/20091019_last_articles_modules_merge_tiki.php', '28.4', 0),
('f8cef1ce28764cf186963efb6e754b6d', './installer/schema/20091019_users_perms_types_tidying_tiki.sql', '28.4', 0),
('cea39d8b633ccf21c530eb38dc8d5d4d', './installer/schema/20091020_bigger_user_prefs_tiki.sql', '28.4', 0),
('97f2e29237a5f2f66a8d68ef1d519aa9', './installer/schema/20091020_faq_created_tiki.sql', '28.4', 0),
('d64f44fb2fc4a66091c7f084278da4f0', './installer/schema/20091020_kaltura_tiki.sql', '28.4', 0),
('849edab4e7d7fdec986089032840ef2c', './installer/schema/20091020_remove_charts_tiki.sql', '28.4', 0),
('87b5cd3a5894c73bc20c2351b549d774', './installer/schema/20091020_sefurl_trackeritem_tiki.sql', '28.4', 0),
('89456db508a7a0d97200907f83c143b0', './installer/schema/20091021_moz_pagelist_tiki.sql', '28.4', 0),
('de6aa476f72445aa4dae312681ce9ebb', './installer/schema/20091023_bookmarks_name_lengthen_tiki.sql', '28.4', 0),
('4ebf9ad2bf9cc6d3e0c6046a38cd3096', './installer/schema/20091023_nul_categ_tiki.sql', '28.4', 0),
('a149de4e5b9d725180961926b6732bb9', './installer/schema/20091023_report_tiki.sql', '28.4', 0),
('345569753d67064166061deda3c47e34', './installer/schema/20091027_multiple_session_handler_tiki.sql', '28.4', 0),
('b3db4a3b28d2e6ca3751e7fdfd22a7a9', './installer/schema/20091028_quota_tiki.sql', '28.4', 0),
('a278b9df0b6b039001b9219863cb7625', './installer/schema/20091030_wiki_watch_tiki.sql', '28.4', 0),
('472da3e91ca5c57e180f471e82e69843', './installer/schema/20091103_upgrade_categperm_tiki.php', '28.4', 0),
('bbeb6795a1202644d61d82a6b3ab1e25', './installer/schema/20091105_auth_tokens_tiki.sql', '28.4', 0),
('f1570b8fd47a0dca223a15382da22709', './installer/schema/20091111_fgal_size_tiki.sql', '28.4', 0),
('7bd8ac55be14e25c7120a26f23eff436', './installer/schema/20091112_rename_mnu_application_menu_tiki.sql', '28.4', 0),
('712125292ff84ad268db796e12d0d860', './installer/schema/20091112_template_type_tiki.sql', '28.4', 0),
('7b18ad1124c4793f68eee26efecc6c15', './installer/schema/20091113_old_categ_perm_tiki.sql', '28.4', 0),
('cbeebd65f32c65d2171b5afe3cb0bb88', './installer/schema/20091118_sefurl_tiki.sql', '28.4', 0),
('893c7f6e4e519c67adc07265daffd31d', './installer/schema/20091120_poll_lookup_index_tiki.sql', '28.4', 0),
('df8cef1f416acca82b52e30e6094aadd', './installer/schema/20091120_username_pattern_tiki.sql', '28.4', 0),
('3e981f300423d52b094778c83e513245', './installer/schema/20091123_dns_permission_tiki.sql', '28.4', 0),
('55a8ac66a2d8b98982bb03e544927f18', './installer/schema/20091123_metrics_tiki.sql', '28.4', 0),
('03bc81d782b5a380a01ccace7badb14e', './installer/schema/20091123_upgrade_categperm_2_tiki.php', '28.4', 0),
('469e21d2779263943cd4c45f5f8db526', './installer/schema/20091124_fgal_backlink_tiki.sql', '28.4', 0),
('5b47492ea791031cf119ac3daf791f97', './installer/schema/20091124_metrics_dsn_tiki.sql', '28.4', 0),
('c070d97d1927459c781cd75887f40d11', './installer/schema/20091125_wiki_comments_per_page_tiki.sql', '28.4', 0),
('94d90cb820a65bdb9a64cb0d2396a643', './installer/schema/20091126_dynamic_variables_i18n_tiki.sql', '28.4', 0),
('5cb9af495c32baaab1a4c975d8cceaef', './installer/schema/20091204_filegal_wiki_syntax_tiki.sql', '28.4', 0),
('a72f40dc524ffce5390afc15923cb78f', './installer/schema/20091204_tiki_p_view_newsletter_tiki.sql', '28.4', 0),
('bb96171d83b521a6699b6cb1630c178e', './installer/schema/20091208_backlink_perms_tiki.sql', '28.4', 0),
('8e295076a1387fd3d68c8a0e23066c7a', './installer/schema/20091209_rss_feeds_name_tiki.sql', '28.4', 0),
('a5044acc14e9a7efe50944b93917d7b2', './installer/schema/20091210_charset_tiki.sql', '28.4', 0),
('d617149349d294764b6820ed8d412244', './installer/schema/20091210_dcs_type_tiki.sql', '28.4', 0),
('31ab1668ffeb47e2fdf7c5b80d5eacfd', './installer/schema/20091214_perspective_management_tiki.php', '28.4', 0),
('c275deb83663a95e4265677d33bda5de', './installer/schema/20091214_perspective_management_tiki.sql', '28.4', 0),
('ec2eeddd35627137e13ae7eef8c18f4c', './installer/schema/20091216_show_backlinks_tiki.sql', '28.4', 0),
('bff553fae8d722d9c239714e9e75f369', './installer/schema/20091228_page_keywords_tiki.sql', '28.4', 0),
('5b547103c6c3720dfd46515f3dc4b9cf', './installer/schema/20100101_search_modules_merge_tiki.sql', '28.4', 0),
('2e4b473f1a5ab5dbbf7933ddbb7e2cf4', './installer/schema/20100101_search_wiki_page_modules_merge_tiki.sql', '28.4', 0),
('6b8a6f903619170fc06b5e21acb8a88d', './installer/schema/20100104_tiki_p_tracker_revote_ratings_tiki.sql', '28.4', 0),
('3cbd0d19bfef3b685a304e96902656d8', './installer/schema/20100106_forum_att_list_nb_tiki.sql', '28.4', 0),
('5615afe6adc083d68e9b55539cd2fb57', './installer/schema/20100107_payment_tiki.sql', '28.4', 0),
('0e531e6cd9f6bc248c9e940afcdce1c9', './installer/schema/20100113_forum_display_tiki.sql', '28.4', 0),
('3e8c5924e3563c9f15474662ed5165c5', './installer/schema/20100114_tiki_actionlog_merge_tiki.sql', '28.4', 0),
('8b23e2a3a3dc1aa2bd6be6650005e50e', './installer/schema/20100115_admin_modules_menu_tiki.sql', '28.4', 0),
('69a98c55dfdb0639be58af44be275639', './installer/schema/20100115_tiki_p_admin_modules_tiki.sql', '28.4', 0),
('7435683dd08e061a90055de63c6ca777', './installer/schema/20100115_translations_in_progress_tiki.sql', '28.4', 0),
('42a4ae39d6d4045d0e4d96fd785fd620', './installer/schema/20100117_old_doc_tw_o_url_tiki.sql', '28.4', 0),
('a7311875283acb4a98ea9210ff9588ba', './installer/schema/20100118_blog_use_author_tiki.sql', '28.4', 0),
('79e3b88f76c6ced0918f76d5b6665578', './installer/schema/20100118_forum_display_tiki.sql', '28.4', 0),
('2ea1308ff02955c7b6656076301299ab', './installer/schema/20100126_file_lastDownload_tiki.sql', '28.4', 0),
('68f8d2e78cc73e8562839970ba92a70d', './installer/schema/20100128_tiki_p_blog_view_ref_tiki.sql', '28.4', 0),
('6f2fff9200d779aabaf21e7144b5ecdd', './installer/schema/20100129_clean_up_tiki.sql', '28.4', 0),
('7413da3b3b575abed3464e09b768a080', './installer/schema/20100129_events_kil_tiki.sql', '28.4', 0),
('c66c9f9a5d2d14ae38ac664738d0836d', './installer/schema/20100203_payment_detail_tiki.sql', '28.4', 0),
('888c53dd6f29cd376fde45828fc8d69d', './installer/schema/20100205_tiki_p_wiki_view_ref_tiki.sql', '28.4', 0),
('05f7e4fb2ba9012af7b1d9d262023e0f', './installer/schema/20100207_repair_file_galleries_tiki.php', '28.4', 0),
('2d73cd82c5b1ef6b75e2661cd5ec7948', './installer/schema/20100211_rss_items_tiki.sql', '28.4', 0),
('350aff4b5e0a30d274134424b0788327', './installer/schema/20100211_tiki_perms_menu_item_tiki.sql', '28.4', 0),
('3fcab51527f14091b72a61862d375c45', './installer/schema/20100211_tiki_sheet_add_parseValues_tiki.sql', '28.4', 0),
('f2596badf24baf56d10e2c6789213960', './installer/schema/20100212_rss_automation_tiki.sql', '28.4', 0),
('b8760600ba1e21e712f362e63befac45', './installer/schema/20100213_group_inclusion_key_tiki.sql', '28.4', 0),
('c517e0b264751804c7ff41e37f1a413c', './installer/schema/20100214_workspaces_remove_menu_items_tiki.sql', '28.4', 0),
('50673717c01a153edf7b182b1c2be24e', './installer/schema/20100215_create_tiki_user_login_cookies_tiki.sql', '28.4', 0),
('54cc4bcc3ffa4453554c3ce8b06fecc3', './installer/schema/20100215_rating_permissions_tiki.sql', '28.4', 0),
('26aace3abeb9deef32cdc5480e1ddc22', './installer/schema/20100216_attributes_tiki.sql', '28.4', 0),
('36037bd886a0e5868c5fe59c337f6c2e', './installer/schema/20100216_kil_moz_screencast_tiki.sql', '28.4', 0),
('8a232ebfe1aff7c6a9cc6ad47b88a4cf', './installer/schema/20100216_rename_tikisheet_tiki.sql', '28.4', 0),
('89235a225a0a4d3128faf72bc4730993', './installer/schema/20100217_rating_config_tiki.sql', '28.4', 0),
('62a29f5266842c3aafc5e77ca31a4b3f', './installer/schema/20100218_auth_token_reuse_tiki.sql', '28.4', 0),
('0dcee212645ce8000ad216d6bf812c2e', './installer/schema/20100222_add_webmail_fromEmail_field_tiki.sql', '28.4', 0),
('5cf4ae8252efbc6fc53560fb1855fbd6', './installer/schema/20100222_sheet_toolbar_default_tiki.sql', '28.4', 0),
('01714f7d35dd064f2ea3075ea8046096', './installer/schema/20100223_blog_always_owner_tiki.sql', '28.4', 0),
('d13f58b231384ea0a721ec5f5bd4c3bf', './installer/schema/20100224_object_relations_tiki.sql', '28.4', 0),
('9a60dd3d2db1b9e7a0187a818ef08d7a', './installer/schema/20100226_menu_template_feature_check_tiki.sql', '28.4', 0),
('ce7a80dc86bcabf4372e9745cce0e440', './installer/schema/20100226_tracker_dump_perm_tiki.sql', '28.4', 0),
('a1191e4c09d52e1886507e62e6573994', './installer/schema/20100302_filegal_images_max_sizes_tiki.sql', '28.4', 0),
('bf751d0e1c3ad816fbdd7e612c1880db', './installer/schema/20100308_file_delete_after_tiki.sql', '28.4', 0),
('902b64fe934469ed98341678a7840245', './installer/schema/20100309_add_sheet_parent_tiki.sql', '28.4', 0),
('6164442730abf0ff4849170a5c90dbda', './installer/schema/20100312_emailPattern_tiki.sql', '28.4', 0),
('3c97d38fb32ce744185b6ff04d58fa0d', './installer/schema/20100324_newsletters_clippings_tiki.sql', '28.4', 0),
('8d0e67468c13d44ce90601a230c7fd68', './installer/schema/20100409_bigger_module_params_tiki.sql', '28.4', 0),
('4177492c2f4ee3bfbe97c90f38ae0626', './installer/schema/20100414_actionlog_pref_tiki.sql', '28.4', 0),
('f2e50c371c67658571f3290165beff43', './installer/schema/20100414_actionlog_system_tiki.sql', '28.4', 0),
('bbaebffa62af9ccfc56bcece0793b7e0', './installer/schema/20100419_bigbluebutton_tiki.sql', '28.4', 0),
('f4afdf505b5739a5c0686e45a8db05e7', './installer/schema/20100422_tracker_log_tiki.sql', '28.4', 0),
('046e3a3749bdd49c23cbb1336f0cb588', './installer/schema/20100429_newsletter_pages_tiki.sql', '28.4', 0),
('e920515a35ea4da9148ece7c17a82d39', './installer/schema/20100507_flash_banner_tiki.php', '28.4', 0),
('1b5f530a959dd6c18375fdacf258c03e', './installer/schema/20100519_actionlog_tiki.sql', '28.4', 0),
('f7f3a83c028f4a1afbc5e4ad922386fb', './installer/schema/20100525_tracker_validation_message_tiki.sql', '28.4', 0),
('50075186c65a27d7a0eee7962f0f0862', './installer/schema/20100525_tracker_validation_tiki.sql', '28.4', 0),
('c85d90ed2ab759856b41dc3d705f7a96', './installer/schema/20100611_rss_items_url_tiki.sql', '28.4', 0),
('4cb7c699ac79b750404f413e18841472', './installer/schema/20100617_sefurl_user_info_tiki.sql', '28.4', 0),
('7a887d3c80359db3c7baf7a18b4a51d0', './installer/schema/20100618_calendar_participation_tiki.sql', '28.4', 0),
('2c666df90eaaa04fb2ee6d1928b38814', './installer/schema/20100621_pageprefixaliasdata_tiki.sql', '28.4', 0),
('838bb67100b2ef14a12db5d8f026fe24', './installer/schema/20100622_pageprefixtrackeritemid_tiki.sql', '28.4', 0),
('876e1a69de88224bccd3877c01e60add', './installer/schema/20100623_semantic_to_relation_tiki.php', '28.4', 0),
('4673960aa9da0b18682403cb6be37d5a', './installer/schema/20100623_semantic_to_relation_tiki.sql', '28.4', 0),
('690f54a7ae99b145b7fdda6c8df6d1b8', './installer/schema/20100624_banning_index_tiki.sql', '28.4', 0),
('49f703eb7f92a2ecf5d8cd7e127dd02e', './installer/schema/20100628_payment_user_tiki.sql', '28.4', 0),
('687f64c286450f0fe0de1cfbf05c3d0e', './installer/schema/20100629_remove_feature_blog_comments_tiki.sql', '28.4', 0),
('7b0af15477349384dbd3b1010397946e', './installer/schema/20100702_discount_tiki.sql', '28.4', 0),
('1cd43cc0c8d523dc0e9d7dda5e6fd25f', './installer/schema/20100712_remove_unsupported_feed_formats_tiki.sql', '28.4', 0),
('19adc11a5cc9a329cedc5f84f4f90e61', './installer/schema/20100713_rename_feed_prefs_tiki.sql', '28.4', 0),
('91725fe31a54b7681540807302be4a48', './installer/schema/20100714_batch_transition_tiki.sql', '28.4', 0),
('e62cac7f6a4bc314978ee2ac087d67a7', './installer/schema/20100716_user_selector_pref_rename_tiki.sql', '28.4', 0),
('a0719690681cf54c6ecdddeda600dc28', './installer/schema/20100720_tiki_p_view_page_contribution_tiki.sql', '28.4', 0),
('7fbf99c2db7f32abaa339668cbcd06d3', './installer/schema/20100721_batch_transition_rollback_tiki.sql', '28.4', 0),
('45d5a01c4ad08d3c331d77c3e1dd19c0', './installer/schema/20100721_todo_tiki.sql', '28.4', 0),
('57eb1c692598aebcc6f6c62be8267419', './installer/schema/20100721_todonotif_tiki.sql', '28.4', 0),
('5b12e1bc1238983e0fd1ced13c876eb0', './installer/schema/20100727_tiki_p_promote_page_tiki.sql', '28.4', 0),
('c3049a9ad85d934d80509f1bce54ed56', './installer/schema/20100730_list_image_article_tiki.sql', '28.4', 0),
('5b0a22957d84f831f300f0040aeeb6a0', './installer/schema/20100802_tiki_p_share_tiki.sql', '28.4', 0),
('8e02a6d8ad2e1cc0c9e2bf6f9ee8ed28', './installer/schema/20100802_url_shortener_tiki.sql', '28.4', 0),
('44806754ed381ae3a982f7837e49bccd', './installer/schema/20100804_remove_tiki_languages_tiki.sql', '28.4', 0),
('d25e77ce8d4571079e175bc6c47396f2', './installer/schema/20100806_blog_posts_header_tiki.sql', '28.4', 0),
('686669d28d921b67f74e73c939c72a6c', './installer/schema/20100807_alter_tiki_translate_fields_to_text_tiki.sql', '28.4', 0),
('7ef9c8bb7582170a536f47932aee91d4', './installer/schema/20100810_title_comments_upgrade_tiki.sql', '28.4', 0),
('8df0894c777a22e016d7c86adeb5c21a', './installer/schema/20100812_blog_control_max_related_content_tiki.sql', '28.4', 0),
('3ea3be26f5d40cf2edd81abd799ba344', './installer/schema/20100812_blog_show_related_content_tiki.sql', '28.4', 0),
('31c1a0ef9f413ab92ceb6bfe4523fbe3', './installer/schema/20100817_add_email_and_website_fields_to_comments_tiki.sql', '28.4', 0),
('6ea024455e832c9103a199533dbe6568', './installer/schema/20100817_credits_tiki.sql', '28.4', 0),
('5d2cc4aa05385cfc2eba8ac701ae148e', './installer/schema/20100817_rename_preference_wiki_comments_notitle_tiki.sql', '28.4', 0),
('4a3d0c92c69fb3dcc0b9770d62d27c71', './installer/schema/20100818_watch_tiki.sql', '28.4', 0),
('2759ff42a931fce14c367e87ae4c0331', './installer/schema/20100820_blog_posts_wysiwyg_tiki.sql', '28.4', 0),
('31bcc44f8cb269593a399ee00313995e', './installer/schema/20100820_feed_fields_text_and_desc_are_not_empty_tiki.sql', '28.4', 0),
('8d0992f78c263a025ccbd605f6fb7262', './installer/schema/20100824_blog_post_excerpt_tiki.sql', '28.4', 0),
('e2a19962bed53701d9998d7c4434a85d', './installer/schema/20100825_add_changed_column_to_tiki_language_table_tiki.sql', '28.4', 0),
('f0f6af415f67e26aee90c86b87dbf387', './installer/schema/20100825_remove_blog_option_use_title_tiki.sql', '28.4', 0),
('890a3d6accb68581f7d00ebd2c347c1e', './installer/schema/20100830_sheet_add_styles_and_classes_tiki.sql', '28.4', 0),
('560834495744de5dc66690afea1a7626', './installer/schema/20100831_freetag_tiki.sql', '28.4', 0),
('47ed97c0106c3693caa30a0e2ba418fb', './installer/schema/20100901_duplic_actionlog_tiki.sql', '28.4', 0),
('d1f95ffd6ff3f55516c7ff77e3d51297', './installer/schema/20100901_expire_tiki.sql', '28.4', 0),
('99eb503b8e9fcbb4951be5545cc87b9e', './installer/schema/20100902_invit_tiki.sql', '28.4', 0),
('c2b3511dc21a90f27e01a2b270b36ff4', './installer/schema/20100903_article_ispublished_tiki.sql', '28.4', 0),
('57ba839a9b670ba2d383e95875842a79', './installer/schema/20100906_sheet_toolbar_default_tiki.sql', '28.4', 0),
('7a6c571a8fa5ae4142a639593d567671', './installer/schema/20100909_alter_tiki_language_fields_to_text_tiki.sql', '28.4', 0),
('56c277c30f3bb31dc71972f0b90b860a', './installer/schema/20100909_ckeditor_upgrade_tiki.sql', '28.4', 0),
('0d2cdf85fdd09e62d49b8f21ce1e0b48', './installer/schema/20100909_lengthen_wiki_attachments_filename_tiki.sql', '28.4', 0),
('c2c91b87c9818a362b19af7d95361bee', './installer/schema/20100910_new_fields_for_tiki_blogs_tiki.sql', '28.4', 0),
('de4d46f4cc1e55843ee4fb763f1bfbb2', './installer/schema/20100912_rename_autosave_pref_tiki.sql', '28.4', 0),
('ceb893e4b41453e3f40e6f49740694a8', './installer/schema/20100915_add_edit_languages_menu_option_tiki.sql', '28.4', 0),
('b013ef3769d8303ade0931d40bcadbbe', './installer/schema/20100919_tiki_page_contribution_tiki.sql', '28.4', 0),
('9628e595d2392ac509aa9a851b416822', './installer/schema/20100920_ckeditor_remove_pref_tiki.sql', '28.4', 0),
('ea7b94f6c26c78f9cfe9914004b126a2', './installer/schema/20100920_jq_sheet_remove_pref_tiki.sql', '28.4', 0),
('0f0e8d6edd889f948074b5c58eb706d3', './installer/schema/20100920_todo_event_tiki.sql', '28.4', 0),
('0a44187ddda66fb57a8e37de3c683697', './installer/schema/20100923_fix_column_position_tiki.sql', '28.4', 0),
('70deaf3aecb55eff018d3f3d692a7838', './installer/schema/20100923_social_networking_permission_and_menuitem_tiki.sql', '28.4', 0),
('15b3ea9e0602ba476f14eca5ed031f62', './installer/schema/20100925_fix_some_default_value_tiki.sql', '28.4', 0),
('1d28b6ed1ccfdae6b5343d3c180a31e6', './installer/schema/20100927_better_column_fix2_tiki.php', '28.4', 0),
('f3386f3fd528401ad7cea1e2af9d9068', './installer/schema/20100927_better_column_fix_tiki.php', '28.4', 0),
('7078f85293d9b2df64d6b783fd69a8f9', './installer/schema/20100928_sefurl_regex_reordering_tiki.sql', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('b319e7d8b377939e46e5c59fbbfc9cdb', './installer/schema/20101008_user_id_for_tiki_language_tiki.sql', '28.4', 0),
('aa530de5c60b975c437300e3789b2f88', './installer/schema/20101014_tiki_language_add_lastModif_column_tiki.sql', '28.4', 0),
('d982ed41cbf120d9b6c2ebe5ac7e2813', './installer/schema/20101015_tiki_admin_perms_tiki.sql', '28.4', 0),
('f641cc4bf74fb2e9ff547e1aac5c17ae', './installer/schema/20101021_rename_blog_post_comment_object_type_tiki.sql', '28.4', 0),
('ae10d405e50604c62961ff3f82c58fdb', './installer/schema/20101025_fgal_show_deleteAfter_tiki.sql', '28.4', 0),
('0a0afe6962bb24e3d73b2c9409e54fcd', './installer/schema/20101025_profile_sources_pref_tikiwiki_to_tiki.sql', '28.4', 0),
('8d475ba6cabe360e56d29efdbea5e905', './installer/schema/20101025_rename_create_blog_menu_entry_tiki.sql', '28.4', 0),
('3e70698041a57203ad6063378c85984a', './installer/schema/20101026_auth_token_add_columns_tiki.sql', '28.4', 0),
('6497387d0c7806b7aa2427ebef94f37b', './installer/schema/20101027_add_file_gallery_columns_tiki.sql', '28.4', 0),
('228fe45691621f0bb44c70c86a2313c4', './installer/schema/20101027_rename_invit_to_invite_tiki.sql', '28.4', 0),
('8c9d09f4bcecefe64b6610e390492a55', './installer/schema/20101028_p_invit_tiki.sql', '28.4', 0),
('06adc57267b54f62d81f7045853d2842', './installer/schema/20101110_actionlog_tiki.sql', '28.4', 0),
('b61f72f5e9c94f9868f641b673f08ec9', './installer/schema/20101117_actionlog_tiki.sql', '28.4', 0),
('18252b1f4851a73f05c7108718b95836', './installer/schema/20101119_categ_perm_tiki.sql', '28.4', 0),
('624849183014a738640ad613a0c4b0df', './installer/schema/20101126_fgal_add_gallerie_user_tiki.php', '28.4', 0),
('e4b0f44e867fc72e58fb85fc610399a9', './installer/schema/20101130_recreate_tiki_accounting_tables_tiki.sql', '28.4', 0),
('3302b26e70bb5b51e46e783fdea048ed', './installer/schema/20101130_tiki_accounting_tiki.sql', '28.4', 0),
('f4f667d5a0393718c980cf83fe5be0a6', './installer/schema/20101201_tiki_accounting_fix_index_tiki.sql', '28.4', 0),
('ab434bc67f52b72a28cce6ab0ae0d351', './installer/schema/20101203_fgal_archive_default_tiki.sql', '28.4', 0),
('9d6fdac3ebb63a29a4a6fc67e925d9f7', './installer/schema/20101207_feature_file_drafts_tiki.sql', '28.4', 0),
('a46381a5a632a1c933b5e776c39fee0d', './installer/schema/20101208_webservice_soap_tiki.sql', '28.4', 0),
('3b84b3d96b8c192223c00545cdfa079f', './installer/schema/20101210_fgal_add_wiki_attachments_tiki.php', '28.4', 0),
('dd5468fab59af87a2aa1d9d86c46d125', './installer/schema/20101210_sync_users_ldap_tiki.sql', '28.4', 0),
('5058136507b87f7dad9221c554f053b4', './installer/schema/20101211_filegal_maxhits_column_tiki.sql', '28.4', 0),
('673e536dd0126f5bad554785b9f5c729', './installer/schema/20101211_kil_feature_phplayers_tiki.php', '28.4', 0),
('f6e3f8d12dc1ab16f9b8375f553a64be', './installer/schema/20101215_remove_files_tiki.sql', '28.4', 0),
('56bd633ebe67ea8013b7263320d9d442', './installer/schema/20101215_template_file_galleries_tiki.sql', '28.4', 0),
('3de83e0ba0fb478781deadea680de629', './installer/schema/20101219_kill_feature_mobile_tiki.sql', '28.4', 0),
('165c2fcfe425fa7ad175d00f401e5a34', './installer/schema/20101230_create_top_modules_tiki.php', '28.4', 0),
('d9cf35b0058aecae96913a8e7c39f99a', './installer/schema/20110103_include_in_history_tiki.sql', '28.4', 0),
('24ff523ffad872d3ce90571ce0d70702', './installer/schema/20110104_flagged_revision_log_tiki.sql', '28.4', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_again_tiki.sql', '28.4', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_tiki.sql', '28.4', 0),
('83e49b253f0a00059a979cd3a88a6343', './installer/schema/20110112_approval_permissions_tiki.sql', '28.4', 0),
('95b8bee4c1aefc583f6c3fb9dd80802a', './installer/schema/20110115_create_bottom_modules_tiki.php', '28.4', 0),
('0b0ad5da10e9c802b02aff9be0e603a7', './installer/schema/20110118_p_remove_tracker_items_tiki.sql', '28.4', 0),
('c55afd33b7db3e2822c266655eee7aa7', './installer/schema/20110124_update_sheet_to_support_cloning_tiki.sql', '28.4', 0),
('811784b397e95930d88b9fbc2bad627a', './installer/schema/20110201_c_code_to_user_modules_tiki.php', '28.4', 0),
('96de5f8fc058be02a0d781c11f96876f', './installer/schema/20110209_p_list_users_tiki.sql', '28.4', 0),
('e182b1170b0628144f3b7031b4ae9e56', './installer/schema/20110220_p_tracker_view_attachments_tiki.sql', '28.4', 0),
('cf450811ce67bd74a29f4c977127e74f', './installer/schema/20110223_queue_tiki.sql', '28.4', 0),
('540c8adbe21843a849f78019a3a90752', './installer/schema/20110224_tiki_cart_inventory_hold_tiki.sql', '28.4', 0),
('097d060cf3ea7d34012d7692bcdefe40', './installer/schema/20110307_remove_calendar_reminder_tiki.sql', '28.4', 0),
('9383d1ca207d3aec10bf0e8847b8e8f2', './installer/schema/20110308_rss_item_key_tiki.sql', '28.4', 0),
('58b53aa01ecf477ac82dde6e4ef3d7e5', './installer/schema/20110317_attributes_increase_length_tiki.sql', '28.4', 0),
('9830d9ebee9ed93916946a229528d0f0', './installer/schema/20110411_banner_tiki.sql', '28.4', 0),
('8540fc07af7bdbbe76307d4af97a02fc', './installer/schema/20110412_permissions_out_of_db_tiki.sql', '28.4', 0),
('93e5ba1928f66db69d80f8556f6e0279', './installer/schema/20110413_blog_post_priv_default_value_tiki.sql', '28.4', 0),
('56eb71d5321768180d28bbdd0d54a1ae', './installer/schema/20110419_kill_old_search_tiki.sql', '28.4', 0),
('221fbfc6f88ef2630110ad5f6e19a358', './installer/schema/20110420_newsletter_optional_group_inclusion_tiki.sql', '28.4', 0),
('37c7ccf6d9b10f0bd4612d2967a8c309', './installer/schema/20110421_compact_search_in_topbar_tiki.sql', '28.4', 0),
('22ac2552b70bc5b077c29450466aeec9', './installer/schema/20110507_remove_module_style_params_tiki.sql', '28.4', 0),
('c19e62816382404968d7a6dfff401da2', './installer/schema/20110513_banner_tiki.sql', '28.4', 0),
('b8d023864d75d7dcd1e14c0294781bf9', './installer/schema/20110519_quick_edit_categ_params_merge_tiki.php', '28.4', 0),
('6ad0dbeb2003eb63e2782ce8578ed710', './installer/schema/20110603_convert_tracker_comments_tiki.sql', '28.4', 0),
('9820218bc613e80463759ac5cdffcb61', './installer/schema/20110606_convert_ip_fields_to_ipv6_tiki.sql', '28.4', 0),
('807fa46c47826a962baa067c9eec8722', './installer/schema/20110609_batch_update_tracker_item_links_tiki.php', '28.4', 0),
('787a5f5d2bab3458b3012ae54469ee1c', './installer/schema/20110609_missing_sql_tiki.sql', '28.4', 0),
('8e32c07487b8ebaf8c5a48f487553f05', './installer/schema/20110609_unique_login_tiki.php', '28.4', 0),
('d9ce76e3752d0531115b70415e3c7bb0', './installer/schema/20110610_readd_sefurl_index_left_tiki.php', '28.4', 0),
('2f19e2666841d01b7c612194bc8c2f7c', './installer/schema/20110610_revert_poll_additions_tiki.php', '28.4', 0),
('118fe0373f666f454253d166c37723d3', './installer/schema/20110611_accounting_fix_primarykeys_tiki.sql', '28.4', 0),
('7ac89aee06b1e7dfc191afd6b837af2b', './installer/schema/20110613_filegal_source_display_tiki.sql', '28.4', 0),
('04c304ade37e768c0f20d4da1bb6cc31', './installer/schema/20110614_provider_authentication_tiki.sql', '28.4', 0),
('45cc111cc1df4c17c6982177b24a0250', './installer/schema/20110615_structure_alias_tiki.sql', '28.4', 0),
('3d3efcb12b2491dade431346a93f4272', './installer/schema/20110622_file_from_url_log_tiki.sql', '28.4', 0),
('2881aa2867a68821baa2f8a9d95e16cb', './installer/schema/20110630_fix_blogs_copyright_frencho_tiki.sql', '28.4', 0),
('1207ff134476c048445fa5a175aeda3d', './installer/schema/20110717_invoice_menu_options_tiki.sql', '28.4', 0),
('d706c164e7327bf66d68644d7297e921', './installer/schema/20110725_tracker_field_permname_tiki.sql', '28.4', 0),
('8421e15234fd764192e12dfe10da03b0', './installer/schema/20110727_tracker_multilingual_convert_tiki.php', '28.4', 0),
('9c2fe77d70c17df2c038e4488b17d794', './installer/schema/20110727_tracker_multilingual_convert_tiki.sql', '28.4', 0),
('94392c46b0ed3843e2cc020e7c75db6f', './installer/schema/20110803_objectpermissions_tiki.sql', '28.4', 0),
('3713bca2297fd26847d523ac6512224b', './installer/schema/20110808_default_perm_name_tiki.sql', '28.4', 0),
('2616b96d2ce5225935c658d36a171833', './installer/schema/20110808_tracker_tiki.sql', '28.4', 0),
('a08aa709071292d07d56267037fd0f95', './installer/schema/20110815_creator_lost_7_tiki.sql', '28.4', 0),
('4fc9819d32aca61b48496e52c8aa36f9', './installer/schema/20110819_group_max_length_tiki.sql', '28.4', 0),
('b3428c386e01fbe73047c55cadcc30f0', './installer/schema/20110823_tiki_connect_create_tiki.sql', '28.4', 0),
('2909cf1a279262e6290b155799653e96', './installer/schema/20110830_default_enable_in_use_tiki.php', '28.4', 0),
('1b9c3c961e6deca124a4012adf6a2734', './installer/schema/20110830_tiki_connect_longer_guid_tiki.sql', '28.4', 0),
('894111de5dc15d63eb5f7b41dca9a7b8', './installer/schema/20110902_revert_rootCategId_addition_tiki.php', '28.4', 0),
('328b8627af75d5564f388731ab74c711', './installer/schema/20110904_shoutbox_def_tweetid_tiki.sql', '28.4', 0),
('06177cffcaa034aa10f307ab16118ee4', './installer/schema/20110905_extend_actionlog_comment_tiki.sql', '28.4', 0),
('264fc6a5a9986a1806b63c8b39f10251', './installer/schema/20110905_multibyte_lc_fix_tiki.php', '28.4', 0),
('24ce6ceaf2a590a5291cbb899b6b8ce7', './installer/schema/20110908_author_submission_tiki.sql', '28.4', 0),
('322244495b3f612ff070dba910433fde', './installer/schema/20110909_tiki_forums_add_language_tiki.sql', '28.4', 0),
('13a301980674abdc01e85abea9425dfa', './installer/schema/20110911_add_missing_engine_specs_tiki.sql', '28.4', 0),
('76e3828702b68de894048a364ad096f3', './installer/schema/20110912_groupsexpiryanniversary_tiki.sql', '28.4', 0),
('6e71326d28f1b81e66467802d5dfed74', './installer/schema/20110912_remove_unused_fields_tiki.sql', '28.4', 0),
('6114f9218bd29cdc11f8c1a1d039985e', './installer/schema/20110923_referer_stats_tiki.sql', '28.4', 0),
('5cb9b8bc23137ec40da043d997af27cc', './installer/schema/20110926_tracker_menu_feature_reports_tiki.sql', '28.4', 0),
('a9f5fe2dbd1789987812f4d8932a8c6d', './installer/schema/20111001_add_tiki_areas_tiki.sql', '28.4', 0),
('407750420d6d2827c1198ce722fefc24', './installer/schema/20111006_drop_useless_key_tiki.sql', '28.4', 0),
('fa31c9cc670222337f3934c58d0ab895', './installer/schema/20111010_revert_fix_user_bookmarks_folders_key_tiki.php', '28.4', 0),
('e4fd615f3ee7224ce7065179ac05b602', './installer/schema/20111014_menu_feature_time_sheet_tiki.sql', '28.4', 0),
('e49fc3a8c6b20f7beee8389d50f0f134', './installer/schema/20111118_remove_versionOfPreferencesCache_tiki.sql', '28.4', 0),
('955501778236fe83504e4ce2c02099c8', './installer/schema/20111210_add_blog_hits_tiki.sql', '28.4', 0),
('8c3eefd5747facc604522bce0b7a3b0a', './installer/schema/20111217_on_value_tracker_tiki.sql', '28.4', 0),
('bbac3e90f149e60ce8c1851a5b147cd8', './installer/schema/20111231_change_datetime_defaults_to_null_tiki.php', '28.4', 0),
('54901ab93551e49fd2372410d26f24d7', './installer/schema/20120115_remove_article_show_lang_tiki.sql', '28.4', 0),
('eb75b6d04c0ba431ba96f3f3e00b183e', './installer/schema/20120118_remove_users_prefs_language_tiki.sql', '28.4', 0),
('8aa7cfcc0e89ac36204d4d2923d782dd', './installer/schema/20120123_remove_column_from_tiki_user_reports_tiki.sql', '28.4', 0),
('6f7ae9d4d88d1fd8f47ed4207a142ec7', './installer/schema/20120315_list_image_article_y_tiki.sql', '28.4', 0),
('c117ae7f125445e353e66fc93d15c793', './installer/schema/20120319_remove_sheets_with_no_relation_tiki.sql', '28.4', 0),
('47a64215b806bc69fc1762bec8628a80', './installer/schema/20120320_remove_admin_trackers_application_menu_tiki.sql', '28.4', 0),
('8be855afd09afffd9421030ef884d7c0', './installer/schema/20120323_add_reports_to_application_menu_tiki.sql', '28.4', 0),
('5915f745e660dbfb599856e21d1d5a8c', './installer/schema/20120323_remove_tracker_reports_from_application_menu_tiki.sql', '28.4', 0),
('46b7f80f9589da64c98a70b9269c6cc2', './installer/schema/20120324_add_filegals_icon_tiki.sql', '28.4', 0),
('ef7cd89a6a747950a94c018b0b9b3021', './installer/schema/20120401_kaltura_prefs_rename_tiki.sql', '28.4', 0),
('7e861d8be89c62e0fc790c580905c8df', './installer/schema/20120408_add_forumthread_sefurl_tiki.sql', '28.4', 0),
('e5c32a4acc3564abb7646802d82939ea', './installer/schema/20120421_autoincementtoautoincrement_tiki.sql', '28.4', 0),
('0351e57b91c6022444ecfeffc7c72e07', './installer/schema/20120422_mime_tiki.sql', '28.4', 0),
('98c3ad22db54d5a603bf29f8711da702', './installer/schema/20120423_add_page_refs_tiki.sql', '28.4', 0),
('0a97722ec5858dade8610abc538d06a3', './installer/schema/20120423_add_status_attr_tiki.sql', '28.4', 0),
('eb751653821eea4afa005a21965fb001', './installer/schema/20120426_perspectives_menu_entry_tiki.sql', '28.4', 0),
('065220f370cf11f688281a5c21a047ce', './installer/schema/20120426_tiki_db_status_tiki.sql', '28.4', 0),
('be3b0812ecdbe0ea5826959cf957ac19', './installer/schema/20120429_fix_collation_tiki.php', '28.4', 0),
('2a1743af01a89efb43f2e6b0822ca5d7', './installer/schema/20120510_mailqueue_tiki.sql', '28.4', 0),
('02fd7c020f0f0eecb8c46c966387bfa7', './installer/schema/20120604_add_holder_to_copyright_tiki.sql', '28.4', 0),
('8965cd9fbbeae4f092b9113f32a53c08', './installer/schema/20120628_correct_admin_user_createdate_tiki.sql', '28.4', 0),
('f77420b5c17943f0f57b9ae25f40fd04', './installer/schema/20120823_admin_user_credit_menu_entry_tiki.sql', '28.4', 0),
('553bcde43dd2576908d5838a34cd9261', './installer/schema/20120823_workspace_template_tiki.sql', '28.4', 0),
('849d88e7bb98c32166cc7f7c8e422bf0', './installer/schema/20120824_advanced_mode_flag_tiki.sql', '28.4', 0),
('b09f72e445325d5b290bd74023b5f956', './installer/schema/20120825_accounting_menu_entry_tiki.sql', '28.4', 0),
('b94ca87f607d459633ed52b307917eb8', './installer/schema/20120826_store_metadata_tiki.sql', '28.4', 0),
('493ed1b13709eb88fa82c5a8180b2e6a', './installer/schema/20120904_category_root_tiki.php', '28.4', 0),
('040310ecc810ced038db139a0bf9943d', './installer/schema/20120904_category_root_tiki.sql', '28.4', 0),
('46aadea27a9cd9646b771b97b4a9ab30', './installer/schema/20120927_add_area_exclusive_and_common_tiki.sql', '28.4', 0),
('29f3ec57c679da3c747c8d1fb78f4bcd', './installer/schema/20120927_add_menu_parse_tiki.sql', '28.4', 0),
('2a44d38e5345ebf58742ba826ecb5ecc', './installer/schema/20120930_tiki_p_view_poll_choices_tiki.sql', '28.4', 0),
('3cb67ce6e2d0c884110fd7848c94a7c9', './installer/schema/20121009_module_search_box_to_search_tiki.sql', '28.4', 0),
('7ffee0c3c2c04925d2657e7a3aced53e', './installer/schema/20121016_actionlog_comment_text_tiki.sql', '28.4', 0),
('1322b29fedaa19ebc14140315407cbc1', './installer/schema/20121027_tracker_samerow_fix_tiki.sql', '28.4', 0),
('1cdbb1b1c87529f75509a40d900de4cd', './installer/schema/20121210_add_missing_index_user_assigned_modules_tiki.sql', '28.4', 0),
('fddde4267df7ab11df0999f2114b76b0', './installer/schema/20121210_better_forum_reported_index_tiki.sql', '28.4', 0),
('36865e5e83a6a4fc5e61bc43980c1b62', './installer/schema/20121213_module_zone_enlarge_tiki.php', '28.4', 0),
('566786e812240f906c36fd1d4acd9542', './installer/schema/20121213_module_zone_enlarge_tiki.sql', '28.4', 0),
('f400a5ecec07b112fec66e77b1d2f729', './installer/schema/20130220_wiki_attachments_tiki.sql', '28.4', 0),
('737e19c901e25ff8c54a4558fe018a29', './installer/schema/20130228_bigger_token_groups_tiki.sql', '28.4', 0),
('ee050d5b8a9eca59e6f125a45c283475', './installer/schema/20130301_sefurl_tracker_type_tiki.sql', '28.4', 0),
('388b15d787592e591a46c5bf5287206d', './installer/schema/20130314_keep_search_pref_settings_tiki.php', '28.4', 0),
('cad976420a3bc2e4a49506632af268e4', './installer/schema/20130322_app_menu_timesheet_pos_tiki.sql', '28.4', 0),
('44ec4903b1538e416525a6594899e66c', './installer/schema/20130322_restore_lost_filegals_tiki.sql', '28.4', 0),
('78828e075e63206219481fd1a96faca5', './installer/schema/20130328_extend_actionlog_bbb_tiki.sql', '28.4', 0),
('3a32eaeb8aa97aa8345e571d1f3db8bd', './installer/schema/20130410_keep_wysiwyg_htmltowiki_setting_tiki.php', '28.4', 0),
('f6e3acf02e07ef44d2a3c1404bdb74e4', './installer/schema/20130415_repair_file_galleries_again_tiki.php', '28.4', 0),
('a6dc788402261b5ad7f8dc457a519d38', './installer/schema/20130417_score_alter_tiki.sql', '28.4', 0),
('1548a7f6c0f3e048a2d9cff98040430e', './installer/schema/20130417_score_tiki.sql', '28.4', 0),
('2ec218efe4d675718cb4874068bcb483', './installer/schema/20130419_newsletters_clippings_tiki.sql', '28.4', 0),
('e4852d3b573876cd2e68f12c802b5be0', './installer/schema/20130513_convert_tracker_field_parameters_tiki.php', '28.4', 0),
('06c8be2f743dd4a2a13a7a0a364abbc3', './installer/schema/20130530_category_log_tiki.sql', '28.4', 0),
('ccfa5273eda1b232f21b778e00ddfc2a', './installer/schema/20130530_tracker_modification_log_tiki.sql', '28.4', 0),
('362b275807bed067759ba6fb1502cf15', './installer/schema/20130605_mailin_show_inline_tiki.sql', '28.4', 0),
('6f6945a8092cae1c0a663ea8a915770d', './installer/schema/20130606_mailin_add_categoryId_tiki.sql', '28.4', 0),
('7824253242a5c3641ac10844a1b8f905', './installer/schema/20130608_convert_mailin_pwd_tiki.php', '28.4', 0),
('810b71aa0c0166b64f8f27194511fb83', './installer/schema/20130608_mailin_response_tiki.sql', '28.4', 0),
('b5732bd4a0ea92ba019ca86d43a66d63', './installer/schema/20130611_mailin_add_html_tiki.sql', '28.4', 0),
('15de188ed2b8dbb2239e575b1150e0a3', './installer/schema/20130614_mailin_add_admin_tiki.sql', '28.4', 0),
('8c1977cb799881db7f7d87c4ec260f99', './installer/schema/20130616_mailin_add_namespace_tiki.sql', '28.4', 0),
('9fe8acbdaa6cd6804f8c7913d5d0945c', './installer/schema/20130623_create_mailin_user_struct_tiki.sql', '28.4', 0),
('2d3d0193bdd38bfe398eca12b4263a86', './installer/schema/20130624_mailin_add_attr_tiki.sql', '28.4', 0),
('22381e5220531fc9df24b9a92f1d3f9e', './installer/schema/20130704_catname_tiki.sql', '28.4', 0),
('3927bb8ba89cef57e6679b080295d62d', './installer/schema/20130705_activity_stream_tiki.sql', '28.4', 0),
('5cd63d71a596f99fde4c47176211bca1', './installer/schema/20130715_activity_stream_rules_tiki.sql', '28.4', 0),
('783a0cc74edeefda8775a7efb4d976ef', './installer/schema/20130730_friendship_conversion_tiki.sql', '28.4', 0),
('a67099a385301a4b847168020b76ae0a', './installer/schema/20130730_wiki_para_format_default_change_tiki.php', '28.4', 0),
('8a71c66336b573de4ef0a1d145e6b173', './installer/schema/20130807_tracker_files_display_param_change_tiki.php', '28.4', 0),
('a5af4e4aed2ae98d411084e2dbf0f552', './installer/schema/20130809_limit_name_lengths_in_objects_tiki.php', '28.4', 0),
('31334949f0ce1de52c3f6a93a28fe43c', './installer/schema/20131007_menus_items_missing_icons_tiki.sql', '28.4', 0),
('571ae86418cc31331bb0021296349765', './installer/schema/20131108_mytiki_add_mailin_tiki.sql', '28.4', 0),
('494cf7041923d4ca2e37aaa23d42853b', './installer/schema/20131117_unified_engine_default_change_tiki.php', '28.4', 0),
('5d1437bc3bd543091835de90e1991d8f', './installer/schema/20131218_stored_queries_tiki.sql', '28.4', 0),
('818b79ae45f7ed853c70c0ecb19e7c46', './installer/schema/20131231_add_sheet_metadata_tiki.sql', '28.4', 0),
('63588872c5d3fc25f97683f89785f855', './installer/schema/20140109_query_unique_name_tiki.sql', '28.4', 0),
('169d7254d23d4f5630582a21986eba0e', './installer/schema/20140117_monitor_tiki.sql', '28.4', 0),
('1e08c3fc2c93915f8b3a631a3d26044d', './installer/schema/20140129_bigger_target_monitor_tiki.sql', '28.4', 0),
('1c47a37146f38292f1d968bfef47ebb8', './installer/schema/20140203_menu_item_and_icon_user_wizard_tiki.sql', '28.4', 0),
('ce1c7d411fae4b462bed93d9ac6a5a95', './installer/schema/20140206_add_parser_column_tiki.sql', '28.4', 0),
('edde062c490700faca572aaabf77cb52', './installer/schema/20140210_user_wizard_add_section_name_tiki.sql', '28.4', 0),
('999c259f971e2fecb1149e74a86c1c43', './installer/schema/20140214_goals_tiki.sql', '28.4', 0),
('0442370003a89c03d1f7883226733f3d', './installer/schema/20140219_full_goal_events_tiki.sql', '28.4', 0),
('d6e3d03ba7405a447f4d3fd47f0ce4aa', './installer/schema/20140301_add_column_rating_choice_topic_on_forums_tiki.sql', '28.4', 0),
('8ab2629b201dc667190659d2fc0d3c02', './installer/schema/20140318_user_wizard_add_groupname_tiki.sql', '28.4', 0),
('57ecb42c72979352cd5ba68b3403aeec', './installer/schema/20140402_mailin_protocol_option_tiki.sql', '28.4', 0),
('9fcb77f139414164845c0f9117748905', './installer/schema/20140402_payment_authorization_tiki.sql', '28.4', 0),
('c8cbc000d5875cc0a92f7953db4797fe', './installer/schema/20140402_remove_mailin_smtp_tiki.sql', '28.4', 0),
('664417ce11b34798af188c68990f9782', './installer/schema/20140509_rss_add_categories_tiki.sql', '28.4', 0),
('dd9a3fc5e45cf923014c6798b659969b', './installer/schema/20140625_survey_tiki.sql', '28.4', 0),
('84f7d6c1af19614ed08e0b1d012e9de8', './installer/schema/20140705_page_slug_tiki.php', '28.4', 0),
('e8434febe415828ffc72641e5b2013b3', './installer/schema/20140705_page_slug_tiki.sql', '28.4', 0),
('de40a3d1b526871e6c400294b11ff1e8', './installer/schema/20140807_federated_search_tiki.sql', '28.4', 0),
('47a13c870ca78d25b919d94a5f0bffb0', './installer/schema/20140812_convert_tiki_connect_data_to_json_tiki.php', '28.4', 0),
('e3072df61eae0c85a320d3c66983fbab', './installer/schema/20140914_addon_profiles_tiki.sql', '28.4', 0),
('8ee715acbdd66d1d8d58fa1eaca6e21a', './installer/schema/20141003_change_style_pref_to_theme_tiki.php', '28.4', 0),
('b570b04882abe860e483717f508a4424', './installer/schema/20141106_menu_configuration_panel_tiki.sql', '28.4', 0),
('722ef80e1f2641b33d0c51930cda0439', './installer/schema/20141114_remove_babelfish_tiki.sql', '28.4', 0),
('8b7024e62197537a0a65a596a7d12244', './installer/schema/20141120_tracker_tabular_tiki.sql', '28.4', 0),
('1c4726c7c1398af65801e1e79b66049f', './installer/schema/20141122_change_prefname_availblestyles_to_availablethemes_tiki.sql', '28.4', 0),
('109233b6947f5095378ea739f554ecde', './installer/schema/20141125_menu_control_panels_tiki.sql', '28.4', 0),
('810f09f5a3711abf92c3e4976f9807fd', './installer/schema/20150109_tabular_filters_tiki.sql', '28.4', 0),
('58c344c5452911759d101ad286b68d7d', './installer/schema/20150112_theme_option_etc_tiki.sql', '28.4', 0),
('1eee7b39a4687be425eeb55a590d8d22', './installer/schema/20150203_add_menu_option_class_tiki.sql', '28.4', 0),
('975871b45b1c2c9d8e493e3b3d0cdaaa', './installer/schema/20150310_rename_freetags_in_menu_42_tiki.sql', '28.4', 0),
('fb48dee14b960d1d7c48a08a85ef7fc8', './installer/schema/20150310_rename_mytiki_in_menu_42_tiki.sql', '28.4', 0),
('2d346e27c91070cc840b7dab52504a0f', './installer/schema/20150327_tracker_showPopup_option_fix_tiki.sql', '28.4', 0),
('8e032a195dac36d92fdbeaf0aecfd85e', './installer/schema/20150414_profile_symbol_tooshort_fix_tiki.sql', '28.4', 0),
('fc3c6bd5ed7353f96f36fa1fe9c318b1', './installer/schema/20150426_menu_item_external_wikis_restored_tiki.sql', '28.4', 0),
('081e7daf19971ad47ba0eb0eb8fe001b', './installer/schema/20150508_perspectives_style_to_theme_tiki.php', '28.4', 0),
('bd25949296c7ceaf65935eb8530c73c6', './installer/schema/20150730_menu_item_tabular_trackers_tiki.sql', '28.4', 0),
('ffb42720a6dd9ba8670b6bacaf35eb84', './installer/schema/20150901_prefname_char_length_tiki.sql', '28.4', 0),
('7fae5fdf9dcc1a2446e7d930bbc0fdfe', './installer/schema/20150929_make_hotwords_longer_tiki.sql', '28.4', 0),
('2afddf6d23449b961d9c97ec5125a3fc', './installer/schema/20151203_tiki_score_revamp_tiki.sql', '28.4', 0),
('0b0ac54a682f34d94dddc4505b328c7f', './installer/schema/20151203_tokens_create_user_tiki.sql', '28.4', 0),
('5468fa2c97256a0f7fb4c92251f7b880', './installer/schema/20160120_remove_gmap_menu_item_tiki.sql', '28.4', 0),
('381f850f916bceec588cda286a9361be', './installer/schema/20160201_remove_maps_menus_tiki.sql', '28.4', 0),
('6647ca98d6677dbfe4f2c096488e1c88', './installer/schema/20160206_theme_option_modules_tiki.sql', '28.4', 0),
('d767fe6ea302cb082eb0a2e91a024b23', './installer/schema/20160315_correct_blogpost_encoding_tiki.sql', '28.4', 0),
('ea2f7fb91e7fde0d126e2221f16cb7f0', './installer/schema/20160325_menu_42_list_pages_tiki.sql', '28.4', 0),
('8cc364ddb16d2f13d019c3eacd1ff66b', './installer/schema/20160420_correct_blogpost_encoding_tiki.sql', '28.4', 0),
('12fe008b7f0546d15f76f80aacf97e16', './installer/schema/20160519_calendar_events_action_log_tiki.sql', '28.4', 0),
('861d7ba1007a5553f7df989ff948be5c', './installer/schema/20160527_menu_item_payment_tiki.sql', '28.4', 0),
('6a8c281b237495e027f93e95beced976', './installer/schema/20160604_remove_unwanted_files_tiki.php', '28.4', 0),
('8cc8de59f71262e6a1f99d927b79aaba', './installer/schema/20160608_menu_item_admin_tokens_tiki.sql', '28.4', 0),
('c949f7ae51ac122ccff013162fcd8287', './installer/schema/20160612_new_password_implementation_tiki.sql', '28.4', 0),
('f83941959cbe9067a082cf26e1043c4f', './installer/schema/20160612_remove_feature_challenge_pref_tiki.sql', '28.4', 0),
('adc07b416a815a8f03874198fd656d13', './installer/schema/20160614_clear_password_removal_tiki.sql', '28.4', 0),
('1b9a5f74e37b3a2b9b8067eda6b6a225', './installer/schema/20160627_remove_more_unwanted_files_tiki.php', '28.4', 0),
('e2d6675d1b2336734626c73d49f73f04', './installer/schema/20160817_fix_dymanic_list_field_values_tiki.php', '28.4', 0),
('ec6cd06bfbd06b43859ab14ab39eabc9', './installer/schema/20160914_extwiki_missing_columns_fix_tiki.php', '28.4', 0),
('e61bd3eb5e50b4ec85e95079d1ecca01', './installer/schema/20160915_extwiki_indexname_length_tiki.sql', '28.4', 0),
('45b09b10f8ea3c02ee12691304becc7b', './installer/schema/20161109_remove_old_password_tiki.php', '28.4', 0),
('eee4743d39b2312e6ecff75c92a69d9a', './installer/schema/20161117_favicon_tiki.sql', '28.4', 0),
('c11ab00fb5536582645af47d2e8f365b', './installer/schema/20161206_larger_comment_field_tiki.sql', '28.4', 0),
('6de770c4a95205e0aa61e1d679283f09', './installer/schema/20161220_add_h5p_tables_tiki.sql', '28.4', 0),
('240ba47520a7acce828f0bf6cef8ab7c', './installer/schema/20170122_schedulers_tiki.sql', '28.4', 0),
('a32009e8646f18dd48a9b374b1ccfc30', './installer/schema/20170127_remove_templates_c_tiki.php', '28.4', 0),
('fd2258f8a39b5169741c2099d4b03817', './installer/schema/20170129_feature_dump_tiki.sql', '28.4', 0),
('c8a60d8cdfb3565b69127ae54d04da0a', './installer/schema/20170207_iefix_rem_tiki.sql', '28.4', 0),
('f84913f95963a58e47c93c2739f283f3', './installer/schema/20170213_footnotearea_tiki.sql', '28.4', 0),
('7e9a23984ebda395c2d649295bdc338c', './installer/schema/20170218_schedulers_menu_tiki.sql', '28.4', 0),
('60263c47c43b093a7c136d13181ecd9c', './installer/schema/20170305_webservices_menu_tiki.sql', '28.4', 0),
('8edbc1084b547b63c6f78494fdf6be9f', './installer/schema/20170307_kill_wikilingo_tiki.sql', '28.4', 0),
('d94c2fd4462b9645a41586c87af072da', './installer/schema/20170319_kill_jcapture_tiki.sql', '28.4', 0),
('9ed43fbdc01e8c73bd2e7ee263f10b21', './installer/schema/20170322_fix_allocate_memory_prefs_tiki.sql', '28.4', 0),
('c00631e32fd03059c5eef945f7863763', './installer/schema/20170329_add_color_to_groups_tiki.sql', '28.4', 0),
('4438e6ee090276c2075c8bfc957e1491', './installer/schema/20170329_larger_category_descriptions_tiki.sql', '28.4', 0),
('23f4d598463814df65c646ac33611f49', './installer/schema/20170330_merge_hiddenlinks_into_headinglinks_tiki.sql', '28.4', 0),
('2fd39ce818ff806b5278a6dbf5140802', './installer/schema/20170427_update_accounting_journal_cols_tiki.sql', '28.4', 0),
('08e0d74ea36e315296ef16f3d29a4d63', './installer/schema/20170531_feature_usability_tiki.sql', '28.4', 0),
('6a10646d08ded550f49800b7b5014fed', './installer/schema/20170628_schedulers_menu_tiki.sql', '28.4', 0),
('3cbd55baf1f3c88d2cc5dd068332ea9d', './installer/schema/20170702_wiki_url_scheme_pref_default_tiki.php', '28.4', 0),
('d004defba0d59ece0833d9aecb64f3b5', './installer/schema/20170717_add_missing_trackeritem_attachment_backlinks_tiki.php', '28.4', 0),
('f266609ceac80f0c53c24145a7c45a21', './installer/schema/20170726_remove_article_hashes_tiki.sql', '28.4', 0),
('7900f8cb0da7eefc44e333004c55f701', './installer/schema/20170726_tabular_config_tiki.sql', '28.4', 0),
('5c7fdeca3bec2b10dba0756b877839be', './installer/schema/20170829_custom_routes_tiki.sql', '28.4', 0),
('8bda31c0d04c361263cda1c39944199c', './installer/schema/20170920_admin_webservices_menu_option_tiki.sql', '28.4', 0),
('ad273fb8a3de46ecb514f2e7d94736e4', './installer/schema/20170925_add_general_to_language_tiki.sql', '28.4', 0),
('d14ab7413cc7dd0ab9511af079b707cf', './installer/schema/20170930_custom_routes_menu_tiki.sql', '28.4', 0),
('876555c041bae9e5e061c7adb8a6bd24', './installer/schema/20171002_queue_handler_size_increase_tiki.sql', '28.4', 0),
('9466b7f60fe444acaee8f9e992d1ef3a', './installer/schema/20171010_action_log_info_new_column_tiki.php', '28.4', 0),
('8a1525b0f940c1c14dc04a340cfbe8b9', './installer/schema/20171016_no_homepage_specificed_tiki.php', '28.4', 0),
('ecbe60467cafbdeb77bc8561f0679423', './installer/schema/20171121_create_plugin_include_relations_tiki.php', '28.4', 0),
('f4abc334a722098ff7aba542ed26c7ce', './installer/schema/20171122_h5p_update_add_hub_table_tiki.sql', '28.4', 0),
('ef930a840992362c04915add52147ddd', './installer/schema/20171123_create_object_links_tiki.php', '28.4', 0),
('d99b0b8efaed59d28bc42cd06c16a011', './installer/schema/20171129_backlinks_for_object_types_admin_options_tiki.sql', '28.4', 0),
('66cbeb1c9c5d27862ca5888ea0071aec', './installer/schema/20171130_plugin_include_link_original_tiki.sql', '28.4', 0),
('c622a5feed33323862aa6f2dc164f5da', './installer/schema/20171204_update_geo_enabled_tiki.sql', '28.4', 0),
('fdf500b3ad5aa5eb8c0cbe2666d36f5d', './installer/schema/20171231_add_short_url_tiki.sql', '28.4', 0),
('75ab724a0ed998cf5c03f8c20b6ba543', './installer/schema/20180228_comment_on_object_attributes_tiki.sql', '28.4', 0),
('45b5c210f7fefa7873401d3cb6024ff6', './installer/schema/20180331_rename_custom_route_object_type_tiki.sql', '28.4', 0),
('03b5cd52cdbfc264e8432645d2e3d51d', './installer/schema/20180405_custom_routes_menu_tiki.sql', '28.4', 0),
('0a5cb5a13d80bf5690eb982dc5904cac', './installer/schema/20180405_remove_unused_user_id_tiki.sql', '28.4', 0),
('11c8fd68fe4171f5783cb57b0c1e577c', './installer/schema/20180410_install_piwik_plugin_tiki.php', '28.4', 0),
('6ba406554a14d2fddad4c069f0dc2ed2', './installer/schema/20180411_schedulers_change_column_to_text_tiki.sql', '28.4', 0),
('52e9f72e43040b23b489ea44c43ee32e', './installer/schema/20180412_rename_short_url_prefs_tiki.sql', '28.4', 0),
('733dc3217ef761090477e9413426cb79', './installer/schema/20180419_scheduler_run_stalled_column_tiki.sql', '28.4', 0),
('cd428c5756b4f05ea6b764f0cf1a28c9', './installer/schema/20180421_scheduler_run_healed_column_tiki.sql', '28.4', 0),
('eed54e26fdc4867a1c59784aaa835f73', './installer/schema/20180503_fix_throttled_newsletters_tiki.sql', '28.4', 0),
('526019e79ad1a4415c61928c042d4c0d', './installer/schema/20180609_change_log_column_type_tiki.sql', '28.4', 0),
('751120c011c1c4de4f1578b271e6d4b9', './installer/schema/20180625_user_reports_null_last_reports_tiki.sql', '28.4', 0),
('bc86aa555cffced621d949868afdf7b2', './installer/schema/20180705_fix_calendaritem_tracker_attributes_tiki.sql', '28.4', 0),
('31991df8d0082922a07ed84d2776e862', './installer/schema/20180706_remove_menu_reports_tiki.sql', '28.4', 0),
('812e2e73e30215f18b64b95bd03763a2', './installer/schema/20180803_semaphore_value_tiki.sql', '28.4', 0),
('4f18a0947aea64a264a0d591bb25c871', './installer/schema/20180808_ocr_tiki.sql', '28.4', 0),
('248fb02673aed57936068d21e55ca3d0', './installer/schema/20180815_merge_topic_read_perm_tiki.sql', '28.4', 0),
('3c2bad543cb7a0a240d301977a65b7ea', './installer/schema/20180909_remove_page_content_fetch_readability_tiki.sql', '28.4', 0),
('04f3233604e34ed46c3a0596baf160d6', './installer/schema/20180918_remove_poweredby_module_tiki.sql', '28.4', 0),
('5120ab754e911ea426976e5dc97d518b', './installer/schema/20180921_php_upgrade_fix_from_older_tiki.php', '28.4', 0),
('b4cb598bd215c313edd93f2f78c99fdb', './installer/schema/20180921_sql_upgrade_fix_from_older_tiki.php', '28.4', 0),
('d5c2b526223227bfc75d3684ab198f3e', './installer/schema/20180923_convert_collation_to_utf8mb4_tiki.php', '28.4', 0),
('aa37e17717f27af3bff25be4fe504908', './installer/schema/20180925_feature_jquery_superfish_pref_default_tiki.php', '28.4', 0),
('29317c82da0d406663cba29d46a5d041', './installer/schema/20181114_ocr_uff8mb4_tiki.sql', '28.4', 0),
('10aaa9ad8f215493ad61ae86f25944c7', './installer/schema/20181127_convert_db_local_to_utf8mb4_tiki.php', '28.4', 0),
('9d9161bd99ebf5430f3f1e4278117e0e', './installer/schema/20181130_update_column_name_size_tracker_table_tiki.sql', '28.4', 0),
('2531e2b1a80dc003cfd1a2d94cd64d9e', './installer/schema/20190117_create_oauthserver_clients_table_tiki.sql', '28.4', 0),
('67b1a038054ed146c2766265d99e0646', './installer/schema/20190121_h5p_add_new_library_fields_tiki.sql', '28.4', 0),
('7104ef096f1b22dde38c0c4f2f48f956', './installer/schema/20190121_h5p_allow_null_in_filtered_tiki.sql', '28.4', 0),
('62dd53d50798d80568b7a18b6307be55', './installer/schema/20190123_h5p_move_storage_assets_to_new_dir_tiki.php', '28.4', 0),
('6c3a2992b22b779ed855620e65ebf193', './installer/schema/20190129_fix_ambiguity_on_oauthserver_id_column_tiki.php', '28.4', 0),
('068ca01a57fba854eba3ad536530310e', './installer/schema/20190226_change_xmpp_auth_pref_name_tiki.sql', '28.4', 0),
('b2d09fb8cf6362a66e4e7ff0c0434f38', './installer/schema/20190303_make_tiki_object_href_larger_tiki.sql', '28.4', 0),
('6e0be312d346770a1f4005b8e234b9d7', './installer/schema/20190401_add_support_database_strict_mode_tiki.sql', '28.4', 0),
('1c10cd737040087392e064baddbf25f1', './installer/schema/20190425_add_creation_date_schedule_tiki.sql', '28.4', 0),
('c74555198a3b4177d6bd56f9cb1de71e', './installer/schema/20190425_set_creation_date_to_scheduler_tiki.php', '28.4', 0),
('5d8ac658c0c6d98408e88e0673a81d7c', './installer/schema/20190523_migrate_webmail_accounts_tiki.php', '28.4', 0),
('e4ac9a8109622ea18809c642ad6d26a4', './installer/schema/20190526_remove_tiki_addon_profiles_tiki.sql', '28.4', 0),
('5f29fd9203816d46e921ab28826f4f16', './installer/schema/20190620_add_role_groups_tiki.sql', '28.4', 0),
('871e967e4e8268ec69b096f78b4e1dbd', './installer/schema/20190627_add_ocr_fgal_status_tiki.sql', '28.4', 0),
('eb215c708c3a33bb7ffcdccb6a88846d', './installer/schema/20190717_add_role_categ_available_tiki.sql', '28.4', 0),
('21fadc155ab35853f7affe28b2422af7', './installer/schema/20190722_ocr_fgal_tiki.sql', '28.4', 0),
('dfe176e17549e7ae7bd54ac28ba5f0ac', './installer/schema/20190723_add_is_tlp_group_tiki.sql', '28.4', 0),
('b197a50f75f1d7fa998caecc6725b790', './installer/schema/20190729_add_tlp_group_category_tiki.sql', '28.4', 0),
('35808972cf4a216c0e90f482254e8181', './installer/schema/20190831_add_two_factor_secret_tiki.sql', '28.4', 0),
('de8db997d574a7afe9a8a54ca76c0c04', './installer/schema/20190913_caldav_tiki.sql', '28.4', 0),
('6c411e8725a9b696bb7db7a9a730b53d', './installer/schema/20190925_caldav_updates_tiki.sql', '28.4', 0),
('b5a5fb647b0291834f8bf0c4925ad7db', './installer/schema/20191114_caldav_recurring_updates_tiki.sql', '28.4', 0),
('1a16b25a33696e1b9dcc4121f7611ea0', './installer/schema/20191116_scheduler_run_only_once_tiki.sql', '28.4', 0),
('2b041737a62a9abc30ee7065db8c8f54', './installer/schema/20191126_add_forum_parent_tiki.sql', '28.4', 0),
('a62a38886e82131fb641d09d773bd1d6', './installer/schema/20191218_carddav_tiki.sql', '28.4', 0),
('c61977bd122475c05d7118b53143fab1', './installer/schema/20200113_tracker_field_rules_column_tiki.sql', '28.4', 0),
('4399d43e24d437313364a3cfb23f7016', './installer/schema/20200123_calendar_rsvp_tiki.sql', '28.4', 0),
('fc8fd4b751dac80a6a02ba1a227b8b85', './installer/schema/20200126_remove_invoice_menu_options_tiki.sql', '28.4', 0),
('a87d4519131d319c755d730a92f28c26', './installer/schema/20200205_mailin_add_galleryid_tiki.sql', '28.4', 0),
('2466c179999ae3cb1e528fdaf314c48e', './installer/schema/20200218_mailin_add_trackerid_tiki.sql', '28.4', 0),
('77a9f98f0a05175dec423866c5ea8a45', './installer/schema/20200309_fix_sefurl_regex_out_issues_tiki.sql', '28.4', 0),
('5b755f2d3042c68d7819ae1476ac0eb6', './installer/schema/20200311_add_forum_order_tiki.sql', '28.4', 0),
('79235d26670fd6216d745318aa090320', './installer/schema/20200513_expand_sessions_data_column_tiki.sql', '28.4', 0),
('1b7524ba6ec1829d8a0d9554ecf8989f', './installer/schema/20200601_carddav_contact_uri_tiki.sql', '28.4', 0),
('f646ed7b9623faeab1dd7dfb98e32f7e', './installer/schema/20200613_scheduler_run_now_tiki.sql', '28.4', 0),
('e9454bb8f0bd53b05d127004bc996fb5', './installer/schema/20200614_expand_mail_queue_message_column_tiki.sql', '28.4', 0),
('251a93a22f5155d1e7c6c03384ac6619', './installer/schema/20200701_rename_pref_unified_lucene_default_operator_tiki.sql', '28.4', 0),
('560a883f6694ee43f5e883456b2ceeaa', './installer/schema/20200710_feature_templated_groups_tiki.php', '28.4', 0),
('791001a3baa8529ab3802e064d9e6e93', './installer/schema/20200820_performance_table_creation_tiki.sql', '28.4', 0),
('8ab40e1a97d6aa8ea74a9230f4ca8b95', './installer/schema/20200903_create_encryption_keys_tiki.sql', '28.4', 0),
('4b432360cb51437743dc98a52483f511', './installer/schema/20200903_create_machine_learning_models_tiki.sql', '28.4', 0),
('55b5f11d9bcdbcc5d84d4bb1d9602fb8', './installer/schema/20200910_add_encryption_key_to_tracker_fields_tiki.sql', '28.4', 0),
('af0797da7e33016d1d2b7dd4e70d0ae7', './installer/schema/20200928_add_machine_learning_menu_options_tiki.sql', '28.4', 0),
('6378e0b162580584a084a5287e5d1f20', './installer/schema/20201024_h5p_add_a11y_title_tiki.sql', '28.4', 0),
('783f6534bf5f806b4d963bb5634970a0', './installer/schema/20201024_h5p_add_default_lang_tiki.sql', '28.4', 0),
('fdac7050a5bd41e3496348f0d2f93a1b', './installer/schema/20201118_add_odbc_tabulars_tiki.sql', '28.4', 0),
('aeb851095f17c5a570ebd944c5a716a0', './installer/schema/20201212_remove_comment_hash_tiki.sql', '28.4', 0),
('089a2d35c7dcb1d1ad9070de342bc330', './installer/schema/20210115_add_trackerfields_sefurl_tiki.sql', '28.4', 0),
('eae62776c3098fd2c5cdcf59bf6fcfca', './installer/schema/20210316_preference_replace_chosen_with_select2_tiki.sql', '28.4', 0),
('fea269d780e2f2cd1e8791124d12c1fb', './installer/schema/20210410_alter_activity_stream_arguments_column_tiki.sql', '28.4', 0),
('84b079f34590105bac893b8021b05850', './installer/schema/20210421_add_ml_label_field_tiki.sql', '28.4', 0),
('60db428f497aaf288bf219ee1a1baade', './installer/schema/20210428_mailin_add_preferences_tiki.sql', '28.4', 0),
('c8c930f8bd7b9a846e5cbebf57c31747', './installer/schema/20210605_image_gallery_removal_tiki.sql', '28.4', 0),
('5f66c504fb5e27ccc299c625e66eafc4', './installer/schema/20210608_timesheet_menu_removal_tiki.sql', '28.4', 0),
('58071a62fe437fca10ede774908d0ed8', './installer/schema/20210819_theme_unified_admin_backend_pref_default_tiki.php', '28.4', 0),
('d8887e9ff56c24b81784e60d7674b0c8', './installer/schema/20211004_calendar_weekly_multiple_tiki.php', '28.4', 0),
('5b86202389bc870cc9ccd3d3319fff85', './installer/schema/20211020_mark_image_gallery_tables_as_unused_tiki.sql', '28.4', 0),
('1af7f4f1400cdb676bd514d4788388a9', './installer/schema/20211110_create_api_tokens_tiki.sql', '28.4', 0),
('39dcde6102a604c0ba90cdae7f703de3', './installer/schema/20211126_timezone_date_update_tiki.php', '28.4', 0),
('5e26fec0700583811cca79a4faaacd20', './installer/schema/20220111_backlinks_tiki.sql', '28.4', 0),
('3c6f27723656fb2269040acddb4a94e6', './installer/schema/20220112_extend_api_tokens_tiki.sql', '28.4', 0),
('aaf985cc80c824de0c14833bfaefd637', './installer/schema/20220112_extend_oauthserver_clients_tiki.sql', '28.4', 0),
('cb9d92f1b6d1e744ddfa148a40033f29', './installer/schema/20220113_password_blacklist_tiki.sql', '28.4', 0),
('7b570cd593e1c41deb789801509c05e4', './installer/schema/20220119_make_user_nullable_api_tokens_tiki.sql', '28.4', 0),
('c05d7337f0acd7df9f2d084c5c7d6b65', './installer/schema/20220301_add_manager_menu_option_tiki.sql', '28.4', 0),
('0f3f38035a9df72fe0e1d26aa305c977', './installer/schema/20220503_add_api_tabulars_tiki.sql', '28.4', 0),
('df7572504e0094f63cb4db7418dbc4bf', './installer/schema/20220601_discard_hash_column_from_articles_tiki.php', '28.4', 0),
('579ea07714bda8b1fc23e7563da6a885', './installer/schema/20220726_create_webhooks_tiki.sql', '28.4', 0),
('14e07a96b2675d77c1eb598aa05d360a', './installer/schema/20220808_add_user_to_auth_sources_tiki.sql', '28.4', 0),
('4f989fc2c4fed55313d5e3d777904a46', './installer/schema/20220811_http_prefs_default_tiki.php', '28.4', 0),
('d794191197116b61eb0406cc4bb46b53', './installer/schema/20220811_permissions_print_and_pdf_export_tiki.sql', '28.4', 0),
('f3a3c9938342e22722c4cac3ed13d477', './installer/schema/20220909_remove_tiki_mindmap_feature_tiki.sql', '28.4', 0),
('d3832e692058625b1617dcb43a05fe74', './installer/schema/20220923_increase_prefs_value_size_tiki.sql', '28.4', 0),
('5fa6306d3cf277ff22b4d5b367ed4d8c', './installer/schema/20221020_add_direct_to_file_galleries_tiki.sql', '28.4', 0),
('207de3adddcd96b996a458b1a896a611', './installer/schema/20221024_add_indexes_to_file_galleries_tiki.sql', '28.4', 0),
('9171cd608f0f42671f4a556fd02ab228', './installer/schema/20221026_add_fgal_sync_to_action_log_tiki.sql', '28.4', 0),
('626016352ebeb87c07a750ce937998a9', './installer/schema/20221028_remove_openid_url_tiki.php', '28.4', 0),
('8215acc083badb1bdc85d3ad4f6a7954', './installer/schema/20221102_add_exclude_from_notification_tiki.sql', '28.4', 0),
('b4501371dc8739296dfe67f40c29cac3', './installer/schema/20221110_add_actionforuser_index_on_actionlog_tiki.sql', '28.4', 0),
('1c9cfb15567f9cbaa07c30ba1b0759f7', './installer/schema/20221111_ft_rename_tracker_tabular_tiki.sql', '28.4', 0),
('b02d4d49753578250ca5281ef7da768e', './installer/schema/20221128_force_refresh_of_mapping_for_forum_section_tiki.sql', '28.4', 0),
('fb97a92b54719049ae5c62258858886c', './installer/schema/20221218_add_field_properties_visible_mode_tiki.sql', '28.4', 0),
('ac3b0db90cc7aee44c26e6d42d93468e', './installer/schema/20230118_add_notification_sent_on_plugin_security_tiki.sql', '28.4', 0),
('73e12cdff467971003fd536c658ad500', './installer/schema/20230120_add_plugin_details_on_plugin_security_tiki.sql', '28.4', 0),
('9f8eeac6b7856a87a1240743a5c7c453', './installer/schema/20230125_add_goalid_to_credits_tiki.sql', '28.4', 0),
('1398a3476e52e7f63bd186ddedeca13d', './installer/schema/20230217_mailin_alter_leave_email_tiki.sql', '28.4', 0),
('06ba468836b21e03bec34df4a6e21e1a', './installer/schema/20230224_plugin_security_tiki_change_arguments_default_value_tiki.sql', '28.4', 0),
('431e88df33cceb534af24fe20eaffdbb', './installer/schema/20230327_update_tiki_manager_menu_section_tiki.sql', '28.4', 0),
('033babdf1b3bb8c93a27e5d0d768f8d0', './installer/schema/20230504_add_attemps_on_tiki_banning_tiki.sql', '28.4', 0),
('3593418357fdbab167cb94705d06a219', './installer/schema/20230510_recurringevent_bymonth_based_on_weekday_tiki.sql', '28.4', 0),
('a5e64bd87682356bf5b523db7f486f93', './installer/schema/20230515_larger_rating_field_articles_tiki.sql', '28.4', 0),
('b7571048e28fc6e14636b45bcab8798e', './installer/schema/20230520_add_blog_allow_post_categorization_tiki.sql', '28.4', 0),
('5aa6da44315b90081d89876cea99550e', './installer/schema/20230522_relation_metadata_tiki.sql', '28.4', 0),
('f240e00d38411738012637281bd98635', './installer/schema/20230608_add_timezone_picker_recurrenctevent_tiki.sql', '28.4', 0),
('8c54ae3a132ad4fb68c1285843d20ece', './installer/schema/20230625_multiprint_fix_error_data_too_long_for_column_parameters_tiki.sql', '28.4', 0),
('2e3d16b15141d69427d946aa39e1086b', './installer/schema/20230703_fix_error_data_too_long_for_column_body_thrown_on_long_page_saving_tiki.sql', '28.4', 0),
('b0dd9bcc63e03a828683202e8ee4d78c', './installer/schema/20230709_create_tiki_custom_color_modes_tiki.sql', '28.4', 0),
('c4c4961aa88d16a23fa195537579c55c', './installer/schema/20230803_tiki_menu_options_rename_url_import_export_formats_tiki.sql', '28.4', 0),
('6c95480073f8968a796e6bb855ebb336', './installer/schema/20230807_sefurl_fix_error_of_wrong_url_for_column_stats_tiki.sql', '28.4', 0),
('3e01084b6ab56015649d5a69ef043e4c', './installer/schema/20230815_fix_error_data_too_long_for_column_comment_and_entry_thrown_on_long_page_saving_tiki.sql', '28.4', 0),
('d531fcb0ed5026624bd68c6753ded0ed', './installer/schema/20230816_fix_wrong_primary_key_setting_on_several_table_tiki.sql', '28.4', 0),
('0a478d2d7c0f5c4224e628d7513efd66', './installer/schema/20230822_create_calendar_propertystorage_tiki.sql', '28.4', 0),
('5f557c495bf3b05ae090e4d43945b8de', './installer/schema/20230824_calendar_calssification_pattern_background_ui_tiki.sql', '28.4', 0),
('c57250917cba5cd143d3759f2a31e9a2', './installer/schema/20230825_calendar_recurrence_fields_tiki.sql', '28.4', 0),
('7089f97d0f4f552ed2acbf0bc8536183', './installer/schema/20230828_add_restriction_tiki_surveys_tiki.sql', '28.4', 0),
('1701ffc105df2fa187f55ad85bffd5eb', './installer/schema/20230831_remove_calendarid_from_subscriptions_tiki.sql', '28.4', 0),
('9384e22e2565782b6b17ea88bcd52b86', './installer/schema/20230906_add_sync_to_calendar_subscriptions_tiki.sql', '28.4', 0),
('964cc5ddff159ac4354a0cd07e099e3c', './installer/schema/20231008_fix_primary_key_issues_on_several_tables_tiki.php', '28.4', 0),
('e62b45ae500873b37e10d8ca4447cb28', './installer/schema/20231025_remove_upload_option_from_kaltura_feature_tiki.sql', '28.4', 0),
('a29e3249a2458c9d1f69e4e13e2880c6', './installer/schema/20231026_remove_pref_kaltura_kcwuiconf_tiki.sql', '28.4', 0),
('78864f31af5b56eb8a75b039d2fa544e', './installer/schema/20231108_add_private_to_calendars_tiki.sql', '28.4', 0),
('91f2721a5b640082314e5170311f68d4', './installer/schema/20231110_remove_searchresults_tiki.sql', '28.4', 0),
('17cd305aefa590fa2dd9146fae2da488', './installer/schema/20231119_extend_actionlog_conf_crsf_error_tiki.sql', '28.4', 0),
('c3926700a9c99ad1d3c2faae80b57501', './installer/schema/20240126_calendar_recurrence_dayofmonth_tiki.sql', '28.4', 0),
('864cb74fdcfc9a1d9ccae1f1d3a77774', './installer/schema/20240311_various_pref_default_tiki27_tiki.php', '28.4', 0),
('fa6c16f4d26d383c9162696675122f77', './installer/schema/20240312_fix_usage_implicit_timestamp_tiki.sql', '28.4', 0),
('f19afddaa38d38666c043420d81edb70', './installer/schema/20240405_modify_tiki_pages_description_type_tiki.sql', '28.4', 0),
('3baf0bad1fba96b9dd95af00d36eb8a0', './installer/schema/20240408_add_api_to_action_log_tiki.sql', '28.4', 0),
('9c3bd091f5a62c00b4142cb72df51aa6', './installer/schema/20240412_recurringevent_bymonth_based_on_firstlastweekday_tiki.sql', '28.4', 0),
('b6402a801e14f4ab1839fd283efbb02e', './installer/schema/20240412_recurringevent_byyear_based_on_firstlastweekday_tiki.sql', '28.4', 0),
('52755336bc355faa5adacbf004b02bac', './installer/schema/20240418_fix_included_plugins_pref_default_tiki.sql', '28.4', 0),
('00751f57765e4dd387208f2112f05f99', './installer/schema/20240419_tabular_itemlink_lookup_simple_rename_tiki.php', '28.4', 0),
('53fe46e46699a8a548115ffc12472daf', './installer/schema/20240502_fix_out_of_range_issue_on_tikiquizstatssum_table_tiki.sql', '28.4', 0),
('4f055dde84a56618b7f9a6a0b18e4091', './installer/schema/20240505_fix_tracker_visibility_fields_tiki.sql', '28.4', 0),
('30633a1a011ef44a58b1b2db9f6c448e', './installer/schema/20240531_tiki_file_attach_relation_to_emails_tiki.php', '28.4', 0),
('5269ff8332fa9aba7931dcede726ccc1', './installer/schema/20240620_offline_trackers_menu_option_tiki.sql', '28.4', 0),
('176388ac7ed395ba7e0163167104fae1', './installer/schema/20240719_keep_link_to_legacy_icons_admin_dashboard_tiki.sql', '28.4', 0),
('dccdfa252a95d1a8ccf4554ddff7a347', './installer/schema/20240818_add_custom_status_to_calendar_item_tiki.sql', '28.4', 0),
('6309831f5a25e88c11889f0896c49967', './installer/schema/20240828_create_tiki_iot_apps_tables_tiki.sql', '28.4', 0),
('49db1c3796bc77ace6e07dccb164f882', './installer/schema/20240829_increase_user_prefs_value_size_tiki.sql', '28.4', 0),
('06b56d2f4aa3c69d3e78e3677ced96d7', './installer/schema/20240923_create_tiki_sql_query_logs_tiki.sql', '28.4', 0),
('2495a7dd7ac580f053b8ff2177d07f3e', './installer/schema/20240923_update_unified_trackerfield_keys_tiki.sql', '28.4', 0),
('48f2587a5d8ab315d52608ef5cfec146', './installer/schema/20241015_expand_sql_query_column_tiki.sql', '28.4', 0),
('dbc9d8462aadab47192e40e9bad7b705', './installer/schema/20241018_theme_unified_admin_backend_pref_default_tiki.php', '28.4', 0),
('c0050b7a67041a1e0c97380ed363abb9', './installer/schema/20241107_update_right_column_for_file_type_in_sefurl_tiki.sql', '28.4', 0),
('e783686ad91a31c7ecbd658500ee9008', './installer/schema/20241114_update_url_type_from_rss_module_tiki.sql', '28.4', 0),
('56f378711dbc2fe56661fba038107791', './installer/schema/20250104_add_password_management_history_tiki.sql', '28.4', 0),
('34788e2106859e0fe933d00a29603f23', './installer/schema/999999991_decode_pages_sources_tiki.php', '28.4', 0),
('594c0d7fbb4c0afc455044ee673e1b4e', './installer/schema/99999999_image_plugins_kill_tiki.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './installer/schema/index.php', '28.4', 0),
('3a7d8e4e655fb8173ce7278efb1bbd93', './installer/schema/optional_20170801_initialize_article_nbreads_tiki.php', '28.4', 0),
('c37ccde61beff7a6c92eeb42477b2409', './installer/shell.php', '28.4', 0),
('59f10208ab9210ec5c2bde5b398b751b', './installer/tiki-installer.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ar/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/ar/language.js', '28.4', 0),
('543858f4f926ca5e6d6ea5908f91325e', './lang/ar/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/bg/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/bg/language.js', '28.4', 0),
('08f1718ed4a12dd3fcb2225b23275ef9', './lang/bg/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ca/index.php', '28.4', 0),
('7efbed05d54b0111706acd44a0acc7ef', './lang/ca/language.js', '28.4', 0),
('71408ea1bc78b14d59810e5ef2957e48', './lang/ca/language.php', '28.4', 0),
('08c9ec153309e126ac57161e7783efda', './lang/ca/language_r.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/cn/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/cn/language.js', '28.4', 0),
('c2e7a5d2c8279dfd2d9976fdc1192f9f', './lang/cn/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/cs/index.php', '28.4', 0),
('4023c73656c3f5044e96aa5b72734056', './lang/cs/language.js', '28.4', 0),
('df1f6c66efcc03de85f26c0923e9973a', './lang/cs/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/cy/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/cy/language.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('a82036e253985d4a02c1aaa8ca2268a0', './lang/cy/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/da/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/da/language.js', '28.4', 0),
('878f432454f1bf89e94fbed486d2c660', './lang/da/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/de/index.php', '28.4', 0),
('2c1c02e250920a8c665315c3b891a7f1', './lang/de/language.js', '28.4', 0),
('f08031ea5e73f7bd155a01112c8d3d6e', './lang/de/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/el/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/el/language.js', '28.4', 0),
('26f4ade935a331dcf3ee70b7d8dc641d', './lang/el/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/en-uk/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/en-uk/language.js', '28.4', 0),
('60eb81dc71fd7d8e05eac7ce5bb70e2a', './lang/en-uk/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/en/index.php', '28.4', 0),
('869788f5933f40fdf7e1f5a8a0a6bc81', './lang/en/language.js', '28.4', 0),
('8782bb86b061bc0e6cfb2a91fc7b6650', './lang/en/language.php', '28.4', 0),
('08c9ec153309e126ac57161e7783efda', './lang/en/language_r.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/es/index.php', '28.4', 0),
('89df401a0f9dc9dda96fac91e4961d71', './lang/es/language.js', '28.4', 0),
('2bc2e2b3fb5f376cea037307a26eaae7', './lang/es/language.php', '28.4', 0),
('dd13812535181c5bc6d2a9d54631e8f3', './lang/es/language_r.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/fa/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/fa/language.js', '28.4', 0),
('39c1bafe950ba303e1b611917d70559f', './lang/fa/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/fi/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/fi/language.js', '28.4', 0),
('d0661dfaa6fbd63ca3b146e3e34129d8', './lang/fi/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/fj/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/fj/language.js', '28.4', 0),
('24f120ea98cfe940f4630b08daef2d84', './lang/fj/language.php', '28.4', 0),
('9e8105dd0cc46c4b8de7f5bcb9fc5640', './lang/flagmapping.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/fr/index.php', '28.4', 0),
('3df16202e47aa6e74e207f035211fa88', './lang/fr/language.js', '28.4', 0),
('ca4f5a4399e58bb8562e97e010c0d486', './lang/fr/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/fy-NL/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/fy-NL/language.js', '28.4', 0),
('7284a94465eadda2e23383e52d5e3ffe', './lang/fy-NL/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/gl/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/gl/language.js', '28.4', 0),
('ad8f90690f2e0b27663a751c1a4486fb', './lang/gl/language.php', '28.4', 0),
('96803928f09fba7677459eda483512c3', './lang/he/custom.php_example.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/he/index.php', '28.4', 0),
('e23cf393964e9c37982572ce3c8c3a97', './lang/he/language.js', '28.4', 0),
('40f203819bfe9a0a75532a2c0102d0e0', './lang/he/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/hr/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/hr/language.js', '28.4', 0),
('1a369e8c79fdd97d1dac150d58bb9e40', './lang/hr/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/hu/index.php', '28.4', 0),
('f0605a2606c6b4cf08ebc36506fbc79c', './lang/hu/language.js', '28.4', 0),
('f5cd2f97fc65dffc551d91d1f6718252', './lang/hu/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/id/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/id/language.js', '28.4', 0),
('ea73ae5db54557044c506c4cb2cce204', './lang/id/language.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './lang/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/is/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/is/language.js', '28.4', 0),
('04b20f3b14e8b4bdf211f892b6b6bb37', './lang/is/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/it/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/it/language.js', '28.4', 0),
('e84c99c543cdb16cf968a61a083ade6e', './lang/it/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/iu-iq/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/iu-iq/language.js', '28.4', 0),
('90d72c87e22c3bbd9554ddcb25474be3', './lang/iu-iq/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/iu-ro/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/iu-ro/language.js', '28.4', 0),
('90d72c87e22c3bbd9554ddcb25474be3', './lang/iu-ro/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/iu/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/iu/language.js', '28.4', 0),
('6627a91785a03a981c19a74102656b0a', './lang/iu/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ja/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/ja/language.js', '28.4', 0),
('fffa0b739c24960d852100f47e1a7756', './lang/ja/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ko/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/ko/language.js', '28.4', 0),
('5671decb1b07dcac1d395b10edb27260', './lang/ko/language.php', '28.4', 0),
('1963885e4e9b250193c03346ba1c34fd', './lang/langmapping.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/lt/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/lt/language.js', '28.4', 0),
('561dac6adebed7cfeb907e0bf052eb62', './lang/lt/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/nds/index.php', '28.4', 0),
('dad7c1af7c8582a2aef61a31e68f8a7c', './lang/nds/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/nl/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/nl/language.js', '28.4', 0),
('218c02e32422b9bc314563f79016b348', './lang/nl/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/no/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/no/language.js', '28.4', 0),
('1dbb7861b6f11cf91552179ff192f48e', './lang/no/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/pl/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/pl/language.js', '28.4', 0),
('1939a104cf60a7fcb287ab6b63c9349d', './lang/pl/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/pt-br/index.php', '28.4', 0),
('f9d20cf00a4b1e01cb13acbf445f2444', './lang/pt-br/language.js', '28.4', 0),
('33e3e7042c070b47c99df68d04ef9644', './lang/pt-br/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/pt/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/pt/language.js', '28.4', 0),
('d9255bcfff4137d9c757e2040164e5f5', './lang/pt/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/rm/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/rm/language.js', '28.4', 0),
('ee6f31b60f9e050dcf0ce14f4539d0d8', './lang/rm/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ro/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/ro/language.js', '28.4', 0),
('8380c8825b359ae4642d970dd831bcf3', './lang/ro/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ru/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/ru/language.js', '28.4', 0),
('beeee90330137a451155e61daed5d67f', './lang/ru/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sb/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sb/language.js', '28.4', 0),
('f1316d0adb17d204390fe8b1c03b1967', './lang/sb/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/si/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/si/language.js', '28.4', 0),
('2c1d69912166c10f42e271b670f7eb2e', './lang/si/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sk/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sk/language.js', '28.4', 0),
('078b1b48626c6fb44382433aa57ad984', './lang/sk/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sl/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sl/language.js', '28.4', 0),
('4517f4368f56e5c057569c08dc9f9bca', './lang/sl/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sq/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sq/language.js', '28.4', 0),
('ce733d9d306c8e40dc16ac51ee3b2d88', './lang/sq/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sr-latn/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sr-latn/language.js', '28.4', 0),
('01a95be45641fa7005f6548e83b31bce', './lang/sr-latn/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sv/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sv/language.js', '28.4', 0),
('d512f41a4f5277617f4070b26f19ce96', './lang/sv/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/sw/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/sw/language.js', '28.4', 0),
('fd2bd76c4cd739bcb55b11d55726d291', './lang/sw/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/th/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/th/language.js', '28.4', 0),
('80372736a72ff91a9dd53cf4b48b8a41', './lang/th/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/tr/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/tr/language.js', '28.4', 0),
('9b319942edaba595e75534fd42aadb4e', './lang/tr/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/tv/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/tv/language.js', '28.4', 0),
('d1546eadf8e1188300c10cca40aea010', './lang/tv/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/tw/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/tw/language.js', '28.4', 0),
('276b47edc07fd24794821ee25a512796', './lang/tw/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/uk/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/uk/language.js', '28.4', 0),
('bd66243d4b9f534cb598ebea0704c8a9', './lang/uk/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/ur/index.php', '28.4', 0),
('6f2d96e43904b5f21f27c3e762e71a05', './lang/ur/language.js', '28.4', 0),
('48b5126c3a31b911a9f02b5fe4122194', './lang/ur/language.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lang/vi/index.php', '28.4', 0),
('9df7b538f59a63303d7e99a2bc682f61', './lang/vi/language.js', '28.4', 0),
('e2bb7c3f0be5bc4d1731371cfd4895e1', './lang/vi/language.php', '28.4', 0),
('1b71419981713a8a566465c34cedc3f6', './lib/Alchemy/AlchemyLib.php', '28.4', 0),
('396c0128494b12d3a2b3f07f4e4b77ba', './lib/Alchemy/Guesser.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/Alchemy/index.php', '28.4', 0),
('b5a47688dc50f8378e02e8c7b79c1d09', './lib/FitVidJs/FitVidJs.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/FitVidJs/index.php', '28.4', 0),
('07c510fdf32e0573eb091b83b26092ac', './lib/IconGenerator.php', '28.4', 0),
('48b58917bd2822c53cddc8f875f913b8', './lib/Image/Gd.php', '28.4', 0),
('dabf1f7be57d4aa9d27f0620e588b215', './lib/Image/Image.php', '28.4', 0),
('b952d4d5d130c53dea88dd09bb642494', './lib/Image/ImageAbstract.php', '28.4', 0),
('ce70bcbbeabe7fe41df38db869b5812d', './lib/Image/ImagickNew.php', '28.4', 0),
('0598656263b65d0f0c688d291250270a', './lib/Image/img_plugin_default_and_mandatory.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/Image/index.php', '28.4', 0),
('ff5b2d0ee051f0186f2b20a58d7d66d6', './lib/Logs/LogsLib.php', '28.4', 0),
('eedb741b6740797b9d929d1735802094', './lib/Logs/LogsQueryLib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/Logs/index.php', '28.4', 0),
('256bfb6c036d23e4201f3692e129ffbd', './lib/OpenIdConnect/OpenIdConnectLib.php', '28.4', 0),
('54a3f9a960b50c5f0885c2a97195f489', './lib/OpenIdConnect/RSA256Signer.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/OpenIdConnect/index.php', '28.4', 0),
('f88b10af25e79f68221d816a2974578a', './lib/Unoconv/UnoconvLib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/Unoconv/index.php', '28.4', 0),
('633971df0143e56a1d306d3c43864c49', './lib/accounting/accountinglib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/accounting/index.php', '28.4', 0),
('e10abc7f1da5491a961ce54144cd4070', './lib/activity/activitylib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/activity/index.php', '28.4', 0),
('9a5d9e91d683a297042374b152093cee', './lib/admin/adminlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/admin/index.php', '28.4', 0),
('4ed739973166164e7ec67751e1765db2', './lib/ajax/autosave.js', '28.4', 0),
('4ede09bf39d87cb1f8d8e8b0b08bb538', './lib/ajax/autosave.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/ajax/index.php', '28.4', 0),
('0cd785e2ac5899e3445445a7effe6c9b', './lib/articles/artlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/articles/index.php', '28.4', 0),
('aa07f7b67ff91f181e12664346a35b17', './lib/attributes/attributelib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/attributes/index.php', '28.4', 0),
('116f24af67066566d52dffb296ac4e5e', './lib/attributes/relationlib.php', '28.4', 0),
('fc371e37c35bdbfa6531cc2ceb033bec', './lib/auth/PasswordHash.php', '28.4', 0),
('ce047b4c415a89b3d3180995bd5a6993', './lib/auth/api_token.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/auth/index.php', '28.4', 0),
('50576d32c03dc85bd29e71ce842c8550', './lib/auth/ldap.php', '28.4', 0),
('ade062518e3704d4c3313427034e5a37', './lib/auth/phpbb.php', '28.4', 0),
('9f5ae08b944ac30c9b3bbbc077cf8ff9', './lib/auth/tokens.php', '28.4', 0),
('a74f2cb0f8e1bf359f6c2d7dc15e2309', './lib/auth/webhook.php', '28.4', 0),
('030b33b29de9666256b79601700d0742', './lib/avatarlib.php', '28.4', 0),
('080aa82d0cac4e476d577915abedc987', './lib/ban/banlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/ban/index.php', '28.4', 0),
('ba45eac772e8d2114e3234972aa5fc57', './lib/banners/bannerlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/banners/index.php', '28.4', 0),
('e1d6f786fd3ad76db0b9fa86c5b16ec6', './lib/bigbluebuttonlib.php', '28.4', 0),
('1ec1ff6492d68c1601b91205f6c64fd4', './lib/blogs/bloglib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/blogs/index.php', '28.4', 0),
('b3748b3de2059e0062a71f99bc95e25e', './lib/bookmarks/bookmarklib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/bookmarks/index.php', '28.4', 0),
('4fd83493b8806bc03dce601fd3c212ee', './lib/breadcrumblib.php', '28.4', 0),
('953515b711bb84eb19cc809e35b30e04', './lib/cache/cachelib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/cache/index.php', '28.4', 0),
('df7bae1b21b8ba5d2eb419823d925af1', './lib/cache/memcachelib.php', '28.4', 0),
('80dda1eb497dbd365b01c500a3668fdf', './lib/cache/redislib.php', '28.4', 0),
('b1532204e331d9cc5427360cd7dec6bd', './lib/calendar/calendarlib.php', '28.4', 0),
('209a0f20b9ab71be2f9c1204ae769d4f', './lib/calendar/calrecurrence.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/calendar/index.php', '28.4', 0),
('cdf8c688a0d07ff0891914d7711d8e8b', './lib/calendar/tikicalendarlib.php', '28.4', 0),
('a5fba4b9fe612af205f73398ee90cfdd', './lib/captcha/Captcha_Questions.php', '28.4', 0),
('b711ab3ba0dbc302f644f90d1f1001f1', './lib/captcha/Captcha_ReCaptcha20.php', '28.4', 0),
('14873f1bbfe769158c29d392667378b4', './lib/captcha/Captcha_ReCaptcha30.php', '28.4', 0),
('776c9a14f3a4a16a80a5eb60d2674f71', './lib/captcha/captchalib.js', '28.4', 0),
('c866c35c004154f63277c59025d7e191', './lib/captcha/captchalib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/captcha/index.php', '28.4', 0),
('d703d61cdd997ca914a8d3256aa2df63', './lib/categories/categlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/categories/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/ckeditor_tiki/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/index.php', '28.4', 0),
('0d1729e5f1d1723737c9f37c4e9807dc', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/tikilink.js', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/ckeditor_tiki/plugins/_tikilink/index.php', '28.4', 0),
('d1a7c135d38c33a388fccd00d8d50970', './lib/ckeditor_tiki/plugins/_tikilink/plugin.js', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/ckeditor_tiki/plugins/autosave/index.php', '28.4', 0),
('9696936403ff7a93f0dcb6218f8ac151', './lib/ckeditor_tiki/plugins/autosave/plugin.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/ckeditor_tiki/plugins/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/ckeditor_tiki/plugins/inlinecancel/index.php', '28.4', 0),
('1e5882dc9d555c187628c6220c703c50', './lib/ckeditor_tiki/plugins/inlinecancel/plugin.js', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/ckeditor_tiki/plugins/inlinesave/index.php', '28.4', 0),
('f6d2a561f761c8f1786830d55622dd11', './lib/ckeditor_tiki/plugins/inlinesave/plugin.js', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/ckeditor_tiki/plugins/tikiplugin/index.php', '28.4', 0),
('b859bd50d309e37d904c8a57539a1beb', './lib/ckeditor_tiki/plugins/tikiplugin/plugin.js', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/ckeditor_tiki/plugins/tikiwiki/index.php', '28.4', 0),
('f991f2179b969eeb9ed5f8cd2b3b46fe', './lib/ckeditor_tiki/plugins/tikiwiki/plugin.js', '28.4', 0),
('6f9dd7bc0fbd06bcab0fc77639f9ce5f', './lib/ckeditor_tiki/tiki-ckeditor.js', '28.4', 0),
('1e2476677ac1df3362609a08c97b0b11', './lib/ckeditor_tiki/tikilink_dialog.js', '28.4', 0),
('4e853e497ff9dd081a3a3a021534d7f9', './lib/ckeditor_tiki/tikistyles.js', '28.4', 0),
('c52c8c20914dff434624e1086757617d', './lib/ckeditor_tiki/tikitemplates.js', '28.4', 0),
('9497f2ba13ba76b3e500963b326de03b', './lib/ckeditor_tiki/wysiwyglib.php', '28.4', 0),
('a6c19d7d4bcca47b2ce45adec6c26884', './lib/codemirror_tiki/codemirror_tiki.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/codemirror_tiki/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/codemirror_tiki/mode/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/codemirror_tiki/mode/tiki/index.php', '28.4', 0),
('42daaf4c1a291da21f022a2ac0fbc56c', './lib/codemirror_tiki/mode/tiki/tiki.js', '28.4', 0),
('9f9e3877bb9b49c5fb39b4effe3e67d0', './lib/codemirror_tiki/tiki_codemirror.php', '28.4', 0),
('5c149830c7501b4dddf42f67c1f0a8a5', './lib/commcenter/commlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/commcenter/index.php', '28.4', 0),
('f9d5a6e5fda15c256f6aa52f73430cc4', './lib/comments/commentslib.js', '28.4', 0),
('ecb5ed3d787e9ac5b9ee0be4cec89951', './lib/comments/commentslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/comments/index.php', '28.4', 0),
('3872db2d741900c847398ecbbbde2e94', './lib/contribution/contributionlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/contribution/index.php', '28.4', 0),
('70d49d0b7dcf06d2ae2443849273be94', './lib/copyrights/copyrightslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/copyrights/index.php', '28.4', 0),
('e1121f812263ebc3f315aa6607c1e527', './lib/core/BOMChecker/Scanner.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/BOMChecker/index.php', '28.4', 0),
('6e97e7442aa8ff6bc9b935ff32282650', './lib/core/Cache/KvpCacheInterface.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Cache/index.php', '28.4', 0),
('56b84b3ff662edf814299e74f5f5ae30', './lib/core/Category/Manipulator.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Category/index.php', '28.4', 0),
('ef78ec33f8ba2e81b258627c05df06d6', './lib/core/CustomRoute/Controller.php', '28.4', 0),
('944f916bc522a6bbd54bb9585aeba78f', './lib/core/CustomRoute/CustomRoute.php', '28.4', 0),
('1973662bbb1d5cc5ddb6038f13ed6542', './lib/core/CustomRoute/CustomRouteLib.php', '28.4', 0),
('f3dff53281783283841d3cf90c589992', './lib/core/CustomRoute/Item.php', '28.4', 0),
('bdd1dab11531e3880c5939ad0cf1a959', './lib/core/CustomRoute/Type.php', '28.4', 0),
('baa26c582bab6dc9714684928c668302', './lib/core/CustomRoute/Type/Direct.php', '28.4', 0),
('d3d32c2885e608190c42c122f1798807', './lib/core/CustomRoute/Type/TikiObject.php', '28.4', 0),
('95dc15509bff6536ae4046fa4f94bee5', './lib/core/CustomRoute/Type/TrackerField.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/CustomRoute/Type/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/CustomRoute/index.php', '28.4', 0),
('52b99d232b72a1fc0be07fd1e98fbfcd', './lib/core/DeclFilter.php', '28.4', 0),
('2d50799f2b6fb1d88dab287bac2f7a17', './lib/core/DeclFilter/CatchAllFilterRule.php', '28.4', 0),
('10dce12aa324ca96c3eb3f34d379c3a4', './lib/core/DeclFilter/CatchAllUnsetRule.php', '28.4', 0),
('e98b13a16e85fc9030766a210d4873dc', './lib/core/DeclFilter/FilterRule.php', '28.4', 0),
('9c5f194e5e2818a1a69014354fa42619', './lib/core/DeclFilter/KeyPatternFilterRule.php', '28.4', 0),
('09a0466bbbb1efa2aab7988f3f8b06d5', './lib/core/DeclFilter/KeyPatternUnsetRule.php', '28.4', 0),
('9e8b317aac6dd6ee295db3f53026cb4d', './lib/core/DeclFilter/Rule.php', '28.4', 0),
('cf746ba4bd620505c4a35ed3921e834e', './lib/core/DeclFilter/StaticKeyFilterRule.php', '28.4', 0),
('08e64fc69f5c62ff88cdec781233ff9e', './lib/core/DeclFilter/StaticKeyUnsetRule.php', '28.4', 0),
('a785c7a1e26370022351aa95bc24dea9', './lib/core/DeclFilter/UnsetRule.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/DeclFilter/index.php', '28.4', 0),
('e9c55f83504b536763df01c76ba01953', './lib/core/Encryption/Exception.php', '28.4', 0),
('85eb03e873e81f15f278782a2a809763', './lib/core/Encryption/Key.php', '28.4', 0),
('68fd7f3cef3e1de306297fe06318b866', './lib/core/Encryption/KeyException.php', '28.4', 0),
('f9ed126d7bebcdbbe6c9964369eafae3', './lib/core/Encryption/NotFoundException.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Encryption/index.php', '28.4', 0),
('9bdbd03b0721a503553156096dac75af', './lib/core/Exceptions/BigBlueButton/ServerSaltKeyException.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Exceptions/BigBlueButton/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Exceptions/index.php', '28.4', 0),
('bb92d99ad312c1a9d4a7e1901a71f1f1', './lib/core/Feed/Abstract.php', '28.4', 0),
('a3c4a1d3e6fc2720b8954dc3d02481d0', './lib/core/Feed/Container.php', '28.4', 0),
('a2d0e51abd60bfd0f61447c9a28e91ea', './lib/core/Feed/Contents.php', '28.4', 0),
('4b0fe0f09d9c665d77f6535bbc622b67', './lib/core/Feed/Html.php', '28.4', 0),
('cb859a816e76502c453f4557834a8d22', './lib/core/Feed/Html/Receive.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Feed/Html/index.php', '28.4', 0),
('139971e9d3a076fe20062680551c7291', './lib/core/Feed/Item.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Feed/index.php', '28.4', 0),
('0a941bf665db08503726c364ddad0622', './lib/core/Feedback.php', '28.4', 0),
('352ca166c67cb44fadbcb474e241d552', './lib/core/File/DiagramHelper.php', '28.4', 0),
('b2c76b7db477077f363a4aacfb9832bf', './lib/core/File/FileHelper.php', '28.4', 0),
('cfee6e3046f4d1a067a635b072801ebf', './lib/core/File/OcrHelper.php', '28.4', 0),
('2bfbee4f3b4588703e701afcb029f64b', './lib/core/File/PDFHelper.php', '28.4', 0),
('08ac52c808dcf7b907747eb56f90b0b5', './lib/core/File/SlideshowHelper.php', '28.4', 0),
('f0ab54279ff65e084f9a46a2b3fb499e', './lib/core/File/XMLHelper.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/File/index.php', '28.4', 0),
('13430d79a9f1be8401e1452f79b69fbb', './lib/core/Group/Roles/RolesLib.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Group/Roles/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Group/index.php', '28.4', 0),
('6b7483d314d2f9b669ec5bc1e6a43609', './lib/core/H5P/EditorTikiAjax.php', '28.4', 0),
('9946e07657f0665c2e90d868c32570f8', './lib/core/H5P/EditorTikiStorage.php', '28.4', 0),
('bcf8cf2f6e901d64e44cb1c9dfe1c9af', './lib/core/H5P/Event.php', '28.4', 0),
('d21b2e5bae65fde4e1064c5baec57817', './lib/core/H5P/H5PTiki.php', '28.4', 0),
('26e199964cb7c9b709e9d6bb7f72cc7b', './lib/core/H5P/editor.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/H5P/index.php', '28.4', 0),
('3be6de61da772a283adf8b8789c056c2', './lib/core/HeadlessBrowser/Casperjs.php', '28.4', 0),
('34745269fc5260ae7a9a30ad8c658d1c', './lib/core/HeadlessBrowser/Chrome.php', '28.4', 0),
('cf3e32f0597aef341f36072015e4653c', './lib/core/HeadlessBrowser/Exception/Exception.php', '28.4', 0),
('7c944d06596d0385e974859757199814', './lib/core/HeadlessBrowser/Exception/HeadlessException.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/HeadlessBrowser/Exception/index.php', '28.4', 0),
('4be509103f0f159bf9b8c6958708fc21', './lib/core/HeadlessBrowser/HeadlessBrowserFactory.php', '28.4', 0),
('4219633f974d5877bc9ca09696a764a6', './lib/core/HeadlessBrowser/HeadlessBrowserInterface.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/HeadlessBrowser/index.php', '28.4', 0),
('3e3668ed87344efc6a0446052e324e87', './lib/core/IDS/Rule.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/IDS/index.php', '28.4', 0),
('29552708a922441e6c72aa261c51fba1', './lib/core/IDS/log.php', '28.4', 0),
('a9a4f440eed80efae44a0979d8557f3c', './lib/core/JitFilter.php', '28.4', 0),
('a4a9e97d5aa7e4d95fbbd86095ff38d1', './lib/core/JitFilter/Element.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/JitFilter/index.php', '28.4', 0),
('f24bdfac91679e240410a70fcf52202f', './lib/core/Math/Formula/Applicator.php', '28.4', 0),
('3f20a265bf3df45fbee844245ab9cf82', './lib/core/Math/Formula/Currency.php', '28.4', 0),
('2276e388843759919042ad1407ed8f98', './lib/core/Math/Formula/Element.php', '28.4', 0),
('63e0bb6f35b2758ab375eec71162f4f9', './lib/core/Math/Formula/Exception.php', '28.4', 0),
('f6d2eaea8dce13a355aa92e8551dbe86', './lib/core/Math/Formula/Function.php', '28.4', 0),
('02be46b1b32c7db67db6ffdd60acd1da', './lib/core/Math/Formula/Function/Abs.php', '28.4', 0),
('a1ea803c83b01abcd7aaa3d765972db5', './lib/core/Math/Formula/Function/Add.php', '28.4', 0),
('6b0e9a9fd6c6c2b7012a8ac57da18949', './lib/core/Math/Formula/Function/And.php', '28.4', 0),
('8c394ae028e02792fca76284190a2cb5', './lib/core/Math/Formula/Function/Avg.php', '28.4', 0),
('38c670236de817eef8b7f963e286b27d', './lib/core/Math/Formula/Function/Ceil.php', '28.4', 0),
('c5c928efb94b0dad3e3301358a6ef6c0', './lib/core/Math/Formula/Function/Clean.php', '28.4', 0),
('ef268ff845f75c4d45d52c133faea6c6', './lib/core/Math/Formula/Function/Coalesce.php', '28.4', 0),
('d3450289f82e8aa6c9b6ae4991a57b74', './lib/core/Math/Formula/Function/Concat.php', '28.4', 0),
('4205af8ed65f9017b92d67b4caaac4bc', './lib/core/Math/Formula/Function/Contains.php', '28.4', 0),
('ad0b40eb900102e19f34f7c0a2bf1cef', './lib/core/Math/Formula/Function/Count.php', '28.4', 0),
('4076de594e90bf93db974ce0c75ef8ba', './lib/core/Math/Formula/Function/Currency.php', '28.4', 0),
('f648b91293b136481dd7c66941929b39', './lib/core/Math/Formula/Function/CurrencyConvert.php', '28.4', 0),
('98f4e304c4006ad88233ad7c2f285e30', './lib/core/Math/Formula/Function/Date.php', '28.4', 0),
('d97076f7579ef6794fb7c1d41314dac1', './lib/core/Math/Formula/Function/DateDiff.php', '28.4', 0),
('8f1baa9a7e4ad7634a18132c762aa3d7', './lib/core/Math/Formula/Function/Div.php', '28.4', 0),
('175f5ee558138074ef6fd3be1b2e4be9', './lib/core/Math/Formula/Function/Equals.php', '28.4', 0),
('08d0beb9c1b74a1f6b29893cbbb230bc', './lib/core/Math/Formula/Function/Eval.php', '28.4', 0),
('2b9d6dee2ee8602606389d3e96fa0956', './lib/core/Math/Formula/Function/Floor.php', '28.4', 0),
('bb28b4ec805eb8f8b74a898e5f962829', './lib/core/Math/Formula/Function/ForEach.php', '28.4', 0),
('6c7ce9a8b83e7ba27f4c8bf04fd3134a', './lib/core/Math/Formula/Function/Hash.php', '28.4', 0),
('5dbf8ab15285405505244d0880257c21', './lib/core/Math/Formula/Function/If.php', '28.4', 0),
('0f4fca63251b05be07ea6ab1218c1a3b', './lib/core/Math/Formula/Function/IsEmpty.php', '28.4', 0),
('4cac56b6a28df775b965c882c6e3173a', './lib/core/Math/Formula/Function/LessThan.php', '28.4', 0),
('c0f704a88da7dff5e220d564253fd6cc', './lib/core/Math/Formula/Function/Lower.php', '28.4', 0),
('37b490af9322899909bdece72b9a3ea4', './lib/core/Math/Formula/Function/Map.php', '28.4', 0),
('059195f6a44409bfb746c5f2678ef5ff', './lib/core/Math/Formula/Function/Max.php', '28.4', 0),
('b8d9e698d029ee1e0e6d1ee55c7897c5', './lib/core/Math/Formula/Function/Min.php', '28.4', 0),
('ad5afd763cba085d30c50e29ebbc34c7', './lib/core/Math/Formula/Function/MoreThan.php', '28.4', 0),
('fef214777ffc6fd6c66bb25f6b1a988c', './lib/core/Math/Formula/Function/Mul.php', '28.4', 0),
('18b4d3fb2b27ce2f8b8cb541e72f37e5', './lib/core/Math/Formula/Function/Not.php', '28.4', 0),
('6692c6713514dc325e3092d646ec41eb', './lib/core/Math/Formula/Function/NotEquals.php', '28.4', 0),
('d40e641c47dc0f01420e1fdce1944bb1', './lib/core/Math/Formula/Function/NumberFormat.php', '28.4', 0),
('6e2abd587aaa92059f0288fac2326046', './lib/core/Math/Formula/Function/Or.php', '28.4', 0),
('8ce2f2a9a8733af088219434cdb3d7da', './lib/core/Math/Formula/Function/Pad.php', '28.4', 0),
('e8ff36d4d290c15e21d5cb4a5b943760', './lib/core/Math/Formula/Function/Percentile.php', '28.4', 0),
('6429188cb4b99b1af45ee0dff33e7a68', './lib/core/Math/Formula/Function/Pow.php', '28.4', 0),
('6365959ebececc048ba8fb3d631dc7d8', './lib/core/Math/Formula/Function/PregReplace.php', '28.4', 0),
('b0c5d55843e9eb008f825b0ea021a798', './lib/core/Math/Formula/Function/Random.php', '28.4', 0),
('3c5e245b2b87f592a154aa8701010e36', './lib/core/Math/Formula/Function/Round.php', '28.4', 0),
('8e99362ef804ac1ea8adcc603770a7a1', './lib/core/Math/Formula/Function/SplitList.php', '28.4', 0),
('7c0b2ab06f10159fd8d659e0b0c9005e', './lib/core/Math/Formula/Function/Sqrt.php', '28.4', 0),
('0e2ae2cd0ec40261c0a6b6226919c050', './lib/core/Math/Formula/Function/StandardDeviation.php', '28.4', 0),
('22df7a69d5b8751ab4b993e79da41a66', './lib/core/Math/Formula/Function/Str.php', '28.4', 0),
('e4f2960a096da3b213e3662b0c28fa14', './lib/core/Math/Formula/Function/StrReplace.php', '28.4', 0),
('24570ba8a045d19751d5709754314626', './lib/core/Math/Formula/Function/StrToTime.php', '28.4', 0),
('4ebc4781ae3ccc050f289a5b7ef5392b', './lib/core/Math/Formula/Function/Sub.php', '28.4', 0),
('83322ab179f6e5da5fb0d126f1cb4c10', './lib/core/Math/Formula/Function/Substring.php', '28.4', 0),
('c2a6a74991b1a357b0451b3a019ff9c0', './lib/core/Math/Formula/Function/Subtotal.php', '28.4', 0),
('80317b959bf6393a1ce764e36fe15a5a', './lib/core/Math/Formula/Function/Upper.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Math/Formula/Function/index.php', '28.4', 0),
('ec1cf072df7170404e364dab6426137a', './lib/core/Math/Formula/InternalString.php', '28.4', 0),
('81e8185c30e4092bd3f079468eefd3da', './lib/core/Math/Formula/Parser.php', '28.4', 0),
('09ad86a6665a684b7cd1b71e0ed48865', './lib/core/Math/Formula/Parser/Exception.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Math/Formula/Parser/index.php', '28.4', 0),
('f801b77f8b75c3c5e661223a271cb089', './lib/core/Math/Formula/Runner.php', '28.4', 0),
('d36f0aae8fe5088638b1a839a13e1ee8', './lib/core/Math/Formula/Runner/Exception.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Math/Formula/Runner/index.php', '28.4', 0),
('d46be4e25a9c870ec3574a3b7c3e6017', './lib/core/Math/Formula/Tokenizer.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Math/Formula/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Math/index.php', '28.4', 0),
('6cb905cabd66e8e4f4b71394c4fb1d40', './lib/core/Modules/Permissions.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Modules/index.php', '28.4', 0),
('2d8692382fb6e60190c5b49f4c95df63', './lib/core/Multilingual/Aligner/BilingualAligner.php', '28.4', 0),
('97b1cb18a98dbcb9a3efa4fcbf0cbf82', './lib/core/Multilingual/Aligner/MockMTWrapper.php', '28.4', 0),
('19585b4b2b55b5bdecd206175f5d9977', './lib/core/Multilingual/Aligner/SentenceAlignments.php', '28.4', 0),
('5b21745150b637988d9f01a75f36d352', './lib/core/Multilingual/Aligner/SentenceSegmentor.php', '28.4', 0),
('ea71756993ae646cdac69b2a653dc0a8', './lib/core/Multilingual/Aligner/ShortestPathFinder.php', '28.4', 0),
('ad9b6054ec5014b4735cc721da9dc536', './lib/core/Multilingual/Aligner/UpdatePages.php', '28.4', 0),
('d8b155dfc7a8254272cf049eb9a91cd3', './lib/core/Multilingual/Aligner/UpdateSentences.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Multilingual/Aligner/index.php', '28.4', 0),
('000152cc9b3d400d79834626447fd6c9', './lib/core/Multilingual/MachineTranslation.php', '28.4', 0),
('b215bf39c54bbaa67b6ec8d5abd61bdc', './lib/core/Multilingual/MachineTranslation/BingTranslateWrapper.php', '28.4', 0),
('e3de7f93a2edba3958d7ab3365298ef5', './lib/core/Multilingual/MachineTranslation/Cache.php', '28.4', 0),
('0397a91b1d80c7b4093a5132e90e64aa', './lib/core/Multilingual/MachineTranslation/GoogleTranslateWrapper.php', '28.4', 0),
('541bbfc93c717326673aac8816515200', './lib/core/Multilingual/MachineTranslation/Interface.php', '28.4', 0),
('e36c0502a2cf08da01e2f5783b4b8183', './lib/core/Multilingual/MachineTranslation/Null.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Multilingual/MachineTranslation/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Multilingual/index.php', '28.4', 0),
('0fd43401e7d4f4272a91530ce3662f20', './lib/core/Notifications/Email.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Notifications/index.php', '28.4', 0),
('8dd7a9b708b01ee3e8253642a2925008', './lib/core/Perms.php', '28.4', 0),
('5c6d0e1038330104f397dc4744602232', './lib/core/Perms/Accessor.php', '28.4', 0),
('41067df0af587c888578bda326f9d03e', './lib/core/Perms/Applier.php', '28.4', 0),
('844ffce864b14a28325144d7f2212aca', './lib/core/Perms/Builder.php', '28.4', 0),
('d2e81abd737461841829336c7d8b2670', './lib/core/Perms/Check.php', '28.4', 0),
('b3e6bce8a772b70a70e024eff4f4daea', './lib/core/Perms/Check/Alternate.php', '28.4', 0),
('e63f866605a919fdabc01b91d0bf2ce1', './lib/core/Perms/Check/Creator.php', '28.4', 0),
('12e3833c808f2cf91de268677e443564', './lib/core/Perms/Check/Direct.php', '28.4', 0),
('e3d5103e85811a1753cd128b47dbdc64', './lib/core/Perms/Check/Fixed.php', '28.4', 0),
('41e3520d6ed3c2b86cc2b09fa1c7fd83', './lib/core/Perms/Check/Indirect.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Perms/Check/index.php', '28.4', 0),
('8527ed8dc7175344ae85a10ca9916616', './lib/core/Perms/Context.php', '28.4', 0),
('bbd854d6e4fb539820b5cf8f16b36a8b', './lib/core/Perms/Reflection/Category.php', '28.4', 0),
('3f49e8f5006a4e57e091efcbe5a3d03d', './lib/core/Perms/Reflection/Container.php', '28.4', 0),
('0a13ebce5e47f4de0f970e075563ed82', './lib/core/Perms/Reflection/Factory.php', '28.4', 0),
('4ad65d07b76c5dc86354645da2ac3e0e', './lib/core/Perms/Reflection/Global.php', '28.4', 0),
('97d3967832eb4b6f954ea51ce7d69de1', './lib/core/Perms/Reflection/Object.php', '28.4', 0),
('4f2154d5f2e8dd667424df49d9347486', './lib/core/Perms/Reflection/PermissionComparator.php', '28.4', 0),
('a96715d576dead971a917ed8ddd42a70', './lib/core/Perms/Reflection/PermissionSet.php', '28.4', 0),
('357260ec51f5966291aad3f7d78d4664', './lib/core/Perms/Reflection/Quick.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Perms/Reflection/index.php', '28.4', 0),
('5eddd1e457f0550d610bb46b77a6423b', './lib/core/Perms/Resolver.php', '28.4', 0),
('f23a905cb11d283c1d07eb5c57a3562e', './lib/core/Perms/Resolver/Default.php', '28.4', 0),
('504e95c0b834a9f23838d120059cd760', './lib/core/Perms/Resolver/Static.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Perms/Resolver/index.php', '28.4', 0),
('b67a69c720f86b5d6b1c8271154f2555', './lib/core/Perms/ResolverFactory.php', '28.4', 0),
('81f47767f2a7e9b5e441e155fe93f007', './lib/core/Perms/ResolverFactory/CategoryFactory.php', '28.4', 0),
('0ec9c26be853a264f8b912b8346e53b2', './lib/core/Perms/ResolverFactory/GlobalFactory.php', '28.4', 0),
('a894fc2007bfb6c1ef285f6222f277a1', './lib/core/Perms/ResolverFactory/ObjectFactory.php', '28.4', 0),
('046f35111347fdb5a3b13c062f59d92f', './lib/core/Perms/ResolverFactory/StaticFactory.php', '28.4', 0),
('30d617246f4191d7723d344a6a9a39d1', './lib/core/Perms/ResolverFactory/TestFactory.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Perms/ResolverFactory/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Perms/index.php', '28.4', 0),
('9a659186d4e1852e0dc12338b6c83be9', './lib/core/RSS/CustomEntryField.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/RSS/index.php', '28.4', 0),
('b8c7c032f21f54821c37b96b932a07ae', './lib/core/Realtime/Chat.php', '28.4', 0),
('6049e6fdb6dbbaa4715bc9c407c1045a', './lib/core/Realtime/Console.php', '28.4', 0),
('3dba60736ec16df8cc082635db0ad5ae', './lib/core/Realtime/IotDashboardNotifier.php', '28.4', 0),
('40fc17115dd6366ea8974d33ba5f2fcb', './lib/core/Realtime/Ping.php', '28.4', 0),
('42e9f2172af84eb11c225354cb781cc9', './lib/core/Realtime/SessionAwareApp.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Realtime/index.php', '28.4', 0),
('de3a00f266396b03b38b5265ed83903a', './lib/core/Reports/Cache.php', '28.4', 0),
('bbc82bf0629ec0dbeafe7ad89d390ddf', './lib/core/Reports/Factory.php', '28.4', 0),
('368429a50f0c9e2623eb6188c8bd198c', './lib/core/Reports/Manager.php', '28.4', 0),
('11d7cf8e0b2becff4a2aa721397a9305', './lib/core/Reports/Send.php', '28.4', 0),
('40488bdb3f06104dbdab531d41c31aaa', './lib/core/Reports/Send/EmailBuilder.php', '28.4', 0),
('1aff14c32f8fae64f849bbf2d36862a5', './lib/core/Reports/Send/EmailBuilder/Abstract.php', '28.4', 0),
('63257cca56ef9394fa0e15ef0e592910', './lib/core/Reports/Send/EmailBuilder/ArticleDeleted.php', '28.4', 0),
('48f454e45bad4ddbf9a1e79a5ee1ea60', './lib/core/Reports/Send/EmailBuilder/ArticleEdited.php', '28.4', 0),
('9d3dded8d8201295bdda24459001022c', './lib/core/Reports/Send/EmailBuilder/ArticleSubmitted.php', '28.4', 0),
('5510c84d7a3e52d977955997174e1eeb', './lib/core/Reports/Send/EmailBuilder/BlogPost.php', '28.4', 0),
('501e7d1d1e9ea3778a2314661c125014', './lib/core/Reports/Send/EmailBuilder/CalendarChanged.php', '28.4', 0),
('18c74823ccd3425f74234d05ecabf5fa', './lib/core/Reports/Send/EmailBuilder/CategoryChanged.php', '28.4', 0),
('23a5635b9d8ea20cd95cf4dedcffdc2d', './lib/core/Reports/Send/EmailBuilder/Factory.php', '28.4', 0),
('20918f244c9420f3641ff3524ed43250', './lib/core/Reports/Send/EmailBuilder/FileGalleryChanged.php', '28.4', 0),
('49dcf4d289eb91e02460ba45b484dc4a', './lib/core/Reports/Send/EmailBuilder/ForumPostThread.php', '28.4', 0),
('b01525f7d8dcd819a5f1ccf99ecd5c90', './lib/core/Reports/Send/EmailBuilder/ForumPostTopic.php', '28.4', 0),
('483882b06b6e3df20e4713af0048d216', './lib/core/Reports/Send/EmailBuilder/StructureAdd.php', '28.4', 0),
('3a3502101ee3887e00ea629419a7dfc3', './lib/core/Reports/Send/EmailBuilder/StructureMoveDown.php', '28.4', 0),
('7e5c89b2f34be68e12ccc2052313c6be', './lib/core/Reports/Send/EmailBuilder/StructureMoveUp.php', '28.4', 0),
('219d4c4131d192530b41a8aa046ae61d', './lib/core/Reports/Send/EmailBuilder/StructureRemove.php', '28.4', 0),
('b3b05a37503990456cd8bef4117741b5', './lib/core/Reports/Send/EmailBuilder/TrackerFileAttachment.php', '28.4', 0),
('1a9411412c21230fd1973686dd419c22', './lib/core/Reports/Send/EmailBuilder/TrackerItemComment.php', '28.4', 0),
('f26a8a9b41f8c32a44ca0a4fa6b4a328', './lib/core/Reports/Send/EmailBuilder/TrackerItemModified.php', '28.4', 0),
('a13dbefb01f7893862910bf3e5e71a2f', './lib/core/Reports/Send/EmailBuilder/WikiFileAttached.php', '28.4', 0),
('6f18ee0d9e699f23f35764bf7242d9cb', './lib/core/Reports/Send/EmailBuilder/WikiPageChanged.php', '28.4', 0),
('69db4b15f82b9c39fc84addeab576823', './lib/core/Reports/Send/EmailBuilder/WikiPageCreated.php', '28.4', 0),
('f3be213925f1bca8dde332cc06cb332c', './lib/core/Reports/Send/EmailBuilder/WikiPageDeleted.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Reports/Send/EmailBuilder/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Reports/Send/index.php', '28.4', 0),
('e3c4d62f7f3c03ff1280946e9f8b16ae', './lib/core/Reports/Users.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Reports/index.php', '28.4', 0),
('9c8aa4f39b321afd929f4bcb762ce7ce', './lib/core/Scheduler/Exception/CrontimeFormatException.php', '28.4', 0),
('e81c5938faf0081e818a576206348bab', './lib/core/Scheduler/Exception/Exception.php', '28.4', 0),
('4c18cecfce87ead28f07193e7e6edfa6', './lib/core/Scheduler/Exception/TaskParamException.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Scheduler/Exception/index.php', '28.4', 0),
('5b90259bcf621e40dfb3fed916f56491', './lib/core/Scheduler/Item.php', '28.4', 0),
('0a887935f672a2ff9159ff881edad29e', './lib/core/Scheduler/Manager.php', '28.4', 0),
('a5eaf4ba94a5f2795edf019cd2fdec12', './lib/core/Scheduler/Output/SchedulerRunOutput.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Scheduler/Output/index.php', '28.4', 0),
('249be692856dce8b1e4fd39884627deb', './lib/core/Scheduler/Task/CommandTask.php', '28.4', 0),
('5fcbd48bc56d433c48e2df7c4fa40aaa', './lib/core/Scheduler/Task/ConsoleCommandTask.php', '28.4', 0),
('50cd16d26f8914264d0ec175b9961023', './lib/core/Scheduler/Task/HTTPGetCommandTask.php', '28.4', 0),
('fb0fb2cd063560235153aab255c794cd', './lib/core/Scheduler/Task/ShellCommandTask.php', '28.4', 0),
('269605d5fdde076bdee85cbf1f4dd0f4', './lib/core/Scheduler/Task/TikiCheckerCommandTask.php', '28.4', 0),
('33690df427e19a10b782005471d32d28', './lib/core/Scheduler/Task/UserLockMailerCommandTask.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Scheduler/Task/index.php', '28.4', 0),
('a64107b757942c8089f2c3dc14bd939e', './lib/core/Scheduler/Utils.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Scheduler/index.php', '28.4', 0),
('ac7e78acc7d7479dfddae3077162f92b', './lib/core/Search/Action/Action.php', '28.4', 0),
('47eb3417f616beef2e015fe0d77ac999', './lib/core/Search/Action/ActionStep.php', '28.4', 0),
('1bfb0ca0ee30afa47f571c8b28fa0c24', './lib/core/Search/Action/CategorizeObjectAction.php', '28.4', 0),
('d9dcfd06b7c12aa06fff7fc345763fa9', './lib/core/Search/Action/ChangeStatusAction.php', '28.4', 0),
('cbb4e9833597b886265fe9cd39f63b1a', './lib/core/Search/Action/DataChannel.php', '28.4', 0),
('6c50098efc9c9f22f3419abdc1aea2db', './lib/core/Search/Action/Delete.php', '28.4', 0),
('03e2aed1bc07d7eaafb6bcec70d35bdb', './lib/core/Search/Action/EmailAction.php', '28.4', 0),
('9b13c762e61e8610b3b8b2ec699bf3a5', './lib/core/Search/Action/Exception.php', '28.4', 0),
('d1d623087e1ec2553bf3b54b3cff97d8', './lib/core/Search/Action/Factory.php', '28.4', 0),
('1cc46d8b28841df51d4c61b61e357ee7', './lib/core/Search/Action/FileGalleryChangeFilename.php', '28.4', 0),
('21cc2e11a074465a4e6e88c5fb237081', './lib/core/Search/Action/FileGalleryImageOverlay.php', '28.4', 0),
('526251976a41f1b698b461ad187f6abe', './lib/core/Search/Action/ReportingTransform.php', '28.4', 0),
('10a9a420fd3b5471397ef9fe15b6d89e', './lib/core/Search/Action/Sequence.php', '28.4', 0),
('ca40ee5a1465594317ca3a06bc53dd63', './lib/core/Search/Action/Snapshot.php', '28.4', 0),
('c2e952cd378b138810871b4401c9d48a', './lib/core/Search/Action/Step.php', '28.4', 0),
('36ef2fc2dcaa1760dbcaa3d64314e4b5', './lib/core/Search/Action/TrackerItemClone.php', '28.4', 0),
('9ee34c60a510c8247e9928f03418c5b4', './lib/core/Search/Action/TrackerItemInsert.php', '28.4', 0),
('73f4f660fede68741fbcaedcf86c0814', './lib/core/Search/Action/TrackerItemModify.php', '28.4', 0),
('3fe87394462c1174b99fbad54d957869', './lib/core/Search/Action/UnknownStep.php', '28.4', 0),
('69c34d26b8da1a04b88579779005c75a', './lib/core/Search/Action/UserGroupModify.php', '28.4', 0),
('9cd382c07297d92cb6b4c3c49cf52ea1', './lib/core/Search/Action/WikiApprovalAction.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Action/index.php', '28.4', 0),
('96d1cf921b957787e1305678aca69b7b', './lib/core/Search/ContentFilter/VersionNumber.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/ContentFilter/index.php', '28.4', 0),
('5496195bd266f4959aa6d92959564bc6', './lib/core/Search/ContentSource/ActivityStreamSource.php', '28.4', 0),
('c0621809f1269323b7a8b6d9333c5c77', './lib/core/Search/ContentSource/ArticleSource.php', '28.4', 0),
('6cc665c7df04498e30adead24b0ac910', './lib/core/Search/ContentSource/BlogPostSource.php', '28.4', 0),
('01ca4395f546762394d4f5276f9e9b65', './lib/core/Search/ContentSource/BlogSource.php', '28.4', 0),
('e3d658acf8cd272fe2725fa829862ebb', './lib/core/Search/ContentSource/CalendarItemSource.php', '28.4', 0),
('5d3494fa7dafbea86dc66c3b0f53cce4', './lib/core/Search/ContentSource/CalendarSource.php', '28.4', 0),
('9014129238324f0f3619a6e58f5048c4', './lib/core/Search/ContentSource/CategorySource.php', '28.4', 0),
('accd39509730106bffb2b4b75040dce4', './lib/core/Search/ContentSource/CommentSource.php', '28.4', 0),
('301d1d61707501abbbd7c7b69c4105e6', './lib/core/Search/ContentSource/CreditSource.php', '28.4', 0),
('8fb650ee6e5ce82509543a50f5d1987d', './lib/core/Search/ContentSource/FileGallerySource.php', '28.4', 0),
('f1748f7767bec2cd80f66e12fab83e79', './lib/core/Search/ContentSource/FileSource.php', '28.4', 0),
('bd724ffb457e68b86f74639a75f0a191', './lib/core/Search/ContentSource/ForumPostSource.php', '28.4', 0),
('4ce3974bd96387c15001bdfcd61eb01f', './lib/core/Search/ContentSource/ForumSource.php', '28.4', 0),
('bbeef721b17bbd699f1169278e98c737', './lib/core/Search/ContentSource/GoalEventSource.php', '28.4', 0),
('92d74aebaaea7d6c1e2843ce7abbc3af', './lib/core/Search/ContentSource/GoalSource.php', '28.4', 0),
('d49374bf150b1f2f8e6cc27389870721', './lib/core/Search/ContentSource/GroupSource.php', '28.4', 0),
('22e5a992606864f6144388698580c6ba', './lib/core/Search/ContentSource/Interface.php', '28.4', 0),
('272f322b3268fa810c7ba1ba1f27241d', './lib/core/Search/ContentSource/SheetSource.php', '28.4', 0),
('efcf6959c820086fc3192393cc88b418', './lib/core/Search/ContentSource/Static.php', '28.4', 0),
('566bcb6f7a1105f25bd7977fb8aa8a1f', './lib/core/Search/ContentSource/SurveySource.php', '28.4', 0),
('ea6719940d20263ee4e7535deeba2e59', './lib/core/Search/ContentSource/TrackerFieldSource.php', '28.4', 0),
('e367964effc7080ecaf3d951bbdea094', './lib/core/Search/ContentSource/TrackerItemSource.php', '28.4', 0),
('4fa22e1d41b7bb314ff94949e375b66b', './lib/core/Search/ContentSource/TrackerSource.php', '28.4', 0),
('020b0111a4e4e9e54a79a768fa64c4ca', './lib/core/Search/ContentSource/UserSource.php', '28.4', 0),
('48036f1aef92fe9d971ee2d6fa53de54', './lib/core/Search/ContentSource/WebserviceSource.php', '28.4', 0),
('6cfbf5c2a35ff4d0a45df7347ebee80e', './lib/core/Search/ContentSource/WikiSource.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/ContentSource/index.php', '28.4', 0),
('8d18565c09a503c6c4a10c6bf4577b3a', './lib/core/Search/Elastic/BulkOperation.php', '28.4', 0),
('816ffff3d7f4fcd7fc05a2afee279b21', './lib/core/Search/Elastic/Connection.php', '28.4', 0),
('be371f1fafbbdf92785576f6b3b8dcc2', './lib/core/Search/Elastic/ElasticSearchIndexManager.php', '28.4', 0),
('bf0f3df1e856e98fbeb632bd029a377a', './lib/core/Search/Elastic/Exception.php', '28.4', 0),
('6db1f835044c273f8dd96cc7696665a6', './lib/core/Search/Elastic/FacetBuilder.php', '28.4', 0),
('670b513edcd150fbdbb758ed9b9cf463', './lib/core/Search/Elastic/FacetReader.php', '28.4', 0),
('9d1021fa47390ebfa47d7439b8b778ea', './lib/core/Search/Elastic/Index.php', '28.4', 0),
('0195c5f44086c6af8ac1a70a99b7492d', './lib/core/Search/Elastic/MappingException.php', '28.4', 0),
('435a679ae2b402d2f6add6d7266851b6', './lib/core/Search/Elastic/NotFoundException.php', '28.4', 0),
('edf21873840d7c95a218bf97d2d1495d', './lib/core/Search/Elastic/NumberFormatException.php', '28.4', 0),
('aa80c5511ae241c7f7633ada345965d2', './lib/core/Search/Elastic/OrderBuilder.php', '28.4', 0),
('10206da775907c42f9db7e67b218d5df', './lib/core/Search/Elastic/Prefilter.php', '28.4', 0),
('74e87cb6008b7acbefc70b9b67425cab', './lib/core/Search/Elastic/QueryBuilder.php', '28.4', 0),
('24c5be47c123a0c18da103c99e28fc9b', './lib/core/Search/Elastic/QueryParsingException.php', '28.4', 0),
('d4d68de44ad5519d9913048b06e498c0', './lib/core/Search/Elastic/RescoreQueryBuilder.php', '28.4', 0),
('24df27199c96c5df43964ed2224f6200', './lib/core/Search/Elastic/ResultSet.php', '28.4', 0),
('06a9a7fdbb06defff0387a1f8585d740', './lib/core/Search/Elastic/SortException.php', '28.4', 0),
('fe3a80a14535ae23b19de9287752306d', './lib/core/Search/Elastic/TransportException.php', '28.4', 0),
('72bc4b8a5a1d77de0626d24ca85b43e0', './lib/core/Search/Elastic/TypeFactory.php', '28.4', 0),
('a59e5a457c9dcee6d8b667a4bf2d1f1e', './lib/core/Search/EngineResult/Elastic.php', '28.4', 0),
('48a748a3d52c49529ff4fd7d2aa2633a', './lib/core/Search/EngineResult/Interface.php', '28.4', 0),
('9a350a59d8d7eb4c630134564adc4c5e', './lib/core/Search/EngineResult/Manticore.php', '28.4', 0),
('9c7df68d6a3bb273a9a740916787077b', './lib/core/Search/EngineResult/MySQL.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/EngineResult/index.php', '28.4', 0),
('93472c78c316a397695741c6a37f5c6d', './lib/core/Search/Exception.php', '28.4', 0),
('0b840114581fc5c1f54c0d0e4eba6ee1', './lib/core/Search/Expr/And.php', '28.4', 0),
('347f743dd3f508946bbc83f7883c17d7', './lib/core/Search/Expr/Distance.php', '28.4', 0),
('461f10ad7c6d925b107cf1189477813b', './lib/core/Search/Expr/ExplicitPhrase.php', '28.4', 0),
('e06bdf0415d70444a83ef511b6f70caa', './lib/core/Search/Expr/ImplicitPhrase.php', '28.4', 0),
('dd74028cfe1b0547ff650ec09b5dd0da', './lib/core/Search/Expr/Initial.php', '28.4', 0),
('d8d45fca5e975bee6daa0007d06132e0', './lib/core/Search/Expr/Interface.php', '28.4', 0),
('9892157659caeab0c01ab1a49f5350fa', './lib/core/Search/Expr/MoreLikeThis.php', '28.4', 0),
('22732e57e9292f75a53186d285b65c2f', './lib/core/Search/Expr/Not.php', '28.4', 0),
('47eb44f8232427189fae928b6327fb6b', './lib/core/Search/Expr/Or.php', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('ec1ebe15dc63b509dcf518035d8026e9', './lib/core/Search/Expr/Parser.php', '28.4', 0),
('0d05351aad25d2dbcb9987a8e172ac72', './lib/core/Search/Expr/Range.php', '28.4', 0),
('a680ebd68887bae42dacf387f4cc606e', './lib/core/Search/Expr/Token.php', '28.4', 0),
('e07237d783c00c4a2a21fd0db0fc98db', './lib/core/Search/Expr/Tokenizer.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Expr/index.php', '28.4', 0),
('08a518e416f2ce21477aa8635222d784', './lib/core/Search/FacetProvider.php', '28.4', 0),
('9e6557e47071222ad8a1da0ed9267fe2', './lib/core/Search/FacetProvider/Interface.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/FacetProvider/index.php', '28.4', 0),
('91e0c13323f00874dcc060b8df426d2f', './lib/core/Search/Federated/CompilerPass.php', '28.4', 0),
('71fa4717f0c53f847780507f4538297a', './lib/core/Search/Federated/IndexInterface.php', '28.4', 0),
('a7a6409fa6dd297476e8edc78fd50955', './lib/core/Search/Federated/ManifoldCfIndex.php', '28.4', 0),
('5a64f6dc8bf33367750c43165ade1911', './lib/core/Search/Federated/TikiIndex.php', '28.4', 0),
('faa8d78b5af0ebaedf921dded5fda417', './lib/core/Search/Federated/UrlPrefixTransform.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Federated/index.php', '28.4', 0),
('232cad379fabfd3025743972dfc0f4a7', './lib/core/Search/Formatter.php', '28.4', 0),
('9dec925fd160fb38a54976b9a30ebfcb', './lib/core/Search/Formatter/AppendPagination.php', '28.4', 0),
('719bf38e77dc4dd40f1bf631c2207363', './lib/core/Search/Formatter/ArrayBuilder.php', '28.4', 0),
('f74402efa18f0bdedf239340c9f0679f', './lib/core/Search/Formatter/Builder.php', '28.4', 0),
('302d9a2270509585ee9e25196099dc21', './lib/core/Search/Formatter/DataSource/Declarative.php', '28.4', 0),
('26fe53f0032ec8c9474493a52bfe9343', './lib/core/Search/Formatter/DataSource/Interface.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Formatter/DataSource/index.php', '28.4', 0),
('ef250bceed06904823334dc2ec6c4026', './lib/core/Search/Formatter/Factory.php', '28.4', 0),
('5a4bda97a4982860c12475ecf0322052', './lib/core/Search/Formatter/Plugin/AbstractTableTemplate.php', '28.4', 0),
('2ad5c0e5910c341f98ce213e1ffda8f5', './lib/core/Search/Formatter/Plugin/ArrayTemplate.php', '28.4', 0),
('bb86d2bd24872a9867f4240a3e408c61', './lib/core/Search/Formatter/Plugin/CsvTemplate.php', '28.4', 0),
('8304cc3e77bdc43369b98f767bb7326b', './lib/core/Search/Formatter/Plugin/Interface.php', '28.4', 0),
('2231c98b698d8e4c2d2d12f9cfda4ba2', './lib/core/Search/Formatter/Plugin/ReportTemplate.php', '28.4', 0),
('7a5c7f0fb788338ca50a30d2ba405243', './lib/core/Search/Formatter/Plugin/SmartyTemplate.php', '28.4', 0),
('25f2028ba5e537075bc796026fef0314', './lib/core/Search/Formatter/Plugin/Sublist.php', '28.4', 0),
('0c61bf1ec4320217b1da72ee0255558c', './lib/core/Search/Formatter/Plugin/WikiTemplate.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Formatter/Plugin/index.php', '28.4', 0),
('21312a1c5927e92bb4e1f28d996fbd14', './lib/core/Search/Formatter/Sublist/Exception.php', '28.4', 0),
('1df60e7d87d30bcc3632f7012ea40e89', './lib/core/Search/Formatter/Sublist/Executor.php', '28.4', 0),
('3cef6204eb75faa84d96d84c79d1194c', './lib/core/Search/Formatter/Sublist/Parser.php', '28.4', 0),
('f082b0e76320f23ad86be5f60546488f', './lib/core/Search/Formatter/Sublist/Record.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Formatter/Sublist/index.php', '28.4', 0),
('7c6bc7651cc8774da00b7fba9b0303b3', './lib/core/Search/Formatter/Transform/DynamicLoader.php', '28.4', 0),
('c76bd1ce9fddf81113f85074e7c88ac7', './lib/core/Search/Formatter/Transform/FieldPermissionEnforcer.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Formatter/Transform/index.php', '28.4', 0),
('f681e6522bca5eca93596be6070bb83a', './lib/core/Search/Formatter/ValueFormatter.php', '28.4', 0),
('1e67cf954da014110f351ff712f3c1e9', './lib/core/Search/Formatter/ValueFormatter/Abstract.php', '28.4', 0),
('d425f8fffc983f8ec3fc2b04654c373a', './lib/core/Search/Formatter/ValueFormatter/Categorylist.php', '28.4', 0),
('00c692b0f87055359ec473d3ebf09615', './lib/core/Search/Formatter/ValueFormatter/Count.php', '28.4', 0),
('99186d3ae7d82d7e645a6b11ff578d69', './lib/core/Search/Formatter/ValueFormatter/Currency.php', '28.4', 0),
('550e84d85413ed2a505c9b6e11ad40ba', './lib/core/Search/Formatter/ValueFormatter/Date.php', '28.4', 0),
('35d2d12438f929f1ca430535963a5bb6', './lib/core/Search/Formatter/ValueFormatter/Datetime.php', '28.4', 0),
('e2ae3137c1d188d9290e6b12fa2957ad', './lib/core/Search/Formatter/ValueFormatter/Imagegrabber.php', '28.4', 0),
('5a62adfde5d5604eb8c40149c49e25c7', './lib/core/Search/Formatter/ValueFormatter/Interface.php', '28.4', 0),
('3bcc62131dcd48b3b9ad8a0cfe6f6cce', './lib/core/Search/Formatter/ValueFormatter/Number.php', '28.4', 0),
('964a6faee7f3c65f22db873a921efa5d', './lib/core/Search/Formatter/ValueFormatter/Objectlink.php', '28.4', 0),
('6abd406f69f6bb5e95c20f5d59d71426', './lib/core/Search/Formatter/ValueFormatter/Plain.php', '28.4', 0),
('3ee3854757a21f68f241e1db487eb443', './lib/core/Search/Formatter/ValueFormatter/Reference.php', '28.4', 0),
('79f2c653cc87c748ea4340055bd43fed', './lib/core/Search/Formatter/ValueFormatter/Slug.php', '28.4', 0),
('980766c9d69305c46dea29bebe131b57', './lib/core/Search/Formatter/ValueFormatter/Snippet.php', '28.4', 0),
('633c66fc057249271db722ddbe9b6cd6', './lib/core/Search/Formatter/ValueFormatter/Sorthandle.php', '28.4', 0),
('5cc35de3f5f2f419a65bdba31c323f54', './lib/core/Search/Formatter/ValueFormatter/Templaterender.php', '28.4', 0),
('213b8ff9776023b85de3b50903a7fb51', './lib/core/Search/Formatter/ValueFormatter/Timeago.php', '28.4', 0),
('b3e69818ef58aae70be2853ffe4fccc4', './lib/core/Search/Formatter/ValueFormatter/Trackerrender.php', '28.4', 0),
('0bb428079fda611f299d34fc34610c3f', './lib/core/Search/Formatter/ValueFormatter/Url.php', '28.4', 0),
('1999673312a81598d25abdd92c59e5b1', './lib/core/Search/Formatter/ValueFormatter/Urlencode.php', '28.4', 0),
('840e197c14dabf97bac56144d37ac2d3', './lib/core/Search/Formatter/ValueFormatter/Userlist.php', '28.4', 0),
('1a1aef113779822fdacec1c7eae49709', './lib/core/Search/Formatter/ValueFormatter/Wikiplugin.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Formatter/ValueFormatter/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Formatter/index.php', '28.4', 0),
('2ee7a97976f47e830e159fa24f0bde77', './lib/core/Search/GlobalSource/AdvancedRatingSource.php', '28.4', 0),
('8cdc11d0c6d94d5c453503ec85a59059', './lib/core/Search/GlobalSource/ArticleAttachmentSource.php', '28.4', 0),
('ce7a26b9b5ab742ebfb2fef54d135a69', './lib/core/Search/GlobalSource/CategorySource.php', '28.4', 0),
('17d1af2aeaf585fde6d216753ff42c6b', './lib/core/Search/GlobalSource/CommentSource.php', '28.4', 0),
('62b44aeaece2765b4055cfa2f95b92c5', './lib/core/Search/GlobalSource/FileAttachmentSource.php', '28.4', 0),
('a689f949b5c2411b5d7562df03d2a4e5', './lib/core/Search/GlobalSource/FreeTagSource.php', '28.4', 0),
('d368d5f1b8d50850e99a92809ef853e0', './lib/core/Search/GlobalSource/Geolocation.php', '28.4', 0),
('a0a4e4924f051c419c0d07285afd251f', './lib/core/Search/GlobalSource/IndexNameSource.php', '28.4', 0),
('aea70b381a47e9d09a48092ef0ceeb61', './lib/core/Search/GlobalSource/Interface.php', '28.4', 0),
('eb18be7436113a7b51680ac84a857607', './lib/core/Search/GlobalSource/PermissionSource.php', '28.4', 0),
('8d3d657b1d1d8ec68fdb1801feb99f58', './lib/core/Search/GlobalSource/RelationSource.php', '28.4', 0),
('d22b283ab9ed320b088c01114be16e34', './lib/core/Search/GlobalSource/SearchableSource.php', '28.4', 0),
('ae5a0cc25ede0e766861b5515c9eee13', './lib/core/Search/GlobalSource/SocialSource.php', '28.4', 0),
('52a912ba2bf6f263d1f98ad56299635d', './lib/core/Search/GlobalSource/Static.php', '28.4', 0),
('5993e15e51373841372c5cbfbef1ce55', './lib/core/Search/GlobalSource/TitleInitialSource.php', '28.4', 0),
('904fc47e32ab0aea3dbb45cf34d71ec1', './lib/core/Search/GlobalSource/UrlSource.php', '28.4', 0),
('7a3b4080804e54b543aa40c5b806f416', './lib/core/Search/GlobalSource/VisitsSource.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/GlobalSource/index.php', '28.4', 0),
('6284200ad6deee99d67b07c0b2a14c9a', './lib/core/Search/Index/AbstractIndexDecorator.php', '28.4', 0),
('3f6571c404f57eab9291807bbe375543', './lib/core/Search/Index/CategoryFilterDecorator.php', '28.4', 0),
('02db09956dccbca62243e788d07b45f0', './lib/core/Search/Index/Cypht.php', '28.4', 0),
('48f6b9724affbab148ae7eb4549f638d', './lib/core/Search/Index/Interface.php', '28.4', 0),
('577e03c3eb195adfdf085db972a4c41a', './lib/core/Search/Index/Memory.php', '28.4', 0),
('7656632740d69f2269f5df3e5aa727dd', './lib/core/Search/Index/QueryAlertDecorator.php', '28.4', 0),
('df3eb79a2772346966d5183dff725f62', './lib/core/Search/Index/QueryRepository.php', '28.4', 0),
('87a06ab67cb2f4834a217dd09b7a7d93', './lib/core/Search/Index/TypeAnalysisDecorator.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Index/index.php', '28.4', 0),
('11ea2cb69d89cc3a212ca5610835c4c2', './lib/core/Search/Indexer.php', '28.4', 0),
('bf77c92275362eb9a6316e37ab4e657f', './lib/core/Search/Manticore/Client.php', '28.4', 0),
('2a40fd8182ad153384294adcb5668d1b', './lib/core/Search/Manticore/ClientException.php', '28.4', 0),
('8501cb9ece77d1ba01bfb64bc10f4921', './lib/core/Search/Manticore/Decorator.php', '28.4', 0),
('c248c0849b1fcfac461961fb59af23e3', './lib/core/Search/Manticore/Exception.php', '28.4', 0),
('de5aa49d5d3fae6eab1109b2413cda1b', './lib/core/Search/Manticore/FacetBuilder.php', '28.4', 0),
('ce16eb36b9e347ba230ab051321d945a', './lib/core/Search/Manticore/FacetDecorator.php', '28.4', 0),
('e0fd5a7398b7169318a0d9bb7303b561', './lib/core/Search/Manticore/FacetReader.php', '28.4', 0),
('e00d68ca6bba56122ec24928764bb25e', './lib/core/Search/Manticore/FatalException.php', '28.4', 0),
('7ece82907427844c0e1175fea509ebbd', './lib/core/Search/Manticore/Index.php', '28.4', 0),
('b5b78d0647de3bfd5fde93758bd88bd7', './lib/core/Search/Manticore/ManticoreSearchIndexManager.php', '28.4', 0),
('3e769b25260ae4f38ae175a16a55fbcd', './lib/core/Search/Manticore/OrderBuilder.php', '28.4', 0),
('71d3a869f63f9aecfe2578c802ff1640', './lib/core/Search/Manticore/OrderDecorator.php', '28.4', 0),
('770a71fac74558d325760b9e7970734b', './lib/core/Search/Manticore/PdoClient.php', '28.4', 0),
('461fcd118e2ece139f7404f91150ea00', './lib/core/Search/Manticore/Prefilter.php', '28.4', 0),
('a21d5fbc45574cc4a5547bc3c0fc1077', './lib/core/Search/Manticore/QueryBuffer.php', '28.4', 0),
('baffd3bc07bb4f8edd49cd3c8a52c429', './lib/core/Search/Manticore/QueryBuilder.php', '28.4', 0),
('30a16415aa469362f294b68b5b627d91', './lib/core/Search/Manticore/QueryDecorator.php', '28.4', 0),
('a2da98cef828efae8be6902ad0dc5dcf', './lib/core/Search/Manticore/ResultSet.php', '28.4', 0),
('8e845970f44340c09473a74045c778ff', './lib/core/Search/Manticore/TypeFactory.php', '28.4', 0),
('aaa4e182c4b36e7427cb3eea4fe6adbb', './lib/core/Search/MySql/Exception.php', '28.4', 0),
('2ee61fce436b03d9730dd29cccaca89e', './lib/core/Search/MySql/FieldQueryBuilder.php', '28.4', 0),
('17b9260943031e755c65786ea2a85b72', './lib/core/Search/MySql/HighlightHelper.php', '28.4', 0),
('66c86cd4942b70e83309a052924d1cbe', './lib/core/Search/MySql/Index.php', '28.4', 0),
('fcea9df24cc048e53d40ddca97cecdf6', './lib/core/Search/MySql/LimitReachedException.php', '28.4', 0),
('e53a4e5a3e8b368c4877980e8e6f0bd1', './lib/core/Search/MySql/MysqlSearchIndexManager.php', '28.4', 0),
('1124b043b297a9f4027b19a65d4d2dab', './lib/core/Search/MySql/Prefilter.php', '28.4', 0),
('46f4df4ee193b0dd346ed6cc01ff1b94', './lib/core/Search/MySql/QueryBuffer.php', '28.4', 0),
('35d9dfb543ee991afde1e1a9fc68c082', './lib/core/Search/MySql/QueryBuilder.php', '28.4', 0),
('35ad8a14c50f2256305cb28f8d48d35d', './lib/core/Search/MySql/QueryException.php', '28.4', 0),
('66ec9bcb05e2843f09356b3605f529e6', './lib/core/Search/MySql/Table.php', '28.4', 0),
('ebcb0aed5b7b98f387e5f3c564ae25a0', './lib/core/Search/MySql/TrackerFieldTranslator.php', '28.4', 0),
('bd60e00102a06bb614717a9aa21759da', './lib/core/Search/MySql/TypeFactory.php', '28.4', 0),
('88c907131e7a1b8d15a78feb86721070', './lib/core/Search/PackageSource/Interface.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/PackageSource/index.php', '28.4', 0),
('495ee15286ac6465e21a653ce150c415', './lib/core/Search/Query.php', '28.4', 0),
('09cee594077490f87ea246c79e8fcb76', './lib/core/Search/Query/Facet/Abstract.php', '28.4', 0),
('b0983d55709acd5c5e0cbd033d3891cb', './lib/core/Search/Query/Facet/DateHistogram.php', '28.4', 0),
('d9befc8aea208259f9bd8fa1f59b6889', './lib/core/Search/Query/Facet/DateRange.php', '28.4', 0),
('cac0756a32e45ba5d3476e0a4a8d92eb', './lib/core/Search/Query/Facet/Interface.php', '28.4', 0),
('d0ebf4bb370183deaad92dbe632b9941', './lib/core/Search/Query/Facet/Term.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Query/Facet/index.php', '28.4', 0),
('8f74dd5e8c89bde149dc04e8aa1cee90', './lib/core/Search/Query/FacetWikiBuilder.php', '28.4', 0),
('bfbf78786813d174a5d024a34b935f8c', './lib/core/Search/Query/Interface.php', '28.4', 0),
('79dad27ff0f59e6b40c0ff6295edbb26', './lib/core/Search/Query/Order.php', '28.4', 0),
('4eade15aca654ebc92222b578263fb88', './lib/core/Search/Query/OrderClause.php', '28.4', 0),
('a0fba675f0630b9f420f16d3a4b10217', './lib/core/Search/Query/Relation.php', '28.4', 0),
('91f5f8ddd42389eaa657c064ec4263a4', './lib/core/Search/Query/RelationReplacer.php', '28.4', 0),
('c48677d9e2005b75f6aee2c50dfdaa5d', './lib/core/Search/Query/WeightCalculator/Field.php', '28.4', 0),
('461e770e16e8c77ac5b030721b8c27a3', './lib/core/Search/Query/WeightCalculator/Interface.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Query/WeightCalculator/index.php', '28.4', 0),
('a5cb153cd77eaa6c83e819d416cd0f2c', './lib/core/Search/Query/WikiBuilder.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Query/index.php', '28.4', 0),
('b0cda1151d9d2dad718bd42f6d86e1c4', './lib/core/Search/ResultSet.php', '28.4', 0),
('751aa24d64f156ca75060441e97b3df1', './lib/core/Search/ResultSet/FacetFilter.php', '28.4', 0),
('cf2f95b102f9d623412285473c8c5ccd', './lib/core/Search/ResultSet/SnippetHelper.php', '28.4', 0),
('76066c0039a6646003361a3f85a7b0b8', './lib/core/Search/ResultSet/UrlHighlightTermsTransform.php', '28.4', 0),
('4a920c5e287ea00209f7956a37801266', './lib/core/Search/ResultSet/WikiBuilder.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/ResultSet/index.php', '28.4', 0),
('50f3491044391f1ad946e82ceaabb3ac', './lib/core/Search/Type/Analyzer.php', '28.4', 0),
('c59cdb35b61ee749a693884f4923862c', './lib/core/Search/Type/DateTime.php', '28.4', 0),
('0b00194323c0293e4f71be2eb5151bfc', './lib/core/Search/Type/Factory/Direct.php', '28.4', 0),
('ccb2345d6fce32570f51b61f644fc513', './lib/core/Search/Type/Factory/Interface.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Search/Type/Factory/index.php', '28.4', 0),
('948fa3ad2e4b4180d9e3ef47a5ac67f2', './lib/core/Search/Type/GeoPoint.php', '28.4', 0),
('92e42a3fcd9148e1a49ccfac349dc9d0', './lib/core/Search/Type/Interface.php', '28.4', 0),
('750d6552d2b4c1fac88b00ad2788f86b', './lib/core/Search/Type/Json.php', '28.4', 0),
('c6e8bcfa71b7455578be6878c768e84b', './lib/core/Search/Type/JsonEncoded.php', '28.4', 0),
('93c5c57792d2ae597bed38927785fb34', './lib/core/Search/Type/MultivalueInt.php', '28.4', 0),
('a90df695bd68ddaed87f1ac18e6132e8', './lib/core/Search/Type/MultivalueJson.php', '28.4', 0),
('8a6852df0283acc99f19cc8ca08908c0', './lib/core/Search/Type/MultivaluePlain.php', '28.4', 0),
('7ce8b3313e431c842ff4216f15cac29c', './lib/core/Search/Type/MultivalueText.php', '28.4', 0),
('29a0fcc5573896be2bd91c44271276ea', './lib/core/Search/Type/Nested.php', '28.4', 0),
('941cdb7152797a963d3ec27c207a2e8b', './lib/core/Search/Type/Numeric.php', '28.4', 0),
('93d7c6b6383d2fe25aaf37cf1e7be15b', './lib/core/Search/Type/Object.php', '28.4', 0),
('9ae27cfee298c8cba4d23a6f70543d5d', './lib/core/Search/Type/PlainMediumText.php', '28.4', 0),
('dc06fb758bf43d2907fb751e3b085d1c', './lib/core/Search/Type/PlainShortText.php', '28.4', 0),
('75d3c8119b44929dcb364a3cfc5c579c', './lib/core/Search/Type/PlainText.php', '28.4', 0),
('e64979ea2cb7b58762e28799b46ea9b9', './lib/core/Search/Type/ShortText.php', '28.4', 0),
('4290ac17d9c55eb6f758de8b61b81e42', './lib/core/Search/Type/SimpleText.php', '28.4', 0),
('f857a1fb2f564e61b354c234971be6b8', './lib/core/Search/Type/Timestamp.php', '28.4', 0),
('ffa8f4db3b7248c102143ed9734e2268', './lib/core/Search/Type/Whole.php', '28.4', 0),
('65c1b6a69e66bbfd908592ad52b787c3', './lib/core/Search/Type/WikiText.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Search/Type/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Search/index.php', '28.4', 0),
('44b084cceaff6cc3b6a1a2edacebf076', './lib/core/Sections.php', '28.4', 0),
('fb7b8d5c1bf142daef58a158f5df4bfc', './lib/core/Services/API/TokenController.php', '28.4', 0),
('5b6cef5d052d5e0256a8983ec0a6beec', './lib/core/Services/API/WebhookController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/API/index.php', '28.4', 0),
('71a89ea1ba78ad21f58d5edde8a4647e', './lib/core/Services/Access/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Access/index.php', '28.4', 0),
('5dc92060c8ed7b82931968aab1d17717', './lib/core/Services/ActivityStream/Controller.php', '28.4', 0),
('ff950fe0430475cfda8773448e63ea54', './lib/core/Services/ActivityStream/ManageController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/ActivityStream/index.php', '28.4', 0),
('3d16bc4a511602a20d9c4b8173d55233', './lib/core/Services/ApiBridge.php', '28.4', 0),
('981a3354c7cc90414771a1db91b696a7', './lib/core/Services/ApiClient.php', '28.4', 0),
('a16dcb55927bead8a9bddbd83e6179c2', './lib/core/Services/Article/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Article/index.php', '28.4', 0),
('b02b20c1dace48a42fa52dc508bac655', './lib/core/Services/Attribute/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Attribute/index.php', '28.4', 0),
('58ac2187c660111fa73ba6e1ff18eebd', './lib/core/Services/AuthSource/Controller.php', '28.4', 0),
('b13cfbf7a9a812c9aadbcb0ee9118f76', './lib/core/Services/AuthSource/OAuthController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/AuthSource/index.php', '28.4', 0),
('710696df202c314174325cf4d1a48772', './lib/core/Services/AutoSave/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/AutoSave/index.php', '28.4', 0),
('0657f60b5ddddb57abd7bb65edfd51b4', './lib/core/Services/BigBlueButton/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/BigBlueButton/index.php', '28.4', 0),
('36e08900b3728e8638bab8077e53c936', './lib/core/Services/Broker.php', '28.4', 0),
('031f4af03d8fc990423c8f2570638128', './lib/core/Services/Calendar/AppointmentController.php', '28.4', 0),
('842d6fe3a033b71b4645796c64f88c22', './lib/core/Services/Calendar/AvailabilityController.php', '28.4', 0),
('c702cda0527b4a4321ca675310f16a73', './lib/core/Services/Calendar/BaseController.php', '28.4', 0),
('4b1ca34ff1ff4f5c3673557d842ca381', './lib/core/Services/Calendar/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Calendar/index.php', '28.4', 0),
('43e853ff22bbd47aed8d0a95ab875385', './lib/core/Services/Category/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Category/index.php', '28.4', 0),
('6f30b723e489ae16c7a0ed0fe79b9ec6', './lib/core/Services/ColorModes/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/ColorModes/index.php', '28.4', 0),
('e7c5511c6a63c8b2ade9ac634689a81e', './lib/core/Services/Comment/AnnotationController.php', '28.4', 0),
('543771c9807450646b77351c204d87a4', './lib/core/Services/Comment/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Comment/index.php', '28.4', 0),
('e6bb813ecb685c76647267202516b0e2', './lib/core/Services/Connect/Client.php', '28.4', 0),
('e39b29fbcb2ce035a4dfa74e82f697ab', './lib/core/Services/Connect/Server.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Connect/index.php', '28.4', 0),
('b4fe24dd2e8cde8bf9a009bb7ba8b332', './lib/core/Services/ContentTemplate/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/ContentTemplate/index.php', '28.4', 0),
('d95af631c71041c87982d21064072c3f', './lib/core/Services/CustomRoute/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/CustomRoute/index.php', '28.4', 0),
('6b002a2ced127a0d197b100e5acccff4', './lib/core/Services/Cypht/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Cypht/index.php', '28.4', 0),
('407f8d4e0e34374f68de41fb46c76e35', './lib/core/Services/Diagram/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Diagram/index.php', '28.4', 0),
('9e76d37f11161eeae847970a6b49221b', './lib/core/Services/Draw/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Draw/index.php', '28.4', 0),
('f4c7a26f776064c3ff6d21a24e095b16', './lib/core/Services/Edit/Controller.php', '28.4', 0),
('8d831591fe092ad821ca3d7466ec404a', './lib/core/Services/Edit/ListConverter.php', '28.4', 0),
('77f665f1d5fbaae4a19afdbbba5404d6', './lib/core/Services/Edit/ListPluginHelper.php', '28.4', 0),
('85d9ad4183a53ea917e62cf84e3cd69d', './lib/core/Services/Edit/PluginController.php', '28.4', 0),
('dc00179b1af32d8e326fa5067da3c4ec', './lib/core/Services/Edit/SemaphoreController.php', '28.4', 0),
('cd1059c900def72507dbeb6ac19790dc', './lib/core/Services/Edit/Utilities.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Edit/index.php', '28.4', 0),
('af847c7fdaa8867aa51f6c8a1628fecd', './lib/core/Services/Encryption/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Encryption/index.php', '28.4', 0),
('07d1fdd3399d2b5075b8eb4bb1b5298c', './lib/core/Services/Exception.php', '28.4', 0),
('cb8dbab542b5018be3fdcd51640ccb4b', './lib/core/Services/Exception/BadRequest.php', '28.4', 0),
('8f9a7f012052b496a8f1cc7d3b662ff7', './lib/core/Services/Exception/Denied.php', '28.4', 0),
('8d012bba66c37ec1680a74607c3bf89c', './lib/core/Services/Exception/Disabled.php', '28.4', 0),
('b659f844a45dd09cbe2b1a92da5aa2b8', './lib/core/Services/Exception/DuplicateValue.php', '28.4', 0),
('706bf340a81e9d7506fc48c8c8dffb2f', './lib/core/Services/Exception/EditConflict.php', '28.4', 0),
('81a2518b7ec3e533c867248f64703d59', './lib/core/Services/Exception/FieldError.php', '28.4', 0),
('cb00ac9ab3e438dabd35446f0f7e8378', './lib/core/Services/Exception/MissingValue.php', '28.4', 0),
('a604fe9302bc12e9bf4cda0ff4b7f190', './lib/core/Services/Exception/NotAvailable.php', '28.4', 0),
('0366d32f476166afcce9c2968f9a8b73', './lib/core/Services/Exception/NotFound.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Exception/index.php', '28.4', 0),
('a2cba899bd7beb693c45723f231bca10', './lib/core/Services/Export/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Export/index.php', '28.4', 0),
('a41894fa59070aae37a4002e26361c53', './lib/core/Services/File/Controller.php', '28.4', 0),
('5d4180a7cf3338f2d3983bb8c8469b8e', './lib/core/Services/File/FinderController.php', '28.4', 0),
('839a28455351c1afa22c9f0dd14214af', './lib/core/Services/File/Utilities.php', '28.4', 0),
('eb9ac01aedb0bc361c1dcafe6ba9d9a2', './lib/core/Services/File/VimeoController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/File/index.php', '28.4', 0),
('e53c273da4421da7abf32205828e80da', './lib/core/Services/Forum/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Forum/index.php', '28.4', 0),
('3b822bc3a0f2b098836e35a21d993840', './lib/core/Services/Goal/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Goal/index.php', '28.4', 0),
('4610d43ffaf02748590267336d758c30', './lib/core/Services/Group/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Group/index.php', '28.4', 0),
('1f2a5684768287b47b40052511948a6c', './lib/core/Services/H5P/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/H5P/index.php', '28.4', 0),
('e59984514be36dc811675381eaf2dc38', './lib/core/Services/IDS/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/IDS/index.php', '28.4', 0),
('7c4c1fe8912995914145fad30e2da158', './lib/core/Services/IconPicker/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/IconPicker/index.php', '28.4', 0),
('741178c849a0b71b28ab91301fdf1259', './lib/core/Services/IotApps/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/IotApps/index.php', '28.4', 0),
('bca43760b88a738bf93168173c9167c6', './lib/core/Services/Kaltura/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Kaltura/index.php', '28.4', 0),
('7596aa205da94c7c6be365283f2aced9', './lib/core/Services/Language/Controller.php', '28.4', 0),
('b01fe0b65450417276e19f4074e4a6ec', './lib/core/Services/Language/TransifexController.php', '28.4', 0),
('ec7babb847dd4d3513e20bac3b642905', './lib/core/Services/Language/TranslationController.php', '28.4', 0),
('579aef834d488b64537b38b8fc2d6b01', './lib/core/Services/Language/TranslationReader.php', '28.4', 0),
('403b1b9c31ca2368a09ef428a072be1a', './lib/core/Services/Language/Utilities.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Language/index.php', '28.4', 0),
('0d66aa24817f0a2bbcff0239f7e29fda', './lib/core/Services/ML/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/ML/index.php', '28.4', 0),
('8ff87b872af492025652c922c9e0236f', './lib/core/Services/MailIn/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/MailIn/index.php', '28.4', 0),
('83f7de2e4810b904bd38b024bc6a515c', './lib/core/Services/Manager/Controller.php', '28.4', 0),
('db545855db85ee4c37d4312f6c6d9bd3', './lib/core/Services/Manager/FieldController.php', '28.4', 0),
('be1c2a98b2b4a226467d75af4fe2b2e8', './lib/core/Services/Manager/PatchController.php', '28.4', 0),
('c37c2fd671f113ba748722ea74201b21', './lib/core/Services/Manager/Trait.php', '28.4', 0),
('4f88de7bff155e4103203341e961e044', './lib/core/Services/Manager/Utilities.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Manager/index.php', '28.4', 0),
('1f7cd4a540d0de3f5da95ce7b5d369d5', './lib/core/Services/Menu/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Menu/index.php', '28.4', 0),
('a09a8191c36d364cf632fc3533c22dc8', './lib/core/Services/Module/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Module/index.php', '28.4', 0),
('e6e7560cf602867df6f1add339058f2e', './lib/core/Services/MustRead/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/MustRead/index.php', '28.4', 0),
('e859c4aadeae19712c3bbc33982db788', './lib/core/Services/OAuthServer/Controller.php', '28.4', 0),
('e0cddc7e9953d3bbad5440b3c60c0599', './lib/core/Services/OAuthServer/JsonResponse.php', '28.4', 0),
('c08bcfcc09aa8ea355088db2425cf370', './lib/core/Services/OAuthServer/Utilities.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/OAuthServer/index.php', '28.4', 0),
('707480480072d71275641501d00e8828', './lib/core/Services/Object/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Object/index.php', '28.4', 0),
('a06d7f2114e543fd344325a52fcbc799', './lib/core/Services/PDF/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/PDF/index.php', '28.4', 0),
('ecd55a29e3247289f0c4f8ff481bbce8', './lib/core/Services/Payment/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Payment/index.php', '28.4', 0),
('eb0d4909fcb66017c7f7ddbfe1ec9adc', './lib/core/Services/Performance/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Performance/index.php', '28.4', 0),
('09f98ba7ce09b4568f11bda8dc1cfd45', './lib/core/Services/Rating/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Rating/index.php', '28.4', 0),
('e6c35422cc6bcfa2be4f840711ed528b', './lib/core/Services/Recommendation/DevelopmentController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Recommendation/index.php', '28.4', 0),
('e107ab383571ce1a02217f80adb093cd', './lib/core/Services/RecordRtc/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/RecordRtc/index.php', '28.4', 0),
('735efc29d1f56553f41439eaba9651f9', './lib/core/Services/Relation/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Relation/index.php', '28.4', 0),
('3ecbb6cf79b59e73db18f658c95eeba7', './lib/core/Services/ResultLoader.php', '28.4', 0),
('c21a85d3fcd6148354f161395baa4795', './lib/core/Services/ResultLoader/WebService.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/ResultLoader/index.php', '28.4', 0),
('63cf37ae182949b22d2618a6becb9089', './lib/core/Services/Scheduler/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Scheduler/index.php', '28.4', 0),
('4eef4cc27eb530e33f65cc89355675e3', './lib/core/Services/Score/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Score/index.php', '28.4', 0),
('ad5293f4ce0bc6ed3eb046c164a4aebc', './lib/core/Services/Search/Controller.php', '28.4', 0),
('133b21cee3864675d6efaaa5e13c8588', './lib/core/Services/Search/CustomSearchController.php', '28.4', 0),
('c73707f02bf5334010b72acd42f577cb', './lib/core/Services/Search/ManifoldController.php', '28.4', 0),
('7893d130431d9033b500fa60a06e4a13', './lib/core/Services/Search/StoredController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Search/index.php', '28.4', 0),
('64a9931290aef7d2baec1d5cf9c99fbe', './lib/core/Services/ShowTikiOrg/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/ShowTikiOrg/index.php', '28.4', 0),
('8ce74fcf42b68bbfb54bb6447ee3d9ea', './lib/core/Services/StyleGuide/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/StyleGuide/index.php', '28.4', 0),
('f6bcebd2daf4cfae1946550ea232b378', './lib/core/Services/Suite/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Suite/index.php', '28.4', 0),
('50e16ecfdf109403fb7c2a552fb3fbb9', './lib/core/Services/Tracker/CalendarController.php', '28.4', 0),
('1bdf9e5d4ec74eab6a6ca5a9d00c1f0b', './lib/core/Services/Tracker/Controller.php', '28.4', 0),
('8fc3e6ee4841498ce33e2fb9a7aa9bf6', './lib/core/Services/Tracker/DurationController.php', '28.4', 0),
('4f6f7f50f04acdc68a9af3e9ce0696a6', './lib/core/Services/Tracker/OfflineController.php', '28.4', 0),
('07e1402fe76d820c9a13623c3eba71a1', './lib/core/Services/Tracker/SyncController.php', '28.4', 0),
('e05ed653165ffe015c35abddf7a7eb42', './lib/core/Services/Tracker/TabularController.php', '28.4', 0),
('c82baf7fbfe4d69ac90f18493810a848', './lib/core/Services/Tracker/TodoController.php', '28.4', 0),
('930399e5a972a8718bc5f6fb58feed4c', './lib/core/Services/Tracker/Utilities.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Tracker/index.php', '28.4', 0),
('455d1132c28ce5478419e410d172bc06', './lib/core/Services/User/ConditionsController.php', '28.4', 0),
('21b7331dc274b2e12b1107184e1230df', './lib/core/Services/User/Controller.php', '28.4', 0),
('2e6928ae518dd07d334c6183d0db2c30', './lib/core/Services/User/FavoriteController.php', '28.4', 0),
('93ac2452fe5a79b0d52e5b16f13713db', './lib/core/Services/User/MonitorController.php', '28.4', 0),
('804dd9ee5a7075301ca5aa9c26d95953', './lib/core/Services/User/SocialController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/User/index.php', '28.4', 0),
('f95016e9e7eb785b3db9244faa2e194a', './lib/core/Services/Utilities.php', '28.4', 0),
('06b91638f2f2885137c084a35eef8cc0', './lib/core/Services/Wiki/Controller.php', '28.4', 0),
('149dd1621f7115af3ba62066c4827707', './lib/core/Services/Wiki/StructureController.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Wiki/index.php', '28.4', 0),
('6373c667e514f977dbf2399002b89cb6', './lib/core/Services/Workspace/Controller.php', '28.4', 0),
('539f28b86e120cba3daf9fd53fb51a6b', './lib/core/Services/Workspace/ProfileAnalyser.php', '28.4', 0),
('aaf7ecf84d2f081892cb8d62089cb8d0', './lib/core/Services/Workspace/ProfileBuilder.php', '28.4', 0),
('c500a5ee31ee50a7f1eb21eda1428d30', './lib/core/Services/Workspace/Utilities.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Workspace/index.php', '28.4', 0),
('acb0c2e786fa8baa9e998a294eb0ddb5', './lib/core/Services/Xmpp/Controller.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Services/Xmpp/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Services/index.php', '28.4', 0),
('9ca89edfcc765ce0dcb0ba65120a9b9d', './lib/core/Table/Check.php', '28.4', 0),
('19414d364e672e05bdfe9ebff9848b77', './lib/core/Table/Code/Abstract.php', '28.4', 0),
('dfb0a0bfc7daad834ea96ac734162155', './lib/core/Table/Code/Bind.php', '28.4', 0),
('12c6607275f60f4865a478cb8a4be6b3', './lib/core/Table/Code/MainOptions.php', '28.4', 0),
('f992559f1ab24397d26653f93061f359', './lib/core/Table/Code/Manager.php', '28.4', 0),
('d80437be46c5be5089d7c604b796eb2b', './lib/core/Table/Code/Other.php', '28.4', 0),
('7267f4c2421d91c3df17a64b7e3a9860', './lib/core/Table/Code/WidgetOptions.php', '28.4', 0),
('0249f922dda22a67dc7c375f3c088415', './lib/core/Table/Code/WidgetOptionsFilter.php', '28.4', 0),
('35d6004aa83642799352c44081ac81b9', './lib/core/Table/Code/WidgetOptionsMath.php', '28.4', 0),
('d9e0c9d6a9ddd62085b13fd49bf71214', './lib/core/Table/Code/WidgetOptionsOutput.php', '28.4', 0),
('93c02d57577dae951561b08b04166ce6', './lib/core/Table/Code/WidgetOptionsPager.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Table/Code/index.php', '28.4', 0),
('b412bd78d0b707a0fa5b1f37276e9193', './lib/core/Table/Factory.php', '28.4', 0),
('1f8aba0732e3364fbfb250cf533a52f4', './lib/core/Table/Manager.php', '28.4', 0),
('69f94e416531edba5d3eae3e38f712fd', './lib/core/Table/Plugin.php', '28.4', 0),
('77fbd57a4e68e5233e974bd1f5212f16', './lib/core/Table/Settings/Abstract.php', '28.4', 0),
('14052260ab0b4e14259265eb8a8d7782', './lib/core/Table/Settings/Plugin.php', '28.4', 0),
('a7e4e9202be33f839d2eb7cdf5cdaf17', './lib/core/Table/Settings/PluginWithAjax.php', '28.4', 0),
('5fb155c6e169e254fa8ce0a4fd26c02e', './lib/core/Table/Settings/Standard.php', '28.4', 0),
('62f6d81e8a81d624c1ce332c7928ec2b', './lib/core/Table/Settings/TikiAdminForums.php', '28.4', 0),
('fa1d2c16369c0420824464c64c406ea8', './lib/core/Table/Settings/TikiAdminGroups.php', '28.4', 0),
('3fa41e908ac93e3cb04271d8c3366d81', './lib/core/Table/Settings/TikiAdminGroupsBanned.php', '28.4', 0),
('e1e72b01539a2ecb155ba3b686e47762', './lib/core/Table/Settings/TikiAdminGroupsMembers.php', '28.4', 0),
('1e4acbda32209ef6e3d8dce509820982', './lib/core/Table/Settings/TikiAdminusers.php', '28.4', 0),
('952ea325177b93a410ed733011896b2c', './lib/core/Table/Settings/TikiForums.php', '28.4', 0),
('f7797d548b91d4789628c14e55f99c90', './lib/core/Table/Settings/TikiListpages.php', '28.4', 0),
('590b873030429bb4afdbc983729369c4', './lib/core/Table/Settings/TikiPayment.php', '28.4', 0),
('5ec04a62c170d4ece6ab672f8004d32b', './lib/core/Table/Settings/TikiPaymentPast.php', '28.4', 0),
('811fb1418bd74cb90db88814649ab29e', './lib/core/Table/Settings/TikiViewforum.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Table/Settings/index.php', '28.4', 0),
('42c24f428c3d959152ee98a0b6871cf9', './lib/core/Table/Totals.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Table/index.php', '28.4', 0),
('ece8e77936da2bc5658457e1e5c86fbf', './lib/core/Tiki/Autoload.php', '28.4', 0),
('502e0f6a62920fa04c168b5dcfd04b70', './lib/core/Tiki/BigBlueButton/Configuration.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/BigBlueButton/index.php', '28.4', 0),
('58cd7bdbb650e829cfa448b6e578fe82', './lib/core/Tiki/Command/AdminIndexRebuildCommand.php', '28.4', 0),
('9d23ec8ebb63dcb0fa744de0670e9fc4', './lib/core/Tiki/Command/Application.php', '28.4', 0),
('419c495c45afb74d86606895026c26ba', './lib/core/Tiki/Command/AttachmentsMigrateCommand.php', '28.4', 0),
('5de6875407b1c67aaad5cc2d60821daa', './lib/core/Tiki/Command/BackupDBCommand.php', '28.4', 0),
('c28f8fd213929f1bc8878ad15d211244', './lib/core/Tiki/Command/BackupFilesCommand.php', '28.4', 0),
('f932d272df68b3ee2e7b8191c857450f', './lib/core/Tiki/Command/BuildIconsListCommand.php', '28.4', 0),
('32f2fe3ea5eee348b1856ae29fe8e6e2', './lib/core/Tiki/Command/CacheClearCommand.php', '28.4', 0),
('5d4fd55065c6e6a98850dc4c3c850752', './lib/core/Tiki/Command/CacheGenerateCommand.php', '28.4', 0),
('e0527cf5c512d793abf8cece064536d8', './lib/core/Tiki/Command/CalendarSyncCommand.php', '28.4', 0),
('be1460d627b74c70f58cce169633669c', './lib/core/Tiki/Command/CommandUnavailableException.php', '28.4', 0),
('7dab11e6b4a9a2dee19b7d2d72fae2a6', './lib/core/Tiki/Command/ConfigureCommand.php', '28.4', 0),
('f4907be061864b2836cd5b0acc1a4e1f', './lib/core/Tiki/Command/ConsoleApplicationBuilder.php', '28.4', 0),
('8dc14212c7391b4df74214acec17d738', './lib/core/Tiki/Command/ConsoleSetupException.php', '28.4', 0),
('2c08a044834db352a34ee10ddbbc2c19', './lib/core/Tiki/Command/CookiesClearCommand.php', '28.4', 0),
('b8884354bd7969ae2e4f54f10e69fa81', './lib/core/Tiki/Command/DailyReportSendCommand.php', '28.4', 0),
('b96271bc316d47d2fff406e364903174', './lib/core/Tiki/Command/DevConfigureCommand.php', '28.4', 0),
('ceaa16f85511fa831ed7487ad6b155c0', './lib/core/Tiki/Command/DevFixStyleCommand.php', '28.4', 0),
('0275438cd3b52dd8e84cb4adf14b1f93', './lib/core/Tiki/Command/DevUnInstallCommand.php', '28.4', 0),
('e56d38d48d969fa8e7b3dde3652dea49', './lib/core/Tiki/Command/DevbuildwsconfsCommand.php', '28.4', 0),
('8e47240f737fa54e35c1e534b22f64ab', './lib/core/Tiki/Command/EnglishUpdateCommand.php', '28.4', 0),
('ff2d106a73345ce6bd4e87a3dad6611e', './lib/core/Tiki/Command/FakerCommentsCommand.php', '28.4', 0),
('65bfe6aea5aee58e14771759c2c32054', './lib/core/Tiki/Command/FakerTrackerCommand.php', '28.4', 0),
('923178fe01535c3cb1fd55cdf403bee9', './lib/core/Tiki/Command/FileGallerySyncCommand.php', '28.4', 0),
('01d2c58646721b236fb01e78e4d371a1', './lib/core/Tiki/Command/FilesBatchuploadCommand.php', '28.4', 0),
('88f2e6c6a4b3f1045005eb3e94c5c440', './lib/core/Tiki/Command/FilesCheckCommand.php', '28.4', 0),
('5f411f0b5623de7dd13a1daaa208f25d', './lib/core/Tiki/Command/FilesCopyCommand.php', '28.4', 0),
('c2c3f7d8cf9b68010ceadc25d78876a5', './lib/core/Tiki/Command/FilesDeleteoldCommand.php', '28.4', 0),
('30b16c179fad3081aaab9c57c0f92a0d', './lib/core/Tiki/Command/FilesIndexCommand.php', '28.4', 0),
('85c515b8e419fe9ea21078d3ffbed963', './lib/core/Tiki/Command/FilesMoveCommand.php', '28.4', 0),
('ee0d0813915e02855442a13193f35e0f', './lib/core/Tiki/Command/FixBOMandUnixCommand.php', '28.4', 0),
('5b5ee2a040e8da656043fd0ca959acc2', './lib/core/Tiki/Command/ForumProcessInboundMail.php', '28.4', 0),
('2b545d1c36e357ca8f71cc5da1a004cc', './lib/core/Tiki/Command/GalleryMigrateCommand.php', '28.4', 0),
('cfb951fc00209b7b8f97463d5cd7cbe6', './lib/core/Tiki/Command/GetStringsCommand.php', '28.4', 0),
('55016f164982a0e5dce61a0b064f8ffa', './lib/core/Tiki/Command/GoalCheckCommand.php', '28.4', 0),
('a450d5cf5e5471050a12525548f906e6', './lib/core/Tiki/Command/IndexCatchUpCommand.php', '28.4', 0),
('45c73774f1f229710617297db5c3c1b2', './lib/core/Tiki/Command/IndexCleanupCommand.php', '28.4', 0),
('729e1f96bf53142e2f813c7e0ad11108', './lib/core/Tiki/Command/IndexCompareEnginesCommand.php', '28.4', 0),
('2a38991507032fefc9e2c77d3daff4cb', './lib/core/Tiki/Command/IndexOptimizeCommand.php', '28.4', 0),
('35c5fa9b1d9ca72dec1a6e091d7eb136', './lib/core/Tiki/Command/IndexRebuildCommand.php', '28.4', 0),
('30fcad87299b55a66ebde3011403d260', './lib/core/Tiki/Command/InstallCommand.php', '28.4', 0),
('bbca2bc0a84c9833263391491a0ea95c', './lib/core/Tiki/Command/InstallerLockCommand.php', '28.4', 0),
('0463a60bc0aca65ec3b39a97b112c789', './lib/core/Tiki/Command/InstallerUnlockCommand.php', '28.4', 0),
('370983457acb835cf286a074570caff8', './lib/core/Tiki/Command/ListExecuteCommand.php', '28.4', 0),
('3d635865cba60022e13190bfbe420cd6', './lib/core/Tiki/Command/MLTrainCommand.php', '28.4', 0),
('e039a44b286cd358ac563b6d2c381133', './lib/core/Tiki/Command/MailInPollCommand.php', '28.4', 0),
('a01d0cbf5c35418b5036295a0eb6ab74', './lib/core/Tiki/Command/MailQueueSendCommand.php', '28.4', 0),
('73cbf71283895f5e8f98092b89b90d26', './lib/core/Tiki/Command/MarkdownConvertCommand.php', '28.4', 0),
('9e8669478c9f613de0d761d8869d17f3', './lib/core/Tiki/Command/MultiTikiListCommand.php', '28.4', 0),
('16ed2369c7f80f5e631c0c8499fd2119', './lib/core/Tiki/Command/MultiTikiMoveCommand.php', '28.4', 0),
('05b209b80ef6b1807e3cbfb794b706dd', './lib/core/Tiki/Command/NotificationDigestCommand.php', '28.4', 0),
('02c4089520868be4e8e346f843ae568e', './lib/core/Tiki/Command/OCRAllCommand.php', '28.4', 0),
('058d016ef36a3c6bf481322dd0ff7853', './lib/core/Tiki/Command/OCRFileCommand.php', '28.4', 0),
('c06e6dc83d94c5180c28d08bb8f050ad', './lib/core/Tiki/Command/OCRSetCommand.php', '28.4', 0),
('3f2a84269d5d914fffd98e77bce6c4c7', './lib/core/Tiki/Command/OCRStatusCommand.php', '28.4', 0),
('f38210002ea06d67d3677252b063601b', './lib/core/Tiki/Command/ObjectsExportCommand.php', '28.4', 0),
('3f63aab76d4ee006a79ef92c8e6e98db', './lib/core/Tiki/Command/ObjectsNotifyMaintainersCommand.php', '28.4', 0),
('1066747ac7922d7004bc392012a47aa1', './lib/core/Tiki/Command/PackageClearCacheCommand.php', '28.4', 0),
('b3d2d0e6eee3ca8874a6d3e0d9b0b8ba', './lib/core/Tiki/Command/PackageDisableCommand.php', '28.4', 0),
('7045adba3e1bf56be690568ecd571a23', './lib/core/Tiki/Command/PackageEnableCommand.php', '28.4', 0),
('11ede2409928cecda57403c2c3e57926', './lib/core/Tiki/Command/PackageInstallCommand.php', '28.4', 0),
('8d3a1f805c22d866a8bef7799d575974', './lib/core/Tiki/Command/PackageListCommand.php', '28.4', 0),
('cdf4d84119aa493c0e9b138c7d28997f', './lib/core/Tiki/Command/PackageRemoveCommand.php', '28.4', 0),
('b0adbb8b49aae5541a0adb71bc18fe43', './lib/core/Tiki/Command/PackageUpdateCommand.php', '28.4', 0),
('c97dc43e2fe21e72a0102ca2777e43d1', './lib/core/Tiki/Command/PatchCommand.php', '28.4', 0),
('adeecd49d50a0ec18156167422d825d3', './lib/core/Tiki/Command/PerformanceCheckCommand.php', '28.4', 0),
('c9c77dc82c8397fc2a59943578456dae', './lib/core/Tiki/Command/PluginApproveRunCommand.php', '28.4', 0),
('2580e976ecdbf23da5c1679af7b919df', './lib/core/Tiki/Command/PluginListRunCommand.php', '28.4', 0),
('1f56a704c8a5a3337cb5bbb333992e21', './lib/core/Tiki/Command/PluginPendingRunCommand.php', '28.4', 0),
('824a170e84eea51df190ffb38d06c117', './lib/core/Tiki/Command/PluginRefreshRunCommand.php', '28.4', 0),
('1ec4c8b94f2079d7221a014f06d56132', './lib/core/Tiki/Command/PreferencesDeleteCommand.php', '28.4', 0),
('7e1fd44a01ba92ad988a257f783cd9b8', './lib/core/Tiki/Command/PreferencesExportCommand.php', '28.4', 0),
('175100cb6d12094bce326ab7f1325bd5', './lib/core/Tiki/Command/PreferencesGetCommand.php', '28.4', 0),
('ce2ed256858de3a1637c832897ad96f5', './lib/core/Tiki/Command/PreferencesSetCommand.php', '28.4', 0),
('89fe8cc61e4574063cf0381adb807f6d', './lib/core/Tiki/Command/ProfileBaselineCommand.php', '28.4', 0),
('3bfd67df477e0a91ffbf07221b2d495c', './lib/core/Tiki/Command/ProfileExport/ActivityRuleSet.php', '28.4', 0),
('95ee3cf1964a258bcf69ef57a370f81c', './lib/core/Tiki/Command/ProfileExport/ActivityStreamRule.php', '28.4', 0),
('9604f514c8b314545d7bf7eda8383998', './lib/core/Tiki/Command/ProfileExport/AllModules.php', '28.4', 0),
('3d38a20b558641193a6ffa88b4e7eac5', './lib/core/Tiki/Command/ProfileExport/Article.php', '28.4', 0),
('251e70cfb2e6b89fb11a1dc65cf92138', './lib/core/Tiki/Command/ProfileExport/ArticleTopic.php', '28.4', 0),
('8b344fc8de1f97dfe8c83fe4a9db9fd2', './lib/core/Tiki/Command/ProfileExport/ArticleType.php', '28.4', 0),
('66af4fcae58ce913d0111e0e21734e63', './lib/core/Tiki/Command/ProfileExport/Calendar.php', '28.4', 0),
('d39b4823fe7db7cd6e0cfeffd7debba7', './lib/core/Tiki/Command/ProfileExport/Category.php', '28.4', 0),
('e64849c852b2aa358fd995ce6e5beea7', './lib/core/Tiki/Command/ProfileExport/FileGallery.php', '28.4', 0),
('1b147d0f8ab49e6effc62f3d9c112b16', './lib/core/Tiki/Command/ProfileExport/Finalize.php', '28.4', 0),
('2c979907417c0eb637b8c65aecf90a10', './lib/core/Tiki/Command/ProfileExport/Forum.php', '28.4', 0),
('b12377fbaae906fe61f302a1289093c8', './lib/core/Tiki/Command/ProfileExport/Goal.php', '28.4', 0),
('751e04096c2825fd05ca8c21b445ab28', './lib/core/Tiki/Command/ProfileExport/GoalSet.php', '28.4', 0),
('8f33be149c24a88433aa70600c3e17cf', './lib/core/Tiki/Command/ProfileExport/Group.php', '28.4', 0),
('cb98f461f33693d2b66da72419526314', './lib/core/Tiki/Command/ProfileExport/IncludeProfile.php', '28.4', 0),
('5f07a515980f6e6c867a7763e915300a', './lib/core/Tiki/Command/ProfileExport/Init.php', '28.4', 0),
('0a6607980d7eeea89950839314211898', './lib/core/Tiki/Command/ProfileExport/Menu.php', '28.4', 0),
('68d8440fec60cc4d5417b1cb5fa1418e', './lib/core/Tiki/Command/ProfileExport/Module.php', '28.4', 0),
('3407faf4351073b9a1f08f59b264d30a', './lib/core/Tiki/Command/ProfileExport/ObjectWriter.php', '28.4', 0),
('7be958c0c325ccb1416a2b339b2567cc', './lib/core/Tiki/Command/ProfileExport/Preference.php', '28.4', 0),
('43fa3beb2888f73168d47e8f04589eae', './lib/core/Tiki/Command/ProfileExport/RatingConfig.php', '28.4', 0),
('55806721e62aeb3255d5fefca45b6704', './lib/core/Tiki/Command/ProfileExport/RatingConfigSet.php', '28.4', 0),
('fe0304775a07d4a0c703702c6a811e07', './lib/core/Tiki/Command/ProfileExport/RecentChanges.php', '28.4', 0),
('00019a42bac575d30ecf0264d3c7f480', './lib/core/Tiki/Command/ProfileExport/Rss.php', '28.4', 0),
('add4f2ff2acc57bfe2f32e178d2f1766', './lib/core/Tiki/Command/ProfileExport/Tabular.php', '28.4', 0),
('c4d6af399cb6f0e39d17068409022c91', './lib/core/Tiki/Command/ProfileExport/Tracker.php', '28.4', 0),
('8cc208d2230ced23c12c3d7a5bc797cb', './lib/core/Tiki/Command/ProfileExport/TrackerField.php', '28.4', 0),
('8665feaf00fe7f442abbf68403cff1c6', './lib/core/Tiki/Command/ProfileExport/TrackerItem.php', '28.4', 0),
('a9da976aa6f46849852f688493f3da0b', './lib/core/Tiki/Command/ProfileExport/WikiPage.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Command/ProfileExport/index.php', '28.4', 0),
('d78d90d857e002c9c2cd9211e8f85347', './lib/core/Tiki/Command/ProfileForgetCommand.php', '28.4', 0),
('608ac77e2826cebef5b06a5f66dcf202', './lib/core/Tiki/Command/ProfileInstallCommand.php', '28.4', 0),
('04d6a75bcc13c3c4959c4a446cca6665', './lib/core/Tiki/Command/RecommendationBatchCommand.php', '28.4', 0),
('c55a4f386fe0f8eb1adf5d8b476be6cf', './lib/core/Tiki/Command/RedactDBCommand.php', '28.4', 0),
('64738064222820d820020ed55b508a31', './lib/core/Tiki/Command/RefreshRssCommand.php', '28.4', 0),
('add70d07b99bb76efe78ab5530e77771', './lib/core/Tiki/Command/ReportCacheClearCommand.php', '28.4', 0),
('af79e39481f8b4e173ff445e03537a68', './lib/core/Tiki/Command/RssClearCacheCommand.php', '28.4', 0),
('4d9638f29c0ea6aac2ddd67c3f28841f', './lib/core/Tiki/Command/SchedulerHealCommand.php', '28.4', 0),
('8ba3fdabb5e311bef8f1cfb8283be71f', './lib/core/Tiki/Command/SchedulerRunCommand.php', '28.4', 0),
('2a7ac8cf36df32f6919fe2427bffc6dd', './lib/core/Tiki/Command/SemiAutoMergeCommand.php', '28.4', 0),
('198badc83620f6d67c9b185ab7251b9d', './lib/core/Tiki/Command/SieveFiltersCommand.php', '28.4', 0),
('dbbe0c331c01e81666d3b938d6b80a79', './lib/core/Tiki/Command/SitemapGenerateCommand.php', '28.4', 0),
('bdab705ab6d309b254885a707ed84a1e', './lib/core/Tiki/Command/StatsCommand.php', '28.4', 0),
('19edcf82604e5ecc383871fbb463b43e', './lib/core/Tiki/Command/ThemeInstallCommand.php', '28.4', 0),
('7fc9db0484b59d4069cdd295750c782e', './lib/core/Tiki/Command/ThemeRemoveCommand.php', '28.4', 0),
('b0c27c5b87304a5b85955da617a0b404', './lib/core/Tiki/Command/ThemeUpdateCommand.php', '28.4', 0),
('a4d7f924926a75fbeb6d11c658dd2454', './lib/core/Tiki/Command/TikiInfoCommand.php', '28.4', 0),
('05f972cb65c553ecebd4686bc4c5145f', './lib/core/Tiki/Command/TokensClearCommand.php', '28.4', 0),
('b1199a7325839af3cc29e0821357e469', './lib/core/Tiki/Command/TrackerClearCommand.php', '28.4', 0),
('c3d8fe0517f7f2d09ab6f9d19e5ebcd7', './lib/core/Tiki/Command/TrackerConvertAttachmentsCommand.php', '28.4', 0),
('1d56d078d9bfb35cdc3b65f5fd652849', './lib/core/Tiki/Command/TrackerExportCommand.php', '28.4', 0),
('743740c40e511f7b6a528f680527ded3', './lib/core/Tiki/Command/TrackerImportCommand.php', '28.4', 0),
('360933ba4a265619e0ae3da6e9956546', './lib/core/Tiki/Command/TrackerRecalcCommand.php', '28.4', 0),
('df20185fb1798e23077a9923e1be0fac', './lib/core/Tiki/Command/TranslationExportCommand.php', '28.4', 0),
('7540cfc32dd15748170b73650580d3de', './lib/core/Tiki/Command/TranslationPercentageCommand.php', '28.4', 0),
('5d0fe2b8d91636c50f46c4de8fc6497f', './lib/core/Tiki/Command/UpdateCommand.php', '28.4', 0),
('5c4a79a33349a7cb6a99c17e4be7e8b4', './lib/core/Tiki/Command/UserCreateCommand.php', '28.4', 0),
('8fb094302df209ac9460f73b151fb742', './lib/core/Tiki/Command/UserUnlockCommand.php', '28.4', 0),
('f6c12a27222aad9bac227a6a76481377', './lib/core/Tiki/Command/UsersListCommand.php', '28.4', 0),
('727e2f5101cd8d1c49fe51552a505231', './lib/core/Tiki/Command/UsersPasswordCommand.php', '28.4', 0),
('5cc9bf2f1c80bfc139cd33b6277c4e4b', './lib/core/Tiki/Command/UsersTemporaryCommand.php', '28.4', 0),
('203c1227612b7f86a72e33a607527433', './lib/core/Tiki/Command/Utilities/DatabaseQueryLogConsoleFormatter.php', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Command/Utilities/index.php', '28.4', 0),
('d15a604b7e164a02339de3dcd3e818f0', './lib/core/Tiki/Command/VCSUpdateCommand.php', '28.4', 0),
('5df0d5b072355f377d572c2b4c4a5893', './lib/core/Tiki/Command/VendorSecurityCommand.php', '28.4', 0),
('c425733a23e87f612c0e12a505e299b8', './lib/core/Tiki/Command/WebmailUnreadGlobalCommand.php', '28.4', 0),
('7cc44580a156dbd88c97a3cdd84a0fe2', './lib/core/Tiki/Command/WebmailUnreadPagesCommand.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Command/index.php', '28.4', 0),
('edcba838a4a931724a16d0661afc9526', './lib/core/Tiki/Composer/Autoload.php', '28.4', 0),
('47783657adcf1a21efcad703f48abd4a', './lib/core/Tiki/Composer/BootstrapCompiler.php', '28.4', 0),
('616263725acd419950eb0aefc48d9780', './lib/core/Tiki/Composer/CleanVendorAfterVendorBundledMigration.php', '28.4', 0),
('ca88c7fee6dbf9752283016a495b89f7', './lib/core/Tiki/Composer/CleanVendors.php', '28.4', 0),
('5f823845d67c28ee0287ce0d2a3fc586', './lib/core/Tiki/Composer/GenerateIcons.php', '28.4', 0),
('621fc1df9974ba80ae30c3cada246b17', './lib/core/Tiki/Composer/GenerateIndexFiles.php', '28.4', 0),
('c0c3f0612ba506c326b8e45565c6b4d2', './lib/core/Tiki/Composer/PatchCypht.php', '28.4', 0),
('e13c940dd74eae40481c47d92692196d', './lib/core/Tiki/Composer/RestoreVendors.php', '28.4', 0),
('c9b30e1bd7eac67c3ce86f3c2795193f', './lib/core/Tiki/Composer/ThemeInstaller.php', '28.4', 0),
('c4ba6b8e950320091112d087e1d2dd5c', './lib/core/Tiki/Composer/ValidateVersion.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Composer/index.php', '28.4', 0),
('d8a8601cb7c9d33be66b2aaf2e759845', './lib/core/Tiki/Config/Ini.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Config/index.php', '28.4', 0),
('39ce0bdccfefd5bd72cabd44e95360b1', './lib/core/Tiki/Connect/Abstract.php', '28.4', 0),
('d0cf99d4814b3f2502b83a805cf3e459', './lib/core/Tiki/Connect/Client.php', '28.4', 0),
('85dc870b8135ffef81b559fb857c612b', './lib/core/Tiki/Connect/Server.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Connect/index.php', '28.4', 0),
('32965ab0c3d16d3ef140faa456b7139e', './lib/core/Tiki/Editable/Value.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Editable/index.php', '28.4', 0),
('f96df82615eefdbc4ba71ca82f0415f6', './lib/core/Tiki/Errors.php', '28.4', 0),
('2a754e51327b07d7f7864f9f6ae3268b', './lib/core/Tiki/Event/Chain.php', '28.4', 0),
('03d0e3b708402bbd065cad0fb8110dc1', './lib/core/Tiki/Event/Customizer.php', '28.4', 0),
('a667ea9fee03b4a96977c6c314f1cc73', './lib/core/Tiki/Event/Customizer/Executor.php', '28.4', 0),
('5bb37aef44751955a5f807ce932c37ca', './lib/core/Tiki/Event/Customizer/RuleSet.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Event/Customizer/index.php', '28.4', 0),
('3f7e88991fc1d6ec467dd2973c62f364', './lib/core/Tiki/Event/EdgeProvider.php', '28.4', 0),
('66481744ae8d1b56244e1533c747a6c9', './lib/core/Tiki/Event/Function/EventLog.php', '28.4', 0),
('50d551c877b6e99b5ce5bb0a1dfae914', './lib/core/Tiki/Event/Function/EventNotify.php', '28.4', 0),
('b3109c959d7f3a13c8f47152e170b421', './lib/core/Tiki/Event/Function/EventRecord.php', '28.4', 0),
('202f3f570b0643b7f45da8c01e2c9827', './lib/core/Tiki/Event/Function/EventSample.php', '28.4', 0),
('1b0707615f857466be5c9d2a3f431b2c', './lib/core/Tiki/Event/Function/EventTrigger.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Event/Function/index.php', '28.4', 0),
('c27bdea46abef3ee00e1a9a3700d5bde', './lib/core/Tiki/Event/Lib.php', '28.4', 0),
('dd720b4cb2dfdde978e2cff68f6e4c2d', './lib/core/Tiki/Event/Manager.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Event/index.php', '28.4', 0),
('6bb4d6fb8ddb9f204c36f1e83495f35f', './lib/core/Tiki/Faker.php', '28.4', 0),
('b95eed7f67677f0e1b36d467d2e1d1ae', './lib/core/Tiki/FileGallery/Definition.php', '28.4', 0),
('3132893bc1bc966c2e4de256cd1a9925', './lib/core/Tiki/FileGallery/DirectMapping/EventHandler.php', '28.4', 0),
('c706eef75afd8990d942e2b2b21f7f60', './lib/core/Tiki/FileGallery/DirectMapping/Synchronizer.php', '28.4', 0),
('79d1133a5ccb0e80fc6960ddae8bb6f9', './lib/core/Tiki/FileGallery/DirectMapping/Utilities.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/FileGallery/DirectMapping/index.php', '28.4', 0),
('f2a6c048560b06940ea1d5851348ada7', './lib/core/Tiki/FileGallery/File.php', '28.4', 0),
('f07e70a8185f9f7ed8990be67b9fe80b', './lib/core/Tiki/FileGallery/FileDraft.php', '28.4', 0),
('92d8b761a5ede7054adc529085c5198f', './lib/core/Tiki/FileGallery/FileWrapper/FlysystemFile.php', '28.4', 0),
('e46d6f345a26cb2bf3c8a0d0df341951', './lib/core/Tiki/FileGallery/FileWrapper/PhysicalFile.php', '28.4', 0),
('947cb3a2fe1d7b524870db709c0ab701', './lib/core/Tiki/FileGallery/FileWrapper/PreloadedContent.php', '28.4', 0),
('7ff3c6829a6e6abc5d70710b395ace2c', './lib/core/Tiki/FileGallery/FileWrapper/WrapperInterface.php', '28.4', 0),
('bb6cc1f495af0511af90142e12396e17', './lib/core/Tiki/FileGallery/FileWrapper/WriteException.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/FileGallery/FileWrapper/index.php', '28.4', 0),
('45a068f5d6d00b31eda2c5905e45c9a7', './lib/core/Tiki/FileGallery/Handler/AdapterNotFoundException.php', '28.4', 0),
('9b69e093affbe18afcef31168a4d1475', './lib/core/Tiki/FileGallery/Handler/FileSystem.php', '28.4', 0),
('30867ea964baabd5a9a7c11e6a0c696a', './lib/core/Tiki/FileGallery/Handler/Flysystem.php', '28.4', 0),
('ef6d7caeec736578073c3db8b214229b', './lib/core/Tiki/FileGallery/Handler/HandlerInterface.php', '28.4', 0),
('91f7c3b35b4bc8358ed6decb5dfe1c50', './lib/core/Tiki/FileGallery/Handler/Podcast.php', '28.4', 0),
('183fe9553893e418f0ffbdc8e02f076a', './lib/core/Tiki/FileGallery/Handler/Preloaded.php', '28.4', 0),
('ff149ee3e179dcf62cf221c48fc2229a', './lib/core/Tiki/FileGallery/Handler/System.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/FileGallery/Handler/index.php', '28.4', 0),
('4fe679472d5161ae48cb85b2196340d4', './lib/core/Tiki/FileGallery/Manipulator/EmailParser.php', '28.4', 0),
('2a914f8d71d09f4a7a68f6d198936d60', './lib/core/Tiki/FileGallery/Manipulator/ImageTransformer.php', '28.4', 0),
('c89c6d213acf71c8a93537b4f3ba1ed1', './lib/core/Tiki/FileGallery/Manipulator/Manipulator.php', '28.4', 0),
('751ba7d053e8294ccea7f2ae941f2121', './lib/core/Tiki/FileGallery/Manipulator/MetadataExtractor.php', '28.4', 0),
('17e4d89920364ee7753337b8c18b6e02', './lib/core/Tiki/FileGallery/Manipulator/Validator.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/FileGallery/Manipulator/index.php', '28.4', 0),
('c6a12e5b73bf55938a85e36515b1b082', './lib/core/Tiki/FileGallery/SaveHandler.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/FileGallery/index.php', '28.4', 0),
('3c9386dcb45bd12ab6e91c49533c05f4', './lib/core/Tiki/Files/AbstractCheckGallery.php', '28.4', 0),
('ddd32c5e460b539ec80006eb6adead5f', './lib/core/Tiki/Files/CheckAttachmentGallery.php', '28.4', 0),
('5a3e06087dc8e6ac301ed46941adf411', './lib/core/Tiki/Files/CheckFileGallery.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Files/index.php', '28.4', 0),
('e4d0d51244d7b6dffe6404c5f00f503d', './lib/core/Tiki/Log.php', '28.4', 0),
('be2ffb83de1cc781a0ea8027936886cd', './lib/core/Tiki/MailIn/Account.php', '28.4', 0),
('1e8c0de7aa405cd74d8a87cfa0a2f431', './lib/core/Tiki/MailIn/Action/ActionInterface.php', '28.4', 0),
('6f4e06fdd80659d2765e3f6021c62bcd', './lib/core/Tiki/MailIn/Action/ArticlePut.php', '28.4', 0),
('d4308b84dcebc9acdb05688e1835b97a', './lib/core/Tiki/MailIn/Action/Comment.php', '28.4', 0),
('011d9d6bb1607cff74880303f83ca22b', './lib/core/Tiki/MailIn/Action/DirectFactory.php', '28.4', 0),
('cb67fd055a30eb67a25bd3119c4b4490', './lib/core/Tiki/MailIn/Action/FactoryInterface.php', '28.4', 0),
('dd3b3879ea09f963071f2188de34a425', './lib/core/Tiki/MailIn/Action/FilePut.php', '28.4', 0),
('622d331453f080cb5d115521490e0395', './lib/core/Tiki/MailIn/Action/RecipientPlaceholderFactory.php', '28.4', 0),
('fafe1e897cc3cbc371cf3d4879a24bf6', './lib/core/Tiki/MailIn/Action/SubjectPrefixFactory.php', '28.4', 0),
('21680e3ab1a92386bbff096b4a5f1345', './lib/core/Tiki/MailIn/Action/Tracker.php', '28.4', 0),
('b9f78c6d617543a56b30eed8dd78cc4a', './lib/core/Tiki/MailIn/Action/WikiAppend.php', '28.4', 0),
('0bb7db59f52d504512c6e444c1df0795', './lib/core/Tiki/MailIn/Action/WikiGet.php', '28.4', 0),
('43268d464a897e01f6a655be18a62b29', './lib/core/Tiki/MailIn/Action/WikiPrepend.php', '28.4', 0),
('651bcb4060d26973ad473ad4dacfeb75', './lib/core/Tiki/MailIn/Action/WikiPut.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/MailIn/Action/index.php', '28.4', 0),
('a98cd3c3ad3a51d8d632f654ad849f54', './lib/core/Tiki/MailIn/Exception/MailInException.php', '28.4', 0),
('ae14ce6f8cb4bcbd98afc0fe7d8d7a33', './lib/core/Tiki/MailIn/Exception/TransportException.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/MailIn/Exception/index.php', '28.4', 0),
('07c64e24152a7a4dd80cf0257bd6bb45', './lib/core/Tiki/MailIn/Provider/ArticlePutProvider.php', '28.4', 0),
('b828b1d26f71963e1cddc4e87bf3f8ec', './lib/core/Tiki/MailIn/Provider/BasicWikiProvider.php', '28.4', 0),
('af4350350e808f096df1a65e750d214d', './lib/core/Tiki/MailIn/Provider/CompilerPass.php', '28.4', 0),
('24c7095caeef4ee822bafdef3e7f2a6a', './lib/core/Tiki/MailIn/Provider/FilePutProvider.php', '28.4', 0),
('985abfc9849de82f30aa404d964b5bbe', './lib/core/Tiki/MailIn/Provider/ProviderInterface.php', '28.4', 0),
('a96270df2ee369c916ed1db0236857f7', './lib/core/Tiki/MailIn/Provider/ProviderList.php', '28.4', 0),
('9b6141bb1336f8941e3d8362a72ad86f', './lib/core/Tiki/MailIn/Provider/ReplyHandlerProvider.php', '28.4', 0),
('200e7ac5d239897adcaab095ff13a6dc', './lib/core/Tiki/MailIn/Provider/TrackerProvider.php', '28.4', 0),
('84e1f4d207f6f4e26bf1a99363291712', './lib/core/Tiki/MailIn/Provider/WikiMultipleProvider.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/MailIn/Provider/index.php', '28.4', 0),
('0a9311a776aaf6c09f5cb626d6d273dc', './lib/core/Tiki/MailIn/Source/Imap.php', '28.4', 0),
('2c9f03f33eb2f03bce8ebb7af0573a21', './lib/core/Tiki/MailIn/Source/Message.php', '28.4', 0),
('95b5f0c45205c8b51e35063378b7fe4b', './lib/core/Tiki/MailIn/Source/Pop3.php', '28.4', 0),
('4c5c6a37dca95114ea8d795b88581c25', './lib/core/Tiki/MailIn/Source/SourceInterface.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/MailIn/Source/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/MailIn/index.php', '28.4', 0),
('3b8480e8e6b0f6976c7bd219b6cfbf6c', './lib/core/Tiki/MemoryLimit.php', '28.4', 0),
('2f85be2a5246c6a04289b1b662228e15', './lib/core/Tiki/ObjectSelector/Selector.php', '28.4', 0),
('348a691f20263b3ffd0995a87da4726f', './lib/core/Tiki/ObjectSelector/SelectorItem.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/ObjectSelector/index.php', '28.4', 0),
('556a9c005cc3aa353b9d5b231cfe6462', './lib/core/Tiki/PSR12Migration/Autoload.php', '28.4', 0),
('6259ca2af4f927c2feda738914848983', './lib/core/Tiki/PSR12Migration/Report.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/PSR12Migration/index.php', '28.4', 0),
('c2e60ee0d4801c89ba21170984fab4a3', './lib/core/Tiki/Package/ComposerCli.php', '28.4', 0),
('4b14731aeb09f253e3c9950cf1c6ac0b', './lib/core/Tiki/Package/ComposerManager.php', '28.4', 0),
('8fad3fcfc66094a0f66b23ca5d3f0445', './lib/core/Tiki/Package/ComposerPackage.php', '28.4', 0),
('8d844781473f2a9617cd55686543e541', './lib/core/Tiki/Package/Extension/Api.php', '28.4', 0),
('8eb9f9bf95929c171c7b0e18ab3ffe99', './lib/core/Tiki/Package/Extension/Api/Events.php', '28.4', 0),
('4f1f3f54b8b0609b26786fb5f7ec9fa3', './lib/core/Tiki/Package/Extension/Api/Search.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/core/Tiki/Package/Extension/Api/index.php', '28.4', 0),
('8e77ebb248fffd994f9939c5683d6a1b', './lib/core/Tiki/Package/Extension/Extension.php', '28.4', 0),
('ff0cbe2e2744fb2c004483a3edc99aa8', './lib/core/Tiki/Package/Extension/Utilities.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Package/Extension/index.php', '28.4', 0),
('620274f62f652eded023a7f0f568e76f', './lib/core/Tiki/Package/ExtensionManager.php', '28.4', 0),
('7b18e17f3d9e04d1fd022fdf43a06b55', './lib/core/Tiki/Package/PackageCommandHelper.php', '28.4', 0),
('932e064f2e37adc386cfbd354abb61c8', './lib/core/Tiki/Package/PackageInformationCache.php', '28.4', 0),
('6182907d18e727a08bf41dffb8c68692', './lib/core/Tiki/Package/VendorHelper.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Package/index.php', '28.4', 0),
('bd9915bf2a87ae22a782af14677e21bd', './lib/core/Tiki/PageCache.php', '28.4', 0),
('d82f6ed04c85354d9b68fab2f8e96c23', './lib/core/Tiki/Paths/Customization.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Paths/index.php', '28.4', 0),
('0f477dece2ed4ecc7146dcf83a6f2111', './lib/core/Tiki/Process/PhpExecutableFinder.php', '28.4', 0),
('6e7065b98350f7d6be71b90e7b2d85d6', './lib/core/Tiki/Process/Process.php', '28.4', 0),
('0c20f9c1d08acd32ee38623b0c2aa115', './lib/core/Tiki/Process/ProcessFactory.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Process/index.php', '28.4', 0),
('83b6d28d4e9350eb051462f25d0255ea', './lib/core/Tiki/Profile.php', '28.4', 0),
('154e5e385a05eee5e3003576f8bcb138', './lib/core/Tiki/Profile/ChannelList.php', '28.4', 0),
('d0e80f3df1de1582a39c8d3fa7321427', './lib/core/Tiki/Profile/Converter.php', '28.4', 0),
('f930008cfbf9ee3f1993a328263c39e5', './lib/core/Tiki/Profile/DateConverter.php', '28.4', 0),
('706ed7f68f04a2b12e6f247253089e6e', './lib/core/Tiki/Profile/InstallHandler.php', '28.4', 0),
('bf0479d9b65ac0f7f9c0e965714746e9', './lib/core/Tiki/Profile/InstallHandler/ActivityRuleSet.php', '28.4', 0),
('9a5cacf4a3c886bbb7ccdb8260d331b0', './lib/core/Tiki/Profile/InstallHandler/ActivityStreamRule.php', '28.4', 0),
('34a0fbb9eeada90fe1c9f5f55fd5cd2b', './lib/core/Tiki/Profile/InstallHandler/AreaBinding.php', '28.4', 0),
('40b8c6fe2300a2e54c31a8cd19fa3765', './lib/core/Tiki/Profile/InstallHandler/Article.php', '28.4', 0),
('cda812cb69d63b87c702d0fff63b98ec', './lib/core/Tiki/Profile/InstallHandler/ArticleTopic.php', '28.4', 0),
('08e818f3607af4626a183b177df67ae7', './lib/core/Tiki/Profile/InstallHandler/ArticleType.php', '28.4', 0),
('f98def330a58967b10686f95590676fd', './lib/core/Tiki/Profile/InstallHandler/Blog.php', '28.4', 0),
('aa59ee01c7fbb47bade0a3a757006fe6', './lib/core/Tiki/Profile/InstallHandler/BlogPost.php', '28.4', 0),
('732f91c5c6d6dea9f6dd186f4f9f0bfd', './lib/core/Tiki/Profile/InstallHandler/Calendar.php', '28.4', 0),
('2aa042691b26cf6e953b80ab94642b52', './lib/core/Tiki/Profile/InstallHandler/Categorize.php', '28.4', 0),
('60d12c894ea7e2967bb03f5dc91a965c', './lib/core/Tiki/Profile/InstallHandler/Category.php', '28.4', 0),
('3b3900fc026ca808eeaef45b00321ed0', './lib/core/Tiki/Profile/InstallHandler/DataChannel.php', '28.4', 0),
('af7283d106cfdb6d55c77d8b12ff2f52', './lib/core/Tiki/Profile/InstallHandler/ExtWiki.php', '28.4', 0),
('122fa4dcd1a5994b5f01b162b4fd7678', './lib/core/Tiki/Profile/InstallHandler/FileGallery.php', '28.4', 0),
('ce0bae444de0dbda3e661d176e7a5944', './lib/core/Tiki/Profile/InstallHandler/Forum.php', '28.4', 0),
('b37f6fcc3c3d8a392f695e48b6bf3218', './lib/core/Tiki/Profile/InstallHandler/Goal.php', '28.4', 0),
('ee5e937fdab5b111e181a0ed141e81b1', './lib/core/Tiki/Profile/InstallHandler/GoalSet.php', '28.4', 0),
('6eb34272165d4afdeae91ea6674364ad', './lib/core/Tiki/Profile/InstallHandler/Menu.php', '28.4', 0),
('8918a744bc9bbf20b2d108b2c6b9dc85', './lib/core/Tiki/Profile/InstallHandler/MenuOption.php', '28.4', 0),
('292a5bbcb686de08a144a34170a17a10', './lib/core/Tiki/Profile/InstallHandler/Module.php', '28.4', 0),
('ef3609c6306511674857d8b687670dac', './lib/core/Tiki/Profile/InstallHandler/Perspective.php', '28.4', 0),
('b3a29115ff6ba0d5f4f85f60f98e8126', './lib/core/Tiki/Profile/InstallHandler/PluginAlias.php', '28.4', 0),
('9f0f715b964e0ac46ce3ea3ea614d87c', './lib/core/Tiki/Profile/InstallHandler/RatingConfig.php', '28.4', 0),
('62203dab63d8512cad7a9a62ce86ca18', './lib/core/Tiki/Profile/InstallHandler/RatingConfigSet.php', '28.4', 0),
('f670ad3469be93c5194e56302290b43d', './lib/core/Tiki/Profile/InstallHandler/Rss.php', '28.4', 0),
('2e524861a4493041d9fc931897d5ba29', './lib/core/Tiki/Profile/InstallHandler/Scheduler.php', '28.4', 0),
('6dece7f0e3ac22737751ff05c7fa1980', './lib/core/Tiki/Profile/InstallHandler/Sheet.php', '28.4', 0),
('e8c8231030ba8be4b10839ec1310eb31', './lib/core/Tiki/Profile/InstallHandler/Tabular.php', '28.4', 0),
('a70053dbbd97a9a6d28dfff2705fe926', './lib/core/Tiki/Profile/InstallHandler/Template.php', '28.4', 0),
('efbc87e82ee64a034f8f92bf8e49d4fa', './lib/core/Tiki/Profile/InstallHandler/Tracker.php', '28.4', 0),
('30638c08ecef0869c1a3d855c5430a31', './lib/core/Tiki/Profile/InstallHandler/TrackerField.php', '28.4', 0),
('31cd7ee51adba0a9e02444dc4edbd24e', './lib/core/Tiki/Profile/InstallHandler/TrackerItem.php', '28.4', 0),
('8c79f3beaf703157ff6404d9cab029d8', './lib/core/Tiki/Profile/InstallHandler/TrackerOption.php', '28.4', 0),
('86a26b0608061584b936fb3298cd1f40', './lib/core/Tiki/Profile/InstallHandler/Transition.php', '28.4', 0),
('66a3cfe37ec33ff00a94eb20521d5ffc', './lib/core/Tiki/Profile/InstallHandler/User.php', '28.4', 0),
('3cad0f3a01d8665e7b0c7dfe000bb579', './lib/core/Tiki/Profile/InstallHandler/Webmail.php', '28.4', 0),
('471db90aae06a066ed0eb15b6beefdeb', './lib/core/Tiki/Profile/InstallHandler/Webservice.php', '28.4', 0),
('ae43d8eb9aa9f1715be77185b5afa7ba', './lib/core/Tiki/Profile/InstallHandler/WebserviceTemplate.php', '28.4', 0),
('be46089ef033c71b8382acb196b019cb', './lib/core/Tiki/Profile/InstallHandler/WikiPage.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Profile/InstallHandler/index.php', '28.4', 0),
('2666aa1c59b79e1689dbc1f8fccf56ee', './lib/core/Tiki/Profile/Installer.php', '28.4', 0),
('5715b9af782891ec8f655ddda1a54dec', './lib/core/Tiki/Profile/List.php', '28.4', 0),
('9c41145998372fe7fc80a9d8f6a3a080', './lib/core/Tiki/Profile/Object.php', '28.4', 0),
('b931ef38aa7671fd3b08827d708b4aac', './lib/core/Tiki/Profile/SymbolLoader.php', '28.4', 0),
('bf20ff97c9b30c383a683f35b0e0d8a9', './lib/core/Tiki/Profile/Transport/File.php', '28.4', 0),
('23ae5de1374ed916199ea6cfec915a70', './lib/core/Tiki/Profile/Transport/Interface.php', '28.4', 0),
('5118d14b86b48d2d9567749fbf7f0974', './lib/core/Tiki/Profile/Transport/Local.php', '28.4', 0),
('c6b3fbbc5c24e77a7e18abc5fe4648a7', './lib/core/Tiki/Profile/Transport/Repository.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Profile/Transport/index.php', '28.4', 0),
('5eba5a3673437e203a3041de7e9607f5', './lib/core/Tiki/Profile/ValueMapConverter.php', '28.4', 0),
('2eb90ea94edc911b40b25cfe8bc7a632', './lib/core/Tiki/Profile/Writer.php', '28.4', 0),
('25a6c0437db98d0ddc9d7762b431add2', './lib/core/Tiki/Profile/Writer/ExternalWriter.php', '28.4', 0),
('dc6cea114558f767d133d415191eabee', './lib/core/Tiki/Profile/Writer/Helper.php', '28.4', 0),
('714c542fbc9a4389cc0bb111c21c5192', './lib/core/Tiki/Profile/Writer/ProfileFinder.php', '28.4', 0),
('985a3d9970b03ca2f9a266bbd63ad922', './lib/core/Tiki/Profile/Writer/Queue.php', '28.4', 0),
('430e8c9bd108acd053048ff311c53ac7', './lib/core/Tiki/Profile/Writer/ReferenceProvider.php', '28.4', 0),
('efe057b270fccbb60ed2c91858f5f9f0', './lib/core/Tiki/Profile/Writer/SearchFieldHelper.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Profile/Writer/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Profile/index.php', '28.4', 0),
('fdd4c91d7c050cd6924a4e120376cb86', './lib/core/Tiki/Profiling/DatabaseQueryLog.php', '28.4', 0),
('8c40660cf6d050500fa9e3a57e967203', './lib/core/Tiki/Profiling/Memory.php', '28.4', 0),
('1c2b067a595e936045e043765710dbbf', './lib/core/Tiki/Profiling/Timer.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Profiling/index.php', '28.4', 0),
('efadab3701fb5985956e3afa786a0863', './lib/core/Tiki/Recommendation/BatchProcessor.php', '28.4', 0),
('cc5387a8ffce4c468139e7722db65b93', './lib/core/Tiki/Recommendation/Comparator.php', '28.4', 0),
('7d7118fb7e2635fe8460b3e98901ed35', './lib/core/Tiki/Recommendation/Debug/SourceDocument.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Recommendation/Debug/index.php', '28.4', 0),
('c7a243b25ad0f58d44d82eac8208068d', './lib/core/Tiki/Recommendation/Engine/CompilerPass.php', '28.4', 0),
('68fcd695ff3c8fb018b90de5c6027d6f', './lib/core/Tiki/Recommendation/Engine/EngineInterface.php', '28.4', 0),
('9df8c6290ce2356fb852bd3e86f76c40', './lib/core/Tiki/Recommendation/Engine/FakeEngine.php', '28.4', 0),
('a73d22935941508d6b9e7dbcce434ff7', './lib/core/Tiki/Recommendation/Engine/UserFavorite.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Recommendation/Engine/index.php', '28.4', 0),
('3712d3bea1f90c93c50f8949fe49346a', './lib/core/Tiki/Recommendation/EngineOutput.php', '28.4', 0),
('ef97bf02903046aa6517c466c511382a', './lib/core/Tiki/Recommendation/EngineSet.php', '28.4', 0),
('cfd1a8a6b6448875d0eda035d0feebfd', './lib/core/Tiki/Recommendation/Input/UserInput.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Recommendation/Input/index.php', '28.4', 0),
('a9b4622b8c3672808cbbf77f519feddd', './lib/core/Tiki/Recommendation/Recommendation.php', '28.4', 0),
('387b4dcf5d86ae7c3f05652e4cfeebd6', './lib/core/Tiki/Recommendation/RecommendationSet.php', '28.4', 0),
('22f1cd98b46aa689ecb057fd30defd91', './lib/core/Tiki/Recommendation/Store/ActivityStore.php', '28.4', 0),
('b07faefe96dae07cde52c6caee8c5d3d', './lib/core/Tiki/Recommendation/Store/StoreInterface.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Recommendation/Store/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Recommendation/index.php', '28.4', 0),
('55b8b1100eec623338e55a2e6f2fb825', './lib/core/Tiki/Relation/ObjectRelation.php', '28.4', 0),
('3a5de42aa09ad0f4f37aa7229d3f1408', './lib/core/Tiki/Relation/Parts/Link.php', '28.4', 0),
('19886b86b73df01416abf740985e5a32', './lib/core/Tiki/Relation/Parts/Metadata.php', '28.4', 0),
('4bc4f5e12d7668e0ed2745a8e8373dd3', './lib/core/Tiki/Relation/Parts/Source.php', '28.4', 0),
('a29791327949539a6bf4f49752b0a6af', './lib/core/Tiki/Relation/Parts/Target.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Relation/Parts/index.php', '28.4', 0),
('7ac9d4737c5c0f5ea888f31047a1e7bd', './lib/core/Tiki/Relation/Semantics.php', '28.4', 0),
('1f871fc0b6f45ae39114d2bd9e039013', './lib/core/Tiki/Relation/SystemTrackerCreator.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Relation/index.php', '28.4', 0),
('40a141e05a7cf8b06e0d774f37795ac6', './lib/core/Tiki/Render/Editable.php', '28.4', 0),
('2ffa421383f22282fedb4bb09a412acc', './lib/core/Tiki/Render/Lazy.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Render/index.php', '28.4', 0),
('b09476abccaf02b71adefdae2c9dcc5a', './lib/core/Tiki/Request.php', '28.4', 0),
('57e50fd1c2a840a415a3d1c6389b59f9', './lib/core/Tiki/SabreDav/AclPlugin.php', '28.4', 0),
('8ed3a7f6cb4549e997f1388601db4d3e', './lib/core/Tiki/SabreDav/AddressBookType/AddressBookTypeInterface.php', '28.4', 0),
('e2b81faba705d6ec36153ad7651e4e02', './lib/core/Tiki/SabreDav/AddressBookType/Custom.php', '28.4', 0),
('e94e35f5f83a5d0e63851404820d7efa', './lib/core/Tiki/SabreDav/AddressBookType/Factory.php', '28.4', 0),
('026a379423022c572a15939c403680d4', './lib/core/Tiki/SabreDav/AddressBookType/System.php', '28.4', 0),
('e6bba4b27a22904cc74ddc2470a53bab', './lib/core/Tiki/SabreDav/AddressBookType/Webmail.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/SabreDav/AddressBookType/index.php', '28.4', 0),
('044a530d9d5769ed998eaca52cc8c551', './lib/core/Tiki/SabreDav/BasicAuth.php', '28.4', 0),
('ad5b343014f78fe3bbf80aba53fb50a7', './lib/core/Tiki/SabreDav/CalDAVBackend.php', '28.4', 0),
('203f8264c6fd3b36456521246ba85272', './lib/core/Tiki/SabreDav/CaldavClient.php', '28.4', 0),
('02d37adfdb69e112d8f28d5d49797b0e', './lib/core/Tiki/SabreDav/CaldavPlugin.php', '28.4', 0),
('f25eb45f85e0cc363306309e47df3242', './lib/core/Tiki/SabreDav/CardDAVBackend.php', '28.4', 0),
('87bcd6d0b67baa1b5b6a26e79973f532', './lib/core/Tiki/SabreDav/Directory.php', '28.4', 0),
('9f69737b190d9f34a0b3e52dff8a6f5f', './lib/core/Tiki/SabreDav/File.php', '28.4', 0),
('b6208be222261175d102ff477546c60e', './lib/core/Tiki/SabreDav/InternalAuth.php', '28.4', 0),
('ea5bbdc6108c0be78a9aa0b1402ebceb', './lib/core/Tiki/SabreDav/LocksBackend.php', '28.4', 0),
('b51fed1759e92d0ee394d3c5ef28d426', './lib/core/Tiki/SabreDav/PrincipalBackend.php', '28.4', 0),
('c06d61d220b32b414503f65bf923fc77', './lib/core/Tiki/SabreDav/Utilities.php', '28.4', 0),
('c106d6787207c1aad72109a6e61a6bea', './lib/core/Tiki/SabreDav/WikiDirectory.php', '28.4', 0),
('41e4b18ba396a330c0b1e11e7d9e8a67', './lib/core/Tiki/SabreDav/WikiPage.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/SabreDav/index.php', '28.4', 0),
('9dee00ad2bc21eee7c1df49e906777ad', './lib/core/Tiki/Security.php', '28.4', 0),
('d779b1470b6e50d45636d47a314d4b03', './lib/core/Tiki/Sitemap/AbstractType.php', '28.4', 0),
('2a1465a2c0540ba208ae8276b54557b1', './lib/core/Tiki/Sitemap/Generator.php', '28.4', 0),
('79983eca0504af0cd28acfc2318c6ede', './lib/core/Tiki/Sitemap/Type/Articles.php', '28.4', 0),
('d4e4074aa45b088cead220a98b421760', './lib/core/Tiki/Sitemap/Type/Blog.php', '28.4', 0),
('5762514a852c2693c81dbbf7f697e36e', './lib/core/Tiki/Sitemap/Type/Forums.php', '28.4', 0),
('7a17b2eaf1e23155fa947fe971a305f7', './lib/core/Tiki/Sitemap/Type/Page.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Sitemap/Type/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Sitemap/index.php', '28.4', 0),
('b65f19186c2cb5bafc8c59bc1c234cf3', './lib/core/Tiki/Suggestion/Helpers/Community.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Suggestion/Helpers/index.php', '28.4', 0),
('44e9246e7386479924f3c4f7dac78c54', './lib/core/Tiki/Suggestion/Performance/Informations.php', '28.4', 0),
('f8c1d95ac38cb9970a767461a6ddcfbf', './lib/core/Tiki/Suggestion/Performance/NumberFiles.php', '28.4', 0),
('fb0785f0072dc30af4283c58977b32fc', './lib/core/Tiki/Suggestion/Performance/NumberTrackers.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Suggestion/Performance/index.php', '28.4', 0),
('c35bc1e0c5ec10de213f780873f6daaa', './lib/core/Tiki/Suggestion/Rules.php', '28.4', 0),
('db8f365d6fe62a2ce01eb9505e00d6b8', './lib/core/Tiki/Suggestion/SuggestionRulesInterface.php', '28.4', 0),
('1faca8876d1e1405db37a8f6ce2f1257', './lib/core/Tiki/Suggestion/TikiCheck/Version.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Suggestion/TikiCheck/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Suggestion/index.php', '28.4', 0),
('ff4d771765fc05fe73add972eecfe125', './lib/core/Tiki/Theme/Handler.php', '28.4', 0),
('2aab14cd45310778e9b3011f5647b6dd', './lib/core/Tiki/Theme/Menu.php', '28.4', 0),
('14ea3c4571766d94d43b216847d4d69d', './lib/core/Tiki/Theme/Module.php', '28.4', 0),
('c997a508000614d216fa898c1195b338', './lib/core/Tiki/Theme/ThemeInstaller.php', '28.4', 0),
('d1b83d42dfcd80a1bf0b49709749c50a', './lib/core/Tiki/Theme/Zip.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Theme/index.php', '28.4', 0),
('6ea3e0606b0f56b40f5a1bfe1a0f00b7', './lib/core/Tiki/TikiInit.php', '28.4', 0),
('1233bd76d2ad4290f44c1114f3c1525d', './lib/core/Tiki/TimeLimit.php', '28.4', 0),
('40ed82c7a3c562a58f37bf5e348b53c5', './lib/core/Tiki/Transition.php', '28.4', 0),
('c48c15680ccf6b62810cc0bbbaa647c8', './lib/core/Tiki/Url.php', '28.4', 0),
('fec71d272b06f6f5febe3f18e4d1e2c2', './lib/core/Tiki/Utilities/Identifiers.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Utilities/index.php', '28.4', 0),
('8c2735b2cc5eb416de4b21ce77f3af74', './lib/core/Tiki/Version/Checker.php', '28.4', 0),
('557a3c863051162a92035fe5cbb993b1', './lib/core/Tiki/Version/Upgrade.php', '28.4', 0),
('ed6849f6e3af4941e32f52333d3566ea', './lib/core/Tiki/Version/Utils.php', '28.4', 0),
('a4841f5c9755bc769e1bbfa43c181cfa', './lib/core/Tiki/Version/Version.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Version/index.php', '28.4', 0),
('9fe174e30ab30d7643e7ca8bb9c9135e', './lib/core/Tiki/Wiki/SlugManager.php', '28.4', 0),
('ad340b3e2cf34644aeae9cf040c33e87', './lib/core/Tiki/Wiki/SlugManager/CompilerPass.php', '28.4', 0),
('a6fd94547a10587cedd11e98295c6290', './lib/core/Tiki/Wiki/SlugManager/DashGenerator.php', '28.4', 0),
('ec7bea170bc2ccf3cac683de0e19b8b4', './lib/core/Tiki/Wiki/SlugManager/Generator.php', '28.4', 0),
('71f541f16f660b6f2a273ef660bbb17f', './lib/core/Tiki/Wiki/SlugManager/InMemoryTracker.php', '28.4', 0),
('06788b89314005bb79315aef4c0c710b', './lib/core/Tiki/Wiki/SlugManager/UnderscoreGenerator.php', '28.4', 0),
('4f893013e57b15b17b2bfbc00ced7195', './lib/core/Tiki/Wiki/SlugManager/UrlencodeGenerator.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tiki/Wiki/SlugManager/index.php', '28.4', 0),
('fbced9f920c121bf01fec09ba2dfdb3b', './lib/core/Tiki/Wiki/WikiPaginationUtils.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tiki/Wiki/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Tiki/index.php', '28.4', 0),
('cc9d6bdad7320253eed50a0ef46b49e1', './lib/core/TikiDb.php', '28.4', 0),
('92cd23d49dbae5a0bec0f711fb544d16', './lib/core/TikiDb/Adodb.php', '28.4', 0),
('6fc248af09381e007ba31dd2137d680c', './lib/core/TikiDb/Bridge.php', '28.4', 0),
('c1bff2c4d8da452072897dda4a7214fd', './lib/core/TikiDb/ErrorHandler.php', '28.4', 0),
('bf74e1c484338cd90cf44bb6d744ecef', './lib/core/TikiDb/Exception.php', '28.4', 0),
('95ba04e3a8c3c62c0c06c283b295530e', './lib/core/TikiDb/Exception/DuplicateEntry.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/TikiDb/Exception/index.php', '28.4', 0),
('34e596b9a115d76cb82cb51655ec12b8', './lib/core/TikiDb/Expr.php', '28.4', 0),
('0c9ad52a15a4c555f6de94d53098d941', './lib/core/TikiDb/Initializer.php', '28.4', 0),
('3e9bbd1c277a85051662b46037ae7ebf', './lib/core/TikiDb/Initializer/Adodb.php', '28.4', 0),
('6f17b400cfff18b65d483529fa1876b2', './lib/core/TikiDb/Initializer/Pdo.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/TikiDb/Initializer/index.php', '28.4', 0),
('ea577e8ed00dede7598d67c16a98d860', './lib/core/TikiDb/MasterSlaveDispatch.php', '28.4', 0),
('7fa31281726e5b09e5fadec487f64ffe', './lib/core/TikiDb/Pdo.php', '28.4', 0),
('acaf27ba6103445fc929436f5da059bc', './lib/core/TikiDb/SanitizeEncoding.php', '28.4', 0),
('e0cc9450773b7ebf58d989e6c2bd612c', './lib/core/TikiDb/Table.php', '28.4', 0),
('e0ff8449047161e4b64636385ea75164', './lib/core/TikiDb/Transaction.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/TikiDb/index.php', '28.4', 0),
('d8d4c77fccd68bd9d1a532411e4982ca', './lib/core/TikiFilter.php', '28.4', 0),
('6206e39fd89a9afd8aa1108ab637b16d', './lib/core/TikiFilter/Alnum.php', '28.4', 0),
('5d115c79d4a440ecd27eb9e9269203b7', './lib/core/TikiFilter/Alpha.php', '28.4', 0),
('42d270b79ea1f6f1514d70f6a97f3105', './lib/core/TikiFilter/Array.php', '28.4', 0),
('c392d1760510e2fba791d8098a97452a', './lib/core/TikiFilter/AttributeType.php', '28.4', 0),
('ed848e9f1e463011b2d4626daec8212b', './lib/core/TikiFilter/Callback.php', '28.4', 0),
('0c4563ddbc15ebc5f730ec9c7867e490', './lib/core/TikiFilter/HtmlPurifier.php', '28.4', 0),
('3cad82319b8c6032bb01e013408ab41c', './lib/core/TikiFilter/IsoDate.php', '28.4', 0),
('753c926ad967756d193f2b20d95e42ff', './lib/core/TikiFilter/Lang.php', '28.4', 0),
('1b4a119cebd50c58e1a8a6261419210e', './lib/core/TikiFilter/None.php', '28.4', 0),
('8f0fd166c5bb347723a1fdcf291b75ba', './lib/core/TikiFilter/PregFilter.php', '28.4', 0),
('80cccfea5547fa0ec28900e7e37ce694', './lib/core/TikiFilter/PrepareInput.php', '28.4', 0),
('90506857c65942949ffa3511a27f56bb', './lib/core/TikiFilter/PreventXss.php', '28.4', 0),
('9dacb67e47c3edc34892d6b17c326ed1', './lib/core/TikiFilter/Raw.php', '28.4', 0),
('da1cd314bd0bc3f5954bd6e949187873', './lib/core/TikiFilter/RawUnsafe.php', '28.4', 0),
('ce5e15f9b4308952171ef468bd0a6689', './lib/core/TikiFilter/RelativeURL.php', '28.4', 0),
('d83489f0cdab4acbd8e7bc9a9c274ba0', './lib/core/TikiFilter/StripTags.php', '28.4', 0),
('89f9fa52d9b2eccb4fa828b2ca058083', './lib/core/TikiFilter/WikiContent.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/TikiFilter/index.php', '28.4', 0),
('a072403692bb12c1f61d0af317cd0f9d', './lib/core/Toolbar/ToolbarAdmin.php', '28.4', 0),
('47799d254bb53f37f8e2c76287c020d0', './lib/core/Toolbar/ToolbarAutosave.php', '28.4', 0),
('a1f1baac5ba68b82aeec7398b7578d65', './lib/core/Toolbar/ToolbarBlock.php', '28.4', 0),
('a444e9b8b9a65ff82f13e819f5e3a6df', './lib/core/Toolbar/ToolbarCkOnly.php', '28.4', 0),
('fd1d7f9e17dbaec3a35b81052b13de62', './lib/core/Toolbar/ToolbarCombos.php', '28.4', 0),
('7fa1455fde37033ca64240f710d2935c', './lib/core/Toolbar/ToolbarDialog.php', '28.4', 0),
('49e9760718b8c627eb98009d9e9d36b7', './lib/core/Toolbar/ToolbarFileGallery.php', '28.4', 0),
('55e80b8067bbd11b541d64966df3e65b', './lib/core/Toolbar/ToolbarFileGalleryFile.php', '28.4', 0),
('221abf11138bd831ae27caeeb2e8cf4e', './lib/core/Toolbar/ToolbarFullscreen.php', '28.4', 0),
('84deab9ae62230809333c57dad7433b2', './lib/core/Toolbar/ToolbarHelptool.php', '28.4', 0),
('784fbf8d325944b0ef707c6182950eb6', './lib/core/Toolbar/ToolbarInline.php', '28.4', 0),
('4d775482d4be42bd94c2d8701d66a05c', './lib/core/Toolbar/ToolbarItem.php', '28.4', 0),
('9f1548bf458b4e54850dee3ed2f9df42', './lib/core/Toolbar/ToolbarLaunchPlugins.php', '28.4', 0),
('d738f12a9b9ab258036f0d7c10bc8320', './lib/core/Toolbar/ToolbarLineBased.php', '28.4', 0),
('9c811439d015e609787e8f799026d748', './lib/core/Toolbar/ToolbarLinkFile.php', '28.4', 0),
('b48bd03341daf7518164ae26b99baa1e', './lib/core/Toolbar/ToolbarPicker.php', '28.4', 0),
('2691e9d97ce6f7357a3804de71785f23', './lib/core/Toolbar/ToolbarSeparator.php', '28.4', 0),
('e9ef8586be523f7ab447704f92f1b643', './lib/core/Toolbar/ToolbarSheet.php', '28.4', 0),
('5840020b6b7bf63cd87edc4017d3417f', './lib/core/Toolbar/ToolbarSpacer.php', '28.4', 0),
('233a8b83890083031ee1552fb4a00549', './lib/core/Toolbar/ToolbarSwitchEditor.php', '28.4', 0),
('37e1a8cac2e8b7445988007f811c019e', './lib/core/Toolbar/ToolbarUtilityItem.php', '28.4', 0),
('1c72277d6ca1b90a7500a1c4b6a2b343', './lib/core/Toolbar/ToolbarWikiplugin.php', '28.4', 0),
('67f84dbef48929c979fcaee4f4096ada', './lib/core/Toolbar/ToolbarsList.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Toolbar/index.php', '28.4', 0),
('7351a5976e01107e6ebd4bf8fdd4e267', './lib/core/Tracker/CompilerPass.php', '28.4', 0),
('8d4d56678cddc8f3888ddabe63eac8c8', './lib/core/Tracker/Definition.php', '28.4', 0),
('73b0a42101124f259e82248713b4dd28', './lib/core/Tracker/Field/AbstractItemField.php', '28.4', 0),
('35b46653127e839185fcd481d3f6a29a', './lib/core/Tracker/Field/AbstractTrackerField.php', '28.4', 0),
('dfe40cda902600afc7f58bd02be3aa21', './lib/core/Tracker/Field/AbstractTrackerFieldRelational.php', '28.4', 0),
('0d0c95aee5e93dc3a4e8141a466b1ddf', './lib/core/Tracker/Field/Action.php', '28.4', 0),
('29897a6ab9e1c6731b0413afa74d45a9', './lib/core/Tracker/Field/Articles.php', '28.4', 0),
('eb07d81465fa32d6f0c17fd2b3b82576', './lib/core/Tracker/Field/AutoIncrement.php', '28.4', 0),
('afec5625984906b5e5055b1cad42a368', './lib/core/Tracker/Field/CalendarItem.php', '28.4', 0),
('480ed50d7720eab3180ea9a7ed0cef06', './lib/core/Tracker/Field/Category.php', '28.4', 0),
('1eb7a05bb32dc852966b690a99de9fe3', './lib/core/Tracker/Field/Checkbox.php', '28.4', 0),
('366d6f142a953b316c36277c3ffd56a8', './lib/core/Tracker/Field/Computed.php', '28.4', 0),
('a203414d38cf178a4dd3a968de3e56ab', './lib/core/Tracker/Field/CountrySelector.php', '28.4', 0),
('d96d0e72c15cca00601aa65d5095dfd3', './lib/core/Tracker/Field/Currency.php', '28.4', 0),
('718b1e35a84f01bcfe8ac37ede061a5c', './lib/core/Tracker/Field/DateTime.php', '28.4', 0),
('0fcd1263b7b2bf3b4877983960c0e247', './lib/core/Tracker/Field/Dropdown.php', '28.4', 0),
('4fdd91f76673bf7f918ad5375fa5c109', './lib/core/Tracker/Field/Duration.php', '28.4', 0),
('cff38970e79edce0eb1f9cf01129a2ff', './lib/core/Tracker/Field/DynamicList.php', '28.4', 0),
('08106c922c9776a21a4581a17e921e47', './lib/core/Tracker/Field/Email.php', '28.4', 0),
('5f67949c2a112d43c51bdda29e28b4f0', './lib/core/Tracker/Field/EmailFolder.php', '28.4', 0),
('a51a071c1113df467c706abd04af16da', './lib/core/Tracker/Field/EnumerableInterface.php', '28.4', 0),
('ffa3ed7977c4c24e40c3dd3c49d2d461', './lib/core/Tracker/Field/ExportableInterface.php', '28.4', 0),
('0d97ab82c30661b35805d6e20dce7bab', './lib/core/Tracker/Field/Factory.php', '28.4', 0),
('42be4c83e91ccef4ae9fa4bb6eeb1217', './lib/core/Tracker/Field/File.php', '28.4', 0),
('24b673479145d7a1f95c8d642267c411', './lib/core/Tracker/Field/Files.php', '28.4', 0),
('e15490c85da7c12f4a97463ce89f2642', './lib/core/Tracker/Field/FilterableInterface.php', '28.4', 0),
('815a83a668195a0235dde9b430a9f5cd', './lib/core/Tracker/Field/Freetags.php', '28.4', 0),
('e8d8326dc84ef3edf65e9f8d954f1616', './lib/core/Tracker/Field/GeographicFeature.php', '28.4', 0),
('c751fcbeb289e16110f6fb7dad933d27', './lib/core/Tracker/Field/GroupSelector.php', '28.4', 0),
('7190953b1d58607da430f4ecffc54919', './lib/core/Tracker/Field/Heading.php', '28.4', 0),
('275a6cf3be1208f3a41c1483682252b9', './lib/core/Tracker/Field/Icon.php', '28.4', 0),
('f77463d3f6e6b0a0a1c3213324a73314', './lib/core/Tracker/Field/Image.php', '28.4', 0),
('09459d4b5bc51e31548ee5d586a2b9cc', './lib/core/Tracker/Field/InGroup.php', '28.4', 0),
('c3a90b5c5d2c3bb3fafbc2785e9a7a89', './lib/core/Tracker/Field/IndexableInterface.php', '28.4', 0),
('132bfb2b10fc25be7f1c5fb94ec9ab6b', './lib/core/Tracker/Field/Ip.php', '28.4', 0),
('c9e95c17d34d24c63b43079db22da7d3', './lib/core/Tracker/Field/ItemFieldInterface.php', '28.4', 0),
('0344cd52fe9d9b8207cbe5ede7fd0ff6', './lib/core/Tracker/Field/ItemLink.php', '28.4', 0),
('d957fa2597af9444d6dd338561a11bbd', './lib/core/Tracker/Field/ItemsList.php', '28.4', 0),
('61d1f632f2c1a2975656a444103f7386', './lib/core/Tracker/Field/JsCalendar.php', '28.4', 0),
('6e1aa773c816f1eb92d19709413e19b2', './lib/core/Tracker/Field/Kaltura.php', '28.4', 0),
('0dd13e3fa57b533ca79e7a42ecd69dbe', './lib/core/Tracker/Field/Language.php', '28.4', 0),
('f8979145b46934a51c373bf9cd0313ba', './lib/core/Tracker/Field/Ldap.php', '28.4', 0),
('ca31a46da7db11ba4e194e6f73361af9', './lib/core/Tracker/Field/Location.php', '28.4', 0),
('d8b5cdcf56003f3627ae7115d823c4af', './lib/core/Tracker/Field/Math.php', '28.4', 0),
('3e094d5df568b60e3eb0762e9e911b01', './lib/core/Tracker/Field/Numeric.php', '28.4', 0),
('6634b22be81080cbaa243f6a88a0e8a7', './lib/core/Tracker/Field/PageSelector.php', '28.4', 0),
('6b2b6b66b74658ece75af270f85d2f31', './lib/core/Tracker/Field/Rating.php', '28.4', 0),
('6198d09b1bf8bcc86a27db12c920b1dc', './lib/core/Tracker/Field/Relation.php', '28.4', 0),
('6d69e8809af003680834886db4404856', './lib/core/Tracker/Field/ShowTikiOrg.php', '28.4', 0),
('df8bc84a6309443c95de206fc40d795b', './lib/core/Tracker/Field/StaticText.php', '28.4', 0),
('faf03e0747d518ce0d70c045d10db1b1', './lib/core/Tracker/Field/SynchronizableInterface.php', '28.4', 0),
('ef4cc39c6ef7bc60bfd670b8bac883bf', './lib/core/Tracker/Field/Text.php', '28.4', 0),
('a51e84bcf8b75926cbbc972019404ef6', './lib/core/Tracker/Field/TextArea.php', '28.4', 0),
('2e8468b5ca59a4dfff2e11f7339d78e3', './lib/core/Tracker/Field/TikiManager.php', '28.4', 0),
('0e4f7a46b480fa7bdd1f2a81050e2c89', './lib/core/Tracker/Field/TrackerFieldDynamicList.php', '28.4', 0),
('46813ff36288b19f40ab7c002fd28112', './lib/core/Tracker/Field/TrackerFieldGeneric.php', '28.4', 0),
('e2bab6754dc33f8a288907c6661b429b', './lib/core/Tracker/Field/TrackerFieldItemLink.php', '28.4', 0),
('96e577c455dec2da9c1e02dbfcdcac50', './lib/core/Tracker/Field/TrackerFieldRelation.php', '28.4', 0),
('06bb51909a6a3a9f1ca55a0806e0c129', './lib/core/Tracker/Field/Url.php', '28.4', 0),
('380fab5236c7981285404c5d8ccc1a9b', './lib/core/Tracker/Field/UserGroups.php', '28.4', 0),
('651d234316218287a060d9bdd9961b50', './lib/core/Tracker/Field/UserPreference.php', '28.4', 0),
('13c32112e2fbecf7db141e12acb6dc4e', './lib/core/Tracker/Field/UserSelector.php', '28.4', 0),
('f1e06d3f4d1eca487ef36321e9103319', './lib/core/Tracker/Field/UserSubscription.php', '28.4', 0),
('9433b93a1981c244745d1ed4ca9f64b4', './lib/core/Tracker/Field/WebService.php', '28.4', 0),
('63c7e408baf1351e57f286ccd302673c', './lib/core/Tracker/Field/Wiki.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tracker/Field/index.php', '28.4', 0),
('5fb18031612ae37a963e5db6f7366b22', './lib/core/Tracker/Filter/Collection.php', '28.4', 0),
('04a1604b319ec360b51dce0c18a3a242', './lib/core/Tracker/Filter/Control/Control.php', '28.4', 0),
('a560593c6297bc998444686618e5f9c3', './lib/core/Tracker/Filter/Control/CurrencyRange.php', '28.4', 0),
('6acd986518ee5a1102807202ed3a12a0', './lib/core/Tracker/Filter/Control/DateRange.php', '28.4', 0),
('48be2dc904792202727b0cc095d80f0d', './lib/core/Tracker/Filter/Control/DropDown.php', '28.4', 0),
('02e32288e29f5680d14364cd6b2c22d7', './lib/core/Tracker/Filter/Control/InlineCheckboxes.php', '28.4', 0),
('d3e8322171312a6c7c94e82e3e8dcb12', './lib/core/Tracker/Filter/Control/MultiSelect.php', '28.4', 0),
('eaff111e53bff9e393b840cd4ac4b2a2', './lib/core/Tracker/Filter/Control/NumericRange.php', '28.4', 0),
('f76708eb2f6222a85708bfc05fbafec0', './lib/core/Tracker/Filter/Control/ObjectSelector.php', '28.4', 0),
('7b83c14f382dc3163b8c946157464046', './lib/core/Tracker/Filter/Control/TextField.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Filter/Control/index.php', '28.4', 0),
('d691e022ecf124985edf08a7d6319074', './lib/core/Tracker/Filter/Exception/Exception.php', '28.4', 0),
('0c1ae2de2c1a12ae57529b36113c0f37', './lib/core/Tracker/Filter/Exception/FieldNotFound.php', '28.4', 0),
('ac6bbad8acfb433fa696222181799803', './lib/core/Tracker/Filter/Exception/ModeNotSupported.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Filter/Exception/index.php', '28.4', 0),
('e1e0cc2e1a3f3f26237c4cf00222b1c6', './lib/core/Tracker/Filter/Filter.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tracker/Filter/index.php', '28.4', 0),
('02f7b3f826c33fa2b807e3a181834561', './lib/core/Tracker/Item.php', '28.4', 0),
('856e66b95e611c43c73ca033fb21ea4a', './lib/core/Tracker/Options.php', '28.4', 0),
('b42736c11727527eb9d500eff83e0adc', './lib/core/Tracker/Query.php', '28.4', 0),
('c8d7759638a7870d0f1c1eac89a523d4', './lib/core/Tracker/RelationInfoEntity.php', '28.4', 0),
('bfcc117b89dff282523a00693ce601cc', './lib/core/Tracker/RelationInfoRelation.php', '28.4', 0),
('74f5a1992b32f8d9b41851133fcf8209', './lib/core/Tracker/Rule/Action/Action.php', '28.4', 0),
('5ee857734c5731159bc60eab3401c852', './lib/core/Tracker/Rule/Action/Editable.php', '28.4', 0),
('4d1de1211e2b1e329ade711d15780541', './lib/core/Tracker/Rule/Action/Hide.php', '28.4', 0),
('029e9a10a52320996739ea0d0d597b33', './lib/core/Tracker/Rule/Action/NoOp.php', '28.4', 0),
('2132920a970e028748b2faabf778b1d6', './lib/core/Tracker/Rule/Action/NotEditable.php', '28.4', 0),
('7cbaedb823bbadee329144b23618c67c', './lib/core/Tracker/Rule/Action/NotRequired.php', '28.4', 0),
('25a331cebaad7c430bc9fcc7c974ff2d', './lib/core/Tracker/Rule/Action/Required.php', '28.4', 0),
('5b2fe3cdcf416e51189cd64a4436130d', './lib/core/Tracker/Rule/Action/SetValue.php', '28.4', 0),
('3509a4edff1f5b372b466e860c023696', './lib/core/Tracker/Rule/Action/Show.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Rule/Action/index.php', '28.4', 0),
('f607853277cf1166d309138bbcb7d542', './lib/core/Tracker/Rule/Column.php', '28.4', 0),
('b2e346fdffc5945bafd844011dee7e68', './lib/core/Tracker/Rule/Definition.php', '28.4', 0),
('a9d1fc873992c9637eff8a58d8306a26', './lib/core/Tracker/Rule/LogicalType/All.php', '28.4', 0),
('625685df8554e9f5a9174c2eaf6067eb', './lib/core/Tracker/Rule/LogicalType/Any.php', '28.4', 0),
('dce8c5967554aecba51b8fdf9473ac5d', './lib/core/Tracker/Rule/LogicalType/LogicalType.php', '28.4', 0),
('ab151ae7885a9654dcba84ee6306f3de', './lib/core/Tracker/Rule/LogicalType/None.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Rule/LogicalType/index.php', '28.4', 0),
('6d906d81a3d9425a77ab676db287101a', './lib/core/Tracker/Rule/Operator/BooleanTrueFalse.php', '28.4', 0),
('8f849c25cd6bcd3428c46364de52b821', './lib/core/Tracker/Rule/Operator/CollectionContains.php', '28.4', 0),
('f3c58f21d9a2c8158481360d53a8a5b0', './lib/core/Tracker/Rule/Operator/CollectionContainsUsername.php', '28.4', 0),
('d4d4720e740596a99acdab90035835f6', './lib/core/Tracker/Rule/Operator/CollectionEmpty.php', '28.4', 0),
('dd7af3b31286fcb42ef4a6d2c66d1ccf', './lib/core/Tracker/Rule/Operator/CollectionNotContains.php', '28.4', 0),
('59c4de5a0ef33a23f5c4c80a720c6e8f', './lib/core/Tracker/Rule/Operator/CollectionNotEmpty.php', '28.4', 0),
('414e1b51c7384e35c984ff8f8d7c3587', './lib/core/Tracker/Rule/Operator/DateTimeAfter.php', '28.4', 0),
('56767db6f8b6f4d85ed5766411a3c774', './lib/core/Tracker/Rule/Operator/DateTimeBefore.php', '28.4', 0),
('5fd86d802681bcf9d90a2a06abfd0dcb', './lib/core/Tracker/Rule/Operator/DateTimeOn.php', '28.4', 0),
('bae4905c912863cc22abdfd3bf30df8a', './lib/core/Tracker/Rule/Operator/NumberEquals.php', '28.4', 0),
('c4a5fc3cc10dea3e80f572ee68e3b637', './lib/core/Tracker/Rule/Operator/NumberGreaterThan.php', '28.4', 0),
('64ac902ba6018a7251f79ba95a1fb462', './lib/core/Tracker/Rule/Operator/NumberLessThan.php', '28.4', 0),
('2a032277b717da42eb8bceb77d8d5c00', './lib/core/Tracker/Rule/Operator/NumberNotEquals.php', '28.4', 0),
('d643b945dd1b563cbd3ea349159bd431', './lib/core/Tracker/Rule/Operator/Operator.php', '28.4', 0),
('526d01ca5aa9b3fb48cc73025150974b', './lib/core/Tracker/Rule/Operator/TextContains.php', '28.4', 0),
('1f174090cbb30ada28aaea05891b5b60', './lib/core/Tracker/Rule/Operator/TextEquals.php', '28.4', 0),
('f971e9d61cf69d4b8cdb3c028e973adf', './lib/core/Tracker/Rule/Operator/TextIsEmpty.php', '28.4', 0),
('915b52ca9a0f4e3663de1bbcd9493a8f', './lib/core/Tracker/Rule/Operator/TextIsNotEmpty.php', '28.4', 0),
('b6b5a3524911a10042b498a7dc9c9ddc', './lib/core/Tracker/Rule/Operator/TextIsUsername.php', '28.4', 0),
('8a072b841742094ace9c91287f20d455', './lib/core/Tracker/Rule/Operator/TextNotContains.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Rule/Operator/index.php', '28.4', 0),
('92c87c9a4a89585143c38375ca26916f', './lib/core/Tracker/Rule/Rules.php', '28.4', 0),
('ae63d7196036170919f01d3300ef04c9', './lib/core/Tracker/Rule/Target/Field.php', '28.4', 0),
('0de514f8793f73dc665aef2e0fdb4821', './lib/core/Tracker/Rule/Target/NoTarget.php', '28.4', 0),
('20f08080e94f647620072effafc6eb80', './lib/core/Tracker/Rule/Target/Target.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Rule/Target/index.php', '28.4', 0),
('dee444145a4140dd29d41c7b815829d7', './lib/core/Tracker/Rule/Type/Boolean.php', '28.4', 0),
('38099f5b322d62486d8d970b93f8cdd9', './lib/core/Tracker/Rule/Type/Collection.php', '28.4', 0),
('82323d8ae242c77175b23666c5d187f3', './lib/core/Tracker/Rule/Type/DateTime.php', '28.4', 0),
('3c74664c505f018e224f2dd12217007d', './lib/core/Tracker/Rule/Type/Field.php', '28.4', 0),
('053d7ed783883283195caa5ca92f1eda', './lib/core/Tracker/Rule/Type/Nothing.php', '28.4', 0),
('85aed5a7fa136b079d93a5ea47234ef3', './lib/core/Tracker/Rule/Type/Number.php', '28.4', 0),
('36588169c3bfaa7f27bf55872a762ff2', './lib/core/Tracker/Rule/Type/Status.php', '28.4', 0),
('f962d0c392d996eafce7fe9fe245253a', './lib/core/Tracker/Rule/Type/Text.php', '28.4', 0),
('cfb45ac4ac036f808367ac1e4fd48709', './lib/core/Tracker/Rule/Type/Type.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Rule/Type/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tracker/Rule/index.php', '28.4', 0),
('4a2a5fbab60371fbb1f55cedd30d0a31', './lib/core/Tracker/System/Bounces.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tracker/System/index.php', '28.4', 0),
('ca4e5784fe315cd22c772c139116e347', './lib/core/Tracker/Tabular/Exception/Exception.php', '28.4', 0),
('911cb381e33a5501b8abbf6184f69271', './lib/core/Tracker/Tabular/Exception/FieldNotFound.php', '28.4', 0),
('a100840df5a7630babe40b762146abfc', './lib/core/Tracker/Tabular/Exception/ModeNotSupported.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Tabular/Exception/index.php', '28.4', 0),
('14e196403a648cf8e8ca80ad98d27da8', './lib/core/Tracker/Tabular/Manager.php', '28.4', 0),
('e5d53ad14c41d71dfa8c03926023a9e1', './lib/core/Tracker/Tabular/ODBCManager.php', '28.4', 0),
('de55002a29bed3bbcef02f77a2a8f267', './lib/core/Tracker/Tabular/Schema.php', '28.4', 0),
('de58d7eabb0eed50603c0926cb7d523d', './lib/core/Tracker/Tabular/Schema/CachedLookupHelper.php', '28.4', 0),
('615ed112365bb9bc25ccab581c1f4ae3', './lib/core/Tracker/Tabular/Schema/Column.php', '28.4', 0),
('dd922d0c37a85534b9e5ae9a6915fed6', './lib/core/Tracker/Tabular/Schema/DateHelper.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Tabular/Schema/index.php', '28.4', 0),
('a4cdf8d0c6db6452d6b1b79429e538d9', './lib/core/Tracker/Tabular/Source/APISource.php', '28.4', 0),
('540a0e557d34c9f8f2c70afbdc55ca30', './lib/core/Tracker/Tabular/Source/AutoDetectCsvSource.php', '28.4', 0),
('6699c59d109c7cc15af776bf79ff0019', './lib/core/Tracker/Tabular/Source/CsvSource.php', '28.4', 0),
('234ffb38105f925f6780c1c3a73cee62', './lib/core/Tracker/Tabular/Source/CsvSourceEntry.php', '28.4', 0),
('9a0b223a28bbd6d6e5218787464a04e4', './lib/core/Tracker/Tabular/Source/IcalSource.php', '28.4', 0),
('8719f0696d12c7b7160150d1c36e2fee', './lib/core/Tracker/Tabular/Source/JsonSource.php', '28.4', 0),
('b1cad7855ed11453b0c3d6c00433aff7', './lib/core/Tracker/Tabular/Source/JsonSourceEntry.php', '28.4', 0),
('3dbf092785a6549d7a9e05a982e15496', './lib/core/Tracker/Tabular/Source/ODBCSource.php', '28.4', 0),
('f2dae9adea496d9e06b1d2f6be8687b0', './lib/core/Tracker/Tabular/Source/ODBCSourceEntry.php', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('c5e9ecbfb03e0b168a9678c8633af19b', './lib/core/Tracker/Tabular/Source/PaginatedQuerySource.php', '28.4', 0),
('2ff5f069955a5bc1708451f713c3e6cd', './lib/core/Tracker/Tabular/Source/QuerySource.php', '28.4', 0),
('80436d850f947bcbf3e9e1b9ddac0cc0', './lib/core/Tracker/Tabular/Source/QuerySourceEntry.php', '28.4', 0),
('3d252232ff450300f5158cfe0dfd0f07', './lib/core/Tracker/Tabular/Source/SourceEntryInterface.php', '28.4', 0),
('72602842153879a16a0c30581eead0cf', './lib/core/Tracker/Tabular/Source/SourceInterface.php', '28.4', 0),
('79116715650da26521aed4038b28b68e', './lib/core/Tracker/Tabular/Source/TrackerItemSource.php', '28.4', 0),
('a3981ec387fd501e345594fc9fca6408', './lib/core/Tracker/Tabular/Source/TrackerSource.php', '28.4', 0),
('d815929130c86d508bde26bbade3b845', './lib/core/Tracker/Tabular/Source/TrackerSourceEntry.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Tabular/Source/index.php', '28.4', 0),
('be1f2ffb8415f2586e9c570874b34ec3', './lib/core/Tracker/Tabular/Writer/APIWriter.php', '28.4', 0),
('d73ee39157027d2818b3192ac2764ce7', './lib/core/Tracker/Tabular/Writer/CsvWriter.php', '28.4', 0),
('e1f75b998f11b5bbe02cad5a1c8f28d0', './lib/core/Tracker/Tabular/Writer/HtmlWriter.php', '28.4', 0),
('f9121159d2679558eb558c5a3a328131', './lib/core/Tracker/Tabular/Writer/IcalWriter.php', '28.4', 0),
('df3a90a1837679d0e0999257a62df67d', './lib/core/Tracker/Tabular/Writer/JsonWriter.php', '28.4', 0),
('5c13cddc80ec8bc063a7d79806d69932', './lib/core/Tracker/Tabular/Writer/NDJsonWriter.php', '28.4', 0),
('7675d2a3846dedcd92bdf1a77f7c717e', './lib/core/Tracker/Tabular/Writer/ODBCWriter.php', '28.4', 0),
('fe4ab905c40b6a9954e180b62204ec99', './lib/core/Tracker/Tabular/Writer/TrackerWriter.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/Tracker/Tabular/Writer/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Tracker/Tabular/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Tracker/index.php', '28.4', 0),
('9dd201c3a27efa743c08b76a0d77bb9d', './lib/core/WikiParser/Markdown/CollapsibleHeadingProcessor.php', '28.4', 0),
('2369f1420a0bc4fa17e2bcf0eb62cbe3', './lib/core/WikiParser/Markdown/Converter/DefinitionListConverter.php', '28.4', 0),
('14792ac7d8d7f89052da1d22021607ad', './lib/core/WikiParser/Markdown/Converter/StrikeConverter.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/WikiParser/Markdown/Converter/index.php', '28.4', 0),
('2099c339a90c6e0a6338753826a17c0a', './lib/core/WikiParser/Markdown/Extension.php', '28.4', 0),
('4de48e23f8a8674f9ae1b4f97ebb42d3', './lib/core/WikiParser/Markdown/Node/CollapsibleContainer.php', '28.4', 0),
('ece90520dbcef9425c07baea8f1c8adc', './lib/core/WikiParser/Markdown/Node/CollapsibleHeading.php', '28.4', 0),
('51ead4e16b2c4d30e8e6ac4d09f86830', './lib/core/WikiParser/Markdown/Node/CollapsibleLink.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/WikiParser/Markdown/Node/index.php', '28.4', 0),
('1945252ece3cecdb76483b2c08c9bd78', './lib/core/WikiParser/Markdown/Parser/CollapsibleHeadingParser.php', '28.4', 0),
('d154553753296e697c07fdf7e1ab2157', './lib/core/WikiParser/Markdown/Parser/HeadingAutonumberingCollapsibleParser.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/WikiParser/Markdown/Parser/index.php', '28.4', 0),
('e3662d6427eeefccbbedeaf52b9e9c51', './lib/core/WikiParser/Markdown/Renderer/CollapsibleContainerRenderer.php', '28.4', 0),
('a8268b4ba72a7df6333b3cbf415a4ba3', './lib/core/WikiParser/Markdown/Renderer/CollapsibleHeadingRenderer.php', '28.4', 0),
('1cf287020161c1db97d4f10261c53ba6', './lib/core/WikiParser/Markdown/Renderer/CollapsibleLinkRenderer.php', '28.4', 0),
('2507da07dec5f3b64f7632e524a85d06', './lib/core/WikiParser/Markdown/Renderer/TaskListItemMarkerRenderer.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/WikiParser/Markdown/Renderer/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/WikiParser/Markdown/index.php', '28.4', 0),
('148fd38141732819291dc11afc0c62cc', './lib/core/WikiParser/OutputLink.php', '28.4', 0),
('3cf24607d43a4dced799011b0e6e3eaf', './lib/core/WikiParser/Parsable.php', '28.4', 0),
('48c5c3b3d3e323767e1409f642177c24', './lib/core/WikiParser/ParsableMarkdown.php', '28.4', 0),
('8fcf238fe9641015a828d61233bffdb8', './lib/core/WikiParser/ParsableWiki.php', '28.4', 0),
('5f97d2746dd1e61e9f32807c12b08b56', './lib/core/WikiParser/PluginArgumentParser.php', '28.4', 0),
('85e07a790eb534df5dfddd0063b55b10', './lib/core/WikiParser/PluginDefinition.php', '28.4', 0),
('10dd71ecbdc475517e7104a4e5ac5cc4', './lib/core/WikiParser/PluginMatcher.php', '28.4', 0),
('9da4a6ac2abc2c266f47f04b41add086', './lib/core/WikiParser/PluginOutput.php', '28.4', 0),
('3d79d67dccfc1ff09da0448b68956cd2', './lib/core/WikiParser/PluginParser.php', '28.4', 0),
('4ee4275ef50ba6fa2124d60df63b6379', './lib/core/WikiParser/PluginRepository.php', '28.4', 0),
('63bf10d5c3e6827f8f64c4f9c16b1bc1', './lib/core/WikiParser/PluginRunner.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/WikiParser/index.php', '28.4', 0),
('e7ee3e075ffcee87d2d12b0ad68c353a', './lib/core/WikiPlugin/Casperjs/Render.php', '28.4', 0),
('8f9066378153a5a2e982f345dcff9f21', './lib/core/WikiPlugin/Casperjs/Result.php', '28.4', 0),
('87d428630ad0453dfb8dc83797f418a4', './lib/core/WikiPlugin/Casperjs/Runner.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/WikiPlugin/Casperjs/index.php', '28.4', 0),
('0e601c36b8ca278677861dab2d594969', './lib/core/WikiPlugin/Enums/PluginParameterTags.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/WikiPlugin/Enums/index.php', '28.4', 0),
('f099cda64c97a1b610cbc5ead20efccf', './lib/core/WikiPlugin/Helper.php', '28.4', 0),
('fec66d667ee7a355c899c9c2fbe692e4', './lib/core/WikiPlugin/Negotiator/Wiki.php', '28.4', 0),
('ca17ba94a959730b6210804ac6539f67', './lib/core/WikiPlugin/Negotiator/Wiki/Alias.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/core/WikiPlugin/Negotiator/Wiki/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/WikiPlugin/Negotiator/index.php', '28.4', 0),
('21d1939feedeccd922aa9be951e899e3', './lib/core/WikiPlugin/Reference.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/WikiPlugin/index.php', '28.4', 0),
('eafb6b1e9253075ee81b84e995359c9a', './lib/core/Yaml/Directive/DirectiveInclude.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Yaml/Directive/index.php', '28.4', 0),
('5cd1c0d222485ce5737500212dea95ff', './lib/core/Yaml/Directives.php', '28.4', 0),
('42420cf4ca2c9ca7dcb074c7a67a1f1d', './lib/core/Yaml/Filter/FilterInterface.php', '28.4', 0),
('49a17bb5acda535058b8b58a9777f47e', './lib/core/Yaml/Filter/ReplaceUserData.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/core/Yaml/Filter/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/core/Yaml/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/core/index.php', '28.4', 0),
('27d298fdf3a7b4ee175191b142e4a649', './lib/credits/creditslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/credits/index.php', '28.4', 0),
('f5ba76ada0af474513c11661ede3c94c', './lib/crypt/cryptlib.php', '28.4', 0),
('4acefd1d716a02598a5a2286feae6c71', './lib/crypt/encryptionlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/crypt/index.php', '28.4', 0),
('d307896a54fab3e30055ae632b4816a3', './lib/csslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/cypht/index.php', '28.4', 0),
('90da23ff0ce9c48f9a9d2a21352a6e60', './lib/cypht/integration/Tiki_Hm_Custom_Auth.php', '28.4', 0),
('e346cc32a61c73f1ed01673e237f30e9', './lib/cypht/integration/Tiki_Hm_Custom_Cache.php', '28.4', 0),
('63595db0b1e7c4c28473a213b78058a6', './lib/cypht/integration/Tiki_Hm_Custom_Session.php', '28.4', 0),
('dc82f38902d4643ba7887a94436886e7', './lib/cypht/integration/Tiki_Hm_Functions.php', '28.4', 0),
('109d2a61e9f91e7319c788bb06616936', './lib/cypht/integration/Tiki_Hm_Output_HTTP.php', '28.4', 0),
('780089794324e4f22ee81a05e9fcd0d2', './lib/cypht/integration/Tiki_Hm_Sieve_Client_Factory.php', '28.4', 0),
('68883fc5a3df8ff0edfdf4363ee57bf4', './lib/cypht/integration/Tiki_Hm_Sieve_Custom_Client.php', '28.4', 0),
('3d10a24aee50e4e9b77583002e714fe2', './lib/cypht/integration/Tiki_Hm_Site_Config_File.php', '28.4', 0),
('2cf46a3e256aa2cf9aca8dfe3709d346', './lib/cypht/integration/Tiki_Hm_Tiki_Cache.php', '28.4', 0),
('b9457c0c21c98d812a985d436f3851aa', './lib/cypht/integration/Tiki_Hm_User_Config.php', '28.4', 0),
('3c77d2f9e07d7fba4354839cbb7cab41', './lib/cypht/integration/classes.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/cypht/integration/index.php', '28.4', 0),
('01baea624ad3817e67b18802c673d6b5', './lib/cypht/jquery.touch.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/cypht/modules/index.php', '28.4', 0),
('e7a2d3edf2c45c9a2f0143f06a810498', './lib/cypht/modules/tiki/calendar_modules.php', '28.4', 0),
('c25840904de88ba8777ab0ef529c6480', './lib/cypht/modules/tiki/functions.php', '28.4', 0),
('25aa588daf11ddc0dec8f664f1529ea5', './lib/cypht/modules/tiki/general_modules.php', '28.4', 0),
('4f3ccbf5d61f46f8b5255a82c63ff6cf', './lib/cypht/modules/tiki/groupmail_modules.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/cypht/modules/tiki/index.php', '28.4', 0),
('7935092600f261a9187eb28ae0451010', './lib/cypht/modules/tiki/modules.php', '28.4', 0),
('7ae3bf1d41789925dd988738332541ce', './lib/cypht/modules/tiki/setup.php', '28.4', 0),
('bb1bee10e9e8cd5bec7ac3d55dbcf5f8', './lib/cypht/modules/tiki/sievefilters_modules.php', '28.4', 0),
('f51e14b2dad0ba1595cf232c192d6082', './lib/cypht/modules/tiki/site.js', '28.4', 0),
('fb38e91d2728eb62597df3c150db2845', './lib/cypht/modules/tiki/tracker_modules.php', '28.4', 0),
('88bf3f5be6a8f080f48536f808c80dea', './lib/cypht/site.css', '28.4', 0),
('bde5b940f82ac1e48ced3fe9e336083b', './lib/cypht/site.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/db/index.php', '28.4', 0),
('d4d8995b1cbfc552c30adec559225923', './lib/db/tiki_registration_fields.php', '28.4', 0),
('5d749da12a7f73ab26ca300b28acd368', './lib/dcs/dcslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/dcs/index.php', '28.4', 0),
('de589e702b23e2ab3b1e1e387dffa315', './lib/debug/Tracer.php', '28.4', 0),
('34487a864e9b3d330ebb64fda6daf234', './lib/debug/debug-command_dmsg.php', '28.4', 0),
('7ecc6ae6fff8bb0ee0a5fee55adb4f97', './lib/debug/debug-command_features.php', '28.4', 0),
('1dac7ababddb1fbf0e5cb11d253244ac', './lib/debug/debug-command_perm.php', '28.4', 0),
('b65906dd4b8233b16f5983a668385489', './lib/debug/debug-command_print.php', '28.4', 0),
('a68480bed5a8d1915c044ec15af21271', './lib/debug/debug-command_slist.php', '28.4', 0),
('badfcbc676a400782b73edcda78b45c6', './lib/debug/debug-command_sprint.php', '28.4', 0),
('5b97d8a30ce17cd0f60d049765510b28', './lib/debug/debug-command_sql.php', '28.4', 0),
('987054d689add394c3fdd6578314d676', './lib/debug/debug-command_test.php', '28.4', 0),
('0049601b88f5c5cb8b70c26f4a71a4f8', './lib/debug/debug-command_tikitables.php', '28.4', 0),
('667b54eaa1bc07f0ef546c16e15ffa63', './lib/debug/debug-command_watch.php', '28.4', 0),
('7886974ccd14dcb3b98e6c8c84c5cc3f', './lib/debug/debugger-common.php', '28.4', 0),
('efffc64bbaa3bf05feeb1c27e01eb1d7', './lib/debug/debugger-ext.php', '28.4', 0),
('e4deeec74647453e49f5a04eb6e28e8d', './lib/debug/debugger.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/debug/index.php', '28.4', 0),
('d522bb4f29bca2ccc7f601778c49251b', './lib/diff.php', '28.4', 0),
('c1b2831181704d9ba9d9c13a50cc9a42', './lib/diff/Diff.php', '28.4', 0),
('e1d3cf90cd89b9f06746a0dadadcae3d', './lib/diff/Renderer.php', '28.4', 0),
('9ae8903f8e64df7d9a3355a9e91bd548', './lib/diff/difflib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/diff/index.php', '28.4', 0),
('e09fb3aecee833634debc246edeb45b6', './lib/diff/renderer_bytes.php', '28.4', 0),
('ec30b053bf4fa5b37667abbbac6edd5e', './lib/diff/renderer_character.php', '28.4', 0),
('66f87fd16638b83d210d9f2bccd4fd54', './lib/diff/renderer_character_inline.php', '28.4', 0),
('86e8fdef13d667a011a1bff93921fdc1', './lib/diff/renderer_htmldiff.php', '28.4', 0),
('fb522e24625de4a48acdc32a3f148d3f', './lib/diff/renderer_inline.php', '28.4', 0),
('d77854cc5e0ca35ccea6725ace2dba89', './lib/diff/renderer_sidebyside.php', '28.4', 0),
('182ff53082bdb93bbadb6d9cd52c4217', './lib/diff/renderer_unified.php', '28.4', 0),
('396882b6be25836f98d6eafd014e0fa7', './lib/directory/dirlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/directory/index.php', '28.4', 0),
('aea3cafad8dc2db00dcb4d529cb4959a', './lib/dracula/graffle.js', '28.4', 0),
('f1407d94cdfa66e6221ee92e03be74dd', './lib/dracula/graph.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/dracula/index.php', '28.4', 0),
('8b1b503c7e881b85379888e7d9c39873', './lib/dracula/raphael-min.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/encoding/index.php', '28.4', 0),
('74a6de443765e2ee57e108f2e992e141', './lib/encoding/lib-encoding.php', '28.4', 0),
('71c14ccabc694cd294907af24a8cb16e', './lib/enforce_php_version_constraints.php', '28.4', 0),
('81c1acb2f3cd15482b908715fb379d20', './lib/error/errormanagerlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/error/index.php', '28.4', 0),
('f309bfd68be1fc3124d1742deef5c048', './lib/faqs/faqlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/faqs/index.php', '28.4', 0),
('99ffbec16b61f5c95613b775acf03c76', './lib/featured_links/flinkslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/featured_links/index.php', '28.4', 0),
('d1f113c4739b98d7124ad0dec28cfb45', './lib/filegals/filegalbatchlib.php', '28.4', 0),
('1e918b06d6a153ef855671fd6ff700a3', './lib/filegals/filegalcopylib.php', '28.4', 0),
('360faf7780e3b204be1435b894bc5dff', './lib/filegals/filegallib.php', '28.4', 0),
('c3a00a7bbdf02aae2c53282305ae3a84', './lib/filegals/h5plib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/filegals/index.php', '28.4', 0),
('417f49e52a73aae5754752807613eb90', './lib/filegals/max_upload_size.php', '28.4', 0),
('d946a8c8313de300f2f5c6bb21f4c9ac', './lib/filegals/scormlib.php', '28.4', 0),
('e5813fc730e0b32091c5e04f8cea8455', './lib/filegals/vimeolib.php', '28.4', 0),
('e066495b2f0404d1ef1d7656b8cff548', './lib/freetag/freetaglib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/freetag/index.php', '28.4', 0),
('edecb823be73dd6db8ceb396444912ca', './lib/geo/geolib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/geo/index.php', '28.4', 0),
('a4d1472d151d99b87dd822247b20fded', './lib/gitlib.php', '28.4', 0),
('11561de747f74cf9951a4df85b5c5879', './lib/goal/eventlib.php', '28.4', 0),
('7e6975879311cab2712738433a66a9f8', './lib/goal/goallib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/goal/index.php', '28.4', 0),
('6d49d3aeb0a0341ebbbcb12310d2f6ee', './lib/goal/rewardlib.php', '28.4', 0),
('449b73b10a2e7cb0007951f0399007d8', './lib/graph-engine/abstract.gridbased.php', '28.4', 0),
('aa31be6ff382b7e99659ba1e7450ca7a', './lib/graph-engine/core.php', '28.4', 0),
('4a71b708ffabc99236c71defd3bc3d50', './lib/graph-engine/gd.php', '28.4', 0),
('ba93f454524735cf5dc0354b5028bf2f', './lib/graph-engine/graph.bar.php', '28.4', 0),
('203aaae19a1939056dd045bc8988bfbd', './lib/graph-engine/graph.multiline.php', '28.4', 0),
('b9f1a2098889b17a373515384446f661', './lib/graph-engine/graph.pie.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/graph-engine/index.php', '28.4', 0),
('7bcb66c962e10e7425a2409cf17632d3', './lib/graph-engine/pdflib.php', '28.4', 0),
('69f1b3552be013e8fd25ed76f39de28b', './lib/graph-engine/ps.php', '28.4', 0),
('ef11e34fa6baf986505e12e43d57bb75', './lib/groupalert/groupalertlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/groupalert/index.php', '28.4', 0),
('eacefb373b257120d4e493ea9b39074b', './lib/headerlib.php', '28.4', 0),
('3f68c8639a9c4a304166ab2eec863962', './lib/hotwords/hotwordlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/hotwords/index.php', '28.4', 0),
('e31078967daaee5d40ad00375414a8c0', './lib/htmlpages/htmlpageslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/htmlpages/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/htmlparser/index.php', '28.4', 0),
('3104c56223e01220d31984dd42d04188', './lib/htmlparser/rebuildgrammar.php', '28.4', 0),
('7af94ddd3c452ecb7c02af58a8057098', './lib/htmlpurifier_tiki/HTMLPurifier.tiki.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/htmlpurifier_tiki/index.php', '28.4', 0),
('cf014438c1c4b5b210cd2ba1109bff06', './lib/ical/File.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/ical/index.php', '28.4', 0),
('d94886f9e348424e75bd816919124b10', './lib/iconGeneratorNodeWrapper.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/importer/index.php', '28.4', 0),
('dfc4e1561476a7cb8992dc116c0627cc', './lib/importer/tikiimporter.php', '28.4', 0),
('7190f2bdddec5d583b44a184e97b8904', './lib/importer/tikiimporter_blog.php', '28.4', 0),
('96577c29d915aaa570db90b9ebddc9d0', './lib/importer/tikiimporter_blog_wordpress.php', '28.4', 0),
('2036a0c5321ad99d20697d41ef5c2dcd', './lib/importer/tikiimporter_wiki.php', '28.4', 0),
('af3f16303d6a6f612e16cb5950974dec', './lib/importer/tikiimporter_wiki_mediawiki.php', '28.4', 0),
('29b6557267a7bc82553d6f9321886d30', './lib/importerlib.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './lib/index.php', '28.4', 0),
('9cea92a37c887a4ddbc4516630195f55', './lib/init/SmartyTikiErrorHandler.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/init/index.php', '28.4', 0),
('07e98731337862e312c520b566015077', './lib/init/initlib.php', '28.4', 0),
('502152649d1c912a90f96ee155993dc6', './lib/init/smarty.php', '28.4', 0),
('25c74151718fc0e4024c1923afc38082', './lib/init/tra.php', '28.4', 0),
('b42e64c46df1bd2e5863c3db6bd48e62', './lib/init/typography.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/integrator/index.php', '28.4', 0),
('b46340b57ddf31cb741e87f07801f5c1', './lib/integrator/integrator.php', '28.4', 0),
('f6ed52e3adbfc6cb1b932f9f88d39ec9', './lib/iot/DrawflowActionInterface.php', '28.4', 0),
('adf3ccd90573c28c6928a50aa3cfc948', './lib/iot/DrawflowEditor.php', '28.4', 0),
('4291255947abf6266fed0211e36304c6', './lib/iot/DrawflowNodeDefinitions/DrawflowEmailSend.php', '28.4', 0),
('3ea4014d693f332561f032ffb2e33544', './lib/iot/DrawflowNodeDefinitions/DrawflowHardwareIOStateSetting.php', '28.4', 0),
('c0919977f46b46e5d9380da0b2b6b591', './lib/iot/DrawflowNodeDefinitions/DrawflowLogger.php', '28.4', 0),
('6390b459d0e97d4107d1490a93462068', './lib/iot/DrawflowNodeDefinitions/DrawflowMathComparison.php', '28.4', 0),
('aba772d2bd6d2fe2ec0089e8e202fdfa', './lib/iot/DrawflowNodeDefinitions/DrawflowStringTemplateBuilder.php', '28.4', 0),
('210127ffd70ff2c95be5b8ec54444727', './lib/iot/DrawflowNodeDefinitions/DrawflowTrackerInput.php', '28.4', 0),
('a4a76cd31522305329b426bef81e7d38', './lib/iot/DrawflowNodeDefinitions/DrawflowWebhookSend.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/iot/DrawflowNodeDefinitions/index.php', '28.4', 0),
('f471dfbb01a067e0dc267f3ce358c53e', './lib/iot/DrawflowNodeType.php', '28.4', 0),
('08e8c8077faeb704fb15e86b2abeee81', './lib/iot/DrawflowProcessor.php', '28.4', 0),
('3f044de8d5929072e166cb192e975aad', './lib/iot/EventListener.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/iot/index.php', '28.4', 0),
('78fda28b2d352e7fcd7778d9088b41b1', './lib/iot/theme/drawflow-default.css', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/iot/theme/index.php', '28.4', 0),
('8655979c7b32da573c0b8a6a039ff53f', './lib/iot/theme/initial.css', '28.4', 0),
('afc5e5b9db9af06d027aaba17a38bf1f', './lib/jquery_tiki/autoToc.js', '28.4', 0),
('c7518d5f14e7c205c1de15a3da80ce64', './lib/jquery_tiki/customsearch.js', '28.4', 0),
('b99923d05077aa5586ed7d5a8faaf55a', './lib/jquery_tiki/edit_preview.js', '28.4', 0),
('300b9ff2764245dfa7184b8413e07ef0', './lib/jquery_tiki/elfinder/elFinderVolumeTikiFiles.class.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/jquery_tiki/elfinder/index.php', '28.4', 0),
('49a1faa704a79069ad610d3238682458', './lib/jquery_tiki/elfinder/tiki-elfinder.js', '28.4', 0),
('0324e0549efb47a4d39c5c72b5e6871f', './lib/jquery_tiki/elfinder/tikiElFinder.php', '28.4', 0),
('f7e313b0ea9e4ea6a485de1101bfe19c', './lib/jquery_tiki/files.js', '28.4', 0),
('e943e07431e583aae29dc07efffa650d', './lib/jquery_tiki/function.debugger.js', '28.4', 0),
('38aba2aa3ad0949869503ae8feb75688', './lib/jquery_tiki/iconsets.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/jquery_tiki/index.php', '28.4', 0),
('992d1a198683248adbce806f3a6456a3', './lib/jquery_tiki/inline_edit.js', '28.4', 0),
('ba068e0f271657f2c514bbeaa8be0249', './lib/jquery_tiki/multilike.js', '28.4', 0),
('1ce91006548cdf6caa484a15373349bd', './lib/jquery_tiki/mustread.js', '28.4', 0),
('187986b9ece6fd9dbee2a74bfb07daf4', './lib/jquery_tiki/pdf.js', '28.4', 0),
('f2af26599253d5dfd9455cef09af10b1', './lib/jquery_tiki/pluginedit.js', '28.4', 0),
('523ea9a5018e6f3a1ff7622140de82cf', './lib/jquery_tiki/pluginedit_list.js', '28.4', 0),
('79c239cdbde128159ec7f1ec61e30786', './lib/jquery_tiki/recordrtc.js', '28.4', 0),
('4ad865d12c4aa0ec994e1e686b91e365', './lib/jquery_tiki/social.js', '28.4', 0),
('3e750d85ef7a8a5c8081e79099598ff6', './lib/jquery_tiki/tablesorter.js', '28.4', 0),
('ff3f1128858e213dedb5019f25e0770a', './lib/jquery_tiki/theme-customizer.js', '28.4', 0),
('496809858319feb0e32e39920975cc25', './lib/jquery_tiki/tiki-admin.js', '28.4', 0),
('d2943554d031dbaed4da7755096101e4', './lib/jquery_tiki/tiki-admin_actionlog.js', '28.4', 0),
('26054d5f4ec3d0f1efbd54128911e423', './lib/jquery_tiki/tiki-admin_oauthserver.js', '28.4', 0),
('36546f9c9562e9888ec021654780f38e', './lib/jquery_tiki/tiki-calendar_edit_item.js', '28.4', 0),
('77013d141e8d960bf359529c552ddb64', './lib/jquery_tiki/tiki-confirm.js', '28.4', 0),
('53e9f800cc4e0317297045b81acd989e', './lib/jquery_tiki/tiki-connect.js', '28.4', 0),
('ca7ab90b2286e51aae4bfafb4227ebd5', './lib/jquery_tiki/tiki-diagram.js', '28.4', 0),
('61191d35869c58acd6a45d3532b92f86', './lib/jquery_tiki/tiki-editdiagram.js', '28.4', 0),
('d8e1c142f331d90bc2f3e8a6d9b7f5a0', './lib/jquery_tiki/tiki-export_tracker_schema.js', '28.4', 0),
('838068f045be79fd2c24fa795a74098c', './lib/jquery_tiki/tiki-jquery.js', '28.4', 0),
('e5dd122ad3fca2b38e9f29f73b80c917', './lib/jquery_tiki/tiki-jquery_upload.js', '28.4', 0),
('a7299e06bb2cc806cc7106895fc54e9b', './lib/jquery_tiki/tiki-machine_learning.js', '28.4', 0),
('c0ed7450d0f5a7c1fa14e39d5909f77d', './lib/jquery_tiki/tiki-manager.js', '28.4', 0),
('9b98ab128a1f343f7e690c5ad24cf8f6', './lib/jquery_tiki/tiki-maps-ol3.js', '28.4', 0),
('9175449f44122498b0421a9995d5a777', './lib/jquery_tiki/tiki-mxgraph.js', '28.4', 0),
('e091613b181cd3d225f6c338e258cbef', './lib/jquery_tiki/tiki-pdfjs.js', '28.4', 0),
('e8ab9fa96d904c881520f1f5396702d5', './lib/jquery_tiki/tiki-popovers_for_footnotes.js', '28.4', 0),
('71d3b3fd96d66def419fb0fd509c8f64', './lib/jquery_tiki/tiki-profile.js', '28.4', 0),
('948bb04481a93330fba1ed9f37c67fd9', './lib/jquery_tiki/tiki-schedulers.js', '28.4', 0),
('db63ea455316f335b2e43f2fb4eb9d95', './lib/jquery_tiki/tiki-smartmenus-bootstrap-4.js', '28.4', 0),
('1772136ae921d6f412376cd64b212449', './lib/jquery_tiki/tiki-tasks.js', '28.4', 0),
('e8efc8f2ae0805c8523071f6025cfc77', './lib/jquery_tiki/tiki-toolbars.js', '28.4', 0),
('96cf209cd0cda15c993a78634de2ebce', './lib/jquery_tiki/tiki-tracker-rules.js', '28.4', 0),
('2e1b42190dca5518913b9219147899bd', './lib/jquery_tiki/tiki-trackers.js', '28.4', 0),
('6de5153755035aeea88a104f9b24e142', './lib/jquery_tiki/tiki-vimeo_upload.js', '28.4', 0),
('4bea34e32a2dd4ba6c31b96ef5c5f2e7', './lib/jquery_tiki/tiki-vue.js', '28.4', 0),
('3f1e651f2a79ff30cb659b56ee9b710e', './lib/jquery_tiki/tiki-websockets.js', '28.4', 0),
('b494d44a29df1c078a271b9a29e8d082', './lib/jquery_tiki/tiki-workspace-ui.js', '28.4', 0),
('db2d667c11e0dd0aacf18aaebfe2ae97', './lib/jquery_tiki/user_mentions.js', '28.4', 0),
('81f89d6c2e03ae71134c3eb2d84417d9', './lib/jquery_tiki/wikiplugin-annotation.js', '28.4', 0),
('b8d5615a9acdb66e69a3726027d4d0ca', './lib/jquery_tiki/wikiplugin-coil.js', '28.4', 0),
('7f52509519fccfc1e311dabaf9ab4572', './lib/jquery_tiki/wikiplugin-convene.js', '28.4', 0),
('51e3b1a4225e3dbb498fe94030b65649', './lib/jquery_tiki/wikiplugin-ganttchart.js', '28.4', 0),
('70c70201f442defadddef5476c9e3858', './lib/jquery_tiki/wikiplugin-include.js', '28.4', 0),
('df29e12cc0191aada1d1a56b12fa6127', './lib/jquery_tiki/wikiplugin-listexecute.js', '28.4', 0),
('2e4d363e31f31793d568e4fa46fcbdb1', './lib/jquery_tiki/wikiplugin-mediaplayer.js', '28.4', 0),
('4a650280374cea6a608aac78c736da32', './lib/jquery_tiki/wikiplugin-pivottable.js', '28.4', 0),
('cbcb643473cb5583b03bf752ddd2cb8e', './lib/jquery_tiki/wikiplugin-signature.js', '28.4', 0),
('13fe5182b0791707942636da6ce13700', './lib/jquery_tiki/wikiplugin-totp.js', '28.4', 0),
('b845870011163a537023ba0eeeb12a40', './lib/jquery_tiki/wikiplugin-xmpp.js', '28.4', 0),
('b21e28289f2df481677841f4a32c4794', './lib/language/CollectFiles.php', '28.4', 0),
('06215f024ecf920f9f47f68dfd78d8dc', './lib/language/Exception.php', '28.4', 0),
('5015c52ef6d3fc4c71f8db02fe951128', './lib/language/File.php', '28.4', 0),
('58d79934287cf9642e6f075fe62205ac', './lib/language/FileType.php', '28.4', 0),
('0ddaf972ca6409b6558d47fb1f625a1b', './lib/language/FileType/Php.php', '28.4', 0),
('14b5a078a25cfc2d2668e1287e968b97', './lib/language/FileType/Tpl.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/language/FileType/index.php', '28.4', 0),
('e43e9080d96ca34533df52420d4ecad3', './lib/language/GetStrings.php', '28.4', 0),
('71ae3ba69bb5f95994a626a0d9c9855a', './lib/language/Language.php', '28.4', 0),
('c2525df9fe75734c94607df0126803f5', './lib/language/LanguageTranslations.php', '28.4', 0),
('d8a76dfd65a4a66c4baa916975c39c84', './lib/language/LanguageTranslator.php', '28.4', 0),
('56db9de8dfc6559e1679035ea71941df', './lib/language/MergeFiles.php', '28.4', 0),
('3983835b9683f2ec017d900eecd0b439', './lib/language/WriteFile.php', '28.4', 0),
('2aedecfa5988e7254a4d19f96bb2486c', './lib/language/WriteFile/Factory.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/language/WriteFile/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/language/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/language/js/index.php', '28.4', 0),
('a6689d9a99f0cece9813f27e670dbef0', './lib/language/js/interactive_translation.js', '28.4', 0),
('4bc76e95d70ae8e45dcb7a0882730ced', './lib/language/js/tiki-edit_languages.js', '28.4', 0),
('e70d9c018e634c00018ef66722aec0bb', './lib/ldap/filter.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/ldap/index.php', '28.4', 0),
('55679d2f60a98465ea09f94d71dc6cab', './lib/ldap/ldaplib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/live_support/index.php', '28.4', 0),
('f7b751908d499b391b36f34bcafc4542', './lib/live_support/live-support.css', '28.4', 0),
('6809ec3549b1a0be173cbab0af628159', './lib/live_support/live-support.js', '28.4', 0),
('169b90a94409f7b9050b00f2696a3514', './lib/live_support/lsadminlib.php', '28.4', 0),
('72d04ff761cf88aa459ef95a3a91137f', './lib/live_support/lslib.php', '28.4', 0),
('b1981e00101063e7ac701c0582beacbe', './lib/loginlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/mail/index.php', '28.4', 0),
('83310e050ebc487085c20bdd9fc54908', './lib/mail/maillib.php', '28.4', 0),
('98f07aab109c9f28b7256aea310d34c1', './lib/mail/mimelib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/mailin/index.php', '28.4', 0),
('6fd6ef44bd036a3ae924c2450c88f44e', './lib/mailin/mailinlib.php', '28.4', 0),
('994bc87616b9086d697d20d1a5a18452', './lib/mailin/usermailinlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/menubuilder/index.php', '28.4', 0),
('af94419a8734c597a6b8a3e00560be77', './lib/menubuilder/menulib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/messu/index.php', '28.4', 0),
('64546734d025f777949fa6f0851d4f11', './lib/messu/messulib.php', '28.4', 0),
('eff5289e6c3dca0a792618694072f124', './lib/metadata/datatypes/basicinfo.php', '28.4', 0),
('b61cf7150ee14744a543b74ec281b0a0', './lib/metadata/datatypes/exif.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/metadata/datatypes/index.php', '28.4', 0),
('4029b5385b11cc6d129c3a6573e6c458', './lib/metadata/datatypes/iptc.php', '28.4', 0),
('7bca3dd060b0cdd5a614facb6a5f1f69', './lib/metadata/datatypes/xmp.php', '28.4', 0),
('47b0c18df93dbeff0573d88cf19b46c0', './lib/metadata/filetypes/imagefile.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/metadata/filetypes/index.php', '28.4', 0),
('937242cef74f020333d443cb0ae1f624', './lib/metadata/filetypes/jpeg.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/metadata/index.php', '28.4', 0),
('f3826ca960355016ad6841bbf5527ee3', './lib/metadata/metadatalib.php', '28.4', 0),
('9aa71f944a6e5e636009fa760285897a', './lib/metadata/reconcile.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/mime/index.php', '28.4', 0),
('575750b8a38d40e17f6c174d01072b30', './lib/mime/mimelib.php', '28.4', 0),
('48235aefd954957dffe7c1defe05d717', './lib/mime/mimetypes.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/minical/index.php', '28.4', 0),
('645fad80dbbab6055f46f56e340b604a', './lib/minical/minicallib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/ml/index.php', '28.4', 0),
('13a337cf1fc3e4cababadfb083931902', './lib/ml/mllib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/modules/index.php', '28.4', 0),
('7655b4a2f50d054a740f97082a0282d6', './lib/modules/modlib.php', '28.4', 0),
('2ac1779d66813fce284552cfccca17cc', './lib/modules/tiki-admin_modules.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/multilingual/index.php', '28.4', 0),
('7f028b67982c9fb33b075fc93bea2610', './lib/multilingual/multilinguallib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/newsletters/index.php', '28.4', 0),
('bab7ddac63bcff577f1e791dfbaba5a2', './lib/newsletters/nllib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/notepad/index.php', '28.4', 0),
('0dd4467036ba96a2e0a78cc3a0cd841e', './lib/notepad/notepadlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/notifications/index.php', '28.4', 0),
('7f9a8bac33068852397838bb9b2210dc', './lib/notifications/notificationemaillib.php', '28.4', 0),
('cb3949a916b166845a62d49af133a834', './lib/notifications/notificationlib.php', '28.4', 0),
('174a4cba7b58515883db5646278c9ba3', './lib/oauthlib.php', '28.4', 0),
('18e82fdc498d647d18f2a9ec6e1f0812', './lib/oauthserver/TikiCryptKey.php', '28.4', 0),
('ed99eabe35a573543558083c76cf9bc9', './lib/oauthserver/entities/AccessTokenEntity.php', '28.4', 0),
('43e5756d4d25e66496b323605a13d28b', './lib/oauthserver/entities/AuthCodeEntity.php', '28.4', 0),
('4a19b0b9a10e4465a78e22538b8742b6', './lib/oauthserver/entities/ClientEntity.php', '28.4', 0),
('3e680fd93b05051c136b7167e712eb11', './lib/oauthserver/entities/RefreshTokenEntity.php', '28.4', 0),
('cfb72ee2ad47261eee59f2254ccfba90', './lib/oauthserver/entities/ScopeEntity.php', '28.4', 0),
('09419026ad4d2b5e1ab615873475a66e', './lib/oauthserver/entities/UserEntity.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/oauthserver/entities/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/oauthserver/index.php', '28.4', 0),
('0e850d49b0b02a769198d87f2477f55a', './lib/oauthserver/oauthserverlib.php', '28.4', 0),
('adfd6f1f9866088f2b100907fd19b19f', './lib/oauthserver/repositories/AccessTokenRepository.php', '28.4', 0),
('11cc685bfa20a1db6d05d65bb60fccbf', './lib/oauthserver/repositories/AuthCodeRepository.php', '28.4', 0),
('b0ab66947b745a9bc292cb8db5d85600', './lib/oauthserver/repositories/ClientRepository.php', '28.4', 0),
('1fa8c14b9969901f433f7919c432a8c8', './lib/oauthserver/repositories/RefreshTokenRepository.php', '28.4', 0),
('2344320e7f904b98d41475a2c484be04', './lib/oauthserver/repositories/ScopeRepository.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/oauthserver/repositories/index.php', '28.4', 0),
('70a015b6c745896b784b49e28cd6a7b6', './lib/objectlib.php', '28.4', 0),
('ead2e03186d30e81e0b34ad89ef9b50a', './lib/ocrlib.php', '28.4', 0),
('798f27c438c80893426b718a43c9e8e0', './lib/ointegratelib.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/openlayers/art/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/openlayers/img/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/openlayers/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/openlayers/licenses/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/openlayers/theme/dark/index.php', '28.4', 0),
('a6bcea2af384a1f59ceaf6d99a737b72', './lib/openlayers/theme/default/google.css', '28.4', 0),
('ae75483aedfcd7d1ea3bb11f6148cf2f', './lib/openlayers/theme/default/google.tidy.css', '28.4', 0),
('97e9508128e3d02599b15c947b8490a1', './lib/openlayers/theme/default/ie6-style.css', '28.4', 0),
('256c553a4738811397517c82f0119101', './lib/openlayers/theme/default/ie6-style.tidy.css', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/openlayers/theme/default/img/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/openlayers/theme/default/index.php', '28.4', 0),
('d7e4ed1a6b03b93c4452db55dc262927', './lib/openlayers/theme/default/style.css', '28.4', 0),
('340578162d772d9c74c7f0785b4754e8', './lib/openlayers/theme/default/style.mobile.css', '28.4', 0),
('9132583981f7f7ef6f3c00a387bdca6f', './lib/openlayers/theme/default/style.mobile.tidy.css', '28.4', 0),
('9521ac61157d73a252cdebe6df5e019d', './lib/openlayers/theme/default/style.tidy.css', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/openlayers/theme/index.php', '28.4', 0),
('0361bb038391cd60edcb2c7b850c5655', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Sendmail.php', '28.4', 0),
('eb0f57d31f92c26ae50c861672ad9d10', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Smtp.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/openpgp/index.php', '28.4', 0),
('27396e9d425e4a4eba32d6a5e5746cc1', './lib/openpgp/openpgplib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/parser/index.php', '28.4', 0),
('220a10f44e8514fb6785a6244a690fd8', './lib/parser/parserlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/pass_blacklists/index.php', '28.4', 0),
('9983bc8ea23525c0c812fc5529a51a7a', './lib/payment/ILPInvoicePaymentLib.php', '28.4', 0),
('94d7bb1c82fc3b4280d2311dff311765', './lib/payment/ILPPaymentAdapterInterface.php', '28.4', 0),
('22467a6870a5534a6b4010c4f9037c6e', './lib/payment/behavior/cancel_cart_order.php', '28.4', 0),
('f5c3e27405593d6cd87e5aff97392f8e', './lib/payment/behavior/cancel_membership_extension.php', '28.4', 0),
('dee03867fb393c160aa2994d081f529c', './lib/payment/behavior/cart_exchange_product.php', '28.4', 0),
('d680b8427ac08d243ada353ab7f64935', './lib/payment/behavior/cart_send_confirm_email.php', '28.4', 0),
('79e574f6eb5a9fb916040e3242a12314', './lib/payment/behavior/execute_datachannel.php', '28.4', 0),
('9048c67debe634fb9dd2219975e14f43', './lib/payment/behavior/extend_membership.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/payment/behavior/index.php', '28.4', 0),
('d1a19735a88327f5e3daabb7e55a9da1', './lib/payment/behavior/perform_trade.php', '28.4', 0),
('b72814d8f17be356c96e394029dcc470', './lib/payment/behavior/record_cart_order.php', '28.4', 0),
('1a680b48e1a76856126235d2f8d1b879', './lib/payment/behavior/replace_inventory.php', '28.4', 0),
('32ddcfe40118a65a91a09acf4f8fce6b', './lib/payment/behavior/sample.php', '28.4', 0),
('35ae58af3f9457c3ebb1839fe4820941', './lib/payment/cartlib.js', '28.4', 0),
('c5a2f13a7a87cc6fad58f1191325cad0', './lib/payment/cartlib.php', '28.4', 0),
('8a45d3e78a16a2a7753afc90b7540ee6', './lib/payment/cclitelib.php', '28.4', 0),
('a0e5a68bc091244c5cb9ba933dfd2053', './lib/payment/creditspaylib.php', '28.4', 0),
('73a122bf4d7f597e3d3e619710a8c5e8', './lib/payment/discountlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/payment/index.php', '28.4', 0),
('ed5f1598e0d0ddf125d1868395365ede', './lib/payment/paymentlib.php', '28.4', 0),
('5252b2ae3aa2d54487e943d552ae46e0', './lib/payment/paypallib.php', '28.4', 0),
('e390043eaaab48d94a4c3b1a2b5ea35f', './lib/pdfimages.php', '28.4', 0),
('05bc2c7712748a444715b337f01e2981', './lib/pdflib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/performance/index.php', '28.4', 0),
('fc90b995dfb292980118726a9bad5146', './lib/performance/performancestatslib.php', '28.4', 0),
('e1ea24f4a9c98a52aa584f319178fff4', './lib/perspective/binderlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/perspective/index.php', '28.4', 0),
('1278fdc04f3b4f855ea0662866d42889', './lib/perspectivelib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/polls/index.php', '28.4', 0),
('64f8dba39344127b48a5475e5f739b21', './lib/polls/polllib.php', '28.4', 0),
('a7b12f752eba0311dcc7380e74d060ce', './lib/polls/polllib_shared.php', '28.4', 0),
('c7766d4d13508b1266c57869f318c9b9', './lib/prefs/access.php', '28.4', 0),
('959d991ef5b3695a52c155da1fbb05ec', './lib/prefs/activity.php', '28.4', 0),
('32e773da5c4482fdd01b18ff2e21374e', './lib/prefs/ajax.php', '28.4', 0),
('5f61f5692f04e0c18820ffb8050083bc', './lib/prefs/alchemy.php', '28.4', 0),
('12b8317fe5c71d8047f2cc223c19fd73', './lib/prefs/allocate.php', '28.4', 0),
('218d4b7866a116c96232511de20bf9c9', './lib/prefs/allowmsg.php', '28.4', 0),
('7981d92d585a9cbe32f378270dc7985d', './lib/prefs/areas.php', '28.4', 0),
('d9f9abe984bfe32ee9881fb14726f17e', './lib/prefs/art.php', '28.4', 0),
('68751cbeeb021fad7c95afd5bd190e7a', './lib/prefs/article.php', '28.4', 0),
('2c464830367e30438e08c731fe8eb3fb', './lib/prefs/auth.php', '28.4', 0),
('82696513495dcbc245b01341c221a61c', './lib/prefs/available.php', '28.4', 0),
('d35fd48f8b5ae02bb87013f324bd6b8c', './lib/prefs/bigbluebutton.php', '28.4', 0),
('365edbeaa35a92322123edb93f5e01bf', './lib/prefs/blog.php', '28.4', 0),
('8ad4cf309b35424646d4abe50c23a0bc', './lib/prefs/box.php', '28.4', 0),
('e0bc64b3b48cbc9617f918818bd1a31f', './lib/prefs/calendar.php', '28.4', 0),
('82732248927a6a907c254db11779f09e', './lib/prefs/captcha.php', '28.4', 0),
('652f65ae24c3bd1c5f26bf1f77aa932b', './lib/prefs/cas.php', '28.4', 0),
('553a118d9bc3d98875802e90779b5f69', './lib/prefs/categories.php', '28.4', 0),
('7117486f1b76f0bace6131bab4efd5d0', './lib/prefs/category.php', '28.4', 0),
('eb2260375252203227a5dc4dd08b14c7', './lib/prefs/categorypath.php', '28.4', 0),
('bb4b3c2d41873a683d4a9ba0ecf445e0', './lib/prefs/center.php', '28.4', 0),
('5ef4e6899f766ffd5e249b4ceaffdeaa', './lib/prefs/change.php', '28.4', 0),
('5ef3e1c886a06373caf80335621f8c92', './lib/prefs/comments.php', '28.4', 0),
('fc39296067bed863ebaa1825bba5f779', './lib/prefs/conditions.php', '28.4', 0),
('a6df60813bea9066a6a75599305b9795', './lib/prefs/connect.php', '28.4', 0),
('bb17e17b0304575cfaf18266be97e6ad', './lib/prefs/contact.php', '28.4', 0),
('1959b5ebd47e8a79408d129ce43b9101', './lib/prefs/cookie.php', '28.4', 0),
('4d622695b5c14371643c32442f29bbaa', './lib/prefs/count.php', '28.4', 0),
('eb1660e2e8ecec68336e687b9f11123f', './lib/prefs/dailyreports.php', '28.4', 0),
('e65af7d5c10c82212b53c35b5e3d7a76', './lib/prefs/default.php', '28.4', 0),
('46d3957d8c9e82ac342ab94c09dd3394', './lib/prefs/desactive.php', '28.4', 0),
('1ffa8dca8d05cd5b61cca80341f11277', './lib/prefs/direct.php', '28.4', 0),
('f8f4e0364b4a6c11312c95c547695c65', './lib/prefs/directory.php', '28.4', 0),
('7530ab409e5c1d6a2b8f451435e1c80c', './lib/prefs/display.php', '28.4', 0),
('38da39d2c7ece1c9dade78254f7b1a29', './lib/prefs/elementplus.php', '28.4', 0),
('d54aa11966ea2aea65322a13ca07c7f1', './lib/prefs/email.php', '28.4', 0),
('81cb351a5c65f579fc708b2f866359cf', './lib/prefs/error.php', '28.4', 0),
('89fa22fb60b829f1a67aa765d576a54e', './lib/prefs/faq.php', '28.4', 0),
('89862906c42d001cdf27149b08f12879', './lib/prefs/feature.php', '28.4', 0),
('b45c6ba35ec56ae2280acd2b19af0eae', './lib/prefs/federated.php', '28.4', 0),
('552412e23636b6f9ace8d4e5621517ea', './lib/prefs/feed.php', '28.4', 0),
('345ac364080b97782ba192c0263c7553', './lib/prefs/fgal.php', '28.4', 0),
('94e741351be7419e1cb6dcc11d5f2cb2', './lib/prefs/file.php', '28.4', 0),
('b03e937e485e78d5d2f67a97ead2b48a', './lib/prefs/flaggedrev.php', '28.4', 0),
('8056b4f3afb67b74420850172ddc5adc', './lib/prefs/footer.php', '28.4', 0),
('5928d95dfc2d9b67e98744ae09c2fcc5', './lib/prefs/footnote.php', '28.4', 0),
('84a3f81a0df377fc1b247a23a97cb534', './lib/prefs/forum.php', '28.4', 0),
('94977f1ed71af5e7ea339234d045e0de', './lib/prefs/forums.php', '28.4', 0),
('73a4162b029248c3eb1ba0d5215a937a', './lib/prefs/freetags.php', '28.4', 0),
('11d1ddd0f95c6010516438ff838bda51', './lib/prefs/generate.php', '28.4', 0),
('45117272eef4e4e13b0ad0a4758248f7', './lib/prefs/geo.php', '28.4', 0),
('55ebb93401b411e3dfc72709aaa3f66c', './lib/prefs/global.php', '28.4', 0),
('1b9491a224dc57f07cac21b7ce7fc9a7', './lib/prefs/gmap.php', '28.4', 0),
('99aed5b086659b9ccca54d2ec90a0991', './lib/prefs/goal.php', '28.4', 0),
('8d9cbb5202b9ba5add11d7e86f8c7797', './lib/prefs/h5p.php', '28.4', 0),
('a3a9d66f60c2f4899f14db2e6dfd1f3e', './lib/prefs/header.php', '28.4', 0),
('b0e5ba4086baea0878ae819f546284cf', './lib/prefs/headlessbrowser.php', '28.4', 0),
('ccae839947aa764d0fe3bd2bc9df8bcd', './lib/prefs/highlight.php', '28.4', 0),
('d1699cd6f1ae0289c8edbb4d2157f538', './lib/prefs/home.php', '28.4', 0),
('fb35e3ad062e1f60e89bd98399f2d90e', './lib/prefs/http.php', '28.4', 0),
('902b4417ae2348c5268f850f68975047', './lib/prefs/https.php', '28.4', 0),
('d6545dbc9908ec68a59cfc9cffecf921', './lib/prefs/ids.php', '28.4', 0),
('d2db539eb3365372a78f932e482ba6e6', './lib/prefs/image.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/prefs/index.php', '28.4', 0),
('4042f6049db7eac54249fab0389d3412', './lib/prefs/intertiki.php', '28.4', 0),
('9fda07d2b9bda267cececf0d5f857825', './lib/prefs/ip.php', '28.4', 0),
('0b9c1b500185893d1d9637ba10b275cb', './lib/prefs/javascript.php', '28.4', 0),
('2de5fbadfe1c68da73b3a034931027e7', './lib/prefs/jquery.php', '28.4', 0),
('a4766c99ca0aa24beef7402c5a8c51a2', './lib/prefs/kaltura.php', '28.4', 0),
('48654b7e578d1c57b3c7561823fd208f', './lib/prefs/keep.php', '28.4', 0),
('06532d0fbbd1b176e89522efd46989fb', './lib/prefs/lang.php', '28.4', 0),
('a7ee209afd6876c727de79963aa6da30', './lib/prefs/language.php', '28.4', 0),
('7422bfd9cde2782288cfa87a926e557a', './lib/prefs/layout.php', '28.4', 0),
('b9a4455ee2f86e7a4997aa9b815d41d2', './lib/prefs/ldap.php', '28.4', 0),
('8033dff8d69b11a9a385fab727134f25', './lib/prefs/load.php', '28.4', 0),
('e1e25ba3d4106268428552311760b2a3', './lib/prefs/lock.php', '28.4', 0),
('e89004232d79d22229668ca87ff84e30', './lib/prefs/log.php', '28.4', 0),
('751a05ad4e7f69c6613992764ffc3f8d', './lib/prefs/login.php', '28.4', 0),
('bc4baa5f2dded562dac4352e517e948a', './lib/prefs/long.php', '28.4', 0),
('d3537959aa1c3d017bac0c69f8a192a2', './lib/prefs/lowercase.php', '28.4', 0),
('9f04e4cd200ed650190c840cd38b9dc6', './lib/prefs/mail.php', '28.4', 0),
('3ce692d376480cc6037b69d6d278daca', './lib/prefs/main.php', '28.4', 0),
('5156d9b3cc041b21ac21d8d056cfeb91', './lib/prefs/markdown.php', '28.4', 0),
('9a5e6bd0fa8cdba8f76bcaaf29af7eee', './lib/prefs/max.php', '28.4', 0),
('261372596aa5b34ab1e1ce4c5491e9f1', './lib/prefs/memcache.php', '28.4', 0),
('ce8891517cb6af5de02c8ff266b6e0fd', './lib/prefs/menus.php', '28.4', 0),
('a95d8a0582a12c2dcde9f9ae1ee1b33f', './lib/prefs/messu.php', '28.4', 0),
('1fc07b2cc55b0bc84e248fe8f72949a8', './lib/prefs/metatag.php', '28.4', 0),
('d83269f62c7603412d0f9210a92bf5ff', './lib/prefs/middle.php', '28.4', 0),
('84511480932eb11f5e9de1a505b3a02e', './lib/prefs/min.php', '28.4', 0),
('5c4c04e1afc622e80f1f0da1276f74fe', './lib/prefs/module.php', '28.4', 0),
('25b26837ac1c860862d8d8de803cf906', './lib/prefs/monitor.php', '28.4', 0),
('c292142092863d35ad532eb07b48e485', './lib/prefs/morelikethis.php', '28.4', 0),
('7d1e431fb90da3b76c4dd66c98fab6e1', './lib/prefs/multidomain.php', '28.4', 0),
('1923a93b70cada3b6907c32327b9fa0f', './lib/prefs/mustread.php', '28.4', 0),
('eadeac755ddc0028a28daabe65534c86', './lib/prefs/namespace.php', '28.4', 0),
('09f7323a339966d1394bf7bafc857ee2', './lib/prefs/newsletter.php', '28.4', 0),
('6727e177222560fb0c68328d10f57dbb', './lib/prefs/nextprev.php', '28.4', 0),
('6748e79bf7aa005b74232e5044e5ea06', './lib/prefs/oauthserver.php', '28.4', 0),
('89295bd06b9f7b8957837dbc19796ca8', './lib/prefs/object.php', '28.4', 0),
('4bb53f8f65339a03211c6c4894a2dd7a', './lib/prefs/ocr.php', '28.4', 0),
('95ea04ae84c33a3f0f1577f8868fcd1b', './lib/prefs/openidconnect.php', '28.4', 0),
('208cec3c71fefc8988ebc20f4b355dc8', './lib/prefs/openpgp.php', '28.4', 0),
('df4710e3f111d451fb8e8f62b73d87e7', './lib/prefs/page.php', '28.4', 0),
('4f5777a2b65f72b6aeeaa798e60465c9', './lib/prefs/pagination.php', '28.4', 0),
('ff89fe6ce342225f7a2fc222fe989317', './lib/prefs/pam.php', '28.4', 0),
('fcfcf8c456e55063d5a68dabbffd332e', './lib/prefs/pass.php', '28.4', 0),
('7d050c58cd94b0d09969c4fb87bebe2f', './lib/prefs/payment.php', '28.4', 0),
('425e686507dbebe3a1fe1bff80cb1047', './lib/prefs/permission.php', '28.4', 0),
('ca01bd5a4ca3b59599fa7d9356d0488f', './lib/prefs/php.php', '28.4', 0),
('3f8275d099d6535f05303a238be01f8b', './lib/prefs/poll.php', '28.4', 0),
('cda4314bf1850c881204c3d7cd28bd5d', './lib/prefs/print.php', '28.4', 0),
('845c30e5722943d5d04b8df989f1453b', './lib/prefs/profile.php', '28.4', 0),
('718410207e74047df7b4b8f642a1769b', './lib/prefs/proxy.php', '28.4', 0),
('77a9fd07d425255b48a141f80886306a', './lib/prefs/pwa.php', '28.4', 0),
('8ed439861ca656d3e42a91d8793d6903', './lib/prefs/quantify.php', '28.4', 0),
('3dda114e30a74c7a2ab6903ebecbd9a7', './lib/prefs/rating.php', '28.4', 0),
('86e509b7c75b2c16c8a74557bc96243f', './lib/prefs/realtime.php', '28.4', 0),
('53e0ca09b3768cf1710d89027d7eb34f', './lib/prefs/recaptcha.php', '28.4', 0),
('1fe8276355c6e79707e15b31577f7787', './lib/prefs/record.php', '28.4', 0),
('a572a5ae61786ff7ba2acc0a425febb6', './lib/prefs/redis.php', '28.4', 0),
('2ea0159ca00bd02f464c07b7e8df576a', './lib/prefs/restrict.php', '28.4', 0),
('1af5c5b3800468bb9206723c67f7c865', './lib/prefs/saml.php', '28.4', 0),
('e7cb724216eefe7c0ad4df166d2b2a42', './lib/prefs/scheduler.php', '28.4', 0),
('5fe11d7a141b69b74fa5c1ba8fca3a35', './lib/prefs/scorm.php', '28.4', 0),
('edda1f5991d67e71de26154e5caed82c', './lib/prefs/search.php', '28.4', 0),
('f1886efad7d619234c3ac8a15e672568', './lib/prefs/section.php', '28.4', 0),
('313a16df9f790bab7ac0935f212bd583', './lib/prefs/sefurl.php', '28.4', 0),
('6dfe7a5dcf54e624b42597237824e7de', './lib/prefs/sender.php', '28.4', 0),
('b430f14197baa2fbdf2bf9855422368a', './lib/prefs/server.php', '28.4', 0),
('ff09a79ea6cb9cddfcdf9bfb488aaefd', './lib/prefs/session.php', '28.4', 0),
('0b28a7cf7873cc8bacdfbbf421847b5c', './lib/prefs/share.php', '28.4', 0),
('328ff78e0a01f0f766e5fc3501354008', './lib/prefs/shib.php', '28.4', 0),
('0752e06d5bb157f8fd5870437a1e911a', './lib/prefs/shipping.php', '28.4', 0),
('cea2f68af79c80c2befa2cd91b51386c', './lib/prefs/short.php', '28.4', 0),
('8c42ee0aff6567fed995c11651a40c6a', './lib/prefs/show.php', '28.4', 0),
('9a69acdce6c0f89527b50098d3021dc7', './lib/prefs/site.php', '28.4', 0),
('28dab5f395c8fd88991e5e723c5ce79b', './lib/prefs/sitead.php', '28.4', 0),
('6c741170dea5c3d30595ef0670b649f5', './lib/prefs/sitelogo.php', '28.4', 0),
('7e22a09e05cec546a0abe4d6670cae6e', './lib/prefs/sitemap.php', '28.4', 0),
('d64599c6243826f5cba9ebcb5eb844f5', './lib/prefs/slide.php', '28.4', 0),
('acd74aba018ba6caeceb67f850c144a8', './lib/prefs/smarty.php', '28.4', 0),
('0a5c488ea9906fc8e08f7fcac72827c5', './lib/prefs/social.php', '28.4', 0),
('004b785ad391b97b8d236a2d4bf53de5', './lib/prefs/socialnetworks.php', '28.4', 0),
('644afd3b360c8742b0a9c26903722473', './lib/prefs/socnets.php', '28.4', 0),
('1adf15c3ae11e8f9799b07384cab808c', './lib/prefs/storedsearch.php', '28.4', 0),
('f1a14bca0ad3b747356793225e33661f', './lib/prefs/suite.php', '28.4', 0),
('042c0967678183768b5b7e643f244123', './lib/prefs/t.php', '28.4', 0),
('e7ad74fba4687e00253acc4056be905c', './lib/prefs/theme.php', '28.4', 0),
('569167875e6068bc8d11996ea8893290', './lib/prefs/tiki.php', '28.4', 0),
('560c060169747b696f7f0c877ff4aef0', './lib/prefs/tikimanager.php', '28.4', 0),
('d346fb45ef8af9fe08832bc90bf60259', './lib/prefs/tracker.php', '28.4', 0),
('6f826361e560ec7bc1638641109db1f3', './lib/prefs/trackerfield.php', '28.4', 0),
('c36b3b79de454932b1361df99619741d', './lib/prefs/uf.php', '28.4', 0),
('38e064e69f5a4c126658eb2e3e85defa', './lib/prefs/unified.php', '28.4', 0),
('d1271b6a43839220e9d9bcb2870679c7', './lib/prefs/unsuccessful.php', '28.4', 0),
('d2f3856fbf0256400e3078555325a8b1', './lib/prefs/url.php', '28.4', 0),
('23f70b090a0d052e7f4adf4992525c27', './lib/prefs/use.php', '28.4', 0),
('ef8a54c367b7c70fc58e957b19f1badc', './lib/prefs/user.php', '28.4', 0),
('d1ab4495237e6d193dab6f2e92021d74', './lib/prefs/userfiles.php', '28.4', 0),
('c22f770627c2c5ad2768014100ffe601', './lib/prefs/username.php', '28.4', 0),
('53f854879896b02197c6a5f78dd758f2', './lib/prefs/users.php', '28.4', 0),
('1a8f6d818271d92636d6a5e8e8d0fb63', './lib/prefs/validator.php', '28.4', 0),
('b528a93bd3b424d80c66ef98d7528b2d', './lib/prefs/vimeo.php', '28.4', 0),
('6dee1b43d20817bfc750fe66bc16a2e2', './lib/prefs/vuejs.php', '28.4', 0),
('d504916068130ec3cd729cfca1a19c5f', './lib/prefs/w.php', '28.4', 0),
('67578669c33d0c175443c4989c259474', './lib/prefs/warn.php', '28.4', 0),
('3584c333ba2d5e8cfc933620dc173cfe', './lib/prefs/webcron.php', '28.4', 0),
('2b79854727b9bb219c6e50b292bf98b8', './lib/prefs/webmonetization.php', '28.4', 0),
('17f1997f7db894f6d657b5cb5643e9be', './lib/prefs/webservice.php', '28.4', 0),
('0af316feebd02df58eabfbdb036f727a', './lib/prefs/wiki.php', '28.4', 0),
('08f45a6df95b78ee002057b02b9886c7', './lib/prefs/wikiapproval.php', '28.4', 0),
('2e80bde55d727e1a01c1caeca63017e9', './lib/prefs/wikiplugin.php', '28.4', 0),
('5ef70b903dc27f6754915a0502e59d0a', './lib/prefs/wikiplugininline.php', '28.4', 0),
('db51f5751b20f2efbc92ec4a96ec9402', './lib/prefs/wikipluginprefs.php', '28.4', 0),
('46842a7f66ba0f7e39265ccabb5a404e', './lib/prefs/wizard.php', '28.4', 0),
('c8457206774b03bb6403b50488fcb47b', './lib/prefs/workspace.php', '28.4', 0),
('ed293bc2c4c0c86c63053a4c113fb001', './lib/prefs/wysiwyg.php', '28.4', 0),
('488e84ee77a2d3f7c41893f6af80dd49', './lib/prefs/xmpp.php', '28.4', 0),
('6dcbb757ff991f3d77d1bf0d0b5e8c5e', './lib/prefs/zend.php', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('634dba4114fa177a875b52c751e3c75d', './lib/prefs/zotero.php', '28.4', 0),
('d35766fedab1561031a75c628cbe0fb7', './lib/prefslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/profilelib/index.php', '28.4', 0),
('fe7452e28c26c9909e136ab83fcc0d09', './lib/profilelib/shell.php', '28.4', 0),
('1b21b1f0132353b596d44deedc38fd34', './lib/pwa/app.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/pwa/index.php', '28.4', 0),
('5cbb879427f8d5aae74b5d4cf757da17', './lib/pwa/trackers.js', '28.4', 0),
('c1f67269e63462ce052b078310f348c5', './lib/queuelib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/quizzes/index.php', '28.4', 0),
('f2b31a267940b1cddbe4cbc4b65ef4b1', './lib/quizzes/quizlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/rankings/index.php', '28.4', 0),
('76c40b24856dc1d2e86ffea07aa5cc81', './lib/rankings/ranklib.php', '28.4', 0),
('49514f7fd072f55a2f3c9f05f1a54c1b', './lib/rating/configlib.php', '28.4', 0),
('57a08fa0583c78a545c0387cfff60315', './lib/rating/formula/ArticleInfo.php', '28.4', 0),
('e82848fe8bca07ce1bb22ef57dfb8041', './lib/rating/formula/Attribute.php', '28.4', 0),
('f7f8d85f2feb197616c1cf7ccd78b02c', './lib/rating/formula/CategoryPresent.php', '28.4', 0),
('3e012492a15e3578a5846cfb87ccba16', './lib/rating/formula/RatingAverage.php', '28.4', 0),
('9ea183ae21dd97a652b2b128a10d4568', './lib/rating/formula/RatingSum.php', '28.4', 0),
('63493d08df0a24c8840602343c56b60a', './lib/rating/formula/RelationPresent.php', '28.4', 0),
('7eed0cc1dc397ccb6688a3eefcf4b1d1', './lib/rating/formula/ResultCount.php', '28.4', 0),
('392b4bc7016c36f7f17b9739a2b75bba', './lib/rating/formula/TrackerField.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/rating/formula/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/rating/index.php', '28.4', 0),
('9e2ffeb4bf06fd3a68cc02cb35011a8b', './lib/rating/ratinglib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/references/index.php', '28.4', 0),
('5120a87724bce92303cc6b03c8329de1', './lib/references/referenceslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/refererstats/index.php', '28.4', 0),
('2601b70491ca3ce16273b5f98e1d59bc', './lib/refererstats/refererlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/registration/index.php', '28.4', 0),
('5fc0ff51cbd4428e80f6103b40254577', './lib/registration/registrationlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/rss/index.php', '28.4', 0),
('7a62b5a1569e94478c7b779efe2d5f72', './lib/rss/pagecontentlib.php', '28.4', 0),
('d15a50d4c81bd0428274eb645a744f29', './lib/rss/rsslib.php', '28.4', 0),
('d82521212532aa0694d739893c92c07e', './lib/schedulerslib.php', '28.4', 0),
('ca54cbc7eb1c6b17e7b5cbca5989a767', './lib/score/events.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/score/index.php', '28.4', 0),
('bf58a3f6f0cfb55d2855a4e9a0f5fc31', './lib/score/scorelib.php', '28.4', 0),
('af5eadcebf515d2322be5c29cf741123', './lib/search/federatedsearchlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/search/index.php', '28.4', 0),
('7333dc989f638e38a3c2915357e96086', './lib/search/refresh-functions.php', '28.4', 0),
('7d179d606bade4fe4e1bc7ee5936e5bb', './lib/search/refresh.php', '28.4', 0),
('8212c91600793d07180e7cf9f6ae6025', './lib/search/report_string_in_db.php', '28.4', 0),
('d51babd2c9f95411fd810d017b762772', './lib/search/searchlib-unified.php', '28.4', 0),
('91aaed13d768c5838585116be40550d4', './lib/search/searchstatslib.php', '28.4', 0),
('fe7452e28c26c9909e136ab83fcc0d09', './lib/search/shell.php', '28.4', 0),
('0ba9d8e9bd51872a5bde8cc8f9d802a3', './lib/search/storedsearchlib.php', '28.4', 0),
('3b02f8878bfc3390603cacb01983e77a', './lib/serializedlist.php', '28.4', 0),
('644d960612014a66a27117e9e1499ad2', './lib/servicelib.php', '28.4', 0),
('394875dfe3e834b1442eeef3f076d45c', './lib/setup/absolute_urls.php', '28.4', 0),
('e9b67012f60a5d013369b8b203a3dd75', './lib/setup/avatar_force_upload.php', '28.4', 0),
('9f7953106899777e3e1f3d40aa574696', './lib/setup/categories.php', '28.4', 0),
('55e8db2cf3c335e8fc38cf9d0ca93ff1', './lib/setup/comments_zone.php', '28.4', 0),
('932ec141839c89520381ad4104982ca0', './lib/setup/cookies.php', '28.4', 0),
('042011713eb35910be83abbc0bb75f27', './lib/setup/credits.php', '28.4', 0),
('887510f7f8a0768aa11def69a3c4717f', './lib/setup/default_homepage.php', '28.4', 0),
('766dfa7a08e1a99573c788f760f6a95c', './lib/setup/dynamic_variables.php', '28.4', 0),
('2c099788de64d51d02e88dfb495688c9', './lib/setup/editmode.php', '28.4', 0),
('bb1dd3a147ade575e063b3efa3cff96d', './lib/setup/error_reporting.php', '28.4', 0),
('cd08568db5f2990ee105f1a887f9ccd0', './lib/setup/error_tracking.php', '28.4', 0),
('8738200579a33412b0a3eca76b311b8d', './lib/setup/events.php', '28.4', 0),
('30864d719b7bdf5f0fee76a79467d7f1', './lib/setup/freetags.php', '28.4', 0),
('e66f98caead96d3e7b9dbb20ae94cdc0', './lib/setup/fullscreen.php', '28.4', 0),
('10fbbc80cc4048348eb05cee1064beda', './lib/setup/ids.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/setup/index.php', '28.4', 0),
('29abd8d8d3cb556805f47c027b2a3e44', './lib/setup/integrator.php', '28.4', 0),
('3cf6d33acf25704a973b8307050f8647', './lib/setup/javascript.php', '28.4', 0),
('f5896cab13988d5e8d44aa787164102d', './lib/setup/language.php', '28.4', 0),
('976b16d37ed5b734693f6112e982a9fe', './lib/setup/last_update.php', '28.4', 0),
('a2fefe274f6a02cccf8887a987ba6b73', './lib/setup/live_support.php', '28.4', 0),
('a86bdddd6980b7ab9530627f28fb662b', './lib/setup/load_threshold.php', '28.4', 0),
('9a0f7bfb18be3e0c32f381d346399845', './lib/setup/mailin.php', '28.4', 0),
('0243561866ce766813ee36e1957a1855', './lib/setup/output_compression.php', '28.4', 0),
('c146b37dce5a4d94db1acae03a0a45f3', './lib/setup/perms.php', '28.4', 0),
('4c04dd43be53ec3ab192a49899defd7d', './lib/setup/plugins_actions.php', '28.4', 0),
('6e541654886e74e5f65b310d5524aec7', './lib/setup/polls.php', '28.4', 0),
('c66186bc2c8b238a3cba981c8af3ad28', './lib/setup/prefs.php', '28.4', 0),
('1ad0bd0ac99d22574129732de308a43a', './lib/setup/sections.php', '28.4', 0),
('9577ad635b7b83c38b7aed7ecbd87d3a', './lib/setup/site_closed.php', '28.4', 0),
('7e40cc8e90020a947c5587caff1cddb1', './lib/setup/stats.php', '28.4', 0),
('6e19f9fdec1f529dec7ab5e0f8d1bf92', './lib/setup/theme.php', '28.4', 0),
('7d1b0609822c1ea96a10822451be50ff', './lib/setup/third_party.php', '28.4', 0),
('5c5132f62ae740f6b15e7db489c954df', './lib/setup/tikiIndex.php', '28.4', 0),
('e998810f9ef89fd981fdb8a5f163bf91', './lib/setup/tikisetup.class.php', '28.4', 0),
('a431589f30efa32bfa7c801c134d11b6', './lib/setup/tracker_force_fill.php', '28.4', 0),
('80924a7dde9be37fe6ea99da085d150e', './lib/setup/twversion.class.php', '28.4', 0),
('b2300f70bfa8baf0bdb95b4654e07f8a', './lib/setup/ui/elementplus.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/setup/ui/index.php', '28.4', 0),
('217671c3c763c184f662ca52103c3f3a', './lib/setup/user_prefs.php', '28.4', 0),
('508782e4961e0a9939029cbe40423c97', './lib/setup/userlevels.php', '28.4', 0),
('4bdc334eae6eb19e9e2c299bcf7e75d3', './lib/setup/usermenu.php', '28.4', 0),
('188bdf1dc5584416a45e8e0c564b248e', './lib/setup/wiki.php', '28.4', 0),
('fddae4e0ac3cdf3302c616142260806f', './lib/sharelib.php', '28.4', 0),
('a4f2ad00d3517f72abc1a7af5c175720', './lib/sheet/conf/config.inc.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/sheet/conf/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/sheet/excel/index.php', '28.4', 0),
('5105cd643514cb0f96bbb23f3fcc38f6', './lib/sheet/excel/reader.php', '28.4', 0),
('3544c7f37a8d007ba4d6256c9a3a20ae', './lib/sheet/excel/reader_ole.php', '28.4', 0),
('44646d93c3613022a4e331088ca1dd7a', './lib/sheet/excel/writer.php', '28.4', 0),
('7f0152abcd61bab379ccb3d0d23ea907', './lib/sheet/excel/writer/biffwriter.php', '28.4', 0),
('9d1fd9b371d64eaf625e7e5f3b3a446d', './lib/sheet/excel/writer/format.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/sheet/excel/writer/index.php', '28.4', 0),
('534d5f49c2f4cc1fc7deccac23dc6d4a', './lib/sheet/excel/writer/parser.php', '28.4', 0),
('0c348caf6f78265780beec5111e286c7', './lib/sheet/excel/writer/validator.php', '28.4', 0),
('b5c6422068f57493164795c7fc4d3307', './lib/sheet/excel/writer/workbook.php', '28.4', 0),
('85b931794f54ef39ebc700290f814560', './lib/sheet/excel/writer/worksheet.php', '28.4', 0),
('c98dce263cb897680a71fd11720b1a7b', './lib/sheet/grid.js', '28.4', 0),
('a203268dc6df1c3213ff637696ee38be', './lib/sheet/grid.php', '28.4', 0),
('a08db8eabbe39331ebfcb0108cf28889', './lib/sheet/include/core/APIC.php', '28.4', 0),
('1be36f6175a6c7df220edd4c865ccbbd', './lib/sheet/include/core/APICObject.php', '28.4', 0),
('538dbc8a7a7a4ccb9174b6774d855fcc', './lib/sheet/include/core/APIClass.php', '28.4', 0),
('9c5cafc0b489476310b2df0e80e39075', './lib/sheet/include/core/APIClassRegistry.php', '28.4', 0),
('77f120337c0c0f5b6601d8435dc25d5f', './lib/sheet/include/core/ErrorManager.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/sheet/include/core/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/sheet/include/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/sheet/include/org/apicnet/index.php', '28.4', 0),
('fe15e6cceb0cc7b3356f85c66e28ece2', './lib/sheet/include/org/apicnet/io/File.php', '28.4', 0),
('e08bbb4b60e227175b9ab01be9b0d34a', './lib/sheet/include/org/apicnet/io/OOo/OOoCalc.php', '28.4', 0),
('4ec429f03d40bbe47b5b5365cfd5e1f5', './lib/sheet/include/org/apicnet/io/OOo/OOoDoc.php', '28.4', 0),
('e8c80a10deb6bb90a3b887f2decf431d', './lib/sheet/include/org/apicnet/io/OOo/OOoManifest.php', '28.4', 0),
('18ea5c12ebd59dce8ce9dfbbe2086f2b', './lib/sheet/include/org/apicnet/io/OOo/OOoMeta.php', '28.4', 0),
('0d4520d39070954dd9ea16b6a34fb59d', './lib/sheet/include/org/apicnet/io/OOo/OOoMime.php', '28.4', 0),
('ad4d2fba56f11e6305b359091e228ee1', './lib/sheet/include/org/apicnet/io/OOo/OOoStyle.php', '28.4', 0),
('fbbaf16f0479f43d3c7eeb5492181fa3', './lib/sheet/include/org/apicnet/io/OOo/OOoUtil.php', '28.4', 0),
('0592b5a74b46b9bcca578e8d0368823e', './lib/sheet/include/org/apicnet/io/OOo/OOoWriter.php', '28.4', 0),
('c640f55a92004fb5ee9469d44f7e84e4', './lib/sheet/include/org/apicnet/io/OOo/absOOo.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './lib/sheet/include/org/apicnet/io/OOo/index.php', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoCadre.php', '28.4', 0),
('6e1d031f81e959a5ad87aa37c1f4e149', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoImg.php', '28.4', 0),
('9cd61de34c3e84f1ad8079a9a128974d', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoTable.php', '28.4', 0),
('daf2faa10875e93905a3a38ef8167c4a', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoText.php', '28.4', 0),
('ae1ca7e7618014a7056b4cfef3362afd', './lib/sheet/include/org/apicnet/io/OOo/objOOo/index.php', '28.4', 0),
('c055f6e447f0e451bbc1ab4e0e6bcb59', './lib/sheet/include/org/apicnet/io/archive/CZip.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './lib/sheet/include/org/apicnet/io/archive/index.php', '28.4', 0),
('557867972272973a271ab8bd38b733e2', './lib/sheet/include/org/apicnet/io/cdir.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/sheet/include/org/apicnet/io/index.php', '28.4', 0),
('2166cfe52ef7c6d74107d3ae8f584ef1', './lib/sheet/include/org/apicnet/util/HTTPHeader.php', '28.4', 0),
('02413a4bdbc1abc36fd7c340f6c9b526', './lib/sheet/include/org/apicnet/util/StringBuffer.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/sheet/include/org/apicnet/util/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/sheet/include/org/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/sheet/index.php', '28.4', 0),
('2383faff7dad9b5a54ae53da9e7cacd5', './lib/sheet/ole.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/sheet/ole/index.php', '28.4', 0),
('b9451b11d613a600dac29d30df1872ff', './lib/sheet/ole/pps.php', '28.4', 0),
('bd3e553871c0ff468eab011fc7a2a784', './lib/sheet/ole/pps/file.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/sheet/ole/pps/index.php', '28.4', 0),
('1e0044e9ba892ddac43359921de4af19', './lib/sheet/ole/pps/root.php', '28.4', 0),
('1838ee116b6710bcbfccc36f7d201d70', './lib/sheet/sheetlib.php', '28.4', 0),
('e04070800aa134273ad26221be509183', './lib/shipping/custom/example.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/shipping/custom/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/shipping/index.php', '28.4', 0),
('ae25ed0993dfda5aef415db44315cb82', './lib/shipping/provider_fedex.php', '28.4', 0),
('2edefd406aa0c3b615a7ca31c313cd4e', './lib/shipping/provider_ups.php', '28.4', 0),
('8416e7a00e7bd950d80a4d8cb5bdf0fd', './lib/shipping/shippinglib.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/shipping/ups-wsdl/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/shoutbox/index.php', '28.4', 0),
('3ba42aabfd9bd6f33c7b18849cf21770', './lib/shoutbox/shoutboxlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/simile_tiki/index.php', '28.4', 0),
('d9e13489b4f69f02b98c1e9229538925', './lib/simile_tiki/tiki-timeline.js', '28.4', 0),
('7a7259e3d0a1d93dd8c0146133fc335c', './lib/smarty_tiki/BlockHandler/Accordion.php', '28.4', 0),
('0b7bf5e049d084740226da12802de329', './lib/smarty_tiki/BlockHandler/AccordionGroup.php', '28.4', 0),
('d1189d1bdb0dd8d023e3563af01dea28', './lib/smarty_tiki/BlockHandler/Actions.php', '28.4', 0),
('2da949866bcc24095f0f4d444b82093b', './lib/smarty_tiki/BlockHandler/ActivityFrame.php', '28.4', 0),
('9ebbe58399066bd5d0578e6cdc2ef910', './lib/smarty_tiki/BlockHandler/AjaxHref.php', '28.4', 0),
('29426b0a2638c01feb5bb3e92f375938', './lib/smarty_tiki/BlockHandler/Compact.php', '28.4', 0),
('45110dc44b9e5440fb5c9bc9e4bd71a2', './lib/smarty_tiki/BlockHandler/Display.php', '28.4', 0),
('258daf49bfb65d63c1b295d2d92f16c0', './lib/smarty_tiki/BlockHandler/Filter.php', '28.4', 0),
('e4641281669733906749acb132817f0d', './lib/smarty_tiki/BlockHandler/IfSearchExists.php', '28.4', 0),
('07da1c7d014c04815a0410774730a42e', './lib/smarty_tiki/BlockHandler/IfSearchNotExists.php', '28.4', 0),
('8f9462c66e389a7dad6af163922f2fad', './lib/smarty_tiki/BlockHandler/ItemField.php', '28.4', 0),
('8e0b743a4e34498c22056d08e119f04b', './lib/smarty_tiki/BlockHandler/Jq.php', '28.4', 0),
('8b943d25c9c7bb5c21b743830948a865', './lib/smarty_tiki/BlockHandler/MailUrl.php', '28.4', 0),
('0a5df822fce861f8b2af17dc590e566c', './lib/smarty_tiki/BlockHandler/ModulesList.php', '28.4', 0),
('6edac50386a6d8c77878b8063ec4b3bf', './lib/smarty_tiki/BlockHandler/PackagePlugin.php', '28.4', 0),
('560898508b505fd10c5454b366baad9c', './lib/smarty_tiki/BlockHandler/PaginationLinks.php', '28.4', 0),
('b518f87da95a7eac24ff2ee97fdec9dd', './lib/smarty_tiki/BlockHandler/Permission.php', '28.4', 0),
('30811ed541ca54f79e77353aa810a4dd', './lib/smarty_tiki/BlockHandler/PopupLink.php', '28.4', 0),
('da896e2b8d77dcd085c33cf9cd1a87fa', './lib/smarty_tiki/BlockHandler/Remarksbox.php', '28.4', 0),
('2d055876c6a6f010497bfaadfd19d111', './lib/smarty_tiki/BlockHandler/Repeat.php', '28.4', 0),
('68938cf9c4330d6f8aa9b60cef0d8522', './lib/smarty_tiki/BlockHandler/SelfLink.php', '28.4', 0),
('5a5afb880969453a51785aa9c9652438', './lib/smarty_tiki/BlockHandler/SortLinks.php', '28.4', 0),
('60ee96bd5cc61904e008e1c65e3cc781', './lib/smarty_tiki/BlockHandler/Tab.php', '28.4', 0),
('2b4a21ad32ee9cedf47181f1a2be3d25', './lib/smarty_tiki/BlockHandler/Tabset.php', '28.4', 0),
('23f11a90b2c76588ac0b1e1938107cff', './lib/smarty_tiki/BlockHandler/TextArea.php', '28.4', 0),
('3cf072bcc2bd9bf204f0e0ea4a67e662', './lib/smarty_tiki/BlockHandler/TikiModule.php', '28.4', 0),
('b5e61c381e59aac9ea56c7f284e89d1d', './lib/smarty_tiki/BlockHandler/Title.php', '28.4', 0),
('b19f0d6e8cc38ef9d605f130bf3073b6', './lib/smarty_tiki/BlockHandler/Tr.php', '28.4', 0),
('a234207f92e3c85bb264ff8363b5a264', './lib/smarty_tiki/BlockHandler/TrackerItemCheck.php', '28.4', 0),
('6dceb2f0708b865964c8f8646e313c3e', './lib/smarty_tiki/BlockHandler/Translation.php', '28.4', 0),
('e0d9485856b6d1fb0181c74c58b63e3a', './lib/smarty_tiki/BlockHandler/Vue.php', '28.4', 0),
('3ed020f257f241e53842d21ddd45f954', './lib/smarty_tiki/BlockHandler/Wiki.php', '28.4', 0),
('abe1e381ba47bb6e897aef8b0127c5c2', './lib/smarty_tiki/BlockHandler/Wikiplugin.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/smarty_tiki/BlockHandler/index.php', '28.4', 0),
('19ef66542b206182c0424dfd559708c1', './lib/smarty_tiki/Compile/Modifier/EscapeModifierCompiler.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/smarty_tiki/Compile/Modifier/index.php', '28.4', 0),
('cfa02818de6133c697325d242d5c561b', './lib/smarty_tiki/Compile/Tag/AssignContent.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/smarty_tiki/Compile/Tag/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/smarty_tiki/Compile/index.php', '28.4', 0),
('6451b0ca5b77e7e1f89f8ef81f6b8347', './lib/smarty_tiki/Extension/SmartyTikiExtension.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/smarty_tiki/Extension/index.php', '28.4', 0),
('af4b6e87c011630fd6944eceec387608', './lib/smarty_tiki/Filter/Output/Highlight.php', '28.4', 0),
('67a1895194e85fe51b201bdde1e73e45', './lib/smarty_tiki/Filter/Output/Sefurl.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/smarty_tiki/Filter/Output/index.php', '28.4', 0),
('c41bbf492a6ac261c30a1eb245a44492', './lib/smarty_tiki/Filter/Pre/Jq.php', '28.4', 0),
('8fa1ffcd6378c244202ae9825d078d0f', './lib/smarty_tiki/Filter/Pre/LogTpl.php', '28.4', 0),
('a7aadaf818062852d00eceffeb5c985c', './lib/smarty_tiki/Filter/Pre/Tr.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/smarty_tiki/Filter/Pre/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/smarty_tiki/Filter/index.php', '28.4', 0),
('3d511c04c4d8e6ae2aecf305f00cb935', './lib/smarty_tiki/FunctionHandler/Activity.php', '28.4', 0),
('6bde8dff384683371f645950c02320eb', './lib/smarty_tiki/FunctionHandler/Article.php', '28.4', 0),
('a900f6c9153f7702b4fa66e9b4ae81d5', './lib/smarty_tiki/FunctionHandler/Attachments.php', '28.4', 0),
('087366c2aeb188ce92a1ba9798696a9a', './lib/smarty_tiki/FunctionHandler/Autocomplete.php', '28.4', 0),
('5c5019dce4ef1ea26d25fb4ebf5a3016', './lib/smarty_tiki/FunctionHandler/Banner.php', '28.4', 0),
('57d1ee9ff851ae892007e3fc9412f2f2', './lib/smarty_tiki/FunctionHandler/BootstrapModal.php', '28.4', 0),
('b50a5ccc625481be69158f0018e44b15', './lib/smarty_tiki/FunctionHandler/Breadcrumbs.php', '28.4', 0),
('92f3cf5e24e5afea3aa67a8803d3bbfb', './lib/smarty_tiki/FunctionHandler/Button.php', '28.4', 0),
('c98416204ea7e4c30a8f591b375018eb', './lib/smarty_tiki/FunctionHandler/CategoryName.php', '28.4', 0),
('5968575295508e6187eeffe8d36d513b', './lib/smarty_tiki/FunctionHandler/CategorySelector.php', '28.4', 0),
('e1ee8cdefb0e604933c8c20e3ec0962b', './lib/smarty_tiki/FunctionHandler/Content.php', '28.4', 0),
('b07178a7e6b46be33f482b149a4e478e', './lib/smarty_tiki/FunctionHandler/Cookie.php', '28.4', 0),
('9975d5c74c74c762c39ad3b7acaaf113', './lib/smarty_tiki/FunctionHandler/CookieJar.php', '28.4', 0),
('f97bab5187e52d8c9acfa47ef1b6302f', './lib/smarty_tiki/FunctionHandler/Count.php', '28.4', 0),
('ccf4ea4b452353a636f01e7eca01ab87', './lib/smarty_tiki/FunctionHandler/Currency.php', '28.4', 0),
('0f1948c1f66d3920b9d48940f88a1027', './lib/smarty_tiki/FunctionHandler/CustomTemplate.php', '28.4', 0),
('0312c2fafa7cde75b8d369e02af47c88', './lib/smarty_tiki/FunctionHandler/DatabaseQueryLog.php', '28.4', 0),
('ad3881a70cddd1d2203ce7d0fd5e3934', './lib/smarty_tiki/FunctionHandler/DatetimeRange.php', '28.4', 0),
('f3d69239e8b63368f5f233fe8cdba786', './lib/smarty_tiki/FunctionHandler/Debugger.php', '28.4', 0),
('ad7279fbeaaf9b3733e8485d2c4dc150', './lib/smarty_tiki/FunctionHandler/DefaultMapCenter.php', '28.4', 0),
('d5fd699c2c7427d45d251b266a65c253', './lib/smarty_tiki/FunctionHandler/Ed.php', '28.4', 0),
('401cd417ec5d46951eac61054d79e627', './lib/smarty_tiki/FunctionHandler/Elapsed.php', '28.4', 0),
('f02c9e5e3d0fb157afc7e1ebc369404c', './lib/smarty_tiki/FunctionHandler/Favorite.php', '28.4', 0),
('7f5c2b647c70e89646a0a0bc9dd34c43', './lib/smarty_tiki/FunctionHandler/Feedback.php', '28.4', 0),
('f490f5f1894980bac04b070b5d891fd0', './lib/smarty_tiki/FunctionHandler/FgalBrowse.php', '28.4', 0),
('5a24f0764e59c8bcc918e39469f3c5e2', './lib/smarty_tiki/FunctionHandler/FileGalManagerUrl.php', '28.4', 0),
('ce1b15445ccedda30e5646cfdc44c271', './lib/smarty_tiki/FunctionHandler/FileGalUploader.php', '28.4', 0),
('763f9234694ea822fef9bbe18e3ad30d', './lib/smarty_tiki/FunctionHandler/FileInfo.php', '28.4', 0),
('9047a4c22b221e6284db73363eb02665', './lib/smarty_tiki/FunctionHandler/FileSelector.php', '28.4', 0),
('206006b9de7c1ba6ae093fb846626c76', './lib/smarty_tiki/FunctionHandler/FormItem.php', '28.4', 0),
('627d5fdbe850ebde55698bb0bd7b47d9', './lib/smarty_tiki/FunctionHandler/Help.php', '28.4', 0),
('d2cb7fc852e88f52e51a9035cadbcde6', './lib/smarty_tiki/FunctionHandler/HtmlBodyAttributes.php', '28.4', 0),
('9ccceaecef288f8c10446194c9a914d7', './lib/smarty_tiki/FunctionHandler/HtmlSelectDate.php', '28.4', 0),
('348783e97c9446a26f5620f6e5a70387', './lib/smarty_tiki/FunctionHandler/HtmlSelectDuration.php', '28.4', 0),
('b10319ab05c2b09bcb46023d5fd7402e', './lib/smarty_tiki/FunctionHandler/HtmlSelectTime.php', '28.4', 0),
('577eb3ca0fb736acf7cd9e56ea1b7c08', './lib/smarty_tiki/FunctionHandler/Icon.php', '28.4', 0),
('075c335b3f0e169db61704725cfd8917', './lib/smarty_tiki/FunctionHandler/InitialsFilterLinks.php', '28.4', 0),
('bba741365cf6c36b414fb306d95c0bc4', './lib/smarty_tiki/FunctionHandler/InteractiveTranslation.php', '28.4', 0),
('082e3fb42ca3970bc6d0d677cdfbe977', './lib/smarty_tiki/FunctionHandler/JsCalendar.php', '28.4', 0),
('65e09878b5b794643a84ca9b0f8e1244', './lib/smarty_tiki/FunctionHandler/JsInsertIcon.php', '28.4', 0),
('45ddb1874741e0387aa4df648b8f61c3', './lib/smarty_tiki/FunctionHandler/JsMaxLength.php', '28.4', 0),
('6c4adcd672a68b30bb760698b17f5981', './lib/smarty_tiki/FunctionHandler/JsPopup.php', '28.4', 0),
('d8ebfb8aa0c588c4d547623d470bfcf5', './lib/smarty_tiki/FunctionHandler/JsTransferList.php', '28.4', 0),
('3e60193a258d8f31dc88587361168c7f', './lib/smarty_tiki/FunctionHandler/Like.php', '28.4', 0),
('ffd32504bf66b540df4183e6bed8533a', './lib/smarty_tiki/FunctionHandler/ListFilter.php', '28.4', 0),
('e5f85603508e00522f9e38694aaf78f2', './lib/smarty_tiki/FunctionHandler/Lock.php', '28.4', 0),
('98884f41f3a0d08ca948eb23b17c5138', './lib/smarty_tiki/FunctionHandler/MemUsage.php', '28.4', 0),
('e67ab2fdf4e8e87d745838190dfc3c99', './lib/smarty_tiki/FunctionHandler/Menu.php', '28.4', 0),
('dc16ace2eda407d4684d179374bd6e33', './lib/smarty_tiki/FunctionHandler/Module.php', '28.4', 0),
('984c32e9828dbc0947592d9e57fea8ea', './lib/smarty_tiki/FunctionHandler/ModuleList.php', '28.4', 0),
('dd22eab0383cb1c742f1ea0cdd12d9cf', './lib/smarty_tiki/FunctionHandler/MonitorLink.php', '28.4', 0),
('b419206101407cf5c3386fb764ba4c68', './lib/smarty_tiki/FunctionHandler/MultiLike.php', '28.4', 0),
('979b46176e38bf1326df815977fa2f13', './lib/smarty_tiki/FunctionHandler/NoRecords.php', '28.4', 0),
('c3c0edc5f1a11e65c43f5f5a449ca24c', './lib/smarty_tiki/FunctionHandler/NotificationLink.php', '28.4', 0),
('d95f1f7254305873e5d0dfac99d48c16', './lib/smarty_tiki/FunctionHandler/ObjInCat.php', '28.4', 0),
('f62f8a0d0b9f995f195a94250ff8904d', './lib/smarty_tiki/FunctionHandler/ObjectLink.php', '28.4', 0),
('380b77cdc8fb6c3e1e0a07fdee4cb0b3', './lib/smarty_tiki/FunctionHandler/ObjectScore.php', '28.4', 0),
('54f43f3d8a01fbe541c2f1f4711cb25f', './lib/smarty_tiki/FunctionHandler/ObjectSelector.php', '28.4', 0),
('9cd1efe3b4b21ea2940463cf690429e2', './lib/smarty_tiki/FunctionHandler/ObjectSelectorMulti.php', '28.4', 0),
('e7f1107ef33fc703315bf229904a011e', './lib/smarty_tiki/FunctionHandler/ObjectTitle.php', '28.4', 0),
('90ef124c474c84940d5673fbd71e2d42', './lib/smarty_tiki/FunctionHandler/ObjectType.php', '28.4', 0),
('df1f15eb37b6f22e34acad48ff509359', './lib/smarty_tiki/FunctionHandler/PageAlias.php', '28.4', 0),
('d03dc8d46500253a93ed5b83438b6894', './lib/smarty_tiki/FunctionHandler/PageInStructure.php', '28.4', 0),
('5cb7cdba5951c6699c543812438770d3', './lib/smarty_tiki/FunctionHandler/Payment.php', '28.4', 0),
('1312b4720be78b04345bc44188135608', './lib/smarty_tiki/FunctionHandler/PermissionLink.php', '28.4', 0),
('f8826296678ce3252e81a3e078c3541b', './lib/smarty_tiki/FunctionHandler/Pluralize.php', '28.4', 0),
('a45992de00cfea7d920093acea6b63db', './lib/smarty_tiki/FunctionHandler/Poll.php', '28.4', 0),
('849a1e829ac8a033bb8a6daec6999209', './lib/smarty_tiki/FunctionHandler/Popup.php', '28.4', 0),
('53b32118c8a7d30b70089123274414c4', './lib/smarty_tiki/FunctionHandler/Preference.php', '28.4', 0),
('394d2211e0168635bf220ec147e154de', './lib/smarty_tiki/FunctionHandler/ProfileSymbolValue.php', '28.4', 0),
('0fb71f57dee3281f5340641162b3d37e', './lib/smarty_tiki/FunctionHandler/Query.php', '28.4', 0),
('669a4431448a6f613c62c56bf68b1c25', './lib/smarty_tiki/FunctionHandler/Quotabar.php', '28.4', 0),
('848572dc1f04f0633d0c9c347b672e39', './lib/smarty_tiki/FunctionHandler/Rating.php', '28.4', 0),
('fcf21cda8aa4800dfaa7aeb4b3affee6', './lib/smarty_tiki/FunctionHandler/RatingChoice.php', '28.4', 0),
('fb8bbdf02328e5b1a798d409681f5e2c', './lib/smarty_tiki/FunctionHandler/RatingOverrideMenu.php', '28.4', 0),
('1e4f448b5e74f975f5634e8f239beec3', './lib/smarty_tiki/FunctionHandler/RatingResult.php', '28.4', 0),
('0bf3c2fa8e15bcbf058e4ac826998f93', './lib/smarty_tiki/FunctionHandler/RatingResultAvg.php', '28.4', 0),
('b365cbd579a6edca63662523d1056554', './lib/smarty_tiki/FunctionHandler/Rcontent.php', '28.4', 0),
('08787a505225fa4868594a4a7fb02c3a', './lib/smarty_tiki/FunctionHandler/Redirect.php', '28.4', 0),
('69b9ecda9db83405fe203337d771e905', './lib/smarty_tiki/FunctionHandler/ReindexFilePixel.php', '28.4', 0),
('30b2325865e29e39f7138db1b42f4931', './lib/smarty_tiki/FunctionHandler/RouterParams.php', '28.4', 0),
('b08bd520275f9abb202f4bb9dd41aad4', './lib/smarty_tiki/FunctionHandler/Rss.php', '28.4', 0),
('7c11cc48d060442d9d4030388f33ec06', './lib/smarty_tiki/FunctionHandler/SameUrl.php', '28.4', 0),
('507cdb16ca92a8a91fa620dcac17af2b', './lib/smarty_tiki/FunctionHandler/SchedulerParams.php', '28.4', 0),
('d69101b8e8a7b4d545527650e7f31697', './lib/smarty_tiki/FunctionHandler/Sefurl.php', '28.4', 0),
('be9694ce34540eea064632ad865881ff', './lib/smarty_tiki/FunctionHandler/SelectAll.php', '28.4', 0),
('83890aa81e30052aebc97473f44584e1', './lib/smarty_tiki/FunctionHandler/Service.php', '28.4', 0),
('9ac96ba5768a0be02e33f7d3f1167717', './lib/smarty_tiki/FunctionHandler/ServiceInline.php', '28.4', 0),
('f93e5bbde5fc8c82042e06696935f6e8', './lib/smarty_tiki/FunctionHandler/Set.php', '28.4', 0),
('2155499a604fb544c93bfcc246af4e70', './lib/smarty_tiki/FunctionHandler/ShowShort.php', '28.4', 0),
('c98416204ea7e4c30a8f591b375018eb', './lib/smarty_tiki/FunctionHandler/StrToLower.php', '28.4', 0),
('9b7dcfaed2c8fef6dc1a2040ff9f398d', './lib/smarty_tiki/FunctionHandler/SvnLastup.php', '28.4', 0),
('60c86397c3a4cf9a5562f518decef345', './lib/smarty_tiki/FunctionHandler/SvnRev.php', '28.4', 0),
('1f8b7603e1d0fd114951f7d8fe44834e', './lib/smarty_tiki/FunctionHandler/Syntax.php', '28.4', 0),
('c3c5f1187629502b4d7849843ee318fd', './lib/smarty_tiki/FunctionHandler/Thumb.php', '28.4', 0),
('f4de117dbf0a4a625921d633fc40b1e1', './lib/smarty_tiki/FunctionHandler/Ticket.php', '28.4', 0),
('a5946bf8bf54689f3f7f6b772e44e696', './lib/smarty_tiki/FunctionHandler/Toolbars.php', '28.4', 0),
('ad573c4becf8f91ad38ca4daa63b5765', './lib/smarty_tiki/FunctionHandler/TrackerFields.php', '28.4', 0),
('ac638ebcb697ff05b6109b6f9bdff6f6', './lib/smarty_tiki/FunctionHandler/TrackerHeader.php', '28.4', 0),
('a2fdf2fdfdd63f2d760456d31067ae1a', './lib/smarty_tiki/FunctionHandler/TrackerInput.php', '28.4', 0),
('c86fcdce446edf0fcb2c69491530861e', './lib/smarty_tiki/FunctionHandler/TrackerItemStatusIcon.php', '28.4', 0),
('32e83d40fd8b61d92fe19b64517698fe', './lib/smarty_tiki/FunctionHandler/TrackerOutput.php', '28.4', 0),
('76c47f52ff2432f84e81765d1e784cd8', './lib/smarty_tiki/FunctionHandler/TrackerRules.php', '28.4', 0),
('499e5dbd5f72ed759cfb55ebc8e50f00', './lib/smarty_tiki/FunctionHandler/TreeTable.php', '28.4', 0),
('0d9bc29140e7aa587b0eaca9f057a613', './lib/smarty_tiki/FunctionHandler/UserRegistration.php', '28.4', 0),
('2f704384acaf39f875c63e826355bf5a', './lib/smarty_tiki/FunctionHandler/UserSelector.php', '28.4', 0),
('320d97602befa5e24b879db934e16428', './lib/smarty_tiki/FunctionHandler/VarDump.php', '28.4', 0),
('66cab6630eb7ce99c060b5896b6a6a41', './lib/smarty_tiki/FunctionHandler/VimeoUploader.php', '28.4', 0),
('91f0bf7901b988025d21ebb89aa67554', './lib/smarty_tiki/FunctionHandler/WikiDiff.php', '28.4', 0),
('c5c75de4e90a116350e5ccde5b7aa0f5', './lib/smarty_tiki/FunctionHandler/WikiStructure.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/smarty_tiki/FunctionHandler/index.php', '28.4', 0),
('b83b9cec6e18dfa6071e186691d541cc', './lib/smarty_tiki/Modifier/Adjust.php', '28.4', 0),
('6eaae34de08d621a332f9c8f4820ae73', './lib/smarty_tiki/Modifier/AorAn.php', '28.4', 0),
('ce2c45f41101ab32ba745bf1214f2675', './lib/smarty_tiki/Modifier/Avatarize.php', '28.4', 0),
('7ac96afafbb1ccf4246affc686ae25c9', './lib/smarty_tiki/Modifier/Breakline.php', '28.4', 0),
('6827b5045e4ee442e86de14b1060a164', './lib/smarty_tiki/Modifier/CategId.php', '28.4', 0),
('480dbccdd2758d7db183a59017569c0b', './lib/smarty_tiki/Modifier/CompactIsoDate.php', '28.4', 0),
('9932524160e91832fd9cec7dc5f195a5', './lib/smarty_tiki/Modifier/CountryFlag.php', '28.4', 0),
('89b886221de60307fa42a2be7535abec', './lib/smarty_tiki/Modifier/D.php', '28.4', 0),
('a1920f2072ef5d479ba87a9166359a96', './lib/smarty_tiki/Modifier/Dbg.php', '28.4', 0),
('0a84c4a41750d4de2fed3bd30468b0b7', './lib/smarty_tiki/Modifier/DebugPrintTree.php', '28.4', 0),
('e68f3c20575956e49b27f98d7da6ceea', './lib/smarty_tiki/Modifier/Div.php', '28.4', 0),
('4b392e044bdad45c1c067af0884bd0fd', './lib/smarty_tiki/Modifier/Duration.php', '28.4', 0),
('793e74c00b7211baa3130e537823e2d5', './lib/smarty_tiki/Modifier/DurationShort.php', '28.4', 0),
('9f19cd1121f017e82a011d5ae252ca83', './lib/smarty_tiki/Modifier/Escape.php', '28.4', 0),
('03a8d4c7dcc4d59f9b798d9963a914a5', './lib/smarty_tiki/Modifier/FileCanConvertToPdf.php', '28.4', 0),
('e7d85d4ff829fccbc68aab7ba178928d', './lib/smarty_tiki/Modifier/FileDiagram.php', '28.4', 0),
('5da8e46a40d7501765ccb0ce3e418797', './lib/smarty_tiki/Modifier/ForumName.php', '28.4', 0),
('1ac458c3b2a6a4176b7a3c762a46d180', './lib/smarty_tiki/Modifier/ForumTopicCount.php', '28.4', 0),
('e5f5e27bbe6f59b173f9f5ff338fba61', './lib/smarty_tiki/Modifier/GroupMemberCount.php', '28.4', 0),
('27e46aac389bc933e4ceb7d34e8c8197', './lib/smarty_tiki/Modifier/HowManyUserInscriptions.php', '28.4', 0),
('b5db2b1d7e73431ad5ae35822b0fe9d6', './lib/smarty_tiki/Modifier/HtmlDecode.php', '28.4', 0),
('349bf177dd3ddbaa57ba3bd7a4ac098c', './lib/smarty_tiki/Modifier/Iconify.php', '28.4', 0),
('a507eab546452bb8b2a7abf6ebb04fc6', './lib/smarty_tiki/Modifier/InGroup.php', '28.4', 0),
('f0344f907946ffd67adf16fea4ee4e9b', './lib/smarty_tiki/Modifier/IsoDate.php', '28.4', 0),
('70047a7e7bee6aeb425bb457f4b9cf9b', './lib/smarty_tiki/Modifier/KbSize.php', '28.4', 0),
('8ae491035db5a01118b9d3415a7b5062', './lib/smarty_tiki/Modifier/LangName.php', '28.4', 0),
('0b58c93de2fb981948d125210d5b559d', './lib/smarty_tiki/Modifier/MaxUserInscriptions.php', '28.4', 0),
('d31ca4e05595dc9b35c415b4d82087a9', './lib/smarty_tiki/Modifier/MoneyFormat.php', '28.4', 0),
('55bf3d24315cd74c73e2c8df241fad16', './lib/smarty_tiki/Modifier/NamespaceModifier.php', '28.4', 0),
('bd43b641eb1f4f9da648359bc39023f1', './lib/smarty_tiki/Modifier/NoNamespace.php', '28.4', 0),
('a3b93d684d1861943809f3e19134afa4', './lib/smarty_tiki/Modifier/Nonp.php', '28.4', 0),
('5fef59bb70c297122b63f07618b86d2c', './lib/smarty_tiki/Modifier/NumStyle.php', '28.4', 0),
('7d965b3cdf0b0b36cd67859b06a03e25', './lib/smarty_tiki/Modifier/NumberFormat.php', '28.4', 0),
('6766748a148687a6985a1c4bb43e9ddf', './lib/smarty_tiki/Modifier/Output.php', '28.4', 0),
('294d9afb6d0274d86cf2d9fcdef28367', './lib/smarty_tiki/Modifier/PackageItemId.php', '28.4', 0),
('688444039a78312bfcdf04392b17c55b', './lib/smarty_tiki/Modifier/PageName.php', '28.4', 0),
('753f493fcd0d55a27c4ab96de404c8e0', './lib/smarty_tiki/Modifier/Parse.php', '28.4', 0),
('bce6c8974ea7193464f52bd94497ca5a', './lib/smarty_tiki/Modifier/Percent.php', '28.4', 0),
('5237c99986094d8ad59e16843e723332', './lib/smarty_tiki/Modifier/Quoted.php', '28.4', 0),
('43993d730b577e216accc432ee81dd1a', './lib/smarty_tiki/Modifier/Sefurl.php', '28.4', 0),
('2701d055ed97e6ce85012baf1f9031f7', './lib/smarty_tiki/Modifier/Slug.php', '28.4', 0),
('c4dc2a7923085d8f035873d52e6bc37a', './lib/smarty_tiki/Modifier/Star.php', '28.4', 0),
('662980e7bbeeaef6d61e729ced20a9b4', './lib/smarty_tiki/Modifier/StringFix.php', '28.4', 0),
('7af74ace21ab16da1de9a7cc4a1b120a', './lib/smarty_tiki/Modifier/TaskLink.php', '28.4', 0),
('ecf839e0e25ef4c81573119197b7f44e', './lib/smarty_tiki/Modifier/Template.php', '28.4', 0),
('b35a9f88712fb3e5dc1020e525455b71', './lib/smarty_tiki/Modifier/Ternary.php', '28.4', 0),
('899a612a19015e38b068530ed4df1544', './lib/smarty_tiki/Modifier/TikiDateFormat.php', '28.4', 0),
('ec55a5d6ea0fbd7f7521d1d6fec96570', './lib/smarty_tiki/Modifier/TikiDateTimezoneFromUnix.php', '28.4', 0),
('5281d397efb9c44d7e677d234404205d', './lib/smarty_tiki/Modifier/TikiLongDate.php', '28.4', 0),
('884fbbde1c024d8aab738d2e9ea8e762', './lib/smarty_tiki/Modifier/TikiLongDateTime.php', '28.4', 0),
('2b2543bbee7d6627ddb1490746fcd009', './lib/smarty_tiki/Modifier/TikiLongTime.php', '28.4', 0),
('5cd19e09cd04a5e3dec5660fc29d62ae', './lib/smarty_tiki/Modifier/TikiRemainingDaysFromNow.php', '28.4', 0),
('949aca09fb7a6f71a25b7c85e53ed0d6', './lib/smarty_tiki/Modifier/TikiShortDate.php', '28.4', 0),
('f43755ad7359885035286e2ca481c09c', './lib/smarty_tiki/Modifier/TikiShortDateTime.php', '28.4', 0),
('437c2a62f14313629cc96a2b6b1f098f', './lib/smarty_tiki/Modifier/TikiShortTime.php', '28.4', 0),
('23c19198e4c78408b883608d63a1e1a0', './lib/smarty_tiki/Modifier/Times.php', '28.4', 0),
('02110b1725f1849ff746f8de07f9a133', './lib/smarty_tiki/Modifier/TrIf.php', '28.4', 0),
('fd906e0f48416736fc10814938ba9bbb', './lib/smarty_tiki/Modifier/Tra.php', '28.4', 0),
('3c9e8f4d0a76c36938b077ae6320de3d', './lib/smarty_tiki/Modifier/Truex.php', '28.4', 0),
('596f3b171bc2101e950a076762cbe275', './lib/smarty_tiki/Modifier/Truncate.php', '28.4', 0),
('2c74b0944235590779fd6f0ccf025866', './lib/smarty_tiki/Modifier/UserLink.php', '28.4', 0),
('ca30082041bc59bc247332b75b3d947a', './lib/smarty_tiki/Modifier/Username.php', '28.4', 0),
('1e63a4d0e593ab91f1fbcec25f8beaaf', './lib/smarty_tiki/Modifier/Utf8Unicode.php', '28.4', 0),
('33f15129c82cd34f6866320e1380f505', './lib/smarty_tiki/Modifier/VirtualPath.php', '28.4', 0),
('beb06346753ca3de07ff641168d71622', './lib/smarty_tiki/Modifier/YesNo.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/smarty_tiki/Modifier/index.php', '28.4', 0),
('bf8e0a4d718b6cfad580a843c0eb18f2', './lib/smarty_tiki/block.accordion.php', '28.4', 0),
('4ff326eb08ae1d1e0675a946f32025a1', './lib/smarty_tiki/block.accordion_group.php', '28.4', 0),
('49e6271569217a677d0a781a10c77cff', './lib/smarty_tiki/block.actions.php', '28.4', 0),
('52b61a73beb964620afbd454444c8410', './lib/smarty_tiki/block.activityframe.php', '28.4', 0),
('52d25fe52b2b2df7b1013dadffd4137c', './lib/smarty_tiki/block.ajax_href.php', '28.4', 0),
('d3d387fd36bebed5d0bf2f84c8cc4a50', './lib/smarty_tiki/block.compact.php', '28.4', 0),
('8be6f26492fb3fbb69b38bc047f58d2e', './lib/smarty_tiki/block.display.php', '28.4', 0),
('ea7cddbccc2748a7dbb2191354c90930', './lib/smarty_tiki/block.filter.php', '28.4', 0),
('0c9dec7a03396f6433561865352fdd28', './lib/smarty_tiki/block.ifsearchexists.php', '28.4', 0),
('a49e2f78a85ec108b032aa1ff386ff6e', './lib/smarty_tiki/block.ifsearchnotexists.php', '28.4', 0),
('75a38a9fa4274d7ff69f7cd494e357a1', './lib/smarty_tiki/block.itemfield.php', '28.4', 0),
('80143f488fdef377ad3372a19d5bfa88', './lib/smarty_tiki/block.jq.php', '28.4', 0),
('54c27bd1cf52adea2ac05b9538c698b8', './lib/smarty_tiki/block.mailurl.php', '28.4', 0),
('aa3587bae59b8694375d6fde7c9418f2', './lib/smarty_tiki/block.modules_list.php', '28.4', 0),
('37fc4f86a81786516951adc984da704d', './lib/smarty_tiki/block.packageplugin.php', '28.4', 0),
('1c4fb220793186ace78795063c27f1dd', './lib/smarty_tiki/block.pagination_links.php', '28.4', 0),
('ac2dc24fa188200279714ba8dd8d847e', './lib/smarty_tiki/block.permission.php', '28.4', 0),
('95058f827cf5095d2ccf6a87d9df0551', './lib/smarty_tiki/block.popup_link.php', '28.4', 0),
('bfda3ad21f652b31d58f6ea471c26c28', './lib/smarty_tiki/block.remarksbox.php', '28.4', 0),
('2050470c6cf65a2eaf4f4d1e512eccce', './lib/smarty_tiki/block.repeat.php', '28.4', 0),
('d0cf8dda1d14ab6877b70bef0a5d69ec', './lib/smarty_tiki/block.self_link.php', '28.4', 0),
('15f659c87fd88dcd61d4a979e6bedb97', './lib/smarty_tiki/block.sortlinks.php', '28.4', 0),
('81459716680b76aee25ade59414253dd', './lib/smarty_tiki/block.tab.php', '28.4', 0),
('a9333e4933e2eed3089fa88f927d6678', './lib/smarty_tiki/block.tabset.php', '28.4', 0),
('1366ad43b85460fe1627b6a1a82194e9', './lib/smarty_tiki/block.textarea.php', '28.4', 0),
('45372910fae8f2583888184c5dbedbd9', './lib/smarty_tiki/block.tikimodule.php', '28.4', 0),
('51f8cb010b1bc413230fed45aba49e09', './lib/smarty_tiki/block.title.php', '28.4', 0),
('de629833cc739510e834758883554b6b', './lib/smarty_tiki/block.tr.php', '28.4', 0),
('c8219f3803dc7decf9db850c01d8e9ea', './lib/smarty_tiki/block.trackeritemcheck.php', '28.4', 0),
('fb5f2a37d17cc170d3e20b9896c17a5c', './lib/smarty_tiki/block.translation.php', '28.4', 0),
('dd3e70ca0925c42a974008dcd59547c7', './lib/smarty_tiki/block.vue.php', '28.4', 0),
('feed17c18af0827578a085df5a16bc58', './lib/smarty_tiki/block.wiki.php', '28.4', 0),
('97f6e270109f4e2e3dc54ec86de753c2', './lib/smarty_tiki/block.wikiplugin.php', '28.4', 0),
('0e3647df04e279b023af26f78665fa99', './lib/smarty_tiki/compiler.assign_content.php', '28.4', 0),
('595a35b31a50cb14622967624f4180a8', './lib/smarty_tiki/function.activity.php', '28.4', 0),
('0176de978ffaf768e0321afb6c5d34fa', './lib/smarty_tiki/function.article.php', '28.4', 0),
('1aa06172526ca4f02494d37350123e9b', './lib/smarty_tiki/function.attachments.php', '28.4', 0),
('7d1f581607d984f692bd2db5da06785d', './lib/smarty_tiki/function.autocomplete.php', '28.4', 0),
('6c89a2a3571ed99956bda4ff415a8bab', './lib/smarty_tiki/function.banner.php', '28.4', 0),
('5a8c441629d3736c6e18c8820b89358a', './lib/smarty_tiki/function.bootstrap_modal.php', '28.4', 0),
('12092915160f2c6b57733abc93d76d07', './lib/smarty_tiki/function.breadcrumbs.php', '28.4', 0),
('c2f8736b8e23a16851d9c5f237dda9d5', './lib/smarty_tiki/function.button.php', '28.4', 0),
('d015c466ad3d5a986dc66b44e07cdf79', './lib/smarty_tiki/function.categoryName.php', '28.4', 0),
('cc714ce34f993f19e5311b20a5ee2937', './lib/smarty_tiki/function.categoryselector.php', '28.4', 0),
('ff8aa1ffc32ba3a2b97604921045952c', './lib/smarty_tiki/function.content.php', '28.4', 0),
('6f4ae0f3360db281bdf5c7211b79d9da', './lib/smarty_tiki/function.cookie.php', '28.4', 0),
('e7bea8e7154fb70eed47a7f4fd529b7d', './lib/smarty_tiki/function.cookie_jar.php', '28.4', 0),
('d5182a039c3493e294297891a5606da2', './lib/smarty_tiki/function.count.php', '28.4', 0),
('a64fdd66fb7bf7979966e74dd9ea4064', './lib/smarty_tiki/function.currency.php', '28.4', 0),
('353c245e5fc19c530394a159a4593a50', './lib/smarty_tiki/function.custom_template.php', '28.4', 0),
('05f1f01af9fa8897f54eca7a4159f2a2', './lib/smarty_tiki/function.datetime_range.php', '28.4', 0),
('8728e0d6c1993665401223b1f5502058', './lib/smarty_tiki/function.debugger.php', '28.4', 0),
('fa53d7b94c16815b67bac71b6eb0d9e6', './lib/smarty_tiki/function.defaultmapcenter.php', '28.4', 0),
('25bf9df15d66be5abc1ba1b2ee1249f3', './lib/smarty_tiki/function.ed.php', '28.4', 0),
('64844e406cbc99a7bd72c2049c470b5c', './lib/smarty_tiki/function.elapsed.php', '28.4', 0),
('2038531155fedcf78a88d7a9c26c4206', './lib/smarty_tiki/function.favorite.php', '28.4', 0),
('4c3fdb3156958a8fca512514087122b9', './lib/smarty_tiki/function.feedback.php', '28.4', 0),
('99612e42fe7b9354850ace5ef97eb012', './lib/smarty_tiki/function.fgal_browse.php', '28.4', 0),
('272a503979ed4c9c32ffffd06796181b', './lib/smarty_tiki/function.file_selector.php', '28.4', 0),
('944bb525ab74c1ac20b13f7139b431e5', './lib/smarty_tiki/function.filegal_manager_url.php', '28.4', 0),
('061b55c021570b083c63846096862852', './lib/smarty_tiki/function.filegal_uploader.php', '28.4', 0),
('4a74c75839a4c40eacd06f4a19fe2b63', './lib/smarty_tiki/function.fileinfo.php', '28.4', 0),
('25c97a6cb4d9313ca8fa6d7a4319a4ec', './lib/smarty_tiki/function.formitem.php', '28.4', 0),
('8e2dc59374f42358b255c86b06c0d64a', './lib/smarty_tiki/function.help.php', '28.4', 0),
('72a5640d90cc908d2674bae9d98256b0', './lib/smarty_tiki/function.html_body_attributes.php', '28.4', 0),
('2014975ad6f3fe5daa112f5290b7f95a', './lib/smarty_tiki/function.html_image.php', '28.4', 0),
('6d1decc4b25228dfeb519f4726c588a3', './lib/smarty_tiki/function.html_options.php', '28.4', 0),
('0b8dd4c9092744a9a39e11555d2b7885', './lib/smarty_tiki/function.html_select_date.php', '28.4', 0),
('bdd511b40df2352ec63644e2ef19b97e', './lib/smarty_tiki/function.html_select_duration.php', '28.4', 0),
('6451ba323b76692061b233d5bab830e2', './lib/smarty_tiki/function.html_select_time.php', '28.4', 0),
('70207ff3de24c24044b9a3aac218b209', './lib/smarty_tiki/function.icon.php', '28.4', 0),
('d313d8e40f1f1ce7afef7fc516e688ae', './lib/smarty_tiki/function.initials_filter_links.php', '28.4', 0),
('2d4fd94e1b76cda2f04cb8dfb5b5b7ec', './lib/smarty_tiki/function.interactivetranslation.php', '28.4', 0),
('0a7b21279bce96b0ae646f37eaa64562', './lib/smarty_tiki/function.js_insert_icon.php', '28.4', 0),
('b3a95e3a2b0463872aaea602c3584d03', './lib/smarty_tiki/function.js_maxlength.php', '28.4', 0),
('3673c4150022d1b0d108ff3040b6382b', './lib/smarty_tiki/function.jscalendar.php', '28.4', 0),
('359036874f4d67cbcff0062c2f662df2', './lib/smarty_tiki/function.jspopup.php', '28.4', 0),
('66ef52135d8cebfcc8a2482e746d816f', './lib/smarty_tiki/function.jstransfer_list.php', '28.4', 0),
('8ee6d1867c456d94d660a833959753ad', './lib/smarty_tiki/function.like.php', '28.4', 0),
('89c9b64feadff413ca8f00f93578df2d', './lib/smarty_tiki/function.listfilter.php', '28.4', 0),
('1665819f3ec735622ca28d0feaa1445a', './lib/smarty_tiki/function.lock.php', '28.4', 0),
('da8064f1ed744dfb010ceef1b06915b3', './lib/smarty_tiki/function.memusage.php', '28.4', 0),
('1d6de649fe7c5de25ba9dbc374a94cb4', './lib/smarty_tiki/function.menu.php', '28.4', 0),
('216a467171fa32eb774e3ce5100d5488', './lib/smarty_tiki/function.module.php', '28.4', 0),
('3aa8623dd9c34abb11bfa0850e091622', './lib/smarty_tiki/function.modulelist.php', '28.4', 0),
('1060b7b65239a11ec08337ad2d2464f7', './lib/smarty_tiki/function.monitor_link.php', '28.4', 0),
('40af54185e1f1f0ba4d2ac2f9c6d1ebc', './lib/smarty_tiki/function.multilike.php', '28.4', 0),
('645b88dea44b6b747b8fca466241c9e6', './lib/smarty_tiki/function.norecords.php', '28.4', 0),
('67497866872e55be133891719ba2b53e', './lib/smarty_tiki/function.notification_link.php', '28.4', 0),
('34ee377b8d60630c3ecc8ac1bdab6bce', './lib/smarty_tiki/function.obj_in_cat.php', '28.4', 0),
('abdbb1c04107457438cb2a98de409782', './lib/smarty_tiki/function.object_link.php', '28.4', 0),
('7c784dd2a680c0ffc4ed11d6f5183719', './lib/smarty_tiki/function.object_score.php', '28.4', 0),
('b132b7d83a45cd7ec8edccc88ef377a6', './lib/smarty_tiki/function.object_selector.php', '28.4', 0),
('719dd70ea0e81c503c0fcba04315b532', './lib/smarty_tiki/function.object_selector_multi.php', '28.4', 0),
('037f3ada70d8d3c314bdd8abf3b8862f', './lib/smarty_tiki/function.object_title.php', '28.4', 0),
('94d463260f73eba4a95161f5c06cc2b7', './lib/smarty_tiki/function.object_type.php', '28.4', 0),
('bb3a26c0481e36f2f681bad0c1310f8d', './lib/smarty_tiki/function.page_alias.php', '28.4', 0),
('49976fb90c406e6b1478cc70fb241565', './lib/smarty_tiki/function.page_in_structure.php', '28.4', 0),
('8b2c9ee06d81a97882e2261322b9ab4d', './lib/smarty_tiki/function.payment.php', '28.4', 0),
('1e08dfdde573e0e48d06e341316ea33e', './lib/smarty_tiki/function.permission_link.php', '28.4', 0),
('9b4d0b684f3d92c29c514fdbcaaa1851', './lib/smarty_tiki/function.pluralize.php', '28.4', 0),
('5a866943bc105be3e3755159c64bcbb9', './lib/smarty_tiki/function.poll.php', '28.4', 0),
('733d6126134f41fec3d0016f5aa79481', './lib/smarty_tiki/function.popup.php', '28.4', 0),
('e8c1e52ca54aa94336cefd2c657a7568', './lib/smarty_tiki/function.preference.php', '28.4', 0),
('2322ee10c9526cc9991ac29d4d2b669b', './lib/smarty_tiki/function.profilesymbolvalue.php', '28.4', 0),
('dc814e7f8dce6763543db063344826d7', './lib/smarty_tiki/function.query.php', '28.4', 0),
('57ba6aa7a2a2e9ed39ecab494ec005e2', './lib/smarty_tiki/function.quotabar.php', '28.4', 0),
('3b782188d857c94b90ec7d498af9fc8b', './lib/smarty_tiki/function.rating.php', '28.4', 0),
('69ed2e65ac0396c7ce26ba598a304f9b', './lib/smarty_tiki/function.rating_choice.php', '28.4', 0),
('8e023292efce833f62dd057f014e4121', './lib/smarty_tiki/function.rating_override_menu.php', '28.4', 0),
('78b1c7ff79b071999fae5e18c404ec1c', './lib/smarty_tiki/function.rating_result.php', '28.4', 0),
('d0a134cac62fb1c367c47c8411dd1e6c', './lib/smarty_tiki/function.rating_result_avg.php', '28.4', 0),
('10c008a463e49f146f7ef696cd0b5325', './lib/smarty_tiki/function.rcontent.php', '28.4', 0),
('6ec6445076374b554778ca9c56207f6f', './lib/smarty_tiki/function.redirect.php', '28.4', 0),
('45cd4a51f4283cc6e41b0b6d5039d0bf', './lib/smarty_tiki/function.reindex_file_pixel.php', '28.4', 0),
('4d1ae1f2180062368790511dd4ccd9a3', './lib/smarty_tiki/function.router_params.php', '28.4', 0),
('44faaaec295cdec4ee6abff3a11da12f', './lib/smarty_tiki/function.rss.php', '28.4', 0),
('b02823d192757865af8d874795c84f59', './lib/smarty_tiki/function.sameurl.php', '28.4', 0),
('39a3638a9a6ca57fc6041388a495ad93', './lib/smarty_tiki/function.scheduler_params.php', '28.4', 0),
('5151f3cf83794f4cafd0b14f576af2ee', './lib/smarty_tiki/function.sefurl.php', '28.4', 0),
('086da4cb7064e3830d638d015d7b5db5', './lib/smarty_tiki/function.select_all.php', '28.4', 0),
('e92dbef237956b78ce987886eb751c3b', './lib/smarty_tiki/function.service.php', '28.4', 0),
('0357c89aae24871858b4114cb794bfc2', './lib/smarty_tiki/function.service_inline.php', '28.4', 0),
('7432ee99582640df1b65b9288723a40f', './lib/smarty_tiki/function.set.php', '28.4', 0),
('7c3d8c0d0005b941272ac621cdddbb04', './lib/smarty_tiki/function.show_sort.php', '28.4', 0),
('ae55e262883f10ff18af9d8c6a889a3e', './lib/smarty_tiki/function.svn_lastup.php', '28.4', 0),
('ccf22db26714a142364722b41ef00843', './lib/smarty_tiki/function.svn_rev.php', '28.4', 0),
('9a0f3d06df7bcfd872c45395cd372e57', './lib/smarty_tiki/function.syntax.php', '28.4', 0),
('a8bed9ff3fcc2e8ab69fc6b65c6572c1', './lib/smarty_tiki/function.thumb.php', '28.4', 0),
('7b5105fc4c0ebc9d6c078ecb20e766a5', './lib/smarty_tiki/function.ticket.php', '28.4', 0),
('c0ff2424a23f086ed3dbd7523adfaa47', './lib/smarty_tiki/function.toolbars.php', '28.4', 0),
('4d66e99f8481f770d6ccf69e58047037', './lib/smarty_tiki/function.tracker_item_status_icon.php', '28.4', 0),
('bd2587c78975a9c319287940ef8d9b72', './lib/smarty_tiki/function.trackerfields.php', '28.4', 0),
('cd068d41ee0080c4eda9c205fc94aea4', './lib/smarty_tiki/function.trackerheader.php', '28.4', 0),
('1758a9b5f2feefe165ea5305e1b00178', './lib/smarty_tiki/function.trackerinput.php', '28.4', 0),
('4e6410c16bb0e44a90ec582d02972c98', './lib/smarty_tiki/function.trackeroutput.php', '28.4', 0),
('00f50d7f8b4a46732923d270af6f574a', './lib/smarty_tiki/function.trackerrules.php', '28.4', 0),
('e25bf389fbd2655c45301a59d646f2ca', './lib/smarty_tiki/function.treetable.php', '28.4', 0),
('02610a5a75140e21527688ffb0ea7009', './lib/smarty_tiki/function.user_registration.php', '28.4', 0),
('91a5a6deff35835fd7574c90098c584a', './lib/smarty_tiki/function.user_selector.php', '28.4', 0),
('ce1b592980ce5edba478122f012d1ec1', './lib/smarty_tiki/function.var_dump.php', '28.4', 0),
('382f56da2b3c9e021b08194c98d25e27', './lib/smarty_tiki/function.vimeo_uploader.php', '28.4', 0),
('bff4249fbe900b106d1463a1a683d036', './lib/smarty_tiki/function.wikidiff.php', '28.4', 0),
('ce70b158ebd8ba31b66c942f37b2ff06', './lib/smarty_tiki/function.wikistructure.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/smarty_tiki/index.php', '28.4', 0),
('1b7231a2cf8fdf4beeb00e51cfc083aa', './lib/smarty_tiki/modifier.a_or_an.php', '28.4', 0),
('34a070da5f8743c6f864c49fde5094ff', './lib/smarty_tiki/modifier.adjust.php', '28.4', 0),
('1e7decf547ef634d40bc2359b58e77e3', './lib/smarty_tiki/modifier.avatarize.php', '28.4', 0),
('9cd68fdd5aaa498373c869854f9f497b', './lib/smarty_tiki/modifier.breakline.php', '28.4', 0),
('e542e6a0a9dd7bbf491875bc536e3561', './lib/smarty_tiki/modifier.categid.php', '28.4', 0),
('f4e8f21ab03e052f536f67abb940fedf', './lib/smarty_tiki/modifier.compactisodate.php', '28.4', 0),
('ce7368fb5017fc25274fbaa4314cdfb4', './lib/smarty_tiki/modifier.countryflag.php', '28.4', 0),
('8a971797ef64823668cc4eb69c657fcc', './lib/smarty_tiki/modifier.d.php', '28.4', 0),
('1c3caa6c49f9831c7af5493a227c9ae4', './lib/smarty_tiki/modifier.dbg.php', '28.4', 0),
('613218e1bb0e60b958ea8c183fc6244f', './lib/smarty_tiki/modifier.div.php', '28.4', 0),
('3630ac725d9770540a7357a53bbb9fba', './lib/smarty_tiki/modifier.duration.php', '28.4', 0),
('91980f66bed5bcd072804e82fc4603ad', './lib/smarty_tiki/modifier.duration_short.php', '28.4', 0),
('371d28b978e9b5e6feb7ac6f1fa4e2ea', './lib/smarty_tiki/modifier.escape.php', '28.4', 0),
('bfd9f50b906e205fc251e5415e3a31cf', './lib/smarty_tiki/modifier.file_can_convert_to_pdf.php', '28.4', 0),
('ac5a9b8a5f52d30cd32aedcce3248fa0', './lib/smarty_tiki/modifier.file_diagram.php', '28.4', 0),
('40f0ca8a0ab9acd197b7a7bbc269a19a', './lib/smarty_tiki/modifier.forumname.php', '28.4', 0),
('4d419bb056cc52d17ce285e94598798f', './lib/smarty_tiki/modifier.forumtopiccount.php', '28.4', 0),
('c1f4610eea58cf4772f2fe03a4fd8c34', './lib/smarty_tiki/modifier.groupmembercount.php', '28.4', 0),
('46521635965f3c9fae18f36f0819aed8', './lib/smarty_tiki/modifier.how_many_user_inscriptions.php', '28.4', 0),
('ea9d26827d0227eeb8cffe980e0fb60f', './lib/smarty_tiki/modifier.htmldecode.php', '28.4', 0),
('10a78045735fe6b7ba3d7a81879881b1', './lib/smarty_tiki/modifier.iconify.php', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('35d53e93b5ffb44a6b92697a924e7d53', './lib/smarty_tiki/modifier.in_group.php', '28.4', 0),
('625b327298061ca8ccabc424efc68d15', './lib/smarty_tiki/modifier.isodate.php', '28.4', 0),
('52c4d39c5c17e806f22acd129ae29d04', './lib/smarty_tiki/modifier.kbsize.php', '28.4', 0),
('9ac71f6bae425f4680267b52f1b8ce83', './lib/smarty_tiki/modifier.langname.php', '28.4', 0),
('16ccdc4c8f1e92bb079667cdc1f66a8c', './lib/smarty_tiki/modifier.lcfirst.php', '28.4', 0),
('ec416ecbbca3d1b559a37a120232139b', './lib/smarty_tiki/modifier.max_user_inscriptions.php', '28.4', 0),
('a79e15bf90b54a7c28d6f54a243ae827', './lib/smarty_tiki/modifier.money_format.php', '28.4', 0),
('2196973f233bc3b3c42e64fdf8d3a74b', './lib/smarty_tiki/modifier.namespace.php', '28.4', 0),
('71ec2460062fd8e00f85a879df072b7b', './lib/smarty_tiki/modifier.nonamespace.php', '28.4', 0),
('d22ae6d055cc8fdfc1ba6994871924c7', './lib/smarty_tiki/modifier.nonp.php', '28.4', 0),
('5d6fa4d919b7aa29be48b4bfcae7b883', './lib/smarty_tiki/modifier.number_format.php', '28.4', 0),
('dbaafb0e066c1c0ce742452ef9ecd044', './lib/smarty_tiki/modifier.numstyle.php', '28.4', 0),
('a01210f788c786a36e4660381e840f59', './lib/smarty_tiki/modifier.output.php', '28.4', 0),
('91f7a9ca68b2a23e6bea095c75cc537e', './lib/smarty_tiki/modifier.packageitemid.php', '28.4', 0),
('68cb6c6281cd60abbc489a979c4971ec', './lib/smarty_tiki/modifier.pagename.php', '28.4', 0),
('9dadfc6dd67624b8cfabf3501027dd41', './lib/smarty_tiki/modifier.parse.php', '28.4', 0),
('33179b5f3790a53c24f61e60f7164348', './lib/smarty_tiki/modifier.percent.php', '28.4', 0),
('fc77334b10df12f9929319b9921f9b29', './lib/smarty_tiki/modifier.quoted.php', '28.4', 0),
('a98475b6aacd7e9b5f1fd26dea99a6d7', './lib/smarty_tiki/modifier.replacei.php', '28.4', 0),
('c80ed492708ef91dc6442308e41fd881', './lib/smarty_tiki/modifier.reverse_array.php', '28.4', 0),
('6239b0226ba04c1cc99794f3e8f3009c', './lib/smarty_tiki/modifier.sefurl.php', '28.4', 0),
('8509a976f3f22e2365fb92d6f1ba6013', './lib/smarty_tiki/modifier.slug.php', '28.4', 0),
('5190bd201de533a37a6b8274fdfdf81f', './lib/smarty_tiki/modifier.star.php', '28.4', 0),
('1f0aeb3ae7c73b3e45be4371bb353b1d', './lib/smarty_tiki/modifier.stringfix.php', '28.4', 0),
('2f13568af0e3a631f42c419c90a0cb7f', './lib/smarty_tiki/modifier.strtotime.php', '28.4', 0),
('d92c32d9cd9f672bf42c489daa9bd59e', './lib/smarty_tiki/modifier.substring.php', '28.4', 0),
('0950ad03465aa090110af81e10438270', './lib/smarty_tiki/modifier.tasklink.php', '28.4', 0),
('396c281888c90bda48a0bc8fe53dc426', './lib/smarty_tiki/modifier.template.php', '28.4', 0),
('ec4888ac0d339c7b1fd22123e1bf1ccf', './lib/smarty_tiki/modifier.tiki_date_format.php', '28.4', 0),
('f891d0eb80c5b532108985f7b6f4ec1b', './lib/smarty_tiki/modifier.tiki_date_timezone_from_unix.php', '28.4', 0),
('5c9938a4b633bc4dd01551d3ffe1ff02', './lib/smarty_tiki/modifier.tiki_long_date.php', '28.4', 0),
('f21b7d83d0e4f247f709c024dbec2ab4', './lib/smarty_tiki/modifier.tiki_long_datetime.php', '28.4', 0),
('cd96d7b52a55f7ab84904eb20ed32443', './lib/smarty_tiki/modifier.tiki_long_time.php', '28.4', 0),
('54d9543c564f26af35d89e278fab6149', './lib/smarty_tiki/modifier.tiki_remaining_days_from_now.php', '28.4', 0),
('53479ea838cf512d6e758e20ee506d08', './lib/smarty_tiki/modifier.tiki_short_date.php', '28.4', 0),
('81f166a987f07befea7891d0c94536b9', './lib/smarty_tiki/modifier.tiki_short_datetime.php', '28.4', 0),
('cf49bb595c6b85b73240e7ad6b253d95', './lib/smarty_tiki/modifier.tiki_short_time.php', '28.4', 0),
('7db706cbff8186a8e783914ffbd9092b', './lib/smarty_tiki/modifier.times.php', '28.4', 0),
('3c4924154507bb97e30ef07e9da2a770', './lib/smarty_tiki/modifier.tr_if.php', '28.4', 0),
('a271065362771201595c2070265a0e03', './lib/smarty_tiki/modifier.trim.php', '28.4', 0),
('89b2f94ccbc5ddf5061568acd122fa7f', './lib/smarty_tiki/modifier.truex.php', '28.4', 0),
('840f5c4ca5ea6121a78253c4aa3cf905', './lib/smarty_tiki/modifier.truncate.php', '28.4', 0),
('c40ef9f18368cfd125955fad11355767', './lib/smarty_tiki/modifier.userlink.php', '28.4', 0),
('47f8ce2c86dbaeb1dc444dbae11b31c3', './lib/smarty_tiki/modifier.username.php', '28.4', 0),
('9d5d4b2a5c05369eadd9bbbdeaf3e151', './lib/smarty_tiki/modifier.utf8unicode.php', '28.4', 0),
('9066ceb35691f18a9c83f96605a2ebda', './lib/smarty_tiki/modifier.virtual_path.php', '28.4', 0),
('7e085781f5b63c945e52582e44e81d79', './lib/smarty_tiki/modifier.yesno.php', '28.4', 0),
('5484cfc4131f1b03858fffc3f60a2bf3', './lib/smarty_tiki/modifier.zone_is_empty.php', '28.4', 0),
('74ff52f95cddb05646dafcd7b86edd88', './lib/smarty_tiki/outputfilter.highlight.php', '28.4', 0),
('75c587a5afbd1d551514cc1d9829a2cd', './lib/smarty_tiki/prefilter.jq.php', '28.4', 0),
('560823fdc9f951e46269a89156579bc5', './lib/smarty_tiki/prefilter.log_tpl.php', '28.4', 0),
('89e68420c3438f2680be28ddde8b8355', './lib/smarty_tiki/prefilter.tr.php', '28.4', 0),
('ca92302b945a665bb0bcfc4613d890fd', './lib/smarty_tiki/resource.tplwiki.php', '28.4', 0),
('f48ad0841603ec76ec433b08e2c2cbc0', './lib/smarty_tiki/resource.wiki.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/soap/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/soap/nusoap/index.php', '28.4', 0),
('727cd7ec810b919cd6f5015b60656ee9', './lib/soap/nusoap/nusoap.php', '28.4', 0),
('8bbdfb359ceae1133ece4ba3c5efdd54', './lib/soap/soaplib.php', '28.4', 0),
('6098cdd0436687d4018cc42470a14339', './lib/soap/tiki-admin_webservices.js', '28.4', 0),
('cf4a6a1b10cfaf76853eb9ce6da098de', './lib/soap/wsdllib.php', '28.4', 0),
('adee6725a6a69232d9644db5c6a6c8d4', './lib/socialnetworkslib.php', '28.4', 0),
('ccbcb0e6a2160aff787a539fc421ff93', './lib/socnets/LLOG.php', '28.4', 0),
('4736e6d3c99f9d0f6172fb7adddd1b26', './lib/socnets/PrefsGen.php', '28.4', 0),
('2bac152eebecca1b632364401b5996a2', './lib/socnets/TikiHybrid.php', '28.4', 0),
('a08d70b5428aafc5d202963c530ecb26', './lib/socnets/Util.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/socnets/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/stats/index.php', '28.4', 0),
('f353e8e228d326cd19c5fc336e834a8c', './lib/stats/statslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/structures/index.php', '28.4', 0),
('6f85e4cc4f667d3871d9af1dccade369', './lib/structures/structlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/surveys/index.php', '28.4', 0),
('7c517ea78e121819c91042410ce3894c', './lib/surveys/surveylib.php', '28.4', 0),
('c9794e6ecba6e2a2d24ea97dfee30e3f', './lib/surveys/tiki-admin_survey_questions.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/swfobject/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/swfobject/src/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/taglines/index.php', '28.4', 0),
('c886d76f5e7b50d9a1c81022485691f4', './lib/taglines/taglinelib.php', '28.4', 0),
('7ce612ef8170e0221937cb95437fcfa0', './lib/tar.class.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/tasks/index.php', '28.4', 0),
('9b33d0c92588d3cb16b090052d749704', './lib/tasks/tasklib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/templates/index.php', '28.4', 0),
('bfe21caee5af4c93671b23962e61e4b5', './lib/templates/templateslib.php', '28.4', 0),
('331b5882d000c1f3bd72cccfe66be66c', './lib/test/AcceptanceTests/AllTests.php', '28.4', 0),
('2d53cc6a7195206a90d301b0d86bdc60', './lib/test/AcceptanceTests/CollaborativeMultilingualTerminologyTest.php', '28.4', 0),
('7db52e94ff4916165e98dbb7acb75d54', './lib/test/AcceptanceTests/ListPagesTest.php', '28.4', 0),
('06c01fb087ba8474b389146ef88c1269', './lib/test/AcceptanceTests/MultilingualTest.php', '28.4', 0),
('a0251341c5756fea72ae629915da7dbd', './lib/test/AcceptanceTests/MultilinguallibTest.php', '28.4', 0),
('9e8684cabe5bbc978cb901cb38295966', './lib/test/AcceptanceTests/SearchTest.php', '28.4', 0),
('199750050d9c0b4b82cbabe9870cc2b9', './lib/test/AcceptanceTests/TikiLibrariesAccessTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/AcceptanceTests/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/AcceptanceTests/utils/index.php', '28.4', 0),
('b0bc9562b81a841fdca5437dcd2592ad', './lib/test/AcceptanceTests/utils/upgrade_test_database_dump_file.php', '28.4', 0),
('562661f16a1e81ad79c9a4a56c72bef7', './lib/test/AllTestsAcceptance.php', '28.4', 0),
('a7b27492f7e9e4bdfbd89eb064f88ee3', './lib/test/Calendar/CalRecurrenceTest.php', '28.4', 0),
('654df9fb77c3b9b4d31141192ebf458e', './lib/test/Calendar/DateTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/Calendar/index.php', '28.4', 0),
('631f8bc0ca282adcd73ef144f9680f0c', './lib/test/ContinuousIntegationTesting.php', '28.4', 0),
('8d6de20dccac99536793818b8f723f39', './lib/test/FileChecks/allTikiPhpFilesTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/FileChecks/index.php', '28.4', 0),
('adfc1a8cf02a3f4e9e4dbe8b87c59358', './lib/test/IntegrationTests/MLModelTest.php', '28.4', 0),
('640f89770ce13e93f964916f5de506f1', './lib/test/IntegrationTests/TrackerDatesTimezoneTest.php', '28.4', 0),
('a9948a815b7f1c36e9b573f7ecc89783', './lib/test/IntegrationTests/TrackerItemPermissionTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/IntegrationTests/index.php', '28.4', 0),
('335542660ee402d0eea62d4e920d41a7', './lib/test/MultilingualLibTest.php', '28.4', 0),
('bac81c97b12daeffbec238e7dd7d7da0', './lib/test/TestHelpers.php', '28.4', 0),
('6f914bb54631190b3e8a1845a7834dca', './lib/test/TestHelpers/GlobRecursiveHelper.php', '28.4', 0),
('25037b22ee750b129da98f03ffb15b51', './lib/test/TestHelpers/TikiDbHelper.php', '28.4', 0),
('527f0b30b2f3cfb4e95c9b90d2811394', './lib/test/TestHelpers/TikiProfileHelper.php', '28.4', 0),
('317720535fda984d4a2f169e569bbf0c', './lib/test/TestHelpers/WebClientHelper.php', '28.4', 0),
('1a41898f0356ae441872496d6c1f8cf8', './lib/test/TestHelpers/cli/create_dump_db_file.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/TestHelpers/cli/index.php', '28.4', 0),
('d8305023f133e5e69b03c52aea6d5fd1', './lib/test/TestHelpers/cli/restore_db_dump.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/TestHelpers/index.php', '28.4', 0),
('912330a7fdab3c1a0e0041a10569628e', './lib/test/TestRunnerWithBaseline.php', '28.4', 0),
('f84fc3f5da0fcbc00eb5c71bea2d5106', './lib/test/TestRunnerWithBaselineTest.php', '28.4', 0),
('af61ee57aab3c4b9fdad6a4e78a0c261', './lib/test/TestableTikiLib.php', '28.4', 0),
('73925f0b4b6eb7229c61dc4d14f54835', './lib/test/TikiAcceptanceTestDBRestorer.php', '28.4', 0),
('8d19fb1371c110751482857a7fad35a0', './lib/test/TikiDatabaseTestCase.php', '28.4', 0),
('a2e0898711298a7be66409a581fd6be3', './lib/test/TikiLib/LibTest.php', '28.4', 0),
('80d881b4aae3adec8bd49a7325af84b4', './lib/test/TikiLib/MarkdownParserTest.php', '28.4', 0),
('13d61432f93cc73554991b2f09a0e9fc', './lib/test/TikiLib/MultiExplodeTest.php', '28.4', 0),
('f6f43637ed4812ec71f5f3cca7c381b7', './lib/test/TikiLib/TestableTikiLibTest.php', '28.4', 0),
('75c2a215bbaf497934c8ed3a11430850', './lib/test/TikiLib/TikiLibTest.php', '28.4', 0),
('9bcbd59cbb132565abf93514d4a97d1d', './lib/test/TikiLib/UriMergeTest.php', '28.4', 0),
('3a9940949a4648886e7264ab1098490a', './lib/test/TikiLib/UrlEncodeAccentTest.php', '28.4', 0),
('71df3dbd195253ddce1ca07a26218819', './lib/test/TikiLib/UserLibTest.php', '28.4', 0),
('014eaad37fe81130f1e8420aae2ac328', './lib/test/TikiLib/UserWatchesTest.php', '28.4', 0),
('56d4ea418f3bb0676c2d4e7d09c2d6e7', './lib/test/TikiLib/WikiParserTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/TikiLib/index.php', '28.4', 0),
('59d4daa592ad3ece829ed69e60b9d8c7', './lib/test/TikiSeleniumTestCase.php', '28.4', 0),
('393bb07335ae4518cc0270f8152369c5', './lib/test/TikiTestCase.php', '28.4', 0),
('25aba4928a2e0d36e8b8b03c867a450d', './lib/test/TikiVersionTest.php', '28.4', 0),
('cfda4463ee863733301c9aa49d495e81', './lib/test/attributes/AttributeTest.php', '28.4', 0),
('c1fa6c5d23fc1ee61b73282210177fc2', './lib/test/attributes/RelationTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/attributes/index.php', '28.4', 0),
('5693378a2d8fcc914cf61f51d1d5587d', './lib/test/auth/AuthTokensTest.php', '28.4', 0),
('c15f6a55254daeb02d1f9c3683a91d19', './lib/test/auth/MembershipTest.php', '28.4', 0),
('5faca119423f51626974e2a4c867d968', './lib/test/auth/PasswordTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/auth/fixtures/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/auth/index.php', '28.4', 0),
('43f8e7112f784637ea6f1eee5aaafabe', './lib/test/bigbluebutton/DynamicConfigurationTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/bigbluebutton/index.php', '28.4', 0),
('e3eec6eb7fc2859a6de73619d53dd81f', './lib/test/bootstrap.php', '28.4', 0),
('88ca72fe1133ebd59df701ce53950559', './lib/test/comments/CommentsTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/comments/index.php', '28.4', 0),
('f2c66d3513e1e934719b7f2a7669945e', './lib/test/core/Category/ManipulatorTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Category/index.php', '28.4', 0),
('ff1077aba73de80d24a182e61232bdc9', './lib/test/core/Connect/ClientTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Connect/index.php', '28.4', 0),
('2fc3fb1d3ac75174c6c4e0615cf2c154', './lib/test/core/CustomRoute/ControllerTest.php', '28.4', 0),
('71b4aab8fe59e18c3d5da03e25d23ae4', './lib/test/core/CustomRoute/CustomRouteTest.php', '28.4', 0),
('272c428aa614bd6abc0f8a000b4562c0', './lib/test/core/CustomRoute/ItemTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/CustomRoute/index.php', '28.4', 0),
('601df44cd8bb5d18ec63344051954dd4', './lib/test/core/DeclFilter/BaseTest.php', '28.4', 0),
('c469c148635cf2fc24be20eb1cb103f3', './lib/test/core/DeclFilter/CatchAllFilterTest.php', '28.4', 0),
('5957b57cf4d1d6c409902548d9c727fb', './lib/test/core/DeclFilter/CatchAllUnsetTest.php', '28.4', 0),
('e0e51816fe95c39445964ce23d0ffe33', './lib/test/core/DeclFilter/ConfigureTest.php', '28.4', 0),
('39948666abb53b02590a57d32d058a29', './lib/test/core/DeclFilter/KeyPatternFilterTest.php', '28.4', 0),
('07af5e1f78b7eeb2506c0620d80aec00', './lib/test/core/DeclFilter/KeyPatternUnsetTest.php', '28.4', 0),
('e868b5da41022aa6cb6939748ae30480', './lib/test/core/DeclFilter/StaticKeyFilterTest.php', '28.4', 0),
('99777cae306a033eb4bd97c2460088e8', './lib/test/core/DeclFilter/StaticKeyUnsetTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/DeclFilter/index.php', '28.4', 0),
('ecf393b44b014835cbf895c3fe17de28', './lib/test/core/Event/CustomizerTest.php', '28.4', 0),
('0bf35fdcb5d9127f8c4b338875e7daa2', './lib/test/core/Event/ManagerTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Event/index.php', '28.4', 0),
('9ebd71e07c12a18ac99e1fcba40d4462', './lib/test/core/File/FileHelperTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/File/index.php', '28.4', 0),
('0ec5db6ac26d3a63b8f24540ce8ba6e1', './lib/test/core/Files/CheckAttachmentGalleryTest.php', '28.4', 0),
('eb2868b9dd30e26631d8b8fedeed4cfb', './lib/test/core/Files/CheckFileGalleryTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Files/index.php', '28.4', 0),
('94ff0898b87bf0fc23d43ea152dca8cb', './lib/test/core/JitFilter/AccessTest.php', '28.4', 0),
('abdb3aa795160925135fda277ff8ba5f', './lib/test/core/JitFilter/FilterTest.php', '28.4', 0),
('58e0489a256b212136e3865815462b20', './lib/test/core/JitFilter/IteratorTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/JitFilter/index.php', '28.4', 0),
('7d551b7784dc1a8540140f0cabf46899', './lib/test/core/Math/Formula/CurrencyTest.php', '28.4', 0),
('bf344aed15e67cd150152a5b7659e749', './lib/test/core/Math/Formula/DummyFunction/FortyTwo.php', '28.4', 0),
('a68133eaf916f17cd15e2e4f270b22ab', './lib/test/core/Math/Formula/DummyFunction/Testop.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/test/core/Math/Formula/DummyFunction/index.php', '28.4', 0),
('bdc2b99d2b06bc85af8da8c3dfbe5a5c', './lib/test/core/Math/Formula/ElementTest.php', '28.4', 0),
('2d61ec1ac1f2f7c8bca0ef1a3a3a4354', './lib/test/core/Math/Formula/ParserTest.php', '28.4', 0),
('1f528d2e5ea270d0f50c3320187989f7', './lib/test/core/Math/Formula/RunnerTest.php', '28.4', 0),
('723053065e9edc11b037752f944eac2a', './lib/test/core/Math/Formula/TokenizerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Math/Formula/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Math/index.php', '28.4', 0),
('2f016c188582c14046cebc2cf0d12070', './lib/test/core/Multilingual/Aligner/BilingualAlignerTest.php', '28.4', 0),
('73f2047ecbd6834825bfab298f8a0832', './lib/test/core/Multilingual/Aligner/SentenceAlignmentsTest.php', '28.4', 0),
('c8c30c82d5bf0f477c7d17b9357f3064', './lib/test/core/Multilingual/Aligner/SentenceSegmentorTest.php', '28.4', 0),
('e0b07f67253d8b5e77ea9e61602401c2', './lib/test/core/Multilingual/Aligner/ShortestPathFinderTest.php', '28.4', 0),
('949339e197c059aaa174ff5d8e4bed4c', './lib/test/core/Multilingual/Aligner/UpdatePagesTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Multilingual/Aligner/index.php', '28.4', 0),
('5ada8fcccd7d1400d8a57d82e363fe3c', './lib/test/core/Multilingual/MachineTranslation/GoogleTranslateWrapperTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Multilingual/MachineTranslation/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Multilingual/index.php', '28.4', 0),
('293405bdc38973b47932ff374b02144e', './lib/test/core/Notifications/EmailTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Notifications/index.php', '28.4', 0),
('0afe491755e9107d3f488d2af923315c', './lib/test/core/ObjectSelector/ObjectSelectorTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/ObjectSelector/index.php', '28.4', 0),
('b4738a2c0d3e0597852757b9b42b055e', './lib/test/core/Perms/AccessorTest.php', '28.4', 0),
('b8159130ffb3af557a79c183a2900cb2', './lib/test/core/Perms/ApplierTest.php', '28.4', 0),
('7153c7f43c5923c3ef6c5bc0879472aa', './lib/test/core/Perms/BaseTest.php', '28.4', 0),
('3f31180555a5108bf2d5280ac9a0d613', './lib/test/core/Perms/BuilderTest.php', '28.4', 0),
('b2fce1718d4894e3b2359cc6f5c35bb4', './lib/test/core/Perms/Check/AlternateTest.php', '28.4', 0),
('cd3404b37550629cf36892ab3789cd12', './lib/test/core/Perms/Check/CreatorTest.php', '28.4', 0),
('f0d5cfacaaabc1521d71e2b1fcc6271c', './lib/test/core/Perms/Check/DirectTest.php', '28.4', 0),
('5c3f5c12772bf768ef611e9468038d0a', './lib/test/core/Perms/Check/IndirectTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Perms/Check/index.php', '28.4', 0),
('b827408be78dba1eea8c5643c56c62d1', './lib/test/core/Perms/CheckSequenceTest.php', '28.4', 0),
('3613d602a4a205c4bf64fa3ead2a07d3', './lib/test/core/Perms/MixedTest.php', '28.4', 0),
('d55814bff3f4d7260bf544a084166c1d', './lib/test/core/Perms/Reflection/FactoryTest.php', '28.4', 0),
('8285566488207defc7d56aa345fd9cfa', './lib/test/core/Perms/Reflection/PermissionComparatorTest.php', '28.4', 0),
('4814a98565d6edf3fba240c818f7c5fa', './lib/test/core/Perms/Reflection/PermissionSetTest.php', '28.4', 0),
('d00eae5d6781de36cfbd1fbca68faa7c', './lib/test/core/Perms/Reflection/QuickTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Perms/Reflection/index.php', '28.4', 0),
('01a58760f17bb0143f7693daec392fa4', './lib/test/core/Perms/Resolver/DefaultTest.php', '28.4', 0),
('dc4acec3fb5595c1df36c107ae292f1e', './lib/test/core/Perms/Resolver/StaticTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Perms/Resolver/index.php', '28.4', 0),
('d36f477c2119c76f8aa3711a58338b84', './lib/test/core/Perms/ResolverFactory/CategoryFactoryTest.php', '28.4', 0),
('8117ae45c0782e42123bda2ab6a9f6b4', './lib/test/core/Perms/ResolverFactory/GlobalFactoryTest.php', '28.4', 0),
('1cfc9c9eba65a43818c704b0aff5e186', './lib/test/core/Perms/ResolverFactory/ObjectFactoryTest.php', '28.4', 0),
('0feb127108b88567753ae8c243db1725', './lib/test/core/Perms/ResolverFactory/TestFactoryTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Perms/ResolverFactory/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Perms/index.php', '28.4', 0),
('6d86e30604adc7dc0a970e60aa93fe9e', './lib/test/core/Recommendation/BatchTest.php', '28.4', 0),
('9a4f9fcd9a50f1f1c0da340715f07ea0', './lib/test/core/Recommendation/ComparatorTest.php', '28.4', 0),
('d701b65049d463fe7ebd189071b26860', './lib/test/core/Recommendation/EngineSetTest.php', '28.4', 0),
('fa785813b920ea2c4975dd28713255fa', './lib/test/core/Recommendation/RecommendationSetTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Recommendation/index.php', '28.4', 0),
('2d3a2ab99e18487778336be24f6616c2', './lib/test/core/Reports/CacheTest.php', '28.4', 0),
('d3694084bb3bd4411cf6432f1433a5a3', './lib/test/core/Reports/FactoryTest.php', '28.4', 0),
('4c6a8e8b00571ec2b21d962aadac8e9b', './lib/test/core/Reports/ManagerTest.php', '28.4', 0),
('b1a7ac6bc111b15c61c2dbcf744e6010', './lib/test/core/Reports/ReportsEndToEndTest.php', '28.4', 0),
('1808a53ecbb24208a3582e39cfc995f3', './lib/test/core/Reports/Send/EmailBuilderTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Reports/Send/index.php', '28.4', 0),
('200e156f5d960d3ba1904a82da59ca25', './lib/test/core/Reports/SendTest.php', '28.4', 0),
('c180e2e97c38ef5c3410c671b1052040', './lib/test/core/Reports/UsersTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Reports/fixtures/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Reports/index.php', '28.4', 0),
('da04e37adf0b8475cd2d8cd83a0d7b82', './lib/test/core/Request/RequestTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Request/index.php', '28.4', 0),
('7deb19a381144a8933e7386ecc7bdc87', './lib/test/core/Scheduler/ItemTest.php', '28.4', 0),
('16f7b6cca298f47a24cf365ab9cb6b52', './lib/test/core/Scheduler/ManagerTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Scheduler/index.php', '28.4', 0),
('14c004e5688b87363f33543263fafe1c', './lib/test/core/Search/ActionStepTest.php', '28.4', 0),
('a23cd88524577c3348b5693cc142d160', './lib/test/core/Search/Elastic/BaseTest.php', '28.4', 0),
('cea355d25a97d0bcb5a50760b9c07ac6', './lib/test/core/Search/Elastic/BulkIncrementalUpdateTest.php', '28.4', 0),
('1e45b43c42903a308a2cc38ee2bfc98a', './lib/test/core/Search/Elastic/BulkIndexingTest.php', '28.4', 0),
('94e2d34ac34738bb025eb80b089f7894', './lib/test/core/Search/Elastic/CamelCaseTest.php', '28.4', 0),
('8c3090defa254cf9cbe1c696a7ba5561', './lib/test/core/Search/Elastic/FacetBuilderTest.php', '28.4', 0),
('437309a9035046a5e7068bbc05e40cc8', './lib/test/core/Search/Elastic/FacetReaderTest.php', '28.4', 0),
('c46bcc08c0b4b687b16ea6a43b6c642b', './lib/test/core/Search/Elastic/FacetTest.php', '28.4', 0),
('290b510ca1db9ad871f589f64e1dc28c', './lib/test/core/Search/Elastic/FederatedQueryTest.php', '28.4', 0),
('a8f007d7dc84d5bb1052c080365e2f9a', './lib/test/core/Search/Elastic/IncrementalUpdateTest.php', '28.4', 0),
('c8390937339e448e3be8d12419c51bc3', './lib/test/core/Search/Elastic/MoreLikeThisTest.php', '28.4', 0),
('cbc1e03d404c6907ad701a00e7470daf', './lib/test/core/Search/Elastic/NumericTest.php', '28.4', 0),
('78cdb7657c78693fd3c55d584014b88d', './lib/test/core/Search/Elastic/PaginationTest.php', '28.4', 0),
('16c6368a6801788c60cd7f16dd0735a0', './lib/test/core/Search/Elastic/PrefilterTest.php', '28.4', 0),
('4e407335dfdf6a1dc96836890b796380', './lib/test/core/Search/Elastic/ProtocolTest.php', '28.4', 0),
('d2a7b8f5a4c724de928aba1d8ccf6b3a', './lib/test/core/Search/Elastic/QueryBuilderTest.php', '28.4', 0),
('b4c8cfe2b9373247d07a80a2b313a73e', './lib/test/core/Search/Elastic/RescoreQueryBuilderTest.php', '28.4', 0),
('4412851ee32da92e0045bb4c148a6346', './lib/test/core/Search/Elastic/SearchElasticPartialUpdateTest.php', '28.4', 0),
('1e7e4ea830006134936cd18a2c1c2216', './lib/test/core/Search/Elastic/SearchElasticQueryRepository.php', '28.4', 0),
('12df0dbcbd93be3cf1b305d9c2e87ced', './lib/test/core/Search/Elastic/SortTest.php', '28.4', 0),
('0844802bd80ff9e8c1e24f739a92b26c', './lib/test/core/Search/Elastic/StemmingTest.php', '28.4', 0),
('8fe3a67590324fbc33a6c07003861280', './lib/test/core/Search/Elastic/TypeAnalyzerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Elastic/index.php', '28.4', 0),
('96a461707b7073f23906e8ec5f433c67', './lib/test/core/Search/Expr/ParserTest.php', '28.4', 0),
('6dce961b661a421aa6c686a782616ba6', './lib/test/core/Search/Expr/TokenizerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Expr/index.php', '28.4', 0),
('b3da0bea1eef763b16691c8c62d6c1a1', './lib/test/core/Search/Formatter/ArrayBuilderTest.php', '28.4', 0),
('075ee67f5e2fb9b6b46fa408f658120a', './lib/test/core/Search/Formatter/DataSourceTest.php', '28.4', 0),
('9cd477cd78f5e1b3fd80f350c6e7c7f2', './lib/test/core/Search/Formatter/FactoryTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Formatter/index.php', '28.4', 0),
('a41949d8b3e69658d1840020947e7bb5', './lib/test/core/Search/FormatterTest.php', '28.4', 0),
('5f570e2948720f795ab4135e74a8aa58', './lib/test/core/Search/GlobalSource/PermissionSourceTest.php', '28.4', 0),
('9584aa01211d3c9fc712798e3357ca60', './lib/test/core/Search/GlobalSource/TitleInitialTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/GlobalSource/index.php', '28.4', 0),
('08f043627e030fe954a0631ead5c4ab9', './lib/test/core/Search/Index/QueryRepository.php', '28.4', 0),
('63d949c4271f3d1a07736f197b043629', './lib/test/core/Search/Index/SearchIndexBase.php', '28.4', 0),
('0fd650b6cf54958d48a4f6effcb6f7f4', './lib/test/core/Search/Index/SearchIndexIncrementalUpdate.php', '28.4', 0),
('78ce4d0cca0e0c1fbc1535f90daf5884', './lib/test/core/Search/Index/SearchIndexNumeric.php', '28.4', 0),
('0f07a097c05fe28c12c8cb2300f8628e', './lib/test/core/Search/Index/SearchIndexPagination.php', '28.4', 0),
('79da1dfb5ba1053c68e296c82cf122b2', './lib/test/core/Search/Index/SearchIndexPartialUpdate.php', '28.4', 0),
('6bb9e85fe6477c3ac39b1fed1b0470fa', './lib/test/core/Search/Index/SearchIndexSort.php', '28.4', 0),
('7abb1f12fee22207b7b9e7cd1ad7db28', './lib/test/core/Search/Index/SearchIndexStemming.php', '28.4', 0),
('3840340598520098bc7fa7c7786fc713', './lib/test/core/Search/Index/SearchIndexTypeAnalyzer.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Index/index.php', '28.4', 0),
('0103f20e22e235ae674470305568b979', './lib/test/core/Search/IndexerTest.php', '28.4', 0),
('0c8115a7689f1ab2d57d86d832467476', './lib/test/core/Search/Manticore/BaseTest.php', '28.4', 0),
('838b1cd6e7adccce3af56a5e7af9a282', './lib/test/core/Search/Manticore/ComplexQueriesTest.php', '28.4', 0),
('41ebce40cb0842bf6d6584dbf0c2407e', './lib/test/core/Search/Manticore/FacetTest.php', '28.4', 0),
('b2ab12ece0ea66c85de70527f2100fb3', './lib/test/core/Search/Manticore/IncrementalUpdateTest.php', '28.4', 0),
('e49c725cc0bd8afe1190c384dcf3b418', './lib/test/core/Search/Manticore/IndexBuilder.php', '28.4', 0),
('b660917f6133ec70da9277deb92e21d3', './lib/test/core/Search/Manticore/NumericTest.php', '28.4', 0),
('76257027b6f1ce98b0053f8dda1adb83', './lib/test/core/Search/Manticore/PaginationTest.php', '28.4', 0),
('16120d647690e578b01b1864c46fde07', './lib/test/core/Search/Manticore/PartialUpdateTest.php', '28.4', 0),
('9de787c83bb80caa56b53933d08d56ab', './lib/test/core/Search/Manticore/QueryRepository.php', '28.4', 0),
('4182cf9d16d01f1fad1442b8f6ece452', './lib/test/core/Search/Manticore/SortTest.php', '28.4', 0),
('acea9fcac427fc20873f7d731fead932', './lib/test/core/Search/Manticore/StemmingTest.php', '28.4', 0),
('21a602f390152dff3984e4218de7ee82', './lib/test/core/Search/Manticore/TypeAnalyzerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Manticore/index.php', '28.4', 0),
('63035179baa459fde94a02e2116ac018', './lib/test/core/Search/MySql/BaseTest.php', '28.4', 0),
('8d478faa4eaa8c94700ef8cfa9346ba3', './lib/test/core/Search/MySql/IncrementalUpdateTest.php', '28.4', 0),
('df3242af9400212cf8dccd2f2c5c1355', './lib/test/core/Search/MySql/LargeDatasetTest.php', '28.4', 0),
('bc3db6a36dc8505fa711ed80ec7a4d7f', './lib/test/core/Search/MySql/PaginationTest.php', '28.4', 0),
('8e1f642c801abb1c7894edb5ce7e7966', './lib/test/core/Search/MySql/QueryBuilderTest.php', '28.4', 0),
('5eaf410d43ab765486dd1b31b44fecb3', './lib/test/core/Search/MySql/SearchMySqlPartialUpdateTest.php', '28.4', 0),
('baf86f3cf44bda5514ab06f6427d7d61', './lib/test/core/Search/MySql/SortTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/MySql/index.php', '28.4', 0),
('fc04ff63f39c92d3623ffee2e5af2798', './lib/test/core/Search/Query/OrderTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Query/index.php', '28.4', 0),
('20a01160cf951458618cf6180c18b20e', './lib/test/core/Search/QueryTest.php', '28.4', 0),
('7c36959b50f21b3ad46b6df20f7677fb', './lib/test/core/Search/Type/WikiTextTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Search/Type/index.php', '28.4', 0),
('96c9e43e57f4b6a5f14698ee61cfd2ea', './lib/test/core/Search/TypeAnalyzerTest.php', '28.4', 0),
('19011a2474a7724b0b8fc5399d1f78cf', './lib/test/core/Search/basic.tpl', '28.4', 0),
('4afd33d3c9c4ae07e8fc871fec015a94', './lib/test/core/Search/embedded.tpl', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Search/index.php', '28.4', 0),
('99520ab12efa21b173659692c60d77e1', './lib/test/core/Search/paginate.tpl', '28.4', 0),
('10e85a175a408f4106841a6bd003e035', './lib/test/core/Services/Comment/ControllerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Services/Comment/index.php', '28.4', 0),
('f155cf047935842a6d912779c7953dae', './lib/test/core/Services/Encryption/ControllerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Services/Encryption/index.php', '28.4', 0),
('e902b72e4d66092d8687008b8c0123af', './lib/test/core/Services/ResultLoaderTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Services/index.php', '28.4', 0),
('cbf2bb5b9877c589487f300cdd837f5f', './lib/test/core/Tiki/Command/ListExecute/ExecuteTest.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/test/core/Tiki/Command/ListExecute/index.php', '28.4', 0),
('510226d47bde13d03f51b79fd8f270f7', './lib/test/core/Tiki/Command/ProfileExport/Fixtures/index.php', '28.4', 0),
('2bb23f635f7957b7aa0a6c2ede1fcf0c', './lib/test/core/Tiki/Command/ProfileExport/TrackerItemTest.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/test/core/Tiki/Command/ProfileExport/index.php', '28.4', 0),
('af7d89267b6e9d4ea3b9b2eec4b50f0e', './lib/test/core/Tiki/Command/UsersPasswordCommand/UsersPasswordCommandTest.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/test/core/Tiki/Command/UsersPasswordCommand/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Tiki/Command/index.php', '28.4', 0),
('07a9ce568b50a8d0618790167f8ce825', './lib/test/core/Tiki/FileGallery/DefinitionTest.php', '28.4', 0),
('44b1aaa8a0d93c209f049737a72a1b84', './lib/test/core/Tiki/FileGallery/FileDraftTest.php', '28.4', 0),
('de9bdc32c83fc50b328cd18120fdc9b5', './lib/test/core/Tiki/FileGallery/FileTest.php', '28.4', 0),
('f43b8af60254f5255642c91f25513e0b', './lib/test/core/Tiki/FileGallery/Manipulator/ImageTransformerTest.php', '28.4', 0),
('1dd60e9540c7bb9be526ffc7895e46f5', './lib/test/core/Tiki/FileGallery/Manipulator/MetadataExtractorTest.php', '28.4', 0),
('b11475bfe2c1aa758f5544ccd6ee5cb9', './lib/test/core/Tiki/FileGallery/Manipulator/ValidatorTest.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/test/core/Tiki/FileGallery/Manipulator/index.php', '28.4', 0),
('395198795df824ee8c42c08780e0d0e9', './lib/test/core/Tiki/FileGallery/SaveHandlerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Tiki/FileGallery/index.php', '28.4', 0),
('de6892cccb471e57bf7180698e92c923', './lib/test/core/Tiki/Package/ComposerCliTest.php', '28.4', 0),
('5d97b7b39e20eb7f46b3337db09664d3', './lib/test/core/Tiki/Package/ComposerManagerTest.php', '28.4', 0),
('138d142b68ffed769bee523a99796980', './lib/test/core/Tiki/Package/Fixtures/index.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Tiki/Package/index.php', '28.4', 0),
('90bb306385c0713dec9ad15c875acd7d', './lib/test/core/Tiki/Process/PhpExecutableFinderTest.php', '28.4', 0),
('b7e71b49194cb959fb868a07b1a7f41c', './lib/test/core/Tiki/Process/ProcessFactoryTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Tiki/Process/index.php', '28.4', 0),
('9e9a8a76aa3d27529504b1d8c53e4206', './lib/test/core/Tiki/ProfileTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Tiki/index.php', '28.4', 0),
('fabf423a6f83c167bc6c75b8b7c3b7a8', './lib/test/core/TikiDb/SanitizeEncodingTest.php', '28.4', 0),
('11afeb1d503f5ebacaead19093d15e76', './lib/test/core/TikiDb/TableTest.php', '28.4', 0),
('bda48169ebd932f4829fb5e9782dfae5', './lib/test/core/TikiDb/TikiDbBasicAssumptionsPdoTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/TikiDb/index.php', '28.4', 0),
('6ee41b96394e5d436f387e2e7098046a', './lib/test/core/TikiFilter/CallbackTest.php', '28.4', 0),
('4b4592f9010db0503af3f4ada4ed4c9d', './lib/test/core/TikiFilter/MapTest.php', '28.4', 0),
('143458ec4becf694906e96d1bad133db', './lib/test/core/TikiFilter/PrepareInputTest.php', '28.4', 0),
('1985521d46f4314182a7dd68057012f9', './lib/test/core/TikiFilter/WordTest.php', '28.4', 0),
('b8aee0bac0e5acd02ba9099dda3aa032', './lib/test/core/TikiFilter/XssTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/TikiFilter/index.php', '28.4', 0),
('85cb1cd27f0994a31e9c2b1f56624ab0', './lib/test/core/TikiSecurityTest.php', '28.4', 0),
('b6ab737d1d82ff5ea4521d1f41d54fb2', './lib/test/core/Tracker/Field/ItemLinkTest.php', '28.4', 0),
('fa338a64b0c9bbde1376fbe090ee9458', './lib/test/core/Tracker/Field/MathTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Tracker/Field/index.php', '28.4', 0),
('56fca823dc4ec33b15a86a37a92c8f2c', './lib/test/core/Tracker/OptionsTest.php', '28.4', 0),
('4692988a48b91c4888317e5ab81d7fd6', './lib/test/core/Tracker/Tabular/ODBCManagerTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Tracker/Tabular/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Tracker/index.php', '28.4', 0),
('e379184554d63991de077d06f034234f', './lib/test/core/Transition/AtLeastTest.php', '28.4', 0),
('aa8072ce79bfd7e4795c78b4002f74a5', './lib/test/core/Transition/AtMostTest.php', '28.4', 0),
('b479cb69d3abb340ec2c53304beb2420', './lib/test/core/Transition/BasicTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Transition/index.php', '28.4', 0),
('9973fdd86215f8eeebfdfff5b273257a', './lib/test/core/Wiki/SlugManagerTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Wiki/index.php', '28.4', 0),
('2da429afb599664d7b2f40cc3c23360c', './lib/test/core/WikiParser/OutputLinkTest.php', '28.4', 0),
('9666f9bae234052f158cdbf3bb9eaa32', './lib/test/core/WikiParser/PluginArgumentParserTest.php', '28.4', 0),
('8612393c053828ad27a47e9cdae4e5d2', './lib/test/core/WikiParser/PluginMatcherTest.php', '28.4', 0),
('567be2bb2caff0beed0110013f5af812', './lib/test/core/WikiParser/PluginOutputTest.php', '28.4', 0),
('ecad44ca9b4edefa6e3822ac7d3db053', './lib/test/core/WikiParser/PluginParserTest.php', '28.4', 0),
('22a2f79c17e7513472f4666fda241747', './lib/test/core/WikiParser/PluginRepositoryTest.php', '28.4', 0),
('bf52a234bdf65bee6a65b29339e5a3ae', './lib/test/core/WikiParser/StressTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/WikiParser/index.php', '28.4', 0),
('b8bf559b3a14f529fba9febe2071b2f0', './lib/test/core/WikiParser/wikiplugin_foo.php', '28.4', 0),
('ca3b85247cc14c4b65eb8257c5293a55', './lib/test/core/Workspace/AnalyserTest.php', '28.4', 0),
('39237deb498030331f21214196f42932', './lib/test/core/Workspace/BuilderTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Workspace/index.php', '28.4', 0),
('86837504a5a60d6aefac3287a9d8a300', './lib/test/core/Yaml/DirectivesTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/core/Yaml/Fixtures/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/core/Yaml/index.php', '28.4', 0),
('c6ec3f27bccadc83f9aded564dc67d8b', './lib/test/core/bootstrap.php', '28.4', 0),
('ad29566a60f5f50b0c1aebbed6dac042', './lib/test/core/include_non_autoload_compatible_classes.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/core/index.php', '28.4', 0),
('8bdd0a1d490e23f2024375191b305a50', './lib/test/diff/DiffTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/diff/fixtures/index.php', '28.4', 0),
('e94b86e8471c56b9878548b5704af8c5', './lib/test/diff/fixtures/unidiff.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/diff/index.php', '28.4', 0),
('e62fe9c5356ff89ccac6ffc1f9a594a4', './lib/test/editlib/EditLibTest.php', '28.4', 0),
('b0a9e98c47ca34afc97e81d97a2db4b8', './lib/test/editlib/ParseToWiki_CharacterTest.php', '28.4', 0),
('f0c86e6a8e7dea7e1b4dc4b7ede92eed', './lib/test/editlib/ParseToWiki_LinkTest.php', '28.4', 0),
('856706f71e35f06131d2054ffc3f6b14', './lib/test/editlib/ParseToWiki_ListTest.php', '28.4', 0),
('62c8db741dd35bc40656d93b876e7557', './lib/test/editlib/ParseToWiki_TextTest.php', '28.4', 0),
('c0215c347479757af2c694984a51f948', './lib/test/editlib/ParseToWysiwyg_CharacterTest.php', '28.4', 0),
('76a5b5bb0883380e5e6a619a86cf86dc', './lib/test/editlib/ParseToWysiwyg_LinkTest.php', '28.4', 0),
('1f418f71acdaf6f163bcb3c27eb0b850', './lib/test/editlib/ParseToWysiwyg_ListTest.php', '28.4', 0),
('d9d37409c4c06d5281b3e6be1d72ae33', './lib/test/editlib/ParseToWysiwyg_TextTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/editlib/index.php', '28.4', 0),
('beb90fcc28d0f1b69d3c27e12dda64a4', './lib/test/filegals/FilegalsTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/filegals/index.php', '28.4', 0),
('b69a92a879ed27145157bcfe4e94f866', './lib/test/freetag/FreetagTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/freetag/index.php', '28.4', 0),
('22bf1bf876787196ab5aaacbf352f846', './lib/test/importer/TikiImporterBlogTest.php', '28.4', 0),
('b84924b9e7c161f0e822611e5f3260ac', './lib/test/importer/TikiImporterBlogWordpressTest.php', '28.4', 0),
('8c8a4a5b538e4b9dfe25f27dbbb0155b', './lib/test/importer/TikiImporterTest.php', '28.4', 0),
('dc31239764015f5919c49145a4bb9b2f', './lib/test/importer/TikiImporterWikiMediawikiTest.php', '28.4', 0),
('338ab2bee3afefde95c5911f0c355289', './lib/test/importer/TikiImporterWikiTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/importer/fixtures/index.php', '28.4', 0),
('f3cbab359978f7d8fc879c1a78c87ff4', './lib/test/importer/fixtures/mediawiki_page_as_array.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/importer/index.php', '28.4', 0),
('ffd38d150b0c3629f25b1ab7c87fd43a', './lib/test/importer/tikiimporter_testcase.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/test/index.php', '28.4', 0),
('6558ee2978f053ef9ae53b125dbaff95', './lib/test/language/CollectFilesTest.php', '28.4', 0),
('7adb29caa0e96e8002799a75f581abff', './lib/test/language/FileType/PhpTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/language/FileType/index.php', '28.4', 0),
('06ec134564194bdf9ea60cfd2aa2a166', './lib/test/language/GetStringsEndToEndTest.php', '28.4', 0),
('ccaff418a33aaa9a7e211a7cf448450c', './lib/test/language/GetStringsTest.php', '28.4', 0),
('f595906ff8fd9a45034b77790b1eec27', './lib/test/language/LanguageFileTest.php', '28.4', 0),
('1cbf25c330592707735dca4e474ddf29', './lib/test/language/LanguageTest.php', '28.4', 0),
('7a03c51ec568c1350f61b39f90dbe229', './lib/test/language/LanguageTranslationsTest.php', '28.4', 0),
('42a036afa488c6ea4aa1371b3922f3e8', './lib/test/language/MergeFilesTest.php', '28.4', 0),
('80f0b34ae1ec5970deeaf561b35dc768', './lib/test/language/WriteFile/FactoryTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/language/WriteFile/index.php', '28.4', 0),
('a28219005fadb726cd4df7e432bf418b', './lib/test/language/WriteFileTest.php', '28.4', 0),
('a29697fb7a4b15e85ecd454e3a5d713a', './lib/test/language/fixtures/custom.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/language/fixtures/index.php', '28.4', 0),
('7146f87132ede279f57d0fca0c37074a', './lib/test/language/fixtures/language_end_to_end_test_modified.php', '28.4', 0),
('8b7e61dcb8319fc9d07d4d737eaf9109', './lib/test/language/fixtures/language_end_to_end_test_original.php', '28.4', 0),
('ec1381a48f8a4c32fdb724b866edc39a', './lib/test/language/fixtures/language_escape_special_characters.php', '28.4', 0),
('e081f0e39c955151f7d81971f3e2e261', './lib/test/language/fixtures/language_fa_modified.php', '28.4', 0),
('d174926968b41b5ba07b302f68a99b45', './lib/test/language/fixtures/language_fa_original.php', '28.4', 0),
('f36136539665c33d1f72d882268f425d', './lib/test/language/fixtures/language_invalid.php', '28.4', 0),
('f464f6784a269022cc5ca404476d6a11', './lib/test/language/fixtures/language_merge_files_original.php', '28.4', 0),
('c856093fb6e2be46974a7decc118fa6a', './lib/test/language/fixtures/language_merge_files_result.php', '28.4', 0),
('081cc4a8d22ee5e9ebbee07766827144', './lib/test/language/fixtures/language_modif.php', '28.4', 0),
('ef72e4e828e1980c29a90a84af90f2df', './lib/test/language/fixtures/language_orig.php', '28.4', 0),
('94109316ec40af88e149752b79a15f44', './lib/test/language/fixtures/language_punctuations.php', '28.4', 0),
('565e2fdc529132f5a68f6e61a6b10410', './lib/test/language/fixtures/language_ru_modified.php', '28.4', 0),
('cf588fa7f56b59be6d1f08a1b012b318', './lib/test/language/fixtures/language_ru_original.php', '28.4', 0),
('74a1b6d9381f9b9ed476c33d472dcf6c', './lib/test/language/fixtures/language_simple.php', '28.4', 0),
('3c5a84c1d6de237f63026cf6cbdd4a25', './lib/test/language/fixtures/language_to_parse_file.php', '28.4', 0),
('7310baf88bf909bc8cc726c8f7611c8b', './lib/test/language/fixtures/language_untranslated.php', '28.4', 0),
('a241ae52062431f4468f98818332f76f', './lib/test/language/fixtures/language_with_translations.php', '28.4', 0),
('1425e9a3384dd3cb5f2f9ee3df036901', './lib/test/language/fixtures/language_with_translations_and_file_paths.php', '28.4', 0),
('6eb5223df6d76a1ded0592f87f67e10a', './lib/test/language/fixtures/language_writestringstofile_first_call.php', '28.4', 0),
('c7a0a41a42a6f0b9807597689b9d147f', './lib/test/language/fixtures/language_writestringstofile_second_call.php', '28.4', 0),
('9041d99feca8cf210e015c2517b3173f', './lib/test/language/fixtures/test_collecting_strings.php', '28.4', 0),
('838275e917563495f6fa44a557c89915', './lib/test/language/fixtures/test_collecting_strings.tpl', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/language/index.php', '28.4', 0),
('15714d23f589d3d477f749438eabb02b', './lib/test/lib/AbsoluteToRelativeLinkTest.php', '28.4', 0),
('9fb4826bfe335a940a15b33b3b494efa', './lib/test/lib/PdfLibTest.php', '28.4', 0),
('4a0ddf3a28abee84b2d36ccfb7b18d67', './lib/test/lib/Perspective/AreasMultiDomainBasicTest.php', '28.4', 0),
('fb5010a52c81acbbb50837d4c6257d0e', './lib/test/lib/Perspective/PerspectivesNavigationBaseTestCase.php', '28.4', 0),
('ea855af66e911578eea5522c9ebb6dc4', './lib/test/lib/Perspective/PerspectivesTest.php', '28.4', 0),
('cd1f5a887fccf3fc5dbe7a407edafe02', './lib/test/lib/Perspective/fixtures/index.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/lib/Perspective/index.php', '28.4', 0),
('8632d0b69a677273fec0a9d4d573cfd6', './lib/test/lib/accounting/AccountingLibTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/lib/accounting/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/lib/index.php', '28.4', 0),
('35991d3d7e7a384945c083b59958ac32', './lib/test/notifications/NotificationEmailLibTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/notifications/index.php', '28.4', 0),
('f6fb8909c1b4d7f4b2369e8fcc195bcc', './lib/test/payment/CartTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/payment/index.php', '28.4', 0),
('92534818713a2dedfac2252d40bf2b73', './lib/test/phpunit.php', '28.4', 0),
('67dc7884b1c9f78a6845798ede500ba8', './lib/test/phpunit_with_baseline.php', '28.4', 0),
('1475e1267a42ed372e3cb2659908db96', './lib/test/rating/AggregationTest.php', '28.4', 0),
('2ac12ea070d891660b9616ab8d4d06e2', './lib/test/rating/RegisterVoteTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/rating/index.php', '28.4', 0),
('84380776f16275913b434bf51966ed95', './lib/test/shipping/ShippingTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/shipping/index.php', '28.4', 0),
('03984e5b54e83af991a7902ae970f3d8', './lib/test/smarty_tiki/FunctionToolbarsTest.php', '28.4', 0),
('398a596677ae0f06012c2b3bbe06fc51', './lib/test/smarty_tiki/ModifierDurationTest.php', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/test/smarty_tiki/fixtures/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/smarty_tiki/index.php', '28.4', 0),
('a2609f5ff8e363a1429b2e3911402e38', './lib/test/wiki-plugins/CodeTest.php', '28.4', 0),
('9718df2a44861601eadcb4b438bdcafc', './lib/test/wiki-plugins/TranslationOfTest.php', '28.4', 0),
('de4329911f4966fe7c5ff09ba19a1295', './lib/test/wiki-plugins/WikiPluginRedirectTest.php', '28.4', 0),
('e3b6bac7cba330e9c8c510c4052f3207', './lib/test/wiki-plugins/YoutubeTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/wiki-plugins/index.php', '28.4', 0),
('5df0fa129726ecdc6bc724d9023cee63', './lib/test/wiki/EditLibTest.php', '28.4', 0),
('03c0a8867850080f26b1191d81b0d1c4', './lib/test/wiki/WikiLibTest.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/test/wiki/index.php', '28.4', 0),
('e052ff5bf6c80437fc272130337ef9d4', './lib/theme/iconsetlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/theme/index.php', '28.4', 0),
('f2d617c8321724d8fcd8fa33e3183b3f', './lib/theme/themecontrollib.php', '28.4', 0),
('44261cd3edec3539fcecf1def4d245e9', './lib/theme/themelib.php', '28.4', 0),
('ae065a847da2f47f4174e6683f224f01', './lib/tiki-js.js', '28.4', 0),
('518a851df9fa0cae3c960cafdf324c54', './lib/tikiaccesslib.php', '28.4', 0),
('c1d9d90fab4a9a614b5c0ac4b171f145', './lib/tikidate.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/tikihelp/css/index.php', '28.4', 0),
('c42ebbdb75e2f36e078db5b256dabc93', './lib/tikihelp/css/menu.css', '28.4', 0),
('26a50ce04ebc204f29d795b1216fe9ea', './lib/tikihelp/css/toolbar.css', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/tikihelp/index.php', '28.4', 0),
('96ed9bd0969f3f89e2c76be975f7c6ab', './lib/tikihelp/js/global.js', '28.4', 0),
('50f3861b9268922292a1dea3d254fd54', './lib/tikihelp/js/highlight.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/tikihelp/js/index.php', '28.4', 0),
('a6cfb9a59fc649962847c11d418349a6', './lib/tikihelp/js/toolbar.js', '28.4', 0),
('3cb73377cdaba68023b716556eb72c1d', './lib/tikihelp/menu/ftiens4.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/tikihelp/menu/index.php', '28.4', 0),
('3a58a2fe95f389c6b620dbf8357bb3f5', './lib/tikihelp/menu/menuNodes.js', '28.4', 0),
('fbfea9307d4e3e69d06dc76ed3476899', './lib/tikihelp/menu/ua.js', '28.4', 0),
('f6510d69418eafa43473b9f0421caae8', './lib/tikihelplib.php', '28.4', 0),
('4ae1734755c5b31ecedad53cfe4d1e27', './lib/tikilib.php', '28.4', 0),
('44fa6851ad6e35cefa84597d0c14cd12', './lib/tikisession-adodb.php', '28.4', 0),
('574d7fe079af905a6e53aebe895096a9', './lib/tikisession-memcache.php', '28.4', 0),
('bfb2ca1ba517063b82b6d2414c3b9757', './lib/tikisession-pdo.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/toastui_tiki/index.php', '28.4', 0),
('56b061e0310d3bc7f4b693aa31042ee6', './lib/toastui_tiki/tiki-plugin.js', '28.4', 0),
('40217b93013f03989424524ac29ca3d9', './lib/toastui_tiki/tiki-toastui.js', '28.4', 0),
('076d0c059967217f311304a605d260c8', './lib/todolib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/toolbars/index.php', '28.4', 0),
('1a865afce9f4efe9d61967ce071054b0', './lib/toolbars/tiki-admin_toolbars.js', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/trackers/index.php', '28.4', 0),
('077f47ab760d8a5875d4825e1658d720', './lib/trackers/trackerlib.php', '28.4', 0),
('d13735ec2fb169653b413f888a3273d4', './lib/transitionlib.php', '28.4', 0),
('fb704cb59c68458371e06573a47f04b4', './lib/tree/BrowseTreeMaker.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/tree/index.php', '28.4', 0),
('2dee72818e295445041ec5908b91c404', './lib/tree/tree.php', '28.4', 0),
('19c2ef1595b5de19cd8faa03fe6dfcab', './lib/user/blacklistlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/user/index.php', '28.4', 0),
('453933cc0aa08fad2d7a3bb5d5913cf8', './lib/user/monitorlib.php', '28.4', 0),
('afe295b8a4a8216cb181fa0a0862030b', './lib/user/monitormaillib.php', '28.4', 0),
('24f883c7c1b19f621b366b4614d54000', './lib/user/sociallib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/userfiles/index.php', '28.4', 0),
('b059d1341667bbee74ff7a021d9faa60', './lib/userfiles/userfileslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/usermenu/index.php', '28.4', 0),
('d96c72ac37c02f23ed4817593e8969b1', './lib/usermenu/usermenulib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/usermodules/index.php', '28.4', 0),
('7d627e77b671794146b0c11826c56379', './lib/usermodules/usermoduleslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/userprefs/index.php', '28.4', 0),
('abf4bf1d2604586c527088119699ff0c', './lib/userprefs/userprefslib.php', '28.4', 0),
('8bf91e6f1f213fd6b17ea5fab82a038b', './lib/userslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/validators/index.php', '28.4', 0),
('8e60079d0201ca3aff3e1937aa113e02', './lib/validators/validator_captcha.php', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('5555d146a707ca4b721c7f9ec5ce5d3e', './lib/validators/validator_cardinality.php', '28.4', 0),
('fcf2c328c8bcf550647ff64e3151e6b2', './lib/validators/validator_distinct.php', '28.4', 0),
('ac9e052d3084d72b26706098e051019c', './lib/validators/validator_pagename.php', '28.4', 0),
('44fbfe3d10dd47d58d29eb68ea9e434c', './lib/validators/validator_passcode.php', '28.4', 0),
('c2cd0ccd9dd5324e5d8aa4fd58a352ef', './lib/validators/validator_password.php', '28.4', 0),
('537a7018d2c9e0c6710f0594e8af013c', './lib/validators/validator_regex.php', '28.4', 0),
('30abab25f84dc24c92c337b7592b2a72', './lib/validators/validator_remotelock.php', '28.4', 0),
('4d9d118c993a4c3d691db8bd2b51c6f9', './lib/validators/validator_smarty.php', '28.4', 0),
('947e2cdfdf77c1185585149b4b0ad49d', './lib/validators/validator_tiki.js', '28.4', 0),
('0626dd7ba8f190273f6d79acac52da99', './lib/validators/validator_uniqueemail.php', '28.4', 0),
('bfe1ecbf26e3b2023d1aa1d570bdede2', './lib/validators/validator_username.php', '28.4', 0),
('93c9a625873d55b879f5e01b3ef97a76', './lib/validatorslib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/videogals/index.php', '28.4', 0),
('2d8eee7192e66795d4b2afba4e835b73', './lib/videogals/kalturalib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/vue/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/vue/lib/index.php', '28.4', 0),
('c58fc21bffa40c3f59413d4a52f78c03', './lib/vue/lib/ui-predicate-vue.css', '28.4', 0),
('ae31eee74d3767fb5918395c69268afe', './lib/vue/lib/ui-predicate-vue.js', '28.4', 0),
('9eb92015f38ac940708f168c20a5b697', './lib/vue/lib/ui-predicate/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/vue/rules/index.php', '28.4', 0),
('e8b79c38aedd8af3e161897948b267fc', './lib/vue/vuejslib.php', '28.4', 0),
('f19c989eb4d62b66f37ce8019320886c', './lib/webmail/addressbooklib.php', '28.4', 0),
('6ae1b0c2eb9c43f9bd6c2bc3ee51f86b', './lib/webmail/contactlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/webmail/index.php', '28.4', 0),
('040042485cf34899b3d38e4f2d395ee5', './lib/webmail/net_pop3.php', '28.4', 0),
('cb104845cba0958350710c759f131f93', './lib/webmail/tikimaillib.php', '28.4', 0),
('91b208b3f4394c3a501e02974c8af5ec', './lib/webservicelib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/wiki-plugins/index.php', '28.4', 0),
('8611c138c4699ff0fe0e227d39bbbde4', './lib/wiki-plugins/wikiplugin_accordion.php', '28.4', 0),
('e83af925f77b77943a546ea761de23c0', './lib/wiki-plugins/wikiplugin_activitystream.php', '28.4', 0),
('91ebb7fa2b9aab1d06affa63dcf96877', './lib/wiki-plugins/wikiplugin_addfreetag.php', '28.4', 0),
('ac85ce017cab23e1dfe6360af7aeecab', './lib/wiki-plugins/wikiplugin_addreference.php', '28.4', 0),
('004d5c7d9c797c849f8530f3eb614eb5', './lib/wiki-plugins/wikiplugin_addrelation.php', '28.4', 0),
('3332cbf10def029f9a19dee5b499ac94', './lib/wiki-plugins/wikiplugin_addtocart.php', '28.4', 0),
('3a2713a1112be7014a341c5503fdca72', './lib/wiki-plugins/wikiplugin_addtogooglecal.php', '28.4', 0),
('0681f907bf4c838d1a09ad15c626eb3c', './lib/wiki-plugins/wikiplugin_adjustinventory.php', '28.4', 0),
('d6db5f1d15bd860d6b429ef45621a800', './lib/wiki-plugins/wikiplugin_agentinfo.php', '28.4', 0),
('704c28bc95e9ba1b1115c1a16e07962b', './lib/wiki-plugins/wikiplugin_ajaxload.php', '28.4', 0),
('2241584f795845e192b087f71fb27b71', './lib/wiki-plugins/wikiplugin_alink.php', '28.4', 0),
('ab60705870154673fc09f4cd8d00cfa0', './lib/wiki-plugins/wikiplugin_aname.php', '28.4', 0),
('b373f84b3afc34c3fdb1319e424d7886', './lib/wiki-plugins/wikiplugin_annotation.php', '28.4', 0),
('fe06fb88d5f31f32cf2b7d41d929fab1', './lib/wiki-plugins/wikiplugin_appframe.php', '28.4', 0),
('9e541ca2d680f6a731edbe10dc1d3b1f', './lib/wiki-plugins/wikiplugin_archivebuilder.php', '28.4', 0),
('25b773c2befb5c1fa4f76d3c76e85283', './lib/wiki-plugins/wikiplugin_article.php', '28.4', 0),
('6df51baf245e5ac14690200a700366f7', './lib/wiki-plugins/wikiplugin_articles.php', '28.4', 0),
('c590380727c8079f19fe69d28d491a9d', './lib/wiki-plugins/wikiplugin_attach.php', '28.4', 0),
('9242e4e4a3e9c2169102332ec037ee6a', './lib/wiki-plugins/wikiplugin_attributes.php', '28.4', 0),
('ba2ff44bcab298aa6761d823e51b2df3', './lib/wiki-plugins/wikiplugin_author.php', '28.4', 0),
('093f8fcf60a2aabc30ab0a911dcf9a7c', './lib/wiki-plugins/wikiplugin_autoqueryargs.php', '28.4', 0),
('5ed473e9387046e339996fa2eb9952c2', './lib/wiki-plugins/wikiplugin_autotoc.php', '28.4', 0),
('8b8b22f60316d566fd81d4088ec9ffc4', './lib/wiki-plugins/wikiplugin_avatar.php', '28.4', 0),
('0bf7e952818cd71483170f73e0fa779b', './lib/wiki-plugins/wikiplugin_back.php', '28.4', 0),
('a22b5e8cef093e46394b4b3484185051', './lib/wiki-plugins/wikiplugin_backlinks.php', '28.4', 0),
('a102dd0a1850b877a49e2ba353d8f121', './lib/wiki-plugins/wikiplugin_banner.php', '28.4', 0),
('e8cb6843155fe6319779ed7bdb4d8ed8', './lib/wiki-plugins/wikiplugin_benchmark.php', '28.4', 0),
('69cef6ffacbc3f1bf032e55e98a02c16', './lib/wiki-plugins/wikiplugin_bigbluebutton.php', '28.4', 0),
('5b8c6940d556fc2546e6faf2fffb1777', './lib/wiki-plugins/wikiplugin_bloglist.php', '28.4', 0),
('29570a17317bd5d16a3d785dbb9ca281', './lib/wiki-plugins/wikiplugin_box.php', '28.4', 0),
('444281abbbdc1359f59648d1a25cd1aa', './lib/wiki-plugins/wikiplugin_button.php', '28.4', 0),
('4399f232fd62971d92e78fa49c54409a', './lib/wiki-plugins/wikiplugin_calendar.php', '28.4', 0),
('f480fb7b637eccc70c085d7edcc0cee8', './lib/wiki-plugins/wikiplugin_casperjs.php', '28.4', 0),
('33b84f296d91868e493bd64b55f691c7', './lib/wiki-plugins/wikiplugin_category.php', '28.4', 0),
('e98feaaf41e451a40254e3ab4ef84cfd', './lib/wiki-plugins/wikiplugin_categorytransition.php', '28.4', 0),
('b83dc58a205015a0f0a7e8830e2c92a7', './lib/wiki-plugins/wikiplugin_catorphans.php', '28.4', 0),
('00c4b28ddf5d859b797d073ee733a081', './lib/wiki-plugins/wikiplugin_catpath.php', '28.4', 0),
('e608f2a283da4a2ee9585d29e45f9615', './lib/wiki-plugins/wikiplugin_cclite.php', '28.4', 0),
('49cba5764b715ecd760602e3d3a5a0be', './lib/wiki-plugins/wikiplugin_center.php', '28.4', 0),
('ad7b14757df6286187dda7bb203b9138', './lib/wiki-plugins/wikiplugin_chart.php', '28.4', 0),
('dd6d4e5b87ca9318b61befebec7d6f92', './lib/wiki-plugins/wikiplugin_chartjs.php', '28.4', 0),
('2031a4a8fc2d87e448ad5326e7f193c9', './lib/wiki-plugins/wikiplugin_checkreferer.php', '28.4', 0),
('bc8f834244bfb1943703f24bc37fc70b', './lib/wiki-plugins/wikiplugin_code.php', '28.4', 0),
('8d70014db96606373ea5e5de3f8375d7', './lib/wiki-plugins/wikiplugin_coil.php', '28.4', 0),
('8fd28cb01cff614cd427038934193d17', './lib/wiki-plugins/wikiplugin_colorbox.php', '28.4', 0),
('d50e27ac51d8740422b77303115a3db8', './lib/wiki-plugins/wikiplugin_comment.php', '28.4', 0),
('d58af58ffb413edcea6abbdda0f94bf0', './lib/wiki-plugins/wikiplugin_content.php', '28.4', 0),
('52182d6a6e891f48772e7492d6f9f823', './lib/wiki-plugins/wikiplugin_contributionsdashboard.php', '28.4', 0),
('3fc5f86e4e7f619f5e0ef291d99c89b0', './lib/wiki-plugins/wikiplugin_convene.php', '28.4', 0),
('97d103fa67b042be09d1d021dc58a014', './lib/wiki-plugins/wikiplugin_cookie.php', '28.4', 0),
('a6a4fa7b403c9b53ad52b6808da9a6c4', './lib/wiki-plugins/wikiplugin_cookieconsent.php', '28.4', 0),
('eec1d43f6c41007fa18defbfd7c0f06e', './lib/wiki-plugins/wikiplugin_copyright.php', '28.4', 0),
('1e30bd207a594daa85ce694be6cc0c11', './lib/wiki-plugins/wikiplugin_countdown.php', '28.4', 0),
('725fc0e5d839d7a80e1132bf6f9fe2e4', './lib/wiki-plugins/wikiplugin_countup.php', '28.4', 0),
('1484a5bacbf9323a8fddade3c8506900', './lib/wiki-plugins/wikiplugin_customsearch.php', '28.4', 0),
('e9a6f988a7c7940a73bdfec97f92f62a', './lib/wiki-plugins/wikiplugin_cypht.php', '28.4', 0),
('776c8c8d8fe28f73a8c04b17e1c6f298', './lib/wiki-plugins/wikiplugin_datachannel.php', '28.4', 0),
('fa40e5700260c41320f5e7d47810a3e5', './lib/wiki-plugins/wikiplugin_dbreport.php', '28.4', 0),
('e644545fefc5d0f26ff15084fe7d6010', './lib/wiki-plugins/wikiplugin_diagram.php', '28.4', 0),
('4c461cdd2762fc5669648a4d309f71dd', './lib/wiki-plugins/wikiplugin_dialog.php', '28.4', 0),
('a7d271b05d3cd607b0dc4e96eb9cb09a', './lib/wiki-plugins/wikiplugin_div.php', '28.4', 0),
('ec85b27434cde2271d9931cd9412ecbe', './lib/wiki-plugins/wikiplugin_dl.php', '28.4', 0),
('5090f71215d00033652f7952f93fed55', './lib/wiki-plugins/wikiplugin_draw.php', '28.4', 0),
('8dff70ff40f2ec859b01ca916dae6df5', './lib/wiki-plugins/wikiplugin_dynamicvariables.php', '28.4', 0),
('aadfe87ac943d203f09b7ab5af30283a', './lib/wiki-plugins/wikiplugin_equation.php', '28.4', 0),
('1f91c51276f90634088e9a3d6e8051ec', './lib/wiki-plugins/wikiplugin_events.php', '28.4', 0),
('71f2cbf11066caaf3b9c19e2108380ac', './lib/wiki-plugins/wikiplugin_exercise.php', '28.4', 0),
('93ca8a27522118b4b000d21ad395fc54', './lib/wiki-plugins/wikiplugin_extendcarthold.php', '28.4', 0),
('e98a6ac74076c2346121917c17512835', './lib/wiki-plugins/wikiplugin_fade.php', '28.4', 0),
('9efe1997db167750fb5c337e7da5884d', './lib/wiki-plugins/wikiplugin_fancylist.php', '28.4', 0),
('7b0a648b5654cb4d3b4e948facea752d', './lib/wiki-plugins/wikiplugin_fancytable.php', '28.4', 0),
('1b2ff81c6bcc6f1e6fc7e7552002ec08', './lib/wiki-plugins/wikiplugin_favorite.php', '28.4', 0),
('589830c90c13142309eceb27383a7940', './lib/wiki-plugins/wikiplugin_figlet.php', '28.4', 0),
('8550982c8de62a135106d49dd78057bd', './lib/wiki-plugins/wikiplugin_file.php', '28.4', 0),
('9e5f9bd3a7c89f0eab23949565fb1f72', './lib/wiki-plugins/wikiplugin_files.php', '28.4', 0),
('6a09be9ff71394c98aeb7a0b69a9fbe6', './lib/wiki-plugins/wikiplugin_fitnesse.php', '28.4', 0),
('1427a695df4cc5e1ea93271c60086357', './lib/wiki-plugins/wikiplugin_fluidgrid.php', '28.4', 0),
('03d5cd0194409c6f5bc5b088a91204a5', './lib/wiki-plugins/wikiplugin_font.php', '28.4', 0),
('6513f8721529496d4703394bf83e2840', './lib/wiki-plugins/wikiplugin_footnote.php', '28.4', 0),
('6c0a1030807aa37004dff57e6aa5b8fd', './lib/wiki-plugins/wikiplugin_footnotearea.php', '28.4', 0),
('92a2003e5dcef289044135eac713b073', './lib/wiki-plugins/wikiplugin_freetagged.php', '28.4', 0),
('347f1976a840f0366c262d711ce6d816', './lib/wiki-plugins/wikiplugin_friend.php', '28.4', 0),
('d6394a6fc1b94dc8732ada57a4465600', './lib/wiki-plugins/wikiplugin_ftp.php', '28.4', 0),
('74d2f92acf59648e00e3d0212a2f0592', './lib/wiki-plugins/wikiplugin_fullwidthtitle.php', '28.4', 0),
('4f2eb2c0c6ea4883c8ccc5d41e2dc103', './lib/wiki-plugins/wikiplugin_ganttchart.php', '28.4', 0),
('8fc5d525d24f75b5d86a919c9d9d2ad6', './lib/wiki-plugins/wikiplugin_gauge.php', '28.4', 0),
('41ae08da6e76e0249e1c01e9880fc736', './lib/wiki-plugins/wikiplugin_gdgraph.php', '28.4', 0),
('57226b7f7dfdbf531a8a60ee0e3fb80a', './lib/wiki-plugins/wikiplugin_getaccesstoken.php', '28.4', 0),
('cfc09ba7524a93a021e7e61f31436c07', './lib/wiki-plugins/wikiplugin_googleanalytics.php', '28.4', 0),
('01b5e3b51a3b40ca7f9fa3960bcb0d73', './lib/wiki-plugins/wikiplugin_googlechart.php', '28.4', 0),
('51e4a43e2413e6a6f1efb49ed18007f4', './lib/wiki-plugins/wikiplugin_googledoc.php', '28.4', 0),
('5ed4e5db638af5d085e389ce5c2223ba', './lib/wiki-plugins/wikiplugin_group.php', '28.4', 0),
('4267e5dbb0a4e2f88c7104a63966ece1', './lib/wiki-plugins/wikiplugin_groupedit.php', '28.4', 0),
('4f89206475695fc4a8760c98caaa64b5', './lib/wiki-plugins/wikiplugin_groupexpiry.php', '28.4', 0),
('a9a583438e5a97a59f44f229dd5fe860', './lib/wiki-plugins/wikiplugin_grouplist.php', '28.4', 0),
('14e4cd7561ebe61b0c2396d01afa205a', './lib/wiki-plugins/wikiplugin_groupmailcore.php', '28.4', 0),
('cf6519b8892d6cbc938b778d11d935b0', './lib/wiki-plugins/wikiplugin_groupstat.php', '28.4', 0),
('175a2614aea7525a5e6c6f3ccc8fc68b', './lib/wiki-plugins/wikiplugin_h5p.php', '28.4', 0),
('62089bc23dced73644eff6438119190f', './lib/wiki-plugins/wikiplugin_html.php', '28.4', 0),
('3c8afb4a486eff275c77064c05529c4c', './lib/wiki-plugins/wikiplugin_icon.php', '28.4', 0),
('9207d7eb65f49bc0e4de36da58445906', './lib/wiki-plugins/wikiplugin_iframe.php', '28.4', 0),
('82d93a88c896f10d16deddfb015bdd07', './lib/wiki-plugins/wikiplugin_img.php', '28.4', 0),
('b44290d12d937a0be09f23f49859031c', './lib/wiki-plugins/wikiplugin_include.php', '28.4', 0),
('f637d829c3e194e69106eac449bf66d8', './lib/wiki-plugins/wikiplugin_includetpl.php', '28.4', 0),
('188acfadbdfc5048a50c23d0608b2012', './lib/wiki-plugins/wikiplugin_includeurl.php', '28.4', 0),
('3453492983b011f451eaab703d336a69', './lib/wiki-plugins/wikiplugin_indent.php', '28.4', 0),
('c2a6ae4bea765bd25b3dadf03b9eda9e', './lib/wiki-plugins/wikiplugin_insert.php', '28.4', 0),
('8214bb9a4515a6afc4c4cfd51f84ca1b', './lib/wiki-plugins/wikiplugin_invite.php', '28.4', 0),
('5380808b132a3f32e0b1bf854d2e47bd', './lib/wiki-plugins/wikiplugin_jq.php', '28.4', 0),
('44e96c0593f89f396b60eaaf85b30f0c', './lib/wiki-plugins/wikiplugin_js.php', '28.4', 0),
('2770c447fc5bd4f7b02cf3c626d1c038', './lib/wiki-plugins/wikiplugin_kaltura.php', '28.4', 0),
('6de6083448630879f73062a0092be2f5', './lib/wiki-plugins/wikiplugin_kanban.php', '28.4', 0),
('86d9848ca69ea411eb64b207c88f5406', './lib/wiki-plugins/wikiplugin_lang.php', '28.4', 0),
('57856459eeb9bb79196a9947adf5b7dc', './lib/wiki-plugins/wikiplugin_lastmod.php', '28.4', 0),
('2ef679dab2bd806d097b359412e5597a', './lib/wiki-plugins/wikiplugin_layout.php', '28.4', 0),
('a3832706a1484511f48bf65dad9d997c', './lib/wiki-plugins/wikiplugin_like.php', '28.4', 0),
('265724cc6199d766f06c65e101bed476', './lib/wiki-plugins/wikiplugin_list.php', '28.4', 0),
('de4c20723890745a7dd02e5ccc77bffa', './lib/wiki-plugins/wikiplugin_listexecute.php', '28.4', 0),
('a81ea7f3cf7ada21744b010ece6547f6', './lib/wiki-plugins/wikiplugin_listpages.php', '28.4', 0),
('c4638aa41cee529f9e90d88cd25cc65d', './lib/wiki-plugins/wikiplugin_livesupport.php', '28.4', 0),
('92cff51508d96eaff5568040a82ca34c', './lib/wiki-plugins/wikiplugin_localfiles.php', '28.4', 0),
('fa8de4261c9157a0c34b56f4711c7b9b', './lib/wiki-plugins/wikiplugin_lsdir.php', '28.4', 0),
('4785529300fc28d3b1d6441c31345e8f', './lib/wiki-plugins/wikiplugin_mail.php', '28.4', 0),
('8e1cc67f4709c8a3ecb6a982b2773fb8', './lib/wiki-plugins/wikiplugin_map.php', '28.4', 0),
('28e81b4c5133454f8c91f1e8c65e7fbf', './lib/wiki-plugins/wikiplugin_markdown.php', '28.4', 0),
('0ea26632ef4a6838e6544e6c6a747afe', './lib/wiki-plugins/wikiplugin_mautic.php', '28.4', 0),
('6d0d1b087eb52e059f25911fad75407f', './lib/wiki-plugins/wikiplugin_mcalendar.php', '28.4', 0),
('da96c62cb473aa7db08c88701e10e15f', './lib/wiki-plugins/wikiplugin_mediaplayer.php', '28.4', 0),
('b72ec2764199282718e0b306e2e532c8', './lib/wiki-plugins/wikiplugin_memberlist.php', '28.4', 0),
('fa94b9ffc557a88f8a7fa602a75bb80e', './lib/wiki-plugins/wikiplugin_memberpayment.php', '28.4', 0),
('86b29257ab223a880eb08098acb96cbf', './lib/wiki-plugins/wikiplugin_metatag.php', '28.4', 0),
('7d898c8a7b2000f3925f525fbda6454a', './lib/wiki-plugins/wikiplugin_miniquiz.php', '28.4', 0),
('d5964da1d4d99a830d34c098b5c3315c', './lib/wiki-plugins/wikiplugin_module.php', '28.4', 0),
('1fdae0392044c35c37be702a873dc67e', './lib/wiki-plugins/wikiplugin_modulelist.php', '28.4', 0),
('198a2cf2eafb54a8db51a7a01ae22b51', './lib/wiki-plugins/wikiplugin_mono.php', '28.4', 0),
('6cbacecd4e7cc162e170812a18c390f2', './lib/wiki-plugins/wikiplugin_mouseover.php', '28.4', 0),
('c7f9b87455b7b13ba49835e71ba5ee43', './lib/wiki-plugins/wikiplugin_mwtable.php', '28.4', 0),
('84d35874c6d54769eb360963956fb9e4', './lib/wiki-plugins/wikiplugin_networkcondition.php', '28.4', 0),
('a03aa38926d5c2a2ab86431b878e65ff', './lib/wiki-plugins/wikiplugin_now.php', '28.4', 0),
('2a2e8cd56cb6509cca3b2146748322e4', './lib/wiki-plugins/wikiplugin_objecthits.php', '28.4', 0),
('daa8d93348fc9c556819911138a81683', './lib/wiki-plugins/wikiplugin_objectlink.php', '28.4', 0),
('fbe28c94157e3b2bca8d71f7dd0ca198', './lib/wiki-plugins/wikiplugin_oembed.php', '28.4', 0),
('9786b1648a85fc3d8ccd53f4a74688cb', './lib/wiki-plugins/wikiplugin_package.php', '28.4', 0),
('d18f9352d7e89b98e3dbeb0c449371d3', './lib/wiki-plugins/wikiplugin_pagetabs.php', '28.4', 0),
('7b634954d4a846a9920e1a7117373822', './lib/wiki-plugins/wikiplugin_param.php', '28.4', 0),
('b287f51f1550524984e045cf89661534', './lib/wiki-plugins/wikiplugin_payment.php', '28.4', 0),
('448efac729c09a716cd3fece6cbd7ded', './lib/wiki-plugins/wikiplugin_paymentlist.php', '28.4', 0),
('24129e87dd45e1763c2e4fe05a09c0de', './lib/wiki-plugins/wikiplugin_paypal.php', '28.4', 0),
('2bcf181e5beeb4b7233dc22b836c2904', './lib/wiki-plugins/wikiplugin_pdf.php', '28.4', 0),
('7321e8214c3f9bd1128a919241ea9ce1', './lib/wiki-plugins/wikiplugin_pdfbookmark.php', '28.4', 0),
('df81e64145b6396d64bec4625bfa100c', './lib/wiki-plugins/wikiplugin_pdfpage.php', '28.4', 0),
('e927fa2181bd13285d2cd7812f95b679', './lib/wiki-plugins/wikiplugin_pdfpagebreak.php', '28.4', 0),
('b627d98f810be8fd2a50fbf785069448', './lib/wiki-plugins/wikiplugin_perm.php', '28.4', 0),
('9e53a22739df28c21546da9bb1546fc5', './lib/wiki-plugins/wikiplugin_perspective.php', '28.4', 0),
('0d9431681b32c2bd36a520f4b923ed2b', './lib/wiki-plugins/wikiplugin_pivottable.php', '28.4', 0),
('0d75a816be44e2468e7f08301141a685', './lib/wiki-plugins/wikiplugin_piwik.php', '28.4', 0),
('19be35a3574dcd54a22d9c5e46f86c46', './lib/wiki-plugins/wikiplugin_playscorm.php', '28.4', 0),
('e8e2eed79b311ea6352e69ff7b577e71', './lib/wiki-plugins/wikiplugin_pluginmanager.php', '28.4', 0),
('ef23519840120d9ace409fa67622ac52', './lib/wiki-plugins/wikiplugin_poll.php', '28.4', 0),
('e3b6c49225a1b284ef1d6d828f4749de', './lib/wiki-plugins/wikiplugin_pref.php', '28.4', 0),
('bcfbe097ab0f164a67e91dc186d390a5', './lib/wiki-plugins/wikiplugin_prefdoc.php', '28.4', 0),
('49948fdfceea12efb62780ed642a3c95', './lib/wiki-plugins/wikiplugin_preference.php', '28.4', 0),
('c0b1f52ebdd0f5e2b8cacd7315a702ff', './lib/wiki-plugins/wikiplugin_preview.php', '28.4', 0),
('418756c193c80ae2d69f5f6ee82f66d6', './lib/wiki-plugins/wikiplugin_profile.php', '28.4', 0),
('24f055e1c811dec0ba0417de83b8a9ec', './lib/wiki-plugins/wikiplugin_profilesymbolvalue.php', '28.4', 0),
('062a583cc96fcaa0aea0162d790f90be', './lib/wiki-plugins/wikiplugin_proposal.php', '28.4', 0),
('3867246be4bca0af63020d4889e35060', './lib/wiki-plugins/wikiplugin_qr.php', '28.4', 0),
('479ca93cc4e39c16b2aef7cea331b4ff', './lib/wiki-plugins/wikiplugin_quote.php', '28.4', 0),
('8ea5e5ff593b9dc1f8f0cc8fbb283d63', './lib/wiki-plugins/wikiplugin_r.php', '28.4', 0),
('bb74b44ec1eb7d3a91d449e93cd7446a', './lib/wiki-plugins/wikiplugin_randominclude.php', '28.4', 0),
('8053725653665e18205a8b90dec88254', './lib/wiki-plugins/wikiplugin_rcontent.php', '28.4', 0),
('42e494bc94bcc20cdb3c7c30921760de', './lib/wiki-plugins/wikiplugin_realnamelist.php', '28.4', 0),
('1a72690a43d905a1702663d44c33bd8f', './lib/wiki-plugins/wikiplugin_redirect.php', '28.4', 0),
('a741458f1380bbb22e1eca125c109c19', './lib/wiki-plugins/wikiplugin_regex.php', '28.4', 0),
('b8057b0004c458e0da61f42ca9bcd384', './lib/wiki-plugins/wikiplugin_registermemberpayment.php', '28.4', 0),
('0505cfca0c422c7350ea28e811c3af66', './lib/wiki-plugins/wikiplugin_relations.php', '28.4', 0),
('0302b471a2a3d2ff87cf6f37d1d87330', './lib/wiki-plugins/wikiplugin_remarksbox.php', '28.4', 0),
('e474baffacca2588e9499f704681b5df', './lib/wiki-plugins/wikiplugin_rr.php', '28.4', 0),
('39d924938940cca1931a4c3fd3a06d38', './lib/wiki-plugins/wikiplugin_rss.php', '28.4', 0),
('649851c5691ef12cd2937b87f1fcead9', './lib/wiki-plugins/wikiplugin_scroll.php', '28.4', 0),
('187077a74a1a980b4a5819764bb06635', './lib/wiki-plugins/wikiplugin_semanticsearch.php', '28.4', 0),
('f7cd71fac9866d78d5db42c2c0bdb69f', './lib/wiki-plugins/wikiplugin_sharethis.php', '28.4', 0),
('6d366735aae0695b142bb0c954ca2598', './lib/wiki-plugins/wikiplugin_sheet.php', '28.4', 0),
('8155faefe1f6eab46e297b64c2397ab8', './lib/wiki-plugins/wikiplugin_shopperinfo.php', '28.4', 0),
('1f6af8e1774094dee28f3ff154d6b6ef', './lib/wiki-plugins/wikiplugin_shorten.php', '28.4', 0),
('942f7c07f2e58bb0a9588a6dfaaff9ba', './lib/wiki-plugins/wikiplugin_showpages.php', '28.4', 0),
('7e7ad7c4eb6e767c1ce33998bae44112', './lib/wiki-plugins/wikiplugin_showpref.php', '28.4', 0),
('fc8f5b3518ec5cd7885aad29e18589d7', './lib/wiki-plugins/wikiplugin_showreference.php', '28.4', 0),
('245031082aa69bbf3cd1a0c404dfb472', './lib/wiki-plugins/wikiplugin_sign.php', '28.4', 0),
('c14a5c7da540a2b6d0a61de4dc4642be', './lib/wiki-plugins/wikiplugin_signature.php', '28.4', 0),
('ef59ef47aba9d1c1b4264e175cadb0eb', './lib/wiki-plugins/wikiplugin_skype.php', '28.4', 0),
('171f5354507ce4c45291e970e12e1c69', './lib/wiki-plugins/wikiplugin_slideshow.php', '28.4', 0),
('fcfc529c4207b2c1a10ae7d256ec04a4', './lib/wiki-plugins/wikiplugin_slideshowslide.php', '28.4', 0),
('6db00bb3dd9c8f254c3b5b01a02b73d1', './lib/wiki-plugins/wikiplugin_smarty.php', '28.4', 0),
('a5bb003d578ff7cf8a62f1334dc8ba63', './lib/wiki-plugins/wikiplugin_snarf.php', '28.4', 0),
('d22b328e265be16f9f7e8051a2ad8c1b', './lib/wiki-plugins/wikiplugin_sort.php', '28.4', 0),
('960d2b124e464083fb2753449cdd6392', './lib/wiki-plugins/wikiplugin_split.php', '28.4', 0),
('57ce9b349a885269b028b32dcedd41ca', './lib/wiki-plugins/wikiplugin_sql.php', '28.4', 0),
('36b08c98bca4c36a3b3d83985856a975', './lib/wiki-plugins/wikiplugin_stat.php', '28.4', 0),
('5f5d51ff4af514c7b461dc77a3ed0eb4', './lib/wiki-plugins/wikiplugin_sub.php', '28.4', 0),
('8d687ace4caaaaeb2f83d1e10fb5eeb6', './lib/wiki-plugins/wikiplugin_subscribegroup.php', '28.4', 0),
('2957847e516f346610561a3b4b84da65', './lib/wiki-plugins/wikiplugin_subscribegroups.php', '28.4', 0),
('dec2ef65c37a249c6062675d2c8b01e1', './lib/wiki-plugins/wikiplugin_subscribenewsletter.php', '28.4', 0),
('dcba869209b49fc4ef6011d982242655', './lib/wiki-plugins/wikiplugin_sup.php', '28.4', 0),
('946af48dfdfa90b73190cbe2dc829a00', './lib/wiki-plugins/wikiplugin_survey.php', '28.4', 0),
('209ca9928d69631e2c5f22aa33c48a53', './lib/wiki-plugins/wikiplugin_swiper.php', '28.4', 0),
('31ce4e95a04f238240c42e79645a29a7', './lib/wiki-plugins/wikiplugin_tabs.php', '28.4', 0),
('376e9a11ea23919f525d52ff7c22053a', './lib/wiki-plugins/wikiplugin_tag.php', '28.4', 0),
('595fb85a9a8ae91e7a4bc9bc665a1c3d', './lib/wiki-plugins/wikiplugin_tikidocfromcode.php', '28.4', 0),
('771508baf7cc46cd897f38089529432b', './lib/wiki-plugins/wikiplugin_tikimanager.php', '28.4', 0),
('6a607db0a16fd6012c192563fd4aa375', './lib/wiki-plugins/wikiplugin_tikimanagerclone.php', '28.4', 0),
('1e990eb2296b302bd29cd012b5e42fe9', './lib/wiki-plugins/wikiplugin_tikimanagerupdate.php', '28.4', 0),
('57c1bec2d8001329d194cde0e7241eed', './lib/wiki-plugins/wikiplugin_timeline.php', '28.4', 0),
('72c47e53e8e0943b257aecc870a99dc0', './lib/wiki-plugins/wikiplugin_titlesearch.php', '28.4', 0),
('7064528fab0f33dc2334a84de95bb28e', './lib/wiki-plugins/wikiplugin_toc.php', '28.4', 0),
('72ddf22ec7267d524797354031517818', './lib/wiki-plugins/wikiplugin_together.php', '28.4', 0),
('45f6336035d45a8dba1de55899eaf0fe', './lib/wiki-plugins/wikiplugin_totp.php', '28.4', 0),
('1fa03f4c0224452cecdd4db704c308d0', './lib/wiki-plugins/wikiplugin_tour.php', '28.4', 0),
('6fd86bc344251de43ff6214c94236dbe', './lib/wiki-plugins/wikiplugin_tr.php', '28.4', 0),
('6ed83bbfa7982502fa043142e9279851', './lib/wiki-plugins/wikiplugin_tracker.php', '28.4', 0),
('b65f1c2c07e7d32059bb8c40daf67278', './lib/wiki-plugins/wikiplugin_trackercalendar.php', '28.4', 0),
('d86446a14c69929338cfb475c1dbfd96', './lib/wiki-plugins/wikiplugin_trackercomments.php', '28.4', 0),
('e32a3ca38fbfd96eb7e5ee224bb96ce2', './lib/wiki-plugins/wikiplugin_trackerfilter.php', '28.4', 0),
('94dadd211004e0a9d4445ed8606773ba', './lib/wiki-plugins/wikiplugin_trackerif.php', '28.4', 0),
('27b7ea93c1bdb453ead8a4e9cff7ab90', './lib/wiki-plugins/wikiplugin_trackeritemcopy.php', '28.4', 0),
('e408e3543569268db44cf239f889f594', './lib/wiki-plugins/wikiplugin_trackeritemfield.php', '28.4', 0),
('b7ad81eefd9cbbc30d46075241b4afee', './lib/wiki-plugins/wikiplugin_trackerlist.php', '28.4', 0),
('17a8c64a05f2e8905371ef9bb264e53a', './lib/wiki-plugins/wikiplugin_trackerprefill.php', '28.4', 0),
('7d09c37a3f570240d8411134e7744c7e', './lib/wiki-plugins/wikiplugin_trackerquerytemplate.php', '28.4', 0),
('aacef8e0ce828b3c669dd64d69eefaee', './lib/wiki-plugins/wikiplugin_trackerstat.php', '28.4', 0),
('1c780fc199d37f2ac621bfcf4773ee85', './lib/wiki-plugins/wikiplugin_trackertimeline.php', '28.4', 0),
('fd289076e1e6c92d9140dfecc40035a9', './lib/wiki-plugins/wikiplugin_trackertoggle.php', '28.4', 0),
('179dfc72a2c849df72a285cc76431fbc', './lib/wiki-plugins/wikiplugin_trade.php', '28.4', 0),
('b56d1713581c23e96abf3e75e706e164', './lib/wiki-plugins/wikiplugin_transclude.php', '28.4', 0),
('1862337f89322ae46b7f0ca241aa1738', './lib/wiki-plugins/wikiplugin_translated.php', '28.4', 0),
('2a51844e2a639cf25f2958dc6d6dcd22', './lib/wiki-plugins/wikiplugin_translationof.php', '28.4', 0),
('970f3716f2a07a488a933b04cf4bb4a9', './lib/wiki-plugins/wikiplugin_twitter.php', '28.4', 0),
('15f2ecc7cd5021f7f2c5bff2726da106', './lib/wiki-plugins/wikiplugin_usercount.php', '28.4', 0),
('a461b37aedc7aceacb64aa0202ee004b', './lib/wiki-plugins/wikiplugin_useringroup.php', '28.4', 0),
('95a77ea71d86b232962742339bb196a1', './lib/wiki-plugins/wikiplugin_userlastlogged.php', '28.4', 0),
('bfb09a854c4db46f58684414a324772d', './lib/wiki-plugins/wikiplugin_userlink.php', '28.4', 0),
('8a5fd2c61832ecec8f4ed12fbde8f044', './lib/wiki-plugins/wikiplugin_userlist.php', '28.4', 0),
('1233495de62b3692a87b16d0fa28b036', './lib/wiki-plugins/wikiplugin_userpref.php', '28.4', 0),
('84fb8b090ec90d899a175e2496910efa', './lib/wiki-plugins/wikiplugin_versions.php', '28.4', 0),
('fc61f99b93fff5977ebabf334fe29440', './lib/wiki-plugins/wikiplugin_viewtextfile.php', '28.4', 0),
('a9f14fd95d8bce505dba5fdc7f238fc6', './lib/wiki-plugins/wikiplugin_vimeo.php', '28.4', 0),
('0718a53d63bb098e72b91b6ecde11182', './lib/wiki-plugins/wikiplugin_vote.php', '28.4', 0),
('4ba3dc242b6479e25882b8e215af57fb', './lib/wiki-plugins/wikiplugin_votings.php', '28.4', 0),
('278155dfe5be9bc6531fbf06332dde06', './lib/wiki-plugins/wikiplugin_vue.php', '28.4', 0),
('10dd7281335f7817bab2407021d7c771', './lib/wiki-plugins/wikiplugin_wantedpages.php', '28.4', 0),
('17c268815555ed430f5302250f47cc72', './lib/wiki-plugins/wikiplugin_webdocviewer.php', '28.4', 0),
('b1a91bf955407e571e423a5e6af34566', './lib/wiki-plugins/wikiplugin_webservice.php', '28.4', 0),
('ab6e5ae4554a7b4498d28ecb36aa9287', './lib/wiki-plugins/wikiplugin_wikidiff.php', '28.4', 0),
('7ee054dde0ef214e18131379b7a700a5', './lib/wiki-plugins/wikiplugin_wysiwyg.php', '28.4', 0),
('34b6c4f57794522e9e778421584a74dc', './lib/wiki-plugins/wikiplugin_xmlupdate.php', '28.4', 0),
('3dc63091a97d7dce0a895188bc94daa6', './lib/wiki-plugins/wikiplugin_xmpp.php', '28.4', 0),
('6f4cbe3c0407029e92b3bfa2f50c0bd4', './lib/wiki-plugins/wikiplugin_youtube.php', '28.4', 0),
('6270f475a1005a734cec8ba2fb7bfd7f', './lib/wiki-plugins/wikiplugin_zotero.php', '28.4', 0),
('cd967d6eb978d9d61610476ed3a2be3f', './lib/wiki-plugins/wikiplugin_zoterolist.php', '28.4', 0),
('3efa012529aeea56bfdf68fbaab9ce15', './lib/wiki/editlib.php', '28.4', 0),
('edc44d6756dc9a693f3568973990f715', './lib/wiki/exportlib.php', '28.4', 0),
('6170ba826c7c5e9d9fe0ee0def40fda5', './lib/wiki/flaggedrevisionlib.php', '28.4', 0),
('9d049191ee64cd03c5cbf8c7c150461c', './lib/wiki/histlib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/wiki/index.php', '28.4', 0),
('aaae510ef1cb6cac41b48e564832e5cd', './lib/wiki/pluginslib.php', '28.4', 0),
('fccd9a29739430c7cc06d0c2ae520e68', './lib/wiki/quantifylib.php', '28.4', 0),
('94afd4d444f42b5777368f91a3a4cd64', './lib/wiki/renderlib.php', '28.4', 0),
('f51fa39d3d5de059e0590fd1b3b74f68', './lib/wiki/semanticlib.php', '28.4', 0),
('e46d138f2f4145ab93840b638b988348', './lib/wiki/wikilib.php', '28.4', 0),
('eed77ae201cc69f11c46feafe38f3fe0', './lib/wiki/xmllib.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/wizard/index.php', '28.4', 0),
('157943ac24de0df43d14e3fff934451a', './lib/wizard/pages/admin_advanced.php', '28.4', 0),
('142a42be3ad761bed1993ccedd33ab62', './lib/wizard/pages/admin_auto_toc.php', '28.4', 0),
('2ce07dfe8305c78cbfb493fa3b5136dc', './lib/wizard/pages/admin_category.php', '28.4', 0),
('1d0b344ea551bb8d2fd2a6733040847a', './lib/wizard/pages/admin_community.php', '28.4', 0),
('79c50d1ef3d04b474a470601c589983d', './lib/wizard/pages/admin_date_time.php', '28.4', 0),
('fd75186034a8e464d729284d5a66cb6c', './lib/wizard/pages/admin_editor_type.php', '28.4', 0),
('17b4e1ab984bcdc41b303374349c5f9a', './lib/wizard/pages/admin_features.php', '28.4', 0),
('497bfb3c3f759906e78ef63f21a2bd32', './lib/wizard/pages/admin_files.php', '28.4', 0),
('deeb79aadf4150cca1639066373be908', './lib/wizard/pages/admin_files_storage.php', '28.4', 0),
('a09443ac7f0a259a5e6d5438df64d425', './lib/wizard/pages/admin_language.php', '28.4', 0),
('0d4e4cd2454e7568b3858d866ae1c443', './lib/wizard/pages/admin_login.php', '28.4', 0),
('da3c84bc7dbe57e98228ba915a9af925', './lib/wizard/pages/admin_look_and_feel.php', '28.4', 0),
('6e47329fcc31380e9e594b1c520ba93a', './lib/wizard/pages/admin_namespace.php', '28.4', 0),
('5bc8498ed5397fbfc2b37409bc0bf770', './lib/wizard/pages/admin_search.php', '28.4', 0),
('588a35ebdd4a5c43393760900d6fa4f1', './lib/wizard/pages/admin_structures.php', '28.4', 0),
('8c4192c62cca2434da77ad73199a3f7b', './lib/wizard/pages/admin_text_area.php', '28.4', 0),
('5293dddef56d8ac678c1c9631db961c3', './lib/wizard/pages/admin_wiki.php', '28.4', 0),
('f9408044fb46c8bdd3c624ba4331ed75', './lib/wizard/pages/admin_wizard.php', '28.4', 0),
('2f66fbb5d103cc31e8bd0daf98d3c6f5', './lib/wizard/pages/admin_wizard_completed.php', '28.4', 0),
('2394bc03d531ae5ccd26de15971935ce', './lib/wizard/pages/admin_wysiwyg.php', '28.4', 0),
('f6f8a1032e27bcef03aee1e3aaed5f00', './lib/wizard/pages/changes_doc_page_iframe.php', '28.4', 0),
('159ebb96f62ab458f411ebf3acd054f4', './lib/wizard/pages/changes_new_in_13.php', '28.4', 0),
('06cdc8b924c3c763f950cb8f2456bdfc', './lib/wizard/pages/changes_new_in_14.php', '28.4', 0),
('83478d079dbe0b89b454b50473956cd2', './lib/wizard/pages/changes_new_in_15.php', '28.4', 0),
('8def240364dc0c0f9f4be55458ba756c', './lib/wizard/pages/changes_new_in_16.php', '28.4', 0),
('2f61499f9a091518ede7236e8640785e', './lib/wizard/pages/changes_new_in_17.php', '28.4', 0),
('bde7f4389369ce74eb53814de217f769', './lib/wizard/pages/changes_new_in_18.php', '28.4', 0),
('1416e577eeea39857f21645e488daef6', './lib/wizard/pages/changes_new_in_19.php', '28.4', 0),
('dda335d25b857cd41d41da614f65683b', './lib/wizard/pages/changes_new_in_20.php', '28.4', 0),
('15902c39afed4d0a42d7848c0fc91198', './lib/wizard/pages/changes_new_in_21.php', '28.4', 0),
('1928056df5d9aa6cb9acafc5c2bce11a', './lib/wizard/pages/changes_new_in_22.php', '28.4', 0),
('272788d9bb34b40520656dc31db2fe1f', './lib/wizard/pages/changes_new_in_23.php', '28.4', 0),
('672c790ef94c9ad0fcec7607aa17a3c9', './lib/wizard/pages/changes_new_in_24.php', '28.4', 0),
('c5260b5c08309d3f16b1a2ae74061d31', './lib/wizard/pages/changes_new_in_25.php', '28.4', 0),
('31641def36f789e78f3c8b0947afe9c4', './lib/wizard/pages/changes_new_in_26.php', '28.4', 0),
('846b99ea53e233f33d3eae0a012d3a1c', './lib/wizard/pages/changes_novice_admin_assistance.php', '28.4', 0),
('6f178f5eb8507e4792fc24f72de137c6', './lib/wizard/pages/changes_others.php', '28.4', 0),
('603234fe0ce0b2f6e9afed1e6ef3c456', './lib/wizard/pages/changes_permissions_and_logs.php', '28.4', 0),
('0da77b8d7e5ea54f688780e7f1b02263', './lib/wizard/pages/changes_send_feedback.php', '28.4', 0),
('d80feae31f0121edf2e433b81163a6a1', './lib/wizard/pages/changes_trackers.php', '28.4', 0),
('d0ba481e582a067cbe3b105153ad383c', './lib/wizard/pages/changes_ui.php', '28.4', 0),
('c2c188dbab59c7d37451e41bd358c0a7', './lib/wizard/pages/changes_wizard_completed.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/wizard/pages/index.php', '28.4', 0),
('609a787410d43ce14177217152d5c83d', './lib/wizard/pages/profiles_completed.php', '28.4', 0),
('a18695fedcb446600163eedf1e17c08b', './lib/wizard/pages/profiles_demo_cases_in_project_management.php', '28.4', 0),
('5d53d38d83d1e242e27f4648e73fc903', './lib/wizard/pages/profiles_demo_common_confs.php', '28.4', 0),
('e7f11aaa21e2b4d2d49918e0e5d42995', './lib/wizard/pages/profiles_demo_highly_specialized_confs.php', '28.4', 0),
('deee1ccdc61d0ce6e65cca6ca5afee94', './lib/wizard/pages/profiles_demo_interesting_use_cases.php', '28.4', 0),
('c73966affbff91e80cd2969aa710e1fa', './lib/wizard/pages/profiles_demo_more_advanced_confs.php', '28.4', 0),
('bd413441e56b26729aa6f29a281afc19', './lib/wizard/pages/profiles_demo_other_interesting_use_cases.php', '28.4', 0),
('7a5b22de9c817eaf638eeb57de35d4b6', './lib/wizard/pages/profiles_featured_site_confs.php', '28.4', 0),
('09f1c3efa15d51382e49f58efdb7744c', './lib/wizard/pages/profiles_useful_admin_confs.php', '28.4', 0),
('e3cf1f2410ad6a2d21144605d40d9820', './lib/wizard/pages/profiles_useful_changes_in_display.php', '28.4', 0),
('c54af2ec8f6e286905d02fdacb033441', './lib/wizard/pages/profiles_useful_micro_confs.php', '28.4', 0),
('5d6516dd419286b13f0fd946affa8b41', './lib/wizard/pages/profiles_useful_new_tech_confs.php', '28.4', 0),
('3ad0562dedf7401f34e6dce2f976eb77', './lib/wizard/pages/user_dummy1.php', '28.4', 0),
('ced1426754d46961931fc18196efd4d1', './lib/wizard/pages/user_dummy2.php', '28.4', 0),
('9fa4adf2b3f46511b284c4fe745d028a', './lib/wizard/pages/user_dummy3.php', '28.4', 0),
('c6f4883560ec1255d291971ee4c9e2bc', './lib/wizard/pages/user_preferences_info.php', '28.4', 0),
('1d7af571aa6a434c14e37a24cd37b7f2', './lib/wizard/pages/user_preferences_notifications.php', '28.4', 0),
('e2607334adbfaf7e6be132f4ef3fc848', './lib/wizard/pages/user_preferences_params.php', '28.4', 0),
('81bc65c4657018fb252253215614f3d1', './lib/wizard/pages/user_preferences_reports.php', '28.4', 0),
('6033b2b611c0bc10a20abf94c5c6b8de', './lib/wizard/pages/user_tracker.php', '28.4', 0),
('92a8298c2700aca7fe5218bea55adf13', './lib/wizard/pages/user_wizard.php', '28.4', 0),
('101a8e528e1a0e2e66f8ab58bb34558a', './lib/wizard/pages/user_wizard_completed.php', '28.4', 0),
('2b08b454d0bd601de48f8a4e2f5bacd4', './lib/wizard/wizard.php', '28.4', 0),
('f15b01ba0d002844cb1fa95cfc897421', './lib/wizard/wizardlib.php', '28.4', 0),
('dbde66ef0536cd90fb93b0bd0243f064', './lib/xmpp/ConverseJS.php', '28.4', 0),
('76b90bee1038ceafd0b27cb3c2a5e014', './lib/xmpp/TikiXmppChat.php', '28.4', 0),
('590f8c054eacc61f0d97d1e1ce08858b', './lib/xmpp/TikiXmppPrebind.php', '28.4', 0),
('06b4ac4a77c4e3f8a610500b29197a0b', './lib/xmpp/css/conversejs.css', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/xmpp/css/index.php', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/xmpp/html/index.php', '28.4', 0),
('058be43ba5b1e80619ec7ec15c7d0cad', './lib/xmpp/index.php', '28.4', 0),
('35d97508cec8ddbd9b58860b0f91fb8f', './lib/xmpp/js/conversejs-tiki-oauth.js', '28.4', 0),
('8c21853e4c043031956b7229b22555e1', './lib/xmpp/js/conversejs-tiki.js', '28.4', 0),
('b94766c4a347613e2cf323ca1303b436', './lib/xmpp/js/index.php', '28.4', 0),
('6f4088468b72c997ddb302579dbf11b5', './lib/xmpp/xmpplib.php', '28.4', 0),
('6ff1e7ad2a6c475ae7bf899cecb4b46f', './lib/ziplib.php', '28.4', 0),
('04b5ac49372f106748eb2e3a5f64d3a1', './lib/zoterolib.php', '28.4', 0),
('42184cb5864c8f3b84c3d89c90bd87c3', './list-file_backlinks_ajax.php', '28.4', 0),
('3561e7531eceaf2ce2b4e6833e670897', './list-tracker_field_values_ajax.php', '28.4', 0),
('ccc2af3f6b9d5a63b51b1432ef6cf388', './lists/articles.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './lists/index.php', '28.4', 0),
('230264bd91f310d9a9f66b48a2d582ee', './messu-archive.php', '28.4', 0),
('dfb80f7b1a0b94bbbac40f164d5df5d6', './messu-broadcast.php', '28.4', 0),
('683a215bca327ea159c036c943e61577', './messu-compose.php', '28.4', 0),
('f7c3625977c103849112b7cada1739f7', './messu-mailbox.php', '28.4', 0),
('fa96a55c6923916e7837d9c7866451f0', './messu-read.php', '28.4', 0),
('8a30efa145c6c5521a4184a72785a6f2', './messu-read_archive.php', '28.4', 0),
('e2e51a24d05c06f81fd0b73ffc453ec2', './messu-read_sent.php', '28.4', 0),
('8da6926a1681210542198f94d2dcb49f', './messu-sent.php', '28.4', 0),
('23b16a7bd407f17353c496c775ebea1e', './modules/index.php', '28.4', 0),
('76f582e9fbf21b1676803dd4d726f1be', './modules/mod-func-action_calendar.php', '28.4', 0),
('dbe69ed1bb8ca82bfe338f5f5ab67ba8', './modules/mod-func-action_similarcontent.php', '28.4', 0),
('26940f87bfaebdd3b6862467201cefd2', './modules/mod-func-adminbar.php', '28.4', 0),
('781c366eae0aa8378e52a2c1b9a2ea08', './modules/mod-func-adsense.php', '28.4', 0),
('94e660a95b60904dedb5add9ed3f3621', './modules/mod-func-article_archives.php', '28.4', 0),
('aaa0eb914c5959906bb10b027f590cf5', './modules/mod-func-article_topics.php', '28.4', 0),
('b364f083d9e290d7172acc81752d49e1', './modules/mod-func-articles.php', '28.4', 0),
('d1909918e526a133f37ecf98fa9ac684', './modules/mod-func-assistant.php', '28.4', 0),
('42f01c4a514b6ea1a6d0b194f273bbf5', './modules/mod-func-blog_last_comments.php', '28.4', 0),
('1e6b8a47d96bda2634707de1fa6dbb37', './modules/mod-func-breadcrumb.php', '28.4', 0),
('c4a5c2e2768566be7815baad98477b38', './modules/mod-func-breadcrumbs.php', '28.4', 0),
('94806afc6ab47555a3fea99cd80d8ae1', './modules/mod-func-calendar_new.php', '28.4', 0),
('314c80cac870115b3c3f7b80ff0309bf', './modules/mod-func-cart.php', '28.4', 0),
('b49385bd5fa1e08c142414aa80ff14c0', './modules/mod-func-categories.php', '28.4', 0),
('ad1d2d50de9f4e5a47c9e773d67f1d96', './modules/mod-func-category_transition.php', '28.4', 0),
('0687cf550e64ca804da954a024a0593c', './modules/mod-func-change_category.php', '28.4', 0),
('2f695bb9627a4d6c012d287fa3c85663', './modules/mod-func-collapse.php', '28.4', 0),
('fd86955562d1a1871cdb65fa98978fba', './modules/mod-func-comm_received_objects.php', '28.4', 0),
('069e75fff48ea57e5c4132601ee22cda', './modules/mod-func-contributors.php', '28.4', 0),
('7153a742f24318b34a9d6a34dfe66710', './modules/mod-func-cookiesettings.php', '28.4', 0),
('709ae9079f5d662c0e3bd6d5816f21e7', './modules/mod-func-credits.php', '28.4', 0),
('e308fdb9874816c6793e2d72f769a463', './modules/mod-func-current_activity.php', '28.4', 0),
('6e550316041c5c16301b7fd420f45615', './modules/mod-func-directory_last_sites.php', '28.4', 0),
('d8724e5f6678a59e39a1376a4350fa00', './modules/mod-func-directory_stats.php', '28.4', 0),
('c64479580703dc888dca9b132995fa11', './modules/mod-func-directory_top_sites.php', '28.4', 0),
('ac70e5a438950793725cde9ef5f85095', './modules/mod-func-domain_password.php', '28.4', 0),
('b926177f6358a9f02a0cb9026910d86a', './modules/mod-func-facebook.php', '28.4', 0),
('def65f1ab9ece2a0e2d5a6c642b9eaf1', './modules/mod-func-featured_links.php', '28.4', 0),
('42d756e0fc8918b4eb7b335e6c0a26f3', './modules/mod-func-file_galleries.php', '28.4', 0),
('7ffe5a0b429a012eb7d2ccf2d4c64e2a', './modules/mod-func-forums_best_voted_topics.php', '28.4', 0),
('5c5565da455046109ae997d4bc94e55b', './modules/mod-func-forums_last_posts.php', '28.4', 0),
('5ff931165b86c7aa7f968011fac0f65d', './modules/mod-func-forums_most_commented_forums.php', '28.4', 0),
('cdab01885fb9784e1dfe1742deeb1b7b', './modules/mod-func-forums_most_read_topics.php', '28.4', 0),
('673d6e88857b29ff2dadfd16b0fde883', './modules/mod-func-forums_most_visited_forums.php', '28.4', 0),
('fc0ce954ba2030b4a769cde1c2f3546e', './modules/mod-func-freetag.php', '28.4', 0),
('d409fa2393548876f1c08b98e2758901', './modules/mod-func-freetags_current.php', '28.4', 0),
('fc19d50177c1f0cd7bf22bdcb17b1337', './modules/mod-func-freetags_morelikethis.php', '28.4', 0),
('d980a32088bc4896949c89cb3dad7d62', './modules/mod-func-freetags_most_popular.php', '28.4', 0),
('25e246a2d4999a37e854efbc8ac58073', './modules/mod-func-freetags_prefered.php', '28.4', 0),
('cc27faa830398bb909bdbd43c98895fc', './modules/mod-func-friend_list.php', '28.4', 0),
('1f98e99374ef4269f50cafd62c856ebf', './modules/mod-func-git_detail.php', '28.4', 0),
('ec7b37a3319b8bc619c14b1bf0749a87', './modules/mod-func-google.php', '28.4', 0),
('f3aa444c320dfbd735e3340dc461b060', './modules/mod-func-groups_emulation.php', '28.4', 0),
('984188dd8f71bdb396b458577ed02c86', './modules/mod-func-last_actions.php', '28.4', 0),
('4e46be232cc59e7680872ed98a3cc250', './modules/mod-func-last_blog_posts.php', '28.4', 0),
('94167cc967a857dfa8467d17dedeb687', './modules/mod-func-last_category_objects.php', '28.4', 0),
('a01bc6093e74f4a67efff537579faa21', './modules/mod-func-last_created_blogs.php', '28.4', 0),
('67202dfb2503bc012f48adb5707f8c66', './modules/mod-func-last_created_faqs.php', '28.4', 0),
('c0f1d2661e2820de0a435d438774f21e', './modules/mod-func-last_created_quizzes.php', '28.4', 0),
('5e1d3d48471d3bd0e463fd3f7cfd3728', './modules/mod-func-last_file_galleries.php', '28.4', 0),
('01a7bacf5475e724f9efe12eb7a5f48c', './modules/mod-func-last_files.php', '28.4', 0),
('136134a50cd585286da0a137fd992a1c', './modules/mod-func-last_modif_events.php', '28.4', 0),
('ad1b5c7a2c1b361c3dbfee200a643f3e', './modules/mod-func-last_modif_pages.php', '28.4', 0),
('20afa447732dae38b1d8fd87979569df', './modules/mod-func-last_modified_blogs.php', '28.4', 0),
('76195aa01a4dea4a3bd371cd83f79bb8', './modules/mod-func-last_podcasts.php', '28.4', 0),
('9936c7cd7529d210888d7bd2b5791f70', './modules/mod-func-last_submissions.php', '28.4', 0),
('f1880ad06bca44943b6fdf614fb3010d', './modules/mod-func-last_tracker_comments.php', '28.4', 0),
('4edef97dbf8661c7c377c59b503be03a', './modules/mod-func-last_tracker_items.php', '28.4', 0),
('cfbc5d807e44be64604645463b1c1590', './modules/mod-func-last_validated_faq_questions.php', '28.4', 0),
('044d2f87cb8b33bef2851bce30b9ae79', './modules/mod-func-last_visitors.php', '28.4', 0),
('92b7c41bce057a956dad29c02284ee11', './modules/mod-func-last_youtube_playlist_videos.php', '28.4', 0),
('0ffebcedf5f2b56e7ea5e2c22433b217', './modules/mod-func-list.php', '28.4', 0),
('bdffa08a9f13c803d13c17a53c1dbca6', './modules/mod-func-live_support.php', '28.4', 0),
('55c0c744bc7a0f3a8a53ef1c8e8489b3', './modules/mod-func-loadstats.php', '28.4', 0),
('b2744141e401382188a4fdc36d70c411', './modules/mod-func-locator.php', '28.4', 0),
('d626c340b821652bc9b1a639bb193dc1', './modules/mod-func-login_box.php', '28.4', 0),
('1f38d8499737a990e8c4565374839ff5', './modules/mod-func-logo.php', '28.4', 0),
('8fd50b9e433777105d9abaa05fea4700', './modules/mod-func-map_edit_features.php', '28.4', 0),
('28ae864e1276ba0881cbe330d282a4cc', './modules/mod-func-map_layer_selector.php', '28.4', 0),
('caa8082c263beec5e466664aba7bc4e9', './modules/mod-func-map_mode_selector.php', '28.4', 0),
('1573cc2bc51cff558d0d477e2e02778d', './modules/mod-func-map_search_location.php', '28.4', 0),
('8f87a145d79e3d51efc475d7aeb0f7b5', './modules/mod-func-menu.php', '28.4', 0),
('a8b1f6b69c30fd548527c2bc0ecd9d5b', './modules/mod-func-menupage.php', '28.4', 0),
('939325aa66e22b6242b0c10dc45be2e9', './modules/mod-func-menustructure.php', '28.4', 0),
('1941d1836148cf1a795e82c7006f7606', './modules/mod-func-messages_unread_messages.php', '28.4', 0),
('2ea2f3c01e2a4ccbc26b44c3e9f443a1', './modules/mod-func-minichat.php', '28.4', 0),
('f9629c27062ba0fe9dff466466e7d9a2', './modules/mod-func-months_links.php', '28.4', 0),
('dcd368882fb15b3e18e1c1ee326598ca', './modules/mod-func-most_commented.php', '28.4', 0),
('a260021fc885bfd9e0da68e5b17b1be7', './modules/mod-func-mustread.php', '28.4', 0),
('002bc5b4c03ae3688396623d7b656ca8', './modules/mod-func-notificationlink.php', '28.4', 0),
('03e596de4b2d5f8af39acac41b7d602b', './modules/mod-func-num_submissions.php', '28.4', 0),
('7449ee038f103022e3394e3a5abece24', './modules/mod-func-old_articles.php', '28.4', 0),
('57e5f2f93261e47f62950cce96018542', './modules/mod-func-package.php', '28.4', 0),
('068988aa822d591f698ce09e7ca61a41', './modules/mod-func-pagetop_hero.php', '28.4', 0),
('2ac512c4243d14567f8d0bd59fb327b2', './modules/mod-func-payment_outstanding.php', '28.4', 0),
('bb22cce706159cc5888e78a1a975cfd0', './modules/mod-func-permissions.php', '28.4', 0),
('51907007c854e9e9838567db6d19bff3', './modules/mod-func-perspective.php', '28.4', 0),
('9b5c8a124d21bc6c4b9f87f361d3195e', './modules/mod-func-poweredby.php', '28.4', 0),
('573be2f45d5c38a3cd7ae4009ce3c2ae', './modules/mod-func-quick_edit.php', '28.4', 0),
('b4078f25293e2ba0d3f75262099b6778', './modules/mod-func-quick_search.php', '28.4', 0),
('a520a15c63143501364bd23b981721c4', './modules/mod-func-quickadmin.php', '28.4', 0),
('f61338a70cadf7fe27721d644ca38a1b', './modules/mod-func-random_pages.php', '28.4', 0),
('c16e566c2101395c9729a17c8142abb8', './modules/mod-func-reading_time.php', '28.4', 0),
('2e90ec5e8926f8c171ad69cbd2d40cd5', './modules/mod-func-recordrtc.php', '28.4', 0),
('70ced8d1035ebfed1fdd0d4e50e359f2', './modules/mod-func-register.php', '28.4', 0),
('dfeb4de37edb63c7ef69bd8648e3aaf5', './modules/mod-func-rsslist.php', '28.4', 0),
('12407e05def1a75efbf5b4ed379d4b1b', './modules/mod-func-search.php', '28.4', 0),
('e17bb4b9dd347f36cfb5937bbc0f39ad', './modules/mod-func-search_last_rebuild_stats.php', '28.4', 0),
('79a7495b116d0270079e0607618abb36', './modules/mod-func-search_morelikethis.php', '28.4', 0),
('987f8dd6362f4b4120bc72c84b308e19', './modules/mod-func-search_wiki_page.php', '28.4', 0),
('53c3100aa0618475fdf693ab0292333b', './modules/mod-func-semantic_links.php', '28.4', 0),
('fc0c3f4c2601d5e19b2c175eba2abfb1', './modules/mod-func-share.php', '28.4', 0),
('1a19eea0be4c7d5ca3c839f0c5885cf8', './modules/mod-func-short_url.php', '28.4', 0),
('a74fe14a105c28d0b0c455121cb97675', './modules/mod-func-shoutbox.php', '28.4', 0),
('5ea5c173dc290b4b54ec4d3f10fc9560', './modules/mod-func-since_last_visit.php', '28.4', 0),
('0a6b1b28838b814b0ce0291b4b364d3e', './modules/mod-func-since_last_visit_new.php', '28.4', 0),
('cba9f4b3867a1677298d49f14222dfd1', './modules/mod-func-switch_color_mode.php', '28.4', 0),
('e80ccfbd889fcfbff62a02bb3ad9e224', './modules/mod-func-switch_lang.php', '28.4', 0),
('d5803924cf5835318e9d38da2de9bd55', './modules/mod-func-switch_lang_admin.php', '28.4', 0),
('fabcfcd9dba04ead2230e0be666048a2', './modules/mod-func-switch_theme.php', '28.4', 0),
('428a39aeba7993fbd2829b8223414de6', './modules/mod-func-terminology.php', '28.4', 0),
('88f9ab47ea94d36fe5c3d80d8248755a', './modules/mod-func-tikitests.php', '28.4', 0),
('ef7e5260412d35eec09d8526e35c8af9', './modules/mod-func-top_active_blogs.php', '28.4', 0),
('cc386afdb6d64cf3f94bf95073cb0eda', './modules/mod-func-top_articles.php', '28.4', 0),
('d4d1423b2fd8f006231048c0fc88f530', './modules/mod-func-top_blog_posters.php', '28.4', 0),
('dda253c1bac1fcee6d9be8b849eaa40d', './modules/mod-func-top_file_galleries.php', '28.4', 0),
('ed3d209fddfdc8b87e4fb73a99db984c', './modules/mod-func-top_files.php', '28.4', 0),
('c320c797e7c54ff0b07c92281589abf1', './modules/mod-func-top_forum_posters.php', '28.4', 0),
('603988e21c293c3691a4c03156599e2d', './modules/mod-func-top_objects.php', '28.4', 0),
('ca21e0a298e7985510564fcfeed36748', './modules/mod-func-top_pages.php', '28.4', 0),
('c3819616874bf52d52b1f87e21965dbd', './modules/mod-func-top_quizzes.php', '28.4', 0),
('7d29d80ac1ae20fef88d455d76dba1be', './modules/mod-func-top_visited_blogs.php', '28.4', 0),
('ce0cfe530b58ba242051afc9f6ed3229', './modules/mod-func-top_visited_faqs.php', '28.4', 0),
('e870f8c751416b6b33f81b6b50bc6fed', './modules/mod-func-tracker_input.php', '28.4', 0),
('bb6054dfc4d3370da25e4df4bbba0c8f', './modules/mod-func-trackerhelp.php', '28.4', 0),
('b4beb45660f359d3d25031f6446bed7f', './modules/mod-func-translation.php', '28.4', 0),
('4440ced655e303b6bd09007d52287bed', './modules/mod-func-twitter.php', '28.4', 0),
('5dd62648cdd1f539972463cb45b44eaf', './modules/mod-func-upcoming_events.php', '28.4', 0),
('37fb2610cffec6ceee3e90a305e4d409', './modules/mod-func-user_blogs.php', '28.4', 0),
('04a31e8e27a3795ceac0f3e146292718', './modules/mod-func-user_bookmarks.php', '28.4', 0),
('1c53ce3cce7f5aee26764618e15c1ad8', './modules/mod-func-user_pages.php', '28.4', 0),
('5ba6046eb04c51e5e47f3726932cf91f', './modules/mod-func-user_tasks.php', '28.4', 0),
('ec468348f92516a5b1767e66d3f3cb22', './modules/mod-func-user_tasks_public.php', '28.4', 0),
('028f7e3ed77682de11c4bc5e4354a495', './modules/mod-func-usergroup_tracker.php', '28.4', 0),
('6f4c93d871ce0cbe7478d4ca5680fdcd', './modules/mod-func-users_list.php', '28.4', 0),
('41b1e593f17c1b9f4b72575979648c37', './modules/mod-func-users_own_rank.php', '28.4', 0),
('95178730ec88fc22e60013fd3021b2c5', './modules/mod-func-users_rank.php', '28.4', 0),
('3667f69d5cfe02014f374cee85a2aa33', './modules/mod-func-websearch.php', '28.4', 0),
('8d7b4b653cbeb59a2a0d13d0f4aae732', './modules/mod-func-whats_related.php', '28.4', 0),
('f27a5ca156a663f1f888ade1512a7db9', './modules/mod-func-who_is_there.php', '28.4', 0),
('f231e6b8eb00eb7a2b3e51ad47dbbbbe', './modules/mod-func-wiki_last_comments.php', '28.4', 0),
('dad1038069c0697e2e76b6069b6504af', './modules/mod-func-xmpp.php', '28.4', 0),
('e0ba5356483f6174ce5dd852c028f25e', './modules/mod-func-youtube.php', '28.4', 0),
('db845e5e08b90c8a87a8ab9ff746fb74', './modules/mod-func-zone.php', '28.4', 0),
('824370597eabcc58ef454da0bdf26685', './modules/mod-func-zotero.php', '28.4', 0),
('3933aea9273df6eed4c41f0d66d65093', './node_modules/3d-view/example/demo.js', '28.4', 0),
('d1044a83d79f617acd758ff84f251e8b', './node_modules/3d-view/example/minimal.js', '28.4', 0),
('cd23b3e3c0691d288be50f53e00a972f', './node_modules/3d-view/test/test.js', '28.4', 0),
('95c9a7a760edfff5ba92206d7eab4ec9', './node_modules/3d-view/view.js', '28.4', 0),
('8ae6a8ee5130378b33f215867aeb236d', './node_modules/@ampproject/remapping/dist/remapping.umd.js', '28.4', 0),
('e08794f58ebced7b1706385eda40e5ef', './node_modules/@babel/code-frame/lib/index.js', '28.4', 0),
('91996c7e8749e0a7e5a475ea6ef94202', './node_modules/@babel/compat-data/corejs2-built-ins.js', '28.4', 0),
('bf398dada4a976d9e801a43763e4da8d', './node_modules/@babel/compat-data/corejs3-shipped-proposals.js', '28.4', 0),
('31d64a508173549f7228795a0846d62a', './node_modules/@babel/compat-data/native-modules.js', '28.4', 0),
('c1af3a002647c2ce693603a8161d8167', './node_modules/@babel/compat-data/overlapping-plugins.js', '28.4', 0),
('8af665ab827e2b2049052bf777c37a33', './node_modules/@babel/compat-data/plugin-bugfixes.js', '28.4', 0),
('131cf6ed73ff6a3fff38c4bb1120a897', './node_modules/@babel/compat-data/plugins.js', '28.4', 0),
('02677e000eb58fdcb99fa794792e52c8', './node_modules/@babel/core/lib/config/cache-contexts.js', '28.4', 0),
('084055b495e12ee8ddcd56a2e69089ea', './node_modules/@babel/core/lib/config/caching.js', '28.4', 0),
('c66d9f5674bcfd9a09155b79a26c0993', './node_modules/@babel/core/lib/config/config-chain.js', '28.4', 0),
('bbd244d50ae67a088bedc5ae973d9d9a', './node_modules/@babel/core/lib/config/config-descriptors.js', '28.4', 0),
('380582c32ac4710acfff6ca5b7f9ce15', './node_modules/@babel/core/lib/config/files/configuration.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('1bf27d41afd24f77b6bcd3fba6a1ee63', './node_modules/@babel/core/lib/config/files/index-browser.js', '28.4', 0),
('eeea394adc21208270096e093e1365a3', './node_modules/@babel/core/lib/config/files/index.js', '28.4', 0),
('e9d3c31c4359599adca68dc2e37c1f56', './node_modules/@babel/core/lib/config/files/module-types.js', '28.4', 0),
('121365a71bd7ef1cb708594605b43e30', './node_modules/@babel/core/lib/config/files/package.js', '28.4', 0),
('f4658535adc98cf52d0859d859a457de', './node_modules/@babel/core/lib/config/files/plugins.js', '28.4', 0),
('2c83b0b775a93b1a55538c369f3c3d2d', './node_modules/@babel/core/lib/config/files/types.js', '28.4', 0),
('aaf4b9980b35cec26837ff652fae1f0d', './node_modules/@babel/core/lib/config/files/utils.js', '28.4', 0),
('de0d982e8cae73a988be0545d522fce3', './node_modules/@babel/core/lib/config/full.js', '28.4', 0),
('a563ce0879196e80071e57966fa9e211', './node_modules/@babel/core/lib/config/helpers/config-api.js', '28.4', 0),
('560129c9be1725827efb30ceedc3d046', './node_modules/@babel/core/lib/config/helpers/deep-array.js', '28.4', 0),
('8650840aa32bedf475e9082550fd674d', './node_modules/@babel/core/lib/config/helpers/environment.js', '28.4', 0),
('9e70e51055459ff50f7d2bfba1a6363e', './node_modules/@babel/core/lib/config/index.js', '28.4', 0),
('825cef622feb840a37e67bf2e6f4414e', './node_modules/@babel/core/lib/config/item.js', '28.4', 0),
('35e2b2cec13382e1ebb44d5b491f1448', './node_modules/@babel/core/lib/config/partial.js', '28.4', 0),
('3c8ca8164d3a15ec0a5105aa46d21d98', './node_modules/@babel/core/lib/config/pattern-to-regex.js', '28.4', 0),
('4af0adcc57c0b6b16eaa6d656db41ef9', './node_modules/@babel/core/lib/config/plugin.js', '28.4', 0),
('ef2869b246860b208d573c4bfa2c376c', './node_modules/@babel/core/lib/config/printer.js', '28.4', 0),
('73994ff3db49a2723d63066778dd9727', './node_modules/@babel/core/lib/config/resolve-targets-browser.js', '28.4', 0),
('846a4a5cf72e4f2ebcb7509bb5addfce', './node_modules/@babel/core/lib/config/resolve-targets.js', '28.4', 0),
('b2878cb163519fbf99f32a355db93217', './node_modules/@babel/core/lib/config/util.js', '28.4', 0),
('9e58c086af81a9cdfc96f3c0072ac7ef', './node_modules/@babel/core/lib/config/validation/option-assertions.js', '28.4', 0),
('952cbae45c10b015ae921353f0a65e06', './node_modules/@babel/core/lib/config/validation/options.js', '28.4', 0),
('f2df23815cfec2a842399179455f378c', './node_modules/@babel/core/lib/config/validation/plugins.js', '28.4', 0),
('517ec77366aab7a59262f1b743653170', './node_modules/@babel/core/lib/config/validation/removed.js', '28.4', 0),
('314eba512eecfb1b0347e26c250efb77', './node_modules/@babel/core/lib/errors/config-error.js', '28.4', 0),
('c4579cc3bd18fc9667128fb9b6d84e83', './node_modules/@babel/core/lib/errors/rewrite-stack-trace.js', '28.4', 0),
('66bcf61890a6b6ba3aea02584298d832', './node_modules/@babel/core/lib/gensync-utils/async.js', '28.4', 0),
('0e1866c970db7c636fa51aa1abe3a042', './node_modules/@babel/core/lib/gensync-utils/fs.js', '28.4', 0),
('c739529a2b14f920b9b8f09fe2cc2015', './node_modules/@babel/core/lib/gensync-utils/functional.js', '28.4', 0),
('750f330918f5e816cd625785a410ca7f', './node_modules/@babel/core/lib/index.js', '28.4', 0),
('970e0aa24a65982b0df07b99cde74a7b', './node_modules/@babel/core/lib/parse.js', '28.4', 0),
('01af76fe237fd44bdb1036dc8ceff42f', './node_modules/@babel/core/lib/parser/index.js', '28.4', 0),
('95c13eee377e88a88a31c9072c594493', './node_modules/@babel/core/lib/parser/util/missing-plugin-helper.js', '28.4', 0),
('4e5c360a07515c576c4a9b998dd174cf', './node_modules/@babel/core/lib/tools/build-external-helpers.js', '28.4', 0),
('f09bdb680b2d84ab99e0713fd28093b3', './node_modules/@babel/core/lib/transform-ast.js', '28.4', 0),
('8a3dba71e1cc74df5f9081a294b45119', './node_modules/@babel/core/lib/transform-file-browser.js', '28.4', 0),
('84eca2625625154598a97811b71a8b78', './node_modules/@babel/core/lib/transform-file.js', '28.4', 0),
('aeb9e6b9172de92ca1254991e9d91039', './node_modules/@babel/core/lib/transform.js', '28.4', 0),
('13931faebcf84821f8dfc45d6e5714b0', './node_modules/@babel/core/lib/transformation/block-hoist-plugin.js', '28.4', 0),
('29ada641f7f1088b2a27c02f98d6c1fe', './node_modules/@babel/core/lib/transformation/file/file.js', '28.4', 0),
('1ccdf342215b045c496522db6eb124e0', './node_modules/@babel/core/lib/transformation/file/generate.js', '28.4', 0),
('febed99f0d9c587956bc781c87df756b', './node_modules/@babel/core/lib/transformation/file/merge-map.js', '28.4', 0),
('08eddea734e27d35fe6657a1eebfe83f', './node_modules/@babel/core/lib/transformation/index.js', '28.4', 0),
('e9a6487dca484ee6e31e6a3457e34942', './node_modules/@babel/core/lib/transformation/normalize-file.js', '28.4', 0),
('cd3673461e0fc0b937d7f141d45e4aac', './node_modules/@babel/core/lib/transformation/normalize-opts.js', '28.4', 0),
('4e1e5a6db378e75649fb981789d946f3', './node_modules/@babel/core/lib/transformation/plugin-pass.js', '28.4', 0),
('7e7873d203fbf8135d39a422b5aabaf4', './node_modules/@babel/core/lib/transformation/util/clone-deep.js', '28.4', 0),
('4686b233af681350eec4dd5980a88247', './node_modules/@babel/core/lib/vendor/import-meta-resolve.js', '28.4', 0),
('eb4e282d94eb3fc0cd83014b7ceebf41', './node_modules/@babel/core/node_modules/semver/bin/semver.js', '28.4', 0),
('c1f4573d2526cdbbbc4f2f658dc951f7', './node_modules/@babel/core/node_modules/semver/semver.js', '28.4', 0),
('35dc620d459b797a3a4ea63ab2744da3', './node_modules/@babel/generator/lib/buffer.js', '28.4', 0),
('e6a2db776f29d04bf37eb3bad4ea8fc8', './node_modules/@babel/generator/lib/generators/base.js', '28.4', 0),
('926b8f777214f1c7cbf0892416f0a02f', './node_modules/@babel/generator/lib/generators/classes.js', '28.4', 0),
('cd8a1940893d90fe7c76ae164a83b964', './node_modules/@babel/generator/lib/generators/expressions.js', '28.4', 0),
('887031588bed20557a050f0d534e8c5a', './node_modules/@babel/generator/lib/generators/flow.js', '28.4', 0),
('874c09c7e951adc9a2e1199582fd21de', './node_modules/@babel/generator/lib/generators/index.js', '28.4', 0),
('00c3468f7b0f616400a13feac9268df8', './node_modules/@babel/generator/lib/generators/jsx.js', '28.4', 0),
('416c7eea0c15ad240091552ddc416945', './node_modules/@babel/generator/lib/generators/methods.js', '28.4', 0),
('d7c501e1cc60345b4d8e1af075f90453', './node_modules/@babel/generator/lib/generators/modules.js', '28.4', 0),
('9f05abd0a7e908001d3f6115b12fbb10', './node_modules/@babel/generator/lib/generators/statements.js', '28.4', 0),
('09bb984880764fa97c6cebb2375db620', './node_modules/@babel/generator/lib/generators/template-literals.js', '28.4', 0),
('a3ddb5de133415ff556ac89d2834b915', './node_modules/@babel/generator/lib/generators/types.js', '28.4', 0),
('d15ca414862aad1965520c528c5e2080', './node_modules/@babel/generator/lib/generators/typescript.js', '28.4', 0),
('3b93d8996e3e8faf7533a10867b30bc5', './node_modules/@babel/generator/lib/index.js', '28.4', 0),
('691ca2e5fdd35a0858b14c7527ee03af', './node_modules/@babel/generator/lib/node/index.js', '28.4', 0),
('b0103fba11af18a86ef6673235bbef4d', './node_modules/@babel/generator/lib/node/parentheses.js', '28.4', 0),
('979f3e7678dad3cc61f1f31fb7998abc', './node_modules/@babel/generator/lib/node/whitespace.js', '28.4', 0),
('8a617fb4324a76c932b1216bf52299ce', './node_modules/@babel/generator/lib/printer.js', '28.4', 0),
('da65a1591dabb5f1f23601ccb45b4936', './node_modules/@babel/generator/lib/source-map.js', '28.4', 0),
('f34de4a3cf96df824f64db7654d754ca', './node_modules/@babel/helper-compilation-targets/lib/debug.js', '28.4', 0),
('d50d23f683b5cfc842cc56647151c842', './node_modules/@babel/helper-compilation-targets/lib/filter-items.js', '28.4', 0),
('2bbaa0eab91516081fe2776a9fc9c2b3', './node_modules/@babel/helper-compilation-targets/lib/index.js', '28.4', 0),
('2afbf153856840735c1df3f7d116c583', './node_modules/@babel/helper-compilation-targets/lib/options.js', '28.4', 0),
('c036e3037dd451d95a70e28f89233bd3', './node_modules/@babel/helper-compilation-targets/lib/pretty.js', '28.4', 0),
('ecdf8c681cdfb4024e34c5a11acbcca2', './node_modules/@babel/helper-compilation-targets/lib/targets.js', '28.4', 0),
('ca63739279994c9cd485a8e64e7bd91e', './node_modules/@babel/helper-compilation-targets/lib/utils.js', '28.4', 0),
('48445c2c358dbffce2099aaf18f5a645', './node_modules/@babel/helper-compilation-targets/node_modules/lru-cache/index.js', '28.4', 0),
('eb4e282d94eb3fc0cd83014b7ceebf41', './node_modules/@babel/helper-compilation-targets/node_modules/semver/bin/semver.js', '28.4', 0),
('c1f4573d2526cdbbbc4f2f658dc951f7', './node_modules/@babel/helper-compilation-targets/node_modules/semver/semver.js', '28.4', 0),
('815f2c408219f81bfc71cf9e216480e0', './node_modules/@babel/helper-compilation-targets/node_modules/yallist/iterator.js', '28.4', 0),
('483ea622c4704f6dc92ab509464db95c', './node_modules/@babel/helper-compilation-targets/node_modules/yallist/yallist.js', '28.4', 0),
('4561d710cd40c4833872d2b939deee80', './node_modules/@babel/helper-module-imports/lib/import-builder.js', '28.4', 0),
('ad62b2b79b8a3def673542510e5640e5', './node_modules/@babel/helper-module-imports/lib/import-injector.js', '28.4', 0),
('df57f24cf3a0d69a77be1adb0519122f', './node_modules/@babel/helper-module-imports/lib/index.js', '28.4', 0),
('5faa027aad66399d39dfabf15b95b236', './node_modules/@babel/helper-module-imports/lib/is-module.js', '28.4', 0),
('9a7b84102a947234010c3fb86a66828a', './node_modules/@babel/helper-module-transforms/lib/dynamic-import.js', '28.4', 0),
('09f8a69c9a8554730cacb428a77da6c7', './node_modules/@babel/helper-module-transforms/lib/get-module-name.js', '28.4', 0),
('2917d351c942d32c25b579b1178941dc', './node_modules/@babel/helper-module-transforms/lib/index.js', '28.4', 0),
('f96a15adddd695c0f4846ab4627dc235', './node_modules/@babel/helper-module-transforms/lib/lazy-modules.js', '28.4', 0),
('db6c42529266c2f39a0783a0752f720a', './node_modules/@babel/helper-module-transforms/lib/normalize-and-load-metadata.js', '28.4', 0),
('e5de042ab4e4c45c6d7a1cb49dbf818c', './node_modules/@babel/helper-module-transforms/lib/rewrite-live-references.js', '28.4', 0),
('d5ea84ac296fb46b24e9340ca6bd6f9e', './node_modules/@babel/helper-module-transforms/lib/rewrite-this.js', '28.4', 0),
('a66a06a60c67984b421a2bd3aea63ec5', './node_modules/@babel/helper-simple-access/lib/index.js', '28.4', 0),
('5a9f3a57943f6fb32ae0cb638df9b369', './node_modules/@babel/helper-string-parser/lib/index.js', '28.4', 0),
('bbdeabc03531aceb105bd89f47c37d29', './node_modules/@babel/helper-validator-identifier/lib/identifier.js', '28.4', 0),
('79f552d23cb30cf5865d0237a3aeaeba', './node_modules/@babel/helper-validator-identifier/lib/index.js', '28.4', 0),
('00177e3d4b1a59334f7119694a009b13', './node_modules/@babel/helper-validator-identifier/lib/keyword.js', '28.4', 0),
('6003903b2ed47f3bc14f3e0c5b1403cd', './node_modules/@babel/helper-validator-option/lib/find-suggestion.js', '28.4', 0),
('377d889b9be30790716cb55749f7625b', './node_modules/@babel/helper-validator-option/lib/index.js', '28.4', 0),
('09cb0a783befbca93c53c46e4cd38078', './node_modules/@babel/helper-validator-option/lib/validator.js', '28.4', 0),
('f10c7d9930a6d23150b979e70fa8e72d', './node_modules/@babel/helpers/lib/helpers-generated.js', '28.4', 0),
('d963a65a1698b9ab04e5a2bf96e226ee', './node_modules/@babel/helpers/lib/helpers/AwaitValue.js', '28.4', 0),
('b3a309ef4b8643646a2dc4bd42267ba9', './node_modules/@babel/helpers/lib/helpers/OverloadYield.js', '28.4', 0),
('9cf4c385dc2cbf32a1b486ff9c3d8c23', './node_modules/@babel/helpers/lib/helpers/applyDecoratedDescriptor.js', '28.4', 0),
('b91733b2ff13f36cac4394a6a57bf94c', './node_modules/@babel/helpers/lib/helpers/applyDecs.js', '28.4', 0),
('48af33c12debe68e2aea008175beabb3', './node_modules/@babel/helpers/lib/helpers/applyDecs2203.js', '28.4', 0),
('d89e21a2e47a618824784b5431d62709', './node_modules/@babel/helpers/lib/helpers/applyDecs2203R.js', '28.4', 0),
('2ce1b4b9b17fc3ca3e4c2e79466bb427', './node_modules/@babel/helpers/lib/helpers/applyDecs2301.js', '28.4', 0),
('2c023a554547cbb1fdc48af006b29b01', './node_modules/@babel/helpers/lib/helpers/applyDecs2305.js', '28.4', 0),
('5d377b97f15bb2a4e81afa8d581b28da', './node_modules/@babel/helpers/lib/helpers/applyDecs2311.js', '28.4', 0),
('8f9c003b7586743900b1ddce1878a528', './node_modules/@babel/helpers/lib/helpers/arrayLikeToArray.js', '28.4', 0),
('44550395b4b6c7c87570ac7202670da8', './node_modules/@babel/helpers/lib/helpers/arrayWithHoles.js', '28.4', 0),
('f939ee07866334f7e81a18eda2dbe227', './node_modules/@babel/helpers/lib/helpers/arrayWithoutHoles.js', '28.4', 0),
('fd6f9a23f5f1754d882dddc0c1ce2514', './node_modules/@babel/helpers/lib/helpers/assertClassBrand.js', '28.4', 0),
('cfd22268ce29ee1b3e6b8f684aae8dc7', './node_modules/@babel/helpers/lib/helpers/assertThisInitialized.js', '28.4', 0),
('c71a03956d7b56ea610f60d4fc028e56', './node_modules/@babel/helpers/lib/helpers/asyncGeneratorDelegate.js', '28.4', 0),
('9176de3990516a18634f141157aff819', './node_modules/@babel/helpers/lib/helpers/asyncIterator.js', '28.4', 0),
('d6d0f817b1d19b3b392f18ac247aff9d', './node_modules/@babel/helpers/lib/helpers/asyncToGenerator.js', '28.4', 0),
('5c5f407ed3db4c27b28b633a7baf91f5', './node_modules/@babel/helpers/lib/helpers/awaitAsyncGenerator.js', '28.4', 0),
('44ab4fe8fd20dae1ef78f8693a7ef363', './node_modules/@babel/helpers/lib/helpers/callSuper.js', '28.4', 0),
('09843a7066695c9fb98bcc1ee9149e31', './node_modules/@babel/helpers/lib/helpers/checkInRHS.js', '28.4', 0),
('2a3fc8272dd64921db76c43509d4d8a5', './node_modules/@babel/helpers/lib/helpers/checkPrivateRedeclaration.js', '28.4', 0),
('dbd3f821ff6cbc0b7cf62d64b1a7451b', './node_modules/@babel/helpers/lib/helpers/classApplyDescriptorDestructureSet.js', '28.4', 0),
('7fb733710eed2ebb71571897a71867b2', './node_modules/@babel/helpers/lib/helpers/classApplyDescriptorGet.js', '28.4', 0),
('98fc3f28ff8d60ee2b8e548abde73abd', './node_modules/@babel/helpers/lib/helpers/classApplyDescriptorSet.js', '28.4', 0),
('88887ecb1cccfb1a29a0545ebffe85d0', './node_modules/@babel/helpers/lib/helpers/classCallCheck.js', '28.4', 0),
('8a6bfc7050df358dc874af3a1980938f', './node_modules/@babel/helpers/lib/helpers/classCheckPrivateStaticAccess.js', '28.4', 0),
('fe6b19cbae899401ba554784c0076bbc', './node_modules/@babel/helpers/lib/helpers/classCheckPrivateStaticFieldDescriptor.js', '28.4', 0),
('ca57f1f6e82910ff3c1029406b52fa4d', './node_modules/@babel/helpers/lib/helpers/classExtractFieldDescriptor.js', '28.4', 0),
('42e9366827b995525b4aac6b374ba759', './node_modules/@babel/helpers/lib/helpers/classNameTDZError.js', '28.4', 0),
('4d04bde62161fddeeedee5e3abe93a91', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldDestructureSet.js', '28.4', 0),
('d73e975c2a084c5366046ffcdb512c63', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldGet.js', '28.4', 0),
('5532139dee269212154f83f2537a025c', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldGet2.js', '28.4', 0),
('4ed193c7503953782908121e5e66e26d', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldInitSpec.js', '28.4', 0),
('fc0699e261fade7b84dd11db17a0c057', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldLooseBase.js', '28.4', 0),
('a89ba59cc854d250374f918f45922a64', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldLooseKey.js', '28.4', 0),
('131c00d4b2cf12717301e631a91dff15', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldSet.js', '28.4', 0),
('8dd5fc60e280ba408e566861f62ad511', './node_modules/@babel/helpers/lib/helpers/classPrivateFieldSet2.js', '28.4', 0),
('fbec9ab7a5487da542db3c0b10b35e26', './node_modules/@babel/helpers/lib/helpers/classPrivateGetter.js', '28.4', 0),
('f03a676c2f28edd1a0bd0477da0fc8bd', './node_modules/@babel/helpers/lib/helpers/classPrivateMethodGet.js', '28.4', 0),
('5fed63a83cc2ef6c3e0dbdca03d6111e', './node_modules/@babel/helpers/lib/helpers/classPrivateMethodInitSpec.js', '28.4', 0),
('e8a0a9424dcc931b47be1198d6f8f8eb', './node_modules/@babel/helpers/lib/helpers/classPrivateMethodSet.js', '28.4', 0),
('c6ccc68250279e9ea6d6c35a33fe4be8', './node_modules/@babel/helpers/lib/helpers/classPrivateSetter.js', '28.4', 0),
('769f4e704a299a621c60a51e24937d2f', './node_modules/@babel/helpers/lib/helpers/classStaticPrivateFieldDestructureSet.js', '28.4', 0),
('800b6a52f41b6f20d7e998f841fa51d0', './node_modules/@babel/helpers/lib/helpers/classStaticPrivateFieldSpecGet.js', '28.4', 0),
('80b0cba5a8f9da757b5633b67597e269', './node_modules/@babel/helpers/lib/helpers/classStaticPrivateFieldSpecSet.js', '28.4', 0),
('9be2e539be2fa1a79216c5ab35dc1fc9', './node_modules/@babel/helpers/lib/helpers/classStaticPrivateMethodGet.js', '28.4', 0),
('6cedeb1affc9ff06b87cd3535dd44515', './node_modules/@babel/helpers/lib/helpers/classStaticPrivateMethodSet.js', '28.4', 0),
('7e62780dffa7a9c19f65565d6219e2dd', './node_modules/@babel/helpers/lib/helpers/construct.js', '28.4', 0),
('31f36a29ba08411bc088d54ba532b286', './node_modules/@babel/helpers/lib/helpers/createClass.js', '28.4', 0),
('15a20a0064f834112664d2b61aeda961', './node_modules/@babel/helpers/lib/helpers/createForOfIteratorHelper.js', '28.4', 0),
('131dbfa652546eff22c052470f1c4203', './node_modules/@babel/helpers/lib/helpers/createForOfIteratorHelperLoose.js', '28.4', 0),
('0c2a0556230104b367084558ee42237e', './node_modules/@babel/helpers/lib/helpers/createSuper.js', '28.4', 0),
('ba9262e441fc9e75ee27ae4fd7cbd5f4', './node_modules/@babel/helpers/lib/helpers/decorate.js', '28.4', 0),
('9ea734c5eb2c5451cea167497eb841c8', './node_modules/@babel/helpers/lib/helpers/defaults.js', '28.4', 0),
('d14d72a390b0e702340c301bfff753cf', './node_modules/@babel/helpers/lib/helpers/defineAccessor.js', '28.4', 0),
('c281cab38f36995f3502355336f49249', './node_modules/@babel/helpers/lib/helpers/defineEnumerableProperties.js', '28.4', 0),
('7e19eade2a785a94dd27ec771cfff43f', './node_modules/@babel/helpers/lib/helpers/defineProperty.js', '28.4', 0),
('2193b6bb41ba919d9732dff84ca28f3e', './node_modules/@babel/helpers/lib/helpers/dispose.js', '28.4', 0),
('83266c51ff76dc7c21e0911df6de568f', './node_modules/@babel/helpers/lib/helpers/extends.js', '28.4', 0),
('bf92759dc52a0348c60a361260202799', './node_modules/@babel/helpers/lib/helpers/get.js', '28.4', 0),
('6e0afb07e272c2e26ac88aa3511780b6', './node_modules/@babel/helpers/lib/helpers/getPrototypeOf.js', '28.4', 0),
('93b572daa9908e7deb3f2621d6c0849f', './node_modules/@babel/helpers/lib/helpers/identity.js', '28.4', 0),
('5fb0250e4bd407ed0694def1285c9274', './node_modules/@babel/helpers/lib/helpers/importDeferProxy.js', '28.4', 0),
('b4e001d1ef07e6fc46d98d2161267e33', './node_modules/@babel/helpers/lib/helpers/inherits.js', '28.4', 0),
('69dadcc978a9ae0e2ff50d6d0ab44cb5', './node_modules/@babel/helpers/lib/helpers/inheritsLoose.js', '28.4', 0),
('bc8be8c3c283d92e855454eea4fd43c3', './node_modules/@babel/helpers/lib/helpers/initializerDefineProperty.js', '28.4', 0),
('b9f202091700b7099a6fc332e2518c65', './node_modules/@babel/helpers/lib/helpers/initializerWarningHelper.js', '28.4', 0),
('3622341ccb5afce04649690ee6ca4392', './node_modules/@babel/helpers/lib/helpers/instanceof.js', '28.4', 0),
('e77373d13f18750cf2ed247e8fc3af35', './node_modules/@babel/helpers/lib/helpers/interopRequireDefault.js', '28.4', 0),
('13ed3103a0ff4942248e1f72b577f912', './node_modules/@babel/helpers/lib/helpers/interopRequireWildcard.js', '28.4', 0),
('b66e0815a83a1265efc24830124428e6', './node_modules/@babel/helpers/lib/helpers/isNativeFunction.js', '28.4', 0),
('90dd6f2c276256ddc8a26aeafbe90ddd', './node_modules/@babel/helpers/lib/helpers/isNativeReflectConstruct.js', '28.4', 0),
('51a57eadb55b6c05d7b27c80a1d9a307', './node_modules/@babel/helpers/lib/helpers/iterableToArray.js', '28.4', 0),
('44f5bd648146371e5455498974da4a18', './node_modules/@babel/helpers/lib/helpers/iterableToArrayLimit.js', '28.4', 0),
('6d89ce9d7f90832ae71afa35fd7bcb81', './node_modules/@babel/helpers/lib/helpers/jsx.js', '28.4', 0),
('fafc2d0e973552e9171915e1d124be56', './node_modules/@babel/helpers/lib/helpers/maybeArrayLike.js', '28.4', 0),
('b1974034d2f914f191885ae502275066', './node_modules/@babel/helpers/lib/helpers/newArrowCheck.js', '28.4', 0),
('0a4c935685b62933c183097c4e884afb', './node_modules/@babel/helpers/lib/helpers/nonIterableRest.js', '28.4', 0),
('5ddc2d2b137e0feacc71e3b451ddb66d', './node_modules/@babel/helpers/lib/helpers/nonIterableSpread.js', '28.4', 0),
('ee2aa96d851b7b7e7defe218a5f0d109', './node_modules/@babel/helpers/lib/helpers/nullishReceiverError.js', '28.4', 0),
('84c3305eecc7b24e25fe7071a9328ad5', './node_modules/@babel/helpers/lib/helpers/objectDestructuringEmpty.js', '28.4', 0),
('69c5ce8588b46b12afe87a1e95a51170', './node_modules/@babel/helpers/lib/helpers/objectSpread.js', '28.4', 0),
('fe2fb88bad2c44ee3295f11115dcf360', './node_modules/@babel/helpers/lib/helpers/objectSpread2.js', '28.4', 0),
('b4b0db0d6ed51aa65914277f15a3e64e', './node_modules/@babel/helpers/lib/helpers/objectWithoutProperties.js', '28.4', 0),
('56d8bbb31cdb382724f93fed5c159466', './node_modules/@babel/helpers/lib/helpers/objectWithoutPropertiesLoose.js', '28.4', 0),
('73e641af7d5f9328406ca936ba2a0ef6', './node_modules/@babel/helpers/lib/helpers/possibleConstructorReturn.js', '28.4', 0),
('5843ccae03224592025adde087a771c7', './node_modules/@babel/helpers/lib/helpers/readOnlyError.js', '28.4', 0),
('d17350842b44af15bbc19b3aff1318a3', './node_modules/@babel/helpers/lib/helpers/regeneratorRuntime.js', '28.4', 0),
('b7b6d548627b74f96021978649b01090', './node_modules/@babel/helpers/lib/helpers/set.js', '28.4', 0),
('5c0b6e3e176ac442e32454c3df7d9e6d', './node_modules/@babel/helpers/lib/helpers/setFunctionName.js', '28.4', 0),
('2fe52b961b4a3ce26c49504081764d44', './node_modules/@babel/helpers/lib/helpers/setPrototypeOf.js', '28.4', 0),
('bbb3a880ef224d4f8504477181f08b80', './node_modules/@babel/helpers/lib/helpers/skipFirstGeneratorNext.js', '28.4', 0),
('e89800989b1c4d541f829c7787c7e8b7', './node_modules/@babel/helpers/lib/helpers/slicedToArray.js', '28.4', 0),
('859e4c589d225c37ba4d4823f8a5cbf6', './node_modules/@babel/helpers/lib/helpers/superPropBase.js', '28.4', 0),
('4d518b2fb2fd22f5c8b7ed7002d96143', './node_modules/@babel/helpers/lib/helpers/superPropGet.js', '28.4', 0),
('9c5063785553091ab292540fc7a35a5c', './node_modules/@babel/helpers/lib/helpers/superPropSet.js', '28.4', 0),
('e744c8907b7faf53660256ad40560bce', './node_modules/@babel/helpers/lib/helpers/taggedTemplateLiteral.js', '28.4', 0),
('5c5b719e9e0c25f4e23eb253e03c0e9b', './node_modules/@babel/helpers/lib/helpers/taggedTemplateLiteralLoose.js', '28.4', 0),
('550aee84cc517e6620a37e5341903d24', './node_modules/@babel/helpers/lib/helpers/tdz.js', '28.4', 0),
('9bde6af8d6ac3eb6c67c5debe4aabb87', './node_modules/@babel/helpers/lib/helpers/temporalRef.js', '28.4', 0),
('b85b49bdf9a88a0e3c5accbbd6354cf5', './node_modules/@babel/helpers/lib/helpers/temporalUndefined.js', '28.4', 0),
('1742bcfe707c1476e88163dc654b2f93', './node_modules/@babel/helpers/lib/helpers/toArray.js', '28.4', 0),
('616c0cc57fa2760ea95283aa8f76dc3b', './node_modules/@babel/helpers/lib/helpers/toConsumableArray.js', '28.4', 0),
('ab97a1e59f201894f8f156a5c29b4937', './node_modules/@babel/helpers/lib/helpers/toPrimitive.js', '28.4', 0),
('c7f8e6c61efb3df555af163338b5cd5b', './node_modules/@babel/helpers/lib/helpers/toPropertyKey.js', '28.4', 0),
('95608d99acf05914ea37ac65f63466c9', './node_modules/@babel/helpers/lib/helpers/toSetter.js', '28.4', 0),
('54855d4238803693f0e950be64ffa11b', './node_modules/@babel/helpers/lib/helpers/typeof.js', '28.4', 0),
('e1fc4085c9a133db8a1ddff813e44587', './node_modules/@babel/helpers/lib/helpers/unsupportedIterableToArray.js', '28.4', 0),
('6edd0c22cb2a82ca6b868618358e4dc4', './node_modules/@babel/helpers/lib/helpers/using.js', '28.4', 0),
('66468883a93b293236425b1cb1913c36', './node_modules/@babel/helpers/lib/helpers/usingCtx.js', '28.4', 0),
('0308e7712649c9e566e990fac002d46a', './node_modules/@babel/helpers/lib/helpers/wrapAsyncGenerator.js', '28.4', 0),
('07b2e41bdbc9c431f9288647e36eeb3a', './node_modules/@babel/helpers/lib/helpers/wrapNativeSuper.js', '28.4', 0),
('b2172832d6404293ac6d1d30539d1e7c', './node_modules/@babel/helpers/lib/helpers/wrapRegExp.js', '28.4', 0),
('81186b681b7042b0e4929c2cc865028c', './node_modules/@babel/helpers/lib/helpers/writeOnlyError.js', '28.4', 0),
('8c6d369c36d15c8e5d5c7041d246d92d', './node_modules/@babel/helpers/lib/index.js', '28.4', 0),
('968813412349a919e7d0163ca4e2dd86', './node_modules/@babel/helpers/scripts/build-helper-metadata.js', '28.4', 0),
('72a790fd8da1d80dd525261b43ec8049', './node_modules/@babel/helpers/scripts/generate-helpers.js', '28.4', 0),
('7b0cd4452e9f0aa8bf2c7d41a51d1d2d', './node_modules/@babel/helpers/scripts/generate-regenerator-runtime.js', '28.4', 0),
('aa1d852df533f615deccd691ea87825f', './node_modules/@babel/highlight/lib/index.js', '28.4', 0),
('746f0fd174c4c54a26dfe0b5ef52c25e', './node_modules/@babel/highlight/node_modules/ansi-styles/index.js', '28.4', 0),
('bb573269345dcfe1ad7b10a6db19ee9f', './node_modules/@babel/highlight/node_modules/chalk/index.js', '28.4', 0),
('4b69ee87432f991d3f1f1e90d5facd1e', './node_modules/@babel/highlight/node_modules/chalk/templates.js', '28.4', 0),
('1e739864ba89e9876b4a06d1105c3f15', './node_modules/@babel/highlight/node_modules/color-convert/conversions.js', '28.4', 0),
('3dd0a1f66c1d90dd2692e1bfa7eeb05a', './node_modules/@babel/highlight/node_modules/color-convert/index.js', '28.4', 0),
('ec324515d5dff142da623cfca2c08c01', './node_modules/@babel/highlight/node_modules/color-convert/route.js', '28.4', 0),
('405840ec3052209f357288fe4c0f4414', './node_modules/@babel/highlight/node_modules/color-name/index.js', '28.4', 0),
('4d018d689a1a257a1c4e09bb296dbb9e', './node_modules/@babel/highlight/node_modules/color-name/test.js', '28.4', 0),
('7b366c6d23641eabb9d8f46fa9008535', './node_modules/@babel/highlight/node_modules/escape-string-regexp/index.js', '28.4', 0),
('a5a0a76afed750bf24321951974305f9', './node_modules/@babel/highlight/node_modules/has-flag/index.js', '28.4', 0),
('eb4c64679962222ba7791179667eef6f', './node_modules/@babel/highlight/node_modules/supports-color/browser.js', '28.4', 0),
('9a855ec52971bd5501058217723a4ebc', './node_modules/@babel/highlight/node_modules/supports-color/index.js', '28.4', 0),
('11050c1a46fb8b470f28bec167769dd9', './node_modules/@babel/parser/bin/babel-parser.js', '28.4', 0),
('85f4ebb634ebe01b60dd92e0494a767d', './node_modules/@babel/parser/lib/index.js', '28.4', 0),
('95d2e0fbac8cb3322a191bc4ba7465db', './node_modules/@babel/runtime/helpers/AwaitValue.js', '28.4', 0),
('a94b88c40d711d1297fe90f415af61f0', './node_modules/@babel/runtime/helpers/OverloadYield.js', '28.4', 0),
('2e0cbb81984f0152e9196d8db56f94fd', './node_modules/@babel/runtime/helpers/applyDecoratedDescriptor.js', '28.4', 0),
('2e625626b2f65ae7c291c553610f7ea3', './node_modules/@babel/runtime/helpers/applyDecs.js', '28.4', 0),
('8c177a637798d7c82212cf8d9f6d915e', './node_modules/@babel/runtime/helpers/applyDecs2203.js', '28.4', 0),
('6f8d15832b91e44fe38cfb8c69d63356', './node_modules/@babel/runtime/helpers/applyDecs2203R.js', '28.4', 0),
('74706deef4f1b1ad6538d3fd82654dad', './node_modules/@babel/runtime/helpers/applyDecs2301.js', '28.4', 0),
('fcad38d7d282267b21987166ef52a291', './node_modules/@babel/runtime/helpers/applyDecs2305.js', '28.4', 0),
('1a948517067a963788085c5de1c81633', './node_modules/@babel/runtime/helpers/applyDecs2311.js', '28.4', 0),
('b5b38821498e7766012002faea598b9a', './node_modules/@babel/runtime/helpers/arrayLikeToArray.js', '28.4', 0),
('4a9238bbbd1b4d8f3cc1d9eecb571f18', './node_modules/@babel/runtime/helpers/arrayWithHoles.js', '28.4', 0),
('de8a0074f488a61fc148ccd619c368bc', './node_modules/@babel/runtime/helpers/arrayWithoutHoles.js', '28.4', 0),
('486c80329f8ee0f1d9d7f02af79b68fb', './node_modules/@babel/runtime/helpers/assertClassBrand.js', '28.4', 0),
('c7738195638cefa0c95a0a650439f14f', './node_modules/@babel/runtime/helpers/assertThisInitialized.js', '28.4', 0),
('ce89d7e48ef308eb436a4c8adbef0201', './node_modules/@babel/runtime/helpers/asyncGeneratorDelegate.js', '28.4', 0),
('c42d649b4ec47ebd80bc1726b61bac08', './node_modules/@babel/runtime/helpers/asyncIterator.js', '28.4', 0),
('68ba4375bfc70601a953f3e2086530ee', './node_modules/@babel/runtime/helpers/asyncToGenerator.js', '28.4', 0),
('4ce2d513eb82b06be2e05a11d9b365ae', './node_modules/@babel/runtime/helpers/awaitAsyncGenerator.js', '28.4', 0),
('1d99c3b9f291551d43dbbe17a708290b', './node_modules/@babel/runtime/helpers/callSuper.js', '28.4', 0),
('4bd2237b41bef815efd9382354ba038d', './node_modules/@babel/runtime/helpers/checkInRHS.js', '28.4', 0),
('26e88c98306a73325e3fb40198614e13', './node_modules/@babel/runtime/helpers/checkPrivateRedeclaration.js', '28.4', 0),
('10370b64f22bd316c0bf4c36c08f7050', './node_modules/@babel/runtime/helpers/classApplyDescriptorDestructureSet.js', '28.4', 0),
('a07db895ebec42d626a8828aa3886890', './node_modules/@babel/runtime/helpers/classApplyDescriptorGet.js', '28.4', 0),
('27b5fa108dc3c4d79e59448b007fcb91', './node_modules/@babel/runtime/helpers/classApplyDescriptorSet.js', '28.4', 0),
('0c7ba2d8e33fab28ecb550e2a6e18a7f', './node_modules/@babel/runtime/helpers/classCallCheck.js', '28.4', 0),
('3593c64f09546b7bb033fef62f5eacc4', './node_modules/@babel/runtime/helpers/classCheckPrivateStaticAccess.js', '28.4', 0),
('20f46ef708176a3eae8a24f1e78744f1', './node_modules/@babel/runtime/helpers/classCheckPrivateStaticFieldDescriptor.js', '28.4', 0),
('3ab4a35130c864a2c89c4dfbd7b426da', './node_modules/@babel/runtime/helpers/classExtractFieldDescriptor.js', '28.4', 0),
('10d5398ad7330688be168a7cfc2d51f8', './node_modules/@babel/runtime/helpers/classNameTDZError.js', '28.4', 0),
('0958d906ca96f48ba1ff48d1ce2b89b2', './node_modules/@babel/runtime/helpers/classPrivateFieldDestructureSet.js', '28.4', 0),
('d6f008fee8a32678cd871846ba714376', './node_modules/@babel/runtime/helpers/classPrivateFieldGet.js', '28.4', 0),
('1aedf48f08475404aa697327a0c7ca00', './node_modules/@babel/runtime/helpers/classPrivateFieldGet2.js', '28.4', 0),
('b430f8f255b7ff78da5d1c25dcd21926', './node_modules/@babel/runtime/helpers/classPrivateFieldInitSpec.js', '28.4', 0),
('e295aebc8c5e72f35676aaa7af1ff4c9', './node_modules/@babel/runtime/helpers/classPrivateFieldLooseBase.js', '28.4', 0),
('06f2025627439f7b2dee25acf8fcf7ed', './node_modules/@babel/runtime/helpers/classPrivateFieldLooseKey.js', '28.4', 0),
('8cab35c06d29d231106182cb3a90ef53', './node_modules/@babel/runtime/helpers/classPrivateFieldSet.js', '28.4', 0),
('0cf8b1e3b607fcc916b4d6fe441d6ab1', './node_modules/@babel/runtime/helpers/classPrivateFieldSet2.js', '28.4', 0),
('29b4a847919d09efca36e6aaea16161f', './node_modules/@babel/runtime/helpers/classPrivateGetter.js', '28.4', 0),
('7606419d30db7bb6746c47f2ece89c12', './node_modules/@babel/runtime/helpers/classPrivateMethodGet.js', '28.4', 0),
('01c783a57f9a341fe19a960b836d25d5', './node_modules/@babel/runtime/helpers/classPrivateMethodInitSpec.js', '28.4', 0),
('a7fcd9b602551b2d48befbdbd39de677', './node_modules/@babel/runtime/helpers/classPrivateMethodSet.js', '28.4', 0),
('85cbd2acd8eef0dad9484b983b61997f', './node_modules/@babel/runtime/helpers/classPrivateSetter.js', '28.4', 0),
('f2778a5e0a815086ddad73d3600f5c40', './node_modules/@babel/runtime/helpers/classStaticPrivateFieldDestructureSet.js', '28.4', 0),
('f790f85341b2e2d93ddde47070129c10', './node_modules/@babel/runtime/helpers/classStaticPrivateFieldSpecGet.js', '28.4', 0),
('dbfb93739b96b9193a45eeb5dd72c71a', './node_modules/@babel/runtime/helpers/classStaticPrivateFieldSpecSet.js', '28.4', 0),
('c75bfc73f1c07e95a2a67dfc198d111f', './node_modules/@babel/runtime/helpers/classStaticPrivateMethodGet.js', '28.4', 0),
('98b69550f959d01f1b87f3940baa086f', './node_modules/@babel/runtime/helpers/classStaticPrivateMethodSet.js', '28.4', 0),
('02857a4b2e490b84b0a530ca76be81c5', './node_modules/@babel/runtime/helpers/construct.js', '28.4', 0),
('7b42f949b86738f7e94dc56a0700950b', './node_modules/@babel/runtime/helpers/createClass.js', '28.4', 0),
('b5a7144c49345a7a6b8991d9f9b87b33', './node_modules/@babel/runtime/helpers/createForOfIteratorHelper.js', '28.4', 0),
('384c771b0471598a41a5b3d2e716fe36', './node_modules/@babel/runtime/helpers/createForOfIteratorHelperLoose.js', '28.4', 0),
('dd609a8cf48317a76aa5780a5d1d3c4f', './node_modules/@babel/runtime/helpers/createSuper.js', '28.4', 0),
('1ef7badbc6cda46e454ec1704c41f2dc', './node_modules/@babel/runtime/helpers/decorate.js', '28.4', 0),
('3caf7cef88c523ac5b92cffae67f54f7', './node_modules/@babel/runtime/helpers/defaults.js', '28.4', 0),
('27237e4b460d8a9b23713a34d93560d7', './node_modules/@babel/runtime/helpers/defineAccessor.js', '28.4', 0),
('a16b3200a7190e32af82660ccaf922ce', './node_modules/@babel/runtime/helpers/defineEnumerableProperties.js', '28.4', 0),
('d2a774c7057442313316cd962ca6da46', './node_modules/@babel/runtime/helpers/defineProperty.js', '28.4', 0),
('ca7d7296860dfdabbfe0b8b0fd15be0d', './node_modules/@babel/runtime/helpers/dispose.js', '28.4', 0),
('5d24e121cac71378fba2fe01d83c3d83', './node_modules/@babel/runtime/helpers/esm/AwaitValue.js', '28.4', 0),
('0c037588c16326aad70142ece7ac0407', './node_modules/@babel/runtime/helpers/esm/OverloadYield.js', '28.4', 0),
('b3eafcc9002c622df3e44b262604b75e', './node_modules/@babel/runtime/helpers/esm/applyDecoratedDescriptor.js', '28.4', 0),
('245d7299d9ca2b6e9fdbad9cceb2f9d9', './node_modules/@babel/runtime/helpers/esm/applyDecs.js', '28.4', 0),
('880b3a217020f95a9e02419c47207c5e', './node_modules/@babel/runtime/helpers/esm/applyDecs2203.js', '28.4', 0),
('2d44c3bb5408e57f142c82d5146cc517', './node_modules/@babel/runtime/helpers/esm/applyDecs2203R.js', '28.4', 0),
('baa93803dc67326e74a8f4436e97a2c8', './node_modules/@babel/runtime/helpers/esm/applyDecs2301.js', '28.4', 0),
('5966010e16aa227205a168f491a0aa45', './node_modules/@babel/runtime/helpers/esm/applyDecs2305.js', '28.4', 0),
('baef04d22cfa730d2dec45e89ce894f9', './node_modules/@babel/runtime/helpers/esm/applyDecs2311.js', '28.4', 0),
('9c1d6602ec7313ad62995a4520733184', './node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js', '28.4', 0),
('132f06c9a6fe5b3862c6bea5acdeb258', './node_modules/@babel/runtime/helpers/esm/arrayWithHoles.js', '28.4', 0),
('0658134c21737b69f6e8a8d1a380e0b3', './node_modules/@babel/runtime/helpers/esm/arrayWithoutHoles.js', '28.4', 0),
('1a395bfb3b2cae5c40561a24298228c7', './node_modules/@babel/runtime/helpers/esm/assertClassBrand.js', '28.4', 0),
('231e450aee70af220f18b8567e5a2dcb', './node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js', '28.4', 0),
('1f6af4a12c6e2c601a0ef6e55e2db24d', './node_modules/@babel/runtime/helpers/esm/asyncGeneratorDelegate.js', '28.4', 0),
('31c17b625cc3ec8e4415386536bd896c', './node_modules/@babel/runtime/helpers/esm/asyncIterator.js', '28.4', 0),
('0b0212a9c7b45393a9888c991c9185d6', './node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js', '28.4', 0),
('d48ae1a6a3692807b0f58bbedda83def', './node_modules/@babel/runtime/helpers/esm/awaitAsyncGenerator.js', '28.4', 0),
('cb7ded019ec1fc1006f153d58629a6a6', './node_modules/@babel/runtime/helpers/esm/callSuper.js', '28.4', 0),
('bcc615edac0927f11023902416eeffec', './node_modules/@babel/runtime/helpers/esm/checkInRHS.js', '28.4', 0),
('61c605884a78ad22619b70576344ff9a', './node_modules/@babel/runtime/helpers/esm/checkPrivateRedeclaration.js', '28.4', 0),
('9afd9085fa2b81a389300a20a26f8a10', './node_modules/@babel/runtime/helpers/esm/classApplyDescriptorDestructureSet.js', '28.4', 0),
('3392ffa243a6f607d926bab30dd6d9ab', './node_modules/@babel/runtime/helpers/esm/classApplyDescriptorGet.js', '28.4', 0),
('ae55f6753ef254ab65bfddadebe3183c', './node_modules/@babel/runtime/helpers/esm/classApplyDescriptorSet.js', '28.4', 0),
('d77354b1f0e4203f47533aa5d065c07c', './node_modules/@babel/runtime/helpers/esm/classCallCheck.js', '28.4', 0),
('e7796ee9c0e7e6130cf78cee2bc47356', './node_modules/@babel/runtime/helpers/esm/classCheckPrivateStaticAccess.js', '28.4', 0),
('acd17f1b79b174462784702cd9ec2e86', './node_modules/@babel/runtime/helpers/esm/classCheckPrivateStaticFieldDescriptor.js', '28.4', 0),
('7401335816422994d8e82d63c9401cdb', './node_modules/@babel/runtime/helpers/esm/classExtractFieldDescriptor.js', '28.4', 0),
('8ff0d354f8a980b68570a1e50479ca60', './node_modules/@babel/runtime/helpers/esm/classNameTDZError.js', '28.4', 0),
('d7dd4be1dce9275ccb5dc61eb4a396d7', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldDestructureSet.js', '28.4', 0),
('b0eb645f84973e55a700b55ae303e305', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldGet.js', '28.4', 0),
('4fc4e796273aa391b4a37439258bec89', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldGet2.js', '28.4', 0),
('da6593d274da4b95ac265ee8d05cd0a2', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldInitSpec.js', '28.4', 0),
('41965f1940339be80c45185bc222c751', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldLooseBase.js', '28.4', 0),
('21bd5c0afc861ec5b685047e168aa02c', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldLooseKey.js', '28.4', 0),
('62efc2fcc1eb185f34f12c72bb55f6cc', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldSet.js', '28.4', 0),
('07aa571c4f880e07f126f4f96eec6dea', './node_modules/@babel/runtime/helpers/esm/classPrivateFieldSet2.js', '28.4', 0),
('726bbf819aa70387fd013928c3895759', './node_modules/@babel/runtime/helpers/esm/classPrivateGetter.js', '28.4', 0),
('673a977dc41f2d6a8ff239b8bb2f73e5', './node_modules/@babel/runtime/helpers/esm/classPrivateMethodGet.js', '28.4', 0),
('61d894847c25b1df461f8ab2a1336aa3', './node_modules/@babel/runtime/helpers/esm/classPrivateMethodInitSpec.js', '28.4', 0),
('605e58a4edaacf1bb759e5fdeeed9aab', './node_modules/@babel/runtime/helpers/esm/classPrivateMethodSet.js', '28.4', 0),
('da50b4fcce8c23b6e40292fa989ffa1b', './node_modules/@babel/runtime/helpers/esm/classPrivateSetter.js', '28.4', 0),
('3a2be23df88b0b1c569daddb7a0e47a6', './node_modules/@babel/runtime/helpers/esm/classStaticPrivateFieldDestructureSet.js', '28.4', 0),
('a8933818a358a900d8331a4a04643865', './node_modules/@babel/runtime/helpers/esm/classStaticPrivateFieldSpecGet.js', '28.4', 0),
('fa4bdede2edc8649447828b5f652f60a', './node_modules/@babel/runtime/helpers/esm/classStaticPrivateFieldSpecSet.js', '28.4', 0),
('7f0854c7712206a0af03e0d8592bc754', './node_modules/@babel/runtime/helpers/esm/classStaticPrivateMethodGet.js', '28.4', 0),
('b35abc834857861554e45df9c5c0d012', './node_modules/@babel/runtime/helpers/esm/classStaticPrivateMethodSet.js', '28.4', 0),
('04ca765f7383807d4a083e8d9898e5b0', './node_modules/@babel/runtime/helpers/esm/construct.js', '28.4', 0),
('866b6a2ab48d40f3d1c8e786f0b41a85', './node_modules/@babel/runtime/helpers/esm/createClass.js', '28.4', 0),
('3a0ed0af719938f666d11c6ce48d18bc', './node_modules/@babel/runtime/helpers/esm/createForOfIteratorHelper.js', '28.4', 0),
('14564cfbc0c7b942f933653dbec1795c', './node_modules/@babel/runtime/helpers/esm/createForOfIteratorHelperLoose.js', '28.4', 0),
('bb529ff4521649c5382a03a91a422d5b', './node_modules/@babel/runtime/helpers/esm/createSuper.js', '28.4', 0),
('61d17c1309f5a3980c3566284b2d9fce', './node_modules/@babel/runtime/helpers/esm/decorate.js', '28.4', 0),
('60383b70ca69134eb3c4f86aee8f81c3', './node_modules/@babel/runtime/helpers/esm/defaults.js', '28.4', 0),
('671fca86615c8a3de19caed004c94548', './node_modules/@babel/runtime/helpers/esm/defineAccessor.js', '28.4', 0),
('25180184f432f6e9e4d87c6183703c4a', './node_modules/@babel/runtime/helpers/esm/defineEnumerableProperties.js', '28.4', 0),
('9a4b0fa812067066ca8de79995e55602', './node_modules/@babel/runtime/helpers/esm/defineProperty.js', '28.4', 0),
('afab8a0e082ec7a53682bacffb0fa1e2', './node_modules/@babel/runtime/helpers/esm/dispose.js', '28.4', 0),
('301c402c063f2cb2293b06aed6b049d9', './node_modules/@babel/runtime/helpers/esm/extends.js', '28.4', 0),
('93c0b56d7b7720645b677ff1fc956e79', './node_modules/@babel/runtime/helpers/esm/get.js', '28.4', 0),
('09eb757794e761eaea1492413c61d421', './node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js', '28.4', 0),
('cb77483f81c9f355f362a58f63121609', './node_modules/@babel/runtime/helpers/esm/identity.js', '28.4', 0),
('e1dbd5493a752fc33eac5f3599895e7d', './node_modules/@babel/runtime/helpers/esm/importDeferProxy.js', '28.4', 0),
('3586160ecc21c7d6ba72bf7b6ef55370', './node_modules/@babel/runtime/helpers/esm/inherits.js', '28.4', 0),
('668f6c18dfebcdb8f2a50182c3a8ecdb', './node_modules/@babel/runtime/helpers/esm/inheritsLoose.js', '28.4', 0),
('4bb19452d172c429bb047faf5ff0a346', './node_modules/@babel/runtime/helpers/esm/initializerDefineProperty.js', '28.4', 0),
('c2f4b86305a4365e0c8cdb72ad554199', './node_modules/@babel/runtime/helpers/esm/initializerWarningHelper.js', '28.4', 0),
('80a81bc49dea86e0834149377857e2a3', './node_modules/@babel/runtime/helpers/esm/instanceof.js', '28.4', 0),
('b5951b52bfcd112b60b473e3b77843ce', './node_modules/@babel/runtime/helpers/esm/interopRequireDefault.js', '28.4', 0),
('35e1be3b1f171f37135e4339dd6b58c6', './node_modules/@babel/runtime/helpers/esm/interopRequireWildcard.js', '28.4', 0),
('b7b209dbcf201bca4e7b26ab985498a2', './node_modules/@babel/runtime/helpers/esm/isNativeFunction.js', '28.4', 0),
('28d2cf0ce9282b46260296d1b6862866', './node_modules/@babel/runtime/helpers/esm/isNativeReflectConstruct.js', '28.4', 0),
('c83557334d16727b5283c92334d13b9d', './node_modules/@babel/runtime/helpers/esm/iterableToArray.js', '28.4', 0),
('984fefdab51e7eeea3a27fe0076248f7', './node_modules/@babel/runtime/helpers/esm/iterableToArrayLimit.js', '28.4', 0),
('a97a7016d326fb8d01f43e090b73edd5', './node_modules/@babel/runtime/helpers/esm/jsx.js', '28.4', 0),
('59fb0b5e9872cf8baff7abc3a874d2fd', './node_modules/@babel/runtime/helpers/esm/maybeArrayLike.js', '28.4', 0),
('7cd5ffa1786ffdbf52a77c233571a9e4', './node_modules/@babel/runtime/helpers/esm/newArrowCheck.js', '28.4', 0),
('630259b9419d195b26db745ddb094bd4', './node_modules/@babel/runtime/helpers/esm/nonIterableRest.js', '28.4', 0),
('e4548adde45434aa2b17236bf81c3375', './node_modules/@babel/runtime/helpers/esm/nonIterableSpread.js', '28.4', 0),
('ac9a28338c959bdf91e8b9333cba0947', './node_modules/@babel/runtime/helpers/esm/nullishReceiverError.js', '28.4', 0),
('5bd533c1f18f98c124d706f84215cc80', './node_modules/@babel/runtime/helpers/esm/objectDestructuringEmpty.js', '28.4', 0),
('9d21bb6780565e74bea13e9bc21a4ed6', './node_modules/@babel/runtime/helpers/esm/objectSpread.js', '28.4', 0),
('308ed03568800b5a6fd3cb436d5285f4', './node_modules/@babel/runtime/helpers/esm/objectSpread2.js', '28.4', 0),
('940edae172e084fcc796e37b0050b6bc', './node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js', '28.4', 0),
('0e07057042247011975bb04be785e663', './node_modules/@babel/runtime/helpers/esm/objectWithoutPropertiesLoose.js', '28.4', 0),
('e7980396983854a9c2c7d28125f68883', './node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js', '28.4', 0),
('6917b367eda210be57f0ffff20086e99', './node_modules/@babel/runtime/helpers/esm/readOnlyError.js', '28.4', 0),
('5b680436d5b9feafe5831d68c2595588', './node_modules/@babel/runtime/helpers/esm/regeneratorRuntime.js', '28.4', 0),
('6e095170d6ae7750b313ea4288a8825d', './node_modules/@babel/runtime/helpers/esm/set.js', '28.4', 0),
('8dba65e4415077ae2e0ce2874a5bec03', './node_modules/@babel/runtime/helpers/esm/setFunctionName.js', '28.4', 0),
('4469ee721158cdbba6620e0de0b13406', './node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js', '28.4', 0),
('b054b02adee90ae936cac8fa263747ac', './node_modules/@babel/runtime/helpers/esm/skipFirstGeneratorNext.js', '28.4', 0),
('15d9202c527d914c5f43eee313bcc706', './node_modules/@babel/runtime/helpers/esm/slicedToArray.js', '28.4', 0),
('4ea2f5dd4f3866d177005749845a3be8', './node_modules/@babel/runtime/helpers/esm/superPropBase.js', '28.4', 0),
('4d0573ed2bcc9edd2640e8321c6eb401', './node_modules/@babel/runtime/helpers/esm/superPropGet.js', '28.4', 0),
('d3337f8a410b1e39325cf39b1e94cf3e', './node_modules/@babel/runtime/helpers/esm/superPropSet.js', '28.4', 0),
('b05e23ccf1705e7a1425b80053e66680', './node_modules/@babel/runtime/helpers/esm/taggedTemplateLiteral.js', '28.4', 0),
('b6bb214915247586dc9e95f0f1322286', './node_modules/@babel/runtime/helpers/esm/taggedTemplateLiteralLoose.js', '28.4', 0),
('209d9da4151c7d35805c569398cc8733', './node_modules/@babel/runtime/helpers/esm/tdz.js', '28.4', 0),
('35f6f8ecaca26dc6170882a1d39655e2', './node_modules/@babel/runtime/helpers/esm/temporalRef.js', '28.4', 0),
('110b7c2168c7e64e5325d34a089f434d', './node_modules/@babel/runtime/helpers/esm/temporalUndefined.js', '28.4', 0),
('ceb9fa771ae0d18d99b3ba35eaeb4e1b', './node_modules/@babel/runtime/helpers/esm/toArray.js', '28.4', 0),
('1a9f62c3e99bb6ed8789668d4ecaa972', './node_modules/@babel/runtime/helpers/esm/toConsumableArray.js', '28.4', 0),
('f8869c407a2022ff090b66ea9cd2e286', './node_modules/@babel/runtime/helpers/esm/toPrimitive.js', '28.4', 0),
('b9e2b83bc2d1858d21891bfb2f10bd80', './node_modules/@babel/runtime/helpers/esm/toPropertyKey.js', '28.4', 0),
('f1d823818bedb4af708c8425a8c47a56', './node_modules/@babel/runtime/helpers/esm/toSetter.js', '28.4', 0),
('164d16f14e1bb6ff5334c4ee6a7dcd25', './node_modules/@babel/runtime/helpers/esm/typeof.js', '28.4', 0),
('78373f375168e1f77f4fd222108d0a56', './node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js', '28.4', 0),
('372f3b76f3720be6dec4335d92959370', './node_modules/@babel/runtime/helpers/esm/using.js', '28.4', 0),
('d7e5a4833e3ef4930c2b187744e42e43', './node_modules/@babel/runtime/helpers/esm/usingCtx.js', '28.4', 0),
('3552ba5ac5e865f700f60712e73ebd67', './node_modules/@babel/runtime/helpers/esm/wrapAsyncGenerator.js', '28.4', 0),
('a9c6364c0dcbd8e7273861304ffec225', './node_modules/@babel/runtime/helpers/esm/wrapNativeSuper.js', '28.4', 0),
('29075b53b5bb5660122234ef700d0ffb', './node_modules/@babel/runtime/helpers/esm/wrapRegExp.js', '28.4', 0),
('f372f8eccead0bb08c3ecad3b0c8aea4', './node_modules/@babel/runtime/helpers/esm/writeOnlyError.js', '28.4', 0),
('dbb97ce812eea68a4cdb70b59c53a5e7', './node_modules/@babel/runtime/helpers/extends.js', '28.4', 0),
('7691197b9f07d05795d9bfffc3b55aee', './node_modules/@babel/runtime/helpers/get.js', '28.4', 0),
('85aac71f02c3962d68cc9f9a2d5e1178', './node_modules/@babel/runtime/helpers/getPrototypeOf.js', '28.4', 0),
('917a87edb043621ed4c45fb6156484ce', './node_modules/@babel/runtime/helpers/identity.js', '28.4', 0),
('dcf32384f62569ebc462e9d8d1f0270f', './node_modules/@babel/runtime/helpers/importDeferProxy.js', '28.4', 0),
('10e0301e66a79114bc35b09e956aef55', './node_modules/@babel/runtime/helpers/inherits.js', '28.4', 0),
('aa444eb626a1f31476d180f3e2e7e6c5', './node_modules/@babel/runtime/helpers/inheritsLoose.js', '28.4', 0),
('8206e3b2c8761c2ab974782bb352fda2', './node_modules/@babel/runtime/helpers/initializerDefineProperty.js', '28.4', 0),
('d78946b9749b9f31ea6560bf1fd64fbf', './node_modules/@babel/runtime/helpers/initializerWarningHelper.js', '28.4', 0),
('20b99b428128d43bcad439df735fa6a6', './node_modules/@babel/runtime/helpers/instanceof.js', '28.4', 0),
('83f7ac32b1e7655518f52f67059f65b2', './node_modules/@babel/runtime/helpers/interopRequireDefault.js', '28.4', 0),
('35a3ef8ca03036d085a137d8cd36498a', './node_modules/@babel/runtime/helpers/interopRequireWildcard.js', '28.4', 0),
('c9e0919c41b8922248498c757543149f', './node_modules/@babel/runtime/helpers/isNativeFunction.js', '28.4', 0),
('261f30d4fbdd32fd2fe357db39013e3c', './node_modules/@babel/runtime/helpers/isNativeReflectConstruct.js', '28.4', 0),
('f77bec80b758ed482b815693e71d15ad', './node_modules/@babel/runtime/helpers/iterableToArray.js', '28.4', 0),
('21febd921734fc413ac39f20146492d3', './node_modules/@babel/runtime/helpers/iterableToArrayLimit.js', '28.4', 0),
('e026abbc512e765ae114b913065c5654', './node_modules/@babel/runtime/helpers/jsx.js', '28.4', 0),
('70e72ce9294fccbc5fcc9c63775ccef3', './node_modules/@babel/runtime/helpers/maybeArrayLike.js', '28.4', 0),
('f73571ab43892f5c37826d2ea942bdb1', './node_modules/@babel/runtime/helpers/newArrowCheck.js', '28.4', 0),
('bca88ffa6f6f344f91b5e020379ec1aa', './node_modules/@babel/runtime/helpers/nonIterableRest.js', '28.4', 0),
('a2f5c44263dddcf743767e798b2dc9bd', './node_modules/@babel/runtime/helpers/nonIterableSpread.js', '28.4', 0),
('f24f4e28b0d89806167e6e494583193b', './node_modules/@babel/runtime/helpers/nullishReceiverError.js', '28.4', 0),
('0a777fb1c095a697cbe970f857b1ffb9', './node_modules/@babel/runtime/helpers/objectDestructuringEmpty.js', '28.4', 0),
('d9b0c966a2e98b4b44c3bd4be02fd65e', './node_modules/@babel/runtime/helpers/objectSpread.js', '28.4', 0),
('6757d51f89f094f7b0b44249701887c2', './node_modules/@babel/runtime/helpers/objectSpread2.js', '28.4', 0),
('82e1d89b10b2e087bff5acde62b62fca', './node_modules/@babel/runtime/helpers/objectWithoutProperties.js', '28.4', 0),
('d5fba7e781f48a53eb01f99862ef2750', './node_modules/@babel/runtime/helpers/objectWithoutPropertiesLoose.js', '28.4', 0),
('926ed424fee540682dd4869bdf217c24', './node_modules/@babel/runtime/helpers/possibleConstructorReturn.js', '28.4', 0),
('8f0f2e919083eeac5682fc43cd2bb872', './node_modules/@babel/runtime/helpers/readOnlyError.js', '28.4', 0),
('67e401771da0ffd9f85dd74fd4b58dd8', './node_modules/@babel/runtime/helpers/regeneratorRuntime.js', '28.4', 0),
('8afe8cb2976a46c43c08abb3c7c54e3c', './node_modules/@babel/runtime/helpers/set.js', '28.4', 0),
('29b5acbeb73c821b08d79930c21a3523', './node_modules/@babel/runtime/helpers/setFunctionName.js', '28.4', 0),
('7ceca34292ec71c5d4d20cda7e3789ca', './node_modules/@babel/runtime/helpers/setPrototypeOf.js', '28.4', 0),
('a9aa50d7214bbf12a29bfb04ca51147d', './node_modules/@babel/runtime/helpers/skipFirstGeneratorNext.js', '28.4', 0),
('21e985ec1cc63133a20c41b940602085', './node_modules/@babel/runtime/helpers/slicedToArray.js', '28.4', 0),
('09f1c21af6833328c02e87c0f2672717', './node_modules/@babel/runtime/helpers/superPropBase.js', '28.4', 0),
('cada96962a8d26fa77f4dca2701d9e27', './node_modules/@babel/runtime/helpers/superPropGet.js', '28.4', 0),
('57332bc52cb026c1af4aba4ca97b6934', './node_modules/@babel/runtime/helpers/superPropSet.js', '28.4', 0),
('ea56f26b43fed9442f1c8a9e44dff62a', './node_modules/@babel/runtime/helpers/taggedTemplateLiteral.js', '28.4', 0),
('30dd898beb3ef2cc0674375486238237', './node_modules/@babel/runtime/helpers/taggedTemplateLiteralLoose.js', '28.4', 0),
('0eaa6dba45dca95de2c02a02a33fce0e', './node_modules/@babel/runtime/helpers/tdz.js', '28.4', 0),
('f293a73bdde56e5307c9235cf22ccb2e', './node_modules/@babel/runtime/helpers/temporalRef.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('b87935e8b114dc0361e9e0d6a9e257d4', './node_modules/@babel/runtime/helpers/temporalUndefined.js', '28.4', 0),
('06b08c2e1cc3fdfb021e2a9dc1614140', './node_modules/@babel/runtime/helpers/toArray.js', '28.4', 0),
('a297e487abaf6609bf72aef6fc827215', './node_modules/@babel/runtime/helpers/toConsumableArray.js', '28.4', 0),
('d524f62bb007f67b395941a1533eae23', './node_modules/@babel/runtime/helpers/toPrimitive.js', '28.4', 0),
('0eb192021878c8ec307082ff33b54030', './node_modules/@babel/runtime/helpers/toPropertyKey.js', '28.4', 0),
('31375c8d7a3fb671265e5bf2f5ce8961', './node_modules/@babel/runtime/helpers/toSetter.js', '28.4', 0),
('cee65db762de3393e8dd76939f655f74', './node_modules/@babel/runtime/helpers/typeof.js', '28.4', 0),
('eb0783be6db70cc381acac4460214f2b', './node_modules/@babel/runtime/helpers/unsupportedIterableToArray.js', '28.4', 0),
('5c2c7b5bbdf4d807d3d267d92fc03233', './node_modules/@babel/runtime/helpers/using.js', '28.4', 0),
('35bc45b13cdb44b2943286b4592d77d7', './node_modules/@babel/runtime/helpers/usingCtx.js', '28.4', 0),
('7dcb1933046f6ea232765725890ede0a', './node_modules/@babel/runtime/helpers/wrapAsyncGenerator.js', '28.4', 0),
('352fde191641d71b2e56344ee711ef8f', './node_modules/@babel/runtime/helpers/wrapNativeSuper.js', '28.4', 0),
('a07730818a58d4d5794c4ea44136423f', './node_modules/@babel/runtime/helpers/wrapRegExp.js', '28.4', 0),
('26af513ebde88ab0081ecf0dede2e765', './node_modules/@babel/runtime/helpers/writeOnlyError.js', '28.4', 0),
('e171f6736dd83b508df59e8bc77d93f5', './node_modules/@babel/runtime/regenerator/index.js', '28.4', 0),
('9f28e4427fff8cb0fbea37549799831a', './node_modules/@babel/template/lib/builder.js', '28.4', 0),
('25616cb807d9c0e1636cc6e6b04a81e1', './node_modules/@babel/template/lib/formatters.js', '28.4', 0),
('365301d9af93c2c91f0b9ab7ed93e02e', './node_modules/@babel/template/lib/index.js', '28.4', 0),
('1476a81a36f390280f54a87cfc19dffd', './node_modules/@babel/template/lib/literal.js', '28.4', 0),
('df8b152523a1381673e9b08fc5b4cd76', './node_modules/@babel/template/lib/options.js', '28.4', 0),
('20c1407eb4b63d1ce5b0787b16c06032', './node_modules/@babel/template/lib/parse.js', '28.4', 0),
('b15df3d0a80bd58afb1b9eaf54070fac', './node_modules/@babel/template/lib/populate.js', '28.4', 0),
('a410f27d68955de49430a3a47bce7f39', './node_modules/@babel/template/lib/string.js', '28.4', 0),
('338f0218c9514bfc1961870adf963c38', './node_modules/@babel/traverse/lib/cache.js', '28.4', 0),
('d6ad7118d24ef658f838ba81ff94d8c8', './node_modules/@babel/traverse/lib/context.js', '28.4', 0),
('355b6aca3940a3a4552435ad33bc5a76', './node_modules/@babel/traverse/lib/hub.js', '28.4', 0),
('fe9a168e96067902642d07796a34f1b5', './node_modules/@babel/traverse/lib/index.js', '28.4', 0),
('79fa4711127197325d170fe29089d536', './node_modules/@babel/traverse/lib/path/ancestry.js', '28.4', 0),
('5d80d66cb6f1fb4b3684fa4745914f05', './node_modules/@babel/traverse/lib/path/comments.js', '28.4', 0),
('1112abfe7e1d378ae08fedad81bb313f', './node_modules/@babel/traverse/lib/path/context.js', '28.4', 0),
('1f3a98405d7e005c832164cafe8bdc4a', './node_modules/@babel/traverse/lib/path/conversion.js', '28.4', 0),
('62344f03c7ba0931b808b3dee1ec0b27', './node_modules/@babel/traverse/lib/path/evaluation.js', '28.4', 0),
('23808c1d5c1463b6b32bb16067672df9', './node_modules/@babel/traverse/lib/path/family.js', '28.4', 0),
('804fbb3fcc02883a63ee27dca6afc015', './node_modules/@babel/traverse/lib/path/index.js', '28.4', 0),
('46e26cb6b24f4f7bccc40f493893c3ed', './node_modules/@babel/traverse/lib/path/inference/index.js', '28.4', 0),
('17a71b0f87933ef935bcf2f8d8d56822', './node_modules/@babel/traverse/lib/path/inference/inferer-reference.js', '28.4', 0),
('369960427a46436936afd95341843222', './node_modules/@babel/traverse/lib/path/inference/inferers.js', '28.4', 0),
('1f4d2df81efb7faaa5b05744e1a4e8c9', './node_modules/@babel/traverse/lib/path/inference/util.js', '28.4', 0),
('bd33227ace3631815d6038284389cdfa', './node_modules/@babel/traverse/lib/path/introspection.js', '28.4', 0),
('5768412c2543d6b617ee84787d5acc26', './node_modules/@babel/traverse/lib/path/lib/hoister.js', '28.4', 0),
('8f538c34d323262043d90ce22327303f', './node_modules/@babel/traverse/lib/path/lib/removal-hooks.js', '28.4', 0),
('67be544c4dc37a2b0d6bb5868834d774', './node_modules/@babel/traverse/lib/path/lib/virtual-types-validator.js', '28.4', 0),
('0f8206cca07f6964b58f04cac81977e2', './node_modules/@babel/traverse/lib/path/lib/virtual-types.js', '28.4', 0),
('d8c17c9d91240bc8c575182138aaa086', './node_modules/@babel/traverse/lib/path/modification.js', '28.4', 0),
('76afe570b50039e0a96e00ec65500b23', './node_modules/@babel/traverse/lib/path/removal.js', '28.4', 0),
('c74a8f4f60080226eae34be675c2ae9b', './node_modules/@babel/traverse/lib/path/replacement.js', '28.4', 0),
('ffb711cb1cb48da18c7cbc7e9b9f8946', './node_modules/@babel/traverse/lib/scope/binding.js', '28.4', 0),
('36b3aa05e180ffbfd798463d07aee8db', './node_modules/@babel/traverse/lib/scope/index.js', '28.4', 0),
('0080c94be6a5401f0e2bab139c317cc8', './node_modules/@babel/traverse/lib/scope/lib/renamer.js', '28.4', 0),
('fe816ec7968c46b03d4320da07e0a3a1', './node_modules/@babel/traverse/lib/traverse-node.js', '28.4', 0),
('b66fd614fa91138eaa193989c169b315', './node_modules/@babel/traverse/lib/types.js', '28.4', 0),
('1f02f37462bf381963723f735f4d74b5', './node_modules/@babel/traverse/lib/visitors.js', '28.4', 0),
('3e3a6be0a398d188e14e631562b99e8a', './node_modules/@babel/traverse/node_modules/globals/index.js', '28.4', 0),
('42cc69fec777e51cc00ad9db991b0406', './node_modules/@babel/types/lib/asserts/assertNode.js', '28.4', 0),
('aaa64972176dbe495290e18458957b31', './node_modules/@babel/types/lib/asserts/generated/index.js', '28.4', 0),
('1f800638531cfe4826e24d47d78c7fbf', './node_modules/@babel/types/lib/ast-types/generated/index.js', '28.4', 0),
('b342228a7831e4bc13924e39ae74f54f', './node_modules/@babel/types/lib/builders/flow/createFlowUnionType.js', '28.4', 0),
('0a80c346bfb7de898b0d1a034336a663', './node_modules/@babel/types/lib/builders/flow/createTypeAnnotationBasedOnTypeof.js', '28.4', 0),
('1ed17560caa29fb51615a7385475e209', './node_modules/@babel/types/lib/builders/generated/index.js', '28.4', 0),
('bedceab518051f7d844bc4a50b70f156', './node_modules/@babel/types/lib/builders/generated/uppercase.js', '28.4', 0),
('0425e2ad76ef35afdeac16ed6f00a8ea', './node_modules/@babel/types/lib/builders/productions.js', '28.4', 0),
('94f4f68f71057e105568455a450da65e', './node_modules/@babel/types/lib/builders/react/buildChildren.js', '28.4', 0),
('5db68bb7d2ddd7e2ef46f03065d1cafe', './node_modules/@babel/types/lib/builders/typescript/createTSUnionType.js', '28.4', 0),
('b4c95b2842455d5a3b6fe55f2a781874', './node_modules/@babel/types/lib/builders/validateNode.js', '28.4', 0),
('c44686fc35f7c0e9e40bd9ed247d4082', './node_modules/@babel/types/lib/clone/clone.js', '28.4', 0),
('c05747e957962641fad6543643dfba48', './node_modules/@babel/types/lib/clone/cloneDeep.js', '28.4', 0),
('f78c06d6c70fea70d351b83f49eec554', './node_modules/@babel/types/lib/clone/cloneDeepWithoutLoc.js', '28.4', 0),
('16af21efacea21077f65ba66ca75d639', './node_modules/@babel/types/lib/clone/cloneNode.js', '28.4', 0),
('a9e9f61fa9a9e8b8d75884c9b86d9219', './node_modules/@babel/types/lib/clone/cloneWithoutLoc.js', '28.4', 0),
('0f585a933ff928f31ae1ef5bad06978a', './node_modules/@babel/types/lib/comments/addComment.js', '28.4', 0),
('50cd028427d57086f85008e0fb73bee9', './node_modules/@babel/types/lib/comments/addComments.js', '28.4', 0),
('6712f026472cb9c2762e25178db803ae', './node_modules/@babel/types/lib/comments/inheritInnerComments.js', '28.4', 0),
('d6c97e402231c720fddb5694ba889039', './node_modules/@babel/types/lib/comments/inheritLeadingComments.js', '28.4', 0),
('0f0d2d56c2f00b6516a50ccccc9a3fc2', './node_modules/@babel/types/lib/comments/inheritTrailingComments.js', '28.4', 0),
('0f6cc66c26b3b51a6f66b4b7c0b93667', './node_modules/@babel/types/lib/comments/inheritsComments.js', '28.4', 0),
('ed2c19d200fd9da73b42b2c6fd662d6c', './node_modules/@babel/types/lib/comments/removeComments.js', '28.4', 0),
('7322e369abc84f7e12440e5db355ba0d', './node_modules/@babel/types/lib/constants/generated/index.js', '28.4', 0),
('fcbdf018685d84ab393f82030e9d9033', './node_modules/@babel/types/lib/constants/index.js', '28.4', 0),
('9cd612859e0b28065a2413b121cb41f5', './node_modules/@babel/types/lib/converters/ensureBlock.js', '28.4', 0),
('903e6979efc2544b54993236c0242c5d', './node_modules/@babel/types/lib/converters/gatherSequenceExpressions.js', '28.4', 0),
('d1402687f4f6a9b3106a786accfe0948', './node_modules/@babel/types/lib/converters/toBindingIdentifierName.js', '28.4', 0),
('00f5bb8dc315495b190efdef059ead4f', './node_modules/@babel/types/lib/converters/toBlock.js', '28.4', 0),
('bce4aa10c069523cd84737e297c4d23d', './node_modules/@babel/types/lib/converters/toComputedKey.js', '28.4', 0),
('13563aa7aac8db55bae3b2fc28e5b1ab', './node_modules/@babel/types/lib/converters/toExpression.js', '28.4', 0),
('12c0ec7ce6d3b071436e3fc212e487f8', './node_modules/@babel/types/lib/converters/toIdentifier.js', '28.4', 0),
('de170f8dce21fbdb5da54084e422ff29', './node_modules/@babel/types/lib/converters/toKeyAlias.js', '28.4', 0),
('79e64e5b118841ebc836eb0df8cd38cc', './node_modules/@babel/types/lib/converters/toSequenceExpression.js', '28.4', 0),
('f1fc7fb577d7e63e1dadd1460010e720', './node_modules/@babel/types/lib/converters/toStatement.js', '28.4', 0),
('0c54c98e2f8bf042b5f3321514c74d4e', './node_modules/@babel/types/lib/converters/valueToNode.js', '28.4', 0),
('965b42f8ea4bc7a5ce06ef25cb6d1145', './node_modules/@babel/types/lib/definitions/core.js', '28.4', 0),
('f38804ab8bc428012765fa4578cac734', './node_modules/@babel/types/lib/definitions/deprecated-aliases.js', '28.4', 0),
('30f11e4bb74763bc1513fe4033689ebf', './node_modules/@babel/types/lib/definitions/experimental.js', '28.4', 0),
('65cd787203913cca4d9784de92e33258', './node_modules/@babel/types/lib/definitions/flow.js', '28.4', 0),
('a02120e6c7e5875df17fbf28bdfebd42', './node_modules/@babel/types/lib/definitions/index.js', '28.4', 0),
('c55fb85f1622024c1bfccd5ad695086e', './node_modules/@babel/types/lib/definitions/jsx.js', '28.4', 0),
('9775bf1b47266bcf15d069b595888d1d', './node_modules/@babel/types/lib/definitions/misc.js', '28.4', 0),
('60df0e747f56a78310271ade260689c6', './node_modules/@babel/types/lib/definitions/placeholders.js', '28.4', 0),
('817202df817d7d78919b6f0fd5313adc', './node_modules/@babel/types/lib/definitions/typescript.js', '28.4', 0),
('07d8023ae864797183b0984679b61787', './node_modules/@babel/types/lib/definitions/utils.js', '28.4', 0),
('dc71709700199c753392da2d93eacc60', './node_modules/@babel/types/lib/index.js', '28.4', 0),
('b1ec54bd5d2c8e39ce8070736aed73e5', './node_modules/@babel/types/lib/modifications/appendToMemberExpression.js', '28.4', 0),
('2f2d21b2f33c59c20bffe7bba6800b90', './node_modules/@babel/types/lib/modifications/flow/removeTypeDuplicates.js', '28.4', 0),
('77a244126df1c7962a754197dc77cce9', './node_modules/@babel/types/lib/modifications/inherits.js', '28.4', 0),
('db4f69ae784ac11dfd0e98a2ebb50be9', './node_modules/@babel/types/lib/modifications/prependToMemberExpression.js', '28.4', 0),
('d87e0d494624737886487482b1a1de46', './node_modules/@babel/types/lib/modifications/removeProperties.js', '28.4', 0),
('e458b85187136b2b392459bbfa98824e', './node_modules/@babel/types/lib/modifications/removePropertiesDeep.js', '28.4', 0),
('2d7d6514954f9c121d5dc600b95bb2d1', './node_modules/@babel/types/lib/modifications/typescript/removeTypeDuplicates.js', '28.4', 0),
('976910cb7f33648a16944eaf00c67db6', './node_modules/@babel/types/lib/retrievers/getAssignmentIdentifiers.js', '28.4', 0),
('24c7ea96f91d042a926b7b9d4f7cf73c', './node_modules/@babel/types/lib/retrievers/getBindingIdentifiers.js', '28.4', 0),
('36d6252b6310ff83874c7dc5d260a154', './node_modules/@babel/types/lib/retrievers/getFunctionName.js', '28.4', 0),
('ff679046a1c1277cefa2939ecd91b2ae', './node_modules/@babel/types/lib/retrievers/getOuterBindingIdentifiers.js', '28.4', 0),
('eabebc9b4725b3e28845ff90493e1de9', './node_modules/@babel/types/lib/traverse/traverse.js', '28.4', 0),
('5648489528f28972abb061c4fa360167', './node_modules/@babel/types/lib/traverse/traverseFast.js', '28.4', 0),
('53330dccebb65ead1e496701fb96d6b6', './node_modules/@babel/types/lib/utils/deprecationWarning.js', '28.4', 0),
('7c1361e0f91c4ac7967fb57e97e36f34', './node_modules/@babel/types/lib/utils/inherit.js', '28.4', 0),
('de82579a4814860871f3ec7506d4bcf0', './node_modules/@babel/types/lib/utils/react/cleanJSXElementLiteralChild.js', '28.4', 0),
('ec2780b5964ba88fa61cf683efa3ae90', './node_modules/@babel/types/lib/utils/shallowEqual.js', '28.4', 0),
('1052756da23954fa88d7e3959f738134', './node_modules/@babel/types/lib/validators/buildMatchMemberExpression.js', '28.4', 0),
('1cfa3ab8351149fcc3bdcf764ac2bb3c', './node_modules/@babel/types/lib/validators/generated/index.js', '28.4', 0),
('b9276bff3424a1e2219560e4d8a0ffb2', './node_modules/@babel/types/lib/validators/is.js', '28.4', 0),
('a977c0577dddd22a158e58582c3d0d86', './node_modules/@babel/types/lib/validators/isBinding.js', '28.4', 0),
('8a142b43187e849331c575e36c0a39bc', './node_modules/@babel/types/lib/validators/isBlockScoped.js', '28.4', 0),
('c010de4a47838c54dc11f6131e8b292b', './node_modules/@babel/types/lib/validators/isImmutable.js', '28.4', 0),
('1a957f4b3e1211210646073379a69fe2', './node_modules/@babel/types/lib/validators/isLet.js', '28.4', 0),
('f647da90ac458788ba93d4d597177532', './node_modules/@babel/types/lib/validators/isNode.js', '28.4', 0),
('25fedee991ae7caf3974c0e257fd6ada', './node_modules/@babel/types/lib/validators/isNodesEquivalent.js', '28.4', 0),
('5022c677e2ebdb1b2e6d3ec82f2d6846', './node_modules/@babel/types/lib/validators/isPlaceholderType.js', '28.4', 0),
('739e3e2729e96ad2b4415f6cc9151083', './node_modules/@babel/types/lib/validators/isReferenced.js', '28.4', 0),
('27d05af516f4ca09d174864073cf3453', './node_modules/@babel/types/lib/validators/isScope.js', '28.4', 0),
('79aec937546f94778dac30b4dab2e5f1', './node_modules/@babel/types/lib/validators/isSpecifierDefault.js', '28.4', 0),
('e8e454b56486de7f495067d30cac0a8a', './node_modules/@babel/types/lib/validators/isType.js', '28.4', 0),
('95418700df02cc539552dca38086b9d3', './node_modules/@babel/types/lib/validators/isValidES3Identifier.js', '28.4', 0),
('48852a63c8d45c466183a42994e7e625', './node_modules/@babel/types/lib/validators/isValidIdentifier.js', '28.4', 0),
('e374cce9205b18761c21804d579328cd', './node_modules/@babel/types/lib/validators/isVar.js', '28.4', 0),
('19561d089776b5710fc890a26d094d9d', './node_modules/@babel/types/lib/validators/matchesPattern.js', '28.4', 0),
('0eb72a23311d16827da8fe34779fc748', './node_modules/@babel/types/lib/validators/react/isCompatTag.js', '28.4', 0),
('fede4f1b26321f71da0bad709f730188', './node_modules/@babel/types/lib/validators/react/isReactComponent.js', '28.4', 0),
('03f1c89d9e390c87211ca2258bd20fdd', './node_modules/@babel/types/lib/validators/validate.js', '28.4', 0),
('6da9584493417e190c6d31a134fa9fd2', './node_modules/@braintree/sanitize-url/dist/index.js', '28.4', 0),
('9feb11e4259b81f8ce7a1d61b1aafe77', './node_modules/@casl/ability/dist/es5m/extra/index.js', '28.4', 0),
('cedd0c94b84cda7f02203d4e318be170', './node_modules/@casl/ability/dist/es5m/index.js', '28.4', 0),
('d9043d54cc2d25dbe5b2be070a3d9d30', './node_modules/@casl/ability/dist/es6c/extra/index.js', '28.4', 0),
('8e9cbca615b1c38d570a4d4b4defbeb6', './node_modules/@casl/ability/dist/es6c/index.js', '28.4', 0),
('b7ce91ecfeb30486c0344feac8d94633', './node_modules/@casl/ability/dist/umd/extra/index.js', '28.4', 0),
('dd965680a73617649960ae44b83861ab', './node_modules/@casl/ability/dist/umd/index.js', '28.4', 0),
('e25778e73ceeb4fb2b7795d41bbf8dbd', './node_modules/@choojs/findup/bin/findup.js', '28.4', 0),
('217a798d77db64ed949a61e09b0bdc4b', './node_modules/@choojs/findup/index.js', '28.4', 0),
('5d56ccd99113d3a04f449b728b07c4c4', './node_modules/@choojs/findup/node_modules/commander/index.js', '28.4', 0),
('1173367a4691eddb3e13543229088254', './node_modules/@choojs/findup/test/findup-test.js', '28.4', 0),
('b581b958cc4c22d695fb4244502f1e5d', './node_modules/@converse/localforage-getitems/dist/localforage-getitems.es6.js', '28.4', 0),
('b583f950427062ac1655817772ee5663', './node_modules/@converse/localforage-getitems/dist/localforage-getitems.js', '28.4', 0),
('900b161ea6ab8a14a0d88f1f8b0a4655', './node_modules/@converse/localforage-getitems/examples/main.js', '28.4', 0),
('62e23160ee23cbccb9061edbe5464891', './node_modules/@converse/localforage-getitems/lib/getitems-generic.js', '28.4', 0),
('ecfd98ed56bb4b5c73a9c07edf27dcb0', './node_modules/@converse/localforage-getitems/lib/getitems-indexeddb.js', '28.4', 0),
('4e54290aa604bbccaedc51512231f3a9', './node_modules/@converse/localforage-getitems/lib/getitems-websql.js', '28.4', 0),
('8ba118d7814d745271a4bf82606271d7', './node_modules/@converse/localforage-getitems/lib/idbKeyRange.js', '28.4', 0),
('bb3b89b6a0ade6642099ae92e67ae564', './node_modules/@converse/localforage-getitems/lib/localforage-getitems.js', '28.4', 0),
('f96e48919ffebaa4c1fc8c73dd52afc4', './node_modules/@converse/localforage-getitems/lib/utils.js', '28.4', 0),
('d9a1d1d5c584965e428b61530ff13a55', './node_modules/@converse/localforage-getitems/rollup.config.es6.js', '28.4', 0),
('020b38bf04d1feb08d4050e1d1d941c4', './node_modules/@converse/localforage-getitems/rollup.config.js', '28.4', 0),
('39461807d6ddc490399aec29cc494cc9', './node_modules/@converse/localforage-getitems/rollup.config.test.js', '28.4', 0),
('bc05c4c1bed7fc0789ee88a8fe311a70', './node_modules/@converse/localforage-getitems/rollup.config.umd.js', '28.4', 0),
('d309b8bb49a846b8b4a3ef9879595da2', './node_modules/@converse/localforage-getitems/test/index_test.js', '28.4', 0),
('5fc28dd4110995e0e2efd240e431c2be', './node_modules/@converse/openpromise/.eslintrc.js', '28.4', 0),
('3ba6e02431e5267d2e1c3393296485b1', './node_modules/@converse/openpromise/openpromise.js', '28.4', 0),
('32a77691a1eb5af7e3a704ba4df1394c', './node_modules/@converse/skeletor/dist/skeletor.js', '28.4', 0),
('a99f83b37d3207686ae419a378c2554d', './node_modules/@converse/skeletor/dist/skeletor.min.js', '28.4', 0),
('5fc40e0372baa6b5fafa484df8fa8d28', './node_modules/@converse/skeletor/src/collection.js', '28.4', 0),
('59ea3761d4a746fbed71d296633c3042', './node_modules/@converse/skeletor/src/drivers/sessionStorage.js', '28.4', 0),
('4a30dab095d46e80ab3374388c4b4a43', './node_modules/@converse/skeletor/src/element.js', '28.4', 0),
('49a380d4fc2f5f3b8ef03fa5531d2dc7', './node_modules/@converse/skeletor/src/events.js', '28.4', 0),
('75699a0403ae20b861b34f461e96783a', './node_modules/@converse/skeletor/src/helpers.js', '28.4', 0),
('1844109cb851a741364af2922f67bfdd', './node_modules/@converse/skeletor/src/history.js', '28.4', 0),
('44dddde8f7d03c718f773e38b53b0d2b', './node_modules/@converse/skeletor/src/main.js', '28.4', 0),
('5569509747fb7d3d6b3223d0e895f83b', './node_modules/@converse/skeletor/src/model.js', '28.4', 0),
('1bf2031c7c858566907b5c804043698e', './node_modules/@converse/skeletor/src/overview.js', '28.4', 0),
('3ce0bef059e865ae3c2716a8f96b54d5', './node_modules/@converse/skeletor/src/router.js', '28.4', 0),
('21aff15bd251c8a3c05541708b26c445', './node_modules/@converse/skeletor/src/storage.js', '28.4', 0),
('f74a6113004f46f94624b76338f91420', './node_modules/@converse/skeletor/src/view.js', '28.4', 0),
('fa2e2a3ab31fb45e1f098353fd1191dd', './node_modules/@ctrl/tinycolor/dist/bundles/tinycolor.umd.min.js', '28.4', 0),
('1f8d62ff6aecbfd0556c352be8fc8444', './node_modules/@ctrl/tinycolor/dist/conversion.js', '28.4', 0),
('f508fff875adba8f731f0a181ef89764', './node_modules/@ctrl/tinycolor/dist/css-color-names.js', '28.4', 0),
('21e273667cf5d26c41c70f94ddbb5da0', './node_modules/@ctrl/tinycolor/dist/format-input.js', '28.4', 0),
('6ecf4bde73f94f3e7160bf84a8673267', './node_modules/@ctrl/tinycolor/dist/from-ratio.js', '28.4', 0),
('64622c18b11369084f229dcb47d29f8e', './node_modules/@ctrl/tinycolor/dist/index.js', '28.4', 0),
('8963201168a2449f79025884824955f2', './node_modules/@ctrl/tinycolor/dist/interfaces.js', '28.4', 0),
('bcaf33a2eb7dd4e4315b1e96679a6af4', './node_modules/@ctrl/tinycolor/dist/module/conversion.js', '28.4', 0),
('6315fb1623a4179cda4a444a6164c39f', './node_modules/@ctrl/tinycolor/dist/module/css-color-names.js', '28.4', 0),
('cd3d1fabd4785ea8f1d6b98c3b9b60c6', './node_modules/@ctrl/tinycolor/dist/module/format-input.js', '28.4', 0),
('dea3e00ab4a67c51bc7120b98b206949', './node_modules/@ctrl/tinycolor/dist/module/from-ratio.js', '28.4', 0),
('dfbbced3adfa9ea2d6de42c405297260', './node_modules/@ctrl/tinycolor/dist/module/index.js', '28.4', 0),
('e2ebd7ddedcadeeadbf819c35985c768', './node_modules/@ctrl/tinycolor/dist/module/interfaces.js', '28.4', 0),
('17d9b5339cf253d825bb9f44e2e5a372', './node_modules/@ctrl/tinycolor/dist/module/public_api.js', '28.4', 0),
('4ba9f454f39304ff10b65e148928f8f7', './node_modules/@ctrl/tinycolor/dist/module/random.js', '28.4', 0),
('1bfcf2425182500424424f8ba9bfdfef', './node_modules/@ctrl/tinycolor/dist/module/readability.js', '28.4', 0),
('a44d6560ff9d379e53486e0d31d15bb1', './node_modules/@ctrl/tinycolor/dist/module/to-ms-filter.js', '28.4', 0),
('a4c35f75f5191088e465d93b09db88e9', './node_modules/@ctrl/tinycolor/dist/module/umd_api.js', '28.4', 0),
('52d32d8a26321fb71e864190094be4c2', './node_modules/@ctrl/tinycolor/dist/module/util.js', '28.4', 0),
('608461f7e439edf6cc51ae45a472df60', './node_modules/@ctrl/tinycolor/dist/public_api.js', '28.4', 0),
('5c4d2cf11b03d9490197814a58701406', './node_modules/@ctrl/tinycolor/dist/random.js', '28.4', 0),
('9a57476def4cde126d787d02cf673b4b', './node_modules/@ctrl/tinycolor/dist/readability.js', '28.4', 0),
('b20c9fa77b14937f8aa7d51b1e03b779', './node_modules/@ctrl/tinycolor/dist/to-ms-filter.js', '28.4', 0),
('0e68d93a24996175b069574eb3da8e4d', './node_modules/@ctrl/tinycolor/dist/umd_api.js', '28.4', 0),
('254bb6b8e93a72b232ab5776a7dca285', './node_modules/@ctrl/tinycolor/dist/util.js', '28.4', 0),
('171b01afdd07b7f81b0445012b3a207e', './node_modules/@element-plus/icons-vue/dist/global.iife.js', '28.4', 0),
('0d0e86d3cb5ad6bfa92fae674f5318fe', './node_modules/@element-plus/icons-vue/dist/global.iife.min.js', '28.4', 0),
('7a78945fa33a1729832f4ddfd19317b6', './node_modules/@element-plus/icons-vue/dist/global.js', '28.4', 0),
('8aa0cdc6b5b164fe889cff39f2fb363d', './node_modules/@element-plus/icons-vue/dist/global.min.js', '28.4', 0),
('bbee72ba81dc26d9ebee1e4018df71bb', './node_modules/@element-plus/icons-vue/dist/index.iife.js', '28.4', 0),
('d207bcfd53a6bc4ede2d45d41ed8ca1d', './node_modules/@element-plus/icons-vue/dist/index.iife.min.js', '28.4', 0),
('c32f314ca310af3126092ec48b8f7ed4', './node_modules/@element-plus/icons-vue/dist/index.js', '28.4', 0),
('370b0385db3905197d5ee480f6501e51', './node_modules/@element-plus/icons-vue/dist/index.min.js', '28.4', 0),
('364be115b9bf6bd3d2f1acc9e82fe876', './node_modules/@eslint-community/eslint-utils/index.js', '28.4', 0),
('244cddda1435f31477968e1e600a6bfb', './node_modules/@eslint-community/eslint-utils/node_modules/eslint-visitor-keys/lib/index.js', '28.4', 0),
('a569532b0c9fef5239e67e47bebc532e', './node_modules/@eslint-community/eslint-utils/node_modules/eslint-visitor-keys/lib/visitor-keys.js', '28.4', 0),
('00162c3b221f47fc333a454cbebaabfd', './node_modules/@eslint-community/regexpp/index.js', '28.4', 0),
('63f0189f8a5f425635e9081878b76e36', './node_modules/@eslint/config-array/dist/esm/index.js', '28.4', 0),
('cf7bbe5a9e2205a487d791d1b0133ff8', './node_modules/@eslint/eslintrc/conf/config-schema.js', '28.4', 0),
('fbd7f7be3fb4ecfbdf1890ccac450397', './node_modules/@eslint/eslintrc/conf/environments.js', '28.4', 0),
('c6345d94995f0c546e77f78dd925ab1e', './node_modules/@eslint/eslintrc/lib/cascading-config-array-factory.js', '28.4', 0),
('3eb2823a2c4641ef2764d31b02d30747', './node_modules/@eslint/eslintrc/lib/config-array-factory.js', '28.4', 0),
('8ce7e292248d51cf93e5b40775d2d1a6', './node_modules/@eslint/eslintrc/lib/config-array/config-array.js', '28.4', 0),
('0587c35e63e7f342011fbd1682b304be', './node_modules/@eslint/eslintrc/lib/config-array/config-dependency.js', '28.4', 0),
('f11e23be78ea6210067e3d17d4e81c66', './node_modules/@eslint/eslintrc/lib/config-array/extracted-config.js', '28.4', 0),
('fc8cf2e1721decb05c4c1a17445bf2b5', './node_modules/@eslint/eslintrc/lib/config-array/ignore-pattern.js', '28.4', 0),
('8a89fd6b3b75201e4c6f6593b03980c0', './node_modules/@eslint/eslintrc/lib/config-array/index.js', '28.4', 0),
('7251c0661a808299d6d9a12e768a6817', './node_modules/@eslint/eslintrc/lib/config-array/override-tester.js', '28.4', 0),
('06884a46b75c22833473a0d7a0355f22', './node_modules/@eslint/eslintrc/lib/flat-compat.js', '28.4', 0),
('cbc1e87816a34b88b1ae37d8a28a42bb', './node_modules/@eslint/eslintrc/lib/index-universal.js', '28.4', 0),
('1f1aa1e00bcfc27ae029a8a2a0c0e564', './node_modules/@eslint/eslintrc/lib/index.js', '28.4', 0),
('6f209b7a30182162d1c07dcd7b75375c', './node_modules/@eslint/eslintrc/lib/shared/ajv.js', '28.4', 0),
('4b86ef04cf76c792fd9a9226737a83e6', './node_modules/@eslint/eslintrc/lib/shared/config-ops.js', '28.4', 0),
('0450cb525b5a1c5347a27fc4020e7423', './node_modules/@eslint/eslintrc/lib/shared/config-validator.js', '28.4', 0),
('4e7b1a6002ec8ec178cb9c9c69b01e2c', './node_modules/@eslint/eslintrc/lib/shared/deprecation-warnings.js', '28.4', 0),
('fecf082b4243955e6b39e39286b0a4a3', './node_modules/@eslint/eslintrc/lib/shared/naming.js', '28.4', 0),
('3a7af74f6b36e3915a763e411790cd77', './node_modules/@eslint/eslintrc/lib/shared/relative-module-resolver.js', '28.4', 0),
('28ae9a6fba481eca34e721b26b848d4f', './node_modules/@eslint/eslintrc/lib/shared/types.js', '28.4', 0),
('c8c1d50def89dd6c0468046eef647d2f', './node_modules/@eslint/eslintrc/universal.js', '28.4', 0),
('567bd52b7944e168c8541f290387d2c4', './node_modules/@eslint/js/src/configs/eslint-all.js', '28.4', 0),
('6d89a529986d47be4b074d1c9da27aa8', './node_modules/@eslint/js/src/configs/eslint-recommended.js', '28.4', 0),
('caa324fc1a3197503e73e9770556c636', './node_modules/@eslint/js/src/index.js', '28.4', 0),
('3be5a16fe759c209695d9f4ee30573e6', './node_modules/@eslint/object-schema/dist/esm/index.js', '28.4', 0),
('4dcd40d8deae547d2ba7d733aa177ae2', './node_modules/@eslint/plugin-kit/dist/esm/index.js', '28.4', 0),
('133e1fada1830e6af4eb3bbf018b977c', './node_modules/@floating-ui/core/dist/floating-ui.core.esm.js', '28.4', 0),
('d94166a656dee8a1ee4f98e730b62a78', './node_modules/@floating-ui/core/dist/floating-ui.core.umd.js', '28.4', 0),
('6614af26bb4994e645787b52df732b3c', './node_modules/@floating-ui/core/dist/floating-ui.core.umd.min.js', '28.4', 0),
('3dc6ca7302c1d04f5e91007c3daf3b4c', './node_modules/@floating-ui/dom/dist/floating-ui.dom.esm.js', '28.4', 0),
('a10f4914be065054cb5592db2dcc5e60', './node_modules/@floating-ui/dom/dist/floating-ui.dom.umd.js', '28.4', 0),
('46339a6c54742ffdf3d7191cc98d1e6a', './node_modules/@floating-ui/dom/dist/floating-ui.dom.umd.min.js', '28.4', 0),
('c5ed28986e955a7800317136b996c700', './node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.esm.js', '28.4', 0),
('0cb36806e45e11ec911a8c080031fb71', './node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.umd.js', '28.4', 0),
('3e7dec906b1a9c7f751367ac6dcd6939', './node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.umd.min.js', '28.4', 0),
('011ab7eab36e759ede9638850bce104f', './node_modules/@floating-ui/utils/dist/floating-ui.utils.esm.js', '28.4', 0),
('cc7d3fbc8b083f044d06df24ca153f6a', './node_modules/@floating-ui/utils/dist/floating-ui.utils.umd.js', '28.4', 0),
('d88881be67154bb4db9e3dce4ac1e1e9', './node_modules/@floating-ui/utils/dist/floating-ui.utils.umd.min.js', '28.4', 0),
('c5ed28986e955a7800317136b996c700', './node_modules/@floating-ui/utils/dom/floating-ui.utils.dom.esm.js', '28.4', 0),
('0cb36806e45e11ec911a8c080031fb71', './node_modules/@floating-ui/utils/dom/floating-ui.utils.dom.umd.js', '28.4', 0),
('32cbc7490bac7bd4c7bd32eebe935547', './node_modules/@fortawesome/fontawesome-free/css/all.css', '28.4', 0),
('fbf1f3445f2554bce753c92cf6851b41', './node_modules/@fortawesome/fontawesome-free/css/all.min.css', '28.4', 0),
('4990ac5a8e407ca6f6e6df89e2f3290e', './node_modules/@fortawesome/fontawesome-free/css/brands.css', '28.4', 0),
('2aa672199907ea7f5f56d791ee637d7b', './node_modules/@fortawesome/fontawesome-free/css/brands.min.css', '28.4', 0),
('a2b5e2fd95e34ca42d5c78f385a88ce9', './node_modules/@fortawesome/fontawesome-free/css/fontawesome.css', '28.4', 0),
('42e0727f865a31ded34ed07a06b4ffa9', './node_modules/@fortawesome/fontawesome-free/css/fontawesome.min.css', '28.4', 0),
('f119c5dd949aa77326f1b650fab09538', './node_modules/@fortawesome/fontawesome-free/css/regular.css', '28.4', 0),
('e39e227351ea35417f0584f84e2950d7', './node_modules/@fortawesome/fontawesome-free/css/regular.min.css', '28.4', 0),
('c33840624514b5db4734bcec33bde322', './node_modules/@fortawesome/fontawesome-free/css/solid.css', '28.4', 0),
('d5a5aeaef1db22df1c0eadd1d23ccff8', './node_modules/@fortawesome/fontawesome-free/css/solid.min.css', '28.4', 0),
('b4eac312cd51bb77884b36ad7f4f8dcc', './node_modules/@fortawesome/fontawesome-free/css/svg-with-js.css', '28.4', 0),
('700e62e008305a8fca8432a393679ffe', './node_modules/@fortawesome/fontawesome-free/css/svg-with-js.min.css', '28.4', 0),
('6eb4b5612576e17a90c57d4b07826d0c', './node_modules/@fortawesome/fontawesome-free/css/v4-font-face.css', '28.4', 0),
('65b127d0c44b14cfd67b6aead36a8319', './node_modules/@fortawesome/fontawesome-free/css/v4-font-face.min.css', '28.4', 0),
('56f2af566adb517e4b51f8894e8e886d', './node_modules/@fortawesome/fontawesome-free/css/v4-shims.css', '28.4', 0),
('f68f36aede487a2bdfe0ad3c89e0c220', './node_modules/@fortawesome/fontawesome-free/css/v4-shims.min.css', '28.4', 0),
('adad0b5dd5d346cfbf5254a817a054cd', './node_modules/@fortawesome/fontawesome-free/css/v5-font-face.css', '28.4', 0),
('6d4a42743010f17bdbd031e1fc61b861', './node_modules/@fortawesome/fontawesome-free/css/v5-font-face.min.css', '28.4', 0),
('4c2126a94081a845e554752c14f6d266', './node_modules/@fortawesome/fontawesome-free/js/all.js', '28.4', 0),
('d293c4f1799b055229f73388ff066c6e', './node_modules/@fortawesome/fontawesome-free/js/all.min.js', '28.4', 0),
('d17db98a992325d0a95da6ba6b85055b', './node_modules/@fortawesome/fontawesome-free/js/brands.js', '28.4', 0),
('ce278836ea133034399b262362489725', './node_modules/@fortawesome/fontawesome-free/js/brands.min.js', '28.4', 0),
('f55210c66d22fdab37943a0b011951d8', './node_modules/@fortawesome/fontawesome-free/js/conflict-detection.js', '28.4', 0),
('ec5d34a151cbb398e9de6872203b552f', './node_modules/@fortawesome/fontawesome-free/js/conflict-detection.min.js', '28.4', 0),
('ef170e990eeddd90613cb09dd6484819', './node_modules/@fortawesome/fontawesome-free/js/fontawesome.js', '28.4', 0),
('dc2b48d78fb174ad09bd623f0a72e2c4', './node_modules/@fortawesome/fontawesome-free/js/fontawesome.min.js', '28.4', 0),
('af23540b8c309efb30798f2fd0a86bb4', './node_modules/@fortawesome/fontawesome-free/js/regular.js', '28.4', 0),
('23530653025920b1137e3656210a6983', './node_modules/@fortawesome/fontawesome-free/js/regular.min.js', '28.4', 0),
('a60f34a7f2ec8060f93f23e5d632eeb1', './node_modules/@fortawesome/fontawesome-free/js/solid.js', '28.4', 0),
('fd12ae544fd4e9e3a077d7e92b0cfe69', './node_modules/@fortawesome/fontawesome-free/js/solid.min.js', '28.4', 0),
('4881bdac0fcefbe62872a87519ced08b', './node_modules/@fortawesome/fontawesome-free/js/v4-shims.js', '28.4', 0),
('b6e3b165a408422d66ebc7aba5725f70', './node_modules/@fortawesome/fontawesome-free/js/v4-shims.min.js', '28.4', 0),
('a6cdf5af471183f8305da3fbe316c90e', './node_modules/@fullcalendar/core/index.global.js', '28.4', 0),
('1c435495a7fa5fe2773bd25b07e751f6', './node_modules/@fullcalendar/core/index.global.min.js', '28.4', 0),
('38df496b3b9ded8fd8e37bd2c0c60593', './node_modules/@fullcalendar/core/index.js', '28.4', 0),
('30b1e96dbbb6763e3a5b549283068117', './node_modules/@fullcalendar/core/internal-common.js', '28.4', 0),
('aa395c6e20d49e223cbf917d190f5302', './node_modules/@fullcalendar/core/internal.js', '28.4', 0),
('6527b7f8ef4905cc381a9d5225fc32bd', './node_modules/@fullcalendar/core/locales-all.global.js', '28.4', 0),
('7f7bec3a45016a1a0afa8d65f053c286', './node_modules/@fullcalendar/core/locales-all.global.min.js', '28.4', 0),
('531b6c87df2b782345b2c32d931ea215', './node_modules/@fullcalendar/core/locales-all.js', '28.4', 0),
('d66b0ef672f8fd3bd1912b6eb8ddce8f', './node_modules/@fullcalendar/core/locales/af.global.js', '28.4', 0),
('2e1ef18334903fb4247541cc9a109473', './node_modules/@fullcalendar/core/locales/af.global.min.js', '28.4', 0),
('1b7648872eeaf1a77670e3b4ee0dd6a0', './node_modules/@fullcalendar/core/locales/af.js', '28.4', 0),
('5920bf0d638c5739716e06e76844c872', './node_modules/@fullcalendar/core/locales/ar-dz.global.js', '28.4', 0),
('05f50785cfbbe0d534c99e62f69d673c', './node_modules/@fullcalendar/core/locales/ar-dz.global.min.js', '28.4', 0),
('843a9d7f6d0826b43d5abce876328299', './node_modules/@fullcalendar/core/locales/ar-dz.js', '28.4', 0),
('dbde229f75fe590020508b8299470ce4', './node_modules/@fullcalendar/core/locales/ar-kw.global.js', '28.4', 0),
('486f4129f26c6c1c79cd70a756aa9143', './node_modules/@fullcalendar/core/locales/ar-kw.global.min.js', '28.4', 0),
('988010c4f0a116af380636940e967c4b', './node_modules/@fullcalendar/core/locales/ar-kw.js', '28.4', 0),
('bb635adb08c964aead154cefd23352c8', './node_modules/@fullcalendar/core/locales/ar-ly.global.js', '28.4', 0),
('14c8ba99027142c8151c7dbdec2b8e41', './node_modules/@fullcalendar/core/locales/ar-ly.global.min.js', '28.4', 0),
('d74845340bccf23f59c97ad8235a597c', './node_modules/@fullcalendar/core/locales/ar-ly.js', '28.4', 0),
('311da76d737f3520fd0de42600c18c71', './node_modules/@fullcalendar/core/locales/ar-ma.global.js', '28.4', 0),
('17870b8e61d602d5e1dfd7965290d8ca', './node_modules/@fullcalendar/core/locales/ar-ma.global.min.js', '28.4', 0),
('ea2cceae0f9159d6e99f4174772b6203', './node_modules/@fullcalendar/core/locales/ar-ma.js', '28.4', 0),
('be58edc24fe394daf5c9e94a6e36259d', './node_modules/@fullcalendar/core/locales/ar-sa.global.js', '28.4', 0),
('af503297dde3fdd4f4ce59bda141e0cb', './node_modules/@fullcalendar/core/locales/ar-sa.global.min.js', '28.4', 0),
('7ed67fbf1e40ff16d1e6765497ac0799', './node_modules/@fullcalendar/core/locales/ar-sa.js', '28.4', 0),
('149f4562af4e4b637bdedf4e27dfd61e', './node_modules/@fullcalendar/core/locales/ar-tn.global.js', '28.4', 0),
('e2cdb6b49addc8c50a9bb15b28b02be5', './node_modules/@fullcalendar/core/locales/ar-tn.global.min.js', '28.4', 0),
('39bec75b59e60b7f4b3f71a395ebaf88', './node_modules/@fullcalendar/core/locales/ar-tn.js', '28.4', 0),
('6c9980d0fdc2ae40c988b100837ee3af', './node_modules/@fullcalendar/core/locales/ar.global.js', '28.4', 0),
('71850d81251ebce332c7ec9405681a2d', './node_modules/@fullcalendar/core/locales/ar.global.min.js', '28.4', 0),
('32d721dcf8f71467e4d47672067772d1', './node_modules/@fullcalendar/core/locales/ar.js', '28.4', 0),
('16b561dedcc4feb695464e1f42cc98c7', './node_modules/@fullcalendar/core/locales/az.global.js', '28.4', 0),
('b66cbf4d7f2e68b9e5cc1f8b9f534dea', './node_modules/@fullcalendar/core/locales/az.global.min.js', '28.4', 0),
('6b5f0017586557bf6432fd38977dbd01', './node_modules/@fullcalendar/core/locales/az.js', '28.4', 0),
('78aec3b82d4878926ed0eb4e3c4961d1', './node_modules/@fullcalendar/core/locales/bg.global.js', '28.4', 0),
('72c5dc25a3f98ea91fccbce378e1f722', './node_modules/@fullcalendar/core/locales/bg.global.min.js', '28.4', 0),
('27eeff040d15bbfaab2a374653046fc6', './node_modules/@fullcalendar/core/locales/bg.js', '28.4', 0),
('dd40426480389b1a5b8ef7df8e89dc5e', './node_modules/@fullcalendar/core/locales/bn.global.js', '28.4', 0),
('10fdb45caae5b4f7fec554b58c898a84', './node_modules/@fullcalendar/core/locales/bn.global.min.js', '28.4', 0),
('f3524e04472692fcd5402b229f8643f6', './node_modules/@fullcalendar/core/locales/bn.js', '28.4', 0),
('eff1c4f437b816f535cce0962eeabf05', './node_modules/@fullcalendar/core/locales/bs.global.js', '28.4', 0),
('477555eca2fb67a3ccd8bea0371fbe31', './node_modules/@fullcalendar/core/locales/bs.global.min.js', '28.4', 0),
('859a354fe696ef309d7518454e5adf92', './node_modules/@fullcalendar/core/locales/bs.js', '28.4', 0),
('5ca3529567f5f0755387326768ef166a', './node_modules/@fullcalendar/core/locales/ca.global.js', '28.4', 0),
('414c51ec0b7fc07a380acce1eccda923', './node_modules/@fullcalendar/core/locales/ca.global.min.js', '28.4', 0),
('bd0e8e15555b1f366849257b33769221', './node_modules/@fullcalendar/core/locales/ca.js', '28.4', 0),
('edbd2971a4223bed1abbbaf5659c2065', './node_modules/@fullcalendar/core/locales/cs.global.js', '28.4', 0),
('1a9396bbf73198a1575770166e8a69fb', './node_modules/@fullcalendar/core/locales/cs.global.min.js', '28.4', 0),
('fe022ea1ff2b9f580cc0017eb05c3d17', './node_modules/@fullcalendar/core/locales/cs.js', '28.4', 0),
('f0127868550b1ebc2065cf94cf6cf20a', './node_modules/@fullcalendar/core/locales/cy.global.js', '28.4', 0),
('825964b3facb6de86059393d47fff957', './node_modules/@fullcalendar/core/locales/cy.global.min.js', '28.4', 0),
('4cafa92dc23602d057d22990ad2934ae', './node_modules/@fullcalendar/core/locales/cy.js', '28.4', 0),
('501c724fbde45196d242e27e0d9ebb2f', './node_modules/@fullcalendar/core/locales/da.global.js', '28.4', 0),
('7886997f756c477929ec32c2042c7e9b', './node_modules/@fullcalendar/core/locales/da.global.min.js', '28.4', 0),
('70d1561dfb192de113d8b17d339294e4', './node_modules/@fullcalendar/core/locales/da.js', '28.4', 0),
('beabf54fda13c6c082f1b47364a40e70', './node_modules/@fullcalendar/core/locales/de-at.global.js', '28.4', 0),
('4fe0b588dd42dd12567d5e1bf0441988', './node_modules/@fullcalendar/core/locales/de-at.global.min.js', '28.4', 0),
('267d3f24ba72e3b10b5c4f4f15581e95', './node_modules/@fullcalendar/core/locales/de-at.js', '28.4', 0),
('c053c9a0b81dcb55c272daa348c57b66', './node_modules/@fullcalendar/core/locales/de.global.js', '28.4', 0),
('eae0fc1d7c41dc31c3fdac85321f0512', './node_modules/@fullcalendar/core/locales/de.global.min.js', '28.4', 0),
('7724d153d6d2418428ea86f5e56df628', './node_modules/@fullcalendar/core/locales/de.js', '28.4', 0),
('a162f850027a92e762c98be9a26f49d2', './node_modules/@fullcalendar/core/locales/el.global.js', '28.4', 0),
('83bb1f33b34a1ebfc6b54fe804e965d6', './node_modules/@fullcalendar/core/locales/el.global.min.js', '28.4', 0),
('673ac1ae0ce8af20cb00ff2b6cb0159f', './node_modules/@fullcalendar/core/locales/el.js', '28.4', 0),
('7c04b4a47cf381a0a8227bb2163eb50c', './node_modules/@fullcalendar/core/locales/en-au.global.js', '28.4', 0),
('7f9b78e9359f20528c92d8546ce480d6', './node_modules/@fullcalendar/core/locales/en-au.global.min.js', '28.4', 0),
('d9f3616dbd8fc1ec5bc243125a1a05cf', './node_modules/@fullcalendar/core/locales/en-au.js', '28.4', 0),
('9c4e671b2471fd099cd4052a6eb8b8f0', './node_modules/@fullcalendar/core/locales/en-gb.global.js', '28.4', 0),
('86aa0fd92731078c379434fc24636954', './node_modules/@fullcalendar/core/locales/en-gb.global.min.js', '28.4', 0),
('d496054bfc247f4dd4a830a0f79b21e2', './node_modules/@fullcalendar/core/locales/en-gb.js', '28.4', 0),
('ef70c111a7ad137f14478bbd4eecdf69', './node_modules/@fullcalendar/core/locales/en-nz.global.js', '28.4', 0),
('96f9e7f414ea17cb0413cce521bab892', './node_modules/@fullcalendar/core/locales/en-nz.global.min.js', '28.4', 0),
('8fa0985638d049574d867e5ecf1568ed', './node_modules/@fullcalendar/core/locales/en-nz.js', '28.4', 0),
('959532c215a15dde8caba935eaef851b', './node_modules/@fullcalendar/core/locales/eo.global.js', '28.4', 0),
('3411e346f26eadf875b61e29c67fe09e', './node_modules/@fullcalendar/core/locales/eo.global.min.js', '28.4', 0),
('c607f4fa46ae540a2865f32c09aee742', './node_modules/@fullcalendar/core/locales/eo.js', '28.4', 0),
('9c942e918293c348ff87b5b3bcdc3e9f', './node_modules/@fullcalendar/core/locales/es-us.global.js', '28.4', 0),
('a6978bf6d351c7cef4ceb897c78f8564', './node_modules/@fullcalendar/core/locales/es-us.global.min.js', '28.4', 0),
('038d4c720b84a54ad66809e459286f43', './node_modules/@fullcalendar/core/locales/es-us.js', '28.4', 0),
('02e866d29939ac551a218319c1f8b40a', './node_modules/@fullcalendar/core/locales/es.global.js', '28.4', 0),
('c1b897442ddbd77645067beeba42dc3f', './node_modules/@fullcalendar/core/locales/es.global.min.js', '28.4', 0),
('2370a4c9558d58a9f722eee146c642da', './node_modules/@fullcalendar/core/locales/es.js', '28.4', 0),
('a06a8588afb1fdcd983bd54a53120bb8', './node_modules/@fullcalendar/core/locales/et.global.js', '28.4', 0),
('d49ddd36e042129b20fe6ce36cb13a42', './node_modules/@fullcalendar/core/locales/et.global.min.js', '28.4', 0),
('a15ce0d957ab9f1481e13fda80f78462', './node_modules/@fullcalendar/core/locales/et.js', '28.4', 0),
('c84d8884455a70946a02eef91bf30cfb', './node_modules/@fullcalendar/core/locales/eu.global.js', '28.4', 0),
('5246cf2cefbfd2b9f89bd483ed5c599e', './node_modules/@fullcalendar/core/locales/eu.global.min.js', '28.4', 0),
('4110bf6d951a37fcab35937fca51c915', './node_modules/@fullcalendar/core/locales/eu.js', '28.4', 0),
('0cb185797ec87f1226bd861fe61dc3e2', './node_modules/@fullcalendar/core/locales/fa.global.js', '28.4', 0),
('c42334b882203c2ce35024cc5be49e2f', './node_modules/@fullcalendar/core/locales/fa.global.min.js', '28.4', 0),
('33eae622de8332e1209de690080ef0f4', './node_modules/@fullcalendar/core/locales/fa.js', '28.4', 0),
('1c27413d559ceeba3378f03f8003d731', './node_modules/@fullcalendar/core/locales/fi.global.js', '28.4', 0),
('4e899f30ecccd3814c4fb79076778691', './node_modules/@fullcalendar/core/locales/fi.global.min.js', '28.4', 0),
('bdd6a0755384225e6e44935a53a6f3a3', './node_modules/@fullcalendar/core/locales/fi.js', '28.4', 0),
('557971f880dbad910b8829a4c130b894', './node_modules/@fullcalendar/core/locales/fr-ca.global.js', '28.4', 0),
('780eef95e05eb773716a32ce741b0b6e', './node_modules/@fullcalendar/core/locales/fr-ca.global.min.js', '28.4', 0),
('02ca01dbb79003abf42688525c59b530', './node_modules/@fullcalendar/core/locales/fr-ca.js', '28.4', 0),
('02687cd7c86006b62d4c83d7dca4e363', './node_modules/@fullcalendar/core/locales/fr-ch.global.js', '28.4', 0),
('f2c26ea11bd260f896adb2b434e1855e', './node_modules/@fullcalendar/core/locales/fr-ch.global.min.js', '28.4', 0),
('5e0f8730859fd81f4c27f2b2790a0c72', './node_modules/@fullcalendar/core/locales/fr-ch.js', '28.4', 0),
('3ac6cf7b6a93102ce3e027ebfa4d7d55', './node_modules/@fullcalendar/core/locales/fr.global.js', '28.4', 0),
('6fbf53a23d26ba9d7cfb459ef8f22e37', './node_modules/@fullcalendar/core/locales/fr.global.min.js', '28.4', 0),
('50a44d847ad64a08c2bebb68ecc8c37b', './node_modules/@fullcalendar/core/locales/fr.js', '28.4', 0),
('910f3bbd54e0eb175e70bcba824b8dda', './node_modules/@fullcalendar/core/locales/gl.global.js', '28.4', 0),
('dee7c356d7f6d30df57a4b542dc303d2', './node_modules/@fullcalendar/core/locales/gl.global.min.js', '28.4', 0),
('5d5ba208821d72283429e2a29d03fe6a', './node_modules/@fullcalendar/core/locales/gl.js', '28.4', 0),
('73fbedcb2b73e1768985715482235145', './node_modules/@fullcalendar/core/locales/he.global.js', '28.4', 0),
('34d7ac9ca096f0d6a41159d70e5c38f7', './node_modules/@fullcalendar/core/locales/he.global.min.js', '28.4', 0),
('7728d4995c14a82df3c6a8e96d720bfd', './node_modules/@fullcalendar/core/locales/he.js', '28.4', 0),
('d6488c93147f67859e02c072f468cb59', './node_modules/@fullcalendar/core/locales/hi.global.js', '28.4', 0),
('c04e7ed0e03b8f412fb15021ab196dc6', './node_modules/@fullcalendar/core/locales/hi.global.min.js', '28.4', 0),
('2548e55f656ed12f5c97bc5692035b4c', './node_modules/@fullcalendar/core/locales/hi.js', '28.4', 0),
('0ba90d05f7e533e6856190a7717c99d4', './node_modules/@fullcalendar/core/locales/hr.global.js', '28.4', 0),
('d3dead5edfe926818255cbbb58b59152', './node_modules/@fullcalendar/core/locales/hr.global.min.js', '28.4', 0),
('a6f6747808c12b3ee55c756aefb438c8', './node_modules/@fullcalendar/core/locales/hr.js', '28.4', 0),
('20705c8041a9f1cf76dbec79a51a6c67', './node_modules/@fullcalendar/core/locales/hu.global.js', '28.4', 0),
('17ad97699cfb2b89aaa6df488f30d2b3', './node_modules/@fullcalendar/core/locales/hu.global.min.js', '28.4', 0),
('6da3ab379fbad52945ee0f7317ddac1d', './node_modules/@fullcalendar/core/locales/hu.js', '28.4', 0),
('5aabbed629533f5484a31ce49c1e88bd', './node_modules/@fullcalendar/core/locales/hy-am.global.js', '28.4', 0),
('dccf3e3c63a8c450682e0c740ebb9ed1', './node_modules/@fullcalendar/core/locales/hy-am.global.min.js', '28.4', 0),
('467e96176e5018684453791fd756a323', './node_modules/@fullcalendar/core/locales/hy-am.js', '28.4', 0),
('9aaf58bb3e2840d6d2ba6f0841b09955', './node_modules/@fullcalendar/core/locales/id.global.js', '28.4', 0),
('b9115d585ea6e29370f304184d728fc8', './node_modules/@fullcalendar/core/locales/id.global.min.js', '28.4', 0),
('ad83516604308a4fb327c4c88c932863', './node_modules/@fullcalendar/core/locales/id.js', '28.4', 0),
('96cf007597482ccc735da16b04f18ac7', './node_modules/@fullcalendar/core/locales/is.global.js', '28.4', 0),
('1f565e3fee3dd87892ac050eedb3fb84', './node_modules/@fullcalendar/core/locales/is.global.min.js', '28.4', 0),
('ba004cc0f7d1ff8042bb03a14da5cb52', './node_modules/@fullcalendar/core/locales/is.js', '28.4', 0),
('91866eaf2282f94e8e613115cde25aa6', './node_modules/@fullcalendar/core/locales/it.global.js', '28.4', 0),
('18560449c3d18bedc5752af4ef4c4558', './node_modules/@fullcalendar/core/locales/it.global.min.js', '28.4', 0),
('82ceaf6801d11dc5e6578c33074e06fd', './node_modules/@fullcalendar/core/locales/it.js', '28.4', 0),
('5b3d2156ee4ee91754a8202c514226ec', './node_modules/@fullcalendar/core/locales/ja.global.js', '28.4', 0),
('4817f0c35db35886aa8db8eb1e01ae80', './node_modules/@fullcalendar/core/locales/ja.global.min.js', '28.4', 0),
('8f137c91b61deba31d6e247321862b1d', './node_modules/@fullcalendar/core/locales/ja.js', '28.4', 0),
('3e7ea6f161244702f149ca0e40bd2b5a', './node_modules/@fullcalendar/core/locales/ka.global.js', '28.4', 0),
('29fbc0e7d107ef8b3fa04b2a1f1243aa', './node_modules/@fullcalendar/core/locales/ka.global.min.js', '28.4', 0),
('0711a63786636396ca87a3ea50dcb0f6', './node_modules/@fullcalendar/core/locales/ka.js', '28.4', 0),
('ab8966c37b4b86e8db481bc4825d4246', './node_modules/@fullcalendar/core/locales/kk.global.js', '28.4', 0),
('ab695fe59914307f5be61ce1e0661f5d', './node_modules/@fullcalendar/core/locales/kk.global.min.js', '28.4', 0),
('56eec60386e62d6fc02b06637a7075af', './node_modules/@fullcalendar/core/locales/kk.js', '28.4', 0),
('1e095e1fbe467b1640b0dc2f225c2761', './node_modules/@fullcalendar/core/locales/km.global.js', '28.4', 0),
('608ccc62608f1efc76130112d8ace396', './node_modules/@fullcalendar/core/locales/km.global.min.js', '28.4', 0),
('af42b1a91b0366a5563c9ac716d5e11b', './node_modules/@fullcalendar/core/locales/km.js', '28.4', 0),
('10947b51e4c64f250e0ae3dff446be4d', './node_modules/@fullcalendar/core/locales/ko.global.js', '28.4', 0),
('9cb851348dd59f4e02fdcdbfc03eebda', './node_modules/@fullcalendar/core/locales/ko.global.min.js', '28.4', 0),
('b932e07c3914c2529c972d5bbb151062', './node_modules/@fullcalendar/core/locales/ko.js', '28.4', 0),
('94b48dd51721f82a91e0787629c1137f', './node_modules/@fullcalendar/core/locales/ku.global.js', '28.4', 0),
('20ed22989ce0244220123e6b7a223f4f', './node_modules/@fullcalendar/core/locales/ku.global.min.js', '28.4', 0),
('614814c0763a83b147f7c4da67f4e56d', './node_modules/@fullcalendar/core/locales/ku.js', '28.4', 0),
('6e109e34f729516f11c23db1c7cb5f10', './node_modules/@fullcalendar/core/locales/lb.global.js', '28.4', 0),
('5d7f0e2c8b9c3f36968b713438ee64fe', './node_modules/@fullcalendar/core/locales/lb.global.min.js', '28.4', 0),
('6d642ae8acb4b512e4f56fd3d5f2544b', './node_modules/@fullcalendar/core/locales/lb.js', '28.4', 0),
('425cf9db944a355e7e58b9e2de71e352', './node_modules/@fullcalendar/core/locales/lt.global.js', '28.4', 0),
('817e3deb7e65c1c741657102d467f484', './node_modules/@fullcalendar/core/locales/lt.global.min.js', '28.4', 0),
('34b74d222e5d34a59c9a9e9a38548dca', './node_modules/@fullcalendar/core/locales/lt.js', '28.4', 0),
('d6e19e77622b4f62bf50dc5df0e9b114', './node_modules/@fullcalendar/core/locales/lv.global.js', '28.4', 0),
('e1ab7577f082040cf26101f5de10f3b4', './node_modules/@fullcalendar/core/locales/lv.global.min.js', '28.4', 0),
('1e9a5622054f9f3166223df7d71f9b54', './node_modules/@fullcalendar/core/locales/lv.js', '28.4', 0),
('0d0f03eee1fb83343352c5acc2c64dab', './node_modules/@fullcalendar/core/locales/mk.global.js', '28.4', 0),
('ebddb8e85ceeaadd0b1a44aaef066fe1', './node_modules/@fullcalendar/core/locales/mk.global.min.js', '28.4', 0),
('7f59f7eff8c152050596c3d234dbe991', './node_modules/@fullcalendar/core/locales/mk.js', '28.4', 0),
('2e348c0fa8935875589b94c4cae21e4c', './node_modules/@fullcalendar/core/locales/ms.global.js', '28.4', 0),
('a40f6f482c7265a457b35638055482d7', './node_modules/@fullcalendar/core/locales/ms.global.min.js', '28.4', 0),
('d661b9d60226e8877354696929a018af', './node_modules/@fullcalendar/core/locales/ms.js', '28.4', 0),
('7606135159a732aba3bfa4b174921515', './node_modules/@fullcalendar/core/locales/nb.global.js', '28.4', 0),
('af138e58caf4e6a77a3536734f5d9bf6', './node_modules/@fullcalendar/core/locales/nb.global.min.js', '28.4', 0),
('5e82c02bf51960a9306ec1c5bfe6821d', './node_modules/@fullcalendar/core/locales/nb.js', '28.4', 0),
('8654c652add36b565b8dd6462c6edf36', './node_modules/@fullcalendar/core/locales/ne.global.js', '28.4', 0),
('69d8c2088de52807f8033219d0326686', './node_modules/@fullcalendar/core/locales/ne.global.min.js', '28.4', 0),
('b456dce8bb20673f78eb121c2bf4c8cb', './node_modules/@fullcalendar/core/locales/ne.js', '28.4', 0),
('69cec25d693ec8412fced00ceb98af09', './node_modules/@fullcalendar/core/locales/nl.global.js', '28.4', 0),
('9812f57f6bdaced45984aae9121aa913', './node_modules/@fullcalendar/core/locales/nl.global.min.js', '28.4', 0),
('7f6593bc76713720c2bbcb08eae04c9a', './node_modules/@fullcalendar/core/locales/nl.js', '28.4', 0),
('73637f6e8cc880fb639695dd0abee406', './node_modules/@fullcalendar/core/locales/nn.global.js', '28.4', 0),
('e0b75eb501369988f9dc91c8caa67b68', './node_modules/@fullcalendar/core/locales/nn.global.min.js', '28.4', 0),
('7d207812ed5a4f5496872dad2e7b8fe9', './node_modules/@fullcalendar/core/locales/nn.js', '28.4', 0),
('6e853ee8c0883de2df265ea78b140fed', './node_modules/@fullcalendar/core/locales/pl.global.js', '28.4', 0),
('f6455d4a533ca77aadef71e0bb43653b', './node_modules/@fullcalendar/core/locales/pl.global.min.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('8e19e5ad1c08acefd8e13e1efe2add95', './node_modules/@fullcalendar/core/locales/pl.js', '28.4', 0),
('958470b648b4204311fe062297c219bf', './node_modules/@fullcalendar/core/locales/pt-br.global.js', '28.4', 0),
('cc7b084373e670fa3dde572b74523f37', './node_modules/@fullcalendar/core/locales/pt-br.global.min.js', '28.4', 0),
('38829286d658668a90a5d4fd14200976', './node_modules/@fullcalendar/core/locales/pt-br.js', '28.4', 0),
('bd23c78380b888fcf67f6ba154e6f729', './node_modules/@fullcalendar/core/locales/pt.global.js', '28.4', 0),
('e2df4c27097deacd388b66ed822c231e', './node_modules/@fullcalendar/core/locales/pt.global.min.js', '28.4', 0),
('7ab68365d453191f020a1debae08304b', './node_modules/@fullcalendar/core/locales/pt.js', '28.4', 0),
('94493ef00320a130a7102e896b4c69bb', './node_modules/@fullcalendar/core/locales/ro.global.js', '28.4', 0),
('efd7d57063c71ea3e43502c84aff644f', './node_modules/@fullcalendar/core/locales/ro.global.min.js', '28.4', 0),
('08c1d8b5bc1c71ed02f815718ac42a5a', './node_modules/@fullcalendar/core/locales/ro.js', '28.4', 0),
('ffec06d79403efdda74ae00ba966600b', './node_modules/@fullcalendar/core/locales/ru.global.js', '28.4', 0),
('ae779c2389ad92b96e95be695774a0c7', './node_modules/@fullcalendar/core/locales/ru.global.min.js', '28.4', 0),
('20f5def779a90c5fe0db1f9c95a7a249', './node_modules/@fullcalendar/core/locales/ru.js', '28.4', 0),
('5e2c8e1d01972074e3d607cbca0b0939', './node_modules/@fullcalendar/core/locales/si-lk.global.js', '28.4', 0),
('937b1b42ebf9bd3f646405ca0c15b625', './node_modules/@fullcalendar/core/locales/si-lk.global.min.js', '28.4', 0),
('d2135d807f297e536c1156e0239866c3', './node_modules/@fullcalendar/core/locales/si-lk.js', '28.4', 0),
('f926820521fee774089ee96604268504', './node_modules/@fullcalendar/core/locales/sk.global.js', '28.4', 0),
('744223ebfcf3b2c37d11f621421a0dc4', './node_modules/@fullcalendar/core/locales/sk.global.min.js', '28.4', 0),
('adf5d06c25b6a87d9cd58d58bb8c39a4', './node_modules/@fullcalendar/core/locales/sk.js', '28.4', 0),
('9a8f93356d7be454343fdca8d2b76b77', './node_modules/@fullcalendar/core/locales/sl.global.js', '28.4', 0),
('f89d3e27967e9692ad106d847c0b3da4', './node_modules/@fullcalendar/core/locales/sl.global.min.js', '28.4', 0),
('eeb1ce7e3e3d29ba9316d0685550b467', './node_modules/@fullcalendar/core/locales/sl.js', '28.4', 0),
('b3d661b660f8f17765993a16a59f3659', './node_modules/@fullcalendar/core/locales/sm.global.js', '28.4', 0),
('15a0ffd7839a05f9987a244098ffdfa0', './node_modules/@fullcalendar/core/locales/sm.global.min.js', '28.4', 0),
('a01562c01e72269a965a80aaaae47a6a', './node_modules/@fullcalendar/core/locales/sm.js', '28.4', 0),
('fc9b2b9b3fd36d1c57868279e5f3e9c0', './node_modules/@fullcalendar/core/locales/sq.global.js', '28.4', 0),
('b3f2773c48fb3ff62f4ba7e7c5ae8938', './node_modules/@fullcalendar/core/locales/sq.global.min.js', '28.4', 0),
('32a6a4d1937e751ec0134af60788fc7f', './node_modules/@fullcalendar/core/locales/sq.js', '28.4', 0),
('0c96ce7f817e831ae2c455205b2a98e8', './node_modules/@fullcalendar/core/locales/sr-cyrl.global.js', '28.4', 0),
('2ba866aea81fe822ccaeea2e056abc3c', './node_modules/@fullcalendar/core/locales/sr-cyrl.global.min.js', '28.4', 0),
('3f09b8eb00ff948a8bf88e3878b5a503', './node_modules/@fullcalendar/core/locales/sr-cyrl.js', '28.4', 0),
('f2ed1501c176c7351193633055dbb8b7', './node_modules/@fullcalendar/core/locales/sr.global.js', '28.4', 0),
('1d64071c08d102599794c6c78ca13aca', './node_modules/@fullcalendar/core/locales/sr.global.min.js', '28.4', 0),
('01155474bf0da0c4b60633ec7c54b563', './node_modules/@fullcalendar/core/locales/sr.js', '28.4', 0),
('2a85c5db20400afe41e7655da1a52dc9', './node_modules/@fullcalendar/core/locales/sv.global.js', '28.4', 0),
('92cc484feedef1f731c733f1bf6552de', './node_modules/@fullcalendar/core/locales/sv.global.min.js', '28.4', 0),
('5d2f091b796413db2272ac42fad17cbb', './node_modules/@fullcalendar/core/locales/sv.js', '28.4', 0),
('b0d048770cd79b24d5280c8972b6e611', './node_modules/@fullcalendar/core/locales/ta-in.global.js', '28.4', 0),
('3c8165569a1d8127ab7c8c718abb8803', './node_modules/@fullcalendar/core/locales/ta-in.global.min.js', '28.4', 0),
('f2d8cf0352ec6a937ef7345f8165b272', './node_modules/@fullcalendar/core/locales/ta-in.js', '28.4', 0),
('e65403f5067fa862263576d4eaee2aec', './node_modules/@fullcalendar/core/locales/th.global.js', '28.4', 0),
('6f66f98bb355d81fd02ce4d14b44b539', './node_modules/@fullcalendar/core/locales/th.global.min.js', '28.4', 0),
('e004a4011da56e06eb935a1ed5bd72b5', './node_modules/@fullcalendar/core/locales/th.js', '28.4', 0),
('720a998522666d1703e79cd0248171c1', './node_modules/@fullcalendar/core/locales/tr.global.js', '28.4', 0),
('62d9d94deae61e5e7af5d6fa1c3f1fe6', './node_modules/@fullcalendar/core/locales/tr.global.min.js', '28.4', 0),
('1e15a86d0fc7a78310eaba4625a50876', './node_modules/@fullcalendar/core/locales/tr.js', '28.4', 0),
('48b366b083907a389fb8984f99b2401c', './node_modules/@fullcalendar/core/locales/ug.global.js', '28.4', 0),
('02bebeed165fdbae2227f49587a74b8b', './node_modules/@fullcalendar/core/locales/ug.global.min.js', '28.4', 0),
('c3ae8e88d051d5fc2fd134181f3d2c21', './node_modules/@fullcalendar/core/locales/ug.js', '28.4', 0),
('0044e3d5b1cf56eb913bf34cdda555d9', './node_modules/@fullcalendar/core/locales/uk.global.js', '28.4', 0),
('f5e2122793a9acece022858937c98f26', './node_modules/@fullcalendar/core/locales/uk.global.min.js', '28.4', 0),
('9a5afaaf69564638c243226f2b6d57bb', './node_modules/@fullcalendar/core/locales/uk.js', '28.4', 0),
('ee28d5da83f563f3ae009d0e251c2537', './node_modules/@fullcalendar/core/locales/uz-cy.global.js', '28.4', 0),
('c0d04f01918584d1ed998b005bf1026c', './node_modules/@fullcalendar/core/locales/uz-cy.global.min.js', '28.4', 0),
('2337a550629aea354ba4bc78c12ccf85', './node_modules/@fullcalendar/core/locales/uz-cy.js', '28.4', 0),
('e58199381ecb753f2fc4ceb2f5ce33db', './node_modules/@fullcalendar/core/locales/uz.global.js', '28.4', 0),
('ad3d49cc759d9d5ef9324fa5a0d17642', './node_modules/@fullcalendar/core/locales/uz.global.min.js', '28.4', 0),
('d1c2fecc7bd74bdc14055c78d21dfca3', './node_modules/@fullcalendar/core/locales/uz.js', '28.4', 0),
('e21abfc06648bee45d851c9672642042', './node_modules/@fullcalendar/core/locales/vi.global.js', '28.4', 0),
('83b9e91729e1b1dc1e52102aa93396a7', './node_modules/@fullcalendar/core/locales/vi.global.min.js', '28.4', 0),
('a4861d67c813b9c06dfaa3844da36339', './node_modules/@fullcalendar/core/locales/vi.js', '28.4', 0),
('22fc8e30bb25054c3ac9d2ac515c58b7', './node_modules/@fullcalendar/core/locales/zh-cn.global.js', '28.4', 0),
('65733fc54477692164693c31e623b68c', './node_modules/@fullcalendar/core/locales/zh-cn.global.min.js', '28.4', 0),
('b1ddddc9d5429e393122c38aab09cddb', './node_modules/@fullcalendar/core/locales/zh-cn.js', '28.4', 0),
('86f84412e138fc72900d8900fff791da', './node_modules/@fullcalendar/core/locales/zh-tw.global.js', '28.4', 0),
('49c47cb880334c2ce69980e13ebb53ce', './node_modules/@fullcalendar/core/locales/zh-tw.global.min.js', '28.4', 0),
('6ff551e8d0fc46bd945ca6ac2b84c442', './node_modules/@fullcalendar/core/locales/zh-tw.js', '28.4', 0),
('fff99ccf841a82f4d0ff2b4aac8951f9', './node_modules/@fullcalendar/core/preact.js', '28.4', 0),
('0e41be0db830a63fa8118671f9596937', './node_modules/@fullcalendar/daygrid/index.global.js', '28.4', 0),
('6525e6f2d7721471d90caf76a93ed7fc', './node_modules/@fullcalendar/daygrid/index.global.min.js', '28.4', 0),
('d1d6f644a820ff80c9ea20ad8371af13', './node_modules/@fullcalendar/daygrid/index.js', '28.4', 0),
('a2efc2204c0d3a660b7c92e6d842a431', './node_modules/@fullcalendar/daygrid/internal.js', '28.4', 0),
('fc3c6d64c353fff7d80c162343ef240a', './node_modules/@fullcalendar/interaction/index.global.js', '28.4', 0),
('0f1caa52c20a915a13bd4182e167dae9', './node_modules/@fullcalendar/interaction/index.global.min.js', '28.4', 0),
('ed44762a29ca1d3b99237533fbf9a06a', './node_modules/@fullcalendar/interaction/index.js', '28.4', 0),
('42c99564a4a26e7953096e76c1c9ef57', './node_modules/@fullcalendar/list/index.global.js', '28.4', 0),
('051ce046bb7069efb43686bb9b82dda6', './node_modules/@fullcalendar/list/index.global.min.js', '28.4', 0),
('75a3037664bcb506b4cedc2c66b2b747', './node_modules/@fullcalendar/list/index.js', '28.4', 0),
('88fa87b002c3e42c49a75f3b16be3eeb', './node_modules/@fullcalendar/list/internal.js', '28.4', 0),
('6cede887eff69e076d5f0edebb310e02', './node_modules/@fullcalendar/premium-common/index.global.js', '28.4', 0),
('aa134fc7730f17d4413e70d3ea20122c', './node_modules/@fullcalendar/premium-common/index.global.min.js', '28.4', 0),
('9072ffa109f9450d9e8e68c60fd4c18d', './node_modules/@fullcalendar/premium-common/index.js', '28.4', 0),
('275a60eaf9eb70758c186022544b85b9', './node_modules/@fullcalendar/resource-daygrid/index.global.js', '28.4', 0),
('7a5c6253c4c7ed7d9fc1a306d4c84d29', './node_modules/@fullcalendar/resource-daygrid/index.global.min.js', '28.4', 0),
('1294b1c4df5c3abfd203da0a634fa373', './node_modules/@fullcalendar/resource-daygrid/index.js', '28.4', 0),
('82d424d58d4b111869a0b95f29225979', './node_modules/@fullcalendar/resource-daygrid/internal.js', '28.4', 0),
('0b6a0c7c31bc99951568a80e6de43247', './node_modules/@fullcalendar/resource-timegrid/index.global.js', '28.4', 0),
('bbf9b0518a9f7e0d266a25dbd8e253cc', './node_modules/@fullcalendar/resource-timegrid/index.global.min.js', '28.4', 0),
('3da4555aca378bd29d81b7826d8f3143', './node_modules/@fullcalendar/resource-timegrid/index.js', '28.4', 0),
('dff4fcd72e63264824d2c7d56f5273ec', './node_modules/@fullcalendar/resource-timegrid/internal.js', '28.4', 0),
('3242e67e7ed7d3249c9e66c8806f0e94', './node_modules/@fullcalendar/resource-timeline/index.global.js', '28.4', 0),
('05f7d9d8a613564710f915d88116096d', './node_modules/@fullcalendar/resource-timeline/index.global.min.js', '28.4', 0),
('ac07004d8f60d8a1688a94905b053b7f', './node_modules/@fullcalendar/resource-timeline/index.js', '28.4', 0),
('4f178dcf00f49cd650211e404d6a4019', './node_modules/@fullcalendar/resource-timeline/internal.js', '28.4', 0),
('160c26594f39a4246d2bae103b9c0419', './node_modules/@fullcalendar/resource/index.global.js', '28.4', 0),
('f718062b762fe3f7cad270d5079456aa', './node_modules/@fullcalendar/resource/index.global.min.js', '28.4', 0),
('d630b37bb85c753a9a9f4f84e233bdf8', './node_modules/@fullcalendar/resource/index.js', '28.4', 0),
('01f3a292a1dba4ed640d4d9b20f2f1fb', './node_modules/@fullcalendar/resource/internal-common.js', '28.4', 0),
('ca3701ebfcb1f20c6fe386ff2614dd51', './node_modules/@fullcalendar/resource/internal.js', '28.4', 0),
('e7f8fcbd6028ce208fd84b510c99c001', './node_modules/@fullcalendar/scrollgrid/index.global.js', '28.4', 0),
('0e7bd2f255f79fb1f4c9a76ff0793e76', './node_modules/@fullcalendar/scrollgrid/index.global.min.js', '28.4', 0),
('6852f8e179f0d4070eeab1c7c5ce40ff', './node_modules/@fullcalendar/scrollgrid/index.js', '28.4', 0),
('6eb3324523b0f94d2e1cbfa561b98633', './node_modules/@fullcalendar/scrollgrid/internal.js', '28.4', 0),
('61ea4a85eec0790dea62684b135835b9', './node_modules/@fullcalendar/timegrid/index.global.js', '28.4', 0),
('e542975f4f116b58bb0f4cdd1045ab1c', './node_modules/@fullcalendar/timegrid/index.global.min.js', '28.4', 0),
('8cac69ac08fc656e2c1f7bbcb1ba91ef', './node_modules/@fullcalendar/timegrid/index.js', '28.4', 0),
('d957b70bf5c030fbc95e1d7deffe8f4d', './node_modules/@fullcalendar/timegrid/internal.js', '28.4', 0),
('d6827db63286512946f48d4f8018e3b6', './node_modules/@fullcalendar/timeline/index.global.js', '28.4', 0),
('e794d1bdbdbf9a6d616a89f3ebbfd9cd', './node_modules/@fullcalendar/timeline/index.global.min.js', '28.4', 0),
('f767eb9ca6134cbe6995a3ccd5940d45', './node_modules/@fullcalendar/timeline/index.js', '28.4', 0),
('58304c1616d43bee4c97adf3629fbfc9', './node_modules/@fullcalendar/timeline/internal.js', '28.4', 0),
('083d29f34785b976b2e867dacbaaa543', './node_modules/@humanfs/core/src/errors.js', '28.4', 0),
('6aeee4a9431de49e6f84f67c4226435c', './node_modules/@humanfs/core/src/hfs.js', '28.4', 0),
('842e7076b6b4a56c062ee0512efdf0f5', './node_modules/@humanfs/core/src/index.js', '28.4', 0),
('61e5d1d75b6f8a70830ed7604756640f', './node_modules/@humanfs/core/src/path.js', '28.4', 0),
('a0454f5a5404e67e4e8c847fbab36975', './node_modules/@humanfs/node/src/index.js', '28.4', 0),
('4bbf02f7a29a513e60151157072cf74f', './node_modules/@humanfs/node/src/node-hfs.js', '28.4', 0),
('3fda6aedf386dbf20c4a6c427aa9b945', './node_modules/@humanwhocodes/module-importer/dist/module-importer.js', '28.4', 0),
('afaabd750391f23d56ff7d13756ab1d6', './node_modules/@humanwhocodes/module-importer/src/module-importer.js', '28.4', 0),
('56a2bbcf85f8cde00e55dd0507d71a4a', './node_modules/@humanwhocodes/retry/dist/retrier.js', '28.4', 0),
('9a0c81bb67b820616717e7a3f0526881', './node_modules/@humanwhocodes/retry/dist/retrier.min.js', '28.4', 0),
('6b680292c31b2ab073915df380940266', './node_modules/@interactjs/types/index.js', '28.4', 0),
('3dace3c3771f05b4783e86ccc1d1f017', './node_modules/@interactjs/types/index.prod.js', '28.4', 0),
('3df08507ebeb83a522978c95a0e11631', './node_modules/@isaacs/cliui/build/lib/index.js', '28.4', 0),
('a91efb7c51f14654fd93ef9fe8070618', './node_modules/@istanbuljs/schema/default-exclude.js', '28.4', 0),
('29d24f17d70dc305052003a2a877dec9', './node_modules/@istanbuljs/schema/default-extension.js', '28.4', 0),
('2d84a271b166ca95ab5b783859b5d3c8', './node_modules/@istanbuljs/schema/index.js', '28.4', 0),
('c5fbaaddfc421f6dfe06158b0f078a97', './node_modules/@jridgewell/gen-mapping/dist/gen-mapping.umd.js', '28.4', 0),
('1895d57b7b67bf99fa5f8e8eaa3d42b2', './node_modules/@jridgewell/resolve-uri/dist/resolve-uri.umd.js', '28.4', 0),
('7e28cf987eb0d4524e21b2d655ece771', './node_modules/@jridgewell/set-array/dist/set-array.umd.js', '28.4', 0),
('9243f8dc6a3e272f7006fdc2cdef30b9', './node_modules/@jridgewell/sourcemap-codec/dist/sourcemap-codec.umd.js', '28.4', 0),
('145e328dac69aff23609531727da0180', './node_modules/@jridgewell/trace-mapping/dist/trace-mapping.umd.js', '28.4', 0),
('96edb7e8b1089fbd8688c072e2c7dc10', './node_modules/@kurkle/color/dist/color.esm.js', '28.4', 0),
('70f9931cc48805ebd60ea81f73b34f31', './node_modules/@kurkle/color/dist/color.min.js', '28.4', 0),
('71ee28714541a937b281725af9ab29d7', './node_modules/@lit-labs/ssr-dom-shim/index.js', '28.4', 0),
('71eabdf4af3de228b29429670c8f434f', './node_modules/@lit-labs/ssr-dom-shim/lib/element-internals.js', '28.4', 0),
('8d3767179744a228f48c746ed5d61224', './node_modules/@lit/react/create-component.js', '28.4', 0),
('ad8b84a1ff228080a347b6d4134d386c', './node_modules/@lit/react/development/create-component.js', '28.4', 0),
('c3470025f97396670355936cc89ccfef', './node_modules/@lit/react/development/index.js', '28.4', 0),
('3b062c3473336f0fc645adeae3db940b', './node_modules/@lit/react/development/use-controller.js', '28.4', 0),
('e609650931f303edbb7e5fd8b5c4cdc2', './node_modules/@lit/react/index.js', '28.4', 0),
('2a3da208085021446b5b307e971932fd', './node_modules/@lit/react/node/create-component.js', '28.4', 0),
('ab2841cf02da3c56d08e657b9298dd65', './node_modules/@lit/react/node/development/create-component.js', '28.4', 0),
('fcebd1cc83c6d2fc9b9b94ba8220c99d', './node_modules/@lit/react/node/development/index.js', '28.4', 0),
('4395522fbae38563466f49f026c4ff07', './node_modules/@lit/react/node/development/use-controller.js', '28.4', 0),
('e609650931f303edbb7e5fd8b5c4cdc2', './node_modules/@lit/react/node/index.js', '28.4', 0),
('c27ce3b919d2e64c2ae6a906bfdbd066', './node_modules/@lit/react/node/use-controller.js', '28.4', 0),
('c27ce3b919d2e64c2ae6a906bfdbd066', './node_modules/@lit/react/use-controller.js', '28.4', 0),
('40215bf46bb1dce75e3a863b4463921a', './node_modules/@lit/reactive-element/css-tag.js', '28.4', 0),
('6141720105f9800f2f7a1269e56a0a93', './node_modules/@lit/reactive-element/decorators.js', '28.4', 0),
('4e995b35b287f0752a49e63b5f82204c', './node_modules/@lit/reactive-element/decorators/base.js', '28.4', 0),
('17caa0d791801bdcc2e0d26b7b61bcd0', './node_modules/@lit/reactive-element/decorators/custom-element.js', '28.4', 0),
('d6e9389bef7b27289d7b494345b84375', './node_modules/@lit/reactive-element/decorators/event-options.js', '28.4', 0),
('bdf295220a8771537afccc9be7cb565b', './node_modules/@lit/reactive-element/decorators/property.js', '28.4', 0),
('4374217ab9302f95404667e27bf00564', './node_modules/@lit/reactive-element/decorators/query-all.js', '28.4', 0),
('ee1e92f667cd7ab7573c674d68645745', './node_modules/@lit/reactive-element/decorators/query-assigned-elements.js', '28.4', 0),
('871759d65833d64d3ed5c0ad45ff6c6f', './node_modules/@lit/reactive-element/decorators/query-assigned-nodes.js', '28.4', 0),
('4103bb46d7416f2364cb2c49c653f359', './node_modules/@lit/reactive-element/decorators/query-async.js', '28.4', 0),
('5610c269f6e84849de9a098ccc497748', './node_modules/@lit/reactive-element/decorators/query.js', '28.4', 0),
('7718aa205dce2af4cad43b4150b50219', './node_modules/@lit/reactive-element/decorators/state.js', '28.4', 0),
('4a166365989e82ea05e8ab384ee47656', './node_modules/@lit/reactive-element/development/css-tag.js', '28.4', 0),
('79b276eade9a5df100bf5771db850828', './node_modules/@lit/reactive-element/development/decorators.js', '28.4', 0),
('33efd70c2d25a6dbce2a5a491409f632', './node_modules/@lit/reactive-element/development/decorators/base.js', '28.4', 0),
('7089ff9599fd7b884e3ade6f12765515', './node_modules/@lit/reactive-element/development/decorators/custom-element.js', '28.4', 0),
('a0fc348efe8eb24e2b12203cc6804a5e', './node_modules/@lit/reactive-element/development/decorators/event-options.js', '28.4', 0),
('182061d347a6b1c07394373c7e13dd6c', './node_modules/@lit/reactive-element/development/decorators/property.js', '28.4', 0),
('d936c91cf8e7dc9e97d0a439d362bc95', './node_modules/@lit/reactive-element/development/decorators/query-all.js', '28.4', 0),
('e71afa1e6e25bbc8c82dc163a3e568f9', './node_modules/@lit/reactive-element/development/decorators/query-assigned-elements.js', '28.4', 0),
('c6d0a4ebe8293aa3060531e47a3ac348', './node_modules/@lit/reactive-element/development/decorators/query-assigned-nodes.js', '28.4', 0),
('3de7da1fac0ea22a95966281dadba06a', './node_modules/@lit/reactive-element/development/decorators/query-async.js', '28.4', 0),
('c8304ec1f233c21363331da4a38cd639', './node_modules/@lit/reactive-element/development/decorators/query.js', '28.4', 0),
('5ac650361fb15e19f4d842f0fbb08f2a', './node_modules/@lit/reactive-element/development/decorators/state.js', '28.4', 0),
('292a650013b455a6ecb58f57186a454f', './node_modules/@lit/reactive-element/development/polyfill-support.js', '28.4', 0),
('8ddf4f4ba4a58fd0cf507b392b82221e', './node_modules/@lit/reactive-element/development/reactive-controller.js', '28.4', 0),
('b2b0454ecbded0af47b6dc58adf617bf', './node_modules/@lit/reactive-element/development/reactive-element.js', '28.4', 0),
('a0b09027a9488a3011a748bc6a34b929', './node_modules/@lit/reactive-element/node/css-tag.js', '28.4', 0),
('6141720105f9800f2f7a1269e56a0a93', './node_modules/@lit/reactive-element/node/decorators.js', '28.4', 0),
('4e995b35b287f0752a49e63b5f82204c', './node_modules/@lit/reactive-element/node/decorators/base.js', '28.4', 0),
('17caa0d791801bdcc2e0d26b7b61bcd0', './node_modules/@lit/reactive-element/node/decorators/custom-element.js', '28.4', 0),
('d6e9389bef7b27289d7b494345b84375', './node_modules/@lit/reactive-element/node/decorators/event-options.js', '28.4', 0),
('bdf295220a8771537afccc9be7cb565b', './node_modules/@lit/reactive-element/node/decorators/property.js', '28.4', 0),
('4374217ab9302f95404667e27bf00564', './node_modules/@lit/reactive-element/node/decorators/query-all.js', '28.4', 0),
('ee1e92f667cd7ab7573c674d68645745', './node_modules/@lit/reactive-element/node/decorators/query-assigned-elements.js', '28.4', 0),
('871759d65833d64d3ed5c0ad45ff6c6f', './node_modules/@lit/reactive-element/node/decorators/query-assigned-nodes.js', '28.4', 0),
('4103bb46d7416f2364cb2c49c653f359', './node_modules/@lit/reactive-element/node/decorators/query-async.js', '28.4', 0),
('5610c269f6e84849de9a098ccc497748', './node_modules/@lit/reactive-element/node/decorators/query.js', '28.4', 0),
('7718aa205dce2af4cad43b4150b50219', './node_modules/@lit/reactive-element/node/decorators/state.js', '28.4', 0),
('8127db71fbca7b59db6a522079eb4fe7', './node_modules/@lit/reactive-element/node/development/css-tag.js', '28.4', 0),
('9012beb51f33a00ecc0b8fd75ac82721', './node_modules/@lit/reactive-element/node/development/decorators.js', '28.4', 0),
('2cbfef46fed07ecbf8cad1961a18ecfa', './node_modules/@lit/reactive-element/node/development/decorators/base.js', '28.4', 0),
('47c8d42c06fed73f90c7de4f987b3c5b', './node_modules/@lit/reactive-element/node/development/decorators/custom-element.js', '28.4', 0),
('e5d4b67d164b821e070ce8d5080789a4', './node_modules/@lit/reactive-element/node/development/decorators/event-options.js', '28.4', 0),
('01bde7778c626194a462e63083c4c061', './node_modules/@lit/reactive-element/node/development/decorators/property.js', '28.4', 0),
('8e0a91bc6ce1b9d7f54f35a1fd6f5636', './node_modules/@lit/reactive-element/node/development/decorators/query-all.js', '28.4', 0),
('826452bf15782b247a2fb503c1573ff6', './node_modules/@lit/reactive-element/node/development/decorators/query-assigned-elements.js', '28.4', 0),
('87eace3af8053cf12527a6dc41785da5', './node_modules/@lit/reactive-element/node/development/decorators/query-assigned-nodes.js', '28.4', 0),
('135d843d8dca5b78a8aeaf33ee534238', './node_modules/@lit/reactive-element/node/development/decorators/query-async.js', '28.4', 0),
('2d505acd75ba6bb8dfaef51f03f0267d', './node_modules/@lit/reactive-element/node/development/decorators/query.js', '28.4', 0),
('0011e38ba9261c23478198854c6a0250', './node_modules/@lit/reactive-element/node/development/decorators/state.js', '28.4', 0),
('b84367e4067a28560a6461f130e0619c', './node_modules/@lit/reactive-element/node/development/reactive-controller.js', '28.4', 0),
('7deba0d9611dcf10f016808765eff3e2', './node_modules/@lit/reactive-element/node/development/reactive-element.js', '28.4', 0),
('b84367e4067a28560a6461f130e0619c', './node_modules/@lit/reactive-element/node/reactive-controller.js', '28.4', 0),
('e1b4863a8757c0b147fd519f3c5ca457', './node_modules/@lit/reactive-element/node/reactive-element.js', '28.4', 0),
('3b7a62eac7bd4f6ca16a398745c5007d', './node_modules/@lit/reactive-element/polyfill-support.js', '28.4', 0),
('b84367e4067a28560a6461f130e0619c', './node_modules/@lit/reactive-element/reactive-controller.js', '28.4', 0),
('512ed6ffce7771d25ef0c540f1745c52', './node_modules/@lit/reactive-element/reactive-element.js', '28.4', 0),
('77680c90a123803fa71f44867c93ff94', './node_modules/@mapbox/geojson-rewind/index.js', '28.4', 0),
('f8853e30e76fd62701e9b0e47739d5bc', './node_modules/@mapbox/geojson-types/generate-fixtures.js', '28.4', 0),
('246ca438666208682046ac31b5c2f745', './node_modules/@mapbox/geojson-types/index.js', '28.4', 0),
('e7adeab2e73f729cfa4a160baa10ebb1', './node_modules/@mapbox/geojson-types/test.js', '28.4', 0),
('b5c20b66fbead12a264b37f0210d2ff4', './node_modules/@mapbox/jsonlint-lines-primitives/lib/formatter.js', '28.4', 0),
('620b4f63f8568ac7515f6b25e636b90c', './node_modules/@mapbox/jsonlint-lines-primitives/lib/jsonlint.js', '28.4', 0),
('58f177cfcc868266c6fe21ed70241d83', './node_modules/@mapbox/jsonlint-lines-primitives/scripts/bundle.js', '28.4', 0),
('28023c46caef695fb29498e141c91d2d', './node_modules/@mapbox/jsonlint-lines-primitives/test/all-tests.js', '28.4', 0),
('895bd455c90e299356335b2890b9713d', './node_modules/@mapbox/jsonlint-lines-primitives/web/json2.js', '28.4', 0),
('be2f772f402d13e438b95814bce78371', './node_modules/@mapbox/jsonlint-lines-primitives/web/jsonlint.js', '28.4', 0),
('622298243c911bad7b03cce5fa7a78a8', './node_modules/@mapbox/mapbox-gl-supported/index.js', '28.4', 0),
('35340ade71a9858a8c643c6dcd5f2343', './node_modules/@mapbox/point-geometry/index.js', '28.4', 0),
('9abc695465b90b40d3987a9564f2446a', './node_modules/@mapbox/point-geometry/test.js', '28.4', 0),
('fd409258622d3186d5ee7dcf418a4f00', './node_modules/@mapbox/tiny-sdf/index.js', '28.4', 0),
('752f0450a05df9e1c8420a2e85956b4c', './node_modules/@mapbox/unitbezier/index.js', '28.4', 0),
('26bd88174d2f362e6a93d04580d15d66', './node_modules/@mapbox/unitbezier/test/unitbezier.js', '28.4', 0),
('73875d302e37d19a34846e4504cf6884', './node_modules/@mapbox/vector-tile/fixtures.js', '28.4', 0),
('8d05100e4dc8647f9da7d2d043714c4e', './node_modules/@mapbox/vector-tile/index.js', '28.4', 0),
('5c681b1a2e464a2a54f186e294a71a2e', './node_modules/@mapbox/vector-tile/lib/vectortile.js', '28.4', 0),
('16c2e9ab506c99fdd76c1cdbe981b069', './node_modules/@mapbox/vector-tile/lib/vectortilefeature.js', '28.4', 0),
('43081f1dd053df19f3a8750b0db1436f', './node_modules/@mapbox/vector-tile/lib/vectortilelayer.js', '28.4', 0),
('c2f27099f45a905bd0ba4792a5dad1a6', './node_modules/@mapbox/vector-tile/test/bench.js', '28.4', 0),
('3a0b74327ed194ab7894e776c8c02273', './node_modules/@mapbox/vector-tile/test/parse.test.js', '28.4', 0),
('fc86ba2f593a804f7083fc5ee2b65305', './node_modules/@mapbox/whoots-js/index.js', '28.4', 0),
('e588938b69c374465a61fa07342515c5', './node_modules/@mapbox/whoots-js/server.js', '28.4', 0),
('f8b0df62e8067a3bbcb2863b62e5ed0d', './node_modules/@nodelib/fs.scandir/out/adapters/fs.js', '28.4', 0),
('8849d58892818a3f95e9531f2c0e1a75', './node_modules/@nodelib/fs.scandir/out/constants.js', '28.4', 0),
('60e0c0cd8a75d4d9e19ea44e7d16fc37', './node_modules/@nodelib/fs.scandir/out/index.js', '28.4', 0),
('bba81ccbb6f3d1de80e54e0a0e5197b4', './node_modules/@nodelib/fs.scandir/out/providers/async.js', '28.4', 0),
('c53470b2b3eff0ce5ea467ca25fe2e81', './node_modules/@nodelib/fs.scandir/out/providers/common.js', '28.4', 0),
('b310573ecb367bfc343097211d4bf817', './node_modules/@nodelib/fs.scandir/out/providers/sync.js', '28.4', 0),
('70cc35e063d1f190c0be5444f645bdcf', './node_modules/@nodelib/fs.scandir/out/settings.js', '28.4', 0),
('8963201168a2449f79025884824955f2', './node_modules/@nodelib/fs.scandir/out/types/index.js', '28.4', 0),
('faf018e3413a4568133a8b363582565f', './node_modules/@nodelib/fs.scandir/out/utils/fs.js', '28.4', 0),
('c00a6767cd54f6fc8253d5372b8f93c3', './node_modules/@nodelib/fs.scandir/out/utils/index.js', '28.4', 0),
('8696e1091f3cd8822022a63c0353c942', './node_modules/@nodelib/fs.stat/out/adapters/fs.js', '28.4', 0),
('f656391358f0820bfc807ad8fef8b87d', './node_modules/@nodelib/fs.stat/out/index.js', '28.4', 0),
('97816dc2b13d0e82704191a609952cfa', './node_modules/@nodelib/fs.stat/out/providers/async.js', '28.4', 0),
('f30bb890f636603e66e2ac30206d0fd8', './node_modules/@nodelib/fs.stat/out/providers/sync.js', '28.4', 0),
('7ae4e14ea2b676153b478e06878bd035', './node_modules/@nodelib/fs.stat/out/settings.js', '28.4', 0),
('8963201168a2449f79025884824955f2', './node_modules/@nodelib/fs.stat/out/types/index.js', '28.4', 0),
('c1f6e660588443f7c42d9e57842974d8', './node_modules/@nodelib/fs.walk/out/index.js', '28.4', 0),
('03d9b766d05b2e0cb87e52a72cc8dabd', './node_modules/@nodelib/fs.walk/out/providers/async.js', '28.4', 0),
('ae05d387c83cc07a1cde3a7855096774', './node_modules/@nodelib/fs.walk/out/providers/index.js', '28.4', 0),
('af8e9ff0b1be710d47cbb5732b53ed06', './node_modules/@nodelib/fs.walk/out/providers/stream.js', '28.4', 0),
('3840c1f4f8a7d1868bc07948c0dd3e41', './node_modules/@nodelib/fs.walk/out/providers/sync.js', '28.4', 0),
('0c1014f0d9722c9a90aed14571919a00', './node_modules/@nodelib/fs.walk/out/readers/async.js', '28.4', 0),
('929756d0b5550d9fb03de7c2171f5bd7', './node_modules/@nodelib/fs.walk/out/readers/common.js', '28.4', 0),
('b477f09bcb040f0aca3acf7fc9d4872e', './node_modules/@nodelib/fs.walk/out/readers/reader.js', '28.4', 0),
('eb5ae2efebfddc4bebead911c485f237', './node_modules/@nodelib/fs.walk/out/readers/sync.js', '28.4', 0),
('d9432524dbc5df674c43c24b55cea95f', './node_modules/@nodelib/fs.walk/out/settings.js', '28.4', 0),
('8963201168a2449f79025884824955f2', './node_modules/@nodelib/fs.walk/out/types/index.js', '28.4', 0),
('de8a4ed7cfb69ccd9a9b5d20f56a7d50', './node_modules/@one-ini/wasm/one_ini.js', '28.4', 0),
('1614bb07d57071974243925eeaf855ef', './node_modules/@parcel/watcher/index.js', '28.4', 0),
('446d2e814774f25bbfd0e73406c534e1', './node_modules/@parcel/watcher/wrapper.js', '28.4', 0),
('4d5546f0c10ee489d75e260f749e4972', './node_modules/@pkgjs/parseargs/examples/is-default-value.js', '28.4', 0),
('ee5ef079543cbdb0b7a1c188508d5d96', './node_modules/@pkgjs/parseargs/examples/limit-long-syntax.js', '28.4', 0),
('b9c2a455634701fa38b2c7eda9ad4f06', './node_modules/@pkgjs/parseargs/examples/negate.js', '28.4', 0),
('633ee76daf2d50666766f90f2320045d', './node_modules/@pkgjs/parseargs/examples/no-repeated-options.js', '28.4', 0),
('42f2991a03b67d1f3560206998b25e23', './node_modules/@pkgjs/parseargs/examples/simple-hard-coded.js', '28.4', 0),
('ccb9c7d4a494b34de1269083a45b0bba', './node_modules/@pkgjs/parseargs/index.js', '28.4', 0),
('31b2dd2a19fd8d4f6c31d2e88cf1a8a2', './node_modules/@pkgjs/parseargs/internal/errors.js', '28.4', 0),
('e62ffa4caa7cda62ac9dd68a6e2d94bb', './node_modules/@pkgjs/parseargs/internal/primordials.js', '28.4', 0),
('3b23fd21e57d2c5e08b3ae4c47d0d0e4', './node_modules/@pkgjs/parseargs/internal/util.js', '28.4', 0),
('0fa32d2e5befaf696235a8e16140a466', './node_modules/@pkgjs/parseargs/internal/validators.js', '28.4', 0),
('2a85443866452a33c48ca9a03ca6fc2c', './node_modules/@pkgjs/parseargs/utils.js', '28.4', 0),
('393aff3e5ee66dd05ef0612503ecc5f0', './node_modules/@pkgr/core/lib/constants.js', '28.4', 0),
('f2ab4f858095d669f4b24cd2dbaaa62f', './node_modules/@pkgr/core/lib/helpers.js', '28.4', 0),
('c77c3c01fce0097261dc631d526cc33b', './node_modules/@pkgr/core/lib/index.js', '28.4', 0),
('dd04b80b6c75fb8e3c60cd8908a4c889', './node_modules/@plotly/d3-sankey-circular/dist/d3-sankey-circular.es.js', '28.4', 0),
('90e95cb103dec28a5ab8f722d538b542', './node_modules/@plotly/d3-sankey-circular/dist/d3-sankey-circular.js', '28.4', 0),
('3f1fbc6058a428d906bedb95e2b06704', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/dist/d3-array.js', '28.4', 0),
('e3337e4143693e436ddb96b7668a72fa', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/dist/d3-array.min.js', '28.4', 0),
('ff782c7d5563cdc90075f3e0c50b8c51', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/rollup.config.js', '28.4', 0),
('216184c3dfa038b826dc216016311a78', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/array.js', '28.4', 0),
('a5c80bdf7d0f582fec4025f9e52d231e', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ascending.js', '28.4', 0),
('e15107a7a55695c5c898350a41e2e561', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisect.js', '28.4', 0),
('d367d28262ac9f9e43fb9b66624f44e7', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/bisector.js', '28.4', 0),
('a1357c443358780f687c6c9c4d55b2b4', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/constant.js', '28.4', 0),
('5977eb8ccb6e4261eda1833d692b7434', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/cross.js', '28.4', 0),
('627bb774ffc0129fe72c18b4991a7fc4', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/descending.js', '28.4', 0),
('58b12251be8037f67bf318fb10169c1c', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/deviation.js', '28.4', 0),
('1b3e5fc82da6fabd760ab6fb4bb4d745', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/extent.js', '28.4', 0),
('e66549ca3c4b809314e7e5c268c41ac2', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/histogram.js', '28.4', 0),
('2c96b7b0fae47211712f7263228f1555', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/identity.js', '28.4', 0),
('b267e3208ff83b7cd7da8d8c0014afdf', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/index.js', '28.4', 0),
('51f64338ac864d53d5d70c0e2af340a1', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/max.js', '28.4', 0),
('16f90b4d0fbfd0f8f6e9deef3c0242c2', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/mean.js', '28.4', 0),
('bbda2a9a2248c94ad6311d1869b32064', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/median.js', '28.4', 0),
('7123f4a7a2a7bc23e1b56dc74ae29bd2', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/merge.js', '28.4', 0),
('3f67c95cf4aca8d23de6e972ecf90f3d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/min.js', '28.4', 0),
('9e09673761709c28a9d95e552d466e27', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/number.js', '28.4', 0),
('ed9e689404897590a42766f15901b989', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/pairs.js', '28.4', 0),
('5e5f5ebd25725ec83177ef0b46a3259f', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/permute.js', '28.4', 0),
('163c8444ee472da028874265760e6168', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/quantile.js', '28.4', 0),
('523066cdb9568521bee6f9a12716f52b', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/range.js', '28.4', 0),
('7840656fe3067dcdcf337e36ecfccfc8', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/scan.js', '28.4', 0),
('5a14dcd180c41c5cc65f5b0bda8660a4', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/shuffle.js', '28.4', 0),
('39401e09f912407eb88a578ae9fcf414', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/sum.js', '28.4', 0),
('3a7347d06bbfcf431a2449fc527d0c74', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/freedmanDiaconis.js', '28.4', 0),
('90705c34ddbac8e1ca741a646097576b', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/scott.js', '28.4', 0),
('824c3657b2a39a324f7429ec29d2cc24', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/threshold/sturges.js', '28.4', 0),
('1ac39d9a328fab0c194c9a4a264928a4', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/ticks.js', '28.4', 0),
('4cbf205c592290765b8ec0afe3992be1', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/transpose.js', '28.4', 0),
('4112d0f2f7d82e15ce91b193c87ce439', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/variance.js', '28.4', 0),
('8bb754b1adc9137d602059f5d1cca9b6', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-array/src/zip.js', '28.4', 0),
('6d76b62d608ce75eb1e10032e9229652', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/dist/d3-path.js', '28.4', 0),
('10db9895732d2d7f8b378bf7e3fc2f6d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/dist/d3-path.min.js', '28.4', 0),
('310e08152d639a9c1db450c294abb87d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/index.js', '28.4', 0),
('37c236c830446ee74ce315604c7d3b4e', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-path/src/path.js', '28.4', 0),
('2d2fe33e82a6656e785e025f8d48b418', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/dist/d3-shape.js', '28.4', 0),
('9cf9c65b4aa0fd5992f5ff228da69247', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/dist/d3-shape.min.js', '28.4', 0),
('f6d431fc64c54f9fcce76fae56618eaa', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/arc.js', '28.4', 0),
('d7ea70387dd4054c8b4dab97f5f05e49', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/area.js', '28.4', 0),
('2986c672d312e3fc3b85601e0078c51d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/areaRadial.js', '28.4', 0),
('e4d54736adebf9ddb31c1c70ea8ed2d3', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/array.js', '28.4', 0),
('d045c96fcb9ca2bebe001fa351da0d0d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/constant.js', '28.4', 0),
('b28b81a3475fa10926159d8b25edd4af', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basis.js', '28.4', 0),
('cc4ac3aac17f171a63723263feaa53ef', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisClosed.js', '28.4', 0),
('cb6b7ca9ecfdf41a6635243845ddf43d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/basisOpen.js', '28.4', 0),
('e6b70d762566f77baa9cf1d1ca7cb0bd', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/bundle.js', '28.4', 0),
('a8f9439316202508f7aa104d59e5f46d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinal.js', '28.4', 0),
('9cbe5cfcad0340a529b45dd7e35cfc43', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalClosed.js', '28.4', 0),
('ef987e68a6e22a556667a87530eadd9c', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/cardinalOpen.js', '28.4', 0),
('9d3809cd9dc895e6130dc49b98da6edf', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRom.js', '28.4', 0),
('244e26a8c285b2ec8ae0fd90b8dfc497', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomClosed.js', '28.4', 0),
('96168d2498cf542736ac2bbb80a76caa', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/catmullRomOpen.js', '28.4', 0),
('a3f7b194af73d59fe2e334372e3dbb92', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linear.js', '28.4', 0),
('3a81fba9192aa7e448361d47a2ac387b', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/linearClosed.js', '28.4', 0),
('905277ab4e4253d6b46bc8eb884ebbd8', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/monotone.js', '28.4', 0),
('2633730d398af5876636e4e8fc079ff0', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/natural.js', '28.4', 0),
('a33d27ab525ba59dce06735d1c58bf20', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/radial.js', '28.4', 0),
('c2b8864699b7da02a668dd268cd0ef11', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/curve/step.js', '28.4', 0),
('627bb774ffc0129fe72c18b4991a7fc4', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/descending.js', '28.4', 0),
('941d1d07223f468a439d47b6124e38ad', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/identity.js', '28.4', 0),
('187c3f15618504cb09feee53d13d94b6', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/index.js', '28.4', 0),
('d3c340cf0f3c3f99f7aa071a57969632', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/line.js', '28.4', 0),
('cfc502519d1467524797ee93bdd2a18f', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/lineRadial.js', '28.4', 0),
('534796e1559825777d3535136216b563', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/link/index.js', '28.4', 0),
('4b44462b8ce1a00bfcf33c6965cb33da', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/math.js', '28.4', 0),
('fa7a68d114b90631634736836c0462dc', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/noop.js', '28.4', 0),
('3af65aebdd084bfcce876b0cbbd981a2', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/diverging.js', '28.4', 0),
('1e1df1b2c09209345eb11591bb14d4fc', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/expand.js', '28.4', 0),
('734a071976de0ed7444a9dc6074f5a23', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/none.js', '28.4', 0),
('16b8979ae383f4a0ebc0b27e5c6a2c15', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/silhouette.js', '28.4', 0),
('b1e227abe71d19b6421dee0ccbd4e96d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/offset/wiggle.js', '28.4', 0),
('ad0fee06055065d388735bd4f40457a1', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/appearance.js', '28.4', 0),
('4337f54b59854dbc4f933046a530c558', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/ascending.js', '28.4', 0),
('cd3d5d15c8f3616351689a109356aee8', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/descending.js', '28.4', 0),
('c6b64fa955917776cc180b80c4da8a6d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/insideOut.js', '28.4', 0),
('dec7b0a5e256aee00030add16c9f79be', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/none.js', '28.4', 0),
('83ae0c4bc16530e94ec06b54074c1e0e', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/order/reverse.js', '28.4', 0),
('ccb0bd3ddbde29ff2d4ef017d6db7ee4', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pie.js', '28.4', 0),
('b819e597c44854bebfaad3891a89879d', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/point.js', '28.4', 0),
('97cb5d6999026e3d54868c57eec56d81', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/pointRadial.js', '28.4', 0),
('56cede3fd5142c8b93c38d8f1d4d150e', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/stack.js', '28.4', 0),
('a9d9b383d99c87bd0c28ebd4326ba7a6', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol.js', '28.4', 0),
('1fbb9d8c6e2be20e912613de6c173aa6', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/circle.js', '28.4', 0),
('f1cc73a597085a0d9558415d7b1351fc', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/cross.js', '28.4', 0),
('b70347100de242968d66bc5449cafc07', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/diamond.js', '28.4', 0),
('a300f4c7c827254388af7cecde3e522b', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/square.js', '28.4', 0),
('65ad1680e607be1a7f2afa40564d627f', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/star.js', '28.4', 0),
('518a0bf978dae83ff7eca5e5f682e136', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/triangle.js', '28.4', 0),
('acb70c83981ca2ccfbfddc1d6af3e9f9', './node_modules/@plotly/d3-sankey-circular/node_modules/d3-shape/src/symbol/wye.js', '28.4', 0),
('2c8b2bd163de60539032667998058ed2', './node_modules/@plotly/d3-sankey/build/d3-sankey.js', '28.4', 0),
('985aaa58f47491196e953601ac5bed60', './node_modules/@plotly/d3-sankey/build/d3-sankey.min.js', '28.4', 0),
('ae1039f2829dfaf73f7655f20da98f84', './node_modules/@plotly/d3-sankey/index.js', '28.4', 0),
('3f1fbc6058a428d906bedb95e2b06704', './node_modules/@plotly/d3-sankey/node_modules/d3-array/dist/d3-array.js', '28.4', 0),
('e3337e4143693e436ddb96b7668a72fa', './node_modules/@plotly/d3-sankey/node_modules/d3-array/dist/d3-array.min.js', '28.4', 0),
('ff782c7d5563cdc90075f3e0c50b8c51', './node_modules/@plotly/d3-sankey/node_modules/d3-array/rollup.config.js', '28.4', 0),
('216184c3dfa038b826dc216016311a78', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/array.js', '28.4', 0),
('a5c80bdf7d0f582fec4025f9e52d231e', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ascending.js', '28.4', 0),
('e15107a7a55695c5c898350a41e2e561', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisect.js', '28.4', 0),
('d367d28262ac9f9e43fb9b66624f44e7', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/bisector.js', '28.4', 0),
('a1357c443358780f687c6c9c4d55b2b4', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/constant.js', '28.4', 0),
('5977eb8ccb6e4261eda1833d692b7434', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/cross.js', '28.4', 0),
('627bb774ffc0129fe72c18b4991a7fc4', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/descending.js', '28.4', 0),
('58b12251be8037f67bf318fb10169c1c', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/deviation.js', '28.4', 0),
('1b3e5fc82da6fabd760ab6fb4bb4d745', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/extent.js', '28.4', 0),
('e66549ca3c4b809314e7e5c268c41ac2', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/histogram.js', '28.4', 0),
('2c96b7b0fae47211712f7263228f1555', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/identity.js', '28.4', 0),
('b267e3208ff83b7cd7da8d8c0014afdf', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/index.js', '28.4', 0),
('51f64338ac864d53d5d70c0e2af340a1', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/max.js', '28.4', 0),
('16f90b4d0fbfd0f8f6e9deef3c0242c2', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/mean.js', '28.4', 0),
('bbda2a9a2248c94ad6311d1869b32064', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/median.js', '28.4', 0),
('7123f4a7a2a7bc23e1b56dc74ae29bd2', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/merge.js', '28.4', 0),
('3f67c95cf4aca8d23de6e972ecf90f3d', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/min.js', '28.4', 0),
('9e09673761709c28a9d95e552d466e27', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/number.js', '28.4', 0),
('ed9e689404897590a42766f15901b989', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/pairs.js', '28.4', 0),
('5e5f5ebd25725ec83177ef0b46a3259f', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/permute.js', '28.4', 0),
('163c8444ee472da028874265760e6168', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/quantile.js', '28.4', 0),
('523066cdb9568521bee6f9a12716f52b', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/range.js', '28.4', 0),
('7840656fe3067dcdcf337e36ecfccfc8', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/scan.js', '28.4', 0),
('5a14dcd180c41c5cc65f5b0bda8660a4', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/shuffle.js', '28.4', 0),
('39401e09f912407eb88a578ae9fcf414', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/sum.js', '28.4', 0),
('3a7347d06bbfcf431a2449fc527d0c74', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/freedmanDiaconis.js', '28.4', 0),
('90705c34ddbac8e1ca741a646097576b', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/scott.js', '28.4', 0),
('824c3657b2a39a324f7429ec29d2cc24', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/threshold/sturges.js', '28.4', 0),
('1ac39d9a328fab0c194c9a4a264928a4', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/ticks.js', '28.4', 0),
('4cbf205c592290765b8ec0afe3992be1', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/transpose.js', '28.4', 0),
('4112d0f2f7d82e15ce91b193c87ce439', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/variance.js', '28.4', 0),
('8bb754b1adc9137d602059f5d1cca9b6', './node_modules/@plotly/d3-sankey/node_modules/d3-array/src/zip.js', '28.4', 0),
('6d76b62d608ce75eb1e10032e9229652', './node_modules/@plotly/d3-sankey/node_modules/d3-path/dist/d3-path.js', '28.4', 0),
('10db9895732d2d7f8b378bf7e3fc2f6d', './node_modules/@plotly/d3-sankey/node_modules/d3-path/dist/d3-path.min.js', '28.4', 0),
('310e08152d639a9c1db450c294abb87d', './node_modules/@plotly/d3-sankey/node_modules/d3-path/src/index.js', '28.4', 0),
('37c236c830446ee74ce315604c7d3b4e', './node_modules/@plotly/d3-sankey/node_modules/d3-path/src/path.js', '28.4', 0),
('2d2fe33e82a6656e785e025f8d48b418', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/dist/d3-shape.js', '28.4', 0),
('9cf9c65b4aa0fd5992f5ff228da69247', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/dist/d3-shape.min.js', '28.4', 0),
('f6d431fc64c54f9fcce76fae56618eaa', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/arc.js', '28.4', 0),
('d7ea70387dd4054c8b4dab97f5f05e49', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/area.js', '28.4', 0),
('2986c672d312e3fc3b85601e0078c51d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/areaRadial.js', '28.4', 0),
('e4d54736adebf9ddb31c1c70ea8ed2d3', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/array.js', '28.4', 0),
('d045c96fcb9ca2bebe001fa351da0d0d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/constant.js', '28.4', 0),
('b28b81a3475fa10926159d8b25edd4af', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basis.js', '28.4', 0),
('cc4ac3aac17f171a63723263feaa53ef', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisClosed.js', '28.4', 0),
('cb6b7ca9ecfdf41a6635243845ddf43d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/basisOpen.js', '28.4', 0),
('e6b70d762566f77baa9cf1d1ca7cb0bd', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/bundle.js', '28.4', 0),
('a8f9439316202508f7aa104d59e5f46d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinal.js', '28.4', 0),
('9cbe5cfcad0340a529b45dd7e35cfc43', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalClosed.js', '28.4', 0),
('ef987e68a6e22a556667a87530eadd9c', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/cardinalOpen.js', '28.4', 0),
('9d3809cd9dc895e6130dc49b98da6edf', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRom.js', '28.4', 0),
('244e26a8c285b2ec8ae0fd90b8dfc497', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomClosed.js', '28.4', 0),
('96168d2498cf542736ac2bbb80a76caa', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/catmullRomOpen.js', '28.4', 0),
('a3f7b194af73d59fe2e334372e3dbb92', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linear.js', '28.4', 0),
('3a81fba9192aa7e448361d47a2ac387b', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/linearClosed.js', '28.4', 0),
('905277ab4e4253d6b46bc8eb884ebbd8', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/monotone.js', '28.4', 0),
('2633730d398af5876636e4e8fc079ff0', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/natural.js', '28.4', 0),
('a33d27ab525ba59dce06735d1c58bf20', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/radial.js', '28.4', 0),
('c2b8864699b7da02a668dd268cd0ef11', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/curve/step.js', '28.4', 0),
('627bb774ffc0129fe72c18b4991a7fc4', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/descending.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('941d1d07223f468a439d47b6124e38ad', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/identity.js', '28.4', 0),
('187c3f15618504cb09feee53d13d94b6', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/index.js', '28.4', 0),
('d3c340cf0f3c3f99f7aa071a57969632', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/line.js', '28.4', 0),
('cfc502519d1467524797ee93bdd2a18f', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/lineRadial.js', '28.4', 0),
('534796e1559825777d3535136216b563', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/link/index.js', '28.4', 0),
('4b44462b8ce1a00bfcf33c6965cb33da', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/math.js', '28.4', 0),
('fa7a68d114b90631634736836c0462dc', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/noop.js', '28.4', 0),
('3af65aebdd084bfcce876b0cbbd981a2', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/diverging.js', '28.4', 0),
('1e1df1b2c09209345eb11591bb14d4fc', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/expand.js', '28.4', 0),
('734a071976de0ed7444a9dc6074f5a23', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/none.js', '28.4', 0),
('16b8979ae383f4a0ebc0b27e5c6a2c15', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/silhouette.js', '28.4', 0),
('b1e227abe71d19b6421dee0ccbd4e96d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/offset/wiggle.js', '28.4', 0),
('ad0fee06055065d388735bd4f40457a1', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/appearance.js', '28.4', 0),
('4337f54b59854dbc4f933046a530c558', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/ascending.js', '28.4', 0),
('cd3d5d15c8f3616351689a109356aee8', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/descending.js', '28.4', 0),
('c6b64fa955917776cc180b80c4da8a6d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/insideOut.js', '28.4', 0),
('dec7b0a5e256aee00030add16c9f79be', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/none.js', '28.4', 0),
('83ae0c4bc16530e94ec06b54074c1e0e', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/order/reverse.js', '28.4', 0),
('ccb0bd3ddbde29ff2d4ef017d6db7ee4', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pie.js', '28.4', 0),
('b819e597c44854bebfaad3891a89879d', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/point.js', '28.4', 0),
('97cb5d6999026e3d54868c57eec56d81', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/pointRadial.js', '28.4', 0),
('56cede3fd5142c8b93c38d8f1d4d150e', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/stack.js', '28.4', 0),
('a9d9b383d99c87bd0c28ebd4326ba7a6', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol.js', '28.4', 0),
('1fbb9d8c6e2be20e912613de6c173aa6', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/circle.js', '28.4', 0),
('f1cc73a597085a0d9558415d7b1351fc', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/cross.js', '28.4', 0),
('b70347100de242968d66bc5449cafc07', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/diamond.js', '28.4', 0),
('a300f4c7c827254388af7cecde3e522b', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/square.js', '28.4', 0),
('65ad1680e607be1a7f2afa40564d627f', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/star.js', '28.4', 0),
('518a0bf978dae83ff7eca5e5f682e136', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/triangle.js', '28.4', 0),
('acb70c83981ca2ccfbfddc1d6af3e9f9', './node_modules/@plotly/d3-sankey/node_modules/d3-shape/src/symbol/wye.js', '28.4', 0),
('93176682108f8ef4df43a8d99365d8b7', './node_modules/@plotly/d3-sankey/src/align.js', '28.4', 0),
('97da38ded3b88695576803b070860f34', './node_modules/@plotly/d3-sankey/src/constant.js', '28.4', 0),
('0cf3d2ffd68c77217be33e70b20cbea4', './node_modules/@plotly/d3-sankey/src/sankey.js', '28.4', 0),
('689209baae6995c8346b5aa6836e5501', './node_modules/@plotly/d3-sankey/src/sankeyLinkHorizontal.js', '28.4', 0),
('1702c36641f86129b4c8c99d9e1dc026', './node_modules/@plotly/point-cluster/index.js', '28.4', 0),
('e828a456bfa7f415d7cc7c0b0247a2b6', './node_modules/@plotly/point-cluster/kd.js', '28.4', 0),
('90f5d7fa132b1f602db1161f74f35e79', './node_modules/@plotly/point-cluster/quad.js', '28.4', 0),
('612ed082c3b486fe3412023c03c611e5', './node_modules/@plotly/point-cluster/research.js', '28.4', 0),
('79e39a91dc792e97f6946ca651099af7', './node_modules/@plotly/point-cluster/test.js', '28.4', 0),
('c0d68515d776760d030503e56922ad23', './node_modules/@popperjs/core/dist/cjs/enums.js', '28.4', 0),
('59a12d5ceac8ff348ada98c60c3dca3e', './node_modules/@popperjs/core/dist/cjs/popper-base.js', '28.4', 0),
('59af1acf92e99562ab38965ba6592997', './node_modules/@popperjs/core/dist/cjs/popper-lite.js', '28.4', 0),
('a6dac197289e152af8b91a0cb66b93cf', './node_modules/@popperjs/core/dist/cjs/popper.js', '28.4', 0),
('c0d59064670f4ae36e2c8390702a7c0d', './node_modules/@popperjs/core/dist/esm/createPopper.js', '28.4', 0),
('29370730b9659e8219934cfb5c82c200', './node_modules/@popperjs/core/dist/esm/dom-utils/contains.js', '28.4', 0),
('b03f55e034f53535ec245ffc5a3f3448', './node_modules/@popperjs/core/dist/esm/dom-utils/getBoundingClientRect.js', '28.4', 0),
('9bca2433882cc464d4ba1249b170d560', './node_modules/@popperjs/core/dist/esm/dom-utils/getClippingRect.js', '28.4', 0),
('9fedbf824360df583983af3158e251d9', './node_modules/@popperjs/core/dist/esm/dom-utils/getCompositeRect.js', '28.4', 0),
('48eadaabfb3b91cf883983b2b0ec32f6', './node_modules/@popperjs/core/dist/esm/dom-utils/getComputedStyle.js', '28.4', 0),
('9e90cb097156533f9f0b6053b8626764', './node_modules/@popperjs/core/dist/esm/dom-utils/getDocumentElement.js', '28.4', 0),
('2a25bd5556985e3f0fe0d1ceb14d2aeb', './node_modules/@popperjs/core/dist/esm/dom-utils/getDocumentRect.js', '28.4', 0),
('2b9801e8d15d66ef95278c1422b6cc6c', './node_modules/@popperjs/core/dist/esm/dom-utils/getHTMLElementScroll.js', '28.4', 0),
('3605e28f36bcbee5272196b2c7a85c63', './node_modules/@popperjs/core/dist/esm/dom-utils/getLayoutRect.js', '28.4', 0),
('a0d8fe0116104b3540352439b3980aae', './node_modules/@popperjs/core/dist/esm/dom-utils/getNodeName.js', '28.4', 0),
('30fd844b11e7d157c63e49239091bd4a', './node_modules/@popperjs/core/dist/esm/dom-utils/getNodeScroll.js', '28.4', 0),
('bfd5a53b6117ca76378c9d8afb4001e8', './node_modules/@popperjs/core/dist/esm/dom-utils/getOffsetParent.js', '28.4', 0),
('622ada1736f640b77554224d1b0666ff', './node_modules/@popperjs/core/dist/esm/dom-utils/getParentNode.js', '28.4', 0),
('a063e6db220c6c452246a86b1e92b9ed', './node_modules/@popperjs/core/dist/esm/dom-utils/getScrollParent.js', '28.4', 0),
('9f5e49326ff40e3f8c048ee74ea18e95', './node_modules/@popperjs/core/dist/esm/dom-utils/getViewportRect.js', '28.4', 0),
('d8f8babb1ee5c8824b7ac6982728301e', './node_modules/@popperjs/core/dist/esm/dom-utils/getWindow.js', '28.4', 0),
('2fe7e0f1c10e8c777b59fc9beb1b33c2', './node_modules/@popperjs/core/dist/esm/dom-utils/getWindowScroll.js', '28.4', 0),
('c511902e8187e7d5947c683b941d0161', './node_modules/@popperjs/core/dist/esm/dom-utils/getWindowScrollBarX.js', '28.4', 0),
('9a59b4dc70e783b50cc0dcc33bb65dfa', './node_modules/@popperjs/core/dist/esm/dom-utils/instanceOf.js', '28.4', 0),
('231f888e447669d357e10e0cb096f9f9', './node_modules/@popperjs/core/dist/esm/dom-utils/isLayoutViewport.js', '28.4', 0),
('15198b60883bf91e6daca70c07049f22', './node_modules/@popperjs/core/dist/esm/dom-utils/isScrollParent.js', '28.4', 0),
('a54a0577a0d47862117deda084554e21', './node_modules/@popperjs/core/dist/esm/dom-utils/isTableElement.js', '28.4', 0),
('cdd482c71d4da367023ae0ee6d8d6fb2', './node_modules/@popperjs/core/dist/esm/dom-utils/listScrollParents.js', '28.4', 0),
('8ae4753699792df63ee836fef2eb5041', './node_modules/@popperjs/core/dist/esm/enums.js', '28.4', 0),
('18220dee44b0cc285a6bd1dd202097ae', './node_modules/@popperjs/core/dist/esm/index.js', '28.4', 0),
('c02c71e8ed54fcdd10d0609bfc5a6186', './node_modules/@popperjs/core/dist/esm/modifiers/applyStyles.js', '28.4', 0),
('4da825960cfc63f91bf3053433fa7fdd', './node_modules/@popperjs/core/dist/esm/modifiers/arrow.js', '28.4', 0),
('826f58d81026dff7fe9d71877710e41e', './node_modules/@popperjs/core/dist/esm/modifiers/computeStyles.js', '28.4', 0),
('3ee6bfd7f8fa6636ea391e6036ea2f44', './node_modules/@popperjs/core/dist/esm/modifiers/eventListeners.js', '28.4', 0),
('9decb50d0ac8680f453955f7375298d3', './node_modules/@popperjs/core/dist/esm/modifiers/flip.js', '28.4', 0),
('4a87e822befe2ca79bbea61bc7608ceb', './node_modules/@popperjs/core/dist/esm/modifiers/hide.js', '28.4', 0),
('690382089887ef5a964546acaf73f86f', './node_modules/@popperjs/core/dist/esm/modifiers/index.js', '28.4', 0),
('ae230ce883ffb1959b3fba5bb91b3afc', './node_modules/@popperjs/core/dist/esm/modifiers/offset.js', '28.4', 0),
('15a688f32742e8b3c063ce621647821f', './node_modules/@popperjs/core/dist/esm/modifiers/popperOffsets.js', '28.4', 0),
('7aabddc46542175ce9c56da322382e02', './node_modules/@popperjs/core/dist/esm/modifiers/preventOverflow.js', '28.4', 0),
('fe13de81368af7aa5ad22f45034a8dbc', './node_modules/@popperjs/core/dist/esm/popper-base.js', '28.4', 0),
('a841949f12126cf8537f7309c608d5f0', './node_modules/@popperjs/core/dist/esm/popper-lite.js', '28.4', 0),
('3baa912c4087c720e0ec8b1eb6e243fc', './node_modules/@popperjs/core/dist/esm/popper.js', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './node_modules/@popperjs/core/dist/esm/types.js', '28.4', 0),
('5eee086b997391dd8e0e566da9ac9103', './node_modules/@popperjs/core/dist/esm/utils/computeAutoPlacement.js', '28.4', 0),
('cbbf3ba0353f76f39cab480ef768a104', './node_modules/@popperjs/core/dist/esm/utils/computeOffsets.js', '28.4', 0),
('2c5ce3282f084a451b85a0a6fcb6e887', './node_modules/@popperjs/core/dist/esm/utils/debounce.js', '28.4', 0),
('169621a949478bfeec7a490462eee90d', './node_modules/@popperjs/core/dist/esm/utils/detectOverflow.js', '28.4', 0),
('5948355f707cee8811c57631f8ee47f6', './node_modules/@popperjs/core/dist/esm/utils/expandToHashMap.js', '28.4', 0),
('e8a929761cd72a8e7827ad89ac5bf291', './node_modules/@popperjs/core/dist/esm/utils/getAltAxis.js', '28.4', 0),
('72a5108823562a01a0fc51c7f1de432e', './node_modules/@popperjs/core/dist/esm/utils/getAltLen.js', '28.4', 0),
('13384fa3869fe33d4d7291cc3ca70162', './node_modules/@popperjs/core/dist/esm/utils/getBasePlacement.js', '28.4', 0),
('c69ef516b656d3a132b7197ad872c59d', './node_modules/@popperjs/core/dist/esm/utils/getFreshSideObject.js', '28.4', 0),
('4f78e426939408875aa50b663404f969', './node_modules/@popperjs/core/dist/esm/utils/getMainAxisFromPlacement.js', '28.4', 0),
('41cca46744c5f32478ca17dc22c87564', './node_modules/@popperjs/core/dist/esm/utils/getOppositePlacement.js', '28.4', 0),
('7ea00f6aed28f325e8450b13aa13d487', './node_modules/@popperjs/core/dist/esm/utils/getOppositeVariationPlacement.js', '28.4', 0),
('ed457d60591138b14bf5fab94b08e073', './node_modules/@popperjs/core/dist/esm/utils/getVariation.js', '28.4', 0),
('a3a93d198ae13b67ab1d7123a9508d7a', './node_modules/@popperjs/core/dist/esm/utils/math.js', '28.4', 0),
('0550579fe3fc19dfe9189dcde9167bf7', './node_modules/@popperjs/core/dist/esm/utils/mergeByName.js', '28.4', 0),
('cc748e224203097aabaf7380f79f9364', './node_modules/@popperjs/core/dist/esm/utils/mergePaddingObject.js', '28.4', 0),
('7a5a30d7e0a90191c92c064b4ef63d71', './node_modules/@popperjs/core/dist/esm/utils/orderModifiers.js', '28.4', 0),
('887af2441fe2b22b9e9566f1256649dc', './node_modules/@popperjs/core/dist/esm/utils/rectToClientRect.js', '28.4', 0),
('83929ec15ff0fded8c7dd5eb1b3b55c0', './node_modules/@popperjs/core/dist/esm/utils/uniqueBy.js', '28.4', 0),
('6547150ad51fa8577904bcb815a4083e', './node_modules/@popperjs/core/dist/esm/utils/userAgent.js', '28.4', 0),
('5931f11efdbffec020cfeda5b15718be', './node_modules/@popperjs/core/dist/esm/utils/within.js', '28.4', 0),
('f35327d185391dceedfd9c4739c31083', './node_modules/@popperjs/core/dist/umd/enums.js', '28.4', 0),
('097562c3ff43b9caa77cd58c675a78f9', './node_modules/@popperjs/core/dist/umd/enums.min.js', '28.4', 0),
('890c047e946d5323bb6d8bbdb0c046ac', './node_modules/@popperjs/core/dist/umd/popper-base.js', '28.4', 0),
('f1c650193a0bcfbdc6f52016f628a22c', './node_modules/@popperjs/core/dist/umd/popper-base.min.js', '28.4', 0),
('e3c8d80c098041a1da77ff766fd7290d', './node_modules/@popperjs/core/dist/umd/popper-lite.js', '28.4', 0),
('248e3ba6eb8b4c179fa91d21a05a9e87', './node_modules/@popperjs/core/dist/umd/popper-lite.min.js', '28.4', 0),
('063a0fe0ef0e183df9f6d99ad2923f29', './node_modules/@popperjs/core/dist/umd/popper.js', '28.4', 0),
('31032b08bd8e72220462d3f54f8bd69a', './node_modules/@popperjs/core/dist/umd/popper.min.js', '28.4', 0),
('c0d59064670f4ae36e2c8390702a7c0d', './node_modules/@popperjs/core/lib/createPopper.js', '28.4', 0),
('29370730b9659e8219934cfb5c82c200', './node_modules/@popperjs/core/lib/dom-utils/contains.js', '28.4', 0),
('b03f55e034f53535ec245ffc5a3f3448', './node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js', '28.4', 0),
('9bca2433882cc464d4ba1249b170d560', './node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js', '28.4', 0),
('9fedbf824360df583983af3158e251d9', './node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js', '28.4', 0),
('48eadaabfb3b91cf883983b2b0ec32f6', './node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js', '28.4', 0),
('9e90cb097156533f9f0b6053b8626764', './node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js', '28.4', 0),
('2a25bd5556985e3f0fe0d1ceb14d2aeb', './node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js', '28.4', 0),
('2b9801e8d15d66ef95278c1422b6cc6c', './node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js', '28.4', 0),
('3605e28f36bcbee5272196b2c7a85c63', './node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js', '28.4', 0),
('a0d8fe0116104b3540352439b3980aae', './node_modules/@popperjs/core/lib/dom-utils/getNodeName.js', '28.4', 0),
('30fd844b11e7d157c63e49239091bd4a', './node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js', '28.4', 0),
('bfd5a53b6117ca76378c9d8afb4001e8', './node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js', '28.4', 0),
('622ada1736f640b77554224d1b0666ff', './node_modules/@popperjs/core/lib/dom-utils/getParentNode.js', '28.4', 0),
('a063e6db220c6c452246a86b1e92b9ed', './node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js', '28.4', 0),
('9f5e49326ff40e3f8c048ee74ea18e95', './node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js', '28.4', 0),
('d8f8babb1ee5c8824b7ac6982728301e', './node_modules/@popperjs/core/lib/dom-utils/getWindow.js', '28.4', 0),
('2fe7e0f1c10e8c777b59fc9beb1b33c2', './node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js', '28.4', 0),
('c511902e8187e7d5947c683b941d0161', './node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js', '28.4', 0),
('9a59b4dc70e783b50cc0dcc33bb65dfa', './node_modules/@popperjs/core/lib/dom-utils/instanceOf.js', '28.4', 0),
('231f888e447669d357e10e0cb096f9f9', './node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js', '28.4', 0),
('15198b60883bf91e6daca70c07049f22', './node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js', '28.4', 0),
('a54a0577a0d47862117deda084554e21', './node_modules/@popperjs/core/lib/dom-utils/isTableElement.js', '28.4', 0),
('cdd482c71d4da367023ae0ee6d8d6fb2', './node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js', '28.4', 0),
('8ae4753699792df63ee836fef2eb5041', './node_modules/@popperjs/core/lib/enums.js', '28.4', 0),
('18220dee44b0cc285a6bd1dd202097ae', './node_modules/@popperjs/core/lib/index.js', '28.4', 0),
('c02c71e8ed54fcdd10d0609bfc5a6186', './node_modules/@popperjs/core/lib/modifiers/applyStyles.js', '28.4', 0),
('4da825960cfc63f91bf3053433fa7fdd', './node_modules/@popperjs/core/lib/modifiers/arrow.js', '28.4', 0),
('826f58d81026dff7fe9d71877710e41e', './node_modules/@popperjs/core/lib/modifiers/computeStyles.js', '28.4', 0),
('3ee6bfd7f8fa6636ea391e6036ea2f44', './node_modules/@popperjs/core/lib/modifiers/eventListeners.js', '28.4', 0),
('9decb50d0ac8680f453955f7375298d3', './node_modules/@popperjs/core/lib/modifiers/flip.js', '28.4', 0),
('4a87e822befe2ca79bbea61bc7608ceb', './node_modules/@popperjs/core/lib/modifiers/hide.js', '28.4', 0),
('690382089887ef5a964546acaf73f86f', './node_modules/@popperjs/core/lib/modifiers/index.js', '28.4', 0),
('ae230ce883ffb1959b3fba5bb91b3afc', './node_modules/@popperjs/core/lib/modifiers/offset.js', '28.4', 0),
('15a688f32742e8b3c063ce621647821f', './node_modules/@popperjs/core/lib/modifiers/popperOffsets.js', '28.4', 0),
('7aabddc46542175ce9c56da322382e02', './node_modules/@popperjs/core/lib/modifiers/preventOverflow.js', '28.4', 0),
('fe13de81368af7aa5ad22f45034a8dbc', './node_modules/@popperjs/core/lib/popper-base.js', '28.4', 0),
('a841949f12126cf8537f7309c608d5f0', './node_modules/@popperjs/core/lib/popper-lite.js', '28.4', 0),
('3baa912c4087c720e0ec8b1eb6e243fc', './node_modules/@popperjs/core/lib/popper.js', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './node_modules/@popperjs/core/lib/types.js', '28.4', 0),
('5eee086b997391dd8e0e566da9ac9103', './node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js', '28.4', 0),
('cbbf3ba0353f76f39cab480ef768a104', './node_modules/@popperjs/core/lib/utils/computeOffsets.js', '28.4', 0),
('2c5ce3282f084a451b85a0a6fcb6e887', './node_modules/@popperjs/core/lib/utils/debounce.js', '28.4', 0),
('169621a949478bfeec7a490462eee90d', './node_modules/@popperjs/core/lib/utils/detectOverflow.js', '28.4', 0),
('5948355f707cee8811c57631f8ee47f6', './node_modules/@popperjs/core/lib/utils/expandToHashMap.js', '28.4', 0),
('e8a929761cd72a8e7827ad89ac5bf291', './node_modules/@popperjs/core/lib/utils/getAltAxis.js', '28.4', 0),
('72a5108823562a01a0fc51c7f1de432e', './node_modules/@popperjs/core/lib/utils/getAltLen.js', '28.4', 0),
('13384fa3869fe33d4d7291cc3ca70162', './node_modules/@popperjs/core/lib/utils/getBasePlacement.js', '28.4', 0),
('c69ef516b656d3a132b7197ad872c59d', './node_modules/@popperjs/core/lib/utils/getFreshSideObject.js', '28.4', 0),
('4f78e426939408875aa50b663404f969', './node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js', '28.4', 0),
('41cca46744c5f32478ca17dc22c87564', './node_modules/@popperjs/core/lib/utils/getOppositePlacement.js', '28.4', 0),
('7ea00f6aed28f325e8450b13aa13d487', './node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js', '28.4', 0),
('ed457d60591138b14bf5fab94b08e073', './node_modules/@popperjs/core/lib/utils/getVariation.js', '28.4', 0),
('a3a93d198ae13b67ab1d7123a9508d7a', './node_modules/@popperjs/core/lib/utils/math.js', '28.4', 0),
('0550579fe3fc19dfe9189dcde9167bf7', './node_modules/@popperjs/core/lib/utils/mergeByName.js', '28.4', 0),
('cc748e224203097aabaf7380f79f9364', './node_modules/@popperjs/core/lib/utils/mergePaddingObject.js', '28.4', 0),
('7a5a30d7e0a90191c92c064b4ef63d71', './node_modules/@popperjs/core/lib/utils/orderModifiers.js', '28.4', 0),
('887af2441fe2b22b9e9566f1256649dc', './node_modules/@popperjs/core/lib/utils/rectToClientRect.js', '28.4', 0),
('83929ec15ff0fded8c7dd5eb1b3b55c0', './node_modules/@popperjs/core/lib/utils/uniqueBy.js', '28.4', 0),
('6547150ad51fa8577904bcb815a4083e', './node_modules/@popperjs/core/lib/utils/userAgent.js', '28.4', 0),
('5931f11efdbffec020cfeda5b15718be', './node_modules/@popperjs/core/lib/utils/within.js', '28.4', 0),
('27661d08a6b79caf78a6dc378e199536', './node_modules/@rollup/pluginutils/dist/cjs/index.js', '28.4', 0),
('814208c9abf64639cff1f36fda91cfc1', './node_modules/@rollup/pluginutils/dist/es/index.js', '28.4', 0),
('abef6248f5576345351f253b744800a5', './node_modules/@shoelace-style/animations/dist/attention_seekers/bounce.js', '28.4', 0),
('33479285e55802eb78a49257ff5ee845', './node_modules/@shoelace-style/animations/dist/attention_seekers/flash.js', '28.4', 0),
('c4f28a957b4f2175c298637bdc0e10b0', './node_modules/@shoelace-style/animations/dist/attention_seekers/headShake.js', '28.4', 0),
('e6a45e1c25b6c6904f821cf57cfd5902', './node_modules/@shoelace-style/animations/dist/attention_seekers/heartBeat.js', '28.4', 0),
('e3bc781ac8e07b7102bcbfa9e5211737', './node_modules/@shoelace-style/animations/dist/attention_seekers/jello.js', '28.4', 0),
('0c9be39d0c5df396a190e68873304f82', './node_modules/@shoelace-style/animations/dist/attention_seekers/pulse.js', '28.4', 0),
('4af61d3f79857b33a11985d6890800f5', './node_modules/@shoelace-style/animations/dist/attention_seekers/rubberBand.js', '28.4', 0),
('0bbd178d3b0c2ac1245fbd36b36d0177', './node_modules/@shoelace-style/animations/dist/attention_seekers/shake.js', '28.4', 0),
('21f4eff661e315fe8350ae5fcde2bc43', './node_modules/@shoelace-style/animations/dist/attention_seekers/shakeX.js', '28.4', 0),
('45ad25f7053553feeab4a38bb4af0150', './node_modules/@shoelace-style/animations/dist/attention_seekers/shakeY.js', '28.4', 0),
('0004e3387a371fb14289cbdc67b6d2a5', './node_modules/@shoelace-style/animations/dist/attention_seekers/swing.js', '28.4', 0),
('50749d30dd3c8905d1de7dfd24d58b7e', './node_modules/@shoelace-style/animations/dist/attention_seekers/tada.js', '28.4', 0),
('3c7684966cb45acfaf1795c1e39837b3', './node_modules/@shoelace-style/animations/dist/attention_seekers/wobble.js', '28.4', 0),
('c15db24bba1f590468f4c5db328cb1b7', './node_modules/@shoelace-style/animations/dist/back_entrances/backInDown.js', '28.4', 0),
('f6f3fa6374cdaaa0c70ec1fed3451d11', './node_modules/@shoelace-style/animations/dist/back_entrances/backInLeft.js', '28.4', 0),
('69a540cee91179861ecaf505ca1869de', './node_modules/@shoelace-style/animations/dist/back_entrances/backInRight.js', '28.4', 0),
('d090965be9e90d73dffe519b0633ab45', './node_modules/@shoelace-style/animations/dist/back_entrances/backInUp.js', '28.4', 0),
('ac4a146546febeab5af33a2663e38c4f', './node_modules/@shoelace-style/animations/dist/back_exits/backOutDown.js', '28.4', 0),
('9b9be39b07613f4e63f4881885541057', './node_modules/@shoelace-style/animations/dist/back_exits/backOutLeft.js', '28.4', 0),
('15dd21507281a4104febd36fe56115df', './node_modules/@shoelace-style/animations/dist/back_exits/backOutRight.js', '28.4', 0),
('5d5fd9a0c9e0ec25c26e50c4f92e3b67', './node_modules/@shoelace-style/animations/dist/back_exits/backOutUp.js', '28.4', 0),
('110130dee544c5be0350dfdaa743d735', './node_modules/@shoelace-style/animations/dist/bouncing_entrances/bounceIn.js', '28.4', 0),
('0d7181ff34a801643091bfd5477f0632', './node_modules/@shoelace-style/animations/dist/bouncing_entrances/bounceInDown.js', '28.4', 0),
('64ca16d0b808da4b4b52b1eabff7e44b', './node_modules/@shoelace-style/animations/dist/bouncing_entrances/bounceInLeft.js', '28.4', 0),
('f5c94d13a65d6852abbd37dca8965128', './node_modules/@shoelace-style/animations/dist/bouncing_entrances/bounceInRight.js', '28.4', 0),
('ad9876898c224b5a16dc86f4a85751ca', './node_modules/@shoelace-style/animations/dist/bouncing_entrances/bounceInUp.js', '28.4', 0),
('cba03641cd724fdd348909f5d7469d85', './node_modules/@shoelace-style/animations/dist/bouncing_exits/bounceOut.js', '28.4', 0),
('b4293ca99eac2c0771e18a7837efc9ef', './node_modules/@shoelace-style/animations/dist/bouncing_exits/bounceOutDown.js', '28.4', 0),
('798e3c8616f2e08f7e798e685eaa08dd', './node_modules/@shoelace-style/animations/dist/bouncing_exits/bounceOutLeft.js', '28.4', 0),
('cf45a39c5ee95f8f9342c483798a1d9d', './node_modules/@shoelace-style/animations/dist/bouncing_exits/bounceOutRight.js', '28.4', 0),
('699f7f77a0a535adee9c4d02ba13398c', './node_modules/@shoelace-style/animations/dist/bouncing_exits/bounceOutUp.js', '28.4', 0),
('06480ef482e3f3aa7be95259171b7c6f', './node_modules/@shoelace-style/animations/dist/easings/easings.js', '28.4', 0),
('ca53c7cb244b7b3cc1be60f7fb25f2a5', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeIn.js', '28.4', 0),
('8ba534fae82fd2ee869e946a71f0caa2', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInBottomLeft.js', '28.4', 0),
('6057b7092a34db89066b2eb0ba43d390', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInBottomRight.js', '28.4', 0),
('0128835625ea46bc6860b592a68c9260', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInDown.js', '28.4', 0),
('beef6451e08586a79db8dfab5b43903b', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInDownBig.js', '28.4', 0),
('9bf85e869406faca913e6ae66e0c8d53', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInLeft.js', '28.4', 0),
('f694ca5e21dbb5fb4d620366777658bc', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInLeftBig.js', '28.4', 0),
('5930a4b39828d901d6d7f9efabd3001d', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInRight.js', '28.4', 0),
('41e9c75c72ca465957be6fe847093016', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInRightBig.js', '28.4', 0),
('e96ec1c075135aac8bdfffe16282868b', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInTopLeft.js', '28.4', 0),
('5bc0f5b4bb5ecefbe6804a5e9ed6923a', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInTopRight.js', '28.4', 0),
('034665c6433495f86f1cae1809ce24cd', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInUp.js', '28.4', 0),
('c6135c278b2d66f1a26bfe663839832f', './node_modules/@shoelace-style/animations/dist/fading_entrances/fadeInUpBig.js', '28.4', 0),
('3045e41ea0eed5572ea3af64f6ee7a1a', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOut.js', '28.4', 0),
('ce9be042bb2eddae6462876a6ea708d6', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutBottomLeft.js', '28.4', 0),
('71c9b0e0a00f802d3b10850dd2521e98', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutBottomRight.js', '28.4', 0),
('22a446512ad26230c45a65d60678e4db', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutDown.js', '28.4', 0),
('4b64f3cbbb9a1f0ab9f89402fe358373', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutDownBig.js', '28.4', 0),
('b381cef942c3ec6491bb48b6aca4ae3c', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutLeft.js', '28.4', 0),
('e2c761162b69ff7f586026b1974f1cbb', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutLeftBig.js', '28.4', 0),
('30b607dd792f0d5a078060ab7bb363d8', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutRight.js', '28.4', 0),
('f88c2b64f8d898c5dfb2ff52b7fcf527', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutRightBig.js', '28.4', 0),
('42c0f90b90dafea6d5f743cacf23f5a9', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutTopLeft.js', '28.4', 0),
('dafba05a7981a94835b0bbab42c2a37d', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutTopRight.js', '28.4', 0),
('02122a461a65e6a935ed9ed61ff19426', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutUp.js', '28.4', 0),
('e92ce3d2d818b1429e8c15f174c146ef', './node_modules/@shoelace-style/animations/dist/fading_exits/fadeOutUpBig.js', '28.4', 0),
('a84a406f1bf7e5565217af6d07b14436', './node_modules/@shoelace-style/animations/dist/flippers/flip.js', '28.4', 0),
('e02ed760a82e551157a854129678dbc7', './node_modules/@shoelace-style/animations/dist/flippers/flipInX.js', '28.4', 0),
('0b9666f5d367def8a99b4d6080b1e926', './node_modules/@shoelace-style/animations/dist/flippers/flipInY.js', '28.4', 0),
('666b3d0fd70a99f7f76dc60d3999dff4', './node_modules/@shoelace-style/animations/dist/flippers/flipOutX.js', '28.4', 0),
('008ef68c73a5b935ecc1e9fc1b189643', './node_modules/@shoelace-style/animations/dist/flippers/flipOutY.js', '28.4', 0),
('bd617db812a16043326a2245d7e00e35', './node_modules/@shoelace-style/animations/dist/index.js', '28.4', 0),
('93f86332ea9a8c335ca9d1c87eacb624', './node_modules/@shoelace-style/animations/dist/lightspeed/lightSpeedInLeft.js', '28.4', 0),
('705ea53989c56988931348511546a62f', './node_modules/@shoelace-style/animations/dist/lightspeed/lightSpeedInRight.js', '28.4', 0),
('8eebb057793ae7b9fecc61c5c54ddd42', './node_modules/@shoelace-style/animations/dist/lightspeed/lightSpeedOutLeft.js', '28.4', 0),
('c21a61f4fe1e40907c4ef0985c35aee9', './node_modules/@shoelace-style/animations/dist/lightspeed/lightSpeedOutRight.js', '28.4', 0),
('31bac09434d30fb21c723fe1f479f7de', './node_modules/@shoelace-style/animations/dist/rotating_entrances/rotateIn.js', '28.4', 0),
('acff5fe83f106f52ce368873387df0cd', './node_modules/@shoelace-style/animations/dist/rotating_entrances/rotateInDownLeft.js', '28.4', 0),
('3ece957280d235387e2af32ac4ae041c', './node_modules/@shoelace-style/animations/dist/rotating_entrances/rotateInDownRight.js', '28.4', 0),
('b1c458891e57ba0246e5a905f9545634', './node_modules/@shoelace-style/animations/dist/rotating_entrances/rotateInUpLeft.js', '28.4', 0),
('e7d4b2401a74b72ecefe51317574a500', './node_modules/@shoelace-style/animations/dist/rotating_entrances/rotateInUpRight.js', '28.4', 0),
('5880c866d9475fefc102049c7e137b4b', './node_modules/@shoelace-style/animations/dist/rotating_exits/rotateOut.js', '28.4', 0),
('3623c97b81bfba8e93fa7469dea3b88f', './node_modules/@shoelace-style/animations/dist/rotating_exits/rotateOutDownLeft.js', '28.4', 0),
('21841364318b84e3b28b86a6e7cca5c3', './node_modules/@shoelace-style/animations/dist/rotating_exits/rotateOutDownRight.js', '28.4', 0),
('4dfd1afe444e5f8eec492298481e55e9', './node_modules/@shoelace-style/animations/dist/rotating_exits/rotateOutUpLeft.js', '28.4', 0),
('13919fecc9cb947720d8318ba78673b8', './node_modules/@shoelace-style/animations/dist/rotating_exits/rotateOutUpRight.js', '28.4', 0),
('6bb624781a03ab76fdaacdb9fd8d39f1', './node_modules/@shoelace-style/animations/dist/sliding_entrances/slideInDown.js', '28.4', 0),
('a82210ae7662bd05477b33df33ecb277', './node_modules/@shoelace-style/animations/dist/sliding_entrances/slideInLeft.js', '28.4', 0),
('c5d0fb165ddb479a4ee319bf84255d21', './node_modules/@shoelace-style/animations/dist/sliding_entrances/slideInRight.js', '28.4', 0),
('75531ac2e2d9a78465b5da1494971a30', './node_modules/@shoelace-style/animations/dist/sliding_entrances/slideInUp.js', '28.4', 0),
('364d92dcf9115f151c0e7b5693e3f00d', './node_modules/@shoelace-style/animations/dist/sliding_exits/slideOutDown.js', '28.4', 0),
('a66a08ef6196aa6ecd1dd6f544bff209', './node_modules/@shoelace-style/animations/dist/sliding_exits/slideOutLeft.js', '28.4', 0),
('39dc0763db40e0b745f02d65bbbf7515', './node_modules/@shoelace-style/animations/dist/sliding_exits/slideOutRight.js', '28.4', 0),
('cd1b81495ebdf66ddb3c991fad14192b', './node_modules/@shoelace-style/animations/dist/sliding_exits/slideOutUp.js', '28.4', 0),
('1b055a4ab5a49c47b59538fbb0ce062a', './node_modules/@shoelace-style/animations/dist/specials/hinge.js', '28.4', 0),
('e0fb2cd66dd7cac1feb587cda7aecf59', './node_modules/@shoelace-style/animations/dist/specials/jackInTheBox.js', '28.4', 0),
('15fc19dbbfab2b9f572e73ffaeb47c17', './node_modules/@shoelace-style/animations/dist/specials/rollIn.js', '28.4', 0),
('64966182d2ce56a8ca0dd748e3118fce', './node_modules/@shoelace-style/animations/dist/specials/rollOut.js', '28.4', 0),
('9702014fbf792db7faa504c24448d98d', './node_modules/@shoelace-style/animations/dist/zooming_entrances/zoomIn.js', '28.4', 0),
('1e3002cf55a685d03af6c9010d4f02e4', './node_modules/@shoelace-style/animations/dist/zooming_entrances/zoomInDown.js', '28.4', 0),
('3aa3bf60bd25e2dfbe34caccab0aaaa7', './node_modules/@shoelace-style/animations/dist/zooming_entrances/zoomInLeft.js', '28.4', 0),
('4f85179d2fd4a6d5e62839948391d2d0', './node_modules/@shoelace-style/animations/dist/zooming_entrances/zoomInRight.js', '28.4', 0),
('76739754e87ac47434a8d7431381afda', './node_modules/@shoelace-style/animations/dist/zooming_entrances/zoomInUp.js', '28.4', 0),
('47edfd0f94089a96d045d97445ebd3d9', './node_modules/@shoelace-style/animations/dist/zooming_exits/zoomOut.js', '28.4', 0),
('6fcc1848ddd051f2e69b1b2ef1cbc1b1', './node_modules/@shoelace-style/animations/dist/zooming_exits/zoomOutDown.js', '28.4', 0),
('7970d289e6e2540718616858d8c2a86d', './node_modules/@shoelace-style/animations/dist/zooming_exits/zoomOutLeft.js', '28.4', 0),
('10875023e86433cb789e555b7758e571', './node_modules/@shoelace-style/animations/dist/zooming_exits/zoomOutRight.js', '28.4', 0),
('7da1b5f5cbf760328e71d625eec932f0', './node_modules/@shoelace-style/animations/dist/zooming_exits/zoomOutUp.js', '28.4', 0),
('d4f6ddf9adb35fe6a19ea165756b6bdd', './node_modules/@shoelace-style/localize/dist/index.js', '28.4', 0),
('1749c4ba6155dc6f3df60a7ee551b898', './node_modules/@shoelace-style/localize/scripts/clean.js', '28.4', 0),
('422b13154c9dd15f60683b99cb413741', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.25NASL57.js', '28.4', 0),
('ab588646b8d64e6198baf2bc46bd1964', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.2GVQUHGD.js', '28.4', 0),
('08f811f63789cadb5eebbcf147d02842', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.2L6GHXIJ.js', '28.4', 0),
('1dd67ea17817cc15448d0fb8a5259b34', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.2PVHMPLN.js', '28.4', 0),
('a013306e4d45d63891a1ea546a801670', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.2URMUHDY.js', '28.4', 0),
('7c0e402ce8343064101126d14e74193d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.2VCJOOVN.js', '28.4', 0),
('0028fddb05100a59c917da6e3981a0cc', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.2VV6AF6A.js', '28.4', 0),
('9eb133c4a355bf6b7ce50277ca84b717', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.33QRBYPI.js', '28.4', 0),
('705a7a72f8b41b1aaa35913ca774f4d6', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.37HAGFEA.js', '28.4', 0),
('9e0b6ba048beb4abbc5486228a54daf7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3BLTEGRR.js', '28.4', 0),
('72acd25ad16dd0024e68855b355cc161', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3GYJGFVR.js', '28.4', 0),
('c44e485f20fd1693f5e0e34e4ad505d4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3IUDMNNO.js', '28.4', 0),
('a133ff7cbd07ef780c54b5ab4f96d8a2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3L4MMHT5.js', '28.4', 0),
('9934b9b891d67bea88e1497ecb84c66f', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3OEVTSBK.js', '28.4', 0),
('1430ec46b2feff7e4666b37665f9621a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3SX7OJWK.js', '28.4', 0),
('4a0c68cf9c5750d18258df0dcb2c5eba', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3TFKS637.js', '28.4', 0),
('9b5f41d818a2b6a13d14740a6b44a963', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3WXN57QB.js', '28.4', 0),
('16fba05d98541d42ed56eeacdafca7b9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.3Y6SB6QS.js', '28.4', 0),
('ef33e56423759b84e4902f6ef4891beb', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.43LLGZR5.js', '28.4', 0),
('339f398e7c1c8d5d956dbbe3a09f3ed4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.43Z4T7VZ.js', '28.4', 0),
('086b923133f824fac481295208f0fcac', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.4CNJZ4VC.js', '28.4', 0),
('ec49c3b121c154e8428f3f0972ea69db', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.4DGWX57B.js', '28.4', 0),
('4595ffb825bbe253b90c930972a1d9f3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.4DMKEI5I.js', '28.4', 0),
('714ffbc15bca49424a9968399c88dffb', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.4UHFJZU3.js', '28.4', 0),
('aeb8eb986aaca4aeeea3542c15932be8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.4VFDNCQZ.js', '28.4', 0),
('08dee84f636fbf7454476aca34b0243e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.4XDI42UA.js', '28.4', 0),
('4f677acc1d0237b7a66dc7dbe4b73fec', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.5BQ3JFXK.js', '28.4', 0),
('ed5460c180ea699143bac4ae7caaf214', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.5YNNJDCN.js', '28.4', 0),
('9c275454110ab4e6444a2f1a45596a62', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.625AWUY7.js', '28.4', 0),
('db14cb8ae89fe94d060b6d6ff346a7b9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6CXPWGYH.js', '28.4', 0),
('a20026aa18daa7b9a626804b9d3781f7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6FRFDWJP.js', '28.4', 0),
('88f8d6fc3b69ddaf79a161cfb78584cd', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6FYWMOER.js', '28.4', 0),
('cc91bc5b08bbcfe6b54dcaa02576ef7e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6GW6MLHD.js', '28.4', 0),
('e707bc4ca0ec07d26b5462efbf6d5ad4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6L2UFA6Z.js', '28.4', 0),
('a6f19f60ad6cf913d1ea242e1cacb2d8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6OASL3QX.js', '28.4', 0),
('76d44ec0ed58887367295670447b872e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6QCFVBVG.js', '28.4', 0),
('1c9cf8689e27147e2bf8b734a355a7f7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6RPTL3BG.js', '28.4', 0),
('08df16a8d667fe37cd27eef8d8243648', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6TRQP4JL.js', '28.4', 0),
('84a3f3ddf2c3dde080895e015c9ec0dd', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.6VMZSVZB.js', '28.4', 0),
('f094f7de7e98fb39bb5f48659bb02988', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.75VJSWZA.js', '28.4', 0),
('072a6ab3077f3855a362b5946eba9f77', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7B4O73GN.js', '28.4', 0),
('a1f15d6643a5c410065f1e2f3f689638', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7EKSUNPQ.js', '28.4', 0),
('5cd32d397687e0b7cc1c2e1f64066e55', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7I6PFJLB.js', '28.4', 0),
('c565e379aab192de9b0a55a0699f05be', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7KZHSE62.js', '28.4', 0),
('fac2816b73f2bef5afedfe7c87489be2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7MWJ2O6P.js', '28.4', 0),
('d8207def95dd1e4df99a2fd859411802', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7O2PEYVR.js', '28.4', 0),
('dd7f781443f4b7c47da1f5206317d6b9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7VWRC3ZQ.js', '28.4', 0),
('d2d5e22c415fa2658b16034def85017e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7YGA5ZD5.js', '28.4', 0),
('cc58e884f8bc5f26e347e20e3e008828', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.7ZOJGPGY.js', '28.4', 0),
('bcf090bf5c318a944cd3da407276388d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.A5KO3G4G.js', '28.4', 0),
('01016e6f863f4383025821c5c2f13918', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.A63MQPPF.js', '28.4', 0),
('550ca04f0cfc35c139aa5d05c4cbae6c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ADY3Z2R5.js', '28.4', 0),
('7cf4bd7176bff1c4c89bef6a72987b3a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.AMAFAG3K.js', '28.4', 0),
('e0cadce7e75d6815000d4e60f98d5f05', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ANRZXOKS.js', '28.4', 0),
('258aa3b5e5d72f195513b972462a1ac9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.AP7BVZNL.js', '28.4', 0),
('3ff2691bf8cb52cc2be9066a2152dcaf', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.APX2S6EY.js', '28.4', 0),
('84e6521ecea02befbfb12dc46409fb3d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ASYXCLN2.js', '28.4', 0),
('1708d7c7b1c371b4a1c1ce0cc35b6d3b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.AXZXLSUN.js', '28.4', 0),
('239937876d63e5dddc7489687fc43b02', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.B2C2RQNP.js', '28.4', 0),
('6f93a858e8ffc0a4eee39582226fb267', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.B4BZKR24.js', '28.4', 0),
('2c69eee74370431d243ceeedbf5c934f', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.BB6IHWQ4.js', '28.4', 0),
('2e57f3d8e239dd946a1d0c9d5cfdc00e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.BIOA57LZ.js', '28.4', 0),
('13db98e5c26eb2f173e22dd960c188ae', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.BO5VMJGY.js', '28.4', 0),
('d5da4c2a31d4e934cbf97310f2ffa675', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.C2R3OWG3.js', '28.4', 0),
('1c68a2bfd5d1770f8f66f802e21ed82b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.C37V4OL3.js', '28.4', 0),
('11dcb29a03638c119a94ba3c4809b57b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.CJB5WKGN.js', '28.4', 0),
('ddf1b84089f8fbb2a2d83b01dc9424a6', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.CKEPJTEM.js', '28.4', 0),
('f27e05497504901c32d3aa80c0d356cf', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.CNAOKAB4.js', '28.4', 0),
('1df7708712e22957a332ad53f9138f80', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.CUKKX6LO.js', '28.4', 0),
('76ba98ad152b0b0d0c0ceda5c5504e51', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.CXZZ2LVK.js', '28.4', 0),
('9c86ccf101661ed354f618a8fe39c480', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.CZZGLXKW.js', '28.4', 0),
('e520190f22922be21538c501428d5cf3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.D4N7GRNJ.js', '28.4', 0),
('91fae9ad9bfcde770b63abe1d2b600c4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.D6IAFMUB.js', '28.4', 0),
('a7c9fa020a966df4e7605c9fbd210196', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DK6N4THU.js', '28.4', 0),
('1e155685819b30e05a950cf315b28cb6', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DNDYQTWS.js', '28.4', 0),
('59757716dedd31222edbaad5cdd07696', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DNMFDNLD.js', '28.4', 0),
('256e9f363be26108fb1df880d3369e64', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DO6VDMTC.js', '28.4', 0),
('6b05f6b7364fda397af2d827cfe94d54', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DTL3YTRI.js', '28.4', 0),
('47e639bdb13ca0d4e110fd7aa9d54bf1', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DV4MWNJ3.js', '28.4', 0),
('e6e6f7dd52aac9209e16c78cfe9caca5', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.DYWNHSIG.js', '28.4', 0),
('6663f4121b837af7869860636786345c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.E3AD2PY7.js', '28.4', 0),
('08bbfff106383aae0f7d5c08cca2d4dc', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.E77YYWGC.js', '28.4', 0),
('cca00f38809d027f0591578b1f45ecfa', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.EJDHS3MU.js', '28.4', 0),
('6a14ad1f19477e950cd3739569b6d49d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.EJOUFVOH.js', '28.4', 0),
('30d301596d92dd119497eadb57ebcd2e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.EPJHAO2T.js', '28.4', 0),
('f3dcf3d3037413ddeea38fc22912942d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ESELY2US.js', '28.4', 0),
('39e39dbbb58a17f1fa84507fdecece22', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.EYBVASJL.js', '28.4', 0),
('b081ebd9c9ec3e2ab386473579e54192', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.EYME7KQI.js', '28.4', 0),
('a0a9c5429920fd459cae637ff74cdaf8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.F3MKP6AV.js', '28.4', 0),
('facf3b1a5513b8a17b9b928c1131949d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.F4VGSDIW.js', '28.4', 0),
('48acba643acb50246239b19dfe2beb53', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.F537L6JG.js', '28.4', 0),
('6652adbc2b31185e1b603fdea73b099a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.FCGBNRLQ.js', '28.4', 0),
('4206d7dd6dbdc13dd02837e7f10ee54c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.FI7TQ6HJ.js', '28.4', 0),
('a33d4072f74076589e52d97642f628a3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.FQH4RL5J.js', '28.4', 0),
('bad310716bcac5c949604608a8b21b59', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.FQQ5K3WY.js', '28.4', 0),
('314ce7d679313bd656e879084c62621b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.FSTHLC3Y.js', '28.4', 0),
('202e8416a7369db323f6f8e56104aa4e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.G227ZG7E.js', '28.4', 0),
('3fb82bcfaddc9ed5e8bee5399c87d86f', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.G25Q3KZ2.js', '28.4', 0),
('dd926a9ec47f54e9a7c9603f0eec7ad6', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.G35LD7QY.js', '28.4', 0),
('cfbd531751caca6965f93e7d7d59bb51', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.G3JQUIYV.js', '28.4', 0),
('0e208d4f03398f22a1100c893357b23d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.G5RXF54R.js', '28.4', 0),
('4d6946f6a9aaae2fd9a1fad6fc9afc93', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GAH3KGT3.js', '28.4', 0),
('f5c52d43e462e9b9ca0e11511b3dbab5', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GDZWCBAZ.js', '28.4', 0),
('e674faa341cd5be1193b7decfbb24754', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GGDWMP5Y.js', '28.4', 0),
('754becb236d996da6bd39273949e7b77', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GJZ2XQYI.js', '28.4', 0),
('2eedaf50ae9cb6ac7c627233a72bee62', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GM4WQMNZ.js', '28.4', 0),
('08ad4f68a7900a59d6caf6a2677a8200', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GMW7LL62.js', '28.4', 0),
('8ea199f31d48a2c0549f7b5db16969ba', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GNZFOKEG.js', '28.4', 0),
('9f6b232fd85d9270c7dbd87cd53757f8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GR65TH73.js', '28.4', 0),
('15a902fa6c49616b71d35c7badb632c6', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GTZHBAAH.js', '28.4', 0),
('d3fae261b565faef139bfe05353e26d4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.GYXO44Z5.js', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HAL7R4WT.js', '28.4', 0),
('4218aecc51d8802ab491a9aeed727799', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HBZA5SZP.js', '28.4', 0),
('de98348519990275852f5bc190fddfd8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HF7GESMZ.js', '28.4', 0),
('62c9de58a90176a7251e32753feb811b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HGHCDEHB.js', '28.4', 0),
('26dfa189f93bad80970c06e11c78356d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HGUS3K4Z.js', '28.4', 0),
('e6b5d02091bb3cd4289cfb629a0072b3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HKO7ON36.js', '28.4', 0),
('68fd63d30ce12a5ffdc463acc0616a2e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HKVRF64Z.js', '28.4', 0),
('135b006ade329641e2e829c2c39c29d5', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HSWXQUHN.js', '28.4', 0),
('86d9d07082dcf3d66fbea1a278dec2c9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.HUJPN4KF.js', '28.4', 0),
('cdc39192abc7dd2eee5a407b7b4523f0', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.I3QKIJTU.js', '28.4', 0),
('6eef6a2540f9f66245261d93e0de3c9b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.I4BWCXWK.js', '28.4', 0),
('24e8c3050280a888994bb27d3a07f46a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.I7IBIORS.js', '28.4', 0),
('fc35f741fa9f7ebc4185d0b5bc0e5c60', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.IK2TT6NG.js', '28.4', 0),
('285849082e31092fb7707be50d23542a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.IMMKQQ6H.js', '28.4', 0),
('3043ff33833b134c1af848e2139cbda2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.IPJHXFIL.js', '28.4', 0),
('88a86241b5d24a7bfe7ba8c03abb9f57', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.IRKZDSA4.js', '28.4', 0),
('0b0693834fbbc22a1d90a489d86799cc', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ISPSD75P.js', '28.4', 0),
('2ebc0d70b1243bcedcda266aad046e75', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.IVGVKKVF.js', '28.4', 0),
('30f7504d2549f3de69fce8fecd091622', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.J7KGMM4B.js', '28.4', 0),
('63963fe2e82bf4610792f47b709ccc09', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JASCFJUS.js', '28.4', 0),
('621dd420e3c4953f6e7d4bfee4434fa3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JH24DE2R.js', '28.4', 0),
('be9e325c897fd65fa4d09557e5418b46', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JKJKXILO.js', '28.4', 0),
('d6746e8b62830a9587b8348a0cde8291', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JMUOJ3NB.js', '28.4', 0),
('ee9f2a2660e5ed26913a1fef2978a3de', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JMV25GCN.js', '28.4', 0),
('780c8eb04777b5d1cd7b6fa62d4f9692', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JTEB2Q5J.js', '28.4', 0),
('8bb49cdfbae4f7e41d3d892daa7de547', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.JXTNYING.js', '28.4', 0),
('666d5f52d5d4ab872d52dc11d14598b4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.K23QWHWK.js', '28.4', 0),
('9a9025e46d2d806b98255542d7f48fd0', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KARBZGQP.js', '28.4', 0),
('3ded5b9b5c61288396c01fe1eacf48e1', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KCZMVKNK.js', '28.4', 0),
('6ebfeb6013c04ade4439dbbfbbc8d0f4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KDUKRKAC.js', '28.4', 0),
('c8b6233189c6b751edb0fe173c9342b2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KHPOZ5GU.js', '28.4', 0),
('86a931d3e6e30d3494602e42bbda2da0', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KMR6BHCO.js', '28.4', 0),
('8a9d5111e01b3c22fd048d2bd85fe771', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KMUO6LEO.js', '28.4', 0),
('2a3719d00891e7c5bcc82ffe84f9dc69', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KPESQDYT.js', '28.4', 0),
('87de6e980e85e43c014c12962d110b20', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KX6JW3HH.js', '28.4', 0),
('2f6072f5887704aa2a291d4463559fe8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.KZQUXDRA.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('6493e66d951b2ead14c324de1f045460', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.L4AMIRHK.js', '28.4', 0),
('d129d0038f2b0b5f04927b21c92233aa', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.L7IBPBN5.js', '28.4', 0),
('53732a552eaf0b4a68a3c6bed775b2e3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.LC52D3NF.js', '28.4', 0),
('e0ebfe050b2715654122931f0aeafe53', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.LROCNIJ2.js', '28.4', 0),
('6df627b1cfb1d291be28b436c5fba691', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.LX7UG5WS.js', '28.4', 0),
('d4a7999703855c4b4b094d1450c15dbe', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.LXDTFLWU.js', '28.4', 0),
('74241ca057be14c316f60c3e5bf6d4f2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.LY2W3OWK.js', '28.4', 0),
('0782cba0416ca86076b0c32caf6ae362', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.M2VP2ZQB.js', '28.4', 0),
('792f1eaf36b12c684ef1abed3493a7a7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.M5W6CHWH.js', '28.4', 0),
('a3690afcebc387346447b5204afeaf95', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MB643KRE.js', '28.4', 0),
('a991f099a3fbdfafe16d1fc237cc57fb', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MF6OX4FC.js', '28.4', 0),
('8aa73487e086f776b3e6d779ff9bc5af', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MHBZCRLJ.js', '28.4', 0),
('73f7f2e53c343bab48ff2ef9bc98dbec', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MKJDSUNA.js', '28.4', 0),
('9fff7aa001d5ce7cf9e2659e672b57e3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MMH6PRFE.js', '28.4', 0),
('5458437347f8109dadc240e7b741ccea', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MOGRU2B4.js', '28.4', 0),
('67aa49b2a93cbc8282d3d84d34e2b8ed', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MVCCMDRT.js', '28.4', 0),
('503760227b0dc994d75d09efb44db1ed', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MVCGXLBK.js', '28.4', 0),
('408708ab2fbab4103d66fbf1596b1804', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.MZQVGI4G.js', '28.4', 0),
('45261f241b5c849a456832108a7828d0', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NAHE3R5Q.js', '28.4', 0),
('137e66c442958db8041a04393a0bf9db', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NFBMJAJT.js', '28.4', 0),
('cee18555de4d9a090a47ff8418da2ba2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NFGGTN5O.js', '28.4', 0),
('c4af768ce3d367678f3002f82978f82d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NGHB4N3Y.js', '28.4', 0),
('b21ec70979e21e130e5c8022c76477a8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NH3SRVOC.js', '28.4', 0),
('fba5f81a8f6217b25c109131c4c0c612', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NJPNJO3T.js', '28.4', 0),
('9a281822c1c79eb726951a5ce69ed5df', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NM2GXZWF.js', '28.4', 0),
('755c58fb6e40bfcdf08d2df30d1d849c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NS554UL5.js', '28.4', 0),
('6b66404a8c53ae0dbbbf5d9293d64d57', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.NYIIDP5N.js', '28.4', 0),
('8aeb06fef6889063bc9980cae0fb07a4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.O27EHOBW.js', '28.4', 0),
('df50c5121894214fed4c203aa099548b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.O2JPUMPA.js', '28.4', 0),
('cf5a28e417729501f0b80ddf2083501a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OGR6IZGY.js', '28.4', 0),
('c7b7aac9ce0e3762bc5a5bfeff3545e5', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OH5ZB3FA.js', '28.4', 0),
('8845aac318ed4140fd979e513773a71e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OJOESQJ2.js', '28.4', 0),
('1ee2026a2355b726654775585b6bac40', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OOAEQSWY.js', '28.4', 0),
('abb961d23301980a22a21f604579aa2c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OP42VRSW.js', '28.4', 0),
('4da934289e8bc17e655b9c4a3d4e2ba1', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OTHWHSXK.js', '28.4', 0),
('86b6f808c03e51953eb3b4812519989d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.OYHCXCU6.js', '28.4', 0),
('f7d494c216bf8aab7344531c7e002dbc', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.P7ZG6EMR.js', '28.4', 0),
('b01d5d1ae22872517e11794ccd9c6e6c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.PHGREGXG.js', '28.4', 0),
('4011cc796eefb01f9b345fdc7ced6a30', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.PJRV5TVI.js', '28.4', 0),
('b04a73d2f00b897fc1e826b831e7ec3f', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.PTCXFA6H.js', '28.4', 0),
('8f7526b8bf258fd16557c9d4451a92da', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.PZM4MIZY.js', '28.4', 0),
('5c755b3f8db468f119b5f4768af3ca4c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Q2373T7A.js', '28.4', 0),
('ec2f0999e6b25f178cf554d9c79957a4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Q2KTWNXF.js', '28.4', 0),
('6260f02253b8f9cfec932a9b216debec', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Q2NDJDLV.js', '28.4', 0),
('64be02d816065e07c431604d13acf85a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Q35FLJR4.js', '28.4', 0),
('7355896ffffaebc6fd078810b0c8527e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Q6JVXZJP.js', '28.4', 0),
('3badd46e44e54c3294f315469f48a7b3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QF5Z6UDG.js', '28.4', 0),
('87afb0f5f6f35189ce837ac092dca0a9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QJTOF5QF.js', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QL5C2XOW.js', '28.4', 0),
('8234d97171eb5f7fb8eff8a0e4ef9fea', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QMXATN4R.js', '28.4', 0),
('f341f2d499a01e826a7519d07b08d2bb', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QPSNFEB2.js', '28.4', 0),
('1b42d85b45443a14b467e18c47908c90', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QQZMGVEQ.js', '28.4', 0),
('dc4c908cfa3e845395e895aa8c9c680c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QX2Z4IKH.js', '28.4', 0),
('5b609705a08dfc453a295aaf09f34e44', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QXVYWNWE.js', '28.4', 0),
('ea12aba0640fea62d9d2acf33e60f248', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QYGNPFWP.js', '28.4', 0),
('215766f828ee854575d3f85fd37a6309', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.QYWEKP2N.js', '28.4', 0),
('5f7ffa11fc1d87e6963e6a7579d913a8', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RGQ7NICF.js', '28.4', 0),
('7ba6cb5897b5a41a87d4f145ad0dea54', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RISKC4J7.js', '28.4', 0),
('7b7048b69f5b83c9d06fa87d079980e7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RLC6V3S7.js', '28.4', 0),
('78cf755841b43d3eecc1f01ed4edfb49', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ROHOK2AY.js', '28.4', 0),
('6e3979589b3c0767682aeb216ed81443', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RQ7JZ4R7.js', '28.4', 0),
('2837a587846581e29c13f4d9dfc01b62', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RV6ECJES.js', '28.4', 0),
('ac31ab9731f5d937736cd7a1f6d90896', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RWUUFNUL.js', '28.4', 0),
('57bb3f957f4dee52f6e1468a4ddf2c05', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RY5H5GHP.js', '28.4', 0),
('517d048c9f4aa5e5db903274ff3cbc91', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.RYFK2CD3.js', '28.4', 0),
('67ecb1a8d51880235d985faf7bad53e4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.S3LZDKXE.js', '28.4', 0),
('ba6a7460343ebf7239ada8ded71f033f', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.SBE7D2NT.js', '28.4', 0),
('98eb8a140a4c71643871ceb097fe9b91', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.SJGTYGCD.js', '28.4', 0),
('04dcffffe702311292e93d6afd65ae32', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.SURIBOCE.js', '28.4', 0),
('50564f7ff7f1339d165fb3ed1e108625', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.SZ6QMU5T.js', '28.4', 0),
('c3edf9de6da376317c82176a92feb827', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.T3DUE4D6.js', '28.4', 0),
('d9661fc66631e6d00e507c7d92b13407', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.TLCW7H3F.js', '28.4', 0),
('e63f9cafcf01fb0ff941a23038ad941c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.TTZ7A3DT.js', '28.4', 0),
('d11313d554ed4d29904b9b99c4f8154b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.U4LNG47M.js', '28.4', 0),
('0ddeaa54f65bd24d73d7dbd6a10d689f', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UFA6BB3R.js', '28.4', 0),
('57ce9ece2f83996a79cf5ffeead251f7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UG4GPH4N.js', '28.4', 0),
('98d5f645e0283bfad56c4c7e2f6491fb', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ULCO5Z44.js', '28.4', 0),
('c97969015adb06e353e874ab65c7fc3a', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ULG2NBYR.js', '28.4', 0),
('237dce117622b375e526ae917c1efaef', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UP75L23G.js', '28.4', 0),
('3711fe06ab28c9954228281a14f2c31b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UQRBALDC.js', '28.4', 0),
('5b54a947c7ca457d19052bb6f62edf0d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UVCAKIVM.js', '28.4', 0),
('967ffb83a342bca56beedade530d4b57', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UWOQIQT3.js', '28.4', 0),
('cb7bd23ee93f38ede83843ea7f5a5965', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UZEWILIS.js', '28.4', 0),
('cf1a6c12bf0d1eb128ae4cbb40e9cd15', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UZPPH7EB.js', '28.4', 0),
('46b518fd7e1746a742a3bc1dd0d4e843', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.UZVKBFXH.js', '28.4', 0),
('8bf480a9c8e8a6def1de5e064f35c892', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.V6CLU5EJ.js', '28.4', 0),
('1dbc6d4b39a969274223b0a609b06c70', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.VB3PXJ6D.js', '28.4', 0),
('1b56b3ebb0b7d15c08c98c1f8883aada', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.VESHGM6T.js', '28.4', 0),
('92c6a98fa63d4bc9e263dc0a7abca4f1', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.W4KUBK3S.js', '28.4', 0),
('c4d4439ecb2426340716d756b52d966d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WB35DBMS.js', '28.4', 0),
('f49f5451173c406fd8000b4e8098161e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WCSHBXT6.js', '28.4', 0),
('bd0851d9e0ff266e8eea5d79a575dd51', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WCW35DM2.js', '28.4', 0),
('739e20cf9cce577b09a4c20d1c84bfec', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WIDVIH73.js', '28.4', 0),
('cf5fa1ddb250dc52ac37f33b02600cb2', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WJC4D6NH.js', '28.4', 0),
('7d96575f9145e08da0eb664e3c777790', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WMK3G5GC.js', '28.4', 0),
('02308e8883d22a23e3ad19ab6c4ecfe9', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WP34ATUX.js', '28.4', 0),
('302b3881233c4a6eef7b18fa00bfe235', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WUT665TF.js', '28.4', 0),
('befbfc7588e7b82a6b96e261637b351e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.WWMEC6Z3.js', '28.4', 0),
('33bc9edbe7e9c1d637a73a62a27d7830', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.X4W6GM64.js', '28.4', 0),
('abffd33417adb24b66b8d47bb14b4633', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.XAC335RV.js', '28.4', 0),
('97a87cbf8b00a67bfa311cb23ce6281b', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.XDJWPVYN.js', '28.4', 0),
('ba748efba301cfcbe82b78a626a5b0c5', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.XDPSCBRH.js', '28.4', 0),
('88cbf819e42fd181c76b88f38ca5334e', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.XLYUUJLH.js', '28.4', 0),
('9eb4e370b76a4f6732ad57c3f3552fbf', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.XNEONNEJ.js', '28.4', 0),
('ce8341b1a69daa790b5efe37d3b2fd52', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.XVSBFOI2.js', '28.4', 0),
('92f2f91da368aa230cedc7e0e3c25886', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Y7EP3V6G.js', '28.4', 0),
('cb4ba80ddd87020a6ed012f9c9f600ce', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.YAEK7MSM.js', '28.4', 0),
('517baa15a515424d032d29614a8d1496', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.YC52RLOC.js', '28.4', 0),
('109a6fb9e467f893e37847b2eb7d49b3', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.YQVLPJMW.js', '28.4', 0),
('14cff407c6fed9302f255b73ca76854c', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.YR3CJNR5.js', '28.4', 0),
('e1ed8b8bca8a66b3830c16747d240a53', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.YU7UY5RS.js', '28.4', 0),
('4785224d4c9847b8f651d862a0bcdc60', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Z242SFBM.js', '28.4', 0),
('059f3b691b430afbe516441dc1f59364', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.Z6EIXACR.js', '28.4', 0),
('6fb69de5eb6ebbdbc06f663548b79326', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZCGQOXMZ.js', '28.4', 0),
('ee4fd748b882bdd5c74c40c0437a76ef', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZDBZWNPG.js', '28.4', 0),
('72d5fdecb3a3843c591a162e406760e4', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZDNXHWTM.js', '28.4', 0),
('b91ca9d1f2acd10560c37521e2a1d95d', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZIAFBSIN.js', '28.4', 0),
('d332810ad1761eec0dc569b02863f309', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZL53POKZ.js', '28.4', 0),
('46a3862810bf85e6f8838401305399d7', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZLYNHB24.js', '28.4', 0),
('e98a84006f7467a50be6294ba1e34c99', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZS3XXAR5.js', '28.4', 0),
('a02875fd463b801134a445cd740afc76', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZTQCHOVN.js', '28.4', 0),
('4eb121e315f5eae71a9ec5be576f24bb', './node_modules/@shoelace-style/shoelace/cdn/chunks/chunk.ZZVDZOHI.js', '28.4', 0),
('68d4458efe9176db90a226a70a7cb013', './node_modules/@shoelace-style/shoelace/cdn/components/alert/alert.component.js', '28.4', 0),
('21e253088fde109ec1c6ce115781c4a6', './node_modules/@shoelace-style/shoelace/cdn/components/alert/alert.js', '28.4', 0),
('debec4aae711482cefc4ad1c3565f939', './node_modules/@shoelace-style/shoelace/cdn/components/alert/alert.styles.js', '28.4', 0),
('96c328fe6ed3fa85201124d5f65bfc56', './node_modules/@shoelace-style/shoelace/cdn/components/animated-image/animated-image.component.js', '28.4', 0),
('5b6563e10b35e8d4454787c0e6f8fbbe', './node_modules/@shoelace-style/shoelace/cdn/components/animated-image/animated-image.js', '28.4', 0),
('146a84baa5543fcf5b748ada81989cdb', './node_modules/@shoelace-style/shoelace/cdn/components/animated-image/animated-image.styles.js', '28.4', 0),
('658b959d46835432f9781a3e76bdf45f', './node_modules/@shoelace-style/shoelace/cdn/components/animation/animation.component.js', '28.4', 0),
('20661ea9c4d5595d9e694da58a309c2e', './node_modules/@shoelace-style/shoelace/cdn/components/animation/animation.js', '28.4', 0),
('8d58ae721aab8fd96e329f0ecfb725f3', './node_modules/@shoelace-style/shoelace/cdn/components/animation/animation.styles.js', '28.4', 0),
('d07573cec41118392e33cec5b652fd7e', './node_modules/@shoelace-style/shoelace/cdn/components/animation/animations.js', '28.4', 0),
('0f98074452ff23f0918efc4ca48374c5', './node_modules/@shoelace-style/shoelace/cdn/components/avatar/avatar.component.js', '28.4', 0),
('598a705e9e4597e022279ddd46fb65b6', './node_modules/@shoelace-style/shoelace/cdn/components/avatar/avatar.js', '28.4', 0),
('63fe1835cde7438e900852e4f7cd0392', './node_modules/@shoelace-style/shoelace/cdn/components/avatar/avatar.styles.js', '28.4', 0),
('b41ed4499a96f9b13e78b4a780c7c120', './node_modules/@shoelace-style/shoelace/cdn/components/badge/badge.component.js', '28.4', 0),
('32814d8cf4d17fd7083fe197fcfe7c21', './node_modules/@shoelace-style/shoelace/cdn/components/badge/badge.js', '28.4', 0),
('f5871febdccf5c7a9f88a43c625d1fca', './node_modules/@shoelace-style/shoelace/cdn/components/badge/badge.styles.js', '28.4', 0),
('5ea3ce5c3148206517f196a0b54e434d', './node_modules/@shoelace-style/shoelace/cdn/components/breadcrumb-item/breadcrumb-item.component.js', '28.4', 0),
('bfa582af1acdb362caf764e5d299d672', './node_modules/@shoelace-style/shoelace/cdn/components/breadcrumb-item/breadcrumb-item.js', '28.4', 0),
('9fc299ea581ad6d470a102a0e502dc38', './node_modules/@shoelace-style/shoelace/cdn/components/breadcrumb-item/breadcrumb-item.styles.js', '28.4', 0),
('3304cf122eb19d0a05d111b0d63a7cb8', './node_modules/@shoelace-style/shoelace/cdn/components/breadcrumb/breadcrumb.component.js', '28.4', 0),
('53ad6a3464f3719fa0c9a5be67e32885', './node_modules/@shoelace-style/shoelace/cdn/components/breadcrumb/breadcrumb.js', '28.4', 0),
('5f585dcbf7196c4a33966c860ef5610c', './node_modules/@shoelace-style/shoelace/cdn/components/breadcrumb/breadcrumb.styles.js', '28.4', 0),
('a1998a2b0ea010878e8c88eafd9f121f', './node_modules/@shoelace-style/shoelace/cdn/components/button-group/button-group.component.js', '28.4', 0),
('24b25e937d47f915f9ef4482e1cb3078', './node_modules/@shoelace-style/shoelace/cdn/components/button-group/button-group.js', '28.4', 0),
('c2f23179e9eb711bfbc43a63a6362e5f', './node_modules/@shoelace-style/shoelace/cdn/components/button-group/button-group.styles.js', '28.4', 0),
('f2ba1554ee5d42b38308159a1747f56b', './node_modules/@shoelace-style/shoelace/cdn/components/button/button.component.js', '28.4', 0),
('462f382a16e6ee8f6f96010a1e8e966d', './node_modules/@shoelace-style/shoelace/cdn/components/button/button.js', '28.4', 0),
('f3551e3296538194db445791f59574d0', './node_modules/@shoelace-style/shoelace/cdn/components/button/button.styles.js', '28.4', 0),
('bf5c3e2dcca94bcadbdbe3dac97590a2', './node_modules/@shoelace-style/shoelace/cdn/components/card/card.component.js', '28.4', 0),
('a01a1e56ab27868ad7215b1406f828c5', './node_modules/@shoelace-style/shoelace/cdn/components/card/card.js', '28.4', 0),
('cee162fcb59e0575a9c603fe36fb4cea', './node_modules/@shoelace-style/shoelace/cdn/components/card/card.styles.js', '28.4', 0),
('22f10b7ceba5f7089b0dda1df278fb8b', './node_modules/@shoelace-style/shoelace/cdn/components/carousel-item/carousel-item.component.js', '28.4', 0),
('d2e45867d4e83136985a4ae4a5eb68da', './node_modules/@shoelace-style/shoelace/cdn/components/carousel-item/carousel-item.js', '28.4', 0),
('2c43c06ac4d1ec6bbc7a451f57fc2575', './node_modules/@shoelace-style/shoelace/cdn/components/carousel-item/carousel-item.styles.js', '28.4', 0),
('d5d3d6c1652b768fc809edb7317b918b', './node_modules/@shoelace-style/shoelace/cdn/components/carousel/autoplay-controller.js', '28.4', 0),
('323ec9bbe4050b155b8c923dd7b5f326', './node_modules/@shoelace-style/shoelace/cdn/components/carousel/carousel.component.js', '28.4', 0),
('6f0fc44a3cd85485a33d73462d5d3b4a', './node_modules/@shoelace-style/shoelace/cdn/components/carousel/carousel.js', '28.4', 0),
('80c2127ebfb88dedc864807b66f0e945', './node_modules/@shoelace-style/shoelace/cdn/components/carousel/carousel.styles.js', '28.4', 0),
('7e24bbfa565cb8e71c0cc35383e0fa3a', './node_modules/@shoelace-style/shoelace/cdn/components/checkbox/checkbox.component.js', '28.4', 0),
('314f17ff2e607a04240c685a9833d1c1', './node_modules/@shoelace-style/shoelace/cdn/components/checkbox/checkbox.js', '28.4', 0),
('ab4bae7f26aa157653c7c4212dbf48b6', './node_modules/@shoelace-style/shoelace/cdn/components/checkbox/checkbox.styles.js', '28.4', 0),
('86d9b7936a1e7d2ab1fb33215041fb99', './node_modules/@shoelace-style/shoelace/cdn/components/color-picker/color-picker.component.js', '28.4', 0),
('4c53f82e25bce682cdbdd4ec5cbe5e18', './node_modules/@shoelace-style/shoelace/cdn/components/color-picker/color-picker.js', '28.4', 0),
('a37f6f97b085ef860ad90e8e65d005dc', './node_modules/@shoelace-style/shoelace/cdn/components/color-picker/color-picker.styles.js', '28.4', 0),
('f0bb29acb3717efb17714966bea5e2db', './node_modules/@shoelace-style/shoelace/cdn/components/copy-button/copy-button.component.js', '28.4', 0),
('7a8f0e5161141d0d68ad85635f087a73', './node_modules/@shoelace-style/shoelace/cdn/components/copy-button/copy-button.js', '28.4', 0),
('84336e00562431431a83337314270b55', './node_modules/@shoelace-style/shoelace/cdn/components/copy-button/copy-button.styles.js', '28.4', 0),
('36e66a96a65601f417afefa88ba370a9', './node_modules/@shoelace-style/shoelace/cdn/components/details/details.component.js', '28.4', 0),
('eeb15d4d4f1c505b3184bdd89b8c63f5', './node_modules/@shoelace-style/shoelace/cdn/components/details/details.js', '28.4', 0),
('d267ac32f584b1a92dc56749cf3c5e29', './node_modules/@shoelace-style/shoelace/cdn/components/details/details.styles.js', '28.4', 0),
('7445852fc1f8ac13dd0b1e98aaf9437b', './node_modules/@shoelace-style/shoelace/cdn/components/dialog/dialog.component.js', '28.4', 0),
('432706d2d3f308832b0c71d64f0fa720', './node_modules/@shoelace-style/shoelace/cdn/components/dialog/dialog.js', '28.4', 0),
('f43c58fd52e980bb7b6c9bfdc4dbe571', './node_modules/@shoelace-style/shoelace/cdn/components/dialog/dialog.styles.js', '28.4', 0),
('d7cfb35f97ec481d7843820d555497cd', './node_modules/@shoelace-style/shoelace/cdn/components/divider/divider.component.js', '28.4', 0),
('e29017b349ef57e84c07eca2f927a35c', './node_modules/@shoelace-style/shoelace/cdn/components/divider/divider.js', '28.4', 0),
('db6a5a4edb9e8ba70a8103ca8954fb92', './node_modules/@shoelace-style/shoelace/cdn/components/divider/divider.styles.js', '28.4', 0),
('c245f51538565269bc21823120dffdb4', './node_modules/@shoelace-style/shoelace/cdn/components/drawer/drawer.component.js', '28.4', 0),
('9e2e5a9d1f1694e9b2715c0e8cb0b2d8', './node_modules/@shoelace-style/shoelace/cdn/components/drawer/drawer.js', '28.4', 0),
('18f493374725eee27d20883f98f65921', './node_modules/@shoelace-style/shoelace/cdn/components/drawer/drawer.styles.js', '28.4', 0),
('03547828a9c8e5d04ede7620685b316c', './node_modules/@shoelace-style/shoelace/cdn/components/dropdown/dropdown.component.js', '28.4', 0),
('4a217949133e829d1e582754110c2e2a', './node_modules/@shoelace-style/shoelace/cdn/components/dropdown/dropdown.js', '28.4', 0),
('93b1e8ff941604ba75449804bf874a85', './node_modules/@shoelace-style/shoelace/cdn/components/dropdown/dropdown.styles.js', '28.4', 0),
('6478a56b0dc43ada791c43e56aa19c2b', './node_modules/@shoelace-style/shoelace/cdn/components/format-bytes/format-bytes.component.js', '28.4', 0),
('e208523e51e455b3ff80b19537b1626e', './node_modules/@shoelace-style/shoelace/cdn/components/format-bytes/format-bytes.js', '28.4', 0),
('f60160cf839d24114de75d37ba6ff5fe', './node_modules/@shoelace-style/shoelace/cdn/components/format-date/format-date.component.js', '28.4', 0),
('cd548a778acd8f8e524cb31c80ebf3e7', './node_modules/@shoelace-style/shoelace/cdn/components/format-date/format-date.js', '28.4', 0),
('4cd60199f4ca22ba01a7bc762396e98b', './node_modules/@shoelace-style/shoelace/cdn/components/format-number/format-number.component.js', '28.4', 0),
('ef7148432886c74eaa2a89ef7ea5e077', './node_modules/@shoelace-style/shoelace/cdn/components/format-number/format-number.js', '28.4', 0),
('3aa47065c4b18f20d078947e982760d4', './node_modules/@shoelace-style/shoelace/cdn/components/icon-button/icon-button.component.js', '28.4', 0),
('3af8a3e77bea0b5455fa53b915a1ce8b', './node_modules/@shoelace-style/shoelace/cdn/components/icon-button/icon-button.js', '28.4', 0),
('71cf67e2e46d20de8a42da03056b2282', './node_modules/@shoelace-style/shoelace/cdn/components/icon-button/icon-button.styles.js', '28.4', 0),
('9d600f77f5f1714e9627d5735b2c76fa', './node_modules/@shoelace-style/shoelace/cdn/components/icon/icon.component.js', '28.4', 0),
('0b5e975b339b94bd25bfd616d7e7a3fe', './node_modules/@shoelace-style/shoelace/cdn/components/icon/icon.js', '28.4', 0),
('7663ba4db6fccd388016d887ce7b1fd3', './node_modules/@shoelace-style/shoelace/cdn/components/icon/icon.styles.js', '28.4', 0),
('3e4bd650361e81d82ab02dc745c4aaef', './node_modules/@shoelace-style/shoelace/cdn/components/icon/library.default.js', '28.4', 0),
('01e825397729d9cf65cc4cd6ca302596', './node_modules/@shoelace-style/shoelace/cdn/components/icon/library.js', '28.4', 0),
('1955d0572c7437e643e4425107b3ea9f', './node_modules/@shoelace-style/shoelace/cdn/components/icon/library.system.js', '28.4', 0),
('d3f29fc63086f7e03bef8fbb59956cdc', './node_modules/@shoelace-style/shoelace/cdn/components/image-comparer/image-comparer.component.js', '28.4', 0),
('b5e2e3dd8fe33c71589839d41296db9f', './node_modules/@shoelace-style/shoelace/cdn/components/image-comparer/image-comparer.js', '28.4', 0),
('f17d7091ade4810b1e4505eebdc8d02a', './node_modules/@shoelace-style/shoelace/cdn/components/image-comparer/image-comparer.styles.js', '28.4', 0),
('eea1ee99c2f6f7b32639cf1a13c6d47c', './node_modules/@shoelace-style/shoelace/cdn/components/include/include.component.js', '28.4', 0),
('d2be3e8c440733b614b69811e52b2cf7', './node_modules/@shoelace-style/shoelace/cdn/components/include/include.js', '28.4', 0),
('fe398a9246ea9c79a1b1555f6566245c', './node_modules/@shoelace-style/shoelace/cdn/components/include/include.styles.js', '28.4', 0),
('e7d5754370fbb222451b94cb7c099cbc', './node_modules/@shoelace-style/shoelace/cdn/components/include/request.js', '28.4', 0),
('ab76126a0ef4c9c9a315a8ef059ca8f1', './node_modules/@shoelace-style/shoelace/cdn/components/input/input.component.js', '28.4', 0),
('3a28c8b54c362fbccea300176efe2069', './node_modules/@shoelace-style/shoelace/cdn/components/input/input.js', '28.4', 0),
('48794e789a320dda1cb0813058192b59', './node_modules/@shoelace-style/shoelace/cdn/components/input/input.styles.js', '28.4', 0),
('e7fdb7a2ba8b64316e7ea7017d9b2ae0', './node_modules/@shoelace-style/shoelace/cdn/components/menu-item/menu-item.component.js', '28.4', 0),
('ecb4f3f9cfa70f7e6fd7deaf09e32158', './node_modules/@shoelace-style/shoelace/cdn/components/menu-item/menu-item.js', '28.4', 0),
('fcd43f0764ed609745b0efac9c0cc346', './node_modules/@shoelace-style/shoelace/cdn/components/menu-item/menu-item.styles.js', '28.4', 0),
('bfa8ef221d62aa0672026ac5b6d96c5d', './node_modules/@shoelace-style/shoelace/cdn/components/menu-item/submenu-controller.js', '28.4', 0),
('c623205f8fa1b7e17e5cda842253ca62', './node_modules/@shoelace-style/shoelace/cdn/components/menu-label/menu-label.component.js', '28.4', 0),
('066c7b6336155608ef1da5a924604b27', './node_modules/@shoelace-style/shoelace/cdn/components/menu-label/menu-label.js', '28.4', 0),
('8c12b2f9d7ada596cdfbe35275ec8849', './node_modules/@shoelace-style/shoelace/cdn/components/menu-label/menu-label.styles.js', '28.4', 0),
('b8343ce67e823f1f70ec09801bd8065c', './node_modules/@shoelace-style/shoelace/cdn/components/menu/menu.component.js', '28.4', 0),
('01ff986283105ff127c119374e7a4131', './node_modules/@shoelace-style/shoelace/cdn/components/menu/menu.js', '28.4', 0),
('18af83e6ff136eb25db6c45c8ac8f576', './node_modules/@shoelace-style/shoelace/cdn/components/menu/menu.styles.js', '28.4', 0),
('166516f22f3da64e58af58cf5f4e31e1', './node_modules/@shoelace-style/shoelace/cdn/components/mutation-observer/mutation-observer.component.js', '28.4', 0),
('a4ad4893a3ad51ff0a5ec16102cf210b', './node_modules/@shoelace-style/shoelace/cdn/components/mutation-observer/mutation-observer.js', '28.4', 0),
('b46bd7e359a552eb9319c4c3828b1bf0', './node_modules/@shoelace-style/shoelace/cdn/components/mutation-observer/mutation-observer.styles.js', '28.4', 0),
('826b1027edbeeee172b3a039a7424872', './node_modules/@shoelace-style/shoelace/cdn/components/option/option.component.js', '28.4', 0),
('99948ead03e6c7221f665866c91c3bc0', './node_modules/@shoelace-style/shoelace/cdn/components/option/option.js', '28.4', 0),
('2be387591e1de07adefff195fd8c7258', './node_modules/@shoelace-style/shoelace/cdn/components/option/option.styles.js', '28.4', 0),
('df40cbe6bbc25acd9aab9acfac5ec2be', './node_modules/@shoelace-style/shoelace/cdn/components/popup/popup.component.js', '28.4', 0),
('74c08b46cc58c6052c01b4febb4a6453', './node_modules/@shoelace-style/shoelace/cdn/components/popup/popup.js', '28.4', 0),
('27f813107ecaed7d5f1ad63aa96975bd', './node_modules/@shoelace-style/shoelace/cdn/components/popup/popup.styles.js', '28.4', 0),
('8b89d188fdc0d879ad1e5617b224312a', './node_modules/@shoelace-style/shoelace/cdn/components/progress-bar/progress-bar.component.js', '28.4', 0),
('783709e056b094dc8e5f8279fc6e6c17', './node_modules/@shoelace-style/shoelace/cdn/components/progress-bar/progress-bar.js', '28.4', 0),
('9fd255b077f3899f9dc411799c5958e3', './node_modules/@shoelace-style/shoelace/cdn/components/progress-bar/progress-bar.styles.js', '28.4', 0),
('4f577f3551617c7539cc860a812e5bc0', './node_modules/@shoelace-style/shoelace/cdn/components/progress-ring/progress-ring.component.js', '28.4', 0),
('f9739b0bcede6ebe14001f3f7649e761', './node_modules/@shoelace-style/shoelace/cdn/components/progress-ring/progress-ring.js', '28.4', 0),
('35f50f8d672d65ffc027d1329edb4dc8', './node_modules/@shoelace-style/shoelace/cdn/components/progress-ring/progress-ring.styles.js', '28.4', 0),
('678d1e0ec8be1899cf785d84db18f384', './node_modules/@shoelace-style/shoelace/cdn/components/qr-code/qr-code.component.js', '28.4', 0),
('96e234a54c9c666429c6e70ad17b6a79', './node_modules/@shoelace-style/shoelace/cdn/components/qr-code/qr-code.js', '28.4', 0),
('7ad0b986b71093b1f105e221a7067f5c', './node_modules/@shoelace-style/shoelace/cdn/components/qr-code/qr-code.styles.js', '28.4', 0),
('0628adf56c6f8a29ceda1e3146bcc0dd', './node_modules/@shoelace-style/shoelace/cdn/components/radio-button/radio-button.component.js', '28.4', 0),
('10c50932fa9c7726ebcad7789bcef1d7', './node_modules/@shoelace-style/shoelace/cdn/components/radio-button/radio-button.js', '28.4', 0),
('47de3ffbb4ae50abee1783eb12dc4f14', './node_modules/@shoelace-style/shoelace/cdn/components/radio-button/radio-button.styles.js', '28.4', 0),
('722711fcda1019639f4b62850f82e154', './node_modules/@shoelace-style/shoelace/cdn/components/radio-group/radio-group.component.js', '28.4', 0),
('ffd31263ca58fa67ec59ec0c549ffddb', './node_modules/@shoelace-style/shoelace/cdn/components/radio-group/radio-group.js', '28.4', 0),
('f2d01ef56d01cc2c302561990d8ef938', './node_modules/@shoelace-style/shoelace/cdn/components/radio-group/radio-group.styles.js', '28.4', 0),
('c1c0f61df95634cb376c77abebda0924', './node_modules/@shoelace-style/shoelace/cdn/components/radio/radio.component.js', '28.4', 0),
('69a24721d0600cd1bd08f525ab7d6318', './node_modules/@shoelace-style/shoelace/cdn/components/radio/radio.js', '28.4', 0),
('7a05b449bd3839d0bbb09182965919a0', './node_modules/@shoelace-style/shoelace/cdn/components/radio/radio.styles.js', '28.4', 0),
('28590a1f8b14f80aa28369ab9a17932e', './node_modules/@shoelace-style/shoelace/cdn/components/range/range.component.js', '28.4', 0),
('cacf33b44a8ecb734e27c1574a287a0e', './node_modules/@shoelace-style/shoelace/cdn/components/range/range.js', '28.4', 0),
('49d04b40748e8422bc18fb2057ddf773', './node_modules/@shoelace-style/shoelace/cdn/components/range/range.styles.js', '28.4', 0),
('071bd900bfbeedcc8b5b9db9a285ce20', './node_modules/@shoelace-style/shoelace/cdn/components/rating/rating.component.js', '28.4', 0),
('f0310b9be534d12e8af990a515f4667b', './node_modules/@shoelace-style/shoelace/cdn/components/rating/rating.js', '28.4', 0),
('c6a2a002c58f8079967aad50ef78dbb3', './node_modules/@shoelace-style/shoelace/cdn/components/rating/rating.styles.js', '28.4', 0),
('83efecade7fab68943bcfb1af2f4b7e9', './node_modules/@shoelace-style/shoelace/cdn/components/relative-time/relative-time.component.js', '28.4', 0),
('94606bf3f3266d677817bf831e185bd7', './node_modules/@shoelace-style/shoelace/cdn/components/relative-time/relative-time.js', '28.4', 0),
('1dcbd840b7e72bfed249d9859a0b89e1', './node_modules/@shoelace-style/shoelace/cdn/components/resize-observer/resize-observer.component.js', '28.4', 0),
('cc115640203a68101d252d446ddbfe5f', './node_modules/@shoelace-style/shoelace/cdn/components/resize-observer/resize-observer.js', '28.4', 0),
('7f16d8a68bac18a362b65326f4a414f8', './node_modules/@shoelace-style/shoelace/cdn/components/resize-observer/resize-observer.styles.js', '28.4', 0),
('f0b71f026cf9515bde3457f9ab8f0a24', './node_modules/@shoelace-style/shoelace/cdn/components/select/select.component.js', '28.4', 0),
('471fcc3d5bb52b7a94a888dae88b5e48', './node_modules/@shoelace-style/shoelace/cdn/components/select/select.js', '28.4', 0),
('d8e06a7ac044ef4388420a6d22d37537', './node_modules/@shoelace-style/shoelace/cdn/components/select/select.styles.js', '28.4', 0),
('0d8dcc71185b0ad9a3575eb05618d144', './node_modules/@shoelace-style/shoelace/cdn/components/skeleton/skeleton.component.js', '28.4', 0),
('d5200998e83119253c76d547caf288bf', './node_modules/@shoelace-style/shoelace/cdn/components/skeleton/skeleton.js', '28.4', 0),
('ba5353c0ca77cbf8c3a9d465d95ab129', './node_modules/@shoelace-style/shoelace/cdn/components/skeleton/skeleton.styles.js', '28.4', 0),
('0e86096070a4c114c3fabf98d784b865', './node_modules/@shoelace-style/shoelace/cdn/components/spinner/spinner.component.js', '28.4', 0),
('494713857e30b7b5b4104075b66b0eff', './node_modules/@shoelace-style/shoelace/cdn/components/spinner/spinner.js', '28.4', 0),
('18eb1608d4309113d6cf8d287c28105f', './node_modules/@shoelace-style/shoelace/cdn/components/spinner/spinner.styles.js', '28.4', 0),
('2b5c467d48c2c9e695124377c10a4122', './node_modules/@shoelace-style/shoelace/cdn/components/split-panel/split-panel.component.js', '28.4', 0),
('4f22dd38a85ad0f64bd61a0841e5f40b', './node_modules/@shoelace-style/shoelace/cdn/components/split-panel/split-panel.js', '28.4', 0),
('84efba0a5f3f17d27302123e880a65ed', './node_modules/@shoelace-style/shoelace/cdn/components/split-panel/split-panel.styles.js', '28.4', 0),
('0caddbb3375cbd9556a9ef35121c8f0d', './node_modules/@shoelace-style/shoelace/cdn/components/switch/switch.component.js', '28.4', 0),
('cf99a72fc47569fb114352433cd3c8ec', './node_modules/@shoelace-style/shoelace/cdn/components/switch/switch.js', '28.4', 0),
('d7860d6d92b4e458f56c8f0e69e31a17', './node_modules/@shoelace-style/shoelace/cdn/components/switch/switch.styles.js', '28.4', 0),
('0e91b87dc58de83f8534c09631f91787', './node_modules/@shoelace-style/shoelace/cdn/components/tab-group/tab-group.component.js', '28.4', 0),
('81a658723186dac24c63fb756538a860', './node_modules/@shoelace-style/shoelace/cdn/components/tab-group/tab-group.js', '28.4', 0),
('2511cbeefe80a5bc7e91c92aa8dbd172', './node_modules/@shoelace-style/shoelace/cdn/components/tab-group/tab-group.styles.js', '28.4', 0),
('7ec516b6af816417f87a2fc45677bd21', './node_modules/@shoelace-style/shoelace/cdn/components/tab-panel/tab-panel.component.js', '28.4', 0),
('b0925c495bb8fd9799cbb9e2f4c00794', './node_modules/@shoelace-style/shoelace/cdn/components/tab-panel/tab-panel.js', '28.4', 0),
('5a6435e91ad8d9d887b4197019322e6e', './node_modules/@shoelace-style/shoelace/cdn/components/tab-panel/tab-panel.styles.js', '28.4', 0),
('d0a22f26ec1b854cbb624e58d3a9f8f6', './node_modules/@shoelace-style/shoelace/cdn/components/tab/tab.component.js', '28.4', 0),
('e1488d4ad30d08c054ea7adb1ea802df', './node_modules/@shoelace-style/shoelace/cdn/components/tab/tab.js', '28.4', 0),
('eb9b7d9e49504744dd81250d01ff51ec', './node_modules/@shoelace-style/shoelace/cdn/components/tab/tab.styles.js', '28.4', 0),
('6b19e1da65add39050f180c2ba112fa8', './node_modules/@shoelace-style/shoelace/cdn/components/tag/tag.component.js', '28.4', 0),
('239a7da4045a2efea5dc2e13300501aa', './node_modules/@shoelace-style/shoelace/cdn/components/tag/tag.js', '28.4', 0),
('42c4d9bfe683536589fa6967fac0d8b8', './node_modules/@shoelace-style/shoelace/cdn/components/tag/tag.styles.js', '28.4', 0),
('92aac9bd45b6c95e3a7234dd646e33e5', './node_modules/@shoelace-style/shoelace/cdn/components/textarea/textarea.component.js', '28.4', 0),
('4a1628a9b6284bf82ba8f39200a27f95', './node_modules/@shoelace-style/shoelace/cdn/components/textarea/textarea.js', '28.4', 0),
('811492582ee3a0740a91436b6e82f154', './node_modules/@shoelace-style/shoelace/cdn/components/textarea/textarea.styles.js', '28.4', 0),
('9db753e1871532d670725309675c402b', './node_modules/@shoelace-style/shoelace/cdn/components/tooltip/tooltip.component.js', '28.4', 0),
('d618f222cdd31cf5f8b29e93e6f77f87', './node_modules/@shoelace-style/shoelace/cdn/components/tooltip/tooltip.js', '28.4', 0),
('965007b26ef0a9e98b3da1a7b102f7e8', './node_modules/@shoelace-style/shoelace/cdn/components/tooltip/tooltip.styles.js', '28.4', 0),
('79c131c629c4f44e161d6e6027a7fe4a', './node_modules/@shoelace-style/shoelace/cdn/components/tree-item/tree-item.component.js', '28.4', 0),
('3440da2b65784961dddd2e00c3785e57', './node_modules/@shoelace-style/shoelace/cdn/components/tree-item/tree-item.js', '28.4', 0),
('819dc1ce066ad2c671c40f5302215ab3', './node_modules/@shoelace-style/shoelace/cdn/components/tree-item/tree-item.styles.js', '28.4', 0),
('e5d095ce392367a3c6d77358a9c40901', './node_modules/@shoelace-style/shoelace/cdn/components/tree/tree.component.js', '28.4', 0),
('77e3fbf605afde97de86d5e54d86f3d9', './node_modules/@shoelace-style/shoelace/cdn/components/tree/tree.js', '28.4', 0),
('e95063fc5cb3172604819eba2663473d', './node_modules/@shoelace-style/shoelace/cdn/components/tree/tree.styles.js', '28.4', 0),
('f0debe75148dd9bbefaf8943af83d4c0', './node_modules/@shoelace-style/shoelace/cdn/components/visually-hidden/visually-hidden.component.js', '28.4', 0),
('5fa9a11fd16fe82f616069f13d51ac84', './node_modules/@shoelace-style/shoelace/cdn/components/visually-hidden/visually-hidden.js', '28.4', 0),
('83788a54d48117f763e9abb6ae0ed5f3', './node_modules/@shoelace-style/shoelace/cdn/components/visually-hidden/visually-hidden.styles.js', '28.4', 0),
('1ffb6167272e3c7cad5bcd67002ed4da', './node_modules/@shoelace-style/shoelace/cdn/react/alert/index.js', '28.4', 0),
('eaa208c978fdf36bec8f62c738f86f30', './node_modules/@shoelace-style/shoelace/cdn/react/animated-image/index.js', '28.4', 0),
('9dbde45fe0cebceb8ca255c85954965c', './node_modules/@shoelace-style/shoelace/cdn/react/animation/index.js', '28.4', 0),
('b519c85d7884ac7307626da1ff5e97ad', './node_modules/@shoelace-style/shoelace/cdn/react/avatar/index.js', '28.4', 0),
('8fbc4b8259605fcf9ceeb97ce8839988', './node_modules/@shoelace-style/shoelace/cdn/react/badge/index.js', '28.4', 0),
('38869622abe9cf2943d17cdd30d67d62', './node_modules/@shoelace-style/shoelace/cdn/react/breadcrumb-item/index.js', '28.4', 0),
('69d429cd786e0aaed93dd28627a84ded', './node_modules/@shoelace-style/shoelace/cdn/react/breadcrumb/index.js', '28.4', 0),
('cf6ab4229e43f7842363c23a5a0a3727', './node_modules/@shoelace-style/shoelace/cdn/react/button-group/index.js', '28.4', 0),
('439105376e38e46eb60f112a59d986ad', './node_modules/@shoelace-style/shoelace/cdn/react/button/index.js', '28.4', 0),
('7eab180eb313b7b69d5ed2b97c883d2f', './node_modules/@shoelace-style/shoelace/cdn/react/card/index.js', '28.4', 0),
('236dbd22266cb8ff9955c1be678cc267', './node_modules/@shoelace-style/shoelace/cdn/react/carousel-item/index.js', '28.4', 0),
('9492fd40271ab4f950b24a46e104f668', './node_modules/@shoelace-style/shoelace/cdn/react/carousel/index.js', '28.4', 0),
('71c971eefdb25bf52726f0c769ee3a93', './node_modules/@shoelace-style/shoelace/cdn/react/checkbox/index.js', '28.4', 0),
('2a4a6752245f571d17b145165e6a74b5', './node_modules/@shoelace-style/shoelace/cdn/react/color-picker/index.js', '28.4', 0),
('fa0e0fd76ab2a24c89a82677c13b2780', './node_modules/@shoelace-style/shoelace/cdn/react/copy-button/index.js', '28.4', 0),
('fa925d3aeb520d000732d5794310f0bd', './node_modules/@shoelace-style/shoelace/cdn/react/details/index.js', '28.4', 0),
('65fd38a1cbdee364cf22d7bddaa33bfe', './node_modules/@shoelace-style/shoelace/cdn/react/dialog/index.js', '28.4', 0),
('0ed68605d2b8cb02ae01319582ca5769', './node_modules/@shoelace-style/shoelace/cdn/react/divider/index.js', '28.4', 0),
('19f48bd172c18795a8ff5b57e5e39986', './node_modules/@shoelace-style/shoelace/cdn/react/drawer/index.js', '28.4', 0),
('0d488812c196ff8ee7d35210cfe20bc0', './node_modules/@shoelace-style/shoelace/cdn/react/dropdown/index.js', '28.4', 0),
('22f6873d15fb5302e2ec8c06a50878f3', './node_modules/@shoelace-style/shoelace/cdn/react/format-bytes/index.js', '28.4', 0),
('943b8f45207947be0cc0982173779df5', './node_modules/@shoelace-style/shoelace/cdn/react/format-date/index.js', '28.4', 0),
('7c86f205a66fce6afb312fa548839540', './node_modules/@shoelace-style/shoelace/cdn/react/format-number/index.js', '28.4', 0),
('f23df6c96d5ac9b133d0cdbca4357acb', './node_modules/@shoelace-style/shoelace/cdn/react/icon-button/index.js', '28.4', 0),
('1e53434873d75bb69b98d2cdaac3e563', './node_modules/@shoelace-style/shoelace/cdn/react/icon/index.js', '28.4', 0),
('ff31701c29e472af272cafc331563f65', './node_modules/@shoelace-style/shoelace/cdn/react/image-comparer/index.js', '28.4', 0),
('31a06486f824ca4a398cfa8b3b7ffce2', './node_modules/@shoelace-style/shoelace/cdn/react/include/index.js', '28.4', 0),
('81c5f3293581b837000a319e7c7dc07d', './node_modules/@shoelace-style/shoelace/cdn/react/index.js', '28.4', 0),
('c3e33ec2808304c1b330db076d637f67', './node_modules/@shoelace-style/shoelace/cdn/react/input/index.js', '28.4', 0),
('70fa70cbe095285d706314f7cbfa66c6', './node_modules/@shoelace-style/shoelace/cdn/react/menu-item/index.js', '28.4', 0),
('9f983589a909dc767ec1721e29336f2e', './node_modules/@shoelace-style/shoelace/cdn/react/menu-label/index.js', '28.4', 0),
('ab0efa356d8721881aa28b94760867c0', './node_modules/@shoelace-style/shoelace/cdn/react/menu/index.js', '28.4', 0),
('481dd93532ad4385730cae871b958876', './node_modules/@shoelace-style/shoelace/cdn/react/mutation-observer/index.js', '28.4', 0),
('3d5327070650bffe0289f00123e6d4a8', './node_modules/@shoelace-style/shoelace/cdn/react/option/index.js', '28.4', 0),
('873455a860999ee06226d2cacb35ef5a', './node_modules/@shoelace-style/shoelace/cdn/react/popup/index.js', '28.4', 0),
('db9ad33dd6a82c124ad9eb058a3d638f', './node_modules/@shoelace-style/shoelace/cdn/react/progress-bar/index.js', '28.4', 0),
('a6ac7a80d3a7b3f8f81f3fa0a17533c1', './node_modules/@shoelace-style/shoelace/cdn/react/progress-ring/index.js', '28.4', 0),
('ca37e25f405ab897c3b2ce49f8492ff6', './node_modules/@shoelace-style/shoelace/cdn/react/qr-code/index.js', '28.4', 0),
('727223b365d582c56f47a33cdca1915e', './node_modules/@shoelace-style/shoelace/cdn/react/radio-button/index.js', '28.4', 0),
('59fc4418036d15fe4ebd2b207a096cc4', './node_modules/@shoelace-style/shoelace/cdn/react/radio-group/index.js', '28.4', 0),
('32435d7afe1893caafb9db4cdf7745f4', './node_modules/@shoelace-style/shoelace/cdn/react/radio/index.js', '28.4', 0),
('863f4bc3b78147f62c0fa87b7a7ab930', './node_modules/@shoelace-style/shoelace/cdn/react/range/index.js', '28.4', 0),
('6570b58d4a574ddaf0125f8d65224214', './node_modules/@shoelace-style/shoelace/cdn/react/rating/index.js', '28.4', 0),
('fd968f43dec0aa9d33310024017ee65e', './node_modules/@shoelace-style/shoelace/cdn/react/relative-time/index.js', '28.4', 0),
('182d6d6ad4b809f00f2c8ea369d7c9d5', './node_modules/@shoelace-style/shoelace/cdn/react/resize-observer/index.js', '28.4', 0),
('9b30fd70ad764658e49eb4b24294388b', './node_modules/@shoelace-style/shoelace/cdn/react/select/index.js', '28.4', 0),
('a5596ec25ade03310af5e607b69c8cd9', './node_modules/@shoelace-style/shoelace/cdn/react/skeleton/index.js', '28.4', 0),
('42a85070c7876027fa231c8aa0e4c76c', './node_modules/@shoelace-style/shoelace/cdn/react/spinner/index.js', '28.4', 0),
('2e7b18f80ee6fb89d0f9ba17eed7e1bf', './node_modules/@shoelace-style/shoelace/cdn/react/split-panel/index.js', '28.4', 0),
('901ce716f2932e68fb6d82b1e99ef8b1', './node_modules/@shoelace-style/shoelace/cdn/react/switch/index.js', '28.4', 0),
('107832f21338690bc78bdf17742a1b85', './node_modules/@shoelace-style/shoelace/cdn/react/tab-group/index.js', '28.4', 0),
('2c5c6d47862a590daa1ce05fbe25f356', './node_modules/@shoelace-style/shoelace/cdn/react/tab-panel/index.js', '28.4', 0),
('8838f995f72761f612daeb641d0f7904', './node_modules/@shoelace-style/shoelace/cdn/react/tab/index.js', '28.4', 0),
('7c108b624b64599b92a186f3af13dd9e', './node_modules/@shoelace-style/shoelace/cdn/react/tag/index.js', '28.4', 0),
('abbc946a66ef1653cb20c22a75e5fde8', './node_modules/@shoelace-style/shoelace/cdn/react/textarea/index.js', '28.4', 0),
('a4f9ef484ccbc7759cdcd136c36c0618', './node_modules/@shoelace-style/shoelace/cdn/react/tooltip/index.js', '28.4', 0),
('d176c048e72fd04ae606deafa0388e00', './node_modules/@shoelace-style/shoelace/cdn/react/tree-item/index.js', '28.4', 0),
('7011554a3b70a82a3bd02a98094dbb02', './node_modules/@shoelace-style/shoelace/cdn/react/tree/index.js', '28.4', 0),
('a2fd93621f139346d72b1821f4411682', './node_modules/@shoelace-style/shoelace/cdn/react/visually-hidden/index.js', '28.4', 0),
('7fc6e4b00ea66f80c9f0ddf5359d2bcb', './node_modules/@shoelace-style/shoelace/cdn/shoelace-autoloader.js', '28.4', 0),
('a7f03995d0071f64372f8d27d8869f09', './node_modules/@shoelace-style/shoelace/cdn/shoelace.js', '28.4', 0),
('7ffcaaf33706026fdce1538af587fdf6', './node_modules/@shoelace-style/shoelace/cdn/themes/dark.css', '28.4', 0),
('3f243bb3a49294c75c4ec99e87e6c952', './node_modules/@shoelace-style/shoelace/cdn/themes/dark.styles.js', '28.4', 0),
('449790d2e0ac49f31fd9dbf6f5646231', './node_modules/@shoelace-style/shoelace/cdn/themes/light.css', '28.4', 0),
('f651379c6ba4795b6caf43d2afb7ef68', './node_modules/@shoelace-style/shoelace/cdn/themes/light.styles.js', '28.4', 0),
('8aca8781274a8b942440af357ef870dd', './node_modules/@shoelace-style/shoelace/cdn/translations/ar.js', '28.4', 0),
('0ebe2f74d3345b8f0f8361892e5c0850', './node_modules/@shoelace-style/shoelace/cdn/translations/cs.js', '28.4', 0),
('9e99c008c8568dbb94ded48e1dab735d', './node_modules/@shoelace-style/shoelace/cdn/translations/da.js', '28.4', 0),
('b4f409637a82041f231ab35461e54a26', './node_modules/@shoelace-style/shoelace/cdn/translations/de-ch.js', '28.4', 0),
('4d754b953d20b9c41cfdde817d34302e', './node_modules/@shoelace-style/shoelace/cdn/translations/de.js', '28.4', 0),
('5bb0dbb791c7c22fd5c4854dd4f72df6', './node_modules/@shoelace-style/shoelace/cdn/translations/en-gb.js', '28.4', 0),
('91e14bbb4bca27e7523be9fd7a5db995', './node_modules/@shoelace-style/shoelace/cdn/translations/en.js', '28.4', 0),
('1dac82d5802d8699543fa5f38dfb3b5a', './node_modules/@shoelace-style/shoelace/cdn/translations/es.js', '28.4', 0),
('185e24f65373b7f8b0d54aa14c987781', './node_modules/@shoelace-style/shoelace/cdn/translations/fa.js', '28.4', 0),
('f4f32c74c8e88b7d0400cf6427096e40', './node_modules/@shoelace-style/shoelace/cdn/translations/fr.js', '28.4', 0),
('6d61cda3cea48f696ee6301339116a6f', './node_modules/@shoelace-style/shoelace/cdn/translations/he.js', '28.4', 0),
('a715242e72f46b5542b9bdd3adb6b56f', './node_modules/@shoelace-style/shoelace/cdn/translations/hr.js', '28.4', 0),
('64ef5964500d57c4d9fabc1b7664efd9', './node_modules/@shoelace-style/shoelace/cdn/translations/hu.js', '28.4', 0),
('462d79dd3e42c2e869fcbdb9aae5bf74', './node_modules/@shoelace-style/shoelace/cdn/translations/id.js', '28.4', 0),
('641099462d3eb1fad9cbe90220a36d7e', './node_modules/@shoelace-style/shoelace/cdn/translations/it.js', '28.4', 0),
('84ca41ff44bfcce7da60621bed38b946', './node_modules/@shoelace-style/shoelace/cdn/translations/ja.js', '28.4', 0),
('ba035c908593e076f7ad4831d2eed89e', './node_modules/@shoelace-style/shoelace/cdn/translations/nl.js', '28.4', 0),
('20c2e2e352bb18552d194a368a64ca2e', './node_modules/@shoelace-style/shoelace/cdn/translations/pl.js', '28.4', 0),
('b7084433f5bbc1de76410560f3c77c69', './node_modules/@shoelace-style/shoelace/cdn/translations/pt.js', '28.4', 0),
('31922681ba37d9ec2de583ac3d4d3743', './node_modules/@shoelace-style/shoelace/cdn/translations/ru.js', '28.4', 0),
('cc23959c9f59c9312fde3d4aec0309df', './node_modules/@shoelace-style/shoelace/cdn/translations/sl.js', '28.4', 0),
('b27a4c9cb8dfe2be9229bd13c743ebcc', './node_modules/@shoelace-style/shoelace/cdn/translations/sv.js', '28.4', 0),
('0b09c173f7fd1666b3842b7d7ca4f9cb', './node_modules/@shoelace-style/shoelace/cdn/translations/tr.js', '28.4', 0),
('287095bc11fed547c4f2e406ea7209e9', './node_modules/@shoelace-style/shoelace/cdn/translations/zh-cn.js', '28.4', 0),
('f74695880349a4714a581f1cab161fd3', './node_modules/@shoelace-style/shoelace/cdn/translations/zh-tw.js', '28.4', 0),
('99fdf9922bf760298ff68418d006b240', './node_modules/@shoelace-style/shoelace/cdn/utilities/animation-registry.js', '28.4', 0),
('8b022bf08f1d7543ddc7b9cce8f22c5a', './node_modules/@shoelace-style/shoelace/cdn/utilities/animation.js', '28.4', 0),
('7716a23b6b1a9b5d2a049f03ec9a9cad', './node_modules/@shoelace-style/shoelace/cdn/utilities/base-path.js', '28.4', 0),
('02a732b4bc6c738bf02df1a28facae66', './node_modules/@shoelace-style/shoelace/cdn/utilities/form.js', '28.4', 0),
('431078cd9c047027606806c9b5995026', './node_modules/@shoelace-style/shoelace/cdn/utilities/icon-library.js', '28.4', 0),
('f1fd957098bb3acbd20d6ac967128a8b', './node_modules/@shoelace-style/shoelace/cdn/utilities/localize.js', '28.4', 0),
('978180a882be61f84586f060a57cbba4', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.26ABR7FJ.js', '28.4', 0),
('75ebbbc105d5d7e4d1d99280a9b7d36e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.26WLUFII.js', '28.4', 0),
('346b618eff29a3f00adc7ab8e578e50b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2D7NRCF6.js', '28.4', 0),
('561d1e5191b80e265fe405caad1cb529', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2EPZMCFM.js', '28.4', 0),
('345a8409202102ff623ff95c9b23de37', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2IHMH66B.js', '28.4', 0),
('6789075e544bdc63ee450e408b0670b0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2NJFRWZV.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('f057cc3306335fba6e9aab05429fbdaf', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2OUC42YY.js', '28.4', 0),
('57230b78d3591e18d1bb77782c9fc263', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2OYYFNVF.js', '28.4', 0),
('1c6e8923c4b491cb511e3fe61830cc68', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2P5EQCYK.js', '28.4', 0),
('228420a0844b360353d17dcecde1b62c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2QZJTKUU.js', '28.4', 0),
('edf401d7a24bd1b62b6d25ef66da04f4', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2RCF7SLU.js', '28.4', 0),
('d3e5fcf885eb3b727f976c1b55d55a87', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2SSSZ2JG.js', '28.4', 0),
('3499607a32900160da0ff376ddb39b76', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2UV3QQ3Z.js', '28.4', 0),
('de9ee69ae6b53962cda6564491d3983c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2W6X55FG.js', '28.4', 0),
('9cf4497b0fed48c571fffe7cce1d582a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.2X7YQ47E.js', '28.4', 0),
('aaf7c20da0c5c5ccf3a4fd239b8755bc', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.3EPZX5HE.js', '28.4', 0),
('d8ced2de46dcd141bcebfaf713b96c9a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.3KSWVBQ5.js', '28.4', 0),
('4a0c68cf9c5750d18258df0dcb2c5eba', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.3TFKS637.js', '28.4', 0),
('16fba05d98541d42ed56eeacdafca7b9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.3Y6SB6QS.js', '28.4', 0),
('b4dff453b747c13c92ac54ff8dc6267b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.43HE4RDY.js', '28.4', 0),
('1e0ac46fb7d187958578535c1159038c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.4K24TN3D.js', '28.4', 0),
('9ff8d7decbca4d3a3d47eb350bf2831b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.4L6M7RA3.js', '28.4', 0),
('d30b90c88a06dcee850e6a26856e5bc7', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.4PGE7FIQ.js', '28.4', 0),
('ecbbb9257c50c10837ca2a831f9bda7f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.4RFB4FGM.js', '28.4', 0),
('5e328daa2f43b58ba8ce13e2aea7943f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.4XPE2OEV.js', '28.4', 0),
('2779a703110fd3710ebc779cbf38d181', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.4ZML5342.js', '28.4', 0),
('95304e7c23ab559d24b32e4ff0a12122', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.54OW4TPT.js', '28.4', 0),
('ab4a284c1759a92f4ed7a0cbea09a152', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.5D6IT2SR.js', '28.4', 0),
('0f105272a81ed5c8246e61244bc9a2aa', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.5EJHXPFX.js', '28.4', 0),
('057072e16d8194f18600f1748e4e7bbe', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.5GFXOTU4.js', '28.4', 0),
('7962a3c6c1d07b82b3f682888efabc3e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.5TUMMRIS.js', '28.4', 0),
('96345c05138a5d9fd7bb94549cf3df3e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.5VKIB4HA.js', '28.4', 0),
('35fbe14d5e079f89bca3718d9aced24c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.5Z452ZXE.js', '28.4', 0),
('a2a88b9cb838cc75147ba21da2881e59', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.62HVOPEB.js', '28.4', 0),
('566077f25c10403cfa0dfbb6aa92c6d5', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.63RPPWZQ.js', '28.4', 0),
('b19a04677fab326a7845d6c5c977a7d5', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.673VS4IL.js', '28.4', 0),
('ac189aed18500b5d6c7780a8b413d704', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.6HLGYC3C.js', '28.4', 0),
('9986cfa697504cb9f2c24b072855608a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.6I2T3DLI.js', '28.4', 0),
('bd13059ac064ed0bba53940d794cce77', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.6SQQ7EJK.js', '28.4', 0),
('9a3fcfad71e02fe2a5a9780c4326e220', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.6TW7UPF7.js', '28.4', 0),
('6d25024631431c10ebdb2c3946519c82', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7AOY43JF.js', '28.4', 0),
('9e7357c957cc4fbba831414b60e15655', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7DBENTHN.js', '28.4', 0),
('3312b87704969e12c5e6a4e358f28b43', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7DDYEY2M.js', '28.4', 0),
('4e9263e88257bd7bb0aadae39360d9b8', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7DUCI5S4.js', '28.4', 0),
('de3a1d727899bd5bc39c68a129692c0f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7EHPR4EM.js', '28.4', 0),
('449e23bb6544099a7a4c805eba24df1c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7GIDNBNI.js', '28.4', 0),
('bc1d1f515b73aae949d12ea7567c82fd', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7NXEYAOV.js', '28.4', 0),
('647aaf635ae6653475daeecd8fc44401', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7RHQSQV2.js', '28.4', 0),
('8e91d1f250ef06dfd6f5a857aaa0caf8', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7SB6YEYV.js', '28.4', 0),
('e644a57fefe17d0464592e9ca6bf8f73', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.7SG6JGAK.js', '28.4', 0),
('ad7483262abaa6a3f0acfb7fbbf2c30d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.A3D57V3Q.js', '28.4', 0),
('a7b81ab29ccc876f227664177cb0cfea', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.A3MHDHAD.js', '28.4', 0),
('383728ce43885aa4b178ab26ff5cafd1', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.A5D6FTFY.js', '28.4', 0),
('ea179445f5d507e0bab0941c7387b6a1', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.A6ZK6XGV.js', '28.4', 0),
('c5db1b37b52afd0897cdd84e73f22836', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.A7Z7ME3W.js', '28.4', 0),
('aad5152340147378454c707ef5eaf0a5', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AD5LLSI4.js', '28.4', 0),
('5291fb190ab6c23d4948d890c36f029e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AR4XFGXQ.js', '28.4', 0),
('d2454adacf9cb6b4a04f11275d4025e5', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ATHLYU3K.js', '28.4', 0),
('4cdaf3b5eb1092ede352e3f5e6d560a2', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AW7FXAPZ.js', '28.4', 0),
('8452e8bb69f08212eeb36b6401fab2e6', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AWJNGRYB.js', '28.4', 0),
('cebef711bc5a3898fa4ce0de7b8c0f28', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AYP3HPB7.js', '28.4', 0),
('9436cefaffbfc7fa8fb422dd63468a61', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AZ343NTV.js', '28.4', 0),
('83a44c1446baa347b0be25577dcdb4d9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.AZCCO5SO.js', '28.4', 0),
('89b9a45a25cb2eda00ca6c153bfe2495', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.B3BW2AY6.js', '28.4', 0),
('6f93a858e8ffc0a4eee39582226fb267', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.B4BZKR24.js', '28.4', 0),
('b1b3d8049698f95565c13d39ce889801', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.B5CZ6R7F.js', '28.4', 0),
('ef3cbd1f56ef01148a6533f45c92c003', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.B63YXDJO.js', '28.4', 0),
('2b6de28d870070ccf39220a10523f5d9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.BMOWACWC.js', '28.4', 0),
('ed2c5e24697f3abc66f7718d93e951c3', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.BQSEJD7X.js', '28.4', 0),
('9477da66244e9e52b3b5ea84b225ac29', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.BRQKZQRB.js', '28.4', 0),
('61727d39c4f2c1ac2a469898eac2b7fc', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.BWVSW6TI.js', '28.4', 0),
('b9ef37a4172c576f53f0d610430e7caa', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.CCJUT23E.js', '28.4', 0),
('b5936ceeedf6651eab2c4645776fb6dd', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.CKUHGEST.js', '28.4', 0),
('ddbbe28cc0b91b3a83b139e5be104cf1', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.CX3DZWHK.js', '28.4', 0),
('2332e9870f060837db144c468c56f653', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.DQ4DJ4AJ.js', '28.4', 0),
('5f72e3ed9b3ca464fa47a9c33c25080b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.DYNLZ5C3.js', '28.4', 0),
('ac5185ae44c04a6699d1480075d23e3d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.DZGTLMEZ.js', '28.4', 0),
('71bde3e2491c2ffa99ebcde89b6a43bd', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.E3RRTAYH.js', '28.4', 0),
('243c0e404a9a867ae93ba57977163cf6', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.EENY2VWU.js', '28.4', 0),
('50d2bd78d2cc111f93e0c79ef4818430', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.EQKPBFYI.js', '28.4', 0),
('f3dcf3d3037413ddeea38fc22912942d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ESELY2US.js', '28.4', 0),
('13849dad6547d807e8c88f25bf0d1bad', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.EU44RQUN.js', '28.4', 0),
('369d2ada3a6527d0cd266504bb542825', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.F3F3MIHY.js', '28.4', 0),
('facf3b1a5513b8a17b9b928c1131949d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.F4VGSDIW.js', '28.4', 0),
('65cffe98e22e54b7eb922687a7cb5721', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.F5LR3FVB.js', '28.4', 0),
('eefe0f70bfafb5de7c97766a9f7cef7f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FCDE5GYF.js', '28.4', 0),
('a58929ea5c4d72501509a02483efddd8', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FDBT7M3N.js', '28.4', 0),
('f82a91a67ef01d2efbd86047fcdd4ec2', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FED7NAWF.js', '28.4', 0),
('fcc6fa451b985901a4d90d1492d899d0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FHWY33R3.js', '28.4', 0),
('2819496caa901531cba8efe1ffbd9ff9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FJIDEMRS.js', '28.4', 0),
('12457cc6ce1c2813b57e82a533dc75e7', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FKMWLPHV.js', '28.4', 0),
('9217a350fc6cda89f51bd8cd4cc29762', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FLA4LNZW.js', '28.4', 0),
('01e608881d1122068af604bd096a7744', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FW7UWQXB.js', '28.4', 0),
('a60ec9a25a7b4ebac349e4a05255fe79', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FWF23UW4.js', '28.4', 0),
('4012039811edb788c528bb20d852d859', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FXXKMG2P.js', '28.4', 0),
('b39afc39f0c36241f87b8f0bf2ecdc3e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.FY7IKLNL.js', '28.4', 0),
('2cf90a499186057d6623455b2cfe8b9e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.G3WC4V6A.js', '28.4', 0),
('f0a16edc8a5f46020d9b570f7f9aac2a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.G5RKA5HF.js', '28.4', 0),
('e88396caebf99a3ca733745ae6408401', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.G7B7WU5W.js', '28.4', 0),
('54a8e22bb7711e7208facad267037663', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.GGT72J62.js', '28.4', 0),
('abdc4c430e2c3fb9cdcafdf2d299d8c0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.GI7VDIWX.js', '28.4', 0),
('4f7da719c7ba0b3804c0dd08639f57e1', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.GXC456DW.js', '28.4', 0),
('626164d0bfa1bba32f2ba441e74b6da4', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.GYJCMK2T.js', '28.4', 0),
('d92f04fce773156761dd12343aaa5b2e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.H24ENZMO.js', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HAL7R4WT.js', '28.4', 0),
('76ab24a4c76d943728fe83d0f8afaad5', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HDK3IYCS.js', '28.4', 0),
('de98348519990275852f5bc190fddfd8', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HF7GESMZ.js', '28.4', 0),
('182c16a792ff85aa32f42f6ee96fddbf', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HLKVCAN5.js', '28.4', 0),
('d06554e5f0316ce81919cc08ee2a7312', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HLY7QLMF.js', '28.4', 0),
('72d3ca3f78af6d803ab3a6a664207017', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HSR44OUL.js', '28.4', 0),
('f69100b541283c6f7b8a2a2fcc4bae83', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HTQNKB5E.js', '28.4', 0),
('db27cfbe2cdfcbc8064b981cd18f1bff', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.HUZT5SAP.js', '28.4', 0),
('376e6b97a9ddab75c2544989ca067aee', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.IG7OT3W2.js', '28.4', 0),
('474e34490b10bdc28ca7352d14f5b980', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.IHZEMJ7S.js', '28.4', 0),
('7296fd3ec39931a87993a709902cb970', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.II44SQ5G.js', '28.4', 0),
('a17caf0f09f272d313011b6ac1b4d26f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.IN4HPCEW.js', '28.4', 0),
('3b18099b724aa4b670e59d8abb905a8e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ITPUUJXW.js', '28.4', 0),
('fe527e7776bd818d29ae0d9075f0e9a1', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.IXQOPD5K.js', '28.4', 0),
('29d182a86c32687b9f70a5a7ce1ed0c7', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.IYEYDJ32.js', '28.4', 0),
('4f76150ee1026d8c581244072b014811', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.IZD4DHXL.js', '28.4', 0),
('ece174443fc16f9b0478ecbdaaa95ab6', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.J5KWGFG6.js', '28.4', 0),
('7117a0ca20a2864364fd2528c4019027', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.J7PLVEQM.js', '28.4', 0),
('b427e81c201a407cb5298c40b0209bc9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.JAB53E3N.js', '28.4', 0),
('c2a055f1600fc212a25eec1d0ea0e197', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.JDKQULNC.js', '28.4', 0),
('73b07d0807c53577dbc69bfb102da801', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.JF3TLNOE.js', '28.4', 0),
('16b3079be60405a44af6bcf6503b3340', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.JO2JSTGY.js', '28.4', 0),
('202d746cc132b39d6af9e64140353965', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.JZFVFBCS.js', '28.4', 0),
('4ff2ef16033405f2ff2dc380b6392675', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.K25YHUPZ.js', '28.4', 0),
('b8efb2ab0fe1ba0961b2aa79ec0f7ffa', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.K35GSB4N.js', '28.4', 0),
('f557daa85c9f7f958bd3050d8030ee93', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KE4TH4B6.js', '28.4', 0),
('27176a1377e0b205ae883a83229eb727', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KFBI7EX7.js', '28.4', 0),
('396bf2d4b16f11e7870335158861e08a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KL7VVFYW.js', '28.4', 0),
('755116d73f89e7f810f17433c7d5a34c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KPCUOKRI.js', '28.4', 0),
('8abc48b1c752fae539f5c0d2f81a9da3', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KSOMZJI5.js', '28.4', 0),
('a3ff7928b663f2bfdd3f0ddb04c53644', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KWGNGLXL.js', '28.4', 0),
('b962893560732ab0a1e1c8092ef1794f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.KZJNDGFO.js', '28.4', 0),
('6f388237984c42b07d620eac39974137', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.LE3KWASX.js', '28.4', 0),
('546146658b50d3cb98c0bc7bb39a9a6e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.LGGG6BNX.js', '28.4', 0),
('2f7330803936b34015f89bff7736fd05', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.LLT7QVRR.js', '28.4', 0),
('f8578f958a7d730accc81104280026fc', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.LTFAMFUX.js', '28.4', 0),
('d4a7999703855c4b4b094d1450c15dbe', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.LXDTFLWU.js', '28.4', 0),
('bf0dc7ef6f7c4ec7152137ff1941f6cb', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.LXP7GVU3.js', '28.4', 0),
('5c951b407f5170c5ed0f3339473a5e03', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.M3A4TKTU.js', '28.4', 0),
('ad400c63eee65a62b3a06526f489145e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MAQXLKQ7.js', '28.4', 0),
('8cbb50cceed9dd0639fad3269e17c671', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MAS2SHYD.js', '28.4', 0),
('cf35b6fffdca6eda9e82dfd00d941b44', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MEDIBR6K.js', '28.4', 0),
('3223077f53173b412a506e486f61301e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MHTPNVIH.js', '28.4', 0),
('dbd9818c1309402d3113636663349ec2', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MOGERTD4.js', '28.4', 0),
('5f8a0a5e7dfb921517986335662cb63d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MQDN23HW.js', '28.4', 0),
('ec8a8b8e91c905399e35d722e654048f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MQVSSGFY.js', '28.4', 0),
('fa784efe60c48fd96e79a7bfb4fa8f6b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.MUXIBDFW.js', '28.4', 0),
('90df44cfe6473195db33ee5251bb8db6', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.N2LA23P5.js', '28.4', 0),
('e9a7604a148ed55fa317371fd30a1ac4', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.N3WQYTAI.js', '28.4', 0),
('ba4f274f131486515e324ba0fc0adfd3', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.N5H7JIU3.js', '28.4', 0),
('25b3e8a1e242e7c5c7b7d6d9286bc3c5', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NIVBGKZN.js', '28.4', 0),
('6d569331f3918869e5b8b0fb7ce5ea7b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NLWS5DN7.js', '28.4', 0),
('a84bab186b508bf3ed83a49eefdd6e0e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NQ44LUGM.js', '28.4', 0),
('37d76f83deba5f9a620551a02b1fb428', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NR5DNEXT.js', '28.4', 0),
('542a10601de31bbc2c5b4887ae76e975', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NRO3PLEA.js', '28.4', 0),
('cd5176ea95459347aa5e31412e20f8fd', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NWY7BPJD.js', '28.4', 0),
('6b66404a8c53ae0dbbbf5d9293d64d57', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NYIIDP5N.js', '28.4', 0),
('cc50698664374eefcfe8aae3b9ba20fb', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NYMJ5CJY.js', '28.4', 0),
('f505775c9c6e9a0abd4645df9f1ea454', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NZB7GSOD.js', '28.4', 0),
('f868590f691ddf6fa47d4089dd30b46d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NZL6FC7F.js', '28.4', 0),
('cad46e55afd1dcd934ef465098bd3f01', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.NZRVFO2E.js', '28.4', 0),
('dcebb8c43f25a06fcd33d8e0fdb42874', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.O6CEROC7.js', '28.4', 0),
('1a9c5e130e2080f36be267d61da5485d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.O7VCMB7W.js', '28.4', 0),
('c8ceba6dcad3b9e26dcfa69b51ed5872', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ODM3674Z.js', '28.4', 0),
('9d5f6fac73365ae5939d154aec457059', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.OEHLR4TU.js', '28.4', 0),
('f02abfe68c7cd8817b9e23268cd51f5f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.OJYFHDX5.js', '28.4', 0),
('8270ac1efcdd6a0ac1bd55c49e6d73e2', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.OPBM3XMX.js', '28.4', 0),
('cafd49e1a1c2cb7a58f422a34464a501', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ORTZCIID.js', '28.4', 0),
('2f5b43c13c3b762ad4284b6db5c4f4a8', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.P4NYDBZP.js', '28.4', 0),
('c2528640b66be8e01d3b428e297681b0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.P5GAID5I.js', '28.4', 0),
('f6d04be28e0a09667ebdc0141e6bc78d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.P6KA27FE.js', '28.4', 0),
('0002540226103cab7d21eaa7ba23f12b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.P6VP5MYG.js', '28.4', 0),
('f7d494c216bf8aab7344531c7e002dbc', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.P7ZG6EMR.js', '28.4', 0),
('81749f4c7d893350fac9748d8e3815ff', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PAKATWLP.js', '28.4', 0),
('e06b56e41ea485ce51a0cc68cdbced5c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PAKVOHWL.js', '28.4', 0),
('a266d42ed198c1ca99fac158a4f752e7', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PBK4BQNZ.js', '28.4', 0),
('4204c6ff6c230bb5191d32a9b1338608', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PDRQDHF3.js', '28.4', 0),
('145c18d2052c23edf43f5f99e8d444d0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PET5PMJP.js', '28.4', 0),
('80cc51d5b625e584456713d0acc92bd0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PIGCKFMH.js', '28.4', 0),
('15c744b0e0cbad9b6c337f1c676c2e1e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.PS5LPY3Z.js', '28.4', 0),
('4e9b8dbeb883d16d029227f23481c7c7', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.Q45FKJX7.js', '28.4', 0),
('ffa423e82bc16b5f376839397956b27d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.Q5P7Y2HU.js', '28.4', 0),
('343a809f3e4bfe9197f72a7310a43693', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QIF3P32T.js', '28.4', 0),
('deb1cc20565176928123519193691193', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QJ52M5AT.js', '28.4', 0),
('8f7c3419851262217943ee23c33366df', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QJHHXIAF.js', '28.4', 0),
('d41d8cd98f00b204e9800998ecf8427e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QL5C2XOW.js', '28.4', 0),
('455f5b17679e04010964e94471501956', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QLXRCYS4.js', '28.4', 0),
('6fa358e9b427cdbc1d2b03c2bca645e9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QOLCOLNK.js', '28.4', 0),
('cb1c1c1a785d763c29a27608d1c6061a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.QPGW3IHR.js', '28.4', 0),
('1150a44db35bed1331ab4971bc55ce0e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.R2T2D3TO.js', '28.4', 0),
('784110a385f91ba218d544233f46a210', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.R3NF57O3.js', '28.4', 0),
('e23736e2de078900188bc3b3d286303c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.RBPP5PLA.js', '28.4', 0),
('457fb7ad3dcb5ab79aa3d247c7dda5a1', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.RCGFCKTU.js', '28.4', 0),
('7ba6cb5897b5a41a87d4f145ad0dea54', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.RISKC4J7.js', '28.4', 0),
('8a5650955acc64ba85534fefd5b778d2', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.RW5OZQWQ.js', '28.4', 0),
('ac31ab9731f5d937736cd7a1f6d90896', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.RWUUFNUL.js', '28.4', 0),
('3ba1ce892149ce9b8332f054cd521f7d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.RX5SQU3O.js', '28.4', 0),
('8cb4bc2e14e60a2061dc277c8fdd66dc', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.S5ZGGRH2.js', '28.4', 0),
('a064b68389aab4a2d9acb4a14388d8e0', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.SI4ACBFK.js', '28.4', 0),
('45cfa4e2345ec27a019f7153501b6551', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.SSV56K2X.js', '28.4', 0),
('e1cf351ef9c69f1515cdf167e4265a4b', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.SUSCR7CI.js', '28.4', 0),
('3592ac936c84e94b4ba7221babf53d6f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.SXA6YTWG.js', '28.4', 0),
('4efa84b295f6c5b5328281c0900bae89', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.SXFLAUBY.js', '28.4', 0),
('e830e7dcd22c991c82db2e4b3f1ee39f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.TARPPPTW.js', '28.4', 0),
('27cf0ccacf1f02d32f3ac156372638fd', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.TGQYXVQF.js', '28.4', 0),
('9a733d6b40c7bb3b10a189bffa052b4d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.TJOP7HQP.js', '28.4', 0),
('a10dd10abc5a7375e4e2758969ddf3eb', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.TSI7S45B.js', '28.4', 0),
('6e1cbdbafb889d5890f236b700c5399f', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.TUVJKY7S.js', '28.4', 0),
('991088242f7658aa24bac2ff7c4ae3ba', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.UAYXD3AN.js', '28.4', 0),
('e478a8e2540b148091de2899cf46f582', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.UJ47T7HP.js', '28.4', 0),
('d10772ba8700f6315b9640b6b1573ee9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ULUDSN57.js', '28.4', 0),
('554450c19189b415fcc1a1a3d344d389', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.UROJTXOK.js', '28.4', 0),
('e8c0acb70070fcc793a198e8f507d188', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.UW6SLYOK.js', '28.4', 0),
('6144807bb7003fbf1c32995fe5f0611d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.UXWFRLXM.js', '28.4', 0),
('cdf85213061b1dba3e8515030fdabc9c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.V2OL7VMD.js', '28.4', 0),
('53fdbd23db9217b9a5267bce0ff6cddd', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VB6USWYN.js', '28.4', 0),
('674dac48d8c0a8cd6df0b2aa9d234520', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VEAFTEXE.js', '28.4', 0),
('5278ad6b857ddb27a1a15c3bb0066a82', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VJUDVBFI.js', '28.4', 0),
('7cc8912ca057fb95d9309f4fd30439e4', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VK3WEIKI.js', '28.4', 0),
('c5983b3ae3adc609c3f329efc1ab33bf', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VP77VWVR.js', '28.4', 0),
('dbc6f4038434696eeec393c8d0166a82', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VTOVMUNT.js', '28.4', 0),
('9bd65c217cc5d364770d1768b972289c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.VVA35HTY.js', '28.4', 0),
('9a7488f5c9589c7f8c541b9163365d35', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.W4FB35CZ.js', '28.4', 0),
('7088639aaeee6435133827d3691986b8', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.W77EBTPS.js', '28.4', 0),
('90a2e15b1181a4b1cedc89c348d34eba', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WDIGWRVN.js', '28.4', 0),
('45c002dcec049f2307cb1d959007cbdb', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WLV3FVBR.js', '28.4', 0),
('6c582716ecff804641d4a41833b13d14', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WOIQX2L2.js', '28.4', 0),
('4b3b49767d2d293de7d491a6b0294f31', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WQC6OWUE.js', '28.4', 0),
('2f8e7cd13c4ace6f2c86cfafb74a3f68', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WSSNCNLM.js', '28.4', 0),
('7d2926253a9e429361877c4f2915d45a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WXCDMT2G.js', '28.4', 0),
('d5a921bd0211c3e0bb7db4b11e18c156', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WY3QR2XD.js', '28.4', 0),
('35b590340b650ec00e82b9018d745ec6', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.WYJEPP7Q.js', '28.4', 0),
('a6828fe720714be800e8eb6c03339b62', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.X2WW2TWJ.js', '28.4', 0),
('e4d8a3df36603cf0a784e9806678356e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.X66VV6J2.js', '28.4', 0),
('6343f91f8760527ca0b335a842234856', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.X6FGERGY.js', '28.4', 0),
('5b26de08a3bad8b80531f00baf01b95d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XI7DQXDF.js', '28.4', 0),
('2c0728bc2f4edba7b9fad3814cfd5899', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XISPCK6C.js', '28.4', 0),
('0f875c7553265521f7486c9a443c5f9d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XJU7WU2G.js', '28.4', 0),
('9eb4e370b76a4f6732ad57c3f3552fbf', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XNEONNEJ.js', '28.4', 0),
('2b874955e97b0add2778f772b6fe6bd4', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XOSELTMG.js', '28.4', 0),
('52644be3c61bea5c7f97eb13eaee0a99', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XVVDUPMB.js', '28.4', 0),
('ce807bd93108be9d96cbd9d5a3c95788', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.XXGVZTPD.js', '28.4', 0),
('a3f9a5b66d166e61836d34983cd2ce51', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.Y3NFHAJQ.js', '28.4', 0),
('67223208001f77edf3932677f760b41e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.Y5V5SKWM.js', '28.4', 0),
('6d55877ca79055e42e80921f6e6dc437', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.Y6N3EYW6.js', '28.4', 0),
('019a1c1266407a8534d0dae60cfcb24e', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YHQWYJ2W.js', '28.4', 0),
('32b01db5bfd7b5286110a219dccba123', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YJK4WDCI.js', '28.4', 0),
('cfc5109c4668d7afce62d891578c4215', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YKKSQ2FG.js', '28.4', 0),
('b1e51ddb4235d4e00f8a8916c5abde3c', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YKUUDJCV.js', '28.4', 0),
('872eee3bbf5cb01934f9f176951517f9', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YR2VJIJ5.js', '28.4', 0),
('c8ca78383038bc2b8cce761249f46a8d', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YVBD742T.js', '28.4', 0),
('56f58914c554d12a22842ea603333ae2', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.YXGWYAZT.js', '28.4', 0),
('668e999dd33dc6c0cc7ac2f8bf01a74a', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ZHOD7CUD.js', '28.4', 0),
('9482cc3919021f278e2ec5a58a0ed541', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ZJHWJN3B.js', '28.4', 0),
('d332810ad1761eec0dc569b02863f309', './node_modules/@shoelace-style/shoelace/dist/chunks/chunk.ZL53POKZ.js', '28.4', 0),
('6b123a4b32986f717a6444cc16d16c0d', './node_modules/@shoelace-style/shoelace/dist/components/alert/alert.component.js', '28.4', 0),
('584e6bd0115f29b2059289491d2ec97d', './node_modules/@shoelace-style/shoelace/dist/components/alert/alert.js', '28.4', 0),
('0453e93e5b78614efab1d3b4792035cc', './node_modules/@shoelace-style/shoelace/dist/components/alert/alert.styles.js', '28.4', 0),
('f80be63205793456ae777410d0f0d140', './node_modules/@shoelace-style/shoelace/dist/components/animated-image/animated-image.component.js', '28.4', 0),
('f21ee792bbb32bcc99f7045b3f5eec3b', './node_modules/@shoelace-style/shoelace/dist/components/animated-image/animated-image.js', '28.4', 0),
('8005694a8f46431a4a47eafd78887fbf', './node_modules/@shoelace-style/shoelace/dist/components/animated-image/animated-image.styles.js', '28.4', 0),
('f94c4180ff09c3ec34046424f9242564', './node_modules/@shoelace-style/shoelace/dist/components/animation/animation.component.js', '28.4', 0),
('9674bb1a87469a37f5c2eccd9dc839dc', './node_modules/@shoelace-style/shoelace/dist/components/animation/animation.js', '28.4', 0),
('01119f9214cb05546a89ff15a2ca8c6c', './node_modules/@shoelace-style/shoelace/dist/components/animation/animation.styles.js', '28.4', 0),
('260fe2d6b214ff7f49081743bbdb4bdb', './node_modules/@shoelace-style/shoelace/dist/components/animation/animations.js', '28.4', 0),
('97a635c0e5742b09427da150ade92d97', './node_modules/@shoelace-style/shoelace/dist/components/avatar/avatar.component.js', '28.4', 0),
('aa7fbeda0207f52a237425e5290b8b60', './node_modules/@shoelace-style/shoelace/dist/components/avatar/avatar.js', '28.4', 0),
('19eaae6cc596f6684395f0d098e0b8fc', './node_modules/@shoelace-style/shoelace/dist/components/avatar/avatar.styles.js', '28.4', 0),
('806b7237e8f3d7f7c9131239e2e47a99', './node_modules/@shoelace-style/shoelace/dist/components/badge/badge.component.js', '28.4', 0),
('0641f870bc4824fa1ac3162868daddca', './node_modules/@shoelace-style/shoelace/dist/components/badge/badge.js', '28.4', 0),
('4bbd5c27448701406209d57563f5cd0b', './node_modules/@shoelace-style/shoelace/dist/components/badge/badge.styles.js', '28.4', 0),
('f8363c56d6ba66eebc037fb9d9be22e5', './node_modules/@shoelace-style/shoelace/dist/components/breadcrumb-item/breadcrumb-item.component.js', '28.4', 0),
('8bf2efbb90b4aa8262b7bc83caaebdbe', './node_modules/@shoelace-style/shoelace/dist/components/breadcrumb-item/breadcrumb-item.js', '28.4', 0),
('70f1ce4a663388153fb0bfea505cb3f5', './node_modules/@shoelace-style/shoelace/dist/components/breadcrumb-item/breadcrumb-item.styles.js', '28.4', 0),
('d4c0e8648117d649be983171e4e30645', './node_modules/@shoelace-style/shoelace/dist/components/breadcrumb/breadcrumb.component.js', '28.4', 0),
('9f0869ce338c8c5a8360f59054bce384', './node_modules/@shoelace-style/shoelace/dist/components/breadcrumb/breadcrumb.js', '28.4', 0),
('a05183841982d482854c6756f38f10dd', './node_modules/@shoelace-style/shoelace/dist/components/breadcrumb/breadcrumb.styles.js', '28.4', 0),
('088b440e36216fce253593287a82d93b', './node_modules/@shoelace-style/shoelace/dist/components/button-group/button-group.component.js', '28.4', 0),
('91402b0a7a334c2d24e350417574ae4e', './node_modules/@shoelace-style/shoelace/dist/components/button-group/button-group.js', '28.4', 0),
('b21f0625088715a2eaa831f062737ab7', './node_modules/@shoelace-style/shoelace/dist/components/button-group/button-group.styles.js', '28.4', 0),
('223ccf7f985a20a3c096f66591b70b93', './node_modules/@shoelace-style/shoelace/dist/components/button/button.component.js', '28.4', 0),
('4960cdcd39d4ec68bb3e173194dac8e6', './node_modules/@shoelace-style/shoelace/dist/components/button/button.js', '28.4', 0),
('94377802c7a1ee4a3ae04766034d1e15', './node_modules/@shoelace-style/shoelace/dist/components/button/button.styles.js', '28.4', 0),
('14a327f910e939972a629d1a362478f1', './node_modules/@shoelace-style/shoelace/dist/components/card/card.component.js', '28.4', 0),
('d6560ebc33568892b063fec34678ce23', './node_modules/@shoelace-style/shoelace/dist/components/card/card.js', '28.4', 0),
('16c829d9911f42d612ec93fea640b9fa', './node_modules/@shoelace-style/shoelace/dist/components/card/card.styles.js', '28.4', 0),
('d7482678a7e95a645a567e01f97cc351', './node_modules/@shoelace-style/shoelace/dist/components/carousel-item/carousel-item.component.js', '28.4', 0),
('03fbdbca1ef169f0fe89de5684984c57', './node_modules/@shoelace-style/shoelace/dist/components/carousel-item/carousel-item.js', '28.4', 0),
('7dd39493e9452583fdb717342558c94e', './node_modules/@shoelace-style/shoelace/dist/components/carousel-item/carousel-item.styles.js', '28.4', 0),
('4e6323855c8b33af89d13718d1ad8a6d', './node_modules/@shoelace-style/shoelace/dist/components/carousel/autoplay-controller.js', '28.4', 0),
('d5dba197a078f1d7f27a88a1c55e8d5c', './node_modules/@shoelace-style/shoelace/dist/components/carousel/carousel.component.js', '28.4', 0),
('b3b5487dedbd80d90e3367c7719d6333', './node_modules/@shoelace-style/shoelace/dist/components/carousel/carousel.js', '28.4', 0),
('5a9276a6880d3b0b5899dd04eddd68bc', './node_modules/@shoelace-style/shoelace/dist/components/carousel/carousel.styles.js', '28.4', 0),
('97955a6a9cd2ead3f2cda9dff2ccda25', './node_modules/@shoelace-style/shoelace/dist/components/checkbox/checkbox.component.js', '28.4', 0),
('2bad1618bfb40ee0182b3d4815f0e914', './node_modules/@shoelace-style/shoelace/dist/components/checkbox/checkbox.js', '28.4', 0),
('5b8249c64c6cc7b8b63d3b9a6fa27e15', './node_modules/@shoelace-style/shoelace/dist/components/checkbox/checkbox.styles.js', '28.4', 0),
('d421b2f52aabbf65ca107a0d749b3fa7', './node_modules/@shoelace-style/shoelace/dist/components/color-picker/color-picker.component.js', '28.4', 0),
('db88733a2e8ccc7023ff03fbbaccf1e8', './node_modules/@shoelace-style/shoelace/dist/components/color-picker/color-picker.js', '28.4', 0),
('ebdc4505c807eddb11f520c7810bed3f', './node_modules/@shoelace-style/shoelace/dist/components/color-picker/color-picker.styles.js', '28.4', 0),
('c1151c57a9d14a56d3a2be93a9480864', './node_modules/@shoelace-style/shoelace/dist/components/copy-button/copy-button.component.js', '28.4', 0),
('997d9ea57148be318a96625285561c21', './node_modules/@shoelace-style/shoelace/dist/components/copy-button/copy-button.js', '28.4', 0),
('c6c1595faaaaa648f8d3ffca9fbba00f', './node_modules/@shoelace-style/shoelace/dist/components/copy-button/copy-button.styles.js', '28.4', 0),
('ec49e0d44347e3b0398587829798ab86', './node_modules/@shoelace-style/shoelace/dist/components/details/details.component.js', '28.4', 0),
('5221858a97b056467ca21507ab005510', './node_modules/@shoelace-style/shoelace/dist/components/details/details.js', '28.4', 0),
('2b5c40167889f1c6ae082affb53a22c1', './node_modules/@shoelace-style/shoelace/dist/components/details/details.styles.js', '28.4', 0),
('f72fe46fda6459b18fcb1b36dd81e581', './node_modules/@shoelace-style/shoelace/dist/components/dialog/dialog.component.js', '28.4', 0),
('9c873e6ae55e5e19f19d609cd84aae48', './node_modules/@shoelace-style/shoelace/dist/components/dialog/dialog.js', '28.4', 0),
('d3a7e99935682240935da865190530ac', './node_modules/@shoelace-style/shoelace/dist/components/dialog/dialog.styles.js', '28.4', 0),
('7fdc46fa4ae2849c66404e9be99485ea', './node_modules/@shoelace-style/shoelace/dist/components/divider/divider.component.js', '28.4', 0),
('bbc8526752a5296e527e40dad0d19d31', './node_modules/@shoelace-style/shoelace/dist/components/divider/divider.js', '28.4', 0),
('60fd12ed83dd8a17323909e5e35ec206', './node_modules/@shoelace-style/shoelace/dist/components/divider/divider.styles.js', '28.4', 0),
('452929518db005833ca5ab6b4f9c27fa', './node_modules/@shoelace-style/shoelace/dist/components/drawer/drawer.component.js', '28.4', 0),
('270e01bb71deb25a2ac740d1f009fe3d', './node_modules/@shoelace-style/shoelace/dist/components/drawer/drawer.js', '28.4', 0),
('ebf91bb1105ba8cd0e599f8be75d57d4', './node_modules/@shoelace-style/shoelace/dist/components/drawer/drawer.styles.js', '28.4', 0),
('f716bcb17edf8dbe031ad0b2120a99e9', './node_modules/@shoelace-style/shoelace/dist/components/dropdown/dropdown.component.js', '28.4', 0),
('ee063c34b4719b4f396301f03c0157a2', './node_modules/@shoelace-style/shoelace/dist/components/dropdown/dropdown.js', '28.4', 0),
('1b0441a5936a91bbd05093e9d05632ee', './node_modules/@shoelace-style/shoelace/dist/components/dropdown/dropdown.styles.js', '28.4', 0),
('6e818493626afe7b0f739ae7a5d80177', './node_modules/@shoelace-style/shoelace/dist/components/format-bytes/format-bytes.component.js', '28.4', 0),
('d234b9c0315094d7e440a7957f165809', './node_modules/@shoelace-style/shoelace/dist/components/format-bytes/format-bytes.js', '28.4', 0),
('05160ee142114ac7a7b7b32f74fedf83', './node_modules/@shoelace-style/shoelace/dist/components/format-date/format-date.component.js', '28.4', 0),
('1751c5da9a9c57260177815cfaccc18a', './node_modules/@shoelace-style/shoelace/dist/components/format-date/format-date.js', '28.4', 0),
('7b05965f70880efb6f46034e2173a1ed', './node_modules/@shoelace-style/shoelace/dist/components/format-number/format-number.component.js', '28.4', 0),
('96e62e78d6ebc5c260acc8ce9db85725', './node_modules/@shoelace-style/shoelace/dist/components/format-number/format-number.js', '28.4', 0),
('51839a3c3daedc1b1bea361522c61dda', './node_modules/@shoelace-style/shoelace/dist/components/icon-button/icon-button.component.js', '28.4', 0),
('225a09bd60314fc213633ae91a573a71', './node_modules/@shoelace-style/shoelace/dist/components/icon-button/icon-button.js', '28.4', 0),
('e7595fef9dee12c0d10d42b47913c07c', './node_modules/@shoelace-style/shoelace/dist/components/icon-button/icon-button.styles.js', '28.4', 0),
('63321868d06cd81b03baf59f5b70ff59', './node_modules/@shoelace-style/shoelace/dist/components/icon/icon.component.js', '28.4', 0),
('1d39328ae8a274a86c42c9462908207b', './node_modules/@shoelace-style/shoelace/dist/components/icon/icon.js', '28.4', 0),
('187489afa6ae5e8c3a22120e35b87ca8', './node_modules/@shoelace-style/shoelace/dist/components/icon/icon.styles.js', '28.4', 0),
('fe374bc7523868f7053a6e398f50bbae', './node_modules/@shoelace-style/shoelace/dist/components/icon/library.default.js', '28.4', 0),
('4d5753750f97ba310adc50f47a3ccb92', './node_modules/@shoelace-style/shoelace/dist/components/icon/library.js', '28.4', 0),
('9660641d0626da2c597514cae9a62d9b', './node_modules/@shoelace-style/shoelace/dist/components/icon/library.system.js', '28.4', 0),
('9905668d5f92d95cabb5d1507da76f77', './node_modules/@shoelace-style/shoelace/dist/components/image-comparer/image-comparer.component.js', '28.4', 0),
('861d10c23a4ff62a7541767824d9c833', './node_modules/@shoelace-style/shoelace/dist/components/image-comparer/image-comparer.js', '28.4', 0),
('0c5278d39b103a5639766e8b270b75b8', './node_modules/@shoelace-style/shoelace/dist/components/image-comparer/image-comparer.styles.js', '28.4', 0),
('82eca27f3f41378afe7911751fffbb36', './node_modules/@shoelace-style/shoelace/dist/components/include/include.component.js', '28.4', 0),
('cdcc4023e3028efd5aa9a5f2e3df64a3', './node_modules/@shoelace-style/shoelace/dist/components/include/include.js', '28.4', 0),
('f0ba14e64f70bd1c8921dd5c3e9677bf', './node_modules/@shoelace-style/shoelace/dist/components/include/include.styles.js', '28.4', 0),
('314247248553e9fcf7fcc27ac68f801e', './node_modules/@shoelace-style/shoelace/dist/components/include/request.js', '28.4', 0),
('a87326d49198205df1c17bd122d8f3f4', './node_modules/@shoelace-style/shoelace/dist/components/input/input.component.js', '28.4', 0),
('6e1505cc2c040f578dd6becafbc63499', './node_modules/@shoelace-style/shoelace/dist/components/input/input.js', '28.4', 0),
('cd7c8800bc2daa2b1d6609cdb337140f', './node_modules/@shoelace-style/shoelace/dist/components/input/input.styles.js', '28.4', 0),
('e8d0fe2347556d0cd823760779eb1f95', './node_modules/@shoelace-style/shoelace/dist/components/menu-item/menu-item.component.js', '28.4', 0),
('39638d86e5eff3fe04a6caf3cfe6190e', './node_modules/@shoelace-style/shoelace/dist/components/menu-item/menu-item.js', '28.4', 0),
('0f66763e3119a48acde312d4a57d5d06', './node_modules/@shoelace-style/shoelace/dist/components/menu-item/menu-item.styles.js', '28.4', 0),
('79013a4965d5d6bb7174322322fbdb30', './node_modules/@shoelace-style/shoelace/dist/components/menu-item/submenu-controller.js', '28.4', 0),
('9b442b67bb6530be8f38b39bff4bc0af', './node_modules/@shoelace-style/shoelace/dist/components/menu-label/menu-label.component.js', '28.4', 0),
('dff3029be288a3feaa7f3084fb7fd224', './node_modules/@shoelace-style/shoelace/dist/components/menu-label/menu-label.js', '28.4', 0),
('32a0f67402ac60731c8994ca0b5bbec3', './node_modules/@shoelace-style/shoelace/dist/components/menu-label/menu-label.styles.js', '28.4', 0),
('f5de2854222e0da21bde9b71b33d6232', './node_modules/@shoelace-style/shoelace/dist/components/menu/menu.component.js', '28.4', 0),
('9ca3062c60cc47bc27e6b3e6445e00cd', './node_modules/@shoelace-style/shoelace/dist/components/menu/menu.js', '28.4', 0),
('e07d9bae87666c0ef2098d1142346e0d', './node_modules/@shoelace-style/shoelace/dist/components/menu/menu.styles.js', '28.4', 0),
('670e0fee0529d6230029f592be74491b', './node_modules/@shoelace-style/shoelace/dist/components/mutation-observer/mutation-observer.component.js', '28.4', 0),
('1aeab540654f74338899c74ba414e053', './node_modules/@shoelace-style/shoelace/dist/components/mutation-observer/mutation-observer.js', '28.4', 0),
('b7fdae7106c529b1478cb7292c9d9daa', './node_modules/@shoelace-style/shoelace/dist/components/mutation-observer/mutation-observer.styles.js', '28.4', 0),
('a2f6a21ec710c9761fe3ec026d2309d5', './node_modules/@shoelace-style/shoelace/dist/components/option/option.component.js', '28.4', 0),
('da34292bf72349f07ee11ce8f94fde9c', './node_modules/@shoelace-style/shoelace/dist/components/option/option.js', '28.4', 0),
('6453e45a7ca071a9acaafa7961f5246a', './node_modules/@shoelace-style/shoelace/dist/components/option/option.styles.js', '28.4', 0),
('9b40882ad7a1a3d8073f34c9d64686ac', './node_modules/@shoelace-style/shoelace/dist/components/popup/popup.component.js', '28.4', 0),
('e4bd45fc31dc78859c5184b71579830d', './node_modules/@shoelace-style/shoelace/dist/components/popup/popup.js', '28.4', 0),
('c932f490e67ffef139f04204bb0f3167', './node_modules/@shoelace-style/shoelace/dist/components/popup/popup.styles.js', '28.4', 0),
('fd50761208dac999f8b6e52dd28af2e4', './node_modules/@shoelace-style/shoelace/dist/components/progress-bar/progress-bar.component.js', '28.4', 0),
('35bac8693ef2a11db6f8a939f683966f', './node_modules/@shoelace-style/shoelace/dist/components/progress-bar/progress-bar.js', '28.4', 0),
('b9b8bf6e8ac776e1c3b359f4c3b65637', './node_modules/@shoelace-style/shoelace/dist/components/progress-bar/progress-bar.styles.js', '28.4', 0),
('3eec416d0df30243678e75a06b9f7dc9', './node_modules/@shoelace-style/shoelace/dist/components/progress-ring/progress-ring.component.js', '28.4', 0),
('3480c8f3c7f12b46a41767c75426a31e', './node_modules/@shoelace-style/shoelace/dist/components/progress-ring/progress-ring.js', '28.4', 0),
('952beb8ef693de835b794209d34f179a', './node_modules/@shoelace-style/shoelace/dist/components/progress-ring/progress-ring.styles.js', '28.4', 0),
('a4df57b5a6f0b8ba39d6358f40f9eade', './node_modules/@shoelace-style/shoelace/dist/components/qr-code/qr-code.component.js', '28.4', 0),
('9ae1c5180c41b669d19c02ec9d0a71b4', './node_modules/@shoelace-style/shoelace/dist/components/qr-code/qr-code.js', '28.4', 0),
('ac5f21de5aed3fc1f21afecc286c6e6b', './node_modules/@shoelace-style/shoelace/dist/components/qr-code/qr-code.styles.js', '28.4', 0),
('655ad83c69f9f3e5d5bfdf7dde2ff7f3', './node_modules/@shoelace-style/shoelace/dist/components/radio-button/radio-button.component.js', '28.4', 0),
('0e89cac18c62d8114cbbed8bcf3e2b58', './node_modules/@shoelace-style/shoelace/dist/components/radio-button/radio-button.js', '28.4', 0),
('988119099a5b086582bd27be1858200e', './node_modules/@shoelace-style/shoelace/dist/components/radio-button/radio-button.styles.js', '28.4', 0),
('da5cf016478c24f93949997ed76d8961', './node_modules/@shoelace-style/shoelace/dist/components/radio-group/radio-group.component.js', '28.4', 0),
('d374a482e43319935bdad1975ddaad6d', './node_modules/@shoelace-style/shoelace/dist/components/radio-group/radio-group.js', '28.4', 0),
('b57e6da44be778b07a57e1d4ca9910a2', './node_modules/@shoelace-style/shoelace/dist/components/radio-group/radio-group.styles.js', '28.4', 0),
('98f64b3575117eeff6ce188fcd053140', './node_modules/@shoelace-style/shoelace/dist/components/radio/radio.component.js', '28.4', 0),
('417aaebc19944e89201b773fc48ca1c7', './node_modules/@shoelace-style/shoelace/dist/components/radio/radio.js', '28.4', 0),
('84ff825d1f1197d1bdf75c24a2c8c507', './node_modules/@shoelace-style/shoelace/dist/components/radio/radio.styles.js', '28.4', 0),
('4f4162d743defd1f85a93663f4f3e88d', './node_modules/@shoelace-style/shoelace/dist/components/range/range.component.js', '28.4', 0),
('59f1a03fc8ee9056f8e12cd25d2568cd', './node_modules/@shoelace-style/shoelace/dist/components/range/range.js', '28.4', 0),
('bfaf241a1e358e392b0179f766efc141', './node_modules/@shoelace-style/shoelace/dist/components/range/range.styles.js', '28.4', 0),
('031c5a54389fae960f01b9eab5afae42', './node_modules/@shoelace-style/shoelace/dist/components/rating/rating.component.js', '28.4', 0),
('c989562939e569429990a9086226e3ac', './node_modules/@shoelace-style/shoelace/dist/components/rating/rating.js', '28.4', 0),
('efd0d269f1f47b70874190eae513b8ce', './node_modules/@shoelace-style/shoelace/dist/components/rating/rating.styles.js', '28.4', 0),
('92c0e6319e99e165492920a0e0ec654e', './node_modules/@shoelace-style/shoelace/dist/components/relative-time/relative-time.component.js', '28.4', 0),
('d1a1fcc92ce8ca4835d9aed44bc1bf53', './node_modules/@shoelace-style/shoelace/dist/components/relative-time/relative-time.js', '28.4', 0),
('29ae530c9f0b23274a678cbb7bc51832', './node_modules/@shoelace-style/shoelace/dist/components/resize-observer/resize-observer.component.js', '28.4', 0),
('20bed69b8a807ebe2c83fb4a2be87e84', './node_modules/@shoelace-style/shoelace/dist/components/resize-observer/resize-observer.js', '28.4', 0),
('32900ac16a8e921c9ae894af407cd8b1', './node_modules/@shoelace-style/shoelace/dist/components/resize-observer/resize-observer.styles.js', '28.4', 0),
('75e2428c4d49e9f56728593ebdd5749e', './node_modules/@shoelace-style/shoelace/dist/components/select/select.component.js', '28.4', 0),
('60e5f2d19585f6bf4849aa39606ed348', './node_modules/@shoelace-style/shoelace/dist/components/select/select.js', '28.4', 0),
('0b4197bf75f85b53ad91868d2cb55eeb', './node_modules/@shoelace-style/shoelace/dist/components/select/select.styles.js', '28.4', 0),
('7e9a5e795346ca034c69e619757f1a85', './node_modules/@shoelace-style/shoelace/dist/components/skeleton/skeleton.component.js', '28.4', 0),
('8336b68337ea7799c0c6966d534b1aaf', './node_modules/@shoelace-style/shoelace/dist/components/skeleton/skeleton.js', '28.4', 0),
('d43bfc6654fd922c5a56016ac593ec86', './node_modules/@shoelace-style/shoelace/dist/components/skeleton/skeleton.styles.js', '28.4', 0),
('3b7bd20f876ed469960f49fed26ec764', './node_modules/@shoelace-style/shoelace/dist/components/spinner/spinner.component.js', '28.4', 0),
('964e187da5e25a98ed5a23d832d83e88', './node_modules/@shoelace-style/shoelace/dist/components/spinner/spinner.js', '28.4', 0),
('8ab81f74d91c79ca7aa128918b5c175b', './node_modules/@shoelace-style/shoelace/dist/components/spinner/spinner.styles.js', '28.4', 0),
('2556c85eb6f6977863842d7d8ca7f662', './node_modules/@shoelace-style/shoelace/dist/components/split-panel/split-panel.component.js', '28.4', 0),
('afd743b6571875c5afa1b87b46f64094', './node_modules/@shoelace-style/shoelace/dist/components/split-panel/split-panel.js', '28.4', 0);
INSERT INTO `tiki_secdb` VALUES
('b4facf3db72c7c2c0fc2261efa3ce506', './node_modules/@shoelace-style/shoelace/dist/components/split-panel/split-panel.styles.js', '28.4', 0),
('d87496232793bb491fa2588c5a68aa1a', './node_modules/@shoelace-style/shoelace/dist/components/switch/switch.component.js', '28.4', 0),
('72d50f0ecba7d72da120a2fc277ef4cc', './node_modules/@shoelace-style/shoelace/dist/components/switch/switch.js', '28.4', 0),
('3adc30f70ee0c9f7063e0c59851462c7', './node_modules/@shoelace-style/shoelace/dist/components/switch/switch.styles.js', '28.4', 0),
('20f657dd18fd05f2da8372817c1cbe22', './node_modules/@shoelace-style/shoelace/dist/components/tab-group/tab-group.component.js', '28.4', 0),
('f70590d67707901ee65c19eef7bac4d4', './node_modules/@shoelace-style/shoelace/dist/components/tab-group/tab-group.js', '28.4', 0),
('a3a65cdcf54a14b237e5d63b33ab25b7', './node_modules/@shoelace-style/shoelace/dist/components/tab-group/tab-group.styles.js', '28.4', 0),
('74d1b42cf6f7edfe281b5025aef9d208', './node_modules/@shoelace-style/shoelace/dist/components/tab-panel/tab-panel.component.js', '28.4', 0),
('3db0918a12e9bdae5976879283d407fe', './node_modules/@shoelace-style/shoelace/dist/components/tab-panel/tab-panel.js', '28.4', 0),
('9fb5126deb9a0a9941ab5bd2e1e66e93', './node_modules/@shoelace-style/shoelace/dist/components/tab-panel/tab-panel.styles.js', '28.4', 0),
('c17a4952a7a82985292481672f1f9393', './node_modules/@shoelace-style/shoelace/dist/components/tab/tab.component.js', '28.4', 0),
('af4da57acee527510e152ef0384b17ec', './node_modules/@shoelace-style/shoelace/dist/components/tab/tab.js', '28.4', 0),
('425c3a15eee8008c98e9b4f81e2b8615', './node_modules/@shoelace-style/shoelace/dist/components/tab/tab.styles.js', '28.4', 0),
('0f0aef38be586da5753563f95ed0c2bc', './node_modules/@shoelace-style/shoelace/dist/components/tag/tag.component.js', '28.4', 0),
('0986d0e8fb83689e9d5714d55bbba677', './node_modules/@shoelace-style/shoelace/dist/components/tag/tag.js', '28.4', 0),
('79bcbec3611e778934cf79d343153ee6', './node_modules/@shoelace-style/shoelace/dist/components/tag/tag.styles.js', '28.4', 0),
('35887aaf13fb01dbb342d629bd74557c', './node_modules/@shoelace-style/shoelace/dist/components/textarea/textarea.component.js', '28.4', 0),
('34636465abb40f79e20303d336500000', './node_modules/@shoelace-style/shoelace/dist/components/textarea/textarea.js', '28.4', 0),
('7e23b99762363419ba61feffdd5c2d16', './node_modules/@shoelace-style/shoelace/dist/components/textarea