<?php
// ===================================================================================================
//                           _  __     _ _
//                          | |/ /__ _| | |_ _  _ _ _ __ _
//                          | ' </ _` | |  _| || | '_/ _` |
//                          |_|\_\__,_|_|\__|\_,_|_| \__,_|
//
// This file is part of the Kaltura Collaborative Media Suite which allows users
// to do with audio, video, and animation what Wiki platforms allow them to do with
// text.
//
// Copyright (C) 2006-2023  Kaltura Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// @ignore
// ===================================================================================================

/**
 * @namespace
 */
namespace Kaltura\Client;

/**
 * @package Kaltura
 * @subpackage Client
 */
class TypeMap
{
	private static $map = array(
		'KalturaApiExceptionArg' => 'Kaltura\Client\ApiExceptionArg',
		'KalturaListResponse' => 'Kaltura\Client\Type\ListResponse',
		'KalturaBaseRestriction' => 'Kaltura\Client\Type\BaseRestriction',
		'KalturaAccessControl' => 'Kaltura\Client\Type\AccessControl',
		'KalturaAccessControlAction' => 'Kaltura\Client\Type\AccessControlAction',
		'KalturaContextTypeHolder' => 'Kaltura\Client\Type\ContextTypeHolder',
		'KalturaAccessControlContextTypeHolder' => 'Kaltura\Client\Type\AccessControlContextTypeHolder',
		'KalturaAccessControlMessage' => 'Kaltura\Client\Type\AccessControlMessage',
		'KalturaRuleAction' => 'Kaltura\Client\Type\RuleAction',
		'KalturaCondition' => 'Kaltura\Client\Type\Condition',
		'KalturaRule' => 'Kaltura\Client\Type\Rule',
		'KalturaAccessControlProfile' => 'Kaltura\Client\Type\AccessControlProfile',
		'KalturaKeyValue' => 'Kaltura\Client\Type\KeyValue',
		'KalturaAccessControlScope' => 'Kaltura\Client\Type\AccessControlScope',
		'KalturaReportFilter' => 'Kaltura\Client\Type\ReportFilter',
		'KalturaAnalyticsFilter' => 'Kaltura\Client\Type\AnalyticsFilter',
		'KalturaCuePoint' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePoint',
		'KalturaAnnotation' => 'Kaltura\Client\Plugin\Annotation\Type\Annotation',
		'KalturaApiExceptionArg' => 'Kaltura\Client\Type\ApiExceptionArg',
		'KalturaAppToken' => 'Kaltura\Client\Type\AppToken',
		'KalturaAsset' => 'Kaltura\Client\Type\Asset',
		'KalturaAssetDistributionCondition' => 'Kaltura\Client\Plugin\ContentDistribution\Type\AssetDistributionCondition',
		'KalturaAssetDistributionRule' => 'Kaltura\Client\Plugin\ContentDistribution\Type\AssetDistributionRule',
		'KalturaString' => 'Kaltura\Client\Type\Str',
		'KalturaAssetParams' => 'Kaltura\Client\Type\AssetParams',
		'KalturaResource' => 'Kaltura\Client\Type\Resource',
		'KalturaContentResource' => 'Kaltura\Client\Type\ContentResource',
		'KalturaAssetParamsResourceContainer' => 'Kaltura\Client\Type\AssetParamsResourceContainer',
		'KalturaAssetServeOptions' => 'Kaltura\Client\Type\AssetServeOptions',
		'KalturaAttachmentAsset' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAsset',
		'KalturaAuditTrailInfo' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailInfo',
		'KalturaAuditTrail' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrail',
		'KalturaAuditTrailChangeItem' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailChangeItem',
		'KalturaAuthentication' => 'Kaltura\Client\Type\Authentication',
		'KalturaMultiLingualString' => 'Kaltura\Client\Type\MultiLingualString',
		'KalturaOperationAttributes' => 'Kaltura\Client\Type\OperationAttributes',
		'KalturaBaseEntry' => 'Kaltura\Client\Type\BaseEntry',
		'KalturaBaseEntryCloneOptionItem' => 'Kaltura\Client\Type\BaseEntryCloneOptionItem',
		'KalturaBaseInteractivity' => 'Kaltura\Client\Plugin\Interactivity\Type\BaseInteractivity',
		'KalturaBaseResponseProfile' => 'Kaltura\Client\Type\BaseResponseProfile',
		'KalturaBaseSyndicationFeed' => 'Kaltura\Client\Type\BaseSyndicationFeed',
		'KalturaBaseUser' => 'Kaltura\Client\Type\BaseUser',
		'KalturaBaseVendorCredit' => 'Kaltura\Client\Plugin\Reach\Type\BaseVendorCredit',
		'KalturaBasicFieldsDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\BasicFieldsDropFolder',
		'KalturaJobData' => 'Kaltura\Client\Type\JobData',
		'KalturaBatchHistoryData' => 'Kaltura\Client\Type\BatchHistoryData',
		'KalturaBatchJob' => 'Kaltura\Client\Type\BatchJob',
		'KalturaPlayerDeliveryType' => 'Kaltura\Client\Type\PlayerDeliveryType',
		'KalturaPlayerEmbedCodeType' => 'Kaltura\Client\Type\PlayerEmbedCodeType',
		'KalturaESearchLanguageItem' => 'Kaltura\Client\Type\ESearchLanguageItem',
		'KalturaRegexItem' => 'Kaltura\Client\Type\RegexItem',
		'KalturaPartner' => 'Kaltura\Client\Type\Partner',
		'KalturaBatchGetExclusiveNotificationJobsResponse' => 'Kaltura\Client\Type\BatchGetExclusiveNotificationJobsResponse',
		'KalturaBatchJobResponse' => 'Kaltura\Client\Type\BatchJobResponse',
		'KalturaBatchQueuesStatus' => 'Kaltura\Client\Type\BatchQueuesStatus',
		'KalturaBeacon' => 'Kaltura\Client\Plugin\Beacon\Type\Beacon',
		'KalturaESearchBaseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchBaseItem',
		'KalturaBeaconScheduledResourceBaseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\BeaconScheduledResourceBaseItem',
		'KalturaBeaconSearchOrderBy' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconSearchOrderBy',
		'KalturaBeaconSearchParams' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconSearchParams',
		'KalturaESearchOrderByItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchOrderByItem',
		'KalturaBeaconSearchScheduledResourceOrderByItem' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconSearchScheduledResourceOrderByItem',
		'KalturaBeaconSearchScheduledResourceOrderBy' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconSearchScheduledResourceOrderBy',
		'KalturaValue' => 'Kaltura\Client\Type\Value',
		'KalturaBooleanValue' => 'Kaltura\Client\Type\BooleanValue',
		'KalturaBulkServiceData' => 'Kaltura\Client\Plugin\BulkUpload\Type\BulkServiceData',
		'KalturaBulkUploadPluginData' => 'Kaltura\Client\Type\BulkUploadPluginData',
		'KalturaBulkUploadResult' => 'Kaltura\Client\Type\BulkUploadResult',
		'KalturaBulkUpload' => 'Kaltura\Client\Type\BulkUpload',
		'KalturaBulkUploadObjectData' => 'Kaltura\Client\Type\BulkUploadObjectData',
		'KalturaBusinessProcessCase' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessCase',
		'KalturaBusinessProcessServer' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessServer',
		'KalturaCEError' => 'Kaltura\Client\Type\CEError',
		'KalturaCaptionAsset' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAsset',
		'KalturaCaptionAssetItem' => 'Kaltura\Client\Plugin\CaptionSearch\Type\CaptionAssetItem',
		'KalturaCaptionParams' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParams',
		'KalturaCaptionPlaybackPluginData' => 'Kaltura\Client\Plugin\Caption\Type\CaptionPlaybackPluginData',
		'KalturaCaptureSpaceUpdateResponseInfoHash' => 'Kaltura\Client\Plugin\CaptureSpace\Type\CaptureSpaceUpdateResponseInfoHash',
		'KalturaCaptureSpaceUpdateResponseInfo' => 'Kaltura\Client\Plugin\CaptureSpace\Type\CaptureSpaceUpdateResponseInfo',
		'KalturaCaptureSpaceUpdateResponse' => 'Kaltura\Client\Plugin\CaptureSpace\Type\CaptureSpaceUpdateResponse',
		'KalturaCategory' => 'Kaltura\Client\Type\Category',
		'KalturaCategoryEntry' => 'Kaltura\Client\Type\CategoryEntry',
		'KalturaCategoryUser' => 'Kaltura\Client\Type\CategoryUser',
		'KalturaClientConfiguration' => 'Kaltura\Client\Type\ClientConfiguration',
		'KalturaClientNotification' => 'Kaltura\Client\Type\ClientNotification',
		'KalturaClipDescription' => 'Kaltura\Client\Type\ClipDescription',
		'KalturaConfMaps' => 'Kaltura\Client\Plugin\ConfMaps\Type\ConfMaps',
		'KalturaContext' => 'Kaltura\Client\Type\Context',
		'KalturaContextDataResult' => 'Kaltura\Client\Type\ContextDataResult',
		'KalturaControlPanelCommand' => 'Kaltura\Client\Type\ControlPanelCommand',
		'KalturaConversionAttribute' => 'Kaltura\Client\Type\ConversionAttribute',
		'KalturaCropDimensions' => 'Kaltura\Client\Type\CropDimensions',
		'KalturaPluginReplacementOptionsItem' => 'Kaltura\Client\Type\PluginReplacementOptionsItem',
		'KalturaEntryReplacementOptions' => 'Kaltura\Client\Type\EntryReplacementOptions',
		'KalturaConversionProfile' => 'Kaltura\Client\Type\ConversionProfile',
		'KalturaConversionProfileAssetParams' => 'Kaltura\Client\Type\ConversionProfileAssetParams',
		'KalturaConvertCollectionFlavorData' => 'Kaltura\Client\Type\ConvertCollectionFlavorData',
		'KalturaCoordinate' => 'Kaltura\Client\Type\Coordinate',
		'KalturaCsvAdditionalFieldInfo' => 'Kaltura\Client\Type\CsvAdditionalFieldInfo',
		'KalturaDailymotionDistributionCaptionInfo' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionCaptionInfo',
		'KalturaDataEntry' => 'Kaltura\Client\Type\DataEntry',
		'KalturaUrlRecognizer' => 'Kaltura\Client\Type\UrlRecognizer',
		'KalturaUrlTokenizer' => 'Kaltura\Client\Type\UrlTokenizer',
		'KalturaSearchItem' => 'Kaltura\Client\Type\SearchItem',
		'KalturaFilter' => 'Kaltura\Client\Type\Filter',
		'KalturaRelatedFilter' => 'Kaltura\Client\Type\RelatedFilter',
		'KalturaAssetBaseFilter' => 'Kaltura\Client\Type\AssetBaseFilter',
		'KalturaAssetFilter' => 'Kaltura\Client\Type\AssetFilter',
		'KalturaDeliveryProfile' => 'Kaltura\Client\Type\DeliveryProfile',
		'KalturaFileSyncDescriptor' => 'Kaltura\Client\Type\FileSyncDescriptor',
		'KalturaDestFileSyncDescriptor' => 'Kaltura\Client\Type\DestFileSyncDescriptor',
		'KalturaPager' => 'Kaltura\Client\Type\Pager',
		'KalturaFilterPager' => 'Kaltura\Client\Type\FilterPager',
		'KalturaResponseProfileMapping' => 'Kaltura\Client\Type\ResponseProfileMapping',
		'KalturaDetachedResponseProfile' => 'Kaltura\Client\Type\DetachedResponseProfile',
		'KalturaDictionary' => 'Kaltura\Client\Plugin\Reach\Type\Dictionary',
		'KalturaDistributionFieldConfig' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionFieldConfig',
		'KalturaDistributionJobProviderData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionJobProviderData',
		'KalturaDistributionThumbDimensions' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionThumbDimensions',
		'KalturaDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfile',
		'KalturaDistributionProvider' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProvider',
		'KalturaDistributionRemoteMediaFile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionRemoteMediaFile',
		'KalturaDistributionValidationError' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationError',
		'KalturaDocumentEntry' => 'Kaltura\Client\Plugin\Document\Type\DocumentEntry',
		'KalturaDrmLicenseAccessDetails' => 'Kaltura\Client\Plugin\Drm\Type\DrmLicenseAccessDetails',
		'KalturaPluginData' => 'Kaltura\Client\Type\PluginData',
		'KalturaDrmPlaybackPluginData' => 'Kaltura\Client\Type\DrmPlaybackPluginData',
		'KalturaDrmPolicy' => 'Kaltura\Client\Plugin\Drm\Type\DrmPolicy',
		'KalturaDrmProfile' => 'Kaltura\Client\Plugin\Drm\Type\DrmProfile',
		'KalturaDropFolderFileHandlerConfig' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileHandlerConfig',
		'KalturaDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolder',
		'KalturaDropFolderFile' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFile',
		'KalturaDynamicEmailContents' => 'Kaltura\Client\Type\DynamicEmailContents',
		'KalturaESearchAggregationItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAggregationItem',
		'KalturaESearchAggregation' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAggregation',
		'KalturaESearchAggregationBucket' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAggregationBucket',
		'KalturaESearchAggregationResponse' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAggregationResponse',
		'KalturaESearchAggregationResponseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAggregationResponseItem',
		'KalturaESearchBaseFilter' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchBaseFilter',
		'KalturaESearchCategoryBaseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryBaseItem',
		'KalturaESearchHighlight' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchHighlight',
		'KalturaESearchItemData' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchItemData',
		'KalturaESearchItemDataResult' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchItemDataResult',
		'KalturaESearchResult' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchResult',
		'KalturaESearchCategoryResult' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryResult',
		'KalturaESearchEntryBaseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryBaseItem',
		'KalturaESearchEntryBaseNestedObject' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryBaseNestedObject',
		'KalturaESearchEntryNestedBaseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryNestedBaseItem',
		'KalturaESearchEntryResult' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryResult',
		'KalturaESearchGroupBaseItem' => 'Kaltura\Client\Plugin\Group\Type\ESearchGroupBaseItem',
		'KalturaGroup' => 'Kaltura\Client\Plugin\Group\Type\Group',
		'KalturaESearchGroupResult' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchGroupResult',
		'KalturaESearchHistory' => 'Kaltura\Client\Plugin\SearchHistory\Type\ESearchHistory',
		'KalturaESearchOrderBy' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchOrderBy',
		'KalturaESearchParams' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchParams',
		'KalturaESearchRange' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchRange',
		'KalturaESearchResponse' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchResponse',
		'KalturaESearchUserBaseItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserBaseItem',
		'KalturaUser' => 'Kaltura\Client\Type\User',
		'KalturaESearchUserResult' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserResult',
		'KalturaEffect' => 'Kaltura\Client\Type\Effect',
		'KalturaEmailIngestionProfile' => 'Kaltura\Client\Type\EmailIngestionProfile',
		'KalturaStringValue' => 'Kaltura\Client\Type\StringValue',
		'KalturaEmailNotificationRecipient' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationRecipient',
		'KalturaEmailNotificationRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationRecipientJobData',
		'KalturaEmailNotificationRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationRecipientProvider',
		'KalturaEntryDistribution' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistribution',
		'KalturaEntryServerNode' => 'Kaltura\Client\Type\EntryServerNode',
		'KalturaVendorTaskData' => 'Kaltura\Client\Plugin\Reach\Type\VendorTaskData',
		'KalturaEntryVendorTask' => 'Kaltura\Client\Plugin\Reach\Type\EntryVendorTask',
		'KalturaEventCondition' => 'Kaltura\Client\Plugin\EventNotification\Type\EventCondition',
		'KalturaEventNotificationParameter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationParameter',
		'KalturaEventNotificationTemplate' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplate',
		'KalturaExclusiveLockKey' => 'Kaltura\Client\Type\ExclusiveLockKey',
		'KalturaExportToCsvOptions' => 'Kaltura\Client\Type\ExportToCsvOptions',
		'KalturaObjectIdentifier' => 'Kaltura\Client\Type\ObjectIdentifier',
		'KalturaExtendingItemMrssParameter' => 'Kaltura\Client\Type\ExtendingItemMrssParameter',
		'KalturaPlayableEntry' => 'Kaltura\Client\Type\PlayableEntry',
		'KalturaStreamContainer' => 'Kaltura\Client\Type\StreamContainer',
		'KalturaMediaEntry' => 'Kaltura\Client\Type\MediaEntry',
		'KalturaExternalMediaEntry' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntry',
		'KalturaFacebookCaptionDistributionInfo' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookCaptionDistributionInfo',
		'KalturaFeatureStatus' => 'Kaltura\Client\Type\FeatureStatus',
		'KalturaFeedItemInfo' => 'Kaltura\Client\Plugin\FeedDropFolder\Type\FeedItemInfo',
		'KalturaFileAsset' => 'Kaltura\Client\Type\FileAsset',
		'KalturaFileContainer' => 'Kaltura\Client\Type\FileContainer',
		'KalturaFileExistsResponse' => 'Kaltura\Client\Type\FileExistsResponse',
		'KalturaFileSync' => 'Kaltura\Client\Plugin\FileSync\Type\FileSync',
		'KalturaFlavorAsset' => 'Kaltura\Client\Type\FlavorAsset',
		'KalturaFlavorAssetUrlOptions' => 'Kaltura\Client\Type\FlavorAssetUrlOptions',
		'KalturaFlavorParams' => 'Kaltura\Client\Type\FlavorParams',
		'KalturaFlavorAssetWithParams' => 'Kaltura\Client\Type\FlavorAssetWithParams',
		'KalturaFlavorParamsOutput' => 'Kaltura\Client\Type\FlavorParamsOutput',
		'KalturaFreeJobResponse' => 'Kaltura\Client\Type\FreeJobResponse',
		'KalturaFreewheelDistributionAssetPath' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionAssetPath',
		'KalturaFtpDistributionFile' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionFile',
		'KalturaSchedulerStatus' => 'Kaltura\Client\Type\SchedulerStatus',
		'KalturaSchedulerConfig' => 'Kaltura\Client\Type\SchedulerConfig',
		'KalturaSchedulerWorker' => 'Kaltura\Client\Type\SchedulerWorker',
		'KalturaScheduler' => 'Kaltura\Client\Type\Scheduler',
		'KalturaFullStatusResponse' => 'Kaltura\Client\Type\FullStatusResponse',
		'KalturaGenericDistributionProfileAction' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfileAction',
		'KalturaGenericDistributionProviderAction' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderAction',
		'KalturaGenericDistributionProvider' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProvider',
		'KalturaGroupUser' => 'Kaltura\Client\Type\GroupUser',
		'KalturaObject' => 'Kaltura\Client\Type\Object',
		'KalturaHttpNotification' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotification',
		'KalturaHttpNotificationData' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationData',
		'KalturaIntegerValue' => 'Kaltura\Client\Type\IntegerValue',
		'KalturaIntegrationJobProviderData' => 'Kaltura\Client\Plugin\Integration\Type\IntegrationJobProviderData',
		'KalturaIntegrationJobTriggerData' => 'Kaltura\Client\Plugin\Integration\Type\IntegrationJobTriggerData',
		'KalturaIntegrationSetting' => 'Kaltura\Client\Plugin\Vendor\Type\IntegrationSetting',
		'KalturaInteractivityDataFieldsFilter' => 'Kaltura\Client\Plugin\Interactivity\Type\InteractivityDataFieldsFilter',
		'KalturaInteractivityRootFilter' => 'Kaltura\Client\Plugin\Interactivity\Type\InteractivityRootFilter',
		'KalturaInteractivityNodeFilter' => 'Kaltura\Client\Plugin\Interactivity\Type\InteractivityNodeFilter',
		'KalturaInteractivityInteractionFilter' => 'Kaltura\Client\Plugin\Interactivity\Type\InteractivityInteractionFilter',
		'KalturaInteractivityDataFilter' => 'Kaltura\Client\Plugin\Interactivity\Type\InteractivityDataFilter',
		'KalturaInternalToolsSession' => 'Kaltura\Client\Plugin\KalturaInternalTools\Type\InternalToolsSession',
		'KalturaFileSyncListResponse' => 'Kaltura\Client\Plugin\FileSync\Type\FileSyncListResponse',
		'KalturaBatchJobListResponse' => 'Kaltura\Client\Type\BatchJobListResponse',
		'KalturaMediaInfo' => 'Kaltura\Client\Type\MediaInfo',
		'KalturaMediaInfoListResponse' => 'Kaltura\Client\Type\MediaInfoListResponse',
		'KalturaFlavorParamsOutputListResponse' => 'Kaltura\Client\Type\FlavorParamsOutputListResponse',
		'KalturaInvestigateFlavorAssetData' => 'Kaltura\Client\Plugin\AdminConsole\Type\InvestigateFlavorAssetData',
		'KalturaThumbAsset' => 'Kaltura\Client\Type\ThumbAsset',
		'KalturaThumbParams' => 'Kaltura\Client\Type\ThumbParams',
		'KalturaThumbParamsOutput' => 'Kaltura\Client\Type\ThumbParamsOutput',
		'KalturaThumbParamsOutputListResponse' => 'Kaltura\Client\Type\ThumbParamsOutputListResponse',
		'KalturaInvestigateThumbAssetData' => 'Kaltura\Client\Plugin\AdminConsole\Type\InvestigateThumbAssetData',
		'KalturaTrackEntry' => 'Kaltura\Client\Plugin\AdminConsole\Type\TrackEntry',
		'KalturaInvestigateEntryData' => 'Kaltura\Client\Plugin\AdminConsole\Type\InvestigateEntryData',
		'KalturaKeyBooleanValue' => 'Kaltura\Client\Type\KeyBooleanValue',
		'KalturaLike' => 'Kaltura\Client\Plugin\Like\Type\Like',
		'KalturaLinkedScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\LinkedScheduleEvent',
		'KalturaLiveStreamConfiguration' => 'Kaltura\Client\Type\LiveStreamConfiguration',
		'KalturaLiveStreamPushPublishConfiguration' => 'Kaltura\Client\Type\LiveStreamPushPublishConfiguration',
		'KalturaLiveEntryRecordingOptions' => 'Kaltura\Client\Type\LiveEntryRecordingOptions',
		'KalturaLiveEntry' => 'Kaltura\Client\Type\LiveEntry',
		'KalturaLiveChannel' => 'Kaltura\Client\Type\LiveChannel',
		'KalturaLiveChannelSegment' => 'Kaltura\Client\Type\LiveChannelSegment',
		'KalturaLiveEntryServerNodeRecordingInfo' => 'Kaltura\Client\Type\LiveEntryServerNodeRecordingInfo',
		'KalturaLiveFeature' => 'Kaltura\Client\Plugin\Schedule\Type\LiveFeature',
		'KalturaLiveReportExportParams' => 'Kaltura\Client\Type\LiveReportExportParams',
		'KalturaLiveReportExportResponse' => 'Kaltura\Client\Type\LiveReportExportResponse',
		'KalturaLiveReportInputFilter' => 'Kaltura\Client\Type\LiveReportInputFilter',
		'KalturaLiveStats' => 'Kaltura\Client\Type\LiveStats',
		'KalturaLiveStatsEvent' => 'Kaltura\Client\Type\LiveStatsEvent',
		'KalturaLiveStreamBitrate' => 'Kaltura\Client\Type\LiveStreamBitrate',
		'KalturaLiveStreamDetails' => 'Kaltura\Client\Type\LiveStreamDetails',
		'KalturaLiveStreamEntry' => 'Kaltura\Client\Type\LiveStreamEntry',
		'KalturaLiveStreamParams' => 'Kaltura\Client\Type\LiveStreamParams',
		'KalturaLockFileSyncsResponse' => 'Kaltura\Client\Type\LockFileSyncsResponse',
		'KalturaBaseEntryBaseFilter' => 'Kaltura\Client\Type\BaseEntryBaseFilter',
		'KalturaBaseEntryFilter' => 'Kaltura\Client\Type\BaseEntryFilter',
		'KalturaPlayableEntryBaseFilter' => 'Kaltura\Client\Type\PlayableEntryBaseFilter',
		'KalturaPlayableEntryFilter' => 'Kaltura\Client\Type\PlayableEntryFilter',
		'KalturaMediaEntryBaseFilter' => 'Kaltura\Client\Type\MediaEntryBaseFilter',
		'KalturaMediaEntryFilter' => 'Kaltura\Client\Type\MediaEntryFilter',
		'KalturaMediaEntryFilterForPlaylist' => 'Kaltura\Client\Type\MediaEntryFilterForPlaylist',
		'KalturaMediaServerStatus' => 'Kaltura\Client\Type\MediaServerStatus',
		'KalturaMetadata' => 'Kaltura\Client\Plugin\Metadata\Type\Metadata',
		'KalturaMetadataProfile' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfile',
		'KalturaMetadataProfileField' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileField',
		'KalturaMixEntry' => 'Kaltura\Client\Type\MixEntry',
		'KalturaModerationFlag' => 'Kaltura\Client\Type\ModerationFlag',
		'KalturaObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ObjectTask',
		'KalturaOptionalAnswer' => 'Kaltura\Client\Plugin\Quiz\Type\OptionalAnswer',
		'KalturaPartnerPublicInfo' => 'Kaltura\Client\Type\PartnerPublicInfo',
		'KalturaPartnerStatistics' => 'Kaltura\Client\Type\PartnerStatistics',
		'KalturaPartnerUsage' => 'Kaltura\Client\Type\PartnerUsage',
		'KalturaPermission' => 'Kaltura\Client\Type\Permission',
		'KalturaPermissionItem' => 'Kaltura\Client\Type\PermissionItem',
		'KalturaPlayReadyAnalogVideoOPIdHolder' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyAnalogVideoOPIdHolder',
		'KalturaPlayReadyContentKey' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyContentKey',
		'KalturaPlayReadyCopyEnablerHolder' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyCopyEnablerHolder',
		'KalturaPlayReadyDigitalAudioOPIdHolder' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyDigitalAudioOPIdHolder',
		'KalturaPlayReadyRight' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyRight',
		'KalturaPlayReadyPolicy' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyPolicy',
		'KalturaPlayReadyLicenseDetails' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyLicenseDetails',
		'KalturaPlayReadyPlayEnablerHolder' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyPlayEnablerHolder',
		'KalturaPlaybackSource' => 'Kaltura\Client\Type\PlaybackSource',
		'KalturaPlaybackContext' => 'Kaltura\Client\Type\PlaybackContext',
		'KalturaPlaylist' => 'Kaltura\Client\Type\Playlist',
		'KalturaPushEventNotificationParameter' => 'Kaltura\Client\Plugin\PushNotification\Type\PushEventNotificationParameter',
		'KalturaPushNotificationData' => 'Kaltura\Client\Plugin\PushNotification\Type\PushNotificationData',
		'KalturaPushNotificationParams' => 'Kaltura\Client\Plugin\PushNotification\Type\PushNotificationParams',
		'KalturaQuiz' => 'Kaltura\Client\Plugin\Quiz\Type\Quiz',
		'KalturaRatingCount' => 'Kaltura\Client\Plugin\Rating\Type\RatingCount',
		'KalturaReachProfile' => 'Kaltura\Client\Plugin\Reach\Type\ReachProfile',
		'KalturaRemotePath' => 'Kaltura\Client\Type\RemotePath',
		'KalturaUrlResource' => 'Kaltura\Client\Type\UrlResource',
		'KalturaRemoteStorageResource' => 'Kaltura\Client\Type\RemoteStorageResource',
		'KalturaReport' => 'Kaltura\Client\Type\Report',
		'KalturaReportBaseTotal' => 'Kaltura\Client\Type\ReportBaseTotal',
		'KalturaReportExportFile' => 'Kaltura\Client\Type\ReportExportFile',
		'KalturaReportInputBaseFilter' => 'Kaltura\Client\Type\ReportInputBaseFilter',
		'KalturaESearchEntryOperator' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryOperator',
		'KalturaReportInputFilter' => 'Kaltura\Client\Type\ReportInputFilter',
		'KalturaReportResponseOptions' => 'Kaltura\Client\Type\ReportResponseOptions',
		'KalturaReportExportItem' => 'Kaltura\Client\Type\ReportExportItem',
		'KalturaReportExportParams' => 'Kaltura\Client\Type\ReportExportParams',
		'KalturaReportExportResponse' => 'Kaltura\Client\Type\ReportExportResponse',
		'KalturaReportGraph' => 'Kaltura\Client\Type\ReportGraph',
		'KalturaReportResponse' => 'Kaltura\Client\Type\ReportResponse',
		'KalturaReportTable' => 'Kaltura\Client\Type\ReportTable',
		'KalturaReportTotal' => 'Kaltura\Client\Type\ReportTotal',
		'KalturaRequestConfiguration' => 'Kaltura\Client\Type\RequestConfiguration',
		'KalturaResponseProfile' => 'Kaltura\Client\Type\ResponseProfile',
		'KalturaResponseProfileCacheRecalculateOptions' => 'Kaltura\Client\Type\ResponseProfileCacheRecalculateOptions',
		'KalturaResponseProfileCacheRecalculateResults' => 'Kaltura\Client\Type\ResponseProfileCacheRecalculateResults',
		'KalturaRoomDetails' => 'Kaltura\Client\Plugin\Conference\Type\RoomDetails',
		'KalturaScheduleEventRecurrence' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventRecurrence',
		'KalturaScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEvent',
		'KalturaScheduleEventResource' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResource',
		'KalturaScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResource',
		'KalturaScheduledTaskProfile' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfile',
		'KalturaSchedulerStatusResponse' => 'Kaltura\Client\Type\SchedulerStatusResponse',
		'KalturaScope' => 'Kaltura\Client\Type\Scope',
		'KalturaSearch' => 'Kaltura\Client\Type\Search',
		'KalturaSearchAuthData' => 'Kaltura\Client\Type\SearchAuthData',
		'KalturaSearchResult' => 'Kaltura\Client\Type\SearchResult',
		'KalturaSearchResultResponse' => 'Kaltura\Client\Type\SearchResultResponse',
		'KalturaServerNode' => 'Kaltura\Client\Type\ServerNode',
		'KalturaSessionInfo' => 'Kaltura\Client\Type\SessionInfo',
		'KalturaShortLink' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLink',
		'KalturaSipResponse' => 'Kaltura\Client\Plugin\Sip\Type\SipResponse',
		'KalturaSourceFileSyncDescriptor' => 'Kaltura\Client\Type\SourceFileSyncDescriptor',
		'KalturaSso' => 'Kaltura\Client\Plugin\Sso\Type\Sso',
		'KalturaStartWidgetSessionResponse' => 'Kaltura\Client\Type\StartWidgetSessionResponse',
		'KalturaStatsEvent' => 'Kaltura\Client\Type\StatsEvent',
		'KalturaStatsKmcEvent' => 'Kaltura\Client\Type\StatsKmcEvent',
		'KalturaStorageProfile' => 'Kaltura\Client\Type\StorageProfile',
		'KalturaSupportedSubTypes' => 'Kaltura\Client\Type\SupportedSubTypes',
		'KalturaSyndicationFeedEntryCount' => 'Kaltura\Client\Type\SyndicationFeedEntryCount',
		'KalturaSystemPartnerLimit' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerLimit',
		'KalturaSystemPartnerConfiguration' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerConfiguration',
		'KalturaSystemPartnerPackage' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerPackage',
		'KalturaSystemPartnerUsageItem' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerUsageItem',
		'KalturaTag' => 'Kaltura\Client\Plugin\TagSearch\Type\Tag',
		'KalturaTranscriptAsset' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAsset',
		'KalturaTransformMetadataResponse' => 'Kaltura\Client\Plugin\Metadata\Type\TransformMetadataResponse',
		'KalturaTypedArray' => 'Kaltura\Client\Type\TypedArray',
		'KalturaUiConf' => 'Kaltura\Client\Type\UiConf',
		'KalturaUiConfAdmin' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdmin',
		'KalturaUiConfTypeInfo' => 'Kaltura\Client\Type\UiConfTypeInfo',
		'KalturaUpgradeMetadataResponse' => 'Kaltura\Client\Plugin\Metadata\Type\UpgradeMetadataResponse',
		'KalturaUploadResponse' => 'Kaltura\Client\Type\UploadResponse',
		'KalturaUploadToken' => 'Kaltura\Client\Type\UploadToken',
		'KalturaUserEntry' => 'Kaltura\Client\Type\UserEntry',
		'KalturaUserLoginData' => 'Kaltura\Client\Type\UserLoginData',
		'KalturaUserRole' => 'Kaltura\Client\Type\UserRole',
		'KalturaVarPartnerUsageItem' => 'Kaltura\Client\Plugin\VarConsole\Type\VarPartnerUsageItem',
		'KalturaVendorCatalogItemPricing' => 'Kaltura\Client\Plugin\Reach\Type\VendorCatalogItemPricing',
		'KalturaVendorCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorCatalogItem',
		'KalturaVirtualEvent' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualEvent',
		'KalturaVirusScanProfile' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfile',
		'KalturaWidget' => 'Kaltura\Client\Type\Widget',
		'KalturaBatchJobBaseFilter' => 'Kaltura\Client\Type\BatchJobBaseFilter',
		'KalturaBatchJobFilter' => 'Kaltura\Client\Type\BatchJobFilter',
		'KalturaWorkerQueueFilter' => 'Kaltura\Client\Type\WorkerQueueFilter',
		'KalturaYouTubeApiCaptionDistributionInfo' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YouTubeApiCaptionDistributionInfo',
		'KalturaZoomIntegrationSetting' => 'Kaltura\Client\Plugin\Vendor\Type\ZoomIntegrationSetting',
		'KalturaAccessControlBlockAction' => 'Kaltura\Client\Type\AccessControlBlockAction',
		'KalturaAccessControlDrmPolicyAction' => 'Kaltura\Client\Plugin\Drm\Type\AccessControlDrmPolicyAction',
		'KalturaAccessControlLimitDeliveryProfilesAction' => 'Kaltura\Client\Type\AccessControlLimitDeliveryProfilesAction',
		'KalturaAccessControlLimitFlavorsAction' => 'Kaltura\Client\Type\AccessControlLimitFlavorsAction',
		'KalturaAccessControlLimitThumbnailCaptureAction' => 'Kaltura\Client\Type\AccessControlLimitThumbnailCaptureAction',
		'KalturaAccessControlListResponse' => 'Kaltura\Client\Type\AccessControlListResponse',
		'KalturaAccessControlModifyRequestHostRegexAction' => 'Kaltura\Client\Type\AccessControlModifyRequestHostRegexAction',
		'KalturaAccessControlPreviewAction' => 'Kaltura\Client\Type\AccessControlPreviewAction',
		'KalturaAccessControlProfileListResponse' => 'Kaltura\Client\Type\AccessControlProfileListResponse',
		'KalturaAccessControlServeRemoteEdgeServerAction' => 'Kaltura\Client\Type\AccessControlServeRemoteEdgeServerAction',
		'KalturaActivitiBusinessProcessServer' => 'Kaltura\Client\Plugin\ActivitiBusinessProcessNotification\Type\ActivitiBusinessProcessServer',
		'KalturaAdCuePoint' => 'Kaltura\Client\Plugin\AdCuePoint\Type\AdCuePoint',
		'KalturaAddEntryVendorTaskAction' => 'Kaltura\Client\Plugin\Reach\Type\AddEntryVendorTaskAction',
		'KalturaAmazonS3StorageProfile' => 'Kaltura\Client\Type\AmazonS3StorageProfile',
		'KalturaAnnotationListResponse' => 'Kaltura\Client\Plugin\Annotation\Type\AnnotationListResponse',
		'KalturaAnswerCuePoint' => 'Kaltura\Client\Plugin\Quiz\Type\AnswerCuePoint',
		'KalturaApiActionPermissionItem' => 'Kaltura\Client\Type\ApiActionPermissionItem',
		'KalturaApiParameterPermissionItem' => 'Kaltura\Client\Type\ApiParameterPermissionItem',
		'KalturaAppTokenBaseFilter' => 'Kaltura\Client\Type\AppTokenBaseFilter',
		'KalturaAppTokenListResponse' => 'Kaltura\Client\Type\AppTokenListResponse',
		'KalturaAssetDistributionPropertyCondition' => 'Kaltura\Client\Plugin\ContentDistribution\Type\AssetDistributionPropertyCondition',
		'KalturaAssetParamsOutput' => 'Kaltura\Client\Type\AssetParamsOutput',
		'KalturaAssetPropertiesCompareCondition' => 'Kaltura\Client\Type\AssetPropertiesCompareCondition',
		'KalturaAssetTypeCondition' => 'Kaltura\Client\Type\AssetTypeCondition',
		'KalturaAssetsParamsResourceContainers' => 'Kaltura\Client\Type\AssetsParamsResourceContainers',
		'KalturaAttachmentAssetListResponse' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAssetListResponse',
		'KalturaAttachmentServeOptions' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentServeOptions',
		'KalturaAttributeCondition' => 'Kaltura\Client\Type\AttributeCondition',
		'KalturaAuditTrailChangeInfo' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailChangeInfo',
		'KalturaAuditTrailChangeXmlNode' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailChangeXmlNode',
		'KalturaAuditTrailFileSyncCreateInfo' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailFileSyncCreateInfo',
		'KalturaAuditTrailListResponse' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailListResponse',
		'KalturaAuditTrailTextInfo' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailTextInfo',
		'KalturaAuthenticatedCondition' => 'Kaltura\Client\Type\AuthenticatedCondition',
		'KalturaAvnDistributionProvider' => 'Kaltura\Client\Plugin\AvnDistribution\Type\AvnDistributionProvider',
		'KalturaBaseEntryCloneOptionComponent' => 'Kaltura\Client\Type\BaseEntryCloneOptionComponent',
		'KalturaBaseEntryListResponse' => 'Kaltura\Client\Type\BaseEntryListResponse',
		'KalturaBaseSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\BaseSyndicationFeedBaseFilter',
		'KalturaBaseSyndicationFeedListResponse' => 'Kaltura\Client\Type\BaseSyndicationFeedListResponse',
		'KalturaBeaconBaseFilter' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconBaseFilter',
		'KalturaBeaconEnhanceFilter' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconEnhanceFilter',
		'KalturaBeaconListResponse' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconListResponse',
		'KalturaBeaconScheduledResourceOperator' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconScheduledResourceOperator',
		'KalturaBeaconScheduledResourceSearchParams' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconScheduledResourceSearchParams',
		'KalturaBlackoutScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\BlackoutScheduleEvent',
		'KalturaBooleanEventNotificationCondition' => 'Kaltura\Client\Type\BooleanEventNotificationCondition',
		'KalturaBpmEventNotificationIntegrationJobTriggerData' => 'Kaltura\Client\Plugin\BpmEventNotificationIntegration\Type\BpmEventNotificationIntegrationJobTriggerData',
		'KalturaBulkDownloadJobData' => 'Kaltura\Client\Type\BulkDownloadJobData',
		'KalturaBulkServiceFilterDataBase' => 'Kaltura\Client\Plugin\BulkUploadFilter\Type\BulkServiceFilterDataBase',
		'KalturaBulkUploadBaseFilter' => 'Kaltura\Client\Type\BulkUploadBaseFilter',
		'KalturaBulkUploadCategoryData' => 'Kaltura\Client\Type\BulkUploadCategoryData',
		'KalturaBulkUploadCategoryEntryData' => 'Kaltura\Client\Type\BulkUploadCategoryEntryData',
		'KalturaBulkUploadCategoryUserData' => 'Kaltura\Client\Type\BulkUploadCategoryUserData',
		'KalturaBulkUploadEntryData' => 'Kaltura\Client\Type\BulkUploadEntryData',
		'KalturaBulkUploadJobData' => 'Kaltura\Client\Type\BulkUploadJobData',
		'KalturaBulkUploadListResponse' => 'Kaltura\Client\Type\BulkUploadListResponse',
		'KalturaBulkUploadResultCategory' => 'Kaltura\Client\Type\BulkUploadResultCategory',
		'KalturaBulkUploadResultCategoryEntry' => 'Kaltura\Client\Type\BulkUploadResultCategoryEntry',
		'KalturaBulkUploadResultCategoryUser' => 'Kaltura\Client\Type\BulkUploadResultCategoryUser',
		'KalturaBulkUploadResultEntry' => 'Kaltura\Client\Type\BulkUploadResultEntry',
		'KalturaBulkUploadResultJob' => 'Kaltura\Client\Plugin\BulkUploadFilter\Type\BulkUploadResultJob',
		'KalturaBulkUploadResultScheduleEvent' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadResultScheduleEvent',
		'KalturaBulkUploadResultScheduleResource' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadResultScheduleResource',
		'KalturaBulkUploadResultUser' => 'Kaltura\Client\Type\BulkUploadResultUser',
		'KalturaBulkUploadResultUserEntry' => 'Kaltura\Client\Type\BulkUploadResultUserEntry',
		'KalturaBulkUploadResultVendorCatalogItem' => 'Kaltura\Client\Type\BulkUploadResultVendorCatalogItem',
		'KalturaBulkUploadUserData' => 'Kaltura\Client\Type\BulkUploadUserData',
		'KalturaBulkUploadVendorCatalogItemData' => 'Kaltura\Client\Type\BulkUploadVendorCatalogItemData',
		'KalturaBusinessProcessNotificationTemplate' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessNotificationTemplate',
		'KalturaBusinessProcessServerBaseFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessServerBaseFilter',
		'KalturaBusinessProcessServerListResponse' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessServerListResponse',
		'KalturaCameraScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\CameraScheduleResource',
		'KalturaCaptionAssetItemListResponse' => 'Kaltura\Client\Plugin\CaptionSearch\Type\CaptionAssetItemListResponse',
		'KalturaCaptionAssetListResponse' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAssetListResponse',
		'KalturaCaptionParamsListResponse' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParamsListResponse',
		'KalturaCaptureThumbJobData' => 'Kaltura\Client\Type\CaptureThumbJobData',
		'KalturaCatalogItemAdvancedFilter' => 'Kaltura\Client\Plugin\Reach\Type\CatalogItemAdvancedFilter',
		'KalturaCategoryEntryAdvancedFilter' => 'Kaltura\Client\Type\CategoryEntryAdvancedFilter',
		'KalturaCategoryEntryCondition' => 'Kaltura\Client\Plugin\Reach\Type\CategoryEntryCondition',
		'KalturaCategoryEntryListResponse' => 'Kaltura\Client\Type\CategoryEntryListResponse',
		'KalturaCategoryIdentifier' => 'Kaltura\Client\Type\CategoryIdentifier',
		'KalturaCategoryListResponse' => 'Kaltura\Client\Type\CategoryListResponse',
		'KalturaCategoryUserAdvancedFilter' => 'Kaltura\Client\Type\CategoryUserAdvancedFilter',
		'KalturaCategoryUserListResponse' => 'Kaltura\Client\Type\CategoryUserListResponse',
		'KalturaCategoryUserProviderFilter' => 'Kaltura\Client\Plugin\EmailNotification\Type\CategoryUserProviderFilter',
		'KalturaCielo24JobProviderData' => 'Kaltura\Client\Plugin\Cielo24\Type\Cielo24JobProviderData',
		'KalturaClipAttributes' => 'Kaltura\Client\Type\ClipAttributes',
		'KalturaClipConcatJobData' => 'Kaltura\Client\Type\ClipConcatJobData',
		'KalturaCodeCuePoint' => 'Kaltura\Client\Plugin\CodeCuePoint\Type\CodeCuePoint',
		'KalturaComcastMrssDistributionProvider' => 'Kaltura\Client\Plugin\ComcastMrssDistribution\Type\ComcastMrssDistributionProvider',
		'KalturaCompareCondition' => 'Kaltura\Client\Type\CompareCondition',
		'KalturaDataCenterContentResource' => 'Kaltura\Client\Type\DataCenterContentResource',
		'KalturaConcatAttributes' => 'Kaltura\Client\Type\ConcatAttributes',
		'KalturaConcatJobData' => 'Kaltura\Client\Type\ConcatJobData',
		'KalturaConfMapsListResponse' => 'Kaltura\Client\Plugin\ConfMaps\Type\ConfMapsListResponse',
		'KalturaConferenceEntryServerNode' => 'Kaltura\Client\Plugin\Conference\Type\ConferenceEntryServerNode',
		'KalturaConferenceServerNode' => 'Kaltura\Client\Plugin\Conference\Type\ConferenceServerNode',
		'KalturaConfigurableDistributionJobProviderData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionJobProviderData',
		'KalturaConfigurableDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionProfile',
		'KalturaContentDistributionSearchItem' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ContentDistributionSearchItem',
		'KalturaControlPanelCommandBaseFilter' => 'Kaltura\Client\Type\ControlPanelCommandBaseFilter',
		'KalturaControlPanelCommandListResponse' => 'Kaltura\Client\Type\ControlPanelCommandListResponse',
		'KalturaConvartableJobData' => 'Kaltura\Client\Type\ConvartableJobData',
		'KalturaConversionProfileAssetParamsListResponse' => 'Kaltura\Client\Type\ConversionProfileAssetParamsListResponse',
		'KalturaConversionProfileListResponse' => 'Kaltura\Client\Type\ConversionProfileListResponse',
		'KalturaConvertCaptionAssetJobData' => 'Kaltura\Client\Plugin\Caption\Type\ConvertCaptionAssetJobData',
		'KalturaConvertEntryFlavorsObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ConvertEntryFlavorsObjectTask',
		'KalturaConvertLiveSegmentJobData' => 'Kaltura\Client\Type\ConvertLiveSegmentJobData',
		'KalturaConvertProfileJobData' => 'Kaltura\Client\Type\ConvertProfileJobData',
		'KalturaCopyCaptionsJobData' => 'Kaltura\Client\Plugin\Caption\Type\CopyCaptionsJobData',
		'KalturaCopyJobData' => 'Kaltura\Client\Type\CopyJobData',
		'KalturaCopyPartnerJobData' => 'Kaltura\Client\Type\CopyPartnerJobData',
		'KalturaCountryRestriction' => 'Kaltura\Client\Type\CountryRestriction',
		'KalturaCrossKalturaDistributionProvider' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionProvider',
		'KalturaCuePointListResponse' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePointListResponse',
		'KalturaDailymotionDistributionProvider' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionProvider',
		'KalturaDataListResponse' => 'Kaltura\Client\Type\DataListResponse',
		'KalturaDeleteEntryFlavorsObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\DeleteEntryFlavorsObjectTask',
		'KalturaDeleteEntryObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\DeleteEntryObjectTask',
		'KalturaDeleteFileJobData' => 'Kaltura\Client\Type\DeleteFileJobData',
		'KalturaDeleteJobData' => 'Kaltura\Client\Type\DeleteJobData',
		'KalturaDeleteLocalContentObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\DeleteLocalContentObjectTask',
		'KalturaDeliveryProfileAkamaiAppleHttpManifest' => 'Kaltura\Client\Type\DeliveryProfileAkamaiAppleHttpManifest',
		'KalturaDeliveryProfileAkamaiHds' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHds',
		'KalturaDeliveryProfileBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileBaseFilter',
		'KalturaDeliveryProfileCondition' => 'Kaltura\Client\Type\DeliveryProfileCondition',
		'KalturaDeliveryProfileGenericAppleHttp' => 'Kaltura\Client\Type\DeliveryProfileGenericAppleHttp',
		'KalturaDeliveryProfileGenericHds' => 'Kaltura\Client\Type\DeliveryProfileGenericHds',
		'KalturaDeliveryProfileGenericSilverLight' => 'Kaltura\Client\Type\DeliveryProfileGenericSilverLight',
		'KalturaDeliveryProfileHttp' => 'Kaltura\Client\Type\DeliveryProfileHttp',
		'KalturaDeliveryProfileListResponse' => 'Kaltura\Client\Type\DeliveryProfileListResponse',
		'KalturaDeliveryProfileLiveAppleHttp' => 'Kaltura\Client\Type\DeliveryProfileLiveAppleHttp',
		'KalturaDeliveryProfileLivePackager' => 'Kaltura\Client\Type\DeliveryProfileLivePackager',
		'KalturaDeliveryProfileRtmp' => 'Kaltura\Client\Type\DeliveryProfileRtmp',
		'KalturaDeliveryProfileVod' => 'Kaltura\Client\Type\DeliveryProfileVod',
		'KalturaDeliveryServerNode' => 'Kaltura\Client\Type\DeliveryServerNode',
		'KalturaDirectoryRestriction' => 'Kaltura\Client\Type\DirectoryRestriction',
		'KalturaDispatchEventNotificationObjectTask' => 'Kaltura\Client\Plugin\ScheduledTaskEventNotification\Type\DispatchEventNotificationObjectTask',
		'KalturaDistributeObjectTask' => 'Kaltura\Client\Plugin\ScheduledTaskContentDistribution\Type\DistributeObjectTask',
		'KalturaDistributionJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionJobData',
		'KalturaDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfileBaseFilter',
		'KalturaDistributionProfileListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfileListResponse',
		'KalturaDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProviderBaseFilter',
		'KalturaDistributionProviderListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProviderListResponse',
		'KalturaDistributionValidationErrorConditionNotMet' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorConditionNotMet',
		'KalturaDistributionValidationErrorInvalidData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorInvalidData',
		'KalturaDistributionValidationErrorMissingAsset' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingAsset',
		'KalturaDistributionValidationErrorMissingFlavor' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingFlavor',
		'KalturaDistributionValidationErrorMissingMetadata' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingMetadata',
		'KalturaDistributionValidationErrorMissingThumbnail' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorMissingThumbnail',
		'KalturaDocumentListResponse' => 'Kaltura\Client\Plugin\Document\Type\DocumentListResponse',
		'KalturaDoubleClickDistributionJobProviderData' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionJobProviderData',
		'KalturaDoubleClickDistributionProvider' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionProvider',
		'KalturaDrmEntryContextPluginData' => 'Kaltura\Client\Type\DrmEntryContextPluginData',
		'KalturaDrmPolicyBaseFilter' => 'Kaltura\Client\Plugin\Drm\Type\DrmPolicyBaseFilter',
		'KalturaDrmPolicyListResponse' => 'Kaltura\Client\Plugin\Drm\Type\DrmPolicyListResponse',
		'KalturaDrmProfileBaseFilter' => 'Kaltura\Client\Plugin\Drm\Type\DrmProfileBaseFilter',
		'KalturaDrmProfileListResponse' => 'Kaltura\Client\Plugin\Drm\Type\DrmProfileListResponse',
		'KalturaDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderBaseFilter',
		'KalturaDropFolderContentFileHandlerConfig' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderContentFileHandlerConfig',
		'KalturaDropFolderContentProcessorJobData' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderContentProcessorJobData',
		'KalturaDropFolderFileBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileBaseFilter',
		'KalturaDropFolderFileListResponse' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileListResponse',
		'KalturaDropFolderICalBulkUploadFileHandlerConfig' => 'Kaltura\Client\Plugin\ScheduleDropFolder\Type\DropFolderICalBulkUploadFileHandlerConfig',
		'KalturaDropFolderListResponse' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderListResponse',
		'KalturaDropFolderXmlBulkUploadFileHandlerConfig' => 'Kaltura\Client\Plugin\DropFolderXmlBulkUpload\Type\DropFolderXmlBulkUploadFileHandlerConfig',
		'KalturaESearchCaptionItemData' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCaptionItemData',
		'KalturaESearchCategoryAggregationItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryAggregationItem',
		'KalturaESearchCategoryOrderByItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryOrderByItem',
		'KalturaESearchCategoryOperator' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryOperator',
		'KalturaESearchCategoryParams' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryParams',
		'KalturaESearchCategoryResponse' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryResponse',
		'KalturaESearchCuePointItemData' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCuePointItemData',
		'KalturaESearchCuepointsAggregationItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCuepointsAggregationItem',
		'KalturaESearchEntryAggregationItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryAggregationItem',
		'KalturaESearchEntryOrderByItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryOrderByItem',
		'KalturaESearchEntryParams' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryParams',
		'KalturaESearchEntryResponse' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryResponse',
		'KalturaESearchGroupOrderByItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchGroupOrderByItem',
		'KalturaESearchGroupOperator' => 'Kaltura\Client\Plugin\Group\Type\ESearchGroupOperator',
		'KalturaESearchGroupParams' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchGroupParams',
		'KalturaESearchGroupResponse' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchGroupResponse',
		'KalturaESearchHistoryFilter' => 'Kaltura\Client\Plugin\SearchHistory\Type\ESearchHistoryFilter',
		'KalturaESearchHistoryListResponse' => 'Kaltura\Client\Plugin\SearchHistory\Type\ESearchHistoryListResponse',
		'KalturaESearchMetadataAggregationItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchMetadataAggregationItem',
		'KalturaESearchMetadataItemData' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchMetadataItemData',
		'KalturaESearchMetadataOrderByItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchMetadataOrderByItem',
		'KalturaESearchUserOrderByItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserOrderByItem',
		'KalturaESearchUserOperator' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserOperator',
		'KalturaESearchUserParams' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserParams',
		'KalturaESearchUserResponse' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserResponse',
		'KalturaCategoryUserBaseFilter' => 'Kaltura\Client\Type\CategoryUserBaseFilter',
		'KalturaCategoryUserFilter' => 'Kaltura\Client\Type\CategoryUserFilter',
		'KalturaEmailNotificationCategoryRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationCategoryRecipientJobData',
		'KalturaEmailNotificationCategoryRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationCategoryRecipientProvider',
		'KalturaEmailNotificationGroupRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationGroupRecipientJobData',
		'KalturaEmailNotificationGroupRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationGroupRecipientProvider',
		'KalturaEmailNotificationParameter' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationParameter',
		'KalturaEmailNotificationStaticRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationStaticRecipientJobData',
		'KalturaEmailNotificationStaticRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationStaticRecipientProvider',
		'KalturaEmailNotificationTemplate' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationTemplate',
		'KalturaBaseUserBaseFilter' => 'Kaltura\Client\Type\BaseUserBaseFilter',
		'KalturaBaseUserFilter' => 'Kaltura\Client\Type\BaseUserFilter',
		'KalturaUserBaseFilter' => 'Kaltura\Client\Type\UserBaseFilter',
		'KalturaUserFilter' => 'Kaltura\Client\Type\UserFilter',
		'KalturaEmailNotificationUserRecipientJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationUserRecipientJobData',
		'KalturaEmailNotificationUserRecipientProvider' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationUserRecipientProvider',
		'KalturaEntryCaptionAdvancedFilter' => 'Kaltura\Client\Plugin\ElasticSearch\Type\EntryCaptionAdvancedFilter',
		'KalturaEntryCaptionAssetSearchItem' => 'Kaltura\Client\Plugin\CaptionSearch\Type\EntryCaptionAssetSearchItem',
		'KalturaEntryContext' => 'Kaltura\Client\Type\EntryContext',
		'KalturaEntryContextDataParams' => 'Kaltura\Client\Type\EntryContextDataParams',
		'KalturaEntryContextDataResult' => 'Kaltura\Client\Type\EntryContextDataResult',
		'KalturaEntryCuePointSearchFilter' => 'Kaltura\Client\Type\EntryCuePointSearchFilter',
		'KalturaEntryDistributionListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistributionListResponse',
		'KalturaEntryIdentifier' => 'Kaltura\Client\Type\EntryIdentifier',
		'KalturaEntryLiveStats' => 'Kaltura\Client\Type\EntryLiveStats',
		'KalturaEntryScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\EntryScheduleEvent',
		'KalturaEntryScheduledCondition' => 'Kaltura\Client\Type\EntryScheduledCondition',
		'KalturaEntryServerNodeBaseFilter' => 'Kaltura\Client\Type\EntryServerNodeBaseFilter',
		'KalturaEntryServerNodeListResponse' => 'Kaltura\Client\Type\EntryServerNodeListResponse',
		'KalturaEntryTranscriptAssetSearchItem' => 'Kaltura\Client\Plugin\Transcript\Type\EntryTranscriptAssetSearchItem',
		'KalturaEntryVendorTaskListResponse' => 'Kaltura\Client\Plugin\Reach\Type\EntryVendorTaskListResponse',
		'KalturaEventCuePoint' => 'Kaltura\Client\Plugin\EventCuePoint\Type\EventCuePoint',
		'KalturaBooleanField' => 'Kaltura\Client\Type\BooleanField',
		'KalturaEventFieldCondition' => 'Kaltura\Client\Plugin\EventNotification\Type\EventFieldCondition',
		'KalturaEventNotificationArrayParameter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationArrayParameter',
		'KalturaEventNotificationDispatchJobData' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationDispatchJobData',
		'KalturaEventNotificationScope' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationScope',
		'KalturaEventNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplateBaseFilter',
		'KalturaEventNotificationTemplateListResponse' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplateListResponse',
		'KalturaEventObjectChangedCondition' => 'Kaltura\Client\Plugin\EventNotification\Type\EventObjectChangedCondition',
		'KalturaExecuteMetadataXsltObjectTask' => 'Kaltura\Client\Plugin\ScheduledTaskMetadata\Type\ExecuteMetadataXsltObjectTask',
		'KalturaExportCsvJobData' => 'Kaltura\Client\Type\ExportCsvJobData',
		'KalturaExternalMediaEntryListResponse' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntryListResponse',
		'KalturaFacebookDistributionProvider' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProvider',
		'KalturaFairplayDrmProfile' => 'Kaltura\Client\Plugin\Fairplay\Type\FairplayDrmProfile',
		'KalturaFairplayEntryContextPluginData' => 'Kaltura\Client\Plugin\Fairplay\Type\FairplayEntryContextPluginData',
		'KalturaFeatureStatusListResponse' => 'Kaltura\Client\Type\FeatureStatusListResponse',
		'KalturaFeedDropFolder' => 'Kaltura\Client\Plugin\FeedDropFolder\Type\FeedDropFolder',
		'KalturaFeedDropFolderFile' => 'Kaltura\Client\Plugin\FeedDropFolder\Type\FeedDropFolderFile',
		'KalturaFileAssetListResponse' => 'Kaltura\Client\Type\FileAssetListResponse',
		'KalturaFileSyncBaseFilter' => 'Kaltura\Client\Plugin\FileSync\Type\FileSyncBaseFilter',
		'KalturaFlattenJobData' => 'Kaltura\Client\Type\FlattenJobData',
		'KalturaFlavorAssetListResponse' => 'Kaltura\Client\Type\FlavorAssetListResponse',
		'KalturaFlavorParamsListResponse' => 'Kaltura\Client\Type\FlavorParamsListResponse',
		'KalturaFreewheelDistributionJobProviderData' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionJobProviderData',
		'KalturaFreewheelDistributionProfile' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionProfile',
		'KalturaFreewheelDistributionProvider' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionProvider',
		'KalturaFreewheelGenericDistributionProvider' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionProvider',
		'KalturaFtpDistributionProvider' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionProvider',
		'KalturaGenericDistributionJobProviderData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionJobProviderData',
		'KalturaGenericDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfile',
		'KalturaGenericDistributionProviderActionBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderActionBaseFilter',
		'KalturaGenericDistributionProviderActionListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderActionListResponse',
		'KalturaGenericDistributionProviderListResponse' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderListResponse',
		'KalturaGenericSyndicationFeed' => 'Kaltura\Client\Type\GenericSyndicationFeed',
		'KalturaGoogleVideoSyndicationFeed' => 'Kaltura\Client\Type\GoogleVideoSyndicationFeed',
		'KalturaGroupListResponse' => 'Kaltura\Client\Plugin\Group\Type\GroupListResponse',
		'KalturaGroupUserListResponse' => 'Kaltura\Client\Type\GroupUserListResponse',
		'KalturaHashCondition' => 'Kaltura\Client\Type\HashCondition',
		'KalturaHttpNotificationDataFields' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationDataFields',
		'KalturaHttpNotificationDataText' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationDataText',
		'KalturaHttpNotificationObjectData' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationObjectData',
		'KalturaHttpNotificationTemplate' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationTemplate',
		'KalturaHuluDistributionProvider' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionProvider',
		'KalturaITunesSyndicationFeed' => 'Kaltura\Client\Type\ITunesSyndicationFeed',
		'KalturaIdeticDistributionProvider' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProvider',
		'KalturaImportJobData' => 'Kaltura\Client\Type\ImportJobData',
		'KalturaImportMetadataJobData' => 'Kaltura\Client\Plugin\Metadata\Type\ImportMetadataJobData',
		'KalturaIndexAdvancedFilter' => 'Kaltura\Client\Type\IndexAdvancedFilter',
		'KalturaIndexJobData' => 'Kaltura\Client\Type\IndexJobData',
		'KalturaIndexTagsByPrivacyContextJobData' => 'Kaltura\Client\Plugin\TagSearch\Type\IndexTagsByPrivacyContextJobData',
		'KalturaIntegrationJobData' => 'Kaltura\Client\Plugin\Integration\Type\IntegrationJobData',
		'KalturaIntelligentTaggingVendorTaskData' => 'Kaltura\Client\Plugin\Reach\Type\IntelligentTaggingVendorTaskData',
		'KalturaInteractivity' => 'Kaltura\Client\Plugin\Interactivity\Type\Interactivity',
		'KalturaIpAddressRestriction' => 'Kaltura\Client\Type\IpAddressRestriction',
		'KalturaKeyValueExtended' => 'Kaltura\Client\Type\KeyValueExtended',
		'KalturaKontikiStorageProfile' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageProfile',
		'KalturaLikeListResponse' => 'Kaltura\Client\Plugin\Like\Type\LikeListResponse',
		'KalturaLimitFlavorsRestriction' => 'Kaltura\Client\Type\LimitFlavorsRestriction',
		'KalturaLiveCaptionFeature' => 'Kaltura\Client\Plugin\Schedule\Type\LiveCaptionFeature',
		'KalturaLiveChannelListResponse' => 'Kaltura\Client\Type\LiveChannelListResponse',
		'KalturaLiveChannelSegmentListResponse' => 'Kaltura\Client\Type\LiveChannelSegmentListResponse',
		'KalturaLiveEntryArchiveJobData' => 'Kaltura\Client\Type\LiveEntryArchiveJobData',
		'KalturaLiveEntryScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\LiveEntryScheduleResource',
		'KalturaLiveEntryServerNode' => 'Kaltura\Client\Type\LiveEntryServerNode',
		'KalturaLiveReportExportJobData' => 'Kaltura\Client\Type\LiveReportExportJobData',
		'KalturaLiveRestreamFeature' => 'Kaltura\Client\Plugin\Schedule\Type\LiveRestreamFeature',
		'KalturaLiveStatsListResponse' => 'Kaltura\Client\Type\LiveStatsListResponse',
		'KalturaLiveStreamListResponse' => 'Kaltura\Client\Type\LiveStreamListResponse',
		'KalturaLiveStreamPushPublishRTMPConfiguration' => 'Kaltura\Client\Type\LiveStreamPushPublishRTMPConfiguration',
		'KalturaLiveToVodJobData' => 'Kaltura\Client\Type\LiveToVodJobData',
		'KalturaLocationScheduleResource' => 'Kaltura\Client\Plugin\Schedule\Type\LocationScheduleResource',
		'KalturaMailJobData' => 'Kaltura\Client\Type\MailJobData',
		'KalturaMailNotificationObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\MailNotificationObjectTask',
		'KalturaMatchCondition' => 'Kaltura\Client\Type\MatchCondition',
		'KalturaMediaInfoBaseFilter' => 'Kaltura\Client\Type\MediaInfoBaseFilter',
		'KalturaMediaListResponse' => 'Kaltura\Client\Type\MediaListResponse',
		'KalturaMetadataListResponse' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataListResponse',
		'KalturaMetadataProfileBaseFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileBaseFilter',
		'KalturaMetadataProfileFieldListResponse' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileFieldListResponse',
		'KalturaMetadataProfileListResponse' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileListResponse',
		'KalturaMetadataReplacementOptionsItem' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataReplacementOptionsItem',
		'KalturaMetadataResponseProfileMapping' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataResponseProfileMapping',
		'KalturaMetroPcsDistributionProvider' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionProvider',
		'KalturaMixListResponse' => 'Kaltura\Client\Type\MixListResponse',
		'KalturaModerationFlagListResponse' => 'Kaltura\Client\Type\ModerationFlagListResponse',
		'KalturaModifyCategoriesObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ModifyCategoriesObjectTask',
		'KalturaModifyEntryObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ModifyEntryObjectTask',
		'KalturaMoveCategoryEntriesJobData' => 'Kaltura\Client\Type\MoveCategoryEntriesJobData',
		'KalturaMsnDistributionProvider' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionProvider',
		'KalturaNotificationJobData' => 'Kaltura\Client\Type\NotificationJobData',
		'KalturaObjectListResponse' => 'Kaltura\Client\Type\ObjectListResponse',
		'KalturaOrCondition' => 'Kaltura\Client\Type\OrCondition',
		'KalturaParseCaptionAssetJobData' => 'Kaltura\Client\Plugin\VirusScan\Type\ParseCaptionAssetJobData',
		'KalturaParseMultiLanguageCaptionAssetJobData' => 'Kaltura\Client\Plugin\Caption\Type\ParseMultiLanguageCaptionAssetJobData',
		'KalturaPartnerBaseFilter' => 'Kaltura\Client\Type\PartnerBaseFilter',
		'KalturaPartnerListResponse' => 'Kaltura\Client\Type\PartnerListResponse',
		'KalturaPartnerUsageListResponse' => 'Kaltura\Client\Plugin\VarConsole\Type\PartnerUsageListResponse',
		'KalturaPermissionItemListResponse' => 'Kaltura\Client\Type\PermissionItemListResponse',
		'KalturaPermissionListResponse' => 'Kaltura\Client\Type\PermissionListResponse',
		'KalturaPlayReadyCopyRight' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyCopyRight',
		'KalturaPlayReadyPlayRight' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyPlayRight',
		'KalturaPlayReadyProfile' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyProfile',
		'KalturaPlaylistListResponse' => 'Kaltura\Client\Type\PlaylistListResponse',
		'KalturaPodcastDistributionJobProviderData' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionJobProviderData',
		'KalturaPodcastDistributionProfile' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionProfile',
		'KalturaPodcastDistributionProvider' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionProvider',
		'KalturaProvisionJobData' => 'Kaltura\Client\Type\ProvisionJobData',
		'KalturaPushNotificationTemplate' => 'Kaltura\Client\Plugin\PushNotification\Type\PushNotificationTemplate',
		'KalturaQuestionCuePoint' => 'Kaltura\Client\Plugin\Quiz\Type\QuestionCuePoint',
		'KalturaQuickPlayDistributionProvider' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionProvider',
		'KalturaQuizAdvancedFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuizAdvancedFilter',
		'KalturaQuizListResponse' => 'Kaltura\Client\Plugin\Quiz\Type\QuizListResponse',
		'KalturaQuizUserEntry' => 'Kaltura\Client\Type\QuizUserEntry',
		'KalturaRatingCountListResponse' => 'Kaltura\Client\Plugin\Rating\Type\RatingCountListResponse',
		'KalturaReachProfileListResponse' => 'Kaltura\Client\Plugin\Reach\Type\ReachProfileListResponse',
		'KalturaRecalculateCacheJobData' => 'Kaltura\Client\Type\RecalculateCacheJobData',
		'KalturaRegistrationUserEntry' => 'Kaltura\Client\Plugin\Registration\Type\RegistrationUserEntry',
		'KalturaRemoteDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\RemoteDropFolder',
		'KalturaRemotePathListResponse' => 'Kaltura\Client\Type\RemotePathListResponse',
		'KalturaReportBaseFilter' => 'Kaltura\Client\Type\ReportBaseFilter',
		'KalturaReportExportJobData' => 'Kaltura\Client\Type\ReportExportJobData',
		'KalturaReportListResponse' => 'Kaltura\Client\Type\ReportListResponse',
		'KalturaResponseProfileBaseFilter' => 'Kaltura\Client\Type\ResponseProfileBaseFilter',
		'KalturaResponseProfileHolder' => 'Kaltura\Client\Type\ResponseProfileHolder',
		'KalturaResponseProfileListResponse' => 'Kaltura\Client\Type\ResponseProfileListResponse',
		'KalturaScheduleEventListResponse' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventListResponse',
		'KalturaScheduleEventResourceListResponse' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResourceListResponse',
		'KalturaScheduleResourceListResponse' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResourceListResponse',
		'KalturaScheduledTaskJobData' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskJobData',
		'KalturaScheduledTaskProfileBaseFilter' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfileBaseFilter',
		'KalturaScheduledTaskProfileListResponse' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfileListResponse',
		'KalturaScheduledVendorTaskData' => 'Kaltura\Client\Plugin\Reach\Type\ScheduledVendorTaskData',
		'KalturaSchedulerListResponse' => 'Kaltura\Client\Type\SchedulerListResponse',
		'KalturaSchedulerWorkerListResponse' => 'Kaltura\Client\Type\SchedulerWorkerListResponse',
		'KalturaSearchCondition' => 'Kaltura\Client\Type\SearchCondition',
		'KalturaSearchOperator' => 'Kaltura\Client\Type\SearchOperator',
		'KalturaServerNodeBaseFilter' => 'Kaltura\Client\Type\ServerNodeBaseFilter',
		'KalturaServerNodeListResponse' => 'Kaltura\Client\Type\ServerNodeListResponse',
		'KalturaSessionResponse' => 'Kaltura\Client\Type\SessionResponse',
		'KalturaSessionRestriction' => 'Kaltura\Client\Type\SessionRestriction',
		'KalturaShortLinkBaseFilter' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLinkBaseFilter',
		'KalturaShortLinkListResponse' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLinkListResponse',
		'KalturaSipEntryServerNode' => 'Kaltura\Client\Plugin\Sip\Type\SipEntryServerNode',
		'KalturaSipServerNode' => 'Kaltura\Client\Plugin\Sip\Type\SipServerNode',
		'KalturaSiteRestriction' => 'Kaltura\Client\Type\SiteRestriction',
		'KalturaSsoListResponse' => 'Kaltura\Client\Plugin\Sso\Type\SsoListResponse',
		'KalturaStorageAddAction' => 'Kaltura\Client\Type\StorageAddAction',
		'KalturaStorageExportObjectTask' => 'Kaltura\Client\Plugin\ScheduledTask\Type\StorageExportObjectTask',
		'KalturaStorageJobData' => 'Kaltura\Client\Type\StorageJobData',
		'KalturaStorageProfileBaseFilter' => 'Kaltura\Client\Type\StorageProfileBaseFilter',
		'KalturaStorageProfileListResponse' => 'Kaltura\Client\Type\StorageProfileListResponse',
		'KalturaSyncCategoryPrivacyContextJobData' => 'Kaltura\Client\Type\SyncCategoryPrivacyContextJobData',
		'KalturaSyndicationDistributionProfile' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProfile',
		'KalturaSyndicationDistributionProvider' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProvider',
		'KalturaSystemPartnerLiveAdminTagLimit' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerLiveAdminTagLimit',
		'KalturaSystemPartnerOveragedLimit' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerOveragedLimit',
		'KalturaSystemPartnerUsageFilter' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerUsageFilter',
		'KalturaSystemPartnerUsageListResponse' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerUsageListResponse',
		'KalturaTagFilter' => 'Kaltura\Client\Plugin\TagSearch\Type\TagFilter',
		'KalturaTagListResponse' => 'Kaltura\Client\Plugin\TagSearch\Type\TagListResponse',
		'KalturaTaskEntryServerNode' => 'Kaltura\Client\Type\TaskEntryServerNode',
		'KalturaThumbAssetListResponse' => 'Kaltura\Client\Type\ThumbAssetListResponse',
		'KalturaThumbCuePoint' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\ThumbCuePoint',
		'KalturaThumbParamsListResponse' => 'Kaltura\Client\Type\ThumbParamsListResponse',
		'KalturaThumbnailServeOptions' => 'Kaltura\Client\Type\ThumbnailServeOptions',
		'KalturaTrackEntryListResponse' => 'Kaltura\Client\Plugin\AdminConsole\Type\TrackEntryListResponse',
		'KalturaTranscriptAssetListResponse' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAssetListResponse',
		'KalturaTransformMetadataJobData' => 'Kaltura\Client\Plugin\Metadata\Type\TransformMetadataJobData',
		'KalturaTubeMogulSyndicationFeed' => 'Kaltura\Client\Type\TubeMogulSyndicationFeed',
		'KalturaUiConfAdminListResponse' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdminListResponse',
		'KalturaUiConfBaseFilter' => 'Kaltura\Client\Type\UiConfBaseFilter',
		'KalturaUiConfListResponse' => 'Kaltura\Client\Type\UiConfListResponse',
		'KalturaUnicornDistributionProvider' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionProvider',
		'KalturaUnlimitedVendorCredit' => 'Kaltura\Client\Plugin\Reach\Type\UnlimitedVendorCredit',
		'KalturaUploadTokenBaseFilter' => 'Kaltura\Client\Type\UploadTokenBaseFilter',
		'KalturaUploadTokenListResponse' => 'Kaltura\Client\Type\UploadTokenListResponse',
		'KalturaUrlAuthenticationParamsCondition' => 'Kaltura\Client\Type\UrlAuthenticationParamsCondition',
		'KalturaUrlRecognizerAkamaiG2O' => 'Kaltura\Client\Type\UrlRecognizerAkamaiG2O',
		'KalturaUrlRecognizerKaltura' => 'Kaltura\Client\Type\UrlRecognizerKaltura',
		'KalturaUrlTokenizerAkamaiHttp' => 'Kaltura\Client\Type\UrlTokenizerAkamaiHttp',
		'KalturaUrlTokenizerAkamaiRtmp' => 'Kaltura\Client\Type\UrlTokenizerAkamaiRtmp',
		'KalturaUrlTokenizerAkamaiRtsp' => 'Kaltura\Client\Type\UrlTokenizerAkamaiRtsp',
		'KalturaUrlTokenizerAkamaiSecureHd' => 'Kaltura\Client\Type\UrlTokenizerAkamaiSecureHd',
		'KalturaUrlTokenizerBitGravity' => 'Kaltura\Client\Type\UrlTokenizerBitGravity',
		'KalturaUrlTokenizerChinaCache' => 'Kaltura\Client\Type\UrlTokenizerChinaCache',
		'KalturaUrlTokenizerCht' => 'Kaltura\Client\Type\UrlTokenizerCht',
		'KalturaUrlTokenizerCloudFront' => 'Kaltura\Client\Type\UrlTokenizerCloudFront',
		'KalturaUrlTokenizerKaltura' => 'Kaltura\Client\Type\UrlTokenizerKaltura',
		'KalturaUrlTokenizerKs' => 'Kaltura\Client\Type\UrlTokenizerKs',
		'KalturaUrlTokenizerL3' => 'Kaltura\Client\Type\UrlTokenizerL3',
		'KalturaUrlTokenizerLevel3' => 'Kaltura\Client\Type\UrlTokenizerLevel3',
		'KalturaUrlTokenizerLimeLight' => 'Kaltura\Client\Type\UrlTokenizerLimeLight',
		'KalturaUrlTokenizerVelocix' => 'Kaltura\Client\Type\UrlTokenizerVelocix',
		'KalturaUrlTokenizerVnpt' => 'Kaltura\Client\Type\UrlTokenizerVnpt',
		'KalturaUrlTokenizerWowzaSecureToken' => 'Kaltura\Client\Type\UrlTokenizerWowzaSecureToken',
		'KalturaUserAgentRestriction' => 'Kaltura\Client\Type\UserAgentRestriction',
		'KalturaUserEntryListResponse' => 'Kaltura\Client\Type\UserEntryListResponse',
		'KalturaUserListResponse' => 'Kaltura\Client\Type\UserListResponse',
		'KalturaUserLoginDataListResponse' => 'Kaltura\Client\Type\UserLoginDataListResponse',
		'KalturaUserRoleCondition' => 'Kaltura\Client\Type\UserRoleCondition',
		'KalturaUserRoleListResponse' => 'Kaltura\Client\Type\UserRoleListResponse',
		'KalturaValidateActiveEdgeCondition' => 'Kaltura\Client\Type\ValidateActiveEdgeCondition',
		'KalturaVarPartnerUsageTotalItem' => 'Kaltura\Client\Plugin\VarConsole\Type\VarPartnerUsageTotalItem',
		'KalturaVendorAlignmentCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorAlignmentCatalogItem',
		'KalturaVendorAudioDescriptionCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorAudioDescriptionCatalogItem',
		'KalturaVendorCaptionsCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorCaptionsCatalogItem',
		'KalturaVendorCatalogItemListResponse' => 'Kaltura\Client\Plugin\Reach\Type\VendorCatalogItemListResponse',
		'KalturaVendorChapteringCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorChapteringCatalogItem',
		'KalturaVendorCredit' => 'Kaltura\Client\Plugin\Reach\Type\VendorCredit',
		'KalturaVendorDubbingCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorDubbingCatalogItem',
		'KalturaVendorExtendedAudioDescriptionCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorExtendedAudioDescriptionCatalogItem',
		'KalturaVendorIntelligentTaggingCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorIntelligentTaggingCatalogItem',
		'KalturaVendorTaskDataCaptionAsset' => 'Kaltura\Client\Plugin\Reach\Type\VendorTaskDataCaptionAsset',
		'KalturaViewHistoryUserEntry' => 'Kaltura\Client\Plugin\ViewHistory\Type\ViewHistoryUserEntry',
		'KalturaViewHistoryUserEntryAdvancedFilter' => 'Kaltura\Client\Plugin\ViewHistory\Type\ViewHistoryUserEntryAdvancedFilter',
		'KalturaVirtualEventBaseFilter' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualEventBaseFilter',
		'KalturaVirtualEventListResponse' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualEventListResponse',
		'KalturaVirtualScheduleEvent' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualScheduleEvent',
		'KalturaVirusScanJobData' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanJobData',
		'KalturaVirusScanProfileBaseFilter' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfileBaseFilter',
		'KalturaVirusScanProfileListResponse' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfileListResponse',
		'KalturaVoicebaseJobProviderData' => 'Kaltura\Client\Plugin\Voicebase\Type\VoicebaseJobProviderData',
		'KalturaVolatileInteractivity' => 'Kaltura\Client\Plugin\Interactivity\Type\VolatileInteractivity',
		'KalturaWatchLaterUserEntry' => 'Kaltura\Client\Plugin\WatchLater\Type\WatchLaterUserEntry',
		'KalturaWatchLaterUserEntryAdvancedFilter' => 'Kaltura\Client\Plugin\WatchLater\Type\WatchLaterUserEntryAdvancedFilter',
		'KalturaWebexDropFolder' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolder',
		'KalturaWebexDropFolderFile' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolderFile',
		'KalturaWidevineProfile' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineProfile',
		'KalturaWidevineRepositorySyncJobData' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineRepositorySyncJobData',
		'KalturaWidgetBaseFilter' => 'Kaltura\Client\Type\WidgetBaseFilter',
		'KalturaWidgetListResponse' => 'Kaltura\Client\Type\WidgetListResponse',
		'KalturaYahooDistributionProvider' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionProvider',
		'KalturaYahooSyndicationFeed' => 'Kaltura\Client\Type\YahooSyndicationFeed',
		'KalturaYouTubeDistributionProvider' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionProvider',
		'KalturaYoutubeApiDistributionProvider' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProvider',
		'KalturaZoomIntegrationSettingResponse' => 'Kaltura\Client\Plugin\Vendor\Type\ZoomIntegrationSettingResponse',
		'KalturaAccessControlBaseFilter' => 'Kaltura\Client\Type\AccessControlBaseFilter',
		'KalturaAccessControlProfileBaseFilter' => 'Kaltura\Client\Type\AccessControlProfileBaseFilter',
		'KalturaAdminUser' => 'Kaltura\Client\Type\AdminUser',
		'KalturaAkamaiProvisionJobData' => 'Kaltura\Client\Type\AkamaiProvisionJobData',
		'KalturaAkamaiUniversalProvisionJobData' => 'Kaltura\Client\Type\AkamaiUniversalProvisionJobData',
		'KalturaAlignmentVendorTaskData' => 'Kaltura\Client\Plugin\Reach\Type\AlignmentVendorTaskData',
		'KalturaAnonymousIPCondition' => 'Kaltura\Client\Type\AnonymousIPCondition',
		'KalturaAppTokenFilter' => 'Kaltura\Client\Type\AppTokenFilter',
		'KalturaAssetParamsBaseFilter' => 'Kaltura\Client\Type\AssetParamsBaseFilter',
		'KalturaAssetResource' => 'Kaltura\Client\Type\AssetResource',
		'KalturaAuditTrailBaseFilter' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailBaseFilter',
		'KalturaAvnDistributionProfile' => 'Kaltura\Client\Plugin\AvnDistribution\Type\AvnDistributionProfile',
		'KalturaBaseLiveScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\BaseLiveScheduleEvent',
		'KalturaBaseSyndicationFeedFilter' => 'Kaltura\Client\Type\BaseSyndicationFeedFilter',
		'KalturaBeaconAbstractScheduledResourceItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\BeaconAbstractScheduledResourceItem',
		'KalturaBeaconFilter' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconFilter',
		'KalturaBulkServiceFilterData' => 'Kaltura\Client\Plugin\BulkUploadFilter\Type\BulkServiceFilterData',
		'KalturaBulkUploadCsvJobData' => 'Kaltura\Client\Plugin\BulkUploadCsv\Type\BulkUploadCsvJobData',
		'KalturaBulkUploadFilter' => 'Kaltura\Client\Type\BulkUploadFilter',
		'KalturaBulkUploadFilterJobData' => 'Kaltura\Client\Plugin\BulkUploadFilter\Type\BulkUploadFilterJobData',
		'KalturaBulkUploadScheduleEventJobData' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadScheduleEventJobData',
		'KalturaBulkUploadXmlJobData' => 'Kaltura\Client\Plugin\BulkUploadXml\Type\BulkUploadXmlJobData',
		'KalturaBusinessProcessAbortNotificationTemplate' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessAbortNotificationTemplate',
		'KalturaBusinessProcessNotificationDispatchJobData' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessNotificationDispatchJobData',
		'KalturaBusinessProcessServerFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessServerFilter',
		'KalturaBusinessProcessSignalNotificationTemplate' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessSignalNotificationTemplate',
		'KalturaBusinessProcessStartNotificationTemplate' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessStartNotificationTemplate',
		'KalturaCategoryBaseFilter' => 'Kaltura\Client\Type\CategoryBaseFilter',
		'KalturaCategoryEntryBaseFilter' => 'Kaltura\Client\Type\CategoryEntryBaseFilter',
		'KalturaClippingTaskEntryServerNode' => 'Kaltura\Client\Type\ClippingTaskEntryServerNode',
		'KalturaComcastMrssDistributionProfile' => 'Kaltura\Client\Plugin\ComcastMrssDistribution\Type\ComcastMrssDistributionProfile',
		'KalturaCompareMetadataCondition' => 'Kaltura\Client\Plugin\Metadata\Type\CompareMetadataCondition',
		'KalturaConfMapsBaseFilter' => 'Kaltura\Client\Plugin\ConfMaps\Type\ConfMapsBaseFilter',
		'KalturaControlPanelCommandFilter' => 'Kaltura\Client\Type\ControlPanelCommandFilter',
		'KalturaConversionProfileAssetParamsBaseFilter' => 'Kaltura\Client\Type\ConversionProfileAssetParamsBaseFilter',
		'KalturaConversionProfileBaseFilter' => 'Kaltura\Client\Type\ConversionProfileBaseFilter',
		'KalturaConvertCollectionJobData' => 'Kaltura\Client\Type\ConvertCollectionJobData',
		'KalturaConvertJobData' => 'Kaltura\Client\Type\ConvertJobData',
		'KalturaCountryCondition' => 'Kaltura\Client\Type\CountryCondition',
		'KalturaCrossKalturaDistributionJobProviderData' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionJobProviderData',
		'KalturaCrossKalturaDistributionProfile' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionProfile',
		'KalturaCuePointBaseFilter' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePointBaseFilter',
		'KalturaDailymotionDistributionJobProviderData' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionJobProviderData',
		'KalturaDailymotionDistributionProfile' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionProfile',
		'KalturaDeliveryProfileAkamaiHttp' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHttp',
		'KalturaDeliveryProfileFilter' => 'Kaltura\Client\Type\DeliveryProfileFilter',
		'KalturaDeliveryProfileGenericHttp' => 'Kaltura\Client\Type\DeliveryProfileGenericHttp',
		'KalturaDeliveryProfileGenericRtmp' => 'Kaltura\Client\Type\DeliveryProfileGenericRtmp',
		'KalturaDeliveryProfileLivePackagerHls' => 'Kaltura\Client\Type\DeliveryProfileLivePackagerHls',
		'KalturaDeliveryProfileVodPackagerPlayServer' => 'Kaltura\Client\Type\DeliveryProfileVodPackagerPlayServer',
		'KalturaDistributionDeleteJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionDeleteJobData',
		'KalturaDistributionFetchReportJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionFetchReportJobData',
		'KalturaDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProfileFilter',
		'KalturaDistributionProviderFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionProviderFilter',
		'KalturaDistributionSubmitJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionSubmitJobData',
		'KalturaDistributionUpdateJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionUpdateJobData',
		'KalturaDistributionValidationErrorInvalidMetadata' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionValidationErrorInvalidMetadata',
		'KalturaDocumentFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParams',
		'KalturaDoubleClickDistributionProfile' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionProfile',
		'KalturaDrmPolicyFilter' => 'Kaltura\Client\Plugin\Drm\Type\DrmPolicyFilter',
		'KalturaDrmProfileFilter' => 'Kaltura\Client\Plugin\Drm\Type\DrmProfileFilter',
		'KalturaDropFolderFileFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileFilter',
		'KalturaDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFilter',
		'KalturaDynamicObjectSearchItem' => 'Kaltura\Client\Plugin\Metadata\Type\DynamicObjectSearchItem',
		'KalturaESearchAbstractCategoryItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAbstractCategoryItem',
		'KalturaESearchAbstractEntryItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAbstractEntryItem',
		'KalturaESearchAbstractGroupItem' => 'Kaltura\Client\Plugin\Group\Type\ESearchAbstractGroupItem',
		'KalturaESearchAbstractUserItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchAbstractUserItem',
		'KalturaEdgeServerNode' => 'Kaltura\Client\Type\EdgeServerNode',
		'KalturaEmailNotificationDispatchJobData' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationDispatchJobData',
		'KalturaEndUserReportInputFilter' => 'Kaltura\Client\Type\EndUserReportInputFilter',
		'KalturaEntryDistributionBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistributionBaseFilter',
		'KalturaEntryIndexAdvancedFilter' => 'Kaltura\Client\Type\EntryIndexAdvancedFilter',
		'KalturaEntryReferrerLiveStats' => 'Kaltura\Client\Type\EntryReferrerLiveStats',
		'KalturaEntryResource' => 'Kaltura\Client\Type\EntryResource',
		'KalturaEntryServerNodeFilter' => 'Kaltura\Client\Type\EntryServerNodeFilter',
		'KalturaEntryVendorTaskBaseFilter' => 'Kaltura\Client\Plugin\Reach\Type\EntryVendorTaskBaseFilter',
		'KalturaEntryVendorTaskFilter' => 'Kaltura\Client\Plugin\Reach\Type\EntryVendorTaskFilter',
		'KalturaEntryVendorTaskCsvJobData' => 'Kaltura\Client\Plugin\Reach\Type\EntryVendorTaskCsvJobData',
		'KalturaEventNotificationDispatchScope' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationDispatchScope',
		'KalturaEventNotificationTemplateFilter' => 'Kaltura\Client\Plugin\EventNotification\Type\EventNotificationTemplateFilter',
		'KalturaExtractMediaJobData' => 'Kaltura\Client\Type\ExtractMediaJobData',
		'KalturaFacebookDistributionJobProviderData' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionJobProviderData',
		'KalturaFacebookDistributionProfile' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProfile',
		'KalturaFairPlayPlaybackPluginData' => 'Kaltura\Client\Type\FairPlayPlaybackPluginData',
		'KalturaIntegerField' => 'Kaltura\Client\Type\IntegerField',
		'KalturaFieldCompareCondition' => 'Kaltura\Client\Type\FieldCompareCondition',
		'KalturaStringField' => 'Kaltura\Client\Type\StringField',
		'KalturaFieldMatchCondition' => 'Kaltura\Client\Type\FieldMatchCondition',
		'KalturaFileAssetBaseFilter' => 'Kaltura\Client\Type\FileAssetBaseFilter',
		'KalturaFileSyncFilter' => 'Kaltura\Client\Plugin\FileSync\Type\FileSyncFilter',
		'KalturaFileSyncResource' => 'Kaltura\Client\Type\FileSyncResource',
		'KalturaFreewheelGenericDistributionJobProviderData' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionJobProviderData',
		'KalturaFreewheelGenericDistributionProfile' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionProfile',
		'KalturaFtpDistributionJobProviderData' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionJobProviderData',
		'KalturaFtpDistributionProfile' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionProfile',
		'KalturaFtpDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\FtpDropFolder',
		'KalturaFtpScheduledDistributionProvider' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpScheduledDistributionProvider',
		'KalturaGenericDistributionProviderActionFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderActionFilter',
		'KalturaGenericXsltSyndicationFeed' => 'Kaltura\Client\Type\GenericXsltSyndicationFeed',
		'KalturaGeoDistanceCondition' => 'Kaltura\Client\Type\GeoDistanceCondition',
		'KalturaGeoTimeLiveStats' => 'Kaltura\Client\Type\GeoTimeLiveStats',
		'KalturaGroupUserBaseFilter' => 'Kaltura\Client\Type\GroupUserBaseFilter',
		'KalturaHttpNotificationDispatchJobData' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationDispatchJobData',
		'KalturaHuluDistributionJobProviderData' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionJobProviderData',
		'KalturaHuluDistributionProfile' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionProfile',
		'KalturaIdeticDistributionJobProviderData' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionJobProviderData',
		'KalturaIdeticDistributionProfile' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProfile',
		'KalturaImageFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParams',
		'KalturaIpAddressCondition' => 'Kaltura\Client\Type\IpAddressCondition',
		'KalturaLikeBaseFilter' => 'Kaltura\Client\Plugin\Like\Type\LikeBaseFilter',
		'KalturaLiveAsset' => 'Kaltura\Client\Type\LiveAsset',
		'KalturaLiveChannelSegmentBaseFilter' => 'Kaltura\Client\Type\LiveChannelSegmentBaseFilter',
		'KalturaLiveParams' => 'Kaltura\Client\Type\LiveParams',
		'KalturaMappedObjectsCsvJobData' => 'Kaltura\Client\Type\MappedObjectsCsvJobData',
		'KalturaMatchMetadataCondition' => 'Kaltura\Client\Plugin\Metadata\Type\MatchMetadataCondition',
		'KalturaMediaEsearchExportToCsvJobData' => 'Kaltura\Client\Plugin\ElasticSearch\Type\MediaEsearchExportToCsvJobData',
		'KalturaMediaFlavorParams' => 'Kaltura\Client\Type\MediaFlavorParams',
		'KalturaMediaInfoFilter' => 'Kaltura\Client\Type\MediaInfoFilter',
		'KalturaMediaServerNode' => 'Kaltura\Client\Type\MediaServerNode',
		'KalturaMeetingScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\MeetingScheduleEvent',
		'KalturaMetadataBaseFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataBaseFilter',
		'KalturaMetadataFieldChangedCondition' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataFieldChangedCondition',
		'KalturaMetadataProfileFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataProfileFilter',
		'KalturaMetadataSearchItem' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataSearchItem',
		'KalturaMetroPcsDistributionJobProviderData' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionJobProviderData',
		'KalturaMetroPcsDistributionProfile' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionProfile',
		'KalturaMsnDistributionJobProviderData' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionJobProviderData',
		'KalturaMsnDistributionProfile' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionProfile',
		'KalturaOperationResource' => 'Kaltura\Client\Type\OperationResource',
		'KalturaPartnerFilter' => 'Kaltura\Client\Type\PartnerFilter',
		'KalturaPdfFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParams',
		'KalturaPermissionBaseFilter' => 'Kaltura\Client\Type\PermissionBaseFilter',
		'KalturaPermissionItemBaseFilter' => 'Kaltura\Client\Type\PermissionItemBaseFilter',
		'KalturaPlaybackContextOptions' => 'Kaltura\Client\Type\PlaybackContextOptions',
		'KalturaPostConvertJobData' => 'Kaltura\Client\Type\PostConvertJobData',
		'KalturaPreviewRestriction' => 'Kaltura\Client\Type\PreviewRestriction',
		'KalturaQuickPlayDistributionJobProviderData' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionJobProviderData',
		'KalturaQuickPlayDistributionProfile' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionProfile',
		'KalturaQuizFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuizFilter',
		'KalturaRatingCountBaseFilter' => 'Kaltura\Client\Plugin\Rating\Type\RatingCountBaseFilter',
		'KalturaReachProfileBaseFilter' => 'Kaltura\Client\Plugin\Reach\Type\ReachProfileBaseFilter',
		'KalturaReachReportInputFilter' => 'Kaltura\Client\Plugin\Reach\Type\ReachReportInputFilter',
		'KalturaRecalculateResponseProfileCacheJobData' => 'Kaltura\Client\Type\RecalculateResponseProfileCacheJobData',
		'KalturaRecordScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\RecordScheduleEvent',
		'KalturaRegexCondition' => 'Kaltura\Client\Type\RegexCondition',
		'KalturaRemoteStorageResources' => 'Kaltura\Client\Type\RemoteStorageResources',
		'KalturaResponseProfileFilter' => 'Kaltura\Client\Type\ResponseProfileFilter',
		'KalturaScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventBaseFilter',
		'KalturaScheduleEventResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResourceBaseFilter',
		'KalturaScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResourceBaseFilter',
		'KalturaScheduledTaskProfileFilter' => 'Kaltura\Client\Plugin\ScheduledTask\Type\ScheduledTaskProfileFilter',
		'KalturaSearchComparableAttributeCondition' => 'Kaltura\Client\Type\SearchComparableAttributeCondition',
		'KalturaSearchComparableCondition' => 'Kaltura\Client\Type\SearchComparableCondition',
		'KalturaSearchMatchAttributeCondition' => 'Kaltura\Client\Type\SearchMatchAttributeCondition',
		'KalturaSearchMatchCondition' => 'Kaltura\Client\Type\SearchMatchCondition',
		'KalturaServerNodeFilter' => 'Kaltura\Client\Type\ServerNodeFilter',
		'KalturaShortLinkFilter' => 'Kaltura\Client\Plugin\ShortLink\Type\ShortLinkFilter',
		'KalturaSiteCondition' => 'Kaltura\Client\Type\SiteCondition',
		'KalturaSshDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\SshDropFolder',
		'KalturaSshImportJobData' => 'Kaltura\Client\Type\SshImportJobData',
		'KalturaSsoBaseFilter' => 'Kaltura\Client\Plugin\Sso\Type\SsoBaseFilter',
		'KalturaStorageDeleteJobData' => 'Kaltura\Client\Type\StorageDeleteJobData',
		'KalturaStorageExportJobData' => 'Kaltura\Client\Type\StorageExportJobData',
		'KalturaStorageProfileFilter' => 'Kaltura\Client\Type\StorageProfileFilter',
		'KalturaStringResource' => 'Kaltura\Client\Type\StringResource',
		'KalturaSwfFlavorParams' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParams',
		'KalturaTimeRangeVendorCredit' => 'Kaltura\Client\Plugin\Reach\Type\TimeRangeVendorCredit',
		'KalturaTimedThumbAsset' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\TimedThumbAsset',
		'KalturaTranslationVendorTaskData' => 'Kaltura\Client\Plugin\Reach\Type\TranslationVendorTaskData',
		'KalturaUiConfFilter' => 'Kaltura\Client\Type\UiConfFilter',
		'KalturaUnicornDistributionJobProviderData' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionJobProviderData',
		'KalturaUnicornDistributionProfile' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionProfile',
		'KalturaUploadTokenFilter' => 'Kaltura\Client\Type\UploadTokenFilter',
		'KalturaUserEntryBaseFilter' => 'Kaltura\Client\Type\UserEntryBaseFilter',
		'KalturaUserLoginDataBaseFilter' => 'Kaltura\Client\Type\UserLoginDataBaseFilter',
		'KalturaUserRoleBaseFilter' => 'Kaltura\Client\Type\UserRoleBaseFilter',
		'KalturaVelocixProvisionJobData' => 'Kaltura\Client\Plugin\Velocix\Type\VelocixProvisionJobData',
		'KalturaVendorCatalogItemBaseFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorCatalogItemBaseFilter',
		'KalturaVendorLiveCaptionCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorLiveCaptionCatalogItem',
		'KalturaVendorTranslationCatalogItem' => 'Kaltura\Client\Plugin\Reach\Type\VendorTranslationCatalogItem',
		'KalturaVirtualEventFilter' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualEventFilter',
		'KalturaVirusScanProfileFilter' => 'Kaltura\Client\Plugin\VirusScan\Type\VirusScanProfileFilter',
		'KalturaVodScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\VodScheduleEvent',
		'KalturaWebexDropFolderContentProcessorJobData' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolderContentProcessorJobData',
		'KalturaWidevineFlavorAsset' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorAsset',
		'KalturaWidevineFlavorParams' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorParams',
		'KalturaWidgetFilter' => 'Kaltura\Client\Type\WidgetFilter',
		'KalturaYahooDistributionJobProviderData' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionJobProviderData',
		'KalturaYahooDistributionProfile' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionProfile',
		'KalturaYouTubeDistributionJobProviderData' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionJobProviderData',
		'KalturaYouTubeDistributionProfile' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionProfile',
		'KalturaYoutubeApiDistributionJobProviderData' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionJobProviderData',
		'KalturaYoutubeApiDistributionProfile' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProfile',
		'KalturaAccessControlFilter' => 'Kaltura\Client\Type\AccessControlFilter',
		'KalturaAccessControlProfileFilter' => 'Kaltura\Client\Type\AccessControlProfileFilter',
		'KalturaActionNameCondition' => 'Kaltura\Client\Type\ActionNameCondition',
		'KalturaActivitiBusinessProcessServerBaseFilter' => 'Kaltura\Client\Plugin\ActivitiBusinessProcessNotification\Type\ActivitiBusinessProcessServerBaseFilter',
		'KalturaAmazonS3StorageExportJobData' => 'Kaltura\Client\Type\AmazonS3StorageExportJobData',
		'KalturaAmazonS3StorageProfileBaseFilter' => 'Kaltura\Client\Type\AmazonS3StorageProfileBaseFilter',
		'KalturaAnonymousIPContextField' => 'Kaltura\Client\Type\AnonymousIPContextField',
		'KalturaAssetParamsFilter' => 'Kaltura\Client\Type\AssetParamsFilter',
		'KalturaAuditTrailFilter' => 'Kaltura\Client\Plugin\Audit\Type\AuditTrailFilter',
		'KalturaAvnDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\AvnDistribution\Type\AvnDistributionProviderBaseFilter',
		'KalturaBaseEntryCompareAttributeCondition' => 'Kaltura\Client\Type\BaseEntryCompareAttributeCondition',
		'KalturaBaseEntryMatchAttributeCondition' => 'Kaltura\Client\Type\BaseEntryMatchAttributeCondition',
		'KalturaBatchJobFilterExt' => 'Kaltura\Client\Type\BatchJobFilterExt',
		'KalturaBeaconScheduledResourceItem' => 'Kaltura\Client\Plugin\Beacon\Type\BeaconScheduledResourceItem',
		'KalturaBulkUploadICalJobData' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadICalJobData',
		'KalturaBulkUploadScheduleEventCsvJobData' => 'Kaltura\Client\Plugin\ScheduleBulkUpload\Type\BulkUploadScheduleEventCsvJobData',
		'KalturaBusinessProcessNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessNotificationTemplateBaseFilter',
		'KalturaCategoryFilter' => 'Kaltura\Client\Type\CategoryFilter',
		'KalturaCategoriesCsvJobData' => 'Kaltura\Client\Type\CategoriesCsvJobData',
		'KalturaCategoryEntryFilter' => 'Kaltura\Client\Type\CategoryEntryFilter',
		'KalturaComcastMrssDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ComcastMrssDistribution\Type\ComcastMrssDistributionProviderBaseFilter',
		'KalturaConfMapsFilter' => 'Kaltura\Client\Plugin\ConfMaps\Type\ConfMapsFilter',
		'KalturaConferenceEntryServerNodeBaseFilter' => 'Kaltura\Client\Plugin\Conference\Type\ConferenceEntryServerNodeBaseFilter',
		'KalturaConferenceServerNodeBaseFilter' => 'Kaltura\Client\Plugin\Conference\Type\ConferenceServerNodeBaseFilter',
		'KalturaConfigurableDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionProfileBaseFilter',
		'KalturaConstantXsltSyndicationFeed' => 'Kaltura\Client\Type\ConstantXsltSyndicationFeed',
		'KalturaConversionProfileFilter' => 'Kaltura\Client\Type\ConversionProfileFilter',
		'KalturaConversionProfileAssetParamsFilter' => 'Kaltura\Client\Type\ConversionProfileAssetParamsFilter',
		'KalturaCoordinatesContextField' => 'Kaltura\Client\Type\CoordinatesContextField',
		'KalturaCountryContextField' => 'Kaltura\Client\Type\CountryContextField',
		'KalturaCrossKalturaDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionProviderBaseFilter',
		'KalturaCuePointFilter' => 'Kaltura\Client\Plugin\CuePoint\Type\CuePointFilter',
		'KalturaDailymotionDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionProviderBaseFilter',
		'KalturaDataEntryCompareAttributeCondition' => 'Kaltura\Client\Type\DataEntryCompareAttributeCondition',
		'KalturaDataEntryMatchAttributeCondition' => 'Kaltura\Client\Type\DataEntryMatchAttributeCondition',
		'KalturaDeliveryProfileAkamaiAppleHttpManifestBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiAppleHttpManifestBaseFilter',
		'KalturaDeliveryProfileAkamaiHdsBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHdsBaseFilter',
		'KalturaDeliveryProfileAkamaiHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHttpBaseFilter',
		'KalturaDeliveryProfileGenericAppleHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericAppleHttpBaseFilter',
		'KalturaDeliveryProfileGenericHdsBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHdsBaseFilter',
		'KalturaDeliveryProfileGenericHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHttpBaseFilter',
		'KalturaDeliveryProfileGenericSilverLightBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericSilverLightBaseFilter',
		'KalturaDeliveryProfileLiveAppleHttpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileLiveAppleHttpBaseFilter',
		'KalturaDeliveryProfileRtmpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileRtmpBaseFilter',
		'KalturaDeliveryProfileVodPackagerHls' => 'Kaltura\Client\Type\DeliveryProfileVodPackagerHls',
		'KalturaDeliveryServerNodeBaseFilter' => 'Kaltura\Client\Type\DeliveryServerNodeBaseFilter',
		'KalturaDistributionDisableJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionDisableJobData',
		'KalturaDistributionEnableJobData' => 'Kaltura\Client\Plugin\ContentDistribution\Type\DistributionEnableJobData',
		'KalturaDocumentEntryCompareAttributeCondition' => 'Kaltura\Client\Type\DocumentEntryCompareAttributeCondition',
		'KalturaDocumentEntryMatchAttributeCondition' => 'Kaltura\Client\Type\DocumentEntryMatchAttributeCondition',
		'KalturaDocumentFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsOutput',
		'KalturaDoubleClickDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionProviderBaseFilter',
		'KalturaDropFolderImportJobData' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderImportJobData',
		'KalturaDropFolderXmlBulkUploadJobData' => 'Kaltura\Client\Plugin\DropFolderXmlBulkUpload\Type\DropFolderXmlBulkUploadJobData',
		'KalturaESearchCategoryEntryItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryEntryItem',
		'KalturaESearchCategoryItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryItem',
		'KalturaESearchCategoryMetadataItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryMetadataItem',
		'KalturaESearchCategoryUserItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCategoryUserItem',
		'KalturaESearchEntryItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryItem',
		'KalturaESearchGroupItem' => 'Kaltura\Client\Plugin\Group\Type\ESearchGroupItem',
		'KalturaESearchGroupMetadataItem' => 'Kaltura\Client\Plugin\Group\Type\ESearchGroupMetadataItem',
		'KalturaESearchGroupUserItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchGroupUserItem',
		'KalturaESearchUnifiedItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUnifiedItem',
		'KalturaESearchUserItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserItem',
		'KalturaESearchUserMetadataItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchUserMetadataItem',
		'KalturaEmailNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationTemplateBaseFilter',
		'KalturaEntriesCsvJobData' => 'Kaltura\Client\Type\EntriesCsvJobData',
		'KalturaEntryDistributionFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\EntryDistributionFilter',
		'KalturaEvalBooleanField' => 'Kaltura\Client\Type\EvalBooleanField',
		'KalturaEvalStringField' => 'Kaltura\Client\Type\EvalStringField',
		'KalturaExternalMediaEntryCompareAttributeCondition' => 'Kaltura\Client\Type\ExternalMediaEntryCompareAttributeCondition',
		'KalturaExternalMediaEntryMatchAttributeCondition' => 'Kaltura\Client\Type\ExternalMediaEntryMatchAttributeCondition',
		'KalturaFacebookDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProviderBaseFilter',
		'KalturaFileAssetFilter' => 'Kaltura\Client\Type\FileAssetFilter',
		'KalturaFreewheelDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionProfileBaseFilter',
		'KalturaFreewheelDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionProviderBaseFilter',
		'KalturaFreewheelGenericDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionProviderBaseFilter',
		'KalturaFtpDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionProviderBaseFilter',
		'KalturaGenericDataCenterContentResource' => 'Kaltura\Client\Type\GenericDataCenterContentResource',
		'KalturaGenericDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfileBaseFilter',
		'KalturaGenericDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderBaseFilter',
		'KalturaGenericSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\GenericSyndicationFeedBaseFilter',
		'KalturaGoogleVideoSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\GoogleVideoSyndicationFeedBaseFilter',
		'KalturaGroupUserFilter' => 'Kaltura\Client\Type\GroupUserFilter',
		'KalturaHttpHeaderCondition' => 'Kaltura\Client\Type\HttpHeaderCondition',
		'KalturaHttpNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationTemplateBaseFilter',
		'KalturaHuluDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionProviderBaseFilter',
		'KalturaITunesSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\ITunesSyndicationFeedBaseFilter',
		'KalturaIdeticDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProviderBaseFilter',
		'KalturaImageFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsOutput',
		'KalturaIpAddressContextField' => 'Kaltura\Client\Type\IpAddressContextField',
		'KalturaKontikiStorageDeleteJobData' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageDeleteJobData',
		'KalturaKontikiStorageExportJobData' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageExportJobData',
		'KalturaKontikiStorageProfileBaseFilter' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageProfileBaseFilter',
		'KalturaLikeFilter' => 'Kaltura\Client\Plugin\Like\Type\LikeFilter',
		'KalturaLiveChannelCompareAttributeCondition' => 'Kaltura\Client\Type\LiveChannelCompareAttributeCondition',
		'KalturaLiveChannelMatchAttributeCondition' => 'Kaltura\Client\Type\LiveChannelMatchAttributeCondition',
		'KalturaLiveChannelSegmentFilter' => 'Kaltura\Client\Type\LiveChannelSegmentFilter',
		'KalturaLiveClusterMediaServerNode' => 'Kaltura\Client\Plugin\LiveCluster\Type\LiveClusterMediaServerNode',
		'KalturaLiveEntryCompareAttributeCondition' => 'Kaltura\Client\Type\LiveEntryCompareAttributeCondition',
		'KalturaLiveEntryMatchAttributeCondition' => 'Kaltura\Client\Type\LiveEntryMatchAttributeCondition',
		'KalturaLiveEntryServerNodeBaseFilter' => 'Kaltura\Client\Type\LiveEntryServerNodeBaseFilter',
		'KalturaLiveRedirectScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\LiveRedirectScheduleEvent',
		'KalturaLiveStreamAdminEntryCompareAttributeCondition' => 'Kaltura\Client\Type\LiveStreamAdminEntryCompareAttributeCondition',
		'KalturaLiveStreamAdminEntryMatchAttributeCondition' => 'Kaltura\Client\Type\LiveStreamAdminEntryMatchAttributeCondition',
		'KalturaLiveStreamEntryCompareAttributeCondition' => 'Kaltura\Client\Type\LiveStreamEntryCompareAttributeCondition',
		'KalturaLiveStreamEntryMatchAttributeCondition' => 'Kaltura\Client\Type\LiveStreamEntryMatchAttributeCondition',
		'KalturaLiveStreamScheduleEvent' => 'Kaltura\Client\Plugin\Schedule\Type\LiveStreamScheduleEvent',
		'KalturaMediaEntryCompareAttributeCondition' => 'Kaltura\Client\Type\MediaEntryCompareAttributeCondition',
		'KalturaMediaEntryMatchAttributeCondition' => 'Kaltura\Client\Type\MediaEntryMatchAttributeCondition',
		'KalturaMediaFlavorParamsOutput' => 'Kaltura\Client\Type\MediaFlavorParamsOutput',
		'KalturaMetadataField' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataField',
		'KalturaMetadataFilter' => 'Kaltura\Client\Plugin\Metadata\Type\MetadataFilter',
		'KalturaMetroPcsDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionProviderBaseFilter',
		'KalturaMixEntryCompareAttributeCondition' => 'Kaltura\Client\Type\MixEntryCompareAttributeCondition',
		'KalturaMixEntryMatchAttributeCondition' => 'Kaltura\Client\Type\MixEntryMatchAttributeCondition',
		'KalturaMsnDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionProviderBaseFilter',
		'KalturaObjectIdField' => 'Kaltura\Client\Type\ObjectIdField',
		'KalturaPdfFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsOutput',
		'KalturaPermissionFilter' => 'Kaltura\Client\Type\PermissionFilter',
		'KalturaPermissionItemFilter' => 'Kaltura\Client\Type\PermissionItemFilter',
		'KalturaPlayReadyPolicyBaseFilter' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyPolicyBaseFilter',
		'KalturaPlayReadyProfileBaseFilter' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyProfileBaseFilter',
		'KalturaPlayableEntryCompareAttributeCondition' => 'Kaltura\Client\Type\PlayableEntryCompareAttributeCondition',
		'KalturaPlayableEntryMatchAttributeCondition' => 'Kaltura\Client\Type\PlayableEntryMatchAttributeCondition',
		'KalturaPlaylistCompareAttributeCondition' => 'Kaltura\Client\Type\PlaylistCompareAttributeCondition',
		'KalturaPlaylistMatchAttributeCondition' => 'Kaltura\Client\Type\PlaylistMatchAttributeCondition',
		'KalturaPodcastDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionProfileBaseFilter',
		'KalturaPodcastDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionProviderBaseFilter',
		'KalturaPushNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\PushNotification\Type\PushNotificationTemplateBaseFilter',
		'KalturaQuickPlayDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionProviderBaseFilter',
		'KalturaRatingCountFilter' => 'Kaltura\Client\Plugin\Rating\Type\RatingCountFilter',
		'KalturaReachProfileFilter' => 'Kaltura\Client\Plugin\Reach\Type\ReachProfileFilter',
		'KalturaRemoteDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\RemoteDropFolderBaseFilter',
		'KalturaReoccurringVendorCredit' => 'Kaltura\Client\Plugin\Reach\Type\ReoccurringVendorCredit',
		'KalturaScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventFilter',
		'KalturaScheduleEventResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleEventResourceFilter',
		'KalturaScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\ScheduleResourceFilter',
		'KalturaScpDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\ScpDropFolder',
		'KalturaSftpDropFolder' => 'Kaltura\Client\Plugin\DropFolder\Type\SftpDropFolder',
		'KalturaSipEntryServerNodeBaseFilter' => 'Kaltura\Client\Plugin\Sip\Type\SipEntryServerNodeBaseFilter',
		'KalturaSipServerNodeBaseFilter' => 'Kaltura\Client\Plugin\Sip\Type\SipServerNodeBaseFilter',
		'KalturaSshUrlResource' => 'Kaltura\Client\Type\SshUrlResource',
		'KalturaSsoFilter' => 'Kaltura\Client\Plugin\Sso\Type\SsoFilter',
		'KalturaSwfFlavorParamsOutput' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsOutput',
		'KalturaSyndicationDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProfileBaseFilter',
		'KalturaSyndicationDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProviderBaseFilter',
		'KalturaSystemPartnerFilter' => 'Kaltura\Client\Plugin\SystemPartner\Type\SystemPartnerFilter',
		'KalturaTimeContextField' => 'Kaltura\Client\Type\TimeContextField',
		'KalturaTubeMogulSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\TubeMogulSyndicationFeedBaseFilter',
		'KalturaUiConfAdminBaseFilter' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdminBaseFilter',
		'KalturaUnicornDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionProviderBaseFilter',
		'KalturaUserAgentCondition' => 'Kaltura\Client\Type\UserAgentCondition',
		'KalturaUserAgentContextField' => 'Kaltura\Client\Type\UserAgentContextField',
		'KalturaUserEmailContextField' => 'Kaltura\Client\Type\UserEmailContextField',
		'KalturaUserEntryFilter' => 'Kaltura\Client\Type\UserEntryFilter',
		'KalturaUserLoginDataFilter' => 'Kaltura\Client\Type\UserLoginDataFilter',
		'KalturaUserRoleFilter' => 'Kaltura\Client\Type\UserRoleFilter',
		'KalturaUsersCsvJobData' => 'Kaltura\Client\Type\UsersCsvJobData',
		'KalturaVarConsolePartnerFilter' => 'Kaltura\Client\Plugin\VarConsole\Type\VarConsolePartnerFilter',
		'KalturaVendorCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorCatalogItemFilter',
		'KalturaWebcamTokenResource' => 'Kaltura\Client\Type\WebcamTokenResource',
		'KalturaWebexDropFolderBaseFilter' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolderBaseFilter',
		'KalturaWebexDropFolderFileBaseFilter' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolderFileBaseFilter',
		'KalturaWidevineFlavorParamsOutput' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorParamsOutput',
		'KalturaWidevineProfileBaseFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineProfileBaseFilter',
		'KalturaWowzaMediaServerNode' => 'Kaltura\Client\Plugin\Wowza\Type\WowzaMediaServerNode',
		'KalturaYahooDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionProviderBaseFilter',
		'KalturaYahooSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\YahooSyndicationFeedBaseFilter',
		'KalturaYouTubeDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionProviderBaseFilter',
		'KalturaYoutubeApiDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProviderBaseFilter',
		'KalturaActivitiBusinessProcessServerFilter' => 'Kaltura\Client\Plugin\ActivitiBusinessProcessNotification\Type\ActivitiBusinessProcessServerFilter',
		'KalturaAdCuePointBaseFilter' => 'Kaltura\Client\Plugin\AdCuePoint\Type\AdCuePointBaseFilter',
		'KalturaAmazonS3StorageProfileFilter' => 'Kaltura\Client\Type\AmazonS3StorageProfileFilter',
		'KalturaAnnotationBaseFilter' => 'Kaltura\Client\Plugin\Annotation\Type\AnnotationBaseFilter',
		'KalturaAnswerCuePointBaseFilter' => 'Kaltura\Client\Plugin\Quiz\Type\AnswerCuePointBaseFilter',
		'KalturaApiActionPermissionItemBaseFilter' => 'Kaltura\Client\Type\ApiActionPermissionItemBaseFilter',
		'KalturaApiParameterPermissionItemBaseFilter' => 'Kaltura\Client\Type\ApiParameterPermissionItemBaseFilter',
		'KalturaAssetParamsOutputBaseFilter' => 'Kaltura\Client\Type\AssetParamsOutputBaseFilter',
		'KalturaAttachmentAssetBaseFilter' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAssetBaseFilter',
		'KalturaAvnDistributionProviderFilter' => 'Kaltura\Client\Plugin\AvnDistribution\Type\AvnDistributionProviderFilter',
		'KalturaBusinessProcessNotificationTemplateFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessNotificationTemplateFilter',
		'KalturaCameraScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\CameraScheduleResourceBaseFilter',
		'KalturaCaptionAssetBaseFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAssetBaseFilter',
		'KalturaCaptionParamsBaseFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParamsBaseFilter',
		'KalturaCodeCuePointBaseFilter' => 'Kaltura\Client\Plugin\CodeCuePoint\Type\CodeCuePointBaseFilter',
		'KalturaComcastMrssDistributionProviderFilter' => 'Kaltura\Client\Plugin\ComcastMrssDistribution\Type\ComcastMrssDistributionProviderFilter',
		'KalturaConferenceEntryServerNodeFilter' => 'Kaltura\Client\Plugin\Conference\Type\ConferenceEntryServerNodeFilter',
		'KalturaConferenceServerNodeFilter' => 'Kaltura\Client\Plugin\Conference\Type\ConferenceServerNodeFilter',
		'KalturaConfigurableDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\ConfigurableDistributionProfileFilter',
		'KalturaCrossKalturaDistributionProviderFilter' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionProviderFilter',
		'KalturaDailymotionDistributionProviderFilter' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionProviderFilter',
		'KalturaDataEntryBaseFilter' => 'Kaltura\Client\Type\DataEntryBaseFilter',
		'KalturaDeliveryProfileAkamaiAppleHttpManifestFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiAppleHttpManifestFilter',
		'KalturaDeliveryProfileAkamaiHdsFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHdsFilter',
		'KalturaDeliveryProfileAkamaiHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileAkamaiHttpFilter',
		'KalturaDeliveryProfileGenericAppleHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericAppleHttpFilter',
		'KalturaDeliveryProfileGenericHdsFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHdsFilter',
		'KalturaDeliveryProfileGenericHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericHttpFilter',
		'KalturaDeliveryProfileGenericSilverLightFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericSilverLightFilter',
		'KalturaDeliveryProfileLiveAppleHttpFilter' => 'Kaltura\Client\Type\DeliveryProfileLiveAppleHttpFilter',
		'KalturaDeliveryProfileRtmpFilter' => 'Kaltura\Client\Type\DeliveryProfileRtmpFilter',
		'KalturaDeliveryServerNodeFilter' => 'Kaltura\Client\Type\DeliveryServerNodeFilter',
		'KalturaDocumentEntryBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentEntryBaseFilter',
		'KalturaDoubleClickDistributionProviderFilter' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionProviderFilter',
		'KalturaDropFolderFileResource' => 'Kaltura\Client\Plugin\DropFolder\Type\DropFolderFileResource',
		'KalturaESearchEntryAbstractNestedItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryAbstractNestedItem',
		'KalturaESearchNestedOperator' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchNestedOperator',
		'KalturaEmailNotificationTemplateFilter' => 'Kaltura\Client\Plugin\EmailNotification\Type\EmailNotificationTemplateFilter',
		'KalturaEntryScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\EntryScheduleEventBaseFilter',
		'KalturaEventCuePointBaseFilter' => 'Kaltura\Client\Plugin\EventCuePoint\Type\EventCuePointBaseFilter',
		'KalturaFacebookDistributionProviderFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProviderFilter',
		'KalturaFlavorAssetBaseFilter' => 'Kaltura\Client\Type\FlavorAssetBaseFilter',
		'KalturaFlavorParamsBaseFilter' => 'Kaltura\Client\Type\FlavorParamsBaseFilter',
		'KalturaFreewheelDistributionProfileFilter' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionProfileFilter',
		'KalturaFreewheelDistributionProviderFilter' => 'Kaltura\Client\Plugin\FreewheelDistribution\Type\FreewheelDistributionProviderFilter',
		'KalturaFreewheelGenericDistributionProviderFilter' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionProviderFilter',
		'KalturaFtpDistributionProviderFilter' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionProviderFilter',
		'KalturaGenericDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProfileFilter',
		'KalturaGenericDistributionProviderFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\GenericDistributionProviderFilter',
		'KalturaGenericSyndicationFeedFilter' => 'Kaltura\Client\Type\GenericSyndicationFeedFilter',
		'KalturaGoogleVideoSyndicationFeedFilter' => 'Kaltura\Client\Type\GoogleVideoSyndicationFeedFilter',
		'KalturaHttpNotificationTemplateFilter' => 'Kaltura\Client\Plugin\HttpNotification\Type\HttpNotificationTemplateFilter',
		'KalturaHuluDistributionProviderFilter' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionProviderFilter',
		'KalturaITunesSyndicationFeedFilter' => 'Kaltura\Client\Type\ITunesSyndicationFeedFilter',
		'KalturaIdeticDistributionProviderFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProviderFilter',
		'KalturaKontikiStorageProfileFilter' => 'Kaltura\Client\Plugin\Kontiki\Type\KontikiStorageProfileFilter',
		'KalturaLiveEntryScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveEntryScheduleResourceBaseFilter',
		'KalturaLiveEntryServerNodeFilter' => 'Kaltura\Client\Type\LiveEntryServerNodeFilter',
		'KalturaLocationScheduleResourceBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LocationScheduleResourceBaseFilter',
		'KalturaMetroPcsDistributionProviderFilter' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionProviderFilter',
		'KalturaMsnDistributionProviderFilter' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionProviderFilter',
		'KalturaOperaSyndicationFeed' => 'Kaltura\Client\Type\OperaSyndicationFeed',
		'KalturaPlayReadyPolicyFilter' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyPolicyFilter',
		'KalturaPlayReadyProfileFilter' => 'Kaltura\Client\Plugin\PlayReady\Type\PlayReadyProfileFilter',
		'KalturaPlaylistBaseFilter' => 'Kaltura\Client\Type\PlaylistBaseFilter',
		'KalturaPodcastDistributionProfileFilter' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionProfileFilter',
		'KalturaPodcastDistributionProviderFilter' => 'Kaltura\Client\Plugin\PodcastDistribution\Type\PodcastDistributionProviderFilter',
		'KalturaPushNotificationTemplateFilter' => 'Kaltura\Client\Plugin\PushNotification\Type\PushNotificationTemplateFilter',
		'KalturaQuestionCuePointBaseFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuestionCuePointBaseFilter',
		'KalturaQuickPlayDistributionProviderFilter' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionProviderFilter',
		'KalturaQuizUserEntryBaseFilter' => 'Kaltura\Client\Type\QuizUserEntryBaseFilter',
		'KalturaRegistrationUserEntryFilter' => 'Kaltura\Client\Plugin\Registration\Type\RegistrationUserEntryFilter',
		'KalturaRemoteDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\RemoteDropFolderFilter',
		'KalturaRokuSyndicationFeed' => 'Kaltura\Client\Type\RokuSyndicationFeed',
		'KalturaServerFileResource' => 'Kaltura\Client\Type\ServerFileResource',
		'KalturaSipEntryServerNodeFilter' => 'Kaltura\Client\Plugin\Sip\Type\SipEntryServerNodeFilter',
		'KalturaSipServerNodeFilter' => 'Kaltura\Client\Plugin\Sip\Type\SipServerNodeFilter',
		'KalturaSyndicationDistributionProfileFilter' => 'Kaltura\Client\Plugin\ContentDistribution\Type\SyndicationDistributionProfileFilter',
		'KalturaThumbAssetBaseFilter' => 'Kaltura\Client\Type\ThumbAssetBaseFilter',
		'KalturaThumbCuePointBaseFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\ThumbCuePointBaseFilter',
		'KalturaThumbParamsBaseFilter' => 'Kaltura\Client\Type\ThumbParamsBaseFilter',
		'KalturaTubeMogulSyndicationFeedFilter' => 'Kaltura\Client\Type\TubeMogulSyndicationFeedFilter',
		'KalturaUiConfAdminFilter' => 'Kaltura\Client\Plugin\AdminConsole\Type\UiConfAdminFilter',
		'KalturaUnicornDistributionProviderFilter' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionProviderFilter',
		'KalturaUploadedFileResource' => 'Kaltura\Client\Type\UploadedFileResource',
		'KalturaUploadedFileTokenResource' => 'Kaltura\Client\Type\UploadedFileTokenResource',
		'KalturaVendorCaptionsCatalogItemBaseFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorCaptionsCatalogItemBaseFilter',
		'KalturaVendorDubbingCatalogItemBaseFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorDubbingCatalogItemBaseFilter',
		'KalturaViewHistoryUserEntryFilter' => 'Kaltura\Client\Plugin\ViewHistory\Type\ViewHistoryUserEntryFilter',
		'KalturaVirtualScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualScheduleEventBaseFilter',
		'KalturaWatchLaterUserEntryFilter' => 'Kaltura\Client\Plugin\WatchLater\Type\WatchLaterUserEntryFilter',
		'KalturaWebexDropFolderFileFilter' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolderFileFilter',
		'KalturaWebexDropFolderFilter' => 'Kaltura\Client\Plugin\WebexDropFolder\Type\WebexDropFolderFilter',
		'KalturaWidevineProfileFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineProfileFilter',
		'KalturaYahooDistributionProviderFilter' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionProviderFilter',
		'KalturaYahooSyndicationFeedFilter' => 'Kaltura\Client\Type\YahooSyndicationFeedFilter',
		'KalturaYouTubeDistributionProviderFilter' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionProviderFilter',
		'KalturaYoutubeApiDistributionProviderFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProviderFilter',
		'KalturaAdCuePointFilter' => 'Kaltura\Client\Plugin\AdCuePoint\Type\AdCuePointFilter',
		'KalturaAnnotationFilter' => 'Kaltura\Client\Plugin\Annotation\Type\AnnotationFilter',
		'KalturaAnswerCuePointFilter' => 'Kaltura\Client\Plugin\Quiz\Type\AnswerCuePointFilter',
		'KalturaApiActionPermissionItemFilter' => 'Kaltura\Client\Type\ApiActionPermissionItemFilter',
		'KalturaApiParameterPermissionItemFilter' => 'Kaltura\Client\Type\ApiParameterPermissionItemFilter',
		'KalturaAssetParamsOutputFilter' => 'Kaltura\Client\Type\AssetParamsOutputFilter',
		'KalturaAttachmentAssetFilter' => 'Kaltura\Client\Plugin\Attachment\Type\AttachmentAssetFilter',
		'KalturaAvnDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\AvnDistribution\Type\AvnDistributionProfileBaseFilter',
		'KalturaBusinessProcessAbortNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessAbortNotificationTemplateBaseFilter',
		'KalturaBusinessProcessSignalNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessSignalNotificationTemplateBaseFilter',
		'KalturaBusinessProcessStartNotificationTemplateBaseFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessStartNotificationTemplateBaseFilter',
		'KalturaCameraScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\CameraScheduleResourceFilter',
		'KalturaCaptionAssetFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionAssetFilter',
		'KalturaCaptionParamsFilter' => 'Kaltura\Client\Plugin\Caption\Type\CaptionParamsFilter',
		'KalturaCodeCuePointFilter' => 'Kaltura\Client\Plugin\CodeCuePoint\Type\CodeCuePointFilter',
		'KalturaComcastMrssDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\ComcastMrssDistribution\Type\ComcastMrssDistributionProfileBaseFilter',
		'KalturaCrossKalturaDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionProfileBaseFilter',
		'KalturaDailymotionDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionProfileBaseFilter',
		'KalturaDataEntryFilter' => 'Kaltura\Client\Type\DataEntryFilter',
		'KalturaDeliveryProfileGenericRtmpBaseFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericRtmpBaseFilter',
		'KalturaDocumentEntryFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentEntryFilter',
		'KalturaDoubleClickDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionProfileBaseFilter',
		'KalturaESearchCaptionItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCaptionItem',
		'KalturaESearchCuePointItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchCuePointItem',
		'KalturaESearchEntryMetadataItem' => 'Kaltura\Client\Plugin\ElasticSearch\Type\ESearchEntryMetadataItem',
		'KalturaEdgeServerNodeBaseFilter' => 'Kaltura\Client\Type\EdgeServerNodeBaseFilter',
		'KalturaEntryScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\EntryScheduleEventFilter',
		'KalturaEventCuePointFilter' => 'Kaltura\Client\Plugin\EventCuePoint\Type\EventCuePointFilter',
		'KalturaFacebookDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProfileBaseFilter',
		'KalturaFlavorAssetFilter' => 'Kaltura\Client\Type\FlavorAssetFilter',
		'KalturaFlavorParamsFilter' => 'Kaltura\Client\Type\FlavorParamsFilter',
		'KalturaFreewheelGenericDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionProfileBaseFilter',
		'KalturaFtpDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionProfileBaseFilter',
		'KalturaFtpDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\FtpDropFolderBaseFilter',
		'KalturaFtpScheduledDistributionProviderBaseFilter' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpScheduledDistributionProviderBaseFilter',
		'KalturaGenericXsltSyndicationFeedBaseFilter' => 'Kaltura\Client\Type\GenericXsltSyndicationFeedBaseFilter',
		'KalturaHuluDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionProfileBaseFilter',
		'KalturaIdeticDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProfileBaseFilter',
		'KalturaLiveEntryScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveEntryScheduleResourceFilter',
		'KalturaLiveStreamAdminEntry' => 'Kaltura\Client\Type\LiveStreamAdminEntry',
		'KalturaLocationScheduleResourceFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LocationScheduleResourceFilter',
		'KalturaMediaServerNodeBaseFilter' => 'Kaltura\Client\Type\MediaServerNodeBaseFilter',
		'KalturaMetroPcsDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionProfileBaseFilter',
		'KalturaMsnDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionProfileBaseFilter',
		'KalturaPlaylistFilter' => 'Kaltura\Client\Type\PlaylistFilter',
		'KalturaQuestionCuePointFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuestionCuePointFilter',
		'KalturaQuickPlayDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionProfileBaseFilter',
		'KalturaQuizUserEntryFilter' => 'Kaltura\Client\Plugin\Quiz\Type\QuizUserEntryFilter',
		'KalturaSshDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SshDropFolderBaseFilter',
		'KalturaThumbAssetFilter' => 'Kaltura\Client\Type\ThumbAssetFilter',
		'KalturaThumbCuePointFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\ThumbCuePointFilter',
		'KalturaThumbParamsFilter' => 'Kaltura\Client\Type\ThumbParamsFilter',
		'KalturaUnicornDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionProfileBaseFilter',
		'KalturaVendorAlignmentCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorAlignmentCatalogItemFilter',
		'KalturaVendorAudioDescriptionCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorAudioDescriptionCatalogItemFilter',
		'KalturaVendorCaptionsCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorCaptionsCatalogItemFilter',
		'KalturaVendorChapteringCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorChapteringCatalogItemFilter',
		'KalturaVendorDubbingCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorDubbingCatalogItemFilter',
		'KalturaVendorExtendedAudioDescriptionCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorExtendedAudioDescriptionCatalogItemFilter',
		'KalturaVendorLiveCaptionCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorLiveCaptionCatalogItemFilter',
		'KalturaVirtualScheduleEventFilter' => 'Kaltura\Client\Plugin\VirtualEvent\Type\VirtualScheduleEventFilter',
		'KalturaYahooDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionProfileBaseFilter',
		'KalturaYouTubeDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionProfileBaseFilter',
		'KalturaYoutubeApiDistributionProfileBaseFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProfileBaseFilter',
		'KalturaAdminUserBaseFilter' => 'Kaltura\Client\Type\AdminUserBaseFilter',
		'KalturaAvnDistributionProfileFilter' => 'Kaltura\Client\Plugin\AvnDistribution\Type\AvnDistributionProfileFilter',
		'KalturaBusinessProcessAbortNotificationTemplateFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessAbortNotificationTemplateFilter',
		'KalturaBusinessProcessSignalNotificationTemplateFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessSignalNotificationTemplateFilter',
		'KalturaBusinessProcessStartNotificationTemplateFilter' => 'Kaltura\Client\Plugin\BusinessProcessNotification\Type\BusinessProcessStartNotificationTemplateFilter',
		'KalturaCaptionAssetItemFilter' => 'Kaltura\Client\Plugin\CaptionSearch\Type\CaptionAssetItemFilter',
		'KalturaComcastMrssDistributionProfileFilter' => 'Kaltura\Client\Plugin\ComcastMrssDistribution\Type\ComcastMrssDistributionProfileFilter',
		'KalturaCrossKalturaDistributionProfileFilter' => 'Kaltura\Client\Plugin\CrossKalturaDistribution\Type\CrossKalturaDistributionProfileFilter',
		'KalturaDailymotionDistributionProfileFilter' => 'Kaltura\Client\Plugin\DailymotionDistribution\Type\DailymotionDistributionProfileFilter',
		'KalturaDeliveryProfileGenericRtmpFilter' => 'Kaltura\Client\Type\DeliveryProfileGenericRtmpFilter',
		'KalturaDocumentFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsBaseFilter',
		'KalturaDoubleClickDistributionProfileFilter' => 'Kaltura\Client\Plugin\DoubleClickDistribution\Type\DoubleClickDistributionProfileFilter',
		'KalturaEdgeServerNodeFilter' => 'Kaltura\Client\Type\EdgeServerNodeFilter',
		'KalturaFacebookDistributionProfileFilter' => 'Kaltura\Client\Plugin\FacebookDistribution\Type\FacebookDistributionProfileFilter',
		'KalturaFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Type\FlavorParamsOutputBaseFilter',
		'KalturaFreewheelGenericDistributionProfileFilter' => 'Kaltura\Client\Plugin\FreewheelGenericDistribution\Type\FreewheelGenericDistributionProfileFilter',
		'KalturaFtpDistributionProfileFilter' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpDistributionProfileFilter',
		'KalturaFtpDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\FtpDropFolderFilter',
		'KalturaFtpScheduledDistributionProviderFilter' => 'Kaltura\Client\Plugin\FtpDistribution\Type\FtpScheduledDistributionProviderFilter',
		'KalturaGenericXsltSyndicationFeedFilter' => 'Kaltura\Client\Type\GenericXsltSyndicationFeedFilter',
		'KalturaGroupFilter' => 'Kaltura\Client\Plugin\Group\Type\GroupFilter',
		'KalturaHuluDistributionProfileFilter' => 'Kaltura\Client\Plugin\HuluDistribution\Type\HuluDistributionProfileFilter',
		'KalturaIdeticDistributionProfileFilter' => 'Kaltura\Client\Plugin\IdeticDistribution\Type\IdeticDistributionProfileFilter',
		'KalturaImageFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsBaseFilter',
		'KalturaLiveAssetBaseFilter' => 'Kaltura\Client\Type\LiveAssetBaseFilter',
		'KalturaLiveParamsBaseFilter' => 'Kaltura\Client\Type\LiveParamsBaseFilter',
		'KalturaLiveRedirectScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveRedirectScheduleEventFilter',
		'KalturaLiveStreamScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveStreamScheduleEventBaseFilter',
		'KalturaMediaFlavorParamsBaseFilter' => 'Kaltura\Client\Type\MediaFlavorParamsBaseFilter',
		'KalturaMediaServerNodeFilter' => 'Kaltura\Client\Type\MediaServerNodeFilter',
		'KalturaMeetingScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\MeetingScheduleEventBaseFilter',
		'KalturaMetroPcsDistributionProfileFilter' => 'Kaltura\Client\Plugin\MetroPcsDistribution\Type\MetroPcsDistributionProfileFilter',
		'KalturaMixEntryBaseFilter' => 'Kaltura\Client\Type\MixEntryBaseFilter',
		'KalturaMsnDistributionProfileFilter' => 'Kaltura\Client\Plugin\MsnDistribution\Type\MsnDistributionProfileFilter',
		'KalturaPdfFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsBaseFilter',
		'KalturaQuickPlayDistributionProfileFilter' => 'Kaltura\Client\Plugin\QuickPlayDistribution\Type\QuickPlayDistributionProfileFilter',
		'KalturaRecordScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\RecordScheduleEventBaseFilter',
		'KalturaSshDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SshDropFolderFilter',
		'KalturaSwfFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsBaseFilter',
		'KalturaThumbParamsOutputBaseFilter' => 'Kaltura\Client\Type\ThumbParamsOutputBaseFilter',
		'KalturaTimedThumbAssetBaseFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\TimedThumbAssetBaseFilter',
		'KalturaTranscriptAssetBaseFilter' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAssetBaseFilter',
		'KalturaUnicornDistributionProfileFilter' => 'Kaltura\Client\Plugin\UnicornDistribution\Type\UnicornDistributionProfileFilter',
		'KalturaVendorTranslationCatalogItemBaseFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorTranslationCatalogItemBaseFilter',
		'KalturaVodScheduleEventBaseFilter' => 'Kaltura\Client\Plugin\Schedule\Type\VodScheduleEventBaseFilter',
		'KalturaWidevineFlavorAssetBaseFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorAssetBaseFilter',
		'KalturaWidevineFlavorParamsBaseFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorParamsBaseFilter',
		'KalturaYahooDistributionProfileFilter' => 'Kaltura\Client\Plugin\YahooDistribution\Type\YahooDistributionProfileFilter',
		'KalturaYouTubeDistributionProfileFilter' => 'Kaltura\Client\Plugin\YouTubeDistribution\Type\YouTubeDistributionProfileFilter',
		'KalturaYoutubeApiDistributionProfileFilter' => 'Kaltura\Client\Plugin\YoutubeApiDistribution\Type\YoutubeApiDistributionProfileFilter',
		'KalturaAdminUserFilter' => 'Kaltura\Client\Type\AdminUserFilter',
		'KalturaBlackoutScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\BlackoutScheduleEventFilter',
		'KalturaDocumentFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsFilter',
		'KalturaFlavorParamsOutputFilter' => 'Kaltura\Client\Type\FlavorParamsOutputFilter',
		'KalturaImageFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsFilter',
		'KalturaLiveAssetFilter' => 'Kaltura\Client\Type\LiveAssetFilter',
		'KalturaLiveClusterMediaServerNodeBaseFilter' => 'Kaltura\Client\Plugin\LiveCluster\Type\LiveClusterMediaServerNodeBaseFilter',
		'KalturaLiveParamsFilter' => 'Kaltura\Client\Type\LiveParamsFilter',
		'KalturaLiveStreamScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\LiveStreamScheduleEventFilter',
		'KalturaMediaFlavorParamsFilter' => 'Kaltura\Client\Type\MediaFlavorParamsFilter',
		'KalturaMeetingScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\MeetingScheduleEventFilter',
		'KalturaMixEntryFilter' => 'Kaltura\Client\Type\MixEntryFilter',
		'KalturaPdfFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsFilter',
		'KalturaRecordScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\RecordScheduleEventFilter',
		'KalturaScpDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\ScpDropFolderBaseFilter',
		'KalturaSftpDropFolderBaseFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SftpDropFolderBaseFilter',
		'KalturaSwfFlavorParamsFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsFilter',
		'KalturaThumbParamsOutputFilter' => 'Kaltura\Client\Type\ThumbParamsOutputFilter',
		'KalturaTimedThumbAssetFilter' => 'Kaltura\Client\Plugin\ThumbCuePoint\Type\TimedThumbAssetFilter',
		'KalturaTranscriptAssetFilter' => 'Kaltura\Client\Plugin\Transcript\Type\TranscriptAssetFilter',
		'KalturaVendorTranslationCatalogItemFilter' => 'Kaltura\Client\Plugin\Reach\Type\VendorTranslationCatalogItemFilter',
		'KalturaVodScheduleEventFilter' => 'Kaltura\Client\Plugin\Schedule\Type\VodScheduleEventFilter',
		'KalturaWidevineFlavorAssetFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorAssetFilter',
		'KalturaWidevineFlavorParamsFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorParamsFilter',
		'KalturaWowzaMediaServerNodeBaseFilter' => 'Kaltura\Client\Plugin\Wowza\Type\WowzaMediaServerNodeBaseFilter',
		'KalturaDocumentFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsOutputBaseFilter',
		'KalturaExternalMediaEntryBaseFilter' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntryBaseFilter',
		'KalturaImageFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsOutputBaseFilter',
		'KalturaLiveClusterMediaServerNodeFilter' => 'Kaltura\Client\Plugin\LiveCluster\Type\LiveClusterMediaServerNodeFilter',
		'KalturaLiveEntryBaseFilter' => 'Kaltura\Client\Type\LiveEntryBaseFilter',
		'KalturaMediaFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Type\MediaFlavorParamsOutputBaseFilter',
		'KalturaPdfFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsOutputBaseFilter',
		'KalturaScpDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\ScpDropFolderFilter',
		'KalturaSftpDropFolderFilter' => 'Kaltura\Client\Plugin\DropFolder\Type\SftpDropFolderFilter',
		'KalturaSwfFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsOutputBaseFilter',
		'KalturaWidevineFlavorParamsOutputBaseFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorParamsOutputBaseFilter',
		'KalturaWowzaMediaServerNodeFilter' => 'Kaltura\Client\Plugin\Wowza\Type\WowzaMediaServerNodeFilter',
		'KalturaDocumentFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\DocumentFlavorParamsOutputFilter',
		'KalturaExternalMediaEntryFilter' => 'Kaltura\Client\Plugin\ExternalMedia\Type\ExternalMediaEntryFilter',
		'KalturaImageFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\ImageFlavorParamsOutputFilter',
		'KalturaLiveEntryFilter' => 'Kaltura\Client\Type\LiveEntryFilter',
		'KalturaMediaFlavorParamsOutputFilter' => 'Kaltura\Client\Type\MediaFlavorParamsOutputFilter',
		'KalturaPdfFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\PdfFlavorParamsOutputFilter',
		'KalturaSwfFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Document\Type\SwfFlavorParamsOutputFilter',
		'KalturaWidevineFlavorParamsOutputFilter' => 'Kaltura\Client\Plugin\Widevine\Type\WidevineFlavorParamsOutputFilter',
		'KalturaLiveChannelBaseFilter' => 'Kaltura\Client\Type\LiveChannelBaseFilter',
		'KalturaLiveStreamEntryBaseFilter' => 'Kaltura\Client\Type\LiveStreamEntryBaseFilter',
		'KalturaLiveChannelFilter' => 'Kaltura\Client\Type\LiveChannelFilter',
		'KalturaLiveStreamEntryFilter' => 'Kaltura\Client\Type\LiveStreamEntryFilter',
		'KalturaLiveStreamAdminEntryBaseFilter' => 'Kaltura\Client\Type\LiveStreamAdminEntryBaseFilter',
		'KalturaLiveStreamAdminEntryFilter' => 'Kaltura\Client\Type\LiveStreamAdminEntryFilter',
	);
	
	public static function getZendType($kalturaType)
	{
		if(isset(self::$map[$kalturaType]))
			return self::$map[$kalturaType];
		return null;
	}
}
