
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `tiki249`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[indexName]]`
--

CREATE TABLE `[[indexName]]` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object_id` varchar(235) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci,
  `creation_date` datetime DEFAULT NULL,
  `modification_date` datetime DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `language` text COLLATE utf8mb4_unicode_ci,
  `gallery_id` text COLLATE utf8mb4_unicode_ci,
  `view_permission` text COLLATE utf8mb4_unicode_ci,
  `attachments` text COLLATE utf8mb4_unicode_ci,
  `primary_image` text COLLATE utf8mb4_unicode_ci,
  `geo_located` text COLLATE utf8mb4_unicode_ci,
  `geo_location` text COLLATE utf8mb4_unicode_ci,
  `allowed_groups` text COLLATE utf8mb4_unicode_ci,
  `allowed_users` text COLLATE utf8mb4_unicode_ci,
  `relations` text COLLATE utf8mb4_unicode_ci,
  `relation_types` text COLLATE utf8mb4_unicode_ci,
  `relation_count` text COLLATE utf8mb4_unicode_ci,
  `title_initial` text COLLATE utf8mb4_unicode_ci,
  `title_firstword` text COLLATE utf8mb4_unicode_ci,
  `searchable` text COLLATE utf8mb4_unicode_ci,
  `url` text COLLATE utf8mb4_unicode_ci,
  `contents` mediumtext COLLATE utf8mb4_unicode_ci,
  `title_unstemmed` text COLLATE utf8mb4_unicode_ci,
  `lastlogin_date` datetime DEFAULT NULL,
  `currentlogin_date` datetime DEFAULT NULL,
  `user_country` text COLLATE utf8mb4_unicode_ci,
  `user_gender` text COLLATE utf8mb4_unicode_ci,
  `user_homepage` text COLLATE utf8mb4_unicode_ci,
  `user_realName` text COLLATE utf8mb4_unicode_ci,
  `user_allowmsgs` text COLLATE utf8mb4_unicode_ci,
  `user_language` text COLLATE utf8mb4_unicode_ci,
  `user_style` text COLLATE utf8mb4_unicode_ci,
  `user_page` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `object_type` (`object_type`,`object_id`(160))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=9 ;

--
-- Dumping data for table `[[indexName]]`
--

INSERT INTO `[[indexName]]` VALUES
(1, 'file gallery', '1', 'File Galleries', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'F', 'File', 'y', 'tiki-list_file_gallery.php?galleryId=1', ' File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'file gallery', '2', 'Users File Galleries', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'U', 'Users', 'y', 'tiki-list_file_gallery.php?galleryId=2', ' Users File Galleries  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'file gallery', '3', 'Wiki Attachments', NULL, NULL, NULL, '', 'unknown', '-1', 'tiki_p_view_file_gallery', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'W', 'Wiki', 'y', 'tiki-list_file_gallery.php?galleryId=3', ' Wiki Attachments  ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(8, 'user', 'admin', 'System Administrator', '[[regtime]]', NULL, '[[regtime]]', NULL, NULL, NULL, 'tiki_p_list_users', '', '', 'n', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf', '', '', '', '', 'S', 'System', 'n', 'admin', ' System Administrator [[regtime]]   ', 'System Administrator', '[[regtime]]', '[[regtime]]', '', '', '', 'System Administrator', 'y', 'tokenycfefedxfbytywbaaucdupydwdqbbudw', '', '', 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt tokenvqzucfytrvaeewccbtqwwyacuevybdrf'),
(5, 'group', 'Anonymous', 'Anonymous', NULL, NULL, NULL, 'Public users not logged', NULL, NULL, 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Anonymous', 'n', 'Anonymous', ' Anonymous Public users not logged ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 'group', 'Registered', 'Registered', NULL, NULL, NULL, 'Users logged into the system', NULL, NULL, 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'R', 'Registered', 'n', 'Registered', ' Registered Users logged into the system ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, 'group', 'Admins', 'Admins', NULL, NULL, NULL, 'Administrator and accounts managers.', NULL, NULL, 'tiki_p_group_view', '', '', 'n', NULL, 'tokenrpqtevrqrpatuytyuxdxwwwpbtaafzvt', '', '', '', '', 'A', 'Admins', 'n', 'Admins', ' Admins Administrator and accounts managers. ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `messu_archive`
--

CREATE TABLE `messu_archive` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_messages`
--

CREATE TABLE `messu_messages` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`),
  KEY `userIsRead` (`user`(190),`isRead`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `messu_sent`
--

CREATE TABLE `messu_sent` (
  `msgId` int(14) NOT NULL AUTO_INCREMENT,
  `user` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_from` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` text COLLATE utf8mb4_unicode_ci,
  `user_cc` text COLLATE utf8mb4_unicode_ci,
  `user_bcc` text COLLATE utf8mb4_unicode_ci,
  `subject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text COLLATE utf8mb4_unicode_ci,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `replyto_hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date` int(14) DEFAULT NULL,
  `isRead` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isReplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isFlagged` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `sesskey` char(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int(11) unsigned NOT NULL,
  `expireref` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob NOT NULL,
  PRIMARY KEY (`sesskey`),
  KEY `expiry` (`expiry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_account`
--

CREATE TABLE `tiki_acct_account` (
  `accountBookId` int(10) unsigned NOT NULL,
  `accountId` int(10) unsigned NOT NULL DEFAULT '0',
  `accountName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `accountNotes` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `accountBudget` double NOT NULL DEFAULT '0',
  `accountLocked` int(1) NOT NULL DEFAULT '0',
  `accountTax` int(11) NOT NULL DEFAULT '0',
  `accountUserId` int(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`accountBookId`,`accountId`),
  KEY `accountTax` (`accountTax`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_bankaccount`
--

CREATE TABLE `tiki_acct_bankaccount` (
  `bankBookId` int(10) unsigned NOT NULL,
  `bankAccountId` int(10) unsigned NOT NULL,
  `externalNumber` int(10) NOT NULL,
  `bankCountry` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankCode` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankIBAN` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankBIC` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bankDelimeter` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ';',
  `bankDecPoint` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `bankThousand` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `bankHasHeader` tinyint(1) NOT NULL DEFAULT '1',
  `fieldNameAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameBookingDate` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `formatBookingDate` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameValueDate` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `formatValueDate` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameBookingText` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameReason` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartName` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameCounterpartBankCode` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldNameAmount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amountType` int(10) unsigned NOT NULL,
  `fieldNameAmountSign` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SignPositive` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `SignNegative` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`bankBookId`,`bankAccountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_book`
--

CREATE TABLE `tiki_acct_book` (
  `bookId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bookName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bookClosed` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `bookStartDate` date DEFAULT NULL,
  `bookEndDate` date DEFAULT NULL,
  `bookCurrency` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'EUR',
  `bookCurrencyPos` int(11) NOT NULL,
  `bookDecimals` int(11) NOT NULL DEFAULT '2',
  `bookDecPoint` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `bookThousand` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `exportSeparator` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ';',
  `exportEOL` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'LF',
  `exportQuote` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '"',
  `bookAutoTax` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`bookId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_item`
--

CREATE TABLE `tiki_acct_item` (
  `itemId` int(11) NOT NULL AUTO_INCREMENT,
  `itemBookId` int(10) unsigned NOT NULL,
  `itemJournalId` int(10) unsigned NOT NULL DEFAULT '0',
  `itemAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `itemType` int(1) NOT NULL DEFAULT '-1',
  `itemAmount` double NOT NULL DEFAULT '0',
  `itemText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `itemTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_journal`
--

CREATE TABLE `tiki_acct_journal` (
  `journalBookId` int(10) unsigned NOT NULL,
  `journalId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `journalDate` date DEFAULT NULL,
  `journalDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `journalCancelled` int(1) NOT NULL DEFAULT '0',
  `journalTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`journalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stack`
--

CREATE TABLE `tiki_acct_stack` (
  `stackBookId` int(10) unsigned NOT NULL,
  `stackId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `stackDate` date DEFAULT NULL,
  `stackDescription` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stackTs` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`stackId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_stackitem`
--

CREATE TABLE `tiki_acct_stackitem` (
  `stackBookId` int(10) unsigned NOT NULL,
  `stackItemStackId` int(10) unsigned NOT NULL DEFAULT '0',
  `stackItemAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `stackItemType` int(1) NOT NULL DEFAULT '-1',
  `stackItemAmount` double NOT NULL DEFAULT '0',
  `stackItemText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stackBookId`,`stackItemStackId`,`stackItemAccountId`,`stackItemType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_statement`
--

CREATE TABLE `tiki_acct_statement` (
  `statementBookId` int(10) unsigned NOT NULL,
  `statementAccountId` int(10) unsigned NOT NULL DEFAULT '0',
  `statementId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `statementBookingDate` date DEFAULT NULL,
  `statementValueDate` date DEFAULT NULL,
  `statementBookingText` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementReason` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpart` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpartAccount` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementCounterpartBankCode` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `statementAmount` double NOT NULL,
  `statementJournalId` int(10) unsigned NOT NULL DEFAULT '0',
  `statementStackId` int(11) NOT NULL,
  PRIMARY KEY (`statementId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_acct_tax`
--

CREATE TABLE `tiki_acct_tax` (
  `taxBookId` int(10) unsigned NOT NULL,
  `taxId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `taxText` varchar(63) COLLATE utf8mb4_unicode_ci NOT NULL,
  `taxAmount` double NOT NULL DEFAULT '0',
  `taxIsFix` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog`
--

CREATE TABLE `tiki_actionlog` (
  `actionId` int(8) NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastModif` int(14) DEFAULT NULL,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `categId` int(12) NOT NULL DEFAULT '0',
  `client` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`actionId`),
  KEY `lastModif` (`lastModif`),
  KEY `object` (`object`(100),`objectType`,`action`(100)),
  KEY `actionforuser` (`user`(100),`objectType`,`action`(100))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `tiki_actionlog`
--


-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_conf`
--

CREATE TABLE `tiki_actionlog_conf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`action`,`objectType`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=62 ;

--
-- Dumping data for table `tiki_actionlog_conf`
--

INSERT INTO `tiki_actionlog_conf` VALUES
(1, 'Created', 'wiki page', 'y'),
(2, 'Updated', 'wiki page', 'y'),
(3, 'Removed', 'wiki page', 'y'),
(4, 'Viewed', 'wiki page', 'n'),
(5, 'Viewed', 'forum', 'n'),
(6, 'Posted', 'forum', 'n'),
(7, 'Replied', 'forum', 'n'),
(8, 'Updated', 'forum', 'n'),
(9, 'Viewed', 'file gallery', 'n'),
(10, 'Uploaded', 'file gallery', 'n'),
(11, '%', 'category', 'n'),
(12, 'login', 'system', 'y'),
(13, 'Posted', 'message', 'n'),
(14, 'Replied', 'message', 'n'),
(15, 'Viewed', 'message', 'n'),
(16, 'Removed version', 'wiki page', 'n'),
(17, 'Removed last version', 'wiki page', 'n'),
(18, 'Rollback', 'wiki page', 'n'),
(19, 'Removed', 'forum', 'n'),
(20, 'Downloaded', 'file gallery', 'n'),
(21, 'Posted', 'comment', 'n'),
(22, 'Replied', 'comment', 'n'),
(23, 'Updated', 'comment', 'n'),
(24, 'Removed', 'comment', 'n'),
(25, 'Renamed', 'wiki page', 'n'),
(26, 'Created', 'sheet', 'n'),
(27, 'Updated', 'sheet', 'n'),
(28, 'Removed', 'sheet', 'n'),
(29, 'Viewed', 'sheet', 'n'),
(30, 'Viewed', 'blog', 'n'),
(31, 'Posted', 'blog', 'n'),
(32, 'Updated', 'blog', 'n'),
(33, 'Removed', 'blog', 'n'),
(34, 'Removed', 'file', 'n'),
(35, 'Viewed', 'article', 'n'),
(36, '%', 'system', 'y'),
(37, 'feature', 'system', 'y'),
(38, 'Updated', 'trackeritem', 'y'),
(39, 'Created', 'trackeritem', 'y'),
(40, 'Viewed', 'trackeritem', 'y'),
(41, 'Removed', 'trackeritem', 'y'),
(42, 'Created', 'wiki page attachment', 'n'),
(43, 'Removed', 'wiki page attachment', 'n'),
(44, 'Categorized', 'wiki page', 'n'),
(45, 'Uncategorized', 'wiki page', 'n'),
(46, 'Flagged', 'wiki page', 'n'),
(47, 'Fetch', 'url', 'n'),
(48, 'Refresh', 'url', 'n'),
(49, 'Joined Room', 'bigbluebutton', 'n'),
(50, 'Left Room', 'bigbluebutton', 'n'),
(51, 'Created', 'tracker', 'y'),
(52, 'Updated', 'tracker', 'y'),
(53, 'Removed', 'tracker', 'y'),
(54, 'Created', 'category', 'y'),
(55, 'Updated', 'category', 'y'),
(56, 'Removed', 'category', 'y'),
(57, 'Created', 'calendar event', 'n'),
(58, 'Updated', 'calendar event', 'n'),
(59, 'Removed', 'calendar event', 'n'),
(60, 'Sync', 'file gallery', 'y'),
(61, 'CRSF Error', 'system', 'y');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_actionlog_params`
--

CREATE TABLE `tiki_actionlog_params` (
  `actionId` int(8) NOT NULL,
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  KEY `actionId` (`actionId`),
  KEY `nameValue` (`name`,`value`(151))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream`
--

CREATE TABLE `tiki_activity_stream` (
  `activityId` int(8) NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eventDate` int(11) NOT NULL,
  `arguments` mediumblob,
  PRIMARY KEY (`activityId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_mapping`
--

CREATE TABLE `tiki_activity_stream_mapping` (
  `field_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`field_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_activity_stream_rules`
--

CREATE TABLE `tiki_activity_stream_rules` (
  `ruleId` int(8) NOT NULL AUTO_INCREMENT,
  `eventType` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruleType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `rule` text COLLATE utf8mb4_unicode_ci,
  `notes` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ruleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_address_books`
--

CREATE TABLE `tiki_address_books` (
  `addressBookId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varbinary(200) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`addressBookId`),
  UNIQUE KEY `user` (`user`(141),`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_address_cards`
--

CREATE TABLE `tiki_address_cards` (
  `addressCardId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `addressBookId` int(10) unsigned NOT NULL,
  `carddata` mediumblob,
  `uri` varbinary(200) DEFAULT NULL,
  `lastmodified` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  PRIMARY KEY (`addressCardId`),
  KEY `addressBookId` (`addressBookId`,`uri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_api_tokens`
--

CREATE TABLE `tiki_api_tokens` (
  `tokenId` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'manual',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parameters` text COLLATE utf8mb4_unicode_ci,
  `created` int(11) NOT NULL,
  `lastModif` int(11) NOT NULL,
  `expireAfter` int(11) DEFAULT NULL,
  `hits` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tokenId`),
  KEY `token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_areas`
--

CREATE TABLE `tiki_areas` (
  `categId` int(11) NOT NULL,
  `perspectives` text COLLATE utf8mb4_unicode_ci,
  `exclusive` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `share_common` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `enabled` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  KEY `categId` (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_articles`
--

CREATE TABLE `tiki_articles` (
  `articleId` int(8) NOT NULL AUTO_INCREMENT,
  `topline` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `linkto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 's',
  `authorName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topicId` int(14) DEFAULT NULL,
  `topicName` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(12) DEFAULT NULL,
  `useImage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_caption` text COLLATE utf8mb4_unicode_ci,
  `image_type` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(14) DEFAULT NULL,
  `image_x` int(4) DEFAULT NULL,
  `image_y` int(4) DEFAULT NULL,
  `list_image_x` int(4) DEFAULT NULL,
  `list_image_y` int(4) DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `body` text COLLATE utf8mb4_unicode_ci,
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nbreads` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` int(14) DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  `isfloat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ispublished` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  PRIMARY KEY (`articleId`),
  KEY `title` (`title`(191)),
  KEY `heading` (`heading`(191)),
  KEY `body` (`body`(191)),
  KEY `nbreads` (`nbreads`),
  KEY `author` (`author`(32)),
  KEY `topicId` (`topicId`),
  KEY `publishDate` (`publishDate`),
  KEY `expireDate` (`expireDate`),
  KEY `type` (`type`),
  FULLTEXT KEY `ft` (`title`,`heading`,`body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_article_types`
--

CREATE TABLE `tiki_article_types` (
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `use_ratings` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_pre_publ` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_post_expire` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `heading_only` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_comments` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_image` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_avatar` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_author` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_pubdate` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_expdate` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_reads` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_size` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_topline` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_subtitle` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_linkto` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_image_caption` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `creator_edit` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_can_rate_article` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`type`),
  KEY `show_pre_publ` (`show_pre_publ`),
  KEY `show_post_expire` (`show_post_expire`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_article_types`
--

INSERT INTO `tiki_article_types` VALUES
('Article', NULL, NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Review', 'y', NULL, 'y', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Event', NULL, NULL, 'n', NULL, 'y', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL),
('Classified', NULL, NULL, 'n', 'y', 'n', 'y', NULL, 'y', 'y', NULL, 'y', 'n', 'n', 'n', 'n', 'n', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_auth_tokens`
--

CREATE TABLE `tiki_auth_tokens` (
  `tokenId` int(11) NOT NULL AUTO_INCREMENT,
  `creation` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `timeout` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '1',
  `maxhits` int(11) NOT NULL DEFAULT '1',
  `token` char(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `entry` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameters` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups` text COLLATE utf8mb4_unicode_ci,
  `createUser` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `userPrefix` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '_token',
  PRIMARY KEY (`tokenId`),
  KEY `tiki_auth_tokens_token` (`token`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banners`
--

CREATE TABLE `tiki_banners` (
  `bannerId` int(12) NOT NULL AUTO_INCREMENT,
  `client` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `which` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageData` longblob,
  `imageType` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imageName` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `HTMLData` text COLLATE utf8mb4_unicode_ci,
  `fixedURLData` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `textData` text COLLATE utf8mb4_unicode_ci,
  `fromDate` int(14) DEFAULT NULL,
  `toDate` int(14) DEFAULT NULL,
  `useDates` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tue` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wed` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thu` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fri` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sun` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourFrom` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hourTo` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `maxImpressions` int(8) DEFAULT NULL,
  `impressions` int(8) DEFAULT NULL,
  `maxUserImpressions` int(8) DEFAULT '-1',
  `maxClicks` int(8) DEFAULT NULL,
  `clicks` int(8) DEFAULT NULL,
  `zone` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onlyInURIs` text COLLATE utf8mb4_unicode_ci,
  `exceptInURIs` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`bannerId`),
  KEY `ban1` (`zone`,`useDates`,`impressions`,`maxImpressions`,`hourFrom`,`hourTo`,`fromDate`,`toDate`,`mon`,`tue`,`wed`,`thu`,`fri`,`sat`,`sun`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning`
--

CREATE TABLE `tiki_banning` (
  `banId` int(12) NOT NULL AUTO_INCREMENT,
  `mode` enum('user','ip') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip1` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip2` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip3` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip4` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `date_from` timestamp NULL DEFAULT NULL,
  `date_to` timestamp NULL DEFAULT NULL,
  `use_dates` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci,
  `attempts` int(11) DEFAULT NULL,
  PRIMARY KEY (`banId`),
  KEY `ban` (`use_dates`,`date_from`,`date_to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_banning_sections`
--

CREATE TABLE `tiki_banning_sections` (
  `banId` int(12) NOT NULL DEFAULT '0',
  `section` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`banId`,`section`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blogs`
--

CREATE TABLE `tiki_blogs` (
  `blogId` int(8) NOT NULL AUTO_INCREMENT,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `posts` int(8) DEFAULT NULL,
  `maxPosts` int(8) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `activity` decimal(4,2) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `post_heading` text COLLATE utf8mb4_unicode_ci,
  `use_find` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_title` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_title_in_post` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `use_breadcrumbs` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `use_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_excerpt` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_date` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_poster` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_comments` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allow_post_categorization` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `show_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `always_owner` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_related` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `related_max` int(4) DEFAULT '5',
  PRIMARY KEY (`blogId`),
  KEY `title` (`title`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_activity`
--

CREATE TABLE `tiki_blog_activity` (
  `blogId` int(8) NOT NULL DEFAULT '0',
  `day` int(14) NOT NULL DEFAULT '0',
  `posts` int(8) DEFAULT NULL,
  PRIMARY KEY (`blogId`,`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts`
--

CREATE TABLE `tiki_blog_posts` (
  `postId` int(8) NOT NULL AUTO_INCREMENT,
  `blogId` int(8) NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `data_size` int(11) unsigned NOT NULL DEFAULT '0',
  `excerpt` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` bigint(20) DEFAULT '0',
  `trackbacks_to` text COLLATE utf8mb4_unicode_ci,
  `trackbacks_from` text COLLATE utf8mb4_unicode_ci,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priv` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `wysiwyg` varchar(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`postId`),
  KEY `data` (`data`(191)),
  KEY `blogId` (`blogId`),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`data`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_blog_posts_images`
--

CREATE TABLE `tiki_blog_posts_images` (
  `imgId` int(14) NOT NULL AUTO_INCREMENT,
  `postId` int(14) NOT NULL DEFAULT '0',
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `data` longblob,
  PRIMARY KEY (`imgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendars`
--

CREATE TABLE `tiki_calendars` (
  `calendarId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `customlocations` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customcategories` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customlanguages` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `custompriorities` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customparticipants` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customsubscription` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `customstatus` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `personal` enum('n','y') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_categories`
--

CREATE TABLE `tiki_calendar_categories` (
  `calcatId` int(11) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`calcatId`),
  UNIQUE KEY `catname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_changes`
--

CREATE TABLE `tiki_calendar_changes` (
  `changeId` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `calitemId` int(11) unsigned NOT NULL,
  `synctoken` int(11) unsigned NOT NULL,
  `calendarId` int(11) unsigned NOT NULL,
  `operation` tinyint(1) NOT NULL,
  PRIMARY KEY (`changeId`),
  KEY `calendarId` (`calendarId`,`synctoken`),
  KEY `calitemId` (`calitemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_instances`
--

CREATE TABLE `tiki_calendar_instances` (
  `calendarInstanceId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `calendarId` int(10) unsigned NOT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `access` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1 = owner, 2 = read, 3 = readwrite',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varbinary(200) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int(11) unsigned NOT NULL DEFAULT '0',
  `color` varbinary(10) DEFAULT NULL,
  `timezone` text COLLATE utf8mb4_unicode_ci,
  `transparent` tinyint(1) NOT NULL DEFAULT '0',
  `share_href` varbinary(100) DEFAULT NULL,
  `share_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `share_invite_status` tinyint(1) NOT NULL DEFAULT '2' COMMENT '1 = noresponse, 2 = accepted, 3 = declined, 4 = invalid',
  PRIMARY KEY (`calendarInstanceId`),
  UNIQUE KEY `calendarId_2` (`calendarId`,`share_href`),
  UNIQUE KEY `user` (`user`(141),`uri`),
  UNIQUE KEY `calendarId` (`calendarId`,`user`(189))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_items`
--

CREATE TABLE `tiki_calendar_items` (
  `calitemId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `start` int(14) NOT NULL DEFAULT '0',
  `end` int(14) NOT NULL DEFAULT '0',
  `locationId` int(14) DEFAULT NULL,
  `categoryId` int(14) DEFAULT NULL,
  `nlId` int(12) NOT NULL DEFAULT '0',
  `priority` enum('0','1','2','3','4','5','6','7','8','9') COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `status` enum('0','1','2') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `recurrenceId` int(14) DEFAULT NULL,
  `changed` tinyint(1) DEFAULT '0',
  `recurrenceStart` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `uid` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calitemId`),
  KEY `calendarId` (`calendarId`),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_locations`
--

CREATE TABLE `tiki_calendar_locations` (
  `callocId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  PRIMARY KEY (`callocId`),
  UNIQUE KEY `locname` (`calendarId`,`name`(16))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_options`
--

CREATE TABLE `tiki_calendar_options` (
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `optionName` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calendarId`,`optionName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_recurrence`
--

CREATE TABLE `tiki_calendar_recurrence` (
  `recurrenceId` int(14) NOT NULL AUTO_INCREMENT,
  `calendarId` int(14) NOT NULL DEFAULT '0',
  `start` int(4) NOT NULL DEFAULT '0',
  `end` int(4) NOT NULL DEFAULT '2359',
  `allday` tinyint(1) NOT NULL DEFAULT '0',
  `locationId` int(14) DEFAULT NULL,
  `categoryId` int(14) DEFAULT NULL,
  `nlId` int(12) NOT NULL DEFAULT '0',
  `priority` enum('1','2','3','4','5','6','7','8','9') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `status` enum('0','1','2') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` blob,
  `weekly` tinyint(1) DEFAULT '0',
  `weekdays` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `monthly` tinyint(1) DEFAULT '0',
  `dayOfMonth` int(2) DEFAULT NULL,
  `yearly` tinyint(1) DEFAULT '0',
  `dateOfYear` int(4) DEFAULT NULL,
  `nbRecurrences` int(8) DEFAULT NULL,
  `startPeriod` int(14) DEFAULT NULL,
  `endPeriod` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  `lastmodif` int(14) NOT NULL DEFAULT '0',
  `uid` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`recurrenceId`),
  KEY `calendarId` (`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_roles`
--

CREATE TABLE `tiki_calendar_roles` (
  `calitemId` int(14) NOT NULL DEFAULT '0',
  `username` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `role` enum('0','1','2','3','6') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `partstat` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`calitemId`,`username`(16),`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_scheduling_objects`
--

CREATE TABLE `tiki_calendar_scheduling_objects` (
  `schedulingObjectId` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `calendardata` mediumblob,
  `uri` varbinary(200) DEFAULT NULL,
  `lastmodif` int(11) unsigned DEFAULT NULL,
  `etag` varbinary(32) DEFAULT NULL,
  `size` int(11) unsigned NOT NULL,
  PRIMARY KEY (`schedulingObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_calendar_subscriptions`
--

CREATE TABLE `tiki_calendar_subscriptions` (
  `subscriptionId` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `calendarId` int(11) unsigned NOT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` text COLLATE utf8mb4_unicode_ci,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh_rate` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int(11) unsigned NOT NULL DEFAULT '0',
  `color` varbinary(10) DEFAULT NULL,
  `strip_todos` tinyint(1) DEFAULT NULL,
  `strip_alarms` tinyint(1) DEFAULT NULL,
  `strip_attachments` tinyint(1) DEFAULT NULL,
  `lastmodif` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`subscriptionId`),
  UNIQUE KEY `user` (`user`(189),`calendarId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cart_inventory_hold`
--

CREATE TABLE `tiki_cart_inventory_hold` (
  `productId` int(14) NOT NULL,
  `quantity` int(14) NOT NULL,
  `timeHeld` int(14) NOT NULL,
  `hash` char(32) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories`
--

CREATE TABLE `tiki_categories` (
  `categId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(500) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int(12) DEFAULT NULL,
  `rootId` int(11) NOT NULL DEFAULT '0',
  `hits` int(8) DEFAULT NULL,
  `tplGroupContainerId` int(12) DEFAULT NULL,
  `tplGroupPattern` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories_roles`
--

CREATE TABLE `tiki_categories_roles` (
  `categId` int(12) NOT NULL,
  `categRoleId` int(12) NOT NULL,
  `groupRoleId` int(12) NOT NULL,
  `groupId` int(12) NOT NULL,
  PRIMARY KEY (`categId`,`categRoleId`,`groupRoleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categories_roles_available`
--

CREATE TABLE `tiki_categories_roles_available` (
  `categId` int(12) NOT NULL,
  `categRoleId` int(12) NOT NULL,
  PRIMARY KEY (`categId`,`categRoleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_categorized_objects`
--

CREATE TABLE `tiki_categorized_objects` (
  `catObjectId` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_objects`
--

CREATE TABLE `tiki_category_objects` (
  `catObjectId` int(12) NOT NULL DEFAULT '0',
  `categId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_category_sites`
--

CREATE TABLE `tiki_category_sites` (
  `categId` int(10) NOT NULL DEFAULT '0',
  `siteId` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`siteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_channels`
--

CREATE TABLE `tiki_chat_channels` (
  `channelId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_users` int(8) DEFAULT NULL,
  `mode` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `refresh` int(6) DEFAULT NULL,
  PRIMARY KEY (`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_messages`
--

CREATE TABLE `tiki_chat_messages` (
  `messageId` int(8) NOT NULL AUTO_INCREMENT,
  `channelId` int(8) NOT NULL DEFAULT '0',
  `data` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `poster` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_chat_users`
--

CREATE TABLE `tiki_chat_users` (
  `nickname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `channelId` int(8) NOT NULL DEFAULT '0',
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`nickname`(183),`channelId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_comments`
--

CREATE TABLE `tiki_comments` (
  `threadId` int(14) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `parentId` int(14) DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `commentDate` int(14) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `average` decimal(8,4) DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smiley` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message_id` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment_rating` tinyint(2) DEFAULT NULL,
  `archived` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `locked` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`threadId`),
  UNIQUE KEY `no_repeats` (`parentId`,`userName`(40),`title`(43),`commentDate`,`message_id`(40),`in_reply_to`(40)),
  KEY `title` (`title`(191)),
  KEY `data` (`data`(191)),
  KEY `hits` (`hits`),
  KEY `tc_pi` (`parentId`),
  KEY `objectType` (`object`(160),`objectType`),
  KEY `commentDate` (`commentDate`),
  KEY `threaded` (`message_id`(89),`in_reply_to`(88),`parentId`),
  FULLTEXT KEY `ft` (`title`,`data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_connect`
--

CREATE TABLE `tiki_connect` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  `guid` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `server` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `server` (`server`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content`
--

CREATE TABLE `tiki_content` (
  `contentId` int(8) NOT NULL AUTO_INCREMENT,
  `description` text COLLATE utf8mb4_unicode_ci,
  `contentLabel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`contentId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates`
--

CREATE TABLE `tiki_content_templates` (
  `templateId` int(10) NOT NULL AUTO_INCREMENT,
  `template_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `content` longblob,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`templateId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_content_templates_sections`
--

CREATE TABLE `tiki_content_templates_sections` (
  `templateId` int(10) NOT NULL DEFAULT '0',
  `section` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`templateId`,`section`(181))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions`
--

CREATE TABLE `tiki_contributions` (
  `contributionId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_contributions_assigned`
--

CREATE TABLE `tiki_contributions_assigned` (
  `contributionId` int(12) NOT NULL,
  `objectId` int(12) NOT NULL,
  PRIMARY KEY (`objectId`,`contributionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_cookies`
--

CREATE TABLE `tiki_cookies` (
  `cookieId` int(10) NOT NULL AUTO_INCREMENT,
  `cookie` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`cookieId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_copyrights`
--

CREATE TABLE `tiki_copyrights` (
  `copyrightId` int(12) NOT NULL AUTO_INCREMENT,
  `page` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `authors` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `holder` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `copyright_order` int(11) DEFAULT NULL,
  `userName` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`copyrightId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits`
--

CREATE TABLE `tiki_credits` (
  `creditId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userId` int(8) NOT NULL,
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expiration_date` timestamp NULL DEFAULT NULL,
  `total_amount` float NOT NULL DEFAULT '0',
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int(8) DEFAULT NULL,
  `goalId` int(11) DEFAULT NULL,
  PRIMARY KEY (`creditId`),
  KEY `userId` (`userId`,`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_types`
--

CREATE TABLE `tiki_credits_types` (
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_text` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_text` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_static_level` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `scaling_divisor` float NOT NULL DEFAULT '1',
  PRIMARY KEY (`credit_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_credits_usage`
--

CREATE TABLE `tiki_credits_usage` (
  `usageId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `usage_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `credit_type` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used_amount` float NOT NULL DEFAULT '0',
  `product_id` int(8) DEFAULT NULL,
  PRIMARY KEY (`usageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_custom_route`
--

CREATE TABLE `tiki_custom_route` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `from` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `short_url` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_db_status`
--

CREATE TABLE `tiki_db_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `objectId` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tableName` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `other` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=3 ;

--
-- Dumping data for table `tiki_db_status`
--

INSERT INTO `tiki_db_status` VALUES
(1, '1', 'tiki_pages', 'new9.0+', NULL),
(2, '1', 'tiki_history', 'new9.0+', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_categories`
--

CREATE TABLE `tiki_directory_categories` (
  `categId` int(10) NOT NULL AUTO_INCREMENT,
  `parent` int(10) DEFAULT NULL,
  `name` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `childrenType` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sites` int(10) DEFAULT NULL,
  `viewableChildren` int(4) DEFAULT NULL,
  `allowSites` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `showCount` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `editorGroup` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(12) DEFAULT NULL,
  PRIMARY KEY (`categId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_search`
--

CREATE TABLE `tiki_directory_search` (
  `term` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  PRIMARY KEY (`term`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_directory_sites`
--

CREATE TABLE `tiki_directory_sites` (
  `siteId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(12) DEFAULT NULL,
  `isValid` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `cache` longblob,
  `cache_timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`siteId`),
  KEY `isValid` (`isValid`),
  KEY `url` (`url`(191)),
  FULLTEXT KEY `ft` (`name`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_discount`
--

CREATE TABLE `tiki_discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max` int(11) DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `code` (`code`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_download`
--

CREATE TABLE `tiki_download` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `object` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userId` int(8) NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `date` int(14) NOT NULL DEFAULT '0',
  `IP` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `object` (`object`(163),`userId`,`type`),
  KEY `userId` (`userId`),
  KEY `type` (`type`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dsn`
--

CREATE TABLE `tiki_dsn` (
  `dsnId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `dsn` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`dsnId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_dynamic_variables`
--

CREATE TABLE `tiki_dynamic_variables` (
  `name` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_encryption_keys`
--

CREATE TABLE `tiki_encryption_keys` (
  `keyId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `algo` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shares` int(11) NOT NULL,
  `users` text COLLATE utf8mb4_unicode_ci,
  `secret` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`keyId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_extwiki`
--

CREATE TABLE `tiki_extwiki` (
  `extwikiId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extwiki` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `indexname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups` varchar(1024) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`extwikiId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faqs`
--

CREATE TABLE `tiki_faqs` (
  `faqId` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `questions` int(5) DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `canSuggest` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`faqId`),
  KEY `title` (`title`(191)),
  KEY `description` (`description`(191)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`title`,`description`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_faq_questions`
--

CREATE TABLE `tiki_faq_questions` (
  `questionId` int(10) NOT NULL AUTO_INCREMENT,
  `faqId` int(10) DEFAULT NULL,
  `position` int(4) DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`questionId`),
  KEY `faqId` (`faqId`),
  KEY `question` (`question`(191)),
  KEY `answer` (`answer`(191)),
  KEY `created` (`created`),
  FULLTEXT KEY `ft` (`question`,`answer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_feature`
--

CREATE TABLE `tiki_feature` (
  `feature_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `feature_name` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` mediumint(9) NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `setting_name` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feature_type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'feature',
  `template` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permission` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordinal` mediumint(9) NOT NULL DEFAULT '1',
  `depends_on` mediumint(9) DEFAULT NULL,
  `keyword` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tip` text COLLATE utf8mb4_unicode_ci,
  `feature_count` mediumint(9) NOT NULL DEFAULT '0',
  `feature_path` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_featured_links`
--

CREATE TABLE `tiki_featured_links` (
  `url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `hits` int(8) DEFAULT NULL,
  `position` int(6) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_files`
--

CREATE TABLE `tiki_files` (
  `fileId` int(14) NOT NULL AUTO_INCREMENT,
  `galleryId` int(14) NOT NULL DEFAULT '0',
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `author` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(14) DEFAULT NULL,
  `maxhits` int(14) DEFAULT NULL,
  `lastDownload` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_reference` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `search_data` longtext COLLATE utf8mb4_unicode_ci,
  `metadata` longtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int(14) DEFAULT NULL,
  `lastModifUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `comment` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `archiveId` int(14) DEFAULT '0',
  `deleteAfter` int(14) DEFAULT NULL,
  `ocr_state` tinyint(1) DEFAULT NULL,
  `ocr_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ocr_data` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`fileId`),
  KEY `name` (`name`(191)),
  KEY `description` (`description`(191)),
  KEY `created` (`created`),
  KEY `archiveId` (`archiveId`),
  KEY `galleryIdAndPath` (`galleryId`,`path`(188)),
  KEY `hits` (`hits`),
  FULLTEXT KEY `ft` (`name`,`description`,`search_data`,`filename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_backlinks`
--

CREATE TABLE `tiki_file_backlinks` (
  `fileId` int(14) NOT NULL,
  `objectId` int(12) NOT NULL,
  KEY `objectId` (`objectId`),
  KEY `fileId` (`fileId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_drafts`
--

CREATE TABLE `tiki_file_drafts` (
  `fileId` int(14) NOT NULL,
  `filename` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(14) DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` longtext COLLATE utf8mb4_unicode_ci,
  `lastModif` int(14) DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`fileId`,`user`(177))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_galleries`
--

CREATE TABLE `tiki_file_galleries` (
  `galleryId` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `direct` text COLLATE utf8mb4_unicode_ci,
  `template` int(10) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `visible` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hits` int(14) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `points` decimal(8,2) DEFAULT NULL,
  `maxRows` int(10) DEFAULT NULL,
  `public` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_id` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_icon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_name` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_size` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_desc` int(8) DEFAULT NULL,
  `show_created` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_hits` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_lastDownload` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int(14) NOT NULL DEFAULT '-1',
  `lockable` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_lockedby` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `archives` int(4) DEFAULT '0',
  `sort_mode` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_modified` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_creator` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subgal_conf` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_last_user` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_comment` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_files` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_explorer` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_path` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_slideshow` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_ocr_state` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_view` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quota` int(8) DEFAULT '0',
  `size` int(14) DEFAULT NULL,
  `wiki_syntax` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backlinkPerms` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `show_backlinks` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_deleteAfter` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_checked` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_share` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_max_size_x` int(8) NOT NULL DEFAULT '0',
  `image_max_size_y` int(8) NOT NULL DEFAULT '0',
  `show_source` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'o',
  `icon_fileId` int(14) unsigned DEFAULT NULL,
  `ocr_lang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`galleryId`),
  KEY `parentIdAndName` (`parentId`,`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_file_galleries`
--

INSERT INTO `tiki_file_galleries` VALUES
(1, 'File Galleries', 'system', NULL, NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL),
(2, 'Users File Galleries', 'system', NULL, NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL),
(3, 'Wiki Attachments', 'system', NULL, NULL, '', NULL, 'y', NULL, 'admin', NULL, NULL, NULL, NULL, 'y', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 'n', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 'n', NULL, NULL, NULL, NULL, 0, 0, 'o', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_file_handlers`
--

CREATE TABLE `tiki_file_handlers` (
  `mime_type` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cmd` varchar(238) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums`
--

CREATE TABLE `tiki_forums` (
  `forumId` int(8) NOT NULL AUTO_INCREMENT,
  `parentId` int(8) NOT NULL DEFAULT '0',
  `forumOrder` int(8) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastPost` int(14) DEFAULT NULL,
  `threads` int(8) DEFAULT NULL,
  `comments` int(8) DEFAULT NULL,
  `controlFlood` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floodInterval` int(8) DEFAULT NULL,
  `moderator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `mail` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `useMail` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `section` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `usePruneUnreplied` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pruneUnrepliedAge` int(8) DEFAULT NULL,
  `usePruneOld` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pruneMaxAge` int(8) DEFAULT NULL,
  `topicsPerPage` int(6) DEFAULT NULL,
  `topicOrdering` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `threadOrdering` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_store` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_store_dir` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `att_max_size` int(12) DEFAULT NULL,
  `att_list_nb` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_level` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_password` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_use_password` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moderator_group` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_address` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_mails_for_inbound_mails` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_mails_reply_link` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `outbound_from` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_server` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_port` int(4) DEFAULT NULL,
  `inbound_pop_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `inbound_pop_password` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_smileys` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_rating_choice_topic` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_posts` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_email` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ui_online` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_summary` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_description` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_replies` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_reads` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_pts` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_title` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_lastpost_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_author` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topics_list_author_avatar` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vote_threads` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forum_last_n` int(2) DEFAULT '0',
  `threadStyle` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commentsPerPage` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_flat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mandatory_contribution` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `forumLanguage` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`forumId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_queue`
--

CREATE TABLE `tiki_forums_queue` (
  `qId` int(14) NOT NULL AUTO_INCREMENT,
  `object` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentId` int(14) DEFAULT NULL,
  `forumId` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `title` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_smiley` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `topic_title` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `summary` varchar(240) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `in_reply_to` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tags` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`qId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forums_reported`
--

CREATE TABLE `tiki_forums_reported` (
  `threadId` int(12) NOT NULL DEFAULT '0',
  `forumId` int(12) NOT NULL DEFAULT '0',
  `parentId` int(12) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `timestamp` int(14) DEFAULT NULL,
  `reason` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`threadId`,`forumId`,`parentId`,`user`(182))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_attachments`
--

CREATE TABLE `tiki_forum_attachments` (
  `attId` int(14) NOT NULL AUTO_INCREMENT,
  `threadId` int(14) NOT NULL DEFAULT '0',
  `qId` int(14) NOT NULL DEFAULT '0',
  `forumId` int(14) DEFAULT NULL,
  `filename` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` int(12) DEFAULT NULL,
  `data` longblob,
  `dir` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attId`),
  KEY `threadId` (`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_forum_reads`
--

CREATE TABLE `tiki_forum_reads` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `threadId` int(14) NOT NULL DEFAULT '0',
  `forumId` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`user`(177),`threadId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetagged_objects`
--

CREATE TABLE `tiki_freetagged_objects` (
  `tagId` int(12) NOT NULL AUTO_INCREMENT,
  `objectId` int(11) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` int(14) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagId`,`user`(168),`objectId`),
  KEY `tagId` (`tagId`),
  KEY `user` (`user`(191)),
  KEY `objectId` (`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_freetags`
--

CREATE TABLE `tiki_freetags` (
  `tagId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `raw_tag` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`tagId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goals`
--

CREATE TABLE `tiki_goals` (
  `goalId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `description` text COLLATE utf8mb4_unicode_ci,
  `enabled` int(11) NOT NULL DEFAULT '0',
  `daySpan` int(11) NOT NULL DEFAULT '14',
  `from` datetime DEFAULT NULL,
  `to` datetime DEFAULT NULL,
  `eligible` blob,
  `conditions` blob,
  `rewards` blob,
  PRIMARY KEY (`goalId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_goal_events`
--

CREATE TABLE `tiki_goal_events` (
  `eventId` int(11) NOT NULL AUTO_INCREMENT,
  `eventDate` int(11) NOT NULL,
  `eventType` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `targetType` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `targetObject` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `groups` blob NOT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_groupalert`
--

CREATE TABLE `tiki_groupalert` (
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectId` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `displayEachuser` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`groupName`(161),`objectType`,`objectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_inclusion`
--

CREATE TABLE `tiki_group_inclusion` (
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `includeGroup` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`groupName`(120),`includeGroup`(120))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_group_inclusion`
--

INSERT INTO `tiki_group_inclusion` VALUES
('Registered', 'Anonymous');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_group_watches`
--

CREATE TABLE `tiki_group_watches` (
  `watchId` int(12) NOT NULL AUTO_INCREMENT,
  `group` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `event` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `object` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`watchId`),
  KEY `event-object-group` (`event`,`object`(100),`group`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_contents`
--

CREATE TABLE `tiki_h5p_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `file_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `library_id` int(10) unsigned NOT NULL,
  `parameters` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `filtered` longtext COLLATE utf8mb4_unicode_ci,
  `slug` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `embed_type` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `disable` int(10) unsigned NOT NULL DEFAULT '0',
  `content_type` varchar(127) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authors` mediumtext COLLATE utf8mb4_unicode_ci,
  `license` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `source` varchar(2083) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year_from` int(10) unsigned DEFAULT NULL,
  `year_to` int(10) unsigned DEFAULT NULL,
  `license_version` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `license_extras` longtext COLLATE utf8mb4_unicode_ci,
  `author_comments` longtext COLLATE utf8mb4_unicode_ci,
  `changes` mediumtext COLLATE utf8mb4_unicode_ci,
  `default_language` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `a11y_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `fileId` (`file_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_contents_libraries`
--

CREATE TABLE `tiki_h5p_contents_libraries` (
  `content_id` int(10) unsigned NOT NULL,
  `library_id` int(10) unsigned NOT NULL,
  `dependency_type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` smallint(5) unsigned NOT NULL DEFAULT '0',
  `drop_css` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`content_id`,`library_id`,`dependency_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries`
--

CREATE TABLE `tiki_h5p_libraries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major_version` int(10) unsigned NOT NULL,
  `minor_version` int(10) unsigned NOT NULL,
  `patch_version` int(10) unsigned NOT NULL,
  `runnable` int(10) unsigned NOT NULL,
  `restricted` int(10) unsigned NOT NULL DEFAULT '0',
  `fullscreen` int(10) unsigned NOT NULL,
  `embed_types` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `preloaded_js` text COLLATE utf8mb4_unicode_ci,
  `preloaded_css` text COLLATE utf8mb4_unicode_ci,
  `drop_library_css` text COLLATE utf8mb4_unicode_ci,
  `semantics` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `tutorial_url` varchar(1023) COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_icon` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata_settings` text COLLATE utf8mb4_unicode_ci,
  `add_to` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `name_version` (`name`,`major_version`,`minor_version`,`patch_version`),
  KEY `runnable` (`runnable`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_cachedassets`
--

CREATE TABLE `tiki_h5p_libraries_cachedassets` (
  `library_id` int(10) unsigned NOT NULL,
  `hash` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_hub_cache`
--

CREATE TABLE `tiki_h5p_libraries_hub_cache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `machine_name` varchar(127) COLLATE utf8mb4_unicode_ci NOT NULL,
  `major_version` int(10) unsigned NOT NULL,
  `minor_version` int(10) unsigned NOT NULL,
  `patch_version` int(10) unsigned NOT NULL,
  `h5p_major_version` int(10) unsigned DEFAULT NULL,
  `h5p_minor_version` int(10) unsigned DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `summary` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(511) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  `updated_at` int(10) unsigned NOT NULL,
  `is_recommended` int(10) unsigned NOT NULL,
  `popularity` int(10) unsigned NOT NULL,
  `screenshots` text COLLATE utf8mb4_unicode_ci,
  `license` text COLLATE utf8mb4_unicode_ci,
  `example` varchar(511) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tutorial` varchar(511) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  `categories` text COLLATE utf8mb4_unicode_ci,
  `owner` varchar(511) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name_version` (`machine_name`,`major_version`,`minor_version`,`patch_version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_languages`
--

CREATE TABLE `tiki_h5p_libraries_languages` (
  `library_id` int(10) unsigned NOT NULL,
  `language_code` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `translation` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`language_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_libraries_libraries`
--

CREATE TABLE `tiki_h5p_libraries_libraries` (
  `library_id` int(10) unsigned NOT NULL,
  `required_library_id` int(10) unsigned NOT NULL,
  `dependency_type` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`library_id`,`required_library_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_results`
--

CREATE TABLE `tiki_h5p_results` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `score` int(10) unsigned NOT NULL,
  `max_score` int(10) unsigned NOT NULL,
  `opened` int(10) unsigned NOT NULL,
  `finished` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `content_user` (`content_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_h5p_tmpfiles`
--

CREATE TABLE `tiki_h5p_tmpfiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `path` (`path`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_history`
--

CREATE TABLE `tiki_history` (
  `historyId` int(12) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(8) NOT NULL DEFAULT '0',
  `version_minor` int(8) NOT NULL DEFAULT '0',
  `lastModif` int(14) DEFAULT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pageName`,`version`),
  KEY `user` (`user`(191)),
  KEY `historyId` (`historyId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_history`
--

INSERT INTO `tiki_history` VALUES
(1, 'HomePage', 1, 0, [[timestamp]], '', 'admin', '0.0.0.0', 'Tiki initialization', '!Congratulations\nThis is the default homepage for your Tiki. If you are seeing this page, your installation was successful.\n\nYou can change this page after logging in. Please review the [http://doc.tiki.org/Wiki-syntax|wiki syntax] for editing details.\n\n\n!!Get started.\nTo begin configuring your site:\n{FANCYLIST()}\n1) Log in with your newly created password.\n2) Manually [tiki-admin.php?page=features|Enable specific Tiki features] that you didn''t enable with the Admin wizard.\n3) Run [tiki-admin.php?page=profiles|Tiki Profiles] to quickly get up and running.\n{FANCYLIST}\n\n!!Need help?\nFor more information:\n*[https://tiki.org/Introduction|Learn more about Tiki].\n*[https://tiki.org/|Get help], including the [http://doc.tiki.org|official documentation] and [http://tiki.org/forums|support forums].\n*[https://tiki.org/Join|Join the Tiki community].\n', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_hotwords`
--

CREATE TABLE `tiki_hotwords` (
  `word` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`word`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages`
--

CREATE TABLE `tiki_html_pages` (
  `pageName` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content` longblob,
  `refresh` int(10) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  PRIMARY KEY (`pageName`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_html_pages_dynamic_zones`
--

CREATE TABLE `tiki_html_pages_dynamic_zones` (
  `pageName` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `zone` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pageName`,`zone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_reps`
--

CREATE TABLE `tiki_integrator_reps` (
  `repID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `start_page` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `css_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `visibility` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `cacheable` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `expiration` int(11) NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_integrator_reps`
--

INSERT INTO `tiki_integrator_reps` VALUES
(1, 'Doxygened (1.3.4) Documentation', '', 'index.html', 'doxygen.css', 'n', 'y', 0, 'Use this repository as rule source for all your repositories based on doxygened docs. To setup yours just add new repository and copy rules from this repository :)');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_integrator_rules`
--

CREATE TABLE `tiki_integrator_rules` (
  `ruleID` int(11) NOT NULL AUTO_INCREMENT,
  `repID` int(11) NOT NULL DEFAULT '0',
  `ord` int(2) unsigned NOT NULL DEFAULT '0',
  `srch` blob NOT NULL,
  `repl` blob NOT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `casesense` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `rxmod` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `enabled` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`ruleID`),
  KEY `repID` (`repID`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=4 ;

--
-- Dumping data for table `tiki_integrator_rules`
--

INSERT INTO `tiki_integrator_rules` VALUES
(1, 1, 1, '.*<body[^>]*?>(.*?)</body.*', '1', 'y', 'n', 'i', 'y', 'Extract code between <body> and </body> tags'),
(2, 1, 2, 'img src=("|'')(?!http://)', 'img src=1{path}/', 'y', 'n', 'i', 'y', 'Fix image paths'),
(3, 1, 3, 'href=("|'')(?!(#|(http|ftp)://))', 'href=1tiki-integrator.php?repID={repID}&file=', 'y', 'n', 'i', 'y', 'Replace internal links to integrator. Don not touch an external link.');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invite`
--

CREATE TABLE `tiki_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inviter` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `groups` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ts` int(11) NOT NULL,
  `emailsubject` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `emailcontent` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `wikicontent` text COLLATE utf8mb4_unicode_ci,
  `wikipageafter` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_invited`
--

CREATE TABLE `tiki_invited` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_invite` int(11) NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `firstname` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastname` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `used` enum('no','registered','logged') COLLATE utf8mb4_unicode_ci NOT NULL,
  `used_on_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_invite` (`id_invite`),
  KEY `used_on_user` (`used_on_user`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_language`
--

CREATE TABLE `tiki_language` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `source` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tran` text COLLATE utf8mb4_unicode_ci,
  `changed` tinyint(1) DEFAULT NULL,
  `general` tinyint(1) DEFAULT NULL COMMENT 'true if this translation is general and can be contributed to the Tiki community, false if it is specific to this instance',
  `userId` int(8) DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_links`
--

CREATE TABLE `tiki_links` (
  `fromPage` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `toPage` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastModif` int(14) NOT NULL,
  PRIMARY KEY (`fromPage`(96),`toPage`(95)),
  KEY `toPage` (`toPage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_link_cache`
--

CREATE TABLE `tiki_link_cache` (
  `cacheId` int(14) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `refresh` int(14) DEFAULT NULL,
  PRIMARY KEY (`cacheId`),
  KEY `url` (`url`(191)),
  KEY `urlindex` (`url`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_events`
--

CREATE TABLE `tiki_live_support_events` (
  `eventId` int(14) NOT NULL AUTO_INCREMENT,
  `reqId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seqId` int(14) DEFAULT NULL,
  `senderId` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_messages`
--

CREATE TABLE `tiki_live_support_messages` (
  `msgId` int(12) NOT NULL AUTO_INCREMENT,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int(2) DEFAULT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_to` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module` int(4) DEFAULT NULL,
  `email` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`msgId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_message_comments`
--

CREATE TABLE `tiki_live_support_message_comments` (
  `cId` int(12) NOT NULL AUTO_INCREMENT,
  `msgId` int(12) DEFAULT NULL,
  `data` text COLLATE utf8mb4_unicode_ci,
  `timestamp` int(14) DEFAULT NULL,
  PRIMARY KEY (`cId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_modules`
--

CREATE TABLE `tiki_live_support_modules` (
  `modId` int(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`modId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=5 ;

--
-- Dumping data for table `tiki_live_support_modules`
--

INSERT INTO `tiki_live_support_modules` VALUES
(1, 'wiki'),
(2, 'forums'),
(3, 'file galleries'),
(4, 'directory');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_operators`
--

CREATE TABLE `tiki_live_support_operators` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `accepted_requests` int(10) DEFAULT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longest_chat` int(10) DEFAULT NULL,
  `shortest_chat` int(10) DEFAULT NULL,
  `average_chat` int(10) DEFAULT NULL,
  `last_chat` int(14) DEFAULT NULL,
  `time_online` int(10) DEFAULT NULL,
  `votes` int(10) DEFAULT NULL,
  `points` int(10) DEFAULT NULL,
  `status_since` int(14) DEFAULT NULL,
  PRIMARY KEY (`user`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_live_support_requests`
--

CREATE TABLE `tiki_live_support_requests` (
  `reqId` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `tiki_user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operator_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` text COLLATE utf8mb4_unicode_ci,
  `req_timestamp` int(14) DEFAULT NULL,
  `timestamp` int(14) DEFAULT NULL,
  `status` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `resolution` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `chat_started` int(14) DEFAULT NULL,
  `chat_ended` int(14) DEFAULT NULL,
  PRIMARY KEY (`reqId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_logs`
--

CREATE TABLE `tiki_logs` (
  `logId` int(8) NOT NULL AUTO_INCREMENT,
  `logtype` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logmessage` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `loguser` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logip` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logclient` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `logtime` int(14) NOT NULL,
  PRIMARY KEY (`logId`),
  KEY `logtype` (`logtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_machine_learning_models`
--

CREATE TABLE `tiki_machine_learning_models` (
  `mlmId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `sourceTrackerId` int(11) NOT NULL,
  `trackerFields` text COLLATE utf8mb4_unicode_ci,
  `labelField` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ignoreEmpty` tinyint(1) DEFAULT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`mlmId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mailin_accounts`
--

CREATE TABLE `tiki_mailin_accounts` (
  `accountId` int(12) NOT NULL AUTO_INCREMENT,
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `account` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `protocol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pop',
  `host` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` int(4) DEFAULT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pass` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `anonymous` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `admin` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `attachments` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `routing` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `article_topicId` int(4) DEFAULT NULL,
  `article_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discard_after` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_inlineImages` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `save_html` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `categoryId` int(12) DEFAULT NULL,
  `namespace` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `respond_email` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y',
  `leave_email` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `galleryId` int(11) DEFAULT NULL,
  `trackerId` int(11) DEFAULT NULL,
  `preferences` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`accountId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_events`
--

CREATE TABLE `tiki_mail_events` (
  `event` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_mail_queue`
--

CREATE TABLE `tiki_mail_queue` (
  `messageId` int(11) NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci,
  `attempts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menus`
--

CREATE TABLE `tiki_menus` (
  `menuId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `use_items_icons` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `parse` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`menuId`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=43 ;

--
-- Dumping data for table `tiki_menus`
--

INSERT INTO `tiki_menus` VALUES
(42, 'Application menu', 'Main extensive navigation menu', 'd', NULL, 'y', 'n');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_languages`
--

CREATE TABLE `tiki_menu_languages` (
  `menuId` int(8) NOT NULL AUTO_INCREMENT,
  `language` char(16) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`menuId`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_menu_options`
--

CREATE TABLE `tiki_menu_options` (
  `optionId` int(8) NOT NULL AUTO_INCREMENT,
  `menuId` int(8) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(4) DEFAULT NULL,
  `section` text COLLATE utf8mb4_unicode_ci,
  `perm` text COLLATE utf8mb4_unicode_ci,
  `groupname` text COLLATE utf8mb4_unicode_ci,
  `userlevel` int(4) DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `class` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`optionId`),
  UNIQUE KEY `uniq_menu` (`menuId`,`name`(30),`url`(50),`position`,`section`(60),`perm`(50),`groupname`(50))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=192 ;

--
-- Dumping data for table `tiki_menu_options`
--

INSERT INTO `tiki_menu_options` VALUES
(1, 42, 'o', 'Home', './', 10, '', '', '', 0, 'home48x48', NULL),
(2, 42, 'o', 'Search', 'tiki-searchresults.php', 13, 'feature_search_fulltext', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(3, 42, 'o', 'Search', 'tiki-searchindex.php', 13, 'feature_search', 'tiki_p_search', '', 0, 'xfce4-appfinder48x48', NULL),
(4, 42, 'o', 'Contact Us', 'tiki-contact.php', 20, 'feature_contact,feature_messages', '', '', 0, 'contactus48x48', NULL),
(5, 42, 'o', 'Stats', 'tiki-stats.php', 23, 'feature_stats', 'tiki_p_view_stats', '', 0, 'stats48x48', NULL),
(6, 42, 'o', 'Categories', 'tiki-browse_categories.php', 25, 'feature_categories', 'tiki_p_view_category', '', 0, 'categories48x48', NULL),
(7, 42, 'o', 'Tags', 'tiki-browse_freetags.php', 27, 'feature_freetags', 'tiki_p_view_freetags', '', 0, 'vcard48x48', NULL),
(8, 42, 'o', 'Calendar', 'tiki-calendar.php', 35, 'feature_calendar', 'tiki_p_view_calendar', '', 0, 'date48x48', NULL),
(9, 42, 'o', 'Tiki Calendar', 'tiki-action_calendar.php', 37, 'feature_action_calendar', 'tiki_p_view_tiki_calendar', '', 0, 'tikicalendar48x48', NULL),
(10, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_view', '', 0, NULL, NULL),
(11, 42, 'o', 'Payments', 'tiki-payment.php', 39, 'payment_feature', 'tiki_p_payment_request', '', 0, NULL, NULL),
(12, 42, 'o', '(debug)', 'javascript:toggle(''debugconsole'')', 40, 'feature_debug_console', 'tiki_p_admin', '', 0, 'debug48x48', NULL),
(13, 42, 'o', 'User Wizard', 'tiki-wizard_user.php', 45, 'feature_wizard_user', '', 'Registered', 0, 'wizard_user48x48', NULL),
(14, 42, 's', 'My Account', 'tiki-my_tiki.php', 50, 'feature_mytiki', '', 'Registered', 0, 'userfiles48x48', NULL),
(15, 42, 'o', 'My Account Home', 'tiki-my_tiki.php', 51, 'feature_mytiki', '', 'Registered', 0, NULL, NULL),
(16, 42, 'o', 'Preferences', 'tiki-user_preferences.php', 55, 'feature_mytiki,feature_userPreferences', '', 'Registered', 0, NULL, NULL),
(17, 42, 'o', 'Messages', 'messu-mailbox.php', 60, 'feature_mytiki,feature_messages', 'tiki_p_messages', 'Registered', 0, NULL, NULL),
(18, 42, 'o', 'Tasks', 'tiki-user_tasks.php', 65, 'feature_mytiki,feature_tasks', 'tiki_p_tasks', 'Registered', 0, NULL, NULL),
(19, 42, 'o', 'Bookmarks', 'tiki-user_bookmarks.php', 70, 'feature_mytiki,feature_user_bookmarks', 'tiki_p_create_bookmarks', 'Registered', 0, NULL, NULL),
(20, 42, 'o', 'Modules', 'tiki-user_assigned_modules.php', 75, 'feature_mytiki,user_assigned_modules', 'tiki_p_configure_modules', 'Registered', 0, NULL, NULL),
(21, 42, 'o', 'Webmail', 'tiki-webmail.php', 85, 'feature_mytiki,feature_webmail', 'tiki_p_use_webmail', 'Registered', 0, NULL, NULL),
(22, 42, 'o', 'Contacts', 'tiki-contacts.php', 87, 'feature_mytiki,feature_contacts', '', 'Registered', 0, NULL, NULL),
(23, 42, 'o', 'Mail-in', 'tiki-user_mailin.php', 88, 'feature_mytiki,feature_mailin', '', 'Registered', 0, NULL, NULL),
(24, 42, 'o', 'Notepad', 'tiki-notepad_list.php', 90, 'feature_mytiki,feature_notepad', 'tiki_p_notepad', 'Registered', 0, NULL, NULL),
(25, 42, 'o', 'My Files', 'tiki-userfiles.php', 95, 'feature_mytiki,feature_userfiles', 'tiki_p_userfiles', 'Registered', 0, NULL, NULL),
(26, 42, 'o', 'User Menu', 'tiki-usermenu.php', 100, 'feature_mytiki,feature_usermenu', 'tiki_p_usermenu', 'Registered', 0, NULL, NULL),
(27, 42, 'o', 'Mini Calendar', 'tiki-minical.php', 105, 'feature_mytiki,feature_minical', 'tiki_p_minical', 'Registered', 0, NULL, NULL),
(28, 42, 'o', 'My Watches', 'tiki-user_watches.php', 110, 'feature_mytiki,feature_user_watches', '', 'Registered', 0, NULL, NULL),
(29, 42, 's', 'Community', 'tiki-list_users.php', 187, 'feature_friends', 'tiki_p_list_users', '', 0, 'users48x48', NULL),
(30, 42, 'o', 'User List', 'tiki-list_users.php', 188, 'feature_friends', 'tiki_p_list_users', '', 0, NULL, NULL),
(31, 42, 'o', 'Friendship Network', 'tiki-friends.php', 189, 'feature_friends', '', 'Registered', 0, NULL, NULL),
(32, 42, 's', 'Wiki', 'tiki-index.php', 200, 'feature_wiki', 'tiki_p_view', '', 0, 'wikipages48x48', NULL),
(33, 42, 'o', 'Wiki Home', 'tiki-index.php', 202, 'feature_wiki', 'tiki_p_view', '', 0, NULL, NULL),
(34, 42, 'o', 'Last Changes', 'tiki-lastchanges.php', 205, 'feature_wiki,feature_lastChanges', 'tiki_p_view', '', 0, NULL, NULL),
(35, 42, 'o', 'Rankings', 'tiki-wiki_rankings.php', 215, 'feature_wiki,feature_wiki_rankings', 'tiki_p_view', '', 0, NULL, NULL),
(36, 42, 'o', 'List Pages', 'tiki-listpages.php?cookietab=1#tab1', 220, 'feature_wiki,feature_listPages', 'tiki_p_view', '', 0, NULL, NULL),
(37, 42, 'o', 'Create a Wiki Page', 'tiki-listpages.php?cookietab=2#tab2', 222, 'feature_wiki,feature_listPages', 'tiki_p_view,tiki_p_edit', '', 0, NULL, NULL),
(38, 42, 'o', 'Orphan Pages', 'tiki-orphan_pages.php', 225, 'feature_wiki,feature_listorphanPages', 'tiki_p_view', '', 0, NULL, NULL),
(39, 42, 'o', 'Sandbox', 'tiki-editpage.php?page=sandbox', 230, 'feature_wiki,feature_sandbox', 'tiki_p_view', '', 0, NULL, NULL),
(40, 42, 'o', 'Multiple Print', 'tiki-print_pages.php', 235, 'feature_wiki,feature_wiki_multiprint', 'tiki_p_view', '', 0, NULL, NULL),
(41, 42, 'o', 'Send Pages', 'tiki-send_objects.php', 240, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_send_pages', '', 0, NULL, NULL),
(42, 42, 'o', 'Received Pages', 'tiki-received_pages.php', 245, 'feature_wiki,feature_comm', 'tiki_p_view,tiki_p_admin_received_pages', '', 0, NULL, NULL),
(43, 42, 'o', 'Structures', 'tiki-admin_structures.php', 250, 'feature_wiki,feature_wiki_structure', 'tiki_p_view', '', 0, NULL, NULL),
(44, 42, 'o', 'Mind Map', 'tiki-mindmap.php', 255, 'feature_wiki_mindmap', 'tiki_p_view', '', 0, NULL, NULL),
(45, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_read_article', '', 0, 'stock_bold48x48', NULL),
(46, 42, 's', 'Articles', 'tiki-view_articles.php', 350, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, 'stock_bold48x48', NULL),
(47, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(48, 42, 'o', 'Articles Home', 'tiki-view_articles.php', 355, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(49, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_read_article', '', 0, NULL, NULL),
(50, 42, 'o', 'List Articles', 'tiki-list_articles.php', 360, 'feature_articles', 'tiki_p_articles_read_heading', '', 0, NULL, NULL),
(51, 42, 'o', 'Rankings', 'tiki-cms_rankings.php', 365, 'feature_articles,feature_cms_rankings', 'tiki_p_read_article', '', 0, NULL, NULL),
(52, 42, 'o', 'Submit Article', 'tiki-edit_submission.php', 370, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(53, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_submit_article', '', 0, NULL, NULL),
(54, 42, 'o', 'View submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_approve_submission', '', 0, NULL, NULL),
(55, 42, 'o', 'View Submissions', 'tiki-list_submissions.php', 375, 'feature_articles,feature_submissions', 'tiki_p_read_article,tiki_p_remove_submission', '', 0, NULL, NULL),
(56, 42, 'o', 'New Article', 'tiki-edit_article.php', 380, 'feature_articles', 'tiki_p_read_article,tiki_p_edit_article', '', 0, NULL, NULL),
(57, 42, 'o', 'Send Articles', 'tiki-send_objects.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_send_articles', '', 0, NULL, NULL),
(58, 42, 'o', 'Received Articles', 'tiki-received_articles.php', 385, 'feature_articles,feature_comm', 'tiki_p_read_article,tiki_p_admin_received_articles', '', 0, NULL, NULL),
(59, 42, 'o', 'Admin Types', 'tiki-article_types.php', 395, 'feature_articles', 'tiki_p_articles_admin_types', '', 0, NULL, NULL),
(60, 42, 'o', 'Admin Topics', 'tiki-admin_topics.php', 390, 'feature_articles', 'tiki_p_articles_admin_topics', '', 0, NULL, NULL),
(61, 42, 's', 'Blogs', 'tiki-list_blogs.php', 450, 'feature_blogs', 'tiki_p_read_blog', '', 0, 'blogs48x48', NULL),
(62, 42, 'o', 'List Blogs', 'tiki-list_blogs.php', 455, 'feature_blogs', 'tiki_p_read_blog', '', 0, NULL, NULL),
(63, 42, 'o', 'Rankings', 'tiki-blog_rankings.php', 460, 'feature_blogs,feature_blog_rankings', 'tiki_p_read_blog', '', 0, NULL, NULL),
(64, 42, 'o', 'Create Blog', 'tiki-edit_blog.php', 465, 'feature_blogs', 'tiki_p_read_blog,tiki_p_create_blogs', '', 0, NULL, NULL),
(65, 42, 'o', 'New Blog Post', 'tiki-blog_post.php', 470, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_post', '', 0, NULL, NULL),
(66, 42, 'o', 'List Blog Posts', 'tiki-list_posts.php', 475, 'feature_blogs', 'tiki_p_read_blog,tiki_p_blog_admin', '', 0, NULL, NULL),
(67, 42, 's', 'Forums', 'tiki-forums.php', 500, 'feature_forums', 'tiki_p_forum_read', '', 0, 'stock_index48x48', NULL),
(68, 42, 'o', 'List Forums', 'tiki-forums.php', 505, 'feature_forums', 'tiki_p_forum_read', '', 0, NULL, NULL),
(69, 42, 'o', 'Rankings', 'tiki-forum_rankings.php', 510, 'feature_forums,feature_forum_rankings', 'tiki_p_forum_read', '', 0, NULL, NULL),
(70, 42, 'o', 'Admin Forums', 'tiki-admin_forums.php', 515, 'feature_forums', 'tiki_p_forum_read,tiki_p_admin_forum', '', 0, NULL, NULL),
(71, 42, 's', 'Directory', 'tiki-directory_browse.php', 550, 'feature_directory', 'tiki_p_view_directory', '', 0, 'directory48x48', NULL),
(72, 42, 'o', 'Submit a new link', 'tiki-directory_add_site.php', 555, 'feature_directory', 'tiki_p_submit_link', '', 0, NULL, NULL),
(73, 42, 'o', 'Browse Directory', 'tiki-directory_browse.php', 560, 'feature_directory', 'tiki_p_view_directory', '', 0, NULL, NULL),
(74, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_cats', '', 0, NULL, NULL),
(75, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_admin_directory_sites', '', 0, NULL, NULL),
(76, 42, 'o', 'Admin Directory', 'tiki-directory_admin.php', 565, 'feature_directory', 'tiki_p_view_directory,tiki_p_validate_links', '', 0, NULL, NULL),
(77, 42, 's', 'File Galleries', 'tiki-list_file_gallery.php', 600, 'feature_file_galleries', 'tiki_p_list_file_galleries|tiki_p_view_file_gallery|tiki_p_upload_files', '', 0, 'file-manager48x48', NULL),
(78, 42, 'o', 'List Galleries', 'tiki-list_file_gallery.php', 605, 'feature_file_galleries', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(79, 42, 'o', 'Rankings', 'tiki-file_galleries_rankings.php', 610, 'feature_file_galleries,feature_file_galleries_rankings', 'tiki_p_list_file_galleries', '', 0, NULL, NULL),
(80, 42, 'o', 'Upload File', 'tiki-upload_file.php', 615, 'feature_file_galleries', 'tiki_p_upload_files', '', 0, NULL, NULL),
(81, 42, 'o', 'Directory batch', 'tiki-batch_upload_files.php', 617, 'feature_file_galleries_batch', 'tiki_p_batch_upload_file_dir', '', 0, NULL, NULL),
(82, 42, 's', 'FAQs', 'tiki-list_faqs.php', 650, 'feature_faqs', 'tiki_p_view_faqs', '', 0, 'stock_dialog_question48x48', NULL),
(83, 42, 'o', 'List FAQs', 'tiki-list_faqs.php', 665, 'feature_faqs', 'tiki_p_view_faqs', '', 0, NULL, NULL),
(84, 42, 'o', 'Admin FAQs', 'tiki-list_faqs.php', 660, 'feature_faqs', 'tiki_p_admin_faqs', '', 0, NULL, NULL),
(85, 42, 's', 'Quizzes', 'tiki-list_quizzes.php', 750, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, 'quizzes48x48', NULL),
(86, 42, 'o', 'List Quizzes', 'tiki-list_quizzes.php', 755, 'feature_quizzes', 'tiki_p_take_quiz', '', 0, NULL, NULL),
(87, 42, 'o', 'Quiz Stats', 'tiki-quiz_stats.php', 760, 'feature_quizzes', 'tiki_p_view_quiz_stats', '', 0, NULL, NULL),
(88, 42, 'o', 'Admin Quizzes', 'tiki-edit_quiz.php', 765, 'feature_quizzes', 'tiki_p_admin_quizzes', '', 0, NULL, NULL),
(89, 42, 's', 'Spreadsheets', 'tiki-sheets.php', 780, 'feature_sheet', 'tiki_p_view_sheet', '', 0, 'spreadsheet48x48', NULL),
(90, 42, 'o', 'List Sheets', 'tiki-sheets.php', 782, 'feature_sheet', 'tiki_p_view_sheet', '', 0, NULL, NULL),
(91, 42, 's', 'Trackers', 'tiki-list_trackers.php', 800, 'feature_trackers', 'tiki_p_list_trackers', '', 0, 'gnome-settings-font48x48', NULL),
(92, 42, 'o', 'List Trackers', 'tiki-list_trackers.php', 805, 'feature_trackers', 'tiki_p_list_trackers', '', 0, NULL, NULL),
(93, 42, 'o', 'Manage Tabular Formats', 'tiki-tabular-manage', 810, 'tracker_tabular_enabled', 'tiki_p_tabular_admin', '', 0, NULL, NULL),
(94, 42, 's', 'Machine Learning', 'tiki-ml-list', 820, 'feature_machine_learning', 'tiki_p_machine_learning', '', 0, NULL, NULL),
(95, 42, 'o', 'List Models', 'tiki-ml-list', 825, 'feature_machine_learning', 'tiki_p_machine_learning', '', 0, NULL, NULL),
(96, 42, 's', 'Accounting', 'tiki-accounting_books.php', 830, 'feature_accounting', 'tiki_p_acct_view', '', 0, 'accounting48x48', NULL),
(97, 42, 'o', 'Accounting books', 'tiki-accounting_books.php', 835, 'feature_accounting', 'tiki_p_acct_view', '', 0, NULL, NULL),
(98, 42, 's', 'Surveys', 'tiki-list_surveys.php', 850, 'feature_surveys', 'tiki_p_take_survey', '', 0, 'surveys48x48', NULL),
(99, 42, 'o', 'List Surveys', 'tiki-list_surveys.php', 855, 'feature_surveys', 'tiki_p_take_survey', '', 0, NULL, NULL),
(100, 42, 'o', 'Stats', 'tiki-survey_stats.php', 860, 'feature_surveys', 'tiki_p_view_survey_stats', '', 0, 'stats48x48', NULL),
(101, 42, 'o', 'Admin Surveys', 'tiki-admin_surveys.php', 865, 'feature_surveys', 'tiki_p_admin_surveys', '', 0, NULL, NULL),
(102, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_subscribe_newsletters', '', 0, 'messages48x48', NULL),
(103, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, 'messages48x48', NULL),
(104, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, 'messages48x48', NULL),
(105, 42, 's', 'Newsletters', 'tiki-newsletters.php', 900, 'feature_newsletters', 'tiki_p_list_newsletters', '', 0, 'messages48x48', NULL),
(106, 42, 'o', 'Send Newsletters', 'tiki-send_newsletters.php', 905, 'feature_newsletters', 'tiki_p_send_newsletters', '', 0, NULL, NULL),
(107, 42, 'o', 'Admin Newsletters', 'tiki-admin_newsletters.php', 910, 'feature_newsletters', 'tiki_p_admin_newsletters', '', 0, NULL, NULL),
(108, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin', '', 0, 'icon-configuration48x48', NULL),
(109, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_categories', '', 0, 'icon-configuration48x48', NULL),
(110, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_banners', '', 0, 'icon-configuration48x48', NULL),
(111, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(112, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_cookies', '', 0, 'icon-configuration48x48', NULL),
(113, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_dynamic', '', 0, 'icon-configuration48x48', NULL),
(114, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_mailin', '', 0, 'icon-configuration48x48', NULL),
(115, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_content_templates', '', 0, 'icon-configuration48x48', NULL),
(116, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_html_pages', '', 0, 'icon-configuration48x48', NULL),
(117, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_view_referer_stats', '', 0, 'icon-configuration48x48', NULL),
(118, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_shoutbox', '', 0, 'icon-configuration48x48', NULL),
(119, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_live_support_admin', '', 0, 'icon-configuration48x48', NULL),
(120, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'user_is_operator', '', 0, 'icon-configuration48x48', NULL),
(121, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, 'icon-configuration48x48', NULL),
(122, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(123, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_view_tpl', 'tiki_p_edit_templates', '', 0, 'icon-configuration48x48', NULL),
(124, 42, 'r', 'Settings', 'tiki-admin.php', 1050, 'feature_editcss', 'tiki_p_create_css', '', 0, 'icon-configuration48x48', NULL),
(125, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_contribution', '', 0, 'icon-configuration48x48', NULL),
(126, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_users', '', 0, 'icon-configuration48x48', NULL),
(127, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_toolbars', '', 0, 'icon-configuration48x48', NULL),
(128, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_edit_menu', '', 0, 'icon-configuration48x48', NULL),
(129, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_clean_cache', '', 0, 'icon-configuration48x48', NULL),
(130, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_modules', '', 0, 'icon-configuration48x48', NULL),
(131, 42, 'r', 'Settings', 'tiki-admin.php', 1050, '', 'tiki_p_admin_webservices', '', 0, 'icon-configuration48x48', NULL),
(132, 42, 'o', ' Control Panels', 'tiki-admin.php', 1051, '', 'tiki_p_admin', '', 0, NULL, NULL),
(133, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'tiki_p_live_support_admin', '', 0, NULL, NULL),
(134, 42, 'o', 'Live Support', 'tiki-live_support_admin.php', 1055, 'feature_live_support', 'user_is_operator', '', 0, NULL, NULL),
(135, 42, 'o', 'Banning', 'tiki-admin_banning.php', 1060, 'feature_banning', 'tiki_p_admin_banning', '', 0, NULL, NULL),
(136, 42, 'o', 'Calendar', 'tiki-admin_calendars.php', 1065, 'feature_calendar', 'tiki_p_admin_calendar', '', 0, NULL, NULL),
(137, 42, 'o', 'Admin credits', 'tiki-admin_credits.php', 1067, 'payment_feature', 'tiki_p_admin_users', '', 0, NULL, NULL),
(138, 42, 'o', 'Users', 'tiki-adminusers.php', 1070, '', 'tiki_p_admin_users', '', 0, NULL, NULL),
(139, 42, 'o', 'Groups', 'tiki-admingroups.php', 1075, '', 'tiki_p_admin', '', 0, NULL, NULL),
(140, 42, 'o', 'External Pages Cache', 'tiki-list_cache.php', 1080, 'cachepages', 'tiki_p_admin', '', 0, NULL, NULL),
(141, 42, 'o', 'Modules', 'tiki-admin_modules.php', 1085, '', 'tiki_p_admin_modules', '', 0, NULL, NULL),
(142, 42, 'o', 'Performance', 'tiki-performance_stats.php', 1088, '', 'tiki_monitor_performance', '', 0, NULL, NULL),
(143, 42, 'o', 'Hotwords', 'tiki-admin_hotwords.php', 1095, 'feature_hotwords', 'tiki_p_admin', '', 0, NULL, NULL),
(144, 42, 'o', 'Edit languages', 'tiki-edit_languages.php', 1098, 'lang_use_db', 'tiki_p_edit_languages', '', 0, NULL, NULL),
(145, 42, 'o', 'External Feeds', 'tiki-admin_rssmodules.php', 1100, '', 'tiki_p_admin_rssmodules', '', 0, NULL, NULL),
(146, 42, 'o', 'External Wikis', 'tiki-admin_external_wikis.php', 1102, '', 'tiki_p_admin', '', 0, NULL, NULL),
(147, 42, 'o', 'Menus', 'tiki-admin_menus.php', 1105, '', 'tiki_p_edit_menu', '', 0, NULL, NULL),
(148, 42, 'o', 'Polls', 'tiki-admin_polls.php', 1110, 'feature_polls', 'tiki_p_admin_polls', '', 0, NULL, NULL),
(149, 42, 'o', 'Mail Notifications', 'tiki-admin_notifications.php', 1120, '', 'tiki_p_admin_notifications', '', 0, NULL, NULL),
(150, 42, 'o', 'Search Stats', 'tiki-search_stats.php', 1125, 'feature_search_stats', 'tiki_p_admin', '', 0, NULL, NULL),
(151, 42, 'o', 'Theme Control', 'tiki-theme_control.php', 1130, 'feature_theme_control', 'tiki_p_admin', '', 0, NULL, NULL),
(152, 42, 'o', 'Tokens', 'tiki-admin_tokens.php', 1132, 'auth_token_access', 'tiki_p_admin', '', 0, NULL, NULL),
(153, 42, 'o', 'Toolbars', 'tiki-admin_toolbars.php', 1135, '', 'tiki_p_admin_toolbars', '', 0, NULL, NULL),
(154, 42, 'o', 'Transitions', 'tiki-admin_transitions.php', 1140, '', 'tiki_p_admin', '', 0, NULL, NULL),
(155, 42, 'o', 'Categories', 'tiki-admin_categories.php', 1145, 'feature_categories', 'tiki_p_admin_categories', '', 0, 'categories48x48', NULL),
(156, 42, 'o', 'Banners', 'tiki-list_banners.php', 1150, 'feature_banners', 'tiki_p_admin_banners', '', 0, NULL, NULL),
(157, 42, 'o', 'Edit Templates', 'tiki-edit_templates.php', 1155, 'feature_edit_templates', 'tiki_p_edit_templates', '', 0, NULL, NULL),
(158, 42, 'o', 'View Templates', 'tiki-edit_templates.php', 1155, 'feature_view_tpl', 'tiki_p_edit_templates', '', 2, NULL, NULL),
(159, 42, 'o', 'Edit CSS', 'tiki-edit_css.php', 1158, 'feature_editcss', 'tiki_p_create_css', '', 2, NULL, NULL),
(160, 42, 'o', 'Dynamic content', 'tiki-list_contents.php', 1165, 'feature_dynamic_content', 'tiki_p_admin_dynamic', '', 0, NULL, NULL),
(161, 42, 'o', 'Mail-in', 'tiki-admin_mailin.php', 1175, 'feature_mailin', 'tiki_p_admin_mailin', '', 0, NULL, NULL),
(162, 42, 'o', 'HTML Pages', 'tiki-admin_html_pages.php', 1185, 'feature_html_pages', 'tiki_p_edit_html_pages', '', 0, NULL, NULL),
(163, 42, 'o', 'Shoutbox', 'tiki-shoutbox.php', 1190, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(164, 42, 'o', 'Shoutbox Words', 'tiki-admin_shoutbox_words.php', 1191, 'feature_shoutbox', 'tiki_p_admin_shoutbox', '', 0, NULL, NULL),
(165, 42, 'o', 'Referer Stats', 'tiki-referer_stats.php', 1195, 'feature_referer_stats', 'tiki_p_view_referer_stats', '', 0, NULL, NULL),
(166, 42, 'o', 'Integrator', 'tiki-admin_integrator.php', 1205, 'feature_integrator', 'tiki_p_admin_integrator', '', 0, NULL, NULL),
(167, 42, 'o', 'phpinfo', 'tiki-phpinfo.php', 1215, '', 'tiki_p_admin', '', 0, NULL, NULL),
(168, 42, 'o', 'Tiki Cache/Sys Admin', 'tiki-admin_system.php', 1230, '', 'tiki_p_clean_cache', '', 0, NULL, NULL),
(169, 42, 'o', 'Tiki Importer', 'tiki-importer.php', 1240, '', 'tiki_p_admin_importer', '', 0, NULL, NULL),
(170, 42, 'o', 'Tiki Logs', 'tiki-syslog.php', 1245, '', 'tiki_p_admin', '', 0, NULL, NULL),
(171, 42, 'o', 'Security Admin', 'tiki-admin_security.php', 1250, '', 'tiki_p_admin', '', 0, NULL, NULL),
(172, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_admin', '', 0, NULL, NULL),
(173, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog', '', 0, NULL, NULL),
(174, 42, 'o', 'Action Log', 'tiki-admin_actionlog.php', 1255, 'feature_actionlog', 'tiki_p_view_actionlog_owngroups', '', 0, NULL, NULL),
(175, 42, 'o', 'Content Templates', 'tiki-admin_content_templates.php', 1256, 'feature_wiki_templates', 'tiki_p_edit_content_templates', '', 0, NULL, NULL),
(176, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_wiki_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(177, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_article_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(178, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_file_galleries_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(179, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_poll_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(180, 42, 'o', 'Comments', 'tiki-list_comments.php', 1260, 'feature_faq_comments', 'tiki_p_admin', '', 0, NULL, NULL),
(181, 42, 'o', 'Contribution', 'tiki-admin_contribution.php', 1265, 'feature_contribution', 'tiki_p_admin_contribution', '', 0, NULL, NULL),
(182, 42, 's', 'Kaltura Video', 'tiki-list_kaltura_entries.php', 950, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, 'kaltura48x48', NULL),
(183, 42, 'o', 'List Media', 'tiki-list_kaltura_entries.php', 952, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_list_videos', '', 0, NULL, NULL),
(184, 42, 'o', 'Upload Media', 'tiki-kaltura_upload.php', 954, 'feature_kaltura', 'tiki_p_admin | tiki_p_admin_kaltura | tiki_p_upload_videos', '', 0, NULL, NULL),
(185, 42, 'o', 'Permissions', 'tiki-objectpermissions.php', 1077, '', 'tiki_p_admin|tiki_p_admin_objects', '', 0, NULL, NULL),
(186, 42, 'o', 'Perspectives', 'tiki-edit_perspective.php', 1081, 'feature_perspective', 'tiki_p_admin', '', 0, NULL, NULL),
(187, 42, 'o', 'Social networks', 'tiki-socialnetworks.php', 115, 'feature_mytiki,feature_socialnetworks', 'tiki_p_socialnetworks|tiki_p_admin_socialnetworks', 'Registered', 0, NULL, NULL),
(188, 42, 'o', 'Scheduler', 'tiki-admin_schedulers.php', 1270, '', 'tiki_p_admin', '', 0, NULL, NULL),
(189, 42, 'o', 'Webservices', 'tiki-admin_webservices.php', 1280, 'feature_webservices', 'tiki_p_admin_webservices', '', 0, NULL, NULL),
(190, 42, 'o', 'References', 'tiki-references.php', 255, 'feature_wiki,feature_references', 'tiki_p_edit_references', '', 0, NULL, NULL),
(191, 42, 'o', 'Custom Routes', 'tiki-admin_routes.php', 1290, 'feature_sefurl_routes', 'tiki_p_admin', '', 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_events`
--

CREATE TABLE `tiki_minical_events` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `eventId` int(12) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `start` int(14) DEFAULT NULL,
  `end` int(14) DEFAULT NULL,
  `security` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` int(3) DEFAULT NULL,
  `topicId` int(12) DEFAULT NULL,
  `reminded` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`eventId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minical_topics`
--

CREATE TABLE `tiki_minical_topics` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `topicId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filename` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filetype` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesize` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `data` longblob,
  `path` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isIcon` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`topicId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_minichat`
--

CREATE TABLE `tiki_minichat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channel` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ts` int(10) unsigned NOT NULL,
  `user` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nick` varchar(31) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `msg` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `channel` (`channel`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_modules`
--

CREATE TABLE `tiki_modules` (
  `moduleId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `ord` int(4) NOT NULL DEFAULT '0',
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cache_time` int(14) DEFAULT NULL,
  `rows` int(4) DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `groups` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`moduleId`),
  KEY `positionType` (`position`,`type`),
  KEY `namePosOrdParam` (`name`(100),`position`,`ord`,`params`(120))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `tiki_modules`
--

INSERT INTO `tiki_modules` VALUES
(1, 'menu', 'left', 1, NULL, NULL, 7200, NULL, 'id=42&title=System+Menu', 'a:1:{i:0;s:10:"Registered";}'),
(2, 'logo', 'top', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(3, 'login_box', 'top', 2, NULL, NULL, 0, NULL, 'mode=popup&nobox=y', 'a:0:{}'),
(4, 'rsslist', 'bottom', 1, NULL, NULL, 7200, NULL, 'nobox=y', 'a:0:{}'),
(5, 'poweredby', 'bottom', 2, NULL, NULL, 7200, NULL, 'nobox=y&icons=n&version=n', 'a:0:{}');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletters`
--

CREATE TABLE `tiki_newsletters` (
  `nlId` int(12) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `lastSent` int(14) DEFAULT NULL,
  `editions` int(10) DEFAULT NULL,
  `users` int(10) DEFAULT NULL,
  `allowUserSub` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `allowAnySub` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unsubMsg` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `validateAddr` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `frequency` int(14) DEFAULT NULL,
  `allowTxt` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `allowArticleClip` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  `autoArticleClip` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `articleClipTypes` text COLLATE utf8mb4_unicode_ci,
  `articleClipRange` int(14) DEFAULT NULL,
  `emptyClipBlocksSend` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  PRIMARY KEY (`nlId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_groups`
--

CREATE TABLE `tiki_newsletter_groups` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `groupName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `include_groups` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'y',
  PRIMARY KEY (`nlId`,`groupName`(179))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_included`
--

CREATE TABLE `tiki_newsletter_included` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `includedId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nlId`,`includedId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_pages`
--

CREATE TABLE `tiki_newsletter_pages` (
  `nlId` int(12) NOT NULL,
  `wikiPageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `validateAddrs` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `addToList` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`wikiPageName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_newsletter_subscriptions`
--

CREATE TABLE `tiki_newsletter_subscriptions` (
  `nlId` int(12) NOT NULL DEFAULT '0',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `valid` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscribed` int(14) DEFAULT NULL,
  `isUser` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  `included` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`nlId`,`email`(178),`isUser`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_oauthserver_clients`
--

CREATE TABLE `tiki_oauthserver_clients` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `client_secret` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `redirect_uri` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `client_id` (`client_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_objects`
--

CREATE TABLE `tiki_objects` (
  `objectId` int(12) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `itemId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created` int(14) DEFAULT NULL,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `href` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `comments_locked` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n',
  PRIMARY KEY (`objectId`),
  KEY `type` (`type`,`objectId`),
  KEY `itemId` (`itemId`(141),`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_attributes`
--

CREATE TABLE `tiki_object_attributes` (
  `attributeId` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribute` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`attributeId`),
  UNIQUE KEY `item_attribute_uq` (`type`,`itemId`(91),`attribute`(50)),
  KEY `attribute_lookup_ix` (`attribute`,`value`(121))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_ratings`
--

CREATE TABLE `tiki_object_ratings` (
  `catObjectId` int(12) NOT NULL DEFAULT '0',
  `pollId` int(12) NOT NULL DEFAULT '0',
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_relations`
--

CREATE TABLE `tiki_object_relations` (
  `relationId` int(11) NOT NULL AUTO_INCREMENT,
  `relation` varchar(70) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source_itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_itemId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`relationId`),
  KEY `relation_source_ix` (`source_type`,`source_itemId`),
  KEY `relation_target_ix` (`target_type`,`target_itemId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_object_scores`
--

CREATE TABLE `tiki_object_scores` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `triggerObjectType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerObjectId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerUser` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `triggerEvent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ruleId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipientObjectType` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `recipientObjectId` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pointsAssigned` int(11) NOT NULL,
  `pointsBalance` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `reversalOf` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_output`
--

CREATE TABLE `tiki_output` (
  `entityId` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `objectType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `outputType` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(8) NOT NULL DEFAULT '0',
  `outputId` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`outputId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages`
--

CREATE TABLE `tiki_pages` (
  `page_id` int(14) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pageSlug` varchar(160) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(8) DEFAULT NULL,
  `data` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastModif` int(14) DEFAULT NULL,
  `comment` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `version` int(8) NOT NULL DEFAULT '0',
  `version_minor` int(8) NOT NULL DEFAULT '0',
  `user` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flag` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `points` int(8) DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `cache` longtext COLLATE utf8mb4_unicode_ci,
  `wiki_cache` int(10) DEFAULT NULL,
  `cache_timestamp` int(14) DEFAULT NULL,
  `pageRank` decimal(4,3) DEFAULT NULL,
  `creator` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_size` int(10) unsigned DEFAULT '0',
  `lang` varchar(16) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockedby` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_html` tinyint(1) DEFAULT '0',
  `created` int(14) DEFAULT NULL,
  `wysiwyg` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `wiki_authors_style` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `comments_enabled` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `pageName` (`pageName`),
  UNIQUE KEY `pageSlug` (`pageSlug`),
  KEY `data` (`data`(191)),
  KEY `pageRank` (`pageRank`),
  KEY `lastModif` (`lastModif`),
  FULLTEXT KEY `ft` (`pageName`,`description`,`data`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `tiki_pages`
--

INSERT INTO `tiki_pages` VALUES
(1, 'HomePage', 'HomePage', 0, '!Congratulations\nThis is the default homepage for your Tiki. If you are seeing this page, your installation was successful.\n\nYou can change this page after logging in. Please review the [http://doc.tiki.org/Wiki-syntax|wiki syntax] for editing details.\n\n\n!!Get started.\nTo begin configuring your site:\n{FANCYLIST()}\n1) Log in with your newly created password.\n2) Manually [tiki-admin.php?page=features|Enable specific Tiki features] that you didn''t enable with the Admin wizard.\n3) Run [tiki-admin.php?page=profiles|Tiki Profiles] to quickly get up and running.\n{FANCYLIST}\n\n!!Need help?\nFor more information:\n*[https://tiki.org/Introduction|Learn more about Tiki].\n*[https://tiki.org/|Get help], including the [http://doc.tiki.org|official documentation] and [http://tiki.org/forums|support forums].\n*[https://tiki.org/Join|Join the Tiki community].\n', '', [[timestamp]], 'Tiki initialization', 1, 0, 'admin', '0.0.0.0', '', NULL, NULL, NULL, NULL, NULL, NULL, 'admin', 851, 'en', '', 0, [[timestamp]], 'n', '', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_changes`
--

CREATE TABLE `tiki_pages_changes` (
  `page_id` int(14) NOT NULL DEFAULT '0',
  `version` int(10) NOT NULL DEFAULT '0',
  `segments_added` int(10) DEFAULT NULL,
  `segments_removed` int(10) DEFAULT NULL,
  `segments_total` int(10) DEFAULT NULL,
  PRIMARY KEY (`page_id`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pages_translation_bits`
--

CREATE TABLE `tiki_pages_translation_bits` (
  `translation_bit_id` int(14) NOT NULL AUTO_INCREMENT,
  `page_id` int(14) NOT NULL,
  `version` int(8) NOT NULL,
  `source_translation_bit` int(10) DEFAULT NULL,
  `original_translation_bit` int(10) DEFAULT NULL,
  `flags` set('critical') COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`translation_bit_id`),
  KEY `page_id` (`page_id`),
  KEY `original_translation_bit` (`original_translation_bit`),
  KEY `source_translation_bit` (`source_translation_bit`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_pageviews`
--

CREATE TABLE `tiki_pageviews` (
  `day` int(14) NOT NULL DEFAULT '0',
  `pageviews` int(14) DEFAULT NULL,
  PRIMARY KEY (`day`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_footnotes`
--

CREATE TABLE `tiki_page_footnotes` (
  `user` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pageName` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`user`(150),`pageName`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_page_references`
--

CREATE TABLE `tiki_page_references` (
  `ref_id` int(14) NOT NULL AUTO_INCREMENT,
  `page_id` int(14) DEFAULT NULL,
  `biblio_code` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `part` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uri` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publisher` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `style` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ref_id`),
  UNIQUE KEY `uk1_tiki_page_ref_biblio_code` (`page_id`,`biblio_code`),
  KEY `PageId` (`page_id`),
  KEY `idx_tiki_page_ref_title` (`title`(191)),
  KEY `idx_tiki_page_ref_author` (`author`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_password_blacklist`
--

CREATE TABLE `tiki_password_blacklist` (
  `password` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`password`) USING HASH
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_received`
--

CREATE TABLE `tiki_payment_received` (
  `paymentReceivedId` int(11) NOT NULL AUTO_INCREMENT,
  `paymentRequestId` int(11) NOT NULL,
  `payment_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `amount` decimal(7,2) DEFAULT NULL,
  `type` varchar(15) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'paid',
  `details` text COLLATE utf8mb4_unicode_ci,
  `userId` int(8) DEFAULT NULL,
  PRIMARY KEY (`paymentReceivedId`),
  KEY `payment_request_ix` (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_payment_requests`
--

CREATE TABLE `tiki_payment_requests` (
  `paymentRequestId` int(11) NOT NULL AUTO_INCREMENT,
  `amount` decimal(7,2) NOT NULL,
  `amount_paid` decimal(7,2) NOT NULL DEFAULT '0.00',
  `currency` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `due_date` timestamp NULL DEFAULT NULL,
  `authorized_until` timestamp NULL DEFAULT NULL,
  `cancel_date` timestamp NULL DEFAULT NULL,
  `description` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `actions` text COLLATE utf8mb4_unicode_ci,
  `detail` text COLLATE utf8mb4_unicode_ci,
  `userId` int(8) DEFAULT NULL,
  PRIMARY KEY (`paymentRequestId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_performance`
--

CREATE TABLE `tiki_performance` (
  `id` int(12) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_taken` int(12) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspectives`
--

CREATE TABLE `tiki_perspectives` (
  `perspectiveId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`perspectiveId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_perspective_preferences`
--

CREATE TABLE `tiki_perspective_preferences` (
  `perspectiveId` int(11) NOT NULL,
  `pref` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`perspectiveId`,`pref`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_plugin_security`
--

CREATE TABLE `tiki_plugin_security` (
  `fingerprint` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `added_by` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approval_by` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_objectType` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_objectId` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`fingerprint`(191)),
  KEY `last_object` (`last_objectType`,`last_objectId`(171))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_polls`
--

CREATE TABLE `tiki_polls` (
  `pollId` int(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `votes` int(8) DEFAULT NULL,
  `active` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publishDate` int(14) DEFAULT NULL,
  `voteConsiderationSpan` int(4) DEFAULT '0',
  PRIMARY KEY (`pollId`),
  KEY `tiki_poll_lookup` (`active`,`title`(190))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_objects`
--

CREATE TABLE `tiki_poll_objects` (
  `catObjectId` int(11) NOT NULL DEFAULT '0',
  `pollId` int(11) NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`catObjectId`,`pollId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_poll_options`
--

CREATE TABLE `tiki_poll_options` (
  `pollId` int(8) NOT NULL DEFAULT '0',
  `optionId` int(8) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(4) NOT NULL DEFAULT '0',
  `votes` int(8) DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_preferences`
--

CREATE TABLE `tiki_preferences` (
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`name`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_preferences`
--

INSERT INTO `tiki_preferences` VALUES
('browsertitle', '[[site_name]]'),
('server_domain', '[[domhost]]'),
('sender_email', '[[admin_email]]'),
('https_login', 'allowed'),
('https_port', '443'),
('error_reporting_level', '2039'),
('use_proxy', 'n'),
('proxy_host', ''),
('proxy_port', ''),
('proxy_user', ''),
('proxy_pass', ''),
('error_reporting_adminonly', 'y'),
('smarty_notice_reporting', 'n'),
('log_tpl', 'n'),
('feature_switch_ssl_mode', 'n'),
('feature_show_stay_in_ssl_mode', 'y'),
('smarty_enable_string_eval', 'n'),
('language', '[[end_language]]'),
('unified_mysql_index_rebuilding', '[[indexName]]'),
('unified_total_fields', '37'),
('unified_field_count', '36'),
('unified_identifier_fields', 'a:12:{i:0;s:8:"language";i:1;s:10:"gallery_id";i:2;s:15:"view_permission";i:3;s:13:"primary_image";i:4;s:11:"geo_located";i:5;s:12:"geo_location";i:6;s:13:"title_initial";i:7;s:15:"title_firstword";i:8;s:10:"searchable";i:9;s:3:"url";i:10;s:11:"object_type";i:11;s:9:"object_id";}'),
('unified_mysql_index_current', '[[indexName]]'),
('unified_last_rebuild', '[[timestamp]]'),
('unified_last_rebuild_stats', 'a:1:{s:7:"default";a:4:{s:6:"counts";a:5:{s:4:"file";i:0;s:12:"file gallery";i:3;s:4:"user";i:1;s:5:"group";i:3;s:9:"wiki page";i:0;}s:5:"times";a:6:{s:4:"file";d:0.0004141330718994140625;s:12:"file gallery";d:0.07614898681640625;s:4:"user";d:0.015861988067626953125;s:5:"group";d:0.0049240589141845703125;s:9:"wiki page";d:0.0001418590545654296875;s:5:"total";d:0.0974910259246826171875;}s:25:"total tiki fields indexed";i:36;s:45:"total fields used in the mysql search index: ";i:37;}}'),
('wizard_admin_hide_on_login', 'n'),
('language_admin', '[[admin_language]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_private_messages`
--

CREATE TABLE `tiki_private_messages` (
  `messageId` int(8) NOT NULL AUTO_INCREMENT,
  `toNickname` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `poster` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'anonymous',
  `timestamp` int(14) DEFAULT NULL,
  `received` tinyint(1) NOT NULL DEFAULT '0',
  `message` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`messageId`),
  KEY `received` (`received`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_profile_symbols`
--

CREATE TABLE `tiki_profile_symbols` (
  `domain` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `profile` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL,
  `named` enum('y','n') COLLATE utf8mb4_unicode_ci NOT NULL,
  `creation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`domain`,`profile`(70),`object`(71)),
  KEY `named` (`named`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_programmed_content`
--

CREATE TABLE `tiki_programmed_content` (
  `pId` int(8) NOT NULL AUTO_INCREMENT,
  `contentId` int(8) NOT NULL DEFAULT '0',
  `content_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `publishDate` int(14) NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`pId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_queue`
--

CREATE TABLE `tiki_queue` (
  `entryId` int(11) NOT NULL AUTO_INCREMENT,
  `queue` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `timestamp` int(11) NOT NULL,
  `handler` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`entryId`),
  KEY `queue_name_ix` (`queue`),
  KEY `queue_handler_ix` (`handler`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quizzes`
--

CREATE TABLE `tiki_quizzes` (
  `quizId` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `canRepeat` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `storeResults` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `questionsPerPage` int(4) DEFAULT NULL,
  `timeLimited` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timeLimit` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `taken` int(10) DEFAULT NULL,
  `immediateFeedback` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `showAnswers` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shuffleQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shuffleAnswers` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `bDeleted` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nAuthor` int(4) DEFAULT NULL,
  `bOnline` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bRandomQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nRandomQuestions` tinyint(4) DEFAULT NULL,
  `bLimitQuestionsPerPage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nLimitQuestionsPerPage` tinyint(4) DEFAULT NULL,
  `bMultiSession` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nCanRepeat` tinyint(4) DEFAULT NULL,
  `sGradingMethod` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sShowScore` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sShowCorrectAnswers` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sPublishStats` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bAdditionalQuestions` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bForum` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sForum` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sPrologue` text COLLATE utf8mb4_unicode_ci,
  `sData` text COLLATE utf8mb4_unicode_ci,
  `sEpilogue` text COLLATE utf8mb4_unicode_ci,
  `passingperct` int(4) DEFAULT '0',
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_questions`
--

CREATE TABLE `tiki_quiz_questions` (
  `questionId` int(10) NOT NULL AUTO_INCREMENT,
  `quizId` int(10) DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `position` int(4) DEFAULT NULL,
  `type` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `maxPoints` int(4) DEFAULT NULL,
  PRIMARY KEY (`questionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_question_options`
--

CREATE TABLE `tiki_quiz_question_options` (
  `optionId` int(10) NOT NULL AUTO_INCREMENT,
  `questionId` int(10) DEFAULT NULL,
  `optionText` text COLLATE utf8mb4_unicode_ci,
  `points` int(4) DEFAULT NULL,
  PRIMARY KEY (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_results`
--

CREATE TABLE `tiki_quiz_results` (
  `resultId` int(10) NOT NULL AUTO_INCREMENT,
  `quizId` int(10) DEFAULT NULL,
  `fromPoints` int(4) DEFAULT NULL,
  `toPoints` int(4) DEFAULT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`resultId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats`
--

CREATE TABLE `tiki_quiz_stats` (
  `quizId` int(10) NOT NULL DEFAULT '0',
  `questionId` int(10) NOT NULL DEFAULT '0',
  `optionId` int(10) NOT NULL DEFAULT '0',
  `votes` int(10) DEFAULT NULL,
  PRIMARY KEY (`quizId`,`questionId`,`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_quiz_stats_sum`
--

CREATE TABLE `tiki_quiz_stats_sum` (
  `quizId` int(10) NOT NULL DEFAULT '0',
  `quizName` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timesTaken` int(10) DEFAULT NULL,
  `avgpoints` decimal(5,2) DEFAULT NULL,
  `avgavg` decimal(5,2) DEFAULT NULL,
  `avgtime` decimal(5,2) DEFAULT NULL,
  PRIMARY KEY (`quizId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_configs`
--

CREATE TABLE `tiki_rating_configs` (
  `ratingConfigId` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiry` int(11) NOT NULL DEFAULT '3600',
  `formula` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `callbacks` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rating_obtained`
--

CREATE TABLE `tiki_rating_obtained` (
  `ratingId` int(11) NOT NULL AUTO_INCREMENT,
  `ratingConfigId` int(11) NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `object` int(11) NOT NULL,
  `expire` int(11) NOT NULL,
  `value` float NOT NULL,
  PRIMARY KEY (`ratingId`),
  UNIQUE KEY `tiki_obtained_rating_uq` (`type`,`object`,`ratingConfigId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_articles`
--

CREATE TABLE `tiki_received_articles` (
  `receivedArticleId` int(14) NOT NULL AUTO_INCREMENT,
  `receivedFromSite` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedDate` int(14) DEFAULT NULL,
  `title` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `authorName` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(12) DEFAULT NULL,
  `useImage` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_name` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_type` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_size` int(14) DEFAULT NULL,
  `image_x` int(4) DEFAULT NULL,
  `image_y` int(4) DEFAULT NULL,
  `image_data` longblob,
  `publishDate` int(14) DEFAULT NULL,
  `expireDate` int(14) DEFAULT NULL,
  `created` int(14) DEFAULT NULL,
  `heading` text COLLATE utf8mb4_unicode_ci,
  `body` longblob,
  `hash` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `author` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating` decimal(3,2) DEFAULT NULL,
  PRIMARY KEY (`receivedArticleId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_received_pages`
--

CREATE TABLE `tiki_received_pages` (
  `receivedPageId` int(14) NOT NULL AUTO_INCREMENT,
  `pageName` varchar(160) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` longblob,
  `description` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromSite` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedFromUser` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receivedDate` int(14) DEFAULT NULL,
  `parent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint(3) unsigned DEFAULT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `structureName` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parentName` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `page_alias` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `pos` int(4) DEFAULT NULL,
  PRIMARY KEY (`receivedPageId`),
  KEY `structureName` (`structureName`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_referer_stats`
--

CREATE TABLE `tiki_referer_stats` (
  `referer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) DEFAULT NULL,
  `last` int(14) DEFAULT NULL,
  `lasturl` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`referer`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_registration_fields`
--

CREATE TABLE `tiki_registration_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `show` tinyint(1) NOT NULL DEFAULT '1',
  `size` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '10',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_related_categories`
--

CREATE TABLE `tiki_related_categories` (
  `categId` int(10) NOT NULL DEFAULT '0',
  `relatedTo` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`categId`,`relatedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_feeds`
--

CREATE TABLE `tiki_rss_feeds` (
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rssVer` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `refresh` int(8) DEFAULT '300',
  `lastUpdated` int(14) DEFAULT NULL,
  `cache` longblob,
  PRIMARY KEY (`name`,`rssVer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_items`
--

CREATE TABLE `tiki_rss_items` (
  `rssItemId` int(11) NOT NULL AUTO_INCREMENT,
  `rssId` int(11) NOT NULL,
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `publication_date` int(10) unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  `categories` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rssItemId`),
  KEY `tiki_rss_items_rss` (`rssId`),
  KEY `tiki_rss_items_item` (`rssId`,`guid`(177))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_rss_modules`
--

CREATE TABLE `tiki_rss_modules` (
  `rssId` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `refresh` int(8) DEFAULT NULL,
  `lastUpdated` int(14) DEFAULT NULL,
  `showTitle` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `showPubDate` char(1) COLLATE utf8mb4_unicode_ci DEFAULT 'n',
  `sitetitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `siteurl` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actions` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`rssId`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_scheduler`
--

CREATE TABLE `tiki_scheduler` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `task` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params` text COLLATE utf8mb4_unicode_ci,
  `run_time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `re_run` tinyint(4) DEFAULT NULL,
  `run_only_once` tinyint(4) DEFAULT NULL,
  `creation_date` int(14) DEFAULT NULL,
  `user_run_now` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_scheduler_run`
--

CREATE TABLE `tiki_scheduler_run` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `scheduler_id` int(11) NOT NULL,
  `start_time` int(14) DEFAULT NULL,
  `end_time` int(14) DEFAULT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `output` text COLLATE utf8mb4_unicode_ci,
  `stalled` tinyint(4) DEFAULT '0',
  `healed` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_schema`
--

CREATE TABLE `tiki_schema` (
  `patch_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `install_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`patch_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_schema`
--

INSERT INTO `tiki_schema` VALUES
('00000000_schema_change_tiki', '[[regtime]]'),
('20080227_invite_tiki', '[[regtime]]'),
('20080809_semlinks_tiki', '[[regtime]]'),
('20080827_bigfeaturetype_tiki', '[[regtime]]'),
('20080829_pagealiasdata_tiki', '[[regtime]]'),
('20080829_pluginvalidation_tiki', '[[regtime]]'),
('20080901_pluginvalidation_tiki', '[[regtime]]'),
('20080902_trackerparsedesc_tiki', '[[regtime]]'),
('20080905_feature_tip_tiki', '[[regtime]]'),
('20080916_webservice_registry_tiki', '[[regtime]]'),
('20080922_calendar_customstatus_tiki', '[[regtime]]'),
('20080924_webmail_tiki', '[[regtime]]'),
('20080926_bannerindex_tiki', '[[regtime]]'),
('20081004_mindmap_menu_tiki', '[[regtime]]'),
('20081006_comments_moderation_tiki', '[[regtime]]'),
('20081008_bit_flags_nullable_tiki', '[[regtime]]'),
('20081010_filter_perms_tiki', '[[regtime]]'),
('20081014_trust_input_perm_tiki', '[[regtime]]'),
('20081018_filter_perms_tiki', '[[regtime]]'),
('20081019_score_tiki', '[[regtime]]'),
('20081022_application_menu_tiki', '[[regtime]]'),
('20081024_fulltext_file_tiki', '[[regtime]]'),
('20081027_calendar_tiki', '[[regtime]]'),
('20081027_file_galleries_tiki', '[[regtime]]'),
('20081027_groupalert_tiki', '[[regtime]]'),
('20081027_surveys_tiki', '[[regtime]]'),
('20081027_trackers_tiki', '[[regtime]]'),
('20081027_wysiwyg_history_tiki', '[[regtime]]'),
('20081029_tracker_index_tiki', '[[regtime]]'),
('20081102_application_menu_structures_tiki', '[[regtime]]'),
('20081105_calendar_items_allday_tiki', '[[regtime]]'),
('20081107_menu42_tiki', '[[regtime]]'),
('20081112_tiki_p_tracker_view_comments_tiki', '[[regtime]]'),
('20081114_tiki_banner_tiki', '[[regtime]]'),
('20081119_tiki_p_export_tracker_tiki', '[[regtime]]'),
('20081120_showCategories_tiki', '[[regtime]]'),
('20081120_tiki_poll_structures_update_tiki', '[[regtime]]'),
('20081125_tiki_tracker_types_tiki', '[[regtime]]'),
('20081127_calendar_recurrence_tiki', '[[regtime]]'),
('20081130_tiki_users_permission_tiki', '[[regtime]]'),
('20081211_newsletter_files_tiki', '[[regtime]]'),
('20081211_score_tiki', '[[regtime]]'),
('20081212_tiki_p_view_backlinks_tiki', '[[regtime]]'),
('20081214_webservice_post_tiki', '[[regtime]]'),
('20090106_group_watch_tiki', '[[regtime]]'),
('20090120_sefurl_rules_tiki', '[[regtime]]'),
('20090129_callendar_search_tiki', '[[regtime]]'),
('20090203_null_tiki', '[[regtime]]'),
('20090205_forum_and_comments_locking_tiki', '[[regtime]]'),
('20090205_menucase_tiki', '[[regtime]]'),
('20090205_menus_items_icons_tiki', '[[regtime]]'),
('20090206_content_tpl_menu_tiki', '[[regtime]]'),
('20090206_poll_tiki', '[[regtime]]'),
('20090211_mailnotification_tiki', '[[regtime]]'),
('20090212_forum_tiki', '[[regtime]]'),
('20090220_admin_section_tiki', '[[regtime]]'),
('20090226_admin_menu_tiki', '[[regtime]]'),
('20090301_browsertitle_tiki', '[[regtime]]'),
('20090304_tiki_p_view_backlink_without_s_tiki', '[[regtime]]'),
('20090306_menu_perms_tiki', '[[regtime]]'),
('20090306_text_for_menu_options_tiki', '[[regtime]]'),
('20090310_application_menu_tiki', '[[regtime]]'),
('20090310_feature_search_show_object_filter_tiki', '[[regtime]]'),
('20090311_remove_mod_menu_application_menu_tiki', '[[regtime]]'),
('20090316_index_tiki', '[[regtime]]'),
('20090323_maxUserImpressions_banners_tiki', '[[regtime]]'),
('20090330_quicktags_renames_tiki', '[[regtime]]'),
('20090401_newsletters_included_tiki', '[[regtime]]'),
('20090401_replace_shoutjax_with_shoutbox_tiki', '[[regtime]]'),
('20090401_replace_switch_lang2_with_switch_lang_tiki', '[[regtime]]'),
('20090416_plugin_security_tiki', '[[regtime]]'),
('20090416_quicktags_kil_email_tiki', '[[regtime]]'),
('20090416_quicktags_plugin_helpers_tiki', '[[regtime]]'),
('20090427_filegal_optionalize_tiki', '[[regtime]]'),
('20090429_groupId_tiki', '[[regtime]]'),
('20090513_calendar_priority_tiki', '[[regtime]]'),
('20090513_swffix_tiki', '[[regtime]]'),
('20090513_wiki_similar_permission_tiki', '[[regtime]]'),
('20090515_score_tiki', '[[regtime]]'),
('20090602_webmail_protocols_tiki', '[[regtime]]'),
('20090605_tiki_p_modify_tracker_items_pending_closed_tiki', '[[regtime]]'),
('20090617_add_new_table_for_reports_tiki', '[[regtime]]'),
('20090623_actionlog_view_article_tiki', '[[regtime]]'),
('20090626_change_pear_auth_preferences_to_ldap_tiki', '[[regtime]]'),
('20090707_tiki_p_delete_account_tiki', '[[regtime]]'),
('20090713_tiki_importer_permission_and_menu_entry_tiki', '[[regtime]]'),
('20090715_sefurl_for_filegalleries_tiki', '[[regtime]]'),
('20090720_perspectives_tiki', '[[regtime]]'),
('20090721_webmail_ext_public_tiki', '[[regtime]]'),
('20090727_category_permissions_tiki', '[[regtime]]'),
('20090727_user_votings_index_tiki', '[[regtime]]'),
('20090730_p_list_newsletters_tiki', '[[regtime]]'),
('20090803_perspective_permission_tiki', '[[regtime]]'),
('20090804_kaltura_permissions_tiki', '[[regtime]]'),
('20090804_menu_search_tiki', '[[regtime]]'),
('20090805_kill_newsreader_tiki', '[[regtime]]'),
('20090805_remove_drawings_prefs_etc_tiki', '[[regtime]]'),
('20090805_remove_games_tiki', '[[regtime]]'),
('20090806_group_permissions_tiki', '[[regtime]]'),
('20090806_menu_list_trackers_tiki', '[[regtime]]'),
('20090806_perms_featurechecks_tiki', '[[regtime]]'),
('20090806_remove_charts_tiki', '[[regtime]]'),
('20090806_remove_latin_collations_tiki', '[[regtime]]'),
('20090806_strasa_option_rename_tiki', '[[regtime]]'),
('20090807_transitions_tiki', '[[regtime]]'),
('20090808_add_wiki_minor_edits_tiki', '[[regtime]]'),
('20090809_marc_needs_more_space_tiki', '[[regtime]]'),
('20090811_filegals_container_tiki', '[[regtime]]'),
('20090811_kaltura_editor_pref_tiki', '[[regtime]]'),
('20090811_quizzes_tiki', '[[regtime]]'),
('20090811_rename_quicktags_to_toolbars_tiki', '[[regtime]]'),
('20090823_kaltura_menu_options_tiki', '[[regtime]]'),
('20090826_group_expiration_tiki', '[[regtime]]'),
('20090904_wysiwyg_newsletters_tiki', '[[regtime]]'),
('20090911_tracker_item_change_user_tiki', '[[regtime]]'),
('20090912_change_feature_name_for_lesser_magic_tiki', '[[regtime]]'),
('20090913_plugin_security_addedby_tiki', '[[regtime]]'),
('20090915_change_perms_for_browse_cats_tiki', '[[regtime]]'),
('20090921_logo_tiki', '[[regtime]]'),
('20090923_mod_change_category_defaults_tiki', '[[regtime]]'),
('20090925_online_logged_users_modules_merge_tiki', '[[regtime]]'),
('20090927_top_images_modules_merge_tiki', '[[regtime]]'),
('20090928_galaxia_leftovers_tiki', '[[regtime]]'),
('20090928_last_images_modules_merge_tiki', '[[regtime]]'),
('20090928_transition_guards_text_tiki', '[[regtime]]'),
('20091004_last_tracker_items_modules_merge_tiki', '[[regtime]]'),
('20091007_update_database_structure_tiki', '[[regtime]]'),
('20091008_reg_group_includes_anon_tiki', '[[regtime]]'),
('20091011_serurl_dl_order_tiki', '[[regtime]]'),
('20091013_fix_perms_tiki', '[[regtime]]'),
('20091015_application_menu_admin_renames_tiki', '[[regtime]]'),
('20091016_categorization_tracker_item_tiki', '[[regtime]]'),
('20091019_article_by_rating_modules_merge_tiki', '[[regtime]]'),
('20091019_last_articles_modules_merge_tiki', '[[regtime]]'),
('20091019_users_perms_types_tidying_tiki', '[[regtime]]'),
('20091020_bigger_user_prefs_tiki', '[[regtime]]'),
('20091020_faq_created_tiki', '[[regtime]]'),
('20091020_kaltura_tiki', '[[regtime]]'),
('20091020_remove_charts_tiki', '[[regtime]]'),
('20091020_sefurl_trackeritem_tiki', '[[regtime]]'),
('20091021_moz_pagelist_tiki', '[[regtime]]'),
('20091023_bookmarks_name_lengthen_tiki', '[[regtime]]'),
('20091023_nul_categ_tiki', '[[regtime]]'),
('20091023_report_tiki', '[[regtime]]'),
('20091027_multiple_session_handler_tiki', '[[regtime]]'),
('20091028_quota_tiki', '[[regtime]]'),
('20091030_wiki_watch_tiki', '[[regtime]]'),
('20091103_upgrade_categperm_tiki', '[[regtime]]'),
('20091105_auth_tokens_tiki', '[[regtime]]'),
('20091111_fgal_size_tiki', '[[regtime]]'),
('20091112_rename_mnu_application_menu_tiki', '[[regtime]]'),
('20091112_template_type_tiki', '[[regtime]]'),
('20091113_old_categ_perm_tiki', '[[regtime]]'),
('20091118_sefurl_tiki', '[[regtime]]'),
('20091120_poll_lookup_index_tiki', '[[regtime]]'),
('20091120_username_pattern_tiki', '[[regtime]]'),
('20091123_dns_permission_tiki', '[[regtime]]'),
('20091123_metrics_tiki', '[[regtime]]'),
('20091123_upgrade_categperm_2_tiki', '[[regtime]]'),
('20091124_fgal_backlink_tiki', '[[regtime]]'),
('20091124_metrics_dsn_tiki', '[[regtime]]'),
('20091125_wiki_comments_per_page_tiki', '[[regtime]]'),
('20091126_dynamic_variables_i18n_tiki', '[[regtime]]'),
('20091204_filegal_wiki_syntax_tiki', '[[regtime]]'),
('20091204_tiki_p_view_newsletter_tiki', '[[regtime]]'),
('20091208_backlink_perms_tiki', '[[regtime]]'),
('20091209_rss_feeds_name_tiki', '[[regtime]]'),
('20091210_charset_tiki', '[[regtime]]'),
('20091210_dcs_type_tiki', '[[regtime]]'),
('20091214_perspective_management_tiki', '[[regtime]]'),
('20091216_show_backlinks_tiki', '[[regtime]]'),
('20091228_page_keywords_tiki', '[[regtime]]'),
('20100101_search_modules_merge_tiki', '[[regtime]]'),
('20100101_search_wiki_page_modules_merge_tiki', '[[regtime]]'),
('20100104_tiki_p_tracker_revote_ratings_tiki', '[[regtime]]'),
('20100106_forum_att_list_nb_tiki', '[[regtime]]'),
('20100107_payment_tiki', '[[regtime]]'),
('20100113_forum_display_tiki', '[[regtime]]'),
('20100114_tiki_actionlog_merge_tiki', '[[regtime]]'),
('20100115_admin_modules_menu_tiki', '[[regtime]]'),
('20100115_tiki_p_admin_modules_tiki', '[[regtime]]'),
('20100115_translations_in_progress_tiki', '[[regtime]]'),
('20100117_old_doc_tw_o_url_tiki', '[[regtime]]'),
('20100118_blog_use_author_tiki', '[[regtime]]'),
('20100118_forum_display_tiki', '[[regtime]]'),
('20100126_file_lastDownload_tiki', '[[regtime]]'),
('20100128_tiki_p_blog_view_ref_tiki', '[[regtime]]'),
('20100129_clean_up_tiki', '[[regtime]]'),
('20100129_events_kil_tiki', '[[regtime]]'),
('20100203_payment_detail_tiki', '[[regtime]]'),
('20100205_tiki_p_wiki_view_ref_tiki', '[[regtime]]'),
('20100207_repair_file_galleries_tiki', '[[regtime]]'),
('20100211_rss_items_tiki', '[[regtime]]'),
('20100211_tiki_perms_menu_item_tiki', '[[regtime]]'),
('20100211_tiki_sheet_add_parseValues_tiki', '[[regtime]]'),
('20100212_rss_automation_tiki', '[[regtime]]'),
('20100213_group_inclusion_key_tiki', '[[regtime]]'),
('20100214_workspaces_remove_menu_items_tiki', '[[regtime]]'),
('20100215_create_tiki_user_login_cookies_tiki', '[[regtime]]'),
('20100215_rating_permissions_tiki', '[[regtime]]'),
('20100216_attributes_tiki', '[[regtime]]'),
('20100216_kil_moz_screencast_tiki', '[[regtime]]'),
('20100216_rename_tikisheet_tiki', '[[regtime]]'),
('20100217_rating_config_tiki', '[[regtime]]'),
('20100218_auth_token_reuse_tiki', '[[regtime]]'),
('20100222_add_webmail_fromEmail_field_tiki', '[[regtime]]'),
('20100222_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100223_blog_always_owner_tiki', '[[regtime]]'),
('20100224_object_relations_tiki', '[[regtime]]'),
('20100226_menu_template_feature_check_tiki', '[[regtime]]'),
('20100226_tracker_dump_perm_tiki', '[[regtime]]'),
('20100302_filegal_images_max_sizes_tiki', '[[regtime]]'),
('20100308_file_delete_after_tiki', '[[regtime]]'),
('20100309_add_sheet_parent_tiki', '[[regtime]]'),
('20100312_emailPattern_tiki', '[[regtime]]'),
('20100324_newsletters_clippings_tiki', '[[regtime]]'),
('20100409_bigger_module_params_tiki', '[[regtime]]'),
('20100414_actionlog_pref_tiki', '[[regtime]]'),
('20100414_actionlog_system_tiki', '[[regtime]]'),
('20100419_bigbluebutton_tiki', '[[regtime]]'),
('20100422_tracker_log_tiki', '[[regtime]]'),
('20100429_newsletter_pages_tiki', '[[regtime]]'),
('20100507_flash_banner_tiki', '[[regtime]]'),
('20100519_actionlog_tiki', '[[regtime]]'),
('20100525_tracker_validation_message_tiki', '[[regtime]]'),
('20100525_tracker_validation_tiki', '[[regtime]]'),
('20100611_rss_items_url_tiki', '[[regtime]]'),
('20100617_sefurl_user_info_tiki', '[[regtime]]'),
('20100618_calendar_participation_tiki', '[[regtime]]'),
('20100621_pageprefixaliasdata_tiki', '[[regtime]]'),
('20100622_pageprefixtrackeritemid_tiki', '[[regtime]]'),
('20100623_semantic_to_relation_tiki', '[[regtime]]'),
('20100624_banning_index_tiki', '[[regtime]]'),
('20100628_payment_user_tiki', '[[regtime]]'),
('20100629_remove_feature_blog_comments_tiki', '[[regtime]]'),
('20100702_discount_tiki', '[[regtime]]'),
('20100712_remove_unsupported_feed_formats_tiki', '[[regtime]]'),
('20100713_rename_feed_prefs_tiki', '[[regtime]]'),
('20100714_batch_transition_tiki', '[[regtime]]'),
('20100716_user_selector_pref_rename_tiki', '[[regtime]]'),
('20100720_tiki_p_view_page_contribution_tiki', '[[regtime]]'),
('20100721_batch_transition_rollback_tiki', '[[regtime]]'),
('20100721_todo_tiki', '[[regtime]]'),
('20100721_todonotif_tiki', '[[regtime]]'),
('20100727_tiki_p_promote_page_tiki', '[[regtime]]'),
('20100730_list_image_article_tiki', '[[regtime]]'),
('20100802_tiki_p_share_tiki', '[[regtime]]'),
('20100802_url_shortener_tiki', '[[regtime]]'),
('20100804_remove_tiki_languages_tiki', '[[regtime]]'),
('20100806_blog_posts_header_tiki', '[[regtime]]'),
('20100807_alter_tiki_translate_fields_to_text_tiki', '[[regtime]]'),
('20100810_title_comments_upgrade_tiki', '[[regtime]]'),
('20100812_blog_control_max_related_content_tiki', '[[regtime]]'),
('20100812_blog_show_related_content_tiki', '[[regtime]]'),
('20100817_add_email_and_website_fields_to_comments_tiki', '[[regtime]]'),
('20100817_credits_tiki', '[[regtime]]'),
('20100817_rename_preference_wiki_comments_notitle_tiki', '[[regtime]]'),
('20100818_watch_tiki', '[[regtime]]'),
('20100820_blog_posts_wysiwyg_tiki', '[[regtime]]'),
('20100820_feed_fields_text_and_desc_are_not_empty_tiki', '[[regtime]]'),
('20100824_blog_post_excerpt_tiki', '[[regtime]]'),
('20100825_add_changed_column_to_tiki_language_table_tiki', '[[regtime]]'),
('20100825_remove_blog_option_use_title_tiki', '[[regtime]]'),
('20100830_sheet_add_styles_and_classes_tiki', '[[regtime]]'),
('20100831_freetag_tiki', '[[regtime]]'),
('20100901_duplic_actionlog_tiki', '[[regtime]]'),
('20100901_expire_tiki', '[[regtime]]'),
('20100902_invit_tiki', '[[regtime]]'),
('20100903_article_ispublished_tiki', '[[regtime]]'),
('20100906_sheet_toolbar_default_tiki', '[[regtime]]'),
('20100909_alter_tiki_language_fields_to_text_tiki', '[[regtime]]'),
('20100909_ckeditor_upgrade_tiki', '[[regtime]]'),
('20100909_lengthen_wiki_attachments_filename_tiki', '[[regtime]]'),
('20100910_new_fields_for_tiki_blogs_tiki', '[[regtime]]'),
('20100912_rename_autosave_pref_tiki', '[[regtime]]'),
('20100915_add_edit_languages_menu_option_tiki', '[[regtime]]'),
('20100919_tiki_page_contribution_tiki', '[[regtime]]'),
('20100920_ckeditor_remove_pref_tiki', '[[regtime]]'),
('20100920_jq_sheet_remove_pref_tiki', '[[regtime]]'),
('20100920_todo_event_tiki', '[[regtime]]'),
('20100923_fix_column_position_tiki', '[[regtime]]'),
('20100923_social_networking_permission_and_menuitem_tiki', '[[regtime]]'),
('20100925_fix_some_default_value_tiki', '[[regtime]]'),
('20100927_better_column_fix2_tiki', '[[regtime]]'),
('20100927_better_column_fix_tiki', '[[regtime]]'),
('20100928_sefurl_regex_reordering_tiki', '[[regtime]]'),
('20101008_user_id_for_tiki_language_tiki', '[[regtime]]'),
('20101014_tiki_language_add_lastModif_column_tiki', '[[regtime]]'),
('20101015_tiki_admin_perms_tiki', '[[regtime]]'),
('20101021_rename_blog_post_comment_object_type_tiki', '[[regtime]]'),
('20101025_fgal_show_deleteAfter_tiki', '[[regtime]]'),
('20101025_profile_sources_pref_tikiwiki_to_tiki', '[[regtime]]'),
('20101025_rename_create_blog_menu_entry_tiki', '[[regtime]]'),
('20101026_auth_token_add_columns_tiki', '[[regtime]]'),
('20101027_add_file_gallery_columns_tiki', '[[regtime]]'),
('20101027_rename_invit_to_invite_tiki', '[[regtime]]'),
('20101028_p_invit_tiki', '[[regtime]]'),
('20101110_actionlog_tiki', '[[regtime]]'),
('20101117_actionlog_tiki', '[[regtime]]'),
('20101119_categ_perm_tiki', '[[regtime]]'),
('20101126_fgal_add_gallerie_user_tiki', '[[regtime]]'),
('20101130_recreate_tiki_accounting_tables_tiki', '[[regtime]]'),
('20101130_tiki_accounting_tiki', '[[regtime]]'),
('20101201_tiki_accounting_fix_index_tiki', '[[regtime]]'),
('20101203_fgal_archive_default_tiki', '[[regtime]]'),
('20101207_feature_file_drafts_tiki', '[[regtime]]'),
('20101208_webservice_soap_tiki', '[[regtime]]'),
('20101210_fgal_add_wiki_attachments_tiki', '[[regtime]]'),
('20101210_sync_users_ldap_tiki', '[[regtime]]'),
('20101211_filegal_maxhits_column_tiki', '[[regtime]]'),
('20101211_kil_feature_phplayers_tiki', '[[regtime]]'),
('20101215_remove_files_tiki', '[[regtime]]'),
('20101215_template_file_galleries_tiki', '[[regtime]]'),
('20101219_kill_feature_mobile_tiki', '[[regtime]]'),
('20101230_create_top_modules_tiki', '[[regtime]]'),
('20110103_include_in_history_tiki', '[[regtime]]'),
('20110104_flagged_revision_log_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_again_tiki', '[[regtime]]'),
('20110104_sefurl_trackeritem_tiki', '[[regtime]]'),
('20110112_approval_permissions_tiki', '[[regtime]]'),
('20110115_create_bottom_modules_tiki', '[[regtime]]'),
('20110118_p_remove_tracker_items_tiki', '[[regtime]]'),
('20110124_update_sheet_to_support_cloning_tiki', '[[regtime]]'),
('20110201_c_code_to_user_modules_tiki', '[[regtime]]'),
('20110209_p_list_users_tiki', '[[regtime]]'),
('20110220_p_tracker_view_attachments_tiki', '[[regtime]]'),
('20110223_queue_tiki', '[[regtime]]'),
('20110224_tiki_cart_inventory_hold_tiki', '[[regtime]]'),
('20110307_remove_calendar_reminder_tiki', '[[regtime]]'),
('20110308_rss_item_key_tiki', '[[regtime]]'),
('20110317_attributes_increase_length_tiki', '[[regtime]]'),
('20110411_banner_tiki', '[[regtime]]'),
('20110412_permissions_out_of_db_tiki', '[[regtime]]'),
('20110413_blog_post_priv_default_value_tiki', '[[regtime]]'),
('20110419_kill_old_search_tiki', '[[regtime]]'),
('20110420_newsletter_optional_group_inclusion_tiki', '[[regtime]]'),
('20110421_compact_search_in_topbar_tiki', '[[regtime]]'),
('20110507_remove_module_style_params_tiki', '[[regtime]]'),
('20110513_banner_tiki', '[[regtime]]'),
('20110519_quick_edit_categ_params_merge_tiki', '[[regtime]]'),
('20110603_convert_tracker_comments_tiki', '[[regtime]]'),
('20110606_convert_ip_fields_to_ipv6_tiki', '[[regtime]]'),
('20110609_batch_update_tracker_item_links_tiki', '[[regtime]]'),
('20110609_missing_sql_tiki', '[[regtime]]'),
('20110609_unique_login_tiki', '[[regtime]]'),
('20110610_readd_sefurl_index_left_tiki', '[[regtime]]'),
('20110610_revert_poll_additions_tiki', '[[regtime]]'),
('20110611_accounting_fix_primarykeys_tiki', '[[regtime]]'),
('20110613_filegal_source_display_tiki', '[[regtime]]'),
('20110614_provider_authentication_tiki', '[[regtime]]'),
('20110615_structure_alias_tiki', '[[regtime]]'),
('20110622_file_from_url_log_tiki', '[[regtime]]'),
('20110630_fix_blogs_copyright_frencho_tiki', '[[regtime]]'),
('20110717_invoice_menu_options_tiki', '[[regtime]]'),
('20110725_tracker_field_permname_tiki', '[[regtime]]'),
('20110727_tracker_multilingual_convert_tiki', '[[regtime]]'),
('20110803_objectpermissions_tiki', '[[regtime]]'),
('20110808_default_perm_name_tiki', '[[regtime]]'),
('20110808_tracker_tiki', '[[regtime]]'),
('20110815_creator_lost_7_tiki', '[[regtime]]'),
('20110819_group_max_length_tiki', '[[regtime]]'),
('20110823_tiki_connect_create_tiki', '[[regtime]]'),
('20110830_default_enable_in_use_tiki', '[[regtime]]'),
('20110830_tiki_connect_longer_guid_tiki', '[[regtime]]'),
('20110902_revert_rootCategId_addition_tiki', '[[regtime]]'),
('20110904_shoutbox_def_tweetid_tiki', '[[regtime]]'),
('20110905_extend_actionlog_comment_tiki', '[[regtime]]'),
('20110905_multibyte_lc_fix_tiki', '[[regtime]]'),
('20110908_author_submission_tiki', '[[regtime]]'),
('20110909_tiki_forums_add_language_tiki', '[[regtime]]'),
('20110911_add_missing_engine_specs_tiki', '[[regtime]]'),
('20110912_groupsexpiryanniversary_tiki', '[[regtime]]'),
('20110912_remove_unused_fields_tiki', '[[regtime]]'),
('20110923_referer_stats_tiki', '[[regtime]]'),
('20110926_tracker_menu_feature_reports_tiki', '[[regtime]]'),
('20111001_add_tiki_areas_tiki', '[[regtime]]'),
('20111006_drop_useless_key_tiki', '[[regtime]]'),
('20111010_revert_fix_user_bookmarks_folders_key_tiki', '[[regtime]]'),
('20111014_menu_feature_time_sheet_tiki', '[[regtime]]'),
('20111118_remove_versionOfPreferencesCache_tiki', '[[regtime]]'),
('20111210_add_blog_hits_tiki', '[[regtime]]'),
('20111217_on_value_tracker_tiki', '[[regtime]]'),
('20111231_change_datetime_defaults_to_null_tiki', '[[regtime]]'),
('20120115_remove_article_show_lang_tiki', '[[regtime]]'),
('20120118_remove_users_prefs_language_tiki', '[[regtime]]'),
('20120123_remove_column_from_tiki_user_reports_tiki', '[[regtime]]'),
('20120315_list_image_article_y_tiki', '[[regtime]]'),
('20120319_remove_sheets_with_no_relation_tiki', '[[regtime]]'),
('20120320_remove_admin_trackers_application_menu_tiki', '[[regtime]]'),
('20120323_add_reports_to_application_menu_tiki', '[[regtime]]'),
('20120323_remove_tracker_reports_from_application_menu_tiki', '[[regtime]]'),
('20120324_add_filegals_icon_tiki', '[[regtime]]'),
('20120401_kaltura_prefs_rename_tiki', '[[regtime]]'),
('20120408_add_forumthread_sefurl_tiki', '[[regtime]]'),
('20120421_autoincementtoautoincrement_tiki', '[[regtime]]'),
('20120422_mime_tiki', '[[regtime]]'),
('20120423_add_page_refs_tiki', '[[regtime]]'),
('20120423_add_status_attr_tiki', '[[regtime]]'),
('20120426_perspectives_menu_entry_tiki', '[[regtime]]'),
('20120426_tiki_db_status_tiki', '[[regtime]]'),
('20120429_fix_collation_tiki', '[[regtime]]'),
('20120510_mailqueue_tiki', '[[regtime]]'),
('20120604_add_holder_to_copyright_tiki', '[[regtime]]'),
('20120628_correct_admin_user_createdate_tiki', '[[regtime]]'),
('20120823_admin_user_credit_menu_entry_tiki', '[[regtime]]'),
('20120823_workspace_template_tiki', '[[regtime]]'),
('20120824_advanced_mode_flag_tiki', '[[regtime]]'),
('20120825_accounting_menu_entry_tiki', '[[regtime]]'),
('20120826_store_metadata_tiki', '[[regtime]]'),
('20120904_category_root_tiki', '[[regtime]]'),
('20120927_add_area_exclusive_and_common_tiki', '[[regtime]]'),
('20120927_add_menu_parse_tiki', '[[regtime]]'),
('20120930_tiki_p_view_poll_choices_tiki', '[[regtime]]'),
('20121009_module_search_box_to_search_tiki', '[[regtime]]'),
('20121016_actionlog_comment_text_tiki', '[[regtime]]'),
('20121027_tracker_samerow_fix_tiki', '[[regtime]]'),
('20121210_add_missing_index_user_assigned_modules_tiki', '[[regtime]]'),
('20121210_better_forum_reported_index_tiki', '[[regtime]]'),
('20121213_module_zone_enlarge_tiki', '[[regtime]]'),
('20130220_wiki_attachments_tiki', '[[regtime]]'),
('20130228_bigger_token_groups_tiki', '[[regtime]]'),
('20130301_sefurl_tracker_type_tiki', '[[regtime]]'),
('20130314_keep_search_pref_settings_tiki', '[[regtime]]'),
('20130322_app_menu_timesheet_pos_tiki', '[[regtime]]'),
('20130322_restore_lost_filegals_tiki', '[[regtime]]'),
('20130328_extend_actionlog_bbb_tiki', '[[regtime]]'),
('20130410_keep_wysiwyg_htmltowiki_setting_tiki', '[[regtime]]'),
('20130415_repair_file_galleries_again_tiki', '[[regtime]]'),
('20130417_score_alter_tiki', '[[regtime]]'),
('20130417_score_tiki', '[[regtime]]'),
('20130419_newsletters_clippings_tiki', '[[regtime]]'),
('20130513_convert_tracker_field_parameters_tiki', '[[regtime]]'),
('20130530_category_log_tiki', '[[regtime]]'),
('20130530_tracker_modification_log_tiki', '[[regtime]]'),
('20130605_mailin_show_inline_tiki', '[[regtime]]'),
('20130606_mailin_add_categoryId_tiki', '[[regtime]]'),
('20130608_convert_mailin_pwd_tiki', '[[regtime]]'),
('20130608_mailin_response_tiki', '[[regtime]]'),
('20130611_mailin_add_html_tiki', '[[regtime]]'),
('20130614_mailin_add_admin_tiki', '[[regtime]]'),
('20130616_mailin_add_namespace_tiki', '[[regtime]]'),
('20130623_create_mailin_user_struct_tiki', '[[regtime]]'),
('20130624_mailin_add_attr_tiki', '[[regtime]]'),
('20130704_catname_tiki', '[[regtime]]'),
('20130705_activity_stream_tiki', '[[regtime]]'),
('20130715_activity_stream_rules_tiki', '[[regtime]]'),
('20130730_friendship_conversion_tiki', '[[regtime]]'),
('20130730_wiki_para_format_default_change_tiki', '[[regtime]]'),
('20130807_tracker_files_display_param_change_tiki', '[[regtime]]'),
('20130809_limit_name_lengths_in_objects_tiki', '[[regtime]]'),
('20131007_menus_items_missing_icons_tiki', '[[regtime]]'),
('20131108_mytiki_add_mailin_tiki', '[[regtime]]'),
('20131117_unified_engine_default_change_tiki', '[[regtime]]'),
('20131218_stored_queries_tiki', '[[regtime]]'),
('20131231_add_sheet_metadata_tiki', '[[regtime]]'),
('20140109_query_unique_name_tiki', '[[regtime]]'),
('20140117_monitor_tiki', '[[regtime]]'),
('20140129_bigger_target_monitor_tiki', '[[regtime]]'),
('20140203_menu_item_and_icon_user_wizard_tiki', '[[regtime]]'),
('20140206_add_parser_column_tiki', '[[regtime]]'),
('20140210_user_wizard_add_section_name_tiki', '[[regtime]]'),
('20140214_goals_tiki', '[[regtime]]'),
('20140219_full_goal_events_tiki', '[[regtime]]'),
('20140301_add_column_rating_choice_topic_on_forums_tiki', '[[regtime]]'),
('20140318_user_wizard_add_groupname_tiki', '[[regtime]]'),
('20140402_mailin_protocol_option_tiki', '[[regtime]]'),
('20140402_payment_authorization_tiki', '[[regtime]]'),
('20140402_remove_mailin_smtp_tiki', '[[regtime]]'),
('20140509_rss_add_categories_tiki', '[[regtime]]'),
('20140625_survey_tiki', '[[regtime]]'),
('20140705_page_slug_tiki', '[[regtime]]'),
('20140807_federated_search_tiki', '[[regtime]]'),
('20140812_convert_tiki_connect_data_to_json_tiki', '[[regtime]]'),
('20140914_addon_profiles_tiki', '[[regtime]]'),
('20141003_change_style_pref_to_theme_tiki', '[[regtime]]'),
('20141106_menu_configuration_panel_tiki', '[[regtime]]'),
('20141114_remove_babelfish_tiki', '[[regtime]]'),
('20141120_tracker_tabular_tiki', '[[regtime]]'),
('20141122_change_prefname_availblestyles_to_availablethemes_tiki', '[[regtime]]'),
('20141125_menu_control_panels_tiki', '[[regtime]]'),
('20150109_tabular_filters_tiki', '[[regtime]]'),
('20150112_theme_option_etc_tiki', '[[regtime]]'),
('20150203_add_menu_option_class_tiki', '[[regtime]]'),
('20150310_rename_freetags_in_menu_42_tiki', '[[regtime]]'),
('20150310_rename_mytiki_in_menu_42_tiki', '[[regtime]]'),
('20150327_tracker_showPopup_option_fix_tiki', '[[regtime]]'),
('20150414_profile_symbol_tooshort_fix_tiki', '[[regtime]]'),
('20150426_menu_item_external_wikis_restored_tiki', '[[regtime]]'),
('20150508_perspectives_style_to_theme_tiki', '[[regtime]]'),
('20150730_menu_item_tabular_trackers_tiki', '[[regtime]]'),
('20150901_prefname_char_length_tiki', '[[regtime]]'),
('20150929_make_hotwords_longer_tiki', '[[regtime]]'),
('20151203_tiki_score_revamp_tiki', '[[regtime]]'),
('20151203_tokens_create_user_tiki', '[[regtime]]'),
('20160120_remove_gmap_menu_item_tiki', '[[regtime]]'),
('20160201_remove_maps_menus_tiki', '[[regtime]]'),
('20160206_theme_option_modules_tiki', '[[regtime]]'),
('20160315_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160325_menu_42_list_pages_tiki', '[[regtime]]'),
('20160420_correct_blogpost_encoding_tiki', '[[regtime]]'),
('20160519_calendar_events_action_log_tiki', '[[regtime]]'),
('20160527_menu_item_payment_tiki', '[[regtime]]'),
('20160604_remove_unwanted_files_tiki', '[[regtime]]'),
('20160608_menu_item_admin_tokens_tiki', '[[regtime]]'),
('20160612_new_password_implementation_tiki', '[[regtime]]'),
('20160612_remove_feature_challenge_pref_tiki', '[[regtime]]'),
('20160614_clear_password_removal_tiki', '[[regtime]]'),
('20160627_remove_more_unwanted_files_tiki', '[[regtime]]'),
('20160817_fix_dymanic_list_field_values_tiki', '[[regtime]]'),
('20160914_extwiki_missing_columns_fix_tiki', '[[regtime]]'),
('20160915_extwiki_indexname_length_tiki', '[[regtime]]'),
('20161109_remove_old_password_tiki', '[[regtime]]'),
('20161117_favicon_tiki', '[[regtime]]'),
('20161206_larger_comment_field_tiki', '[[regtime]]'),
('20161220_add_h5p_tables_tiki', '[[regtime]]'),
('20170122_schedulers_tiki', '[[regtime]]'),
('20170127_remove_templates_c_tiki', '[[regtime]]'),
('20170129_feature_dump_tiki', '[[regtime]]'),
('20170207_iefix_rem_tiki', '[[regtime]]'),
('20170213_footnotearea_tiki', '[[regtime]]'),
('20170218_schedulers_menu_tiki', '[[regtime]]'),
('20170305_webservices_menu_tiki', '[[regtime]]'),
('20170307_kill_wikilingo_tiki', '[[regtime]]'),
('20170319_kill_jcapture_tiki', '[[regtime]]'),
('20170322_fix_allocate_memory_prefs_tiki', '[[regtime]]'),
('20170329_add_color_to_groups_tiki', '[[regtime]]'),
('20170329_larger_category_descriptions_tiki', '[[regtime]]'),
('20170330_merge_hiddenlinks_into_headinglinks_tiki', '[[regtime]]'),
('20170427_update_accounting_journal_cols_tiki', '[[regtime]]'),
('20170531_feature_usability_tiki', '[[regtime]]'),
('20170628_schedulers_menu_tiki', '[[regtime]]'),
('20170702_wiki_url_scheme_pref_default_tiki', '[[regtime]]'),
('20170717_add_missing_trackeritem_attachment_backlinks_tiki', '[[regtime]]'),
('20170726_remove_article_hashes_tiki', '[[regtime]]'),
('20170726_tabular_config_tiki', '[[regtime]]'),
('20170829_custom_routes_tiki', '[[regtime]]'),
('20170920_admin_webservices_menu_option_tiki', '[[regtime]]'),
('20170925_add_general_to_language_tiki', '[[regtime]]'),
('20170930_custom_routes_menu_tiki', '[[regtime]]'),
('20171002_queue_handler_size_increase_tiki', '[[regtime]]'),
('20171010_action_log_info_new_column_tiki', '[[regtime]]'),
('20171016_no_homepage_specificed_tiki', '[[regtime]]'),
('20171121_create_plugin_include_relations_tiki', '[[regtime]]'),
('20171122_h5p_update_add_hub_table_tiki', '[[regtime]]'),
('20171123_create_object_links_tiki', '[[regtime]]'),
('20171129_backlinks_for_object_types_admin_options_tiki', '[[regtime]]'),
('20171130_plugin_include_link_original_tiki', '[[regtime]]'),
('20171204_update_geo_enabled_tiki', '[[regtime]]'),
('20171231_add_short_url_tiki', '[[regtime]]'),
('20180228_comment_on_object_attributes_tiki', '[[regtime]]'),
('20180331_rename_custom_route_object_type_tiki', '[[regtime]]'),
('20180405_custom_routes_menu_tiki', '[[regtime]]'),
('20180405_remove_unused_user_id_tiki', '[[regtime]]'),
('20180410_install_piwik_plugin_tiki', '[[regtime]]'),
('20180411_schedulers_change_column_to_text_tiki', '[[regtime]]'),
('20180412_rename_short_url_prefs_tiki', '[[regtime]]'),
('20180419_scheduler_run_stalled_column_tiki', '[[regtime]]'),
('20180421_scheduler_run_healed_column_tiki', '[[regtime]]'),
('20180503_fix_throttled_newsletters_tiki', '[[regtime]]'),
('20180609_change_log_column_type_tiki', '[[regtime]]'),
('20180625_user_reports_null_last_reports_tiki', '[[regtime]]'),
('20180705_fix_calendaritem_tracker_attributes_tiki', '[[regtime]]'),
('20180706_remove_menu_reports_tiki', '[[regtime]]'),
('20180803_semaphore_value_tiki', '[[regtime]]'),
('20180808_ocr_tiki', '[[regtime]]'),
('20180815_merge_topic_read_perm_tiki', '[[regtime]]'),
('20180909_remove_page_content_fetch_readability_tiki', '[[regtime]]'),
('20180918_remove_poweredby_module_tiki', '[[regtime]]'),
('20180921_php_upgrade_fix_from_older_tiki', '[[regtime]]'),
('20180921_sql_upgrade_fix_from_older_tiki', '[[regtime]]'),
('20180923_convert_collation_to_utf8mb4_tiki', '[[regtime]]'),
('20180925_feature_jquery_superfish_pref_default_tiki', '[[regtime]]'),
('20181114_ocr_uff8mb4_tiki', '[[regtime]]'),
('20181127_convert_db_local_to_utf8mb4_tiki', '[[regtime]]'),
('20181130_update_column_name_size_tracker_table_tiki', '[[regtime]]'),
('20190117_create_oauthserver_clients_table_tiki', '[[regtime]]'),
('20190121_h5p_add_new_library_fields_tiki', '[[regtime]]'),
('20190121_h5p_allow_null_in_filtered_tiki', '[[regtime]]'),
('20190123_h5p_move_storage_assets_to_new_dir_tiki', '[[regtime]]'),
('20190129_fix_ambiguity_on_oauthserver_id_column_tiki', '[[regtime]]'),
('20190226_change_xmpp_auth_pref_name_tiki', '[[regtime]]'),
('20190303_make_tiki_object_href_larger_tiki', '[[regtime]]'),
('20190401_add_support_database_strict_mode_tiki', '[[regtime]]'),
('20190425_add_creation_date_schedule_tiki', '[[regtime]]'),
('20190425_set_creation_date_to_scheduler_tiki', '[[regtime]]'),
('20190523_migrate_webmail_accounts_tiki', '[[regtime]]'),
('20190526_remove_tiki_addon_profiles_tiki', '[[regtime]]'),
('20190620_add_role_groups_tiki', '[[regtime]]'),
('20190627_add_ocr_fgal_status_tiki', '[[regtime]]'),
('20190717_add_role_categ_available_tiki', '[[regtime]]'),
('20190722_ocr_fgal_tiki', '[[regtime]]'),
('20190723_add_is_tlp_group_tiki', '[[regtime]]'),
('20190729_add_tlp_group_category_tiki', '[[regtime]]'),
('20190831_add_two_factor_secret_tiki', '[[regtime]]'),
('20190913_caldav_tiki', '[[regtime]]'),
('20190925_caldav_updates_tiki', '[[regtime]]'),
('20191114_caldav_recurring_updates_tiki', '[[regtime]]'),
('20191116_scheduler_run_only_once_tiki', '[[regtime]]'),
('20191126_add_forum_parent_tiki', '[[regtime]]'),
('20191218_carddav_tiki', '[[regtime]]'),
('20200113_tracker_field_rules_column_tiki', '[[regtime]]'),
('20200123_calendar_rsvp_tiki', '[[regtime]]'),
('20200126_remove_invoice_menu_options_tiki', '[[regtime]]'),
('20200205_mailin_add_galleryid_tiki', '[[regtime]]'),
('20200218_mailin_add_trackerid_tiki', '[[regtime]]'),
('20200309_fix_sefurl_regex_out_issues_tiki', '[[regtime]]'),
('20200311_add_forum_order_tiki', '[[regtime]]'),
('20200513_expand_sessions_data_column_tiki', '[[regtime]]'),
('20200601_carddav_contact_uri_tiki', '[[regtime]]'),
('20200613_scheduler_run_now_tiki', '[[regtime]]'),
('20200614_expand_mail_queue_message_column_tiki', '[[regtime]]'),
('20200701_rename_pref_unified_lucene_default_operator_tiki', '[[regtime]]'),
('20200710_feature_templated_groups_tiki', '[[regtime]]'),
('20200820_performance_table_creation_tiki', '[[regtime]]'),
('20200903_create_encryption_keys_tiki', '[[regtime]]'),
('20200903_create_machine_learning_models_tiki', '[[regtime]]'),
('20200910_add_encryption_key_to_tracker_fields_tiki', '[[regtime]]'),
('20200928_add_machine_learning_menu_options_tiki', '[[regtime]]'),
('20201024_h5p_add_a11y_title_tiki', '[[regtime]]'),
('20201024_h5p_add_default_lang_tiki', '[[regtime]]'),
('20201118_add_odbc_tabulars_tiki', '[[regtime]]'),
('20201212_remove_comment_hash_tiki', '[[regtime]]'),
('20210115_add_trackerfields_sefurl_tiki', '[[regtime]]'),
('20210316_preference_replace_chosen_with_select2_tiki', '[[regtime]]'),
('20210410_alter_activity_stream_arguments_column_tiki', '[[regtime]]'),
('20210421_add_ml_label_field_tiki', '[[regtime]]'),
('20210428_mailin_add_preferences_tiki', '[[regtime]]'),
('20210605_image_gallery_removal_tiki', '[[regtime]]'),
('20210608_timesheet_menu_removal_tiki', '[[regtime]]'),
('20210819_theme_unified_admin_backend_pref_default_tiki', '[[regtime]]'),
('20211004_calendar_weekly_multiple_tiki', '[[regtime]]'),
('20211020_mark_image_gallery_tables_as_unused_tiki', '[[regtime]]'),
('20211110_create_api_tokens_tiki', '[[regtime]]'),
('20211126_timezone_date_update_tiki', '[[regtime]]'),
('20220111_backlinks_tiki', '[[regtime]]'),
('20220112_extend_api_tokens_tiki', '[[regtime]]'),
('20220112_extend_oauthserver_clients_tiki', '[[regtime]]'),
('20220113_password_blacklist_tiki', '[[regtime]]'),
('20220119_make_user_nullable_api_tokens_tiki', '[[regtime]]'),
('20220601_discard_hash_column_from_articles_tiki', '[[regtime]]'),
('20221020_add_direct_to_file_galleries_tiki', '[[regtime]]'),
('20221024_add_indexes_to_file_galleries_tiki', '[[regtime]]'),
('20221026_add_fgal_sync_to_action_log_tiki', '[[regtime]]'),
('20221110_add_actionforuser_index_on_actionlog_tiki', '[[regtime]]'),
('20221128_force_refresh_of_mapping_for_forum_section_tiki', '[[regtime]]'),
('20230125_add_goalid_to_credits_tiki', '[[regtime]]'),
('20230504_add_attemps_on_tiki_banning_tiki', '[[regtime]]'),
('20230520_add_blog_allow_post_categorization_tiki', '[[regtime]]'),
('20230807_sefurl_fix_error_of_wrong_url_for_column_stats_tiki', '[[regtime]]'),
('20230828_add_restriction_tiki_surveys_tiki', '[[regtime]]'),
('20231119_extend_actionlog_conf_crsf_error_tiki', '[[regtime]]'),
('20240419_tabular_itemlink_lookup_simple_rename_tiki', '[[regtime]]'),
('999999991_decode_pages_sources_tiki', '[[regtime]]'),
('99999999_image_plugins_kill_tiki', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_score`
--

CREATE TABLE `tiki_score` (
  `event` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8mb4_unicode_ci,
  `reversalEvent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`event`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_score`
--

INSERT INTO `tiki_score` VALUES
('tiki.user.login', '[\n    {"ruleId":"User logs in","recipientType":"user","recipient":"user","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.view', '[\n    {"ruleId":"See other user''s profile","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your profile seen","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.friend', '[\n    {"ruleId":"Make friends","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.user.message', '[\n    {"ruleId":"Send message","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Receive message","recipientType":"user","recipient":"object","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.create', '[\n    {"ruleId":"Publish new article","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.article.view', '[\n    {"ruleId":"Read an article","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your article read","recipientType":"user","recipient":"author","score":"1","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.filegallery.create', '[\n    {"ruleId":"Create new file gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.create', '[\n    {"ruleId":"Upload new file to gallery","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.file.download', '[\n    {"ruleId":"Download other user''s file","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your file downloaded","recipientType":"user","recipient":"owner","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.create', '[\n    {"ruleId":"Create new blog","recipientType":"user","recipient":"user","score":"20","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blogpost.create', '[\n    {"ruleId":"Post in a blog","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.blog.view', '[\n    {"ruleId":"Read other user''s blog","recipientType":"user","recipient":"user","score":"2","validObjectIds":[""],"expiration":""},\n    {"ruleId":"Have your blog read","recipientType":"user","recipient":"author","score":"3","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.create', '[\n    {"ruleId":"Create a wiki page","recipientType":"user","recipient":"user","score":"10","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.update', '[\n    {"ruleId":"Edit an existing wiki page","recipientType":"user","recipient":"user","score":"5","validObjectIds":[""],"expiration":""}\n]', ''),
('tiki.wiki.attachfile', '[\n    {"ruleId":"Attach file to wiki page","recipientType":"user","recipient":"user","score":"3","validObjectIds":[""],"expiration":""}\n]', '');

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_queries`
--

CREATE TABLE `tiki_search_queries` (
  `queryId` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `lastModif` int(11) DEFAULT NULL,
  `label` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `priority` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `query` blob,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`queryId`),
  UNIQUE KEY `tiki_user_query_uq` (`userId`,`label`),
  KEY `query_userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_search_stats`
--

CREATE TABLE `tiki_search_stats` (
  `term` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) DEFAULT NULL,
  PRIMARY KEY (`term`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `tiki_secdb`
--

CREATE TABLE `tiki_secdb` (
  `md5_value` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tiki_version` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `severity` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`filename`(171),`tiki_version`(20)),
  KEY `sdb_fn` (`filename`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tiki_secdb`
--

INSERT INTO `tiki_secdb` VALUES
('b5439a28556f7a18e14dc55c524e5d1b', './about.php', '24.9', 0),
('45294b4dc5e9adbccdb3948c9d6dd829', './admin/define_admin_icons.php', '24.9', 0),
('c659e1767ac77d0096169945133d8c48', './admin/include_articles.php', '24.9', 0),
('9a2a06db2f5127022ccdb3890aee1272', './admin/include_category.php', '24.9', 0),
('b570479b1a93aeea70c66211bb37d683', './admin/include_connect.php', '24.9', 0),
('5024d39b97eb333f0f23624b970ca660', './admin/include_features.php', '24.9', 0),
('85426df600cc498a562408c005fd0e5f', './admin/include_fgal.php', '24.9', 0),
('711b24298e512b0ead3262e93c65f762', './admin/include_freetags.php', '24.9', 0),
('d174d728dc09acc6b949e97eb0189765', './admin/include_general.php', '24.9', 0),
('c7fecbbc9a9d6b7b2d63a7f88db82da6', './admin/include_i18n.php', '24.9', 0),
('8b33b293b6c9d2e7a846facd31f4637f', './admin/include_intertiki.php', '24.9', 0),
('1c8f17c35aee4fe869f8712c45acf467', './admin/include_login.php', '24.9', 0),
('1447a5fe68091b4988abc053e66d9485', './admin/include_look.php', '24.9', 0),
('da88318ba807bdf3e26705cac7c61ce5', './admin/include_packages.php', '24.9', 0),
('fe4332fc869248ebe57b231238655a51', './admin/include_performance.php', '24.9', 0),
('2f0191c2963b395cbb267519be83353d', './admin/include_profiles.php', '24.9', 0),
('e57b24b7d9156ac393aa8fb8326162e3', './admin/include_rating.php', '24.9', 0),
('ac127d17308be2ceef1862e8190da9ff', './admin/include_score.php', '24.9', 0),
('cb5296cd5f9b7fa14fe1015990f3e933', './admin/include_search.php', '24.9', 0),
('cdc646a8342d0611255dc047f12fe75e', './admin/include_security.php', '24.9', 0),
('488e67bbb7f72bf88c0e6bf0480b5935', './admin/include_sefurl.php', '24.9', 0),
('23f5fa7ce89fa50f104817fb6755e307', './admin/include_semantic.php', '24.9', 0),
('595721419b4ff5f0d67d423fac4d7db5', './admin/include_socialnetworks.php', '24.9', 0),
('a4f1952d23a6aa0fd5166c1f08eeca48', './admin/include_socnets.php', '24.9', 0),
('e45f21f59599332400ce4baada5b9563', './admin/include_textarea.php', '24.9', 0),
('2e994eaa3fe8d2ab4f7d5f0cd0f76509', './admin/include_trackers.php', '24.9', 0),
('dfa00b0226ba0780b216f509f7227914', './admin/include_user.php', '24.9', 0),
('b5d1353f2b5ccdac18a597dd12547371', './admin/include_video.php', '24.9', 0),
('15a35784060c91c0ef37399e2a35dd9c', './admin/include_wiki.php', '24.9', 0),
('b78a47d7ed859d4d18e431f2a8582158', './admin/include_wikiatt.php', '24.9', 0),
('7435229539f620d75d1c44ba38fb5ea1', './admin/include_workspace.php', '24.9', 0),
('ef2d196ba1f4d968e65d5ef81de58125', './admin/index.php', '24.9', 0),
('309bd82f9871e31fce013817aabe01a0', './antibot.php', '24.9', 0),
('9ce0bfc7116937b48cc50b3a6ccbbb80', './article_image.php', '24.9', 0),
('7656218899278ffc2ea05288fc0c25b2', './banner_click.php', '24.9', 0),
('d24ffe69f737225dfb17cafbc94e5aab', './banner_image.php', '24.9', 0),
('f56ca4f3d0b49ec726bff55b595a3fae', './categorize.php', '24.9', 0),
('02bbbb806537f95b46d83d553476863e', './categorize_list.php', '24.9', 0),
('a71d677283fd1a71aedee7be19d3e6a9', './check_composer_exists.php', '24.9', 0),
('5545180ba169732dbf49ee018610264b', './comments.php', '24.9', 0),
('24c47a4a68222eb1b7b12e8a8793a4ee', './commxmlrpc.php', '24.9', 0),
('188df77183f5f080d7dc295214a9d7a0', './console.php', '24.9', 0),
('7c2673bee20eb64177eb7a756474ec06', './contribution.php', '24.9', 0),
('af6dd077cf67dfb4dcc11b174bb2fe26', './copyrights.php', '24.9', 0),
('2bbfe08556421f748cbf8abc6bad738c', './cron.php', '24.9', 0),
('ad1238b98c8bf8004941e42d9acbfb22', './db/cert/index.php', '24.9', 0),
('ad1238b98c8bf8004941e42d9acbfb22', './db/config/index.php', '24.9', 0),
('1341931ed9c16ec34465205b50714459', './db/index.php', '24.9', 0),
('20570c08e6373ededde60d1b0d40342a', './db/preconfiguration.php', '24.9', 0),
('1b7c75559607a7b03925558d879debca', './db/tiki-db.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './db/tiki-secdb_24.9_mysql.sql', '24.9', 0),
('4be338fff29138d133ecf1747fe8f6c1', './db/tiki.sql', '24.9', 0),
('9c7d6b69f58123ce74e2b5359f36b169', './db/tiki_1.8to1.9.sql', '24.9', 0),
('16eee72f2420a3533492dc1d6610b857', './db/tiki_1.9to2.0.sql', '24.9', 0),
('7bc56be608ef791189fe4dabc0c5b35c', './db/tiki_2.0to3.0.sql', '24.9', 0),
('7e9c1cbc8983e18f0811f7a5b5d25c89', './db/tiki_convert_myisam_to_innodb.sql', '24.9', 0),
('1b5d1eaebc0905c2bae45493275c03f6', './db/tiki_fulltext_indexes.sql', '24.9', 0),
('7f6698c8c0e0db0e556b02439a13dbdd', './db/tiki_innodb.sql', '24.9', 0),
('9425e37fc31a591c10cf3dea5717bb43', './db/tiki_myisam.sql', '24.9', 0),
('de4690a8bd97ec68f7d4fec999e179f2', './display_banner.php', '24.9', 0),
('4683085d195889a15754fc5557450898', './doc/devtools/20160715_trim50_tracker_permanent_names_for_mysqlfts_tiki.sql', '24.9', 0),
('eacb1bb7a17f2057d63c8abf44893e7b', './doc/devtools/backup.php', '24.9', 0),
('9c34100d5822548700fb0fc2cebf4a6f', './doc/devtools/buildincrement.php', '24.9', 0),
('ddcf82496277fbfd71cd6b2cec619918', './doc/devtools/check_bom_encoding.php', '24.9', 0),
('f22183e81dcd5cf34acc9f5945f20e2a', './doc/devtools/check_filegal_dir.php', '24.9', 0),
('f61cdcbd52cc647ed8e83075a1f5ab03', './doc/devtools/check_schema_naming_convention.php', '24.9', 0),
('d90a399d204c6564a3657410530521b7', './doc/devtools/check_schema_sql_drop.php', '24.9', 0),
('4aac31adf30bfd83fa425af8ee050293', './doc/devtools/check_schema_upgrade.php', '24.9', 0),
('b396ba1260f59327e19c9e869c20c16c', './doc/devtools/check_sql_engine.php', '24.9', 0),
('685e2716ce341d1bd8e15253c8ce43bf', './doc/devtools/check_sql_engine_conversion.php', '24.9', 0),
('28f1fde6cd565a4a3bc438da2eff28aa', './doc/devtools/check_template_translation_standards.php', '24.9', 0),
('251dfc1db781cf4bc4da48089582e65a', './doc/devtools/check_tiki-new.php', '24.9', 0),
('d7d3972b836bf3bd0627ab5c1a777e93', './doc/devtools/check_tiki.php', '24.9', 0),
('6514a15cbd9c818f6042a362a4b9f976', './doc/devtools/check_tiki_directories.php', '24.9', 0),
('f13479a23c1cfa5dfa7afee22b29bec2', './doc/devtools/check_unix_ending_line.php', '24.9', 0),
('264b95dc0b6ac817fda1e2fe797d7731', './doc/devtools/clear_tracker_fast.sql', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './doc/devtools/codesniffer/index.php', '24.9', 0),
('bb702b55e9c6ba63d5d28ec108cdce31', './doc/devtools/codesniffer/standards/Tiki/Sniffs/Wrapper/DisallowSymfonyProcessSniff.php', '24.9', 0),
('5d57d119f75e3f3887195778d6166429', './doc/devtools/codesniffer/standards/Tiki/Sniffs/Wrapper/index.php', '24.9', 0),
('97f062d31145fabca0b65e615d31dd61', './doc/devtools/codesniffer/standards/Tiki/Sniffs/index.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './doc/devtools/codesniffer/standards/Tiki/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './doc/devtools/codesniffer/standards/index.php', '24.9', 0),
('2578807373e4dc83cfd2118d0c6c95d9', './doc/devtools/commit_translations_by_lang.php', '24.9', 0),
('e1ff9a54e1c0e136ca49e1a57ebc5428', './doc/devtools/composer_http_mode.php', '24.9', 0),
('d14acc3893c8c8e8372f94643a9eef14', './doc/devtools/convert_templates_prefs-2.0.php', '24.9', 0),
('4e60645a7aa8b026db5132bdbcaa7fa7', './doc/devtools/convert_tpl_ajax.php', '24.9', 0),
('469a0feb1da7253f3f0c292e91697963', './doc/devtools/convert_tracker_attachments.php', '24.9', 0),
('4be61db8e0405455922dfb87b3c085da', './doc/devtools/convert_user_logins_from_email.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './doc/devtools/dbdiff/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './doc/devtools/etc/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './doc/devtools/etc/update/index.php', '24.9', 0),
('1341931ed9c16ec34465205b50714459', './doc/devtools/experimental/index.php', '24.9', 0),
('1341931ed9c16ec34465205b50714459', './doc/devtools/experimental/unzip/index.php', '24.9', 0),
('3ecde8b7ad790d9fa8df191720be469a', './doc/devtools/experimental/unzip/unzipper.php', '24.9', 0),
('9d1788b54e0a127e4147a7f8f834c58e', './doc/devtools/export_all_translation_to_file.php', '24.9', 0),
('0076bf83b593777464380b5d2d5fd15b', './doc/devtools/export_translations_to_file.php', '24.9', 0),
('116fed0eb426f31d57dbcc8996cb0459', './doc/devtools/extract-img-db-to-fs.php', '24.9', 0),
('cbf6111f0530dfae2594f2d7acabe157', './doc/devtools/fgal_revamp_archive_fix.php', '24.9', 0),
('e46c476b86fc482416895be9e76508dd', './doc/devtools/fix-encoding.php', '24.9', 0),
('67ce03aff5e6695fb60f095c13f59dc3', './doc/devtools/fixsvnkeyids.php', '24.9', 0),
('7d85433110b4c215ce037c604a37d33e', './doc/devtools/get_translation_percentage.php', '24.9', 0),
('f20f4868b1cb8f5bf8f78d7f03dd4a01', './doc/devtools/ggg-trace.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './doc/devtools/gitlab/index.php', '24.9', 0),
('c12bd6b52f6f091b84e4cffba8922769', './doc/devtools/gittools.php', '24.9', 0),
('29d9eab0cced72126f4b5166110c8b52', './doc/devtools/h5p_reset_all_data.sql', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './doc/devtools/index.php', '24.9', 0),
('857e41970d45355cfeb3b9f09cb00aec', './doc/devtools/invert_relations.php', '24.9', 0),
('7b956b7cb936586be05225caf4fd8c14', './doc/devtools/ks_prefreport.php', '24.9', 0),
('c8ab811d380bfea8db68f9b60c57e4ec', './doc/devtools/make_db_local.sql', '24.9', 0),
('1470fe9a7cc9e86d5d7f716952159cdb', './doc/devtools/mergelang.php', '24.9', 0),
('a995b6ff6f35e46beade6c004749fb44', './doc/devtools/parse_tiki.php', '24.9', 0),
('0e3671642621165431e9642f992c89f8', './doc/devtools/prefreport.php', '24.9', 0),
('32ad0ade35fdced79a7febb8465bf500', './doc/devtools/rebuild_search_index.php', '24.9', 0),
('5dddf7a6f8882cb2a3a5176f35b17aff', './doc/devtools/remove_empty_wiki_attachment_filegals.php', '24.9', 0),
('bdf07ca8019ff7e447cc5fb0946993d9', './doc/devtools/rescue_wiki_changes_from_elastic.php', '24.9', 0),
('ad129a4c911ccde0302d8d5fd876ff51', './doc/devtools/restorehelp.php', '24.9', 0),
('fdca90e0ebcf2e5c82ee78ce9007527d', './doc/devtools/rewritesecdb.php', '24.9', 0),
('4fc7bafddcbe5362eb31a6b40fe5db8d', './doc/devtools/satis_composer_packages_gitlab.php', '24.9', 0),
('1d187d80ce061907ffb18991ab36e74c', './doc/devtools/search_smarty_prefs-2.0.php', '24.9', 0),
('0d158425638cb55fa44c1f08f1bafd86', './doc/devtools/securitycheck.php', '24.9', 0),
('5e752f6b8ef335b8f1c0b749fa406b66', './doc/devtools/stripcomments.php', '24.9', 0),
('49fac539567d6ab5e3d62cb62aabaeea', './doc/devtools/svnbranch.php', '24.9', 0),
('06bba4cda29a3e91623de4a5681c903d', './doc/devtools/svnbranchreview.php', '24.9', 0),
('ebf37f3c57cb3b60a9041069fe37a7ad', './doc/devtools/svnbranchupdate.php', '24.9', 0),
('474127d379c9bec980a91bf87fdab666', './doc/devtools/svnmerge.php', '24.9', 0),
('b791a6217d7e776e0d2c5603043620d4', './doc/devtools/svnswitch.php', '24.9', 0),
('fe448ecefe77d40da555714cc432be20', './doc/devtools/svntools.php', '24.9', 0),
('5eb8a3cc599592e0ba055ceebfc7e128', './doc/devtools/svnup.php', '24.9', 0),
('3596d052c6e2e61e1cf90638fde6574e', './doc/devtools/sync.php', '24.9', 0),
('991bf84b79c5f29b424f31de18336a6d', './doc/devtools/tiki-create_md5.php', '24.9', 0),
('d9683863f61604ecffb0fece1f3659ad', './doc/devtools/tiki-show_raw_links.php', '24.9', 0),
('42008141dee690a6c0a3cce02d6669b5', './doc/devtools/tiki-sync_ldap.php', '24.9', 0),
('1341931ed9c16ec34465205b50714459', './doc/devtools/tim/index.php', '24.9', 0),
('7da0e5b22722212e92e49b6aa33d0998', './doc/devtools/translate.php', '24.9', 0),
('84f70a5b542c78ba60497fcb548ec285', './doc/devtools/update_composer_lock.php', '24.9', 0),
('8e9bbbe6723e0c6a2bf7028a8e2ea424', './doc/devtools/update_english_strings.php', '24.9', 0),
('16c1861016d103465d19b36f2f40260b', './doc/devtools/update_vendor_bundled.php', '24.9', 0),
('c95b1d56a06cafba4f73eb3f6daf0034', './doc/devtools/upto_18_drop_unused_tables.sql', '24.9', 0),
('214a3022a15d52cb769682000b45ae55', './doc/devtools/upto_4.1_delete_all_cetgory_perms.sql', '24.9', 0),
('d20bb5a10ce694a47c9ddc3a595615e7', './doc/devtools/upto_4.1_drop_unused_4.0_tables.sql', '24.9', 0),
('58572000763181f94d8101a459c40a14', './doc/devtools/upto_7_drop_unused_6.x_tables.sql', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './doc/devtools/var/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './doc/devtools/var/lock/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './doc/devtools/var/log/index.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './doc/devtools/var/log/update/index.php', '24.9', 0),
('a89b9c07d42c1e53cbc05f19e810979e', './doc/devtools/vcscommons.php', '24.9', 0),
('7eca31f65be19680c74dad2b88f6e719', './doc/index.php', '24.9', 0),
('1341931ed9c16ec34465205b50714459', './doc/reports/index.php', '24.9', 0),
('f13b414a6bde1cd9bfa43dca83c1afcd', './dump/index.php', '24.9', 0),
('5da01519dc631438a2274a3e9cc66ff3', './fgal_listing_conf.php', '24.9', 0),
('f298af8844e4f5961389c01f4202ff6f', './freetag_apply.php', '24.9', 0),
('fd8b332cc7536fd9d4860149194b673f', './freetag_list.php', '24.9', 0),
('371df6b0c0c80c2d0f2425025f39c983', './get_strings.php', '24.9', 0),
('a5622516fe3bcd1dba99b20d54697e4d', './group_tracker_ajax.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/avatars/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './img/ckeditor/index.php', '24.9', 0),
('8c2427474651b6c90e8469fc8df7a1ab', './img/flags/flagnames.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/flags/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/icons/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/large/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/mime/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/mime/large/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './img/icons/sprite/index.php', '24.9', 0),
('935bbc15dd9cf712f7e69d97e1a386d7', './img/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './img/poweredby/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/profiles/index.php', '24.9', 0),
('24cd66e06eabffa9f23bb6105b670131', './img/rating_smiles/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/smiles/index.php', '24.9', 0),
('24cd66e06eabffa9f23bb6105b670131', './img/superfish/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/tiki/index.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './img/tikihelp/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/trackers/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/webmail/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/wiki/index.php', '24.9', 0),
('e6c08d8ef2ed0484f503d4dd874856b1', './img/wiki_up/index.php', '24.9', 0),
('5f2196a4269caa83a059f059c65ff56a', './index.php', '24.9', 0),
('6109d0d3e20ff687038aaa54b11e648a', './installer/Installer.php', '24.9', 0),
('3671278f198a8987e9a083ec09d68b6a', './installer/InstallerDatabaseErrorHandler.php', '24.9', 0),
('a51734232003334475e3c6f41d616583', './installer/Patch.php', '24.9', 0),
('68735fdd7d41e91bdff6e617048ba8ce', './installer/ProgressBar.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './installer/composer-patches/index.php', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './installer/index.php', '24.9', 0),
('0f667dc1400b550f56a4023bcc13567b', './installer/installlib.php', '24.9', 0),
('2bb856c10f0c98e0a6e8bc5be5bf7e6b', './installer/schema/00000000_schema_change_tiki.sql', '24.9', 0),
('006c768f38fb584f81a9577977988c40', './installer/schema/20080227_invite_tiki.sql', '24.9', 0),
('2d0b98a6482de21d7da2aa51becf84dc', './installer/schema/20080809_semlinks_tiki.sql', '24.9', 0),
('b7bc39833ff6498a7f2810f6ba477c7c', './installer/schema/20080827_bigfeaturetype_tiki.sql', '24.9', 0),
('2398106f99b68b3767b9719765489233', './installer/schema/20080829_pagealiasdata_tiki.sql', '24.9', 0),
('c4f4acac0dc6cbc2ebfb2f9c0be7e529', './installer/schema/20080829_pluginvalidation_tiki.sql', '24.9', 0),
('b3e9d8bf2668aefc4771dab17d0a24a2', './installer/schema/20080901_pluginvalidation_tiki.sql', '24.9', 0),
('ff79e407ffb5b00ff4d1e89a73c9704a', './installer/schema/20080902_trackerparsedesc_tiki.sql', '24.9', 0),
('7f8b965f930f78a8bddcef926ae47037', './installer/schema/20080905_feature_tip_tiki.sql', '24.9', 0),
('3f86cfb1dc64d6b19c54c28019102ca7', './installer/schema/20080916_webservice_registry_tiki.sql', '24.9', 0),
('32603465e3345c4fb4135313fd639fed', './installer/schema/20080922_calendar_customstatus_tiki.sql', '24.9', 0),
('b5ab53b9f57092bca8ea8592fa037f7b', './installer/schema/20080924_webmail_tiki.sql', '24.9', 0),
('a692f6c42ad0de8abb9d754288dec8d2', './installer/schema/20080926_bannerindex_tiki.sql', '24.9', 0),
('bc29e3e80740fc29e33d27defbcbc97f', './installer/schema/20081004_mindmap_menu_tiki.sql', '24.9', 0),
('536631185aad52c71ef92899b5c5b62f', './installer/schema/20081006_comments_moderation_tiki.sql', '24.9', 0),
('97837099f4b69a93e84f567d3c56d257', './installer/schema/20081008_bit_flags_nullable_tiki.sql', '24.9', 0),
('e8ce3139d3e2b292ee37e8ce885e1705', './installer/schema/20081010_filter_perms_tiki.sql', '24.9', 0),
('2e63a1b5e05aab6502e083ce82c0dc79', './installer/schema/20081014_trust_input_perm_tiki.sql', '24.9', 0),
('a360c4d3bf674a0701ab7f4280f5c3a8', './installer/schema/20081018_filter_perms_tiki.sql', '24.9', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20081019_score_tiki.sql', '24.9', 0),
('9936db192fac5ee273acfe31dec15cf9', './installer/schema/20081022_application_menu_tiki.sql', '24.9', 0),
('9a97cd6ca26d30c0b9d05c4aa537084d', './installer/schema/20081024_fulltext_file_tiki.sql', '24.9', 0),
('8d701d07641ef5d3f7b69d7e6d5a33a9', './installer/schema/20081027_calendar_tiki.sql', '24.9', 0),
('3d53e3b67422f25ff924fbe763538155', './installer/schema/20081027_file_galleries_tiki.sql', '24.9', 0),
('2d1a37d08e6f39946a6dc2e1cfb0737a', './installer/schema/20081027_groupalert_tiki.sql', '24.9', 0),
('58df86055cb0233d2b7d32defd83828b', './installer/schema/20081027_surveys_tiki.sql', '24.9', 0),
('9ec9d1e68f44edbf587713bcd1e456c7', './installer/schema/20081027_trackers_tiki.sql', '24.9', 0),
('b716c67361eacf1a987e1bb40f6316ee', './installer/schema/20081027_wysiwyg_history_tiki.sql', '24.9', 0),
('dca26112be92a3177d122e04f6fa959a', './installer/schema/20081029_tracker_index_tiki.sql', '24.9', 0),
('00c60bf6063b7c4d89e0c9ead79abf75', './installer/schema/20081102_application_menu_structures_tiki.sql', '24.9', 0),
('1ef6d37f65c50ed067481f95baf4fd09', './installer/schema/20081105_calendar_items_allday_tiki.sql', '24.9', 0),
('27788e1efb7a90034e8950fd8f4354bd', './installer/schema/20081107_menu42_tiki.sql', '24.9', 0),
('d4c56d850365c4b6acf6ad25b90d4c73', './installer/schema/20081112_tiki_p_tracker_view_comments_tiki.sql', '24.9', 0),
('43d6558ec8576961ad0fa57eea6ec549', './installer/schema/20081114_tiki_banner_tiki.sql', '24.9', 0),
('dafa2c29eca3f81a8cb59ee6208de018', './installer/schema/20081119_tiki_p_export_tracker_tiki.sql', '24.9', 0),
('910db98348db50f457bcd220e6b94d96', './installer/schema/20081120_showCategories_tiki.sql', '24.9', 0),
('b96d9c4717c53493180e1b3bba0448ac', './installer/schema/20081120_tiki_poll_structures_update_tiki.sql', '24.9', 0),
('89c22600772bbf20691a784f5abafb0b', './installer/schema/20081125_tiki_tracker_types_tiki.sql', '24.9', 0),
('5982d5bdb4eebc0d9c987c202318e8e6', './installer/schema/20081127_calendar_recurrence_tiki.sql', '24.9', 0),
('87e87aca605d69c54c0144768facb548', './installer/schema/20081130_tiki_users_permission_tiki.sql', '24.9', 0),
('f0f9c1466b9330c3a4fa41680a9a63e4', './installer/schema/20081211_newsletter_files_tiki.sql', '24.9', 0),
('fd50074486eece74754eff0e24fa8cc7', './installer/schema/20081211_score_tiki.sql', '24.9', 0),
('419cfa4072a49c9712f047c6d00019e7', './installer/schema/20081212_tiki_p_view_backlinks_tiki.sql', '24.9', 0),
('5671f4746f9ab96caf1673eaabfc8134', './installer/schema/20081214_webservice_post_tiki.sql', '24.9', 0),
('fa760fbadd8b8611db93629587f4c856', './installer/schema/20090106_group_watch_tiki.sql', '24.9', 0),
('91eaa83db90f06582180cd14355122b4', './installer/schema/20090120_sefurl_rules_tiki.sql', '24.9', 0),
('c26a0ce1737db912d15bf60e52b22d1d', './installer/schema/20090129_callendar_search_tiki.sql', '24.9', 0),
('78e3b5aa3c867fa9b6bc5766c70ee9eb', './installer/schema/20090203_null_tiki.sql', '24.9', 0),
('c635a46b0df03ad6549eb3aa555ef0c3', './installer/schema/20090205_forum_and_comments_locking_tiki.sql', '24.9', 0),
('ae4896884f1506b3aef47977d105a445', './installer/schema/20090205_menucase_tiki.sql', '24.9', 0),
('7767c3b7b399c9c01a2687a136c90c6b', './installer/schema/20090205_menus_items_icons_tiki.sql', '24.9', 0),
('500233565a264f3160e0d76034b5bbb2', './installer/schema/20090206_content_tpl_menu_tiki.sql', '24.9', 0),
('70324c0efc3a3fa7d82966f01050c621', './installer/schema/20090206_poll_tiki.sql', '24.9', 0),
('526e7e62f79d0a3a303661f107ab8c50', './installer/schema/20090211_mailnotification_tiki.sql', '24.9', 0),
('7803cbadaa3504e48ab96d2073b85a9f', './installer/schema/20090212_forum_tiki.sql', '24.9', 0),
('b9996cda2a892f43f736e15331321b44', './installer/schema/20090220_admin_section_tiki.sql', '24.9', 0),
('e2e57d5445fccb30772d339a4b6b3e4a', './installer/schema/20090226_admin_menu_tiki.sql', '24.9', 0),
('270f4a015a19424cef2cc35021be8572', './installer/schema/20090301_browsertitle_tiki.sql', '24.9', 0),
('e0d61c3cc6c9b77a755c891d85cb177c', './installer/schema/20090304_tiki_p_view_backlink_without_s_tiki.sql', '24.9', 0),
('f7bd45395c2ff0fd2798e35562df924a', './installer/schema/20090306_menu_perms_tiki.sql', '24.9', 0),
('06fd6cb8f5d2b047ea709ad02c625170', './installer/schema/20090306_text_for_menu_options_tiki.sql', '24.9', 0),
('ce4a78cdeb27a383ce8810ee4fa0d964', './installer/schema/20090310_application_menu_tiki.sql', '24.9', 0),
('cbbffca4f72b5728da74826e7837f286', './installer/schema/20090310_feature_search_show_object_filter_tiki.sql', '24.9', 0),
('667061194dd0bf84dfb4d1dcabeea9b1', './installer/schema/20090311_remove_mod_menu_application_menu_tiki.sql', '24.9', 0),
('956e0e696703ab32441f8ee6f8a6ab77', './installer/schema/20090316_index_tiki.sql', '24.9', 0),
('cbe4979f2306bafb7cbd672dd1cf01d8', './installer/schema/20090323_maxUserImpressions_banners_tiki.sql', '24.9', 0),
('54b66f96391a42d5708064e4ef4c8f97', './installer/schema/20090330_quicktags_renames_tiki.sql', '24.9', 0),
('6b2b361cdf76da968df937fa7376a181', './installer/schema/20090401_newsletters_included_tiki.sql', '24.9', 0),
('39598df227aa9dc8bdadd488df7bbee8', './installer/schema/20090401_replace_shoutjax_with_shoutbox_tiki.sql', '24.9', 0),
('bef61fb68a07da74003ff4afe066c802', './installer/schema/20090401_replace_switch_lang2_with_switch_lang_tiki.sql', '24.9', 0),
('493a63c7c8436b157a0200da3f7ed02d', './installer/schema/20090416_plugin_security_tiki.php', '24.9', 0),
('5998f3e1edb3d82c17cccde4533fcd30', './installer/schema/20090416_plugin_security_tiki.sql', '24.9', 0),
('c90f5078217322adfb556675fa934a82', './installer/schema/20090416_quicktags_kil_email_tiki.sql', '24.9', 0),
('93c12b32158f54c0633bf753269b6494', './installer/schema/20090416_quicktags_plugin_helpers_tiki.sql', '24.9', 0),
('bf02c6a99bf51c768fa4cd2078bb985b', './installer/schema/20090427_filegal_optionalize_tiki.sql', '24.9', 0),
('55df14def9249a255c63a08a413e8d52', './installer/schema/20090429_groupId_tiki.sql', '24.9', 0),
('47b2e95f6c75fc43dd02ec7cb3d3ce7c', './installer/schema/20090513_calendar_priority_tiki.sql', '24.9', 0),
('d9a996de940eb309bf773b52303d825f', './installer/schema/20090513_swffix_tiki.sql', '24.9', 0),
('32809522a429ac7b66f2f96d06d45a8f', './installer/schema/20090513_wiki_similar_permission_tiki.sql', '24.9', 0),
('4e4ceee2e728162c861597b2d63964af', './installer/schema/20090515_score_tiki.sql', '24.9', 0),
('22a74480ae1b46cad78ec1df893ccea0', './installer/schema/20090602_webmail_protocols_tiki.sql', '24.9', 0),
('442aa44b3f6f263b01edc9228dcad2ce', './installer/schema/20090605_tiki_p_modify_tracker_items_pending_closed_tiki.sql', '24.9', 0),
('337e0cfb80b1d8dc0a41385b9d3ac655', './installer/schema/20090617_add_new_table_for_reports_tiki.sql', '24.9', 0),
('9f92fa8fa2b8160595b2ac1381fae55a', './installer/schema/20090623_actionlog_view_article_tiki.sql', '24.9', 0),
('cb7026c21dbab9aeec235fff9f1a06b6', './installer/schema/20090626_change_pear_auth_preferences_to_ldap_tiki.sql', '24.9', 0),
('420b72a12e9646cae3b236144528f393', './installer/schema/20090707_tiki_p_delete_account_tiki.sql', '24.9', 0),
('ba933dc23124eb6cc7252fa0fceaa90c', './installer/schema/20090713_tiki_importer_permission_and_menu_entry_tiki.sql', '24.9', 0),
('62dd644b6e39e612d19f540e44282414', './installer/schema/20090715_sefurl_for_filegalleries_tiki.sql', '24.9', 0),
('531d11e98da6639283564c0e9ed17077', './installer/schema/20090720_perspectives_tiki.sql', '24.9', 0),
('e9b19e102e3eedad9ef8e8f7d032792c', './installer/schema/20090721_webmail_ext_public_tiki.sql', '24.9', 0),
('8139d5f5e562aafc301fe9e64a721c02', './installer/schema/20090727_category_permissions_tiki.sql', '24.9', 0),
('52d147c0e3a28323ddeae7728a6cd2d9', './installer/schema/20090727_user_votings_index_tiki.sql', '24.9', 0),
('628613b2da84a05f443544eaa6b99424', './installer/schema/20090730_p_list_newsletters_tiki.sql', '24.9', 0),
('b92b91a727e9bfb7a7fbe4ad11953a33', './installer/schema/20090803_perspective_permission_tiki.sql', '24.9', 0),
('82f33550024286cdc27d2915604e9158', './installer/schema/20090804_kaltura_permissions_tiki.sql', '24.9', 0),
('d5dc1e57a3396aef995cf2a910469897', './installer/schema/20090804_menu_search_tiki.sql', '24.9', 0),
('f72547e2cb4c194b8fa32d3bec3c9018', './installer/schema/20090805_kill_newsreader_tiki.sql', '24.9', 0),
('cc5c96b09f7b9706036f9bf9b9b73fac', './installer/schema/20090805_remove_drawings_prefs_etc_tiki.sql', '24.9', 0),
('c3f351efc86fb06230ecb11592ed2e9a', './installer/schema/20090805_remove_games_tiki.sql', '24.9', 0),
('cb13f0c90d7565566ffddedd17449dc0', './installer/schema/20090806_group_permissions_tiki.sql', '24.9', 0),
('4fffdf190d26d20a72f384036f924cbf', './installer/schema/20090806_menu_list_trackers_tiki.sql', '24.9', 0),
('0a52e5782358430e557664b7d5aa5c1c', './installer/schema/20090806_perms_featurechecks_tiki.sql', '24.9', 0),
('ee38952775b551eacf1bb72da93c5acb', './installer/schema/20090806_remove_charts_tiki.sql', '24.9', 0),
('8b5d955462daed16192cd422fc514590', './installer/schema/20090806_remove_latin_collations_tiki.sql', '24.9', 0),
('e1e6b59348c4e6ceb064d2af676b3620', './installer/schema/20090806_strasa_option_rename_tiki.sql', '24.9', 0),
('167fcb355e27d0813aa3c7f2ad1bb2d7', './installer/schema/20090807_transitions_tiki.sql', '24.9', 0),
('6adbc7a739c0fd262f6600bfc9630510', './installer/schema/20090808_add_wiki_minor_edits_tiki.sql', '24.9', 0),
('0067c2b32ca47ce7b42ea5d45f64cdf4', './installer/schema/20090809_marc_needs_more_space_tiki.sql', '24.9', 0),
('e0a7048d37a6f4ae95fe246a70935e6f', './installer/schema/20090811_filegals_container_tiki.sql', '24.9', 0),
('90cbc20466a1dcd55a42f4532099a4b3', './installer/schema/20090811_kaltura_editor_pref_tiki.sql', '24.9', 0),
('0c64b4b6661d1601b4b1d847b1e6810c', './installer/schema/20090811_quizzes_tiki.sql', '24.9', 0),
('b97dac6447ab14c1278a80bfef18d0d6', './installer/schema/20090811_rename_quicktags_to_toolbars_tiki.sql', '24.9', 0),
('4795abe4f54b97fe2fe1e851d1665031', './installer/schema/20090823_kaltura_menu_options_tiki.sql', '24.9', 0),
('4c19a550fa670b8680b4536491de9f58', './installer/schema/20090826_group_expiration_tiki.sql', '24.9', 0),
('c456caa0febc6f77a02d7202820b6878', './installer/schema/20090904_wysiwyg_newsletters_tiki.sql', '24.9', 0),
('055a4c9f0da1ea66388257c95851fd37', './installer/schema/20090911_tracker_item_change_user_tiki.sql', '24.9', 0),
('647c88b4faa510131fd775b6fd494129', './installer/schema/20090912_change_feature_name_for_lesser_magic_tiki.sql', '24.9', 0),
('97dea83392a7fde1ab54f1ce3df0f26a', './installer/schema/20090913_plugin_security_addedby_tiki.sql', '24.9', 0),
('fd23b4fc2cb7b31f09fcd533ec21f264', './installer/schema/20090915_change_perms_for_browse_cats_tiki.sql', '24.9', 0),
('1f07cce9c277e528d55fb4554f28cea1', './installer/schema/20090921_logo_tiki.sql', '24.9', 0),
('cdb431c229e167d50d864ae5355df674', './installer/schema/20090923_mod_change_category_defaults_tiki.php', '24.9', 0),
('f580a5bdef3c93176c9fcc963d6f7ee5', './installer/schema/20090925_online_logged_users_modules_merge_tiki.sql', '24.9', 0),
('b74f2d4a9ac9b184868809defef17b9e', './installer/schema/20090927_top_images_modules_merge_tiki.sql', '24.9', 0),
('d581271bb2b939b62a9c7d3468d71363', './installer/schema/20090928_galaxia_leftovers_tiki.sql', '24.9', 0),
('a9b31268ede9a9d19bad4b3e9a560858', './installer/schema/20090928_last_images_modules_merge_tiki.sql', '24.9', 0),
('47512729ed5702c29ebf674158b7dd22', './installer/schema/20090928_transition_guards_text_tiki.sql', '24.9', 0),
('30a1bf18ade46464db31147c91f9708f', './installer/schema/20091004_last_tracker_items_modules_merge_tiki.php', '24.9', 0),
('566e10ed8016fd2ae2e77017a6af5bc5', './installer/schema/20091007_update_database_structure_tiki.sql', '24.9', 0),
('44c61ac918cc1385b7640393c138efff', './installer/schema/20091008_reg_group_includes_anon_tiki.sql', '24.9', 0),
('1a6e2252aefc8b4549eea766c4681418', './installer/schema/20091011_serurl_dl_order_tiki.sql', '24.9', 0),
('2e691f9f536276faf13b3e7708f77863', './installer/schema/20091013_fix_perms_tiki.sql', '24.9', 0),
('c7ca3defd20741232a8c11b89d2250ab', './installer/schema/20091015_application_menu_admin_renames_tiki.sql', '24.9', 0),
('273bebc06180dcf99c0fbb6f57f32cae', './installer/schema/20091016_categorization_tracker_item_tiki.sql', '24.9', 0),
('54fc1c70f9f612b2048b0d54847706c9', './installer/schema/20091019_article_by_rating_modules_merge_tiki.php', '24.9', 0),
('fa8ea5e3b09eb58d39b5b522c7aa5b85', './installer/schema/20091019_last_articles_modules_merge_tiki.php', '24.9', 0),
('f8cef1ce28764cf186963efb6e754b6d', './installer/schema/20091019_users_perms_types_tidying_tiki.sql', '24.9', 0),
('cea39d8b633ccf21c530eb38dc8d5d4d', './installer/schema/20091020_bigger_user_prefs_tiki.sql', '24.9', 0),
('97f2e29237a5f2f66a8d68ef1d519aa9', './installer/schema/20091020_faq_created_tiki.sql', '24.9', 0),
('d64f44fb2fc4a66091c7f084278da4f0', './installer/schema/20091020_kaltura_tiki.sql', '24.9', 0),
('849edab4e7d7fdec986089032840ef2c', './installer/schema/20091020_remove_charts_tiki.sql', '24.9', 0),
('87b5cd3a5894c73bc20c2351b549d774', './installer/schema/20091020_sefurl_trackeritem_tiki.sql', '24.9', 0),
('89456db508a7a0d97200907f83c143b0', './installer/schema/20091021_moz_pagelist_tiki.sql', '24.9', 0),
('de6aa476f72445aa4dae312681ce9ebb', './installer/schema/20091023_bookmarks_name_lengthen_tiki.sql', '24.9', 0),
('4ebf9ad2bf9cc6d3e0c6046a38cd3096', './installer/schema/20091023_nul_categ_tiki.sql', '24.9', 0),
('a149de4e5b9d725180961926b6732bb9', './installer/schema/20091023_report_tiki.sql', '24.9', 0),
('345569753d67064166061deda3c47e34', './installer/schema/20091027_multiple_session_handler_tiki.sql', '24.9', 0),
('b3db4a3b28d2e6ca3751e7fdfd22a7a9', './installer/schema/20091028_quota_tiki.sql', '24.9', 0),
('a278b9df0b6b039001b9219863cb7625', './installer/schema/20091030_wiki_watch_tiki.sql', '24.9', 0),
('9177e60dc8783157d195d0a233e280c4', './installer/schema/20091103_upgrade_categperm_tiki.php', '24.9', 0),
('bbeb6795a1202644d61d82a6b3ab1e25', './installer/schema/20091105_auth_tokens_tiki.sql', '24.9', 0),
('f1570b8fd47a0dca223a15382da22709', './installer/schema/20091111_fgal_size_tiki.sql', '24.9', 0),
('7bd8ac55be14e25c7120a26f23eff436', './installer/schema/20091112_rename_mnu_application_menu_tiki.sql', '24.9', 0),
('712125292ff84ad268db796e12d0d860', './installer/schema/20091112_template_type_tiki.sql', '24.9', 0),
('7b18ad1124c4793f68eee26efecc6c15', './installer/schema/20091113_old_categ_perm_tiki.sql', '24.9', 0),
('cbeebd65f32c65d2171b5afe3cb0bb88', './installer/schema/20091118_sefurl_tiki.sql', '24.9', 0),
('893c7f6e4e519c67adc07265daffd31d', './installer/schema/20091120_poll_lookup_index_tiki.sql', '24.9', 0),
('df8cef1f416acca82b52e30e6094aadd', './installer/schema/20091120_username_pattern_tiki.sql', '24.9', 0),
('3e981f300423d52b094778c83e513245', './installer/schema/20091123_dns_permission_tiki.sql', '24.9', 0),
('55a8ac66a2d8b98982bb03e544927f18', './installer/schema/20091123_metrics_tiki.sql', '24.9', 0),
('87d6de29f4916800e3ede265fc179755', './installer/schema/20091123_upgrade_categperm_2_tiki.php', '24.9', 0),
('469e21d2779263943cd4c45f5f8db526', './installer/schema/20091124_fgal_backlink_tiki.sql', '24.9', 0),
('5b47492ea791031cf119ac3daf791f97', './installer/schema/20091124_metrics_dsn_tiki.sql', '24.9', 0),
('c070d97d1927459c781cd75887f40d11', './installer/schema/20091125_wiki_comments_per_page_tiki.sql', '24.9', 0),
('94d90cb820a65bdb9a64cb0d2396a643', './installer/schema/20091126_dynamic_variables_i18n_tiki.sql', '24.9', 0),
('5cb9af495c32baaab1a4c975d8cceaef', './installer/schema/20091204_filegal_wiki_syntax_tiki.sql', '24.9', 0),
('a72f40dc524ffce5390afc15923cb78f', './installer/schema/20091204_tiki_p_view_newsletter_tiki.sql', '24.9', 0),
('bb96171d83b521a6699b6cb1630c178e', './installer/schema/20091208_backlink_perms_tiki.sql', '24.9', 0),
('8e295076a1387fd3d68c8a0e23066c7a', './installer/schema/20091209_rss_feeds_name_tiki.sql', '24.9', 0),
('a5044acc14e9a7efe50944b93917d7b2', './installer/schema/20091210_charset_tiki.sql', '24.9', 0),
('d617149349d294764b6820ed8d412244', './installer/schema/20091210_dcs_type_tiki.sql', '24.9', 0),
('85989e9972d7f53e27ab3d34e7ed1506', './installer/schema/20091214_perspective_management_tiki.php', '24.9', 0),
('c275deb83663a95e4265677d33bda5de', './installer/schema/20091214_perspective_management_tiki.sql', '24.9', 0),
('ec2eeddd35627137e13ae7eef8c18f4c', './installer/schema/20091216_show_backlinks_tiki.sql', '24.9', 0),
('bff553fae8d722d9c239714e9e75f369', './installer/schema/20091228_page_keywords_tiki.sql', '24.9', 0),
('5b547103c6c3720dfd46515f3dc4b9cf', './installer/schema/20100101_search_modules_merge_tiki.sql', '24.9', 0),
('2e4b473f1a5ab5dbbf7933ddbb7e2cf4', './installer/schema/20100101_search_wiki_page_modules_merge_tiki.sql', '24.9', 0),
('6b8a6f903619170fc06b5e21acb8a88d', './installer/schema/20100104_tiki_p_tracker_revote_ratings_tiki.sql', '24.9', 0),
('3cbd0d19bfef3b685a304e96902656d8', './installer/schema/20100106_forum_att_list_nb_tiki.sql', '24.9', 0),
('5615afe6adc083d68e9b55539cd2fb57', './installer/schema/20100107_payment_tiki.sql', '24.9', 0),
('0e531e6cd9f6bc248c9e940afcdce1c9', './installer/schema/20100113_forum_display_tiki.sql', '24.9', 0),
('3e8c5924e3563c9f15474662ed5165c5', './installer/schema/20100114_tiki_actionlog_merge_tiki.sql', '24.9', 0),
('8b23e2a3a3dc1aa2bd6be6650005e50e', './installer/schema/20100115_admin_modules_menu_tiki.sql', '24.9', 0),
('69a98c55dfdb0639be58af44be275639', './installer/schema/20100115_tiki_p_admin_modules_tiki.sql', '24.9', 0),
('7435683dd08e061a90055de63c6ca777', './installer/schema/20100115_translations_in_progress_tiki.sql', '24.9', 0),
('42a4ae39d6d4045d0e4d96fd785fd620', './installer/schema/20100117_old_doc_tw_o_url_tiki.sql', '24.9', 0),
('a7311875283acb4a98ea9210ff9588ba', './installer/schema/20100118_blog_use_author_tiki.sql', '24.9', 0),
('79e3b88f76c6ced0918f76d5b6665578', './installer/schema/20100118_forum_display_tiki.sql', '24.9', 0),
('2ea1308ff02955c7b6656076301299ab', './installer/schema/20100126_file_lastDownload_tiki.sql', '24.9', 0),
('68f8d2e78cc73e8562839970ba92a70d', './installer/schema/20100128_tiki_p_blog_view_ref_tiki.sql', '24.9', 0),
('6f2fff9200d779aabaf21e7144b5ecdd', './installer/schema/20100129_clean_up_tiki.sql', '24.9', 0),
('7413da3b3b575abed3464e09b768a080', './installer/schema/20100129_events_kil_tiki.sql', '24.9', 0),
('c66c9f9a5d2d14ae38ac664738d0836d', './installer/schema/20100203_payment_detail_tiki.sql', '24.9', 0),
('888c53dd6f29cd376fde45828fc8d69d', './installer/schema/20100205_tiki_p_wiki_view_ref_tiki.sql', '24.9', 0),
('9bba0c32136ab966239d772e8c612fd6', './installer/schema/20100207_repair_file_galleries_tiki.php', '24.9', 0),
('2d73cd82c5b1ef6b75e2661cd5ec7948', './installer/schema/20100211_rss_items_tiki.sql', '24.9', 0),
('350aff4b5e0a30d274134424b0788327', './installer/schema/20100211_tiki_perms_menu_item_tiki.sql', '24.9', 0),
('3fcab51527f14091b72a61862d375c45', './installer/schema/20100211_tiki_sheet_add_parseValues_tiki.sql', '24.9', 0),
('f2596badf24baf56d10e2c6789213960', './installer/schema/20100212_rss_automation_tiki.sql', '24.9', 0),
('b8760600ba1e21e712f362e63befac45', './installer/schema/20100213_group_inclusion_key_tiki.sql', '24.9', 0),
('c517e0b264751804c7ff41e37f1a413c', './installer/schema/20100214_workspaces_remove_menu_items_tiki.sql', '24.9', 0),
('50673717c01a153edf7b182b1c2be24e', './installer/schema/20100215_create_tiki_user_login_cookies_tiki.sql', '24.9', 0),
('54cc4bcc3ffa4453554c3ce8b06fecc3', './installer/schema/20100215_rating_permissions_tiki.sql', '24.9', 0),
('26aace3abeb9deef32cdc5480e1ddc22', './installer/schema/20100216_attributes_tiki.sql', '24.9', 0),
('36037bd886a0e5868c5fe59c337f6c2e', './installer/schema/20100216_kil_moz_screencast_tiki.sql', '24.9', 0),
('8a232ebfe1aff7c6a9cc6ad47b88a4cf', './installer/schema/20100216_rename_tikisheet_tiki.sql', '24.9', 0),
('89235a225a0a4d3128faf72bc4730993', './installer/schema/20100217_rating_config_tiki.sql', '24.9', 0),
('62a29f5266842c3aafc5e77ca31a4b3f', './installer/schema/20100218_auth_token_reuse_tiki.sql', '24.9', 0),
('0dcee212645ce8000ad216d6bf812c2e', './installer/schema/20100222_add_webmail_fromEmail_field_tiki.sql', '24.9', 0),
('5cf4ae8252efbc6fc53560fb1855fbd6', './installer/schema/20100222_sheet_toolbar_default_tiki.sql', '24.9', 0),
('01714f7d35dd064f2ea3075ea8046096', './installer/schema/20100223_blog_always_owner_tiki.sql', '24.9', 0),
('d13f58b231384ea0a721ec5f5bd4c3bf', './installer/schema/20100224_object_relations_tiki.sql', '24.9', 0),
('9a60dd3d2db1b9e7a0187a818ef08d7a', './installer/schema/20100226_menu_template_feature_check_tiki.sql', '24.9', 0),
('ce7a80dc86bcabf4372e9745cce0e440', './installer/schema/20100226_tracker_dump_perm_tiki.sql', '24.9', 0),
('a1191e4c09d52e1886507e62e6573994', './installer/schema/20100302_filegal_images_max_sizes_tiki.sql', '24.9', 0),
('bf751d0e1c3ad816fbdd7e612c1880db', './installer/schema/20100308_file_delete_after_tiki.sql', '24.9', 0),
('902b64fe934469ed98341678a7840245', './installer/schema/20100309_add_sheet_parent_tiki.sql', '24.9', 0),
('6164442730abf0ff4849170a5c90dbda', './installer/schema/20100312_emailPattern_tiki.sql', '24.9', 0),
('3c97d38fb32ce744185b6ff04d58fa0d', './installer/schema/20100324_newsletters_clippings_tiki.sql', '24.9', 0),
('8d0e67468c13d44ce90601a230c7fd68', './installer/schema/20100409_bigger_module_params_tiki.sql', '24.9', 0),
('4177492c2f4ee3bfbe97c90f38ae0626', './installer/schema/20100414_actionlog_pref_tiki.sql', '24.9', 0),
('f2e50c371c67658571f3290165beff43', './installer/schema/20100414_actionlog_system_tiki.sql', '24.9', 0),
('bbaebffa62af9ccfc56bcece0793b7e0', './installer/schema/20100419_bigbluebutton_tiki.sql', '24.9', 0),
('f4afdf505b5739a5c0686e45a8db05e7', './installer/schema/20100422_tracker_log_tiki.sql', '24.9', 0),
('046e3a3749bdd49c23cbb1336f0cb588', './installer/schema/20100429_newsletter_pages_tiki.sql', '24.9', 0),
('6472896d5422a4d97ade0131e9824067', './installer/schema/20100507_flash_banner_tiki.php', '24.9', 0),
('1b5f530a959dd6c18375fdacf258c03e', './installer/schema/20100519_actionlog_tiki.sql', '24.9', 0),
('f7f3a83c028f4a1afbc5e4ad922386fb', './installer/schema/20100525_tracker_validation_message_tiki.sql', '24.9', 0),
('50075186c65a27d7a0eee7962f0f0862', './installer/schema/20100525_tracker_validation_tiki.sql', '24.9', 0),
('c85d90ed2ab759856b41dc3d705f7a96', './installer/schema/20100611_rss_items_url_tiki.sql', '24.9', 0),
('4cb7c699ac79b750404f413e18841472', './installer/schema/20100617_sefurl_user_info_tiki.sql', '24.9', 0),
('7a887d3c80359db3c7baf7a18b4a51d0', './installer/schema/20100618_calendar_participation_tiki.sql', '24.9', 0),
('2c666df90eaaa04fb2ee6d1928b38814', './installer/schema/20100621_pageprefixaliasdata_tiki.sql', '24.9', 0),
('838bb67100b2ef14a12db5d8f026fe24', './installer/schema/20100622_pageprefixtrackeritemid_tiki.sql', '24.9', 0),
('937449fffccc2b7b282500f72867a4f1', './installer/schema/20100623_semantic_to_relation_tiki.php', '24.9', 0),
('4673960aa9da0b18682403cb6be37d5a', './installer/schema/20100623_semantic_to_relation_tiki.sql', '24.9', 0),
('690f54a7ae99b145b7fdda6c8df6d1b8', './installer/schema/20100624_banning_index_tiki.sql', '24.9', 0),
('49f703eb7f92a2ecf5d8cd7e127dd02e', './installer/schema/20100628_payment_user_tiki.sql', '24.9', 0),
('687f64c286450f0fe0de1cfbf05c3d0e', './installer/schema/20100629_remove_feature_blog_comments_tiki.sql', '24.9', 0),
('7b0af15477349384dbd3b1010397946e', './installer/schema/20100702_discount_tiki.sql', '24.9', 0),
('1cd43cc0c8d523dc0e9d7dda5e6fd25f', './installer/schema/20100712_remove_unsupported_feed_formats_tiki.sql', '24.9', 0),
('19adc11a5cc9a329cedc5f84f4f90e61', './installer/schema/20100713_rename_feed_prefs_tiki.sql', '24.9', 0),
('91725fe31a54b7681540807302be4a48', './installer/schema/20100714_batch_transition_tiki.sql', '24.9', 0),
('e62cac7f6a4bc314978ee2ac087d67a7', './installer/schema/20100716_user_selector_pref_rename_tiki.sql', '24.9', 0),
('a0719690681cf54c6ecdddeda600dc28', './installer/schema/20100720_tiki_p_view_page_contribution_tiki.sql', '24.9', 0),
('7fbf99c2db7f32abaa339668cbcd06d3', './installer/schema/20100721_batch_transition_rollback_tiki.sql', '24.9', 0),
('45d5a01c4ad08d3c331d77c3e1dd19c0', './installer/schema/20100721_todo_tiki.sql', '24.9', 0),
('57eb1c692598aebcc6f6c62be8267419', './installer/schema/20100721_todonotif_tiki.sql', '24.9', 0),
('5b12e1bc1238983e0fd1ced13c876eb0', './installer/schema/20100727_tiki_p_promote_page_tiki.sql', '24.9', 0),
('c3049a9ad85d934d80509f1bce54ed56', './installer/schema/20100730_list_image_article_tiki.sql', '24.9', 0),
('5b0a22957d84f831f300f0040aeeb6a0', './installer/schema/20100802_tiki_p_share_tiki.sql', '24.9', 0),
('8e02a6d8ad2e1cc0c9e2bf6f9ee8ed28', './installer/schema/20100802_url_shortener_tiki.sql', '24.9', 0),
('44806754ed381ae3a982f7837e49bccd', './installer/schema/20100804_remove_tiki_languages_tiki.sql', '24.9', 0),
('d25e77ce8d4571079e175bc6c47396f2', './installer/schema/20100806_blog_posts_header_tiki.sql', '24.9', 0),
('686669d28d921b67f74e73c939c72a6c', './installer/schema/20100807_alter_tiki_translate_fields_to_text_tiki.sql', '24.9', 0),
('7ef9c8bb7582170a536f47932aee91d4', './installer/schema/20100810_title_comments_upgrade_tiki.sql', '24.9', 0),
('8df0894c777a22e016d7c86adeb5c21a', './installer/schema/20100812_blog_control_max_related_content_tiki.sql', '24.9', 0),
('3ea3be26f5d40cf2edd81abd799ba344', './installer/schema/20100812_blog_show_related_content_tiki.sql', '24.9', 0),
('31c1a0ef9f413ab92ceb6bfe4523fbe3', './installer/schema/20100817_add_email_and_website_fields_to_comments_tiki.sql', '24.9', 0),
('6ea024455e832c9103a199533dbe6568', './installer/schema/20100817_credits_tiki.sql', '24.9', 0),
('5d2cc4aa05385cfc2eba8ac701ae148e', './installer/schema/20100817_rename_preference_wiki_comments_notitle_tiki.sql', '24.9', 0),
('4a3d0c92c69fb3dcc0b9770d62d27c71', './installer/schema/20100818_watch_tiki.sql', '24.9', 0),
('2759ff42a931fce14c367e87ae4c0331', './installer/schema/20100820_blog_posts_wysiwyg_tiki.sql', '24.9', 0),
('31bcc44f8cb269593a399ee00313995e', './installer/schema/20100820_feed_fields_text_and_desc_are_not_empty_tiki.sql', '24.9', 0),
('8d0992f78c263a025ccbd605f6fb7262', './installer/schema/20100824_blog_post_excerpt_tiki.sql', '24.9', 0),
('e2a19962bed53701d9998d7c4434a85d', './installer/schema/20100825_add_changed_column_to_tiki_language_table_tiki.sql', '24.9', 0),
('f0f6af415f67e26aee90c86b87dbf387', './installer/schema/20100825_remove_blog_option_use_title_tiki.sql', '24.9', 0),
('890a3d6accb68581f7d00ebd2c347c1e', './installer/schema/20100830_sheet_add_styles_and_classes_tiki.sql', '24.9', 0),
('560834495744de5dc66690afea1a7626', './installer/schema/20100831_freetag_tiki.sql', '24.9', 0),
('47ed97c0106c3693caa30a0e2ba418fb', './installer/schema/20100901_duplic_actionlog_tiki.sql', '24.9', 0),
('d1f95ffd6ff3f55516c7ff77e3d51297', './installer/schema/20100901_expire_tiki.sql', '24.9', 0),
('99eb503b8e9fcbb4951be5545cc87b9e', './installer/schema/20100902_invit_tiki.sql', '24.9', 0),
('c2b3511dc21a90f27e01a2b270b36ff4', './installer/schema/20100903_article_ispublished_tiki.sql', '24.9', 0),
('57ba839a9b670ba2d383e95875842a79', './installer/schema/20100906_sheet_toolbar_default_tiki.sql', '24.9', 0),
('7a6c571a8fa5ae4142a639593d567671', './installer/schema/20100909_alter_tiki_language_fields_to_text_tiki.sql', '24.9', 0),
('56c277c30f3bb31dc71972f0b90b860a', './installer/schema/20100909_ckeditor_upgrade_tiki.sql', '24.9', 0),
('0d2cdf85fdd09e62d49b8f21ce1e0b48', './installer/schema/20100909_lengthen_wiki_attachments_filename_tiki.sql', '24.9', 0),
('c2c91b87c9818a362b19af7d95361bee', './installer/schema/20100910_new_fields_for_tiki_blogs_tiki.sql', '24.9', 0),
('de4d46f4cc1e55843ee4fb763f1bfbb2', './installer/schema/20100912_rename_autosave_pref_tiki.sql', '24.9', 0),
('ceb893e4b41453e3f40e6f49740694a8', './installer/schema/20100915_add_edit_languages_menu_option_tiki.sql', '24.9', 0),
('b013ef3769d8303ade0931d40bcadbbe', './installer/schema/20100919_tiki_page_contribution_tiki.sql', '24.9', 0),
('9628e595d2392ac509aa9a851b416822', './installer/schema/20100920_ckeditor_remove_pref_tiki.sql', '24.9', 0),
('ea7b94f6c26c78f9cfe9914004b126a2', './installer/schema/20100920_jq_sheet_remove_pref_tiki.sql', '24.9', 0),
('0f0e8d6edd889f948074b5c58eb706d3', './installer/schema/20100920_todo_event_tiki.sql', '24.9', 0),
('0a44187ddda66fb57a8e37de3c683697', './installer/schema/20100923_fix_column_position_tiki.sql', '24.9', 0),
('70deaf3aecb55eff018d3f3d692a7838', './installer/schema/20100923_social_networking_permission_and_menuitem_tiki.sql', '24.9', 0),
('15b3ea9e0602ba476f14eca5ed031f62', './installer/schema/20100925_fix_some_default_value_tiki.sql', '24.9', 0),
('3c54c8d472f6d6a8ee46f5616c13ecc1', './installer/schema/20100927_better_column_fix2_tiki.php', '24.9', 0),
('35852a3b5257abe75a2bac236d3872ea', './installer/schema/20100927_better_column_fix_tiki.php', '24.9', 0),
('7078f85293d9b2df64d6b783fd69a8f9', './installer/schema/20100928_sefurl_regex_reordering_tiki.sql', '24.9', 0),
('b319e7d8b377939e46e5c59fbbfc9cdb', './installer/schema/20101008_user_id_for_tiki_language_tiki.sql', '24.9', 0),
('aa530de5c60b975c437300e3789b2f88', './installer/schema/20101014_tiki_language_add_lastModif_column_tiki.sql', '24.9', 0),
('d982ed41cbf120d9b6c2ebe5ac7e2813', './installer/schema/20101015_tiki_admin_perms_tiki.sql', '24.9', 0),
('f641cc4bf74fb2e9ff547e1aac5c17ae', './installer/schema/20101021_rename_blog_post_comment_object_type_tiki.sql', '24.9', 0),
('ae10d405e50604c62961ff3f82c58fdb', './installer/schema/20101025_fgal_show_deleteAfter_tiki.sql', '24.9', 0),
('0a0afe6962bb24e3d73b2c9409e54fcd', './installer/schema/20101025_profile_sources_pref_tikiwiki_to_tiki.sql', '24.9', 0),
('8d475ba6cabe360e56d29efdbea5e905', './installer/schema/20101025_rename_create_blog_menu_entry_tiki.sql', '24.9', 0),
('3e70698041a57203ad6063378c85984a', './installer/schema/20101026_auth_token_add_columns_tiki.sql', '24.9', 0),
('6497387d0c7806b7aa2427ebef94f37b', './installer/schema/20101027_add_file_gallery_columns_tiki.sql', '24.9', 0),
('228fe45691621f0bb44c70c86a2313c4', './installer/schema/20101027_rename_invit_to_invite_tiki.sql', '24.9', 0),
('8c9d09f4bcecefe64b6610e390492a55', './installer/schema/20101028_p_invit_tiki.sql', '24.9', 0),
('06adc57267b54f62d81f7045853d2842', './installer/schema/20101110_actionlog_tiki.sql', '24.9', 0),
('b61f72f5e9c94f9868f641b673f08ec9', './installer/schema/20101117_actionlog_tiki.sql', '24.9', 0),
('18252b1f4851a73f05c7108718b95836', './installer/schema/20101119_categ_perm_tiki.sql', '24.9', 0),
('08aeb20f9f5cd70bb526b8cf19d9a87f', './installer/schema/20101126_fgal_add_gallerie_user_tiki.php', '24.9', 0),
('e4b0f44e867fc72e58fb85fc610399a9', './installer/schema/20101130_recreate_tiki_accounting_tables_tiki.sql', '24.9', 0),
('3302b26e70bb5b51e46e783fdea048ed', './installer/schema/20101130_tiki_accounting_tiki.sql', '24.9', 0),
('f4f667d5a0393718c980cf83fe5be0a6', './installer/schema/20101201_tiki_accounting_fix_index_tiki.sql', '24.9', 0),
('ab434bc67f52b72a28cce6ab0ae0d351', './installer/schema/20101203_fgal_archive_default_tiki.sql', '24.9', 0),
('9d6fdac3ebb63a29a4a6fc67e925d9f7', './installer/schema/20101207_feature_file_drafts_tiki.sql', '24.9', 0),
('a46381a5a632a1c933b5e776c39fee0d', './installer/schema/20101208_webservice_soap_tiki.sql', '24.9', 0),
('52835b1012d22aad19d69d2092bb50d8', './installer/schema/20101210_fgal_add_wiki_attachments_tiki.php', '24.9', 0),
('dd5468fab59af87a2aa1d9d86c46d125', './installer/schema/20101210_sync_users_ldap_tiki.sql', '24.9', 0),
('5058136507b87f7dad9221c554f053b4', './installer/schema/20101211_filegal_maxhits_column_tiki.sql', '24.9', 0),
('d64e1fdf7f48cb8fad3dc0bf8b883472', './installer/schema/20101211_kil_feature_phplayers_tiki.php', '24.9', 0),
('f6e3f8d12dc1ab16f9b8375f553a64be', './installer/schema/20101215_remove_files_tiki.sql', '24.9', 0),
('56bd633ebe67ea8013b7263320d9d442', './installer/schema/20101215_template_file_galleries_tiki.sql', '24.9', 0),
('3de83e0ba0fb478781deadea680de629', './installer/schema/20101219_kill_feature_mobile_tiki.sql', '24.9', 0),
('75012215209463f55088c6f9cbe94e92', './installer/schema/20101230_create_top_modules_tiki.php', '24.9', 0),
('d9cf35b0058aecae96913a8e7c39f99a', './installer/schema/20110103_include_in_history_tiki.sql', '24.9', 0),
('24ff523ffad872d3ce90571ce0d70702', './installer/schema/20110104_flagged_revision_log_tiki.sql', '24.9', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_again_tiki.sql', '24.9', 0),
('80bf3571ece806c22a7c99ca3fbd8e20', './installer/schema/20110104_sefurl_trackeritem_tiki.sql', '24.9', 0),
('83e49b253f0a00059a979cd3a88a6343', './installer/schema/20110112_approval_permissions_tiki.sql', '24.9', 0),
('a72544e525fe91386605bb6d8b3e9ebc', './installer/schema/20110115_create_bottom_modules_tiki.php', '24.9', 0),
('0b0ad5da10e9c802b02aff9be0e603a7', './installer/schema/20110118_p_remove_tracker_items_tiki.sql', '24.9', 0),
('c55afd33b7db3e2822c266655eee7aa7', './installer/schema/20110124_update_sheet_to_support_cloning_tiki.sql', '24.9', 0),
('b423ec67d41fbb313dd8d2eedc6ce42e', './installer/schema/20110201_c_code_to_user_modules_tiki.php', '24.9', 0),
('96de5f8fc058be02a0d781c11f96876f', './installer/schema/20110209_p_list_users_tiki.sql', '24.9', 0),
('e182b1170b0628144f3b7031b4ae9e56', './installer/schema/20110220_p_tracker_view_attachments_tiki.sql', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('cf450811ce67bd74a29f4c977127e74f', './installer/schema/20110223_queue_tiki.sql', '24.9', 0),
('540c8adbe21843a849f78019a3a90752', './installer/schema/20110224_tiki_cart_inventory_hold_tiki.sql', '24.9', 0),
('097d060cf3ea7d34012d7692bcdefe40', './installer/schema/20110307_remove_calendar_reminder_tiki.sql', '24.9', 0),
('9383d1ca207d3aec10bf0e8847b8e8f2', './installer/schema/20110308_rss_item_key_tiki.sql', '24.9', 0),
('58b53aa01ecf477ac82dde6e4ef3d7e5', './installer/schema/20110317_attributes_increase_length_tiki.sql', '24.9', 0),
('9830d9ebee9ed93916946a229528d0f0', './installer/schema/20110411_banner_tiki.sql', '24.9', 0),
('8540fc07af7bdbbe76307d4af97a02fc', './installer/schema/20110412_permissions_out_of_db_tiki.sql', '24.9', 0),
('93e5ba1928f66db69d80f8556f6e0279', './installer/schema/20110413_blog_post_priv_default_value_tiki.sql', '24.9', 0),
('56eb71d5321768180d28bbdd0d54a1ae', './installer/schema/20110419_kill_old_search_tiki.sql', '24.9', 0),
('221fbfc6f88ef2630110ad5f6e19a358', './installer/schema/20110420_newsletter_optional_group_inclusion_tiki.sql', '24.9', 0),
('37c7ccf6d9b10f0bd4612d2967a8c309', './installer/schema/20110421_compact_search_in_topbar_tiki.sql', '24.9', 0),
('22ac2552b70bc5b077c29450466aeec9', './installer/schema/20110507_remove_module_style_params_tiki.sql', '24.9', 0),
('c19e62816382404968d7a6dfff401da2', './installer/schema/20110513_banner_tiki.sql', '24.9', 0),
('ac7ae8882b9ce4f6592e24f6f2191417', './installer/schema/20110519_quick_edit_categ_params_merge_tiki.php', '24.9', 0),
('6ad0dbeb2003eb63e2782ce8578ed710', './installer/schema/20110603_convert_tracker_comments_tiki.sql', '24.9', 0),
('9820218bc613e80463759ac5cdffcb61', './installer/schema/20110606_convert_ip_fields_to_ipv6_tiki.sql', '24.9', 0),
('814e112fec7fd080bd49fc2626d57c3a', './installer/schema/20110609_batch_update_tracker_item_links_tiki.php', '24.9', 0),
('787a5f5d2bab3458b3012ae54469ee1c', './installer/schema/20110609_missing_sql_tiki.sql', '24.9', 0),
('bd0327ed767ba8fcaef7563d8113e9e9', './installer/schema/20110609_unique_login_tiki.php', '24.9', 0),
('cba144f85a3b3f21ab9c7e6a58c9801f', './installer/schema/20110610_readd_sefurl_index_left_tiki.php', '24.9', 0),
('91c42f4d63be3364b9f7d04125fabc7f', './installer/schema/20110610_revert_poll_additions_tiki.php', '24.9', 0),
('118fe0373f666f454253d166c37723d3', './installer/schema/20110611_accounting_fix_primarykeys_tiki.sql', '24.9', 0),
('7ac89aee06b1e7dfc191afd6b837af2b', './installer/schema/20110613_filegal_source_display_tiki.sql', '24.9', 0),
('04c304ade37e768c0f20d4da1bb6cc31', './installer/schema/20110614_provider_authentication_tiki.sql', '24.9', 0),
('45cc111cc1df4c17c6982177b24a0250', './installer/schema/20110615_structure_alias_tiki.sql', '24.9', 0),
('3d3efcb12b2491dade431346a93f4272', './installer/schema/20110622_file_from_url_log_tiki.sql', '24.9', 0),
('2881aa2867a68821baa2f8a9d95e16cb', './installer/schema/20110630_fix_blogs_copyright_frencho_tiki.sql', '24.9', 0),
('1207ff134476c048445fa5a175aeda3d', './installer/schema/20110717_invoice_menu_options_tiki.sql', '24.9', 0),
('d706c164e7327bf66d68644d7297e921', './installer/schema/20110725_tracker_field_permname_tiki.sql', '24.9', 0),
('2b031eedf493fb3136fe93441621c6c7', './installer/schema/20110727_tracker_multilingual_convert_tiki.php', '24.9', 0),
('9c2fe77d70c17df2c038e4488b17d794', './installer/schema/20110727_tracker_multilingual_convert_tiki.sql', '24.9', 0),
('94392c46b0ed3843e2cc020e7c75db6f', './installer/schema/20110803_objectpermissions_tiki.sql', '24.9', 0),
('3713bca2297fd26847d523ac6512224b', './installer/schema/20110808_default_perm_name_tiki.sql', '24.9', 0),
('2616b96d2ce5225935c658d36a171833', './installer/schema/20110808_tracker_tiki.sql', '24.9', 0),
('a08aa709071292d07d56267037fd0f95', './installer/schema/20110815_creator_lost_7_tiki.sql', '24.9', 0),
('4fc9819d32aca61b48496e52c8aa36f9', './installer/schema/20110819_group_max_length_tiki.sql', '24.9', 0),
('b3428c386e01fbe73047c55cadcc30f0', './installer/schema/20110823_tiki_connect_create_tiki.sql', '24.9', 0),
('a76c5fd4c8be26941833260514dc7d0e', './installer/schema/20110830_default_enable_in_use_tiki.php', '24.9', 0),
('1b9c3c961e6deca124a4012adf6a2734', './installer/schema/20110830_tiki_connect_longer_guid_tiki.sql', '24.9', 0),
('de8ba9e91a1110eea3fb49fe9091cf9b', './installer/schema/20110902_revert_rootCategId_addition_tiki.php', '24.9', 0),
('328b8627af75d5564f388731ab74c711', './installer/schema/20110904_shoutbox_def_tweetid_tiki.sql', '24.9', 0),
('06177cffcaa034aa10f307ab16118ee4', './installer/schema/20110905_extend_actionlog_comment_tiki.sql', '24.9', 0),
('abec308e53b749cb36b9132745860a3a', './installer/schema/20110905_multibyte_lc_fix_tiki.php', '24.9', 0),
('24ce6ceaf2a590a5291cbb899b6b8ce7', './installer/schema/20110908_author_submission_tiki.sql', '24.9', 0),
('322244495b3f612ff070dba910433fde', './installer/schema/20110909_tiki_forums_add_language_tiki.sql', '24.9', 0),
('13a301980674abdc01e85abea9425dfa', './installer/schema/20110911_add_missing_engine_specs_tiki.sql', '24.9', 0),
('76e3828702b68de894048a364ad096f3', './installer/schema/20110912_groupsexpiryanniversary_tiki.sql', '24.9', 0),
('6e71326d28f1b81e66467802d5dfed74', './installer/schema/20110912_remove_unused_fields_tiki.sql', '24.9', 0),
('6114f9218bd29cdc11f8c1a1d039985e', './installer/schema/20110923_referer_stats_tiki.sql', '24.9', 0),
('5cb9b8bc23137ec40da043d997af27cc', './installer/schema/20110926_tracker_menu_feature_reports_tiki.sql', '24.9', 0),
('a9f5fe2dbd1789987812f4d8932a8c6d', './installer/schema/20111001_add_tiki_areas_tiki.sql', '24.9', 0),
('407750420d6d2827c1198ce722fefc24', './installer/schema/20111006_drop_useless_key_tiki.sql', '24.9', 0),
('a6838deaa28c29b62f0750e34f391312', './installer/schema/20111010_revert_fix_user_bookmarks_folders_key_tiki.php', '24.9', 0),
('e4fd615f3ee7224ce7065179ac05b602', './installer/schema/20111014_menu_feature_time_sheet_tiki.sql', '24.9', 0),
('e49fc3a8c6b20f7beee8389d50f0f134', './installer/schema/20111118_remove_versionOfPreferencesCache_tiki.sql', '24.9', 0),
('955501778236fe83504e4ce2c02099c8', './installer/schema/20111210_add_blog_hits_tiki.sql', '24.9', 0),
('8c3eefd5747facc604522bce0b7a3b0a', './installer/schema/20111217_on_value_tracker_tiki.sql', '24.9', 0),
('7f604d1b91c64aeb6251b6b6268460fe', './installer/schema/20111231_change_datetime_defaults_to_null_tiki.php', '24.9', 0),
('54901ab93551e49fd2372410d26f24d7', './installer/schema/20120115_remove_article_show_lang_tiki.sql', '24.9', 0),
('eb75b6d04c0ba431ba96f3f3e00b183e', './installer/schema/20120118_remove_users_prefs_language_tiki.sql', '24.9', 0),
('8aa7cfcc0e89ac36204d4d2923d782dd', './installer/schema/20120123_remove_column_from_tiki_user_reports_tiki.sql', '24.9', 0),
('6f7ae9d4d88d1fd8f47ed4207a142ec7', './installer/schema/20120315_list_image_article_y_tiki.sql', '24.9', 0),
('c117ae7f125445e353e66fc93d15c793', './installer/schema/20120319_remove_sheets_with_no_relation_tiki.sql', '24.9', 0),
('47a64215b806bc69fc1762bec8628a80', './installer/schema/20120320_remove_admin_trackers_application_menu_tiki.sql', '24.9', 0),
('8be855afd09afffd9421030ef884d7c0', './installer/schema/20120323_add_reports_to_application_menu_tiki.sql', '24.9', 0),
('5915f745e660dbfb599856e21d1d5a8c', './installer/schema/20120323_remove_tracker_reports_from_application_menu_tiki.sql', '24.9', 0),
('46b7f80f9589da64c98a70b9269c6cc2', './installer/schema/20120324_add_filegals_icon_tiki.sql', '24.9', 0),
('ef7cd89a6a747950a94c018b0b9b3021', './installer/schema/20120401_kaltura_prefs_rename_tiki.sql', '24.9', 0),
('7e861d8be89c62e0fc790c580905c8df', './installer/schema/20120408_add_forumthread_sefurl_tiki.sql', '24.9', 0),
('e5c32a4acc3564abb7646802d82939ea', './installer/schema/20120421_autoincementtoautoincrement_tiki.sql', '24.9', 0),
('0351e57b91c6022444ecfeffc7c72e07', './installer/schema/20120422_mime_tiki.sql', '24.9', 0),
('98c3ad22db54d5a603bf29f8711da702', './installer/schema/20120423_add_page_refs_tiki.sql', '24.9', 0),
('0a97722ec5858dade8610abc538d06a3', './installer/schema/20120423_add_status_attr_tiki.sql', '24.9', 0),
('eb751653821eea4afa005a21965fb001', './installer/schema/20120426_perspectives_menu_entry_tiki.sql', '24.9', 0),
('065220f370cf11f688281a5c21a047ce', './installer/schema/20120426_tiki_db_status_tiki.sql', '24.9', 0),
('4c1106f51f5e2020d48b0ef2ed815992', './installer/schema/20120429_fix_collation_tiki.php', '24.9', 0),
('2a1743af01a89efb43f2e6b0822ca5d7', './installer/schema/20120510_mailqueue_tiki.sql', '24.9', 0),
('02fd7c020f0f0eecb8c46c966387bfa7', './installer/schema/20120604_add_holder_to_copyright_tiki.sql', '24.9', 0),
('8965cd9fbbeae4f092b9113f32a53c08', './installer/schema/20120628_correct_admin_user_createdate_tiki.sql', '24.9', 0),
('f77420b5c17943f0f57b9ae25f40fd04', './installer/schema/20120823_admin_user_credit_menu_entry_tiki.sql', '24.9', 0),
('553bcde43dd2576908d5838a34cd9261', './installer/schema/20120823_workspace_template_tiki.sql', '24.9', 0),
('849d88e7bb98c32166cc7f7c8e422bf0', './installer/schema/20120824_advanced_mode_flag_tiki.sql', '24.9', 0),
('b09f72e445325d5b290bd74023b5f956', './installer/schema/20120825_accounting_menu_entry_tiki.sql', '24.9', 0),
('b94ca87f607d459633ed52b307917eb8', './installer/schema/20120826_store_metadata_tiki.sql', '24.9', 0),
('e3aa197642a27bfad77a0ba3b2ea25fe', './installer/schema/20120904_category_root_tiki.php', '24.9', 0),
('040310ecc810ced038db139a0bf9943d', './installer/schema/20120904_category_root_tiki.sql', '24.9', 0),
('46aadea27a9cd9646b771b97b4a9ab30', './installer/schema/20120927_add_area_exclusive_and_common_tiki.sql', '24.9', 0),
('29f3ec57c679da3c747c8d1fb78f4bcd', './installer/schema/20120927_add_menu_parse_tiki.sql', '24.9', 0),
('2a44d38e5345ebf58742ba826ecb5ecc', './installer/schema/20120930_tiki_p_view_poll_choices_tiki.sql', '24.9', 0),
('3cb67ce6e2d0c884110fd7848c94a7c9', './installer/schema/20121009_module_search_box_to_search_tiki.sql', '24.9', 0),
('7ffee0c3c2c04925d2657e7a3aced53e', './installer/schema/20121016_actionlog_comment_text_tiki.sql', '24.9', 0),
('1322b29fedaa19ebc14140315407cbc1', './installer/schema/20121027_tracker_samerow_fix_tiki.sql', '24.9', 0),
('1cdbb1b1c87529f75509a40d900de4cd', './installer/schema/20121210_add_missing_index_user_assigned_modules_tiki.sql', '24.9', 0),
('fddde4267df7ab11df0999f2114b76b0', './installer/schema/20121210_better_forum_reported_index_tiki.sql', '24.9', 0),
('bc625eb54d6688a8a3b41d6653319998', './installer/schema/20121213_module_zone_enlarge_tiki.php', '24.9', 0),
('566786e812240f906c36fd1d4acd9542', './installer/schema/20121213_module_zone_enlarge_tiki.sql', '24.9', 0),
('f400a5ecec07b112fec66e77b1d2f729', './installer/schema/20130220_wiki_attachments_tiki.sql', '24.9', 0),
('737e19c901e25ff8c54a4558fe018a29', './installer/schema/20130228_bigger_token_groups_tiki.sql', '24.9', 0),
('ee050d5b8a9eca59e6f125a45c283475', './installer/schema/20130301_sefurl_tracker_type_tiki.sql', '24.9', 0),
('9c51029b2a273121084d80026fb2f2c1', './installer/schema/20130314_keep_search_pref_settings_tiki.php', '24.9', 0),
('cad976420a3bc2e4a49506632af268e4', './installer/schema/20130322_app_menu_timesheet_pos_tiki.sql', '24.9', 0),
('44ec4903b1538e416525a6594899e66c', './installer/schema/20130322_restore_lost_filegals_tiki.sql', '24.9', 0),
('78828e075e63206219481fd1a96faca5', './installer/schema/20130328_extend_actionlog_bbb_tiki.sql', '24.9', 0),
('c0bbd7cffa2fa042409136edf232d1e7', './installer/schema/20130410_keep_wysiwyg_htmltowiki_setting_tiki.php', '24.9', 0),
('cdbb5695983c69df2c868cafdd3efe70', './installer/schema/20130415_repair_file_galleries_again_tiki.php', '24.9', 0),
('a6dc788402261b5ad7f8dc457a519d38', './installer/schema/20130417_score_alter_tiki.sql', '24.9', 0),
('1548a7f6c0f3e048a2d9cff98040430e', './installer/schema/20130417_score_tiki.sql', '24.9', 0),
('2ec218efe4d675718cb4874068bcb483', './installer/schema/20130419_newsletters_clippings_tiki.sql', '24.9', 0),
('6f3293fc844c503f37063e774166a60b', './installer/schema/20130513_convert_tracker_field_parameters_tiki.php', '24.9', 0),
('06c8be2f743dd4a2a13a7a0a364abbc3', './installer/schema/20130530_category_log_tiki.sql', '24.9', 0),
('ccfa5273eda1b232f21b778e00ddfc2a', './installer/schema/20130530_tracker_modification_log_tiki.sql', '24.9', 0),
('362b275807bed067759ba6fb1502cf15', './installer/schema/20130605_mailin_show_inline_tiki.sql', '24.9', 0),
('6f6945a8092cae1c0a663ea8a915770d', './installer/schema/20130606_mailin_add_categoryId_tiki.sql', '24.9', 0),
('7824253242a5c3641ac10844a1b8f905', './installer/schema/20130608_convert_mailin_pwd_tiki.php', '24.9', 0),
('810b71aa0c0166b64f8f27194511fb83', './installer/schema/20130608_mailin_response_tiki.sql', '24.9', 0),
('b5732bd4a0ea92ba019ca86d43a66d63', './installer/schema/20130611_mailin_add_html_tiki.sql', '24.9', 0),
('15de188ed2b8dbb2239e575b1150e0a3', './installer/schema/20130614_mailin_add_admin_tiki.sql', '24.9', 0),
('8c1977cb799881db7f7d87c4ec260f99', './installer/schema/20130616_mailin_add_namespace_tiki.sql', '24.9', 0),
('9fe8acbdaa6cd6804f8c7913d5d0945c', './installer/schema/20130623_create_mailin_user_struct_tiki.sql', '24.9', 0),
('2d3d0193bdd38bfe398eca12b4263a86', './installer/schema/20130624_mailin_add_attr_tiki.sql', '24.9', 0),
('22381e5220531fc9df24b9a92f1d3f9e', './installer/schema/20130704_catname_tiki.sql', '24.9', 0),
('3927bb8ba89cef57e6679b080295d62d', './installer/schema/20130705_activity_stream_tiki.sql', '24.9', 0),
('5cd63d71a596f99fde4c47176211bca1', './installer/schema/20130715_activity_stream_rules_tiki.sql', '24.9', 0),
('783a0cc74edeefda8775a7efb4d976ef', './installer/schema/20130730_friendship_conversion_tiki.sql', '24.9', 0),
('02e743ca71ad9e45f34cd8c044791e0d', './installer/schema/20130730_wiki_para_format_default_change_tiki.php', '24.9', 0),
('8a71c66336b573de4ef0a1d145e6b173', './installer/schema/20130807_tracker_files_display_param_change_tiki.php', '24.9', 0),
('c68ac92879d83f5c9afa595fa3b8aa41', './installer/schema/20130809_limit_name_lengths_in_objects_tiki.php', '24.9', 0),
('31334949f0ce1de52c3f6a93a28fe43c', './installer/schema/20131007_menus_items_missing_icons_tiki.sql', '24.9', 0),
('571ae86418cc31331bb0021296349765', './installer/schema/20131108_mytiki_add_mailin_tiki.sql', '24.9', 0),
('8dd51479dc56d5e1b8d57dad3f831c98', './installer/schema/20131117_unified_engine_default_change_tiki.php', '24.9', 0),
('5d1437bc3bd543091835de90e1991d8f', './installer/schema/20131218_stored_queries_tiki.sql', '24.9', 0),
('818b79ae45f7ed853c70c0ecb19e7c46', './installer/schema/20131231_add_sheet_metadata_tiki.sql', '24.9', 0),
('63588872c5d3fc25f97683f89785f855', './installer/schema/20140109_query_unique_name_tiki.sql', '24.9', 0),
('169d7254d23d4f5630582a21986eba0e', './installer/schema/20140117_monitor_tiki.sql', '24.9', 0),
('1e08c3fc2c93915f8b3a631a3d26044d', './installer/schema/20140129_bigger_target_monitor_tiki.sql', '24.9', 0),
('1c47a37146f38292f1d968bfef47ebb8', './installer/schema/20140203_menu_item_and_icon_user_wizard_tiki.sql', '24.9', 0),
('ce1c7d411fae4b462bed93d9ac6a5a95', './installer/schema/20140206_add_parser_column_tiki.sql', '24.9', 0),
('edde062c490700faca572aaabf77cb52', './installer/schema/20140210_user_wizard_add_section_name_tiki.sql', '24.9', 0),
('999c259f971e2fecb1149e74a86c1c43', './installer/schema/20140214_goals_tiki.sql', '24.9', 0),
('0442370003a89c03d1f7883226733f3d', './installer/schema/20140219_full_goal_events_tiki.sql', '24.9', 0),
('d6e3d03ba7405a447f4d3fd47f0ce4aa', './installer/schema/20140301_add_column_rating_choice_topic_on_forums_tiki.sql', '24.9', 0),
('8ab2629b201dc667190659d2fc0d3c02', './installer/schema/20140318_user_wizard_add_groupname_tiki.sql', '24.9', 0),
('57ecb42c72979352cd5ba68b3403aeec', './installer/schema/20140402_mailin_protocol_option_tiki.sql', '24.9', 0),
('9fcb77f139414164845c0f9117748905', './installer/schema/20140402_payment_authorization_tiki.sql', '24.9', 0),
('c8cbc000d5875cc0a92f7953db4797fe', './installer/schema/20140402_remove_mailin_smtp_tiki.sql', '24.9', 0),
('664417ce11b34798af188c68990f9782', './installer/schema/20140509_rss_add_categories_tiki.sql', '24.9', 0),
('dd9a3fc5e45cf923014c6798b659969b', './installer/schema/20140625_survey_tiki.sql', '24.9', 0),
('84f7d6c1af19614ed08e0b1d012e9de8', './installer/schema/20140705_page_slug_tiki.php', '24.9', 0),
('e8434febe415828ffc72641e5b2013b3', './installer/schema/20140705_page_slug_tiki.sql', '24.9', 0),
('de40a3d1b526871e6c400294b11ff1e8', './installer/schema/20140807_federated_search_tiki.sql', '24.9', 0),
('9a23ba7bb05b97075535e2538354146d', './installer/schema/20140812_convert_tiki_connect_data_to_json_tiki.php', '24.9', 0),
('e3072df61eae0c85a320d3c66983fbab', './installer/schema/20140914_addon_profiles_tiki.sql', '24.9', 0),
('8ee715acbdd66d1d8d58fa1eaca6e21a', './installer/schema/20141003_change_style_pref_to_theme_tiki.php', '24.9', 0),
('b570b04882abe860e483717f508a4424', './installer/schema/20141106_menu_configuration_panel_tiki.sql', '24.9', 0),
('722ef80e1f2641b33d0c51930cda0439', './installer/schema/20141114_remove_babelfish_tiki.sql', '24.9', 0),
('8b7024e62197537a0a65a596a7d12244', './installer/schema/20141120_tracker_tabular_tiki.sql', '24.9', 0),
('1c4726c7c1398af65801e1e79b66049f', './installer/schema/20141122_change_prefname_availblestyles_to_availablethemes_tiki.sql', '24.9', 0),
('109233b6947f5095378ea739f554ecde', './installer/schema/20141125_menu_control_panels_tiki.sql', '24.9', 0),
('810f09f5a3711abf92c3e4976f9807fd', './installer/schema/20150109_tabular_filters_tiki.sql', '24.9', 0),
('58c344c5452911759d101ad286b68d7d', './installer/schema/20150112_theme_option_etc_tiki.sql', '24.9', 0),
('1eee7b39a4687be425eeb55a590d8d22', './installer/schema/20150203_add_menu_option_class_tiki.sql', '24.9', 0),
('975871b45b1c2c9d8e493e3b3d0cdaaa', './installer/schema/20150310_rename_freetags_in_menu_42_tiki.sql', '24.9', 0),
('fb48dee14b960d1d7c48a08a85ef7fc8', './installer/schema/20150310_rename_mytiki_in_menu_42_tiki.sql', '24.9', 0),
('2d346e27c91070cc840b7dab52504a0f', './installer/schema/20150327_tracker_showPopup_option_fix_tiki.sql', '24.9', 0),
('8e032a195dac36d92fdbeaf0aecfd85e', './installer/schema/20150414_profile_symbol_tooshort_fix_tiki.sql', '24.9', 0),
('fc3c6bd5ed7353f96f36fa1fe9c318b1', './installer/schema/20150426_menu_item_external_wikis_restored_tiki.sql', '24.9', 0),
('11ad2e7bd83d983bd79fc483ac20af5f', './installer/schema/20150508_perspectives_style_to_theme_tiki.php', '24.9', 0),
('bd25949296c7ceaf65935eb8530c73c6', './installer/schema/20150730_menu_item_tabular_trackers_tiki.sql', '24.9', 0),
('ffb42720a6dd9ba8670b6bacaf35eb84', './installer/schema/20150901_prefname_char_length_tiki.sql', '24.9', 0),
('7fae5fdf9dcc1a2446e7d930bbc0fdfe', './installer/schema/20150929_make_hotwords_longer_tiki.sql', '24.9', 0),
('2afddf6d23449b961d9c97ec5125a3fc', './installer/schema/20151203_tiki_score_revamp_tiki.sql', '24.9', 0),
('0b0ac54a682f34d94dddc4505b328c7f', './installer/schema/20151203_tokens_create_user_tiki.sql', '24.9', 0),
('5468fa2c97256a0f7fb4c92251f7b880', './installer/schema/20160120_remove_gmap_menu_item_tiki.sql', '24.9', 0),
('381f850f916bceec588cda286a9361be', './installer/schema/20160201_remove_maps_menus_tiki.sql', '24.9', 0),
('6647ca98d6677dbfe4f2c096488e1c88', './installer/schema/20160206_theme_option_modules_tiki.sql', '24.9', 0),
('d767fe6ea302cb082eb0a2e91a024b23', './installer/schema/20160315_correct_blogpost_encoding_tiki.sql', '24.9', 0),
('ea2f7fb91e7fde0d126e2221f16cb7f0', './installer/schema/20160325_menu_42_list_pages_tiki.sql', '24.9', 0),
('8cc364ddb16d2f13d019c3eacd1ff66b', './installer/schema/20160420_correct_blogpost_encoding_tiki.sql', '24.9', 0),
('12fe008b7f0546d15f76f80aacf97e16', './installer/schema/20160519_calendar_events_action_log_tiki.sql', '24.9', 0),
('861d7ba1007a5553f7df989ff948be5c', './installer/schema/20160527_menu_item_payment_tiki.sql', '24.9', 0),
('1f48c41d9d443d035d1ad8b3036a62fd', './installer/schema/20160604_remove_unwanted_files_tiki.php', '24.9', 0),
('8cc8de59f71262e6a1f99d927b79aaba', './installer/schema/20160608_menu_item_admin_tokens_tiki.sql', '24.9', 0),
('c949f7ae51ac122ccff013162fcd8287', './installer/schema/20160612_new_password_implementation_tiki.sql', '24.9', 0),
('f83941959cbe9067a082cf26e1043c4f', './installer/schema/20160612_remove_feature_challenge_pref_tiki.sql', '24.9', 0),
('adc07b416a815a8f03874198fd656d13', './installer/schema/20160614_clear_password_removal_tiki.sql', '24.9', 0),
('749e752958825ad014a9b0e6f9923096', './installer/schema/20160627_remove_more_unwanted_files_tiki.php', '24.9', 0),
('e2d6675d1b2336734626c73d49f73f04', './installer/schema/20160817_fix_dymanic_list_field_values_tiki.php', '24.9', 0),
('ec6cd06bfbd06b43859ab14ab39eabc9', './installer/schema/20160914_extwiki_missing_columns_fix_tiki.php', '24.9', 0),
('e61bd3eb5e50b4ec85e95079d1ecca01', './installer/schema/20160915_extwiki_indexname_length_tiki.sql', '24.9', 0),
('845249c875f947ae1a89493db063efce', './installer/schema/20161109_remove_old_password_tiki.php', '24.9', 0),
('eee4743d39b2312e6ecff75c92a69d9a', './installer/schema/20161117_favicon_tiki.sql', '24.9', 0),
('c11ab00fb5536582645af47d2e8f365b', './installer/schema/20161206_larger_comment_field_tiki.sql', '24.9', 0),
('6de770c4a95205e0aa61e1d679283f09', './installer/schema/20161220_add_h5p_tables_tiki.sql', '24.9', 0),
('240ba47520a7acce828f0bf6cef8ab7c', './installer/schema/20170122_schedulers_tiki.sql', '24.9', 0),
('c493926b19c53d44e024647544f3d056', './installer/schema/20170127_remove_templates_c_tiki.php', '24.9', 0),
('fd2258f8a39b5169741c2099d4b03817', './installer/schema/20170129_feature_dump_tiki.sql', '24.9', 0),
('c8a60d8cdfb3565b69127ae54d04da0a', './installer/schema/20170207_iefix_rem_tiki.sql', '24.9', 0),
('f84913f95963a58e47c93c2739f283f3', './installer/schema/20170213_footnotearea_tiki.sql', '24.9', 0),
('7e9a23984ebda395c2d649295bdc338c', './installer/schema/20170218_schedulers_menu_tiki.sql', '24.9', 0),
('60263c47c43b093a7c136d13181ecd9c', './installer/schema/20170305_webservices_menu_tiki.sql', '24.9', 0),
('8edbc1084b547b63c6f78494fdf6be9f', './installer/schema/20170307_kill_wikilingo_tiki.sql', '24.9', 0),
('d94c2fd4462b9645a41586c87af072da', './installer/schema/20170319_kill_jcapture_tiki.sql', '24.9', 0),
('9ed43fbdc01e8c73bd2e7ee263f10b21', './installer/schema/20170322_fix_allocate_memory_prefs_tiki.sql', '24.9', 0),
('c00631e32fd03059c5eef945f7863763', './installer/schema/20170329_add_color_to_groups_tiki.sql', '24.9', 0),
('4438e6ee090276c2075c8bfc957e1491', './installer/schema/20170329_larger_category_descriptions_tiki.sql', '24.9', 0),
('23f4d598463814df65c646ac33611f49', './installer/schema/20170330_merge_hiddenlinks_into_headinglinks_tiki.sql', '24.9', 0),
('2fd39ce818ff806b5278a6dbf5140802', './installer/schema/20170427_update_accounting_journal_cols_tiki.sql', '24.9', 0),
('08e0d74ea36e315296ef16f3d29a4d63', './installer/schema/20170531_feature_usability_tiki.sql', '24.9', 0),
('6a10646d08ded550f49800b7b5014fed', './installer/schema/20170628_schedulers_menu_tiki.sql', '24.9', 0),
('c2ad5d06b08eb56c8d00873c6e617693', './installer/schema/20170702_wiki_url_scheme_pref_default_tiki.php', '24.9', 0),
('195e8fd6555d536c0698d6800e1fc40f', './installer/schema/20170717_add_missing_trackeritem_attachment_backlinks_tiki.php', '24.9', 0),
('f266609ceac80f0c53c24145a7c45a21', './installer/schema/20170726_remove_article_hashes_tiki.sql', '24.9', 0),
('7900f8cb0da7eefc44e333004c55f701', './installer/schema/20170726_tabular_config_tiki.sql', '24.9', 0),
('5c7fdeca3bec2b10dba0756b877839be', './installer/schema/20170829_custom_routes_tiki.sql', '24.9', 0),
('8bda31c0d04c361263cda1c39944199c', './installer/schema/20170920_admin_webservices_menu_option_tiki.sql', '24.9', 0),
('ad273fb8a3de46ecb514f2e7d94736e4', './installer/schema/20170925_add_general_to_language_tiki.sql', '24.9', 0),
('d14ab7413cc7dd0ab9511af079b707cf', './installer/schema/20170930_custom_routes_menu_tiki.sql', '24.9', 0),
('876555c041bae9e5e061c7adb8a6bd24', './installer/schema/20171002_queue_handler_size_increase_tiki.sql', '24.9', 0),
('064ba8756a4e1095a4dfd309eadef53c', './installer/schema/20171010_action_log_info_new_column_tiki.php', '24.9', 0),
('8a1525b0f940c1c14dc04a340cfbe8b9', './installer/schema/20171016_no_homepage_specificed_tiki.php', '24.9', 0),
('f0db6660cb57d0c42aa7e7e3bbda3a19', './installer/schema/20171121_create_plugin_include_relations_tiki.php', '24.9', 0),
('f4abc334a722098ff7aba542ed26c7ce', './installer/schema/20171122_h5p_update_add_hub_table_tiki.sql', '24.9', 0),
('ef930a840992362c04915add52147ddd', './installer/schema/20171123_create_object_links_tiki.php', '24.9', 0),
('d99b0b8efaed59d28bc42cd06c16a011', './installer/schema/20171129_backlinks_for_object_types_admin_options_tiki.sql', '24.9', 0),
('66cbeb1c9c5d27862ca5888ea0071aec', './installer/schema/20171130_plugin_include_link_original_tiki.sql', '24.9', 0),
('c622a5feed33323862aa6f2dc164f5da', './installer/schema/20171204_update_geo_enabled_tiki.sql', '24.9', 0),
('fdf500b3ad5aa5eb8c0cbe2666d36f5d', './installer/schema/20171231_add_short_url_tiki.sql', '24.9', 0),
('75ab724a0ed998cf5c03f8c20b6ba543', './installer/schema/20180228_comment_on_object_attributes_tiki.sql', '24.9', 0),
('45b5c210f7fefa7873401d3cb6024ff6', './installer/schema/20180331_rename_custom_route_object_type_tiki.sql', '24.9', 0),
('03b5cd52cdbfc264e8432645d2e3d51d', './installer/schema/20180405_custom_routes_menu_tiki.sql', '24.9', 0),
('0a5cb5a13d80bf5690eb982dc5904cac', './installer/schema/20180405_remove_unused_user_id_tiki.sql', '24.9', 0),
('11c8fd68fe4171f5783cb57b0c1e577c', './installer/schema/20180410_install_piwik_plugin_tiki.php', '24.9', 0),
('6ba406554a14d2fddad4c069f0dc2ed2', './installer/schema/20180411_schedulers_change_column_to_text_tiki.sql', '24.9', 0),
('52e9f72e43040b23b489ea44c43ee32e', './installer/schema/20180412_rename_short_url_prefs_tiki.sql', '24.9', 0),
('733dc3217ef761090477e9413426cb79', './installer/schema/20180419_scheduler_run_stalled_column_tiki.sql', '24.9', 0),
('cd428c5756b4f05ea6b764f0cf1a28c9', './installer/schema/20180421_scheduler_run_healed_column_tiki.sql', '24.9', 0),
('eed54e26fdc4867a1c59784aaa835f73', './installer/schema/20180503_fix_throttled_newsletters_tiki.sql', '24.9', 0),
('526019e79ad1a4415c61928c042d4c0d', './installer/schema/20180609_change_log_column_type_tiki.sql', '24.9', 0),
('751120c011c1c4de4f1578b271e6d4b9', './installer/schema/20180625_user_reports_null_last_reports_tiki.sql', '24.9', 0),
('bc86aa555cffced621d949868afdf7b2', './installer/schema/20180705_fix_calendaritem_tracker_attributes_tiki.sql', '24.9', 0),
('31991df8d0082922a07ed84d2776e862', './installer/schema/20180706_remove_menu_reports_tiki.sql', '24.9', 0),
('812e2e73e30215f18b64b95bd03763a2', './installer/schema/20180803_semaphore_value_tiki.sql', '24.9', 0),
('4f18a0947aea64a264a0d591bb25c871', './installer/schema/20180808_ocr_tiki.sql', '24.9', 0),
('248fb02673aed57936068d21e55ca3d0', './installer/schema/20180815_merge_topic_read_perm_tiki.sql', '24.9', 0),
('3c2bad543cb7a0a240d301977a65b7ea', './installer/schema/20180909_remove_page_content_fetch_readability_tiki.sql', '24.9', 0),
('04f3233604e34ed46c3a0596baf160d6', './installer/schema/20180918_remove_poweredby_module_tiki.sql', '24.9', 0),
('c1f8edb151bcf184545f041bd484a289', './installer/schema/20180921_php_upgrade_fix_from_older_tiki.php', '24.9', 0),
('f1551ef9c16100c9bac8d29ee8d10e5a', './installer/schema/20180921_sql_upgrade_fix_from_older_tiki.php', '24.9', 0),
('f745cb9b359b4baf9533aa98b4f546b0', './installer/schema/20180923_convert_collation_to_utf8mb4_tiki.php', '24.9', 0),
('123b3757cecfd31695b395ce36a11dc8', './installer/schema/20180925_feature_jquery_superfish_pref_default_tiki.php', '24.9', 0),
('29317c82da0d406663cba29d46a5d041', './installer/schema/20181114_ocr_uff8mb4_tiki.sql', '24.9', 0),
('9aa733e9be031699b2b16b8ffe822731', './installer/schema/20181127_convert_db_local_to_utf8mb4_tiki.php', '24.9', 0),
('9d9161bd99ebf5430f3f1e4278117e0e', './installer/schema/20181130_update_column_name_size_tracker_table_tiki.sql', '24.9', 0),
('2531e2b1a80dc003cfd1a2d94cd64d9e', './installer/schema/20190117_create_oauthserver_clients_table_tiki.sql', '24.9', 0),
('67b1a038054ed146c2766265d99e0646', './installer/schema/20190121_h5p_add_new_library_fields_tiki.sql', '24.9', 0),
('7104ef096f1b22dde38c0c4f2f48f956', './installer/schema/20190121_h5p_allow_null_in_filtered_tiki.sql', '24.9', 0),
('180b8e7476c874d37345ce6ea0f14ac3', './installer/schema/20190123_h5p_move_storage_assets_to_new_dir_tiki.php', '24.9', 0),
('e609b65ff2bddcb4372f46f4763e5c4b', './installer/schema/20190129_fix_ambiguity_on_oauthserver_id_column_tiki.php', '24.9', 0),
('068ca01a57fba854eba3ad536530310e', './installer/schema/20190226_change_xmpp_auth_pref_name_tiki.sql', '24.9', 0),
('b2d09fb8cf6362a66e4e7ff0c0434f38', './installer/schema/20190303_make_tiki_object_href_larger_tiki.sql', '24.9', 0),
('6e0be312d346770a1f4005b8e234b9d7', './installer/schema/20190401_add_support_database_strict_mode_tiki.sql', '24.9', 0),
('1c10cd737040087392e064baddbf25f1', './installer/schema/20190425_add_creation_date_schedule_tiki.sql', '24.9', 0),
('f02c100cfcbb4211c21cfda261a68998', './installer/schema/20190425_set_creation_date_to_scheduler_tiki.php', '24.9', 0),
('03c9df13dac5497ad01f1f440eef46a2', './installer/schema/20190523_migrate_webmail_accounts_tiki.php', '24.9', 0),
('e4ac9a8109622ea18809c642ad6d26a4', './installer/schema/20190526_remove_tiki_addon_profiles_tiki.sql', '24.9', 0),
('5f29fd9203816d46e921ab28826f4f16', './installer/schema/20190620_add_role_groups_tiki.sql', '24.9', 0),
('871e967e4e8268ec69b096f78b4e1dbd', './installer/schema/20190627_add_ocr_fgal_status_tiki.sql', '24.9', 0),
('eb215c708c3a33bb7ffcdccb6a88846d', './installer/schema/20190717_add_role_categ_available_tiki.sql', '24.9', 0),
('21fadc155ab35853f7affe28b2422af7', './installer/schema/20190722_ocr_fgal_tiki.sql', '24.9', 0),
('dfe176e17549e7ae7bd54ac28ba5f0ac', './installer/schema/20190723_add_is_tlp_group_tiki.sql', '24.9', 0),
('b197a50f75f1d7fa998caecc6725b790', './installer/schema/20190729_add_tlp_group_category_tiki.sql', '24.9', 0),
('35808972cf4a216c0e90f482254e8181', './installer/schema/20190831_add_two_factor_secret_tiki.sql', '24.9', 0),
('de8db997d574a7afe9a8a54ca76c0c04', './installer/schema/20190913_caldav_tiki.sql', '24.9', 0),
('6c411e8725a9b696bb7db7a9a730b53d', './installer/schema/20190925_caldav_updates_tiki.sql', '24.9', 0),
('b5a5fb647b0291834f8bf0c4925ad7db', './installer/schema/20191114_caldav_recurring_updates_tiki.sql', '24.9', 0),
('1a16b25a33696e1b9dcc4121f7611ea0', './installer/schema/20191116_scheduler_run_only_once_tiki.sql', '24.9', 0),
('2b041737a62a9abc30ee7065db8c8f54', './installer/schema/20191126_add_forum_parent_tiki.sql', '24.9', 0),
('a62a38886e82131fb641d09d773bd1d6', './installer/schema/20191218_carddav_tiki.sql', '24.9', 0),
('c61977bd122475c05d7118b53143fab1', './installer/schema/20200113_tracker_field_rules_column_tiki.sql', '24.9', 0),
('4399d43e24d437313364a3cfb23f7016', './installer/schema/20200123_calendar_rsvp_tiki.sql', '24.9', 0),
('fc8fd4b751dac80a6a02ba1a227b8b85', './installer/schema/20200126_remove_invoice_menu_options_tiki.sql', '24.9', 0),
('a87d4519131d319c755d730a92f28c26', './installer/schema/20200205_mailin_add_galleryid_tiki.sql', '24.9', 0),
('2466c179999ae3cb1e528fdaf314c48e', './installer/schema/20200218_mailin_add_trackerid_tiki.sql', '24.9', 0),
('77a9f98f0a05175dec423866c5ea8a45', './installer/schema/20200309_fix_sefurl_regex_out_issues_tiki.sql', '24.9', 0),
('5b755f2d3042c68d7819ae1476ac0eb6', './installer/schema/20200311_add_forum_order_tiki.sql', '24.9', 0),
('79235d26670fd6216d745318aa090320', './installer/schema/20200513_expand_sessions_data_column_tiki.sql', '24.9', 0),
('1b7524ba6ec1829d8a0d9554ecf8989f', './installer/schema/20200601_carddav_contact_uri_tiki.sql', '24.9', 0),
('f646ed7b9623faeab1dd7dfb98e32f7e', './installer/schema/20200613_scheduler_run_now_tiki.sql', '24.9', 0),
('e9454bb8f0bd53b05d127004bc996fb5', './installer/schema/20200614_expand_mail_queue_message_column_tiki.sql', '24.9', 0),
('251a93a22f5155d1e7c6c03384ac6619', './installer/schema/20200701_rename_pref_unified_lucene_default_operator_tiki.sql', '24.9', 0),
('17ab28e640b79f72104414308615bc15', './installer/schema/20200710_feature_templated_groups_tiki.php', '24.9', 0),
('791001a3baa8529ab3802e064d9e6e93', './installer/schema/20200820_performance_table_creation_tiki.sql', '24.9', 0),
('8ab40e1a97d6aa8ea74a9230f4ca8b95', './installer/schema/20200903_create_encryption_keys_tiki.sql', '24.9', 0),
('4b432360cb51437743dc98a52483f511', './installer/schema/20200903_create_machine_learning_models_tiki.sql', '24.9', 0),
('55b5f11d9bcdbcc5d84d4bb1d9602fb8', './installer/schema/20200910_add_encryption_key_to_tracker_fields_tiki.sql', '24.9', 0),
('af0797da7e33016d1d2b7dd4e70d0ae7', './installer/schema/20200928_add_machine_learning_menu_options_tiki.sql', '24.9', 0),
('6378e0b162580584a084a5287e5d1f20', './installer/schema/20201024_h5p_add_a11y_title_tiki.sql', '24.9', 0),
('783f6534bf5f806b4d963bb5634970a0', './installer/schema/20201024_h5p_add_default_lang_tiki.sql', '24.9', 0),
('fdac7050a5bd41e3496348f0d2f93a1b', './installer/schema/20201118_add_odbc_tabulars_tiki.sql', '24.9', 0),
('aeb851095f17c5a570ebd944c5a716a0', './installer/schema/20201212_remove_comment_hash_tiki.sql', '24.9', 0),
('089a2d35c7dcb1d1ad9070de342bc330', './installer/schema/20210115_add_trackerfields_sefurl_tiki.sql', '24.9', 0),
('eae62776c3098fd2c5cdcf59bf6fcfca', './installer/schema/20210316_preference_replace_chosen_with_select2_tiki.sql', '24.9', 0),
('fea269d780e2f2cd1e8791124d12c1fb', './installer/schema/20210410_alter_activity_stream_arguments_column_tiki.sql', '24.9', 0),
('84b079f34590105bac893b8021b05850', './installer/schema/20210421_add_ml_label_field_tiki.sql', '24.9', 0),
('60db428f497aaf288bf219ee1a1baade', './installer/schema/20210428_mailin_add_preferences_tiki.sql', '24.9', 0),
('c8c930f8bd7b9a846e5cbebf57c31747', './installer/schema/20210605_image_gallery_removal_tiki.sql', '24.9', 0),
('5f66c504fb5e27ccc299c625e66eafc4', './installer/schema/20210608_timesheet_menu_removal_tiki.sql', '24.9', 0),
('fa2a4071b5dfd438eb28728a6ec16caa', './installer/schema/20210819_theme_unified_admin_backend_pref_default_tiki.php', '24.9', 0),
('908853b4e4c7483c14bf0c4d799c017b', './installer/schema/20211004_calendar_weekly_multiple_tiki.php', '24.9', 0),
('5b86202389bc870cc9ccd3d3319fff85', './installer/schema/20211020_mark_image_gallery_tables_as_unused_tiki.sql', '24.9', 0),
('1af7f4f1400cdb676bd514d4788388a9', './installer/schema/20211110_create_api_tokens_tiki.sql', '24.9', 0),
('c155b78f239d8c9fc706f2af8a1de30d', './installer/schema/20211126_timezone_date_update_tiki.php', '24.9', 0),
('5e26fec0700583811cca79a4faaacd20', './installer/schema/20220111_backlinks_tiki.sql', '24.9', 0),
('3c6f27723656fb2269040acddb4a94e6', './installer/schema/20220112_extend_api_tokens_tiki.sql', '24.9', 0),
('aaf985cc80c824de0c14833bfaefd637', './installer/schema/20220112_extend_oauthserver_clients_tiki.sql', '24.9', 0),
('bb97d6c270532f3e41fbdf3ece5fbcef', './installer/schema/20220113_password_blacklist_tiki.sql', '24.9', 0),
('7b570cd593e1c41deb789801509c05e4', './installer/schema/20220119_make_user_nullable_api_tokens_tiki.sql', '24.9', 0),
('fe46b7b59516f93a077086bfd021a835', './installer/schema/20220601_discard_hash_column_from_articles_tiki.php', '24.9', 0),
('5fa6306d3cf277ff22b4d5b367ed4d8c', './installer/schema/20221020_add_direct_to_file_galleries_tiki.sql', '24.9', 0),
('207de3adddcd96b996a458b1a896a611', './installer/schema/20221024_add_indexes_to_file_galleries_tiki.sql', '24.9', 0),
('9171cd608f0f42671f4a556fd02ab228', './installer/schema/20221026_add_fgal_sync_to_action_log_tiki.sql', '24.9', 0),
('b4501371dc8739296dfe67f40c29cac3', './installer/schema/20221110_add_actionforuser_index_on_actionlog_tiki.sql', '24.9', 0),
('b02d4d49753578250ca5281ef7da768e', './installer/schema/20221128_force_refresh_of_mapping_for_forum_section_tiki.sql', '24.9', 0),
('9f8eeac6b7856a87a1240743a5c7c453', './installer/schema/20230125_add_goalid_to_credits_tiki.sql', '24.9', 0),
('033babdf1b3bb8c93a27e5d0d768f8d0', './installer/schema/20230504_add_attemps_on_tiki_banning_tiki.sql', '24.9', 0),
('b7571048e28fc6e14636b45bcab8798e', './installer/schema/20230520_add_blog_allow_post_categorization_tiki.sql', '24.9', 0),
('6c95480073f8968a796e6bb855ebb336', './installer/schema/20230807_sefurl_fix_error_of_wrong_url_for_column_stats_tiki.sql', '24.9', 0),
('7089f97d0f4f552ed2acbf0bc8536183', './installer/schema/20230828_add_restriction_tiki_surveys_tiki.sql', '24.9', 0),
('17cd305aefa590fa2dd9146fae2da488', './installer/schema/20231119_extend_actionlog_conf_crsf_error_tiki.sql', '24.9', 0),
('00751f57765e4dd387208f2112f05f99', './installer/schema/20240419_tabular_itemlink_lookup_simple_rename_tiki.php', '24.9', 0),
('b52a9b50184778c8e1a938bf678d3b1a', './installer/schema/999999991_decode_pages_sources_tiki.php', '24.9', 0),
('0638fa0d005789c0eea805e25a511bb9', './installer/schema/99999999_image_plugins_kill_tiki.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './installer/schema/index.php', '24.9', 0),
('31d883076b5c1b9596385d4f326fcda3', './installer/schema/optional_20170801_initialize_article_nbreads_tiki.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './installer/script/index.php', '24.9', 0),
('521642afba302ac50426d3d8deae74f6', './installer/shell.php', '24.9', 0),
('a2ae23387f1e54842110a8c5015ad653', './installer/tiki-installer.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ar/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/ar/language.js', '24.9', 0),
('689fbbc6f96c3d09f1205a7023d3e46e', './lang/ar/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/bg/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/bg/language.js', '24.9', 0),
('31ef6a9750fc64f4e72acae2b6a81efd', './lang/bg/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ca/index.php', '24.9', 0),
('bc90a89fd55b6f6b50ca573e63d69c1f', './lang/ca/language.js', '24.9', 0),
('ebff6b8ed750fd1e1df073cb00869856', './lang/ca/language.php', '24.9', 0),
('08c9ec153309e126ac57161e7783efda', './lang/ca/language_r.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/cn/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/cn/language.js', '24.9', 0),
('562ed548cc709901516a5c81535fa29a', './lang/cn/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/cs/index.php', '24.9', 0),
('4023c73656c3f5044e96aa5b72734056', './lang/cs/language.js', '24.9', 0),
('92cbb1ea9fbefcdaa8238f80a3d25cbd', './lang/cs/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/cy/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/cy/language.js', '24.9', 0),
('8b3605bd2ac4bf6ade0fb048998add6e', './lang/cy/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/da/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/da/language.js', '24.9', 0),
('e65666548aae5e47093c6ed73959cfa4', './lang/da/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/de/index.php', '24.9', 0),
('fc3b85ab89dfdccbfd7e68e5feb367d9', './lang/de/language.js', '24.9', 0),
('bd99ec20a9ebfaae14b0d58ac6478781', './lang/de/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/el/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/el/language.js', '24.9', 0),
('3fabb7577d41f94818e33e23bbb25419', './lang/el/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/en-uk/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/en-uk/language.js', '24.9', 0),
('cf5b8bfa789321c77b7fff8e96ed16d9', './lang/en-uk/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/en/index.php', '24.9', 0),
('1b02d72fc173b42382ae38b86e810574', './lang/en/language.js', '24.9', 0),
('1bd85d5441557bcc0fb9d2d62a95a429', './lang/en/language.php', '24.9', 0),
('08c9ec153309e126ac57161e7783efda', './lang/en/language_r.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/es/index.php', '24.9', 0),
('6fee9bf4415c8f7375728d206d2fc073', './lang/es/language.js', '24.9', 0),
('78b14e0f3a574a02ddf45bdd6dc5b376', './lang/es/language.php', '24.9', 0),
('dd13812535181c5bc6d2a9d54631e8f3', './lang/es/language_r.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/fa/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/fa/language.js', '24.9', 0),
('53d207fbed821bbdda618b1ca5f15db7', './lang/fa/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/fi/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/fi/language.js', '24.9', 0),
('210d5303f4c5252eb9f35c28d14ee2bc', './lang/fi/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/fj/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/fj/language.js', '24.9', 0),
('351919cef75ae9786fa516d547ed94ea', './lang/fj/language.php', '24.9', 0),
('8b44f3fbd80e613db827cb16d05eb61e', './lang/flagmapping.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/fr/index.php', '24.9', 0),
('eb60992bc94de638a73a8125bfef74d9', './lang/fr/language.js', '24.9', 0),
('a3d353bcc075895b44dd7f24b081c294', './lang/fr/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/fy-NL/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/fy-NL/language.js', '24.9', 0),
('180eb26afc5b3c6b94374cb1b39f5ab1', './lang/fy-NL/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/gl/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/gl/language.js', '24.9', 0),
('02df65e95cc1e097ddcc73c2a93e50f3', './lang/gl/language.php', '24.9', 0),
('96803928f09fba7677459eda483512c3', './lang/he/custom.php_example.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/he/index.php', '24.9', 0),
('a8872d89c9e8c32dcd00d54d79c36577', './lang/he/language.js', '24.9', 0),
('2e6c0306b87d3fb4d9d755e7e99544e0', './lang/he/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/hr/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/hr/language.js', '24.9', 0),
('733ef6abfcc6e42604b17bd50dd63ada', './lang/hr/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/hu/index.php', '24.9', 0),
('92da7801fd3b7f581d3794a64e55c1c1', './lang/hu/language.js', '24.9', 0),
('40ae9d394fc9c1340f1093cac63c8571', './lang/hu/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/id/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/id/language.js', '24.9', 0),
('a326be835a92b38c9454a39a5974d832', './lang/id/language.php', '24.9', 0),
('d6fb05a8ea80d246798e377239752a65', './lang/index.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/is/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/is/language.js', '24.9', 0),
('9ffe71b531fdec0b7711603465bfb99f', './lang/is/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/it/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/it/language.js', '24.9', 0),
('7a2518a8b3a257d2087f38abcd045326', './lang/it/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/iu-iq/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/iu-iq/language.js', '24.9', 0),
('938ab7bf8d63ac25f329266dd4a9db3e', './lang/iu-iq/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/iu-ro/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/iu-ro/language.js', '24.9', 0),
('938ab7bf8d63ac25f329266dd4a9db3e', './lang/iu-ro/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/iu/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/iu/language.js', '24.9', 0),
('5e3744228680de6b660c1367665d0150', './lang/iu/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ja/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/ja/language.js', '24.9', 0),
('33fe18b2985e99fc114f5f87bdcaa36b', './lang/ja/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ko/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/ko/language.js', '24.9', 0),
('b5c227e7c5b0cda0fc1499d9a87c77c4', './lang/ko/language.php', '24.9', 0),
('8f8d9ee8de39a4299f0e42b979c0157f', './lang/langmapping.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/lt/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/lt/language.js', '24.9', 0),
('ba0df405a6a6d49c9258e29d9b83113f', './lang/lt/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/nds/index.php', '24.9', 0),
('fd90ed217f142c2d4178a4493d822338', './lang/nds/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/nl/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/nl/language.js', '24.9', 0),
('100b0d1776b8ec84b3624bf4264e34f5', './lang/nl/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/no/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/no/language.js', '24.9', 0),
('55e6a4e327978f3bb4bbce1fd8fe9d99', './lang/no/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/pl/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/pl/language.js', '24.9', 0),
('e3317aaa6ec550831162e46e27095544', './lang/pl/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/pt-br/index.php', '24.9', 0),
('3c9fd2e0d42cfe25dd7dcdc47638418a', './lang/pt-br/language.js', '24.9', 0),
('e75ada69dea9abea1dfd5d2ed584edc9', './lang/pt-br/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/pt/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/pt/language.js', '24.9', 0),
('ca37d4f79fa0289be01bb5758ab75c25', './lang/pt/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/rm/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/rm/language.js', '24.9', 0),
('e5648286a212937e72318d941f2e5050', './lang/rm/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ro/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/ro/language.js', '24.9', 0),
('3ce830a3c28895451856a9f10c8574cf', './lang/ro/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ru/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/ru/language.js', '24.9', 0),
('ae4847fd2ee440e61a87af90aae85407', './lang/ru/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sb/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sb/language.js', '24.9', 0),
('fe7f365d122d9916606472df35fff4d6', './lang/sb/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/si/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/si/language.js', '24.9', 0),
('a4ceafd25e3702dca9e1cc556773e01c', './lang/si/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sk/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sk/language.js', '24.9', 0),
('48c2243b01f4e81fd60f3e6e0aca74c0', './lang/sk/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sl/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sl/language.js', '24.9', 0),
('4460924c0d56e129d02916b3e01e7ab2', './lang/sl/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sq/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sq/language.js', '24.9', 0),
('f4b8431ac9f241b1af7e14d431851a95', './lang/sq/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sr-latn/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sr-latn/language.js', '24.9', 0),
('f232ae98c7942046904fdd9fe2db39bb', './lang/sr-latn/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sv/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sv/language.js', '24.9', 0),
('d0a50f58f56e309ae1ee01421ced8ae9', './lang/sv/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/sw/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/sw/language.js', '24.9', 0),
('4076fc1fd2d43c8cbe545e90c5427767', './lang/sw/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/th/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/th/language.js', '24.9', 0),
('27fb99d62056070f8f7062196181ff16', './lang/th/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/tr/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/tr/language.js', '24.9', 0),
('571ee8a63f7197279986020d8ddfdc4b', './lang/tr/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/tv/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/tv/language.js', '24.9', 0),
('ee39ca861040a31d9424029a5474e8c9', './lang/tv/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/tw/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/tw/language.js', '24.9', 0),
('65904e1900192d1b950d2bde653c92b7', './lang/tw/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/uk/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/uk/language.js', '24.9', 0),
('0759a3c70a2b0c1e44b08a7df1953864', './lang/uk/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/ur/index.php', '24.9', 0),
('9400901359fd5193be6c10436996ca03', './lang/ur/language.js', '24.9', 0),
('914edd8b0ffe9a4c3c6b29e2a67adf88', './lang/ur/language.php', '24.9', 0),
('b2ebc1c2ff6d22ab024739949018b01b', './lang/vi/index.php', '24.9', 0),
('7baa3fac80a0a503db731d0515719b82', './lang/vi/language.js', '24.9', 0),
('f79c71a45eb7dc59cdb8a3c529389dc4', './lang/vi/language.php', '24.9', 0),
('b35051021d5bb6aab9e66e979c59524e', './lib/Alchemy/AlchemyLib.php', '24.9', 0),
('7db6a793a18ce0f8e0a797ff532b9def', './lib/Alchemy/Guesser.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/Alchemy/index.php', '24.9', 0),
('5a0806aeaa587db3cc349f148b2e6fb4', './lib/FitVidJs/FitVidJs.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/FitVidJs/index.php', '24.9', 0),
('e93df790c878bf9119b6d28f1f747d05', './lib/Image/Gd.php', '24.9', 0),
('31e24119761ad46d5162cb8c3d74a076', './lib/Image/Image.php', '24.9', 0),
('3e4fe89814e56fa718de6b9452e5c36f', './lib/Image/ImageAbstract.php', '24.9', 0),
('91809c92bd4e301533898c00e637c752', './lib/Image/ImagickNew.php', '24.9', 0),
('812ba59d8c3540359511a28e32b98e7f', './lib/Image/ImagickOld.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('ea2c8b474bdcd09d54d0220d78c5e73a', './lib/Image/img_plugin_default_and_mandatory.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/Image/index.php', '24.9', 0),
('e30692d010604db23caadd74634184ba', './lib/Logs/LogsLib.php', '24.9', 0),
('91ddb552b6152293fc75865e90705d6e', './lib/Logs/LogsQueryLib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/Logs/index.php', '24.9', 0),
('bca20bef01dc0aa8a6d411b82cf76060', './lib/OpenIdConnect/OpenIdConnectLib.php', '24.9', 0),
('ab8ab656e659578964cf025fe57a2c5a', './lib/OpenIdConnect/RSA256Signer.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/OpenIdConnect/index.php', '24.9', 0),
('33ede58a9416dc5fb5d9b0e9c9dbd5a8', './lib/Unoconv/UnoconvLib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/Unoconv/index.php', '24.9', 0),
('6cc173035feaafe059739f5ec97258cd', './lib/accounting/accountinglib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/accounting/index.php', '24.9', 0),
('3b54c9071048ed880f5d231990064c76', './lib/activity/activitylib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/activity/index.php', '24.9', 0),
('513861e2bf1b75956451bb68030f59b6', './lib/admin/adminlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/admin/index.php', '24.9', 0),
('d54bfc5f2f599a960d6bbbde69ea232f', './lib/ajax/autosave.js', '24.9', 0),
('36e1d5e233c8fa2a3f33c57890d90b82', './lib/ajax/autosave.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/ajax/index.php', '24.9', 0),
('dff8a9c39f260bbeca19167084151c1f', './lib/articles/artlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/articles/index.php', '24.9', 0),
('32f32c6adca6ba81f932bbcc22f7a310', './lib/attributes/attributelib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/attributes/index.php', '24.9', 0),
('1c40fb22821fa22e05a9ed4effd9276c', './lib/attributes/relationlib.php', '24.9', 0),
('fc371e37c35bdbfa6531cc2ceb033bec', './lib/auth/PasswordHash.php', '24.9', 0),
('b737c3ee78d3bb78e7acd1b82408d1b6', './lib/auth/api_token.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/auth/index.php', '24.9', 0),
('328b8426db1fa872139c9d54cf9384ed', './lib/auth/ldap.php', '24.9', 0),
('704ac1dc1090679d7970bf9fb54ffbe6', './lib/auth/phpbb.php', '24.9', 0),
('601d57a7ae7597b894fb84290539253f', './lib/auth/tokens.php', '24.9', 0),
('48c80119e8ffc7ab88761444151f7d37', './lib/avatarlib.php', '24.9', 0),
('81b8992e135c3b245402bf667252c580', './lib/ban/banlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/ban/index.php', '24.9', 0),
('14f77a81fc88dadbe5b598465668d2e5', './lib/banners/bannerlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/banners/index.php', '24.9', 0),
('3900e074eac727fe4e777ecdf86cc312', './lib/bigbluebuttonlib.php', '24.9', 0),
('4488aa8dc2a02b7d9a9c5e4986462398', './lib/blogs/bloglib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/blogs/index.php', '24.9', 0),
('81c9d4e14b9bdbd74efc72c406d867cd', './lib/bookmarks/bookmarklib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/bookmarks/index.php', '24.9', 0),
('1d8843a8216a53f4ec4b877ffdb515f3', './lib/breadcrumblib.php', '24.9', 0),
('2b3df2f18be90b189c31b1955b3b61be', './lib/cache/cachelib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/cache/index.php', '24.9', 0),
('ff39c0941cc54bc24e3840b3b6a22a49', './lib/cache/memcachelib.php', '24.9', 0),
('c971c71538cb868f678fbb42d176b758', './lib/cache/redislib.php', '24.9', 0),
('1e5716b487b9c1e69b9cd02c2baa39ec', './lib/calendar/calendarlib.php', '24.9', 0),
('07c90735e54089a22876b7ad2896118a', './lib/calendar/calrecurrence.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/calendar/index.php', '24.9', 0),
('f50b24b50b5932dbec68684361aa24fd', './lib/calendar/tikicalendarlib.php', '24.9', 0),
('f99ba45a262381a1c6ceda7552033276', './lib/captcha/Captcha_Questions.php', '24.9', 0),
('9954aca6b44dc60a8df7c64ddea9ea12', './lib/captcha/Captcha_ReCaptcha20.php', '24.9', 0),
('efb9135717693f63c05d4dfba2795761', './lib/captcha/Captcha_ReCaptcha30.php', '24.9', 0),
('344ef2dcc03f355a9b153ccd950cd73e', './lib/captcha/captchalib.js', '24.9', 0),
('dcb7240a6629ea6129fdb4fc19f94ac2', './lib/captcha/captchalib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/captcha/index.php', '24.9', 0),
('65ea6f000dd96e69bafc0dadf185fe48', './lib/categories/categlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/categories/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/ckeditor_tiki/index.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/index.php', '24.9', 0),
('0d1729e5f1d1723737c9f37c4e9807dc', './lib/ckeditor_tiki/plugins/_tikilink/dialogs/tikilink.js', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/ckeditor_tiki/plugins/_tikilink/index.php', '24.9', 0),
('d1a7c135d38c33a388fccd00d8d50970', './lib/ckeditor_tiki/plugins/_tikilink/plugin.js', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/ckeditor_tiki/plugins/autosave/index.php', '24.9', 0),
('a1017a48361355688837afa4d13636f1', './lib/ckeditor_tiki/plugins/autosave/plugin.js', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/ckeditor_tiki/plugins/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/ckeditor_tiki/plugins/inlinecancel/index.php', '24.9', 0),
('08f6bea26344cedf1b4e1e86482ffce4', './lib/ckeditor_tiki/plugins/inlinecancel/plugin.js', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/ckeditor_tiki/plugins/inlinesave/index.php', '24.9', 0),
('d642302b9468b999685dea48536bdca2', './lib/ckeditor_tiki/plugins/inlinesave/plugin.js', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/ckeditor_tiki/plugins/tikiplugin/index.php', '24.9', 0),
('d70b578a3060ad26640d6040c40d177a', './lib/ckeditor_tiki/plugins/tikiplugin/plugin.js', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/ckeditor_tiki/plugins/tikiwiki/index.php', '24.9', 0),
('853a3078d10e3aec558e243a1b10d5ba', './lib/ckeditor_tiki/plugins/tikiwiki/plugin.js', '24.9', 0),
('a9c2a8a02eff4721ae58f3bb4b73183e', './lib/ckeditor_tiki/tiki-ckeditor.js', '24.9', 0),
('8899aff4c58b5ff5b2a89a125bacaf14', './lib/ckeditor_tiki/tikilink_dialog.js', '24.9', 0),
('7827f6d5813b68db4be6215791140894', './lib/ckeditor_tiki/tikistyles.js', '24.9', 0),
('9b059e4d077657b3a801a3fa8f0e3a85', './lib/ckeditor_tiki/tikitemplates.js', '24.9', 0),
('6d2b31a2b32a188aea5a62d052ca3851', './lib/ckeditor_tiki/wysiwyglib.php', '24.9', 0),
('f593983bf5207fad8d128633b67cbd49', './lib/codemirror_tiki/codemirror_tiki.js', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/codemirror_tiki/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/codemirror_tiki/mode/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/codemirror_tiki/mode/tiki/index.php', '24.9', 0),
('35b30abe24a0ebe2ba012fca51874b38', './lib/codemirror_tiki/mode/tiki/tiki.js', '24.9', 0),
('d2963128f37cca07bbba2c7084052b90', './lib/codemirror_tiki/tiki_codemirror.php', '24.9', 0),
('2d9ba9d6ed40a106e9e4f059162dcbf0', './lib/commcenter/commlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/commcenter/index.php', '24.9', 0),
('0aad74cc23ee48372f3f59dbd78da5fb', './lib/comments/commentslib.js', '24.9', 0),
('45d5e1742a5e1d466534d0734b42a393', './lib/comments/commentslib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/comments/index.php', '24.9', 0),
('c2bc78c51f646860a485877ea5c8b4d0', './lib/contribution/contributionlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/contribution/index.php', '24.9', 0),
('00bf12ccf96e45a132ede23d4870fb3e', './lib/copyrights/copyrightslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/copyrights/index.php', '24.9', 0),
('c856298bf676e80074c224ea7fdad5ca', './lib/core/BOMChecker/Scanner.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/BOMChecker/index.php', '24.9', 0),
('cb73f3f89b699e79b2084437fa31608c', './lib/core/Category/Manipulator.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Category/index.php', '24.9', 0),
('cf133333825f6e6c99ab7bf488188370', './lib/core/CustomRoute/Controller.php', '24.9', 0),
('89431db4b7206b710e9a92d8136f97d4', './lib/core/CustomRoute/CustomRoute.php', '24.9', 0),
('6a6e6564427acfe5b5199bc6ae43fed4', './lib/core/CustomRoute/CustomRouteLib.php', '24.9', 0),
('15ccb317a398729045c46c147aebd372', './lib/core/CustomRoute/Item.php', '24.9', 0),
('6a349936ab504a06910abc894f3974e2', './lib/core/CustomRoute/Type.php', '24.9', 0),
('e0ce389cdce53e0879bf34a6d7676dd0', './lib/core/CustomRoute/Type/Direct.php', '24.9', 0),
('4e803377fb5feec3c1db4b8118187a0a', './lib/core/CustomRoute/Type/TikiObject.php', '24.9', 0),
('312c2767aba4be959407adbe816b25c5', './lib/core/CustomRoute/Type/TrackerField.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/CustomRoute/Type/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/CustomRoute/index.php', '24.9', 0),
('a3bf3361ac3e7c26b9bac07041b15fe7', './lib/core/DeclFilter.php', '24.9', 0),
('d7ed558901ba630f8c8dfa29404efbef', './lib/core/DeclFilter/CatchAllFilterRule.php', '24.9', 0),
('cec14602206d13839144b8827db2faf5', './lib/core/DeclFilter/CatchAllUnsetRule.php', '24.9', 0),
('f9556cac0df62ffe315c0f1376d2d793', './lib/core/DeclFilter/FilterRule.php', '24.9', 0),
('fe19cdc4417a90de708dfc51659e7c57', './lib/core/DeclFilter/KeyPatternFilterRule.php', '24.9', 0),
('cbf6a9e587128c1824dfa670c1ff7707', './lib/core/DeclFilter/KeyPatternUnsetRule.php', '24.9', 0),
('8592459bac564c48e1bbe716b3851fc4', './lib/core/DeclFilter/Rule.php', '24.9', 0),
('38539b61333b3ca7e21ee5b166569341', './lib/core/DeclFilter/StaticKeyFilterRule.php', '24.9', 0),
('cb98b0eb963d8dfbf8571ebde833f4c3', './lib/core/DeclFilter/StaticKeyUnsetRule.php', '24.9', 0),
('a50add2c8d1b097d91092d7d1bc49154', './lib/core/DeclFilter/UnsetRule.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/DeclFilter/index.php', '24.9', 0),
('a5558d7635eab096c1eb1b4d983bf923', './lib/core/Encryption/Exception.php', '24.9', 0),
('0082bc116305d5360cecdd677bd42918', './lib/core/Encryption/Key.php', '24.9', 0),
('a210fe9aa6c1691bc0e80ccb9d72528b', './lib/core/Encryption/KeyException.php', '24.9', 0),
('200e0e97cfc8285a81801e4764f10fa6', './lib/core/Encryption/NotFoundException.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Encryption/index.php', '24.9', 0),
('807f64793d45cf460065e7149b6da3cf', './lib/core/Feed/Abstract.php', '24.9', 0),
('a3c4a1d3e6fc2720b8954dc3d02481d0', './lib/core/Feed/Container.php', '24.9', 0),
('a2d0e51abd60bfd0f61447c9a28e91ea', './lib/core/Feed/Contents.php', '24.9', 0),
('6c2356515dfff4488bd957f62e9d248e', './lib/core/Feed/Html.php', '24.9', 0),
('d033f35ffc9319d31fbdbe80542df0e0', './lib/core/Feed/Html/Receive.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Feed/Html/index.php', '24.9', 0),
('139971e9d3a076fe20062680551c7291', './lib/core/Feed/Item.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Feed/index.php', '24.9', 0),
('23e9fe12ffa0b064cec62a5299181e2b', './lib/core/Feedback.php', '24.9', 0),
('16c21201a6f11fcc2552fd95b5a52058', './lib/core/File/DiagramHelper.php', '24.9', 0),
('aecf4d15d4555dcbb6d61693c1c3a525', './lib/core/File/FileHelper.php', '24.9', 0),
('dec3335bfbba2ef8f68123e04f22c5a1', './lib/core/File/OcrHelper.php', '24.9', 0),
('e35922dc076be4b8461b2d7b5c986b61', './lib/core/File/PDFHelper.php', '24.9', 0),
('7f2f9a013338a8780c4a0af7add9fd4b', './lib/core/File/SlideshowHelper.php', '24.9', 0),
('0a8fe05701e6af0cd5437be72f88a4ae', './lib/core/File/XMLHelper.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/File/index.php', '24.9', 0),
('590b56725855761260d0ff59915c04dd', './lib/core/Group/Roles/RolesLib.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Group/Roles/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Group/index.php', '24.9', 0),
('1895f4308a68e94490acdaf8cd3e4b58', './lib/core/H5P/EditorTikiAjax.php', '24.9', 0),
('9a666c82ae6883aa8892624128712060', './lib/core/H5P/EditorTikiStorage.php', '24.9', 0),
('869590dcdb57a9b5c1940fcc9db377e9', './lib/core/H5P/Event.php', '24.9', 0),
('3e99448e9716a965d1ddbf9f6e7bbe82', './lib/core/H5P/H5PTiki.php', '24.9', 0),
('0ba9248582984ad06136652f42a21462', './lib/core/H5P/editor.js', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/H5P/index.php', '24.9', 0),
('230b26dc2e38fb9f1ba7c71dad0d08b5', './lib/core/IDS/Rule.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/IDS/index.php', '24.9', 0),
('b1893ed5f91b0cbacc6597ca1f923aef', './lib/core/IDS/log.php', '24.9', 0),
('8497c68f524bae93341a315b5170c1ab', './lib/core/JisonParser/Phraser.js', '24.9', 0),
('c7bf9399cb4368f649b2dea700bde6d9', './lib/core/JisonParser/Phraser.php', '24.9', 0),
('b7ada5942528d1fc4136566453093846', './lib/core/JisonParser/Phraser/Handler.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/JisonParser/Phraser/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/JisonParser/index.php', '24.9', 0),
('058a7be99087358db1a1fef325aa045e', './lib/core/JitFilter.php', '24.9', 0),
('e3d75707162328338044016e2ec37a5f', './lib/core/JitFilter/Element.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/JitFilter/index.php', '24.9', 0),
('1462e6c1d7224f09127d20b928641445', './lib/core/Math/Formula/Applicator.php', '24.9', 0),
('91483f41c6732b4ed6c5954b50ef18ee', './lib/core/Math/Formula/Currency.php', '24.9', 0),
('d9ec4432c6ae5653bdde0a2245ea8bb9', './lib/core/Math/Formula/Element.php', '24.9', 0),
('0074b32f60cc613090c1f249157d2bb6', './lib/core/Math/Formula/Exception.php', '24.9', 0),
('d92409c1b40f96b415ee4269e97ac402', './lib/core/Math/Formula/Function.php', '24.9', 0),
('beea55f695c31693431fc4733a78059b', './lib/core/Math/Formula/Function/Add.php', '24.9', 0),
('13926f0779b3125e43c7fcd29ef6cb62', './lib/core/Math/Formula/Function/And.php', '24.9', 0),
('20e2527b1406d2cb851ecda81aedfba2', './lib/core/Math/Formula/Function/Avg.php', '24.9', 0),
('3704c4b0015f9a1516fe0544deb8dadd', './lib/core/Math/Formula/Function/Ceil.php', '24.9', 0),
('8dd0f892991fd440e6b309119f546171', './lib/core/Math/Formula/Function/Clean.php', '24.9', 0),
('d6f96c7611f520517ac0069965acbefb', './lib/core/Math/Formula/Function/Coalesce.php', '24.9', 0),
('8b37fbcbf76569805290786a7aac70f0', './lib/core/Math/Formula/Function/Concat.php', '24.9', 0),
('568f44c5513b5a6e14d6aec79cbce6c3', './lib/core/Math/Formula/Function/Contains.php', '24.9', 0),
('9d50fe6d8e3477a283cd3f9624233902', './lib/core/Math/Formula/Function/Count.php', '24.9', 0),
('0e8c4e37b66959056771f530c9cc4254', './lib/core/Math/Formula/Function/Currency.php', '24.9', 0),
('759b44fdfdbc60d75fdb092c69dc8642', './lib/core/Math/Formula/Function/CurrencyConvert.php', '24.9', 0),
('15e873788f0eeb4bcb58675fb7d9aef7', './lib/core/Math/Formula/Function/Date.php', '24.9', 0),
('14a7362280556cad5b036e658ce56f15', './lib/core/Math/Formula/Function/Div.php', '24.9', 0),
('c49c355bcffb31a493e32ecae2f1da11', './lib/core/Math/Formula/Function/Equals.php', '24.9', 0),
('7af63cc2d234f99ade677cdbfcd377e2', './lib/core/Math/Formula/Function/Eval.php', '24.9', 0),
('aade8d3f4d33a999215dcaa75e1b869d', './lib/core/Math/Formula/Function/Floor.php', '24.9', 0),
('f2fb9e3d4ca20844db9e84005404fe17', './lib/core/Math/Formula/Function/ForEach.php', '24.9', 0),
('f371730e9559443ca0107f4a5d29043b', './lib/core/Math/Formula/Function/Hash.php', '24.9', 0),
('33374f5aa48ae5b98712441a90c4fc9d', './lib/core/Math/Formula/Function/If.php', '24.9', 0),
('2cf381ef414c1489cd7b9642be700364', './lib/core/Math/Formula/Function/IsEmpty.php', '24.9', 0),
('23b8f87c8256c65d3e7dc4e2bfef6685', './lib/core/Math/Formula/Function/LessThan.php', '24.9', 0),
('03c8f9bff799b6cc338af8bbc9aeb107', './lib/core/Math/Formula/Function/Lower.php', '24.9', 0),
('7ce43cc08cb256d2b449ad6bbf5ef433', './lib/core/Math/Formula/Function/Map.php', '24.9', 0),
('f327af9b4a63e184ecebbc419bcd8a6a', './lib/core/Math/Formula/Function/Max.php', '24.9', 0),
('3585328999096ace67202394b2334f65', './lib/core/Math/Formula/Function/Min.php', '24.9', 0),
('87fc110984f0dab7e54de9eb3e1e2b35', './lib/core/Math/Formula/Function/MoreThan.php', '24.9', 0),
('351444d70591761c1030952e3703b758', './lib/core/Math/Formula/Function/Mul.php', '24.9', 0),
('69d057b0a6fc72a5047bb87cd4cce730', './lib/core/Math/Formula/Function/Not.php', '24.9', 0),
('95c60034f29da2c459aaff195d4ebbe4', './lib/core/Math/Formula/Function/NotEquals.php', '24.9', 0),
('b36333f4ac56ba7efe39609bbb35767f', './lib/core/Math/Formula/Function/NumberFormat.php', '24.9', 0),
('ab3d93f88fcdd28ca06ffec5ba3f6cb7', './lib/core/Math/Formula/Function/Or.php', '24.9', 0),
('f0e2f3ed04e3bb5c0c204783e521232b', './lib/core/Math/Formula/Function/Pad.php', '24.9', 0),
('e8ff36d4d290c15e21d5cb4a5b943760', './lib/core/Math/Formula/Function/Percentile.php', '24.9', 0),
('6429188cb4b99b1af45ee0dff33e7a68', './lib/core/Math/Formula/Function/Pow.php', '24.9', 0),
('6a88da32ce0b926c7c2cde1126a2f855', './lib/core/Math/Formula/Function/PregReplace.php', '24.9', 0),
('9801d2c18cf123c17f42e72cc8933f81', './lib/core/Math/Formula/Function/Random.php', '24.9', 0),
('9f83427c4636e985f6859f7dbb7224b2', './lib/core/Math/Formula/Function/Round.php', '24.9', 0),
('1bc7dafb1f8ec6d1fdd31ad550ffa046', './lib/core/Math/Formula/Function/SplitList.php', '24.9', 0),
('7c0b2ab06f10159fd8d659e0b0c9005e', './lib/core/Math/Formula/Function/Sqrt.php', '24.9', 0),
('0e2ae2cd0ec40261c0a6b6226919c050', './lib/core/Math/Formula/Function/StandardDeviation.php', '24.9', 0),
('d592e2340bffff2aa9a0448e51e8e608', './lib/core/Math/Formula/Function/Str.php', '24.9', 0),
('4b4e3eb493cebc360d47dc3b03b79206', './lib/core/Math/Formula/Function/StrReplace.php', '24.9', 0),
('935fa25590a7fb051373a996a19a7130', './lib/core/Math/Formula/Function/StrToTime.php', '24.9', 0),
('2e83a04953a4d46f290137908353dad2', './lib/core/Math/Formula/Function/Sub.php', '24.9', 0),
('9542d73f1a3e310b7bab11004e669ce8', './lib/core/Math/Formula/Function/Substring.php', '24.9', 0),
('415dc9c83296d024268dc71ec898b400', './lib/core/Math/Formula/Function/Subtotal.php', '24.9', 0),
('e535474531c9a6827d9963b0423eac86', './lib/core/Math/Formula/Function/Upper.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Math/Formula/Function/index.php', '24.9', 0),
('2e740bab537735e04c571d80ef762cf4', './lib/core/Math/Formula/InternalString.php', '24.9', 0),
('6584fa79a8ee581fbc83f944fe0508df', './lib/core/Math/Formula/Parser.php', '24.9', 0),
('5bd25dcbb7b93314e840f1ab0799cc07', './lib/core/Math/Formula/Parser/Exception.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Math/Formula/Parser/index.php', '24.9', 0),
('b080e6f2cf7b9704eba328b95e43626f', './lib/core/Math/Formula/Runner.php', '24.9', 0),
('3d6d12cede6aae5cdadd6b9bd6fb4094', './lib/core/Math/Formula/Runner/Exception.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Math/Formula/Runner/index.php', '24.9', 0),
('582a71ed4b9e36b16cb86a5f572cf1ef', './lib/core/Math/Formula/Tokenizer.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Math/Formula/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Math/index.php', '24.9', 0),
('0ae70aff5ae731ec5fd5b4e9396f08e3', './lib/core/Modules/Permissions.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Modules/index.php', '24.9', 0),
('bdedc4979518184cb83222163143a902', './lib/core/Multilingual/Aligner/BilingualAligner.php', '24.9', 0),
('928e5222a68018c6631445c21a8c9d9e', './lib/core/Multilingual/Aligner/MockMTWrapper.php', '24.9', 0),
('f9f22dfad4688dd9d0b94cbff68ccf48', './lib/core/Multilingual/Aligner/SentenceAlignments.php', '24.9', 0),
('db38c540b743693dc57b2a8bf9e06394', './lib/core/Multilingual/Aligner/SentenceSegmentor.php', '24.9', 0),
('ce317933ac47b15ca4387d2d3c6bfbb6', './lib/core/Multilingual/Aligner/ShortestPathFinder.php', '24.9', 0),
('f012755075c21e4eadb80847c84a7045', './lib/core/Multilingual/Aligner/UpdatePages.php', '24.9', 0),
('fa4c4d6435e5332d106bb8d6e8880ec2', './lib/core/Multilingual/Aligner/UpdateSentences.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Multilingual/Aligner/index.php', '24.9', 0),
('b990dda8d70e04d95a6b719eab861af4', './lib/core/Multilingual/MachineTranslation.php', '24.9', 0),
('1a563cf2202ed3cb429b9c689e00a26a', './lib/core/Multilingual/MachineTranslation/BingTranslateWrapper.php', '24.9', 0),
('abfff2a21c27b6024ff8152d9e7ac9d7', './lib/core/Multilingual/MachineTranslation/Cache.php', '24.9', 0),
('426c6af4c4499d1d963464cbaa5f5fe0', './lib/core/Multilingual/MachineTranslation/GoogleTranslateWrapper.php', '24.9', 0),
('03c5d431ebaf3444b4a6889f963a4e83', './lib/core/Multilingual/MachineTranslation/Interface.php', '24.9', 0),
('af7f36a642dca1753773724d3eb78266', './lib/core/Multilingual/MachineTranslation/Null.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Multilingual/MachineTranslation/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Multilingual/index.php', '24.9', 0),
('f1e8a8da10695cd39269a883d9a99029', './lib/core/Notifications/Email.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Notifications/index.php', '24.9', 0),
('03a783e8a91c915ee2e6d53827ee0aef', './lib/core/Perms.php', '24.9', 0),
('343b089a95360e7d507f6547712f71de', './lib/core/Perms/Accessor.php', '24.9', 0),
('284a49ba6fb4b1aded2e8387cce845f7', './lib/core/Perms/Applier.php', '24.9', 0),
('81c975ed9a0464aa7673b83aea6430aa', './lib/core/Perms/Builder.php', '24.9', 0),
('17a138989f4c09a53525272ebf6c3db1', './lib/core/Perms/Check.php', '24.9', 0),
('b06e3fb93255198fccafc4654add98af', './lib/core/Perms/Check/Alternate.php', '24.9', 0),
('41be5618c2f79e45a94f4efb69afb4a8', './lib/core/Perms/Check/Creator.php', '24.9', 0),
('e84bb6e942a172786609e9c1bfb376ac', './lib/core/Perms/Check/Direct.php', '24.9', 0),
('fd387d6286ab0bae8299fc14d66db31d', './lib/core/Perms/Check/Fixed.php', '24.9', 0),
('5fd29eccbd858e91d1b5ee40697fab5d', './lib/core/Perms/Check/Indirect.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Perms/Check/index.php', '24.9', 0),
('47be46cc186e94934471b3301b4bbbb9', './lib/core/Perms/Context.php', '24.9', 0),
('ef2dd5c4f36db8232bfc8b725ad693a2', './lib/core/Perms/Reflection/Category.php', '24.9', 0),
('8186bb79bc4a2587366b6fded21070ba', './lib/core/Perms/Reflection/Container.php', '24.9', 0),
('b9a5e314359adc8eda6c585b0e086549', './lib/core/Perms/Reflection/Factory.php', '24.9', 0),
('7306903f50b51e5b956650d97341c25a', './lib/core/Perms/Reflection/Global.php', '24.9', 0),
('5bbc5e02353923bf063537fd78281d31', './lib/core/Perms/Reflection/Object.php', '24.9', 0),
('b785ff8546e33a61b4f0086ef5ab29d0', './lib/core/Perms/Reflection/PermissionComparator.php', '24.9', 0),
('ecfc1f66b222fea90ff235236336f8cf', './lib/core/Perms/Reflection/PermissionSet.php', '24.9', 0),
('0bac837682c143954d8fd652d6fa37fd', './lib/core/Perms/Reflection/Quick.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Perms/Reflection/index.php', '24.9', 0),
('d40671e2e2e4da71ab1e41ca38620d18', './lib/core/Perms/Resolver.php', '24.9', 0),
('4d19d9b3b9ed95477e89bc45a5cd2583', './lib/core/Perms/Resolver/Default.php', '24.9', 0),
('3ee34ae386308547381aa01b40d16a0e', './lib/core/Perms/Resolver/Static.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Perms/Resolver/index.php', '24.9', 0),
('7f85931be3dbf3d1e89561706e25a74f', './lib/core/Perms/ResolverFactory.php', '24.9', 0),
('f803598beaa804e8cbd72aa815caecc3', './lib/core/Perms/ResolverFactory/CategoryFactory.php', '24.9', 0),
('6dbd0465e05ccfbbc9293c49fed4372c', './lib/core/Perms/ResolverFactory/GlobalFactory.php', '24.9', 0),
('60c9e7cfe783082fce2f61235840dfa1', './lib/core/Perms/ResolverFactory/ObjectFactory.php', '24.9', 0),
('a113c52e59dcb60586eb44aa6b419c74', './lib/core/Perms/ResolverFactory/StaticFactory.php', '24.9', 0),
('7459fa62f65492c890e9d79fde3c1f97', './lib/core/Perms/ResolverFactory/TestFactory.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Perms/ResolverFactory/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Perms/index.php', '24.9', 0),
('8b3a30bf4cde356e0beaea76710b899f', './lib/core/Reports/Cache.php', '24.9', 0),
('648a3ceef7b37dfe8fb3574fb4b385fc', './lib/core/Reports/Factory.php', '24.9', 0),
('38198a532f0643acb022f91d83042c85', './lib/core/Reports/Manager.php', '24.9', 0),
('0b3a0f5a25be32ed59a84a227c0e0947', './lib/core/Reports/Send.php', '24.9', 0),
('4f7e4b68fad1ac0ae5ac21332283ceef', './lib/core/Reports/Send/EmailBuilder.php', '24.9', 0),
('87dd6384342ebfcf0f96693feb4321ee', './lib/core/Reports/Send/EmailBuilder/Abstract.php', '24.9', 0),
('b616234b95a22bf052c98445c6887017', './lib/core/Reports/Send/EmailBuilder/ArticleDeleted.php', '24.9', 0),
('59202c59036032abb5064f7167189dae', './lib/core/Reports/Send/EmailBuilder/ArticleEdited.php', '24.9', 0),
('7c8d7103ada9c618a74dc868d9ab2a18', './lib/core/Reports/Send/EmailBuilder/ArticleSubmitted.php', '24.9', 0),
('326fa16402ce1b077a4c42b0679dd622', './lib/core/Reports/Send/EmailBuilder/BlogPost.php', '24.9', 0),
('564be0d51031dfcd163f7a1c89304f88', './lib/core/Reports/Send/EmailBuilder/CalendarChanged.php', '24.9', 0),
('d50f1c9af4eead7cfda55e58f0a691c4', './lib/core/Reports/Send/EmailBuilder/CategoryChanged.php', '24.9', 0),
('fd0500a7d0e375acf91fe363c5e40c25', './lib/core/Reports/Send/EmailBuilder/Factory.php', '24.9', 0),
('889c94b3a47eba2ceae2ca9c7f279bf8', './lib/core/Reports/Send/EmailBuilder/FileGalleryChanged.php', '24.9', 0),
('1bec3d14e4aae315381974f97d5252f7', './lib/core/Reports/Send/EmailBuilder/ForumPostThread.php', '24.9', 0),
('3845fffa6be260cefccabf793172e172', './lib/core/Reports/Send/EmailBuilder/ForumPostTopic.php', '24.9', 0),
('3a55f2f02b9c002fd708d7905c78b34e', './lib/core/Reports/Send/EmailBuilder/StructureAdd.php', '24.9', 0),
('5836bbb0aa81bed3884458529177d9db', './lib/core/Reports/Send/EmailBuilder/StructureMoveDown.php', '24.9', 0),
('45d505b7ada1f0f06707c33d3a218421', './lib/core/Reports/Send/EmailBuilder/StructureMoveUp.php', '24.9', 0),
('f7558277584836033f7ad42841c9e2f2', './lib/core/Reports/Send/EmailBuilder/StructureRemove.php', '24.9', 0),
('8c29698dbc5fca76afea8006d8c44f20', './lib/core/Reports/Send/EmailBuilder/TrackerFileAttachment.php', '24.9', 0),
('eafca6001c003272cadcac1fdd0adaea', './lib/core/Reports/Send/EmailBuilder/TrackerItemComment.php', '24.9', 0),
('e3d2949287920670c459673457c124e5', './lib/core/Reports/Send/EmailBuilder/TrackerItemModified.php', '24.9', 0),
('1f7c81d0bbc837f1322d84bb84a11938', './lib/core/Reports/Send/EmailBuilder/WikiFileAttached.php', '24.9', 0),
('0297a548968423bd5b82fe45f244dff8', './lib/core/Reports/Send/EmailBuilder/WikiPageChanged.php', '24.9', 0),
('3ac9a2b949053df3b51c60d6c7322eb4', './lib/core/Reports/Send/EmailBuilder/WikiPageCreated.php', '24.9', 0),
('7b0962eeae9876f2213cad9a679c2968', './lib/core/Reports/Send/EmailBuilder/WikiPageDeleted.php', '24.9', 0),
('cc00353272cb6d70d8c46f2faa5d7e2d', './lib/core/Reports/Send/EmailBuilder/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Reports/Send/index.php', '24.9', 0),
('6d8a66db93c23803f3b226d67982fb55', './lib/core/Reports/Users.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Reports/index.php', '24.9', 0),
('f2389df18297829a0b38620c341ecd78', './lib/core/Scheduler/Exception/CrontimeFormatException.php', '24.9', 0),
('5d8395d5e57a667fb95d84aeb815c509', './lib/core/Scheduler/Exception/Exception.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Scheduler/Exception/index.php', '24.9', 0),
('e3b62ff2780dbbb21934802514860cfa', './lib/core/Scheduler/Item.php', '24.9', 0),
('70d2ee9b337362be30aaf9c3576d4ec8', './lib/core/Scheduler/Manager.php', '24.9', 0),
('2f9d3f410b3279499016fb1fb14b766a', './lib/core/Scheduler/Output/SchedulerRunOutput.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Scheduler/Output/index.php', '24.9', 0),
('91936f26ae061cc38b5321fe17279bee', './lib/core/Scheduler/Task/CommandTask.php', '24.9', 0),
('a6f0ea9dd25b6a385cb6640c0c2742d9', './lib/core/Scheduler/Task/ConsoleCommandTask.php', '24.9', 0),
('ec5567cbbd12725edaee29e4dea4ca8e', './lib/core/Scheduler/Task/HTTPGetCommandTask.php', '24.9', 0),
('2d2b098f99a4c6e8a1660d5e14e1b2e0', './lib/core/Scheduler/Task/ShellCommandTask.php', '24.9', 0),
('fbd1cf20d67e7c519cc5ebb8be521e5c', './lib/core/Scheduler/Task/TikiCheckerCommandTask.php', '24.9', 0),
('7d492816dd591a36d1e2cdcbb75fa28d', './lib/core/Scheduler/Task/UserLockMailerCommandTask.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Scheduler/Task/index.php', '24.9', 0),
('6144ed2e919c60e9d50f265c9a1853d1', './lib/core/Scheduler/Utils.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Scheduler/index.php', '24.9', 0),
('4c4a7c2aa7084a1a6bdfbb1e62693f83', './lib/core/Search/Action/Action.php', '24.9', 0),
('fbfef1b3bddbb92ba0b36aaeaf7bc37b', './lib/core/Search/Action/ActionStep.php', '24.9', 0),
('f3a494db95508f57fb749e7e25fd887d', './lib/core/Search/Action/ChangeStatusAction.php', '24.9', 0),
('dd16e55ee30a95a6b11a2212e6096813', './lib/core/Search/Action/Delete.php', '24.9', 0),
('c2e000acdc71c0a16ace6f62c0afc75d', './lib/core/Search/Action/EmailAction.php', '24.9', 0),
('a63c20c0ced9a131b61c9bde920b94f7', './lib/core/Search/Action/Exception.php', '24.9', 0),
('acd8ef893f240d19f3e4688c309f06c5', './lib/core/Search/Action/Factory.php', '24.9', 0),
('c341cf953c6d05299ff8c47dc7afe9e8', './lib/core/Search/Action/FileGalleryChangeFilename.php', '24.9', 0),
('84627461178284048ef7076254b2fcfe', './lib/core/Search/Action/FileGalleryImageOverlay.php', '24.9', 0),
('229ca86fd129c40adea8284d18108b2b', './lib/core/Search/Action/ReportingTransform.php', '24.9', 0),
('f55f4e95d10f4f286e704d7376265d3c', './lib/core/Search/Action/Sequence.php', '24.9', 0),
('64dc20f452658a336d0b04879538b193', './lib/core/Search/Action/Snapshot.php', '24.9', 0),
('9214b701ebdbdfb5e20ae8768c294012', './lib/core/Search/Action/Step.php', '24.9', 0),
('959238386b4e4ea3b4c7cbd7059c2bf1', './lib/core/Search/Action/TrackerItemClone.php', '24.9', 0),
('2b9d3ba89d812567fb1751892f9739eb', './lib/core/Search/Action/TrackerItemInsert.php', '24.9', 0),
('abd5a4a1218faa95d65d6db3c656cefd', './lib/core/Search/Action/TrackerItemModify.php', '24.9', 0),
('d8dacf8c7c413f83989920b10254cf73', './lib/core/Search/Action/UnknownStep.php', '24.9', 0),
('063570d875f6b343dff603fc90ac7135', './lib/core/Search/Action/WikiApprovalAction.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Search/Action/index.php', '24.9', 0),
('aefc51478ed2a60d9e75a20bb07349e0', './lib/core/Search/ContentFilter/VersionNumber.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/ContentFilter/index.php', '24.9', 0),
('e2f2514a5e721befcf9723d4abeff082', './lib/core/Search/ContentSource/ActivityStreamSource.php', '24.9', 0),
('207e5f78a784e07cd033d4461ff6c738', './lib/core/Search/ContentSource/ArticleSource.php', '24.9', 0),
('2e01e428798f2fc6cf60440dfdb7eb46', './lib/core/Search/ContentSource/BlogPostSource.php', '24.9', 0),
('856432b4b74e6adb581edbc3ee4a1487', './lib/core/Search/ContentSource/CalendarItemSource.php', '24.9', 0),
('41e2038ac19e29f1ebfc7bf72b065deb', './lib/core/Search/ContentSource/CalendarSource.php', '24.9', 0),
('744acc68701ff0c126748a314051fe63', './lib/core/Search/ContentSource/CategorySource.php', '24.9', 0),
('c41873c0ebd97748d2cdb88f8696596c', './lib/core/Search/ContentSource/CommentSource.php', '24.9', 0),
('7606f322014672488233312ae310d3e8', './lib/core/Search/ContentSource/CreditSource.php', '24.9', 0),
('fc5e3dacce7c6e7fcc6c7f488fc3ca94', './lib/core/Search/ContentSource/FileGallerySource.php', '24.9', 0),
('5527ef84173ec45628c52d0a20719065', './lib/core/Search/ContentSource/FileSource.php', '24.9', 0),
('afe263bbd1b4d03d338c6d996597363e', './lib/core/Search/ContentSource/ForumPostSource.php', '24.9', 0),
('bb55264693b83dbb007dc38283e66160', './lib/core/Search/ContentSource/ForumSource.php', '24.9', 0),
('592e7586f734da894172276bf9b603a2', './lib/core/Search/ContentSource/GoalEventSource.php', '24.9', 0),
('14f8565155ba408c4ca90f5f14409615', './lib/core/Search/ContentSource/GoalSource.php', '24.9', 0),
('32bc217a3d63be9dfd1db382d78b87f2', './lib/core/Search/ContentSource/GroupSource.php', '24.9', 0),
('83bbc423a765f72677c380a5c591e39d', './lib/core/Search/ContentSource/Interface.php', '24.9', 0),
('ad804255cf80bd14cc436d5aaec1cb1b', './lib/core/Search/ContentSource/SheetSource.php', '24.9', 0),
('7526f9c68425e658e1fdfbc06459fc94', './lib/core/Search/ContentSource/Static.php', '24.9', 0),
('80afe31b67e8e4ff594d73b461229702', './lib/core/Search/ContentSource/TrackerFieldSource.php', '24.9', 0),
('04298e5f69f06eade94fbf7a8bd36569', './lib/core/Search/ContentSource/TrackerItemSource.php', '24.9', 0),
('355c9b029cb8d0f20603a75f01c63ae8', './lib/core/Search/ContentSource/TrackerSource.php', '24.9', 0),
('aef6b6ae425b4f84b6602cf63af26c9f', './lib/core/Search/ContentSource/UserSource.php', '24.9', 0),
('1a4499b7651167ef799592ea986acd8c', './lib/core/Search/ContentSource/WebserviceSource.php', '24.9', 0),
('5637fdd5eccd76b679f0afa411301dce', './lib/core/Search/ContentSource/WikiSource.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/ContentSource/index.php', '24.9', 0),
('f29e801441eab28cf385b2fae36aa167', './lib/core/Search/Elastic/BulkOperation.php', '24.9', 0),
('cdc98378def35b1f4da35e212c6d8f56', './lib/core/Search/Elastic/Connection.php', '24.9', 0),
('1166543bd9a7c559282209bb0432e16b', './lib/core/Search/Elastic/ElasticSearchIndexManager.php', '24.9', 0),
('cb36d064aa089be24b9ff19d456b53e0', './lib/core/Search/Elastic/Exception.php', '24.9', 0),
('52645b05baae63d9354563f40a2b9f0e', './lib/core/Search/Elastic/FacetBuilder.php', '24.9', 0),
('6295e3d872f335c3d3d51f5ad14564b5', './lib/core/Search/Elastic/FacetReader.php', '24.9', 0),
('723c855bf5cd9a78c808ad6791b4927d', './lib/core/Search/Elastic/Index.php', '24.9', 0),
('a43296402617af6c01c68dd70e1355d3', './lib/core/Search/Elastic/MappingException.php', '24.9', 0),
('6d474ea20c7a1af259cb17c3e26539d5', './lib/core/Search/Elastic/NotFoundException.php', '24.9', 0),
('5c52b13c9adb6176bb69895044edc340', './lib/core/Search/Elastic/NumberFormatException.php', '24.9', 0),
('b147b025ae12328c211aa9f8ff723c8c', './lib/core/Search/Elastic/OrderBuilder.php', '24.9', 0),
('581d409450f10d83e178bc89f32d8153', './lib/core/Search/Elastic/Prefilter.php', '24.9', 0),
('a252f2985be9cfd38c569fb4949d16b4', './lib/core/Search/Elastic/QueryBuilder.php', '24.9', 0),
('5300ce38383d9e46db5aba499c7133dd', './lib/core/Search/Elastic/QueryParsingException.php', '24.9', 0),
('4fd69b310e9b1bb18709eeb6da3128ea', './lib/core/Search/Elastic/RescoreQueryBuilder.php', '24.9', 0),
('9eaf5b35dc84adcab419bc457286f735', './lib/core/Search/Elastic/ResultSet.php', '24.9', 0),
('d19a99ce041e62d7210f4e0546d2da34', './lib/core/Search/Elastic/SortException.php', '24.9', 0),
('60f4b2dcc0cb3857d47aeda9f3d57f5b', './lib/core/Search/Elastic/TransportException.php', '24.9', 0),
('2e6ac23d65e9f7f8527306e2eb78d66c', './lib/core/Search/Elastic/TypeFactory.php', '24.9', 0),
('a59e5a457c9dcee6d8b667a4bf2d1f1e', './lib/core/Search/EngineResult/Elastic.php', '24.9', 0),
('48a748a3d52c49529ff4fd7d2aa2633a', './lib/core/Search/EngineResult/Interface.php', '24.9', 0),
('9c7df68d6a3bb273a9a740916787077b', './lib/core/Search/EngineResult/MySQL.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/EngineResult/index.php', '24.9', 0),
('e75321c82583b1cd0bf6005833c5f9c8', './lib/core/Search/Exception.php', '24.9', 0),
('f9fd450797c1587a1223ee616f0f5c0b', './lib/core/Search/Expr/And.php', '24.9', 0),
('77f948774f1ac78943d2977662d64b24', './lib/core/Search/Expr/Distance.php', '24.9', 0),
('9b033053bd636e29369d482337dd5c6e', './lib/core/Search/Expr/ExplicitPhrase.php', '24.9', 0),
('1c155aa5d0476594ab55700089485b26', './lib/core/Search/Expr/ImplicitPhrase.php', '24.9', 0),
('b97888769992e09f5708c6d9669675c0', './lib/core/Search/Expr/Initial.php', '24.9', 0),
('aaf3793db6e20f4e87adbb47f92d8dc8', './lib/core/Search/Expr/Interface.php', '24.9', 0),
('a4eba7f8aaaebac6cf5b29ebecd0e3b0', './lib/core/Search/Expr/MoreLikeThis.php', '24.9', 0),
('655b6f60124af2ecabf7361eae4b8d66', './lib/core/Search/Expr/Not.php', '24.9', 0),
('f210615efe7d547ffa92001221501a71', './lib/core/Search/Expr/Or.php', '24.9', 0),
('fb1fd171bd14e2860c1976000ef746e4', './lib/core/Search/Expr/Parser.php', '24.9', 0),
('60d1bb29f597db4b49db6fed7fcb66cf', './lib/core/Search/Expr/Range.php', '24.9', 0),
('7d412130a55867500b1ef9e8b0c1828b', './lib/core/Search/Expr/Token.php', '24.9', 0),
('a076b81c99d5ab9437681680edff4f09', './lib/core/Search/Expr/Tokenizer.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/Expr/index.php', '24.9', 0),
('9fcffdf6f6fae5b77e514bdb91fa64fd', './lib/core/Search/FacetProvider.php', '24.9', 0),
('e51047bd7886d7a328a3fb303358f2d9', './lib/core/Search/FacetProvider/Interface.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Search/FacetProvider/index.php', '24.9', 0),
('a587b3f949671d9510680ea1994fcf4b', './lib/core/Search/Federated/CompilerPass.php', '24.9', 0),
('950fc004d98e8fa484007012bd4eef4c', './lib/core/Search/Federated/IndexInterface.php', '24.9', 0),
('2e986e587923475b7ad3bc7d3bc122d4', './lib/core/Search/Federated/ManifoldCfIndex.php', '24.9', 0),
('a4f3b791b4dec49cd479e9304063e0b9', './lib/core/Search/Federated/TikiIndex.php', '24.9', 0),
('d588914b65f6bbe192ad00dad5c5c166', './lib/core/Search/Federated/UrlPrefixTransform.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Search/Federated/index.php', '24.9', 0),
('52eef61ab1575978a85c70f19e6e086b', './lib/core/Search/Formatter.php', '24.9', 0),
('973e4a4fc9a860089b782672a72fc435', './lib/core/Search/Formatter/AppendPagination.php', '24.9', 0),
('bd2dfa7d2e069eb25962d94c51239cd4', './lib/core/Search/Formatter/ArrayBuilder.php', '24.9', 0),
('a637c6a84570364d62273091b842b740', './lib/core/Search/Formatter/Builder.php', '24.9', 0),
('dd8bfc3d9b1f3f9d2b635c0da40761f6', './lib/core/Search/Formatter/DataSource/Declarative.php', '24.9', 0),
('3a0a4b2fca3b94bde809f0f3a08cf9bf', './lib/core/Search/Formatter/DataSource/Interface.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Search/Formatter/DataSource/index.php', '24.9', 0),
('a15efc741b139ee06f514a533ddf9c53', './lib/core/Search/Formatter/Factory.php', '24.9', 0),
('4c3395009d72c37a1ef84674558c1e4c', './lib/core/Search/Formatter/Plugin/AbstractTableTemplate.php', '24.9', 0),
('09c64d3367723ff282eb1d1108fe9881', './lib/core/Search/Formatter/Plugin/ArrayTemplate.php', '24.9', 0),
('3bfab3607f0455b32d6167c0943cf215', './lib/core/Search/Formatter/Plugin/CsvTemplate.php', '24.9', 0),
('382f6e58d79e60bb1071aca12f8286b0', './lib/core/Search/Formatter/Plugin/Interface.php', '24.9', 0),
('dc5d3197caf953cf512fa6d26e96d348', './lib/core/Search/Formatter/Plugin/ReportTemplate.php', '24.9', 0),
('922d674e84e65d53289d75798f3adcf4', './lib/core/Search/Formatter/Plugin/SmartyTemplate.php', '24.9', 0),
('c7e5daa327a22c22b7f18e6938b4c6c7', './lib/core/Search/Formatter/Plugin/WikiTemplate.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Search/Formatter/Plugin/index.php', '24.9', 0),
('21312a1c5927e92bb4e1f28d996fbd14', './lib/core/Search/Formatter/Sublist/Exception.php', '24.9', 0),
('9c5c83892a658176f42226747bcf8dc4', './lib/core/Search/Formatter/Sublist/Executor.php', '24.9', 0),
('3cef6204eb75faa84d96d84c79d1194c', './lib/core/Search/Formatter/Sublist/Parser.php', '24.9', 0),
('0b58e0e2c7e5ac58c78a0dbe3ebd8137', './lib/core/Search/Formatter/Sublist/Record.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Search/Formatter/Sublist/index.php', '24.9', 0),
('6e27a5137c924a0f0891eb93724d8ab3', './lib/core/Search/Formatter/Transform/DynamicLoader.php', '24.9', 0),
('3f7df61646c3fa2f74ba469867769b76', './lib/core/Search/Formatter/Transform/FieldPermissionEnforcer.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Search/Formatter/Transform/index.php', '24.9', 0),
('ef53f8b0105c728822803a8cc4314b3e', './lib/core/Search/Formatter/ValueFormatter.php', '24.9', 0),
('871867e1d144f9bfe9e31429fd8405ae', './lib/core/Search/Formatter/ValueFormatter/Abstract.php', '24.9', 0),
('14ab7d08f92404af59e20f11be1a740d', './lib/core/Search/Formatter/ValueFormatter/Categorylist.php', '24.9', 0),
('00c692b0f87055359ec473d3ebf09615', './lib/core/Search/Formatter/ValueFormatter/Count.php', '24.9', 0),
('8a05a88bfe6f1773d9204fc80b6e3cf4', './lib/core/Search/Formatter/ValueFormatter/Currency.php', '24.9', 0),
('b8027b06102160b8d463aeb693f2491b', './lib/core/Search/Formatter/ValueFormatter/Date.php', '24.9', 0),
('71551adc2e9aa503305ac26206300d8d', './lib/core/Search/Formatter/ValueFormatter/Datetime.php', '24.9', 0),
('9e0f95f5c47127240a764a3e36ddbe83', './lib/core/Search/Formatter/ValueFormatter/Imagegrabber.php', '24.9', 0),
('1c8abf37d397d2c3f6ea1bdc9e512746', './lib/core/Search/Formatter/ValueFormatter/Interface.php', '24.9', 0),
('0fd358f2c2aa15c007c54d6d32fc71b3', './lib/core/Search/Formatter/ValueFormatter/Number.php', '24.9', 0),
('4c8cf51d48a005c7e1625ce1195d6d87', './lib/core/Search/Formatter/ValueFormatter/Objectlink.php', '24.9', 0),
('872f4e5a572f865100fcc0cf66cbc301', './lib/core/Search/Formatter/ValueFormatter/Plain.php', '24.9', 0),
('f279e4729d89df8039294281e5c174c6', './lib/core/Search/Formatter/ValueFormatter/Reference.php', '24.9', 0),
('e8cabb072217f98257d683a97dd766b3', './lib/core/Search/Formatter/ValueFormatter/Slug.php', '24.9', 0),
('e2e07205bafd4279d61b7cafa7590960', './lib/core/Search/Formatter/ValueFormatter/Snippet.php', '24.9', 0),
('1d093719954a4dbd442ad988f7d0ac97', './lib/core/Search/Formatter/ValueFormatter/Sorthandle.php', '24.9', 0),
('117746f610428ddeedc595deccff39e2', './lib/core/Search/Formatter/ValueFormatter/Templaterender.php', '24.9', 0),
('5f60cc1bc9e0ccb47435f52b57b153d5', './lib/core/Search/Formatter/ValueFormatter/Timeago.php', '24.9', 0),
('9a547136eae77b7595e5a812a1d4d8a6', './lib/core/Search/Formatter/ValueFormatter/Trackerrender.php', '24.9', 0),
('1033f71a1fec6334a0f398312f416fb8', './lib/core/Search/Formatter/ValueFormatter/Url.php', '24.9', 0),
('47e7a21b3990acd648d7f52f3c21ec6e', './lib/core/Search/Formatter/ValueFormatter/Urlencode.php', '24.9', 0),
('840e197c14dabf97bac56144d37ac2d3', './lib/core/Search/Formatter/ValueFormatter/Userlist.php', '24.9', 0),
('88b8422c975ff073a4b3f83f100c7cda', './lib/core/Search/Formatter/ValueFormatter/Wikiplugin.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Search/Formatter/ValueFormatter/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/Formatter/index.php', '24.9', 0),
('72a9912d7851987e31d4315cb60fed39', './lib/core/Search/GlobalSource/AdvancedRatingSource.php', '24.9', 0),
('d20366c06ecfff319e0cd4255214258f', './lib/core/Search/GlobalSource/ArticleAttachmentSource.php', '24.9', 0),
('6a61c178c501d60eb0b924af33e67272', './lib/core/Search/GlobalSource/CategorySource.php', '24.9', 0),
('73341c3dbe8ccc204e2aa6c4e675ec4f', './lib/core/Search/GlobalSource/CommentSource.php', '24.9', 0),
('4318e95140f17d96c120a87b1490f630', './lib/core/Search/GlobalSource/FileAttachmentSource.php', '24.9', 0),
('ca9da8c24790000697a195a53086c54b', './lib/core/Search/GlobalSource/FreeTagSource.php', '24.9', 0),
('0a21f52b80e6049f1cb9993191790edf', './lib/core/Search/GlobalSource/Geolocation.php', '24.9', 0),
('5978ce38c45b033d2515d53f86ccb251', './lib/core/Search/GlobalSource/Interface.php', '24.9', 0),
('f5f6e99002794cdc94c293cc119ee957', './lib/core/Search/GlobalSource/PermissionSource.php', '24.9', 0),
('e323ffd897fdbe030586ce3afa693214', './lib/core/Search/GlobalSource/RelationSource.php', '24.9', 0),
('a50723c89cff27ca893392afa88d07f9', './lib/core/Search/GlobalSource/SearchableSource.php', '24.9', 0),
('295d3f27f06f36ff1b7f5fb4d106354f', './lib/core/Search/GlobalSource/SocialSource.php', '24.9', 0),
('4d872639d9d3940bee22a2c0f4bd833b', './lib/core/Search/GlobalSource/Static.php', '24.9', 0),
('8de863b4e8852b4b1129a46525f8bfb7', './lib/core/Search/GlobalSource/TitleInitialSource.php', '24.9', 0),
('0a5e0dd22d403cf85ed9a361ec2869e2', './lib/core/Search/GlobalSource/UrlSource.php', '24.9', 0),
('c33b0262382dda35416a8c57edf7b720', './lib/core/Search/GlobalSource/VisitsSource.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/GlobalSource/index.php', '24.9', 0),
('c55ecbf43ee4ba1d2e3ecf4673e22d82', './lib/core/Search/Index/AbstractIndexDecorator.php', '24.9', 0),
('c18ee790b2987c91a5bcd79092ed140a', './lib/core/Search/Index/CategoryFilterDecorator.php', '24.9', 0),
('276d592b91fc69635b1da836e418b4d6', './lib/core/Search/Index/Interface.php', '24.9', 0),
('12fb839d6084045ed72c726aeaad65d9', './lib/core/Search/Index/Memory.php', '24.9', 0),
('974b8516112da2786115782987a5f4c9', './lib/core/Search/Index/QueryAlertDecorator.php', '24.9', 0),
('f5d5985ea9108742c1325b571844425c', './lib/core/Search/Index/QueryRepository.php', '24.9', 0),
('f816f4e6def9b8a159e55121caf0c397', './lib/core/Search/Index/TypeAnalysisDecorator.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/Index/index.php', '24.9', 0),
('ccb913065ff3c2e25e0ba150c94a7ef5', './lib/core/Search/Indexer.php', '24.9', 0),
('56f801ff35b4b718930fbc021ba9b350', './lib/core/Search/MySql/Exception.php', '24.9', 0),
('a09d124a6c858acbb305d8769d6eaa5a', './lib/core/Search/MySql/FieldQueryBuilder.php', '24.9', 0),
('5259e5da355723e263b10ffc986d27ae', './lib/core/Search/MySql/HighlightHelper.php', '24.9', 0),
('87fe9d0f6623957e29eba5a35d025751', './lib/core/Search/MySql/Index.php', '24.9', 0),
('f53ba4c492a298d7fa0efa94b65dbc8b', './lib/core/Search/MySql/LimitReachedException.php', '24.9', 0),
('2fca92f302388a605a13041f6267cff1', './lib/core/Search/MySql/MysqlSearchIndexManager.php', '24.9', 0),
('fbf33b1b452c430d610d82ef88981552', './lib/core/Search/MySql/Prefilter.php', '24.9', 0),
('8bdd7e447fd1eb418400520606e3f10a', './lib/core/Search/MySql/QueryBuffer.php', '24.9', 0),
('a539bd3ef9c09f0f5586ae6607906da9', './lib/core/Search/MySql/QueryBuilder.php', '24.9', 0),
('6aa7929e51eb1769ee09d5b5caa440e0', './lib/core/Search/MySql/QueryException.php', '24.9', 0),
('096a1f78e9c362b62aacf3a5e3689348', './lib/core/Search/MySql/Table.php', '24.9', 0),
('c66090682c6d5f23e818a582a32dd84d', './lib/core/Search/MySql/TrackerFieldTranslator.php', '24.9', 0),
('80210ec5511f1eb05137da8a2031d61e', './lib/core/Search/MySql/TypeFactory.php', '24.9', 0),
('ba8afd0f372b9cebfe49bd61756eb4a5', './lib/core/Search/PackageSource/Interface.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/PackageSource/index.php', '24.9', 0),
('99fcf5924f9eea9fdd988014a1e8b55c', './lib/core/Search/Query.php', '24.9', 0),
('a35d62a9a120d071c60166189e602d68', './lib/core/Search/Query/Facet/Abstract.php', '24.9', 0),
('70c81804132339a763da6d2289da42d6', './lib/core/Search/Query/Facet/DateHistogram.php', '24.9', 0),
('ff2f8e333509b5930d8e6db92f67dc96', './lib/core/Search/Query/Facet/DateRange.php', '24.9', 0),
('10bc4b90ed40ed03f752048c6e83c30e', './lib/core/Search/Query/Facet/Interface.php', '24.9', 0),
('2762dc55012c9bd72cef014a677b6122', './lib/core/Search/Query/Facet/Term.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Search/Query/Facet/index.php', '24.9', 0),
('6ac5af459dcbf6624580412bbc5cb82e', './lib/core/Search/Query/FacetWikiBuilder.php', '24.9', 0),
('6c6a90a8c7c58ea25b4c9efdd60a69da', './lib/core/Search/Query/Interface.php', '24.9', 0),
('1955029155031e9c716ec49459b3be66', './lib/core/Search/Query/Order.php', '24.9', 0),
('2f3cd1e33e39f10b0de2cd054b46bc3e', './lib/core/Search/Query/Relation.php', '24.9', 0),
('89fdb65cf7f60ab50f604dabd7df5282', './lib/core/Search/Query/RelationReplacer.php', '24.9', 0),
('f5fc8bda041c6fc87aa214820602f67e', './lib/core/Search/Query/WeightCalculator/Field.php', '24.9', 0),
('45ebd399fae9c5963e92836b24eef698', './lib/core/Search/Query/WeightCalculator/Interface.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Search/Query/WeightCalculator/index.php', '24.9', 0),
('a0b3b4bf174f064c9c38b34c7b8dbd7f', './lib/core/Search/Query/WikiBuilder.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/Query/index.php', '24.9', 0),
('66334e2d7680b05ac184b761a028f61b', './lib/core/Search/ResultSet.php', '24.9', 0),
('af6e7e771776dfa2105d935b65035bb4', './lib/core/Search/ResultSet/FacetFilter.php', '24.9', 0),
('412abed1649e818293fe20835556ff05', './lib/core/Search/ResultSet/SnippetHelper.php', '24.9', 0),
('691aa176a0b4dd97589a3a59c662c1b8', './lib/core/Search/ResultSet/UrlHighlightTermsTransform.php', '24.9', 0),
('deab2f3a74ff31f5f20ced624a037129', './lib/core/Search/ResultSet/WikiBuilder.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/ResultSet/index.php', '24.9', 0),
('213728eb5009f6a69dc43656742e4e32', './lib/core/Search/Type/Analyzer.php', '24.9', 0),
('47b3d888a07b3bee54df06ecff5986ea', './lib/core/Search/Type/DateTime.php', '24.9', 0),
('729608bf1001ea6618619db75042f10d', './lib/core/Search/Type/Factory/Direct.php', '24.9', 0),
('ceb73858fd4693f27434bf5e8fbe6263', './lib/core/Search/Type/Factory/Interface.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Search/Type/Factory/index.php', '24.9', 0),
('14d67c63013d07e03ab9306dba585159', './lib/core/Search/Type/GeoPoint.php', '24.9', 0),
('ddbf5a57895a50fbb4d62be82c6de496', './lib/core/Search/Type/Interface.php', '24.9', 0),
('d779073b34bd3a753c26f77bcd75379b', './lib/core/Search/Type/Json.php', '24.9', 0),
('794b3bc491305f934d9331d797ff88b9', './lib/core/Search/Type/MultivaluePlain.php', '24.9', 0),
('82e81d1bb64e90950835fb580f511aaa', './lib/core/Search/Type/MultivalueText.php', '24.9', 0),
('39b1d014a02587c3be4c4896f0258cad', './lib/core/Search/Type/Nested.php', '24.9', 0),
('a29436c0c543d4f1f6afae861c64f72b', './lib/core/Search/Type/Numeric.php', '24.9', 0),
('ef75f0636e53f0a21f9ea8f2e8c77f00', './lib/core/Search/Type/Object.php', '24.9', 0),
('5c26efdc61527312f182b3c3f8063999', './lib/core/Search/Type/PlainMediumText.php', '24.9', 0),
('e0b5d638cddb9272422abb38fafd38bb', './lib/core/Search/Type/PlainShortText.php', '24.9', 0),
('36c79e1e4cc76c117a83ba5d17b059c4', './lib/core/Search/Type/PlainText.php', '24.9', 0),
('240543d07e082fd89519b248c5fd5157', './lib/core/Search/Type/ShortText.php', '24.9', 0),
('394ac921b3ab4eb102384b70b2fabd86', './lib/core/Search/Type/SimpleText.php', '24.9', 0),
('853ac79c16049806b23e6a3ff28ae727', './lib/core/Search/Type/Timestamp.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('a36c91708bc9686ab8e8781b5d7bc439', './lib/core/Search/Type/Whole.php', '24.9', 0),
('48f953152d4a5c6b9fe571e252fcfc4c', './lib/core/Search/Type/WikiText.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Search/Type/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Search/index.php', '24.9', 0),
('ac56152992a7e0b8d188a2f0994603a2', './lib/core/Sections.php', '24.9', 0),
('becd40a54f14e200de569ced48a0023f', './lib/core/Services/API/TokenController.php', '24.9', 0),
('a59f934b297c2fa6d73216a6b4e3ed55', './lib/core/Services/API/index.php', '24.9', 0),
('0ec73457402a0e6b0e0bb8e2e5c7c432', './lib/core/Services/Access/Controller.php', '24.9', 0),
('a59f934b297c2fa6d73216a6b4e3ed55', './lib/core/Services/Access/index.php', '24.9', 0),
('02023a94da96e92b9e247afafe5f2cd3', './lib/core/Services/ActivityStream/Controller.php', '24.9', 0),
('3cac553077297847333ff1243a189f16', './lib/core/Services/ActivityStream/ManageController.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/ActivityStream/index.php', '24.9', 0),
('1fe76074ebd1c0eed86df81512ea0bbe', './lib/core/Services/ApiBridge.php', '24.9', 0),
('81df8facbaf4a51a2a405404bfdfea47', './lib/core/Services/ApiClient.php', '24.9', 0),
('8a694c57225e49c29da8697eba45a6c3', './lib/core/Services/Article/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Article/index.php', '24.9', 0),
('cda48ff6f8f4364b1311032e5cbb5900', './lib/core/Services/Attribute/Controller.php', '24.9', 0),
('a59f934b297c2fa6d73216a6b4e3ed55', './lib/core/Services/Attribute/index.php', '24.9', 0),
('6cf6a025eed5971da27622df5ddbedd0', './lib/core/Services/AuthSource/Controller.php', '24.9', 0),
('13dd7879a8b43dd36370915adae16938', './lib/core/Services/AuthSource/OAuthController.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/AuthSource/index.php', '24.9', 0),
('4299a6ed344a2e81bf48fbf191f04ccd', './lib/core/Services/AutoSave/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/AutoSave/index.php', '24.9', 0),
('e8fb57c714149a26c892aa0407f4a7a7', './lib/core/Services/BigBlueButton/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/BigBlueButton/index.php', '24.9', 0),
('d05ba2ebe4f5d67a385fcc563e57f144', './lib/core/Services/Broker.php', '24.9', 0),
('04faadbf3faee63bdb42ae49b1cdcb97', './lib/core/Services/Calendar/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Calendar/index.php', '24.9', 0),
('64f7aace9692ddf65f363d4dda3f9fd3', './lib/core/Services/Category/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Category/index.php', '24.9', 0),
('7268b270ded53105cf310c29d53e452f', './lib/core/Services/Comment/AnnotationController.php', '24.9', 0),
('95e22a395693d7d3dbc8b96ac2ed478f', './lib/core/Services/Comment/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Comment/index.php', '24.9', 0),
('4b75387654866e3f495a06f1ec2ba499', './lib/core/Services/Connect/Client.php', '24.9', 0),
('2d769ca8ff06053da0e923d78a515585', './lib/core/Services/Connect/Server.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Connect/index.php', '24.9', 0),
('c9d746399c8c62b338cd5d5f2003a3fe', './lib/core/Services/ContentTemplate/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/ContentTemplate/index.php', '24.9', 0),
('11dcb8d89ef6583f0317b4aedfc45f7d', './lib/core/Services/CustomRoute/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/CustomRoute/index.php', '24.9', 0),
('b3db2aac934a9a1718a2eedf336587cd', './lib/core/Services/Cypht/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Cypht/index.php', '24.9', 0),
('87eb4b6b8d3a469aee1696469cd73d31', './lib/core/Services/Diagram/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Diagram/index.php', '24.9', 0),
('c9a0a8d6080ccb7253101224aa116a6d', './lib/core/Services/Draw/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Draw/index.php', '24.9', 0),
('dde971c06b3930ae6941cc950b774e44', './lib/core/Services/Edit/Controller.php', '24.9', 0),
('388a4bab02c6bccaf08e36795a4d4a76', './lib/core/Services/Edit/ListConverter.php', '24.9', 0),
('415088015a2117355948b50cf9781376', './lib/core/Services/Edit/ListPluginHelper.php', '24.9', 0),
('9a766fc23d9cbe2df943d269dcd8fc2e', './lib/core/Services/Edit/PluginController.php', '24.9', 0),
('b568ce8f5068fbd947bd00e7cdbe76ee', './lib/core/Services/Edit/SemaphoreController.php', '24.9', 0),
('7eb3be2ecb5bd436fdc980226dd20259', './lib/core/Services/Edit/Utilities.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Edit/index.php', '24.9', 0),
('f18fa920b2bb45aedd04b4e64cef5159', './lib/core/Services/Encryption/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Encryption/index.php', '24.9', 0),
('2c02b4a2375ed2e9998231d53bd6a480', './lib/core/Services/Exception.php', '24.9', 0),
('5bb05a349f39485c4c0c3e0ea3257395', './lib/core/Services/Exception/Denied.php', '24.9', 0),
('39d05b34d5e6b6d67ac7faa205f91ab3', './lib/core/Services/Exception/Disabled.php', '24.9', 0),
('a55f6d328db788219aeba22e915792d5', './lib/core/Services/Exception/DuplicateValue.php', '24.9', 0),
('c7aa61397a4e1d70e1988df5127ef32d', './lib/core/Services/Exception/EditConflict.php', '24.9', 0),
('c22ef0994477d23466d95473808043bf', './lib/core/Services/Exception/FieldError.php', '24.9', 0),
('bb90f39f3cd2d5df285e6024d6a093fc', './lib/core/Services/Exception/MissingValue.php', '24.9', 0),
('442942d57a8c8e41774b81587bf4b3ed', './lib/core/Services/Exception/NotAvailable.php', '24.9', 0),
('fe8e2b08c22a35068c54608c04cc157b', './lib/core/Services/Exception/NotFound.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Exception/index.php', '24.9', 0),
('02eba37da9f8de17949a2a80d8e2f460', './lib/core/Services/Export/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Export/index.php', '24.9', 0),
('57b46a736b51dae11b2e62d2fef474fe', './lib/core/Services/File/Controller.php', '24.9', 0),
('edda6244bd8e21f13d9c1cf2f74a3ba5', './lib/core/Services/File/FinderController.php', '24.9', 0),
('b1dd40a194632942b423b03672fdfa02', './lib/core/Services/File/Utilities.php', '24.9', 0),
('513c05a3773552288df8eb71ff5e47dd', './lib/core/Services/File/VimeoController.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/File/index.php', '24.9', 0),
('f648b68cdd2cbb3a0a6ffd1e41681d5d', './lib/core/Services/Forum/Controller.php', '24.9', 0),
('a59f934b297c2fa6d73216a6b4e3ed55', './lib/core/Services/Forum/index.php', '24.9', 0),
('fcb4ffedfb8b10bb2647759cda850db4', './lib/core/Services/Goal/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Goal/index.php', '24.9', 0),
('f49a30904d527e0f327fa32f07cc73b6', './lib/core/Services/Group/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Group/index.php', '24.9', 0),
('50eddb4ee1a8fc36cc3ee5ce2c4893b4', './lib/core/Services/H5P/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/H5P/index.php', '24.9', 0),
('55595ae9c6ec6169b0657bf30424d10d', './lib/core/Services/IDS/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/IDS/index.php', '24.9', 0),
('4fb6ff61f8cb9a205c9f5edf3af2f90a', './lib/core/Services/Kaltura/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Kaltura/index.php', '24.9', 0),
('51e28632d95a86b1f558712de2695f4f', './lib/core/Services/Language/Controller.php', '24.9', 0),
('c87898735140dd7c5c59b0a03c9fcf03', './lib/core/Services/Language/TransifexController.php', '24.9', 0),
('85695f09806f330af64e288cf459e7d1', './lib/core/Services/Language/TranslationController.php', '24.9', 0),
('d3e182d939d2a00cb043608d0f44944f', './lib/core/Services/Language/TranslationReader.php', '24.9', 0),
('51df33bbbaf211724cc8b738255277a6', './lib/core/Services/Language/Utilities.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Language/index.php', '24.9', 0),
('b8e77f721af244486e3dd0a40be673d0', './lib/core/Services/ML/Controller.php', '24.9', 0),
('a59f934b297c2fa6d73216a6b4e3ed55', './lib/core/Services/ML/index.php', '24.9', 0),
('905851f200c980280416a656dbd37436', './lib/core/Services/MailIn/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/MailIn/index.php', '24.9', 0),
('506c3c54c17bbd55985da535cc5692ac', './lib/core/Services/Menu/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Menu/index.php', '24.9', 0),
('31950c1b4afb1b2f5c27a86066d8dd7c', './lib/core/Services/Module/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Module/index.php', '24.9', 0),
('1bc7212563eb41dfcb0ca6c9d31ceb88', './lib/core/Services/MustRead/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/MustRead/index.php', '24.9', 0),
('d5144a6477f659a31ec565e058cbe5eb', './lib/core/Services/OAuthServer/Controller.php', '24.9', 0),
('e323b7eaf8af2021b884a0f04ea4d3e9', './lib/core/Services/OAuthServer/JsonResponse.php', '24.9', 0),
('af1470e0e22ebf81853c7e862f1150f1', './lib/core/Services/OAuthServer/Utilities.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/OAuthServer/index.php', '24.9', 0),
('34c342b0ad30a7e35d17b0ba06a9ae35', './lib/core/Services/Object/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Object/index.php', '24.9', 0),
('d8e4b5fe21ac88a8d1d4d8de086bdd5a', './lib/core/Services/PDF/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/PDF/index.php', '24.9', 0),
('7eeb4492c41198af032a50e995fd73d8', './lib/core/Services/Payment/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Payment/index.php', '24.9', 0),
('28177a53c48e9321e266d90dfe6e1e04', './lib/core/Services/Performance/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Performance/index.php', '24.9', 0),
('dae48f9f017704f89403278b01268f42', './lib/core/Services/Rating/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Rating/index.php', '24.9', 0),
('f48b7418448a0c4bdcd98ed2aa07eb1e', './lib/core/Services/Recommendation/DevelopmentController.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Recommendation/index.php', '24.9', 0),
('03cc9e17b9c57b4e05035ce27ca0e826', './lib/core/Services/RecordRtc/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/RecordRtc/index.php', '24.9', 0),
('36c8729ee795804ac7c59766b6fe2460', './lib/core/Services/Relation/Controller.php', '24.9', 0),
('a59f934b297c2fa6d73216a6b4e3ed55', './lib/core/Services/Relation/index.php', '24.9', 0),
('e7547114bb2b825db0cc2bbfdf6f1f30', './lib/core/Services/ResultLoader.php', '24.9', 0),
('31c242755156968463915f830e42cbeb', './lib/core/Services/ResultLoader/WebService.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/ResultLoader/index.php', '24.9', 0),
('6db7775464bd66e5d562c1413252b083', './lib/core/Services/Scheduler/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Scheduler/index.php', '24.9', 0),
('8097bfed31e6b2c5f90801d423720143', './lib/core/Services/Score/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Score/index.php', '24.9', 0),
('0df886bdbcec3682356f4f53dfab5eca', './lib/core/Services/Search/Controller.php', '24.9', 0),
('6c3cadf89a86db9e5fa9d72453386aae', './lib/core/Services/Search/CustomSearchController.php', '24.9', 0),
('ae55e80b040a55579da05412387af78f', './lib/core/Services/Search/ManifoldController.php', '24.9', 0),
('9f3503437e589fe968c54642eadfa252', './lib/core/Services/Search/StoredController.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Search/index.php', '24.9', 0),
('fcdc5ea5c61d7e6d6c95729a3697aca9', './lib/core/Services/ShowTikiOrg/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/ShowTikiOrg/index.php', '24.9', 0),
('d3bbcd405b312817e73213afa5ac3c3d', './lib/core/Services/StyleGuide/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/StyleGuide/index.php', '24.9', 0),
('8f7402f56698660e3928f29a72bba692', './lib/core/Services/Suite/Controller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Suite/index.php', '24.9', 0),
('c9fe46e95d43d3a81a97be40efd75c68', './lib/core/Services/Tracker/CalendarController.php', '24.9', 0),
('14c281446804835bf17a7549ea18b094', './lib/core/Services/Tracker/Controller.php', '24.9', 0),
('d3b78c82177863703dc6e795e73b7fab', './lib/core/Services/Tracker/DurationController.php', '24.9', 0),
('128d4f6c9cd0802607e2726c2bd2c63f', './lib/core/Services/Tracker/SyncController.php', '24.9', 0),
('ef4313a1c78723c2f10ef8c416a775fb', './lib/core/Services/Tracker/TabularController.php', '24.9', 0),
('f7a96a7a29b08bfcf496b0a62f95636a', './lib/core/Services/Tracker/TodoController.php', '24.9', 0),
('b025a839ec4f4d4144c6bff360c0498e', './lib/core/Services/Tracker/Utilities.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Tracker/index.php', '24.9', 0),
('8fa1c5e45ee9a8d064204ef9f9dc8e30', './lib/core/Services/User/ConditionsController.php', '24.9', 0),
('11d33038881b8d9bec8ad13a6fa6e5fb', './lib/core/Services/User/Controller.php', '24.9', 0),
('21934b2050f0706c5339382d6b02ef75', './lib/core/Services/User/FavoriteController.php', '24.9', 0),
('5c68b5076b1cfc31dede9ab267257dce', './lib/core/Services/User/MonitorController.php', '24.9', 0),
('72953e1d17759bcb07a0e152f5c16bee', './lib/core/Services/User/SocialController.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/User/index.php', '24.9', 0),
('07326241e8cd25b841a29d1510371f81', './lib/core/Services/Utilities.php', '24.9', 0),
('ea9b4eb149abf004f5e851448e8c0cc8', './lib/core/Services/Wiki/Controller.php', '24.9', 0),
('585b7113d2068f2f6ce897327194b683', './lib/core/Services/Wiki/StructureController.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Wiki/index.php', '24.9', 0),
('2c110c50de427f4c1271a5771cbe3c9c', './lib/core/Services/Workspace/Controller.php', '24.9', 0),
('089c051462f6fa7afbf322f8a5a7e6dc', './lib/core/Services/Workspace/ProfileAnalyser.php', '24.9', 0),
('30167c261f167fb51126ca771b417b99', './lib/core/Services/Workspace/ProfileBuilder.php', '24.9', 0),
('6821fc4d3728151c8f2fc001e38bcaf2', './lib/core/Services/Workspace/Utilities.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Services/Workspace/index.php', '24.9', 0),
('9b8f9fa16e7125c9db4db155bd533f0a', './lib/core/Services/Xmpp/Controller.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Services/Xmpp/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Services/index.php', '24.9', 0),
('efeeadb060277e6fc35d2d2fed296da5', './lib/core/Table/Check.php', '24.9', 0),
('1b02f080ee84bb190da25fa8eaa4ede4', './lib/core/Table/Code/Abstract.php', '24.9', 0),
('6c9aad2c83aebcccc9c4450a4669febb', './lib/core/Table/Code/Bind.php', '24.9', 0),
('ab89c57ea3816869dc1dff84bf2ea3fe', './lib/core/Table/Code/MainOptions.php', '24.9', 0),
('a2a49c26cb4a31626f84cbdf62216245', './lib/core/Table/Code/Manager.php', '24.9', 0),
('52093f0e400810258c36955f294e75c2', './lib/core/Table/Code/Other.php', '24.9', 0),
('9ff3a9e0e3ed60080aabd906406b87b3', './lib/core/Table/Code/WidgetOptions.php', '24.9', 0),
('d72e84c49fdf02740635c4f6521e9574', './lib/core/Table/Code/WidgetOptionsFilter.php', '24.9', 0),
('9cef2fcd9342e55e1edc3a7e6992df88', './lib/core/Table/Code/WidgetOptionsMath.php', '24.9', 0),
('fbacc812739793edb3741bc9444a8b65', './lib/core/Table/Code/WidgetOptionsOutput.php', '24.9', 0),
('baace69cf9d83d947c5bb1f9f1cdb619', './lib/core/Table/Code/WidgetOptionsPager.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Table/Code/index.php', '24.9', 0),
('b93d6af3ac466d15ae63f0969b936138', './lib/core/Table/Factory.php', '24.9', 0),
('aeb5cded068cde4626ee7f3d2c98e5f8', './lib/core/Table/Manager.php', '24.9', 0),
('d6ee9336e194f1946df8ee75beac2719', './lib/core/Table/Plugin.php', '24.9', 0),
('24c3e72fc4f22a8800c793223f3251ce', './lib/core/Table/Settings/Abstract.php', '24.9', 0),
('90dea65e07851c0d1628597d7347ec93', './lib/core/Table/Settings/Plugin.php', '24.9', 0),
('2c05097840b7217d5ad78fd31ed7a8bb', './lib/core/Table/Settings/PluginWithAjax.php', '24.9', 0),
('404410c015e896c02387afe064dfaf81', './lib/core/Table/Settings/Standard.php', '24.9', 0),
('bc7376fa3fa44b29e57e7dff8b05a9b2', './lib/core/Table/Settings/TikiAdminForums.php', '24.9', 0),
('12ae00d3c0d0c337529cfa2ec842888d', './lib/core/Table/Settings/TikiAdminGroups.php', '24.9', 0),
('3ddfc10e8a9ae7fb90215e5f3fce25c4', './lib/core/Table/Settings/TikiAdminGroupsBanned.php', '24.9', 0),
('93f4287281202cdc0ed704436e5e8165', './lib/core/Table/Settings/TikiAdminGroupsMembers.php', '24.9', 0),
('9b929e36e06eb44c2a58b387a0e50f61', './lib/core/Table/Settings/TikiAdminusers.php', '24.9', 0),
('c950e6678b05135963c01290a60ef0ee', './lib/core/Table/Settings/TikiForums.php', '24.9', 0),
('02285ac025fadbb0f503db66fbac4b2e', './lib/core/Table/Settings/TikiListpages.php', '24.9', 0),
('b43df56ee219de5f22a5c3faa7bab02b', './lib/core/Table/Settings/TikiPayment.php', '24.9', 0),
('efb02926f033684b5078fbbacd4a4d4f', './lib/core/Table/Settings/TikiPaymentPast.php', '24.9', 0),
('18ba14fc9eb64bdc99d5069c77da4b71', './lib/core/Table/Settings/TikiViewforum.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Table/Settings/index.php', '24.9', 0),
('7764516614ecc133489022c580f21e98', './lib/core/Table/Totals.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Table/index.php', '24.9', 0),
('2704bc84e961760f0b64c5dcda48bcb9', './lib/core/Tiki/Autoload.php', '24.9', 0),
('502e0f6a62920fa04c168b5dcfd04b70', './lib/core/Tiki/BigBlueButton/Configuration.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/BigBlueButton/index.php', '24.9', 0),
('5248e5ece79e2759fb6ed29a9d1e6e62', './lib/core/Tiki/Command/AdminIndexRebuildCommand.php', '24.9', 0),
('a0a3036b3826440d814f856acc15ea7a', './lib/core/Tiki/Command/Application.php', '24.9', 0),
('3714825e8a94e2f2634ba4d8153a15d2', './lib/core/Tiki/Command/BackupDBCommand.php', '24.9', 0),
('2ce2b625d8535383e4871fbc053078f2', './lib/core/Tiki/Command/BackupFilesCommand.php', '24.9', 0),
('54439f84c658265ab777da7e760b0c73', './lib/core/Tiki/Command/CacheClearCommand.php', '24.9', 0),
('6360e0d8a37ae98557677389fc24b6aa', './lib/core/Tiki/Command/CacheGenerateCommand.php', '24.9', 0),
('b8b38f408562da2aae6acdb4ef1947ec', './lib/core/Tiki/Command/CommandUnavailableException.php', '24.9', 0),
('4e4d0a54479b47854dbe3521918ce4fd', './lib/core/Tiki/Command/ConfigureCommand.php', '24.9', 0),
('628f1d11136a39d700752b3f07d3e999', './lib/core/Tiki/Command/ConsoleApplicationBuilder.php', '24.9', 0),
('d2f3db24f69c5bcc40f631a062be193e', './lib/core/Tiki/Command/ConsoleSetupException.php', '24.9', 0),
('087e6718790564ab8d71bf1a1cf8f0aa', './lib/core/Tiki/Command/CookiesClearCommand.php', '24.9', 0),
('875b4a5e0c219888af6ecc1b9500fa18', './lib/core/Tiki/Command/DailyReportSendCommand.php', '24.9', 0),
('4b2f6b5419818dd6f3b773fbf7fb2335', './lib/core/Tiki/Command/DevConfigureCommand.php', '24.9', 0),
('c9dab8c93abc74b4cad8178ea5a78f33', './lib/core/Tiki/Command/DevFixStyleCommand.php', '24.9', 0),
('713509082708e5b9ef37c312f1710777', './lib/core/Tiki/Command/DevUnInstallCommand.php', '24.9', 0),
('7c35f038afe16da3b2c6a05bf493133c', './lib/core/Tiki/Command/EnglishUpdateCommand.php', '24.9', 0),
('cb9dace15faf0427ef4ecd125806bc27', './lib/core/Tiki/Command/FakerCommentsCommand.php', '24.9', 0),
('9e09ae5a30ef43356b6a4d01a0be89a0', './lib/core/Tiki/Command/FakerTrackerCommand.php', '24.9', 0),
('484f35f80aff2589b569b777cf588baa', './lib/core/Tiki/Command/FileGallerySyncCommand.php', '24.9', 0),
('8d787263ab37f9cabdc1936678506d40', './lib/core/Tiki/Command/FilesBatchuploadCommand.php', '24.9', 0),
('03fa3f90b9cd936c0580036cd841f805', './lib/core/Tiki/Command/FilesCheckCommand.php', '24.9', 0),
('58bf2d9b757dcbeb2fce5a290615d684', './lib/core/Tiki/Command/FilesCopyCommand.php', '24.9', 0),
('7c99a33c6f22ea079de3634cc7afffb9', './lib/core/Tiki/Command/FilesDeleteoldCommand.php', '24.9', 0),
('f86e04c0af1e6ad937c832949b7f9035', './lib/core/Tiki/Command/FilesIndexCommand.php', '24.9', 0),
('b4a8f2f928c752b70b2d7609b3c9601d', './lib/core/Tiki/Command/FilesMoveCommand.php', '24.9', 0),
('b51066978af9c47d95691987e72c3c3c', './lib/core/Tiki/Command/FixBOMandUnixCommand.php', '24.9', 0),
('e3dcf190499380e1a03d65bb8c0afa92', './lib/core/Tiki/Command/FixSVNKeyIdsCommand.php', '24.9', 0),
('48d598121d7523fdfd980b981b96486e', './lib/core/Tiki/Command/GalleryMigrateCommand.php', '24.9', 0),
('71a3469803539362a0ca4e7710b099c6', './lib/core/Tiki/Command/GetStringsCommand.php', '24.9', 0),
('fb9e56f3e8f5776342950dfbfe59c18c', './lib/core/Tiki/Command/GoalCheckCommand.php', '24.9', 0),
('c539125f4a9890c6f10c2ea6afe0c165', './lib/core/Tiki/Command/IndexCatchUpCommand.php', '24.9', 0),
('c04313661ce0768ad8a3468d2ca4f614', './lib/core/Tiki/Command/IndexCleanupCommand.php', '24.9', 0),
('fca62a282a6197ccd58be4dd9dd023d9', './lib/core/Tiki/Command/IndexCompareEnginesCommand.php', '24.9', 0),
('d0f3fa885b833553653c8ea4f23929e5', './lib/core/Tiki/Command/IndexOptimizeCommand.php', '24.9', 0),
('88cb4116d8c1fb2dd1903303754eddb6', './lib/core/Tiki/Command/IndexRebuildCommand.php', '24.9', 0),
('96064e5c4176fe99c10c8ae1d1a234c1', './lib/core/Tiki/Command/InstallCommand.php', '24.9', 0),
('530a73a115cbf67c019e4968a4ae907d', './lib/core/Tiki/Command/InstallerLockCommand.php', '24.9', 0),
('f821b4e684c1df29d165bb86734564ec', './lib/core/Tiki/Command/ListExecuteCommand.php', '24.9', 0),
('168f7ce5a17e581bb88fbe2b72e341ff', './lib/core/Tiki/Command/MLTrainCommand.php', '24.9', 0),
('44a30fdc45b7cfb13e79ef4a473fb2e9', './lib/core/Tiki/Command/MailInPollCommand.php', '24.9', 0),
('c54af6d2845fdc7df1e47c6c949cf331', './lib/core/Tiki/Command/MailQueueSendCommand.php', '24.9', 0),
('0c13ce02f3c87d6615c8c76c3e56c539', './lib/core/Tiki/Command/MultiTikiListCommand.php', '24.9', 0),
('ea546124a3cd23fe0a723588af03ae1c', './lib/core/Tiki/Command/MultiTikiMoveCommand.php', '24.9', 0),
('ec6f6d476d318366ced3ec2b34f61a40', './lib/core/Tiki/Command/NotificationDigestCommand.php', '24.9', 0),
('a6cd1d9c7d03d89f71220fd0adcf35d5', './lib/core/Tiki/Command/OCRAllCommand.php', '24.9', 0),
('679f2a290ea6744cff05af1504b1c3b9', './lib/core/Tiki/Command/OCRFileCommand.php', '24.9', 0),
('adca4bc191197593d05cd0fde7a3be13', './lib/core/Tiki/Command/OCRSetCommand.php', '24.9', 0),
('84f9a3259d8a0c3c1d460c808befe2d7', './lib/core/Tiki/Command/OCRStatusCommand.php', '24.9', 0),
('f13f10811fea8d0e4bcf9cba2e962ae8', './lib/core/Tiki/Command/ObjectsNotifyMaintainersCommand.php', '24.9', 0),
('2caba1fdd5f4ff131626474ef3d6b887', './lib/core/Tiki/Command/PackageClearCacheCommand.php', '24.9', 0),
('f585aebb2fa561ddf099a010dfed9074', './lib/core/Tiki/Command/PackageDisableCommand.php', '24.9', 0),
('bbf16a5a155ba899c01576d25e45a182', './lib/core/Tiki/Command/PackageEnableCommand.php', '24.9', 0),
('18af06682585d90279588bfe6011b7a2', './lib/core/Tiki/Command/PackageInstallCommand.php', '24.9', 0),
('f22e716a46c5a94e61aeadf5e115e649', './lib/core/Tiki/Command/PackageListCommand.php', '24.9', 0),
('69ac40552eaf991727fa5e83f92588b8', './lib/core/Tiki/Command/PackageRemoveCommand.php', '24.9', 0),
('2dc145e7f5797f94f88618a36e9e476b', './lib/core/Tiki/Command/PackageUpdateCommand.php', '24.9', 0),
('cc4c0b97fbefa75a12547af0e6f929f0', './lib/core/Tiki/Command/PatchCommand.php', '24.9', 0),
('fc3859f8150d712ee54b052de347ea69', './lib/core/Tiki/Command/PerformanceCheckCommand.php', '24.9', 0),
('bd8b1cebad2f5959516294810d234033', './lib/core/Tiki/Command/PluginApproveRunCommand.php', '24.9', 0),
('f64802fdedaf61cb19b2f8e95a7bb806', './lib/core/Tiki/Command/PluginListRunCommand.php', '24.9', 0),
('ce82215ae2cfa91a31469f513eba0aa3', './lib/core/Tiki/Command/PluginRefreshRunCommand.php', '24.9', 0),
('3265f0ec8eb49671814f8d49ec46d825', './lib/core/Tiki/Command/PreferencesDeleteCommand.php', '24.9', 0),
('eaac3e2098efde4e73280fc0049042c8', './lib/core/Tiki/Command/PreferencesExportCommand.php', '24.9', 0),
('b6d235d8a0919ec058b37bacb9d020ca', './lib/core/Tiki/Command/PreferencesGetCommand.php', '24.9', 0),
('d4266b63e7b9b759d7b7313f6694a1d4', './lib/core/Tiki/Command/PreferencesSetCommand.php', '24.9', 0),
('0aeb9a3408c8dcab1b8fd390228a537f', './lib/core/Tiki/Command/ProfileBaselineCommand.php', '24.9', 0),
('ca0bbfeb61e7ac9ed8f5b0cfd3ff4fc5', './lib/core/Tiki/Command/ProfileExport/ActivityRuleSet.php', '24.9', 0),
('e71ed7af75627d48f7d717090d849b7c', './lib/core/Tiki/Command/ProfileExport/ActivityStreamRule.php', '24.9', 0),
('5b13e90471f85c5560063702a4aeaa1b', './lib/core/Tiki/Command/ProfileExport/AllModules.php', '24.9', 0),
('ee709d148fb3b3c2ca42f4632032d6db', './lib/core/Tiki/Command/ProfileExport/Article.php', '24.9', 0),
('878a1038cd8e31590ed80ce0888aaf9e', './lib/core/Tiki/Command/ProfileExport/ArticleTopic.php', '24.9', 0),
('916f3841cf07bc3060466be5a0b6bf38', './lib/core/Tiki/Command/ProfileExport/ArticleType.php', '24.9', 0),
('1b135c3f04496a5c0805e2509aef4f47', './lib/core/Tiki/Command/ProfileExport/Calendar.php', '24.9', 0),
('6d7deff1d0c44f58341799fcec7777b6', './lib/core/Tiki/Command/ProfileExport/Category.php', '24.9', 0),
('0630d755bcbc6068feeae7f3aa5efe7a', './lib/core/Tiki/Command/ProfileExport/FileGallery.php', '24.9', 0),
('f64da3499907abb6f46368e007272b2f', './lib/core/Tiki/Command/ProfileExport/Finalize.php', '24.9', 0),
('15b8ef1072d3dd628b90a9a6a2cf29a7', './lib/core/Tiki/Command/ProfileExport/Forum.php', '24.9', 0),
('be659c9930171fbd4d89a99778e7d784', './lib/core/Tiki/Command/ProfileExport/Goal.php', '24.9', 0),
('649e62c4e151a4eb86ac0e7770ea2bf2', './lib/core/Tiki/Command/ProfileExport/GoalSet.php', '24.9', 0),
('5addcf71ff54e12d1a5a1841da583cb0', './lib/core/Tiki/Command/ProfileExport/Group.php', '24.9', 0),
('f79b730014ef5026eaa799772041fbd0', './lib/core/Tiki/Command/ProfileExport/IncludeProfile.php', '24.9', 0),
('a510a9e4d4191333076df9f2a513fddb', './lib/core/Tiki/Command/ProfileExport/Init.php', '24.9', 0),
('fcb37f2251e7488aef0ccffceb6353d1', './lib/core/Tiki/Command/ProfileExport/Menu.php', '24.9', 0),
('d722e08eb7d12935c8de5934918f3ec6', './lib/core/Tiki/Command/ProfileExport/Module.php', '24.9', 0),
('7a761e2c6d79960af9631975eb733d16', './lib/core/Tiki/Command/ProfileExport/ObjectWriter.php', '24.9', 0),
('a2d8009ac484f6e31d26fae7e3f16752', './lib/core/Tiki/Command/ProfileExport/Preference.php', '24.9', 0),
('eaa2e1e6917278eb25e72eb70495cb63', './lib/core/Tiki/Command/ProfileExport/RatingConfig.php', '24.9', 0),
('1e601120d7865fe6af919f5a6e41bad5', './lib/core/Tiki/Command/ProfileExport/RatingConfigSet.php', '24.9', 0),
('a379b9ce1bf377fdda672730a67e60cb', './lib/core/Tiki/Command/ProfileExport/RecentChanges.php', '24.9', 0),
('463f6e268758de58524bbc39713378aa', './lib/core/Tiki/Command/ProfileExport/Rss.php', '24.9', 0),
('683860b60e3f0cf2962d6def223adc32', './lib/core/Tiki/Command/ProfileExport/Tracker.php', '24.9', 0),
('c13d7fb19f23cf6fa5f864bf2cd0adc3', './lib/core/Tiki/Command/ProfileExport/TrackerField.php', '24.9', 0),
('78d9c99b9be6778bfdd903562f3e2d5d', './lib/core/Tiki/Command/ProfileExport/TrackerItem.php', '24.9', 0),
('ea2da9f98a4a0114f2026f1ea643ccc3', './lib/core/Tiki/Command/ProfileExport/WikiPage.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Command/ProfileExport/index.php', '24.9', 0),
('3fc85b0e03092f6f134f0e606d5eab75', './lib/core/Tiki/Command/ProfileForgetCommand.php', '24.9', 0),
('e2b59640b2173dfad00aa8004f44ac58', './lib/core/Tiki/Command/ProfileInstallCommand.php', '24.9', 0),
('22e6ad6b311370abd629abb8ceccb077', './lib/core/Tiki/Command/RecommendationBatchCommand.php', '24.9', 0),
('7a80481dbee7160adf4834fe74a00417', './lib/core/Tiki/Command/RedactDBCommand.php', '24.9', 0),
('97b4ba296968e045f4fffd4e99e7937b', './lib/core/Tiki/Command/RefreshRssCommand.php', '24.9', 0),
('c93819dca284df0e1d7a2a34907ce5fe', './lib/core/Tiki/Command/RssClearCacheCommand.php', '24.9', 0),
('0c4c5dfee5fc62866a6c4513b229a7e9', './lib/core/Tiki/Command/SchedulerHealCommand.php', '24.9', 0),
('3f6f2f1382d9c13e400bda37c6c50b1d', './lib/core/Tiki/Command/SchedulerRunCommand.php', '24.9', 0),
('b8bdd7ffdb58a22055d035da3c09daa5', './lib/core/Tiki/Command/ScssCompileCommand.php', '24.9', 0),
('1fe0b82ecb789aee713dba5ef536c512', './lib/core/Tiki/Command/SemiAutoMergeCommand.php', '24.9', 0),
('56ac11e7c8cf4dd5967c804e7cfb06ce', './lib/core/Tiki/Command/SitemapGenerateCommand.php', '24.9', 0),
('b15a78c1991667a8bd01caed75be0cdb', './lib/core/Tiki/Command/StatsCommand.php', '24.9', 0),
('a14a01871f6e6c500d3965d58a85a715', './lib/core/Tiki/Command/ThemeInstallCommand.php', '24.9', 0),
('817e1ae50067975d60f440b51ca8667d', './lib/core/Tiki/Command/ThemeRemoveCommand.php', '24.9', 0),
('b9a253cbf0b7062639ea08d8c3eade4d', './lib/core/Tiki/Command/ThemeUpdateCommand.php', '24.9', 0),
('39ece3c01b15b91af7472c9780f0b6ce', './lib/core/Tiki/Command/TikiInfoCommand.php', '24.9', 0),
('8ab5604c8c1f7659610fc161495a6094', './lib/core/Tiki/Command/TokensClearCommand.php', '24.9', 0),
('3b782368c941ecd59611cafb49c3bea6', './lib/core/Tiki/Command/TrackerClearCommand.php', '24.9', 0),
('f9a8211fbae6f94edc166b462ba4575d', './lib/core/Tiki/Command/TrackerExportCommand.php', '24.9', 0),
('60300c20a90e7fc2b8c5be1a1d2bfaea', './lib/core/Tiki/Command/TrackerImportCommand.php', '24.9', 0),
('5520fdb47b85d3791f48ea1091a65220', './lib/core/Tiki/Command/TrackerRecalcCommand.php', '24.9', 0),
('c9d105680852505cbd49f44989e4c68f', './lib/core/Tiki/Command/TranslationExportCommand.php', '24.9', 0),
('be1b2421b9705aca5f5ae50f5ccfb212', './lib/core/Tiki/Command/TranslationPercentageCommand.php', '24.9', 0),
('c986fb37d44592c0733d9e2be09fcc2f', './lib/core/Tiki/Command/UpdateCommand.php', '24.9', 0),
('7e7b2d39c308d7ec4345feb8d1d64fec', './lib/core/Tiki/Command/UserCreateCommand.php', '24.9', 0),
('697fb637b4375352c20fdd5030889c94', './lib/core/Tiki/Command/UserUnlockCommand.php', '24.9', 0),
('44bde6094254fee46c43fdef740c3369', './lib/core/Tiki/Command/UsersListCommand.php', '24.9', 0),
('1a453459a6018b8cf340e25376f740c3', './lib/core/Tiki/Command/UsersPasswordCommand.php', '24.9', 0),
('5cc9bf2f1c80bfc139cd33b6277c4e4b', './lib/core/Tiki/Command/UsersTemporaryCommand.php', '24.9', 0),
('b4d344b5d005d94b1148a5c44728b75b', './lib/core/Tiki/Command/VCSUpdateCommand.php', '24.9', 0),
('7e9e6d29155528f90b0ed2152acab385', './lib/core/Tiki/Command/VendorSecurityCommand.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Command/index.php', '24.9', 0),
('fcf2e4e31e586afa1a779563d7b17678', './lib/core/Tiki/Composer/Autoload.php', '24.9', 0),
('10afb9a9b7a8080895565cbab1a03b69', './lib/core/Tiki/Composer/BootstrapCompiler.php', '24.9', 0),
('51459ca6f201c9eecc1c275c9667a3b4', './lib/core/Tiki/Composer/CleanVendorAfterVendorBundledMigration.php', '24.9', 0),
('11677061bc45315ff525451581d25031', './lib/core/Tiki/Composer/CleanVendors.php', '24.9', 0),
('05d714b4ff62dd4164f56feda81f0044', './lib/core/Tiki/Composer/PatchCypht.php', '24.9', 0),
('bf31a17f705e3499156e2ab9abfe1579', './lib/core/Tiki/Composer/RestoreVendors.php', '24.9', 0),
('07fadaec20b9df2daa10c456b5de45dd', './lib/core/Tiki/Composer/ThemeInstaller.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Composer/index.php', '24.9', 0),
('ffa4715ed4f15c0578f425c0428154e2', './lib/core/Tiki/Config/Ini.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Tiki/Config/index.php', '24.9', 0),
('2b8e07843222dd15b0d56b4f0b72942c', './lib/core/Tiki/Connect/Abstract.php', '24.9', 0),
('b02b8cf4c1d83c3ec1386fbcf93f9204', './lib/core/Tiki/Connect/Client.php', '24.9', 0),
('706546b3c013691ad67a6e2ca86b50e1', './lib/core/Tiki/Connect/Server.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Tiki/Connect/index.php', '24.9', 0),
('44f03dad2e635c53ec17320fbe75dae6', './lib/core/Tiki/Editable/Value.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Editable/index.php', '24.9', 0),
('3c192204b3948d22e9c6dce164b28af6', './lib/core/Tiki/Event/Chain.php', '24.9', 0),
('e1df9e7d624909a6fdac1824ec183b47', './lib/core/Tiki/Event/Customizer.php', '24.9', 0),
('093fe0fb5f3c74e0b0ad9098dabce2a5', './lib/core/Tiki/Event/Customizer/Executor.php', '24.9', 0),
('52732822e79404a58afa5a3ac7eb7424', './lib/core/Tiki/Event/Customizer/RuleSet.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Event/Customizer/index.php', '24.9', 0),
('5144c2b086a6c7bcc8a59bd367174f22', './lib/core/Tiki/Event/EdgeProvider.php', '24.9', 0),
('345221f7be94f92fdb2a1786470b0f0a', './lib/core/Tiki/Event/Function/EventLog.php', '24.9', 0),
('97948176464070e50e83845d1472c7a4', './lib/core/Tiki/Event/Function/EventNotify.php', '24.9', 0),
('967a53496aec3a2c702d26a3a64101c2', './lib/core/Tiki/Event/Function/EventRecord.php', '24.9', 0),
('a196d53313dde594380397954158d8a9', './lib/core/Tiki/Event/Function/EventSample.php', '24.9', 0),
('c59a5509256fd4e2f64464d119eb12f5', './lib/core/Tiki/Event/Function/EventTrigger.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Event/Function/index.php', '24.9', 0),
('c94886b368b775d15ac67086e5627ecd', './lib/core/Tiki/Event/Lib.php', '24.9', 0),
('b485dc4ea5710c78990ac99ac82524e5', './lib/core/Tiki/Event/Manager.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Tiki/Event/index.php', '24.9', 0),
('55c30948a4be52400eedba1eaef95c2b', './lib/core/Tiki/Faker.php', '24.9', 0),
('c3d9d96187762a95b4abcc0b57f569d9', './lib/core/Tiki/FileGallery/Definition.php', '24.9', 0),
('548ad464e9bbea9ed4589daf3dbb35db', './lib/core/Tiki/FileGallery/DirectMapping/EventHandler.php', '24.9', 0),
('7a7e00a53d8739dc2984bbf92ee4b497', './lib/core/Tiki/FileGallery/DirectMapping/Synchronizer.php', '24.9', 0),
('57ccc1c07b00a660a7772f6b6cf5f8d2', './lib/core/Tiki/FileGallery/DirectMapping/Utilities.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Tiki/FileGallery/DirectMapping/index.php', '24.9', 0),
('80adbeb66ded568a942d149e299e615f', './lib/core/Tiki/FileGallery/File.php', '24.9', 0),
('14da7d71fc7da55fe0f4bf2400aeaa9b', './lib/core/Tiki/FileGallery/FileDraft.php', '24.9', 0),
('8d081f73773257db474c65fc73d3c86c', './lib/core/Tiki/FileGallery/FileWrapper/FlysystemFile.php', '24.9', 0),
('827958aed233f71b3947b3ed69793209', './lib/core/Tiki/FileGallery/FileWrapper/PhysicalFile.php', '24.9', 0),
('b79ac0e3d94ea13473c60f59bc445e9f', './lib/core/Tiki/FileGallery/FileWrapper/PreloadedContent.php', '24.9', 0),
('ab0cea26cef9d19e20f416d4553558b9', './lib/core/Tiki/FileGallery/FileWrapper/WrapperInterface.php', '24.9', 0),
('6c079ae2d77c2fe01aed22eaf9288ec2', './lib/core/Tiki/FileGallery/FileWrapper/WriteException.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/FileGallery/FileWrapper/index.php', '24.9', 0),
('4ee81920c13af53c6c81e63ce6d919da', './lib/core/Tiki/FileGallery/Handler/AdapterNotFoundException.php', '24.9', 0),
('e60714afb5c8dbd25cf95c885a4b4a16', './lib/core/Tiki/FileGallery/Handler/FileSystem.php', '24.9', 0),
('489df0dc2235a97dd2009900a3bbd367', './lib/core/Tiki/FileGallery/Handler/Flysystem.php', '24.9', 0),
('602087ed2dbdba712979f7edbbcc6b9a', './lib/core/Tiki/FileGallery/Handler/HandlerInterface.php', '24.9', 0),
('ebae11de1f8e007f59e3bad4dc31533d', './lib/core/Tiki/FileGallery/Handler/Podcast.php', '24.9', 0),
('d6843515274f464cd41aefea60702f82', './lib/core/Tiki/FileGallery/Handler/Preloaded.php', '24.9', 0),
('88968033f983020a0061e6573869a8b8', './lib/core/Tiki/FileGallery/Handler/System.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/FileGallery/Handler/index.php', '24.9', 0),
('3b87d1a4577681c763e5631cedbba360', './lib/core/Tiki/FileGallery/Manipulator/EmailParser.php', '24.9', 0),
('da87aa71395933db2ecd2fb42fcd2344', './lib/core/Tiki/FileGallery/Manipulator/ImageTransformer.php', '24.9', 0),
('4e9fdc191e6eb058f8344083e2ff648a', './lib/core/Tiki/FileGallery/Manipulator/Manipulator.php', '24.9', 0),
('7b884abfa2df078962df0696bb603409', './lib/core/Tiki/FileGallery/Manipulator/MetadataExtractor.php', '24.9', 0),
('07dbbe06e75354ed6513b75be7f9f76d', './lib/core/Tiki/FileGallery/Manipulator/Validator.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Tiki/FileGallery/Manipulator/index.php', '24.9', 0),
('dfda55da27f33457ed4f1dde74068389', './lib/core/Tiki/FileGallery/SaveHandler.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Tiki/FileGallery/index.php', '24.9', 0),
('031b5935521e48decde3fa78daf6eb2a', './lib/core/Tiki/Files/AbstractCheckGallery.php', '24.9', 0),
('60fabbd6a131d859926bdfbd1c5d1e16', './lib/core/Tiki/Files/CheckAttachmentGallery.php', '24.9', 0),
('feec9fc8f0c50413a4c4f7c34f05cfb9', './lib/core/Tiki/Files/CheckFileGallery.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/Files/index.php', '24.9', 0),
('e8574b9b3c2d9db7376388205d1762c4', './lib/core/Tiki/Log.php', '24.9', 0),
('be46313e014bb4c902ca95974479898c', './lib/core/Tiki/MailIn/Account.php', '24.9', 0),
('53e46bfe11bb428fba66736373f7c522', './lib/core/Tiki/MailIn/Action/ActionInterface.php', '24.9', 0),
('6e1858013e026f2efe7c7f8d90961720', './lib/core/Tiki/MailIn/Action/ArticlePut.php', '24.9', 0),
('84115066cd6ced82a089146df22be3c8', './lib/core/Tiki/MailIn/Action/Comment.php', '24.9', 0),
('35204a86ce3d078ad2d0b976f1a96b59', './lib/core/Tiki/MailIn/Action/DirectFactory.php', '24.9', 0),
('7b3ee850aa5b6d97e919117ab6b87ab6', './lib/core/Tiki/MailIn/Action/FactoryInterface.php', '24.9', 0),
('35e2e3fb96b6451beb1d5a262853a631', './lib/core/Tiki/MailIn/Action/FilePut.php', '24.9', 0),
('bc82e702c2ca0717c83ae5b933c833a9', './lib/core/Tiki/MailIn/Action/RecipientPlaceholderFactory.php', '24.9', 0),
('d142d43ea7bfb76c312f8a96885ab644', './lib/core/Tiki/MailIn/Action/SubjectPrefixFactory.php', '24.9', 0),
('64fd632d71e717e9ec2fe04199b8df43', './lib/core/Tiki/MailIn/Action/Tracker.php', '24.9', 0),
('0bb711805ba7c2f0b75d865b825d5dc1', './lib/core/Tiki/MailIn/Action/WikiAppend.php', '24.9', 0),
('acd7962643cd751216aa2ad741b8159c', './lib/core/Tiki/MailIn/Action/WikiGet.php', '24.9', 0),
('3449073ab7a0e07b328465b63b67d533', './lib/core/Tiki/MailIn/Action/WikiPrepend.php', '24.9', 0),
('1d3048a07c8207d3d6a8ea0cecf7b9a8', './lib/core/Tiki/MailIn/Action/WikiPut.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/MailIn/Action/index.php', '24.9', 0),
('4425f419e91483d1269c90b3a5f1eded', './lib/core/Tiki/MailIn/Exception/MailInException.php', '24.9', 0),
('ac5fd20398e5c0bdac7ae42892348aa5', './lib/core/Tiki/MailIn/Exception/TransportException.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/MailIn/Exception/index.php', '24.9', 0),
('4959bf94b55b9bd3ab7dbe56539c8825', './lib/core/Tiki/MailIn/Provider/ArticlePutProvider.php', '24.9', 0),
('3f7c4d262e19f24ab4f9c68c90140bba', './lib/core/Tiki/MailIn/Provider/BasicWikiProvider.php', '24.9', 0),
('c4f9bc2325e5a62a7dc763ebe134a8a9', './lib/core/Tiki/MailIn/Provider/CompilerPass.php', '24.9', 0),
('b4886055590748ea34519df1a46a6129', './lib/core/Tiki/MailIn/Provider/FilePutProvider.php', '24.9', 0),
('f2809455b09e503744aafb9aa63117a9', './lib/core/Tiki/MailIn/Provider/ProviderInterface.php', '24.9', 0),
('dd844694410ffda6e6990c4b9a8dea7a', './lib/core/Tiki/MailIn/Provider/ProviderList.php', '24.9', 0),
('de8e67952cbe29404118b0cb03cf6171', './lib/core/Tiki/MailIn/Provider/ReplyHandlerProvider.php', '24.9', 0),
('67d59d99b26295c04175f8a795163ee2', './lib/core/Tiki/MailIn/Provider/TrackerProvider.php', '24.9', 0),
('2ec307e271e435dae8bdf4260fd9dd40', './lib/core/Tiki/MailIn/Provider/WikiMultipleProvider.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/MailIn/Provider/index.php', '24.9', 0),
('b1c6f294ae137724d3c13718be086cd5', './lib/core/Tiki/MailIn/Source/Imap.php', '24.9', 0),
('a883b51da8306dde468db4309d076d5f', './lib/core/Tiki/MailIn/Source/Message.php', '24.9', 0),
('f1f0aaa97db267b9187cc05118eb904a', './lib/core/Tiki/MailIn/Source/Pop3.php', '24.9', 0),
('adc325f401129391e9e5e1ea1b987aff', './lib/core/Tiki/MailIn/Source/SourceInterface.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/MailIn/Source/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/MailIn/index.php', '24.9', 0),
('e5f1bb4145d1879112fb4764dcfbff0d', './lib/core/Tiki/MemoryLimit.php', '24.9', 0),
('6877b393319d229c0020b26d4f8bb615', './lib/core/Tiki/ObjectSelector/Selector.php', '24.9', 0),
('73720b549958f04f53d359e84adda128', './lib/core/Tiki/ObjectSelector/SelectorItem.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/ObjectSelector/index.php', '24.9', 0),
('c18d78e3a3b52fd5f018eabf52f8eadc', './lib/core/Tiki/PSR12Migration/Autoload.php', '24.9', 0),
('8337ac85dd79deecf70f0e1c2281a12a', './lib/core/Tiki/PSR12Migration/Report.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/PSR12Migration/index.php', '24.9', 0),
('35469dbdd7069024291b5e2b5525ec0a', './lib/core/Tiki/Package/ComposerCli.php', '24.9', 0),
('d3abbb0275bf28775fc5fb0cc36b0652', './lib/core/Tiki/Package/ComposerManager.php', '24.9', 0),
('9f93d1390120e858b5ee35cd36c2c0e0', './lib/core/Tiki/Package/ComposerPackage.php', '24.9', 0),
('f7bcf8d871e93ecd83b49931127323e2', './lib/core/Tiki/Package/Extension/Api.php', '24.9', 0),
('fe1f59446e9c11c0cecd7aa8f767b45c', './lib/core/Tiki/Package/Extension/Api/Events.php', '24.9', 0),
('4f1f3f54b8b0609b26786fb5f7ec9fa3', './lib/core/Tiki/Package/Extension/Api/Search.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Package/Extension/Api/index.php', '24.9', 0),
('6c572c5d8f964f5e0ec0a2cfad5508ae', './lib/core/Tiki/Package/Extension/Extension.php', '24.9', 0),
('3175a9f6a427f8cdcabcda32af953067', './lib/core/Tiki/Package/Extension/Utilities.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Package/Extension/index.php', '24.9', 0),
('d3292e475af3f1daccf60a826586c811', './lib/core/Tiki/Package/ExtensionManager.php', '24.9', 0),
('7b18e17f3d9e04d1fd022fdf43a06b55', './lib/core/Tiki/Package/PackageCommandHelper.php', '24.9', 0),
('6bac451f53913c61289a179ea273e085', './lib/core/Tiki/Package/PackageInformationCache.php', '24.9', 0),
('17f9e267539aa2f302e53282e9f8fa23', './lib/core/Tiki/Package/VendorHelper.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/Package/index.php', '24.9', 0),
('ecac611db8c93124c2b8b6779135755f', './lib/core/Tiki/PageCache.php', '24.9', 0),
('5c37bfdd55b2ec89f674b86c945bcc1c', './lib/core/Tiki/Process/Process.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/Process/index.php', '24.9', 0),
('662bc134416433224b12d862429bef0e', './lib/core/Tiki/Profile.php', '24.9', 0),
('37510b730ea505abfcd924f75a8151b1', './lib/core/Tiki/Profile/ChannelList.php', '24.9', 0),
('728e0b24514247acd82c66d3c434ead8', './lib/core/Tiki/Profile/Converter.php', '24.9', 0),
('4f270bf85fecb175021ff6e34668feac', './lib/core/Tiki/Profile/DateConverter.php', '24.9', 0),
('a22eca3ad5e4cfdb12df6d5760eb058f', './lib/core/Tiki/Profile/InstallHandler.php', '24.9', 0),
('02033ca3f066d2f4269a829a27975717', './lib/core/Tiki/Profile/InstallHandler/ActivityRuleSet.php', '24.9', 0),
('dc9bb9e8ddbab70dfe65a3b7406a0ee9', './lib/core/Tiki/Profile/InstallHandler/ActivityStreamRule.php', '24.9', 0),
('6509d6ad20e54990aaa0a5d020acd16c', './lib/core/Tiki/Profile/InstallHandler/AreaBinding.php', '24.9', 0),
('3f6282e67e3e4395570710664d739c24', './lib/core/Tiki/Profile/InstallHandler/Article.php', '24.9', 0),
('41eb45c62b4c9ae623f07108ff347037', './lib/core/Tiki/Profile/InstallHandler/ArticleTopic.php', '24.9', 0),
('38ad846201e35501621979462e659af2', './lib/core/Tiki/Profile/InstallHandler/ArticleType.php', '24.9', 0),
('7987e6c6a3db2e90b6e371b41f5226ca', './lib/core/Tiki/Profile/InstallHandler/Blog.php', '24.9', 0),
('ffd64c8852d8cc05ed011083fdcb4873', './lib/core/Tiki/Profile/InstallHandler/BlogPost.php', '24.9', 0),
('7db369318ef24d225c7b8c4a26682e4a', './lib/core/Tiki/Profile/InstallHandler/Calendar.php', '24.9', 0),
('ac6efd4c3b25a259a4490b8ef7a2d6c0', './lib/core/Tiki/Profile/InstallHandler/Categorize.php', '24.9', 0),
('5b373bb9f06f567538238af13821d108', './lib/core/Tiki/Profile/InstallHandler/Category.php', '24.9', 0),
('d54c4d60403c270b8de4a10bc03636c9', './lib/core/Tiki/Profile/InstallHandler/DataChannel.php', '24.9', 0),
('79c9982dfa4c1db7ce6a9ccbe66a2a9a', './lib/core/Tiki/Profile/InstallHandler/ExtWiki.php', '24.9', 0),
('ea92c44edba9f5a4d4ee26b6501d0a66', './lib/core/Tiki/Profile/InstallHandler/FileGallery.php', '24.9', 0),
('c397addb16b8139baf06da44023b70c1', './lib/core/Tiki/Profile/InstallHandler/Forum.php', '24.9', 0),
('c7666cf498e16fc98dfcbd5665b2871b', './lib/core/Tiki/Profile/InstallHandler/Goal.php', '24.9', 0),
('dc95be4811f409a1c80ba4a18f2e5c38', './lib/core/Tiki/Profile/InstallHandler/GoalSet.php', '24.9', 0),
('952e994ea0d083bd25270ee7db038046', './lib/core/Tiki/Profile/InstallHandler/Menu.php', '24.9', 0),
('59474d37f27a58a5fe8d78bb10194f20', './lib/core/Tiki/Profile/InstallHandler/MenuOption.php', '24.9', 0),
('a127e76adb1ec77d7315ab3e24dc81f1', './lib/core/Tiki/Profile/InstallHandler/Module.php', '24.9', 0),
('ff3aa648622204627fb49a008f311719', './lib/core/Tiki/Profile/InstallHandler/Perspective.php', '24.9', 0),
('45d9ac7b43b1adebbee8331211b36c8c', './lib/core/Tiki/Profile/InstallHandler/PluginAlias.php', '24.9', 0),
('9f4e037026bdca39f1a706e962b93cfd', './lib/core/Tiki/Profile/InstallHandler/RatingConfig.php', '24.9', 0),
('b005b2d50dce136c23f45563018d6e58', './lib/core/Tiki/Profile/InstallHandler/RatingConfigSet.php', '24.9', 0),
('330d005832cf5631acd13eb7e3008f19', './lib/core/Tiki/Profile/InstallHandler/Rss.php', '24.9', 0),
('b847457e73512d2561c2e583b8484323', './lib/core/Tiki/Profile/InstallHandler/Scheduler.php', '24.9', 0),
('6f6627176272ab04ceb4c114f14d894a', './lib/core/Tiki/Profile/InstallHandler/Sheet.php', '24.9', 0),
('b90057a05ec452719fda53ecf5c9d92f', './lib/core/Tiki/Profile/InstallHandler/Template.php', '24.9', 0),
('c0c77160aa7e6544c49c1fba6e0416d6', './lib/core/Tiki/Profile/InstallHandler/Tracker.php', '24.9', 0),
('cb78b9e7536341c38bd1f59e9f239df0', './lib/core/Tiki/Profile/InstallHandler/TrackerField.php', '24.9', 0),
('8398affeeb40244e63c7cb839a1ab103', './lib/core/Tiki/Profile/InstallHandler/TrackerItem.php', '24.9', 0),
('da9032b47c617d1da2316a54bee08901', './lib/core/Tiki/Profile/InstallHandler/TrackerOption.php', '24.9', 0),
('a7e5a6833181c3b65389203f78220b6d', './lib/core/Tiki/Profile/InstallHandler/Transition.php', '24.9', 0),
('8e131c773257dca0a0fd11305c879b93', './lib/core/Tiki/Profile/InstallHandler/User.php', '24.9', 0),
('f3d91c65dbfeb155e4a0103d354b87ba', './lib/core/Tiki/Profile/InstallHandler/Webmail.php', '24.9', 0),
('c64d3277fdc807489b781e1496814154', './lib/core/Tiki/Profile/InstallHandler/Webservice.php', '24.9', 0),
('c0e36461522e3ebaa52c0be28b49663c', './lib/core/Tiki/Profile/InstallHandler/WebserviceTemplate.php', '24.9', 0),
('ec557b0196ff69d0f0925f2b82530415', './lib/core/Tiki/Profile/InstallHandler/WikiPage.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Profile/InstallHandler/index.php', '24.9', 0),
('8d35392900bdbd3b19c2d36348667325', './lib/core/Tiki/Profile/Installer.php', '24.9', 0),
('981265482db8da8e2c6818057cd5c725', './lib/core/Tiki/Profile/List.php', '24.9', 0),
('38783b429eaa35161aa170358c619bdc', './lib/core/Tiki/Profile/Object.php', '24.9', 0),
('04fb2ccc621d56b1f447ce2967519b60', './lib/core/Tiki/Profile/SymbolLoader.php', '24.9', 0),
('28207ea86399a66d5933294cefd689e3', './lib/core/Tiki/Profile/Transport/File.php', '24.9', 0),
('acb9c509c8d5bc920fcf8a24d6dae13e', './lib/core/Tiki/Profile/Transport/Interface.php', '24.9', 0),
('344b1fac5687e000d13701ee4c726771', './lib/core/Tiki/Profile/Transport/Local.php', '24.9', 0),
('60554f646946b1638b897fab832c3eb6', './lib/core/Tiki/Profile/Transport/Repository.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Profile/Transport/index.php', '24.9', 0),
('21579e0e7a4b6cd7a5f45e0ae4883dbb', './lib/core/Tiki/Profile/ValueMapConverter.php', '24.9', 0),
('19a792f065d65cdbf2905555563bc000', './lib/core/Tiki/Profile/Writer.php', '24.9', 0),
('6ba51377ce59e7492137f2d37b9adf14', './lib/core/Tiki/Profile/Writer/ExternalWriter.php', '24.9', 0),
('1b8000f1a564a90fd769e33613e994bc', './lib/core/Tiki/Profile/Writer/Helper.php', '24.9', 0),
('54f8bd05b61f1d1ccb0cca4d7968732a', './lib/core/Tiki/Profile/Writer/ProfileFinder.php', '24.9', 0),
('2c28820d88e010933a9b2d1f6aae4110', './lib/core/Tiki/Profile/Writer/Queue.php', '24.9', 0),
('114de2bdfc4803662363b95e2b93a018', './lib/core/Tiki/Profile/Writer/ReferenceProvider.php', '24.9', 0),
('a5bcdebd1d9e99e8feed0e8c0037b768', './lib/core/Tiki/Profile/Writer/SearchFieldHelper.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Profile/Writer/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Profile/index.php', '24.9', 0),
('2598985676aa7f1e1f36d455a51f7cd6', './lib/core/Tiki/Recommendation/BatchProcessor.php', '24.9', 0),
('8f58b99d43563cb981e723fd28fd8fcf', './lib/core/Tiki/Recommendation/Comparator.php', '24.9', 0),
('3c01fa97745a645d1d829ed8fabab284', './lib/core/Tiki/Recommendation/Debug/SourceDocument.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Recommendation/Debug/index.php', '24.9', 0),
('9b2750a27c67a825a5a22a3bccd06f38', './lib/core/Tiki/Recommendation/Engine/CompilerPass.php', '24.9', 0),
('261e45572e9dd2c3ca0e8e94f5e5c5d9', './lib/core/Tiki/Recommendation/Engine/EngineInterface.php', '24.9', 0),
('53cfa7f764b77e65d440e4c9e3322d35', './lib/core/Tiki/Recommendation/Engine/FakeEngine.php', '24.9', 0),
('93b5f21b00e5a7458f3f680e2f21c599', './lib/core/Tiki/Recommendation/Engine/UserFavorite.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Recommendation/Engine/index.php', '24.9', 0),
('a52135b59d8e394d228644fa5c7b492d', './lib/core/Tiki/Recommendation/EngineOutput.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('01b8dd81101f45e194652d076533068b', './lib/core/Tiki/Recommendation/EngineSet.php', '24.9', 0),
('a60a7bcb25b6c8b0129d73b1af445a66', './lib/core/Tiki/Recommendation/Input/UserInput.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Recommendation/Input/index.php', '24.9', 0),
('01703a48ac117859bd9ce2f36acc5d0f', './lib/core/Tiki/Recommendation/Recommendation.php', '24.9', 0),
('121261f186f2b68a95f73de41e805918', './lib/core/Tiki/Recommendation/RecommendationSet.php', '24.9', 0),
('d781dd80c738b1482e75d7393ab58491', './lib/core/Tiki/Recommendation/Store/ActivityStore.php', '24.9', 0),
('8e8ac0716211bcd3afb8ba1e5fd5a599', './lib/core/Tiki/Recommendation/Store/StoreInterface.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Recommendation/Store/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Recommendation/index.php', '24.9', 0),
('ddbabba5dd01118b2982f3f586e66ba5', './lib/core/Tiki/Render/Editable.php', '24.9', 0),
('08f5c9a377d00077777eb07277528d79', './lib/core/Tiki/Render/Lazy.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Render/index.php', '24.9', 0),
('77ed5c72fb5549c06ed923b3489f5000', './lib/core/Tiki/Request.php', '24.9', 0),
('71ae3095e866cb8a03676a7610e7275c', './lib/core/Tiki/SabreDav/AclPlugin.php', '24.9', 0),
('44f01b1072038869560f67ad195e0793', './lib/core/Tiki/SabreDav/AddressBookType/AddressBookTypeInterface.php', '24.9', 0),
('b173c8af5f88c1b8ec70646d94bae9d7', './lib/core/Tiki/SabreDav/AddressBookType/Custom.php', '24.9', 0),
('3a5f939b27d2c629a95500b4862bdc3e', './lib/core/Tiki/SabreDav/AddressBookType/Factory.php', '24.9', 0),
('bb2ca2ac4fd8bc0d34ed1e0afa8b54df', './lib/core/Tiki/SabreDav/AddressBookType/System.php', '24.9', 0),
('36f31ee3b398b54a0d496bae466e89b2', './lib/core/Tiki/SabreDav/AddressBookType/Webmail.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/core/Tiki/SabreDav/AddressBookType/index.php', '24.9', 0),
('78dd74a2f7e4254d651a2790c06ad65d', './lib/core/Tiki/SabreDav/BasicAuth.php', '24.9', 0),
('d06336238a68bd167b646f8f12b7bada', './lib/core/Tiki/SabreDav/CalDAVBackend.php', '24.9', 0),
('3eedc4b0b01a4896e3601fdb50590903', './lib/core/Tiki/SabreDav/CardDAVBackend.php', '24.9', 0),
('c729933b36c90df1ad7d2ce69d5ec7cb', './lib/core/Tiki/SabreDav/Directory.php', '24.9', 0),
('bfffe5880b8b216d294545cefead59b7', './lib/core/Tiki/SabreDav/File.php', '24.9', 0),
('f473628e69a70c739d605453bf8d29c1', './lib/core/Tiki/SabreDav/LocksBackend.php', '24.9', 0),
('76754445230d5a708e21396159c0ec91', './lib/core/Tiki/SabreDav/PrincipalBackend.php', '24.9', 0),
('bb42e37efaa9668acf6fc2798c640d6b', './lib/core/Tiki/SabreDav/Utilities.php', '24.9', 0),
('a60bc76aa68f783c8586e6c56ca7ed5f', './lib/core/Tiki/SabreDav/WikiDirectory.php', '24.9', 0),
('2ac6ecca19c79fbf7f97f18dda056f36', './lib/core/Tiki/SabreDav/WikiPage.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/SabreDav/index.php', '24.9', 0),
('9ffef60c30e9228f4c42338a30fa7fff', './lib/core/Tiki/Security.php', '24.9', 0),
('0ef5c72371aeed4b4adb01f1bc866c22', './lib/core/Tiki/Sitemap/AbstractType.php', '24.9', 0),
('dd64f69fd5cfdbc541bbfccbc1d3a966', './lib/core/Tiki/Sitemap/Generator.php', '24.9', 0),
('2dc535d4370809c090f7d1cc1c5bbb2f', './lib/core/Tiki/Sitemap/Type/Articles.php', '24.9', 0),
('4042124b9ce91cb7c4cc81868a79e8e5', './lib/core/Tiki/Sitemap/Type/Blog.php', '24.9', 0),
('ee3fc87ad6b2dc476d20adc6a391d182', './lib/core/Tiki/Sitemap/Type/Forums.php', '24.9', 0),
('645be78d88a74730cfb44d1620f56305', './lib/core/Tiki/Sitemap/Type/Page.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Sitemap/Type/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Sitemap/index.php', '24.9', 0),
('7fe8d4f5b4e5f2cc827721346164a1b1', './lib/core/Tiki/Suggestion/Helpers/Community.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Suggestion/Helpers/index.php', '24.9', 0),
('dbfe315034b945eb95829b8d62b2f76a', './lib/core/Tiki/Suggestion/Performance/Informations.php', '24.9', 0),
('81d2e00c1a866991538004c3bb6daef7', './lib/core/Tiki/Suggestion/Performance/NumberFiles.php', '24.9', 0),
('0e75bf04ef640564bbce5bdf30c8ebe2', './lib/core/Tiki/Suggestion/Performance/NumberTrackers.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Suggestion/Performance/index.php', '24.9', 0),
('66672755074a07438fb7718d92aad258', './lib/core/Tiki/Suggestion/Rules.php', '24.9', 0),
('337127c34a0db273cd1edd9722aaba2b', './lib/core/Tiki/Suggestion/SuggestionRulesInterface.php', '24.9', 0),
('ec65ef31f363522e701bb7ef48911257', './lib/core/Tiki/Suggestion/TikiCheck/Version.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Suggestion/TikiCheck/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Suggestion/index.php', '24.9', 0),
('a3a5b16ca59b6b545d50de3ffe430dcf', './lib/core/Tiki/Theme/Handler.php', '24.9', 0),
('eac9eb0545dbec8f8cc670cba11c8bb9', './lib/core/Tiki/Theme/Menu.php', '24.9', 0),
('2a94db44a38b4f26bbd8b3c3b82c6c84', './lib/core/Tiki/Theme/Module.php', '24.9', 0),
('6c5572294399654829f459a61d45993b', './lib/core/Tiki/Theme/ThemeInstaller.php', '24.9', 0),
('00fc45ead43a5838935125841c57125c', './lib/core/Tiki/Theme/Zip.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/Theme/index.php', '24.9', 0),
('19db55a03cc2159cd595ef2800d02fc2', './lib/core/Tiki/TikiInit.php', '24.9', 0),
('d585a6dc496a378313e3dca6764b8164', './lib/core/Tiki/TimeLimit.php', '24.9', 0),
('14470938aae12b7c80acc7425f4423fa', './lib/core/Tiki/Transition.php', '24.9', 0),
('e65458cf6ac28e748d7ba769b15029f8', './lib/core/Tiki/Url.php', '24.9', 0),
('d5218a20e469b7f66b968637666d8c0d', './lib/core/Tiki/Version/Checker.php', '24.9', 0),
('becd9f5796fcb2e46b02059ac18c0ff1', './lib/core/Tiki/Version/Upgrade.php', '24.9', 0),
('423dd542aa30c8f69873bfe215a3507a', './lib/core/Tiki/Version/Utils.php', '24.9', 0),
('1cbcbd56dad654d7a64888ebefc25237', './lib/core/Tiki/Version/Version.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Version/index.php', '24.9', 0),
('1a82ea017e25dd9088c480960964e3f6', './lib/core/Tiki/Wiki/SlugManager.php', '24.9', 0),
('5c67bc6178e81927e733f1078968992d', './lib/core/Tiki/Wiki/SlugManager/CompilerPass.php', '24.9', 0),
('1f3efdf67fca12131ff26b738fe1fcdb', './lib/core/Tiki/Wiki/SlugManager/DashGenerator.php', '24.9', 0),
('90c4b3bd277b181269bb22eca5f58854', './lib/core/Tiki/Wiki/SlugManager/Generator.php', '24.9', 0),
('f02f78cd4bf12e3f302018b84a4cc6ae', './lib/core/Tiki/Wiki/SlugManager/InMemoryTracker.php', '24.9', 0),
('662d972bddd160aa96e3f3b20a9b669c', './lib/core/Tiki/Wiki/SlugManager/UnderscoreGenerator.php', '24.9', 0),
('c3f51b5dafebc6006d520131bef3204e', './lib/core/Tiki/Wiki/SlugManager/UrlencodeGenerator.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tiki/Wiki/SlugManager/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tiki/Wiki/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Tiki/index.php', '24.9', 0),
('a3490d6165c38e4d3be863f35904bbf3', './lib/core/TikiDb.php', '24.9', 0),
('ce853f406cf56cc1021ca37474e0a66e', './lib/core/TikiDb/Adodb.php', '24.9', 0),
('5ce34c03a1bfad3a58cd3be42495fc86', './lib/core/TikiDb/Bridge.php', '24.9', 0),
('418ceef884b1e8100495fc67197e4eae', './lib/core/TikiDb/ErrorHandler.php', '24.9', 0),
('eeb9f071a4d911d72114030f233f69fb', './lib/core/TikiDb/Exception.php', '24.9', 0),
('f5fd5b6ff04e3bde129a0e6b2dfdee3c', './lib/core/TikiDb/Exception/DuplicateEntry.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/TikiDb/Exception/index.php', '24.9', 0),
('4438d0aeab0dc9a180420d1017415944', './lib/core/TikiDb/Expr.php', '24.9', 0),
('d51f68e4751a5d819bdcd9a5f341640b', './lib/core/TikiDb/Initializer.php', '24.9', 0),
('c700d7e21ddf9bb3e584e0247116ddac', './lib/core/TikiDb/Initializer/Adodb.php', '24.9', 0),
('5ce1f51dee28f88999fdfcdcbb488208', './lib/core/TikiDb/Initializer/Pdo.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/TikiDb/Initializer/index.php', '24.9', 0),
('d202913be6f6ec4dd592be224898e1f3', './lib/core/TikiDb/MasterSlaveDispatch.php', '24.9', 0),
('a982cf4789e887fb814a02d59075c0d5', './lib/core/TikiDb/Pdo.php', '24.9', 0),
('7691583bb12e1be8aed0b85ed005e598', './lib/core/TikiDb/SanitizeEncoding.php', '24.9', 0),
('fcaf5c265b651afdebe308e51faa2b53', './lib/core/TikiDb/Table.php', '24.9', 0),
('2ca673fed40350dc68c4e2ef3387b5b3', './lib/core/TikiDb/Transaction.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/TikiDb/index.php', '24.9', 0),
('8a35553115c83e59c4383558a6046163', './lib/core/TikiFilter.php', '24.9', 0),
('e067c0a73b6029a0a27140bd7a1df268', './lib/core/TikiFilter/Alnum.php', '24.9', 0),
('5583738f70497befa7004d0651b5eccb', './lib/core/TikiFilter/Alpha.php', '24.9', 0),
('a6a2a7a722ed6ed14dea2b51c4090688', './lib/core/TikiFilter/AttributeType.php', '24.9', 0),
('8eda14aac23ff689e7df2e572f668bcf', './lib/core/TikiFilter/Callback.php', '24.9', 0),
('9ea02bc491515cd493a6bf87cf93542f', './lib/core/TikiFilter/HtmlPurifier.php', '24.9', 0),
('e4e4118830281e7d2a0ce1185e4fd6b8', './lib/core/TikiFilter/IsoDate.php', '24.9', 0),
('4e4c516519cdaba015afc1f665af6db3', './lib/core/TikiFilter/Lang.php', '24.9', 0),
('17f10751dabeb7d6ba337ef2e43569cd', './lib/core/TikiFilter/None.php', '24.9', 0),
('9b84f2603075e4ff2152699a040ece64', './lib/core/TikiFilter/PregFilter.php', '24.9', 0),
('962f82625cac034af6ea9ac1c7d5377b', './lib/core/TikiFilter/PrepareInput.php', '24.9', 0),
('82ce0ad0e18d3b1ffe9c610826d3ea92', './lib/core/TikiFilter/PreventXss.php', '24.9', 0),
('887c5b259202057f28ae9cfbf3ea743d', './lib/core/TikiFilter/RawUnsafe.php', '24.9', 0),
('8e774a592343e555c77396036b294d9b', './lib/core/TikiFilter/RelativeURL.php', '24.9', 0),
('0dc6b892af4242d55ef7aae8acbaad3f', './lib/core/TikiFilter/WikiContent.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/TikiFilter/index.php', '24.9', 0),
('371e6e82cab8f001717e53756cdc2d21', './lib/core/Tracker/CompilerPass.php', '24.9', 0),
('41a22f4dc255abe4fa3ed9a986536914', './lib/core/Tracker/Definition.php', '24.9', 0),
('8f13cdc83b8311c76589b8f48c1c044b', './lib/core/Tracker/Field/Abstract.php', '24.9', 0),
('d1cad68a17aacba7ede28667594d0d7b', './lib/core/Tracker/Field/Action.php', '24.9', 0),
('e0bfdaccb1cd7b6d8fd59096592f5084', './lib/core/Tracker/Field/Articles.php', '24.9', 0),
('22936c007c71297734b87a4129c04a55', './lib/core/Tracker/Field/AutoIncrement.php', '24.9', 0),
('bbb0d3634aa8d072fbadc640a82cd4dd', './lib/core/Tracker/Field/CalendarItem.php', '24.9', 0),
('fcb2d317d5afa2de6a4dd564ea02fc69', './lib/core/Tracker/Field/Category.php', '24.9', 0),
('0cdade4abbd9e0a973cbbd3a094a70c2', './lib/core/Tracker/Field/Checkbox.php', '24.9', 0),
('738b1cb4553b4d60b548d6466411312d', './lib/core/Tracker/Field/Computed.php', '24.9', 0),
('e2272802cde2338eaa6c2786bd96c56b', './lib/core/Tracker/Field/CountrySelector.php', '24.9', 0),
('362313c2f90bcc2c19b10658e5dccaa8', './lib/core/Tracker/Field/Currency.php', '24.9', 0),
('bfa8354073ff1d23285e66da6617b7fc', './lib/core/Tracker/Field/DateTime.php', '24.9', 0),
('90ff8912631f4ac5fc38bb459a5e72ee', './lib/core/Tracker/Field/Dropdown.php', '24.9', 0),
('e33388f4719b16e4e112b6c3d595e1aa', './lib/core/Tracker/Field/Duration.php', '24.9', 0),
('34f768a2b45da67048f439d51483567f', './lib/core/Tracker/Field/DynamicList.php', '24.9', 0),
('7ed7e50742420e50b7a8629b12f40c6c', './lib/core/Tracker/Field/Email.php', '24.9', 0),
('6d03cb3e2ad3ca750dee6d921038c537', './lib/core/Tracker/Field/EmailFolder.php', '24.9', 0),
('0ea2f2e55b366cabd4e97cec4f65256b', './lib/core/Tracker/Field/Exportable.php', '24.9', 0),
('83151aeabf772a5111e9c8300092acb1', './lib/core/Tracker/Field/Factory.php', '24.9', 0),
('7821f52d5fb9c3873e76be4ae7d9d1fc', './lib/core/Tracker/Field/File.php', '24.9', 0),
('b68128673cd4b28572e0a2a747ad2300', './lib/core/Tracker/Field/Files.php', '24.9', 0),
('d4630e5441aa1097ccecc9b3cfa0465a', './lib/core/Tracker/Field/Filterable.php', '24.9', 0),
('410786d9128431b896be5f023d68afe9', './lib/core/Tracker/Field/Freetags.php', '24.9', 0),
('57b304cdaf4960a0aa90d5fd6d205cb3', './lib/core/Tracker/Field/GeographicFeature.php', '24.9', 0),
('e0e2bc0983e1a8727f47e487d76883f2', './lib/core/Tracker/Field/GroupSelector.php', '24.9', 0),
('b1c83c15adb54634f6f9d14f9954ca79', './lib/core/Tracker/Field/Header.php', '24.9', 0),
('a786fa6b335c229723658f6a56387b6b', './lib/core/Tracker/Field/Icon.php', '24.9', 0),
('719f36b304ed98f50ff4568264491c2b', './lib/core/Tracker/Field/Image.php', '24.9', 0),
('a032f6890df651a8e7acd481024bee4f', './lib/core/Tracker/Field/InGroup.php', '24.9', 0),
('cbce9fad30a0521222967c239694414d', './lib/core/Tracker/Field/Indexable.php', '24.9', 0),
('aaef7d8b54ab11600eb2ae955cffef47', './lib/core/Tracker/Field/Interface.php', '24.9', 0),
('c2b82d03f6a654720f30a7ccb004cab4', './lib/core/Tracker/Field/Ip.php', '24.9', 0),
('436b96170e7e1d1ef2f62a33f3491a1c', './lib/core/Tracker/Field/ItemLink.php', '24.9', 0),
('72dfc4d381a2c7ac40e80b4e36b600f0', './lib/core/Tracker/Field/ItemsList.php', '24.9', 0),
('7ecfc870c272bda7fa174c9c09ae0798', './lib/core/Tracker/Field/JsCalendar.php', '24.9', 0),
('4bf0979538040b1fdfd8fcdb6c18d50e', './lib/core/Tracker/Field/Kaltura.php', '24.9', 0),
('06817b9ac3f6ec5f5d82908b45aa12de', './lib/core/Tracker/Field/Language.php', '24.9', 0),
('10ade85e9a4fb91e3fce147aa5d273ad', './lib/core/Tracker/Field/Ldap.php', '24.9', 0),
('4bd3cd605f75ba783ff58f931c4e0d5b', './lib/core/Tracker/Field/Location.php', '24.9', 0),
('f853d6284766d5d28e7c2959db1b86fe', './lib/core/Tracker/Field/Math.php', '24.9', 0),
('a94a3368b6449ea36e33bf5b197bfc6a', './lib/core/Tracker/Field/Numeric.php', '24.9', 0),
('cb041cd4663deae5f1a9a24e4b419a87', './lib/core/Tracker/Field/PageSelector.php', '24.9', 0),
('00e6b7fe5637b043703ac81ffc5f2442', './lib/core/Tracker/Field/Rating.php', '24.9', 0),
('507bbf56f4f784af8f3147d3f9b1a22f', './lib/core/Tracker/Field/Relation.php', '24.9', 0),
('46628c61229cbfa97bc23c3c1804359c', './lib/core/Tracker/Field/ShowTikiOrg.php', '24.9', 0),
('c40e0e1b1b6b0db8ac5ac74be6d7e64a', './lib/core/Tracker/Field/StaticText.php', '24.9', 0),
('8d3c0f4c690b8f1cc9f7b3fce8d9e0ca', './lib/core/Tracker/Field/Synchronizable.php', '24.9', 0),
('1dc3e69390f8500f450215b93685fea8', './lib/core/Tracker/Field/Text.php', '24.9', 0),
('cf9129736d394ea68bd83cfd3957c8e5', './lib/core/Tracker/Field/TextArea.php', '24.9', 0),
('3b1ae3650da01a0beec08d55719582b1', './lib/core/Tracker/Field/Url.php', '24.9', 0),
('ffa0ff222c2b240a41e719b16fc97b14', './lib/core/Tracker/Field/UserGroups.php', '24.9', 0),
('3b140a6c80dc4e4db834b6b8c00b2f1d', './lib/core/Tracker/Field/UserPreference.php', '24.9', 0),
('bea0d9da0cd050bc163ed9c3bd0e3e78', './lib/core/Tracker/Field/UserSelector.php', '24.9', 0),
('9eec4a148359bc2bcdf27952c352ab79', './lib/core/Tracker/Field/UserSubscription.php', '24.9', 0),
('5af351afc5f6d7ecd59fc80b4857d2f9', './lib/core/Tracker/Field/WebService.php', '24.9', 0),
('9f875aed583c0817336caedb856cff20', './lib/core/Tracker/Field/Wiki.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Tracker/Field/index.php', '24.9', 0),
('c29d6c7fa65db232cbe59aefe1c0d23b', './lib/core/Tracker/Filter/Collection.php', '24.9', 0),
('1c8fae6c14ced828d119ba00e1ddbb03', './lib/core/Tracker/Filter/Control/Control.php', '24.9', 0),
('eb90dea38d9207c05763b8b7d5575da8', './lib/core/Tracker/Filter/Control/CurrencyRange.php', '24.9', 0),
('438ce4cd94f2592dae6fb32a1a451522', './lib/core/Tracker/Filter/Control/DateRange.php', '24.9', 0),
('f6aab0e9059851cbd135bdee83ff6bdb', './lib/core/Tracker/Filter/Control/DropDown.php', '24.9', 0),
('f68258c0b9548851b2f5cf44bb1faeb3', './lib/core/Tracker/Filter/Control/InlineCheckboxes.php', '24.9', 0),
('9ecec9f52f0f5d4bd10e82fd0d0a8a77', './lib/core/Tracker/Filter/Control/MultiSelect.php', '24.9', 0),
('949ed9fe67b74f7c2193edf222d0eb90', './lib/core/Tracker/Filter/Control/NumericRange.php', '24.9', 0),
('3e0369173d69c4ca4c74dde53478c415', './lib/core/Tracker/Filter/Control/ObjectSelector.php', '24.9', 0),
('d0e95f5c2937d3d5ccbf69090d8748c1', './lib/core/Tracker/Filter/Control/TextField.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Filter/Control/index.php', '24.9', 0),
('f15fda57b34d7fe126e2b5b9088a5c13', './lib/core/Tracker/Filter/Exception/Exception.php', '24.9', 0),
('04d809dad619a53f3c3efa6a122ed1d4', './lib/core/Tracker/Filter/Exception/FieldNotFound.php', '24.9', 0),
('7d696af018470505bd7cbc12d3ef2144', './lib/core/Tracker/Filter/Exception/ModeNotSupported.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Filter/Exception/index.php', '24.9', 0),
('30ad8c801f111563259bef398402cdeb', './lib/core/Tracker/Filter/Filter.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Filter/index.php', '24.9', 0),
('3694255f71d2b906f0747cb66fa997e8', './lib/core/Tracker/Item.php', '24.9', 0),
('fd1f42e370d9cbc37d7d40d20ece2c56', './lib/core/Tracker/Options.php', '24.9', 0),
('ed53f690260e19bc0c73a7f9bc0fc7a8', './lib/core/Tracker/Query.php', '24.9', 0),
('74f5a1992b32f8d9b41851133fcf8209', './lib/core/Tracker/Rule/Action/Action.php', '24.9', 0),
('5ee857734c5731159bc60eab3401c852', './lib/core/Tracker/Rule/Action/Editable.php', '24.9', 0),
('4d1de1211e2b1e329ade711d15780541', './lib/core/Tracker/Rule/Action/Hide.php', '24.9', 0),
('029e9a10a52320996739ea0d0d597b33', './lib/core/Tracker/Rule/Action/NoOp.php', '24.9', 0),
('2132920a970e028748b2faabf778b1d6', './lib/core/Tracker/Rule/Action/NotEditable.php', '24.9', 0),
('7cbaedb823bbadee329144b23618c67c', './lib/core/Tracker/Rule/Action/NotRequired.php', '24.9', 0),
('25a331cebaad7c430bc9fcc7c974ff2d', './lib/core/Tracker/Rule/Action/Required.php', '24.9', 0),
('5b2fe3cdcf416e51189cd64a4436130d', './lib/core/Tracker/Rule/Action/SetValue.php', '24.9', 0),
('3509a4edff1f5b372b466e860c023696', './lib/core/Tracker/Rule/Action/Show.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/core/Tracker/Rule/Action/index.php', '24.9', 0),
('f607853277cf1166d309138bbcb7d542', './lib/core/Tracker/Rule/Column.php', '24.9', 0),
('bad5857ae680df30cf1c6ad97d1472da', './lib/core/Tracker/Rule/Definition.php', '24.9', 0),
('c47587456b4533d2d0b24b38919eb0ba', './lib/core/Tracker/Rule/LogicalType/All.php', '24.9', 0),
('04eee6cd71ebf468c5418b65d7c09053', './lib/core/Tracker/Rule/LogicalType/Any.php', '24.9', 0),
('dce8c5967554aecba51b8fdf9473ac5d', './lib/core/Tracker/Rule/LogicalType/LogicalType.php', '24.9', 0),
('16dbd93a097f498aa77a321e6b105a24', './lib/core/Tracker/Rule/LogicalType/None.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/core/Tracker/Rule/LogicalType/index.php', '24.9', 0),
('6d906d81a3d9425a77ab676db287101a', './lib/core/Tracker/Rule/Operator/BooleanTrueFalse.php', '24.9', 0),
('8f849c25cd6bcd3428c46364de52b821', './lib/core/Tracker/Rule/Operator/CollectionContains.php', '24.9', 0),
('f3c58f21d9a2c8158481360d53a8a5b0', './lib/core/Tracker/Rule/Operator/CollectionContainsUsername.php', '24.9', 0),
('d4d4720e740596a99acdab90035835f6', './lib/core/Tracker/Rule/Operator/CollectionEmpty.php', '24.9', 0),
('dd7af3b31286fcb42ef4a6d2c66d1ccf', './lib/core/Tracker/Rule/Operator/CollectionNotContains.php', '24.9', 0),
('59c4de5a0ef33a23f5c4c80a720c6e8f', './lib/core/Tracker/Rule/Operator/CollectionNotEmpty.php', '24.9', 0),
('414e1b51c7384e35c984ff8f8d7c3587', './lib/core/Tracker/Rule/Operator/DateTimeAfter.php', '24.9', 0),
('56767db6f8b6f4d85ed5766411a3c774', './lib/core/Tracker/Rule/Operator/DateTimeBefore.php', '24.9', 0),
('5fd86d802681bcf9d90a2a06abfd0dcb', './lib/core/Tracker/Rule/Operator/DateTimeOn.php', '24.9', 0),
('bae4905c912863cc22abdfd3bf30df8a', './lib/core/Tracker/Rule/Operator/NumberEquals.php', '24.9', 0),
('c4a5fc3cc10dea3e80f572ee68e3b637', './lib/core/Tracker/Rule/Operator/NumberGreaterThan.php', '24.9', 0),
('64ac902ba6018a7251f79ba95a1fb462', './lib/core/Tracker/Rule/Operator/NumberLessThan.php', '24.9', 0),
('2a032277b717da42eb8bceb77d8d5c00', './lib/core/Tracker/Rule/Operator/NumberNotEquals.php', '24.9', 0),
('d643b945dd1b563cbd3ea349159bd431', './lib/core/Tracker/Rule/Operator/Operator.php', '24.9', 0),
('526d01ca5aa9b3fb48cc73025150974b', './lib/core/Tracker/Rule/Operator/TextContains.php', '24.9', 0),
('1f174090cbb30ada28aaea05891b5b60', './lib/core/Tracker/Rule/Operator/TextEquals.php', '24.9', 0),
('f971e9d61cf69d4b8cdb3c028e973adf', './lib/core/Tracker/Rule/Operator/TextIsEmpty.php', '24.9', 0),
('915b52ca9a0f4e3663de1bbcd9493a8f', './lib/core/Tracker/Rule/Operator/TextIsNotEmpty.php', '24.9', 0),
('b6b5a3524911a10042b498a7dc9c9ddc', './lib/core/Tracker/Rule/Operator/TextIsUsername.php', '24.9', 0),
('8a072b841742094ace9c91287f20d455', './lib/core/Tracker/Rule/Operator/TextNotContains.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/core/Tracker/Rule/Operator/index.php', '24.9', 0),
('39c15be3852b9f1914f689534f542574', './lib/core/Tracker/Rule/Rules.php', '24.9', 0),
('be80f6c352b405a852516e89591e581b', './lib/core/Tracker/Rule/Target/Field.php', '24.9', 0),
('0de514f8793f73dc665aef2e0fdb4821', './lib/core/Tracker/Rule/Target/NoTarget.php', '24.9', 0),
('e6246bb308cc3d30818e2dfb6f115edc', './lib/core/Tracker/Rule/Target/Target.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/core/Tracker/Rule/Target/index.php', '24.9', 0),
('dee444145a4140dd29d41c7b815829d7', './lib/core/Tracker/Rule/Type/Boolean.php', '24.9', 0),
('38099f5b322d62486d8d970b93f8cdd9', './lib/core/Tracker/Rule/Type/Collection.php', '24.9', 0),
('82323d8ae242c77175b23666c5d187f3', './lib/core/Tracker/Rule/Type/DateTime.php', '24.9', 0),
('3c74664c505f018e224f2dd12217007d', './lib/core/Tracker/Rule/Type/Field.php', '24.9', 0),
('053d7ed783883283195caa5ca92f1eda', './lib/core/Tracker/Rule/Type/Nothing.php', '24.9', 0),
('85aed5a7fa136b079d93a5ea47234ef3', './lib/core/Tracker/Rule/Type/Number.php', '24.9', 0),
('36588169c3bfaa7f27bf55872a762ff2', './lib/core/Tracker/Rule/Type/Status.php', '24.9', 0),
('f962d0c392d996eafce7fe9fe245253a', './lib/core/Tracker/Rule/Type/Text.php', '24.9', 0),
('cfb45ac4ac036f808367ac1e4fd48709', './lib/core/Tracker/Rule/Type/Type.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/core/Tracker/Rule/Type/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/core/Tracker/Rule/index.php', '24.9', 0),
('499794dad0f7198241925207642ccea4', './lib/core/Tracker/Tabular/Exception/Exception.php', '24.9', 0),
('3134565fe0569072c49d06b5c4799195', './lib/core/Tracker/Tabular/Exception/FieldNotFound.php', '24.9', 0),
('a1e7f2073252ecec37f57fe12eafdf91', './lib/core/Tracker/Tabular/Exception/ModeNotSupported.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Tabular/Exception/index.php', '24.9', 0),
('02f4db80500db520126fea72d38c6ad2', './lib/core/Tracker/Tabular/Manager.php', '24.9', 0),
('21f1d0154fb439a8b3c31f64165019d6', './lib/core/Tracker/Tabular/ODBCManager.php', '24.9', 0),
('6e6dfbc554093f31de575202313bfdca', './lib/core/Tracker/Tabular/Schema.php', '24.9', 0),
('7c4e3da974511da287e4f40bbd3ce00d', './lib/core/Tracker/Tabular/Schema/CachedLookupHelper.php', '24.9', 0),
('5d1eab98271bfa1172067810b255e8a1', './lib/core/Tracker/Tabular/Schema/Column.php', '24.9', 0),
('8ea46765e0bccfc88a447a3cfe28e437', './lib/core/Tracker/Tabular/Schema/DateHelper.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Tabular/Schema/index.php', '24.9', 0),
('32d894cdb56e75aab087396e5e692132', './lib/core/Tracker/Tabular/Source/AutoDetectCsvSource.php', '24.9', 0),
('577a262d953317a24413b5dc04cbc57a', './lib/core/Tracker/Tabular/Source/CsvSource.php', '24.9', 0),
('973e090b7a4ad3a10d7f162f054de026', './lib/core/Tracker/Tabular/Source/CsvSourceEntry.php', '24.9', 0),
('c0726e71ce520702fb2744c03fd2798b', './lib/core/Tracker/Tabular/Source/ODBCSource.php', '24.9', 0),
('3c1361475d68dad1c775d42765a5a0e5', './lib/core/Tracker/Tabular/Source/ODBCSourceEntry.php', '24.9', 0),
('9690369e86ced796ce855c17a744388d', './lib/core/Tracker/Tabular/Source/PaginatedQuerySource.php', '24.9', 0),
('ebdaf71dd50b7312ada85c05ede546ca', './lib/core/Tracker/Tabular/Source/QuerySource.php', '24.9', 0),
('d610e7b86b0861050f15a92e85f36987', './lib/core/Tracker/Tabular/Source/QuerySourceEntry.php', '24.9', 0),
('d4ee29aefd6736880aa4e4e585460f54', './lib/core/Tracker/Tabular/Source/SourceEntryInterface.php', '24.9', 0),
('d9b4efcb0babdcebf64a0f797a06880a', './lib/core/Tracker/Tabular/Source/SourceInterface.php', '24.9', 0),
('e588b453d498065d3e0664baae21cf6b', './lib/core/Tracker/Tabular/Source/TrackerSource.php', '24.9', 0),
('e97e0dcf4640c4234fa517b3aca3cd23', './lib/core/Tracker/Tabular/Source/TrackerSourceEntry.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Tabular/Source/index.php', '24.9', 0),
('12130515821a58f2c66d0066cfe75751', './lib/core/Tracker/Tabular/Writer/CsvWriter.php', '24.9', 0),
('37ee5b51074a71e87d389006427d3828', './lib/core/Tracker/Tabular/Writer/HtmlWriter.php', '24.9', 0),
('497058252ec97d1eecfaf402578554a2', './lib/core/Tracker/Tabular/Writer/ODBCWriter.php', '24.9', 0),
('6e02a69dde9e3c8ed6b05b082eea0b37', './lib/core/Tracker/Tabular/Writer/TrackerWriter.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Tabular/Writer/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/Tracker/Tabular/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Tracker/index.php', '24.9', 0),
('06f3e2607b1903befe7edc048f75371b', './lib/core/WikiParser/OutputLink.php', '24.9', 0),
('c4aa63d9f35c2caccc08d595433c9d2e', './lib/core/WikiParser/Parsable.php', '24.9', 0),
('2bf1bc78e9dba1c386b35885d3357233', './lib/core/WikiParser/PluginArgumentParser.php', '24.9', 0),
('d0a729db73870135f03ad8c91d493760', './lib/core/WikiParser/PluginDefinition.php', '24.9', 0),
('b2715a30cf926a1803b1e8c23d545f13', './lib/core/WikiParser/PluginMatcher.php', '24.9', 0),
('cf1c9ff5f5c977d3bf59fec8ca450d79', './lib/core/WikiParser/PluginOutput.php', '24.9', 0),
('9cedb992badf022b6a3568bd14f0299b', './lib/core/WikiParser/PluginParser.php', '24.9', 0),
('45ad736a6e044e8702b62b643fc9312c', './lib/core/WikiParser/PluginRepository.php', '24.9', 0),
('9f9d76a9316deee873a94a84c7a12565', './lib/core/WikiParser/PluginRunner.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/WikiParser/index.php', '24.9', 0),
('47b3d73ae1adaa19f33c745a2cb166e2', './lib/core/WikiPlugin/Casperjs/Render.php', '24.9', 0),
('346caa6f4f5b7d6d05e1081e94d1a9dd', './lib/core/WikiPlugin/Casperjs/Result.php', '24.9', 0),
('ff38c6ffa3b3c9754a76c848863814eb', './lib/core/WikiPlugin/Casperjs/Runner.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/WikiPlugin/Casperjs/index.php', '24.9', 0),
('3bfbd9a7b4b31eef85a6c1e5dee485bc', './lib/core/WikiPlugin/Helper.php', '24.9', 0),
('58e5c7082c5129b5e9b04888adb6f3e5', './lib/core/WikiPlugin/Negotiator/Wiki.php', '24.9', 0),
('db1284845aa880c9429850c50235e53e', './lib/core/WikiPlugin/Negotiator/Wiki/Alias.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/WikiPlugin/Negotiator/Wiki/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/WikiPlugin/Negotiator/index.php', '24.9', 0),
('6e7f1841f98dccaf9df101c56083de57', './lib/core/WikiPlugin/Reference.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/WikiPlugin/index.php', '24.9', 0),
('635f99c85a686341f0584338aef333e4', './lib/core/Yaml/Directive/DirectiveInclude.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Yaml/Directive/index.php', '24.9', 0),
('d9fefe4d9b681b8b283bbb1e21fe3a63', './lib/core/Yaml/Directives.php', '24.9', 0),
('4a7dca7f9d496a46250c99d97cd18577', './lib/core/Yaml/Filter/FilterInterface.php', '24.9', 0),
('f0d80150f9d2c8da6d15be4a6ac90adc', './lib/core/Yaml/Filter/ReplaceUserData.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/core/Yaml/Filter/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/core/Yaml/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/core/index.php', '24.9', 0),
('9bbc46aa7ae491f22df6aa0c117531a9', './lib/credits/creditslib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/credits/index.php', '24.9', 0),
('fd50a6ecaafe5a897650798b112d7fc8', './lib/crypt/cryptlib.php', '24.9', 0),
('422f11df7e99c2c4e32ad29dd16ec8fc', './lib/crypt/encryptionlib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/crypt/index.php', '24.9', 0),
('d41f4f2dadef2caf29feb929d171be0e', './lib/csslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/cypht/index.php', '24.9', 0),
('fae63e4b1910e94a0b3c0fe51cce665f', './lib/cypht/integration/classes.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/cypht/integration/index.php', '24.9', 0),
('f9a6f49a9a6328c96ea7b34636a9a7f7', './lib/cypht/jquery.touch.js', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/cypht/modules/index.php', '24.9', 0),
('e8c3963e33f81d7901998698bcb0092a', './lib/cypht/modules/tiki/calendar_modules.php', '24.9', 0),
('f0d9f23722cf23460f95c7e6d67308d4', './lib/cypht/modules/tiki/functions.php', '24.9', 0),
('142019bbcd40da5a0fbf0ffafa2a8f81', './lib/cypht/modules/tiki/general_modules.php', '24.9', 0),
('a18da923824cafd213dee5935435b142', './lib/cypht/modules/tiki/groupmail_modules.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/cypht/modules/tiki/index.php', '24.9', 0),
('68c71197cbc7a78aa7c83a2b7e64b254', './lib/cypht/modules/tiki/modules.php', '24.9', 0),
('4ae86aa6ac3fdfb496f7adca7f301e95', './lib/cypht/modules/tiki/setup.php', '24.9', 0),
('8d68e9724cb5cd2919dba4b039ef59e8', './lib/cypht/modules/tiki/site.css', '24.9', 0),
('c5155eec5be891963a0d7bf9b315c0bb', './lib/cypht/modules/tiki/site.js', '24.9', 0),
('abca6bb7c8b74b74b3b4352ee426a8cf', './lib/cypht/modules/tiki/tracker_modules.php', '24.9', 0),
('fb7b3f40a3e5687b55585cfe8976471f', './lib/cypht/site.css', '24.9', 0),
('e25131468a798899884963d211850b80', './lib/cypht/site.js', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/db/index.php', '24.9', 0),
('8405b63f4c9c81767d00837bd5eaf35f', './lib/db/tiki_registration_fields.php', '24.9', 0),
('7dbbe00f3414cb6056f7e94ac847696a', './lib/dcs/dcslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/dcs/index.php', '24.9', 0),
('c00b52d8e0be7c8194cb06334861d42e', './lib/debug/Tracer.php', '24.9', 0),
('7690cf1edb07c9b5a68f30b266eeee10', './lib/debug/debug-command_dmsg.php', '24.9', 0),
('843668edc257be509ce0db9cd87cd9e4', './lib/debug/debug-command_features.php', '24.9', 0),
('a449f3f9e5c8a408fcf68b617ef63233', './lib/debug/debug-command_perm.php', '24.9', 0),
('ae112513d3afd7d94cdaa3ea5bda1ab1', './lib/debug/debug-command_print.php', '24.9', 0),
('d7cd7038276b3057060d991747b3d688', './lib/debug/debug-command_slist.php', '24.9', 0),
('f7abd03c4d08d3d35c04bc25d63fba46', './lib/debug/debug-command_sprint.php', '24.9', 0),
('686c65ec536aafe89a87b6265882fcc0', './lib/debug/debug-command_sql.php', '24.9', 0),
('25a70fde90260cf1bd434dbb4b75ad99', './lib/debug/debug-command_test.php', '24.9', 0),
('f1fea1030c14837e3a3667e2bcc0af91', './lib/debug/debug-command_tikitables.php', '24.9', 0),
('655b3f07a934dadeaad4fce73cd9b3ab', './lib/debug/debug-command_watch.php', '24.9', 0),
('c64c26f5cbbf5aff95559f87a135fbd1', './lib/debug/debugger-common.php', '24.9', 0),
('d39253376a0f54adc71c5a765faff68a', './lib/debug/debugger-ext.php', '24.9', 0),
('290330549a466b38e90aea0db2681ed8', './lib/debug/debugger.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/debug/index.php', '24.9', 0),
('51facb9bf5ff9d6907a65b869d3a39b6', './lib/diff.php', '24.9', 0),
('a375dc5518788ee6563c9e5b6abd4b13', './lib/diff/Diff.php', '24.9', 0),
('67d75f99e28a93b21a3c4eaee3c553b1', './lib/diff/Renderer.php', '24.9', 0),
('e85ce9f47a24df3d7f328d49fd187f6f', './lib/diff/difflib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/diff/index.php', '24.9', 0),
('8b31e9ee9fead2dcb1aa711d44ad06b5', './lib/diff/renderer_bytes.php', '24.9', 0),
('99e405a03ba087cebae04e59056b5945', './lib/diff/renderer_character.php', '24.9', 0),
('9fb3dc2d809f35dd57c695c3c65a8b79', './lib/diff/renderer_character_inline.php', '24.9', 0),
('1cd3c13e0b683fd282f931a541e8f541', './lib/diff/renderer_htmldiff.php', '24.9', 0),
('5354faf4cd5013dd6c8eeef4864d85aa', './lib/diff/renderer_inline.php', '24.9', 0),
('42a562038cbe4a975ffe75f02ab3da9f', './lib/diff/renderer_sidebyside.php', '24.9', 0),
('e3d41dbf8e561967ba68d73349849df9', './lib/diff/renderer_unified.php', '24.9', 0),
('7a4a6b0e07f01b3d754fb55f67bc0777', './lib/directory/dirlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/directory/index.php', '24.9', 0),
('7e524f8e5ab0921701e77fde1af8ec03', './lib/dracula/graffle.js', '24.9', 0),
('cda12bc010f54bc2b47e6feba1466a6c', './lib/dracula/graph.js', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/dracula/index.php', '24.9', 0),
('8b1b503c7e881b85379888e7d9c39873', './lib/dracula/raphael-min.js', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/encoding/index.php', '24.9', 0),
('2ec4b89919b3c60a201b65944910e419', './lib/encoding/lib-encoding.php', '24.9', 0),
('71c14ccabc694cd294907af24a8cb16e', './lib/enforce_php_version_constraints.php', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/equation/index.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/equation/pictures/index.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/equation/tmp/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/events/index.php', '24.9', 0),
('2b9f4df9aaffa90c87b384c8e47d3301', './lib/faqs/faqlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/faqs/index.php', '24.9', 0),
('144f189f90ff033eac67daa291007e63', './lib/featured_links/flinkslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/featured_links/index.php', '24.9', 0),
('ed9798c7b65086fa65aad89e7768f5bf', './lib/filegals/filegalbatchlib.php', '24.9', 0),
('96ab26b071403a3966c4a272c38f93c0', './lib/filegals/filegalcopylib.php', '24.9', 0),
('fedea49a9886ed383c94541e4eb1da84', './lib/filegals/filegallib.php', '24.9', 0),
('148704e8505864422da7cfff80f9f32d', './lib/filegals/h5plib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/filegals/index.php', '24.9', 0),
('5647610cf1730c4756548c735e067c7c', './lib/filegals/max_upload_size.php', '24.9', 0),
('fd967cbc28ba98812cf884376adfaf50', './lib/filegals/scormlib.php', '24.9', 0),
('b283cf6e9b89354d84bcefbd9215d735', './lib/filegals/vimeolib.php', '24.9', 0),
('7b9b589980b6fe654f09c3ebd12bdcfd', './lib/freetag/freetaglib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/freetag/index.php', '24.9', 0),
('cb8a9b1ef71c50348820a3857d6f9b24', './lib/geo/geolib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/geo/index.php', '24.9', 0),
('8739b2af323c5e6ff951d4a5373cf1d4', './lib/gitlib.php', '24.9', 0),
('5dd6e2f8cff553e252dae1149be0dde3', './lib/goal/eventlib.php', '24.9', 0),
('a1bf9c949f5f5f171d1d2d953326a0a8', './lib/goal/goallib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/goal/index.php', '24.9', 0),
('391e184f6155af77a09e1dece7569662', './lib/goal/rewardlib.php', '24.9', 0),
('8465dc1482a2824eecc1c19e06581bd6', './lib/graph-engine/abstract.gridbased.php', '24.9', 0),
('820085948f276cb8fc1fbc7340a08beb', './lib/graph-engine/core.php', '24.9', 0),
('4bf84c8a12dfa9bbcb724a1853f70460', './lib/graph-engine/gd.php', '24.9', 0),
('fa4fa69a0d8bbaa69403010e16a1b735', './lib/graph-engine/graph.bar.php', '24.9', 0),
('ebbc1e140999aefa8509a01e51bd8414', './lib/graph-engine/graph.multiline.php', '24.9', 0),
('4b23f806d0f2489fb8b1cc20c398002a', './lib/graph-engine/graph.pie.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/graph-engine/index.php', '24.9', 0),
('4eead6515a85153e32eec60143f355f9', './lib/graph-engine/pdflib.php', '24.9', 0),
('d8150b6607a61395b356bd187b751be0', './lib/graph-engine/ps.php', '24.9', 0),
('d1f19988eb71837423d2bab237878bde', './lib/groupalert/groupalertlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/groupalert/index.php', '24.9', 0),
('2bafff18f54164b6bcc88c03a918bb3f', './lib/headerlib.php', '24.9', 0),
('08c2b9a711f91cffe2d2121244443ddc', './lib/hotwords/hotwordlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/hotwords/index.php', '24.9', 0),
('d3d5a61a29d3d87b5c764aa93e5db928', './lib/htmlpages/htmlpageslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/htmlpages/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/htmlparser/index.php', '24.9', 0),
('c64987c061d674fd2ad420cee6545664', './lib/htmlparser/rebuildgrammar.php', '24.9', 0),
('9f2ad36709fa028d4b89da13afb842af', './lib/htmlpurifier_tiki/HTMLPurifier.tiki.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/htmlpurifier_tiki/index.php', '24.9', 0),
('17eab260a115111d640cadf8db4a2f8b', './lib/ical/File.php', '24.9', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/ical/iCal/Parser/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/ical/iCal/index.php', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/ical/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/importer/index.php', '24.9', 0),
('51583c87b45d759cb2d85e2ebcbf129f', './lib/importer/tikiimporter.php', '24.9', 0),
('42a4adab3870d95de514b5453497561e', './lib/importer/tikiimporter_blog.php', '24.9', 0),
('e12a777d1ae45f6a199f7d27405cb6a4', './lib/importer/tikiimporter_blog_wordpress.php', '24.9', 0),
('b74595537bd532ac26df3fa48b73bcb5', './lib/importer/tikiimporter_wiki.php', '24.9', 0),
('36eaccacdef0f5a610277fc1aa64e29f', './lib/importer/tikiimporter_wiki_mediawiki.php', '24.9', 0),
('47f3aa38571801f9cfcd2196fb9dfb4a', './lib/importerlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/index.php', '24.9', 0),
('25a3a19621d7f15c06c99b2434800988', './lib/init/index.php', '24.9', 0),
('2f5ec77669f7e3b12d9499ee11f3894e', './lib/init/initlib.php', '24.9', 0),
('c5063a54a4e17655a9e5ed24bbbf9a8d', './lib/init/smarty.php', '24.9', 0),
('2aaaa0db168d4bf0da9750b4634e06eb', './lib/init/tra.php', '24.9', 0),
('ec7fd2087be7c20d1c83796975174c68', './lib/init/typography.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/integrator/index.php', '24.9', 0),
('b14bf9d95d3d9a20488fea5368e666ac', './lib/integrator/integrator.php', '24.9', 0),
('fc957369270e5bd1dd32403446f48fd1', './lib/jquery_tiki/autoToc.js', '24.9', 0),
('7c7e10e79dee5835648301db8f2881bf', './lib/jquery_tiki/calendar_edit_item.js', '24.9', 0),
('e0b42f9d3fcac56ec1cb07f9cfa1e69d', './lib/jquery_tiki/customsearch.js', '24.9', 0),
('de3972ccc34f1c8dc3e0bda1a4b44bba', './lib/jquery_tiki/edit_preview.js', '24.9', 0),
('4e0c2219a101f55b71f7094ed2c8bbb6', './lib/jquery_tiki/elfinder/elFinderVolumeTikiFiles.class.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/jquery_tiki/elfinder/index.php', '24.9', 0),
('b206769a5bbaae9d39ff18a4880931f6', './lib/jquery_tiki/elfinder/tiki-elfinder.js', '24.9', 0),
('8402b8df360339416c80a53b54605478', './lib/jquery_tiki/elfinder/tikiElFinder.php', '24.9', 0),
('6d574977a7b0c639e9e3b17c2e584e79', './lib/jquery_tiki/files.js', '24.9', 0),
('57b408ef4745a4f314f661a41f209820', './lib/jquery_tiki/fullcalendar_to_pdf.js', '24.9', 0),
('9271b39c343c3118fe1eca66170c42ab', './lib/jquery_tiki/iconsets.js', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/jquery_tiki/index.php', '24.9', 0),
('7aa614c41e9717fe93beacf29ffbeca8', './lib/jquery_tiki/inline_edit.js', '24.9', 0),
('8bbe766d331728f0370eb9bb10e11f7e', './lib/jquery_tiki/multilike.js', '24.9', 0),
('1ce91006548cdf6caa484a15373349bd', './lib/jquery_tiki/mustread.js', '24.9', 0),
('475726972ae08e6997d59bc1bdafccd6', './lib/jquery_tiki/pdf.js', '24.9', 0),
('fcec444b97494769c4f482951f9f82c6', './lib/jquery_tiki/pluginedit.js', '24.9', 0),
('7a1ee69e4b003ce5b5cab5dbddb8b97b', './lib/jquery_tiki/pluginedit_list.js', '24.9', 0),
('0d59ad3f4f55297bc946a41c977e18ee', './lib/jquery_tiki/recordrtc.js', '24.9', 0),
('cc5ea0a50a13351a66efe370e2b2248c', './lib/jquery_tiki/social.js', '24.9', 0),
('e8cf986d285cda2de77c151262271c74', './lib/jquery_tiki/tablesorter.js', '24.9', 0),
('a67679485089ef2a60892e0d89ffeccd', './lib/jquery_tiki/theme-customizer.js', '24.9', 0),
('095ceba26a5b40ed6e8648d64b945db2', './lib/jquery_tiki/tiki-admin.js', '24.9', 0),
('6155b0b86812a35e29791f0a7335c674', './lib/jquery_tiki/tiki-admin_actionlog.js', '24.9', 0),
('f7212d16ae65f092acf79220e3c934fd', './lib/jquery_tiki/tiki-admin_oauthserver.js', '24.9', 0),
('85ba88d52062da29bc37bdf6950dea3b', './lib/jquery_tiki/tiki-bootstrapmodalfix.js', '24.9', 0),
('18a087f6bbcc636d1f49a4fb70e5de07', './lib/jquery_tiki/tiki-confirm.js', '24.9', 0),
('860132f311cb1e667627f8f36485e2f6', './lib/jquery_tiki/tiki-connect.js', '24.9', 0),
('5be241eebce4f6aa45b455cf4e8f1520', './lib/jquery_tiki/tiki-diagram.js', '24.9', 0),
('48123e0128800b12e481513ebf882f1c', './lib/jquery_tiki/tiki-editdiagram.js', '24.9', 0),
('4ae698eb3eeddd8586b8354ee876b6eb', './lib/jquery_tiki/tiki-jquery.js', '24.9', 0),
('2e8cca9c879ebac96e28349787f6012b', './lib/jquery_tiki/tiki-jquery_upload.js', '24.9', 0),
('eb535b91475a6aeebc92e6001383da5f', './lib/jquery_tiki/tiki-machine_learning.js', '24.9', 0),
('c4ba777a81556202527a24399d46618a', './lib/jquery_tiki/tiki-maps-ol3.js', '24.9', 0),
('b8478c2f2c544bca1e520ee83766bc42', './lib/jquery_tiki/tiki-maps.js', '24.9', 0),
('7ce95b5278967f51087b9bb53cbc4464', './lib/jquery_tiki/tiki-mxgraph.js', '24.9', 0),
('e67daa7510246e1a5c3bd24f266ca838', './lib/jquery_tiki/tiki-pdfjs.js', '24.9', 0),
('0d44f19645301f462aed023a9f255566', './lib/jquery_tiki/tiki-popovers_for_footnotes.js', '24.9', 0),
('eb2825507366c30020359f64edf1dfe0', './lib/jquery_tiki/tiki-profile.js', '24.9', 0),
('6e5b6d1e8936e771d7277d2caeb1a9f9', './lib/jquery_tiki/tiki-schedulers.js', '24.9', 0),
('f6a3c4a8e132d27b4810646039cee008', './lib/jquery_tiki/tiki-smartmenus-bootstrap-4.js', '24.9', 0),
('7ab3255bff1f8183b3f990993082cd00', './lib/jquery_tiki/tiki-tasks.js', '24.9', 0),
('32a53b90083266b97a13357cac853b2b', './lib/jquery_tiki/tiki-toolbars.js', '24.9', 0),
('ee60ec742952c8abdbcdfe755ddfe775', './lib/jquery_tiki/tiki-tracker-rules.js', '24.9', 0),
('0d3d0fa8657e04aad90a9028d6e3ac48', './lib/jquery_tiki/tiki-trackers.js', '24.9', 0),
('8e61f46b2b61316727776eae9295fa8a', './lib/jquery_tiki/tiki-vimeo_upload.js', '24.9', 0),
('d4b3281d5cdcb54b8598ee03a55466fa', './lib/jquery_tiki/tiki-vue.js', '24.9', 0),
('01be6ef6b7ba080a8577f2249737e264', './lib/jquery_tiki/tiki-workspace-ui.js', '24.9', 0),
('505765e02098fea8b8d4f4eedbf5ee04', './lib/jquery_tiki/user_mentions.js', '24.9', 0),
('1539ed17c6ac5bc1aae2c2d64866cabc', './lib/jquery_tiki/wikiplugin-annotation.js', '24.9', 0),
('b8d5615a9acdb66e69a3726027d4d0ca', './lib/jquery_tiki/wikiplugin-coil.js', '24.9', 0),
('1cc85e58cf0025376ab2a5b8b0ee0f82', './lib/jquery_tiki/wikiplugin-convene.js', '24.9', 0),
('684db9c1761ad918d9f99df778b68034', './lib/jquery_tiki/wikiplugin-ganttchart.js', '24.9', 0),
('30a4ffb094a55bfb876b84c84a4f25fa', './lib/jquery_tiki/wikiplugin-include.js', '24.9', 0),
('6791a3506bb0f8ec360c587aa7455533', './lib/jquery_tiki/wikiplugin-mediaplayer.js', '24.9', 0),
('53d4eb4f7554297bc0da1fdf4f2c1986', './lib/jquery_tiki/wikiplugin-pivottable.js', '24.9', 0),
('2fe09658c94bbac273a9b4b8c5d1aca3', './lib/jquery_tiki/wikiplugin-signature.js', '24.9', 0),
('52d3537afad8bdbe709a72ccd5ef5669', './lib/jquery_tiki/wikiplugin-totp.js', '24.9', 0),
('23c39a72c49fdf04f1863660f9e9585b', './lib/jquery_tiki/wikiplugin-trackercalendar.js', '24.9', 0),
('1714b721d613805381fc4529ead7a1b1', './lib/jquery_tiki/wikiplugin-xmpp.js', '24.9', 0),
('087d0468a15948353867fa6c0adaefe5', './lib/language/CollectFiles.php', '24.9', 0),
('d1f6b96451133fcbed5b7aa81a75bead', './lib/language/Exception.php', '24.9', 0),
('e9bbaf126553d882ae7e743d2d9d214b', './lib/language/File.php', '24.9', 0),
('466f0b639568d39e3f4efc59e998bf19', './lib/language/FileType.php', '24.9', 0),
('efad45dc740cbca3f1939ab5f134bc3b', './lib/language/FileType/Php.php', '24.9', 0),
('1cee9ba44f019becfa8dbb4a0d916af6', './lib/language/FileType/Tpl.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/language/FileType/index.php', '24.9', 0),
('472b8a5841726442d340cfee78d65b5a', './lib/language/GetStrings.php', '24.9', 0),
('5087bf33c60afc258c74417f290d003b', './lib/language/Language.php', '24.9', 0),
('99c6ce877a2b563445a7e3a20c66be3f', './lib/language/LanguageTranslations.php', '24.9', 0),
('ce5cad948a1685575f266055d280e5f3', './lib/language/MergeFiles.php', '24.9', 0),
('1428b5ba552bf2cbf1f9b4f372eea096', './lib/language/WriteFile.php', '24.9', 0),
('fc58919ab0b91426e573c749da8eba5d', './lib/language/WriteFile/Factory.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/language/WriteFile/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/language/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/language/js/index.php', '24.9', 0),
('becf35b411f580eb40bb4d1e1d765ae9', './lib/language/js/interactive_translation.js', '24.9', 0),
('ee93f6f7b8adc56205e9541f0c1748d2', './lib/language/js/tiki-edit_languages.js', '24.9', 0),
('fe4dba3ee543de139a154c9a998f4c48', './lib/ldap/filter.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/ldap/index.php', '24.9', 0),
('f29cdc1ed97314666af3e0523c1f6348', './lib/ldap/ldaplib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/live_support/index.php', '24.9', 0),
('4af668139694ecff28eb5f03d470b6b8', './lib/live_support/live-support.js', '24.9', 0),
('c606552a92fa9b51762268709926ceed', './lib/live_support/lsadminlib.php', '24.9', 0),
('7c37de814f5083d5471f3e5e343bb616', './lib/live_support/lslib.php', '24.9', 0),
('32d84a8eb844cf4402c260263e2ec21e', './lib/loginlib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/mail/index.php', '24.9', 0),
('8a796ca7608e6900d4ff76af7b0a582d', './lib/mail/maillib.php', '24.9', 0),
('6e7dd8b48d67b2cc48078f3baa8005f8', './lib/mail/mimelib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/mailin/index.php', '24.9', 0),
('055d472927b3bb89499443a87fc5ff24', './lib/mailin/mailinlib.php', '24.9', 0),
('8100a0062e0d26b8aa70afa0a8f0a87c', './lib/mailin/usermailinlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/menubuilder/index.php', '24.9', 0),
('873b57b89eaad42740e5fd2ba3f15747', './lib/menubuilder/menulib.php', '24.9', 0),
('b9ae9e13cca91d0c1c01811653994527', './lib/menubuilder/tiki-admin_menu_options.js', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/messu/index.php', '24.9', 0),
('c549d2dbeeafb0b9dd82cc07f3e2e012', './lib/messu/messulib.php', '24.9', 0),
('1447422cb129c24f094572a83c51a271', './lib/metadata/datatypes/basicinfo.php', '24.9', 0),
('5421d5a1d239683859f1844c5ffde612', './lib/metadata/datatypes/exif.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/metadata/datatypes/index.php', '24.9', 0),
('494e478c21b7d22d949d3aef3acf3e8e', './lib/metadata/datatypes/iptc.php', '24.9', 0),
('250fc6bc98a2b53fa6871982b89cb6c1', './lib/metadata/datatypes/xmp.php', '24.9', 0),
('1f7ff79a435fddb4cc48ee09748e925f', './lib/metadata/filetypes/imagefile.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/metadata/filetypes/index.php', '24.9', 0),
('70ece83df9fad4bf388cb579642f58f4', './lib/metadata/filetypes/jpeg.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/metadata/index.php', '24.9', 0),
('710d5c27c7c69f94d8d39a3bc2ed7d39', './lib/metadata/metadatalib.php', '24.9', 0),
('205becc05188badda1e0aa4ab451d890', './lib/metadata/reconcile.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/mime/index.php', '24.9', 0),
('ff5994d531bfd5a9bad75521552ae20d', './lib/mime/mimelib.php', '24.9', 0),
('89f2660c807093a0054045ead3edea01', './lib/mime/mimetypes.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/minical/index.php', '24.9', 0),
('d5efaa0b593af13da20ff86f2115e3df', './lib/minical/minicallib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/ml/index.php', '24.9', 0),
('331089c59f7c247cf0cbb4cfa7cf8c42', './lib/ml/mllib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/modules/index.php', '24.9', 0),
('72a45f6a3a31d9daec77ace7bce02bf1', './lib/modules/modlib.php', '24.9', 0),
('5d67f0caeb25f89792459964c8b54062', './lib/modules/tiki-admin_modules.js', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/multilingual/index.php', '24.9', 0),
('97fb774e3258ec5d967b69ab1876ff7b', './lib/multilingual/multilinguallib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/newsletters/index.php', '24.9', 0),
('235fd0fbfb5670141a83e1304b2c8507', './lib/newsletters/nllib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/notepad/index.php', '24.9', 0),
('611146537e177b9eceee4168fefec729', './lib/notepad/notepadlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/notifications/index.php', '24.9', 0),
('a23457f36ec47795fd80f3403d9341f2', './lib/notifications/notificationemaillib.php', '24.9', 0),
('cef4f11f95b37a21f2ee2ee475c0aa1f', './lib/notifications/notificationlib.php', '24.9', 0),
('3e4770d0b0e0ddcc44953f16324b1ba0', './lib/oauthlib.php', '24.9', 0),
('26b12e92359fa9d2262a3d83ef3d419b', './lib/oauthserver/TikiCryptKey.php', '24.9', 0),
('a14d73182e5d87ac2e62789317eca2c2', './lib/oauthserver/entities/AccessTokenEntity.php', '24.9', 0),
('59c8104dcc15563c7d320de0f2e82395', './lib/oauthserver/entities/AuthCodeEntity.php', '24.9', 0),
('4760ae7225978b18bc0a45060831b0df', './lib/oauthserver/entities/ClientEntity.php', '24.9', 0),
('3e680fd93b05051c136b7167e712eb11', './lib/oauthserver/entities/RefreshTokenEntity.php', '24.9', 0),
('cfb72ee2ad47261eee59f2254ccfba90', './lib/oauthserver/entities/ScopeEntity.php', '24.9', 0),
('09419026ad4d2b5e1ab615873475a66e', './lib/oauthserver/entities/UserEntity.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/oauthserver/entities/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/oauthserver/index.php', '24.9', 0),
('f05d578d1e88384801fb29397f9ebabb', './lib/oauthserver/oauthserverlib.php', '24.9', 0),
('ef1e2bb7dc8c0e5517fe09d0c52e4b33', './lib/oauthserver/repositories/AccessTokenRepository.php', '24.9', 0),
('2d28b88b507c1c2f56e211209115cec9', './lib/oauthserver/repositories/AuthCodeRepository.php', '24.9', 0),
('59a20a60cc652e9f470a05515c07aa95', './lib/oauthserver/repositories/ClientRepository.php', '24.9', 0),
('64ed3f8fbb8dee084c88b5941cad17df', './lib/oauthserver/repositories/RefreshTokenRepository.php', '24.9', 0),
('2344320e7f904b98d41475a2c484be04', './lib/oauthserver/repositories/ScopeRepository.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/oauthserver/repositories/index.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('1f558c72ec401a7e8d500f08b82970e4', './lib/objectlib.php', '24.9', 0),
('5bc79de6336b60d037ce44ccf61f734a', './lib/ocrlib.php', '24.9', 0),
('3685f81704c0e67501fc815f424500d2', './lib/ointegratelib.php', '24.9', 0),
('63508ed874da1432017a7c808f00bc2b', './lib/openlayers/OpenLayers.js', '24.9', 0),
('bc6ec4a829998bb09aeb9ee49f72406c', './lib/openlayers/OpenLayers.light.js', '24.9', 0),
('b624d36aec327baad809a9c326faac31', './lib/openlayers/OpenLayers.mobile.js', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/art/index.php', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/img/index.php', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/index.php', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/licenses/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/openlayers/theme/dark/index.php', '24.9', 0),
('a6bcea2af384a1f59ceaf6d99a737b72', './lib/openlayers/theme/default/google.css', '24.9', 0),
('ae75483aedfcd7d1ea3bb11f6148cf2f', './lib/openlayers/theme/default/google.tidy.css', '24.9', 0),
('97e9508128e3d02599b15c947b8490a1', './lib/openlayers/theme/default/ie6-style.css', '24.9', 0),
('256c553a4738811397517c82f0119101', './lib/openlayers/theme/default/ie6-style.tidy.css', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/theme/default/img/index.php', '24.9', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/openlayers/theme/default/index.php', '24.9', 0),
('d7e4ed1a6b03b93c4452db55dc262927', './lib/openlayers/theme/default/style.css', '24.9', 0),
('340578162d772d9c74c7f0785b4754e8', './lib/openlayers/theme/default/style.mobile.css', '24.9', 0),
('9132583981f7f7ef6f3c00a387bdca6f', './lib/openlayers/theme/default/style.mobile.tidy.css', '24.9', 0),
('9521ac61157d73a252cdebe6df5e019d', './lib/openlayers/theme/default/style.tidy.css', '24.9', 0),
('0292fb69ceb258a99fe22794b447b501', './lib/openlayers/theme/index.php', '24.9', 0),
('d80ba3d63aacd7c8b031b67f151eaed8', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Sendmail.php', '24.9', 0),
('95fe75ccd0246c04e40816d14c574130', './lib/openpgp/OpenPGP_Zend_Mail_Transport_Smtp.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/openpgp/index.php', '24.9', 0),
('cf320ded6ba56f16cda05cdc788d5993', './lib/openpgp/openpgplib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/parser/index.php', '24.9', 0),
('13bd74461afdbcb8bfbcdb6ed0cc307e', './lib/parser/parserlib.php', '24.9', 0),
('b94514a85e00082e19ffb7ad264300e6', './lib/pass_blacklists/index.php', '24.9', 0),
('ac7931d1e95394b43595122c50433149', './lib/payment/ILPInvoicePaymentLib.php', '24.9', 0),
('34e9acfd618b1190a5d2f9e4460c8e02', './lib/payment/ILPPaymentAdapterInterface.php', '24.9', 0),
('cd40f22b8b25595eb1d605cfba03c14d', './lib/payment/behavior/cancel_cart_order.php', '24.9', 0),
('8ea0aa39d8786b4992bd95539d4b5f6b', './lib/payment/behavior/cancel_membership_extension.php', '24.9', 0),
('c875b374c5b4e858f3094b1062c7ff06', './lib/payment/behavior/cart_exchange_product.php', '24.9', 0),
('80b2e7128816e27050271808ae2841bd', './lib/payment/behavior/cart_send_confirm_email.php', '24.9', 0),
('d3dbe1fdf28d5d6608aacbfea378e1fb', './lib/payment/behavior/execute_datachannel.php', '24.9', 0),
('8aedd6ad64bc2fb305c5af5a94b2a57e', './lib/payment/behavior/extend_membership.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/payment/behavior/index.php', '24.9', 0),
('ecfe8c50994e8a9393856386fe55c15d', './lib/payment/behavior/perform_trade.php', '24.9', 0),
('766ca87c692df0241239d0472b8fa6c7', './lib/payment/behavior/record_cart_order.php', '24.9', 0),
('58844a32e13313179d53ba668d7c388e', './lib/payment/behavior/replace_inventory.php', '24.9', 0),
('52920db2cab97fca42df0d233ae79901', './lib/payment/behavior/sample.php', '24.9', 0),
('8bde1741585c54db35ab57eb0e209f37', './lib/payment/cartlib.js', '24.9', 0),
('b986cbc25c7e85b71440b0da49142134', './lib/payment/cartlib.php', '24.9', 0),
('dc01b7efe94e0f13877b8ebe1457344e', './lib/payment/cclitelib.php', '24.9', 0),
('9a96eac9c1532b08fb9070b340db4d33', './lib/payment/creditspaylib.php', '24.9', 0),
('01e4569c3b7d7df638300ace21affeb9', './lib/payment/discountlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/payment/index.php', '24.9', 0),
('40dfe3f2dc92553e334c8e4950d1db3a', './lib/payment/israelpostlib.php', '24.9', 0),
('200e685155d6bf958b188104fb0a3239', './lib/payment/paymentlib.php', '24.9', 0),
('62a66200b36ee0df13121a40ac37b700', './lib/payment/paypallib.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/pdf/fontdata/fontttf/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/pdf/fontdata/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/pdf/index.php', '24.9', 0),
('cd7f731bb77af474c3806e00da7b99a6', './lib/pdfimages.php', '24.9', 0),
('15a0b9a0e77bb5e17c5403c5ceb12570', './lib/pdflib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/performance/index.php', '24.9', 0),
('f7e28efef2faecda9357d567fd0b31d5', './lib/performance/performancestatslib.php', '24.9', 0),
('83058476058787452181317409c187a4', './lib/perspective/binderlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/perspective/index.php', '24.9', 0),
('7181021bc15260e03b96719fb74be8d6', './lib/perspectivelib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/phpseclib_tiki/index.php', '24.9', 0),
('75ae04010557d952bf4a69a3b677b733', './lib/phpseclib_tiki/tikisecure.php', '24.9', 0),
('1772370ac42627c83363d4e4a7f0ccb1', './lib/polls/index.php', '24.9', 0),
('fe00b7ba1addfbfc020e3922b735c25f', './lib/polls/polllib.php', '24.9', 0),
('8735ef341e9d1d3f4d6ba2781efc7f63', './lib/polls/polllib_shared.php', '24.9', 0),
('ea5eb480b251419397c691ce102e93ed', './lib/prefs/access.php', '24.9', 0),
('6c71fa1d7baa7e1892810fefc4648917', './lib/prefs/activity.php', '24.9', 0),
('0676fd3a2447339faae4d3a25dc8cd98', './lib/prefs/ajax.php', '24.9', 0),
('6a6b43a56c9f48b0f49488189a0e3248', './lib/prefs/alchemy.php', '24.9', 0),
('d69a6fa5404de53f79c5ea5d75242407', './lib/prefs/allocate.php', '24.9', 0),
('0023e31cb5967752032de7fd1fd1b5c3', './lib/prefs/allowmsg.php', '24.9', 0),
('09896a7eade7807752ed7e924011fc74', './lib/prefs/areas.php', '24.9', 0),
('bbf46589bdabd887fa495c1d08316877', './lib/prefs/art.php', '24.9', 0),
('1350ac98a6d96752e29eeb4f0a23ab92', './lib/prefs/article.php', '24.9', 0),
('adae77739899d0d04934a1d123d27747', './lib/prefs/auth.php', '24.9', 0),
('f3d27f9c1c90a6bb849567543f7ae34a', './lib/prefs/available.php', '24.9', 0),
('aed716e2167d0e2cdf389b9f6922811c', './lib/prefs/bigbluebutton.php', '24.9', 0),
('da84c6622874936bbaea9c6dd570a026', './lib/prefs/blog.php', '24.9', 0),
('5fc7abb046611882a49638d15e95b5d3', './lib/prefs/box.php', '24.9', 0),
('1a9c95c351c941bc8dd2d063aa38cbf1', './lib/prefs/calendar.php', '24.9', 0),
('2d9f4540762e824694cb22934e7ca732', './lib/prefs/captcha.php', '24.9', 0),
('5af13cc4a15d746b6d69a0a913fb6fe7', './lib/prefs/cas.php', '24.9', 0),
('cd335a1c66f7cedec883b0689dda104e', './lib/prefs/categories.php', '24.9', 0),
('1985957cc7d423070f1c7126a8b0a943', './lib/prefs/category.php', '24.9', 0),
('40178050d9ddb545f928276d33e197e1', './lib/prefs/categorypath.php', '24.9', 0),
('99f56185f3bc60f7d95d544b97c76114', './lib/prefs/center.php', '24.9', 0),
('aaca140f3322f45c28abd44e8caf0189', './lib/prefs/change.php', '24.9', 0),
('7e1ae871ceb99d26c2a682439b76c1ea', './lib/prefs/comments.php', '24.9', 0),
('5ebd68769c2f807a39ee80502979d76a', './lib/prefs/conditions.php', '24.9', 0),
('15f8c13287eecb72c6fbb0007b51a3e0', './lib/prefs/connect.php', '24.9', 0),
('0c660d33130d6bdade12eb2206e14acc', './lib/prefs/contact.php', '24.9', 0),
('490a5e5d16e795a16d40a71cf9b31ddb', './lib/prefs/cookie.php', '24.9', 0),
('bc160421b13c1565457df1d59f336d57', './lib/prefs/count.php', '24.9', 0),
('5dd5a1c474296ea2b7c4eb5b451c6b53', './lib/prefs/dailyreports.php', '24.9', 0),
('4e7259b221a6cc55c3a86fb966c0ebe5', './lib/prefs/default.php', '24.9', 0),
('9af90c699ec07add59af0a91417d9dae', './lib/prefs/desactive.php', '24.9', 0),
('8f8d23ea944e1bfc2c674bca80dc3f97', './lib/prefs/direct.php', '24.9', 0),
('6979ce9cf01dc90874433ef8fc1eacda', './lib/prefs/directory.php', '24.9', 0),
('1672f538094a3835e64ec1ae64030799', './lib/prefs/display.php', '24.9', 0),
('143746dcbcedf39cd16a12ef70590152', './lib/prefs/email.php', '24.9', 0),
('607f3d7709a03b925744ff5b190defb1', './lib/prefs/error.php', '24.9', 0),
('30953c0f686608ef5ef4dc3937fd2865', './lib/prefs/faq.php', '24.9', 0),
('1f64677af8eaf013504dcc2cd00633eb', './lib/prefs/feature.php', '24.9', 0),
('18e1f2530584547201d7c48babff254f', './lib/prefs/federated.php', '24.9', 0),
('608d529d286f023e69236194cfb290df', './lib/prefs/feed.php', '24.9', 0),
('aae23da063b766866e0ee89cc78d0e5e', './lib/prefs/fgal.php', '24.9', 0),
('422e9e0580e7667302eb25c81dbd29ea', './lib/prefs/file.php', '24.9', 0),
('3b99a928674c4b9a9f314e5e157ce671', './lib/prefs/flaggedrev.php', '24.9', 0),
('cd2702613c49ef378fe567b7b976a8f2', './lib/prefs/footer.php', '24.9', 0),
('cddff5a5aeddc3efa69146445671b06a', './lib/prefs/footnote.php', '24.9', 0),
('6fc069163bb809e9b406e45cbd038f1c', './lib/prefs/forum.php', '24.9', 0),
('8ed1d072603aee0a3c32ee1272d10052', './lib/prefs/forums.php', '24.9', 0),
('c105e8ef8bf60e6a2a622f14fb730024', './lib/prefs/freetags.php', '24.9', 0),
('6ef6d5d92e2784cf0f90a97782d918dd', './lib/prefs/gal.php', '24.9', 0),
('71ceb60b357cd7fa30639176b6800cd6', './lib/prefs/generate.php', '24.9', 0),
('ff11f4a4dc8cff819778d83fd3ea0ff2', './lib/prefs/geo.php', '24.9', 0),
('959d2cff772977220c47f635ac7c51c4', './lib/prefs/global.php', '24.9', 0),
('db07029754ad519668d85a5e7ada6def', './lib/prefs/gmap.php', '24.9', 0),
('a8eddf96d04c5257527890887c213c06', './lib/prefs/goal.php', '24.9', 0),
('e68ff57d2134b7bf354b4d39bfeccf98', './lib/prefs/h5p.php', '24.9', 0),
('99ad53def8b0623e56d0931d52654d76', './lib/prefs/header.php', '24.9', 0),
('8d39e5c7201220efbed4254e3bc905a4', './lib/prefs/highlight.php', '24.9', 0),
('ff3f878e65220266317313ef45165425', './lib/prefs/home.php', '24.9', 0),
('16bf8797f643c3457a1897018105a4de', './lib/prefs/http.php', '24.9', 0),
('8b261814de9514476d5432fb4bfedeed', './lib/prefs/https.php', '24.9', 0),
('9d9cda1b5c8451b6ea30548c692c43c4', './lib/prefs/ids.php', '24.9', 0),
('3c27ea0645d9eed5b7993f5011910e4c', './lib/prefs/image.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/prefs/index.php', '24.9', 0),
('040fc6c0fbacaa950fbfe0c4408cd483', './lib/prefs/intertiki.php', '24.9', 0),
('b2a876f921f3ecbb9a28392d4af09c57', './lib/prefs/ip.php', '24.9', 0),
('42e8d21effdbe14f64ea1aae5989a833', './lib/prefs/javascript.php', '24.9', 0),
('1e9ab53efb3a3bc2ed9d4b071d40c700', './lib/prefs/jquery.php', '24.9', 0),
('1f973c6a8fb720bd7a8cbd2ab4c9dc25', './lib/prefs/kaltura.php', '24.9', 0),
('7770606c77969c27c4e3552ec65f9240', './lib/prefs/keep.php', '24.9', 0),
('0a061ac642417508c07d8cd2f8e67ca0', './lib/prefs/lang.php', '24.9', 0),
('e3e96a840c47de957abd65d16e19499a', './lib/prefs/language.php', '24.9', 0),
('bad6ca018895ec08060b80d584f88d63', './lib/prefs/layout.php', '24.9', 0),
('83fe0f8857d62f637633b30b26ce4ae9', './lib/prefs/ldap.php', '24.9', 0),
('2a4309edbbca5a5b9a0e48bd91c7a5fb', './lib/prefs/load.php', '24.9', 0),
('dfe78c21dcf51fd6b579760679179117', './lib/prefs/lock.php', '24.9', 0),
('580533847ac071e061652cef93c93e71', './lib/prefs/log.php', '24.9', 0),
('46327a19fea0aa7acef072e64e10f25a', './lib/prefs/login.php', '24.9', 0),
('7d16a89695474d0c0240b8d7b5a27aff', './lib/prefs/long.php', '24.9', 0),
('1f6960bb18d4ffd2e7314f9f02bf883c', './lib/prefs/lowercase.php', '24.9', 0),
('07b32765297fc45e780af8a5b6af7f54', './lib/prefs/mail.php', '24.9', 0),
('cc3555db1abfa15ff62db48c213dccce', './lib/prefs/main.php', '24.9', 0),
('100593a5e1d044266f9c8e9b4df4af58', './lib/prefs/max.php', '24.9', 0),
('71f6bf8282499f89b462107c02870db2', './lib/prefs/memcache.php', '24.9', 0),
('4bc71685cd1e0a38890f1a3cdf5636fe', './lib/prefs/menus.php', '24.9', 0),
('452beda9f5bb554b2aa79374e64baac5', './lib/prefs/messu.php', '24.9', 0),
('5e82be40b28ab0dc0e4b2277c4348500', './lib/prefs/metatag.php', '24.9', 0),
('3c5279f22a81ff891bb5877eae6f7132', './lib/prefs/middle.php', '24.9', 0),
('f3a593aea24bb125e6ac049a8165aeec', './lib/prefs/min.php', '24.9', 0),
('264bea0c2d0a2efe04c86a921525e7a8', './lib/prefs/mobile.php', '24.9', 0),
('431c84a05d697187c5140ece8774ad08', './lib/prefs/module.php', '24.9', 0),
('98aede00b6e61ce43a1c5f56e410f5fe', './lib/prefs/monitor.php', '24.9', 0),
('1807a1a247829d85e5662bd02d542163', './lib/prefs/morelikethis.php', '24.9', 0),
('a24fe590db91bfb93a237df81f571f60', './lib/prefs/multidomain.php', '24.9', 0),
('ee564d98e5e7bbe1847b9b5bf0e573cb', './lib/prefs/mustread.php', '24.9', 0),
('09a121257865a7942746c349a293b0ee', './lib/prefs/namespace.php', '24.9', 0),
('3ef42f513deb2ac0b9e914b35f31244b', './lib/prefs/newsletter.php', '24.9', 0),
('aad00897897a190bea3c90d02b138efa', './lib/prefs/nextprev.php', '24.9', 0),
('c0825c46837ecb69775f3cf378da83b7', './lib/prefs/oauthserver.php', '24.9', 0),
('b18577fe3a9929fc1319a563503eb6d4', './lib/prefs/object.php', '24.9', 0),
('a9d1e203e748c7637090c3fe5369fee9', './lib/prefs/ocr.php', '24.9', 0),
('db006f0f62e9867be9694a19199fb46a', './lib/prefs/openidconnect.php', '24.9', 0),
('cf33a4a99694f59fc155ac7f33d65f6c', './lib/prefs/openpgp.php', '24.9', 0),
('25f445decdc04bd12e551d1830c38562', './lib/prefs/page.php', '24.9', 0),
('e8ea74f3cc9e9e746d4213eb67b1c36f', './lib/prefs/pagination.php', '24.9', 0),
('7460b38f1197c5f0efc1d405f64900e1', './lib/prefs/pam.php', '24.9', 0),
('0bdcd16317a1da7cb77b219e3fa1f3a9', './lib/prefs/pass.php', '24.9', 0),
('f22fb94824dfabef1b56bf85d4425570', './lib/prefs/payment.php', '24.9', 0),
('fbaaea7afe3e7dc42cc291da34e65d4b', './lib/prefs/permission.php', '24.9', 0),
('8b19751a3f77840b87835753d57ecbe6', './lib/prefs/php.php', '24.9', 0),
('aab9dda944582f793cf526b09c49fcac', './lib/prefs/poll.php', '24.9', 0),
('3c2cfe48bce8dd5f9078dbd25b38bc03', './lib/prefs/print.php', '24.9', 0),
('680910b45091685919ebea477149db73', './lib/prefs/profile.php', '24.9', 0),
('49933cc4de2652fd785c22405aeeace5', './lib/prefs/proxy.php', '24.9', 0),
('3ea3e0b5fe2c0a560e94aea2d2068e89', './lib/prefs/pwa.php', '24.9', 0),
('47af4885a4fa458a561156e34eb3c6d6', './lib/prefs/quantify.php', '24.9', 0),
('d70adb32525a0acd1ad82c64864552c2', './lib/prefs/rating.php', '24.9', 0),
('f372fbf684e656948fba7209d72d0cf3', './lib/prefs/recaptcha.php', '24.9', 0),
('c5a0babbc01fe09b9aec2b68c22c9512', './lib/prefs/record.php', '24.9', 0),
('8cadd2611abafa09a10d062eb050de21', './lib/prefs/redis.php', '24.9', 0),
('0ec9c23eda10c50f65313113e5cd11d6', './lib/prefs/restrict.php', '24.9', 0),
('1af5c5b3800468bb9206723c67f7c865', './lib/prefs/saml.php', '24.9', 0),
('27467442a8df0ec765207749dfb84c76', './lib/prefs/scheduler.php', '24.9', 0),
('2c29248e4e2e3a31bd13a4324a96b307', './lib/prefs/scorm.php', '24.9', 0),
('7e6d5db994ed4226142ec938f86f3bb7', './lib/prefs/search.php', '24.9', 0),
('5252aa37c7c0d6afa6e4f284e67e2c7d', './lib/prefs/section.php', '24.9', 0),
('41e34aeac7b023fe0b538f3e030584b1', './lib/prefs/sefurl.php', '24.9', 0),
('bc50560de8d2a8d6a103d2df156c6f10', './lib/prefs/sender.php', '24.9', 0),
('19d0c8474d34ecfe4de44df2b6cddeae', './lib/prefs/server.php', '24.9', 0),
('962ffdd0b67c26171815b328530e8728', './lib/prefs/session.php', '24.9', 0),
('f3af1f0bd5da1500c115022129f6f8b1', './lib/prefs/share.php', '24.9', 0),
('e33c1b6ec5d1c250183f99569b90c187', './lib/prefs/shib.php', '24.9', 0),
('7e515e656775a09d1af982d084a40445', './lib/prefs/shipping.php', '24.9', 0),
('e9645a633bfb1541864ebe12a777a963', './lib/prefs/short.php', '24.9', 0),
('f2c752ceb33329b1943c53c523f97a9c', './lib/prefs/show.php', '24.9', 0),
('42592eee47a6ded64317105bc63ba3df', './lib/prefs/site.php', '24.9', 0),
('50b0b6499c0f74797f1f6b6e7fbf4469', './lib/prefs/sitead.php', '24.9', 0),
('bfb26683b280b5fe6ceacaa85e86aa61', './lib/prefs/sitelogo.php', '24.9', 0),
('43fe99befefeaac07c225b89586e5f7e', './lib/prefs/sitemap.php', '24.9', 0),
('04cf1e93b7ea22e7a8737e89595a74a2', './lib/prefs/slide.php', '24.9', 0),
('bee651a17c2fdeab4ac6ca70441f476d', './lib/prefs/smarty.php', '24.9', 0),
('df023ec702c2e8387cf60e15c1d374e4', './lib/prefs/social.php', '24.9', 0),
('4fa172fb48e77f03884aef2377c81652', './lib/prefs/socialnetworks.php', '24.9', 0),
('c720ed22eaf86dd544446190979a3056', './lib/prefs/socnets.php', '24.9', 0),
('6008401aa6689780125836960e48a7b4', './lib/prefs/storedsearch.php', '24.9', 0),
('946bfa45c3989edd85dbde5897de0d1f', './lib/prefs/suite.php', '24.9', 0),
('e5d1c9c310ae201f6323bcb6a3efcce6', './lib/prefs/t.php', '24.9', 0),
('d2781c2ae288355e19594ba8b0353b72', './lib/prefs/theme.php', '24.9', 0),
('32f2ae386a14fcabc48a5a7c0fa81343', './lib/prefs/tiki.php', '24.9', 0),
('ebacd7a513da83c4f7cb1eb2e4a0b8dc', './lib/prefs/tracker.php', '24.9', 0),
('52507331d97a56118c87a59615c5cdff', './lib/prefs/trackerfield.php', '24.9', 0),
('01722e8c24f307e8f055cb981effc68a', './lib/prefs/uf.php', '24.9', 0),
('24112ff54acb8a2a274a87495bd837a4', './lib/prefs/unified.php', '24.9', 0),
('6fd15002527e4f38e1cbc5337480873b', './lib/prefs/unsuccessful.php', '24.9', 0),
('139e60d90609bb7bad8dd4af16dc446a', './lib/prefs/url.php', '24.9', 0),
('3bb13dbc4f5669bc1c92cce873f1489e', './lib/prefs/use.php', '24.9', 0),
('f86cb516d308cb394df4b8152422bac1', './lib/prefs/user.php', '24.9', 0),
('3e3a476d4251aeb10613b3a5d831bfac', './lib/prefs/userfiles.php', '24.9', 0),
('a0c0b9c351de92aa43b82a5b037d792f', './lib/prefs/username.php', '24.9', 0),
('9f2d96c13ec37a56b46a767676593268', './lib/prefs/users.php', '24.9', 0),
('b0dd43e85dfaeb4a39bbaafc2d798f74', './lib/prefs/validator.php', '24.9', 0),
('00f5f41a7b8232d78b947bde7b40632b', './lib/prefs/vimeo.php', '24.9', 0),
('1e556be4bd9f960048b381e838a76703', './lib/prefs/vuejs.php', '24.9', 0),
('c0637b499c24cab8f48d6f7bbbcb1df5', './lib/prefs/w.php', '24.9', 0),
('d77bd552acc8262f23fce5d6aceace2e', './lib/prefs/warn.php', '24.9', 0),
('e083187a134f8d78ca47961f36e50824', './lib/prefs/webcron.php', '24.9', 0),
('13cc2a53dfa5a2e75cb5ab42ff44d931', './lib/prefs/webmonetization.php', '24.9', 0),
('cd03c66118f48ee7f4a093915b708768', './lib/prefs/webservice.php', '24.9', 0),
('0a3945e8926fabad5b7aaaa6427018b1', './lib/prefs/wiki.php', '24.9', 0),
('13f3431e2379f7e21ac59f98ed6bece9', './lib/prefs/wikiapproval.php', '24.9', 0),
('f95f3608a0cdd7980573774488a121d9', './lib/prefs/wikiplugin.php', '24.9', 0),
('f0bad13ec7047cb28482e917e6b3add5', './lib/prefs/wikiplugininline.php', '24.9', 0),
('ef7ea17d355c7f9d229d6ab33f5b12a1', './lib/prefs/wikipluginprefs.php', '24.9', 0),
('54b04537fbab096386114a655fff0eb1', './lib/prefs/wizard.php', '24.9', 0),
('329da8e144b436fda2f067522be2ac44', './lib/prefs/workspace.php', '24.9', 0),
('92cfd8699d1807a7c3d2f26c66baeba4', './lib/prefs/wysiwyg.php', '24.9', 0),
('3ef79da37a38c34c2ba7bb4992ad3ef2', './lib/prefs/xmpp.php', '24.9', 0),
('f401dfc233c60ff2234e556bc22c8c5b', './lib/prefs/zend.php', '24.9', 0),
('eafdcdf2cdb31fa14cfbc8247e87987d', './lib/prefs/zotero.php', '24.9', 0),
('ae953e5baddcc32defe4a57656cd893d', './lib/prefslib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/profilelib/index.php', '24.9', 0),
('384518d9fdd87d014c419d87777c1aa0', './lib/profilelib/shell.php', '24.9', 0),
('13211d5b71d363ad1491a3a825134b65', './lib/pwa/app.js', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/pwa/index.php', '24.9', 0),
('9a4ceb3ba5e2d42557628cd531249add', './lib/queuelib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/quizzes/index.php', '24.9', 0),
('9e20a2f7cdfc7745c036f443f15ce4ec', './lib/quizzes/quizlib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/rangy_tiki/index.php', '24.9', 0),
('b379996c490c5e0f7c0cf18636e4a1d3', './lib/rangy_tiki/rangy-phraser.js', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/rankings/index.php', '24.9', 0),
('9e196e7f8489ff58aa18e4ebde094809', './lib/rankings/ranklib.php', '24.9', 0),
('caa43c8d2f1f3fff50fbe41bf86e02ac', './lib/rating/configlib.php', '24.9', 0),
('537148dea96ed5133472e94d2322f08a', './lib/rating/formula/ArticleInfo.php', '24.9', 0),
('8f08a2b31b270b2b3af80633d048d6ef', './lib/rating/formula/Attribute.php', '24.9', 0),
('919b6b5b650fe8131198dcbb72293987', './lib/rating/formula/CategoryPresent.php', '24.9', 0),
('61aca79dc1da50b96d3da534b2a54d31', './lib/rating/formula/RatingAverage.php', '24.9', 0),
('58fb4fbf8d9ec50f1913766cc7a6ce8d', './lib/rating/formula/RatingSum.php', '24.9', 0),
('4eb1c0dcdb015c14d6c5a5fc7bafb41f', './lib/rating/formula/RelationPresent.php', '24.9', 0),
('9f6e189cafb029a63bccb0011adb6d7d', './lib/rating/formula/ResultCount.php', '24.9', 0),
('631640d986a746cfc46b94edbec43def', './lib/rating/formula/TrackerField.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/rating/formula/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/rating/index.php', '24.9', 0),
('3954cb8270fe0777fc7ce8745976b240', './lib/rating/ratinglib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/references/index.php', '24.9', 0),
('ec9988fb12fd3cd7d55bbf1bf9ad8252', './lib/references/referenceslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/refererstats/index.php', '24.9', 0),
('7dd72121a04d90e3db24e67be0ad0fbe', './lib/refererstats/refererlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/registration/index.php', '24.9', 0),
('ee1366431700e581552c64af5270d8c1', './lib/registration/registrationlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/rss/index.php', '24.9', 0),
('8b38f37e4082a031a5f7ba5574bd77df', './lib/rss/pagecontentlib.php', '24.9', 0),
('c9550290970a61735ebd97a4c42ba8b7', './lib/rss/rsslib.php', '24.9', 0),
('fae6f9f573aa5a1534ac2ed2ba388198', './lib/schedulerslib.php', '24.9', 0),
('c311cf86a80b67d8b28bc05da34fae47', './lib/score/events.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/score/index.php', '24.9', 0),
('eceedac5ea1856f37ef377290d9ac3fb', './lib/score/scorelib.php', '24.9', 0),
('a962d55543d59dd74d0004d8924ba674', './lib/search/federatedsearchlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/search/index.php', '24.9', 0),
('7aac384bd856a8b973844d8a42425bb2', './lib/search/refresh-functions.php', '24.9', 0),
('164d5bbe8652d82c01d9e79a0017ba57', './lib/search/refresh.php', '24.9', 0),
('d8bf0d9ee6d6e4b6fff346479e651d05', './lib/search/report_string_in_db.php', '24.9', 0),
('773074f496b0c79d1c9be6beeb9f3db7', './lib/search/searchlib-mysql.php', '24.9', 0),
('56dce5861bf28037a4573b3b4ca6c724', './lib/search/searchlib-unified.php', '24.9', 0),
('2318f380c09b6e4443e719635792c48b', './lib/search/searchstatslib.php', '24.9', 0),
('384518d9fdd87d014c419d87777c1aa0', './lib/search/shell.php', '24.9', 0),
('0ba9d8e9bd51872a5bde8cc8f9d802a3', './lib/search/storedsearchlib.php', '24.9', 0),
('38d8c69c07eaaf565b78ef659ffc58b2', './lib/serializedlist.php', '24.9', 0),
('53625f3a26b79b293e0bd58594bf98bd', './lib/servicelib.php', '24.9', 0),
('54030a504fed040f2f9726ec5429692c', './lib/setup/absolute_urls.php', '24.9', 0),
('271b44a6312724af9c794d9e7ed55fbc', './lib/setup/avatar_force_upload.php', '24.9', 0),
('fd8ac8e4eeffa3a3014e476419cb39fd', './lib/setup/categories.php', '24.9', 0),
('227d3123c08bcfdc4a8451ae7c33788b', './lib/setup/comments_zone.php', '24.9', 0),
('c845d34267b973400364d3d8e3260796', './lib/setup/cookies.php', '24.9', 0),
('a74a4ad5e257f8f32530eef424df240a', './lib/setup/credits.php', '24.9', 0),
('ae0ce772ac861271ff0022b75986057b', './lib/setup/default_homepage.php', '24.9', 0),
('48beaa77e5247da22c70ba497ea76efe', './lib/setup/dynamic_variables.php', '24.9', 0),
('5cf512719bb109cda8e7af5573dd2e75', './lib/setup/editmode.php', '24.9', 0),
('9649eb37bf4ec3541a7d40bd7c07a17d', './lib/setup/error_reporting.php', '24.9', 0),
('e8fbcd82e0e065ce24c094b8548c0cd5', './lib/setup/error_tracking.php', '24.9', 0),
('667831a8c6571892a431b0900f372eb8', './lib/setup/events.php', '24.9', 0),
('775c55753112a953a210bfc472acf98d', './lib/setup/freetags.php', '24.9', 0),
('2ec2b41337437151d528064762e02a6b', './lib/setup/fullscreen.php', '24.9', 0),
('d5583bb8eefa3ed434eaa2e53d52441c', './lib/setup/ids.php', '24.9', 0),
('2140f7376987f964a1bbc62d98a02af3', './lib/setup/index.php', '24.9', 0),
('8600af1964b33f3b2c168b667119a8e3', './lib/setup/integrator.php', '24.9', 0),
('ea0d20bfbd29153ef3089019fd97af10', './lib/setup/javascript.php', '24.9', 0),
('4d13f9dc9abfcaae2bde9f6cfdea67ae', './lib/setup/language.php', '24.9', 0),
('11a89b3db6ba237ced40f485f7ec750b', './lib/setup/last_update.php', '24.9', 0),
('01b8615dade0b99cc87e79f80c855f93', './lib/setup/live_support.php', '24.9', 0),
('d3c2c1dde0d44d0c0ea478774bd7892f', './lib/setup/load_threshold.php', '24.9', 0),
('6c47728193741dc0377ddfc872312db2', './lib/setup/mailin.php', '24.9', 0),
('597985edfb868768ef58e56627cc2234', './lib/setup/mobile.php', '24.9', 0),
('42dc493ec99787173c1ea26a946ad399', './lib/setup/openid.php', '24.9', 0),
('635f61e8f883e2c18e85708ba3a5f3f2', './lib/setup/output_compression.php', '24.9', 0),
('f6600991f110764652413add73ec53e2', './lib/setup/perms.php', '24.9', 0),
('0895f3ed13a3829c55c31f7ac9465e02', './lib/setup/plugins_actions.php', '24.9', 0),
('e89a4d5e6533acb5ae20a725d1ad3e54', './lib/setup/polls.php', '24.9', 0),
('1eaa9df4936cc6afb6acf801a1551cf5', './lib/setup/prefs.php', '24.9', 0),
('d040867b80264e63ab93b2a277f7c83c', './lib/setup/sections.php', '24.9', 0),
('bddab047b1ea4d73d7bc25e559d4aa73', './lib/setup/site_closed.php', '24.9', 0),
('6174151ed489ae2b7e987f455af3f74d', './lib/setup/stats.php', '24.9', 0),
('9444625374f29c75fa796c6e746bc384', './lib/setup/theme.php', '24.9', 0),
('4b3aafd854e2edf746e4b5a603e7bf90', './lib/setup/third_party.php', '24.9', 0),
('f8cba8e5b5f57658e2f94f0fefb772f2', './lib/setup/tikiIndex.php', '24.9', 0),
('7109039e2c87fd1533c9480df3953b52', './lib/setup/tikisetup.class.php', '24.9', 0),
('904293bded483ddd3d9a378721bfda20', './lib/setup/timer.class.php', '24.9', 0),
('17784cc05d5cba09eead5c780398fb87', './lib/setup/tracker_force_fill.php', '24.9', 0),
('40e1c2138dbddd0cd6fcd9a4c2601c33', './lib/setup/twversion.class.php', '24.9', 0),
('78109b127682c28a0eb366a43afa365c', './lib/setup/user_prefs.php', '24.9', 0),
('28f3329962ef5c3749be25500f42011f', './lib/setup/userlevels.php', '24.9', 0),
('a23a6e27392bcdb4e4d065e811cd2952', './lib/setup/usermenu.php', '24.9', 0),
('9233ea1b8bd023a53ac7b9c205db2ddb', './lib/setup/wiki.php', '24.9', 0),
('71dd3521412c3ff439f8437bc5e26a43', './lib/sharelib.php', '24.9', 0),
('a4f2ad00d3517f72abc1a7af5c175720', './lib/sheet/conf/config.inc.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/sheet/conf/index.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/excel/index.php', '24.9', 0),
('882ae1f36e9dacad4e63e9f36a2c5e27', './lib/sheet/excel/reader.php', '24.9', 0),
('3bb449745dbd994a2cba4c303e2b8d1a', './lib/sheet/excel/reader_ole.php', '24.9', 0),
('44646d93c3613022a4e331088ca1dd7a', './lib/sheet/excel/writer.php', '24.9', 0),
('7f0152abcd61bab379ccb3d0d23ea907', './lib/sheet/excel/writer/biffwriter.php', '24.9', 0),
('fd4814527cce2f1d55e3ff699b66e5bf', './lib/sheet/excel/writer/format.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/excel/writer/index.php', '24.9', 0),
('6ad2bd35e6140e2d1b7c91c9383c0bbb', './lib/sheet/excel/writer/parser.php', '24.9', 0),
('558edd189202062bec2b45c5ea45de82', './lib/sheet/excel/writer/validator.php', '24.9', 0),
('ae91bd9a3af1bd484f4813bfa7bb32fa', './lib/sheet/excel/writer/workbook.php', '24.9', 0),
('77292efc1040971fbee8c078eda72140', './lib/sheet/excel/writer/worksheet.php', '24.9', 0),
('ee07c8429f566cc2caef911338897339', './lib/sheet/grid.js', '24.9', 0),
('c3e05d9138cceb9d8bfbb01d0447aada', './lib/sheet/grid.php', '24.9', 0),
('bae0eab55370756d0f82c27077106287', './lib/sheet/include/core/APIC.php', '24.9', 0),
('1be36f6175a6c7df220edd4c865ccbbd', './lib/sheet/include/core/APICObject.php', '24.9', 0),
('9eb3a4a299a499a885652b7ada1b6e3c', './lib/sheet/include/core/APIClass.php', '24.9', 0),
('813b792f83360acc738feb6133cfa388', './lib/sheet/include/core/APIClassRegistry.php', '24.9', 0),
('44c971d5cdf5c0d9e2c873ac7ce3d469', './lib/sheet/include/core/ErrorManager.php', '24.9', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/sheet/include/core/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/sheet/include/index.php', '24.9', 0),
('69585f702336477a9e4e1d5efdd86afb', './lib/sheet/include/org/apicnet/index.php', '24.9', 0),
('423659eaf9ad6e38f98ae145177f7cc0', './lib/sheet/include/org/apicnet/io/File.php', '24.9', 0),
('e08bbb4b60e227175b9ab01be9b0d34a', './lib/sheet/include/org/apicnet/io/OOo/OOoCalc.php', '24.9', 0),
('7b954445244e891d6e71826c523786b1', './lib/sheet/include/org/apicnet/io/OOo/OOoDoc.php', '24.9', 0),
('e8c80a10deb6bb90a3b887f2decf431d', './lib/sheet/include/org/apicnet/io/OOo/OOoManifest.php', '24.9', 0),
('18ea5c12ebd59dce8ce9dfbbe2086f2b', './lib/sheet/include/org/apicnet/io/OOo/OOoMeta.php', '24.9', 0),
('0d4520d39070954dd9ea16b6a34fb59d', './lib/sheet/include/org/apicnet/io/OOo/OOoMime.php', '24.9', 0),
('ad4d2fba56f11e6305b359091e228ee1', './lib/sheet/include/org/apicnet/io/OOo/OOoStyle.php', '24.9', 0),
('b3f0b1a11bcef1a08227659badb054c8', './lib/sheet/include/org/apicnet/io/OOo/OOoUtil.php', '24.9', 0),
('0592b5a74b46b9bcca578e8d0368823e', './lib/sheet/include/org/apicnet/io/OOo/OOoWriter.php', '24.9', 0),
('c640f55a92004fb5ee9469d44f7e84e4', './lib/sheet/include/org/apicnet/io/OOo/absOOo.php', '24.9', 0),
('dae46a9399e4cc46ba8ffa8befd32292', './lib/sheet/include/org/apicnet/io/OOo/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoCadre.php', '24.9', 0),
('6e1d031f81e959a5ad87aa37c1f4e149', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoImg.php', '24.9', 0),
('b9c3d73b9544ad622151f26e32e8e073', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoTable.php', '24.9', 0),
('daf2faa10875e93905a3a38ef8167c4a', './lib/sheet/include/org/apicnet/io/OOo/objOOo/OOoText.php', '24.9', 0),
('dae46a9399e4cc46ba8ffa8befd32292', './lib/sheet/include/org/apicnet/io/OOo/objOOo/index.php', '24.9', 0),
('926a105e79359545f46cf8ee69c57f5d', './lib/sheet/include/org/apicnet/io/archive/CZip.php', '24.9', 0),
('57de715775c07de7aa80e3f3a55239e8', './lib/sheet/include/org/apicnet/io/archive/index.php', '24.9', 0),
('627c97eada0204fd1759f7c5c09626bd', './lib/sheet/include/org/apicnet/io/cdir.php', '24.9', 0),
('7aeb069252f1125cf619fedc8b96e3d4', './lib/sheet/include/org/apicnet/io/index.php', '24.9', 0),
('2166cfe52ef7c6d74107d3ae8f584ef1', './lib/sheet/include/org/apicnet/util/HTTPHeader.php', '24.9', 0),
('42f4f373bc696d3dd788e5a46086e1e8', './lib/sheet/include/org/apicnet/util/StringBuffer.php', '24.9', 0),
('7aeb069252f1125cf619fedc8b96e3d4', './lib/sheet/include/org/apicnet/util/index.php', '24.9', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/sheet/include/org/index.php', '24.9', 0),
('eb3bc926f010a57d6bc5bd8d191224cb', './lib/sheet/index.php', '24.9', 0),
('efe6558250fe7266f048369f97c5783e', './lib/sheet/ole.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/ole/index.php', '24.9', 0),
('a8b2fe9053395dd7d87f7e5dd17bfd29', './lib/sheet/ole/pps.php', '24.9', 0),
('6f7f84838378c7f065038dd167847f67', './lib/sheet/ole/pps/file.php', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/sheet/ole/pps/index.php', '24.9', 0),
('81b9ec66f90f013e19ce6f23d2dfa514', './lib/sheet/ole/pps/root.php', '24.9', 0),
('975baf15d0fec70258707ff91d142727', './lib/sheet/sheetlib.php', '24.9', 0),
('b2dd746a78f7dedc76f00a4a85660cfe', './lib/shipping/custom/example.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/shipping/custom/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/shipping/index.php', '24.9', 0),
('e64e99c86d510609faa5306352069e6d', './lib/shipping/provider_fedex.php', '24.9', 0),
('b150d80b67dee6b3489775f14e2ce979', './lib/shipping/provider_ups.php', '24.9', 0),
('a01fe6fe962951e58c5c0d753967f9d0', './lib/shipping/shippinglib.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/shipping/ups-wsdl/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/shoutbox/index.php', '24.9', 0),
('2b74950c4d6eb111f5724d0a60a1ca82', './lib/shoutbox/shoutboxlib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/simile_tiki/index.php', '24.9', 0),
('8602a6b74975e00a863b50447546f595', './lib/simile_tiki/tiki-timeline.js', '24.9', 0),
('fb7d513f0c859a2f5185dcf57c67c2eb', './lib/smarty_tiki/block.accordion.php', '24.9', 0),
('e5655ba29d3c8098e169fce3d0ac014a', './lib/smarty_tiki/block.accordion_group.php', '24.9', 0),
('b846a0ea9b5eff180a05d38012ad9c7c', './lib/smarty_tiki/block.actions.php', '24.9', 0),
('9163863004733bfd308cdec2baf72af7', './lib/smarty_tiki/block.activityframe.php', '24.9', 0),
('6f633f50094a48e30e29a3b3fb85187c', './lib/smarty_tiki/block.ajax_href.php', '24.9', 0),
('6c5e474f196233c6600b10413179b576', './lib/smarty_tiki/block.compact.php', '24.9', 0),
('81fac114d087ace8d5fece31980b606a', './lib/smarty_tiki/block.display.php', '24.9', 0),
('9995123ff8f209f7179abf986da1de5c', './lib/smarty_tiki/block.filter.php', '24.9', 0),
('db6adf00fb80752437af8fc4a87680a2', './lib/smarty_tiki/block.ifsearchexists.php', '24.9', 0),
('e82bade58c4efee14a53bb88f5aa3ff8', './lib/smarty_tiki/block.ifsearchnotexists.php', '24.9', 0),
('e0fc3c3d01170c844ea273a5c9e4d26b', './lib/smarty_tiki/block.itemfield.php', '24.9', 0),
('5d47165493531e674503728bbbef9cf7', './lib/smarty_tiki/block.jq.php', '24.9', 0),
('ddd82697dc3cada001fb0dc2d0dc4870', './lib/smarty_tiki/block.modules_list.php', '24.9', 0),
('01283c674c8f01097b901f8b963d0e12', './lib/smarty_tiki/block.packageplugin.php', '24.9', 0),
('e79370d74ee27128333676cdb94916ad', './lib/smarty_tiki/block.pagination_links.php', '24.9', 0),
('bf512a9db6e34a1e9af49166d8130f2b', './lib/smarty_tiki/block.permission.php', '24.9', 0),
('2572a0b8f88774e23476d471246d49ae', './lib/smarty_tiki/block.popup_link.php', '24.9', 0),
('7f16cc6dff8e8d7eeb4c8d5b7d85dbce', './lib/smarty_tiki/block.remarksbox.php', '24.9', 0),
('c393170311f1507355465f639ed2f896', './lib/smarty_tiki/block.repeat.php', '24.9', 0),
('fff3a1857990a18615e93c7747259029', './lib/smarty_tiki/block.self_link.php', '24.9', 0),
('c6bd75948984d437b32763b4d86e2dc3', './lib/smarty_tiki/block.sortlinks.php', '24.9', 0),
('2e185c3e01739e52fbcbde626ef7c7e2', './lib/smarty_tiki/block.tab.php', '24.9', 0),
('5e1cdfa751b889d572880d4b65dccd20', './lib/smarty_tiki/block.tabset.php', '24.9', 0),
('ce981cabebd95776ddb84cf7722c0802', './lib/smarty_tiki/block.textarea.php', '24.9', 0),
('e4d80f739ccfc6c228ceb905efb8a016', './lib/smarty_tiki/block.tikimodule.php', '24.9', 0),
('45d3c1efad08ef302549daf8b33bc537', './lib/smarty_tiki/block.title.php', '24.9', 0),
('11a6ce16ba3438c8f4a090eadc8cb828', './lib/smarty_tiki/block.tr.php', '24.9', 0),
('45e3291b15f8e0902dc0f86d1d7fba20', './lib/smarty_tiki/block.trackeritemcheck.php', '24.9', 0),
('d622914e1adfe1d6742c5cfaa4193f32', './lib/smarty_tiki/block.translation.php', '24.9', 0),
('66455cf994f57e5323f1c5fa6ec72f9d', './lib/smarty_tiki/block.vue.php', '24.9', 0),
('4b4ba1087f92582a8c823698cced4717', './lib/smarty_tiki/block.wiki.php', '24.9', 0),
('864b5ec17c4ba4c478126a2bd25d64f1', './lib/smarty_tiki/block.wikiplugin.php', '24.9', 0),
('2033280715ac71a44a85a61c6e36210e', './lib/smarty_tiki/compiler.assign_content.php', '24.9', 0),
('7f02f4131ff694d3518865f62f5094f5', './lib/smarty_tiki/function.activity.php', '24.9', 0),
('0f1a8d72feea4f6bafbebe8c96187d99', './lib/smarty_tiki/function.article.php', '24.9', 0),
('8fcc95b5ba63ea6e99200caa9a4ada35', './lib/smarty_tiki/function.attachments.php', '24.9', 0),
('9d850644a9fe98f6f04c3202e4e18be5', './lib/smarty_tiki/function.autocomplete.php', '24.9', 0),
('96e730acc8c10b7a48edabd7f3c1e835', './lib/smarty_tiki/function.banner.php', '24.9', 0),
('6f4b3c32ded1ff1af729e093efc6edc2', './lib/smarty_tiki/function.bootstrap_modal.php', '24.9', 0),
('7542dc8ccc1b159e619e68339716ae70', './lib/smarty_tiki/function.breadcrumbs.php', '24.9', 0),
('19a2ed8ce405dabe157dd18595dac4fd', './lib/smarty_tiki/function.button.php', '24.9', 0),
('f9c57df0231b68ab57abed9e306cfe3f', './lib/smarty_tiki/function.categoryName.php', '24.9', 0),
('af71089d502a4df4b8ff50cb51925566', './lib/smarty_tiki/function.categoryselector.php', '24.9', 0),
('6f4f8f0bcda33352e2ea8e4ddcf10b51', './lib/smarty_tiki/function.content.php', '24.9', 0),
('ad0c0cdcba1d6387d36888e8f6dcd993', './lib/smarty_tiki/function.cookie.php', '24.9', 0),
('39797f518129c4593714e9489956f961', './lib/smarty_tiki/function.cookie_jar.php', '24.9', 0),
('25631350b4f2f793e0ea6b645e4e60d2', './lib/smarty_tiki/function.count.php', '24.9', 0),
('77fb929be64ea92c3f81267429545619', './lib/smarty_tiki/function.currency.php', '24.9', 0),
('52dd3fe87d96f543c711164f82b894d1', './lib/smarty_tiki/function.custom_template.php', '24.9', 0),
('4198cdc7f7277af51d8c1c4316d2ca37', './lib/smarty_tiki/function.datetime_range.php', '24.9', 0),
('6d3449893a846eb8ed0e78f3cccb8206', './lib/smarty_tiki/function.debugger.php', '24.9', 0),
('1789e79c26bd9aa6731633214cd2aeb9', './lib/smarty_tiki/function.defaultmapcenter.php', '24.9', 0),
('f99c23519b6402ffc03d98a93e1e8304', './lib/smarty_tiki/function.ed.php', '24.9', 0),
('a4a79609d9c7d936fc3db4e0e42831e4', './lib/smarty_tiki/function.elapsed.php', '24.9', 0),
('071e32339d667f881cd5364f2b594e30', './lib/smarty_tiki/function.favorite.php', '24.9', 0),
('60b7660e7793872812544c88db20db3d', './lib/smarty_tiki/function.feedback.php', '24.9', 0),
('5c1d8e657181f57a85469f4bf493236f', './lib/smarty_tiki/function.fgal_browse.php', '24.9', 0),
('8b040bd9eb701e003aeb2ab4f4c3b713', './lib/smarty_tiki/function.file_selector.php', '24.9', 0),
('0381fd7d01f33c3bb518bdd45f948e9a', './lib/smarty_tiki/function.filegal_manager_url.php', '24.9', 0),
('b43136dfe57a2f4b6ab82123c7f5bb5e', './lib/smarty_tiki/function.filegal_uploader.php', '24.9', 0),
('75396656c57cfd3c107d39d3f2011ff8', './lib/smarty_tiki/function.fileinfo.php', '24.9', 0),
('817afe81170f5add90b141236d9a1b2d', './lib/smarty_tiki/function.formitem.php', '24.9', 0),
('eabac8a13f8221b4d2814137224e1a08', './lib/smarty_tiki/function.help.php', '24.9', 0),
('57f264406f362396b499e303a2293b9c', './lib/smarty_tiki/function.html_body_attributes.php', '24.9', 0),
('914626610436214829a5fe3f70108378', './lib/smarty_tiki/function.html_select_date.php', '24.9', 0),
('0b5c2114a2e81b2a265ec4e3a2c59dbe', './lib/smarty_tiki/function.html_select_duration.php', '24.9', 0),
('50a08e414c435afb09b2d43aeccc38a4', './lib/smarty_tiki/function.html_select_time.php', '24.9', 0),
('055fa4997acad059db010d476b56a752', './lib/smarty_tiki/function.icon.php', '24.9', 0),
('6c0aed339171c9d954c02099db1b3af4', './lib/smarty_tiki/function.initials_filter_links.php', '24.9', 0),
('7a13c80e74bcd6415eff528ec0b298a1', './lib/smarty_tiki/function.interactivetranslation.php', '24.9', 0),
('71a44cb0ec1c0cf73a71c2346565aaa4', './lib/smarty_tiki/function.js_insert_icon.php', '24.9', 0),
('090216ff8024671635f405b9a116c0ad', './lib/smarty_tiki/function.js_maxlength.php', '24.9', 0),
('59af89397874a738517fabaea2758a69', './lib/smarty_tiki/function.jscalendar.php', '24.9', 0),
('5b796ce51281a42b136e25d8fd05502c', './lib/smarty_tiki/function.jspopup.php', '24.9', 0),
('2bcca70c41a456e4a3ea2e8d61359667', './lib/smarty_tiki/function.like.php', '24.9', 0),
('e36dfd48cfa99b7950741fa6729e21d2', './lib/smarty_tiki/function.listfilter.php', '24.9', 0),
('ef91973602913e08f37b80274ad191c7', './lib/smarty_tiki/function.lock.php', '24.9', 0),
('59155e9aff38852c2974fe0ad039e8fa', './lib/smarty_tiki/function.memusage.php', '24.9', 0),
('e004a3abc0400941533c7d8f923fff9e', './lib/smarty_tiki/function.menu.php', '24.9', 0),
('2713d630fbf7e218b4f9c87d59f2bc68', './lib/smarty_tiki/function.module.php', '24.9', 0),
('b32ddf931e2c39d982ccc0c04d9e5c82', './lib/smarty_tiki/function.modulelist.php', '24.9', 0),
('cb9c829d3e06da6ae9ee32f4d0f6274b', './lib/smarty_tiki/function.monitor_link.php', '24.9', 0),
('88ccff25cdf069b340ce58ba7f209b76', './lib/smarty_tiki/function.multilike.php', '24.9', 0),
('96b04699e884a5e97f12bdaa0dde7295', './lib/smarty_tiki/function.norecords.php', '24.9', 0),
('d85e440d5ef15b08003e4cd10546e160', './lib/smarty_tiki/function.notification_link.php', '24.9', 0),
('a91522c3f5e01002e5c8aaef69b798f0', './lib/smarty_tiki/function.obj_in_cat.php', '24.9', 0),
('0c2c74900111014ce81dd311f7e5699d', './lib/smarty_tiki/function.object_link.php', '24.9', 0),
('6045c50d0f30e140bedac1ec969a31ed', './lib/smarty_tiki/function.object_score.php', '24.9', 0),
('979286c6975f7aa9e849e4050da8fbe9', './lib/smarty_tiki/function.object_selector.php', '24.9', 0),
('0b133619a7a50dcf6a76c8e5d09980d4', './lib/smarty_tiki/function.object_selector_multi.php', '24.9', 0),
('1ae853ed84fed0fdc0dce45bcbfcbca8', './lib/smarty_tiki/function.object_title.php', '24.9', 0),
('4b93b98f5c91f071b7d06b43dff5bb32', './lib/smarty_tiki/function.object_type.php', '24.9', 0),
('b42c1453b402ae4732385651b1fde0a7', './lib/smarty_tiki/function.page_alias.php', '24.9', 0),
('bd1791df9ac3b466a45b858c41e4029f', './lib/smarty_tiki/function.page_in_structure.php', '24.9', 0),
('5cd3d74fb54300f9c4e17227ed9333df', './lib/smarty_tiki/function.payment.php', '24.9', 0),
('5d283e956aff49db38e4fccda1ec04b0', './lib/smarty_tiki/function.permission_link.php', '24.9', 0),
('977617a1a01e35a39d3240bda96779b2', './lib/smarty_tiki/function.pluralize.php', '24.9', 0),
('85a8913e4ed96c5f47660e3443f82514', './lib/smarty_tiki/function.poll.php', '24.9', 0),
('cb924185543a8360ac459ee3d24f48b6', './lib/smarty_tiki/function.popup.php', '24.9', 0),
('24dd7bcc269f8b52d80f9816ffffe5d8', './lib/smarty_tiki/function.preference.php', '24.9', 0),
('c6c68ad7e4082dbd0eda279dc0a8a2e9', './lib/smarty_tiki/function.profilesymbolvalue.php', '24.9', 0),
('96e78e5f74e0426e285554fb9c7161fd', './lib/smarty_tiki/function.query.php', '24.9', 0),
('6b95922bc00de5753146ea3a538cbc2c', './lib/smarty_tiki/function.quotabar.php', '24.9', 0),
('22a56fd507dbf23659eb5c7be137e306', './lib/smarty_tiki/function.rating.php', '24.9', 0),
('c8928b4a755faf89db8e6752de62972d', './lib/smarty_tiki/function.rating_choice.php', '24.9', 0),
('990b48211b71b3e28d9430dd9854bfe5', './lib/smarty_tiki/function.rating_override_menu.php', '24.9', 0),
('959d8b03d10d97b1ce1ce472167ab887', './lib/smarty_tiki/function.rating_result.php', '24.9', 0),
('6a826051efd5010654d585d2777229dd', './lib/smarty_tiki/function.rating_result_avg.php', '24.9', 0),
('fd5078d1c7aab879bf9980b9fb47c969', './lib/smarty_tiki/function.rcontent.php', '24.9', 0),
('b50360729b77142e7ee425b0451f32cb', './lib/smarty_tiki/function.redirect.php', '24.9', 0),
('ba2579cb67f21551252ce20ec81e6b0e', './lib/smarty_tiki/function.reindex_file_pixel.php', '24.9', 0),
('f32a58640453595deb2455a028639924', './lib/smarty_tiki/function.router_params.php', '24.9', 0),
('d96225349e053f44f0aa933caa86898a', './lib/smarty_tiki/function.rss.php', '24.9', 0),
('578a3ed77cc15a6d573365e211f8d27b', './lib/smarty_tiki/function.sameurl.php', '24.9', 0),
('a2890104045ae75efee8177039585b76', './lib/smarty_tiki/function.scheduler_params.php', '24.9', 0),
('4ffc3fdaf620b1e20630c76c5f05838d', './lib/smarty_tiki/function.sefurl.php', '24.9', 0),
('f7281bdbb51cdced7cb85b1a6efdb3ed', './lib/smarty_tiki/function.select_all.php', '24.9', 0),
('da7ced7db2bf9e88fd2125853b72b96d', './lib/smarty_tiki/function.service.php', '24.9', 0),
('9f55586a65216d86266b5965d24ad827', './lib/smarty_tiki/function.service_inline.php', '24.9', 0),
('9189b547d85ecb06365e7bbe17e542e0', './lib/smarty_tiki/function.set.php', '24.9', 0),
('d1953a70467e57bd35dee9289c2165f1', './lib/smarty_tiki/function.show_sort.php', '24.9', 0),
('bcd9a87653288a4714c4f638604874f8', './lib/smarty_tiki/function.svn_lastup.php', '24.9', 0),
('1c462881a526ff9ad561812d0912e05a', './lib/smarty_tiki/function.svn_rev.php', '24.9', 0),
('c56a40f87ece7de46e1cbbea1f02f6e1', './lib/smarty_tiki/function.thumb.php', '24.9', 0),
('b372fffcd348dcd615cde19690fa9f84', './lib/smarty_tiki/function.ticket.php', '24.9', 0),
('7e549aec616faed3a0de409864ef41e8', './lib/smarty_tiki/function.toolbars.php', '24.9', 0),
('068494b4ae8633030538042c150c8f44', './lib/smarty_tiki/function.tracker_item_status_icon.php', '24.9', 0),
('591eb746d69a1899c5ef0dc556cf10de', './lib/smarty_tiki/function.trackerfields.php', '24.9', 0),
('f92d074f94dadec3981b7cb0dd8f685e', './lib/smarty_tiki/function.trackerheader.php', '24.9', 0),
('79270a702b6ddbe19422e69f667d1ead', './lib/smarty_tiki/function.trackerinput.php', '24.9', 0),
('e6a3484055aadbc51f32519308c56ecd', './lib/smarty_tiki/function.trackeroutput.php', '24.9', 0),
('69d438f92d03dc07eae569fd0b4fbe29', './lib/smarty_tiki/function.trackerrules.php', '24.9', 0),
('2ba5a4653ac413a3d161bb102ca2baea', './lib/smarty_tiki/function.treetable.php', '24.9', 0),
('1d399d76ac462bd6314570c8bc0cfe65', './lib/smarty_tiki/function.user_registration.php', '24.9', 0),
('0fd49bb3f0bb8e7820ba58d7f241a817', './lib/smarty_tiki/function.user_selector.php', '24.9', 0),
('b21253c1c36fd8f7c231f0ca37af54e0', './lib/smarty_tiki/function.var_dump.php', '24.9', 0),
('a3b74e65698e3d709b319d5e8b1034b5', './lib/smarty_tiki/function.vimeo_uploader.php', '24.9', 0),
('d5af5176d2b08cf1833a28f79c42614f', './lib/smarty_tiki/function.wikidiff.php', '24.9', 0),
('4ddc1ed5d428173639445cff38b1cbc1', './lib/smarty_tiki/function.wikistructure.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/smarty_tiki/index.php', '24.9', 0),
('9a1ac4af29e19d1b9af9e0a0fdc4c368', './lib/smarty_tiki/modifier.a_or_an.php', '24.9', 0),
('2c7df0097dc5f8d62c1b494af8d42796', './lib/smarty_tiki/modifier.adjust.php', '24.9', 0),
('25894a38c0fa780ee4eb4bd295018844', './lib/smarty_tiki/modifier.avatarize.php', '24.9', 0),
('55dd7a1591bac5089078c1d72663657a', './lib/smarty_tiki/modifier.breakline.php', '24.9', 0),
('34a8cbe3e20cac23248c9ba1fb8f5c7a', './lib/smarty_tiki/modifier.categid.php', '24.9', 0),
('27e9bdccf852d007d247e1b3203f4c26', './lib/smarty_tiki/modifier.compactisodate.php', '24.9', 0),
('0de3c43e749920cfe4e88d849bc5b8ad', './lib/smarty_tiki/modifier.countryflag.php', '24.9', 0),
('a1ab341b25e1bebcf66c18fdbe316159', './lib/smarty_tiki/modifier.dbg.php', '24.9', 0),
('b5b06951259eec4fa99179138b23f867', './lib/smarty_tiki/modifier.div.php', '24.9', 0),
('ba425f9efaea34a11a3272beb460b0a7', './lib/smarty_tiki/modifier.duration.php', '24.9', 0),
('90e55c82e69957511db1ba3b06555557', './lib/smarty_tiki/modifier.duration_short.php', '24.9', 0),
('a4acac01dacf41de3a628d799876cc74', './lib/smarty_tiki/modifier.escape.php', '24.9', 0),
('6f26e102373f1ce8d4ff58fefd82129b', './lib/smarty_tiki/modifier.file_can_convert_to_pdf.php', '24.9', 0),
('57863cbcb97bd2df84ade7ee32b2db47', './lib/smarty_tiki/modifier.file_diagram.php', '24.9', 0),
('1b1f1392fa600d268f0a705c4f8e620a', './lib/smarty_tiki/modifier.forumname.php', '24.9', 0),
('3db8d5c6b406e150c7871b6ab9276ff1', './lib/smarty_tiki/modifier.forumtopiccount.php', '24.9', 0),
('1d359a0a4589eb67c5dae3ab9f876f63', './lib/smarty_tiki/modifier.groupmembercount.php', '24.9', 0),
('4deaa3743f5f193fe75dded19aae0569', './lib/smarty_tiki/modifier.how_many_user_inscriptions.php', '24.9', 0),
('10537e67d0962c644f77a8b1c2aaf9a1', './lib/smarty_tiki/modifier.htmldecode.php', '24.9', 0),
('69f32e22b63d6528e829e72fa049eab7', './lib/smarty_tiki/modifier.iconify.php', '24.9', 0),
('d0676c504ddb77f83c1af38775f91f77', './lib/smarty_tiki/modifier.in_group.php', '24.9', 0),
('7338a5c6bad84864f931e21414068cc3', './lib/smarty_tiki/modifier.isodate.php', '24.9', 0),
('b8d70ddaea45cd731b273216af554b0d', './lib/smarty_tiki/modifier.kbsize.php', '24.9', 0),
('2d4c307f9f8c29429b01fc6a4339f051', './lib/smarty_tiki/modifier.langname.php', '24.9', 0),
('572e34ccf9ab74abbdbd64bf4b88dd01', './lib/smarty_tiki/modifier.lcfirst.php', '24.9', 0),
('2d7dae303b6861ebe68fbf6b9235b468', './lib/smarty_tiki/modifier.max_user_inscriptions.php', '24.9', 0),
('a6f4eb996d930c2de21913fddbae01e3', './lib/smarty_tiki/modifier.money_format.php', '24.9', 0),
('4705249afae3da5b0b505659a6a16c88', './lib/smarty_tiki/modifier.namespace.php', '24.9', 0),
('c504203e3afe3dc1e0f0650143d1ec31', './lib/smarty_tiki/modifier.nonamespace.php', '24.9', 0),
('dd41c7c6f5017af9450c391119e87849', './lib/smarty_tiki/modifier.nonp.php', '24.9', 0),
('ec6b62f879a64fb0f176471ca0f91dfb', './lib/smarty_tiki/modifier.number_format.php', '24.9', 0),
('e67fb96b072dabda6f677bbdbea1a43b', './lib/smarty_tiki/modifier.numstyle.php', '24.9', 0),
('640827e336928375c5758acb597c861a', './lib/smarty_tiki/modifier.output.php', '24.9', 0),
('25e691954335d970b7181854903f90e7', './lib/smarty_tiki/modifier.packageitemid.php', '24.9', 0),
('afc3e60b393efa95a8b0dfe2dd98fb89', './lib/smarty_tiki/modifier.pagename.php', '24.9', 0),
('0a1c2b8df20d14b4db9ab2989efb9365', './lib/smarty_tiki/modifier.parse.php', '24.9', 0),
('066bee750db75793a598fc6756525542', './lib/smarty_tiki/modifier.percent.php', '24.9', 0),
('770b15be16810cb0a51182a87c908dd2', './lib/smarty_tiki/modifier.quoted.php', '24.9', 0),
('a09faaf855562334b7269e546eb7e1b4', './lib/smarty_tiki/modifier.replacei.php', '24.9', 0),
('f321409b5cc5eeaf2cabec95d081e7d7', './lib/smarty_tiki/modifier.reverse_array.php', '24.9', 0),
('e5b847364a675093af36b28bed7411c8', './lib/smarty_tiki/modifier.sefurl.php', '24.9', 0),
('8273c2b2250e12ca3c4c7746a719a111', './lib/smarty_tiki/modifier.slug.php', '24.9', 0),
('530132adb5ec7c4c19110d92cac2228e', './lib/smarty_tiki/modifier.star.php', '24.9', 0),
('3f1bf6c9dec9aca89545b49f051ecc1b', './lib/smarty_tiki/modifier.stringfix.php', '24.9', 0),
('34f66ceb324c7b94925de28311748c25', './lib/smarty_tiki/modifier.substring.php', '24.9', 0),
('f0450a3da84dee2e0d6f9592b15ac3d3', './lib/smarty_tiki/modifier.tasklink.php', '24.9', 0),
('e75628f080eff9cfa9d580a4e4391806', './lib/smarty_tiki/modifier.template.php', '24.9', 0),
('d6c6d29d35ba4d35060f02a011c9891d', './lib/smarty_tiki/modifier.ternary.php', '24.9', 0),
('bae7238f5fe10ffc21b7cb8c45234733', './lib/smarty_tiki/modifier.tiki_date_format.php', '24.9', 0),
('10805f2903bc7d643ff31e711d78eb5e', './lib/smarty_tiki/modifier.tiki_long_date.php', '24.9', 0),
('07708da020abd215cf6660a066a5f733', './lib/smarty_tiki/modifier.tiki_long_datetime.php', '24.9', 0),
('8a3f45d74b99957089ab7f42188748fc', './lib/smarty_tiki/modifier.tiki_long_time.php', '24.9', 0),
('5de69b9700a3aedf378fe097136aa602', './lib/smarty_tiki/modifier.tiki_remaining_days_from_now.php', '24.9', 0),
('2bc47dc01a4c7b61f8963c26f9161025', './lib/smarty_tiki/modifier.tiki_short_date.php', '24.9', 0),
('e9ae57e11f129ea8cbb59e61cc5f989d', './lib/smarty_tiki/modifier.tiki_short_datetime.php', '24.9', 0),
('881d85bb7f6b2bc9433a50ae8f336de5', './lib/smarty_tiki/modifier.tiki_short_time.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('c95634f58bcbe742a9a8eb7253d8dcf3', './lib/smarty_tiki/modifier.times.php', '24.9', 0),
('b64f94b92ee987ab5a3686d28d40e95b', './lib/smarty_tiki/modifier.tr_if.php', '24.9', 0),
('7fd72ca59709ffe8cca8c1b654736328', './lib/smarty_tiki/modifier.truex.php', '24.9', 0),
('66c96d652b84226f28de359e200410df', './lib/smarty_tiki/modifier.truncate.php', '24.9', 0),
('f23ea1e16b30794dfc882d24ab91f4de', './lib/smarty_tiki/modifier.userlink.php', '24.9', 0),
('bc48d0836bc4d0053a80fd326e31f219', './lib/smarty_tiki/modifier.username.php', '24.9', 0),
('b6920dd1dd5edf99beb7ee19529e8714', './lib/smarty_tiki/modifier.utf8unicode.php', '24.9', 0),
('9210dbec8c30c852ea3b37e0b1d77c7d', './lib/smarty_tiki/modifier.virtual_path.php', '24.9', 0),
('eeeb8f6d1a1c3a560bff3fd0786e55f7', './lib/smarty_tiki/modifier.yesno.php', '24.9', 0),
('207f832ee47ce80be0cbad6147902ce7', './lib/smarty_tiki/outputfilter.highlight.php', '24.9', 0),
('d15005546715deb1bd1dd026f6606c33', './lib/smarty_tiki/outputfilter.ticket.php', '24.9', 0),
('f28fe4c8f2728899838891bddf818159', './lib/smarty_tiki/prefilter.jq.php', '24.9', 0),
('975288e99b61f42a81934d2313518ab5', './lib/smarty_tiki/prefilter.log_tpl.php', '24.9', 0),
('d382de7f84b8bc8a2878ee5f4139f145', './lib/smarty_tiki/prefilter.tr.php', '24.9', 0),
('42d30a176d4f83830dab5f668a86f8a4', './lib/smarty_tiki/resource.tplwiki.php', '24.9', 0),
('5d907e1d7663e6ecaa90ff6123186b55', './lib/smarty_tiki/resource.wiki.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/soap/index.php', '24.9', 0),
('85191d3dac0e41a8267ec968f974baa8', './lib/soap/nusoap/index.php', '24.9', 0),
('c99c56ecbcdcc9e32d614088c10a43e9', './lib/soap/nusoap/nusoap.php', '24.9', 0),
('64d22e5719fa6a7c3201b23b4379b0e3', './lib/soap/soaplib.php', '24.9', 0),
('6098cdd0436687d4018cc42470a14339', './lib/soap/tiki-admin_webservices.js', '24.9', 0),
('39a0ec25a20028c369b9e49f5ad460cc', './lib/soap/wsdllib.php', '24.9', 0),
('6667ec2013b8c82ddc7eb36d55c4b0c2', './lib/socialnetworkslib.php', '24.9', 0),
('6941cdf09ff609ac0d567011095849f3', './lib/socnets/LLOG.php', '24.9', 0),
('6037224e07a2f40b2f7b24a8fdea3ec6', './lib/socnets/PrefsGen.php', '24.9', 0),
('ccd91fbcc62694b127dbacdf43e5f89a', './lib/socnets/TikiHybrid.php', '24.9', 0),
('9ec3bcadd5e725b287bb15c82610057a', './lib/socnets/Util.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/socnets/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/stats/index.php', '24.9', 0),
('2324af02e286d816707d14db073ea31a', './lib/stats/statslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/structures/index.php', '24.9', 0),
('e41a2754b694314528e842a84b452618', './lib/structures/structlib.php', '24.9', 0),
('a660468a3f3bc56f34cd2d1852d398d4', './lib/structures/tiki-edit_structure.js', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/surveys/index.php', '24.9', 0),
('15d91a59a7ad31f43189db74793b0825', './lib/surveys/surveylib.php', '24.9', 0),
('1ebf12c0b06b049ffec3bb78d0eed0c5', './lib/surveys/tiki-admin_survey_questions.js', '24.9', 0),
('2b6f7962df617d30dd82166cb3696b39', './lib/svg-edit_tiki/draw.js', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/svg-edit_tiki/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/swfobject/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/swfobject/src/index.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/taglines/index.php', '24.9', 0),
('fc9f58380f0422582517da1de2802fd2', './lib/taglines/taglinelib.php', '24.9', 0),
('1772370ac42627c83363d4e4a7f0ccb1', './lib/tail/index.php', '24.9', 0),
('6f7d3f1fe3457f50ccd3f9a925ba385a', './lib/tar.class.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/tasks/index.php', '24.9', 0),
('0684da4103a45fdfd610be50d464cf72', './lib/tasks/tasklib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/templates/index.php', '24.9', 0),
('9a674119fecc3743453833d4fe6b2ce1', './lib/templates/templateslib.php', '24.9', 0),
('aac196709ff608f0b484249de7f5456d', './lib/test/AcceptanceTests/AllTests.php', '24.9', 0),
('706d357a285845bc92b012afdd7f23ef', './lib/test/AcceptanceTests/CollaborativeMultilingualTerminologyTest.php', '24.9', 0),
('ce73ded2601717019b4aa1c5791878bf', './lib/test/AcceptanceTests/ListPagesTest.php', '24.9', 0),
('029a9c432787f832b6bb8d9310a6fb20', './lib/test/AcceptanceTests/MultilingualTest.php', '24.9', 0),
('bec440de48baee12b8b5b88429cbe0b3', './lib/test/AcceptanceTests/MultilinguallibTest.php', '24.9', 0),
('e819cdaadd7286e228fe3e615dd9d92e', './lib/test/AcceptanceTests/SearchTest.php', '24.9', 0),
('0d5e10d2b669a074aca7d98fc75fb5a5', './lib/test/AcceptanceTests/TikiLibrariesAccessTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/AcceptanceTests/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/AcceptanceTests/utils/index.php', '24.9', 0),
('f36b1838e963a2f7ae445564332d2910', './lib/test/AcceptanceTests/utils/upgrade_test_database_dump_file.php', '24.9', 0),
('ec8ab68e373c1b6f74de2d1d819f2787', './lib/test/AllTestsAcceptance.php', '24.9', 0),
('3b736c52c37561d3c653180132a72361', './lib/test/Calendar/DateTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/Calendar/index.php', '24.9', 0),
('a16e57cc9ea4dc5c7bb5e5e49ba3c71e', './lib/test/ContinuousIntegationTesting.php', '24.9', 0),
('704e01ee59e36ebc77c596386154c015', './lib/test/FileChecks/allTikiPhpFilesTest.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './lib/test/FileChecks/index.php', '24.9', 0),
('49adab442b913bf1b78633ab97b9fc42', './lib/test/IntegrationTests/MLModelTest.php', '24.9', 0),
('6d1c4dc2a4cea36614ecd0585ed0a137', './lib/test/IntegrationTests/TrackerDatesTimezoneTest.php', '24.9', 0),
('81863e8d9ba13aa48e97cd9992625bae', './lib/test/IntegrationTests/TrackerItemPermissionTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/IntegrationTests/index.php', '24.9', 0),
('ceeb81726c0923671902c7193bb4703a', './lib/test/MultilingualLibTest.php', '24.9', 0),
('627c40674b472b6c13ff8bee2714d03f', './lib/test/TestHelpers.php', '24.9', 0),
('379e905d517465e086d4db8fa3269be9', './lib/test/TestHelpers/GlobRecursiveHelper.php', '24.9', 0),
('50cc8258c4a76bb6bee05474aa1a1e8e', './lib/test/TestHelpers/TikiDbHelper.php', '24.9', 0),
('6e7682c6ca11ef57ce79af5a389244b0', './lib/test/TestHelpers/TikiProfileHelper.php', '24.9', 0),
('86b1e7dc6667143a62308f9b6aed764b', './lib/test/TestHelpers/WebClientHelper.php', '24.9', 0),
('76ee817874053d1fa39cc9f1a2847b50', './lib/test/TestHelpers/cli/create_dump_db_file.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/TestHelpers/cli/index.php', '24.9', 0),
('28792e1689a8809d79657ac1100e9042', './lib/test/TestHelpers/cli/restore_db_dump.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/TestHelpers/index.php', '24.9', 0),
('507e6550a6d1c944a6d5bfb263fc2553', './lib/test/TestRunnerWithBaseline.php', '24.9', 0),
('9a271921db8479801be248a122d3aa9c', './lib/test/TestRunnerWithBaselineTest.php', '24.9', 0),
('1bcee828e470438c02e206e255e5875f', './lib/test/TestableTikiLib.php', '24.9', 0),
('7aba2248a2a1c2fdd5d7d0705badf5c6', './lib/test/TikiAcceptanceTestDBRestorer.php', '24.9', 0),
('e31a7284466114a9a621b2fcbf75ea08', './lib/test/TikiDatabaseTestCase.php', '24.9', 0),
('e3d87e2751a6acd3319b1aaa97712816', './lib/test/TikiLib/LibTest.php', '24.9', 0),
('6c4d1f9dd2fdf3ec66ab0b393af10313', './lib/test/TikiLib/MultiExplodeTest.php', '24.9', 0),
('836254f0a15cccc0945037653d9bbf8d', './lib/test/TikiLib/TestableTikiLibTest.php', '24.9', 0),
('d45cce2734bfa8bb9c232e54594a5537', './lib/test/TikiLib/TikiLibTest.php', '24.9', 0),
('9bcbd59cbb132565abf93514d4a97d1d', './lib/test/TikiLib/UriMergeTest.php', '24.9', 0),
('226f0fda577040399e3db4f6b9fa6bc1', './lib/test/TikiLib/UrlEncodeAccentTest.php', '24.9', 0),
('bfa6c44e8ecf6c61a24781f71da2796a', './lib/test/TikiLib/UserLibTest.php', '24.9', 0),
('53e42089b0b1cee922cedc4fa8cbc71b', './lib/test/TikiLib/UserWatchesTest.php', '24.9', 0),
('1e0a5885f7b79bc7000f379842534aca', './lib/test/TikiLib/WikiParserTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/TikiLib/index.php', '24.9', 0),
('55f1616be32b99b4a5e93070ca232ed1', './lib/test/TikiSeleniumTestCase.php', '24.9', 0),
('bd3753c428d372a918f112a79dbe149f', './lib/test/TikiTestCase.php', '24.9', 0),
('259cc87321b5f98541187388a2c69f2d', './lib/test/TikiVersionTest.php', '24.9', 0),
('08f5cc2b6b9f09e3edf625a002f4c388', './lib/test/attributes/AttributeTest.php', '24.9', 0),
('a3a28da576d9afb32a20c8b5aada2b5f', './lib/test/attributes/RelationTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/attributes/index.php', '24.9', 0),
('4b5be6924c86e1571ba83c247f9f5257', './lib/test/auth/AuthTokensTest.php', '24.9', 0),
('3a1a697a0473cc072cb6893f99dee849', './lib/test/auth/MembershipTest.php', '24.9', 0),
('7d79fd56e334df673a7931ff9a1b0745', './lib/test/auth/PasswordTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/auth/fixtures/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/auth/index.php', '24.9', 0),
('43f8e7112f784637ea6f1eee5aaafabe', './lib/test/bigbluebutton/DynamicConfigurationTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/bigbluebutton/index.php', '24.9', 0),
('e7797b7bf65e52d20b6c99dac3b8e1a4', './lib/test/bootstrap.php', '24.9', 0),
('9a84fea946a6d4d5803a508f0b0902e4', './lib/test/comments/CommentsTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/comments/index.php', '24.9', 0),
('821f259f6ce412afa34b2a27768294f4', './lib/test/core/Category/ManipulatorTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Category/index.php', '24.9', 0),
('19d4e1f1adfee59dab42a637cd5a33ef', './lib/test/core/Connect/ClientTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Connect/index.php', '24.9', 0),
('fbd1af2daaa34ff1e53dca6aa60222d9', './lib/test/core/CustomRoute/ControllerTest.php', '24.9', 0),
('b0047d3db4e3bf8f8599d34ad8473531', './lib/test/core/CustomRoute/CustomRouteTest.php', '24.9', 0),
('934f5ac04d715ee37a5d062b0e275bf5', './lib/test/core/CustomRoute/ItemTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/CustomRoute/index.php', '24.9', 0),
('340e80ee726e67921aef910ad889cb46', './lib/test/core/DeclFilter/BaseTest.php', '24.9', 0),
('991bfcff498d0deccba91ac9d4eeea98', './lib/test/core/DeclFilter/CatchAllFilterTest.php', '24.9', 0),
('3518e9d4a6ce670ef2d5bba24dcee548', './lib/test/core/DeclFilter/CatchAllUnsetTest.php', '24.9', 0),
('9ec99cfc91d362fa8a9590debc83b0d3', './lib/test/core/DeclFilter/ConfigureTest.php', '24.9', 0),
('7ff2f1441f614d1cd902f3d1ee206eda', './lib/test/core/DeclFilter/KeyPatternFilterTest.php', '24.9', 0),
('7e537602e2f1fb336583ab68bdd33740', './lib/test/core/DeclFilter/KeyPatternUnsetTest.php', '24.9', 0),
('2ab7db45b555f606a10abb8a9a180f9e', './lib/test/core/DeclFilter/StaticKeyFilterTest.php', '24.9', 0),
('fab436368c5898750e036159593bc610', './lib/test/core/DeclFilter/StaticKeyUnsetTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/DeclFilter/index.php', '24.9', 0),
('1aa280e6ba6e4d72e53803fbdbf66021', './lib/test/core/Event/CustomizerTest.php', '24.9', 0),
('180666be1877fc23520f088e21c4472b', './lib/test/core/Event/ManagerTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Event/index.php', '24.9', 0),
('f52c60945976c015e9d8addee00eba21', './lib/test/core/File/FileHelperTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/File/index.php', '24.9', 0),
('b56a03eec52205e463656557338ca8bb', './lib/test/core/Files/CheckAttachmentGalleryTest.php', '24.9', 0),
('30a0394aab3597b03c6c34cd3e0253dd', './lib/test/core/Files/CheckFileGalleryTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Files/index.php', '24.9', 0),
('065803898368f6c161329fb0458b3d83', './lib/test/core/JitFilter/AccessTest.php', '24.9', 0),
('cd63b53582cefdacb71906fcc27b7312', './lib/test/core/JitFilter/FilterTest.php', '24.9', 0),
('f117b4ecf6ea5b180bdc92d62e3986cd', './lib/test/core/JitFilter/IteratorTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/JitFilter/index.php', '24.9', 0),
('82a4f17e2d970afc211ce19da0056e8a', './lib/test/core/Math/Formula/CurrencyTest.php', '24.9', 0),
('bf9b6cc85431c5e78ebd976d753105f1', './lib/test/core/Math/Formula/DummyFunction/FortyTwo.php', '24.9', 0),
('7bb57ebfcad6568aef0b24c649934fe8', './lib/test/core/Math/Formula/DummyFunction/Testop.php', '24.9', 0),
('97f062d31145fabca0b65e615d31dd61', './lib/test/core/Math/Formula/DummyFunction/index.php', '24.9', 0),
('44534adb4c962f9354ddffe6eab63c41', './lib/test/core/Math/Formula/ElementTest.php', '24.9', 0),
('00f496a49fd3c5aa8af975c5b1185980', './lib/test/core/Math/Formula/ParserTest.php', '24.9', 0),
('fdaa08e904770f4dcc9e1d657e6cfc78', './lib/test/core/Math/Formula/RunnerTest.php', '24.9', 0),
('491a75d67768ee0ec9fc7627dc98c50b', './lib/test/core/Math/Formula/TokenizerTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Math/Formula/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Math/index.php', '24.9', 0),
('438f353be27f955c5c40f1216e799787', './lib/test/core/Multilingual/Aligner/BilingualAlignerTest.php', '24.9', 0),
('e81a5568469fd0fce0cb326049db662f', './lib/test/core/Multilingual/Aligner/SentenceAlignmentsTest.php', '24.9', 0),
('364b94282a50d697ba9a2c910ee837cd', './lib/test/core/Multilingual/Aligner/SentenceSegmentorTest.php', '24.9', 0),
('91bfb24963f076580d087863911788ef', './lib/test/core/Multilingual/Aligner/ShortestPathFinderTest.php', '24.9', 0),
('bdb31bf2276745c123024ce50c2b3af6', './lib/test/core/Multilingual/Aligner/UpdatePagesTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Multilingual/Aligner/index.php', '24.9', 0),
('55d49ba1cb52393b7541b16470ab9b44', './lib/test/core/Multilingual/MachineTranslation/GoogleTranslateWrapperTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Multilingual/MachineTranslation/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Multilingual/index.php', '24.9', 0),
('3e769db90ed4beb389d6d9d605a1dfbf', './lib/test/core/Notifications/EmailTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Notifications/index.php', '24.9', 0),
('0afe491755e9107d3f488d2af923315c', './lib/test/core/ObjectSelector/ObjectSelectorTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/ObjectSelector/index.php', '24.9', 0),
('97df69898f0ea1da13925a364ec19d8a', './lib/test/core/Perms/AccessorTest.php', '24.9', 0),
('fd4fe66f210da4e0ac8091f6033e1006', './lib/test/core/Perms/ApplierTest.php', '24.9', 0),
('64945ab48137646d14c0ff0ea4f0df41', './lib/test/core/Perms/BaseTest.php', '24.9', 0),
('0537155a09e120e3a30e7672e006d249', './lib/test/core/Perms/BuilderTest.php', '24.9', 0),
('55fe828aaebdf94fe2a95438aca71c5f', './lib/test/core/Perms/Check/AlternateTest.php', '24.9', 0),
('9cbbeee4f998cc2b6a9640dd2ae644b4', './lib/test/core/Perms/Check/CreatorTest.php', '24.9', 0),
('0f33c6b502ace9fa935120f716270e00', './lib/test/core/Perms/Check/DirectTest.php', '24.9', 0),
('f11309ece0780712b69e3838fdfaf321', './lib/test/core/Perms/Check/IndirectTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Perms/Check/index.php', '24.9', 0),
('36be075b7ad750191c1bc1f46030f8c9', './lib/test/core/Perms/CheckSequenceTest.php', '24.9', 0),
('47a53cdeae9df398b822ea6639d1b974', './lib/test/core/Perms/MixedTest.php', '24.9', 0),
('f950b4dc5754530514e829d874929f99', './lib/test/core/Perms/Reflection/FactoryTest.php', '24.9', 0),
('b4903df45eee024d0d75dfd534ae6196', './lib/test/core/Perms/Reflection/PermissionComparatorTest.php', '24.9', 0),
('b94517196378fed7a5d195ffaae698e2', './lib/test/core/Perms/Reflection/PermissionSetTest.php', '24.9', 0),
('adf3fc607b052eb3d09b8d390ce5b508', './lib/test/core/Perms/Reflection/QuickTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Perms/Reflection/index.php', '24.9', 0),
('20a297f8f96192499bee77ca4b4be3e5', './lib/test/core/Perms/Resolver/DefaultTest.php', '24.9', 0),
('924c81647999496a0fb1dc8ac81c6466', './lib/test/core/Perms/Resolver/StaticTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Perms/Resolver/index.php', '24.9', 0),
('60bf8601c8ce38fe31833dee46ed394b', './lib/test/core/Perms/ResolverFactory/CategoryFactoryTest.php', '24.9', 0),
('2842a26c4ed58e7d2cc55da62406b655', './lib/test/core/Perms/ResolverFactory/GlobalFactoryTest.php', '24.9', 0),
('80b113264c097c42cad52366b11e3ed7', './lib/test/core/Perms/ResolverFactory/ObjectFactoryTest.php', '24.9', 0),
('50ad95cbbac587cab4fc7d98715e4d5e', './lib/test/core/Perms/ResolverFactory/TestFactoryTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Perms/ResolverFactory/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Perms/index.php', '24.9', 0),
('1423f014f9bf926ff59711259b482da5', './lib/test/core/Recommendation/BatchTest.php', '24.9', 0),
('efdd9dd7d3874ad951b24fe82425f4e1', './lib/test/core/Recommendation/ComparatorTest.php', '24.9', 0),
('7d1639c0dc9bfdd5c995548799ac4141', './lib/test/core/Recommendation/EngineSetTest.php', '24.9', 0),
('59c8c247565bc0d69e380522b1f7cfb1', './lib/test/core/Recommendation/RecommendationSetTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Recommendation/index.php', '24.9', 0),
('01870b5c58d562c151fd513e5f5f7824', './lib/test/core/Reports/CacheTest.php', '24.9', 0),
('9dc43801af02a1f9bfcd7539849b4281', './lib/test/core/Reports/FactoryTest.php', '24.9', 0),
('8da08d4f2d5970a32f4976c960d1c294', './lib/test/core/Reports/ManagerTest.php', '24.9', 0),
('837d4c36efda0d3fbe4e35adb7eddd3a', './lib/test/core/Reports/ReportsEndToEndTest.php', '24.9', 0),
('1e4fddb0681162f2b84a877920e4b832', './lib/test/core/Reports/Send/EmailBuilderTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Reports/Send/index.php', '24.9', 0),
('8fc795c750c47a77b0a8b3b98c12426a', './lib/test/core/Reports/SendTest.php', '24.9', 0),
('a75e6fb7f4a40f244b3eb20affba028f', './lib/test/core/Reports/UsersTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Reports/fixtures/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Reports/index.php', '24.9', 0),
('7bd08413c9e1ac41f6859f84f10ebc44', './lib/test/core/Request/RequestTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Request/index.php', '24.9', 0),
('3329b112b3fc77b23069d9a3b5443f5f', './lib/test/core/Scheduler/ItemTest.php', '24.9', 0),
('1d2bc259c9bb3d10ade1e4eda4805d65', './lib/test/core/Scheduler/ManagerTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Scheduler/index.php', '24.9', 0),
('fe1f5b0e790bbfa53d2f0070cb08d835', './lib/test/core/Search/ActionStepTest.php', '24.9', 0),
('782be506d3d0ef20a0cebae3df30e7ba', './lib/test/core/Search/Elastic/BaseTest.php', '24.9', 0),
('fc70c71cd94388530836df09ad132b89', './lib/test/core/Search/Elastic/BulkIncrementalUpdateTest.php', '24.9', 0),
('8e82952727492353c325f43c84fd31b6', './lib/test/core/Search/Elastic/BulkIndexingTest.php', '24.9', 0),
('76181878dba87e915e3f688c59cff69b', './lib/test/core/Search/Elastic/CamelCaseTest.php', '24.9', 0),
('3d080edc20fdd1daaf3122a4602cd2d4', './lib/test/core/Search/Elastic/FacetBuilderTest.php', '24.9', 0),
('177ca9c87aa5ac0e81519932d083d7ae', './lib/test/core/Search/Elastic/FacetReaderTest.php', '24.9', 0),
('4e6b7d842fe6ae921029fa93e56d6257', './lib/test/core/Search/Elastic/FacetTest.php', '24.9', 0),
('f83cb5fa6d9700f1caa5ce7ff1ca190a', './lib/test/core/Search/Elastic/FederatedQueryTest.php', '24.9', 0),
('3240c29c7e81de29c1e99461d3c632b3', './lib/test/core/Search/Elastic/IncrementalUpdateTest.php', '24.9', 0),
('c8390937339e448e3be8d12419c51bc3', './lib/test/core/Search/Elastic/MoreLikeThisTest.php', '24.9', 0),
('e6d3a7153b924d613bfbb500fdf56ab3', './lib/test/core/Search/Elastic/NumericTest.php', '24.9', 0),
('8de61d762428e510429d106121596504', './lib/test/core/Search/Elastic/PaginationTest.php', '24.9', 0),
('7c034428be88cf1aadb626e365d2d24d', './lib/test/core/Search/Elastic/PartialUpdateTest.php', '24.9', 0),
('16c6368a6801788c60cd7f16dd0735a0', './lib/test/core/Search/Elastic/PrefilterTest.php', '24.9', 0),
('90092bf98ec07a364553d185d3f575ba', './lib/test/core/Search/Elastic/ProtocolTest.php', '24.9', 0),
('eaba18c4e3a18d6ea0b2cd8d204c6f56', './lib/test/core/Search/Elastic/QueryBuilderTest.php', '24.9', 0),
('40534ce5362a43a4930194531adcd002', './lib/test/core/Search/Elastic/QueryRepositoryTest.php', '24.9', 0),
('ea3e53f7381e5837b1964ef3fdb2904e', './lib/test/core/Search/Elastic/RescoreQueryBuilderTest.php', '24.9', 0),
('596b06f7fe31858826b7a1a508cebf26', './lib/test/core/Search/Elastic/SortTest.php', '24.9', 0),
('6de0bd9b89e40c5c5c89743b3e0e125b', './lib/test/core/Search/Elastic/StemmingTest.php', '24.9', 0),
('102c01a04701f74e34be40e23ba848cc', './lib/test/core/Search/Elastic/TypeAnalyzerTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Search/Elastic/index.php', '24.9', 0),
('04b2f8bb6ffbd3e65e747e8156abb838', './lib/test/core/Search/Expr/ParserTest.php', '24.9', 0),
('58cd6ad6156b2b544ecdb4e6ebd6c54c', './lib/test/core/Search/Expr/TokenizerTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Search/Expr/index.php', '24.9', 0),
('f44000f4d210cc3396853f13247357e0', './lib/test/core/Search/Formatter/ArrayBuilderTest.php', '24.9', 0),
('edd7882146a19e119ce63976a4e19c9c', './lib/test/core/Search/Formatter/DataSourceTest.php', '24.9', 0),
('d394f37797b3391503d55d02b8f61133', './lib/test/core/Search/Formatter/FactoryTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Search/Formatter/index.php', '24.9', 0),
('3a1e7f04949c832a156833516ab15a63', './lib/test/core/Search/FormatterTest.php', '24.9', 0),
('88c69d24526d9c70aa7cd0022fd4f056', './lib/test/core/Search/GlobalSource/PermissionSourceTest.php', '24.9', 0),
('ad0473c5fb8c44ade719481a50d45fce', './lib/test/core/Search/GlobalSource/TitleInitialTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Search/GlobalSource/index.php', '24.9', 0),
('9aef8aa7be9ec01f64ef827f146fa834', './lib/test/core/Search/Index/BaseTest.php', '24.9', 0),
('61d971d1069dd7363ba1294e95a08ac9', './lib/test/core/Search/Index/IncrementalUpdateTest.php', '24.9', 0),
('7fc19d07a4ebd9e5853bdadfcfe967b1', './lib/test/core/Search/Index/NumericTest.php', '24.9', 0),
('f548369bbb5f7eec56a7d9c597c5603d', './lib/test/core/Search/Index/PaginationTest.php', '24.9', 0),
('99216911cfc726d36df95aac9cc66bf6', './lib/test/core/Search/Index/PartialUpdateTest.php', '24.9', 0),
('814e4fff3820f4b103b196cd447e3a3f', './lib/test/core/Search/Index/SortTest.php', '24.9', 0),
('7346e93e8fb8b613c0cdd9b7d51c6f0a', './lib/test/core/Search/Index/StemmingTest.php', '24.9', 0),
('022c2eb7e763f1d24dd76c200f90c83a', './lib/test/core/Search/Index/TypeAnalyzerTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Search/Index/index.php', '24.9', 0),
('f43425af1e00f1b6885d05c1f6a0142f', './lib/test/core/Search/IndexerTest.php', '24.9', 0),
('6199437ffaa6c122326e448b10b179fa', './lib/test/core/Search/MySql/BaseTest.php', '24.9', 0),
('0e6fb4f707ebad6c94ecce40b51a5ab9', './lib/test/core/Search/MySql/IncrementalUpdateTest.php', '24.9', 0),
('52fbb0387b41f36e34f3fedee4883ad8', './lib/test/core/Search/MySql/LargeDatasetTest.php', '24.9', 0),
('ea040a1e57fbe4bb4cbfa4ebfc19a4de', './lib/test/core/Search/MySql/PaginationTest.php', '24.9', 0),
('eda44f833ae4f72d759e73b48951c2db', './lib/test/core/Search/MySql/PartialUpdateTest.php', '24.9', 0),
('60548474f921a14e2f686b7c3cef4baa', './lib/test/core/Search/MySql/QueryBuilderTest.php', '24.9', 0),
('45771b6d614620e044b3ac94b0e888ea', './lib/test/core/Search/MySql/SortTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Search/MySql/index.php', '24.9', 0),
('643f30dfefb86bb755993e7712c14988', './lib/test/core/Search/Query/OrderTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Search/Query/index.php', '24.9', 0),
('0ebb69a6dd533297c9990acae76b67ef', './lib/test/core/Search/QueryTest.php', '24.9', 0),
('2721aaeaae6003f973cb3032f92ea6e4', './lib/test/core/Search/TypeAnalyzerTest.php', '24.9', 0),
('b5bb7ed52a3653a44c5670960a555d07', './lib/test/core/Search/basic.tpl', '24.9', 0),
('4afd33d3c9c4ae07e8fc871fec015a94', './lib/test/core/Search/embedded.tpl', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Search/index.php', '24.9', 0),
('bc3ddd82fa365989ae34360b416e95ce', './lib/test/core/Search/paginate.tpl', '24.9', 0),
('b1da3e35d0097f0848a1c9ce1521385e', './lib/test/core/Services/Comment/ControllerTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Services/Comment/index.php', '24.9', 0),
('63e808c427ff4e44907c1a09e4a2b025', './lib/test/core/Services/Encryption/ControllerTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Services/Encryption/index.php', '24.9', 0),
('8a6059359a69c477d00433ff3fdee0f8', './lib/test/core/Services/ResultLoaderTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Services/index.php', '24.9', 0),
('8c9376d93fa1876447f8b91bc7fa220e', './lib/test/core/Tiki/Command/ListExecute/ExecuteTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/Command/ListExecute/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/Command/ProfileExport/Fixtures/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/Command/ProfileExport/Fixtures/test/index.php', '24.9', 0),
('35c7b397402cee22a2bafa069de94cdb', './lib/test/core/Tiki/Command/ProfileExport/TrackerItemTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/Command/ProfileExport/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/Command/index.php', '24.9', 0),
('aebafeea61e98d6d29d65a1da9b829b4', './lib/test/core/Tiki/FileGallery/DefinitionTest.php', '24.9', 0),
('3e96be9efe04c623273c00dc2e737560', './lib/test/core/Tiki/FileGallery/FileDraftTest.php', '24.9', 0),
('4fcda442669fea0bacfbbf87bcb3efc3', './lib/test/core/Tiki/FileGallery/FileTest.php', '24.9', 0),
('c0c5b63a5e4f22df3f83ac6cfec8331f', './lib/test/core/Tiki/FileGallery/Manipulator/ImageTransformerTest.php', '24.9', 0),
('19620e5193fbc7b867e9a96e8827e551', './lib/test/core/Tiki/FileGallery/Manipulator/MetadataExtractorTest.php', '24.9', 0),
('8907f3993148200e09cad96b1cb91382', './lib/test/core/Tiki/FileGallery/Manipulator/ValidatorTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/core/Tiki/FileGallery/Manipulator/index.php', '24.9', 0),
('517f239d3a66d07d2d951840a4a0e7f4', './lib/test/core/Tiki/FileGallery/SaveHandlerTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/FileGallery/index.php', '24.9', 0),
('167736757ed8f76d182f852927ca4646', './lib/test/core/Tiki/Package/ComposerCliTest.php', '24.9', 0),
('b09563ea27f2bdaca63f29036bbcdaf9', './lib/test/core/Tiki/Package/ComposerManagerTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/core/Tiki/Package/Fixtures/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/Package/index.php', '24.9', 0),
('96bfe23b46b21392d6398e4720ded278', './lib/test/core/Tiki/ProfileTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tiki/index.php', '24.9', 0),
('1e7fab2880692eb40910c4cd298f2a47', './lib/test/core/TikiDb/SanitizeEncodingTest.php', '24.9', 0),
('f7e96b79cc4fadfa8bbd8dddd64f1766', './lib/test/core/TikiDb/TableTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/TikiDb/index.php', '24.9', 0),
('d2e311375742ab879468f978f92a4b8b', './lib/test/core/TikiFilter/CallbackTest.php', '24.9', 0),
('6c262563b7ce2a32b94a8175000af83f', './lib/test/core/TikiFilter/MapTest.php', '24.9', 0),
('9f654771864692ffbf45a0ed26ae3bf9', './lib/test/core/TikiFilter/PrepareInputTest.php', '24.9', 0),
('2588b1b0e78e5f9e0310762877995ac9', './lib/test/core/TikiFilter/WordTest.php', '24.9', 0),
('b8aee0bac0e5acd02ba9099dda3aa032', './lib/test/core/TikiFilter/XssTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/TikiFilter/index.php', '24.9', 0),
('ba52a14f9dc60af5f821837898daff92', './lib/test/core/TikiSecurityTest.php', '24.9', 0),
('c55b60a079983121a376dd2eccb7dae3', './lib/test/core/Tracker/OptionsTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Tracker/index.php', '24.9', 0),
('6bbc0e7228616489bd596d7011158a92', './lib/test/core/Transition/AtLeastTest.php', '24.9', 0),
('700dfd5fa00ac69b1973024e6942fe15', './lib/test/core/Transition/AtMostTest.php', '24.9', 0),
('80c74bec8c6e4e66b26412f8cd6f7311', './lib/test/core/Transition/BasicTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Transition/index.php', '24.9', 0),
('d86ef73fe68f4ce3aed9cc4ca67c0397', './lib/test/core/Wiki/SlugManagerTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Wiki/index.php', '24.9', 0),
('d2a26a874d3912b2c17adb6ad6f17941', './lib/test/core/WikiParser/OutputLinkTest.php', '24.9', 0),
('37b51c9056370d2f8f305bc864ce8c55', './lib/test/core/WikiParser/PluginArgumentParserTest.php', '24.9', 0),
('16fdebcd00ab37ad3bf8ea338f2fd907', './lib/test/core/WikiParser/PluginMatcherTest.php', '24.9', 0),
('a5668a05b71431bed41daf92437d52a5', './lib/test/core/WikiParser/PluginOutputTest.php', '24.9', 0),
('4269116b4a3247bf5feba46119b5bea2', './lib/test/core/WikiParser/PluginParserTest.php', '24.9', 0),
('f998619d6b6b78b7d3cff264f171c632', './lib/test/core/WikiParser/PluginRepositoryTest.php', '24.9', 0),
('aa24f302d0656549b688009321181c64', './lib/test/core/WikiParser/StressTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/core/WikiParser/index.php', '24.9', 0),
('b3dbf3cadd60e7e56fdbf2e1543587a1', './lib/test/core/WikiParser/wikiplugin_foo.php', '24.9', 0),
('ca3b85247cc14c4b65eb8257c5293a55', './lib/test/core/Workspace/AnalyserTest.php', '24.9', 0),
('39237deb498030331f21214196f42932', './lib/test/core/Workspace/BuilderTest.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/test/core/Workspace/index.php', '24.9', 0),
('d909b67893c27a45d5627f741335d579', './lib/test/core/Yaml/DirectivesTest.php', '24.9', 0),
('c98d5e34cbacf04e50ee3f9ada6d71e0', './lib/test/core/Yaml/Fixtures/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/core/Yaml/index.php', '24.9', 0),
('c472d368e77877c5dce5ade72a2fe5b8', './lib/test/core/bootstrap.php', '24.9', 0),
('72875aa71db9cc8fe27dbab63aefb150', './lib/test/core/include_non_autoload_compatible_classes.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/core/index.php', '24.9', 0),
('69585f702336477a9e4e1d5efdd86afb', './lib/test/core/temp/cache/index.php', '24.9', 0),
('65e279db1297ecf8e27cd09027ac897a', './lib/test/core/temp/index.php', '24.9', 0),
('23b9b7ef0e0c9af75264f922cde8904c', './lib/test/diff/DiffTest.php', '24.9', 0),
('cd34ea8df4fed5d3ff252334089743bd', './lib/test/diff/fixtures/index.php', '24.9', 0),
('e94b86e8471c56b9878548b5704af8c5', './lib/test/diff/fixtures/unidiff.php', '24.9', 0),
('5849af79ce8e027244299b0aa4c12ef5', './lib/test/diff/index.php', '24.9', 0),
('1b3f4b1c255f7b290d23d5c9db0af74e', './lib/test/editlib/EditLibTest.php', '24.9', 0),
('3fa2f0749791c80e8340d7bac54d1a10', './lib/test/editlib/ParseToWiki_CharacterTest.php', '24.9', 0),
('553c331f2ae4af481dc22411385376fe', './lib/test/editlib/ParseToWiki_LinkTest.php', '24.9', 0),
('001ddeac0df3ab7f147ddcf5fb2170f8', './lib/test/editlib/ParseToWiki_ListTest.php', '24.9', 0),
('7a1323991a63c25bf75795c4185a28b4', './lib/test/editlib/ParseToWiki_TextTest.php', '24.9', 0),
('72f756fb34df6ffd5a86d04879794b9c', './lib/test/editlib/ParseToWysiwyg_CharacterTest.php', '24.9', 0),
('8077afc9f26d80af7161b21d0bf6d5cb', './lib/test/editlib/ParseToWysiwyg_LinkTest.php', '24.9', 0),
('a041cc9ddc2063b42cdc5aa6838d6297', './lib/test/editlib/ParseToWysiwyg_ListTest.php', '24.9', 0),
('dae83bbd5d09f556c06f68f785740f2c', './lib/test/editlib/ParseToWysiwyg_TextTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/editlib/index.php', '24.9', 0),
('e27d6c7422fc60ceb347a80d8d5637bc', './lib/test/filegals/FilegalsTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/filegals/index.php', '24.9', 0),
('f51642faad65f1661b5a450b0f1420c5', './lib/test/freetag/FreetagTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/freetag/index.php', '24.9', 0),
('4f7d158a2ce32421c0be0ce9688d458b', './lib/test/importer/TikiImporterBlogTest.php', '24.9', 0),
('3fd3828e21f08e7436dfa15823c559c6', './lib/test/importer/TikiImporterBlogWordpressTest.php', '24.9', 0),
('240914bec9a948170dea1166a54fb4f9', './lib/test/importer/TikiImporterTest.php', '24.9', 0),
('c50b1be9be1c4703034a4718e67f2ffa', './lib/test/importer/TikiImporterWikiMediawikiTest.php', '24.9', 0),
('200e586741210e4dcd114bb1bef765f0', './lib/test/importer/TikiImporterWikiTest.php', '24.9', 0),
('cd34ea8df4fed5d3ff252334089743bd', './lib/test/importer/fixtures/index.php', '24.9', 0),
('80e5b9efbf73f0976676a93c98afbe20', './lib/test/importer/fixtures/mediawiki_page_as_array.php', '24.9', 0),
('5849af79ce8e027244299b0aa4c12ef5', './lib/test/importer/index.php', '24.9', 0),
('82ba000077c06e4705173cd3ed089d16', './lib/test/importer/tikiimporter_testcase.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/index.php', '24.9', 0),
('08abaf884dff9e8ea92f0166b7a794d3', './lib/test/language/CollectFilesTest.php', '24.9', 0),
('0730f6248745e3b2d95a9aad6b990bb2', './lib/test/language/FileType/PhpTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/language/FileType/index.php', '24.9', 0),
('5b2685d0f2bce5b9f0b7fe5aa8037e2f', './lib/test/language/GetStringsEndToEndTest.php', '24.9', 0),
('3e50d253fe3bd4e0c5cff93dd3405089', './lib/test/language/GetStringsTest.php', '24.9', 0),
('d27e82ef1f2cdd6737a71bb69a95be7b', './lib/test/language/LanguageTest.php', '24.9', 0),
('e54b59b7d6e6da5a518dd8a2c6d6c475', './lib/test/language/LanguageTranslationsTest.php', '24.9', 0),
('f3bb6cd3eba5b69e6ac977bb9873db76', './lib/test/language/MergeFilesTest.php', '24.9', 0),
('4aea2a6b4304035aa2d9a406f74b08bf', './lib/test/language/ParseFileTest.php', '24.9', 0),
('53d2743fc5a875b7bd7309753759742e', './lib/test/language/WriteFile/FactoryTest.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './lib/test/language/WriteFile/index.php', '24.9', 0),
('4d53437ba905a3a45a2c6b71b5779c9a', './lib/test/language/WriteFileTest.php', '24.9', 0),
('c30e9fba8a091ec82e3efa320109e941', './lib/test/language/fixtures/custom.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/language/fixtures/index.php', '24.9', 0),
('fb6fc4267d7e559ae81d42433ae8f8c1', './lib/test/language/fixtures/language_end_to_end_test_modified.php', '24.9', 0),
('c554b72f129aa0069d20dafe0a998500', './lib/test/language/fixtures/language_end_to_end_test_original.php', '24.9', 0),
('ec1381a48f8a4c32fdb724b866edc39a', './lib/test/language/fixtures/language_escape_special_characters.php', '24.9', 0),
('053fdfeef465b99f25d703c9d2611eed', './lib/test/language/fixtures/language_fa_modified.php', '24.9', 0),
('2ff8e074bb2865c0a82d1aab45fd3783', './lib/test/language/fixtures/language_fa_original.php', '24.9', 0),
('0feb83fd9d48613015688e40692dc770', './lib/test/language/fixtures/language_invalid.php', '24.9', 0),
('f464f6784a269022cc5ca404476d6a11', './lib/test/language/fixtures/language_merge_files_original.php', '24.9', 0),
('c856093fb6e2be46974a7decc118fa6a', './lib/test/language/fixtures/language_merge_files_result.php', '24.9', 0),
('081cc4a8d22ee5e9ebbee07766827144', './lib/test/language/fixtures/language_modif.php', '24.9', 0),
('ef72e4e828e1980c29a90a84af90f2df', './lib/test/language/fixtures/language_orig.php', '24.9', 0),
('94109316ec40af88e149752b79a15f44', './lib/test/language/fixtures/language_punctuations.php', '24.9', 0),
('30fd2d5f01e9c54e9b304da0ec3f3451', './lib/test/language/fixtures/language_ru_modified.php', '24.9', 0),
('5d6fd4835f01daf9137d2d230016b465', './lib/test/language/fixtures/language_ru_original.php', '24.9', 0),
('74a1b6d9381f9b9ed476c33d472dcf6c', './lib/test/language/fixtures/language_simple.php', '24.9', 0),
('171ab1c8654a0ce742d1a6c193561d4a', './lib/test/language/fixtures/language_to_parse_file.php', '24.9', 0),
('2cc61cf116c49b62deac82ebb80f70e2', './lib/test/language/fixtures/language_untranslated.php', '24.9', 0),
('a241ae52062431f4468f98818332f76f', './lib/test/language/fixtures/language_with_translations.php', '24.9', 0),
('1425e9a3384dd3cb5f2f9ee3df036901', './lib/test/language/fixtures/language_with_translations_and_file_paths.php', '24.9', 0),
('6eb5223df6d76a1ded0592f87f67e10a', './lib/test/language/fixtures/language_writestringstofile_first_call.php', '24.9', 0),
('c7a0a41a42a6f0b9807597689b9d147f', './lib/test/language/fixtures/language_writestringstofile_second_call.php', '24.9', 0),
('43a828e2a29ae31a7e86f535e4dde3d1', './lib/test/language/fixtures/test_collecting_strings.php', '24.9', 0),
('7bfad4d4e3bf13a0d5cad4d6e55910a5', './lib/test/language/fixtures/test_collecting_strings.tpl', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/language/index.php', '24.9', 0),
('90fa7b72516868e389495c485b30baee', './lib/test/lib/AbsoluteToRelativeLinkTest.php', '24.9', 0),
('dbea429b6aafa8b6ea9e1a781be2ba8b', './lib/test/lib/Perspective/AreasMultiDomainBasicTest.php', '24.9', 0),
('5b1f45f5b7f74dc767822f0ff80cf521', './lib/test/lib/Perspective/PerspectivesNavigationBaseTestCase.php', '24.9', 0),
('eb7f0727abb7a23ab5e03d9127cd4bc4', './lib/test/lib/Perspective/PerspectivesTest.php', '24.9', 0),
('5849af79ce8e027244299b0aa4c12ef5', './lib/test/lib/Perspective/fixtures/index.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/lib/Perspective/index.php', '24.9', 0),
('cbc1f3c14ab98982209d7c94e01ca568', './lib/test/lib/accounting/AccountingLibTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/lib/accounting/index.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/lib/index.php', '24.9', 0),
('e9a54ef07cf1db5e605133f66b2c9829', './lib/test/notifications/NotificationEmailLibTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/notifications/index.php', '24.9', 0),
('7491aa872fb8cc9bb5c4fb79470d024d', './lib/test/payment/CartTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/payment/index.php', '24.9', 0),
('7d460fdb677a4d0593583edb5ab939f9', './lib/test/phpunit.php', '24.9', 0),
('67dc7884b1c9f78a6845798ede500ba8', './lib/test/phpunit_with_baseline.php', '24.9', 0),
('8ec0b081a67b921174ba3f7b64a14b9b', './lib/test/rating/AggregationTest.php', '24.9', 0),
('6cf3aae58845c60982b91a29871ad9ba', './lib/test/rating/RegisterVoteTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/rating/index.php', '24.9', 0),
('84380776f16275913b434bf51966ed95', './lib/test/shipping/ShippingTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/shipping/index.php', '24.9', 0),
('cf54e1e63f9155072293240b8e9e4bb7', './lib/test/smarty_tiki/ModifierDurationTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/smarty_tiki/index.php', '24.9', 0),
('0dd7bbcfa6624662b40c334017a56443', './lib/test/wiki-plugins/CodeTest.php', '24.9', 0),
('d4932281655d12222bf9dae835d62efa', './lib/test/wiki-plugins/TranslationOfTest.php', '24.9', 0),
('b1197e6d3d4fef64419ae7c66b65c2bc', './lib/test/wiki-plugins/YoutubeTest.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/test/wiki-plugins/index.php', '24.9', 0),
('9e751eb6048a35a3941f2f13f25bd204', './lib/test/wiki/WikiLibTest.php', '24.9', 0),
('e623b454c7d54784cde7dbab91b643a9', './lib/test/wiki/index.php', '24.9', 0),
('df31da734ea8b14160234a126fbaa9b1', './lib/theme/iconsetlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/theme/index.php', '24.9', 0),
('d6c30a4e934d461fafe7355b2d226cdc', './lib/theme/themecontrollib.php', '24.9', 0),
('d3a7c29a1b6f33ac90eab106a0db427c', './lib/theme/themelib.php', '24.9', 0),
('0683ec6abbd09b5d317bacc61ae01840', './lib/tiki-dynamic-js.php', '24.9', 0),
('d3c791886c2a63a43e03a7c165d8d3a5', './lib/tiki-js.js', '24.9', 0),
('e7d491273ae478d84ace4a5e190d6aaf', './lib/tikiaccesslib.php', '24.9', 0),
('4508b75010dc1010c3e04555bf34f839', './lib/tikidate.php', '24.9', 0),
('eb3bc926f010a57d6bc5bd8d191224cb', './lib/tikihelp/css/index.php', '24.9', 0),
('c42ebbdb75e2f36e078db5b256dabc93', './lib/tikihelp/css/menu.css', '24.9', 0),
('26a50ce04ebc204f29d795b1216fe9ea', './lib/tikihelp/css/toolbar.css', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/tikihelp/index.php', '24.9', 0),
('96ed9bd0969f3f89e2c76be975f7c6ab', './lib/tikihelp/js/global.js', '24.9', 0),
('a847a1df13971d9bde8214a27dcf578b', './lib/tikihelp/js/highlight.js', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/tikihelp/js/index.php', '24.9', 0),
('3e1adec893f645fd98018586d360f5d7', './lib/tikihelp/js/toolbar.js', '24.9', 0),
('ed771905c753bc92939956922b675808', './lib/tikihelp/menu/ftiens4.js', '24.9', 0),
('14cec197155381dda9c139e6008095ff', './lib/tikihelp/menu/index.php', '24.9', 0),
('3a58a2fe95f389c6b620dbf8357bb3f5', './lib/tikihelp/menu/menuNodes.js', '24.9', 0),
('8c9271fa6eab559def1de66648c6719a', './lib/tikihelp/menu/ua.js', '24.9', 0),
('129db4adb8c51c6a331a6f655d80ba5f', './lib/tikihelplib.php', '24.9', 0),
('f4ea7a4f9b51cf45724a29d5419acfe9', './lib/tikilib.php', '24.9', 0),
('27f7fcbae6857466a94a7bf3c714710c', './lib/tikisession-adodb.php', '24.9', 0),
('a28aa170260343063f011e6cbb7e98ec', './lib/tikisession-memcache.php', '24.9', 0),
('bcb0de287d60a0ada0f094fd718ef724', './lib/tikisession-pdo.php', '24.9', 0),
('a187844a826ee3381f259e477c542ace', './lib/tikiticketlib.php', '24.9', 0),
('7d21173a4e242747f13c069fdc597a21', './lib/todolib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/toolbars/index.php', '24.9', 0),
('c329bbe5bf0ceb9f3c6aae4ca0f296fb', './lib/toolbars/tiki-admin_toolbars.js', '24.9', 0),
('bd8d06f105d3b105e7f9ecddbf8d70da', './lib/toolbars/toolbarslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/trackers/index.php', '24.9', 0),
('25c71674746eed5831e9a995190da91e', './lib/trackers/trackerlib.php', '24.9', 0),
('a8cfea0a6ff50a36722713016457382c', './lib/transitionlib.php', '24.9', 0),
('cf7379bd307e9ae23a3bc53712cbc1a2', './lib/tree/BrowseTreeMaker.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/tree/index.php', '24.9', 0),
('bf4d7a7163cee263605b1cf6ba402671', './lib/tree/tree.php', '24.9', 0),
('a600c9b3bcdc51ed80c1ef1d91921589', './lib/user/blacklistlib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/user/index.php', '24.9', 0),
('640f9af6af0411858d6ca01ed587eac8', './lib/user/monitorlib.php', '24.9', 0),
('f3b4f4a44ee3edc768e51487793949fa', './lib/user/monitormaillib.php', '24.9', 0),
('487fd04105f7525f86f636f304cf404e', './lib/user/sociallib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/userfiles/index.php', '24.9', 0),
('a05a3e7ba9cfddc20d9808c9487e56c9', './lib/userfiles/userfileslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/usermenu/index.php', '24.9', 0),
('b4a749e9a48113b22c7fe843ae70a904', './lib/usermenu/usermenulib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/usermodules/index.php', '24.9', 0),
('0693074557b3f0954db0f60df0f543f0', './lib/usermodules/usermoduleslib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/userprefs/index.php', '24.9', 0),
('11e8652bb9cce9051943c200b43b1deb', './lib/userprefs/userprefslib.php', '24.9', 0),
('9c56a18ae2cba5c83adf7b9798c2b891', './lib/userslib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/validators/index.php', '24.9', 0),
('989cadbc8343b6ca1cc8e2eb7a573ddd', './lib/validators/validator_captcha.php', '24.9', 0),
('3c6377bcb01a05202ed393b23df95226', './lib/validators/validator_distinct.php', '24.9', 0),
('8865fdea24e0d0c4b21bbe81a1fde768', './lib/validators/validator_pagename.php', '24.9', 0),
('c7ba27db3ac7baedd3abef15c024447f', './lib/validators/validator_passcode.php', '24.9', 0),
('c9ab3b4d9219a7060b874c9c1590893e', './lib/validators/validator_password.php', '24.9', 0),
('a3121f874d922993e4d96967933cdd18', './lib/validators/validator_regex.php', '24.9', 0),
('027752ff44553e840e3ef7336db78bde', './lib/validators/validator_remotelock.php', '24.9', 0),
('38f0449a9b43e6f5fb23cd2c2d6c038b', './lib/validators/validator_smarty.php', '24.9', 0),
('7e1b2dcc6491d9a9be9c3963e16fa3de', './lib/validators/validator_tiki.js', '24.9', 0),
('d26bab449eb7e56dcc6695ca4a6b56a2', './lib/validators/validator_uniqueemail.php', '24.9', 0),
('7a83461366644d451d6e2e8fb84aad61', './lib/validators/validator_username.php', '24.9', 0),
('62ba930bce3e74e1414858c6dee85191', './lib/validatorslib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/videogals/index.php', '24.9', 0),
('1dd10c893c2540dd4574f57d374b2ad0', './lib/videogals/kalturalib.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/vue-mf/index.php', '24.9', 0),
('9065f54218f61885b1a9f74abfd0c591', './lib/vue-mf/kanban/.eslintrc.js', '24.9', 0),
('0a7435c09f8754f13c14566a7dc901ed', './lib/vue-mf/kanban/index.php', '24.9', 0),
('9a6faffa45e28a83ec96d839ab92b9e9', './lib/vue-mf/kanban/public/index.php', '24.9', 0),
('259cc49b3c337d04cacd0e2283d4c44e', './lib/vue-mf/kanban/src/api/index.php', '24.9', 0),
('5aa5150911110d373f0248261763acc2', './lib/vue-mf/kanban/src/api/kanban.js', '24.9', 0),
('a7e6d758b72c0c58c7ff0c7f5995084e', './lib/vue-mf/kanban/src/auth/defineAbility.js', '24.9', 0),
('c0232b65a484d03340590ddf5d9eb941', './lib/vue-mf/kanban/src/auth/entities.js', '24.9', 0),
('259cc49b3c337d04cacd0e2283d4c44e', './lib/vue-mf/kanban/src/auth/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/kanban/src/components/Buttons/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/kanban/src/components/Forms/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/kanban/src/components/Sidemenu/index.php', '24.9', 0),
('259cc49b3c337d04cacd0e2283d4c44e', './lib/vue-mf/kanban/src/components/index.php', '24.9', 0),
('9a6faffa45e28a83ec96d839ab92b9e9', './lib/vue-mf/kanban/src/index.php', '24.9', 0),
('6fda5bf87f43f6346e8c362e02397b71', './lib/vue-mf/kanban/src/main.js', '24.9', 0),
('a3cf2c0d0d6f5dce8a76cf44e65c9c51', './lib/vue-mf/kanban/src/store/index.js', '24.9', 0),
('259cc49b3c337d04cacd0e2283d4c44e', './lib/vue-mf/kanban/src/store/index.php', '24.9', 0),
('c315d3348b0626d9d88f930c207bc46d', './lib/vue-mf/kanban/src/store/logger.js', '24.9', 0),
('31b167660bd9d01f6de98ed7d3da15d7', './lib/vue-mf/kanban/vite.config.js', '24.9', 0),
('0a7435c09f8754f13c14566a7dc901ed', './lib/vue-mf/root-config/index.php', '24.9', 0),
('e0ea0a95ef6be72187adf3fe52971bd2', './lib/vue-mf/root-config/rollup.config.js', '24.9', 0),
('9a6faffa45e28a83ec96d839ab92b9e9', './lib/vue-mf/root-config/src/index.php', '24.9', 0),
('f65c3448cdb21788895d3e00219c6a59', './lib/vue-mf/root-config/src/vue-mf-root-config.js', '24.9', 0),
('3c6084413314668e301de33271991e8d', './lib/vue-mf/styleguide/.eslintrc.js', '24.9', 0),
('0a7435c09f8754f13c14566a7dc901ed', './lib/vue-mf/styleguide/index.php', '24.9', 0),
('259cc49b3c337d04cacd0e2283d4c44e', './lib/vue-mf/styleguide/public/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/styleguide/src/components/Button/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/styleguide/src/components/Card/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/styleguide/src/components/Dropdown/index.php', '24.9', 0),
('149c4355217c0978e803a2b979de982a', './lib/vue-mf/styleguide/src/components/Sidebar/index.php', '24.9', 0),
('259cc49b3c337d04cacd0e2283d4c44e', './lib/vue-mf/styleguide/src/components/index.php', '24.9', 0),
('9a6faffa45e28a83ec96d839ab92b9e9', './lib/vue-mf/styleguide/src/index.php', '24.9', 0),
('e48449b8d25ec235ad83df5de370d4e0', './lib/vue-mf/styleguide/src/main.js', '24.9', 0),
('296219339ad89a50124435f328744f00', './lib/vue-mf/styleguide/vite.config.js', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/vue/duration/index.php', '24.9', 0),
('48851108f73cb90e4ebfca019d2c2919', './lib/vue/duration/store.js', '24.9', 0),
('3a2900b9fbe69ab2766e01b3ddf35121', './lib/vue/duration/styles.css', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/vue/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/vue/lib/index.php', '24.9', 0),
('7ab3da08eecbdcc4b19c4a24929c35a1', './lib/vue/lib/ui-predicate-vue.css', '24.9', 0),
('63863d9348265120dfa37250c790dda1', './lib/vue/lib/ui-predicate-vue.js', '24.9', 0),
('c3dc74609a8aedb46e808266a0e9deb3', './lib/vue/lib/vue.runtime.global.prod.js', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/vue/rules/index.php', '24.9', 0),
('2f1c4a8e0e49c3f2af40d498066c8a73', './lib/vue/vuejslib.php', '24.9', 0),
('edd0f7e13beea3da72b231763b018942', './lib/webmail/addressbooklib.php', '24.9', 0),
('5979c5073d26ba0144843265e5f3a7a6', './lib/webmail/contactlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/webmail/index.php', '24.9', 0),
('368566d5a1196eb3813ad064fa6f461f', './lib/webmail/net_pop3.php', '24.9', 0),
('6b77c10b85c5fbfbe3b2dbdc036ebe1b', './lib/webmail/tikimaillib.php', '24.9', 0),
('ee82fecdf46a312751f76051ee9723d6', './lib/webservicelib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/wiki-plugins/index.php', '24.9', 0),
('271b981f50bbaff5c55b9a54d6ad3bdc', './lib/wiki-plugins/wikiplugin_activitystream.php', '24.9', 0),
('27e29ca64bed5b623d772d325239165b', './lib/wiki-plugins/wikiplugin_addfreetag.php', '24.9', 0),
('580fd52c986b331ac5ec2553a922c8e9', './lib/wiki-plugins/wikiplugin_addreference.php', '24.9', 0),
('c38565cc5aa9e96c777c48331e61a772', './lib/wiki-plugins/wikiplugin_addrelation.php', '24.9', 0),
('5c7b3fa2896b55a7fba66b910876ce7a', './lib/wiki-plugins/wikiplugin_addtocart.php', '24.9', 0),
('5522aa22d7bc4c118847849c6581034f', './lib/wiki-plugins/wikiplugin_addtogooglecal.php', '24.9', 0),
('c4b3e274843e43cf4cb2d374919f9e9f', './lib/wiki-plugins/wikiplugin_adjustinventory.php', '24.9', 0),
('8e9ff6903ddcd0fb7de68da915f43623', './lib/wiki-plugins/wikiplugin_agentinfo.php', '24.9', 0),
('6d9b71ed8a8d9798669897e28d21ad10', './lib/wiki-plugins/wikiplugin_ajaxload.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('924b30b140e4ee62a9bfdf0470af3e1e', './lib/wiki-plugins/wikiplugin_alink.php', '24.9', 0),
('0b26c5889da56d9b169e49d918e0a53b', './lib/wiki-plugins/wikiplugin_aname.php', '24.9', 0),
('fa63fabf1adf34a06edb5d7c16a00ab8', './lib/wiki-plugins/wikiplugin_annotation.php', '24.9', 0),
('ad0231d11b421272955f624a1dc96797', './lib/wiki-plugins/wikiplugin_appframe.php', '24.9', 0),
('9004a9656f7fa8a08efa715e57c125c2', './lib/wiki-plugins/wikiplugin_archivebuilder.php', '24.9', 0),
('91f22e1bb0a988d1fb9e4c995ab173f9', './lib/wiki-plugins/wikiplugin_article.php', '24.9', 0),
('9b432628b0613939ac05216b69864b93', './lib/wiki-plugins/wikiplugin_articles.php', '24.9', 0),
('37c805f59487f1a25ae116e8349a235c', './lib/wiki-plugins/wikiplugin_attach.php', '24.9', 0),
('a5be4edd0d5459fc702ed15d0b50599c', './lib/wiki-plugins/wikiplugin_attributes.php', '24.9', 0),
('cd3a613b391c2e7b5e9a500135a7cd0b', './lib/wiki-plugins/wikiplugin_author.php', '24.9', 0),
('e71ff37051e76c04c75557f9e31e2fc8', './lib/wiki-plugins/wikiplugin_autoqueryargs.php', '24.9', 0),
('592c57ea39c7c8074f57e83d1b355198', './lib/wiki-plugins/wikiplugin_autotoc.php', '24.9', 0),
('196873afcffa774fe817660318c3bd5e', './lib/wiki-plugins/wikiplugin_avatar.php', '24.9', 0),
('0c812a5a80618e4de89f4ba64c24c943', './lib/wiki-plugins/wikiplugin_back.php', '24.9', 0),
('6e044af1c9936dcc83dba98f9b6a07b4', './lib/wiki-plugins/wikiplugin_backlinks.php', '24.9', 0),
('b8c1776beeea0d622a94fca5c4fef5fe', './lib/wiki-plugins/wikiplugin_banner.php', '24.9', 0),
('6d1a3a2d4ff348981189c8840ce15842', './lib/wiki-plugins/wikiplugin_benchmark.php', '24.9', 0),
('62a1b85a6ec7b0770dafd45450ff112a', './lib/wiki-plugins/wikiplugin_bigbluebutton.php', '24.9', 0),
('3817201e2fd18231295cc318ad91b736', './lib/wiki-plugins/wikiplugin_bloglist.php', '24.9', 0),
('18c408e0b888cf1e9ffbd85a9516d381', './lib/wiki-plugins/wikiplugin_box.php', '24.9', 0),
('3afac0f243717c5f87e4c44fc54ba94e', './lib/wiki-plugins/wikiplugin_button.php', '24.9', 0),
('cc41b188d7af85a8a2acdad33f2cb54e', './lib/wiki-plugins/wikiplugin_calendar.php', '24.9', 0),
('30244e6bc0beb242a4aa94c55605f684', './lib/wiki-plugins/wikiplugin_carousel.php', '24.9', 0),
('7f2ac8f362c78e772123e757f127aff0', './lib/wiki-plugins/wikiplugin_casperjs.php', '24.9', 0),
('2519475446e77f71cfc770ac1e3d0c8e', './lib/wiki-plugins/wikiplugin_category.php', '24.9', 0),
('ec8727dd9cbec68142f9dc130563de84', './lib/wiki-plugins/wikiplugin_categorytransition.php', '24.9', 0),
('33032196985bb79cbf7f7395a7fa9e06', './lib/wiki-plugins/wikiplugin_catorphans.php', '24.9', 0),
('6639379f06951ddc820f1e9555e7a850', './lib/wiki-plugins/wikiplugin_catpath.php', '24.9', 0),
('3e2caddebba68fc63321fa0671a7130b', './lib/wiki-plugins/wikiplugin_cclite.php', '24.9', 0),
('442f66f9586fd47d0b545a4bb92c159d', './lib/wiki-plugins/wikiplugin_center.php', '24.9', 0),
('1217c4ed06ad3d54f43d79973006cf9e', './lib/wiki-plugins/wikiplugin_chart.php', '24.9', 0),
('aff3144e57c650ebc771d09e335963fb', './lib/wiki-plugins/wikiplugin_chartjs.php', '24.9', 0),
('58d15a84b41a17356372cf243cf5b6f7', './lib/wiki-plugins/wikiplugin_checkreferer.php', '24.9', 0),
('1fe35ab34baefe82d2c96879d90995a4', './lib/wiki-plugins/wikiplugin_code.php', '24.9', 0),
('b5afc0ef1dfe59d754c6ad98a042e13a', './lib/wiki-plugins/wikiplugin_coil.php', '24.9', 0),
('2ab4e7349a8465d76e801842f3140584', './lib/wiki-plugins/wikiplugin_colorbox.php', '24.9', 0),
('e2e8ad29b7af73acbdac8a3d4cb90850', './lib/wiki-plugins/wikiplugin_comment.php', '24.9', 0),
('08bae6acadb5179cfab32bfcd4c20528', './lib/wiki-plugins/wikiplugin_content.php', '24.9', 0),
('79d628dcbb24300676927476c5fb0ef0', './lib/wiki-plugins/wikiplugin_contributionsdashboard.php', '24.9', 0),
('5498f0592291704fe4bc1a5433dc928d', './lib/wiki-plugins/wikiplugin_convene.php', '24.9', 0),
('234072dd732c69d8564e0a6559894a30', './lib/wiki-plugins/wikiplugin_cookie.php', '24.9', 0),
('c90ff4043fa98b8ff93957a7eaf7c516', './lib/wiki-plugins/wikiplugin_cookieconsent.php', '24.9', 0),
('93d01d7ca23e11b5adc0f3dfea5a3511', './lib/wiki-plugins/wikiplugin_copyright.php', '24.9', 0),
('973ebe6501374e27189e6f2c7ff80b57', './lib/wiki-plugins/wikiplugin_countdown.php', '24.9', 0),
('d3a36bb9ab43eef8ca4090e9d38c4f34', './lib/wiki-plugins/wikiplugin_customsearch.php', '24.9', 0),
('f6e9f547d9165b58b51178f5b5fea4fe', './lib/wiki-plugins/wikiplugin_cypht.php', '24.9', 0),
('543ea5f051176914d3fa84b02bbde19a', './lib/wiki-plugins/wikiplugin_datachannel.php', '24.9', 0),
('4c3bde3ba2ce460012d80f5d423fc8fa', './lib/wiki-plugins/wikiplugin_dbreport.php', '24.9', 0),
('52aa6c6e0a1114cb2602d02e08a4a26c', './lib/wiki-plugins/wikiplugin_diagram.php', '24.9', 0),
('51b65087f5a6973f69474bf9a3719109', './lib/wiki-plugins/wikiplugin_dialog.php', '24.9', 0),
('b004489c38019829a49852573a65a227', './lib/wiki-plugins/wikiplugin_div.php', '24.9', 0),
('52cd33450e7de0b35e833d81028e96d3', './lib/wiki-plugins/wikiplugin_dl.php', '24.9', 0),
('033ef7b6540b99825af43655d8fa7d93', './lib/wiki-plugins/wikiplugin_draw.php', '24.9', 0),
('5f53bd5049a8f24572942bc888504517', './lib/wiki-plugins/wikiplugin_dynamicvariables.php', '24.9', 0),
('0079d93362fa47c966f901fb1f45dedc', './lib/wiki-plugins/wikiplugin_equation.php', '24.9', 0),
('1620c98b7474441d9f113c80d8621acc', './lib/wiki-plugins/wikiplugin_events.php', '24.9', 0),
('8e13ee35cc278542c73ef65627f6c76c', './lib/wiki-plugins/wikiplugin_exercise.php', '24.9', 0),
('4235488daa86845c495f60a70242ffdb', './lib/wiki-plugins/wikiplugin_extendcarthold.php', '24.9', 0),
('a1eafa01cd3e025822730406c4163439', './lib/wiki-plugins/wikiplugin_fade.php', '24.9', 0),
('babf6a6bf8d0ed3b523a1458e8e2ea0d', './lib/wiki-plugins/wikiplugin_fancylist.php', '24.9', 0),
('98c5a6b38f76a70b86bd11df878d08ba', './lib/wiki-plugins/wikiplugin_fancytable.php', '24.9', 0),
('5c49e6442f101fba74ab7ae86973c0a7', './lib/wiki-plugins/wikiplugin_favorite.php', '24.9', 0),
('4bd2b5f75d4e9eebfba95a67fcc43553', './lib/wiki-plugins/wikiplugin_figlet.php', '24.9', 0),
('e1fad0078bdaf04f1a48e84b28003bc5', './lib/wiki-plugins/wikiplugin_file.php', '24.9', 0),
('ba1854e92b1920707fe58c910f338cbe', './lib/wiki-plugins/wikiplugin_files.php', '24.9', 0),
('642e030132be32cd6f6ed4f73b652c7e', './lib/wiki-plugins/wikiplugin_fitnesse.php', '24.9', 0),
('d5c5ce8ded69c3efca9952d8ccae91cb', './lib/wiki-plugins/wikiplugin_flash.php', '24.9', 0),
('657032db9715d9c3b7170c2403112c19', './lib/wiki-plugins/wikiplugin_fluidgrid.php', '24.9', 0),
('3b6c7283a4ae66b6643cce76cf467b81', './lib/wiki-plugins/wikiplugin_font.php', '24.9', 0),
('b83e6074f13e903abcc38f45ea17f252', './lib/wiki-plugins/wikiplugin_footnote.php', '24.9', 0),
('c5cb636137818959f1c008da59dd8ae6', './lib/wiki-plugins/wikiplugin_footnotearea.php', '24.9', 0),
('da73d31b5e92250c8cb67e1e8b9b7dd0', './lib/wiki-plugins/wikiplugin_freetagged.php', '24.9', 0),
('e12df0b10adc6efb90d68d0737a2e331', './lib/wiki-plugins/wikiplugin_friend.php', '24.9', 0),
('7fadd1393b025ea9b0024de4a77d7ac4', './lib/wiki-plugins/wikiplugin_ftp.php', '24.9', 0),
('f5b7afd4cd117af6094ebebee55a3211', './lib/wiki-plugins/wikiplugin_fullwidthtitle.php', '24.9', 0),
('ff8f9711cf1a16736e7435498c43de2d', './lib/wiki-plugins/wikiplugin_galleriffic.php', '24.9', 0),
('9731875ddd8299a3769454540b346170', './lib/wiki-plugins/wikiplugin_ganttchart.php', '24.9', 0),
('84cfd45edfd5ea5b1cb60ac5c5b7b51c', './lib/wiki-plugins/wikiplugin_gauge.php', '24.9', 0),
('aa696641bdc4ae1dfbe21e7fe0bf2447', './lib/wiki-plugins/wikiplugin_gdgraph.php', '24.9', 0),
('ad13f2e23b143421e958b66ecbf4f9d9', './lib/wiki-plugins/wikiplugin_getaccesstoken.php', '24.9', 0),
('934dfe4ce0a93bbe639e1dd44b47afef', './lib/wiki-plugins/wikiplugin_googleanalytics.php', '24.9', 0),
('29c3286faac7b754d94ec7f306561549', './lib/wiki-plugins/wikiplugin_googlechart.php', '24.9', 0),
('ec3850b216be6427719e314d24a69ad2', './lib/wiki-plugins/wikiplugin_googledoc.php', '24.9', 0),
('5009ceccaffdb80d81ba327766a93101', './lib/wiki-plugins/wikiplugin_group.php', '24.9', 0),
('cf06eb94c32045e440708d651052a4bc', './lib/wiki-plugins/wikiplugin_groupedit.php', '24.9', 0),
('84308a56644ce0ec72165100bb804f22', './lib/wiki-plugins/wikiplugin_groupexpiry.php', '24.9', 0),
('d5c34e21ce678116ae6f5d628d04572d', './lib/wiki-plugins/wikiplugin_grouplist.php', '24.9', 0),
('b8744617961b27dc44b3f4ca919e32b5', './lib/wiki-plugins/wikiplugin_groupmailcore.php', '24.9', 0),
('8a39c04cacdd44a7ed44cb2da3eb0aa9', './lib/wiki-plugins/wikiplugin_groupstat.php', '24.9', 0),
('f39d519e46deda01a509f84edab341af', './lib/wiki-plugins/wikiplugin_h5p.php', '24.9', 0),
('308649eeb8a35785787e4dfa28e1438f', './lib/wiki-plugins/wikiplugin_html.php', '24.9', 0),
('f814c25585ab6f384ea19e29d69d5a69', './lib/wiki-plugins/wikiplugin_htmlfeed.php', '24.9', 0),
('0d975d7efd9c716cbc8f9f74c1018b52', './lib/wiki-plugins/wikiplugin_htmlfeedlink.php', '24.9', 0),
('38a5d9d53b331d57a617b5a567070967', './lib/wiki-plugins/wikiplugin_icon.php', '24.9', 0),
('dad814da06b68383ccfcdf3de81dd482', './lib/wiki-plugins/wikiplugin_iframe.php', '24.9', 0),
('d47505d748d273662196b67e2427a82b', './lib/wiki-plugins/wikiplugin_img.php', '24.9', 0),
('bcc7795c2a49b9fbcaf24664a0c64e7c', './lib/wiki-plugins/wikiplugin_include.php', '24.9', 0),
('4e0e1b57f1f8b0233b083ae10bdfd611', './lib/wiki-plugins/wikiplugin_includetpl.php', '24.9', 0),
('0cc881de5f209ffe8383e0ad1bd40141', './lib/wiki-plugins/wikiplugin_includeurl.php', '24.9', 0),
('e82cce7cc2edee7290734a8290d44285', './lib/wiki-plugins/wikiplugin_indent.php', '24.9', 0),
('d10cb1ba096ab06c1329f618f43ead25', './lib/wiki-plugins/wikiplugin_insert.php', '24.9', 0),
('bff09363a7d1ceb342f675f393d7d053', './lib/wiki-plugins/wikiplugin_invite.php', '24.9', 0),
('39b50e6a58612d650d87f7f663772d06', './lib/wiki-plugins/wikiplugin_jq.php', '24.9', 0),
('dff0d53c88038cb91f4e56478bec2d97', './lib/wiki-plugins/wikiplugin_js.php', '24.9', 0),
('54d3435cf20aec9e8bf528ad67150b33', './lib/wiki-plugins/wikiplugin_kaltura.php', '24.9', 0),
('aaedb96dfd27e5d15c7187ec285ceb18', './lib/wiki-plugins/wikiplugin_kanban.php', '24.9', 0),
('3597d2b9bcf821d2ec042d598c063011', './lib/wiki-plugins/wikiplugin_lang.php', '24.9', 0),
('7d49b1fae8c0e4cadf973f9509ec9d96', './lib/wiki-plugins/wikiplugin_lastmod.php', '24.9', 0),
('b8839951e9e8b4a5b2db968a4d394148', './lib/wiki-plugins/wikiplugin_layout.php', '24.9', 0),
('74d604111f0160b972b9f4b40b1d8a62', './lib/wiki-plugins/wikiplugin_like.php', '24.9', 0),
('f7cd701a5a30b0b3591dcead7cc6c8cf', './lib/wiki-plugins/wikiplugin_list.php', '24.9', 0),
('2117fd620a68f9ab1e7a335402d96e42', './lib/wiki-plugins/wikiplugin_listexecute.php', '24.9', 0),
('f6cc81910a4d1f90889f0274e313fa24', './lib/wiki-plugins/wikiplugin_listpages.php', '24.9', 0),
('45eada19249b17a19cadd3b196c8cab1', './lib/wiki-plugins/wikiplugin_localfiles.php', '24.9', 0),
('d2ddd72e175f1481a35e4a01f2c9003a', './lib/wiki-plugins/wikiplugin_lsdir.php', '24.9', 0),
('71d8e0f5c8ccbcc72f4c8399befa9851', './lib/wiki-plugins/wikiplugin_mail.php', '24.9', 0),
('bc9c200968265ff5be8d4c451d02891a', './lib/wiki-plugins/wikiplugin_map.php', '24.9', 0),
('dab870c505551d24d803ce2270c3b58d', './lib/wiki-plugins/wikiplugin_markdown.php', '24.9', 0),
('c32fef1616c3da352d9bb3b0d1f67393', './lib/wiki-plugins/wikiplugin_mcalendar.php', '24.9', 0),
('c778476a07958e755ac8a49cb21e4cd9', './lib/wiki-plugins/wikiplugin_mediaplayer.php', '24.9', 0),
('2ee9fe380d4753a83d4654102dc3351e', './lib/wiki-plugins/wikiplugin_memberlist.php', '24.9', 0),
('9e749e09d4eb01f6c3a0b57fedeec78b', './lib/wiki-plugins/wikiplugin_memberpayment.php', '24.9', 0),
('4a6a46e8cfe18309251479b00085dff9', './lib/wiki-plugins/wikiplugin_metatag.php', '24.9', 0),
('e79b53828c2fb9d1a4bce60a66494fb8', './lib/wiki-plugins/wikiplugin_miniquiz.php', '24.9', 0),
('0b0023c55ac4eb2269c6d32a6cae4cfd', './lib/wiki-plugins/wikiplugin_module.php', '24.9', 0),
('88a61d34d7557b3502ffd978f3e21a02', './lib/wiki-plugins/wikiplugin_modulelist.php', '24.9', 0),
('a420bf5f73be99107b62aed8294e75f6', './lib/wiki-plugins/wikiplugin_mono.php', '24.9', 0),
('6a12810aa50c6dbe887cd6b8a76f7f3b', './lib/wiki-plugins/wikiplugin_mouseover.php', '24.9', 0),
('ce0df2dd7a1048014021f08dc443074b', './lib/wiki-plugins/wikiplugin_mwtable.php', '24.9', 0),
('a8efcde03f399230301275337443aca8', './lib/wiki-plugins/wikiplugin_myspace.php', '24.9', 0),
('e45376935188cdd64b7a728f887a8876', './lib/wiki-plugins/wikiplugin_networkcondition.php', '24.9', 0),
('682a5d5ad1c77f296c1202742a687a26', './lib/wiki-plugins/wikiplugin_now.php', '24.9', 0),
('e1c547fef4ac785bd0bb166d1342900a', './lib/wiki-plugins/wikiplugin_objecthits.php', '24.9', 0),
('2d37c90eacd4a8338ff2b212cbeb23cb', './lib/wiki-plugins/wikiplugin_objectlink.php', '24.9', 0),
('c47e9f44cfb11fd6b9f03618c0e50bd2', './lib/wiki-plugins/wikiplugin_package.php', '24.9', 0),
('fe6a47cac91ccaa0575b6825eeebd68b', './lib/wiki-plugins/wikiplugin_pagetabs.php', '24.9', 0),
('ac5e66e5ba3a55a34cdb8ae98922e84a', './lib/wiki-plugins/wikiplugin_param.php', '24.9', 0),
('4c6976f5b7dc32aeb6cfd8cd4301e213', './lib/wiki-plugins/wikiplugin_payment.php', '24.9', 0),
('e9ec4ad479fc59625dc5610e960362e1', './lib/wiki-plugins/wikiplugin_paymentlist.php', '24.9', 0),
('4aeb921559c07c64bf4bc58971f5a6b9', './lib/wiki-plugins/wikiplugin_paypal.php', '24.9', 0),
('68ad40f7fffd1b85ab01770c79a55558', './lib/wiki-plugins/wikiplugin_pdf.php', '24.9', 0),
('3d951398c3a5e68e8e7b24643ce91ae8', './lib/wiki-plugins/wikiplugin_pdfbookmark.php', '24.9', 0),
('94acb4bed7c7e7a15e0bdf037d1bb716', './lib/wiki-plugins/wikiplugin_pdfpage.php', '24.9', 0),
('756767376895c81ba262d0b10f5f9f1f', './lib/wiki-plugins/wikiplugin_pdfpagebreak.php', '24.9', 0),
('0108322f87214342763a3c1abdc61a2e', './lib/wiki-plugins/wikiplugin_perm.php', '24.9', 0),
('5ffa792807b825ecb4c98df94e3082c0', './lib/wiki-plugins/wikiplugin_perspective.php', '24.9', 0),
('1defc22837fad9744227257f3c99dbad', './lib/wiki-plugins/wikiplugin_pivottable.php', '24.9', 0),
('f97d182f916680e0f91c30a057c8b84b', './lib/wiki-plugins/wikiplugin_piwik.php', '24.9', 0),
('5148a420a9ac3c2930ede868e021701b', './lib/wiki-plugins/wikiplugin_playscorm.php', '24.9', 0),
('16007424a4bbb4a0d2acbbbb8ec58419', './lib/wiki-plugins/wikiplugin_pluginmanager.php', '24.9', 0),
('d04efc9fedff2de4fcd7fcccff76f027', './lib/wiki-plugins/wikiplugin_poll.php', '24.9', 0),
('d9425b979878a6d2703fcfd16bf1cc77', './lib/wiki-plugins/wikiplugin_pref.php', '24.9', 0),
('57464a337bebfadf5c8691ea4b3fce46', './lib/wiki-plugins/wikiplugin_prefdoc.php', '24.9', 0),
('0be738ae9b9523348178cd2666f3a668', './lib/wiki-plugins/wikiplugin_preference.php', '24.9', 0),
('5595f72b7b41157dbb82e74b4c9cf36c', './lib/wiki-plugins/wikiplugin_preview.php', '24.9', 0),
('883d3c258a646bcb89c34ce99596f68d', './lib/wiki-plugins/wikiplugin_profile.php', '24.9', 0),
('3711fd680134bc58855354b6c6133934', './lib/wiki-plugins/wikiplugin_profilesymbolvalue.php', '24.9', 0),
('8ae4efadb84b5869118033de2520edb0', './lib/wiki-plugins/wikiplugin_proposal.php', '24.9', 0),
('f7ceb39a6325c6fb2b4aec03c8f2fa21', './lib/wiki-plugins/wikiplugin_qr.php', '24.9', 0),
('5dc71a9ba080eb754b7640362238f59c', './lib/wiki-plugins/wikiplugin_quote.php', '24.9', 0),
('0fca97af94149c467098aaa21c2f0521', './lib/wiki-plugins/wikiplugin_r.php', '24.9', 0),
('47995aaacd14617f60a4f081b692d9fb', './lib/wiki-plugins/wikiplugin_randominclude.php', '24.9', 0),
('8395b012ff8563bdf352c28010a51aee', './lib/wiki-plugins/wikiplugin_rcontent.php', '24.9', 0),
('e2e13586fd40f72203100739225cba58', './lib/wiki-plugins/wikiplugin_realnamelist.php', '24.9', 0),
('cb28cb95d2f155e4ec7a4653b2f5c4c7', './lib/wiki-plugins/wikiplugin_redirect.php', '24.9', 0),
('e04aff589dfef6a9b543adf8b0758c63', './lib/wiki-plugins/wikiplugin_regex.php', '24.9', 0),
('8e09b212bf906e70a6e344330eaf8b35', './lib/wiki-plugins/wikiplugin_registermemberpayment.php', '24.9', 0),
('14a28adfa97926d76abcb7a723ca4373', './lib/wiki-plugins/wikiplugin_relations.php', '24.9', 0),
('76195c42c80e5355755af06c07275bb7', './lib/wiki-plugins/wikiplugin_remarksbox.php', '24.9', 0),
('0ca7d5881dd0c5e4d91ae88e7933a6a4', './lib/wiki-plugins/wikiplugin_rr.php', '24.9', 0),
('1c48cd3ddb11fc11720807eb58be440d', './lib/wiki-plugins/wikiplugin_rss.php', '24.9', 0),
('4896d4c54c0700f3915ce2ab121440e4', './lib/wiki-plugins/wikiplugin_scroll.php', '24.9', 0),
('49adf8dcca1d89cf89a6938eb4bcd4a0', './lib/wiki-plugins/wikiplugin_sf.php', '24.9', 0),
('95c6aa957ad18031518bdae57e6c974d', './lib/wiki-plugins/wikiplugin_sharethis.php', '24.9', 0),
('45517e2b4039e20cb3aca27b19f3eda1', './lib/wiki-plugins/wikiplugin_sheet.php', '24.9', 0),
('762e3ac5767533ab8dcd392aa8d4d9cc', './lib/wiki-plugins/wikiplugin_shopperinfo.php', '24.9', 0),
('020058759f543dc6435f1d0e558c998b', './lib/wiki-plugins/wikiplugin_shorten.php', '24.9', 0),
('93eccf2b8b795e9416f357d84d6b4dcf', './lib/wiki-plugins/wikiplugin_showpages.php', '24.9', 0),
('3003670bd120ad73a585023bf9ab0357', './lib/wiki-plugins/wikiplugin_showpref.php', '24.9', 0),
('8ee7c38980ae4e5015c1c8b4784cb157', './lib/wiki-plugins/wikiplugin_showreference.php', '24.9', 0),
('fc776a3514866feb603a4bd4267e3e02', './lib/wiki-plugins/wikiplugin_sign.php', '24.9', 0),
('f79ef4ede23c1dc27a4f28aa3d9e3e09', './lib/wiki-plugins/wikiplugin_signature.php', '24.9', 0),
('a92947c860fb757b78217ce13431febc', './lib/wiki-plugins/wikiplugin_skype.php', '24.9', 0),
('12859fadab595151702ae47abfb1b808', './lib/wiki-plugins/wikiplugin_slider.php', '24.9', 0),
('d5e229399169bb1a8985bff987f3fa58', './lib/wiki-plugins/wikiplugin_slideshow.php', '24.9', 0),
('96212b2b93da843f094386212614ff98', './lib/wiki-plugins/wikiplugin_slideshowslide.php', '24.9', 0),
('a65bca952aba73cedde19f900096e6dd', './lib/wiki-plugins/wikiplugin_smarty.php', '24.9', 0),
('d034bfb2071345c29a9f9d738b3d7d8d', './lib/wiki-plugins/wikiplugin_snarf.php', '24.9', 0),
('afe79e227aecd9e2c75b7abf1f1aae5b', './lib/wiki-plugins/wikiplugin_sort.php', '24.9', 0),
('ce1f6167214024ebbb93a54607f1ac27', './lib/wiki-plugins/wikiplugin_split.php', '24.9', 0),
('e98b09f96a74f7869d5772dcbddc6dd9', './lib/wiki-plugins/wikiplugin_sql.php', '24.9', 0),
('7592881cd67598609c3fa2d0c320a85d', './lib/wiki-plugins/wikiplugin_stat.php', '24.9', 0),
('d930e2952c0db87ad1b37df751e46963', './lib/wiki-plugins/wikiplugin_sub.php', '24.9', 0),
('19eecb893af5824ca03d09ebe221461a', './lib/wiki-plugins/wikiplugin_subscribegroup.php', '24.9', 0),
('52ec3be6562dc63889e98cc3d80df920', './lib/wiki-plugins/wikiplugin_subscribegroups.php', '24.9', 0),
('1263d54df5e3608d7a43dcdea77784ed', './lib/wiki-plugins/wikiplugin_subscribenewsletter.php', '24.9', 0),
('cffef6680836ef281986ef38ccbc2e7f', './lib/wiki-plugins/wikiplugin_sup.php', '24.9', 0),
('fb53a42d895a4de9f7ddc5ea598b337f', './lib/wiki-plugins/wikiplugin_survey.php', '24.9', 0),
('704083ff014660850a9500bb8287445d', './lib/wiki-plugins/wikiplugin_swiper.php', '24.9', 0),
('1a22490a4ee188b0a8ddf731d79fcd4f', './lib/wiki-plugins/wikiplugin_tabs.php', '24.9', 0),
('2b78c5741468524aece85fbf11fe78be', './lib/wiki-plugins/wikiplugin_tag.php', '24.9', 0),
('8ed21722543b5087793dad62ff7233e9', './lib/wiki-plugins/wikiplugin_timeline.php', '24.9', 0),
('04fa293bb7a31190a46a41b57d18955e', './lib/wiki-plugins/wikiplugin_titlesearch.php', '24.9', 0),
('65236906d34ad938a401f009aa24a7ae', './lib/wiki-plugins/wikiplugin_toc.php', '24.9', 0),
('a785a98cd98d77e6f9a12f3367507820', './lib/wiki-plugins/wikiplugin_together.php', '24.9', 0),
('dad796670cac99b127b866123ee591b1', './lib/wiki-plugins/wikiplugin_totp.php', '24.9', 0),
('96ea823b53a8a9af0e0634cf4769070f', './lib/wiki-plugins/wikiplugin_tour.php', '24.9', 0),
('87792e0df58d3512392b9a2cdeaa2f90', './lib/wiki-plugins/wikiplugin_tr.php', '24.9', 0),
('1514e5a0e3a17d71fbb763236a0c467f', './lib/wiki-plugins/wikiplugin_tracker.php', '24.9', 0),
('e51bbde8499cd6c84dce993663e64d32', './lib/wiki-plugins/wikiplugin_trackercalendar.php', '24.9', 0),
('4924eabf87b355f0777ed6da1896c668', './lib/wiki-plugins/wikiplugin_trackercomments.php', '24.9', 0),
('cc09cb34e1d4d2fba4c5314ab0b43ff6', './lib/wiki-plugins/wikiplugin_trackerfilter.php', '24.9', 0),
('b1fa2939ea3d43b88fe35a68a95fdc82', './lib/wiki-plugins/wikiplugin_trackerif.php', '24.9', 0),
('ad97aabd0f984a1a4a65344baa61e1a8', './lib/wiki-plugins/wikiplugin_trackeritemcopy.php', '24.9', 0),
('be6906eeb3cff40e2316fa25416cc915', './lib/wiki-plugins/wikiplugin_trackeritemfield.php', '24.9', 0),
('db146e16eea8c19be3417377db06b6a1', './lib/wiki-plugins/wikiplugin_trackerlist.php', '24.9', 0),
('c964243864daa0dd71f32c33f37a146a', './lib/wiki-plugins/wikiplugin_trackerprefill.php', '24.9', 0),
('490d4ddce5b4e8f066e9014c2f3846ab', './lib/wiki-plugins/wikiplugin_trackerquerytemplate.php', '24.9', 0),
('3065c1feafce62a2efd83ec7f04e6c86', './lib/wiki-plugins/wikiplugin_trackerstat.php', '24.9', 0),
('fafff0225b9e3a64b48a7441c37f0e7f', './lib/wiki-plugins/wikiplugin_trackertimeline.php', '24.9', 0),
('6b4b2dac05f4a118660bdfa27d16d6c5', './lib/wiki-plugins/wikiplugin_trackertoggle.php', '24.9', 0),
('a3873536a34f63703fdf2e8a51d8bc01', './lib/wiki-plugins/wikiplugin_trade.php', '24.9', 0),
('62590557af31480a698db62b14a2b965', './lib/wiki-plugins/wikiplugin_transclude.php', '24.9', 0),
('9ce1776c051c134bd2186b44ada658e6', './lib/wiki-plugins/wikiplugin_translated.php', '24.9', 0),
('0f864f7404abd55cd9f71f457b1543e2', './lib/wiki-plugins/wikiplugin_translationof.php', '24.9', 0),
('4279fcba42c1c915d518bdd83d3b430e', './lib/wiki-plugins/wikiplugin_twitter.php', '24.9', 0),
('7207b683cea9524686873e8eea4f3b18', './lib/wiki-plugins/wikiplugin_usercount.php', '24.9', 0),
('6869f0be8a7a7d50193cdb4b2b1c0517', './lib/wiki-plugins/wikiplugin_useringroup.php', '24.9', 0),
('d50a9198812a3833e772c5d393e89e4c', './lib/wiki-plugins/wikiplugin_userlastlogged.php', '24.9', 0),
('2d8ecc356bcd37c94f6382310fb5ed6e', './lib/wiki-plugins/wikiplugin_userlink.php', '24.9', 0),
('743778dfc8ff50845f1c383a45e23e6e', './lib/wiki-plugins/wikiplugin_userlist.php', '24.9', 0),
('de9ddff76c62b87aa1dbf3de40af115b', './lib/wiki-plugins/wikiplugin_userpref.php', '24.9', 0),
('97bf43af4901f30e4063640f27e4cd8a', './lib/wiki-plugins/wikiplugin_versions.php', '24.9', 0),
('297c5022e6095178a49e5821e290d0fa', './lib/wiki-plugins/wikiplugin_vimeo.php', '24.9', 0),
('e1f4642ef9f1091ca675479552bde11e', './lib/wiki-plugins/wikiplugin_vote.php', '24.9', 0),
('a43ee8e8b93653a36611d3f18633ed01', './lib/wiki-plugins/wikiplugin_votings.php', '24.9', 0),
('681b4ea9c168bd00cf95dd1a9ffe5b86', './lib/wiki-plugins/wikiplugin_vue.php', '24.9', 0),
('d1ba48967476976957e52f546d81c600', './lib/wiki-plugins/wikiplugin_wantedpages.php', '24.9', 0),
('a778161b35465fe3004c45c95a4a29e5', './lib/wiki-plugins/wikiplugin_webdocviewer.php', '24.9', 0),
('8b0c3baa2201cad0d0b9ea92ddc93550', './lib/wiki-plugins/wikiplugin_webservice.php', '24.9', 0),
('8443dd93f93f67460c2f15e7de99f41b', './lib/wiki-plugins/wikiplugin_wikidiff.php', '24.9', 0),
('3c4e6f56a85f055535d2a32dcf46a4aa', './lib/wiki-plugins/wikiplugin_wysiwyg.php', '24.9', 0),
('4971774d60990b9a105815f575898aa5', './lib/wiki-plugins/wikiplugin_xmlupdate.php', '24.9', 0),
('cac96090206fa46b6a6b700ebb0d0f17', './lib/wiki-plugins/wikiplugin_xmpp.php', '24.9', 0),
('c018f14dcbe09d661b1982879602770d', './lib/wiki-plugins/wikiplugin_youtube.php', '24.9', 0),
('4390ab0983bba8b75aa7e229039fc62f', './lib/wiki-plugins/wikiplugin_zotero.php', '24.9', 0),
('94610537a2a2c1892f39def2475752b2', './lib/wiki-plugins/wikiplugin_zoterolist.php', '24.9', 0),
('06807e6320afe060d92f7957802fca81', './lib/wiki/editlib.php', '24.9', 0),
('ffeeed38230cb5662e6c1df5104888d6', './lib/wiki/exportlib.php', '24.9', 0),
('e92bcdd1a1fd6dd1ace0baac2bab656d', './lib/wiki/flaggedrevisionlib.php', '24.9', 0),
('593012f248fb343d096dd1d39de2a001', './lib/wiki/histlib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/wiki/index.php', '24.9', 0),
('ff7756f23b582ebbbb2c506a2d9fb53a', './lib/wiki/pluginslib.php', '24.9', 0),
('be78eaad26b306ac300524c73a29757c', './lib/wiki/quantifylib.php', '24.9', 0),
('b5bb2ea7ba9cd326c20abb3e64a7d217', './lib/wiki/renderlib.php', '24.9', 0),
('e22420db491311f5e06d303e93e4e98c', './lib/wiki/semanticlib.php', '24.9', 0),
('312e59e2cb29876e3aaefb5d3d55d4a2', './lib/wiki/wikilib.php', '24.9', 0),
('72a7045feb4e87012f81f6a02def91bf', './lib/wiki/xmllib.php', '24.9', 0),
('8402062307c37ded1464d0e2d0a40de6', './lib/wizard/index.php', '24.9', 0),
('4d511d3f4c7a6bc83c38cdb65841b8d8', './lib/wizard/pages/admin_advanced.php', '24.9', 0),
('e1a2e56f7c27c8e517b83e01d313d4e6', './lib/wizard/pages/admin_auto_toc.php', '24.9', 0),
('f45eb4cc4c10cd29a4261249a6d7df68', './lib/wizard/pages/admin_category.php', '24.9', 0),
('86e91a7dc2f486f2169efd708b4eb158', './lib/wizard/pages/admin_community.php', '24.9', 0),
('14a489034161fe480d326f2aebe19df9', './lib/wizard/pages/admin_date_time.php', '24.9', 0),
('8f17ae4b0764f26f5a6e2f9d633b244b', './lib/wizard/pages/admin_editor_type.php', '24.9', 0),
('c798da1bcb9819e26762057032a1d62d', './lib/wizard/pages/admin_features.php', '24.9', 0),
('47bcfc8bbbab2640ab992175ae6ecda9', './lib/wizard/pages/admin_files.php', '24.9', 0),
('159065f953237ab06d8bda48744bc6f2', './lib/wizard/pages/admin_files_storage.php', '24.9', 0),
('08320f588d69ee96fab98595b5f30c7f', './lib/wizard/pages/admin_language.php', '24.9', 0),
('f2ea19a880ef89c7206863b9c5f54398', './lib/wizard/pages/admin_login.php', '24.9', 0),
('bf12e44467a2a855c678a1ee4ed778ff', './lib/wizard/pages/admin_look_and_feel.php', '24.9', 0),
('67a712eda1987057a1ca2e0237105217', './lib/wizard/pages/admin_namespace.php', '24.9', 0),
('9854f9ed764ebc97b89e9c34d4ce3fb2', './lib/wizard/pages/admin_search.php', '24.9', 0),
('deb02ff6f9bb42337403064b27539082', './lib/wizard/pages/admin_structures.php', '24.9', 0),
('ea2b630c5a037e7eeb34a36a3dca4800', './lib/wizard/pages/admin_text_area.php', '24.9', 0),
('20b4021578a27aa531bfa9ae48fb97b6', './lib/wizard/pages/admin_wiki.php', '24.9', 0),
('a96942fadccd732d20d90a5fc4d2c90e', './lib/wizard/pages/admin_wizard.php', '24.9', 0),
('5b6a6d5e0b475c38787a05d45797cc32', './lib/wizard/pages/admin_wizard_completed.php', '24.9', 0),
('240a34708a531f7b803b83f0ccadbb0c', './lib/wizard/pages/admin_wysiwyg.php', '24.9', 0),
('9e8c3d0303a0126ec7158994c237571c', './lib/wizard/pages/changes_doc_page_iframe.php', '24.9', 0),
('6b8ffc972b39cda2c225503dd102bad6', './lib/wizard/pages/changes_new_in_13.php', '24.9', 0),
('2fda5940672312e791c2d55016774360', './lib/wizard/pages/changes_new_in_14.php', '24.9', 0),
('53938f0bab0f2ef511e7fe3e1c75b030', './lib/wizard/pages/changes_new_in_15.php', '24.9', 0),
('f8c7626bfa1c263e784a9c1e4f82af93', './lib/wizard/pages/changes_new_in_16.php', '24.9', 0),
('1671e55ec475793bd599477226f58288', './lib/wizard/pages/changes_new_in_17.php', '24.9', 0),
('6f60fb8b6e1d73d285729323fb563ff5', './lib/wizard/pages/changes_new_in_18.php', '24.9', 0),
('3554be55b1c77ae44b2cc3c77776cda4', './lib/wizard/pages/changes_new_in_19.php', '24.9', 0),
('6389d266931adc5e17b4b0f82e2a84a6', './lib/wizard/pages/changes_new_in_20.php', '24.9', 0),
('87f6de61f945579fc0309e254e7b0b9b', './lib/wizard/pages/changes_new_in_21.php', '24.9', 0),
('b939351e9c4972ff975c2daa649285aa', './lib/wizard/pages/changes_new_in_22.php', '24.9', 0),
('5b5931442f30b20bc1a4aa08bb6ff13f', './lib/wizard/pages/changes_new_in_23.php', '24.9', 0),
('34efda33c592177cf8a0b0f4ca503540', './lib/wizard/pages/changes_new_in_24.php', '24.9', 0),
('b566a39c3a8c2f2a2d00e45fedd1e08d', './lib/wizard/pages/changes_novice_admin_assistance.php', '24.9', 0),
('a7fced7b159d26182ac3d2c627f79158', './lib/wizard/pages/changes_others.php', '24.9', 0),
('9fdc2e23cfccd149d461cfdf776543f6', './lib/wizard/pages/changes_permissions_and_logs.php', '24.9', 0),
('6bf3c7cafe78872531dab4e298b16cf9', './lib/wizard/pages/changes_send_feedback.php', '24.9', 0),
('e334991d17fede261de6982a6a401e95', './lib/wizard/pages/changes_trackers.php', '24.9', 0),
('162c8a5c0886f5276e1db48210d46479', './lib/wizard/pages/changes_ui.php', '24.9', 0),
('f021197b690f175865c256a1b7cc3255', './lib/wizard/pages/changes_wizard_completed.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/wizard/pages/index.php', '24.9', 0),
('334db598cb66a941ad46585e457fad45', './lib/wizard/pages/profiles_completed.php', '24.9', 0),
('1b1c16537d0e8b0b20b91fbba68e4eb9', './lib/wizard/pages/profiles_demo_cases_in_project_management.php', '24.9', 0),
('10ccec7e427c640fec1adb8e5c6373c9', './lib/wizard/pages/profiles_demo_common_confs.php', '24.9', 0),
('6e003120bde0ceddca11c5b3a03c3a8e', './lib/wizard/pages/profiles_demo_highly_specialized_confs.php', '24.9', 0),
('3339f560a08493f3a1b570f9fa7541a2', './lib/wizard/pages/profiles_demo_interesting_use_cases.php', '24.9', 0),
('bd3f217f1f11ab0b5758ef7a9cc8fb2b', './lib/wizard/pages/profiles_demo_more_advanced_confs.php', '24.9', 0),
('630f65c12b59cc512d655d93ba47aaba', './lib/wizard/pages/profiles_demo_other_interesting_use_cases.php', '24.9', 0),
('f7b40801620bfc6527d8ca9069160f96', './lib/wizard/pages/profiles_featured_site_confs.php', '24.9', 0),
('e02e27be5a01900d726e0dbc44e434bb', './lib/wizard/pages/profiles_useful_admin_confs.php', '24.9', 0),
('52473ecc4e5e879fc97dfad830cd3f29', './lib/wizard/pages/profiles_useful_changes_in_display.php', '24.9', 0),
('552c37e03c52857f22076f18bb55a959', './lib/wizard/pages/profiles_useful_micro_confs.php', '24.9', 0),
('fc0de3782ea8681184ebb368b4295ae0', './lib/wizard/pages/profiles_useful_new_tech_confs.php', '24.9', 0),
('12c51af4f3b2e1ecb4034b4e495655ca', './lib/wizard/pages/user_dummy1.php', '24.9', 0),
('a4c2150724b218296d38d3a6cdba9765', './lib/wizard/pages/user_dummy2.php', '24.9', 0),
('3bc6393357dc5b44ff579c00d1475f30', './lib/wizard/pages/user_dummy3.php', '24.9', 0),
('77e97b926a9200c610bb535081c6c64b', './lib/wizard/pages/user_preferences_info.php', '24.9', 0),
('47afb3ecebdc3c14e39fbcdad12488ef', './lib/wizard/pages/user_preferences_notifications.php', '24.9', 0),
('d949809467624262f1d907780d581c75', './lib/wizard/pages/user_preferences_params.php', '24.9', 0),
('cd74946736c47705b5b401fe76320432', './lib/wizard/pages/user_preferences_reports.php', '24.9', 0),
('93547e4d3c4acbe02cd7a46277997a9c', './lib/wizard/pages/user_tracker.php', '24.9', 0),
('a6179210e655a856685d2889228d94af', './lib/wizard/pages/user_wizard.php', '24.9', 0),
('946c737e8501dad99d382d77318939d8', './lib/wizard/pages/user_wizard_completed.php', '24.9', 0),
('4a2e62280193b5c63c3a1dbab94837b8', './lib/wizard/wizard.php', '24.9', 0),
('dae75986fd7ae97eade8f7c9ddab5e76', './lib/wizard/wizardlib.php', '24.9', 0),
('b6a1d5af68f4659e3003c61c0dd7d7d1', './lib/xmpp/ConverseJS.php', '24.9', 0),
('0f547abc1f5aeb690074f348ad33c781', './lib/xmpp/TikiXmppChat.php', '24.9', 0),
('0c7d4dd39fc0d886408116d2c879d1b8', './lib/xmpp/TikiXmppPrebind.php', '24.9', 0),
('9c3e71977d95bbfe85714363f4c5cba2', './lib/xmpp/css/conversejs.css', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/xmpp/css/index.php', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/xmpp/html/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './lib/xmpp/index.php', '24.9', 0),
('27a3ccfe4949c6beeb5cfdf0cbec16d8', './lib/xmpp/js/conversejs-tiki-oauth.js', '24.9', 0),
('03ba7a32f7028507c965516a878fa620', './lib/xmpp/js/conversejs-tiki.js', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './lib/xmpp/js/index.php', '24.9', 0),
('cb97919297cd99aef449c7ac0fdf2ee4', './lib/xmpp/xmpplib.php', '24.9', 0),
('4e174c6dee1ce0b62551eed299bc4330', './lib/ziplib.php', '24.9', 0),
('c1caca86181c9bbfd49e4829f4676561', './lib/zoterolib.php', '24.9', 0),
('83bb6332ef372810025bbe6b6acdee20', './list-file_backlinks_ajax.php', '24.9', 0),
('47e2884c1ae2c89a33c32e18f8e3e32c', './list-tracker_field_values_ajax.php', '24.9', 0),
('1c95eaffdd15d4a796b093d380bbffb0', './lists/articles.php', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './lists/index.php', '24.9', 0),
('c64e7d678b24b63db58a8c1fa125931b', './messu-archive.php', '24.9', 0),
('105fdd906fb854329cf7f15c33bf696b', './messu-broadcast.php', '24.9', 0),
('ce45258bf33f689c11bddf2664f5024e', './messu-compose.php', '24.9', 0),
('a62f1e8a6f3203d62ef966b1ce91202b', './messu-mailbox.php', '24.9', 0),
('5df569ab6a9971268c5e76bc13291288', './messu-read.php', '24.9', 0),
('ca095a5f774b2ff7015385b33cbcf1e8', './messu-read_archive.php', '24.9', 0),
('f11f0d95d2d18c9856c794439d8b70b7', './messu-read_sent.php', '24.9', 0),
('68f04491d11f15127d24663d31e976ee', './messu-sent.php', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './modules/index.php', '24.9', 0),
('1a6e4ffe68ae5dc5451e0432c2876c04', './modules/mod-func-action_calendar.php', '24.9', 0),
('20c5117530379abf4ddd16d771e420ff', './modules/mod-func-action_similarcontent.php', '24.9', 0),
('fbef1469afa8afb10a2fb4d50c9d5152', './modules/mod-func-adminbar.php', '24.9', 0),
('5534d6a47edba7769db3896c51c99278', './modules/mod-func-adsense.php', '24.9', 0),
('f19839048b43f75dd0e210e12faf50dd', './modules/mod-func-article_archives.php', '24.9', 0),
('c733f35c20648a8a0443d91595898ff5', './modules/mod-func-article_topics.php', '24.9', 0),
('431860926a6e93163ea0a67aa41808c9', './modules/mod-func-articles.php', '24.9', 0),
('e140586e321f0fabfa92a1e3a84ee780', './modules/mod-func-assistant.php', '24.9', 0),
('df6febc79b4656dae837a39b1812ef66', './modules/mod-func-blog_last_comments.php', '24.9', 0),
('071ee22139a2092a453fb5c709507ed3', './modules/mod-func-breadcrumb.php', '24.9', 0),
('80b90552e047d776e0e68ddb3e8d2b28', './modules/mod-func-breadcrumbs.php', '24.9', 0),
('31f0311b8db8077fcc5e1f38405adc63', './modules/mod-func-calendar_new.php', '24.9', 0),
('6750b3ab4265ed09ed3d545245af1e13', './modules/mod-func-cart.php', '24.9', 0),
('750519954e59104e9bf31266157f67f2', './modules/mod-func-categories.php', '24.9', 0),
('2733e44bfd4d9306acbdc4c0f76c0239', './modules/mod-func-category_transition.php', '24.9', 0),
('2257c88613af4b7dc6b056b317ab3a0b', './modules/mod-func-change_category.php', '24.9', 0),
('9b4e63d1c6d8e925edcb035b1f6d50b4', './modules/mod-func-collapse.php', '24.9', 0),
('5a2fc29135e83bc5842d1e1faf0b4dc3', './modules/mod-func-comm_received_objects.php', '24.9', 0),
('0aa6b9da1f753e33b9e63299d577edbf', './modules/mod-func-contributors.php', '24.9', 0),
('bd9380aea1c5e328c3e1cb31e5668407', './modules/mod-func-cookiesettings.php', '24.9', 0),
('37d3463ff8eefd1ba0ecda6d483508e1', './modules/mod-func-credits.php', '24.9', 0),
('79277d79ff752a2a3977bf5ef6b7c37f', './modules/mod-func-current_activity.php', '24.9', 0),
('709a030b638124dbb73396ca690484a2', './modules/mod-func-directory_last_sites.php', '24.9', 0),
('c831512045ecf471bbdf93cdaac7395c', './modules/mod-func-directory_stats.php', '24.9', 0),
('3a967043b2858b249d30e8df34fa0c47', './modules/mod-func-directory_top_sites.php', '24.9', 0),
('d7f275f7e77293c379b655df82645b05', './modules/mod-func-domain_password.php', '24.9', 0),
('278bf5731fb219a5593de1615c8347b5', './modules/mod-func-facebook.php', '24.9', 0),
('c4ed5c61116b9b992a4e4e6fbfa75fb9', './modules/mod-func-featured_links.php', '24.9', 0),
('f3a8650517a0dffdda61cbfcd3bcc6e8', './modules/mod-func-file_galleries.php', '24.9', 0),
('6525c23189c330d96a9f1d073525ed9c', './modules/mod-func-forums_best_voted_topics.php', '24.9', 0),
('40e6c5610a09b1cacb859e1a7fb66df3', './modules/mod-func-forums_last_posts.php', '24.9', 0),
('295050ed6afacfc23de95f9d404c5c91', './modules/mod-func-forums_most_commented_forums.php', '24.9', 0),
('d844bd3f50a1cc829dadc07305e38354', './modules/mod-func-forums_most_read_topics.php', '24.9', 0),
('d12bc79110504bc0120ba6c95fd68716', './modules/mod-func-forums_most_visited_forums.php', '24.9', 0),
('5eb20c3b6f53bf35f522f2cf64d874f0', './modules/mod-func-freetag.php', '24.9', 0),
('bac2a672c9269130f88aaaa8b5868147', './modules/mod-func-freetags_current.php', '24.9', 0),
('75dedc44e7257f1402f9917f4fc6f11c', './modules/mod-func-freetags_morelikethis.php', '24.9', 0),
('a1e631761844cba82254fcab26029013', './modules/mod-func-freetags_most_popular.php', '24.9', 0),
('677b6e31eca0dd5e54d6318170001cbd', './modules/mod-func-freetags_prefered.php', '24.9', 0),
('058b062cbd10afc83c5a062c90d020a4', './modules/mod-func-friend_list.php', '24.9', 0),
('00a41f28e1cd18fb55f4d1e6dfa091f4', './modules/mod-func-git_detail.php', '24.9', 0),
('def4f42b014674afdac2062ae7b4f4cc', './modules/mod-func-google.php', '24.9', 0),
('be4b1ffcc5f0c0616862e0d0df760e82', './modules/mod-func-groups_emulation.php', '24.9', 0),
('6db8f032ccfc88a1135c0bc0d7092190', './modules/mod-func-last_actions.php', '24.9', 0),
('b2c26284fb7aa5e18636587a9f3f8e01', './modules/mod-func-last_blog_posts.php', '24.9', 0),
('c34e4e5313652eb3b34ef1991436314d', './modules/mod-func-last_category_objects.php', '24.9', 0),
('6a5ba463be302edeccef09cc05cda18a', './modules/mod-func-last_created_blogs.php', '24.9', 0),
('98bc848161752c419f3c441700d16d21', './modules/mod-func-last_created_faqs.php', '24.9', 0),
('d128bdd0099048a34948cd6435295c3b', './modules/mod-func-last_created_quizzes.php', '24.9', 0),
('af963a8b129c5d3caede9dda957efcbc', './modules/mod-func-last_file_galleries.php', '24.9', 0),
('62fc09658dd641975322eac201bfce06', './modules/mod-func-last_files.php', '24.9', 0),
('300c1c6088fd704559d4648410ca197d', './modules/mod-func-last_modif_events.php', '24.9', 0),
('e42e13be392213a8f84daa0cc47e537c', './modules/mod-func-last_modif_pages.php', '24.9', 0),
('0685cde5484563bfaf52026ea37d656b', './modules/mod-func-last_modified_blogs.php', '24.9', 0),
('fb0e27b4af2149b8a28904f0bffe1e3f', './modules/mod-func-last_podcasts.php', '24.9', 0),
('a443dd4b5a582921886417d0b9bc7aef', './modules/mod-func-last_submissions.php', '24.9', 0),
('f96b600c4c6f79ae70267a04fcc7b7ab', './modules/mod-func-last_tracker_comments.php', '24.9', 0),
('7ddc702a34368ba558bdb0ce6e143450', './modules/mod-func-last_tracker_items.php', '24.9', 0),
('82d8b9097065075ef8e96e497a29ff81', './modules/mod-func-last_validated_faq_questions.php', '24.9', 0),
('2ff2f925476e5860dfff5fdd24b1c1f4', './modules/mod-func-last_visitors.php', '24.9', 0),
('34ecea9d5bff1ea84cabe0c3cdb0ce08', './modules/mod-func-last_youtube_playlist_videos.php', '24.9', 0),
('0ffebcedf5f2b56e7ea5e2c22433b217', './modules/mod-func-list.php', '24.9', 0),
('9f49e7dd7981106ce7b157649692f9b5', './modules/mod-func-live_support.php', '24.9', 0),
('201bda0a179e02b6d331e8fc5effdd35', './modules/mod-func-loadstats.php', '24.9', 0),
('fbb1c90cc4edc321dfe7da825249bee1', './modules/mod-func-locator.php', '24.9', 0),
('1aa03a15c53fe4263602fba2c1ffc7df', './modules/mod-func-login_box.php', '24.9', 0),
('751b48d1ca19e9f30b77ec223bb17e3a', './modules/mod-func-logo.php', '24.9', 0),
('123858f13f07cab25957c3b457ecf6b7', './modules/mod-func-map_edit_features.php', '24.9', 0),
('a67d38a83ec0ae80c544f84cabcb893e', './modules/mod-func-map_layer_selector.php', '24.9', 0),
('9c82bfe24c4749ca53df6ce2657f68a2', './modules/mod-func-map_mode_selector.php', '24.9', 0),
('159276756a4a41119c9b0305dec56030', './modules/mod-func-map_search_location.php', '24.9', 0),
('f0ff89fa29b613785ab8412325347546', './modules/mod-func-menu.php', '24.9', 0),
('0521a1ca9c5375a51c691dab7d133d84', './modules/mod-func-menupage.php', '24.9', 0),
('6850922562ba6342cc3c191024f37612', './modules/mod-func-menustructure.php', '24.9', 0),
('c9dc068d13c62e30d4c1c7ffb89cb83b', './modules/mod-func-messages_unread_messages.php', '24.9', 0),
('0c53ba4895e924c3a7cb35bfb70935d4', './modules/mod-func-minichat.php', '24.9', 0),
('ab814aee5a31b2a7e2e0089e699fcd62', './modules/mod-func-mobile.php', '24.9', 0),
('180d048cfa7c85ae1b5164d4cd28468d', './modules/mod-func-months_links.php', '24.9', 0),
('0f991da194e6a03e7e3a7d1a1f7b209a', './modules/mod-func-most_commented.php', '24.9', 0),
('b7c89a50379ed045f2eccbd376a0c5b7', './modules/mod-func-mustread.php', '24.9', 0),
('d1f4d4bd64ea76a26544fa780d7c4367', './modules/mod-func-notificationlink.php', '24.9', 0),
('ce8a4b7df428d483579a208262620e91', './modules/mod-func-num_submissions.php', '24.9', 0),
('3b3284fa547694fbc24c028754f078c5', './modules/mod-func-old_articles.php', '24.9', 0),
('338c9c860e760f0428c1307d03350aa7', './modules/mod-func-package.php', '24.9', 0),
('1eac4824b938890f57501dab2f98ab08', './modules/mod-func-payment_outstanding.php', '24.9', 0),
('8ce01bdb255fb4eba3b03648a52f645e', './modules/mod-func-permissions.php', '24.9', 0),
('0d9a8350717cacd7217643b1980d0782', './modules/mod-func-perspective.php', '24.9', 0),
('d3ba4dda82a6b9214b24b7169f576b35', './modules/mod-func-poweredby.php', '24.9', 0),
('20fd327c740c3e3308d86f41d4d47954', './modules/mod-func-quick_edit.php', '24.9', 0),
('6bdddbb7ab1be8c755b5c1eb6c9941cb', './modules/mod-func-quick_search.php', '24.9', 0),
('55dc922814e76416eee29ca2415146b4', './modules/mod-func-quickadmin.php', '24.9', 0),
('3d827b77ff34a774ec83b380bedb2058', './modules/mod-func-random_pages.php', '24.9', 0),
('7e1a23c915d3a39d0ae45f2efbf84d03', './modules/mod-func-recordrtc.php', '24.9', 0),
('67a7a8ce339280a5e3d9b1c1f432b1b3', './modules/mod-func-register.php', '24.9', 0),
('12b751bbf83953048572d8ec1ff7dc6b', './modules/mod-func-rsslist.php', '24.9', 0),
('8cd02083b0214c235bfd363920859dc5', './modules/mod-func-search.php', '24.9', 0),
('e17bb4b9dd347f36cfb5937bbc0f39ad', './modules/mod-func-search_last_rebuild_stats.php', '24.9', 0),
('d56820038f432f2ee6f978d27e4344f1', './modules/mod-func-search_morelikethis.php', '24.9', 0),
('bd87cb3441097dea990a41b054c52205', './modules/mod-func-search_wiki_page.php', '24.9', 0),
('b0caf41381a6b624fdd2d356379cabfa', './modules/mod-func-semantic_links.php', '24.9', 0),
('8266c442b3092d732e4d6e91951a274e', './modules/mod-func-share.php', '24.9', 0),
('1c968d490576e6e41cc4cdec282b9550', './modules/mod-func-short_url.php', '24.9', 0),
('20501a98810ad15c6685f8b69cadedd3', './modules/mod-func-shoutbox.php', '24.9', 0),
('901103d4e5199618e95ec8b901b11072', './modules/mod-func-since_last_visit.php', '24.9', 0),
('33b101b6465673e8694709842232b617', './modules/mod-func-since_last_visit_new.php', '24.9', 0),
('b871ec75278481ea2b3223790c456d1c', './modules/mod-func-svnup.php', '24.9', 0),
('58d483546c01cfae74e5dd4b76b7e153', './modules/mod-func-switch_lang.php', '24.9', 0),
('75f1b37f31598bddc3f59bf3c64366df', './modules/mod-func-switch_lang_admin.php', '24.9', 0),
('d96e19bf44200b97fc9d327311bbc059', './modules/mod-func-switch_theme.php', '24.9', 0),
('ba1aeca238a2264a61895def21c0ed94', './modules/mod-func-terminology.php', '24.9', 0),
('52b629bb331e218092697ee9828e4988', './modules/mod-func-tikitests.php', '24.9', 0),
('8cea4c9d53c7d916560a86d06bb5d0a0', './modules/mod-func-top_active_blogs.php', '24.9', 0),
('b0bdec8598ece726c81f19d69980973e', './modules/mod-func-top_articles.php', '24.9', 0),
('5556eac1d162ce2279b39d01c16421c7', './modules/mod-func-top_blog_posters.php', '24.9', 0),
('07a4cbde700174fcec927de90b30a719', './modules/mod-func-top_file_galleries.php', '24.9', 0),
('f0b9af0a124c810bef4d40ec859bb8c5', './modules/mod-func-top_files.php', '24.9', 0),
('2d1c788bdffb4a26c89bb20910446f52', './modules/mod-func-top_forum_posters.php', '24.9', 0),
('9ffa7d26f1c1139f401f710fd6d7722b', './modules/mod-func-top_objects.php', '24.9', 0),
('25e13c62abd812e29a58f2008b2daf80', './modules/mod-func-top_pages.php', '24.9', 0),
('e1f7ac5f40e1a41038e7e5857c5e9059', './modules/mod-func-top_quizzes.php', '24.9', 0),
('681d40c85c08b9e729e53ed776bd2742', './modules/mod-func-top_visited_blogs.php', '24.9', 0),
('3ef3f88b81cacb8d030d00ead4d3d58f', './modules/mod-func-top_visited_faqs.php', '24.9', 0),
('02baa6595ad16ab129c68aee6e21df07', './modules/mod-func-tracker_input.php', '24.9', 0),
('8ef5916dba3f0f7ddb41c8042574511a', './modules/mod-func-trackerhelp.php', '24.9', 0),
('8a5d5376e738e82bafceef15fbcaa131', './modules/mod-func-translation.php', '24.9', 0),
('f154e8a22da1f2a034e813756d74218b', './modules/mod-func-twitter.php', '24.9', 0),
('7cc0cc777e6f2ab70f93ae7ccd38498a', './modules/mod-func-upcoming_events.php', '24.9', 0),
('8a5a0a684eae8b8a4de3d8e139240274', './modules/mod-func-user_blogs.php', '24.9', 0),
('1061431cc7093182b9ffc823d2e5d568', './modules/mod-func-user_bookmarks.php', '24.9', 0),
('0f982d70d1422e1b38881f706e566ed7', './modules/mod-func-user_pages.php', '24.9', 0),
('c31c1073d3122cc94621e6a7444232d4', './modules/mod-func-user_tasks.php', '24.9', 0),
('fa4090c9129ef7e8834b6a4ba0b78d82', './modules/mod-func-user_tasks_public.php', '24.9', 0),
('7f675b228e90c891d5f765231454ead0', './modules/mod-func-usergroup_tracker.php', '24.9', 0),
('e3d0efb6af566a534c53edb26ddad7c4', './modules/mod-func-users_list.php', '24.9', 0),
('143144b041ff27f7217435177df69eb3', './modules/mod-func-users_own_rank.php', '24.9', 0),
('ddc2ed29d5cd8d0169958a45ecaff0a0', './modules/mod-func-users_rank.php', '24.9', 0),
('5f85c9dc46172a8a2419dcb856bfce65', './modules/mod-func-websearch.php', '24.9', 0),
('4eae9b54c469e8212a1c7fedd1125527', './modules/mod-func-whats_related.php', '24.9', 0),
('077558566f1097a9f5effeeeb54b5473', './modules/mod-func-who_is_there.php', '24.9', 0),
('991dee4c608e2f7c0c62857805beabaf', './modules/mod-func-wiki_last_comments.php', '24.9', 0),
('6045cec880bf4ceb024648e842014fb3', './modules/mod-func-xmpp.php', '24.9', 0),
('f4e10ca29ffdf33f3688ded9db9b2107', './modules/mod-func-youtube.php', '24.9', 0),
('6f028942cc9d2f2230a66a10eaf13598', './modules/mod-func-zone.php', '24.9', 0),
('1ab299b67b8254fd30615391b4a1d1a7', './modules/mod-func-zotero.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/check.php', '24.9', 0),
('863ab68f3cb6c57894272e980ed07952', './permissioncheck/create_new_htaccess.php', '24.9', 0),
('68fa031ae2f5e2a294febf42386b7b14', './permissioncheck/functions.inc.php', '24.9', 0),
('d27c2e34577e00f54a1f211b720ecd6e', './permissioncheck/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/insane/check.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './permissioncheck/insane/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/mixed/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/mixed/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/morepain/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/morepain/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/moreworry/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/moreworry/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/pain/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/pain/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/paranoia-suphp/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/paranoia-suphp/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/paranoia/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/paranoia/index.php', '24.9', 0),
('804eab397572635d9ec2b3d105982233', './permissioncheck/permission_granted.inc.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/risky/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/risky/index.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/sbox/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/sbox/index.php', '24.9', 0),
('9cc3f78c4e4c83ce85ea07a3421894ea', './permissioncheck/usecases.inc.php', '24.9', 0),
('7dac97a220f84ed2be99bfb3f318bb75', './permissioncheck/worry/check.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './permissioncheck/worry/index.php', '24.9', 0),
('923edb14acc137125628f3575d04c129', './php_version_constants.php', '24.9', 0),
('0009deca84766dd592f6fea933cebc73', './poll_categorize.php', '24.9', 0),
('9e917daaed02452044b491c450df2180', './received_article_image.php', '24.9', 0),
('ee05fcb568e4844b1a4c9963d90bd654', './references.php', '24.9', 0),
('50d63a9be8bdd0b94b1e49413c780c39', './reindex_file.php', '24.9', 0),
('30749e86bcaaf5c5a052ae1e92df1dde', './remote.php', '24.9', 0),
('0d5ec3be85757b956b4769d817dc1cdf', './route.php', '24.9', 0),
('36a119bc54ebe94340c32e3fb4751890', './select_banner.php', '24.9', 0),
('c0bed3b3d1d9f70c0cc4ebe538545009', './show_image.php', '24.9', 0),
('cb9386a860ead39fe4360dfee32a2b67', './snarf_ajax.php', '24.9', 0),
('42af1b8e7412d7006fbd725a39365716', './storage/index.php', '24.9', 0),
('7dee02b08f61f79ee1005517e938f290', './storage/public/index.php', '24.9', 0),
('994a466a017eb4647f9954d13756b8fe', './storage/public/vue-mf/index.php', '24.9', 0),
('3133b1abb36bf2e3bb5e74f4aed07c96', './storage/public/vue-mf/kanban/index.php', '24.9', 0),
('0cc381684bf36cba780176007746e9d3', './storage/public/vue-mf/kanban/vue-mf-kanban.min.js', '24.9', 0),
('3133b1abb36bf2e3bb5e74f4aed07c96', './storage/public/vue-mf/root-config/index.php', '24.9', 0),
('be457601610623fe7880321e5e7aa253', './storage/public/vue-mf/root-config/vue-mf-root-config.min.js', '24.9', 0),
('3133b1abb36bf2e3bb5e74f4aed07c96', './storage/public/vue-mf/styleguide/index.php', '24.9', 0),
('3dfb00038c5094a6ce727373398036db', './storage/public/vue-mf/styleguide/vue-mf-styleguide.min.js', '24.9', 0),
('ad0e24281b85ad2f39f4eeeb44098889', './sw.js', '24.9', 0),
('1388b512d493f117bcb998f367e782e8', './templates/access/confirm.tpl', '24.9', 0),
('a8afc2a0843f92144d2d8dfb70316ec1', './templates/access/confirm_select.tpl', '24.9', 0),
('24c970b1cbbfc18c9de4044e4f9a215d', './templates/access/include_extra_fields.tpl', '24.9', 0),
('55c798e6dfff0cd75cab0df80219cdd1', './templates/access/include_hidden.tpl', '24.9', 0),
('9fb6903d89fd48a852d73c1e1fdb4f27', './templates/access/include_items.tpl', '24.9', 0),
('6eb4cadd990becaf2c67242b6aeea942', './templates/access/include_submit.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/access/index.php', '24.9', 0),
('b8b78a69474a4363943fd133c77c0822', './templates/activity/activityframe.tpl', '24.9', 0),
('23ffb6e66037e6aaf1a7168a4bddc211', './templates/activity/activitystream.tpl', '24.9', 0),
('4d5d4ef3c4c8b66b6f331aa65fe8746b', './templates/activity/default_event.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/activity/index.php', '24.9', 0),
('3b775a6e9753b7dd72927c7b81c9cb1b', './templates/activity/tiki.comment.post.tpl', '24.9', 0),
('3b775a6e9753b7dd72927c7b81c9cb1b', './templates/activity/tiki.comment.reply.tpl', '24.9', 0),
('86f9e2d5986ab880c8394b386a4a4736', './templates/activity/tiki.forumpost.create.tpl', '24.9', 0),
('681602976eadf14916978e4bc90a6041', './templates/activity/tiki.forumpost.reply.tpl', '24.9', 0),
('1aa21cc42ecca88ab0f7e3171adbb6fc', './templates/activity/tiki.forumpost.update.tpl', '24.9', 0),
('3e7671f81f4e088788098238e749fe35', './templates/activity/tiki.mustread.required.tpl', '24.9', 0),
('a00fd395ee7260112eb651c411c8c1cd', './templates/activity/tiki.query.critical.tpl', '24.9', 0),
('c6e1ec5cd4b30e768ca2e3e42df79f3f', './templates/activity/tiki.query.high.tpl', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('a9f1b6be0d385fb17986564989cd46af', './templates/activity/tiki.query.low.tpl', '24.9', 0),
('4597f2528e3d04ed0381aae0a5296a62', './templates/activity/tiki.recommendation.incoming.tpl', '24.9', 0),
('f861845ad2d0afb96bf532cf6e8cf810', './templates/activity/tiki.tracker.create.tpl', '24.9', 0),
('e3de9395a818db2975f6b18a324b4b0f', './templates/activity/tiki.trackeritem.create.tpl', '24.9', 0),
('0f63a9e9764b2a9c00b6a237aa4cab88', './templates/activity/tiki.trackeritem.update.tpl', '24.9', 0),
('0e665e0873c88b2fd9504c46e97ad82c', './templates/activity/tiki.user.follow.add.tpl', '24.9', 0),
('77490102a3675d9fed0a518d981c7d5c', './templates/activity/tiki.user.follow.incoming.tpl', '24.9', 0),
('30c00cbe62e47516be0590006d60f610', './templates/activity/tiki.user.friend.add.tpl', '24.9', 0),
('6ca4d6772c95c534ebeb9edbbc9541b7', './templates/activity/tiki.wiki.create.tpl', '24.9', 0),
('a92845f63c2524257804c1c6726d1572', './templates/activity/tiki.wiki.update.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/activitystream/index.php', '24.9', 0),
('c348bbb04ce5c3aef1e0c49441ffc530', './templates/activitystream/render.tpl', '24.9', 0),
('73d904b437b1d1608c6593213c8e966c', './templates/addreference.tpl', '24.9', 0),
('20311cfbfc42b759a9d25b2a3846bb22', './templates/admin/admin_navbar.tpl', '24.9', 0),
('6e830ea72f1f35d5ce41fc45df2c516f', './templates/admin/admin_navbar_menu.tpl', '24.9', 0),
('ff4382e68cdcbce57e64b06f34bc96b4', './templates/admin/admin_suggestion.tpl', '24.9', 0),
('95d76417e888e1ccf4cfcc686a490129', './templates/admin/include_ads.tpl', '24.9', 0),
('a399d490518fe568f41b24c75fe57b48', './templates/admin/include_anchors.tpl', '24.9', 0),
('88cd4a98fd44441fa1e4699d966488f6', './templates/admin/include_apply_bottom.tpl', '24.9', 0),
('86e52111ed91c6cfb7be501dfa834e86', './templates/admin/include_apply_top.tpl', '24.9', 0),
('8e7679b0b5aa7dfcf011b8f5da52df19', './templates/admin/include_articles.tpl', '24.9', 0),
('9b64703d854ecff2f477ec9edc2e7a84', './templates/admin/include_blogs.tpl', '24.9', 0),
('b4411da1535db9a5589e915bf395627b', './templates/admin/include_calendar.tpl', '24.9', 0),
('6740555c027f178b1e2463c8e9992180', './templates/admin/include_category.tpl', '24.9', 0),
('c9bccdd800e8b411e4724fce2b030b4f', './templates/admin/include_comments.tpl', '24.9', 0),
('fc2e87b6e2439b3ca1a65e0270ceedb4', './templates/admin/include_community.tpl', '24.9', 0),
('28d8f95c3657718368372ffb5e30b865', './templates/admin/include_connect.tpl', '24.9', 0),
('65f5ec416ca2be9a09091d39b7f57333', './templates/admin/include_copyright.tpl', '24.9', 0),
('e74d7b5ac7748ab9f27308d7f1226da5', './templates/admin/include_directory.tpl', '24.9', 0),
('b50c4c4233dbd5ed3ef1be427758db3a', './templates/admin/include_extension_package_inactive.tpl', '24.9', 0),
('a78c75d44a68c06c9b9f55697142620f', './templates/admin/include_extension_package_missing_page.tpl', '24.9', 0),
('162da46e27796e5b965d62822965fd06', './templates/admin/include_faqs.tpl', '24.9', 0),
('d18f6cca59eaa9e0bbf82e95a1d5e3ee', './templates/admin/include_features.tpl', '24.9', 0),
('8abffbb7b41d2a96be56a4c432445454', './templates/admin/include_fgal.tpl', '24.9', 0),
('c283c33b265106eecca5dfbf7147f95a', './templates/admin/include_forums.tpl', '24.9', 0),
('50b5c8fd5426ea8df851f1d890cbaec9', './templates/admin/include_freetags.tpl', '24.9', 0),
('0e34c533143a4526ceecb1ada357aad2', './templates/admin/include_general.tpl', '24.9', 0),
('224717f2086d6d31a215746c757739a6', './templates/admin/include_i18n.tpl', '24.9', 0),
('870f39d9b8c51510fbf0a490c3e88bba', './templates/admin/include_intertiki.tpl', '24.9', 0),
('79b6cb8f75210985e15fd4f048274d6d', './templates/admin/include_list_sections.tpl', '24.9', 0),
('93976833b8506572c22591f3744d5d1f', './templates/admin/include_login.tpl', '24.9', 0),
('10a71c4bd4f22ce4b6ed1f497ac7c698', './templates/admin/include_look.tpl', '24.9', 0),
('97786c396cf1319ae540710ec1203507', './templates/admin/include_maps.tpl', '24.9', 0),
('86ac4167d0348e2338fa7e9cf5542187', './templates/admin/include_messages.tpl', '24.9', 0),
('9f554214b03a32e382b4d6897db48ec2', './templates/admin/include_metatags.tpl', '24.9', 0),
('29b98f565a230472fbc603b780b09faa', './templates/admin/include_module.tpl', '24.9', 0),
('f2d765517b0ef94ea47bf8a1679474a9', './templates/admin/include_packages.tpl', '24.9', 0),
('8c4cdf2c1036891b99fea56f21d15322', './templates/admin/include_payment.tpl', '24.9', 0),
('e7cb0cb3e9a82026676fcc048a6fffe4', './templates/admin/include_performance.tpl', '24.9', 0),
('ca327ecc636df0c750e1f1fc805ddf37', './templates/admin/include_polls.tpl', '24.9', 0),
('e9e839ef61de19ee2926080d0df25b21', './templates/admin/include_print.tpl', '24.9', 0),
('050adae5826c197dac1b1ca39085ad68', './templates/admin/include_profiles.tpl', '24.9', 0),
('6c8e43f7ebfaf796586797bf5c186c29', './templates/admin/include_profiles_preview.tpl', '24.9', 0),
('4d114e9154303167cdcd30a4db3d370a', './templates/admin/include_rating.tpl', '24.9', 0),
('12e5bd34741ebf63a14cd4e40cb3b459', './templates/admin/include_rss.tpl', '24.9', 0),
('77e1f58c9dcffb95efeed7622541855a', './templates/admin/include_rtc.tpl', '24.9', 0),
('83fa6406b54f6605e115475d506844e0', './templates/admin/include_score.tpl', '24.9', 0),
('7d8b9ecc0f1bff2b8f4a9e799e64f36c', './templates/admin/include_search.tpl', '24.9', 0),
('2a40ef26d6c62335293772c4bad56799', './templates/admin/include_search_report_string_in_db.tpl', '24.9', 0),
('4830428ff96aaa0ef78cb952c26de2a7', './templates/admin/include_security.tpl', '24.9', 0),
('4518ffe8ed49a8bbf0f32fbc32721558', './templates/admin/include_sefurl.tpl', '24.9', 0),
('ff97e4a771b8027a8eeb444d4eaecaf6', './templates/admin/include_semantic.tpl', '24.9', 0),
('f4dfb5bf2b992343219dcadce3fbe0df', './templates/admin/include_share.tpl', '24.9', 0),
('89012029c658ff35a5aded7efe83c913', './templates/admin/include_socialnetworks.tpl', '24.9', 0),
('77fd3d2bff413dbca7cbeb409cc8b144', './templates/admin/include_socnets.tpl', '24.9', 0),
('b4e08684e05034db732df7d77c3a9cab', './templates/admin/include_stats.tpl', '24.9', 0),
('879c806dfea0d37132a1cc8cc5e53988', './templates/admin/include_textarea.tpl', '24.9', 0),
('493c8140f0f13542555f01c25567f22a', './templates/admin/include_trackers.tpl', '24.9', 0),
('07da0c7d4ac4886e7657105857d7cef9', './templates/admin/include_user.tpl', '24.9', 0),
('41bd1eebe0ce10c49e1b98dc17b71cc5', './templates/admin/include_video.tpl', '24.9', 0),
('9c0e96613edb7418942aa217155f1118', './templates/admin/include_webservices.tpl', '24.9', 0),
('4f978469836bc30efbdfeb786f4d1c61', './templates/admin/include_wiki.tpl', '24.9', 0),
('7f2a055e40edd6a899324826cbc42aed', './templates/admin/include_wikiatt.tpl', '24.9', 0),
('4a75c256f05ea021cc5edf3696f3e4ab', './templates/admin/include_workspace.tpl', '24.9', 0),
('75b94c721ca0044d223b02dc93b2debb', './templates/admin/include_wysiwyg.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/admin/index.php', '24.9', 0),
('733125ce1b9a7ca593baf8c8d7cc62ab', './templates/admin/version_check.tpl', '24.9', 0),
('42d680c14c651b121cb50613fb5581e1', './templates/admin_modules_form.tpl', '24.9', 0),
('778d53182785ce1b12f1655fd580c33f', './templates/antibot.tpl', '24.9', 0),
('d5964c89f2a237c89c5e76ae748310f4', './templates/api/docs.tpl', '24.9', 0),
('7764406b2aa5a45a8d5737843fbcb715', './templates/api_token/edit.tpl', '24.9', 0),
('71e02081ad63a6027953ccad43de9aa9', './templates/api_token/list.tpl', '24.9', 0),
('453bc9eded5d8c451dc5f1bdc3635611', './templates/api_token/new.tpl', '24.9', 0),
('4a5dc5ebcb7d14080768167f704b3a3a', './templates/article-teaser.tpl', '24.9', 0),
('e7e6c45e901a7a8686e2f17cda534ee7', './templates/article.tpl', '24.9', 0),
('db18bb739d873c57f397f0e05e812b43', './templates/article/create_from_url.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/article/index.php', '24.9', 0),
('ff642b3d6c069c912048a3676b9f760c', './templates/article_trailer.tpl', '24.9', 0),
('00543e0c23c360ad48c95e8cf18926ec', './templates/attachments.tpl', '24.9', 0),
('1f815ec7dbfc044767af2c78f68ab2f3', './templates/attachments_tracker.tpl', '24.9', 0),
('962f8cfd66e5857e92302d68c2427f5a', './templates/blog_actions.tpl', '24.9', 0),
('6893cf89ffa784acffbde86b97ba3417', './templates/blog_heading.tpl', '24.9', 0),
('ba24ec700b608f2d825306028a7bbd9f', './templates/blog_post_actions.tpl', '24.9', 0),
('73c24b4d31e940820bb34a3334b8e61b', './templates/blog_post_author_info.tpl', '24.9', 0),
('0ffeeb8365a38299880abea0e260de01', './templates/blog_post_heading.tpl', '24.9', 0),
('2e7275c52d762d4f9384d3b36f0f763f', './templates/blog_post_navigation.tpl', '24.9', 0),
('310c7c35aa0d8560d994454b4341e0f9', './templates/blog_post_postbody_content.tpl', '24.9', 0),
('92311ee2685b3d8ededa6e5fdc625fca', './templates/blog_post_postbody_title.tpl', '24.9', 0),
('d851bfd15262aba7e46663df5976efba', './templates/blog_post_related_content.tpl', '24.9', 0),
('7d3102330b119fc55c60add9f974189b', './templates/blog_post_status.tpl', '24.9', 0),
('20804d37760360b9f9c948f585abe83c', './templates/blog_wrapper.tpl', '24.9', 0),
('42fa852d4d5b73224bff1737456593fe', './templates/bootstrap_menu.tpl', '24.9', 0),
('2bbcc92425daad05f041ba2bc8b8eeac', './templates/bootstrap_smartmenu.tpl', '24.9', 0),
('9c4e6aabcfae4e934828eda12edf31b9', './templates/bootstrap_smartmenu_children.tpl', '24.9', 0),
('6eaf5a8b8b1f4bb8d11123ab1e653f18', './templates/bootstrap_smartmenu_megamenu_children.tpl', '24.9', 0),
('372279a581b6f70804fc372e8f039c54', './templates/browse_file_gallery.tpl', '24.9', 0),
('3517f3ad069aa56cf54649907f186aa6', './templates/browsedcategory.tpl', '24.9', 0),
('090d3eeabd21392406aa62a2b4097296', './templates/calendar.tpl', '24.9', 0),
('88fa49cba650675143e16c03379f8441', './templates/canonical.tpl', '24.9', 0),
('87230e1d358d379f67269f1838ffdf62', './templates/categobjects.tpl', '24.9', 0),
('0ed9d9e33fb56ff6da310a814f74a55d', './templates/categobjects_title.tpl', '24.9', 0),
('628aab619de35e1c0a10e1551b0b6054', './templates/categorize.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/category/index.php', '24.9', 0),
('a39eb70d011a2c91c8180c7c21a335f5', './templates/category/select.tpl', '24.9', 0),
('b36cd5f7c7db4ece103b8621b87b6b1c', './templates/category_related_objects.tpl', '24.9', 0),
('4cbf69169506607413d885cf46324310', './templates/category_tree_entry.tpl', '24.9', 0),
('ffab08a1d83d880e73e1dcb1d2ad950d', './templates/categpath.tpl', '24.9', 0),
('d0e155ecd6cbca20ee1eb35d12143ab9', './templates/comment-body.tpl', '24.9', 0),
('0bb8972755cfbf046e14c51c1c0b2964', './templates/comment-footer.tpl', '24.9', 0),
('7119be0529b6bb38321e315ece28c673', './templates/comment-header.tpl', '24.9', 0),
('ab56df28a25a894cc58a695ee9f896f0', './templates/comment.tpl', '24.9', 0),
('1bb2edc271101df93881ea74060eb8b8', './templates/comment/archive.tpl', '24.9', 0),
('218b908a1fc595cddaecc59304e0f70c', './templates/comment/deliberation_item.tpl', '24.9', 0),
('e89b6ac53e9f1bbdb74f3de76cd473f5', './templates/comment/edit.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/comment/index.php', '24.9', 0),
('2319813f8baa66ea0b7bd98550d7e448', './templates/comment/list.tpl', '24.9', 0),
('6afa0c45f3ee669b62120276a551a6e4', './templates/comment/list_inner.tpl', '24.9', 0),
('e0e8b60030d68de5e250f12d26b0d97d', './templates/comment/lock.tpl', '24.9', 0),
('eb30e7168fd2b42bbe757b7932d0b645', './templates/comment/moderate.tpl', '24.9', 0),
('1340554f101fb31db4c10b823751429d', './templates/comment/post.tpl', '24.9', 0),
('8f790c338c34e2278334dde3980c5f1a', './templates/comment/remove.tpl', '24.9', 0),
('4a9d11b670a6a47bf352e9f90f207828', './templates/comment/unlock.tpl', '24.9', 0),
('7506fe3b42b021a200afd108869dc007', './templates/comments.tpl', '24.9', 0),
('098da1591e18740f3b741555438567e0', './templates/comments_button.tpl', '24.9', 0),
('14899adfac3d22b9a5861abbc033289e', './templates/confirm.tpl', '24.9', 0),
('0cc8b2d46c69c51eb6f30b0d6b62984a', './templates/contribution.tpl', '24.9', 0),
('05e438fba8ae981e7e8e873b071271be', './templates/cookie_consent.tpl', '24.9', 0),
('f198bfd6e1ebbabd8fa0b5f92daa06b9', './templates/copyrights.tpl', '24.9', 0),
('cd1487635fa62ce3b629d6a63de52fe0', './templates/credits.tpl', '24.9', 0),
('1dc945dde934a1faee08b8dc876e1936', './templates/currency_output.tpl', '24.9', 0),
('08707f1aef587ee6f8dadee17eb96e63', './templates/customroute/remove.tpl', '24.9', 0),
('b21c0dfb5d3509fdba237b53c8069051', './templates/database-connection-error.tpl', '24.9', 0),
('36ae9c3278c6acb0fd39b4c731cb67b5', './templates/debug/function.debugger.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/debug/index.php', '24.9', 0),
('f3fa06c59a927c847ad1960e431c15b5', './templates/debug/tiki-debug_console_help.tpl', '24.9', 0),
('7878209f33d441cdc23df021fa6aca45', './templates/debug/tiki-debug_console_tab.tpl', '24.9', 0),
('ec96ac488b6b0428157a31a9aa8566ff', './templates/debug/tiki-debug_dmsg_tab.tpl', '24.9', 0),
('3e1ae4f1b8b16764291ff79b25059bd8', './templates/debug/tiki-debug_features.tpl', '24.9', 0),
('40cc5a39aefa61db9923e9b984dba23e', './templates/debug/tiki-debug_permissions.tpl', '24.9', 0),
('05b3e1299834ac94bd2d6173a3ca12c4', './templates/debug/tiki-debug_tikitables.tpl', '24.9', 0),
('959507f3df9af046c7a62c4f5e31142e', './templates/debug/tiki-debug_watch_tab.tpl', '24.9', 0),
('94b87716e933e97a372d07f11be86617', './templates/discussinforum.tpl', '24.9', 0),
('681d96ade1e492de23acef4c8c9ff5ae', './templates/draw/edit.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/draw/index.php', '24.9', 0),
('5253153daa1a6721d8b143e93aa3f282', './templates/duplicate_file_gallery.tpl', '24.9', 0),
('c1f165c7ff7b47ceff53ac4100e55aeb', './templates/edit/help.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/edit/index.php', '24.9', 0),
('9e606bc9c6509e4b4b293fe86e38f39e', './templates/edit/inline_dialog.tpl', '24.9', 0),
('32f03b28ca7cac06e1df09c09c61df91', './templates/edit/preview.tpl', '24.9', 0),
('5e2e6ae62c29e158afcdbb2fe64d8d52', './templates/edit_file_gallery.tpl', '24.9', 0),
('ebcec2483ed7ee944da8c96fb74b0924', './templates/empty.tpl', '24.9', 0),
('6f9f4931485299280d03ead79ff0d2bd', './templates/encryption/enter_key.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/encryption/index.php', '24.9', 0),
('04afed5d162bf305cd7eb32fa3e2b2e4', './templates/error-ajax.tpl', '24.9', 0),
('d891ebdd8833820fcf5524521c07deb8', './templates/error.tpl', '24.9', 0),
('6973217c83a84faf197f5f8767518b71', './templates/error_raw.tpl', '24.9', 0),
('bbea0934d26b63e490e91320e260e029', './templates/error_simple.tpl', '24.9', 0),
('70524df64466da5bbeceda2c9479a418', './templates/error_ticket.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/examples/index.php', '24.9', 0),
('786c43c7df621fd8a0f99a100bece9a5', './templates/examples/search/facet_charts.tpl', '24.9', 0),
('1db967e178706b45e8395221d2c1e87b', './templates/examples/search/facet_charts2.tpl', '24.9', 0),
('72e0544edeaf03a4370a9c24511cc802', './templates/examples/search/facet_checkboxes.tpl', '24.9', 0),
('07631e8ae8b82b05cc8470d77d816daa', './templates/examples/search/h5p.tpl', '24.9', 0),
('7e19d3f1352f5cba5683e86907a77935', './templates/examples/search/simple_table.tpl', '24.9', 0),
('622c674f4b7c687fa63880232dc58f73', './templates/examples/shop/add_to_cart.tpl', '24.9', 0),
('6b8038a66e2ac6242af58ad50c872890', './templates/examples/shop/custom_search_form.tpl', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './templates/examples/shop/index.php', '24.9', 0),
('5ade29ec5b7c45d531379d23031bf847', './templates/examples/shop/product_ajax.tpl', '24.9', 0),
('011548e488a4969dec5d409ffdc8b711', './templates/examples/shop/product_item.tpl', '24.9', 0),
('3cea5f4a3a65ff14803d605b7255024d', './templates/examples/shop/product_list.tpl', '24.9', 0),
('a25c178d909f25fd55394609e10ab03a', './templates/examples/shop/product_list_inner.tpl', '24.9', 0),
('c0b4bb5cbf7dd0f52d8b7dd94a748cba', './templates/feedback/action.tpl', '24.9', 0),
('0f714122c7d2959ab955861cef0690b2', './templates/feedback/default.tpl', '24.9', 0),
('fd05a33fa16ea448c9d98510c1f6b5e1', './templates/feedback/link.tpl', '24.9', 0),
('71afd0a5ccda384548e12e8a41e1e9e6', './templates/feedback/perm.tpl', '24.9', 0),
('4447c8e631ae2d4f3ab8c3e623a62a7d', './templates/feedback/pref.tpl', '24.9', 0),
('9b921781cfd294eb8b4343b87dcac738', './templates/fgal_attachments.tpl', '24.9', 0),
('1619d77e327a2eec02eb01e9266b4b0f', './templates/fgal_context_menu.tpl', '24.9', 0),
('55b495137924fe214652def3605c1bc3', './templates/fgal_file_link_attributes.tpl', '24.9', 0),
('03ceba859bd575de0d61f17079bdf444', './templates/fgal_listing_conf.tpl', '24.9', 0),
('645c6b5d4662f69818fea39d569c7e35', './templates/fgal_thumbnailframe.tpl', '24.9', 0),
('2d20f36e5d2b2543bb0f248fd8906495', './templates/fgal_view_page.tpl', '24.9', 0),
('b483656891c26c5e568deddda7f78ac3', './templates/file/browse.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/file/index.php', '24.9', 0),
('5c759228b53d0a3bbf3ddfcad15ed4ee', './templates/file/jquery_upload.tpl', '24.9', 0),
('d7c6dedfd1dc853f2e2971c71043fcf6', './templates/file/list_gallery.tpl', '24.9', 0),
('ce732d6e0c7708d994834bcbacf184bf', './templates/file/remote.tpl', '24.9', 0),
('e8f17f517b6019da9b7ecb18afab1077', './templates/file/thumbnail_gallery.tpl', '24.9', 0),
('b2fe6f54056a3af90b7c5a8cab976d80', './templates/file/upload.tpl', '24.9', 0),
('53b3e32206a3d9c34abafcb6bfaa3708', './templates/file/uploader.tpl', '24.9', 0),
('ae18a0ae2bcc4a20139b522e7ef84963', './templates/file_backlinks.tpl', '24.9', 0),
('1f8bed9f721544fcd9c1d079514796d9', './templates/file_displays/diagram.tpl', '24.9', 0),
('5ca921cabc7d390e2482003487063ec1', './templates/file_displays/pdf.tpl', '24.9', 0),
('c687697acec9d5f02a0b74595534b42a', './templates/file_gallery_slideshow.tpl', '24.9', 0),
('c090624f13e9788f1d58e4753bc11068', './templates/file_properties_table.tpl', '24.9', 0),
('f248eb107c5efc770302b5bb37f0c229', './templates/file_selector.tpl', '24.9', 0),
('94b301a93b264f70f30d0f6784bd0486', './templates/filter.tpl', '24.9', 0),
('3f964bc395a546a2a2bdfbaf40d88a44', './templates/filter_control/currency_range.tpl', '24.9', 0),
('f74a8c454589768c29fa1c627a233550', './templates/filter_control/date_range.tpl', '24.9', 0),
('5b55b3ee9ec71ab6601558a54add6f8e', './templates/filter_control/drop_down.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/filter_control/index.php', '24.9', 0),
('b447f87f95d78e713fa343d7b6a5d640', './templates/filter_control/inline_checkboxes.tpl', '24.9', 0),
('35ee3c71591583076de48182975ae289', './templates/filter_control/multi_select.tpl', '24.9', 0),
('38f18c66e542ab4ade737d63458a0a2a', './templates/filter_control/numeric_range.tpl', '24.9', 0),
('57fa26807cfee5f38171acf843b24620', './templates/filter_control/text_field.tpl', '24.9', 0),
('9277c38a29ab9c6ddb445a3255fd30a1', './templates/find.tpl', '24.9', 0),
('6a928e02847f8545821688144db7a545', './templates/footer.tpl', '24.9', 0),
('7e05c36aee0d82cb2a2da93bf8cf765c', './templates/freetag.tpl', '24.9', 0),
('09aca89f7a890e9441ced29e9fdf207f', './templates/freetag_list.tpl', '24.9', 0),
('24702977e2bba859ac9f407c7c6b0497', './templates/goal/admin.tpl', '24.9', 0),
('312d0fd5c73cc6b8b04c0ca6c80719a6', './templates/goal/create.tpl', '24.9', 0),
('9d7fcdcb9d111b1333ad148d10582b69', './templates/goal/delete.tpl', '24.9', 0),
('99ebcff2e918c48d4c68c98515f46dee', './templates/goal/edit.tpl', '24.9', 0),
('8cbe10adcbfdf070ca793c2c30e2618f', './templates/goal/edit_condition.tpl', '24.9', 0),
('86a80f49e4dbdbaa3ea5a6da7f4b54c3', './templates/goal/edit_eligible.tpl', '24.9', 0),
('cf94efac2c3df5020da3f43383f3aaa9', './templates/goal/edit_reward.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/goal/index.php', '24.9', 0),
('94b2530de15d37b0b8c6d57d74753704', './templates/goal/render_conditions.tpl', '24.9', 0),
('592a34f2fa12e57cea77050975a916f3', './templates/goal/render_rewards.tpl', '24.9', 0),
('347dcf6d9cf93e9355752256455abfc6', './templates/goal/show.tpl', '24.9', 0),
('1650faab52ce6b7781e6ad6cb4b0b68d', './templates/goal/show_list.tpl', '24.9', 0),
('fd5e33260656edeec478fc0afeee4c23', './templates/h5p/edit.tpl', '24.9', 0),
('3cd4b6650a4a4ba0d89ad0bc9a50d1b4', './templates/h5p/embed.tpl', '24.9', 0),
('834cd205aab71eb813dfc4eb02128278', './templates/h5p/list_libraries.tpl', '24.9', 0),
('513c0d7f07dda1758896420c84abe601', './templates/h5p/list_results.tpl', '24.9', 0),
('78810786dc13df8cf01f38c82544aea4', './templates/header.tpl', '24.9', 0),
('d9ee711c1ae48677c22d140830945e13', './templates/iconpickermodal.tpl', '24.9', 0),
('4988d4dab8d8fc03d32e746e43d33698', './templates/ids/remove.tpl', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './templates/index.php', '24.9', 0),
('bb7608e4354db19e2643c1a600f22cd5', './templates/interactive_translation_box.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/kaltura/index.php', '24.9', 0),
('05b4252bd30580d2eed01c8991643ed5', './templates/kaltura/list.tpl', '24.9', 0),
('b7be77cc8a1f570711359737d79478f1', './templates/kaltura/upload.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/language/index.php', '24.9', 0),
('c7aed224247693108e472acc3fbef4ba', './templates/language/manage_custom_translations.tpl', '24.9', 0),
('72cfa42b335665825d0ce503d1a64732', './templates/language/upload.tpl', '24.9', 0),
('fe5144dde9dc58300921714274b342a7', './templates/language/write_to_language_php.tpl', '24.9', 0),
('8dc32cfd39f6dbd61418710503c6f09b', './templates/layout_fullscreen_check.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/layouts/basic/index.php', '24.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/basic/layout_edit.tpl', '24.9', 0),
('eef204c0b658a518e0f97f163e77840e', './templates/layouts/basic/layout_view.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/layouts/classic/index.php', '24.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/classic/layout_edit.tpl', '24.9', 0),
('ed478fc5997052a3c4354d88ec35bc19', './templates/layouts/classic/layout_view.tpl', '24.9', 0),
('3508e1874c35cef8863cd331972a87fd', './templates/layouts/classic/module.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/layouts/index.php', '24.9', 0),
('3f3b332bb0b4a80f3027a2c620488d0d', './templates/layouts/internal/ajax.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/layouts/internal/index.php', '24.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/internal/layout_edit.tpl', '24.9', 0),
('f010e49d64fa115a23c20e8b761fb589', './templates/layouts/internal/layout_view.tpl', '24.9', 0),
('b095bbc005892590b04d92530512ec00', './templates/layouts/internal/modal.tpl', '24.9', 0),
('d48c9f5b44d5b5f77bb51e5f4e27ef17', './templates/layouts/layout_plain.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/layouts/social/index.php', '24.9', 0),
('0e7ecb136d1887e4d6866b473a58fa2a', './templates/layouts/social/layout_edit.tpl', '24.9', 0),
('46f50eda62938bea0a58f485f8b18c55', './templates/layouts/social/layout_view.tpl', '24.9', 0),
('6e55da01b6e97d271d25609a23019d38', './templates/like.tpl', '24.9', 0),
('a8b3b9036e12de3eb5d5a1c0d729285f', './templates/list_file_gallery.tpl', '24.9', 0),
('5401e2fc187a0003b220176295c0702a', './templates/list_file_gallery_content.tpl', '24.9', 0),
('eeb0eca74fa5e60fbf6cbe52b58cbd7b', './templates/lists/article-search.tpl', '24.9', 0),
('c048e0fe5b840cceb84cfa14622f4123', './templates/lists/articles.tpl', '24.9', 0),
('ba8b6bc7cb6ffbfab052463e536a7cf1', './templates/mail/account_lock_status_update.tpl', '24.9', 0),
('6b6bf54ffafcd489b6b67c2b2bd3c894', './templates/mail/account_lock_status_update_subject.tpl', '24.9', 0),
('52f7c23b70d0cc88600e431559f7bcb5', './templates/mail/admin_tiki_checker.tpl', '24.9', 0),
('81c40b3b68ccfe7c27753e3023d3d666', './templates/mail/admin_tiki_checker_subject.tpl', '24.9', 0),
('f0754858f3cd08f7a43b966c6e5dfb77', './templates/mail/blogs_send_link.tpl', '24.9', 0),
('ca08d8d64a8348eee11fc2d64a895e10', './templates/mail/cart_order_received_anon.tpl', '24.9', 0),
('923db1b975a962ece0ce61b0d214bb79', './templates/mail/cart_order_received_anon_subject.tpl', '24.9', 0),
('811f08e98a17d840eb99e47b803c11c7', './templates/mail/cart_order_received_reg.tpl', '24.9', 0),
('923db1b975a962ece0ce61b0d214bb79', './templates/mail/cart_order_received_reg_subject.tpl', '24.9', 0),
('a9068cd2387f14a9cc0b7b38e8e4d37b', './templates/mail/confirm_newsletter_subscription.tpl', '24.9', 0),
('31510f9c8ac82b8d0281f6b1918839a2', './templates/mail/confirm_user_email.tpl', '24.9', 0),
('99db3121afa868d56bb51e8990d391fb', './templates/mail/confirm_user_email_after_approval.tpl', '24.9', 0),
('c14036a9f627fe83b2773e96f990765d', './templates/mail/confirm_user_email_after_approval_subject.tpl', '24.9', 0),
('aceeccf9e36362cf7fbff48301908139', './templates/mail/confirm_user_email_subject.tpl', '24.9', 0),
('30171ab9e9bc2fce76b7e3169097b629', './templates/mail/fgal_old_file_deleted.tpl', '24.9', 0),
('dd21bb7eb77f3273b8552398aa8665bb', './templates/mail/fgal_quota_exceeded.tpl', '24.9', 0),
('230cec9ff3427cfd61c92dbb1459b070', './templates/mail/forum_outbound.tpl', '24.9', 0),
('4d56609ab3e758883f08ec510ab600e1', './templates/mail/forum_post_notification.tpl', '24.9', 0),
('3bbc2abb5d26cca5a07d23561fd9ab36', './templates/mail/forum_post_queued_notification.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/mail/index.php', '24.9', 0),
('f7265822802cab7cfd18a8d77def039e', './templates/mail/invite_tempuser.tpl', '24.9', 0),
('38f029db22b43d145d7eae800343c65a', './templates/mail/invite_tempuser_subject.tpl', '24.9', 0),
('d8b88a05c1cd10233424a792b1fa29fc', './templates/mail/mail_invite.tpl', '24.9', 0),
('c031b6c7c19396f8918b9b1b1ef80230', './templates/mail/mail_invite_subject.tpl', '24.9', 0),
('514189f50ec9119d2e435383a7114206', './templates/mail/mailin_reply_subject.tpl', '24.9', 0),
('6d157f3a83bd479778cb40b18fe1fc2a', './templates/mail/mention_notification.tpl', '24.9', 0),
('0d3f14e6547edd89e2f4fc14e3232d83', './templates/mail/mention_notification_subject.tpl', '24.9', 0),
('56ea3c3f98aad7f9c7e09ef2b1e15539', './templates/mail/messu_message_notification.tpl', '24.9', 0),
('248739d35b542a1e06ccae50165f0268', './templates/mail/messu_message_notification_subject.tpl', '24.9', 0),
('2d34c2e9d0d6060322581007c0441060', './templates/mail/moderate_activation_mail.tpl', '24.9', 0),
('3477f02776a3de5e680957f7b47a1420', './templates/mail/moderate_activation_mail_subject.tpl', '24.9', 0),
('9f69ea7a7deb36aabe5fe53bc1489088', './templates/mail/moderate_validation_mail.tpl', '24.9', 0),
('b0e8d001b1fcc0474b6cec0579ea57e9', './templates/mail/moderate_validation_mail_subject.tpl', '24.9', 0),
('8608794fb76b2816889ba81238ebe571', './templates/mail/new_friend_invitation.tpl', '24.9', 0),
('ce654bd70fd229f230a2d4212d58c645', './templates/mail/new_friend_invitation_subject.tpl', '24.9', 0),
('41b7092f011eff682e3fe88b8e54c40a', './templates/mail/new_user_notification.tpl', '24.9', 0),
('2006f3db2c56fc0582059bd9829a09be', './templates/mail/new_user_notification_subject.tpl', '24.9', 0),
('fee2e61f0c3617050605a22a56bfcbb0', './templates/mail/newsletter_articleclip.tpl', '24.9', 0),
('a761b0f8202a269f99e7e3cab4e3c874', './templates/mail/newsletter_byebye.tpl', '24.9', 0),
('7a0c74a53ea8306a76c83e9c59d2822f', './templates/mail/newsletter_byebye_subject.tpl', '24.9', 0),
('a92eba8387aca59a2b08d5d3d6a6082f', './templates/mail/newsletter_unsubscribe.tpl', '24.9', 0),
('0be6f46d30b816d1e2dde6021a567b3e', './templates/mail/newsletter_welcome.tpl', '24.9', 0),
('45d5341b18fafa14b57c5d7475c4337d', './templates/mail/newsletter_welcome_subject.tpl', '24.9', 0),
('3207806f8c37da520b4f03565c964dd2', './templates/mail/notification_subject.tpl', '24.9', 0),
('25f08d21f055ab82272e31f561d766fa', './templates/mail/password_reminder.tpl', '24.9', 0),
('d146f22b28606205a9d327db132a8af9', './templates/mail/password_reminder_subject.tpl', '24.9', 0),
('42e8e2e8d135218488ce76a571c4e830', './templates/mail/plugin_pending_notification.tpl', '24.9', 0),
('c786cdfe811a8ef1340c7c19a8d65665', './templates/mail/report.tpl', '24.9', 0),
('0864ce5dfb7048cb98f6222481a29cf2', './templates/mail/rss_new_source_category.tpl', '24.9', 0),
('bd753b8fc6e836ca2e5b3d3dd0f2c248', './templates/mail/rss_new_source_category_subject.tpl', '24.9', 0),
('2a694213a4114d1e8285cd3b8470e540', './templates/mail/scheduler_healed_notification.tpl', '24.9', 0),
('d62736398c741e6d7de5412b728c3108', './templates/mail/scheduler_healed_notification_subject.tpl', '24.9', 0),
('0f25f9a7cf4e2c2d8609ff1a91af6e78', './templates/mail/scheduler_stalled_notification.tpl', '24.9', 0),
('e2140feafae6e201198155619906b571', './templates/mail/scheduler_stalled_notification_subject.tpl', '24.9', 0),
('154ee4eb082dd598ef26abd754e1b42a', './templates/mail/share.tpl', '24.9', 0),
('be5be7c37715f044e7ffe7126a4ab786', './templates/mail/share_subject.tpl', '24.9', 0),
('21228244deb0877ed3eb8318fd4d7c23', './templates/mail/submission_notification.tpl', '24.9', 0),
('a0ff13f814058b348f07844f21a7159e', './templates/mail/submission_notification_subject.tpl', '24.9', 0),
('d6b63bf4f887c8f1b3f47ff0a33da382', './templates/mail/tracker_changed_notification.tpl', '24.9', 0),
('6000fe5daf7e9afde78623ac8900dd08', './templates/mail/tracker_changed_notification_subject.tpl', '24.9', 0),
('28a103f2869488eae2a358676649041d', './templates/mail/unsuccessful_logins.tpl', '24.9', 0),
('a9a61b6f0827bf017da24112c0c445c2', './templates/mail/unsuccessful_logins_subject.tpl', '24.9', 0),
('7800ee421095735265c817e05c693309', './templates/mail/unsuccessful_logins_suspend.tpl', '24.9', 0),
('13be7631f7911f3fc1ef5ad3e68bd264', './templates/mail/unsuccessful_logins_suspend_subject.tpl', '24.9', 0),
('7cc7478596469ed0221b0bc130c01346', './templates/mail/user_creation_validation_mail.tpl', '24.9', 0),
('d444754a9f68a14e97ade4304129c94a', './templates/mail/user_creation_validation_mail_subject.tpl', '24.9', 0),
('c885a96e22575b0c4c2f25faac99c369', './templates/mail/user_joins_group_notification.tpl', '24.9', 0),
('abbdaebb153b973b1bb3de7dedd97e1a', './templates/mail/user_joins_group_notification_subject.tpl', '24.9', 0),
('f4a2b893939370cda573d714a77b5a83', './templates/mail/user_validation_mail.tpl', '24.9', 0),
('81eb2b053ecdc79c18957764eb1a968a', './templates/mail/user_validation_mail_subject.tpl', '24.9', 0),
('a50d583049e0457928c0846ef7f974a7', './templates/mail/user_validation_msg.tpl', '24.9', 0),
('ea3f0408f4c83709d73f949087844bb4', './templates/mail/user_validation_waiting_msg.tpl', '24.9', 0),
('f42b9a45b76eb44a9aa2f22f2cf74ee6', './templates/mail/user_watch_article_post.tpl', '24.9', 0),
('8a7802361a04682330421ec3878a9978', './templates/mail/user_watch_article_post_subject.tpl', '24.9', 0),
('e3169ce44490a833269883ef44b4e008', './templates/mail/user_watch_blog_post.tpl', '24.9', 0),
('4696501bec230fa149153cd7e7dfb181', './templates/mail/user_watch_blog_post_subject.tpl', '24.9', 0),
('3ab9644f96bd7968e9132a6e689c36f6', './templates/mail/user_watch_calendar.tpl', '24.9', 0),
('76901b0053bcfe80d1b3aea1abe6efbc', './templates/mail/user_watch_calendar_subject.tpl', '24.9', 0),
('c54004694787e9e8f3462aa36f899991', './templates/mail/user_watch_category_changed_subject.tpl', '24.9', 0),
('3e745558bf04b6274a8f29cc81f34d97', './templates/mail/user_watch_category_created.tpl', '24.9', 0),
('42f64260bfab0d37929f301add618fa2', './templates/mail/user_watch_category_created_subject.tpl', '24.9', 0),
('05cec4ce3483c89da40bff3459eedf65', './templates/mail/user_watch_category_removed.tpl', '24.9', 0),
('23eecb2fd91fd0efb986600b1728a7a4', './templates/mail/user_watch_category_removed_subject.tpl', '24.9', 0),
('a6b6a7f590d3fdec2c59e9430d98d169', './templates/mail/user_watch_category_updated.tpl', '24.9', 0),
('c6c8630cbe867f88df46a87e1d7c694a', './templates/mail/user_watch_category_updated_subject.tpl', '24.9', 0),
('f0639871223dd2b303280f2dadda6698', './templates/mail/user_watch_comment.tpl', '24.9', 0),
('a836c45b1cd4876322bb321475fd693e', './templates/mail/user_watch_comment_subject.tpl', '24.9', 0),
('94a50137b1e452867973908c93a36414', './templates/mail/user_watch_file_gallery_changed_subject.tpl', '24.9', 0),
('3fd668d8e81d8cac2651dff7eee3b460', './templates/mail/user_watch_file_gallery_remove_file.tpl', '24.9', 0),
('02b07ecb6a09be90e53b33f5e6138b5b', './templates/mail/user_watch_file_gallery_upload.tpl', '24.9', 0),
('8a0de65208ee550eb2ee537851666f85', './templates/mail/user_watch_forum_queued_subject.tpl', '24.9', 0),
('e28e19193e968fded4c77d96362212dc', './templates/mail/user_watch_forum_subject.tpl', '24.9', 0),
('93783f0afe08b296fd7ec62a1232e598', './templates/mail/user_watch_image_gallery_changed_subject.tpl', '24.9', 0),
('39e3954add897f75327a2481d62135d3', './templates/mail/user_watch_image_gallery_upload.tpl', '24.9', 0),
('9e84109f5129ecc1db8efd7f5e879cae', './templates/mail/user_watch_map_changed.tpl', '24.9', 0),
('beb56906d6da2fa9f5ed9f06c37bbade', './templates/mail/user_watch_object_entered_category.tpl', '24.9', 0),
('4b40f1de20bd2cd20c19cf928011eb96', './templates/mail/user_watch_object_entered_category_subject.tpl', '24.9', 0),
('00a2dd8e1bc26a4bbac27c316dc697fd', './templates/mail/user_watch_object_leaved_category.tpl', '24.9', 0),
('fb15290b96240ac8e589b828325b9691', './templates/mail/user_watch_object_leaved_category_subject.tpl', '24.9', 0),
('4b5cf3e4229346a95cde910ef9d47171', './templates/mail/user_watch_structure.tpl', '24.9', 0),
('02b28c0b025e3d52142ce541d2c5cb8e', './templates/mail/user_watch_structure_subject.tpl', '24.9', 0),
('b36123cdec3ba1859e6e104dcd32a99a', './templates/mail/user_watch_token.tpl', '24.9', 0),
('c9c51ef510b7cc1ebc7c67739cce1a2e', './templates/mail/user_watch_wiki_new_attach.tpl', '24.9', 0),
('5af8f40a3b5cde62661ff1cd637ea503', './templates/mail/user_watch_wiki_new_attach_subject.tpl', '24.9', 0),
('b66901abeb41e577a597b746f2455e8a', './templates/mail/user_watch_wiki_page_changed.tpl', '24.9', 0),
('3aa37c3754f91721d31986c50fe58650', './templates/mail/user_watch_wiki_page_changed_subject.tpl', '24.9', 0),
('126a9c0b7944fbb72a673aa6b6a312c6', './templates/mail/user_watch_wiki_page_renamed.tpl', '24.9', 0),
('78e83e70f5504bf2fe9144251f8fd1e9', './templates/mail/user_watch_wiki_page_renamed_subject.tpl', '24.9', 0),
('45b12c9416660c18154b261558217c2c', './templates/mail/user_welcome_msg.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/mailin/index.php', '24.9', 0),
('cae808048e7627b7642228b5f1efdcb8', './templates/mailin/remove_account.tpl', '24.9', 0),
('9fb0317d9968af49de022ce70c05eb17', './templates/mailin/replace_account.tpl', '24.9', 0),
('fbc4ba1d7a8fb36054f79091f24dde63', './templates/managestream/advanced.tpl', '24.9', 0),
('2959674c5047909b1d1f8313fcae3698', './templates/managestream/change_rule_status.tpl', '24.9', 0),
('153a1b53d9622c73e0019e58e1d432a7', './templates/managestream/change_rule_type.tpl', '24.9', 0),
('5129c656f4954486dbfcac31068d120b', './templates/managestream/delete.tpl', '24.9', 0),
('1eaebf6d822334385232eb346eff02ae', './templates/managestream/deleteactivity.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/managestream/index.php', '24.9', 0),
('4bf84d6bf8dae9520a32e974bd6087ee', './templates/managestream/list.tpl', '24.9', 0),
('14537a56cbb032e1718b4a0fa122a532', './templates/managestream/record.tpl', '24.9', 0),
('25cb888d98e287a7b1ab3729b2a65008', './templates/managestream/sample.tpl', '24.9', 0),
('aa93b65de1aef1579324abe788627c4d', './templates/managestream/tracker_filter.tpl', '24.9', 0),
('9ee3edaba6d8ca823d6e610a7d36964a', './templates/menu/clone.tpl', '24.9', 0),
('02d975ad0fc9ef53d7516fb69f4023fa', './templates/menu/edit.tpl', '24.9', 0),
('a2bf306cdd6f6d1c3f48151d452f7f6d', './templates/menu/edit_option.tpl', '24.9', 0),
('a7d16ba78b7c015e9551828b049a3787', './templates/menu/export_menu_options.tpl', '24.9', 0),
('7c2596820f94805aca9a354009250c89', './templates/menu/import_menu_options.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/menu/index.php', '24.9', 0),
('c0829c65a523b6cfc69f54a8d0af6a6e', './templates/menu/preview.tpl', '24.9', 0),
('e2949ed6277f97f2627f654ae62f24f5', './templates/menu/quicklinks.tpl', '24.9', 0),
('c0caa941f86215520f6d3b19b0e0e368', './templates/messu-archive.tpl', '24.9', 0),
('b27ba4e96957476dc9a0da29f276b6e4', './templates/messu-broadcast.tpl', '24.9', 0),
('dfd674aa52c86c6881d4713b2622594a', './templates/messu-compose.tpl', '24.9', 0),
('a3d56285e9945fc1a272174f399698e5', './templates/messu-download.tpl', '24.9', 0),
('4523d537df5ed938517cabc9cc4195e3', './templates/messu-mailbox.tpl', '24.9', 0),
('1e51016348c68eba903f811dda5ba27b', './templates/messu-nav.tpl', '24.9', 0),
('90cd7ac498f5227e45e7a44a42339d19', './templates/messu-read.tpl', '24.9', 0),
('fb093bf3fdaa7c4e36482584d3eefe7e', './templates/messu-read_archive.tpl', '24.9', 0),
('fc057d2ed451d15f75c1b8f4cae17db0', './templates/messu-read_sent.tpl', '24.9', 0),
('a82c15fb57bbe447fb8ef990e203fada', './templates/messu-sent.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/metadata/index.php', '24.9', 0),
('c185a35d22c89ad9413a27c2c3626218', './templates/metadata/meta_view_dialog.tpl', '24.9', 0),
('fde57c9c8a904bf95210ca329007d0e8', './templates/metadata/meta_view_tabs.tpl', '24.9', 0),
('c9894daf5eeb8a2a9ca94cabc0e59f25', './templates/ml/clone.tpl', '24.9', 0),
('10ca10bfce7afac5670fe3d3948961f6', './templates/ml/create.tpl', '24.9', 0),
('e1bb4d0dd4c5ef79c8e62f2ee166bdd0', './templates/ml/delete.tpl', '24.9', 0),
('2c7d0b8c4d7596eb7408a6df9b427db5', './templates/ml/edit.tpl', '24.9', 0),
('fdd3a33a927b6c55b8a2e0e96e61b1bf', './templates/ml/list.tpl', '24.9', 0),
('041a8f0d863afddc28b146a64a03d8c5', './templates/ml/model_args.tpl', '24.9', 0),
('6b1e669c5c69ab8f18d86fce9ae61c3b', './templates/ml/use.tpl', '24.9', 0),
('51ecdb38ae2dd43ba61678a5e42f0dc8', './templates/module.tpl', '24.9', 0),
('cf2a585b380575feeb10aafe003e3bc5', './templates/module/execute.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/module/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/modules/index.php', '24.9', 0),
('79075c2fb9c6fee700fa49d975c7382c', './templates/modules/mod-action_calendar.tpl', '24.9', 0),
('6c2aff25f579aeb9a608e667b9502833', './templates/modules/mod-action_similarcontent.tpl', '24.9', 0),
('75b216228720494a430a7a54dfa862fb', './templates/modules/mod-adminbar.tpl', '24.9', 0),
('bce834192ccc998f37ab26b239ad82dd', './templates/modules/mod-adsense.tpl', '24.9', 0),
('f721fb8ce6d16353d25f88b5143a9979', './templates/modules/mod-article_archives.tpl', '24.9', 0),
('6edb434df388d528c86f98cf6df2bde2', './templates/modules/mod-article_topics.tpl', '24.9', 0),
('5aff817c779c2bba79a34e36685a14c5', './templates/modules/mod-articles.tpl', '24.9', 0),
('a612bc3e4158ef8189eb42bddf2beba7', './templates/modules/mod-assistant.tpl', '24.9', 0),
('36493aec7c21ebe5fb358771e5fb7bba', './templates/modules/mod-blog_last_comments.tpl', '24.9', 0),
('e8ed4060b178f20faee4162e16cbee3f', './templates/modules/mod-breadcrumb.tpl', '24.9', 0),
('c3cf11db6a632d80ab1f9f2310772169', './templates/modules/mod-breadcrumbs.tpl', '24.9', 0),
('a3bcb07d293a3382c1cf193fd691bb72', './templates/modules/mod-calendar_new.tpl', '24.9', 0),
('4d5c3f7f885d3f8eb556a5bf25d0df22', './templates/modules/mod-cart.tpl', '24.9', 0),
('3b6c2cb7dd92ada6da5a5f4bd27985e4', './templates/modules/mod-categories.tpl', '24.9', 0),
('8ab89c25afda216e0a861bc1698b2b89', './templates/modules/mod-category_transition.tpl', '24.9', 0),
('bb13fc4462440f218c5d5089cfba8668', './templates/modules/mod-change_category.tpl', '24.9', 0),
('bd671400f62d2bd80d396b58c69731cf', './templates/modules/mod-collapse.tpl', '24.9', 0),
('66906582c2db580691f637da9e520cdd', './templates/modules/mod-comm_received_objects.tpl', '24.9', 0),
('adc60c759aafb66516043e7de6a62238', './templates/modules/mod-contributors.tpl', '24.9', 0),
('fc2b69214acc617b1e84a15dda26568e', './templates/modules/mod-cookiesettings.tpl', '24.9', 0),
('48423860b60847272c7c86a3dbb6433c', './templates/modules/mod-credits.tpl', '24.9', 0),
('70b01cf314dd3d129e22f1df1edc124d', './templates/modules/mod-current_activity.tpl', '24.9', 0),
('e87dc6dfd1735fd29f27d506ec4e4cce', './templates/modules/mod-directory_last_sites.tpl', '24.9', 0),
('1c4dcf9c198aa3ed1b5450043c3ef82e', './templates/modules/mod-directory_stats.tpl', '24.9', 0),
('e5b6082eee8f443d2522a4b79de2ba2e', './templates/modules/mod-directory_top_sites.tpl', '24.9', 0),
('06fb3e1da79914e57e423651872d48f8', './templates/modules/mod-domain_password.tpl', '24.9', 0),
('e0e1183ae2b4d9aceed45db805e21a83', './templates/modules/mod-facebook.tpl', '24.9', 0),
('624605455780b8d0f8fd64569beda167', './templates/modules/mod-featured_links.tpl', '24.9', 0),
('77d726286bf554bc8c89390f404f0184', './templates/modules/mod-file_galleries.tpl', '24.9', 0),
('a6eb20a539afe500d5d8621393518adc', './templates/modules/mod-forums_best_voted_topics.tpl', '24.9', 0),
('8d3e0e6ce5869d0b4e920a107ceae83c', './templates/modules/mod-forums_last_posts.tpl', '24.9', 0),
('ff9972cf979853521fce793a8dc6e6fa', './templates/modules/mod-forums_most_commented_forums.tpl', '24.9', 0),
('d6db4b128960cb318b2ee1d663c72555', './templates/modules/mod-forums_most_read_topics.tpl', '24.9', 0),
('4f7b9ad65a0cc10265a3608fbd472772', './templates/modules/mod-forums_most_visited_forums.tpl', '24.9', 0),
('2e0bb67326622f07039c0e0d3aa07ce7', './templates/modules/mod-freetag.tpl', '24.9', 0),
('d88447498e954bf6609f8c04cd39527f', './templates/modules/mod-freetags_current.tpl', '24.9', 0),
('36139db2bc6e2081c25ba89db6ce51fe', './templates/modules/mod-freetags_morelikethis.tpl', '24.9', 0),
('539d752f0e8e0af35187d79399d3baea', './templates/modules/mod-freetags_most_popular.tpl', '24.9', 0),
('f9dd4356b545687ed5713bccb87b6743', './templates/modules/mod-freetags_prefered.tpl', '24.9', 0),
('d23087826470bdc4698aa97c31de69b3', './templates/modules/mod-friend_list.tpl', '24.9', 0),
('79ce5369031d56452f55d35cc45a6d84', './templates/modules/mod-git_detail.tpl', '24.9', 0),
('3c2db72bb881c8d3b0aeda170b0d3e8e', './templates/modules/mod-google.tpl', '24.9', 0),
('e12fe4515c0b00f9575b4d2b79f15759', './templates/modules/mod-groups_emulation.tpl', '24.9', 0),
('ddd9d5f4a1315c6b3d9dd96bb7b9bc74', './templates/modules/mod-last_actions.tpl', '24.9', 0),
('7ba25ef2254bd17143768eaf8503b4c3', './templates/modules/mod-last_blog_posts.tpl', '24.9', 0),
('ec5819757f1c853f1ce174fb9123e117', './templates/modules/mod-last_category_objects.tpl', '24.9', 0),
('a0069113c23fd31204738d3ee8b669cb', './templates/modules/mod-last_created_blogs.tpl', '24.9', 0),
('6624dc9dab59aea3de209e9b2df36cc8', './templates/modules/mod-last_created_faqs.tpl', '24.9', 0),
('11702a9b889dee8f72e9d7d6da563f60', './templates/modules/mod-last_created_quizzes.tpl', '24.9', 0),
('a0b324e9086cc7f7be0c6ded33fcb56f', './templates/modules/mod-last_file_galleries.tpl', '24.9', 0),
('76da96f94170aa50686e8b40d3105f82', './templates/modules/mod-last_files.tpl', '24.9', 0),
('f9c55f2e17b6060b846acb37c4accd7f', './templates/modules/mod-last_modif_events.tpl', '24.9', 0),
('76e6062bc7e30fab45a6d17fbafa2009', './templates/modules/mod-last_modif_pages.tpl', '24.9', 0),
('7cd4b047578bc3d48493e088403f5997', './templates/modules/mod-last_modified_blogs.tpl', '24.9', 0),
('34650c5521e709d42b69c1b613a4c08a', './templates/modules/mod-last_podcasts.tpl', '24.9', 0),
('332076a9e6401b77454b2a3c07768f22', './templates/modules/mod-last_submissions.tpl', '24.9', 0),
('2f977d7b4181da861be8d8be4c31ae0f', './templates/modules/mod-last_tracker_comments.tpl', '24.9', 0),
('b042456618b89f6b65045a67192566d5', './templates/modules/mod-last_tracker_items.tpl', '24.9', 0),
('fce6c002eb31378ddcd99fb3a248d115', './templates/modules/mod-last_validated_faq_questions.tpl', '24.9', 0),
('ebacb95725c1d0fb1fbb9ef223bd9eba', './templates/modules/mod-last_visitors.tpl', '24.9', 0),
('c220c2aac4aba85970685f02aa89eb19', './templates/modules/mod-last_youtube_playlist_videos.tpl', '24.9', 0),
('7109358cdd6475d05f41dcbc8eaefec3', './templates/modules/mod-list.tpl', '24.9', 0),
('2e8bc23e8c194390d40876986ed63060', './templates/modules/mod-live_support.tpl', '24.9', 0),
('403fbdbc05ae0b5c59a84fcf970a9037', './templates/modules/mod-loadstats.tpl', '24.9', 0),
('309479ff2fc745cee027e84c42c9339b', './templates/modules/mod-locator.tpl', '24.9', 0),
('4b8ee2647ac7401f18ad3ef777525ac9', './templates/modules/mod-login_box.tpl', '24.9', 0),
('34ee42af66f1b8831834f5b5fa182ea7', './templates/modules/mod-logo.tpl', '24.9', 0),
('4c6b05cca4a59f62b757779df7f60dae', './templates/modules/mod-map_edit_features.tpl', '24.9', 0),
('9568625cadf3fd2d32be86e55c439b3b', './templates/modules/mod-map_layer_selector.tpl', '24.9', 0),
('4e395b0b8c8b97bcc6ffe56e9299a25e', './templates/modules/mod-map_mode_selector.tpl', '24.9', 0),
('b0c82d9b41c718037bc836bccaf878ed', './templates/modules/mod-map_search_location.tpl', '24.9', 0),
('73af404eee9098f8be96b2a9e1ad2d05', './templates/modules/mod-menu.tpl', '24.9', 0),
('b30002c0cf9f21760baa0c99dd27b870', './templates/modules/mod-menupage.tpl', '24.9', 0),
('89961cbe1b272d8f0e1d70b85e943404', './templates/modules/mod-menustructure.tpl', '24.9', 0),
('d111ba8fbec83cd552014b3e089ac038', './templates/modules/mod-messages_unread_messages.tpl', '24.9', 0),
('5b1eb7211302fa41f2289ed59daabbd8', './templates/modules/mod-minichat.tpl', '24.9', 0),
('1ee83872b277ddc0343fd06745dda74e', './templates/modules/mod-mobile.tpl', '24.9', 0),
('4d3fcebde80e386404a41857b8502474', './templates/modules/mod-months_links.tpl', '24.9', 0),
('1b7160740fff892d881e137dfb72d650', './templates/modules/mod-most_commented.tpl', '24.9', 0),
('b70ad29b88600d835189e20f05c46536', './templates/modules/mod-mustread.tpl', '24.9', 0),
('48d3185aa646fc0002cf0676b69d8ed0', './templates/modules/mod-notificationlink.tpl', '24.9', 0),
('423a67ba8a92d0e353c72ae398d13f45', './templates/modules/mod-num_submissions.tpl', '24.9', 0),
('848c3eac32d5649447f8ab2c4632f5d7', './templates/modules/mod-old_articles.tpl', '24.9', 0),
('c09a7e49bfe9bd8a80fb4c2eb3f68141', './templates/modules/mod-package.tpl', '24.9', 0),
('b8787c0919054ce45cbd601cc24480d1', './templates/modules/mod-payment_outstanding.tpl', '24.9', 0),
('e26814bd756718543aed6f33997894ca', './templates/modules/mod-permissions.tpl', '24.9', 0),
('198350b1041a2053019a383f0431ea00', './templates/modules/mod-perspective.tpl', '24.9', 0),
('8349e51c97e34efa87f1c3b1b66077bd', './templates/modules/mod-quick_edit.tpl', '24.9', 0),
('d79c44a3e22ff5b049ded53d407ee1a8', './templates/modules/mod-quick_search.tpl', '24.9', 0),
('2a5bb3ae0e350fc9cc285cd3c8da2242', './templates/modules/mod-quickadmin.tpl', '24.9', 0),
('6dbf70305a00ce47139d93503d731eb2', './templates/modules/mod-random_pages.tpl', '24.9', 0),
('23147e85c9ffba53c7be7f54eebff40a', './templates/modules/mod-recordrtc.tpl', '24.9', 0),
('1fed37a316aa9ec8f43b027497c4e40c', './templates/modules/mod-register.tpl', '24.9', 0),
('733cdb3840ff95e57845e2e7b14151e2', './templates/modules/mod-rsslist.tpl', '24.9', 0),
('752acc29fa47cf05cc9bfedf05d091e5', './templates/modules/mod-search.tpl', '24.9', 0),
('3e42c3ad61d855743090ad4c51f4417d', './templates/modules/mod-search_last_rebuild_stats.tpl', '24.9', 0),
('762bbe65e1de0d333f02522ff3d63484', './templates/modules/mod-search_morelikethis.tpl', '24.9', 0),
('6de57c6897cddd5f5524b9233af2305f', './templates/modules/mod-search_wiki_page.tpl', '24.9', 0),
('2da24f02a9860aa65077d4c6fa6ae23c', './templates/modules/mod-semantic_links.tpl', '24.9', 0),
('ddc2aa895aee0e5be4cbf6f94d64be61', './templates/modules/mod-share.tpl', '24.9', 0),
('32e51e2a0d8e7882cab74c61af4c806c', './templates/modules/mod-short_url.tpl', '24.9', 0),
('1f42d4d4822972a301e215eef2289bca', './templates/modules/mod-shoutbox.tpl', '24.9', 0),
('915c24a91daf65db31a3bfe8612f05a2', './templates/modules/mod-since_last_visit.tpl', '24.9', 0),
('a184edc6ff84406d9d7197d18d4e6e06', './templates/modules/mod-since_last_visit_new.tpl', '24.9', 0),
('3fc90dbe143e7842ee127cbca92952e1', './templates/modules/mod-svnup.tpl', '24.9', 0),
('2ebfe1a0e849cbd6e7501e7280f1a991', './templates/modules/mod-switch_lang.tpl', '24.9', 0),
('3e04e0a51a4271155163baccfef7a6dc', './templates/modules/mod-switch_lang_admin.tpl', '24.9', 0),
('2763e132e25516c7541b58cc73d97268', './templates/modules/mod-switch_theme.tpl', '24.9', 0),
('7e1f47dbe424f2e51ec1ea285e363d59', './templates/modules/mod-terminology.tpl', '24.9', 0),
('cf5f5f2aa1fc97cf5e196a00dd38d93e', './templates/modules/mod-tikitests.tpl', '24.9', 0),
('3c459d1288617298af7a1f46b32deb9d', './templates/modules/mod-top_active_blogs.tpl', '24.9', 0),
('18d4472adfe0a400fa3fd88032d4870e', './templates/modules/mod-top_articles.tpl', '24.9', 0),
('867187a2e3e0d8d4a876e4aebf1b19b2', './templates/modules/mod-top_blog_posters.tpl', '24.9', 0),
('5abf13f56c772b734e9cd5d77f01b390', './templates/modules/mod-top_file_galleries.tpl', '24.9', 0),
('e8d417c648747a3c82da607a30aa1721', './templates/modules/mod-top_files.tpl', '24.9', 0),
('14c7becd5404e25c56b408f04183d0c6', './templates/modules/mod-top_forum_posters.tpl', '24.9', 0),
('4397dcfbe118b71af2fa116a4391de71', './templates/modules/mod-top_objects.tpl', '24.9', 0),
('98b337dd53bdd25782b4e8576dedfd3d', './templates/modules/mod-top_pages.tpl', '24.9', 0),
('9fefa163980cd293cdfea819927d4244', './templates/modules/mod-top_quizzes.tpl', '24.9', 0),
('1159d7bcf58a0a741039bb6754780381', './templates/modules/mod-top_visited_blogs.tpl', '24.9', 0),
('ab10464972b5e2e92fb3ed564fd1b31c', './templates/modules/mod-top_visited_faqs.tpl', '24.9', 0),
('fd213d8e4472fde91e712ba058883ba6', './templates/modules/mod-tracker_input.tpl', '24.9', 0),
('5c4f5e858a7e634fd0b0765bc648579b', './templates/modules/mod-trackerhelp.tpl', '24.9', 0),
('57022cbfda2db46feca97377c1155fb1', './templates/modules/mod-translation.tpl', '24.9', 0),
('beba2492e0edfdaf3601e17466cf4d78', './templates/modules/mod-twitter.tpl', '24.9', 0),
('6c785c0c00e93f30348aad99b724450e', './templates/modules/mod-upcoming_events.tpl', '24.9', 0),
('b4d9cd960b419b0267fbb913e86b7b8d', './templates/modules/mod-user_blogs.tpl', '24.9', 0),
('59a8b93589eb40529e076866f1b4bfac', './templates/modules/mod-user_bookmarks.tpl', '24.9', 0),
('78bda9ee75467c6db033c9985f34ede8', './templates/modules/mod-user_pages.tpl', '24.9', 0),
('ef94498afd5a96d461fd8c42e6986b0e', './templates/modules/mod-user_tasks.tpl', '24.9', 0),
('3b258c4015d97ac8fa8dea181b98bd0a', './templates/modules/mod-user_tasks_public.tpl', '24.9', 0),
('3edac7708d3141432dad3e6dc3546a89', './templates/modules/mod-usergroup_tracker.tpl', '24.9', 0),
('6a6d55f6cd67673aaf84b425efb21a81', './templates/modules/mod-users_list.tpl', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('362681958e77e461e2c028d62ba5bd68', './templates/modules/mod-users_own_rank.tpl', '24.9', 0),
('4ec895473e4e9d92a6f7c1331ff38ad4', './templates/modules/mod-users_rank.tpl', '24.9', 0),
('fa40668e12b2fe6f1ff75f7a9aaae8eb', './templates/modules/mod-websearch.tpl', '24.9', 0),
('f61e998497fdf5e2bba7b471411da3fa', './templates/modules/mod-whats_related.tpl', '24.9', 0),
('a442b159dcd1465ed639931022c79c25', './templates/modules/mod-who_is_there.tpl', '24.9', 0),
('a0455abbd01a997cfa523e1820907c3a', './templates/modules/mod-wiki_last_comments.tpl', '24.9', 0),
('30d47e920a1b317c9bc7a731fa53496b', './templates/modules/mod-xmpp.tpl', '24.9', 0),
('0ddca394edaf86105a776d7f3db60017', './templates/modules/mod-youtube.tpl', '24.9', 0),
('1f41ffa123ad471dd8ec395d36dd4f27', './templates/modules/mod-zone.tpl', '24.9', 0),
('137a50cc0deacffdf9549e8ea7f13ffd', './templates/modules/mod-zotero.tpl', '24.9', 0),
('e859987973397ef4fb36699e550b2ede', './templates/modules/user_module.tpl', '24.9', 0),
('50b275c0a64c978b9649ab5225d86d90', './templates/modules/websearch.tpl', '24.9', 0),
('1389d5f4e60e7638af0d2f7b2c488735', './templates/monitor/clearall.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/monitor/index.php', '24.9', 0),
('9a6220dd7d6731110a26937b66f0d885', './templates/monitor/link.tpl', '24.9', 0),
('4bf9c3cb6e98886dc492278e29826a40', './templates/monitor/notification_email_body.tpl', '24.9', 0),
('4faf69b20e424490671d2aa8802b6194', './templates/monitor/notification_email_digest_subject.tpl', '24.9', 0),
('04b5b1e77217b68713cc8f19702dd8ee', './templates/monitor/notification_email_subject.tpl', '24.9', 0),
('c257d0eb24ce2aff73d000630e699cff', './templates/monitor/notification_link.tpl', '24.9', 0),
('57dc3aee5c277df609860ce51f0958f1', './templates/monitor/object.tpl', '24.9', 0),
('11d2c2e6563933082bbe4bd7af69340a', './templates/monitor/stream.tpl', '24.9', 0),
('9eb0c34d47aef9050ca92d9603e16fd2', './templates/monitor/unread.tpl', '24.9', 0),
('07496430c8ea65dee40290a9b130a77f', './templates/multilike.tpl', '24.9', 0),
('32626fe6628c1cd933f0aa037d017bea', './templates/mustread/circulate.tpl', '24.9', 0),
('da17163301e34a682719a6fd829a42c1', './templates/mustread/detail.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/mustread/index.php', '24.9', 0),
('fcc3a3641631063e3d02f4ee84c23933', './templates/mustread/list.tpl', '24.9', 0),
('6af0107dddb188866bc33e1509c695ee', './templates/mustread/object.tpl', '24.9', 0),
('d54362028c4381b074c4bdbba124b869', './templates/mxgraph/editor.tpl', '24.9', 0),
('4eb9df4563f136f323202e434d63a12c', './templates/mxgraph/save_modal.tpl', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './templates/oauthserver/client_row.tpl', '24.9', 0),
('dd9ef9863107af3e1e99418bb2fecb62', './templates/oauthserver/consent.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/object/index.php', '24.9', 0),
('ec14c8d11c59305af6ffbd3653ad858b', './templates/object/infobox.tpl', '24.9', 0),
('617521824e10ae03bb10ab40d8fb3e93', './templates/object/infobox/activity.tpl', '24.9', 0),
('b4e1712c18d01578ce3e314d5ded8447', './templates/object/infobox/index.php', '24.9', 0),
('0879d8b9d005906b1c058dbb9c5dc17f', './templates/object/infobox/trackeritem.tpl', '24.9', 0),
('130f2a27f3baad63bccc5953d025e33b', './templates/object/lock.tpl', '24.9', 0),
('0dc0ca5f90beb88c1579f89b773ca909', './templates/object_perms_summary.tpl', '24.9', 0),
('d7b183abf686533fe2b46372509ed615', './templates/object_selector.tpl', '24.9', 0),
('7b170956b1e49e932b86d2e24428e467', './templates/object_selector_multi.tpl', '24.9', 0),
('7cc7d0e42f4068c0a373320265543265', './templates/object_selector_multi_extra.tpl', '24.9', 0),
('ee4500618332a4300d483f941426e40b', './templates/pagehistory.tpl', '24.9', 0),
('1c5a0642eaa687656a3d1a37557655b9', './templates/password_help.tpl', '24.9', 0),
('1bcd5287f9957fc0baa2e5fe499e64df', './templates/password_jq.tpl', '24.9', 0),
('e4699a22dea6f5f5a9beab1ffe84814a', './templates/permission_link.tpl', '24.9', 0),
('00a0e7c4a60e1750d96fe0ef3bee30ea', './templates/plugin/edit.tpl', '24.9', 0),
('8ba60450ffd29d88d21acc4e3027c284', './templates/plugin/list.tpl', '24.9', 0),
('115b281302183acfe379aa7ff9064d62', './templates/plugin/quick_add_references.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/plugins/index.php', '24.9', 0),
('2faded0f4d7833f764c790021562f7fc', './templates/poll.tpl', '24.9', 0),
('12e9aa2e385aca661bf265586e6d6a26', './templates/prefs/flag.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/prefs/index.php', '24.9', 0),
('c142d1daed2d19f7e01b1643e42d5bf5', './templates/prefs/list.tpl', '24.9', 0),
('2434c136b1d9831699108fc622d7b91f', './templates/prefs/multicheckbox.tpl', '24.9', 0),
('9530cf519e800bf750a1e00394340698', './templates/prefs/multilist.tpl', '24.9', 0),
('ef3845c4348723be3829df9829c6be48', './templates/prefs/multiselector.tpl', '24.9', 0),
('1b9620352f6367511b74e497d8fe9720', './templates/prefs/password.tpl', '24.9', 0),
('584c7b76d7754e7584409db5c4fd09d9', './templates/prefs/radio.tpl', '24.9', 0),
('760592945a9be9dd73b20a29c32948df', './templates/prefs/selector.tpl', '24.9', 0),
('259c76e3d6c4c9669b3e41b8f7a6916a', './templates/prefs/shared.tpl', '24.9', 0),
('a7b2f24edd367f7d3da8103e39b9a6b5', './templates/prefs/text.tpl', '24.9', 0),
('92c57fdcaec142928ecaefc550812bbe', './templates/prefs/textarea.tpl', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './templates/print/index.php', '24.9', 0),
('aaf7505c24739f1e45229a87b4fa2b5b', './templates/print/print-decorator_indexed.tpl', '24.9', 0),
('f40660c56a62e4e32c739fa31f1e7306', './templates/print/print-decorator_indexrow.tpl', '24.9', 0),
('0f8a4c459486338fd01fcda1a99bde81', './templates/print/print-index_footer.tpl', '24.9', 0),
('6723f1aaf8c495d506dbbfbbdb6a65ca', './templates/print/print-index_header.tpl', '24.9', 0),
('c4dd8113832a4d631bd3e0ba1f44fe26', './templates/print/print-object_trackeritem.tpl', '24.9', 0),
('84b09b48d485386dc06d57965e399407', './templates/print/print-object_wiki.tpl', '24.9', 0),
('c2ba4d03f4a69006987f1e3703b02611', './templates/print/print-page_footer.tpl', '24.9', 0),
('a6068849617e260501e9ee53135c5550', './templates/print/print-page_header.tpl', '24.9', 0),
('0a293bd9cc815c34970820b55930e8dd', './templates/print/print-title_trackeritem.tpl', '24.9', 0),
('8035a67a17997d1f1d32bd3161ef068f', './templates/print/print-title_wiki.tpl', '24.9', 0),
('4cb80af8c098d6047da30254d4b024d8', './templates/pwa/pwa.tpl', '24.9', 0),
('4113c678d0c44e3840cac1571d71b82a', './templates/rating.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/rating/index.php', '24.9', 0),
('b44a639f5c6b28eb291e85b417cc0e6d', './templates/rating/vote.tpl', '24.9', 0),
('3ed3ddcf0bb4869d303a6b674e920507', './templates/rating_choice.tpl', '24.9', 0),
('a09b6836dd58cd043eb5029d507c35e2', './templates/recommendation_dev/compare.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/recommendation_dev/index.php', '24.9', 0),
('b068f830db9c78690be938ae749526b3', './templates/register-email.tpl', '24.9', 0),
('183803d44ceed610bb8950ad08838fca', './templates/register-form.tpl', '24.9', 0),
('a8b92a489988671bacd231c8df529ca9', './templates/register-groupchoice.tpl', '24.9', 0),
('c473846785d26795b454e47921a01024', './templates/register-login.tpl', '24.9', 0),
('341bd075f019cbc73199ea763f1e6d9f', './templates/register-pass.tpl', '24.9', 0),
('56e3c93687255c774e4def4a88c1c6f8', './templates/register-pass2.tpl', '24.9', 0),
('29d483e705ba208692959c5e739c6a30', './templates/register-passcode.tpl', '24.9', 0),
('dcc2a57266cd3f4327f5fdf5edcc26e0', './templates/remarksbox.tpl', '24.9', 0),
('681d96ade1e492de23acef4c8c9ff5ae', './templates/report/edit.tpl', '24.9', 0),
('681d96ade1e492de23acef4c8c9ff5ae', './templates/report/exportcsv.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/report/index.php', '24.9', 0),
('681d96ade1e492de23acef4c8c9ff5ae', './templates/report/load.tpl', '24.9', 0),
('681d96ade1e492de23acef4c8c9ff5ae', './templates/report/preview.tpl', '24.9', 0),
('681d96ade1e492de23acef4c8c9ff5ae', './templates/report/wikidata.tpl', '24.9', 0),
('7e3ef73a32b3ffab21e18380ab146b25', './templates/scheduler/remove.tpl', '24.9', 0),
('b37988e2319ab3393505dd07edd4c3b7', './templates/scheduler/reset.tpl', '24.9', 0),
('44cb6bbcc18be1c4cf2d82d10d0e2110', './templates/scheduler/run.tpl', '24.9', 0),
('1e8de2e4a9828dbae45e5a63e9319174', './templates/score/create_score_event.tpl', '24.9', 0),
('3ee04884dfc130a13673e3e375e88b21', './templates/search/help.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/search/index.php', '24.9', 0),
('c209a5e32ada53dfbcb97fc239075361', './templates/search/list/carousel.tpl', '24.9', 0),
('299910931a7988757f81bd04bbab13e0', './templates/search/list/count.tpl', '24.9', 0),
('b3bafc0c4947188e136869ff38a9cb53', './templates/search/list/debug.tpl', '24.9', 0),
('c605d5a3c3180038a7e85fdcb57e3f6d', './templates/search/list/filter.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/search/list/index.php', '24.9', 0),
('73a9b4b7096ea74c557d8c98672964ed', './templates/search/list/json_encode.tpl', '24.9', 0),
('5adff4168d3f90942a77ac5c18f04d0e', './templates/search/list/medialist.tpl', '24.9', 0),
('a651cc827e7bec747b9353f195faf721', './templates/search/list/table.tpl', '24.9', 0),
('1c6f3e9d251d22f6ba1b839e2be37f4c', './templates/search/process_queue.tpl', '24.9', 0),
('95cf7c911dcce18cfe3c6d96e9def6b7', './templates/search/rebuild.tpl', '24.9', 0),
('a5ab032f606373473ffacbb4daf69708', './templates/search_customsearch/cache_expired.tpl', '24.9', 0),
('db66190db559ce5ef2db7b0b038c8c2a', './templates/search_customsearch/customsearch.tpl', '24.9', 0),
('c28fa65d291501fc7b6530d90ec55345', './templates/search_customsearch/default_form.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/search_customsearch/index.php', '24.9', 0),
('6daaba49faf9e500f7eb8762f0e5a72d', './templates/search_manifold/check.tpl', '24.9', 0),
('9a1547b4d4375eaf2c4339dccba0d0a2', './templates/search_manifold/create_index.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/search_manifold/index.php', '24.9', 0),
('42eadac72e844c795235d706fb5cb192', './templates/search_stored/delete.tpl', '24.9', 0),
('5142db03931ea7bddb9c26178d190976', './templates/search_stored/edit.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/search_stored/index.php', '24.9', 0),
('ea547de6c24141303f4031e26c539a6e', './templates/search_stored/list.tpl', '24.9', 0),
('122594e1c00847e2e438a4b8b773df47', './templates/search_stored/select.tpl', '24.9', 0),
('5864eaefdeec02ce4369f15cf3d6e60f', './templates/searchresults-plain.tpl', '24.9', 0),
('187cc5f04bf8cfddc349a86f8620a071', './templates/send_newsletter_footer.tpl', '24.9', 0),
('496bb1da40c9e5c00009f135c733f99c', './templates/send_newsletter_header.tpl', '24.9', 0),
('debb7547dda8ba38aabc379ddbaab345', './templates/sent_newsletters.tpl', '24.9', 0),
('63a3a58c7b5a1b5bf9aa5a8569fcba33', './templates/show_copyright.tpl', '24.9', 0),
('607892cddbee839290e351578713a155', './templates/social/add_friend.tpl', '24.9', 0),
('a3e90a20dd6ed51df11f9954463678a0', './templates/social/approve_friend.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/social/index.php', '24.9', 0),
('917beb63bb89d7afeb33e789107e7662', './templates/social/list_friends.tpl', '24.9', 0),
('610644e8df51a246fea3b1fbda4bf331', './templates/social/remove_friend.tpl', '24.9', 0),
('c659eda7d66050c5044da434c54dc327', './templates/structures_toc-endul.tpl', '24.9', 0),
('f441f143e50da8d8590d653734d28f9d', './templates/structures_toc-leaf.tpl', '24.9', 0),
('1ed08084ab8194dab7708c524115497c', './templates/structures_toc-startul.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/styleguide/index.php', '24.9', 0),
('dd981bc9093ccc74d59d5af80307b241', './templates/styleguide/sections/alerts.tpl', '24.9', 0),
('84be8cccde9ab06c82da47637e2fcbcd', './templates/styleguide/sections/buttons.tpl', '24.9', 0),
('38fc538d4200b99c1764734fd033ead7', './templates/styleguide/sections/colors.tpl', '24.9', 0),
('4f54d186476e1e041c1239135c9313d2', './templates/styleguide/sections/dropdowns.tpl', '24.9', 0),
('089a1a78fbcd427d117b9fa3db7be050', './templates/styleguide/sections/fonts.tpl', '24.9', 0),
('f48d0754c25e1b795859a43fac55a8eb', './templates/styleguide/sections/forms.tpl', '24.9', 0),
('e4cfa3c5bb250c3c5af8a81a5552462d', './templates/styleguide/sections/headings.tpl', '24.9', 0),
('de1f3af9cd7d95448807847cbb9c2169', './templates/styleguide/sections/icons.tpl', '24.9', 0),
('d77ab7bfd662318064334348e6e7a4fb', './templates/styleguide/sections/lists.tpl', '24.9', 0),
('d88db95f1006cbcc754d474d8be44914', './templates/styleguide/sections/navbars.tpl', '24.9', 0),
('2c8c488aef26690885b4170bde6119d2', './templates/styleguide/sections/tables.tpl', '24.9', 0),
('0690d42ae6e505185f33f1a575363abc', './templates/styleguide/sections/tabs.tpl', '24.9', 0),
('8ffc4d6926da4d526b2878aae545c497', './templates/styleguide/show.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/suite/index.php', '24.9', 0),
('28a505eeb785edcbac9c00a421a91d67', './templates/suite/jitsi.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/tablesorter/index.php', '24.9', 0),
('55e35fea1bef081cbc3b246721dd4ef0', './templates/tablesorter/totals.tpl', '24.9', 0),
('dce5e5477535cdd734cc59bd9d87e64d', './templates/tabular/create.tpl', '24.9', 0),
('ab7dcba62c1bd04b50868cc00240b38e', './templates/tabular/create_tracker.tpl', '24.9', 0),
('e8f81aae2a7c564a359ffcc3634db2d6', './templates/tabular/delete.tpl', '24.9', 0),
('39fca444bb7aeea72c29cbe1ab0f0fb5', './templates/tabular/duplicate.tpl', '24.9', 0),
('0644042f2a0943e2ace6827ca1e3244c', './templates/tabular/edit.tpl', '24.9', 0),
('bb3c3b6886f44347b20caf7ae90958c3', './templates/tabular/export_search_csv.tpl', '24.9', 0),
('2dced0202ad2d81d43a12db329587bcd', './templates/tabular/filter.tpl', '24.9', 0),
('c5fb4bb3c96e958d1aa3307a1ff28a62', './templates/tabular/import_csv.tpl', '24.9', 0),
('ec07398f414132f736335ba6b033fce4', './templates/tabular/include_tabular_navbar.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/tabular/index.php', '24.9', 0),
('962645d22d402cd5b760bbe0fdf16538', './templates/tabular/item_actions.tpl', '24.9', 0),
('01ee905966a84801619af5b6361603e3', './templates/tabular/list.tpl', '24.9', 0),
('3c84cec08079d67bf2026ffe3858d030', './templates/tabular/manage.tpl', '24.9', 0),
('24ec03fa42afacfb78e68fb7afaf22ca', './templates/tabular/select.tpl', '24.9', 0),
('ae56b38a12a2e25141c4784903bcda62', './templates/tabular/select_filter.tpl', '24.9', 0),
('0d34b66da5649684da870e22791d7af8', './templates/tiki-accounting.tpl', '24.9', 0),
('b1661c9ade0f99567709081beaf2f7cb', './templates/tiki-accounting_account_form.tpl', '24.9', 0),
('c2ec5bcac701547be2939c9a7174806c', './templates/tiki-accounting_account_list.tpl', '24.9', 0),
('87d2d4e25a43e1de3ce2bc3584a72151', './templates/tiki-accounting_account_view.tpl', '24.9', 0),
('b015d26ce7d05496846dd31a2e1011be', './templates/tiki-accounting_accounts_csv.tpl', '24.9', 0),
('6c72720764f5f4669440d6f19779faa3', './templates/tiki-accounting_books.tpl', '24.9', 0),
('ac163af41708a55dce7418e85510562c', './templates/tiki-accounting_cancel.tpl', '24.9', 0),
('1b603db22e28e2032ea7a875b541dfb1', './templates/tiki-accounting_entry.tpl', '24.9', 0),
('0aa98beec691c9933fafc6eb35aec16f', './templates/tiki-accounting_export.tpl', '24.9', 0),
('6a0f1978b2110067c73d82862a1cc983', './templates/tiki-accounting_journal.tpl', '24.9', 0),
('316bbcdd0e50d1b39b7ca2382072bbe4', './templates/tiki-accounting_journal_csv.tpl', '24.9', 0),
('39f174b683a2f39ced3836d1f8e57e19', './templates/tiki-accounting_stack.tpl', '24.9', 0),
('1dc1307e31ddabb5df40191caff31ad8', './templates/tiki-accounting_stacklist.tpl', '24.9', 0),
('ed25a5c604a053525a40df03b79ead91', './templates/tiki-action_calendar.tpl', '24.9', 0),
('c2342a5f1946d0d20fb1913faad21c13', './templates/tiki-admin.tpl', '24.9', 0),
('f0a77bc81fbd3988ef78df7d4d7ec351', './templates/tiki-admin_actionlog.tpl', '24.9', 0),
('34b5a63c865a18b3139466f022d545f1', './templates/tiki-admin_banning.tpl', '24.9', 0),
('6b899f28bcd1f0779819fa399a71d536', './templates/tiki-admin_calendars.tpl', '24.9', 0),
('56335f3fef986f847e50a06f538c096b', './templates/tiki-admin_categories.tpl', '24.9', 0),
('dbf8dfd72849ddd9ab8f359a4217efdb', './templates/tiki-admin_content_templates.tpl', '24.9', 0),
('4fa3dc7c544a31b08aedd2e6aab7311e', './templates/tiki-admin_contribution.tpl', '24.9', 0),
('671871bed3291cca3f591ebabc482479', './templates/tiki-admin_cookies.tpl', '24.9', 0),
('5d7ff88e03912c4086f1c44e80653a09', './templates/tiki-admin_credits.tpl', '24.9', 0),
('5b95a7a62bb18fe3b56e86c43d4e8cc7', './templates/tiki-admin_dsn.tpl', '24.9', 0),
('f307658d36fc7a931988cdcb22b5397d', './templates/tiki-admin_external_wikis.tpl', '24.9', 0),
('2f7dc8d2323e2bb34c4ab7fc6cd0e1ba', './templates/tiki-admin_forums.tpl', '24.9', 0),
('9ba9770ba065bc3b224a97578453fb0d', './templates/tiki-admin_hotwords.tpl', '24.9', 0),
('4f8d161dc87af70d16df75be7ca3edf7', './templates/tiki-admin_html_page_content.tpl', '24.9', 0),
('233cda5156fbc40a49e888e0a98ecd59', './templates/tiki-admin_html_pages.tpl', '24.9', 0),
('076be6fe31b180b62a3100af9ee61125', './templates/tiki-admin_ids.tpl', '24.9', 0),
('bce89f0bd5ddec0528bc1c5a695e6d88', './templates/tiki-admin_integrator.tpl', '24.9', 0),
('c98617c95a48bd5ff8ee353ed74ad8ad', './templates/tiki-admin_integrator_rules.tpl', '24.9', 0),
('30a253550f09022f666c574dfa6393a0', './templates/tiki-admin_keywords.tpl', '24.9', 0),
('f6d517cda161068e6e6996087eb585c4', './templates/tiki-admin_links.tpl', '24.9', 0),
('c1fffdd533cf314e3b89bf8acb0675d2', './templates/tiki-admin_mailin.tpl', '24.9', 0),
('babff0b3473cc5c88f6acb5d67edcee2', './templates/tiki-admin_mailin_routes.tpl', '24.9', 0),
('901bdeeececafe8877080ffdae55028a', './templates/tiki-admin_menu_options.tpl', '24.9', 0),
('a99474ce9fa7d54fce2018dc29786a68', './templates/tiki-admin_menus.tpl', '24.9', 0),
('594667e713c135bf0d2bdd1dace5bef7', './templates/tiki-admin_modules.tpl', '24.9', 0),
('1d0934b8ee40f27f0ae20cc9e88cc4dd', './templates/tiki-admin_newsletter_subscriptions.tpl', '24.9', 0),
('0c67757ea94ca606e2cca05de62eed87', './templates/tiki-admin_newsletters.tpl', '24.9', 0),
('89b4b9921cef2d3bb5c598a3c118823d', './templates/tiki-admin_notifications.tpl', '24.9', 0),
('f1ac6f5e2d357a8de8c5257190423513', './templates/tiki-admin_oauthserver.tpl', '24.9', 0),
('9dfb33397158835c3fc6cc1649cc4377', './templates/tiki-admin_orphaned.tpl', '24.9', 0),
('79524132ba55684f734314481e43aa0a', './templates/tiki-admin_poll_options.tpl', '24.9', 0),
('60ab28267daecd06479389c34a7485db', './templates/tiki-admin_polls.tpl', '24.9', 0),
('57ab41c10b771f75f3c9a83251e41f2f', './templates/tiki-admin_routes.tpl', '24.9', 0),
('21b343bfaadb3c4ebd762a8cbc8ab1f1', './templates/tiki-admin_rssmodules.tpl', '24.9', 0),
('5e3d2806727290288e575c1554909f9e', './templates/tiki-admin_schedulers.tpl', '24.9', 0),
('c00e8ec4b5333ae124ea1e1e908be1b7', './templates/tiki-admin_security.tpl', '24.9', 0),
('c1d95cdac84fa7c3a61cd1475f392d03', './templates/tiki-admin_shoutbox_words.tpl', '24.9', 0),
('2c8ad9a997a59c9591457998a6d44342', './templates/tiki-admin_sitemap.tpl', '24.9', 0),
('a32c0abc24ad442bd1d4e2d23c30d5b4', './templates/tiki-admin_structures.tpl', '24.9', 0),
('07ee03028c63df0dabab89cfb2d74401', './templates/tiki-admin_survey_questions.tpl', '24.9', 0),
('8ce5a2fabaddd5befd3869a96007494b', './templates/tiki-admin_surveys.tpl', '24.9', 0),
('6e10d324971d436c33fb4e078f46e3ca', './templates/tiki-admin_sync.tpl', '24.9', 0),
('184a3457dbac36176f8d7c17519a764f', './templates/tiki-admin_system.tpl', '24.9', 0),
('f4a616eab4ab28ad482162f8607134b3', './templates/tiki-admin_tokens.tpl', '24.9', 0),
('1f993e512c5e16144e833b537e060fa0', './templates/tiki-admin_toolbars.tpl', '24.9', 0),
('75237864614522d655f73710ce4da015', './templates/tiki-admin_topics.tpl', '24.9', 0),
('b6323b07255ce4fccfc3aa89ed93485d', './templates/tiki-admin_tracker_fields.tpl', '24.9', 0),
('fbbcfbd47aa05844abd06e025ec9fe30', './templates/tiki-admin_transitions.tpl', '24.9', 0),
('4f74ecab70a5d177b1294b6c227ce37c', './templates/tiki-admin_webservices.tpl', '24.9', 0),
('b3f854a5af4218365579ac647b6edfae', './templates/tiki-admingroups.tpl', '24.9', 0),
('a9c104ed31d37e268e329291ace50278', './templates/tiki-adminusers.tpl', '24.9', 0),
('4b426bfe2c7e781baa2120b4a86cde4a', './templates/tiki-ajax_header.tpl', '24.9', 0),
('c8eb3887bc55c44ecf90e1dabd20befd', './templates/tiki-all_languages.tpl', '24.9', 0),
('c4f2dc6d0f12e98542690f4987cf5992', './templates/tiki-article_types.tpl', '24.9', 0),
('a7ef90ac84f918b6d1fb94988e48d875', './templates/tiki-articles-js.tpl', '24.9', 0),
('67beac65a548480d34dbc3d717c01427', './templates/tiki-assignuser.tpl', '24.9', 0),
('3500d1960a68f370335cce67d90f14f1', './templates/tiki-backlinks.tpl', '24.9', 0),
('bef95d532c6099621b0b059c7606ae4f', './templates/tiki-batch_upload_files.tpl', '24.9', 0),
('ab62a4dc4253ca133dedfe6e88f52325', './templates/tiki-blog_post.tpl', '24.9', 0),
('dbc9f4da92fbc817aaef9b2a6d5a1792', './templates/tiki-browse_categories.tpl', '24.9', 0),
('a05947cf7ee4961277733e11ca0be98b', './templates/tiki-browse_freetags.tpl', '24.9', 0),
('af6720a233873c68300912b38a0021ae', './templates/tiki-calendar.tpl', '24.9', 0),
('3d0c77889dd9dced5bccc89d56fb626e', './templates/tiki-calendar_box.tpl', '24.9', 0),
('91343db269445a3b8962ae23975d8d1e', './templates/tiki-calendar_box_multiple.tpl', '24.9', 0),
('ddddb11ca5a9eb99c30b2b9ac681fe68', './templates/tiki-calendar_edit_item.tpl', '24.9', 0),
('431b5e9a142ab0f0e1779cd8713942d3', './templates/tiki-calendar_import.tpl', '24.9', 0),
('ec84ae82456ace240f8ba6362f455810', './templates/tiki-calendar_listmode.tpl', '24.9', 0),
('47c8e43e998b8f09dd55a1f2ba3790ee', './templates/tiki-calendar_nav.tpl', '24.9', 0),
('73b51c22257cecfc507ff7ed42d51e8e', './templates/tiki-calendar_params_ical.tpl', '24.9', 0),
('3e635a1148fd60b7429bd84eba88acae', './templates/tiki-change_password.tpl', '24.9', 0),
('a92328de44c0660513aec8ab0fe93ffe', './templates/tiki-check.tpl', '24.9', 0),
('1759b2c89158c635d1377671db2a7894', './templates/tiki-choose_page_language.tpl', '24.9', 0),
('5edf40be91ffb07ecd4fbdb9f9f7fe4f', './templates/tiki-contact.tpl', '24.9', 0),
('b2847babdfbaaa0ed8e2f773213ad746', './templates/tiki-contacts.tpl', '24.9', 0),
('afc1820abcc64fdc3a178f70e4788dbe', './templates/tiki-copypage.tpl', '24.9', 0),
('ff26594409643fac36cb9594c223a0a8', './templates/tiki-create_multilang_pages.tpl', '24.9', 0),
('74c5d3f377ef2f652d491bf88061be25', './templates/tiki-create_webhelp.tpl', '24.9', 0),
('4fda30f6b72dce97e0b4fe645f1203a1', './templates/tiki-directory_add_site.tpl', '24.9', 0),
('fec938adc691519c3094d7d89adc0f1a', './templates/tiki-directory_admin.tpl', '24.9', 0),
('c2626a8ef4802a96c466b3129b3870dd', './templates/tiki-directory_admin_bar.tpl', '24.9', 0),
('a62e68c5975749bcec778bbde66864e5', './templates/tiki-directory_admin_categories.tpl', '24.9', 0),
('ec2a9b1f9fd7e06b91aa0204c3b75496', './templates/tiki-directory_admin_related.tpl', '24.9', 0),
('fe6647ef9673f9dfa7a72be903e6a098', './templates/tiki-directory_admin_sites.tpl', '24.9', 0),
('c26af4a84ee3ff5e5c415979ff7874ee', './templates/tiki-directory_bar.tpl', '24.9', 0),
('7021fcf487c4f650e95fdf3a7ef3326a', './templates/tiki-directory_browse.tpl', '24.9', 0),
('8a25a0a420e058eb39630223ba3f4691', './templates/tiki-directory_footer.tpl', '24.9', 0),
('0567e0c32c61608e565c8681f97af7bb', './templates/tiki-directory_ranking.tpl', '24.9', 0),
('1e47c5edf2dd4a401c23c47208dcc970', './templates/tiki-directory_search.tpl', '24.9', 0),
('62ee72afc82fc35eeae4bd15dd7ca84c', './templates/tiki-directory_validate_sites.tpl', '24.9', 0),
('c9e5c58c13943ced383595b940e7996d', './templates/tiki-discount.tpl', '24.9', 0),
('3867aa6636737625ac06022f36554d13', './templates/tiki-edit-page-include-prompt_for_edit_or_translate.tpl', '24.9', 0),
('4dd08788a28a1a194cecdea20fc648f6', './templates/tiki-edit-page-included_by.tpl', '24.9', 0),
('99c02f344e1de63cef60803d43662e91', './templates/tiki-edit_article.tpl', '24.9', 0),
('2d68e3d0df7738da2e70177e04f68e3c', './templates/tiki-edit_banner.tpl', '24.9', 0),
('7af6c809ffc53eb4d8fd3f7ba6a4dd00', './templates/tiki-edit_blog.tpl', '24.9', 0),
('d8a46c6e89288fee418f75218a4531c1', './templates/tiki-edit_categories.tpl', '24.9', 0),
('d19589fa4bac9426d73c0e3c526f41b7', './templates/tiki-edit_css.tpl', '24.9', 0),
('d22be9fd1fcbd906c8f6e52bc71d6b6e', './templates/tiki-edit_docs.tpl', '24.9', 0),
('0bee484c21ca84c6109b5114b6b37d49', './templates/tiki-edit_draw.tpl', '24.9', 0),
('bc3823951bed77385a841363c9dd0d3b', './templates/tiki-edit_groups.tpl', '24.9', 0),
('20344431c67e2b1c8c87c494931a032c', './templates/tiki-edit_help.tpl', '24.9', 0),
('adf5fec3b6f438c1eef3f7642e5bfbbd', './templates/tiki-edit_help_plugins.tpl', '24.9', 0),
('960ea43aed7b04ddb198d4a590424525', './templates/tiki-edit_help_sheet.tpl', '24.9', 0),
('57f7274f780c7f9cacd5c2884dc24b64', './templates/tiki-edit_help_wysiwyg.tpl', '24.9', 0),
('aaf1ce707cfc536518c618c116ea9ed6', './templates/tiki-edit_languages.tpl', '24.9', 0),
('323d4675c16e90e4493fd58127e53d7d', './templates/tiki-edit_perspective.tpl', '24.9', 0),
('cb38727dcf0bfedcb02ace82f958a2a6', './templates/tiki-edit_programmed_content.tpl', '24.9', 0),
('5891bf4be2bb05975711d07675634cfe', './templates/tiki-edit_question_options.tpl', '24.9', 0),
('c1751a8ff9a9c9f23f622c7e73dab80b', './templates/tiki-edit_quiz.tpl', '24.9', 0),
('fa6af673fc5181a1c42f0d1e7a7c0a70', './templates/tiki-edit_quiz_questions.tpl', '24.9', 0),
('fb729ba6111e36b7d1f4988a88fd7cce', './templates/tiki-edit_quiz_results.tpl', '24.9', 0),
('dd1d49be5cae324878c7e814b65c28f0', './templates/tiki-edit_report.tpl', '24.9', 0),
('5bf31e77123ab0ef2f9448a7f202ef5e', './templates/tiki-edit_structure.tpl', '24.9', 0),
('73434a9cf1d7d4c98867af80492cf38e', './templates/tiki-edit_submission.tpl', '24.9', 0),
('7d4110c013aa1ab7a2ed32f63cbed145', './templates/tiki-edit_templates.tpl', '24.9', 0),
('9d34148b5a99161f7fe073391729c3dd', './templates/tiki-edit_topic.tpl', '24.9', 0),
('e9b2985e354c4f41c220b3e227285b6e', './templates/tiki-edit_translation.tpl', '24.9', 0),
('7c4cf2d7ac62c880208775fe39abf7dc', './templates/tiki-editpage.tpl', '24.9', 0),
('13d89d4ccabbdb00b5279f01cce9da07', './templates/tiki-export-sheets.tpl', '24.9', 0),
('a908f4050bc022f6cd7b0da0661f3d80', './templates/tiki-export_comment_xml.tpl', '24.9', 0),
('9bbbf01a1ae6371b5564877ad031f5a7', './templates/tiki-export_page_xml.tpl', '24.9', 0),
('0077a2d9da080953c83a1b04378557ea', './templates/tiki-export_tracker_item.tpl', '24.9', 0),
('6db458fb8d349ff72c41eb0afa478e2f', './templates/tiki-export_users.tpl', '24.9', 0),
('a80558cf87b90dc3d99ff79d214a14cf', './templates/tiki-faq_questions.tpl', '24.9', 0),
('f187d4c586eac637c462ac86d11ee0b7', './templates/tiki-featured_link.tpl', '24.9', 0),
('383149e6766123e01a27a1f45ce77d64', './templates/tiki-file_archives.tpl', '24.9', 0),
('c4847338a84a2c2dfddb81fdf834434f', './templates/tiki-file_info_box.tpl', '24.9', 0),
('493486c9bc7f5138bb739e816f4419f9', './templates/tiki-flaggedrev_approval_header.tpl', '24.9', 0),
('807a52e841f9fc1b8e18e365bd49d1d3', './templates/tiki-forum_import.tpl', '24.9', 0),
('3fc940cacdebc0c33aaadd809fb99008', './templates/tiki-forum_queue.tpl', '24.9', 0),
('5f8b7ef1e7b6c64627c6b890dc27c8fb', './templates/tiki-forums.tpl', '24.9', 0),
('27cac42f126c905a0f48e5a54788c287', './templates/tiki-forums_reported.tpl', '24.9', 0),
('ef47e275edd5ce5e93377e137aa9d855', './templates/tiki-freetag-translate.tpl', '24.9', 0),
('33882506d9e69022b6eb612401733a57', './templates/tiki-friends.tpl', '24.9', 0),
('8d6ba9e1cd5a15bb6a79cad9be221aa2', './templates/tiki-graph-sheets.tpl', '24.9', 0),
('d4908007848af56f20f599528d2dbd17', './templates/tiki-history_sheets.tpl', '24.9', 0),
('47eeb31ebcec2df04ce829b2cce8ff74', './templates/tiki-import-sheets.tpl', '24.9', 0),
('892875e64089523fab52a6cbd2d97871', './templates/tiki-import_structuredtext.tpl', '24.9', 0),
('9f6d646948694c67806167eafea02ce6', './templates/tiki-import_xml_zip.tpl', '24.9', 0),
('eefbfe3fb6d104ee6cc27a17b7343a0f', './templates/tiki-importer.tpl', '24.9', 0),
('bee551ea1a907a2554abe949e31f749e', './templates/tiki-index_p.tpl', '24.9', 0),
('43239a7e89e8bf1af569a4bac76f447c', './templates/tiki-information.tpl', '24.9', 0),
('dee8e55d1e60d4c070da780c294c58aa', './templates/tiki-install.tpl', '24.9', 0),
('e965eaef10059d899a955ab7d1eacc5a', './templates/tiki-install_screens.tpl', '24.9', 0),
('0ea2100ffdf30f5b54603531a9628450', './templates/tiki-integrator.tpl', '24.9', 0),
('48768bdb5f799f073fab68f181d10b55', './templates/tiki-invite.tpl', '24.9', 0),
('0091c477f85ab74e9ec28fd88ea2e478', './templates/tiki-invited.tpl', '24.9', 0),
('59b9a3c164e3ad396fc2c140d35625dd', './templates/tiki-kaltura_upload.tpl', '24.9', 0),
('98ca4ed64d6c303907feece05b157687', './templates/tiki-kaltura_video.tpl', '24.9', 0),
('d31b33747ff74fc0cd5984aadedd014d', './templates/tiki-lastchanges.tpl', '24.9', 0),
('0386dc039d876dc46fe92990bf789c8d', './templates/tiki-likepages.tpl', '24.9', 0),
('4d9f8a55aa52a9650a96b9d919fc0050', './templates/tiki-list_articles.tpl', '24.9', 0),
('966aad09deb97c333a41a908a40f11ac', './templates/tiki-list_banners.tpl', '24.9', 0),
('51863471f4dc54236a777f68d592d525', './templates/tiki-list_blogs.tpl', '24.9', 0),
('b2a68b6ab2e5c02b339085dfc63f6019', './templates/tiki-list_cache.tpl', '24.9', 0),
('78384233fe0fad4111e4cfe7a921a402', './templates/tiki-list_comments.tpl', '24.9', 0),
('d709f90435a66e5761b458513577bf35', './templates/tiki-list_contents.tpl', '24.9', 0),
('3f58a3734a5f27511bee56ba6dc1c80c', './templates/tiki-list_faqs.tpl', '24.9', 0),
('997a21b9448cc0b77ff784d6b630e733', './templates/tiki-list_file_gallery.tpl', '24.9', 0),
('29c73fefaf5357fdee186168e4a8b271', './templates/tiki-list_integrator_repositories.tpl', '24.9', 0),
('72cea76490323e3eb4fcc4af6eb67243', './templates/tiki-list_invite.tpl', '24.9', 0),
('72904dca6d315996bc7a33892daa4623', './templates/tiki-list_kaltura_browse_entries.tpl', '24.9', 0),
('009082e7fcb91c7057a7b15f0823afa1', './templates/tiki-list_kaltura_entries.tpl', '24.9', 0),
('ec428cca53a85e3465dd8a712803935c', './templates/tiki-list_kaltura_entries_actions.tpl', '24.9', 0),
('1d1ccab4056d8d7f119c37ea5dd0ef95', './templates/tiki-list_kaltura_entries_add_info.tpl', '24.9', 0),
('59122cfd4beb11e3d8f1876fc9dacf12', './templates/tiki-list_kaltura_media_entries.tpl', '24.9', 0),
('785445b5080ee45b58981036d9d951c3', './templates/tiki-list_kaltura_mix_entries.tpl', '24.9', 0),
('ae370b2bff51588cea9bd711146121a9', './templates/tiki-list_object_permissions.tpl', '24.9', 0),
('5f6bd4267e97bdb47436de4138be733c', './templates/tiki-list_posts.tpl', '24.9', 0),
('88f6777fdc648d60e672e006d37088a7', './templates/tiki-list_quizzes.tpl', '24.9', 0),
('a65a157fa2a6d1021d17770f93762fd3', './templates/tiki-list_submissions.tpl', '24.9', 0),
('5333f9cd4773065387df91bd05361448', './templates/tiki-list_surveys.tpl', '24.9', 0),
('0df2f81c80304619f6f277e9dabf7b05', './templates/tiki-list_trackers.tpl', '24.9', 0),
('9ea65c2646cb8a8fcf2b25094288bdf9', './templates/tiki-list_users.tpl', '24.9', 0),
('322e1abc712702ca11aa5db6fe38f60a', './templates/tiki-listpages.tpl', '24.9', 0),
('b7007459684429dd116c9a80366d3428', './templates/tiki-listpages_content.tpl', '24.9', 0),
('279a8b26fa46b94a0445ea7b72d4e5b7', './templates/tiki-live_support_admin.tpl', '24.9', 0),
('4569b68918ec5f01d640a70a1d06fdf0', './templates/tiki-live_support_chat_window.tpl', '24.9', 0),
('3827c74b7719614e61c3720a92b15a4e', './templates/tiki-live_support_client.tpl', '24.9', 0),
('c864a6a3424134d6ba57a10fdc695c94', './templates/tiki-live_support_console.tpl', '24.9', 0),
('0bb540cad716b9dfc5166c6fbf177996', './templates/tiki-live_support_transcripts.tpl', '24.9', 0),
('0ef3e110040b9b46722609bcb41f1003', './templates/tiki-login.tpl', '24.9', 0),
('991706f8c921e6aa5cc51ebb20921086', './templates/tiki-login_confirm_email.tpl', '24.9', 0),
('6b87aa0fb3a2c66a84ac6ba0b71e9760', './templates/tiki-mailin.tpl', '24.9', 0),
('f16bb6741fa324932d6dd26eaf072f94', './templates/tiki-mindmap.tpl', '24.9', 0),
('21a37b6be28d742a350cfad616e09b34', './templates/tiki-minical.tpl', '24.9', 0),
('94087cf80ddf5f6fb88497450d3b7904', './templates/tiki-minical_prefs.tpl', '24.9', 0),
('3631c80773120f15d65e2acb558199bf', './templates/tiki-mods.tpl', '24.9', 0),
('8c5ee77b2848085bbb26516e01d387c2', './templates/tiki-my_tiki.tpl', '24.9', 0),
('9ea630ef59008707b120f801aa1ab7a4', './templates/tiki-mytiki_bar.tpl', '24.9', 0),
('a73fae7e64aef0746f1de4d9c03afe1f', './templates/tiki-newsletter_archives.tpl', '24.9', 0),
('65be1a26b4fcd6acb21cf1cc65501f46', './templates/tiki-newsletters.tpl', '24.9', 0),
('ea311b45e9b054f0d5dac5ac0c3bab17', './templates/tiki-notepad_list.tpl', '24.9', 0),
('ee31c4c3fa8be5d2b818fbd5648c8b16', './templates/tiki-notepad_read.tpl', '24.9', 0),
('3636e0205b3ef0c23d2a2104ddf3a251', './templates/tiki-notepad_write.tpl', '24.9', 0),
('144446643ed65281e0e9500cdadbc7cb', './templates/tiki-object_watches.tpl', '24.9', 0),
('eb4a47840d0957b9e537b04411252d47', './templates/tiki-objectpermissions.tpl', '24.9', 0),
('405b2dd57de7d7edfa82f36e14608a02', './templates/tiki-old_polls.tpl', '24.9', 0),
('f52afd8bc8ff956091ea589cc4c94287', './templates/tiki-openid_select.tpl', '24.9', 0),
('9a7acc45d65bf499e5d3736a6e149e3d', './templates/tiki-orphan_pages.tpl', '24.9', 0),
('2e1b03a5a3640c6f52b74a6c8fd1ceee', './templates/tiki-page.tpl', '24.9', 0),
('6300ea6ec00235c36ccc5c69e2b1fb42', './templates/tiki-page_bar.tpl', '24.9', 0),
('e53e8ea6629fb8b7a5321f5c2ef9dd75', './templates/tiki-page_contribution.tpl', '24.9', 0),
('a435a8ae24d7faa63e6495c88e378cc3', './templates/tiki-page_contribution_form.tpl', '24.9', 0),
('30742585905f5009b58c734f3d936737', './templates/tiki-pagehistory.tpl', '24.9', 0),
('f35a9bf38b40eaa4d5d4203bba4cd50f', './templates/tiki-payment-cclite.tpl', '24.9', 0),
('6d731626e59ffe0526b1fde96cf58d17', './templates/tiki-payment-israelpost.tpl', '24.9', 0),
('657ef37ed85a1d3b9f326ad3db7560dc', './templates/tiki-payment-list-past.tpl', '24.9', 0),
('f82ee842b5e6c459dde536f24ba2793a', './templates/tiki-payment-list.tpl', '24.9', 0),
('1a39ea0e12513ae133af78e82b0c52de', './templates/tiki-payment-paypal.tpl', '24.9', 0),
('0def70085b428ef8bdb788ec9f2f1f0c', './templates/tiki-payment-single.tpl', '24.9', 0),
('a600baf7485b6988448ed46fab07ec0e', './templates/tiki-payment-tikicredits.tpl', '24.9', 0),
('a0545c67ea6ac733e32dbebbb5eafcb0', './templates/tiki-payment-user.tpl', '24.9', 0),
('7f905597e9c69d6786bc1eacdd9c689c', './templates/tiki-payment.tpl', '24.9', 0),
('39a85ea3789da7d69372690bf4102a31', './templates/tiki-performance_stats.tpl', '24.9', 0),
('c55d6adf3a6236d2a892d6bc870aff3e', './templates/tiki-pick_avatar.tpl', '24.9', 0),
('ca063f543f8eaab3a00e91517acdd4cb', './templates/tiki-plugin_blocked.tpl', '24.9', 0),
('8703c5facbf1f44db2f090f69621ec1a', './templates/tiki-plugin_help.tpl', '24.9', 0),
('e7b5d94a6177636c0cf1b2b0629c821f', './templates/tiki-plugin_poll.tpl', '24.9', 0),
('f0b6def65637d946d8ef455168b63f90', './templates/tiki-plugin_sql.tpl', '24.9', 0),
('886efeb103a17e8196de8ddfcdd51273', './templates/tiki-pluginlist_experiment.tpl', '24.9', 0),
('9f73a8921d4743a0a585a423817d9bb2', './templates/tiki-plugins.tpl', '24.9', 0),
('9961e5d8735e54bb6ee67051f2232854', './templates/tiki-poll.tpl', '24.9', 0),
('6121a9b4415c6ce1e26890fd9c5ab417', './templates/tiki-poll_form.tpl', '24.9', 0),
('fa82fc43b8e71b5df9eb51920bc0a8c8', './templates/tiki-poll_results.tpl', '24.9', 0),
('20a3be16d0771bce3a18612f82bc7b17', './templates/tiki-poll_results_bar.tpl', '24.9', 0),
('5eec54023d804b01af785fabd48a2e1d', './templates/tiki-preference_translate.tpl', '24.9', 0),
('e00584c7aff0c7177e222ba9144c9a09', './templates/tiki-preview.tpl', '24.9', 0),
('f3c2320244279c3fa49832e310e00daa', './templates/tiki-print.tpl', '24.9', 0),
('1d165cd3d028a0d26df3fea58713084d', './templates/tiki-print_article.tpl', '24.9', 0),
('f811e4ac7443b2a21f8d817b185eef58', './templates/tiki-print_blog_post.tpl', '24.9', 0),
('d333db2e1d8ad58fecbb466181d0bf4a', './templates/tiki-print_forum_thread.tpl', '24.9', 0),
('96327a530de9817a28cd570223a4db3c', './templates/tiki-print_multi_pages.tpl', '24.9', 0),
('62a0c0853cb40f937adf80dddc952b63', './templates/tiki-print_pages.tpl', '24.9', 0),
('5f9711198b2c5d982aa3408b9ec8e8f3', './templates/tiki-quiz_edit.tpl', '24.9', 0),
('6057d9706d3c0c2a4bb6ed3bc1c8fef4', './templates/tiki-quiz_result_stats.tpl', '24.9', 0),
('416f68bf7a36a379f971f43232d0c469', './templates/tiki-quiz_stats.tpl', '24.9', 0),
('334c5ad460700fbdfb04b199c2eca341', './templates/tiki-quiz_stats_quiz.tpl', '24.9', 0),
('4e5f04517cb1b8818a12b12b02b9bfd2', './templates/tiki-ranking.tpl', '24.9', 0),
('1687f17f4ba5c7cb30e7f2bc244a294e', './templates/tiki-read_article.tpl', '24.9', 0),
('6598bc382f1b0c930487137b4941f2a1', './templates/tiki-received_articles.tpl', '24.9', 0),
('0a85dd26e16e7d7fd3ed67286b5e5c42', './templates/tiki-received_pages.tpl', '24.9', 0),
('5bf5b2c0caf62c3f2da8721cdd7c77a5', './templates/tiki-references.tpl', '24.9', 0),
('66997ad8ffeabb6a4718d27c0fd2227e', './templates/tiki-referer_stats.tpl', '24.9', 0),
('e09976c164c00b0b1915cf8e4824a060', './templates/tiki-register.tpl', '24.9', 0),
('78293210fed9ef831d67361902643389', './templates/tiki-register_site.tpl', '24.9', 0),
('9edf38b0ca8eee428f6df36d80dba783', './templates/tiki-remind_password.tpl', '24.9', 0),
('329b3a53c15c014cc7adcd2535faaaad', './templates/tiki-rename_page.tpl', '24.9', 0),
('9d0b2bf7208aca5650f30d5e11cb6a0d', './templates/tiki-report_direct_object_perms.tpl', '24.9', 0),
('2524cdac200842af98e40f9cca704bc0', './templates/tiki-rollback.tpl', '24.9', 0),
('40c819d8c9c8f40b4d265a524f1f1d04', './templates/tiki-search_count.tpl', '24.9', 0),
('da16e3c9f141650fa1da2647d0ffc9ed', './templates/tiki-search_replace.tpl', '24.9', 0),
('490d49de32ad593ee35114499f4edce0', './templates/tiki-search_stats.tpl', '24.9', 0),
('f1482122dbd6f17c7b8d24d51587f2f2', './templates/tiki-searchfacets.tpl', '24.9', 0),
('53fb0eb693dddad69438a35bfdf9efbd', './templates/tiki-searchindex.tpl', '24.9', 0),
('b7cefec6567c93f35914b7f63e49a5f6', './templates/tiki-searchindex_form.tpl', '24.9', 0),
('fe356730a244983384091004cbdba549', './templates/tiki-searchresults.tpl', '24.9', 0),
('c9b49e62b9160294a79b61832e2736a2', './templates/tiki-send_newsletters.tpl', '24.9', 0),
('a95618154119bb7aacfb8b0834550bb3', './templates/tiki-send_objects.tpl', '24.9', 0),
('7a724b5806f9342570c58dd73f6a9a63', './templates/tiki-share.tpl', '24.9', 0),
('3ff763aff90014c1be2668cb7115a32d', './templates/tiki-sheets.tpl', '24.9', 0),
('c4dd830c9b0a88d449f85e7457c9949e', './templates/tiki-sheets_listing.tpl', '24.9', 0),
('f230532c63d0976c0e7115c1fc98572e', './templates/tiki-shoutbox.tpl', '24.9', 0),
('7f6b5fc9c70e152bd381f98c3718dd05', './templates/tiki-show_page.tpl', '24.9', 0),
('c4beba673b433d1a86bc55559fe7d3f1', './templates/tiki-show_page_raw.tpl', '24.9', 0),
('581470f5c9c05936c3bfa5d9081f22df', './templates/tiki-socialnetworks.tpl', '24.9', 0),
('73ce5bdb80d1daef31cb6e02026bb8ef', './templates/tiki-socialnetworks_firstlogin.tpl', '24.9', 0),
('3e36a1e224562491c165ce088cf63239', './templates/tiki-socialnetworks_firstlogin_launcher.tpl', '24.9', 0),
('41895a72aede334054aa7a0f48dc9007', './templates/tiki-sqllog.tpl', '24.9', 0),
('4e31a761c9c6b26fc6126f45c3619ce9', './templates/tiki-stats.tpl', '24.9', 0),
('15e657e06b8a338f8fcd59fd3403491a', './templates/tiki-survey_stats.tpl', '24.9', 0),
('25e92de8fc8ce9e1a37f866098fe4458', './templates/tiki-survey_stats_survey.tpl', '24.9', 0),
('4d41606d9d0c13b759b113b3b70c2eb9', './templates/tiki-syslog.tpl', '24.9', 0),
('db7aa7e360e3ca0142021dcac5bc8bed', './templates/tiki-take_quiz.tpl', '24.9', 0),
('204c7ed47f8bf7928c02bb83790eb35b', './templates/tiki-take_survey.tpl', '24.9', 0),
('b56699266abb151f1ab0c66186915856', './templates/tiki-tests_edit.tpl', '24.9', 0),
('aabf66ca59f2cbfbac063f169ce09cf5', './templates/tiki-tests_list.tpl', '24.9', 0),
('6339bdfb72937a9f41906a7d5844e2c4', './templates/tiki-tests_menubar.tpl', '24.9', 0),
('5b4f153fa7485d542bf03333d755a512', './templates/tiki-tests_record.tpl', '24.9', 0),
('3561d89ce7edeb9075aa3720f8e3eb61', './templates/tiki-tests_replay.tpl', '24.9', 0),
('3442b55084d99e8b79981d20b6cadd89', './templates/tiki-tests_topbar.tpl', '24.9', 0),
('35c18115dfc8d07a7fa05ab9e9ef944a', './templates/tiki-theme_control.tpl', '24.9', 0),
('c2dd4c9485a6d9c39ea3ab00aed1a2d0', './templates/tiki-theme_control_objects.tpl', '24.9', 0),
('4d5bbf7c5422760b9eba5727851e07ff', './templates/tiki-theme_control_sections.tpl', '24.9', 0),
('306dbb39bfc50efc76e109ca0b3d376a', './templates/tiki-tracker_force_fill.tpl', '24.9', 0),
('36f978ddcfc2420737b22f990647614b', './templates/tiki-tracker_view_history.tpl', '24.9', 0),
('00b8b904a803b1b4ac9dbbc66596b9b1', './templates/tiki-upload_file.tpl', '24.9', 0),
('4ae12bc80ca79c52212a2d5051009db8', './templates/tiki-upload_file_progress.tpl', '24.9', 0),
('ca89ba67ebb744242947f0e7f1f3b5bc', './templates/tiki-user_assigned_modules.tpl', '24.9', 0),
('aedba84f3ed23d3944629534ef0234c9', './templates/tiki-user_bookmarks.tpl', '24.9', 0),
('9f554e12e522a4202008bdf6f15c0ca2', './templates/tiki-user_contacts_prefs.tpl', '24.9', 0),
('519f10b61f22c4ffbadfb86774c41d2e', './templates/tiki-user_cssmenu.tpl', '24.9', 0),
('bf16e7a6aa9fad15678a939d36004418', './templates/tiki-user_information.tpl', '24.9', 0),
('85a44649f740e2199c1d40ad6c889176', './templates/tiki-user_mailin.tpl', '24.9', 0),
('f227306c39e6abe7af65eb6da080e0f7', './templates/tiki-user_menu.tpl', '24.9', 0),
('4f6dcb46aa12a04dbc0ebf2824f38e1c', './templates/tiki-user_preferences.tpl', '24.9', 0),
('793ae55e5f34c0692b2b4c7aadee6f50', './templates/tiki-user_tasks.tpl', '24.9', 0),
('c94a1f13c77fc783628debed1aea33d3', './templates/tiki-user_tasks_edit.tpl', '24.9', 0),
('bc42973c57e70ea6d86afce38a594299', './templates/tiki-user_tasks_list.tpl', '24.9', 0),
('b81c11fba238fff7efd615d79df7e361', './templates/tiki-user_tasks_view.tpl', '24.9', 0),
('257f5547aa0b5a6de687be28bdbdf547', './templates/tiki-user_unified_details.tpl', '24.9', 0),
('dd0ed096a29f79892f5668f7c1e3c0c1', './templates/tiki-user_watches.tpl', '24.9', 0),
('b84a3368ee7e2bac3297cc9236e0a3bc', './templates/tiki-userfiles.tpl', '24.9', 0),
('fa937d8ffdcd2de59b8e01d6a81dd824', './templates/tiki-usermenu.tpl', '24.9', 0),
('b74ee8638587481faf70daed21ed71cf', './templates/tiki-userversions.tpl', '24.9', 0),
('2fc562e5c2c01889bc5f3e4ac4f54b97', './templates/tiki-view_articles-titleonly.tpl', '24.9', 0),
('8e0830c7218149e2b92b456c9d570446', './templates/tiki-view_articles.tpl', '24.9', 0),
('22c9cc709164e90426723530f69f5aff', './templates/tiki-view_banner.tpl', '24.9', 0),
('dea7ff0ed1f8919973c86f2859d28ae2', './templates/tiki-view_blog.tpl', '24.9', 0),
('8bed26c1053d58c608dc685da9b35aba', './templates/tiki-view_blog_post.tpl', '24.9', 0),
('2ce7d74c2b90aa40b228654002e302cb', './templates/tiki-view_cache.tpl', '24.9', 0),
('57989113bbc6a898c66b5f526607172a', './templates/tiki-view_faq.tpl', '24.9', 0),
('fd38984d56cf8dfb189afe77a37853f7', './templates/tiki-view_forum.tpl', '24.9', 0),
('782d2d796e694e9bca012f2abc73ef76', './templates/tiki-view_forum_thread.tpl', '24.9', 0),
('cf3d4f2a229ecfb3fb468475686daec2', './templates/tiki-view_sheets.tpl', '24.9', 0),
('290dbf811030a5ba9fccc1f6c29b86f4', './templates/tiki-view_sheets_menu.tpl', '24.9', 0),
('1e0b40b83e2c8c7189428827e5bc6b91', './templates/tiki-view_tracker.tpl', '24.9', 0),
('2a14b06f7c12d98f2f9f67633c64394b', './templates/tiki-view_tracker_item.tpl', '24.9', 0),
('ca78499ab033eda7618bfffab781ef16', './templates/tiki-view_tracker_more_info.tpl', '24.9', 0),
('652ed45c19d4bd85e66094c7785157c4', './templates/tiki-webdav-wiki.tpl', '24.9', 0),
('930680c6da83fa5a82721f0ca03362ca', './templates/tiki-webdav.tpl', '24.9', 0),
('d41f1bf529545684f38650562529a527', './templates/tiki-webmail.tpl', '24.9', 0),
('0a6ba838b93d3fab407e52203bff596a', './templates/tiki-webmail_contacts.tpl', '24.9', 0),
('de09967f608244fb6f4aee55cab8785a', './templates/tiki-wiki_structure_bar.tpl', '24.9', 0),
('6981e693292362a25375557cd411c119', './templates/tiki-wiki_topline.tpl', '24.9', 0),
('0ed61b6aed5b8ea046d20e427f6a734d', './templates/tiki-wizard_admin.tpl', '24.9', 0),
('1346f194e27568bedb204702416d367b', './templates/tiki-wizard_user.tpl', '24.9', 0),
('7f591864f35d30fb94b2dec6fe11aeec', './templates/tiki.tpl', '24.9', 0),
('6d61796871d8458f36a588ac1abcd543', './templates/tiki_full.tpl', '24.9', 0),
('a41f9401011df1c16d19640fa0bfb0ac', './templates/tracker/add_field.tpl', '24.9', 0),
('40939f79c4baf13127c4d3ddda04934b', './templates/tracker/clear.tpl', '24.9', 0),
('9d7589cdc43aba6cb55a8b68900073ac', './templates/tracker/clone_item.tpl', '24.9', 0),
('14eccd5a4ea138d6b549b098d5243c63', './templates/tracker/duplicate.tpl', '24.9', 0),
('4a59dc7ba079cb210f31fa4bf527a172', './templates/tracker/edit_field.tpl', '24.9', 0),
('80b31bcf43f1ad81627215d57f71ff1f', './templates/tracker/export.tpl', '24.9', 0),
('116df0f6d8186d78cf2a7a04b0ac9c77', './templates/tracker/export_fields.tpl', '24.9', 0),
('aa5b1020be088ca0a89b2f56838edd66', './templates/tracker/export_profile.tpl', '24.9', 0),
('70096c8877c50b6765b2918ec027330c', './templates/tracker/fetch_item_field.tpl', '24.9', 0),
('72574a69c4a0bdf258c971e85e974cea', './templates/tracker/import.tpl', '24.9', 0),
('1b5a6eebc228ad294484da7838b7195f', './templates/tracker/import_fields.tpl', '24.9', 0),
('58415b98ea2d8e6c18a36873d8ce7086', './templates/tracker/import_items.tpl', '24.9', 0),
('ff03bbe574ed4bb40cdae2f9bd2f2896', './templates/tracker/import_profile.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/tracker/index.php', '24.9', 0),
('b7fe06cf2ae559c99d99f6d05f6f327e', './templates/tracker/insert_item.tpl', '24.9', 0),
('681df2775257a63baafc0c1693245fd1', './templates/tracker/preview_item.tpl', '24.9', 0),
('c98d1055bc2f85336a5fae12abbea8a5', './templates/tracker/remove.tpl', '24.9', 0),
('42b9f0d10ccf548af80f8efe58a321a3', './templates/tracker/remove_fields.tpl', '24.9', 0),
('46c38c814fc50430b4d05e05dcac7e2d', './templates/tracker/remove_item.tpl', '24.9', 0),
('f2ffdc800dc7a25c5c4eeafbd9460620', './templates/tracker/replace.tpl', '24.9', 0),
('b9970a7f3295cc1dd79d8ed4f38be344', './templates/tracker/search_help.tpl', '24.9', 0),
('b04c94f60716012cece6306befcc81b4', './templates/tracker/select_tracker.tpl', '24.9', 0),
('b88f64d1d865b70119dfb833e429051e', './templates/tracker/update_item.tpl', '24.9', 0),
('8c38f79f5ac8c7500ddecd3532f58ac4', './templates/tracker/update_item_status.tpl', '24.9', 0),
('071cc8f4031fbd9df76d8dbb95e9a2f7', './templates/tracker/view.tpl', '24.9', 0),
('25c6df33c1dceee0b87d5805380506b2', './templates/tracker_actions.tpl', '24.9', 0),
('fe11a9abd054bd8c0d78a4c05c734126', './templates/tracker_calendar_over.tpl', '24.9', 0),
('a66e48e5d0fbadbdacee918004fb7529', './templates/tracker_error.tpl', '24.9', 0),
('6dfee5372c001066a984b239d0904489', './templates/tracker_filter.tpl', '24.9', 0),
('8e23391500a61f81474e3f589a9e29bf', './templates/tracker_input_field.tpl', '24.9', 0),
('ba8ada29e9ffb0fd52e5a2fecff3c72c', './templates/tracker_pretty_item.tpl', '24.9', 0),
('474443a343077b27c38a96327496cf3a', './templates/tracker_sort_input.tpl', '24.9', 0),
('4c27d8dab2a9545fb90381363cc2fdbd', './templates/tracker_status_input.tpl', '24.9', 0),
('d2b06cdfe51c48cc349a52bb7a0dcffc', './templates/tracker_sync/clone_remote.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/tracker_sync/index.php', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/tracker_todo/index.php', '24.9', 0),
('6d211da90a34704f752a31d92c51cb76', './templates/tracker_todo/view.tpl', '24.9', 0),
('ebb8c33f73e178752fae1351629a3c1f', './templates/tracker_validator.tpl', '24.9', 0),
('15955c4a4cdb0c2e2ecf2164cb31fb53', './templates/trackerinput/articles.tpl', '24.9', 0),
('05bae6666d310a22d3345c0d1f4cd102', './templates/trackerinput/autoincrement.tpl', '24.9', 0),
('4b01ecaa361f382296d0de14d60fbd0f', './templates/trackerinput/calendaritem.tpl', '24.9', 0),
('f06165b419ea11f96846ad648984373d', './templates/trackerinput/category.tpl', '24.9', 0),
('8c0c5c073da7ccfacde8ef56dc59f695', './templates/trackerinput/checkbox.tpl', '24.9', 0),
('c907617a4f2743a7896bcd5b297ec3ec', './templates/trackerinput/countryselector.tpl', '24.9', 0),
('593cb7c5e991d98daa50b4856fe3c934', './templates/trackerinput/currency.tpl', '24.9', 0),
('85c283acf699ebf7bf89bb2a269b8caf', './templates/trackerinput/datetime.tpl', '24.9', 0),
('350a90038676393a1f4e8a98e8c630ee', './templates/trackerinput/dropdown.tpl', '24.9', 0),
('fd591810f0dcfcb1676537a10a0b9a39', './templates/trackerinput/duration.tpl', '24.9', 0),
('d78451fc8a2a4cab81fb55c5b3f3c5f1', './templates/trackerinput/email.tpl', '24.9', 0),
('494da1b513db6da9b4cf5ebbb58f047e', './templates/trackerinput/file.tpl', '24.9', 0),
('b3f60c01db8fc23b296b61a11cf193c8', './templates/trackerinput/files.tpl', '24.9', 0),
('161b556bb9709d0129739859cbdf3618', './templates/trackerinput/freetags.tpl', '24.9', 0),
('7f283d0f6b65b27fc0acb15c4c74940f', './templates/trackerinput/groupselector.tpl', '24.9', 0),
('3217bcb509857ea3289b281d6b4b8746', './templates/trackerinput/icon.tpl', '24.9', 0),
('35878ea6eec2efc9860516508da3cefe', './templates/trackerinput/image.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/trackerinput/index.php', '24.9', 0),
('7ac028e7d7d03af24d27727ef2a1535b', './templates/trackerinput/ip.tpl', '24.9', 0),
('44060e8d99f33ca9b5b273f275bfc60d', './templates/trackerinput/itemlink.tpl', '24.9', 0),
('ef6dcd6b92c56cee28d4b990fb3d2e70', './templates/trackerinput/itemlink_selector.tpl', '24.9', 0),
('62853376b2aee4188077f5322c37056d', './templates/trackerinput/kaltura.tpl', '24.9', 0),
('13f6c510808aa630c2df8827fab117a0', './templates/trackerinput/language.tpl', '24.9', 0),
('239b948ba91ce2d00a37427c42c894b7', './templates/trackerinput/layout_flat.tpl', '24.9', 0),
('a493b064b6810ae5940c53f77823b4bf', './templates/trackerinput/layout_tab.tpl', '24.9', 0),
('43b5635340fc3a346917be4af915635a', './templates/trackerinput/location.tpl', '24.9', 0),
('4c93b93eef2c1d732586b94e25ed2943', './templates/trackerinput/numeric.tpl', '24.9', 0),
('0c876fdea91788fe09c5c16dac7df62e', './templates/trackerinput/pageselector.tpl', '24.9', 0),
('51b1f685690390de858d339a100864ac', './templates/trackerinput/rating.tpl', '24.9', 0),
('72611af50c115c9280da05bca8719f6f', './templates/trackerinput/relation.tpl', '24.9', 0),
('38c25708d69ea30340dedb8dd1a7d990', './templates/trackerinput/showtikiorg.tpl', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('9337c477d610373d103e0a25da441bc7', './templates/trackerinput/statictext.tpl', '24.9', 0),
('e9b21c8c46cf888b7d0c8eaefad43d65', './templates/trackerinput/status.tpl', '24.9', 0),
('07331caf85531b3110c14360bc3fab84', './templates/trackerinput/text.tpl', '24.9', 0),
('6ccd96483527f28b2f43d8ddf0b0015c', './templates/trackerinput/textarea.tpl', '24.9', 0),
('4f6a09f7c84521d47a6eb269d3aebeb7', './templates/trackerinput/url.tpl', '24.9', 0),
('9f9c0b8098e0f3bfb6a40b1e6da9c4bb', './templates/trackerinput/userpreference.tpl', '24.9', 0),
('80e3a8b3c927d82e90545008355e4e28', './templates/trackerinput/userselector_grouped.tpl', '24.9', 0),
('f7691cf5e4080e8bb95c30d0c1f34e01', './templates/trackerinput/usersubscription.tpl', '24.9', 0),
('2403261a554d935a9cd99d4946e4d697', './templates/trackerinput/wiki.tpl', '24.9', 0),
('ee061f6b0b1c83812224891b6b82602f', './templates/trackeroutput/articles.tpl', '24.9', 0),
('32472c3948427699485ce490116f6bc0', './templates/trackeroutput/computed.tpl', '24.9', 0),
('ca68c576c4311053b050c35581f40b34', './templates/trackeroutput/email_folder.tpl', '24.9', 0),
('bb9238bc2852ab3db95268adcf82ae0a', './templates/trackeroutput/email_single_folder.tpl', '24.9', 0),
('013bb12adb2d542aa7bcf1c314f0c66c', './templates/trackeroutput/files_googleviewer.tpl', '24.9', 0),
('595acb64467050742ee2fe773c2c7bd7', './templates/trackeroutput/files_table.tpl', '24.9', 0),
('37b616c0abfa495b551c667ddb146efd', './templates/trackeroutput/freetags.tpl', '24.9', 0),
('e5bfeb3ba4585da72f4a8c39a0eeec8f', './templates/trackeroutput/icon.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/trackeroutput/index.php', '24.9', 0),
('baab538ffd9de6ebeba4191cb38d5035', './templates/trackeroutput/itemslist.tpl', '24.9', 0),
('8d6d1c152eb8182c427dd46328cd0d4d', './templates/trackeroutput/language.tpl', '24.9', 0),
('f107d672753a04f17dbe95dce0628a90', './templates/trackeroutput/layout_flat.tpl', '24.9', 0),
('dd47f72a6558e925084988f87a63da4b', './templates/trackeroutput/layout_tab.tpl', '24.9', 0),
('366d5561fe1057aef3e622e6590e64ee', './templates/trackeroutput/location.tpl', '24.9', 0),
('ab982f2bdc49b8df4233e2ca0bbb5f5d', './templates/trackeroutput/numeric.tpl', '24.9', 0),
('556ef8eb39cc2ecd6482f049d3ae20a5', './templates/trackeroutput/popup.tpl', '24.9', 0),
('46e1a1c8f78a6da0f915996bcb5a3d53', './templates/trackeroutput/rating.tpl', '24.9', 0),
('963314bf5a6f0b762b2fd303506a4810', './templates/trackeroutput/relation.tpl', '24.9', 0),
('ee9c066b425aa146f9aa829c1e8effb1', './templates/trackeroutput/text_history.tpl', '24.9', 0),
('ab3c883e93026ed1cad7ef146f4ca2e1', './templates/trackeroutput/usergroups.tpl', '24.9', 0),
('edf88a3781cfb5b5bcfda8a07fea25f6', './templates/trackeroutput/usersubscription.tpl', '24.9', 0),
('122fca6f178a897794a5857dc5e8abe0', './templates/translated-lang.tpl', '24.9', 0),
('209a2d5b8267f297100ba4c22e750201', './templates/translation/detach.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/translation/index.php', '24.9', 0),
('82a7fb4510969639b278ddd66845cb73', './templates/translation/manage.tpl', '24.9', 0),
('390f2d175d3af07c02de8f6db580d817', './templates/user/email_wikipage.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/user/index.php', '24.9', 0),
('142934301089277cd2634cbebf617e26', './templates/user/info.tpl', '24.9', 0),
('7ac85579b7a13ce04908310a25dc380f', './templates/user/manage_groups.tpl', '24.9', 0),
('ff43f283ea4a2607b6ffa3b720f6f936', './templates/user/register.tpl', '24.9', 0),
('2e17ac1077ea64e721c8c78eeb3b5dd4', './templates/user/remove_users.tpl', '24.9', 0),
('90bc0e04eb48aed7c9f3af28d0a73d39', './templates/user/send_message.tpl', '24.9', 0),
('f4253b4ab456acda28eb2d271f710eea', './templates/user/upload_avatar.tpl', '24.9', 0),
('b4491ce9c1d273df56afec1f72d32236', './templates/user_conditions/age_validation.tpl', '24.9', 0),
('b36bff80b919b79c5a451c97250a6cdd', './templates/user_conditions/approval.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/user_conditions/index.php', '24.9', 0),
('bfdbfb506d28a4ec259bcacf63649439', './templates/user_registration.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/vimeo/index.php', '24.9', 0),
('b74e7c1deb627fb2b8bbfdd5164bd2fd', './templates/vimeo/jquery_upload.tpl', '24.9', 0),
('d7bafdd9ce29dff0755ac091525200c9', './templates/vimeo/upload.tpl', '24.9', 0),
('51955ccf551a1b23486ed0cd5abd5c60', './templates/vimeo/view.tpl', '24.9', 0),
('554c06f6d097d9cefd8f428317001e89', './templates/wiki-discussion.tpl', '24.9', 0),
('4e2ce80bf092445cc9c97be617e36cbc', './templates/wiki-plugins/error_tracker.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/wiki-plugins/index.php', '24.9', 0),
('c21823f54908854dcc80ae98b981603d', './templates/wiki-plugins/trackercalendar.tpl', '24.9', 0),
('389ee4b98dd8b252467ae2a8237f2dfa', './templates/wiki-plugins/wikiplugin_addfreetag.tpl', '24.9', 0),
('64bcd405bc3d5f201852db69d377a3f9', './templates/wiki-plugins/wikiplugin_addreference.tpl', '24.9', 0),
('9572648e0804f42c86c15e342b262f6d', './templates/wiki-plugins/wikiplugin_addrelation.tpl', '24.9', 0),
('99e088c0b911b01dc6aa936f2594ef15', './templates/wiki-plugins/wikiplugin_addtocart.tpl', '24.9', 0),
('3625b5367812e18acb8b50766fb5edf7', './templates/wiki-plugins/wikiplugin_adjustinventory.tpl', '24.9', 0),
('9071e0da7c5c9f6b1da02799ed6d0a8e', './templates/wiki-plugins/wikiplugin_appframe_mapcontrol.tpl', '24.9', 0),
('4f26b5be654cc9beb4ddee41e9a05ea5', './templates/wiki-plugins/wikiplugin_benchmark.tpl', '24.9', 0),
('5c5b5515e90b3341c7a2f458367a718e', './templates/wiki-plugins/wikiplugin_bigbluebutton.tpl', '24.9', 0),
('4ae2c07a09b2788f176e4aa7dc3a6047', './templates/wiki-plugins/wikiplugin_bigbluebutton_create.tpl', '24.9', 0),
('153fd15da2a82a1cbf4cd1efa3a9670c', './templates/wiki-plugins/wikiplugin_bigbluebutton_view_recordings.tpl', '24.9', 0),
('7667739622ecc0878b9cb5346fc727be', './templates/wiki-plugins/wikiplugin_bloglist.tpl', '24.9', 0),
('45dfe0d9ace5a347c16be730e650289d', './templates/wiki-plugins/wikiplugin_categorytransition.tpl', '24.9', 0),
('fea9a7bd94e111dd25189780d8552da9', './templates/wiki-plugins/wikiplugin_catorphans.tpl', '24.9', 0),
('e46b847e408ba9d8a0fcb2beb2377421', './templates/wiki-plugins/wikiplugin_cclite.tpl', '24.9', 0),
('0d75be2bda9fe56d486a4c76b4c4308d', './templates/wiki-plugins/wikiplugin_coil.tpl', '24.9', 0),
('ebd44dce03cbe35bbb4d01936a2f353d', './templates/wiki-plugins/wikiplugin_colobox.tpl', '24.9', 0),
('3a7210a82d692eb58620c24c156d1a1f', './templates/wiki-plugins/wikiplugin_comment.tpl', '24.9', 0),
('54ceafef1adc9a3b76f35c10a68c5a75', './templates/wiki-plugins/wikiplugin_convene.tpl', '24.9', 0),
('275f0fe382597d238542efd0d68bfc94', './templates/wiki-plugins/wikiplugin_datachannel.tpl', '24.9', 0),
('fd39374351fed3ff320f0b5ea40f169a', './templates/wiki-plugins/wikiplugin_diagram.tpl', '24.9', 0),
('8f49f4949ecf0b0c7e5daff1948d89d5', './templates/wiki-plugins/wikiplugin_events.tpl', '24.9', 0),
('74d245470b4077830daec722c51e5b4d', './templates/wiki-plugins/wikiplugin_favorite.tpl', '24.9', 0),
('1b8f9276825d408e1ae5b68737965c55', './templates/wiki-plugins/wikiplugin_files.tpl', '24.9', 0),
('9f138852f781679b426a60cb6234bb83', './templates/wiki-plugins/wikiplugin_footnote.tpl', '24.9', 0),
('65cb2a135b75086c839ed20e544ef9b3', './templates/wiki-plugins/wikiplugin_footnotearea.tpl', '24.9', 0),
('26f0c0f9e52e1e09e130f62acb298ca3', './templates/wiki-plugins/wikiplugin_freetagged.tpl', '24.9', 0),
('a3792a4b115ca44cbaf88005a0c39d8f', './templates/wiki-plugins/wikiplugin_friend.tpl', '24.9', 0),
('94beede4568ff061b470a086aa8c5459', './templates/wiki-plugins/wikiplugin_ftp.tpl', '24.9', 0),
('d5d0beb87039696a6b6bfdc2ee048c87', './templates/wiki-plugins/wikiplugin_fullwidthtitle.tpl', '24.9', 0),
('1b4c1975470f1fa444c5803f32bac987', './templates/wiki-plugins/wikiplugin_galleriffic.tpl', '24.9', 0),
('b7948384d30bbf8bd1194870a9b32220', './templates/wiki-plugins/wikiplugin_ganttchart.tpl', '24.9', 0),
('676d18770d7768c71d5c108afc8ef43f', './templates/wiki-plugins/wikiplugin_grouplist.tpl', '24.9', 0),
('a0ac612c3d93629349b76a70b12e8dad', './templates/wiki-plugins/wikiplugin_groupstat.tpl', '24.9', 0),
('d24bfeb473a4dde57d69cd818db431db', './templates/wiki-plugins/wikiplugin_invite.tpl', '24.9', 0),
('92cf7eb5a90d1b1f1dd9058ae16b487d', './templates/wiki-plugins/wikiplugin_kaltura.tpl', '24.9', 0),
('09c261fdd278047bf210dc98a536eba9', './templates/wiki-plugins/wikiplugin_kanban.tpl', '24.9', 0),
('97d0255286dd0bf00452ca0b1b0a83c5', './templates/wiki-plugins/wikiplugin_like.tpl', '24.9', 0),
('a2b822da1d00a41e969ad4eb88a7600d', './templates/wiki-plugins/wikiplugin_listexecute.tpl', '24.9', 0),
('ac0956cb168a1fddf6ac74ab686897c4', './templates/wiki-plugins/wikiplugin_listpage_namesanddescription.tpl', '24.9', 0),
('26accab62f3558db25c12b435e6f2da5', './templates/wiki-plugins/wikiplugin_listpagenames.tpl', '24.9', 0),
('46cc282d26dd30e51f9a75023a5b6d81', './templates/wiki-plugins/wikiplugin_localfiles.tpl', '24.9', 0),
('e0a3e7900827576b3e8d9eaeceff3343', './templates/wiki-plugins/wikiplugin_mail.tpl', '24.9', 0),
('3fa3da1d8f25cef74fc576d998f2b2bd', './templates/wiki-plugins/wikiplugin_mediaplayer_pdfjs.tpl', '24.9', 0),
('c95e457706b944c90fcc89a5c6b91143', './templates/wiki-plugins/wikiplugin_memberlist.tpl', '24.9', 0),
('600cdd273473ba80ae59ed3b3faccae8', './templates/wiki-plugins/wikiplugin_memberpayment.tpl', '24.9', 0),
('52058ca9a02e495f34815b80b2ced529', './templates/wiki-plugins/wikiplugin_paypal.tpl', '24.9', 0),
('f08b9ef5f934700abebef1a41a6c0720', './templates/wiki-plugins/wikiplugin_pivottable.tpl', '24.9', 0),
('332e513c0ffb25cb89f39abba76dde02', './templates/wiki-plugins/wikiplugin_playscorm.tpl', '24.9', 0),
('5bc659346601efe9bd72491ba78dd043', './templates/wiki-plugins/wikiplugin_preference.tpl', '24.9', 0),
('75cc80fa6d67ed543ead86c7b00db306', './templates/wiki-plugins/wikiplugin_preview.tpl', '24.9', 0),
('c4549705ed9bf645d90aa195e47828f2', './templates/wiki-plugins/wikiplugin_profile.tpl', '24.9', 0),
('cd141b78c7912ebed24e02effbe3778e', './templates/wiki-plugins/wikiplugin_proposal.tpl', '24.9', 0),
('9d803f2d0059a377758c50be2d9cbc53', './templates/wiki-plugins/wikiplugin_quote.tpl', '24.9', 0),
('3c1ec8ab2b0f6e41b3a75e70bda10b9c', './templates/wiki-plugins/wikiplugin_relations.tpl', '24.9', 0),
('56ae439a1c520ae49612210e5ccc4762', './templates/wiki-plugins/wikiplugin_rss.tpl', '24.9', 0),
('743276c5caa60eb9517225dd130b25bc', './templates/wiki-plugins/wikiplugin_shopperinfo.tpl', '24.9', 0),
('77b14d7381272413354a64639537b774', './templates/wiki-plugins/wikiplugin_sign.tpl', '24.9', 0),
('38f2160b7b38c11cb4ec1e82ecf877fb', './templates/wiki-plugins/wikiplugin_signature.tpl', '24.9', 0),
('93e26f537782384d1358ee8fe2ff8efe', './templates/wiki-plugins/wikiplugin_snarf.tpl', '24.9', 0),
('579d72cedec6f9e62442046c67e155ae', './templates/wiki-plugins/wikiplugin_stat.tpl', '24.9', 0),
('f067c559644962c315077b8d40e7eb72', './templates/wiki-plugins/wikiplugin_subscribegroup.tpl', '24.9', 0),
('9f6a8141150feb6b693b3c77630d9531', './templates/wiki-plugins/wikiplugin_subscribegroups.tpl', '24.9', 0),
('8e374f9d71aa56c098ac168f69b7ad91', './templates/wiki-plugins/wikiplugin_subscribenewsletter.tpl', '24.9', 0),
('df13683ded376c7e91c5dd1d8cfb9c99', './templates/wiki-plugins/wikiplugin_tabs.tpl', '24.9', 0),
('37b28d58503f6e3191030d7940eacfc4', './templates/wiki-plugins/wikiplugin_totp.tpl', '24.9', 0),
('d8607fcacaebe0200fb40ac98ad52d42', './templates/wiki-plugins/wikiplugin_totp_scanner.tpl', '24.9', 0),
('97888f1d0bef0f0b1ea05667ae1c80a3', './templates/wiki-plugins/wikiplugin_tour_template.tpl', '24.9', 0),
('dcfd280a09e0339894b12668e53236e2', './templates/wiki-plugins/wikiplugin_trackerfilter.tpl', '24.9', 0),
('30ea8008faf97c1dffa2f01a71070add', './templates/wiki-plugins/wikiplugin_trackerlist.tpl', '24.9', 0),
('09c5a748648977b640d599b34160d692', './templates/wiki-plugins/wikiplugin_trackerprefill.tpl', '24.9', 0),
('62bd0c58a04a0092fc68600ae198fa99', './templates/wiki-plugins/wikiplugin_trackerstat.tpl', '24.9', 0),
('5aa8d5751607801200bd89c3fd782c1a', './templates/wiki-plugins/wikiplugin_trackertimeline.tpl', '24.9', 0),
('772f7a522b23fe9c49e58e66fdfaca80', './templates/wiki-plugins/wikiplugin_trade.tpl', '24.9', 0),
('b1834ceec629864cfc89380157f5d36a', './templates/wiki-plugins/wikiplugin_vote.tpl', '24.9', 0),
('58db85b3f45dbe04a150ba0e1e946d79', './templates/wiki-plugins/wikiplugin_xmlupdate.tpl', '24.9', 0),
('97c263ce453c543adbb78ce292c4df57', './templates/wiki-plugins/wikiplugin_xmpp.tpl', '24.9', 0),
('a4b65ecaeccc4872d8bc00e711683aae', './templates/wiki/get_page.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/wiki/index.php', '24.9', 0),
('ec6139aa8c2a62b9da5781390381fd26', './templates/wiki/regenerate_slugs.tpl', '24.9', 0),
('439a75299c57bd6e346ceab772cf5e06', './templates/wiki/remove_pages.tpl', '24.9', 0),
('f187b147d36e8963936ac89d455c44d0', './templates/wiki_authors.tpl', '24.9', 0),
('7f207cfed15ecab9a8a924102b312054', './templates/wiki_edit.tpl', '24.9', 0),
('3d377a8dbf1ead457c307aadb47efe29', './templates/wiki_edit_actions.tpl', '24.9', 0),
('22666b80299ccb45f3f168c319828ca7', './templates/wiki_edit_with_preview.tpl', '24.9', 0),
('3c4232a560866a4f2bd00924f804d476', './templates/wizard/admin_advanced.tpl', '24.9', 0),
('e7feff197d0951a3ff70a2e829a20c08', './templates/wizard/admin_auto_toc.tpl', '24.9', 0),
('f8c8de5ac661e17a396bd7573f4c0152', './templates/wizard/admin_category.tpl', '24.9', 0),
('7ba12215c4b546708eaf7a0b8954638d', './templates/wizard/admin_community.tpl', '24.9', 0),
('862a50a7babb5d56e26479ddb35e6ed2', './templates/wizard/admin_date_time.tpl', '24.9', 0),
('4eed7cf038e626897ba22a6f0531758a', './templates/wizard/admin_editor_type.tpl', '24.9', 0),
('ab0442a34210f0f8b9fa619877dcd392', './templates/wizard/admin_features.tpl', '24.9', 0),
('237aaaf7a9c4c7d3a562fe5fb5240eaa', './templates/wizard/admin_files.tpl', '24.9', 0),
('2d369f46cc3cd2dc49c725b2b58b661f', './templates/wizard/admin_files_storage.tpl', '24.9', 0),
('8c958a1c6846628ac365bf232ae6f9c1', './templates/wizard/admin_language.tpl', '24.9', 0),
('1796877c0a554c6ba4067704feb48f39', './templates/wizard/admin_login.tpl', '24.9', 0),
('6d14eb398abe9f2cd384756d4e73d89b', './templates/wizard/admin_look_and_feel.tpl', '24.9', 0),
('149425e9084e900902f8cf4615050a40', './templates/wizard/admin_namespace.tpl', '24.9', 0),
('ecf734f44b42ab671812f4bccb986a0a', './templates/wizard/admin_search.tpl', '24.9', 0),
('a8971b9c0a9b287fdb7aa8f2f83437c6', './templates/wizard/admin_structures.tpl', '24.9', 0),
('57e3074b316b1d5be59fe0dd671212d1', './templates/wizard/admin_text_area.tpl', '24.9', 0),
('612dbc4dfca14a2d01aabb3ff4034556', './templates/wizard/admin_wiki.tpl', '24.9', 0),
('dd6655cb71d8edbfe34d6d9911b80fb0', './templates/wizard/admin_wizard.tpl', '24.9', 0),
('f5342aad1af8e639323c363698c376f5', './templates/wizard/admin_wizard_completed.tpl', '24.9', 0),
('17edc15b9e0c71bf89a4ea951e178992', './templates/wizard/admin_wysiwyg.tpl', '24.9', 0),
('3e34625df87b9010b4f569aab5931de6', './templates/wizard/changes_doc_page_iframe.tpl', '24.9', 0),
('9c41556087889a92d8cef1b09deddfb7', './templates/wizard/changes_new_in_13.tpl', '24.9', 0),
('7cf06c4feb047307eceb7e7bde308d91', './templates/wizard/changes_new_in_14.tpl', '24.9', 0),
('5ad5c2b03190df138d747d73e47c2c62', './templates/wizard/changes_new_in_15.tpl', '24.9', 0),
('64699b90b5d85407e8b64dba819934e2', './templates/wizard/changes_new_in_16.tpl', '24.9', 0),
('7dd66aac053ddd02cc0c6fd01be1eb6c', './templates/wizard/changes_new_in_17.tpl', '24.9', 0),
('e0ed05dc25bacbb6eb5fd58eb7e22314', './templates/wizard/changes_new_in_18.tpl', '24.9', 0),
('13e2125ef3298eef97c451f7ceb1a84f', './templates/wizard/changes_new_in_19.tpl', '24.9', 0),
('1ba7e4904f5b0004c4855322e309daf3', './templates/wizard/changes_new_in_20.tpl', '24.9', 0),
('4830f1055175a1ae00b3691f3d919ab8', './templates/wizard/changes_new_in_21.tpl', '24.9', 0),
('7c2c6670bbfa0cb6c6412ec7d093f577', './templates/wizard/changes_new_in_22.tpl', '24.9', 0),
('960569dfe205c201cd7225c2cda6e284', './templates/wizard/changes_new_in_23.tpl', '24.9', 0),
('869bc93498d31b58f866f4f3d6a8c036', './templates/wizard/changes_new_in_24.tpl', '24.9', 0),
('9aca96d3b856cd533b9c3b8c2136b1e4', './templates/wizard/changes_novice_admin_assistance.tpl', '24.9', 0),
('fcf18093f39c73b45bba9da34d33c78e', './templates/wizard/changes_others.tpl', '24.9', 0),
('b6076c62d64cee5beff7c47311b6885e', './templates/wizard/changes_permissions_and_logs.tpl', '24.9', 0),
('c3cd02fa02388d13df22e277ab61123e', './templates/wizard/changes_send_feedback.tpl', '24.9', 0),
('295535f3a325e4cbb44d32b4337dfc66', './templates/wizard/changes_trackers.tpl', '24.9', 0),
('dc886aa216297ac3b6c06873b388505a', './templates/wizard/changes_ui.tpl', '24.9', 0),
('fe3096b874e9f90a2ed51a6aaff5e394', './templates/wizard/changes_wizard_completed.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/wizard/index.php', '24.9', 0),
('07dfd301ca0fc1d78d7a6f2d099335b3', './templates/wizard/profiles_completed.tpl', '24.9', 0),
('20484e5bc9af0f1ea924346645f8d833', './templates/wizard/profiles_demo_cases_in_project_management.tpl', '24.9', 0),
('880da3b90821bcd0a75c1077c1dcced7', './templates/wizard/profiles_demo_common_confs.tpl', '24.9', 0),
('9790846384ddac0b31b085c1cee2e57f', './templates/wizard/profiles_demo_highly_specialized_confs.tpl', '24.9', 0),
('aa4ef96eedb7665f508eaa4cc515baa5', './templates/wizard/profiles_demo_interesting_use_cases.tpl', '24.9', 0),
('7d0522f74af41481036b14f37c057d22', './templates/wizard/profiles_demo_more_advanced_confs.tpl', '24.9', 0),
('932efeb6d8311b5c352bf67e290fbf29', './templates/wizard/profiles_demo_other_interesting_use_cases.tpl', '24.9', 0),
('bb3ccf363e1b577fff4af7fd617865f7', './templates/wizard/profiles_featured_site_confs.tpl', '24.9', 0),
('c8049a0dd653a46c915e5d25528a7a28', './templates/wizard/profiles_useful_admin_confs.tpl', '24.9', 0),
('b2d9733d795283b000d4aa54e4e72d49', './templates/wizard/profiles_useful_changes_in_display.tpl', '24.9', 0),
('39e4f370b0f5bb9d8a726d6c35783843', './templates/wizard/profiles_useful_micro_confs.tpl', '24.9', 0),
('eecaf2ee33d2609e818c86c407ddc542', './templates/wizard/profiles_useful_new_tech_confs.tpl', '24.9', 0),
('d9624b30a79391e64331e4e940ce13ab', './templates/wizard/user_dummy1.tpl', '24.9', 0),
('196c650dc1138558f7dd2f13598b5291', './templates/wizard/user_dummy2.tpl', '24.9', 0),
('d488d7d6f265cc5cb0c644b6758a3ded', './templates/wizard/user_dummy3.tpl', '24.9', 0),
('a1776672f7c84d37173901231699828e', './templates/wizard/user_preferences_info.tpl', '24.9', 0),
('d48402a1a983fcd8a2ed93ccb0e9263c', './templates/wizard/user_preferences_notifications.tpl', '24.9', 0),
('91684c2ca2ea75c542a614a911d4fd76', './templates/wizard/user_preferences_params.tpl', '24.9', 0),
('7b02c957f2f646d60d4d7b29940996aa', './templates/wizard/user_preferences_reports.tpl', '24.9', 0),
('8573ee6c3e5ca8c9e253a00b0e42233b', './templates/wizard/user_tracker.tpl', '24.9', 0),
('632ba93e0f05f6d904c9914404943a51', './templates/wizard/user_wizard.tpl', '24.9', 0),
('0f367fc031f15bba247b60652e966837', './templates/wizard/user_wizard_completed.tpl', '24.9', 0),
('e9b075856001a3274d629eabce89cfa3', './templates/wizard/wizard_bar_admin.tpl', '24.9', 0),
('5ad8d3aefe28486b3d494594efa26de3', './templates/wizard/wizard_bar_user.tpl', '24.9', 0),
('0387e2229295e5ae9ac8e2a97f0db7fb', './templates/workspace/add_template.tpl', '24.9', 0),
('602d7829c6dafdeca6084bc8eb304914', './templates/workspace/advanced_edit.tpl', '24.9', 0),
('c7dfdf3467e2780eb70796af73826c61', './templates/workspace/create.tpl', '24.9', 0),
('7395c61eefe1158056fb9ad6278e5c3d', './templates/workspace/edit_content.tpl', '24.9', 0),
('14ac912e089987e3d2c5fdb182fae638', './templates/workspace/edit_template.tpl', '24.9', 0),
('715fd1d4f32e00c4b9558e61e8314349', './templates/workspace/index.php', '24.9', 0),
('9b61a0bd45122d99f25b2d15174947ed', './templates/workspace/list_templates.tpl', '24.9', 0),
('e22b657eab33735181c5902eda8f925a', './templates/workspace/select_permissions.tpl', '24.9', 0),
('a2a5f7b4f07d1ea4812acbf27677bd4e', './tests/index.php', '24.9', 0),
('01350b71d2c6ce68fc87e660cca32ab6', './themes/amelia/css/amelia.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/amelia/css/index.php', '24.9', 0),
('94be1f1d9655c4d1fff1ae1bccabcf0a', './themes/amelia/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/amelia/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/amelia/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/amelia/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/amelia/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/amelia/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/amelia/templates/index.php', '24.9', 0),
('f6d2efc6909c9496fafac5c444fb79de', './themes/base_files/css/feature/adminui.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/base_files/css/feature/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/base_files/css/index.php', '24.9', 0),
('29411e4dec87e4eb279f065312e80ef6', './themes/base_files/css/newsletter.css', '24.9', 0),
('141cb16d34db4f502fa5c11447855538', './themes/base_files/css/printpdf.css', '24.9', 0),
('22b5861daa319a95da00233d890ec01c', './themes/base_files/css/printqueries.css', '24.9', 0),
('8ec11e68115a216b5aac4b2b81574560', './themes/base_files/css/theme-customizer.css', '24.9', 0),
('9bf68385ae43abcbf546aaf1d368bda4', './themes/base_files/css/tiki_base.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/base_files/favicons/index.php', '24.9', 0),
('2c7a0e719139dc516b7bf92fac31f1e6', './themes/base_files/feature_css/admin.css', '24.9', 0),
('a80453c0369281c434d7712facb9addb', './themes/base_files/feature_css/calendar-print.css', '24.9', 0),
('5070ed91e3c7491b56d5932c3f07b69c', './themes/base_files/feature_css/calendar.css', '24.9', 0),
('d8ccd1ca742637642f82d4841c7a72b7', './themes/base_files/feature_css/codemirror_mode_tiki.css', '24.9', 0),
('e0f02e4ed440be8a499408fd4390ed5a', './themes/base_files/feature_css/codemirror_tiki.css', '24.9', 0),
('33710b5c1feabdab125cd3eb3de501d5', './themes/base_files/feature_css/galleriffic.css', '24.9', 0),
('b3695a5f550b6c1012ab2e63730c1b0f', './themes/base_files/feature_css/index.php', '24.9', 0),
('e8e1dbb11f16f76b2111ab9d4cf9e9fb', './themes/base_files/feature_css/jscalendar.css', '24.9', 0),
('f8a384f2321ad581495abb8d489a7b90', './themes/base_files/feature_css/svg-edit-draw.css', '24.9', 0),
('922f831e1d67025884a1147bfd934595', './themes/base_files/feature_css/wikiplugin-ganttchart.css', '24.9', 0),
('5630919994f66a7c8b55497e4aec08fb', './themes/base_files/feature_css/wikiplugin-signature.css', '24.9', 0),
('7a6170f41f02444f31a3e358a399ac6e', './themes/base_files/feature_css/wizards.css', '24.9', 0),
('f4b9ca3c0c284721bb49b15b4ce9d897', './themes/base_files/iconsets/default.php', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './themes/base_files/iconsets/index.php', '24.9', 0),
('5d3fcca0bba9075ac1ded4e53341a67e', './themes/base_files/iconsets/legacy.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/base_files/index.php', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './themes/base_files/other/index.php', '24.9', 0),
('34dc67dbc8dc1ddb4440ce1eb209c190', './themes/base_files/other/integrator/default.css', '24.9', 0),
('596dc93bed0979b8722c6a8d95e0652d', './themes/base_files/other/integrator/doxygen.css', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/base_files/other/integrator/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/base_files/scss/feature/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/base_files/scss/index.php', '24.9', 0),
('b56633dfdbf10ac506b4a0572ae74d74', './themes/business/css/business.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/business/css/index.php', '24.9', 0),
('909be7adab738cf88477d78afdb723ae', './themes/business/css/newsletter.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/business/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/business/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/business/images/index.php', '24.9', 0),
('5f466361f1e5313bbaa757cad13a7e97', './themes/business/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/business/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/business/templates/index.php', '24.9', 0),
('79d9f5e153aab8e591979449bbef19ab', './themes/cerulean/css/cerulean.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cerulean/css/index.php', '24.9', 0),
('bc82a5a0db739a3e440472eda226f8c4', './themes/cerulean/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cerulean/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cerulean/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cerulean/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/cerulean/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cerulean/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cerulean/templates/index.php', '24.9', 0),
('9c793fa48a8d378d93aee265aeea9084', './themes/cosmo/css/cosmo.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cosmo/css/index.php', '24.9', 0),
('876a7dcb00c25cf968cc1c8a3a5fa641', './themes/cosmo/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cosmo/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cosmo/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cosmo/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/cosmo/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cosmo/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cosmo/templates/index.php', '24.9', 0),
('a697ccd7d2a618a27acebd38db559dfb', './themes/css/h5p-custom-example.css', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/css/index.php', '24.9', 0),
('2b7b9749f7ed8362ed719019cb43ead2', './themes/css/tiki-install.css', '24.9', 0),
('5b5b9c7dd5b53fb7636cd82da898a264', './themes/cyborg/css/cyborg.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cyborg/css/index.php', '24.9', 0),
('2cb0ed6d3e6731bd4bdf743cdfb70b9e', './themes/cyborg/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cyborg/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cyborg/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cyborg/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/cyborg/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cyborg/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/cyborg/templates/index.php', '24.9', 0),
('dc4417d207f8ec846d282da005c86f5b', './themes/darkly/css/darkly.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkly/css/index.php', '24.9', 0),
('d702089894b0f5e8ee882e33b0b1739f', './themes/darkly/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkly/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkly/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkly/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/darkly/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkly/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkly/templates/index.php', '24.9', 0),
('1f44f8e0aa0652dd45c8a1862c136382', './themes/darkroom/css/darkroom.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkroom/css/index.php', '24.9', 0),
('97669a504019cdd4ff8a48a3e7f41cfd', './themes/darkroom/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkroom/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkroom/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkroom/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/darkroom/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkroom/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/darkroom/templates/index.php', '24.9', 0),
('4b80e6080733cb40a405e7e839cec294', './themes/darkshine/css/darkshine.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/darkshine/css/index.php', '24.9', 0),
('1989459090aeb6f9ae35c54b01ab196a', './themes/darkshine/css/newsletter.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/darkshine/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/darkshine/icons/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/darkshine/images/index.php', '24.9', 0),
('5f466361f1e5313bbaa757cad13a7e97', './themes/darkshine/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/darkshine/scss/index.php', '24.9', 0),
('eab34370d58449de887d3ed18cc9d951', './themes/default/css/default.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/css/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/favicons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/default/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/options/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/default/templates/index.php', '24.9', 0),
('892d5631b2de242e211fde98e524cadf', './themes/feb12/css/feb12.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/feb12/css/index.php', '24.9', 0),
('3364b66f579eef99619637f84ebe8eb3', './themes/feb12/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/feb12/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/feb12/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/feb12/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/feb12/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/feb12/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/feb12/templates/index.php', '24.9', 0),
('32058cecf3266317ce7fdb2fbde1e156', './themes/fivealive-lite/css/fivealive-lite.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/css/index.php', '24.9', 0),
('ed8e5f3086903df05e301c3c57071878', './themes/fivealive-lite/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/fonts/index.php', '24.9', 0),
('cbb191146261a65a3fce1a699f3e37a7', './themes/fivealive-lite/icons/custom.php', '24.9', 0),
('631c2306142577d75835adbf991872b8', './themes/fivealive-lite/icons/fivealive_lite.php', '24.9', 0),
('e87801aae36762a085d5b44085010483', './themes/fivealive-lite/icons/fivealive_lite_custom.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/fivealive-lite/index.php', '24.9', 0),
('9564516004535eb0c6db0d3892384ea6', './themes/fivealive-lite/options/akebi/css/akebi.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/akebi/css/index.php', '24.9', 0),
('7cb6ce48685aa92467ba128080ac5d5d', './themes/fivealive-lite/options/akebi/icons/akebi_custom.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/options/akebi/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/akebi/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/akebi/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/akebi/scss/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/blueberry/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/blueberry/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/blueberry/rtl/index.php', '24.9', 0),
('6c8c5310d08293a6bc8099efc7486ef7', './themes/fivealive-lite/options/grape/css/grape.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/grape/css/index.php', '24.9', 0),
('07880874e2f1bc85b9a10d6041d5117e', './themes/fivealive-lite/options/grape/css/newsletter.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/grape/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/grape/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/grape/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/options/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/kiwi/css/index.php', '24.9', 0),
('a3214d20575f8f92752c5aacbb747d53', './themes/fivealive-lite/options/kiwi/css/kiwi.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/kiwi/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/kiwi/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/kiwi/scss/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/lemon/css/index.php', '24.9', 0),
('2847892d3ecd1fc484a8323272cbeb9b', './themes/fivealive-lite/options/lemon/css/lemon.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/lemon/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/lemon/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/lemon/scss/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/orange/css/index.php', '24.9', 0),
('d1a6a79d809a8d1c0ffb430d74fc61a8', './themes/fivealive-lite/options/orange/css/orange.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/orange/icons/index.php', '24.9', 0),
('b5b85af67a0a6c8f1dc9d604afafa256', './themes/fivealive-lite/options/orange/icons/orange.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/orange/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/orange/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/orange/scss/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/plum/css/index.php', '24.9', 0),
('03d6a3455bd2f6bf38eadc2d51648386', './themes/fivealive-lite/options/plum/css/plum.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/plum/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/plum/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/plum/scss/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/raspberry/css/index.php', '24.9', 0),
('7ecd0793f3bed6d013535ae22c6b5a6e', './themes/fivealive-lite/options/raspberry/css/raspberry.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/raspberry/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/raspberry/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/raspberry/scss/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/watermelon/css/index.php', '24.9', 0),
('4a2b8473da77273798bc0756f8042964', './themes/fivealive-lite/options/watermelon/css/watermelon.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/watermelon/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive-lite/options/watermelon/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive-lite/options/watermelon/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive-lite/templates/index.php', '24.9', 0),
('666985c9578b12217f285ce3b6c5ed93', './themes/fivealive/css/fivealive.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/css/index.php', '24.9', 0),
('dc78fe29624c9dd991af29ecf51e0028', './themes/fivealive/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/favicons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/fivealive/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/jquery-ui/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/jquery-ui/index.php', '24.9', 0),
('22a7d33028d43d1be233c0e2c1958dcd', './themes/fivealive/jquery-ui/jquery-ui.css', '24.9', 0),
('036499b6a0aa2e7f986a186f51215266', './themes/fivealive/jquery-ui/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/akebi/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/akebi/index.php', '24.9', 0),
('2ebccfc9ca23beba573283efbd3a48c9', './themes/fivealive/jquery-ui/options/akebi/jquery-ui.css', '24.9', 0),
('93a31bd83b69de4ab5160b72f4860099', './themes/fivealive/jquery-ui/options/akebi/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/grape/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/grape/index.php', '24.9', 0),
('c919c16e3930b790d06566d9c0a74c8a', './themes/fivealive/jquery-ui/options/grape/jquery-ui.css', '24.9', 0),
('9ce6d357331dcbf9400cea87352cec1c', './themes/fivealive/jquery-ui/options/grape/jquery-ui.min.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/jquery-ui/options/index.php', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/kiwi/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/kiwi/index.php', '24.9', 0),
('642834943095e686e7f8b403a40d8369', './themes/fivealive/jquery-ui/options/kiwi/jquery-ui.css', '24.9', 0),
('202620ec8a1125a00e6d03bc375bbd16', './themes/fivealive/jquery-ui/options/kiwi/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/lemon/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/lemon/index.php', '24.9', 0),
('0243a4a5f7940de2abad6f97a69de803', './themes/fivealive/jquery-ui/options/lemon/jquery-ui.css', '24.9', 0),
('c247a0a8b4083f93dad08a556513db9e', './themes/fivealive/jquery-ui/options/lemon/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/orange/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/orange/index.php', '24.9', 0),
('f63953f20a1c100d82c16fef110ca37d', './themes/fivealive/jquery-ui/options/orange/jquery-ui.css', '24.9', 0),
('221188753698a8089591a0e0826a2e5e', './themes/fivealive/jquery-ui/options/orange/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/plum/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/plum/index.php', '24.9', 0),
('37242734c3f5b6f9571aa0891abefb68', './themes/fivealive/jquery-ui/options/plum/jquery-ui.css', '24.9', 0),
('9ee83e9ad1c69d374035d186c99e762d', './themes/fivealive/jquery-ui/options/plum/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/raspberry/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/raspberry/index.php', '24.9', 0),
('970b866ddd84164dcd36105c4accdbef', './themes/fivealive/jquery-ui/options/raspberry/jquery-ui.css', '24.9', 0),
('5e5b795a650bb46553cb6738e85be28e', './themes/fivealive/jquery-ui/options/raspberry/jquery-ui.min.css', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/fivealive/jquery-ui/options/watermelon/images/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/jquery-ui/options/watermelon/index.php', '24.9', 0),
('c8dafc62467e772f0075af7ab065a662', './themes/fivealive/jquery-ui/options/watermelon/jquery-ui.css', '24.9', 0),
('6f3ef93aa4794d750a4e2502cb657189', './themes/fivealive/jquery-ui/options/watermelon/jquery-ui.min.css', '24.9', 0),
('46bcf025d44562373d6fa163e84049d5', './themes/fivealive/js/custom.js', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/js/index.php', '24.9', 0),
('ef390631d3ad27624c750f51a4a3f8d7', './themes/fivealive/options/akebi/css/akebi.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi/css/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/options/akebi/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi/scss/index.php', '24.9', 0),
('baa6c04732b5cbb5172b1fd356907d1f', './themes/fivealive/options/akebi_classic/css/akebi_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi_classic/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/options/akebi_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/akebi_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/akebi_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/blueberry/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/blueberry/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/blueberry/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/blueberry/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/fivealive/options/blueberry/rtl/index.php', '24.9', 0),
('2e4d993f8f6d67b3b20225edd7076490', './themes/fivealive/options/grape/css/grape.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape/css/index.php', '24.9', 0),
('07880874e2f1bc85b9a10d6041d5117e', './themes/fivealive/options/grape/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/grape/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape/scss/index.php', '24.9', 0),
('82f26367f9e445924aee65558b996d1c', './themes/fivealive/options/grape_classic/css/grape_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape_classic/css/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/grape_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/grape_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi/css/index.php', '24.9', 0),
('953433d2659923149e78204e6ffb10e4', './themes/fivealive/options/kiwi/css/kiwi.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/kiwi/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi_classic/css/index.php', '24.9', 0),
('9f384aa5a43cf54b3e0609e153ff0411', './themes/fivealive/options/kiwi_classic/css/kiwi_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/kiwi_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/kiwi_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon/css/index.php', '24.9', 0),
('c73ea4c047964c04a91ace3e4f26cc3c', './themes/fivealive/options/lemon/css/lemon.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/lemon/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon_classic/css/index.php', '24.9', 0),
('76ec594a43ccfe289f5e0d9cedb24053', './themes/fivealive/options/lemon_classic/css/lemon_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/lemon_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/lemon_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange/css/index.php', '24.9', 0),
('12bea3a32735048c6cbcb469bb7ac982', './themes/fivealive/options/orange/css/orange.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/orange/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange_classic/css/index.php', '24.9', 0),
('6180b05be322edf67340bae0efc7ca0e', './themes/fivealive/options/orange_classic/css/orange_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/orange_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/orange_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum/css/index.php', '24.9', 0),
('9973b4767f54fb25913c4e17be940110', './themes/fivealive/options/plum/css/plum.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/plum/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum_classic/css/index.php', '24.9', 0),
('45c873c60c40838ba7f9e79be5d071cc', './themes/fivealive/options/plum_classic/css/plum_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/plum_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/plum_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry/css/index.php', '24.9', 0),
('7b4016751922d121b59e1c94a6fa66f7', './themes/fivealive/options/raspberry/css/raspberry.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/raspberry/images/index.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry_classic/css/index.php', '24.9', 0),
('5de0b8860946af0766744616e470a974', './themes/fivealive/options/raspberry_classic/css/raspberry_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/raspberry_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/raspberry_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon/css/index.php', '24.9', 0),
('515b93d2664c4aa4830e706e2759f0fc', './themes/fivealive/options/watermelon/css/watermelon.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon/icons/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/watermelon/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon_classic/css/index.php', '24.9', 0),
('40de4c69d19d1940169d0de19e3ee32a', './themes/fivealive/options/watermelon_classic/css/watermelon_classic.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon_classic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/fivealive/options/watermelon_classic/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/options/watermelon_classic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/fivealive/templates/index.php', '24.9', 0),
('d430556fafdf74733569ec534c7b47b9', './themes/flatly/css/flatly.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/css/index.php', '24.9', 0),
('c490320a28953acfeb6c53ec59c4cab6', './themes/flatly/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/flatly/index.php', '24.9', 0),
('99b9dcb93aa01a35f79bfc76ce2cd62a', './themes/flatly/options/blue/css/blue.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/flatly/options/blue/css/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/flatly/options/blue/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/options/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/flatly/templates/index.php', '24.9', 0),
('60100823323c47d4b8c386899f60e8fd', './themes/greenvalley/css/greenvalley.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/greenvalley/css/index.php', '24.9', 0),
('893ea914430645d7a4e94e09dcffb6ff', './themes/greenvalley/css/newsletter.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/greenvalley/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/greenvalley/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/greenvalley/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/greenvalley/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/greenvalley/scss/index.php', '24.9', 0),
('965d093eec97d87205bdef69a7e4ea76', './themes/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/journal/css/index.php', '24.9', 0),
('8af1222df821298fb43bd2ea04206428', './themes/journal/css/journal.css', '24.9', 0),
('bdb48c80aeca950bf7c9abdacf167528', './themes/journal/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/journal/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/journal/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/journal/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/journal/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/journal/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/journal/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/css/index.php', '24.9', 0),
('d51196ce2dcfd2d1dfd53e7328064a21', './themes/jqui/css/jqui.css', '24.9', 0),
('5dfc1db0ffaa84808774ec47b76ce58d', './themes/jqui/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/jqui/index.php', '24.9', 0),
('a21400d6e3431cbee3b7f1ba9e983ae1', './themes/jqui/options/element/css/element.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/element/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/element/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/element/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/element/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/element/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/element/scss/index.php', '24.9', 0),
('0a12b454cfcfb0f6b83db2fc4e56b42a', './themes/jqui/options/excitebike/css/excitebike.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/excitebike/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/excitebike/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/excitebike/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/excitebike/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/excitebike/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/excitebike/scss/index.php', '24.9', 0),
('3c677da54979e43554b258db0b9066cb', './themes/jqui/options/flat/css/flat.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/flat/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/flat/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/flat/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/flat/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/flat/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/flat/scss/index.php', '24.9', 0),
('9ec7a9602139f4dc21690bf627b071bf', './themes/jqui/options/good/css/good.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/good/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/good/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/good/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/good/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/good/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/good/scss/index.php', '24.9', 0),
('2a1ef7c2cbce63d5a92647356a43387f', './themes/jqui/options/haus/css/haus.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/haus/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/haus/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/haus/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/haus/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/haus/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/haus/scss/index.php', '24.9', 0),
('3a1aa2ec4edac93c577842e37159e314', './themes/jqui/options/horizons/css/horizons.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/horizons/css/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/horizons/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/horizons/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/horizons/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/horizons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/horizons/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/options/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/rising/css/index.php', '24.9', 0),
('b9f9e48c9e4bdc9aa69d624988c2de9c', './themes/jqui/options/rising/css/rising.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/rising/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/rising/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/rising/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/rising/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/rising/scss/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/scss/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/trontastic/css/index.php', '24.9', 0),
('e356cc3db652bb90fa16f642cfeb1dd7', './themes/jqui/options/trontastic/css/trontastic.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/trontastic/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/trontastic/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/trontastic/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/jqui/options/trontastic/index.php', '24.9', 0),
('4a021eac0eff5b3e7aa805e163ba360e', './themes/jqui/options/trontastic/pics/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/trontastic/pics/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/jqui/options/trontastic/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/jqui/templates/index.php', '24.9', 0),
('376508d840fefbdfd007b515fbbe7283', './themes/js/h5p-custom-example.js', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/js/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lighty/css/index.php', '24.9', 0),
('15bdd38f8d9e6efcba1da64acd187675', './themes/lighty/css/lighty.css', '24.9', 0),
('4919ded2a87f5db9a54cf1a277076bce', './themes/lighty/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lighty/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/lighty/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lighty/scss/index.php', '24.9', 0),
('3a08af04464e8ae8584987b95f3b9d0b', './themes/lighty/templates/antibot.tpl', '24.9', 0),
('62c13f876d9eb4fcf0843a796dace4b2', './themes/lighty/templates/blog_post_postbody_title.tpl', '24.9', 0),
('d874fff3f810b6ba5cc7a2065ee1d5dd', './themes/lighty/templates/blog_wrapper.tpl', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lighty/templates/index.php', '24.9', 0),
('38a8752b5dfe242de5fada3082c14c84', './themes/lighty/templates/tiki-contact.tpl', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/litera/css/index.php', '24.9', 0),
('6325272d7da6b82bccfc1e66d69314a1', './themes/litera/css/litera.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/litera/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/litera/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/litera/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/litera/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/litera/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/litera/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lumen/css/index.php', '24.9', 0),
('19abc50dd0bbabcc8d9e899b167f6fce', './themes/lumen/css/lumen.css', '24.9', 0),
('d118dadd00284643628f2116f6888f6f', './themes/lumen/css/newsletter.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lumen/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lumen/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lumen/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/lumen/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lumen/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lumen/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lux/css/index.php', '24.9', 0),
('42919241538b75a8ea88222afec144d4', './themes/lux/css/lux.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lux/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lux/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lux/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/lux/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lux/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/lux/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/materia/css/index.php', '24.9', 0),
('419753eeb6bf2d46a88d849dd485ff09', './themes/materia/css/materia.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/materia/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/materia/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/materia/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/materia/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/materia/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/materia/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/minty/css/index.php', '24.9', 0),
('31e56bd5fd292097f15f1c68c14a552f', './themes/minty/css/minty.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/minty/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/minty/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/minty/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/minty/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/minty/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/minty/templates/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/morph/css/index.php', '24.9', 0),
('be25178fa7728c313640851ce1fa8cf8', './themes/morph/css/morph.css', '24.9', 0),
('cd1d87209a02c51b32aa91f0c4557aa5', './themes/morph/css/newsletter.css', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/morph/fonts/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/morph/icons/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/morph/images/index.php', '24.9', 0),
('5f466361f1e5313bbaa757cad13a7e97', './themes/morph/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/morph/options/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/morph/scss/index.php', '24.9', 0),
('2efe1259dba2ccffd0a8a9644982b380', './themes/morph/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/ohia/css/index.php', '24.9', 0),
('ad1b0d2ce029b6f4da6833261efcb51f', './themes/ohia/css/newsletter.css', '24.9', 0),
('092cdf04c5dd96cff9e7f07bf4d7c280', './themes/ohia/css/ohia.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/ohia/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/ohia/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/ohia/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/ohia/index.php', '24.9', 0),
('5513774d75f646ec65f01429a17f524b', './themes/ohia/need-fix-or-merge-tiki.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/ohia/scss/index.php', '24.9', 0),
('aae566f45c48aa727c7f076ad4eb9c09', './themes/ohia/templates/credits.tpl', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/ohia/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/pulse/css/index.php', '24.9', 0),
('b4c136844ed082041ed1df2b000f6493', './themes/pulse/css/pulse.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/pulse/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/pulse/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/pulse/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/pulse/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/pulse/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/pulse/templates/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/quartz/css/index.php', '24.9', 0),
('cd1d87209a02c51b32aa91f0c4557aa5', './themes/quartz/css/newsletter.css', '24.9', 0),
('4df0a6300c0994292ea313b95d670e27', './themes/quartz/css/quartz.css', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/quartz/fonts/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/quartz/icons/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/quartz/images/index.php', '24.9', 0),
('5f466361f1e5313bbaa757cad13a7e97', './themes/quartz/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/quartz/options/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/quartz/scss/index.php', '24.9', 0),
('2efe1259dba2ccffd0a8a9644982b380', './themes/quartz/templates/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/sandstone/css/index.php', '24.9', 0),
('e45af66da89838e4200692f87fa7d45b', './themes/sandstone/css/newsletter.css', '24.9', 0),
('8469ba79f6ed9ef07d4f58108a4a2902', './themes/sandstone/css/sandstone.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/sandstone/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/sandstone/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/sandstone/images/index.php', '24.9', 0),
('5f466361f1e5313bbaa757cad13a7e97', './themes/sandstone/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/sandstone/less/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/sandstone/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/simplex/css/index.php', '24.9', 0),
('28488cb84866759d16ec7751a604feb7', './themes/simplex/css/newsletter.css', '24.9', 0),
('65bc93a55a41ee032bcb50b7dd8fe454', './themes/simplex/css/simplex.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/simplex/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/simplex/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/simplex/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/simplex/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/simplex/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/simplex/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/sketchy/css/index.php', '24.9', 0),
('5ffd7d94be10f2566e266d56b3e26403', './themes/sketchy/css/newsletter.css', '24.9', 0),
('bcc31630bdd870990b8fd9257f6218cb', './themes/sketchy/css/sketchy.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/sketchy/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/sketchy/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/sketchy/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/sketchy/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/sketchy/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/sketchy/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/slate/css/index.php', '24.9', 0),
('0dafcc12518e7853200403a8bca4751c', './themes/slate/css/newsletter.css', '24.9', 0),
('3ad0af5277ad2482e53992b938e1d876', './themes/slate/css/slate.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/slate/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/slate/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/slate/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/slate/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/slate/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/slate/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/solar/css/index.php', '24.9', 0),
('fa669f213d26b64e148d39dc4dee11bf', './themes/solar/css/newsletter.css', '24.9', 0),
('22c078ae92336d76cea6cd424f4b0df2', './themes/solar/css/solar.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/solar/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/solar/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/solar/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/solar/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/solar/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/solar/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/spacelab/css/index.php', '24.9', 0),
('3ee33658ff3361587489a486f703c345', './themes/spacelab/css/newsletter.css', '24.9', 0),
('8a6552cf58d33f3eff047108ac7db2f3', './themes/spacelab/css/spacelab.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/spacelab/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/spacelab/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/spacelab/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/spacelab/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/spacelab/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/spacelab/templates/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/strasa/css/index.php', '24.9', 0),
('4c74582484b497bcf490b049046c35fb', './themes/strasa/css/newsletter.css', '24.9', 0),
('a1269a3c381bcb3d74bb2605dc193337', './themes/strasa/css/strasa.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/strasa/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/strasa/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/strasa/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/strasa/index.php', '24.9', 0),
('825117b5d65b80272257b17f595ccae9', './themes/strasa/options/cool/css/cool.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/strasa/options/cool/css/index.php', '24.9', 0),
('b805a56f4b989d30ed49f02eb7814ed7', './themes/strasa/options/cool/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/strasa/options/cool/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/strasa/options/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/strasa/options/mono/css/index.php', '24.9', 0),
('4db73647a5f334216560e4b764d8aab7', './themes/strasa/options/mono/css/mono.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/strasa/options/mono/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/strasa/options/mono/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/strasa/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/superhero/css/index.php', '24.9', 0),
('ee61df3849ef9ed04b3a942f84e65bd6', './themes/superhero/css/newsletter.css', '24.9', 0),
('39220dceeee0fb7811a5c82be1ffeb16', './themes/superhero/css/superhero.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/superhero/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/superhero/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/superhero/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/superhero/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/superhero/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/superhero/templates/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/thenews/css/index.php', '24.9', 0),
('457c2de3cbc1f2676522e1c8e855a519', './themes/thenews/css/newsletter.css', '24.9', 0),
('85c5fd06b1a5a45f8f85da869ed02398', './themes/thenews/css/thenews.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/thenews/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/thenews/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/thenews/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/thenews/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/thenews/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/thenews/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/css/index.php', '24.9', 0),
('8c28c22c66c28ef645ebea3b73a1ed67', './themes/tikicorp/css/tikicorp.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/tikicorp/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/tikicorp/jquery-ui/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/jquery-ui/index.php', '24.9', 0),
('22a7d33028d43d1be233c0e2c1958dcd', './themes/tikicorp/jquery-ui/jquery-ui.css', '24.9', 0),
('036499b6a0aa2e7f986a186f51215266', './themes/tikicorp/jquery-ui/jquery-ui.min.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/options/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/options/light/css/index.php', '24.9', 0),
('d8ddc9343f22010893357ab4d31428d2', './themes/tikicorp/options/light/css/light.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/options/light/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/options/light/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/tikicorp/options/light/images/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/options/light/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/options/light/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikicorp/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/css/index.php', '24.9', 0),
('c6b26c4fa285b4741a6688af756e3a71', './themes/tikinewt/css/newsletter.css', '24.9', 0),
('eac5e5f17525b7b1b3009d6a9105ab46', './themes/tikinewt/css/tikinewt.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/tikinewt/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/options/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/tikinewt/options/shadows/css/index.php', '24.9', 0),
('8ec27e0a8a1a2c871f507b35af4f7926', './themes/tikinewt/options/shadows/css/shadows.css', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/tikinewt/options/shadows/images/index.php', '24.9', 0),
('2e2c275427e24f067d5b616c11c32657', './themes/tikinewt/options/shadows/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikinewt/templates/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/tikipedia/css/index.php', '24.9', 0),
('cd1d87209a02c51b32aa91f0c4557aa5', './themes/tikipedia/css/newsletter.css', '24.9', 0),
('b5387d1fe3fe206dec66df5047e410d9', './themes/tikipedia/css/tikipedia.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/tikipedia/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/tikipedia/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/tikipedia/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/tikipedia/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikipedia/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/tikipedia/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/united/css/index.php', '24.9', 0),
('7f6a27df43d8567f3f21df5dd1b509ec', './themes/united/css/newsletter.css', '24.9', 0),
('2651d95d49442113506b4cbce675b0e9', './themes/united/css/united.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/united/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/united/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/united/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/united/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/united/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/united/templates/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/utopias/css/index.php', '24.9', 0),
('aec3b5fce3a32009ea7439ac191cf705', './themes/utopias/css/newsletter.css', '24.9', 0),
('7fd4c8d50037245e8c98336c3741fffc', './themes/utopias/css/utopias.css', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/utopias/fonts/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/utopias/icons/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/utopias/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/utopias/index.php', '24.9', 0),
('29d2b4c53735d57c3ecc3f03e7c54a7e', './themes/utopias/scss/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/vapor/css/index.php', '24.9', 0),
('cd1d87209a02c51b32aa91f0c4557aa5', './themes/vapor/css/newsletter.css', '24.9', 0),
('f4f52251e18409b3ed40d84064aceac0', './themes/vapor/css/vapor.css', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/vapor/fonts/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/vapor/icons/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/vapor/images/index.php', '24.9', 0),
('5f466361f1e5313bbaa757cad13a7e97', './themes/vapor/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/vapor/options/index.php', '24.9', 0),
('6683a58b49a26bdfebaa80c18e487e74', './themes/vapor/scss/index.php', '24.9', 0),
('2efe1259dba2ccffd0a8a9644982b380', './themes/vapor/templates/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/yeti/css/index.php', '24.9', 0),
('8e09352a53286fd6c455a8e40d3caab2', './themes/yeti/css/newsletter.css', '24.9', 0),
('4e477dbffc4b19ddb235635e4c2e8247', './themes/yeti/css/yeti.css', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/yeti/fonts/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/yeti/icons/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/yeti/images/index.php', '24.9', 0),
('bf1f3e3caf96468dcc8c3dd813e85f98', './themes/yeti/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/yeti/scss/index.php', '24.9', 0),
('ddfa4353bfc23d71891f22c603138eed', './themes/yeti/templates/index.php', '24.9', 0),
('4dea6610d4a87b78e964b3ef545806fe', './tiki-accounting.php', '24.9', 0),
('d9e6c04baacaa33999959682c6c124db', './tiki-accounting_account.php', '24.9', 0),
('9b25b815273ee63f5002a707998e061f', './tiki-accounting_books.php', '24.9', 0),
('61ac707019cdd7043fd9617205e02fd5', './tiki-accounting_cancel.php', '24.9', 0),
('86c1527a271500448011f8c615790ed0', './tiki-accounting_entry.php', '24.9', 0),
('35d9d589f94b4ab5b678d73dd74eef31', './tiki-accounting_export.php', '24.9', 0),
('04242489508fa0d4e3fa1d22a1b1c32a', './tiki-accounting_stack.php', '24.9', 0),
('6799cb198e2b7446e2c3281c9c70fd96', './tiki-action_calendar.php', '24.9', 0),
('d59a24f91c9bb7a837a5fa3fa4ce1d9c', './tiki-admin.php', '24.9', 0),
('946bd42fa981f5dac87e4c9072ac0b14', './tiki-admin_actionlog.php', '24.9', 0),
('06ef2a0154a390cb343626eb3ce07079', './tiki-admin_banners.php', '24.9', 0),
('5e79f25cd037590a16cebfe5b38d6e45', './tiki-admin_banning.php', '24.9', 0),
('4e85a43f8a93dcbd8a56435eba5b04a4', './tiki-admin_calendars.php', '24.9', 0),
('06bf13853694aae62301ae794a164412', './tiki-admin_categories.php', '24.9', 0),
('55f5703c0f8ec83ef568df8a32529efb', './tiki-admin_content_templates.php', '24.9', 0),
('7ad38d32ce47b3ff4549b5b014421257', './tiki-admin_contribution.php', '24.9', 0),
('dfc522e69de8428291206f7399f27e07', './tiki-admin_cookies.php', '24.9', 0),
('128fa2fd0f404856b108e5d8048c3f97', './tiki-admin_credits.php', '24.9', 0),
('81c3287b3304b0a8547decc2cb227ed0', './tiki-admin_dsn.php', '24.9', 0),
('ce9cdaa4c367a065cd1a4801bd04edc0', './tiki-admin_external_wikis.php', '24.9', 0),
('b519e5fbaf95603997f0ce9bcab6866f', './tiki-admin_forums.php', '24.9', 0),
('c60b0721b6c039846f903e2a7a92209c', './tiki-admin_hotwords.php', '24.9', 0),
('1b2750629e7c3a370103ce72eab34e7c', './tiki-admin_html_page_content.php', '24.9', 0),
('afc2b19be6a59c117743b8345822b1b7', './tiki-admin_html_pages.php', '24.9', 0),
('4d66b342341793bf9a659a600f035a7c', './tiki-admin_ids.php', '24.9', 0),
('d924892fdbe2161ed19a0717d3c68b7a', './tiki-admin_integrator.php', '24.9', 0),
('9f02adbd9358aabdd9aa8463aba960eb', './tiki-admin_integrator_rules.php', '24.9', 0),
('cc6e4187670e7bdf98021097707802f4', './tiki-admin_keywords.php', '24.9', 0),
('26c5a1c6803e267a80b231bcfd7b2ba6', './tiki-admin_links.php', '24.9', 0),
('89be7564eb9f63840c598b2b43087000', './tiki-admin_mailin.php', '24.9', 0),
('8f80466d0b959492931676d6943f96f1', './tiki-admin_mailin_routes.php', '24.9', 0),
('7987b8e26ea1ff3025e52ceb4d107afb', './tiki-admin_menu_options.php', '24.9', 0),
('19b84f655c7edf38e9bd1a0655db9015', './tiki-admin_menus.php', '24.9', 0),
('1b3e0a3415a1688215a842f68a3b4594', './tiki-admin_modules.php', '24.9', 0),
('b39bb03b573fc93e2ed7c3c64be26787', './tiki-admin_newsletter_subscriptions.php', '24.9', 0),
('5324a3e14b3d2a074637ad009cbc00f5', './tiki-admin_newsletters.php', '24.9', 0),
('85ba60e19b8b0b08ef84285f42d87b68', './tiki-admin_notifications.php', '24.9', 0),
('4a6d7eb2c0e34c24c05f8df3dc9b671e', './tiki-admin_oauthserver.php', '24.9', 0),
('cd735b8d9cbf3a74c03563d170705c62', './tiki-admin_orphaned.php', '24.9', 0),
('fe83f945799e9a33f99b4abec18e73e2', './tiki-admin_poll_options.php', '24.9', 0),
('c43f07ceca6ac97390bea29e96b0fe2e', './tiki-admin_polls.php', '24.9', 0),
('3571d60b558feed9eddc4276c1addd30', './tiki-admin_routes.php', '24.9', 0),
('32f524943d06669df6db351d0a0bc6ef', './tiki-admin_rssmodules.php', '24.9', 0),
('09ee175cf36bf1a9b276a01730c317f2', './tiki-admin_schedulers.php', '24.9', 0),
('c7c6fdeb9009b38e4e5cad6f430cbd43', './tiki-admin_security.php', '24.9', 0),
('69146b338cb9e4b0663a9336acafd6bc', './tiki-admin_shoutbox_words.php', '24.9', 0),
('a7bd652f1216b2920e4d3e6eeae119b9', './tiki-admin_sitemap.php', '24.9', 0),
('78afa64f83443821a7db40a27cf83367', './tiki-admin_structures.php', '24.9', 0),
('df86a5459dd93dfcda1d290de6f77ecc', './tiki-admin_survey_questions.php', '24.9', 0),
('5e6bcff966414c965fc9813aa61f3320', './tiki-admin_surveys.php', '24.9', 0),
('297c990d5a5defca050a8387ea63751b', './tiki-admin_sync.php', '24.9', 0),
('b372f9ef94fae3f8ea795cd38aa59773', './tiki-admin_system.php', '24.9', 0),
('f0026ea7bb4d986a939191c8c152a32b', './tiki-admin_tokens.php', '24.9', 0),
('95178816e69002c24481e37bc3b020af', './tiki-admin_toolbars.php', '24.9', 0),
('c3c0532911215621f9cba0955acf21f8', './tiki-admin_topics.php', '24.9', 0),
('34877d6f51f19fd7a4adb2f19edd74af', './tiki-admin_tracker_fields.php', '24.9', 0),
('97b7304d3a96d52d270c9a4136227ea1', './tiki-admin_trackers.php', '24.9', 0),
('0ba12016b2fea4f16641a2527f1e5b19', './tiki-admin_transitions.php', '24.9', 0),
('21759669977fda6ba88583413217fedc', './tiki-admin_webservices.php', '24.9', 0),
('88365e65c75e0fcaeb106ce5846e1355', './tiki-admingroups.php', '24.9', 0),
('bda5dcebe93b1a86a3a235c726caa9d1', './tiki-adminusers.php', '24.9', 0),
('33ac17a5021bbb3e3da00fe596208a6b', './tiki-ajax_services.php', '24.9', 0),
('2ebe3345b6ef5629b3a6b4a81a901370', './tiki-all_languages.php', '24.9', 0),
('f9c8eec04148006eed02923ecb557487', './tiki-api.php', '24.9', 0),
('22d13b3afb7ebef978b8fde6ee03bc53', './tiki-article_types.php', '24.9', 0),
('01d2bc8031b1c854968daee8db7869a5', './tiki-articles_rss.php', '24.9', 0),
('c75c980d89fcffeb053d80c5b3da27e1', './tiki-assignuser.php', '24.9', 0),
('9ce9e81b2ee3d563e62921cf8e86d5c2', './tiki-autologin.php', '24.9', 0),
('0a3167c98f9260f23cfd99967f0f4803', './tiki-backlinks.php', '24.9', 0),
('18b6f25e06de74447592ce368e15b641', './tiki-batch_send_newsletter.php', '24.9', 0),
('752eb8f102f20d8e1835e7d7f045e500', './tiki-batch_todo.php', '24.9', 0),
('52fe8f373d293b215e7151f563e6b094', './tiki-batch_upload_files.php', '24.9', 0),
('e0be27391fd32809b0c58e35636664f1', './tiki-blog_post.php', '24.9', 0),
('2eb85391c5555a79cfe3a5c8bdb3b5a4', './tiki-blog_rankings.php', '24.9', 0),
('4982786fa121a3c271642ee7663abc88', './tiki-blog_rss.php', '24.9', 0),
('7170381608cd392decba33052e380baf', './tiki-blogs_rss.php', '24.9', 0),
('d23a41b865bf656897927433f63c574b', './tiki-browse_categories.php', '24.9', 0),
('212a15f7c8a211a703019df5b030fb60', './tiki-browse_freetags.php', '24.9', 0),
('6b7dc8084f025e05fa8ec0d1ac10d91d', './tiki-caldav.php', '24.9', 0),
('8d728c283fef75e53e4e053afcd6179a', './tiki-calendar.php', '24.9', 0),
('5584ebcee12a2a95cf0ecd424f065eb9', './tiki-calendar_edit_item.php', '24.9', 0),
('2fe7a03e4c841c4291eed4c50d0d4390', './tiki-calendar_export_ical.php', '24.9', 0),
('ec7c6f47206b51dc261fd774550c0e80', './tiki-calendar_import.php', '24.9', 0),
('be2633ff55af55f71c601c36a1432511', './tiki-calendar_json.php', '24.9', 0),
('224fd34f60ae827361cb8216158f473f', './tiki-calendar_params_ical.php', '24.9', 0),
('3eec5818d7911e6cd168184a7ce2881b', './tiki-calendar_setup.php', '24.9', 0),
('c121e2c8775258c892eb85bb5a4452c7', './tiki-calendars_rss.php', '24.9', 0),
('2a0e8d5830091086b32b36eaf9cf028a', './tiki-carddav.php', '24.9', 0),
('c228341cde68730f313ddae5ee2ad6b3', './tiki-change_password.php', '24.9', 0),
('cf0480b682a1cc3fb0886fcdaca02374', './tiki-channel.php', '24.9', 0),
('06823bf84d6a5e1fe799ba976c5037e7', './tiki-check.php', '24.9', 0),
('b8186691abedebf20c9a4cdc4aeb9a01', './tiki-cms_rankings.php', '24.9', 0),
('cf12b6843c923ef4b0f4fb30298aead9', './tiki-confirm_user_email.php', '24.9', 0),
('29ff3d087e3b828ddc9c597dc49c118c', './tiki-contact.php', '24.9', 0),
('739ea4b550c04c4ad48a111a8b4ded4a', './tiki-contacts.php', '24.9', 0),
('2f86e0d997786c94c718b95ae435ab47', './tiki-cookie-jar.php', '24.9', 0),
('a3f47e2438d5867c8916030f1e463564', './tiki-copypage.php', '24.9', 0),
('b279c98091f44375889e58c279b0f5f6', './tiki-create_multilang_pages.php', '24.9', 0),
('6cba25290b759c2ad292e2e2052ad264', './tiki-create_webhelp.php', '24.9', 0),
('b08b625a093baf03ab9fdddda045eadd', './tiki-directories_rss.php', '24.9', 0),
('41087f731d477294b06e67aa1a01c049', './tiki-directory_add_site.php', '24.9', 0),
('8bb891765f2ce1e97add57b7aac2e350', './tiki-directory_add_tiki_site.php', '24.9', 0),
('30b64d9d5c6f374f04a482eafe16596a', './tiki-directory_admin.php', '24.9', 0),
('ea75b7df9cfb4bfc590b40f15668b3bb', './tiki-directory_admin_categories.php', '24.9', 0),
('90b99fb439c730445f8e57519826e9fe', './tiki-directory_admin_related.php', '24.9', 0),
('f153941d56ec4dec74b3668637ae95cd', './tiki-directory_admin_sites.php', '24.9', 0),
('70f3b5ff62eebce7d58d3f4778208d7b', './tiki-directory_browse.php', '24.9', 0),
('a13fd3bc32202d1f280a89de14bd5a74', './tiki-directory_ranking.php', '24.9', 0),
('1b3fc113bf76a631083e5f2e8d0cdcd5', './tiki-directory_redirect.php', '24.9', 0),
('f9f02e2467541643c201e853a68d4bc3', './tiki-directory_rss.php', '24.9', 0),
('2f9ecd77e75aac53c20ca69bfef13f87', './tiki-directory_search.php', '24.9', 0),
('e82bea217293b823f8a722b70cadb321', './tiki-directory_validate_sites.php', '24.9', 0),
('105c0c768463add51670e50fb56c3e1d', './tiki-discount.php', '24.9', 0),
('cc488eb85a7fbf56929e23c85ce68321', './tiki-display.php', '24.9', 0),
('f7f47c11c29c6533cdb8c4b8ec1f534d', './tiki-download_file.php', '24.9', 0),
('15e00a4e031ce3b30e9147276587920a', './tiki-download_forum_attachment.php', '24.9', 0),
('6aabe7c40bf7eb354f92482900c1f64f', './tiki-download_item_attachment.php', '24.9', 0),
('8a6edeb1a19d10c64d13aa253e1eac84', './tiki-download_userfile.php', '24.9', 0),
('728c48fd15c743422b135e00b4855fd6', './tiki-download_wiki_attachment.php', '24.9', 0),
('6a9d3abc8378029e62e4a94ed647ea4c', './tiki-edit_article.php', '24.9', 0),
('40613876ad7b507ce4d943f18f718553', './tiki-edit_banner.php', '24.9', 0),
('90c889b01544db6b8e89178569d5442e', './tiki-edit_blog.php', '24.9', 0),
('b595e3af5546be422a2e581ee4433fb6', './tiki-edit_categories.php', '24.9', 0),
('c3df355d21fa9503a3af0c5702e67d7f', './tiki-edit_css.php', '24.9', 0),
('461c6c9f7d2dd4438d4f10d98bfb07e8', './tiki-edit_docs.php', '24.9', 0),
('e79d3eaa841082dedd1c98559a74b6eb', './tiki-edit_draw.php', '24.9', 0),
('cb2de7178f7fbe0e5984b2faaecf7ce1', './tiki-edit_groups.php', '24.9', 0),
('cb5bf3cb8982f54bd1d589bd9a7511b8', './tiki-edit_languages.php', '24.9', 0),
('71078bfaaa652aeee4927846326b8efc', './tiki-edit_perspective.php', '24.9', 0),
('9ff36e4ef2e4b65dd9d1f4fbc561b800', './tiki-edit_programmed_content.php', '24.9', 0),
('e4d3331541c3bf75e2344eea9b4c28c1', './tiki-edit_question_options.php', '24.9', 0),
('2cb35ef3077b6265763c5d479a4387c2', './tiki-edit_quiz.php', '24.9', 0),
('e0a6f641c2cc3ca4fa933da80dafe18b', './tiki-edit_quiz_questions.php', '24.9', 0),
('9fa8c8d13b7ae86f5e89f6b23bdff678', './tiki-edit_quiz_results.php', '24.9', 0),
('6de9f190a9ca143bb6e40518d869d2ae', './tiki-edit_structure.php', '24.9', 0),
('db62fba2596cd81ab29bd2d4a2f79ec7', './tiki-edit_submission.php', '24.9', 0),
('96fe3db00c159c2e44f7374d33e8d758', './tiki-edit_templates.php', '24.9', 0),
('2c91012e49f881a233cdf948f2cf12f2', './tiki-edit_topic.php', '24.9', 0),
('bcdcccd72595e958da60cdcaced2f569', './tiki-edit_translation.php', '24.9', 0),
('2eca55c45f982759ce97ad7ba6547ae0', './tiki-editdiagram.php', '24.9', 0),
('e02df6d738abaf582789a602dbc19ecc', './tiki-editpage.php', '24.9', 0),
('d5d60996f2df45a785e57bc92eb62350', './tiki-emulate_groups_switch.php', '24.9', 0),
('0f12ba3b652c19d5843e70294e65a2ef', './tiki-error_simple.php', '24.9', 0),
('67da62c697234296cb71675cc1284242', './tiki-export_sheet.php', '24.9', 0),
('9e38670fe4b29dcb01c9dd0a6324b93a', './tiki-export_tracker.php', '24.9', 0),
('5c066422073376e6f2382c1d7c32d7f3', './tiki-export_tracker_monitor.php', '24.9', 0),
('47e020bfff744b559a8b07336a93acdb', './tiki-export_wiki_pages.php', '24.9', 0),
('be176b3b8f1d472df76e2de9e2d580cf', './tiki-faq_questions.php', '24.9', 0),
('80aae9a8c52435d036137a42e18e9d7b', './tiki-featured_link.php', '24.9', 0),
('bcfe5f4c92283362d135acf3db11a484', './tiki-feed.php', '24.9', 0),
('f13f39aa434b9ca4c57fa8469472af04', './tiki-file_archives.php', '24.9', 0),
('ada778b37c5e941fe9f31fb3c6448279', './tiki-file_galleries_rankings.php', '24.9', 0),
('f02d724d308ffbdc938cf12bcbbc8467', './tiki-file_galleries_rss.php', '24.9', 0),
('35d19364245c078a20f80509612944c1', './tiki-file_gallery_rss.php', '24.9', 0),
('66c248bce9f212d32cd4a97d16fa226b', './tiki-filter-base.php', '24.9', 0),
('87f388f376c9de33c1b2fe8c458d565e', './tiki-forum_import.php', '24.9', 0),
('2cf3e63af206cc40118a9a60d72c9df4', './tiki-forum_queue.php', '24.9', 0),
('6102c18eaa16bbcc4defb114839dcbad', './tiki-forum_rankings.php', '24.9', 0),
('4fd38861d45abf6ecef782ac2768a5c5', './tiki-forum_rss.php', '24.9', 0),
('086f5804098a8eb4383509c56ee129ee', './tiki-forums.php', '24.9', 0),
('fb5d92e94df36e280f4a08708d9524ed', './tiki-forums_reported.php', '24.9', 0),
('6a7cb0cbe6c3078fceba24debf887b29', './tiki-forums_rss.php', '24.9', 0),
('de4d9d49feccacc871a1156156eeff39', './tiki-freetag_translate.php', '24.9', 0),
('89c8ac33c602f98b68b4c5807fe43807', './tiki-friends.php', '24.9', 0),
('c03c7d0652ca42c2ff8b1f449f69d5e5', './tiki-gdgraph.php', '24.9', 0),
('69d6a2d055717a0f804a4e6432f59a46', './tiki-graph_formula.php', '24.9', 0),
('3de9d0aa7415e6e5e185b700ad25c408', './tiki-graph_sheet.php', '24.9', 0),
('c6680f182d5bd6083148aca884b7f0d9', './tiki-history_sheets.php', '24.9', 0),
('30a1663b8c41a67d1f1531d031fd66e8', './tiki-import_sheet.php', '24.9', 0),
('3246481048e5571d1ab408783d1de95c', './tiki-import_structuredtext.php', '24.9', 0),
('f335648514d3d94ddc79242a385fc1ab', './tiki-import_xml_zip.php', '24.9', 0),
('01b9f056310077e48bcf8fa90f978217', './tiki-importer.php', '24.9', 0),
('db1d8c1cc86e5be269ecedfc3e7104fe', './tiki-index.php', '24.9', 0),
('caf22c1adc446d2835de3c7fce3550c2', './tiki-index_p.php', '24.9', 0),
('89eeb877c18db1155593266205e13694', './tiki-index_raw.php', '24.9', 0),
('e4dd8d0ae26c34d87746321749e1e8ae', './tiki-information.php', '24.9', 0),
('3deec02575049e59918124b595f13557', './tiki-install.php', '24.9', 0),
('fbc402a866bb435a6dacd7b317993f60', './tiki-integrator.php', '24.9', 0),
('3c17bd7241fe74e1f8789ff31f96b061', './tiki-interactive_trans.php', '24.9', 0),
('88b5b20979c6b27563d1646f0485dc8b', './tiki-invite.php', '24.9', 0),
('2a33eacc24f1dec61f34a83bd8c59682', './tiki-invited.php', '24.9', 0),
('8935e71d74d34d79ac06bacd632596be', './tiki-kaltura_upload.php', '24.9', 0),
('048e4818b6e05d45c38a32bc46be633c', './tiki-kaltura_video.php', '24.9', 0),
('ce68e6e54401af9bbe355f1c986aa35d', './tiki-lastchanges.php', '24.9', 0),
('f1d25854cd9a5770cf05e9b0c1dc512d', './tiki-layout_options.php', '24.9', 0),
('e4e43401fbc57bdd27812a606967fc36', './tiki-likepages.php', '24.9', 0),
('a13486ea8d006137acc6aba2965d2a83', './tiki-list_articles.php', '24.9', 0),
('690a89816cbe5704296e97fa41d4248c', './tiki-list_banners.php', '24.9', 0),
('675d49a302f25116f257f1070b9115e9', './tiki-list_blogs.php', '24.9', 0),
('888caf26f835d0a9af292fda805df190', './tiki-list_cache.php', '24.9', 0),
('fba94477d8b9b1fafbdb8e902a067059', './tiki-list_comments.php', '24.9', 0),
('cb017d94dca361ad307c827d413814e0', './tiki-list_contents.php', '24.9', 0),
('9cf4283deb0e2e4fdb7ef91dda5e3c26', './tiki-list_faqs.php', '24.9', 0),
('f8441688fc3b5a84a5c4ebe391a2ae98', './tiki-list_file_gallery.php', '24.9', 0),
('b7282acfc4f5127e3836ee256d25e44a', './tiki-list_integrator_repositories.php', '24.9', 0),
('9c2a7addebecc982d785ebd66a241c14', './tiki-list_invite.php', '24.9', 0),
('c5cd7e00ebab87a9a722c5b5340dee54', './tiki-list_kaltura_entries.php', '24.9', 0),
('37a425bc59c9f420aa09a4c61751ab5e', './tiki-list_object_permissions.php', '24.9', 0),
('67b8a339f47812d48803546893a2ad16', './tiki-list_posts.php', '24.9', 0),
('cb2b14b66e7d918e27fa872df7e7a020', './tiki-list_quizzes.php', '24.9', 0),
('88c95396623873acbcbc189e6e7121d5', './tiki-list_submissions.php', '24.9', 0),
('e3f6c924c804c01414572b20524e618e', './tiki-list_surveys.php', '24.9', 0),
('94504906c0b684b4f5c5c67f96bef78e', './tiki-list_trackers.php', '24.9', 0),
('5c053d560e8fe8cea2096fae0aea395b', './tiki-list_users.php', '24.9', 0),
('f8b585de6996d0980af7b24e2f25d7fd', './tiki-listpages.php', '24.9', 0),
('3d678abb5d4d0ee16ad7ac5d6bc6fd91', './tiki-live_support_admin.php', '24.9', 0),
('d7a089052373a8ca03f10051d8a548c4', './tiki-live_support_chat_frame.php', '24.9', 0),
('924b9375dec009ac778f7f0800a9eadf', './tiki-live_support_chat_window.php', '24.9', 0),
('b466f80321e58149a2decaf883cb81b3', './tiki-live_support_client.php', '24.9', 0),
('6da688275f98c2cbcb902af560fc6492', './tiki-live_support_console.php', '24.9', 0),
('f399597849b582fffc0f781e81a5782f', './tiki-live_support_message.php', '24.9', 0),
('831e894bfd777bef436f64dbb3548d60', './tiki-live_support_server.php', '24.9', 0),
('64f5e5eae33828570a377ffb723bd1d9', './tiki-live_support_transcripts.php', '24.9', 0),
('f75b8d1a4d6a3cdd3fcc221d79ecc746', './tiki-log_bigbluebutton_leave.php', '24.9', 0),
('371ac52868c7843b286444050bd74949', './tiki-login.php', '24.9', 0),
('d3b329ed037efb721ddde3c0337c4bb1', './tiki-login_hybridauth.php', '24.9', 0),
('04a674e735d0c70f05352ac88ada4a3a', './tiki-login_openid.php', '24.9', 0),
('8a81b605cb76dd7fffddb07f9280cae3', './tiki-login_scr.php', '24.9', 0),
('1c2a9fc78f85be00227037eb9de2d987', './tiki-login_validate.php', '24.9', 0),
('c639f2d5ca64cb38855b8adc95c901c6', './tiki-logout.php', '24.9', 0),
('3eb4692e440e70443af0763f17388292', './tiki-mailin-code.php', '24.9', 0),
('788896a8694837d27a5a182f1bbb542e', './tiki-mailin.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('741ba7a57db14aad1b66ff21839a3d4d', './tiki-mindmap.php', '24.9', 0),
('7a8443afd642f725a01da30a319d4692', './tiki-minical.php', '24.9', 0),
('8fe08fe7bf13e6aa71f8497e6cb2dbc2', './tiki-minical_export.php', '24.9', 0),
('d6bbf991ad46aba11fdf19e6487e19ca', './tiki-minical_prefs.php', '24.9', 0),
('c2144a14482b23ddb3e62960af82945f', './tiki-minical_reminders.php', '24.9', 0),
('209bae1ef656d71002b51cb5c376cce0', './tiki-minichat_ajax.php', '24.9', 0),
('69bbea89e0fb4e4ab8bec722a22f46e3', './tiki-mods.php', '24.9', 0),
('fe868fc67aaeb8ec0dffad6305844c0e', './tiki-module_controls.php', '24.9', 0),
('4268da8aebb4e031fdb38f10bb4f343a', './tiki-modules.php', '24.9', 0),
('6562cc529d0abbb51f84c85710b0f3e4', './tiki-monitor.php', '24.9', 0),
('66a52bbe192864b0f8b6e1127d0ebb88', './tiki-my_tiki.php', '24.9', 0),
('06f921f0f9c626b8efcd9e9e5bc083d0', './tiki-mytiki_shared.php', '24.9', 0),
('5795da205cb0cdb8832f7bf8d1c8bd9f', './tiki-newsletter_archives.php', '24.9', 0),
('bafff271dbed7d5fa7867fdf80e8b8fb', './tiki-newsletters.php', '24.9', 0),
('2354323340539b2e5723f708afc320db', './tiki-notepad_get.php', '24.9', 0),
('b701ec992c9e189ced9886d05b53cf4c', './tiki-notepad_list.php', '24.9', 0),
('a71771166aa21122d6adeb44aaa7fbba', './tiki-notepad_read.php', '24.9', 0),
('d7f276fd065c37a55d04a6c2d8391fac', './tiki-notepad_write.php', '24.9', 0),
('96c7f8476f2a0bae440abd5cac2b1d4e', './tiki-object_watches.php', '24.9', 0),
('00c218195a99ddc48158ee148847767e', './tiki-objectpermissions.php', '24.9', 0),
('48d60c450bbd572538c7c23e13fe5b07', './tiki-old_polls.php', '24.9', 0),
('8ac6b43c54534e6d87bc48cdad7c089a', './tiki-orphan_pages.php', '24.9', 0),
('f35e03151bbb6afff786e2c4c4e43b23', './tiki-page.php', '24.9', 0),
('1f2483d4729cfbf8b698fd1d1af478b5', './tiki-page_contribution.php', '24.9', 0),
('6a9f11aca270386ebfcad89f75f79dc8', './tiki-page_loader.php', '24.9', 0),
('840422e583f75c02d4aaa50b13f0a093', './tiki-pagehistory.php', '24.9', 0),
('13da9d33023a521d59e6fe16c99634f2', './tiki-payment.php', '24.9', 0),
('cb5c0d19e537ebd1baba8b51c8b29961', './tiki-performance_stats.php', '24.9', 0),
('e1cef8cd40ac66f4e4b69462a717258b', './tiki-phpinfo.php', '24.9', 0),
('510112b1a127f798d23a2c2c8406ff1e', './tiki-pick_avatar.php', '24.9', 0),
('5d242137a96c6081955f5ca06127f0f3', './tiki-pluginlist_experiment.php', '24.9', 0),
('e75631a5122b24c8a82bded9a3937d4c', './tiki-plugins.php', '24.9', 0),
('de74280f078ac4d6cb96e51364bd87fe', './tiki-poll_form.php', '24.9', 0),
('eab2932cb5079827eac59792508bc253', './tiki-poll_results.php', '24.9', 0),
('8668dbd89d233b52a94c830c46d6568b', './tiki-preference_translate.php', '24.9', 0),
('85fceeb0bf463d1629bb114bd8106148', './tiki-print.php', '24.9', 0),
('ed825a7bc18033ae5c74c1d3a3d595f9', './tiki-print_article.php', '24.9', 0),
('8c270656ecd1dae4a38ee8c2646e38ed', './tiki-print_blog_post.php', '24.9', 0),
('46c43c3e735728a83797d7de90b42c14', './tiki-print_indexed.php', '24.9', 0),
('7da76a390a89a40fced772105655cd72', './tiki-print_multi_pages.php', '24.9', 0),
('0947a830f3fd0e355f18ee6d8481f5b6', './tiki-print_pages.php', '24.9', 0),
('077b1af9f4c7c17d3d80f32186331a7d', './tiki-pv_chart.php', '24.9', 0),
('2009b8032f4d69b2e04e82e771e0ac19', './tiki-quiz_download_answer.php', '24.9', 0),
('9636239520900531f56913c51be29f4b', './tiki-quiz_edit.php', '24.9', 0),
('cfca76e85966fa536e93baf69ba55fc5', './tiki-quiz_result_stats.php', '24.9', 0),
('843c1e08054c56952d2434daec87e27b', './tiki-quiz_stats.php', '24.9', 0),
('1ec145a887b21c19fb766924b56520e1', './tiki-quiz_stats_quiz.php', '24.9', 0),
('65f6f1387fe6868eae731020a3ba63c3', './tiki-read_article.php', '24.9', 0),
('d2730ede8b16bd0d1f33e0ec449a857e', './tiki-received_articles.php', '24.9', 0),
('f17946ac8df921e2b08e5a966b22fdac', './tiki-received_pages.php', '24.9', 0),
('22391893b5149a2a3a097a23119c4c67', './tiki-references.php', '24.9', 0),
('4c19fd242bbdf1339e1ea3cc4e983f16', './tiki-referer_stats.php', '24.9', 0),
('45ed1fa2da731f842cd576e5919ad91b', './tiki-register.php', '24.9', 0),
('855d7a37eb816351659e81a1285817b5', './tiki-register_site.php', '24.9', 0),
('ffdce544cef30e9f45fe64c4a8593fef', './tiki-remind_password.php', '24.9', 0),
('a9158cd88c5b7d26a6f0e554fad5606f', './tiki-rename_page.php', '24.9', 0),
('4569f3fc4a14abccfb570fae42a0f542', './tiki-report_direct_object_perms.php', '24.9', 0),
('76800d8290af999976852382bc4f899b', './tiki-robots.php', '24.9', 0),
('c71668abebee7fe2e48e90818d24de2d', './tiki-rollback.php', '24.9', 0),
('f8ccd0ec9873c9c8ce849948e7ed25cc', './tiki-rss_error.php', '24.9', 0),
('435ec0f6bccb1043ba6f1f7cc085cbd7', './tiki-search_replace.php', '24.9', 0),
('a61987329aa439570c707f3bd8e2cc9f', './tiki-search_stats.php', '24.9', 0),
('334abd88bad4dde1efaad46f437a2055', './tiki-searchindex.php', '24.9', 0),
('8c6b19f3281bcaf8f066a39329256ddb', './tiki-searchresults.php', '24.9', 0),
('25c3618da382837b5c8580f3650cde66', './tiki-section_options.php', '24.9', 0),
('acb962e01c4f2188f0d23f0ba10abea3', './tiki-sefurl.php', '24.9', 0),
('4e4b3eeaecacc949447d9362d3c06a7a', './tiki-send_mail.php', '24.9', 0),
('22e1d2c5566f89679ab5b6dd115f2673', './tiki-send_newsletters.php', '24.9', 0),
('2a20e57d3550cf165483ede67cf55eee', './tiki-send_objects.php', '24.9', 0),
('87355f84705fdadd487073aeed094a03', './tiki-setup.php', '24.9', 0),
('9553eba91b0209a4e714e56f264d2565', './tiki-setup_base.php', '24.9', 0),
('5096e9f4c644b4d584a4c0c3970bd850', './tiki-share.php', '24.9', 0),
('498dbad669f0ef60eaa23bfa0ddb27c6', './tiki-sheets.php', '24.9', 0),
('05625399c9d133c720c982ba2129a9f6', './tiki-short_url.php', '24.9', 0),
('e409d326cc932272e8bfc01b8760015f', './tiki-shoutbox.php', '24.9', 0),
('3289271ff6397459c54731ae0a7531f9', './tiki-shoutbox_rss.php', '24.9', 0),
('aa61ec1163ba95fbe3c43c4a36ca3f4a', './tiki-show_user_avatar.php', '24.9', 0),
('1b0ebe5ef2fe05b24c65cd860c1120c2', './tiki-sitemap.php', '24.9', 0),
('2bdf908ec1bbcb2724f8a66c59c31852', './tiki-slideshow.php', '24.9', 0),
('27696e51e672908e6be2fe4050fa3844', './tiki-socialnetworks.php', '24.9', 0),
('8425bfdbdb5bdf792a61f1dcf2e1e825', './tiki-socialnetworks_firstlogin.php', '24.9', 0),
('5ae30faa7722a4371d303285400cc727', './tiki-socialnetworks_linkedin.php', '24.9', 0),
('6ac0ed2492dccd9be592c4f0ab902bd8', './tiki-sqllog.php', '24.9', 0),
('88d8e8693a37f68facdf3aafbc2a5794', './tiki-stats.php', '24.9', 0),
('3a0e2ecde9c57d5fa9359038a2c82a3b', './tiki-survey_stats.php', '24.9', 0),
('bf08a80d8b0dac1bbcb291e220c981da', './tiki-survey_stats_survey.php', '24.9', 0),
('d9f5b449983d8f70e487a22de7a87d4d', './tiki-switch_lang.php', '24.9', 0),
('c381a48cf033add5e935f1278472b05d', './tiki-switch_perspective.php', '24.9', 0),
('e879a3deecc1fa70dc964d668ba15265', './tiki-switch_theme.php', '24.9', 0),
('993d43e8a79c08c8f9d581d3abe3882c', './tiki-syslog.php', '24.9', 0),
('4c2ce3211c3a4a54e94201d6351b2641', './tiki-take_quiz.php', '24.9', 0),
('e47ddf0813aa9479ef60706f00cbd18e', './tiki-take_survey.php', '24.9', 0),
('7b23a7809d0147d6101e8a463d31617b', './tiki-tc.php', '24.9', 0),
('ce09ab7dfc2ca579084c33b2250788f0', './tiki-testGD.php', '24.9', 0),
('88605154c19edd0768380d6b7f14979b', './tiki-theme_control.php', '24.9', 0),
('926352f4bdbd92cf794274fc8522acc1', './tiki-theme_control_objects.php', '24.9', 0),
('d6153a69218219b1a5be60186e3ff072', './tiki-theme_control_sections.php', '24.9', 0),
('70ba42985ea20fd1df1fdaaa4e3b564c', './tiki-timestamp.php', '24.9', 0),
('94e545a39dd4b32f45c5201d3269193e', './tiki-tracker_http_request.php', '24.9', 0),
('046928a29b2b9d225f63f7f4507c6812', './tiki-tracker_rss.php', '24.9', 0),
('71f8ddb7945d87a7859314bad95c9422', './tiki-tracker_view_history.php', '24.9', 0),
('30c522fc5dd136c9da66b3378bdc2b6d', './tiki-upload_file.php', '24.9', 0),
('a0f588bbfe685f4e489a5f338fdc0e79', './tiki-usage_chart.php', '24.9', 0),
('29c3868bbe1bb5b8ee0fefb55fe7ed23', './tiki-user_assigned_modules.php', '24.9', 0),
('60957e73470ac0ea0f0520e2c8f38007', './tiki-user_bookmarks.php', '24.9', 0),
('3d103058b8d2225f61d9915cfccdddcb', './tiki-user_cached_bookmark.php', '24.9', 0),
('57fae1e25a3b8fd082c3c1a04cf8a241', './tiki-user_contacts_prefs.php', '24.9', 0),
('fd28e3980cad8d0919e87b11f2f9c7c4', './tiki-user_information.php', '24.9', 0),
('e43aa84884afe5d441d49efacdaeea27', './tiki-user_mailin.php', '24.9', 0),
('aaac22cc507d31f3f5e712a92acbab0a', './tiki-user_notifications.php', '24.9', 0),
('7cc529bba64298997bc8dda43f9f9178', './tiki-user_preferences.php', '24.9', 0),
('474da7b197583d05af3e8250e93c6e0e', './tiki-user_reports.php', '24.9', 0),
('95b4981eaf0e835688f5bf7dd3d0f842', './tiki-user_reports_send.php', '24.9', 0),
('9d2daafdcdadd812ca875ceac0ea4991', './tiki-user_tasks.php', '24.9', 0),
('91f3181659b12210d323d7552856f41f', './tiki-user_unified_details.php', '24.9', 0),
('5f9b9b05808daccfeaa6eadb04355f5d', './tiki-user_watches.php', '24.9', 0),
('3ff54400eb30a6bb9312d6568835d9b9', './tiki-userfiles.php', '24.9', 0),
('ab0aceb1ba4ffc3351b23ed631b83f1b', './tiki-usermenu.php', '24.9', 0),
('05b2e7f2937fab83c3a732f67521e815', './tiki-userupload.php', '24.9', 0),
('0b0574404cdf90b2a01276cc18a76ecc', './tiki-userversions.php', '24.9', 0),
('3c1f6308bb5f2799f52f223d6bcae6cd', './tiki-view_articles.php', '24.9', 0),
('b45a46c6a77fe9699e641418f8e0663b', './tiki-view_banner.php', '24.9', 0),
('7c32707d53ffafb8a3082fd01d64db07', './tiki-view_blog.php', '24.9', 0),
('e80222d11a4a70f94a5c004e23828878', './tiki-view_blog_post.php', '24.9', 0),
('423a0a1077fd1055b24147e4a02c4d33', './tiki-view_blog_post_image.php', '24.9', 0),
('57b54948bbfbb3a2c5987048bd1ce8ff', './tiki-view_cache.php', '24.9', 0),
('cf2268f2355b1c4e061ed98f78569972', './tiki-view_faq.php', '24.9', 0),
('2d46e44b8cb08da91f9d188c54712af8', './tiki-view_forum.php', '24.9', 0),
('77ca950bc6a3cf50e374e82a0459f1a2', './tiki-view_forum_thread.php', '24.9', 0),
('7e841e866ce893c499b9b7577239263e', './tiki-view_minical_topic.php', '24.9', 0),
('e342fb93daf615f7aa6c7b736e469218', './tiki-view_sheets.php', '24.9', 0),
('03aa196005489d317320d4d66f38a629', './tiki-view_tracker.php', '24.9', 0),
('5de27a29440aac78631dfb049e947cf4', './tiki-view_tracker_item.php', '24.9', 0),
('9c063882feb7b4cc84da5a66b3ac2504', './tiki-view_tracker_more_info.php', '24.9', 0),
('9f10d3e420eb498e78cb128abc4d3997', './tiki-webdav.php', '24.9', 0),
('aec3b41b5a0da2be7d225b03536d3e76', './tiki-webmail.php', '24.9', 0),
('1c570e99d575f4dad579fe25e32b349b', './tiki-webmail_contacts.php', '24.9', 0),
('81523ea5ad61b6ab4fdd495689b8abb2', './tiki-webservices.php', '24.9', 0),
('523e1da34c7dcf7844b58e28384fc2e0', './tiki-wiki_rankings.php', '24.9', 0),
('6f96972777de0f556fdd059f4a83aaca', './tiki-wiki_rss.php', '24.9', 0),
('6855f32a0b752e18e6692f3bdeaa60be', './tiki-wiki_rss_no_diff.php', '24.9', 0),
('233d667249c51aa40168600cc5d1fbec', './tiki-wikiplugin_edit.php', '24.9', 0),
('13e3aa2e92d38beb55ad793ec5e7149a', './tiki-wizard_admin.php', '24.9', 0),
('607586597391786f6619541382f7f27d', './tiki-wizard_user.php', '24.9', 0),
('9e7112153f96f321a11321bbf4214d8c', './tiki-xmlrpc_services.php', '24.9', 0),
('d6fb05a8ea80d246798e377239752a65', './tiki_tests/index.php', '24.9', 0),
('fb1825dd1f470aa7d333cf1028a1a4ea', './tiki_tests/tests/index.php', '24.9', 0),
('2bddaaf17148b9a7d295b76051821847', './tiki_tests/tiki-tests_edit.php', '24.9', 0),
('8a746f999385d6c5d7018ec19b20e0b7', './tiki_tests/tiki-tests_list.php', '24.9', 0),
('27f1ca713c7dadff927be36686231c48', './tiki_tests/tiki-tests_record.php', '24.9', 0),
('c5e64eeeabc01d5dc9566265ed002c60', './tiki_tests/tiki-tests_replay.php', '24.9', 0),
('38cebe14be45fb03465d40b73de71142', './tiki_tests/tiki-tests_show_xpath.php', '24.9', 0),
('ae39ada0a7c6ef1b5c4f3cd2b0976e54', './tiki_tests/tikitestslib.php', '24.9', 0),
('90e909a604c16127cf7d92c4fd8ec80b', './validate-ajax.php', '24.9', 0),
('86f1b17113e54b95ec9f604e319f9ffc', './vendor_bundled/vendor/Sam152/Javascript-Equal-Height-Responsive-Rows/grids.min.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/Sam152/Javascript-Equal-Height-Responsive-Rows/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/Sam152/index.php', '24.9', 0),
('c1e23b8b447019abc9b0d3b640cda817', './vendor_bundled/vendor/adodb/adodb-php/adodb-active-record.inc.php', '24.9', 0),
('a84e7a0fc925905a93462882b4e56795', './vendor_bundled/vendor/adodb/adodb-php/adodb-csvlib.inc.php', '24.9', 0),
('ccb6edc18e3af52a126f8b1501379d55', './vendor_bundled/vendor/adodb/adodb-php/adodb-datadict.inc.php', '24.9', 0),
('1059b87430fbe1aa14893f5aad91446d', './vendor_bundled/vendor/adodb/adodb-php/adodb-error.inc.php', '24.9', 0),
('5914762257d9f8dfec772e067e9deba0', './vendor_bundled/vendor/adodb/adodb-php/adodb-errorhandler.inc.php', '24.9', 0),
('ae6fcf69062a83fd56768adfaf8dc019', './vendor_bundled/vendor/adodb/adodb-php/adodb-errorpear.inc.php', '24.9', 0),
('383a3e901c69100c08dce1c85879a427', './vendor_bundled/vendor/adodb/adodb-php/adodb-exceptions.inc.php', '24.9', 0),
('6e900f599a824b75d0e441aa3fec0203', './vendor_bundled/vendor/adodb/adodb-php/adodb-lib.inc.php', '24.9', 0),
('74b913bc248311bd5df0e7dc04d1e55e', './vendor_bundled/vendor/adodb/adodb-php/adodb-loadbalancer.inc.php', '24.9', 0),
('bdc29c3936b5c3d622e189d5c3959373', './vendor_bundled/vendor/adodb/adodb-php/adodb-memcache.lib.inc.php', '24.9', 0),
('8f3e1ef69e4cc786d4a55a400e4502e8', './vendor_bundled/vendor/adodb/adodb-php/adodb-pager.inc.php', '24.9', 0),
('dd54bd630b4e651ab0b627cce66236fe', './vendor_bundled/vendor/adodb/adodb-php/adodb-pear.inc.php', '24.9', 0),
('b02eb871ecd096a01eb4a1205e0b41df', './vendor_bundled/vendor/adodb/adodb-php/adodb-perf.inc.php', '24.9', 0),
('c0f91603c1d9bf73c6ecba9dcbbd7724', './vendor_bundled/vendor/adodb/adodb-php/adodb-time.inc.php', '24.9', 0),
('f8a65d45d9ebd701ba290750b9524d0f', './vendor_bundled/vendor/adodb/adodb-php/adodb-xmlschema.inc.php', '24.9', 0),
('e3164c319dc327a9ae887e485eb21758', './vendor_bundled/vendor/adodb/adodb-php/adodb-xmlschema03.inc.php', '24.9', 0),
('f484d13954b0436f799fa69ad4d10108', './vendor_bundled/vendor/adodb/adodb-php/adodb.inc.php', '24.9', 0),
('722309e13c1ac6e2f2b4e68d10a3dd21', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-access.inc.php', '24.9', 0),
('99f980e1b4a960e67621d70dc1266517', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-db2.inc.php', '24.9', 0),
('7de2050f2e7db9d81d1d05956fb5cefe', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-firebird.inc.php', '24.9', 0),
('fc30e938d2cce3f64fb29a0c9255dd76', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-generic.inc.php', '24.9', 0),
('ea36679d329b42ddaf4a03fe75913f66', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-ibase.inc.php', '24.9', 0),
('b8fe5765030deee7c0d0c7b08d381604', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-mssql.inc.php', '24.9', 0),
('c875e3b7bfc75c1dccf708287cdc23a0', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-mssqlnative.inc.php', '24.9', 0),
('7b0f60e38aecf8e1fd27748276c89895', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-mysql.inc.php', '24.9', 0),
('fe66cc7bfe78d74bbf3fefcaba17463c', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-oci8.inc.php', '24.9', 0),
('951d87252e66b6a49d0217869ea62b0a', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-postgres.inc.php', '24.9', 0),
('af6932268f7ab6f694470168d72a7d58', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-sapdb.inc.php', '24.9', 0),
('0e69efdc4a52389382a9ad5ff88a3c52', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-sqlite.inc.php', '24.9', 0),
('96a34a8acf529816ce5839ef048a87b7', './vendor_bundled/vendor/adodb/adodb-php/datadict/datadict-sybase.inc.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/datadict/index.php', '24.9', 0),
('53b2b2d824b8aefdf0ce8f48217d7778', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-access.inc.php', '24.9', 0),
('15e62bfafadacbeec2626dbd0aa35bd4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado.inc.php', '24.9', 0),
('9112d8c635d042c40364ed4c4d006354', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado5.inc.php', '24.9', 0),
('4f137695676c51f45b49e8af780dd235', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado_access.inc.php', '24.9', 0),
('d08ad5e91a841d194cb399f084eca1b4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ado_mssql.inc.php', '24.9', 0),
('bac10c35e4cf22470effa9d6ececc59c', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ads.inc.php', '24.9', 0),
('57cb10101be9b4983a0c9b73eb539aa0', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-borland_ibase.inc.php', '24.9', 0),
('6d3bfed1c980cd1940e161971c5f86c0', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-csv.inc.php', '24.9', 0),
('e0f4275a1d0b6ae3077272f4a2483021', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-db2.inc.php', '24.9', 0),
('01b1ccfcc63d559fbfc9afd951b20f4a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-db2oci.inc.php', '24.9', 0),
('813d11ad8535cb74504ba7fe8896ae61', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-db2ora.inc.php', '24.9', 0),
('a889596a6fd3ddfe51dacaaa12df994b', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-fbsql.inc.php', '24.9', 0),
('f9b2fa8d97ee22c56365bf291bb06db3', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-firebird.inc.php', '24.9', 0),
('85e9d61f6378e1a3e5c51731910806aa', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ibase.inc.php', '24.9', 0),
('3cecbec1fa865338d31d2f65d5a113ad', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-informix72.inc.php', '24.9', 0),
('b395bb4c1f88811be6baa445d9305ea4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-ldap.inc.php', '24.9', 0),
('05285150f13f8fe42224734471f5cb18', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssql.inc.php', '24.9', 0),
('baaff14252b7344a017b8976e026cabb', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssql_n.inc.php', '24.9', 0),
('e03a8735a36d822ac9ce76761766d10d', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssqlnative.inc.php', '24.9', 0),
('579835c331bea6ecad0c501c62c817f9', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mssqlpo.inc.php', '24.9', 0),
('20d43a5d3eed19f130c628929a19cfe2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-mysqli.inc.php', '24.9', 0),
('09747ec47b78fc5644907962a3582a51', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-netezza.inc.php', '24.9', 0),
('826b28a9b6a42114495b1c57a1b8920a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci8.inc.php', '24.9', 0),
('54e0c8ce8a6b749254f57f8462c1855e', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci805.inc.php', '24.9', 0),
('d83cd96cee212614f1f4f61e5257792a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci8po.inc.php', '24.9', 0),
('afe54a5bfc49107ae7b8128d0eddf1e5', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oci8quercus.inc.php', '24.9', 0),
('e81e33dced107c1fc0b82252652052e9', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc.inc.php', '24.9', 0),
('f511537aa2398d443901e0727d0b6b33', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_db2.inc.php', '24.9', 0),
('274d6f960c158fc9f04702c10b02327a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_mssql.inc.php', '24.9', 0),
('141c18a1262b2cf52b8caa5b1dbad88d', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_mssql2012.inc.php', '24.9', 0),
('5368e398730549b09ecfd477d66e1835', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbc_oracle.inc.php', '24.9', 0),
('b7e4fb8ac1120397c71000dfa62d6d62', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbtp.inc.php', '24.9', 0),
('a67f05ef89a55a40c625cc9996e7928c', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-odbtp_unicode.inc.php', '24.9', 0),
('664bbd959351a2565f0c884114d4c0d9', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-oracle.inc.php', '24.9', 0),
('4041310f1a52ab9e2ad3c6567426eaf5', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo.inc.php', '24.9', 0),
('f8d83ad7970e792bca6a22a9ce6eb5d2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_dblib.inc.php', '24.9', 0),
('ff5c83ddf861793dfd0e129fc52803a2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_firebird.inc.php', '24.9', 0),
('289fe077a9b9bed99bc66acbe48fa84f', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_mssql.inc.php', '24.9', 0),
('ecbd41c7099492b5735768f7a035f519', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_mysql.inc.php', '24.9', 0),
('0b848afb6e1f209924bd851c151901e6', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_oci.inc.php', '24.9', 0),
('5f1d6cedf3747b5233f017a254a408a6', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_pgsql.inc.php', '24.9', 0),
('c3512b55339d9da9ab2f88d511108807', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_sqlite.inc.php', '24.9', 0),
('1f9370a6d55d41440b941480125d9453', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-pdo_sqlsrv.inc.php', '24.9', 0),
('fea26748f516731461a989ac00e414b8', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres.inc.php', '24.9', 0),
('7ba60e9d1895cad2f1c7c608ead73301', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres64.inc.php', '24.9', 0),
('186509517f39396dedae84259cbc0b3a', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres7.inc.php', '24.9', 0),
('d2280ebaa952d7b781a0c5ed7ab76969', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres8.inc.php', '24.9', 0),
('689f2ce83f70d3d014cd95dffc703596', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-postgres9.inc.php', '24.9', 0),
('0c8ab8161a16bdd94cf2bea2ff92d96c', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-proxy.inc.php', '24.9', 0),
('efc9617936ba24ff5846c61115b487c7', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sapdb.inc.php', '24.9', 0),
('66058a88f4da4d506837fe8cc03306bd', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlanywhere.inc.php', '24.9', 0),
('b8955e0b4f2b6585a9dbfcd9a1dc79c2', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlite.inc.php', '24.9', 0),
('7349f1515629157e09a4638874554153', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlite3.inc.php', '24.9', 0),
('2eab7bba1ef451f4f7c8bc5847c91d91', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sqlitepo.inc.php', '24.9', 0),
('c65b12971117d2fa7dd1fc29361f7a1d', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sybase.inc.php', '24.9', 0),
('b52598c53a6fb63d94c48913b688c5a4', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-sybase_ase.inc.php', '24.9', 0),
('56b5a13abad94e14a7b3dbd4ab71d944', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-text.inc.php', '24.9', 0),
('7ea2bf13c8bda10ff86eb5841a70ba60', './vendor_bundled/vendor/adodb/adodb-php/drivers/adodb-vfp.inc.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/drivers/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/index.php', '24.9', 0),
('add136e231a627b7be351ff6ca9c2367', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ar.inc.php', '24.9', 0),
('71e73244678b3f04fd8e690d3e58bdbf', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-bg.inc.php', '24.9', 0),
('366f1f60d3836fa4c722340bc3c1dab8', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ca.inc.php', '24.9', 0),
('d4f4966c051b922ec4d17ac05e054718', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-cn.inc.php', '24.9', 0),
('09ce8fc357788b5115f4c912d3c4f97b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-cz.inc.php', '24.9', 0),
('e7f979d9655a9e9891c7e3652763cc68', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-da.inc.php', '24.9', 0),
('235fc4e9e38107c3d2d1db99f866b10a', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-de.inc.php', '24.9', 0),
('7b066499ec5b57c85119668cbeee220c', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-en.inc.php', '24.9', 0),
('b26a255006685960b871a3c9cbc8fd22', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-eo.inc.php', '24.9', 0),
('ebed7521e409da27c849432ab20d9fc9', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-es.inc.php', '24.9', 0),
('f9814b4da90fb900ccdac4681fc163b1', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-fa.inc.php', '24.9', 0),
('55883bb8c710f8c3109b3d398a9ec61a', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-fr.inc.php', '24.9', 0),
('3a996e75b894a114f75b100003081c3b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-hu.inc.php', '24.9', 0),
('0201b6bb3c03a221e6582a631443588c', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-id.inc.php', '24.9', 0),
('4e4c73b4513243e22f80ff07d937d6ae', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-it.inc.php', '24.9', 0),
('86a31b1f65fff792b06c6d99e15db6f4', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ka.inc.php', '24.9', 0),
('acaed1ee8440ac851ccd3cf96efa4221', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-nl.inc.php', '24.9', 0),
('dea11f79441cdaecafcedd12d550aa6d', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-oc.inc.php', '24.9', 0),
('a7032a4c367d69ca1a43f61a4741ca7b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-pl.inc.php', '24.9', 0),
('d6c502b7c98356aa4b2eb6e6a00f9f2b', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-pt-br.inc.php', '24.9', 0),
('00ddf4bf439c1e263db8648b4288fa0d', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ro.inc.php', '24.9', 0),
('38d7c632415228e76fe87c94dbc0e38f', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-ru.inc.php', '24.9', 0),
('d6f7146f671afdeda08973259d8cebf0', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-sv.inc.php', '24.9', 0),
('7067b8cda2f2d2f8d1283e41b22e36ae', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-th.inc.php', '24.9', 0),
('426d22512633a8e48c6c76bb4b8c8e5d', './vendor_bundled/vendor/adodb/adodb-php/lang/adodb-uk.inc.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/lang/index.php', '24.9', 0),
('2229a01e49521509b53180de4df91c98', './vendor_bundled/vendor/adodb/adodb-php/pear/Auth/Container/ADOdb.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/pear/Auth/Container/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/pear/Auth/index.php', '24.9', 0),
('749ac3502774282a8f9ef1e7bdc01e21', './vendor_bundled/vendor/adodb/adodb-php/pear/auth_adodb_example.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/pear/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/perf/index.php', '24.9', 0),
('4f880699033926d77954c6f31016dd47', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-db2.inc.php', '24.9', 0),
('63b4cb1d5b1a0b3670192d5453ef4941', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-mssql.inc.php', '24.9', 0),
('c12452bf53991086bf96e18e9e4da931', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-mssqlnative.inc.php', '24.9', 0),
('cbb73967f01b80b362d102343bb1600e', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-mysql.inc.php', '24.9', 0),
('c9b0bb9f4029ad7001b6498a0d768095', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-oci8.inc.php', '24.9', 0),
('3788786e2c222482bc7886441c83b922', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-postgres.inc.php', '24.9', 0),
('1adecd60e384a5a56cb85359fea942ea', './vendor_bundled/vendor/adodb/adodb-php/perf/perf-sqlite3.inc.php', '24.9', 0),
('65789a0767226340f6c06262cb8a4267', './vendor_bundled/vendor/adodb/adodb-php/pivottable.inc.php', '24.9', 0),
('df0e1d4606c8e9ad1534f5f374f63e91', './vendor_bundled/vendor/adodb/adodb-php/rsfilter.inc.php', '24.9', 0),
('4fcc4ffa5dccc34f0a6105052d03584d', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-compress-bzip2.php', '24.9', 0),
('46ade874b83bdfcb7cdeafdd9c928756', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-compress-gzip.php', '24.9', 0),
('cecef8ae8539f6aa6d22ea15cd8219b4', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-cryptsession.php', '24.9', 0),
('095532a91dc1af383527af461cd2d98d', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-cryptsession2.php', '24.9', 0),
('e346d8bb1c9dc44088cf39cbb1b06d78', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-mcrypt.php', '24.9', 0),
('9ae66b8f7f0ba6006a6e8341a2a7d334', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-md5.php', '24.9', 0),
('80aaf47bc05a7e13b2bff9fab5414ca8', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-secret.php', '24.9', 0),
('c191bc4927da251ce1f230d2ab266a1d', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-encrypt-sha1.php', '24.9', 0),
('3a747064dc523138dbb1088ce63564db', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session-clob.php', '24.9', 0),
('45c07858ffb0c205a6533cc8c3420fb1', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session-clob2.php', '24.9', 0),
('69580d7d81f1dde841a050854c88b0a9', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session.php', '24.9', 0),
('7430c142f3b87be511ba2d862fc84eac', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-session2.php', '24.9', 0),
('42fef0886af1f6da31a06de273876b71', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-sessions.mysql.sql', '24.9', 0),
('3c64f822ee1b493b319c6e8196cc06b8', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-sessions.oracle.clob.sql', '24.9', 0),
('08d0fc1f5fbf8b79a4dca43cbd30e3a1', './vendor_bundled/vendor/adodb/adodb-php/session/adodb-sessions.oracle.sql', '24.9', 0),
('c18239e9c4dfc4ff623e1fe22bcf24dc', './vendor_bundled/vendor/adodb/adodb-php/session/crypt.inc.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/session/index.php', '24.9', 0),
('47f0082ee6017b0ee3d4b7479cf0cef2', './vendor_bundled/vendor/adodb/adodb-php/session/old/adodb-cryptsession.php', '24.9', 0),
('9486261a2fce87c3c65aff7748432a26', './vendor_bundled/vendor/adodb/adodb-php/session/old/adodb-session-clob.php', '24.9', 0),
('294fea38ab5a98ee5907f0cb750fc52f', './vendor_bundled/vendor/adodb/adodb-php/session/old/adodb-session.php', '24.9', 0),
('4d0872dca97c054eea02d76ccd98420d', './vendor_bundled/vendor/adodb/adodb-php/session/old/crypt.inc.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/session/old/index.php', '24.9', 0),
('18083471a238982a9289d7631b8dad94', './vendor_bundled/vendor/adodb/adodb-php/toexport.inc.php', '24.9', 0),
('2c011688c0b5f963e2847ff91f665527', './vendor_bundled/vendor/adodb/adodb-php/tohtml.inc.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/adodb-php/xsl/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/adodb/index.php', '24.9', 0),
('9f03100ab5ce18e0049c25c6c4916802', './vendor_bundled/vendor/afarkas/html5shiv/dist/html5shiv-printshiv.min.js', '24.9', 0),
('f4d9dea8e0ae8455500862bbb874d63c', './vendor_bundled/vendor/afarkas/html5shiv/dist/html5shiv.js', '24.9', 0),
('40bd440d29b3a9371b0c63fec41ee64f', './vendor_bundled/vendor/afarkas/html5shiv/dist/html5shiv.min.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/afarkas/html5shiv/dist/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/afarkas/html5shiv/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/afarkas/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/ahand/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/ahand/mobileesp/PHP/index.php', '24.9', 0),
('00fa8121ea05470b6a3efe154de02bc4', './vendor_bundled/vendor/ahand/mobileesp/PHP/mdetect.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/ahand/mobileesp/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/amp/index.php', '24.9', 0),
('823fb79673020e244b8caf9762c908d7', './vendor_bundled/vendor/amphp/amp/lib/CallableMaker.php', '24.9', 0),
('b02943d494e4c3ad5094649c4671fd62', './vendor_bundled/vendor/amphp/amp/lib/CancellationToken.php', '24.9', 0),
('2536a96758249d47c335cc3ab1a7758c', './vendor_bundled/vendor/amphp/amp/lib/CancellationTokenSource.php', '24.9', 0),
('45ae59bb1594561b4e35f12204fe563b', './vendor_bundled/vendor/amphp/amp/lib/CancelledException.php', '24.9', 0),
('0159be38ca9be239bf429b3abcbfd841', './vendor_bundled/vendor/amphp/amp/lib/CombinedCancellationToken.php', '24.9', 0),
('9526c491ba9244432e0dd54a902735ea', './vendor_bundled/vendor/amphp/amp/lib/Coroutine.php', '24.9', 0),
('186d5f9bcdde250f6334a94b25267c5c', './vendor_bundled/vendor/amphp/amp/lib/Deferred.php', '24.9', 0),
('aaf44d82afbc132df598907321dbc2df', './vendor_bundled/vendor/amphp/amp/lib/Delayed.php', '24.9', 0),
('82a069a83df8fca78ac076a3a41a75ed', './vendor_bundled/vendor/amphp/amp/lib/Emitter.php', '24.9', 0),
('2369178402b56237ed541d4c94d09b80', './vendor_bundled/vendor/amphp/amp/lib/Failure.php', '24.9', 0),
('59ab9589c2f90a7b114cd2b5b7800090', './vendor_bundled/vendor/amphp/amp/lib/Internal/Placeholder.php', '24.9', 0),
('36cfae35619054a1eda581b953d08b05', './vendor_bundled/vendor/amphp/amp/lib/Internal/PrivateIterator.php', '24.9', 0),
('b557dcb7a4245bc91037d6b4f6aa3dce', './vendor_bundled/vendor/amphp/amp/lib/Internal/PrivatePromise.php', '24.9', 0),
('53d8a4e35a9174cadf7307fc4094fc0f', './vendor_bundled/vendor/amphp/amp/lib/Internal/Producer.php', '24.9', 0),
('5a2977ad8fdc4ea545e38906a3c36c9d', './vendor_bundled/vendor/amphp/amp/lib/Internal/ResolutionQueue.php', '24.9', 0),
('7fff3c3412f11ac587317ab4f86575c8', './vendor_bundled/vendor/amphp/amp/lib/Internal/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/amp/lib/Internal/index.php', '24.9', 0),
('45d5eed513debcfcdb1b6dd6d539ea82', './vendor_bundled/vendor/amphp/amp/lib/InvalidYieldError.php', '24.9', 0),
('744ca0540644170c0fe43840673515cf', './vendor_bundled/vendor/amphp/amp/lib/Iterator.php', '24.9', 0),
('aef3e0f03eb7b8a39342be918c4b8055', './vendor_bundled/vendor/amphp/amp/lib/LazyPromise.php', '24.9', 0),
('5ffbab9f7be28530e0f6ce2ca8e86803', './vendor_bundled/vendor/amphp/amp/lib/Loop.php', '24.9', 0),
('42063a2655f605b05f518ba0501c6785', './vendor_bundled/vendor/amphp/amp/lib/Loop/Driver.php', '24.9', 0),
('aa17d5cb7d204e2ef76ead18edaa3f38', './vendor_bundled/vendor/amphp/amp/lib/Loop/DriverFactory.php', '24.9', 0),
('4d1e1697a106ae04252a90543fad1953', './vendor_bundled/vendor/amphp/amp/lib/Loop/EvDriver.php', '24.9', 0),
('d81daa78fa4bbc92e68dc21d73d35d6d', './vendor_bundled/vendor/amphp/amp/lib/Loop/EventDriver.php', '24.9', 0),
('6636848fddabb604f11dd3279da560bd', './vendor_bundled/vendor/amphp/amp/lib/Loop/Internal/TimerQueue.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/amp/lib/Loop/Internal/index.php', '24.9', 0),
('d1f4098cd135b52ee6b526b922a8e009', './vendor_bundled/vendor/amphp/amp/lib/Loop/InvalidWatcherError.php', '24.9', 0),
('91e5f588ace2318801d6c0c147118888', './vendor_bundled/vendor/amphp/amp/lib/Loop/NativeDriver.php', '24.9', 0),
('d50f4f09119c9e3be0e2bace3c10b631', './vendor_bundled/vendor/amphp/amp/lib/Loop/TracingDriver.php', '24.9', 0),
('fff8994a6aa167fc26d320d89eb2d19b', './vendor_bundled/vendor/amphp/amp/lib/Loop/UnsupportedFeatureException.php', '24.9', 0),
('2994f8f2a0b3a25d4cb67d6fd14552d2', './vendor_bundled/vendor/amphp/amp/lib/Loop/UvDriver.php', '24.9', 0),
('adf450b3839b4f54d88b7ebbc6cee9c2', './vendor_bundled/vendor/amphp/amp/lib/Loop/Watcher.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/amp/lib/Loop/index.php', '24.9', 0),
('b8d630f94a5e79dd991b23ea34cb5487', './vendor_bundled/vendor/amphp/amp/lib/MultiReasonException.php', '24.9', 0),
('6cc1084f2023825c0e7a16ec81326068', './vendor_bundled/vendor/amphp/amp/lib/NullCancellationToken.php', '24.9', 0),
('aba956d443c2f764ba8f09334797c401', './vendor_bundled/vendor/amphp/amp/lib/Producer.php', '24.9', 0),
('fa000ae4d8f88d01817b0d7bed5d4788', './vendor_bundled/vendor/amphp/amp/lib/Promise.php', '24.9', 0),
('3b0bdf86b3e4041fbe89039aa6f1742d', './vendor_bundled/vendor/amphp/amp/lib/Struct.php', '24.9', 0),
('4b9a727de1f0fdfb354cfbb2befaef92', './vendor_bundled/vendor/amphp/amp/lib/Success.php', '24.9', 0),
('d1c414cb5174ab80d055fb156574064b', './vendor_bundled/vendor/amphp/amp/lib/TimeoutCancellationToken.php', '24.9', 0),
('f2b3d90ca611366d6b00b852b0472aad', './vendor_bundled/vendor/amphp/amp/lib/TimeoutException.php', '24.9', 0),
('f91082dcb8e4056dc07fce9415ce1f7c', './vendor_bundled/vendor/amphp/amp/lib/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/amp/lib/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/byte-stream/index.php', '24.9', 0),
('cb99abc4bd02fc652f9a05962ddc0335', './vendor_bundled/vendor/amphp/byte-stream/lib/Base64/Base64DecodingInputStream.php', '24.9', 0),
('18c3a1acb888515234051ab61efaeb90', './vendor_bundled/vendor/amphp/byte-stream/lib/Base64/Base64DecodingOutputStream.php', '24.9', 0),
('c2c6554350834f1f1f4043e02695a627', './vendor_bundled/vendor/amphp/byte-stream/lib/Base64/Base64EncodingInputStream.php', '24.9', 0),
('51d6f0e047730aae16c7370635e085cb', './vendor_bundled/vendor/amphp/byte-stream/lib/Base64/Base64EncodingOutputStream.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/byte-stream/lib/Base64/index.php', '24.9', 0),
('fd966c1b0072daef2f34670546b25821', './vendor_bundled/vendor/amphp/byte-stream/lib/ClosedException.php', '24.9', 0),
('1fcf04f6f3ce969a66ef935994a13ea1', './vendor_bundled/vendor/amphp/byte-stream/lib/InMemoryStream.php', '24.9', 0),
('a4df7d9b4b5a8193fab2edd81b4fcc30', './vendor_bundled/vendor/amphp/byte-stream/lib/InputStream.php', '24.9', 0),
('bac2dee7b16457153b2ac3e786f0d30f', './vendor_bundled/vendor/amphp/byte-stream/lib/InputStreamChain.php', '24.9', 0),
('8903a4209afd6b50f0ccf5c23738eb56', './vendor_bundled/vendor/amphp/byte-stream/lib/IteratorStream.php', '24.9', 0),
('52317d766c22ffaf63a6ee722f21395a', './vendor_bundled/vendor/amphp/byte-stream/lib/LineReader.php', '24.9', 0),
('9eae465c0daa94c9158b1ba5039fd18b', './vendor_bundled/vendor/amphp/byte-stream/lib/Message.php', '24.9', 0),
('6bf75b6f5e4bd036bd4cea0edf838f70', './vendor_bundled/vendor/amphp/byte-stream/lib/OutputBuffer.php', '24.9', 0),
('358efd6c4c11434e335e5660e862ae2d', './vendor_bundled/vendor/amphp/byte-stream/lib/OutputStream.php', '24.9', 0),
('c8b83b3dab5e289a2d0074148fa831ba', './vendor_bundled/vendor/amphp/byte-stream/lib/Payload.php', '24.9', 0),
('f6bc313eefe89885e3b58fa14f5e26f1', './vendor_bundled/vendor/amphp/byte-stream/lib/PendingReadError.php', '24.9', 0),
('d3dbe69413b0321daf6e947c272a738e', './vendor_bundled/vendor/amphp/byte-stream/lib/ResourceInputStream.php', '24.9', 0),
('327a7fc8724cc3f8a1c6614e822abc71', './vendor_bundled/vendor/amphp/byte-stream/lib/ResourceOutputStream.php', '24.9', 0),
('803e7cc6fd0dfa781bddfe1c6d79d93b', './vendor_bundled/vendor/amphp/byte-stream/lib/StreamException.php', '24.9', 0),
('93cccf4515ec0183bac5ecc723ab261b', './vendor_bundled/vendor/amphp/byte-stream/lib/ZlibInputStream.php', '24.9', 0),
('9f63e3185fbdcc8ee0fb9810ec1d4363', './vendor_bundled/vendor/amphp/byte-stream/lib/ZlibOutputStream.php', '24.9', 0),
('570d45bd9aa3a263180bd3fb0bd0cb51', './vendor_bundled/vendor/amphp/byte-stream/lib/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/byte-stream/lib/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/index.php', '24.9', 0),
('c4dd73a6e8512474ff80c8e4254653c6', './vendor_bundled/vendor/amphp/parallel/lib/Context/Context.php', '24.9', 0),
('40188f78a6e528d0d0af19778aaf3a8a', './vendor_bundled/vendor/amphp/parallel/lib/Context/ContextException.php', '24.9', 0),
('3f7a1b65374dd34be1a4bc56dbdfcb30', './vendor_bundled/vendor/amphp/parallel/lib/Context/ContextFactory.php', '24.9', 0),
('30904e75d0ebbc3a3e27eb08a2ee9285', './vendor_bundled/vendor/amphp/parallel/lib/Context/DefaultContextFactory.php', '24.9', 0),
('e9751aca9aae32f0797051f49b63f931', './vendor_bundled/vendor/amphp/parallel/lib/Context/Internal/ParallelHub.php', '24.9', 0),
('23ba0597ebf42ff537079bcd0eebbba7', './vendor_bundled/vendor/amphp/parallel/lib/Context/Internal/ProcessHub.php', '24.9', 0),
('c8ca522095c43d8dbc824eadd138d7c8', './vendor_bundled/vendor/amphp/parallel/lib/Context/Internal/Thread.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/Context/Internal/index.php', '24.9', 0),
('b12e5ea23f13e632a48bf420b3101084', './vendor_bundled/vendor/amphp/parallel/lib/Context/Internal/process-runner.php', '24.9', 0),
('4e9feaadde4935b904cf0cf1f199dda3', './vendor_bundled/vendor/amphp/parallel/lib/Context/Parallel.php', '24.9', 0),
('57ec50a44756208f0de86ce862257cc9', './vendor_bundled/vendor/amphp/parallel/lib/Context/Process.php', '24.9', 0),
('6578eed74f9a0aff5bcf5488c42bdb78', './vendor_bundled/vendor/amphp/parallel/lib/Context/StatusError.php', '24.9', 0),
('3b268aa26141e7e782435a28f49897f5', './vendor_bundled/vendor/amphp/parallel/lib/Context/Thread.php', '24.9', 0),
('3144f450c1e46fa21ddd44a757b50b09', './vendor_bundled/vendor/amphp/parallel/lib/Context/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/Context/index.php', '24.9', 0),
('7f6c00514cf98061dda1c5884fa77146', './vendor_bundled/vendor/amphp/parallel/lib/Sync/Channel.php', '24.9', 0),
('ace494e06730ea2b9f3d81a924550020', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ChannelException.php', '24.9', 0),
('a4c7fd43ec9e71028dd515ab94c20852', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ChannelParser.php', '24.9', 0),
('d090c4fe7aa5eaa07f39fcbdd65d3f54', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ChannelledSocket.php', '24.9', 0),
('06bbb28feed5b68533d619910b8a0c70', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ChannelledStream.php', '24.9', 0),
('a210eca1f88eaf39e0ad6e717aeb18d3', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ContextPanicError.php', '24.9', 0),
('2688b02201a5dbff7edafa5ddb07b45d', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ExitFailure.php', '24.9', 0),
('2dbd3e69c83b23933f1c44c2f75910f7', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ExitResult.php', '24.9', 0),
('42574a66a85f2ef26ff79ef631187368', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ExitSuccess.php', '24.9', 0),
('93281c549fdeed94a314b5c81549b0e8', './vendor_bundled/vendor/amphp/parallel/lib/Sync/Internal/ParcelStorage.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/Sync/Internal/index.php', '24.9', 0),
('c4ccf93772995fbd42ea8ce791c5ba08', './vendor_bundled/vendor/amphp/parallel/lib/Sync/PanicError.php', '24.9', 0),
('ec0ebe742834850c4418f628a2916e1f', './vendor_bundled/vendor/amphp/parallel/lib/Sync/Parcel.php', '24.9', 0),
('658d8d03bed265c3ed434916cabf76e8', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ParcelException.php', '24.9', 0),
('b36c1704975838ffbabceb9c70fb56e1', './vendor_bundled/vendor/amphp/parallel/lib/Sync/SharedMemoryException.php', '24.9', 0),
('ab91f8134081a46216c57556ba3b8427', './vendor_bundled/vendor/amphp/parallel/lib/Sync/SharedMemoryParcel.php', '24.9', 0),
('313bef6098f6f26b1676761bde9f5aab', './vendor_bundled/vendor/amphp/parallel/lib/Sync/SynchronizationError.php', '24.9', 0),
('f9f956591616cd278db208f731d81b3c', './vendor_bundled/vendor/amphp/parallel/lib/Sync/ThreadedParcel.php', '24.9', 0),
('59045816184fa4d7d88201702e07abc2', './vendor_bundled/vendor/amphp/parallel/lib/Sync/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/Sync/index.php', '24.9', 0),
('e6d76416bcc36c8b1ccf5483ff2c735e', './vendor_bundled/vendor/amphp/parallel/lib/Worker/BasicEnvironment.php', '24.9', 0),
('23903c3de11506f4125d9ccbd9030a6d', './vendor_bundled/vendor/amphp/parallel/lib/Worker/BootstrapWorkerFactory.php', '24.9', 0),
('02ac1b8aa1c01d43a0fce4d9b828afb1', './vendor_bundled/vendor/amphp/parallel/lib/Worker/CallableTask.php', '24.9', 0),
('638d7f7a9e386ae072cff9a3db673cfe', './vendor_bundled/vendor/amphp/parallel/lib/Worker/DefaultPool.php', '24.9', 0),
('f9a99d2c056f7f071b454c86f43801a3', './vendor_bundled/vendor/amphp/parallel/lib/Worker/DefaultWorkerFactory.php', '24.9', 0),
('0a3dc0d18867e328712edc605d39ef72', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Environment.php', '24.9', 0),
('0644c119d7e8cbd6b00ab7f52bad93e3', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/Job.php', '24.9', 0),
('5aeb236c98e441d8d81ed9623df885ce', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/PooledWorker.php', '24.9', 0),
('8ba758bde3339776c84bda5277a17048', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/TaskFailure.php', '24.9', 0),
('17e85ed233d02ab70f3f6759d52ccde6', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/TaskResult.php', '24.9', 0),
('51b77a0f6fa86d4794505803a652900a', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/TaskSuccess.php', '24.9', 0),
('e460526b2548ee045265644c28042e77', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/WorkerProcess.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/index.php', '24.9', 0),
('b6c6399e4829ae0a3efcd33f23bfa0d7', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Internal/worker-process.php', '24.9', 0),
('51f0e63dc728987e0cdb683ccb361358', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Pool.php', '24.9', 0),
('dc22d8cf2645d18478519a62871bef8d', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Task.php', '24.9', 0),
('7da78430014abcd3ccd7aeb763b91d6a', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskError.php', '24.9', 0),
('c2c94a300140610849ceb4f9dd37bb51', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskException.php', '24.9', 0),
('b4f943c341b0a87177f8659d171d472a', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskFailureError.php', '24.9', 0),
('a7e873f2dfb154b071d098651f510dcb', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskFailureException.php', '24.9', 0),
('e56cae824bf6d45f535d7618808d2c42', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskFailureThrowable.php', '24.9', 0),
('a2250bee2f4249367e58df71859da2ef', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskRunner.php', '24.9', 0),
('0a444b0db0dce7557d424353e5249303', './vendor_bundled/vendor/amphp/parallel/lib/Worker/TaskWorker.php', '24.9', 0),
('707652cf1f41ed18fa0f930d5b6ba8db', './vendor_bundled/vendor/amphp/parallel/lib/Worker/Worker.php', '24.9', 0),
('6ff5bc27d5cc10b057f1ef7c63fad860', './vendor_bundled/vendor/amphp/parallel/lib/Worker/WorkerException.php', '24.9', 0),
('4ba969f021b6196342b0f56719d10ea5', './vendor_bundled/vendor/amphp/parallel/lib/Worker/WorkerFactory.php', '24.9', 0),
('c17b2b6e2184de7b2870ed0051a81ad9', './vendor_bundled/vendor/amphp/parallel/lib/Worker/WorkerParallel.php', '24.9', 0),
('49bd97d2acbd4cfa2ee6cc6108dbd1aa', './vendor_bundled/vendor/amphp/parallel/lib/Worker/WorkerProcess.php', '24.9', 0),
('ae237d7183593b432f00deb0ebdcb39f', './vendor_bundled/vendor/amphp/parallel/lib/Worker/WorkerThread.php', '24.9', 0),
('7e7c7c6398415960e3ba2e3d8c107ab2', './vendor_bundled/vendor/amphp/parallel/lib/Worker/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/Worker/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parallel/lib/index.php', '24.9', 0),
('89c2c870942f2aa804d515d96b89ba7a', './vendor_bundled/vendor/amphp/parser/.php-cs-fixer.dist.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parser/index.php', '24.9', 0),
('0669f094c7d34721da0fb03f4f685459', './vendor_bundled/vendor/amphp/parser/src/InvalidDelimiterError.php', '24.9', 0),
('aa0ad2285e6d7e2fc65e5fcc7dbfcda0', './vendor_bundled/vendor/amphp/parser/src/Parser.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/parser/src/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/bin/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/bin/windows/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/index.php', '24.9', 0),
('60a072812c3199e98aedeccfeee6e8b4', './vendor_bundled/vendor/amphp/process/lib/Internal/Posix/Handle.php', '24.9', 0),
('b447f55b9a7a29c7aa8e5c536e00007b', './vendor_bundled/vendor/amphp/process/lib/Internal/Posix/Runner.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/lib/Internal/Posix/index.php', '24.9', 0),
('7cf21438bca61e6f7f02d5931e11ab14', './vendor_bundled/vendor/amphp/process/lib/Internal/ProcessHandle.php', '24.9', 0),
('25442629b3ca865292ccf599c763c2fe', './vendor_bundled/vendor/amphp/process/lib/Internal/ProcessRunner.php', '24.9', 0),
('1dc1e9fc4bfc9a516546eb7404c6fba1', './vendor_bundled/vendor/amphp/process/lib/Internal/ProcessStatus.php', '24.9', 0),
('e5bc6571dedbb0bee9f2656c33adee21', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/Handle.php', '24.9', 0),
('3a1f15ea774cf27e047cc1e9320df31a', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/HandshakeStatus.php', '24.9', 0),
('e9dab476f58fb25259457f3f7b2a3d86', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/PendingSocketClient.php', '24.9', 0),
('91e101a380e2f841bc3289569b3cfd1f', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/Runner.php', '24.9', 0),
('e66583125963eb11aeec10c229a7b43c', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/SignalCode.php', '24.9', 0),
('97df44648e7163b1ee3b68f43478092c', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/SocketConnector.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/lib/Internal/Windows/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/lib/Internal/index.php', '24.9', 0),
('4ceef7ae0b15ab622dc0e4f1d689f445', './vendor_bundled/vendor/amphp/process/lib/Process.php', '24.9', 0),
('6375270122e9aed646110c6d48c41d57', './vendor_bundled/vendor/amphp/process/lib/ProcessException.php', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('cb09bcb5517ef1e73742bfcec1033e09', './vendor_bundled/vendor/amphp/process/lib/ProcessInputStream.php', '24.9', 0),
('3a6e26124ef933c8914bbcc77693594b', './vendor_bundled/vendor/amphp/process/lib/ProcessOutputStream.php', '24.9', 0),
('659cf1be45039a58bcd49befd2b60107', './vendor_bundled/vendor/amphp/process/lib/StatusError.php', '24.9', 0),
('97b906f05d1f75a30214cb486fb2c42b', './vendor_bundled/vendor/amphp/process/lib/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/process/lib/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/serialization/index.php', '24.9', 0),
('49f2e3f89f7eccbc1c844153f2fb473c', './vendor_bundled/vendor/amphp/serialization/src/CompressingSerializer.php', '24.9', 0),
('77cd29d3affda3f34189e87d38cec553', './vendor_bundled/vendor/amphp/serialization/src/JsonSerializer.php', '24.9', 0),
('2c79c4746575d7bb3a2dd65e5d620185', './vendor_bundled/vendor/amphp/serialization/src/NativeSerializer.php', '24.9', 0),
('ceb5de514207bb3acf96fa68ef76f780', './vendor_bundled/vendor/amphp/serialization/src/PassthroughSerializer.php', '24.9', 0),
('ad71c420b1d54bdab72da3284ffe2b3d', './vendor_bundled/vendor/amphp/serialization/src/SerializationException.php', '24.9', 0),
('52c6ab52a709c7eb5b21cb2dfabf4435', './vendor_bundled/vendor/amphp/serialization/src/Serializer.php', '24.9', 0),
('0f94c7a4f8e15c7e79c839f5229326a4', './vendor_bundled/vendor/amphp/serialization/src/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/serialization/src/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/sync/index.php', '24.9', 0),
('7e41bf61d4ea2de09c8764ebbd86de70', './vendor_bundled/vendor/amphp/sync/src/Barrier.php', '24.9', 0),
('999c9bde25f2c0ae6765acee491c062e', './vendor_bundled/vendor/amphp/sync/src/ConcurrentIterator/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/sync/src/ConcurrentIterator/index.php', '24.9', 0),
('88418ff27ece37be019ef1f27c48d3a0', './vendor_bundled/vendor/amphp/sync/src/FileMutex.php', '24.9', 0),
('1b0e31d5f848a5278b41d1b6acb2fceb', './vendor_bundled/vendor/amphp/sync/src/Internal/MutexStorage.php', '24.9', 0),
('cc9e3317edb18bbc3f99e61455451d09', './vendor_bundled/vendor/amphp/sync/src/Internal/SemaphoreStorage.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/sync/src/Internal/index.php', '24.9', 0),
('38780f4035077051411d263dcdc697c8', './vendor_bundled/vendor/amphp/sync/src/KeyedMutex.php', '24.9', 0),
('e1b428344707165459b52a1c998940f4', './vendor_bundled/vendor/amphp/sync/src/KeyedSemaphore.php', '24.9', 0),
('ae5ff82f457960c46a4d499e421b51a2', './vendor_bundled/vendor/amphp/sync/src/LocalKeyedMutex.php', '24.9', 0),
('c75b424418acdae5eed33de196e52d11', './vendor_bundled/vendor/amphp/sync/src/LocalKeyedSemaphore.php', '24.9', 0),
('fb7964a61f76f6c898fe946de7b9314d', './vendor_bundled/vendor/amphp/sync/src/LocalMutex.php', '24.9', 0),
('5bc56d7c708f6e334f5b2b901bc2fdac', './vendor_bundled/vendor/amphp/sync/src/LocalSemaphore.php', '24.9', 0),
('fdd39ebeb010c915ddb491a697b02a5f', './vendor_bundled/vendor/amphp/sync/src/Lock.php', '24.9', 0),
('39d8deb2557ae19cc3d3cfa80d767e6f', './vendor_bundled/vendor/amphp/sync/src/Mutex.php', '24.9', 0),
('8276a51aac4f55d06371602da73d3d11', './vendor_bundled/vendor/amphp/sync/src/PosixSemaphore.php', '24.9', 0),
('e928d3f3887a66035fc086515970a602', './vendor_bundled/vendor/amphp/sync/src/PrefixedKeyedMutex.php', '24.9', 0),
('a1a12f49aab04b352c496bd96f266a27', './vendor_bundled/vendor/amphp/sync/src/PrefixedKeyedSemaphore.php', '24.9', 0),
('7d633c9fed4fbd2f1885a435282229d4', './vendor_bundled/vendor/amphp/sync/src/Semaphore.php', '24.9', 0),
('7c0b4f4a1706f0385e39da96da3bd51a', './vendor_bundled/vendor/amphp/sync/src/SemaphoreMutex.php', '24.9', 0),
('922c2e2c217ca1addeaf53ee3363d89e', './vendor_bundled/vendor/amphp/sync/src/StaticKeyMutex.php', '24.9', 0),
('23976398438748858ac39f4a633977eb', './vendor_bundled/vendor/amphp/sync/src/SyncException.php', '24.9', 0),
('e68cc4d7d74ddaaa671a867d529dec4a', './vendor_bundled/vendor/amphp/sync/src/ThreadedMutex.php', '24.9', 0),
('5a862d601ee8bf1afe31a988e40d3e96', './vendor_bundled/vendor/amphp/sync/src/ThreadedSemaphore.php', '24.9', 0),
('960a3c97853414270ca320b604eaef59', './vendor_bundled/vendor/amphp/sync/src/functions.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/amphp/sync/src/index.php', '24.9', 0),
('d67005e95943457f82f0381a4ff03588', './vendor_bundled/vendor/autoload.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/avianey/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/avianey/jqdoublescroll/index.php', '24.9', 0),
('6e95dd2494216f769895aad08ee15f79', './vendor_bundled/vendor/avianey/jqdoublescroll/jquery.doubleScroll.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/index.php', '24.9', 0),
('d59da0c3cbb6c638add30e0a4a6a81e1', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/BitArray.php', '24.9', 0),
('a3021ba4be3958c04563788bbb23f7bf', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/BitMatrix.php', '24.9', 0),
('c3b0c27e367ca617b373e367fc149b8e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/BitUtils.php', '24.9', 0),
('9e6de556e1e675c2900b9f2d8db3797d', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/CharacterSetEci.php', '24.9', 0),
('73b949abf8f24460e05afbe2105ff5c6', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/EcBlock.php', '24.9', 0),
('f53c873371e1c7df48c246a002851251', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/EcBlocks.php', '24.9', 0),
('7d44c8045fe6154647f9e6773e66c8e9', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/ErrorCorrectionLevel.php', '24.9', 0),
('787a29902b96c4338c3ed53e17818d9a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/FormatInformation.php', '24.9', 0),
('0128f5e4a4a706bb181f61e444098c30', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/Mode.php', '24.9', 0),
('6db969f0ea944932ea0a84f8d1cd61ad', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/ReedSolomonCodec.php', '24.9', 0),
('73a706cf6e1f9d420869ace65bf8acb1', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/Version.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Common/index.php', '24.9', 0),
('3c5a6dfe954ac9f959b50456121ad24f', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/BlockPair.php', '24.9', 0),
('94af6d1105f978a8f0501bdd6e3e06a9', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/ByteMatrix.php', '24.9', 0),
('402622af2fa543a1013c26f5ff35587e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/Encoder.php', '24.9', 0),
('a47086b0734afddc79f3549ad16f8422', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/MaskUtil.php', '24.9', 0),
('31a90c1cd414ca30999a66785de4a063', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/MatrixUtil.php', '24.9', 0),
('a44246d0cadae0e864785e42bb13bc01', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/QrCode.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Encoder/index.php', '24.9', 0),
('95af4f72c439481f267bd83903de015a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/ExceptionInterface.php', '24.9', 0),
('cc835a75527e12e061471f1ac8329871', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/InvalidArgumentException.php', '24.9', 0),
('a1aae0ca514fe724c15b6e4eb4a7602e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/OutOfBoundsException.php', '24.9', 0),
('b57f73d9f31bc095d867048d5eab7b45', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/RuntimeException.php', '24.9', 0),
('27c830cf0faf2c1a3347c0971ae6e04a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/UnexpectedValueException.php', '24.9', 0),
('cac33a1c7f390301341235cc09bfdc81', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/WriterException.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Exception/index.php', '24.9', 0),
('3f8400219939201b60d03d9e01b2b997', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Alpha.php', '24.9', 0),
('da10aa15f9032ae3287bf1013cf4b7f5', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Cmyk.php', '24.9', 0),
('615eb72e3f50e7067ba50333ae4e9a31', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/ColorInterface.php', '24.9', 0),
('2d1024af0da19a81353cbcb93c4fb19c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Gray.php', '24.9', 0),
('4268ee1d388e8ee0b68cbe4e1405e46c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/Rgb.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Color/index.php', '24.9', 0),
('dd2e3ea122f8147c0f93ca9096568abc', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/CompositeEye.php', '24.9', 0),
('cda648eb7233f0691c31961532a55909', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/EyeInterface.php', '24.9', 0),
('8aefd1cc9e1721e0658c19a069202102', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/ModuleEye.php', '24.9', 0),
('772bab04440f2fba69f8e077d14606c0', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/SimpleCircleEye.php', '24.9', 0),
('6c78cee3c14c8289039d7efb01a3b881', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/SquareEye.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Eye/index.php', '24.9', 0),
('cbd38bfd7fce6bfc9d1d05a6ffceb71e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/EpsImageBackEnd.php', '24.9', 0),
('0b50b4c3d3a3a3f701c9ce604d8b01a8', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/ImageBackEndInterface.php', '24.9', 0),
('a089ebbe42b4e7072bdfbd0e2d88108f', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/ImagickImageBackEnd.php', '24.9', 0),
('d1014f20ba8a97241c50fc7fe7b3a8d2', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/SvgImageBackEnd.php', '24.9', 0),
('bdafa6f94eaf35a90b7aca759eff792a', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/TransformationMatrix.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Image/index.php', '24.9', 0),
('c833b7ccb8d20f7c662e5a008b191c9c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/ImageRenderer.php', '24.9', 0),
('875f563b86dcb874b06931cef0fa6230', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/DotsModule.php', '24.9', 0),
('ae6b54daccd1cdca65569fac667f80f8', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/EdgeIterator/Edge.php', '24.9', 0),
('7b591429247e49c3f60c69b17d1e2b7b', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/EdgeIterator/EdgeIterator.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/EdgeIterator/index.php', '24.9', 0),
('b77e71695dfd80270b8a17702119e899', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/ModuleInterface.php', '24.9', 0),
('c05caece47dc31cdc6f1aca44f2f4cb7', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/RoundnessModule.php', '24.9', 0),
('1cb7d8140d6394d57aa6127ae05add83', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/SquareModule.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Module/index.php', '24.9', 0),
('5e10828fcdec1c0288d3a1c39ce37a22', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Close.php', '24.9', 0),
('bf2bed55211f29703706b37c48be9802', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Curve.php', '24.9', 0),
('a4fa9d3936ee0033c371b4876365040e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/EllipticArc.php', '24.9', 0),
('657dae52b5f9ae78d390b69718007fcd', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Line.php', '24.9', 0),
('03678e8b9a101e3823eff2eab4fd0f5b', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Move.php', '24.9', 0),
('27c16fc46a247b4e75589a836b20482b', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/OperationInterface.php', '24.9', 0),
('0a955a22b9c18417e71550886a5b96c5', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/Path.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/Path/index.php', '24.9', 0),
('6708a8261d9d9bb389b7328cb340d934', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/PlainTextRenderer.php', '24.9', 0),
('94500859bceef7245aeb21fe9fb8916c', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererInterface.php', '24.9', 0),
('17d6762d731feab5786c44e39146b883', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/EyeFill.php', '24.9', 0),
('abaee43a0d4ccfbc1d0e531e81e465dd', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/Fill.php', '24.9', 0),
('c926cffebc01d109ea6ab404c5dcf329', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/Gradient.php', '24.9', 0),
('749cce0005f9aba2ade726f0c151c343', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/GradientType.php', '24.9', 0),
('c0d626499703513bff1e7751a7a5f3c8', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/RendererStyle.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/RendererStyle/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Renderer/index.php', '24.9', 0),
('217cce9ee1b4aeade8abc8e4794a7fcc', './vendor_bundled/vendor/bacon/bacon-qr-code/src/Writer.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/bacon-qr-code/src/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bacon/index.php', '24.9', 0),
('30bcab9c086559aad11d39876ecebcec', './vendor_bundled/vendor/bower-asset/fontawesome/css/all.css', '24.9', 0),
('ecd507b3125edc4d2a03aa6ae5d07da9', './vendor_bundled/vendor/bower-asset/fontawesome/css/all.min.css', '24.9', 0),
('2109e5b8cbf032b14e3834092af66306', './vendor_bundled/vendor/bower-asset/fontawesome/css/brands.css', '24.9', 0),
('2c213c9e855a714f04273ad8ddfec94a', './vendor_bundled/vendor/bower-asset/fontawesome/css/brands.min.css', '24.9', 0),
('24a6fa7bd20a9b9d95334c5747c3fc06', './vendor_bundled/vendor/bower-asset/fontawesome/css/fontawesome.css', '24.9', 0),
('a227f005fa7ae066c1068ac4b963514c', './vendor_bundled/vendor/bower-asset/fontawesome/css/fontawesome.min.css', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/css/index.php', '24.9', 0),
('60e052ee86bc6e1e2fd5c7927517a6a9', './vendor_bundled/vendor/bower-asset/fontawesome/css/regular.css', '24.9', 0),
('49c10bd7921f287bbd5b1180cb008e10', './vendor_bundled/vendor/bower-asset/fontawesome/css/regular.min.css', '24.9', 0),
('fd62ae25e6b0c3dd7446e29886f19e71', './vendor_bundled/vendor/bower-asset/fontawesome/css/solid.css', '24.9', 0),
('685a6b10be9f3db25acf78c5e7ba7379', './vendor_bundled/vendor/bower-asset/fontawesome/css/solid.min.css', '24.9', 0),
('39d0217c6a09db9151f1d042ea3a00b5', './vendor_bundled/vendor/bower-asset/fontawesome/css/svg-with-js.css', '24.9', 0),
('19cf47f65b95a2cbd2b4dd6a4988d373', './vendor_bundled/vendor/bower-asset/fontawesome/css/svg-with-js.min.css', '24.9', 0),
('6ba89750869a4b522e655726a15ed165', './vendor_bundled/vendor/bower-asset/fontawesome/css/v4-shims.css', '24.9', 0),
('a034d3c71bee546f625877d7932917f8', './vendor_bundled/vendor/bower-asset/fontawesome/css/v4-shims.min.css', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/index.php', '24.9', 0),
('40170a907ada3b3d54ed903ea3dd2e81', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-common-types/attribution.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-common-types/index.php', '24.9', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/attribution.js', '24.9', 0),
('30bcab9c086559aad11d39876ecebcec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/all.css', '24.9', 0),
('ecd507b3125edc4d2a03aa6ae5d07da9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/all.min.css', '24.9', 0),
('2109e5b8cbf032b14e3834092af66306', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/brands.css', '24.9', 0),
('2c213c9e855a714f04273ad8ddfec94a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/brands.min.css', '24.9', 0),
('24a6fa7bd20a9b9d95334c5747c3fc06', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/fontawesome.css', '24.9', 0),
('a227f005fa7ae066c1068ac4b963514c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/fontawesome.min.css', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/index.php', '24.9', 0),
('60e052ee86bc6e1e2fd5c7927517a6a9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/regular.css', '24.9', 0),
('49c10bd7921f287bbd5b1180cb008e10', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/regular.min.css', '24.9', 0),
('fd62ae25e6b0c3dd7446e29886f19e71', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/solid.css', '24.9', 0),
('685a6b10be9f3db25acf78c5e7ba7379', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/solid.min.css', '24.9', 0),
('39d0217c6a09db9151f1d042ea3a00b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/svg-with-js.css', '24.9', 0),
('19cf47f65b95a2cbd2b4dd6a4988d373', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/svg-with-js.min.css', '24.9', 0),
('6ba89750869a4b522e655726a15ed165', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/v4-shims.css', '24.9', 0),
('a034d3c71bee546f625877d7932917f8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/css/v4-shims.min.css', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/index.php', '24.9', 0),
('194e3c150b4f413e14580fc7d77bf7cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/all.js', '24.9', 0),
('96a9af0c577c9e60248c2fa3d3597e68', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/all.min.js', '24.9', 0),
('ea5a12f91eb4e22bc7016c4244f12e2f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/brands.js', '24.9', 0),
('d4d4a6d8a186618d6f2f457f527591f0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/brands.min.js', '24.9', 0),
('1f88f026bb89dfaa162643f4f06eddc0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/conflict-detection.js', '24.9', 0),
('35c9bafd67052858e7d68aca3a3ee8ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/conflict-detection.min.js', '24.9', 0),
('0d3ecc868f631131fe2a721e50d7f79c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/fontawesome.js', '24.9', 0),
('2272f69ea5bafa3f88ba33ee1db14b78', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/fontawesome.min.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/index.php', '24.9', 0),
('d10b6f4866e0e1e17fbbbd321e2c2d20', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/regular.js', '24.9', 0),
('23a234113676631d075cec2f97654096', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/regular.min.js', '24.9', 0),
('1d7ecf51e3bcfe5a19219e09e0c48619', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/solid.js', '24.9', 0),
('292db35eb345bf41d13022d9a9c42ca6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/solid.min.js', '24.9', 0),
('c0ea274430b4a0969ac4b9d25d12e7ee', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/v4-shims.js', '24.9', 0),
('5aec9c45548b29e5e5525bedd3b539bb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/js/v4-shims.min.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/less/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/metadata/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/scss/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/sprites/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/svgs/brands/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/svgs/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/svgs/regular/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/svgs/solid/index.php', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-free/webfonts/index.php', '24.9', 0),
('750a15ededf664c2b06ab92abd35d88a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/attribution.js', '24.9', 0),
('5ced866ab3e161cb8b1e1a11f7b9b1f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/index.es.js', '24.9', 0),
('cefec9ed44c8b0fbb7655f14a6db910c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/index.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/index.php', '24.9', 0),
('632ee5338e9d7dfe152a1089587fcc08', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/fontawesome-svg-core/styles.css', '24.9', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/attribution.js', '24.9', 0),
('fa5669d1c2027a91adfdd0c7bec04c68', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/fa500px.js', '24.9', 0),
('3fdb320f10f3ee070b8437b2b3cacf95', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAccessibleIcon.js', '24.9', 0),
('2b6ea11a02e7f0ea7ae6a97d280fea80', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAccusoft.js', '24.9', 0),
('8354fa8cced99710bfd20af5e74a60f2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAcquisitionsIncorporated.js', '24.9', 0),
('cc9a1d59ee98499096799e75f6d84a6f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAdn.js', '24.9', 0),
('f1da066ad0bfec0797484a1b2847516c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAdobe.js', '24.9', 0),
('03515bfb198925494424d7cb743833b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAdversal.js', '24.9', 0),
('e736a50f996d46859912cb3b0270e72a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAffiliatetheme.js', '24.9', 0),
('5e11d56dde590bbe42cd5c7a9163f392', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAirbnb.js', '24.9', 0),
('8122ff33df62848d6f0818418b6988bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAlgolia.js', '24.9', 0),
('0a4d35a34a787d627e949c95f48b772f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAlipay.js', '24.9', 0),
('7fb7ddc4856703fc0ec04486bd091d09', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAmazon.js', '24.9', 0),
('b761ef00d40a86fa5a3c25d89dd74f99', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAmazonPay.js', '24.9', 0),
('d228a8b67264ae423a3eb33611c2c016', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAmilia.js', '24.9', 0),
('4d0ac0565f58c4c05aa29a40a6234bad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAndroid.js', '24.9', 0),
('270e231938cbf7185b427b16852a6911', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAngellist.js', '24.9', 0),
('327ad4f5375459c6a0905c98ae1979e8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAngrycreative.js', '24.9', 0),
('8d1824e3099d37d5dfdc16a40025c7ae', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAngular.js', '24.9', 0),
('38f4adf7bf039844c82cf9abeec1108f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAppStore.js', '24.9', 0),
('0889f8d1f89b5433b14d73abc4c9d5c3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAppStoreIos.js', '24.9', 0),
('243b57607de8c547ab4f7a0ab09c042d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faApper.js', '24.9', 0),
('3f178d04bf5736b670bf5bd526e64876', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faApple.js', '24.9', 0),
('c7031ae2d6b433a93be523cf4ebc36d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faApplePay.js', '24.9', 0),
('f773833bd1f281d32025cf458c2c59cc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faArtstation.js', '24.9', 0),
('4de0489ee09fd40e5327c3c9f299a8d1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAsymmetrik.js', '24.9', 0),
('bf3043cc7dba1c219fa35d74bafdca5e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAtlassian.js', '24.9', 0),
('ae1fd4eeee64bdf9138f8d866245a643', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAudible.js', '24.9', 0),
('1e3b7c49417e202caed6cf51876649ab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAutoprefixer.js', '24.9', 0),
('e2606f1cc3f1bc22d7e7bf730ed303fc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAvianex.js', '24.9', 0),
('6e1fdb162b5ba5fd48702cda5e97ed7f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAviato.js', '24.9', 0),
('d5a8b1c33e45a7ff20aeaa2fe3bbeec9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faAws.js', '24.9', 0),
('4054ba189a40103ea7b825f0575519a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBandcamp.js', '24.9', 0),
('fbf23e4e99a036e9bd8b56fbbd2664ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBattleNet.js', '24.9', 0),
('e271a13ddd9f8fdad03118dac6c4fc6e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBehance.js', '24.9', 0),
('b143ecbf551381a503c92789de6b8d41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBehanceSquare.js', '24.9', 0),
('e940728884f8a8e572f68e9b998630bb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBimobject.js', '24.9', 0),
('830cf8c4e4f101ba3e561866650976c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBitbucket.js', '24.9', 0),
('55fccea6b99f37488057968f359cafb5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBitcoin.js', '24.9', 0),
('269422b64d98a87a5a515e4cd5bb41dd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBity.js', '24.9', 0),
('01fd5e92b6cec23c4244d1baf700fd58', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBlackTie.js', '24.9', 0),
('4a7eb6ba99b3b79a8eac0bd0c295c2c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBlackberry.js', '24.9', 0),
('03004bedc086a74e8dc0b1d1dadaade7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBlogger.js', '24.9', 0),
('a2cfde66c30bbd1c044284503c8b64cf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBloggerB.js', '24.9', 0),
('e25bdf8573aa6ce5312dcbb1afbe5981', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBluetooth.js', '24.9', 0),
('d0a7ecf70c6797a14f86d33ba285b406', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBluetoothB.js', '24.9', 0),
('4d2d022a2a38acd9b7ae0dbc9fcd0384', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBootstrap.js', '24.9', 0),
('d7efdab0a54d652619a4dbe9aa3767b2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBtc.js', '24.9', 0),
('e786be0d05411cd3f7c21860069ef636', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuffer.js', '24.9', 0),
('2b1c43cfc9741c9c32dae34996bd7ac6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuromobelexperte.js', '24.9', 0),
('e6b61a827f99c225bb85513a2e4169ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuyNLarge.js', '24.9', 0),
('59032b209abb2fe45d2213d2cd8df330', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faBuysellads.js', '24.9', 0),
('9ab68d645c5752470954f8fc54340cd5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCanadianMapleLeaf.js', '24.9', 0),
('be61a7319657db6ddd4f70efcdbda872', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcAmazonPay.js', '24.9', 0),
('12431bac80ab36cb92b712342e832757', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcAmex.js', '24.9', 0),
('eb52ba88b0d44b69b7dbe761c8d6478d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcApplePay.js', '24.9', 0),
('e095b64cfc77796a980baba5fa2de921', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcDinersClub.js', '24.9', 0),
('29cbc70195b961a8629bc153b9069a4b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcDiscover.js', '24.9', 0),
('7d1583a72ca0cff0d16091ebed9c6f51', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcJcb.js', '24.9', 0),
('763a120410c1d43b1b056f6f027f117d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcMastercard.js', '24.9', 0),
('6bc6961b3a9eaa297596ec2b196196a4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcPaypal.js', '24.9', 0),
('95abcd4fa515b8becd63234478447abe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcStripe.js', '24.9', 0),
('c356f34de079f7fe99714f292c383fd8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCcVisa.js', '24.9', 0),
('68a8b9f6cded567b77ac39e94d9af950', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCentercode.js', '24.9', 0),
('a2ff9b0ceef879d67cd17a446ad7fbe5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCentos.js', '24.9', 0),
('46d665e63b59612e88f05244875ad400', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faChrome.js', '24.9', 0),
('9d4339236a43b4d71c04c0db4295e57e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faChromecast.js', '24.9', 0),
('bba3c01529c790cc48e44ff647acc363', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudflare.js', '24.9', 0),
('019ecd47eef0abd64e7032747b72e7a8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudscale.js', '24.9', 0),
('3613afbf0b8b1d22d0faf87b5eccff79', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudsmith.js', '24.9', 0),
('72bafd517ad4381bf775e7db4a795128', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCloudversify.js', '24.9', 0),
('085136af104ee774e30059a58487026a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCodepen.js', '24.9', 0),
('8431b9e3be05d73e7c71c32b72273b8a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCodiepie.js', '24.9', 0),
('0af4697ab33cdb7afcebee8ba705a0c3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faConfluence.js', '24.9', 0),
('dabc5ac043d0380b96e3c98a43c04a1d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faConnectdevelop.js', '24.9', 0),
('1be3467e8d2332c92cfe5f2253993b2e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faContao.js', '24.9', 0),
('3b301f4cd0ae0d6eabf01812115aa3c4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCottonBureau.js', '24.9', 0),
('f543127e65501eb4df3d9cf92694fcb8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCpanel.js', '24.9', 0),
('6b9bfa5a8f94ae1f2490c2ddc3e5bd08', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommons.js', '24.9', 0),
('20ef2deddade2b88f2e115f7591fa394', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsBy.js', '24.9', 0),
('b1c1e839d06fa3858368b745eb90f80b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNc.js', '24.9', 0),
('e4562200164f29e98a26432fa992cde0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNcEu.js', '24.9', 0),
('827667c136042de16ef632ebf26187ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNcJp.js', '24.9', 0),
('59d7b35864f96abb1122de7d5e06b8cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsNd.js', '24.9', 0),
('5b542c29f7df033926574eee375aa611', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsPd.js', '24.9', 0),
('cf803e40ecba6edfdd6ed05feafcb755', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsPdAlt.js', '24.9', 0),
('89d7bb7ac557009da281ecc915cb235e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsRemix.js', '24.9', 0),
('54e972143710facdb907ec22234aad83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsSa.js', '24.9', 0),
('71cc43f42c6c4f13c3ce5033edeecc57', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsSampling.js', '24.9', 0),
('0554fd95d29d62efb26f6e16af04afaf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsSamplingPlus.js', '24.9', 0),
('dbc1fcb6048f81bd7e8d23d77fa23d28', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsShare.js', '24.9', 0),
('4eb5c1555a9248acdac908d203894013', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCreativeCommonsZero.js', '24.9', 0),
('c0174bb29919992a6a59318bbbf9e7ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCriticalRole.js', '24.9', 0),
('84a1bf5750246600005fe9a7e13b4656', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCss3.js', '24.9', 0),
('e3e8ab9d5ddbc1cd8a5966249f191575', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCss3Alt.js', '24.9', 0),
('01718ffa01f4718c278f0704ce9491ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faCuttlefish.js', '24.9', 0),
('902f755ffb7f5c04743e0e9997b40580', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDAndD.js', '24.9', 0),
('c03f9a96b1f3a2f4b47273d5b9b8236d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDAndDBeyond.js', '24.9', 0),
('0406323f9dcaf2776f904e38f85ca52f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDailymotion.js', '24.9', 0),
('368fc934b993b16c3c3a39684985fec9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDashcube.js', '24.9', 0),
('e36c7273696c8f9705268669751ebdc2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeezer.js', '24.9', 0),
('cc487a485fbde10aab9b805e7a40af8f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDelicious.js', '24.9', 0),
('d67685d312bc5cf9e2a40f5b1e36ae87', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeploydog.js', '24.9', 0),
('ff2045d2968d319c35cfa83f93151f3b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeskpro.js', '24.9', 0),
('287eab055e5827a605119b30af9d1336', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDev.js', '24.9', 0),
('ef85a530a164978071cd8baa50fa4332', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDeviantart.js', '24.9', 0),
('5e8c226f88566d9f9842928d5df5603e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDhl.js', '24.9', 0),
('4cd634e46b08cc9e99d0f88ee0692ef1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDiaspora.js', '24.9', 0),
('5abbd4d5cef6c43026327ad1ad10871b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDigg.js', '24.9', 0),
('ee02a257b296ce608b077489ef560ff9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDigitalOcean.js', '24.9', 0),
('c54158332162f99c1ccf403baf824d1b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDiscord.js', '24.9', 0),
('95789134e853c2736e435d92d8c44e58', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDiscourse.js', '24.9', 0),
('b99dbac7efa88b30e41c56f9144e9658', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDochub.js', '24.9', 0),
('fba7387ef6e7482a34a9759e4be2db00', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDocker.js', '24.9', 0),
('348da4b41317a01515e13787eb7b3ded', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDraft2digital.js', '24.9', 0),
('9c106b01ea55d157e3f74ce270196cad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDribbble.js', '24.9', 0),
('7ec9d08416fbbabbb4a4f0c65a77e53b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDribbbleSquare.js', '24.9', 0),
('a89458290c547e410a5a435dcfdbbc8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDropbox.js', '24.9', 0),
('4bcdb95e6bc2758ae72243d927358acb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDrupal.js', '24.9', 0),
('b2a3a0d2aa9fc6a05baf7352e0e82509', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faDyalog.js', '24.9', 0),
('bddba6ab450c8db8de99b27c46a54dd7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEarlybirds.js', '24.9', 0),
('9197cd1bfa712ed6050eb93f773f065c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEbay.js', '24.9', 0),
('116bd7085965fb077887c5b4868509aa', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEdge.js', '24.9', 0),
('bf2873819aecc8fa6fb8ff46c33096a8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEdgeLegacy.js', '24.9', 0),
('2189273a31a4a2485f6dddfb28bca1bf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faElementor.js', '24.9', 0),
('55afb691c836794b8dbcbe9855826267', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEllo.js', '24.9', 0),
('b4d10b18f5cbadd800e5bc4f9b9a004f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEmber.js', '24.9', 0),
('4948fa023a9881882520e619d6bc6bc2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEmpire.js', '24.9', 0),
('73dfc366a948ebd1db2b7e8f4b43ca8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEnvira.js', '24.9', 0),
('d565e4206a4bdf16467b200c98e56277', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faErlang.js', '24.9', 0),
('e3bdd00a951744a0d4106a3c0322c762', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEthereum.js', '24.9', 0),
('5db24334b52c53b721f2ce9ad2705344', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEtsy.js', '24.9', 0),
('85378d6670f30ba506ab32cc7b38f157', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faEvernote.js', '24.9', 0),
('c0878268bd5612f407162ba39dd05681', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faExpeditedssl.js', '24.9', 0),
('38fa8cad4ff6dab84118e388a78bb267', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebook.js', '24.9', 0),
('0f78ae7c36b7049424777e434c01d2c2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebookF.js', '24.9', 0),
('bd5c46d1939523a8e8ed912791159194', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebookMessenger.js', '24.9', 0),
('791b9de16037565de43be9191937891d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFacebookSquare.js', '24.9', 0),
('7081e9f2b2220f5abe264f68b810755d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFantasyFlightGames.js', '24.9', 0),
('7b9cce8cbc4a6930e86325b4e83451b4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFedex.js', '24.9', 0),
('79fdc43ad3e3322260f0e6f9d920f131', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFedora.js', '24.9', 0),
('10034461c5f1206d66a78a9659729273', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFigma.js', '24.9', 0),
('aa6754d230b83bbe125b21a837fb5463', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirefox.js', '24.9', 0),
('6efb12a3fe74bbfe1ed76c1324638d5a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirefoxBrowser.js', '24.9', 0),
('9d00a0de8ca57f7362aa1375c5bd2126', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirstOrder.js', '24.9', 0),
('11ec9331dfce8dff401c18592c293690', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirstOrderAlt.js', '24.9', 0),
('c9e3c5cccc8111851f4abf83c9c3341a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFirstdraft.js', '24.9', 0),
('1aa1b470c4a403a3c447d91074f76f9d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFlickr.js', '24.9', 0),
('7c698b767faf081dce3a449f01b09b05', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFlipboard.js', '24.9', 0),
('1291ffac97f2de3f41835924621f4f9d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFly.js', '24.9', 0),
('4606422f1d4c914479e3d3fb369517b7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesome.js', '24.9', 0),
('03edb8fe3d1002b3479307491c2d21e6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesomeAlt.js', '24.9', 0),
('c150b4ad2facc1558525df381b975ec2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesomeFlag.js', '24.9', 0),
('832edd0290435015150ad2321fbd411b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFontAwesomeLogoFull.js', '24.9', 0),
('edbc8b4a9d67c75d1d3ef69e215c1a71', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFonticons.js', '24.9', 0),
('5534e041f41a54787c264421cf859068', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFonticonsFi.js', '24.9', 0),
('9dea4f238b9cdea48b7308f8937ee21a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFortAwesome.js', '24.9', 0),
('714e1e9480179551bfc6ea66a97cb5e6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFortAwesomeAlt.js', '24.9', 0),
('ec2c528d3b19958c0dfe2ad7e2b80d90', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faForumbee.js', '24.9', 0),
('d3dc3c1a66d6d0f8abadfb09aa4f7e6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFoursquare.js', '24.9', 0),
('4ac56c953581d2c9be09d271d1812072', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFreeCodeCamp.js', '24.9', 0),
('588e1986e81d7d2ef45087530b223214', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFreebsd.js', '24.9', 0),
('7a804bbf0ffebdcf0c8124a8e6561fb5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faFulcrum.js', '24.9', 0),
('b909c93b2791e4a621f27ba36de540d9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGalacticRepublic.js', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('d1b4cec69804b5de32e3fd304f6e804e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGalacticSenate.js', '24.9', 0),
('3279b3c7c1def4a043da772bfd648120', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGetPocket.js', '24.9', 0),
('e5d94297425890a5134f18a8cf1bef5d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGg.js', '24.9', 0),
('cea533fd2b2c4aefd6975473d0b44828', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGgCircle.js', '24.9', 0),
('c672846dbbc66d2d832c59de57d84a9c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGit.js', '24.9', 0),
('4caa984cc0c118d84b44a669a6876c48', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitAlt.js', '24.9', 0),
('6e5c8d260f98cb1b5c4320f91ab0e677', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitSquare.js', '24.9', 0),
('cf5a4b8f2cd8fd41d72f2c18774840a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGithub.js', '24.9', 0),
('52ccf898300342fbab845fdd24ac13c2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGithubAlt.js', '24.9', 0),
('df49c9f9e3df3ae95a624d544ede4063', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGithubSquare.js', '24.9', 0),
('b6a9b8d8fabbd3d06b263a83840c25f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitkraken.js', '24.9', 0),
('3e7be9fd3070b8acccce6f7a366f0ac1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitlab.js', '24.9', 0),
('a9209c0499470d4496f640ed5ef87924', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGitter.js', '24.9', 0),
('377681e66a6e8cd122f8956c2d98444e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGlide.js', '24.9', 0),
('f3855ffc520c78b2ddb0cf1a06d146c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGlideG.js', '24.9', 0),
('3d2daa84462f77377e8c5c466c2988a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGofore.js', '24.9', 0),
('a333f28c0a3e775c1a2d5c7385fcb84f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoodreads.js', '24.9', 0),
('818edad2b5943151c5349bfbbc6a3114', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoodreadsG.js', '24.9', 0),
('5debfcdd6ce27729b1dfb13667bb726b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoogle.js', '24.9', 0),
('7388178e1e40e376cf6e62ccaba0aacf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoogleDrive.js', '24.9', 0),
('a17534720c5ff4f49eaac866d65cd6a6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePay.js', '24.9', 0),
('9834b525c696d6cb20a42852fd9e7226', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlay.js', '24.9', 0),
('d02c4667cc244786fb323630df4a2c21', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlus.js', '24.9', 0),
('ce8f5620d0e3316bd73d53774a295891', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlusG.js', '24.9', 0),
('c5fa960932e02606a0053103c3257b62', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGooglePlusSquare.js', '24.9', 0),
('a84b943689c11e64d5cf72c79fed38d3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGoogleWallet.js', '24.9', 0),
('4c2237602fbdc04b11a826a3dffe35f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGratipay.js', '24.9', 0),
('7e0c6bba676915ea3b54a87061f735ad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGrav.js', '24.9', 0),
('3402acb7167102d00468656a6797daea', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGripfire.js', '24.9', 0),
('4432f88c8151322f43d7192a7e6f83df', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGrunt.js', '24.9', 0),
('02fd805a74ba65af7d56577ac585ea77', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGuilded.js', '24.9', 0),
('12389d9954316bf92a8a5b9ab9abc3fe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faGulp.js', '24.9', 0),
('c150c938259f62b03c68214ea5dd38b7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHackerNews.js', '24.9', 0),
('f0611b3bad98631d79cac65a35ba9c0e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHackerNewsSquare.js', '24.9', 0),
('8007e93c607c7124500360e28d2d2588', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHackerrank.js', '24.9', 0),
('7bd54ce8f47d1ff38f06f5a9d419a494', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHips.js', '24.9', 0),
('5f022034b659bb4e5944dcbe7a49f907', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHireAHelper.js', '24.9', 0),
('edc26954906cf7c2576278750a13cd21', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHive.js', '24.9', 0),
('c9fcd700502c2fbd6695d688bfa3c418', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHooli.js', '24.9', 0),
('defca7cfa87147110573bb39f8c98877', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHornbill.js', '24.9', 0),
('1c99086d58b3f5aec55a6898d844ddc6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHotjar.js', '24.9', 0),
('b596e1c39e2b35cf3a9a2b34462d91e1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHouzz.js', '24.9', 0),
('1304dad3b7fa35e8592617951ca171cb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHtml5.js', '24.9', 0),
('086fdfe68bd902c872ec12f987d5522d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faHubspot.js', '24.9', 0),
('bd6733c13c46227bc31d86a6ff371c20', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faIdeal.js', '24.9', 0),
('88376f723649d2ec3ab5d929f012caa8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faImdb.js', '24.9', 0),
('35d69ac887def0f6cdc0b0d418cb71c8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInnosoft.js', '24.9', 0),
('ada62cff953999b802b3755126391ad4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInstagram.js', '24.9', 0),
('5d472ec330584ab729a02249e1a857ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInstagramSquare.js', '24.9', 0),
('d854f4019c525e55ce9c00560b9d324a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInstalod.js', '24.9', 0),
('c67e13cf200f52377bda76ffd53c969b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faIntercom.js', '24.9', 0),
('d1fe95d7fde69fa5c204b74820102296', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInternetExplorer.js', '24.9', 0),
('f599e9b3c683e90a1ec37e35d79d2984', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faInvision.js', '24.9', 0),
('b25224cb92e59f89d402a6363b4ce278', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faIoxhost.js', '24.9', 0),
('a03020482e905269c763770bc3c47b4e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faItchIo.js', '24.9', 0),
('db8914acd7b06fa2e06e8e7e67a251b8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faItunes.js', '24.9', 0),
('11f7dda8c98665cbc9a3580407bdf516', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faItunesNote.js', '24.9', 0),
('61a1d502628217d1565f57ff342aeffd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJava.js', '24.9', 0),
('4a9abba0f789180b1fabc807184db8a5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJediOrder.js', '24.9', 0),
('a5ce95161d4811069d7ccb3c90883d60', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJenkins.js', '24.9', 0),
('9ded6bbc3dcb90314fc1a12acf53ca57', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJira.js', '24.9', 0),
('65ecbcdadd28fdbfe3ec3bb2c8c39ab7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJoget.js', '24.9', 0),
('03fd85011b06a4c65a6e687dab646653', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJoomla.js', '24.9', 0),
('0ac18f7cca89dc9b244d516f6d4c1c59', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJs.js', '24.9', 0),
('0660b552e85172dc330cbe9133ff77b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJsSquare.js', '24.9', 0),
('f59c7066c2053a12f15d43a48006b4d7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faJsfiddle.js', '24.9', 0),
('e4c4fc2b54d37b29e450081e99cae77c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKaggle.js', '24.9', 0),
('de247b8b36cda461e082fbfd91f2dbc1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKeybase.js', '24.9', 0),
('fdf5ff1aee9d26709496f464c1aad964', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKeycdn.js', '24.9', 0),
('9130fcba70a5ecc9888651630b5b8170', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKickstarter.js', '24.9', 0),
('1fd4327417c88e027bcec804b4f1bd58', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKickstarterK.js', '24.9', 0),
('82cd3924ae376fb66de0d1cec1461c6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faKorvue.js', '24.9', 0),
('08b1a73dde5932ec010c9d12c02928ce', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLaravel.js', '24.9', 0),
('95a301bf37eabd30bfce484eedbf729c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLastfm.js', '24.9', 0),
('069763116cd68692e65f9236e3069ae9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLastfmSquare.js', '24.9', 0),
('a53946883c7469e3b472868189f8bcfb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLeanpub.js', '24.9', 0),
('162d2e18eeae824a49d25ffee07a5253', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLess.js', '24.9', 0),
('67e31b6af8885dcecddd57b1c4623249', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLine.js', '24.9', 0),
('9dd2d64a862102241426453cc017bff6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinkedin.js', '24.9', 0),
('c7e4197984cb973db30787f8d8d2101a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinkedinIn.js', '24.9', 0),
('53118e88dad9d0e7284796a2662436e0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinode.js', '24.9', 0),
('f57627b333e3b0f63d0e2d77efef5c45', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLinux.js', '24.9', 0),
('29d8e0be3000e853f4a96628b69cff8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faLyft.js', '24.9', 0),
('fd13e68c4b31dba9094b38bfe477a028', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMagento.js', '24.9', 0),
('567813c955da380fa31eaaaa500d5201', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMailchimp.js', '24.9', 0),
('b71c85ae226360fe810675e20b10d5e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMandalorian.js', '24.9', 0),
('4d1eba7d198771be154bb9b81a165ef8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMarkdown.js', '24.9', 0),
('ba64377b9ca1aca653f5d47202e283a5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMastodon.js', '24.9', 0),
('fd3869e30b127333be3671b2255456e2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMaxcdn.js', '24.9', 0),
('6afd6f47c9a0edd4f154484a34d146d7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMdb.js', '24.9', 0),
('c2e79a3ec9158affe2e9435b1c4fa04f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMedapps.js', '24.9', 0),
('135789114b3834bad4a84a6914a4272f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMedium.js', '24.9', 0),
('f5afe136c4bc2cc8c4cf4bdad23fe683', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMediumM.js', '24.9', 0),
('103e592284757f9f81f0b7f39f1a415c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMedrt.js', '24.9', 0),
('6d4111032faf5a4f5478a607842241c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMeetup.js', '24.9', 0),
('84fb64708cd1b5319e3a457a2baf5645', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMegaport.js', '24.9', 0),
('578a8ee221c5dd3a3d429198856209c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMendeley.js', '24.9', 0),
('92d1313863dc0efd8324b944036af67f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMicroblog.js', '24.9', 0),
('7cbbca306088f88a5c9dc9d65cf8a8e3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMicrosoft.js', '24.9', 0),
('6ada5970a68449d7af05e39003505873', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMix.js', '24.9', 0),
('ea8e82eb5571266f91e3f2ff058d5f84', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMixcloud.js', '24.9', 0),
('be3c97a4fd1fe3060357a39563157057', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMixer.js', '24.9', 0),
('02d1bd0c7632872a3647728fc89492ab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMizuni.js', '24.9', 0),
('3e8aebfe900e386b171ad20897cf933b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faModx.js', '24.9', 0),
('1bd1fdbc3ce50c6a759379f4d43cea37', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faMonero.js', '24.9', 0),
('2cc47b7c76a7f1b39a014bd347795aa1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNapster.js', '24.9', 0),
('6e3a5429a360072ac595e670d2e002a2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNeos.js', '24.9', 0),
('8cfbead6b9ff8f923a68f4939a73cb5b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNimblr.js', '24.9', 0),
('bc44cbaf82c9b8140c3f4ea751f73ee3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNintendoSwitch.js', '24.9', 0),
('f73ce7758c7a187b306b49b7da1a7ab6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNode.js', '24.9', 0),
('4b4e12469267c7bd10978b7b27b22fe1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNodeJs.js', '24.9', 0),
('9cb95171d0259e0b618ae9d55cb0887b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNpm.js', '24.9', 0),
('5490c3aefe35836bf30eafc0a8999413', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNs8.js', '24.9', 0),
('1c8b26235984b80adf22e6e1b3d47a1f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faNutritionix.js', '24.9', 0),
('9fa42b058deb7a54d4c2966f24ecf579', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOctopusDeploy.js', '24.9', 0),
('92f32e025a25fe73e7027faedaa051a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOdnoklassniki.js', '24.9', 0),
('747216e761774e83efac8842caef6510', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOdnoklassnikiSquare.js', '24.9', 0),
('7300a6f7f8acb799ad82f30d661f94c5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOldRepublic.js', '24.9', 0),
('4671d58f5e301d15d4adbb01d6094a9f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOpencart.js', '24.9', 0),
('b3dd798eaed4fe13163719472eb892dd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOpenid.js', '24.9', 0),
('1c05f752f2c6cae8d3a59489839fff41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOpera.js', '24.9', 0),
('0571ff5800c6e7ae364d463da8caa0f8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOptinMonster.js', '24.9', 0),
('c1442615c9f25cf2dc1715bf0f52b026', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOrcid.js', '24.9', 0),
('29540a734bea6ee3a4bc29fac388a3cd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faOsi.js', '24.9', 0),
('dba0612775cbd7893885ce2234f531af', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPage4.js', '24.9', 0),
('7709f70f58b32e82ccf6f37f11305333', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPagelines.js', '24.9', 0),
('05f0005124a2fffc7f6832722a70cad1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPalfed.js', '24.9', 0),
('be758e97bfb01d2e7ea9df4fecc58fa1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPatreon.js', '24.9', 0),
('72ca70c671067085db8ddd79430e025c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPaypal.js', '24.9', 0),
('0ce1d9f3622cc5b94d1367db7dfe7c30', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPennyArcade.js', '24.9', 0),
('abfa5a6582efc6455d7838de5bd300f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPerbyte.js', '24.9', 0),
('e63816a3d2d620f6d1f80eeb0a8016ef', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPeriscope.js', '24.9', 0),
('2f953ba1cf26bc59e56f73fe68274f9b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhabricator.js', '24.9', 0),
('b670fbd77c8fef94bdab15a7f0712a5a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhoenixFramework.js', '24.9', 0),
('ad4747f3e5e14c9416e3c24eb86d5f20', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhoenixSquadron.js', '24.9', 0),
('5c4536e34def0608e872b39b2d8c8fab', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPhp.js', '24.9', 0),
('182f57565280e97e11018f1ffabfec3e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiper.js', '24.9', 0),
('1ea208f74d5685d199871aeebd077e8e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperAlt.js', '24.9', 0),
('62eadbc908f365e4e1e0ec50de293025', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperHat.js', '24.9', 0),
('45dbb87f1f621e59806a70d617205dc1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperPp.js', '24.9', 0),
('e81cdbcf37a87c19aa1920cb3ab83da4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPiedPiperSquare.js', '24.9', 0),
('b7df593e9f7da0d4800a81ddf4d79e66', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPinterest.js', '24.9', 0),
('63713b27650b2a16b28ff2d0e27088c6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPinterestP.js', '24.9', 0),
('975f71060b96592737f49eddf0098f6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPinterestSquare.js', '24.9', 0),
('1faddd4c89057f37e11646b8eec21b0b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPlaystation.js', '24.9', 0),
('2403d6651042eee8dec7efcda567dcad', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faProductHunt.js', '24.9', 0),
('9b4b177279a9c782b0d9944b645173ed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPushed.js', '24.9', 0),
('e3f5cf76bf40f9adbb9e14b89973c8cc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faPython.js', '24.9', 0),
('2945cb8e1bbbd57d85a9b20b153fbb6c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faQq.js', '24.9', 0),
('36a0736625669b5990482d6bbe847890', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faQuinscape.js', '24.9', 0),
('e63ed1e8f56561b11ab104db1dcf3a47', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faQuora.js', '24.9', 0),
('739dc6ff93183847b9934b84e5dbeb28', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRProject.js', '24.9', 0),
('dc94520a2daf135e6dbd6dadf9a70069', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRaspberryPi.js', '24.9', 0),
('1820a539ef39259cc274672ec05e693c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRavelry.js', '24.9', 0),
('bf6aaff542f18e101abbe500d9d03150', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReact.js', '24.9', 0),
('c71f4f027d1750c03d811fbd4f6bd46c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReacteurope.js', '24.9', 0),
('17a3cd8ea90e08021ba426443048e769', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReadme.js', '24.9', 0),
('c8478f8733d289caecf711900ed5e399', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRebel.js', '24.9', 0),
('eb434bb7a54cdba84be3f6e2b4777494', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedRiver.js', '24.9', 0),
('5bea48ce0ee873f93f5f0749b69de8c2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReddit.js', '24.9', 0),
('7293bbb1e5e955c8b91617afc2e6a0d3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedditAlien.js', '24.9', 0),
('cc55b6c3742e38237ae2a31bf02b3270', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedditSquare.js', '24.9', 0),
('306b44cfc99c3fabe4edecc671880a3d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRedhat.js', '24.9', 0),
('885e629155a7bcc126ef8c6612524ee6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRenren.js', '24.9', 0),
('f0ea85b5b360753b34b2d8f4a9876a90', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faReplyd.js', '24.9', 0),
('720cc324230609fb9f09c564544e38ec', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faResearchgate.js', '24.9', 0),
('a41e3dc8c39a1ad0b23b654a3938b40e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faResolving.js', '24.9', 0),
('ec74168bfeaacbd9851c8cea93bd8148', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRev.js', '24.9', 0),
('e2f34b9ab84b0d76c64145d12020c07b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRocketchat.js', '24.9', 0),
('bd82484b8d2c444ff08eb255e78da3dc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRockrms.js', '24.9', 0),
('b979ad40c43613396ffc49e3f9c71d89', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faRust.js', '24.9', 0),
('691077f4cae986dbfcd54dc36f48a312', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSafari.js', '24.9', 0),
('42c2cd860fe10708a255aa0491747112', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSalesforce.js', '24.9', 0),
('3706eb11037e92f38a00a7095bdf3a1e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSass.js', '24.9', 0),
('5c1f2ebd64c41425033a5abf038e5e10', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSchlix.js', '24.9', 0),
('044cbc2e4bd1086560b8ae4d6031aa83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faScribd.js', '24.9', 0),
('73ec0ea59e405b1ecf050a3efdb919ea', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSearchengin.js', '24.9', 0),
('4891733896653837d3c4e8e99f93dc70', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSellcast.js', '24.9', 0),
('0112928e8c8fe098eb26175e841c632c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSellsy.js', '24.9', 0),
('9a12fae2ce56cd49a4e64df283bce612', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faServicestack.js', '24.9', 0),
('bc227bf5ef4dcbf0b5a66d98ee3693eb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faShirtsinbulk.js', '24.9', 0),
('cd37ded98d7cc33f07eacb4b2469456f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faShopify.js', '24.9', 0),
('50c979ae97aef6be65eced5fdeb51e6f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faShopware.js', '24.9', 0),
('256df34a8c5d67d18cd0d28755228062', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSimplybuilt.js', '24.9', 0),
('fbe54b73c70feaebff85b2bf02e49942', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSistrix.js', '24.9', 0),
('01efbc465c31eea5567ec472fa9c1bd2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSith.js', '24.9', 0),
('294f2c5a7605904493305ad43927029c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSketch.js', '24.9', 0),
('edb19b25aa8f3edb216bb218bc7793a9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSkyatlas.js', '24.9', 0),
('9c9646aa9991d7b17f15c9d4c8e1714e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSkype.js', '24.9', 0),
('0d6e04f2640911aee61f4788dea04b6d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSlack.js', '24.9', 0),
('1427706d2df05e3e03f384e5bae3bf87', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSlackHash.js', '24.9', 0),
('a564a3e176528f6be689b7c7dbd63b15', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSlideshare.js', '24.9', 0),
('20f90f1fccfc38816ade89a6ac2157f4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSnapchat.js', '24.9', 0),
('b0705104137c59487faae4e51bdbd849', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSnapchatGhost.js', '24.9', 0),
('53fbd8a089483711628d10391bd651b4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSnapchatSquare.js', '24.9', 0),
('c53816f55147d730389cbba59157b719', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSoundcloud.js', '24.9', 0),
('1977716d00ebdcb5170b8bdba7fdbbbe', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSourcetree.js', '24.9', 0),
('1b6a0b27a78ec9ce04ae556f91c27276', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSpeakap.js', '24.9', 0),
('2b423cf5d58424df716e0cf1ab48f167', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSpeakerDeck.js', '24.9', 0),
('1a52f840969307dc21337c3cff923e34', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSpotify.js', '24.9', 0),
('1b1986881c4443ae38439f5596fb7377', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSquarespace.js', '24.9', 0),
('08f1d47966998223f6e9b24c7d6f4516', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStackExchange.js', '24.9', 0),
('fbc056ca106adc6708ca6ed55e6548fd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStackOverflow.js', '24.9', 0),
('baeaa352674b5d33406345787fb15c0e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStackpath.js', '24.9', 0),
('e10f50c7d54aaca32332b218f9537168', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStaylinked.js', '24.9', 0),
('9d07d84d8c164609b6fe2fd8766a2381', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSteam.js', '24.9', 0),
('029b846822362eaaa91831c9a9e6646e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSteamSquare.js', '24.9', 0),
('d404539220f7a2317b46e3293ed1667f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSteamSymbol.js', '24.9', 0),
('d42996dc1b0b6f975091b1a40b838ebc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStickerMule.js', '24.9', 0),
('ef762e6b1187c29adabbe37fcc5707f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStrava.js', '24.9', 0),
('cc4898b22a2d83efdc0f301ebadea500', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStripe.js', '24.9', 0),
('9386a8ee3f0fa68b7ba5890c6a2fb660', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStripeS.js', '24.9', 0),
('5d5da6efd5386568d3927f404f628fbb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStudiovinari.js', '24.9', 0),
('933aa1e305a6517a5d70aa2cbcca83f0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStumbleupon.js', '24.9', 0),
('cdec1133e09dad7e77408588e8926303', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faStumbleuponCircle.js', '24.9', 0),
('ae1a878cbce3af2c656a2af0d7cab886', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSuperpowers.js', '24.9', 0),
('1ab0c69388ec39a248b8e809e855513d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSupple.js', '24.9', 0),
('47808c17f8a15e642d62486bf791a763', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSuse.js', '24.9', 0),
('a179ab42606b60b9edaf5ac5a12d8cc2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSwift.js', '24.9', 0),
('16adc82d8c908da6ffdb4efe1b3e2e65', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faSymfony.js', '24.9', 0),
('200496667f4435bcde6efc8889cceca9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTeamspeak.js', '24.9', 0),
('dde2a4e48bb75e47b4a55934681c8f3b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTelegram.js', '24.9', 0),
('9a23638d5126729f10bca1232fa51e0f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTelegramPlane.js', '24.9', 0),
('380339330a212d57ed37aa36edaf104f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTencentWeibo.js', '24.9', 0),
('b8bc9c8dce1208726fe376a4bad0fbf0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTheRedYeti.js', '24.9', 0),
('544d82b4f9c0fe8b99467dbc42612f36', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faThemeco.js', '24.9', 0),
('4c627ffa00736f9f7d9d697400e6b0e2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faThemeisle.js', '24.9', 0),
('dd27b5b72c68bc0471a6fa350d6f6058', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faThinkPeaks.js', '24.9', 0),
('77246050df42fe483f9fee6f0cb3af57', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTiktok.js', '24.9', 0),
('fde59d60100f1fefe7e7535291d50e61', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTradeFederation.js', '24.9', 0),
('f229270f952cb5f0687b0e069db68555', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTrello.js', '24.9', 0),
('f93033f3da7f0fc2d6774fa43ca37b41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTripadvisor.js', '24.9', 0),
('6b77f7c77f97df45ef0c4837074d45fc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTumblr.js', '24.9', 0),
('637cc65fe3211e4c890a9337bb471db9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTumblrSquare.js', '24.9', 0),
('d61790d21576ccf08fbef1f2f6320ce5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTwitch.js', '24.9', 0),
('ed0a69c205297646f5d6b8a76d6db550', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTwitter.js', '24.9', 0),
('a8871ceb3eb0297e048b09769691f5b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTwitterSquare.js', '24.9', 0),
('0f24a4a5d190df410d36898fb031c2e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faTypo3.js', '24.9', 0),
('98ae82a7b3027707d9d537a2b7c8f128', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUber.js', '24.9', 0),
('a055442df972e0321bc3ab87677b4c1f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUbuntu.js', '24.9', 0),
('fe091a58ad1db59f745dfc808710158f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUikit.js', '24.9', 0),
('197b3c17feecde918ebf474e34bcb4d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUmbraco.js', '24.9', 0),
('de06687d854e62440db13d763fbfe41f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUncharted.js', '24.9', 0),
('35037f577936e15fa815099e765d5ee5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUniregistry.js', '24.9', 0),
('085fbb67377d023a866e1bb3165e8a9f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUnity.js', '24.9', 0),
('ea19d092052037b7e1398fc22081c92b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUnsplash.js', '24.9', 0),
('f3df0e183c5e1e4aabba4aeea39e87f6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUntappd.js', '24.9', 0),
('c3b2aaae1c01ac8ac133fd6f6b3b6d39', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUps.js', '24.9', 0),
('199899231b36a766e6e35c7a932bc2d2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUsb.js', '24.9', 0),
('7edaf8c30b7321b6c4cb30f4fc1c6f5d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUsps.js', '24.9', 0),
('84deed27ed51017fe1d9e0931c8d9fed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faUssunnah.js', '24.9', 0),
('359b50a8714b058cd98e3ade6668392f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVaadin.js', '24.9', 0),
('861e538c5127b66053fff16ab1c3ee7b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViacoin.js', '24.9', 0),
('f9f81e37dc390648d3144a4af25f1872', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViadeo.js', '24.9', 0),
('baf075d7c2cb650eb1ad896f908d62f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViadeoSquare.js', '24.9', 0),
('60265669816647b370d7afd8a9554661', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faViber.js', '24.9', 0),
('289159e6f5bea4a28656a9a3c6194450', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVimeo.js', '24.9', 0),
('3f11fd781336d1d31063df12ce0c318a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVimeoSquare.js', '24.9', 0),
('1181a1b128893cbea4aea5b7fa0f65b2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVimeoV.js', '24.9', 0),
('ccaa65a00e9730bf63019bed2ea93d72', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVine.js', '24.9', 0),
('3e09b7478514647c2d78f83839b2a9b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVk.js', '24.9', 0),
('3981c1e58125c20ac548876c22c6b3cb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVnv.js', '24.9', 0),
('cab9fb9b5b0e9db3c79f894ea39d9cb2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faVuejs.js', '24.9', 0),
('80e1a92c11b6065699cd8e0efeb8fd53', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWatchmanMonitoring.js', '24.9', 0),
('3df53f1a08c5b475d7329d6ea0a6bca9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWaze.js', '24.9', 0),
('97e1a57a2c16f5d78d4ccbd1e4ececf6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWeebly.js', '24.9', 0),
('5be4b594bbb26a66eaf1923990939d5d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWeibo.js', '24.9', 0),
('e504cb001537b88dc617e30a7d2c7511', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWeixin.js', '24.9', 0),
('a37e5beeb0a4673b7520e4900cfec873', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWhatsapp.js', '24.9', 0),
('a798b260c5dae4fa92c65208cfb037d8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWhatsappSquare.js', '24.9', 0),
('a7b27dc32288511f69bf6917da4ac068', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWhmcs.js', '24.9', 0),
('10d5b59f96b613b3af5b8db020ed661e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWikipediaW.js', '24.9', 0),
('3976380f068cc12d154e6df6a38a4851', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWindows.js', '24.9', 0),
('6438ab925b124f1785d41135ac3b0c46', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWix.js', '24.9', 0),
('3ee9c6c77da5d154744b923b99c79102', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWizardsOfTheCoast.js', '24.9', 0),
('2a2ee39ecc97cf5e19e06b346b1ac02a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWodu.js', '24.9', 0),
('f81415765dd9e25ce2d6cca1c458c13b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWolfPackBattalion.js', '24.9', 0),
('3fd21fbe2b76abfcf51376c92e28e8a0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWordpress.js', '24.9', 0),
('9ed9343ee33da37e8f0ef72b412b836e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWordpressSimple.js', '24.9', 0),
('e0e78449d17fd0e6e7f98c84ab409352', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpbeginner.js', '24.9', 0),
('ea7346702eb002cb853947dc86e7bda6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpexplorer.js', '24.9', 0),
('f560f83201180b4a7e95857d385bf444', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpforms.js', '24.9', 0),
('10081c4c4997e3fa850657c7c5a27480', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faWpressr.js', '24.9', 0),
('5cf2d555a2c4e11f5c0043daaf145a15', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faXbox.js', '24.9', 0),
('fc7752020ce75063b869f2cdaf111901', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faXing.js', '24.9', 0),
('f67e1bb644d9bb10d6c510d1bbb106d0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faXingSquare.js', '24.9', 0),
('b09273c829ff5796ad3ad923bbc10b05', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYCombinator.js', '24.9', 0),
('74b49b9f4d45ad86ce8c9754cc6f5484', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYahoo.js', '24.9', 0),
('35a617eafbb257941509e9b746e61ac5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYammer.js', '24.9', 0),
('1a98f74f6f5aa09bbf0c64f2b201e82c', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYandex.js', '24.9', 0),
('82caa70365825ab42f8dc11182c51ae9', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYandexInternational.js', '24.9', 0),
('165d77ca4652a7db12cc125a50f858a1', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYarn.js', '24.9', 0),
('b7e32265c2c2bbbf59c70e429f1e80b5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYelp.js', '24.9', 0),
('256b2d5be2438f1299446c225d93be88', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYoast.js', '24.9', 0),
('e1747a4c575ff54551c08bea7dcccb12', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYoutube.js', '24.9', 0),
('bbcaa40f041106b343575c0a2465bfe0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faYoutubeSquare.js', '24.9', 0),
('d19d48db60f4de6ecb1b13c033e5215e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/faZhihu.js', '24.9', 0),
('e497d8434e47cd83dec718167f03fbc3', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/index.es.js', '24.9', 0),
('6aa24e31450f4333a26cc2db58778719', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/index.js', '24.9', 0),
('d41d8cd98f00b204e9800998ecf8427e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-brands-svg-icons/index.php', '24.9', 0),
('d79bb88d77c2c925c107cc14e1874a04', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/attribution.js', '24.9', 0),
('466c44c1b290935750cd9600a32df38f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faAddressBook.js', '24.9', 0),
('90e108cc7afe97ddee044f5530319179', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faAddressCard.js', '24.9', 0),
('87880a38343ff4b4d9a6dc2f1cb79d83', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faAngry.js', '24.9', 0),
('8e2c836eebce13e42fe845e7be5c719b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleDown.js', '24.9', 0),
('453cebfad8491278c105e12600e9ef22', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleLeft.js', '24.9', 0),
('eb05306a42564d4d20edd8a71ef74d41', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleRight.js', '24.9', 0),
('1c05febf33595d4c195251e3bfddbe08', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faArrowAltCircleUp.js', '24.9', 0),
('32bca4be5113caa1752e76022034025a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBell.js', '24.9', 0),
('f75c38f2dbdf9cd27c5da3c1e3cea6f5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBellSlash.js', '24.9', 0),
('c447c141d00c2b083c10154452962a42', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBookmark.js', '24.9', 0),
('c6485f53c4bd6a6f2ddee016984a91c0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faBuilding.js', '24.9', 0),
('52ba6dd0ea270d13412c112be77f4105', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendar.js', '24.9', 0),
('60775fa99f7908a3e5799757a4fd6c45', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarAlt.js', '24.9', 0);
INSERT INTO `tiki_secdb` VALUES
('671e042b8772a009b1659086355ff2cb', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarCheck.js', '24.9', 0),
('7747e80faee31b35b4447aab8e235dc5', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarMinus.js', '24.9', 0),
('5faa91db9e2bb6f39a4667ca562f0c44', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarPlus.js', '24.9', 0),
('98519d99b8f60eae76c741a4502810bd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCalendarTimes.js', '24.9', 0),
('2de5b81176c926eefbf5348ac946ce65', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareDown.js', '24.9', 0),
('8f01ef89435a1e47c7c074b60529fe2a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareLeft.js', '24.9', 0),
('9da9b37df339387d45db63034fd05640', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareRight.js', '24.9', 0),
('8ab07ff59713b02c5d8a03b33fbf27ed', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCaretSquareUp.js', '24.9', 0),
('52df47d2cf6d018143bf023470585a60', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faChartBar.js', '24.9', 0),
('19a2f1efd99e4919b3a61dec1e0c7c00', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCheckCircle.js', '24.9', 0),
('c967e452ec187c8ad99493c473d1657b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCheckSquare.js', '24.9', 0),
('7d50cd8773a37dedef6c6ea5c87d77da', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCircle.js', '24.9', 0),
('19aec6bc0067a36e814f8fdb337f60e4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClipboard.js', '24.9', 0),
('b019f90d416e5602fd78b1992ce99357', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClock.js', '24.9', 0),
('a7bb0fb9da17aa21c74dbe8dff756011', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClone.js', '24.9', 0),
('d1d5d5c0c645caf94ccd0fd6fa696349', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faClosedCaptioning.js', '24.9', 0),
('c4a48031d059b4c876aca73239f930bd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faComment.js', '24.9', 0),
('137e19af5bdd6316ee96dfc46a014160', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCommentAlt.js', '24.9', 0),
('0040d1a4cdbb7a58bcbc26b79a22a77e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCommentDots.js', '24.9', 0),
('711b3535b4e042558f63b76f3378eedc', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faComments.js', '24.9', 0),
('ba25485efba6dbf1e7dbb82e49af11b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCompass.js', '24.9', 0),
('ee21fbc099f0056b5ef06cd1ee47a972', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCopy.js', '24.9', 0),
('88b068598bd4552a969606652e8ddb61', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCopyright.js', '24.9', 0),
('132883920bab6d50540e0e5b266feecd', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faCreditCard.js', '24.9', 0),
('36aa0f31ce7fe4013fe16c2adfad2c62', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faDizzy.js', '24.9', 0),
('9da37766ea6c9480da9640ce3764957f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faDotCircle.js', '24.9', 0),
('b7798ccd42434f0cdc18db195a496084', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEdit.js', '24.9', 0),
('6f6220a9e6693b2204e449579d696ef4', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEnvelope.js', '24.9', 0),
('1e98522be1d2b239cf0b62499d02aea6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEnvelopeOpen.js', '24.9', 0),
('f6e833986233de85acc9612f6bcf8086', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEye.js', '24.9', 0),
('06670399056f5eae0851ed3155055685', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faEyeSlash.js', '24.9', 0),
('b740bb0a4b7b1f6c9fd56456ed531d8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFile.js', '24.9', 0),
('1c7f05624c02cbeca30bd0398f1c77d2', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileAlt.js', '24.9', 0),
('3811c8b8f6437b3b74d2944011568abf', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileArchive.js', '24.9', 0),
('f71d3160f7fbdfd1685b399b394d982d', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileAudio.js', '24.9', 0),
('c5397e99de1fd59471b1b1c1c968b9f6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileCode.js', '24.9', 0),
('53c90de4bdc40250e55081d66a318c02', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileExcel.js', '24.9', 0),
('019b6f41570607eb700df03b001701ba', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileImage.js', '24.9', 0),
('378a1e43cd5757c242f8692504d03975', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFilePdf.js', '24.9', 0),
('edbb10de8771c256e1aa6e4f6b5f9986', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFilePowerpoint.js', '24.9', 0),
('4ea2b0a681edf5424e342d03e58b67a8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileVideo.js', '24.9', 0),
('fb08043230d536d6b698d3690210dc84', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFileWord.js', '24.9', 0),
('ad1ced2c65ff5f5e9802c6a81476efe8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFlag.js', '24.9', 0),
('b42bdce5021c00a6b5880f724bfd224f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFlushed.js', '24.9', 0),
('c05f5cd7a69896a6acb6dccc8fe0101f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFolder.js', '24.9', 0),
('cd3044d9facb321fce3290669eee2e76', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFolderOpen.js', '24.9', 0),
('331b28ee0030939f33584a78bffd7ea0', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFontAwesomeLogoFull.js', '24.9', 0),
('a6af14b86e2f8577cc5cec6343ce8e8b', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFrown.js', '24.9', 0),
('adfb52dd0227cf64136aae70ccf4e34f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFrownOpen.js', '24.9', 0),
('407f05e0e32a5c5211a81152fb5b9136', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faFutbol.js', '24.9', 0),
('a83c8eb3592079e0b923a560d6e08113', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGem.js', '24.9', 0),
('bc1349edfc688d8770540516966c206e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrimace.js', '24.9', 0),
('bfb7dac612067790b1e0af085de50cf7', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrin.js', '24.9', 0),
('f6a070f3bb0fad875b7e8a52036849d6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinAlt.js', '24.9', 0),
('080fb6f624f4fac5bd3cafa93768d104', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinBeam.js', '24.9', 0),
('9ce13954cdf93b44aef9e703fc90f1b6', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinBeamSweat.js', '24.9', 0),
('6f682f62943803fb11b958e573c618f8', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinHearts.js', '24.9', 0),
('2c3f00884af30580e77a21bc38140eac', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinSquint.js', '24.9', 0),
('adbc11c46bd2c35e26dad1aa0a8a1300', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinSquintTears.js', '24.9', 0),
('54fb912d7b9eae623f4438fed7b5ff70', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinStars.js', '24.9', 0),
('cdc204e8af1ae4581a0c5e11c5705b5f', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinTears.js', '24.9', 0),
('8b6cfa235a80a7eb7c140f1811700b9e', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortawesome/free-regular-svg-icons/faGrinTongue.js', '24.9', 0),
('32ead6d04b8b446a5e9e7292f8e3e53a', './vendor_bundled/vendor/bower-asset/fontawesome/js-packages/@fortaw