<?php
/**
 * Cart status config REST API controller
 *
 *
 */
class Api_Cartstatusemail_Cartstatus extends Api_Service_Abstract
{

    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    /**
     * Get cart status email data
     *
     * Resourse:
     * : /api/cartstatusemail/cartstatus/id/:id
     *
     * HttpMethod:
     * : GET
     *
     * ## Parameters:
     * * id (type integer)
     * : id
     *
     * pairs (type sting)
     * : If given data will be returned as key-value array
     *
     * @return JSON List of groups
     */
    public function getAction()
    {
        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $cartStatusSettingsMapper = Cartstatusemail_Models_Mapper_CartstatusemailSettingsMapper::getInstance();
        $cartStatusDbtable = new Cartstatusemail_Models_Dbtables_CartstatusemailSettingsDbtable();
        if ($id) {
            $where = $cartStatusSettingsMapper->getDbTable()->getAdapter()->quoteInto('id=?', $id);
            $data = $cartStatusSettingsMapper->fetchAll($where);
            $allProductIdsData[0]['productsIds'] = $data[0]->getProductsIds();
        } else {
            $data = $cartStatusSettingsMapper->fetchAll();
            $select = $cartStatusDbtable->select()->from(
                'plugin_cartstatusemail_settings',
                array('productsIds' => new Zend_Db_Expr("GROUP_CONCAT(productsIds, ',', productsIds)"))
            );
            $allProductIdsData = $cartStatusSettingsMapper->getDbTable()->getAdapter()->fetchAll($select);
        }

        if (!empty($allProductIdsData)) {
            $productIdArray = explode(',', $allProductIdsData[0]['productsIds']);
            $productIdArray = array_unique($productIdArray);
            $select = $cartStatusDbtable->select()
                                        ->setIntegrityCheck(false)
                                        ->from(array('p' => 'page'), array('productId' => 'product.id', 'pageUrl' => 'p.url'))
                                        ->joinleft(array('product' => 'shopping_product'), 'product.page_id = p.id')
                                        ->where('product.id IN (?)', $productIdArray);
            $result = $cartStatusSettingsMapper->getDbTable()->getAdapter()->fetchAssoc($select);
        }

        foreach ($data as $key => $cartStatus) {
            $cartStatusData[$key]['cartStatus'] = $cartStatus->getCartStatus();
            $cartStatusData[$key]['period'] = $cartStatus->getPeriod();
            $cartStatusData[$key]['productsIds'] = $cartStatus->getProductsIds();
            $cartStatusData[$key]['emailTemplate'] = $cartStatus->getEmailTemplate();
            $cartStatusData[$key]['emailFrom'] = $cartStatus->getEmailFrom();
            $cartStatusData[$key]['emailMessage'] = $cartStatus->getEmailMessage();
            $cartStatusData[$key]['productsRule'] = $cartStatus->getProductsRule();
            $cartStatusData[$key]['schedulePeriod'] = $cartStatus->getSchedulePeriod();
            $cartStatusData[$key]['lagType'] = $cartStatus->getLagType();
            $cartStatusData[$key]['sequenceOnly'] = $cartStatus->getSequenceOnly();
            $cartStatusData[$key]['triggerName'] = $cartStatus->getTriggerName();
            $cartStatusData[$key]['schedulePeriodType'] = $cartStatus->getSchedulePeriodType();
            $cartStatusData[$key]['id'] = $cartStatus->getId();
            $cartStatusData[$key]['prodData'] = !empty($result) ? $result : '';
            $cartStatusData[$key]['subject'] = $cartStatus->getSubject();

        }
        if (!empty($cartStatusData)) {
            return array_values($cartStatusData);
        }
        return array();

    }

    /**
     * New cart status email config settings
     *
     * Resourse:
     * : /api/cartstatusemail/cartstatus/
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON New cart status email model
     */
    public function postAction()
    {
        $data = $this->getRequest()->getPost();
        $cache = Zend_Controller_Action_HelperBroker::getStaticHelper('Cache');
        $translator = Zend_Registry::get('Zend_Translate');

        if (!isset($data['periodDays']) && !isset($data['cartStatus'])) {
            $this->_error();
        }
        if ($data['cartStatus'] == '0') {
            $this->_error($translator->translate('Please choose cart status'));
        }

        if (!isset($data['productsIds'])) {
            $this->_error($translator->translate('Please add products'));
        }

        if (empty($data['lagType'])) {
            $this->_error($translator->translate('Empty lag type'));
        }

        if (empty($data['schedulePeriodType'])) {
            $this->_error($translator->translate('Empty schedule period type'));
        }

        if (!in_array($data['lagType'], Cartstatusemail_Models_Models_CartstatusemailSettingsModel::$_lagTypes)) {
            $this->_error($translator->translate('Wrong lag type'));
        }

        if (!in_array($data['schedulePeriodType'], Cartstatusemail_Models_Models_CartstatusemailSettingsModel::$_schedulePeriodTypes)) {
            $this->_error($translator->translate('Wrong period type'));
        }

        if (!empty($data['schedulePeriod']) && is_array($data['schedulePeriod'])) {
            $data['schedulePeriod'] = implode(',' ,$data['schedulePeriod']);
        }

        $data['period'] = filter_var(trim($data['period']), FILTER_SANITIZE_NUMBER_INT);

        if (empty($data['period'])) {
            $this->_error($translator->translate('Period of time Can\'t be empty'));
        }

        if ($data['productsRule'] != 'without' && in_array($data['cartStatus'], Cartstatusemail::$cartStatuses)) {
            if (empty($data['productsIds'])) {
                $this->_error($translator->translate('Please add products'));
            }
        } else {
            $data['productsIds'] = '';
        }

        if (!in_array($data['cartStatus'], Cartstatusemail::$cartStatuses)) {
            $data['productsRule'] = 'without';
        }

        $secureToken = $this->getRequest()->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
        $tokenValid = Tools_System_Tools::validateToken($secureToken, Cartstatusemail::CARTSTATUS_SECURE_TOKEN);
        if (!$tokenValid) {
            $this->_error('invalid token');
        }

        $cartId = !empty($data['cartId']) ? $data['cartId'] : false;

        $cartStatusSettingsMapper = Cartstatusemail_Models_Mapper_CartstatusemailSettingsMapper::getInstance();

        $model = $cartStatusSettingsMapper->find($cartId);
        if (!$model instanceof Cartstatusemail_Models_Models_CartstatusemailSettingsModel) {
            $model = new Cartstatusemail_Models_Models_CartstatusemailSettingsModel();
        }

        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if (method_exists($model, 'set' . ucfirst($key))) {
                    $model->{'set' . ucfirst($key)}($value);
                }
            }
        }

        $model = $cartStatusSettingsMapper->save($model);

        $cache->clean('cartstatus_configdata', 'cart_status');
        return $model->toArray();
    }

    public function putAction()
    {

    }

    /**
     * Delete cart status email
     *
     * Resourse:
     * : /api/cartstatusemail/cartstatus/
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (type integer)
     * : cart id to delete
     *
     * @return JSON Result of removing cart status email
     */
    public function deleteAction()
    {
        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $cache = Zend_Controller_Action_HelperBroker::getStaticHelper('Cache');

        if (!$id) {
            $this->_error();
        }
        Cartstatusemail_Models_Mapper_CartstatusemailQueueMapper::getInstance()->deleteQueueByCartStatusId($id, array('0'));
        $cache->clean('cartstatus_configdata', 'cart_status');
        return Cartstatusemail_Models_Mapper_CartstatusemailSettingsMapper::getInstance()->deleteCartStatus($id);
    }

}
