define([
	'backbone'
], function(Backbone){
    var StatusFormView = Backbone.View.extend({
        el: $('#add-edit-status-cart'),
        events: {
            'submit': 'submit',
            'click #test-status-email' : 'testStatusEmail'
        },
        templates: {

        },
        initialize: function(){
            console.log('render form');
            this.$el = $('#add-edit-status-cart');
            this.$el.attr('action', $('#website_url').val()+'api/cartstatusemail/cartstatus/');

        },
        render: function(){
            this.$el = $('#add-edit-status-cart');
            this.$el.attr('action', $('#website_url').val()+'api/cartstatusemail/cartstatus/');
            return this;
        },
        submit: function(e){
            e.preventDefault();
            var self = this,
                form = $(e.currentTarget),
                isValid = true;

            _.each(form.find('.required'), function(el){
                if (!$(el).val()){
                    isValid = false;
                }
            });

            if (!isValid){
                showMessage('Missing required field', true);
                return false;
            }

            if ($('#cart-status').val() === 'no_cart' && !$('#sequence-only').is(':checked')) {
                showMessage('You can use "No Cart" status only with Sequence only', true, 5000);
                return false;
            }

            if ($('#sequence-only').is(':checked') && $('#sequence-trigger-name').val() == '') {
                showMessage('Please provide a name for email sequence trigger', true, 5000);
                return false;
            }

            showSpinner();
            var data = this.$el.serialize(),
                period = $('#period').val(),
                cartStatus  = $('#cart-status').val(),
                productsRulePrepare = $('#productsRulePrepare').val(),
                productsRule = $('#productsRule').val(),
                emailTemplate = $('.emailTemplate').val(),
                emailFrom = $('#emailFrom').val(),
                emailMessage = $('#emailMessage').val(),
                productsIds = $('.productsIds').val(),
                secureToken = $('.secureToken').val(),
                cartId = $('#cartId').val(),
                schedulePeriodType = $('input.schedule-period-type:checked').val(),
                lagType = $('#lag-type').val(),
                sequenceOnlyStatus = $('#sequence-only').is(':checked'),
                sequenceOnly = 0,
                triggerName = $('#sequence-trigger-name').val(),
                schedulePeriod = [],
                subject = $('#subject').val();


            if (productsRulePrepare == 'without') {
                productsRule = productsRulePrepare;
            }

            if (sequenceOnlyStatus) {
                sequenceOnly = 1;
            }

            $.each($("input.schedule-period:checked"), function() {
                schedulePeriod.push($(this).val());
            });

            if (_.isEmpty(schedulePeriod)) {
                showMessage('Please choose at least one day of the week', true, 5000);
                hideSpinner();
                return false;
            }

            $.ajax({
                url: this.$el.attr('action'),
                data: {
                    period:period,
                    cartStatus:cartStatus,
                    productsRule:productsRule,
                    emailTemplate:emailTemplate,
                    emailFrom:emailFrom,
                    emailMessage:emailMessage,
                    productsIds:productsIds,
                    secureToken:secureToken,
                    cartId:cartId,
                    schedulePeriod:schedulePeriod,
                    schedulePeriodType:schedulePeriodType,
                    lagType:lagType,
                    sequenceOnly:sequenceOnly,
                    triggerName:triggerName,
                    subject:subject
                },
                type: 'POST',
                dataType: 'json'
            }).done(function(response) {
                    self.$el.trigger('reset');
                    self.$el.trigger('status:created');
                    $('.productsIds').val('');
                    $('#cartId').val('');
                    $('.productChekedImage').remove();
                    $('#productsRule').show();
                    $('.prodInfoLabel').show();
                    $('.show-list').show();
                    $('input.marker').attr('checked', false);
                    $('#productsRulePrepare').removeClass('hidden');
                    $('#productsRule').removeClass('hidden');
                    $('#cart-status-products-block').removeClass('hidden');
                    hideSpinner();
                    showMessage('Saved');

            }).fail(function(response){
                    hideSpinner();
                    showMessage(response.responseText, true);
            });

        },
        testStatusEmail: function(e)
        {
            e.preventDefault();
            var data = this.$el.serialize(),
                period = $('#period').val(),
                cartStatus  = $('#cart-status').val(),
                productsRulePrepare = $('#productsRulePrepare').val(),
                productsRule = $('#productsRule').val(),
                emailTemplate = $('.emailTemplate').val(),
                emailFrom = $('#emailFrom').val(),
                emailMessage = $('#emailMessage').val(),
                productsIds = $('.productsIds').val(),
                secureToken = $('.secureToken').val(),
                cartId = $('#cartId').val(),
                schedulePeriodType = $('input.schedule-period-type:checked').val(),
                lagType = $('#lag-type').val(),
                sequenceOnlyStatus = $('#sequence-only').is(':checked'),
                sequenceOnly = 0,
                triggerName = $('#sequence-trigger-name').val(),
                schedulePeriod = [],
                subject = $('#subject').val();


            if (productsRulePrepare == 'without') {
                productsRule = productsRulePrepare;
            }

            if (sequenceOnlyStatus) {
                sequenceOnly = 1;
            }

            $.each($("input.schedule-period:checked"), function() {
                schedulePeriod.push($(this).val());
            });

            $.ajax({
              'url': $('#website_url').val()+'plugin/cartstatusemail/run/testStatusEmail/',
              'data': {
                    period:period,
                    cartStatus:cartStatus,
                    productsRule:productsRule,
                    emailTemplate:emailTemplate,
                    emailFrom:emailFrom,
                    emailMessage:emailMessage,
                    productsIds:productsIds,
                    secureToken:secureToken,
                    cartId:cartId,
                    schedulePeriod:schedulePeriod,
                    schedulePeriodType:schedulePeriodType,
                    lagType:lagType,
                    sequenceOnly:sequenceOnly,
                    triggerName:triggerName,
                    subject:subject
              },
              'type' : 'POST',
              'dataType': 'json'
            }).done(function(response){
                if (response.error == '1') {
                    showMessage(response.responseText, true, 5000);
                } else {
                    showMessage(response.responseText, false, 5000);
                }
            });
        },
        validate: function(e){
            var el = $(e.currentTarget);
            console.log(el.data());
        }

    });

    return StatusFormView;
});