define([
	'backbone',
    '../collections/email-sequence-trigger',
    'text!../templates/email-sequence-triggers.html',
    'text!../templates/email-sequence-triggers-placeholder.html',
    'i18n!../../../nls/dashboard_'+$('#email-sequence-dashboard-system-language').val()+'_ln'
], function(Backbone, EmailSequenceTriggerCollection, EmailSequenceTriggersTmpl, EmailSequenceTriggersPlaceholderTmpl, i18n){
    var EmailSequenceTriggersView = Backbone.View.extend({
        el: $('#email-sequence-triggers-block'),
        events: {
            'click .sequence-trigger-test': 'testTrigger',
            'click .sequence-trigger-delete': 'deleteTrigger',
            'change input.sequence-trigger-status-switch': 'switchTrigger',
            'click .sequence-switch-cart-status': 'switchCartStatus',
            'mouseenter .trigger-sequence-products-block': 'showProducts',
            'mouseleave .trigger-sequence-products-block': 'hideProducts'
        },
        templates: {},
        initialize: function(sequenceId){
           this.$el.unbind();
           this.$el = $('#email-sequence-triggers-block');
           this.emailSequenceTriggersCollection = new EmailSequenceTriggerCollection();
           this.emailSequenceTriggersCollection.sequenceId = sequenceId;
           this.emailSequenceTriggersCollection.on('reset', this.render, this);
           this.emailSequenceTriggersCollection.on('add', this.render, this);
           this.emailSequenceTriggersCollection.on('destroy', this.render, this);
           this.emailSequenceTriggersCollection.pager();
        },
        render: function(){
            this.$el = $('#email-sequence-triggers-block');
            this.$el.empty();
            if (this.emailSequenceTriggersCollection.totalRecords > 0) {
                this.$el.html(_.template(EmailSequenceTriggersTmpl, {'sequenceTriggerModels':this.emailSequenceTriggersCollection, 'productsData': this.emailSequenceTriggersCollection.productsData, 'i18n': i18n}));
            } else {
                this.$el.html(_.template(EmailSequenceTriggersPlaceholderTmpl, {'i18n': i18n}));
            }
            return this;
        },
        showProducts: function(e)
        {
            $(e.currentTarget).find('.trigger-sequence-list-block').removeClass('hidden');
        },
        hideProducts: function(e)
        {
            $(e.currentTarget).find('.trigger-sequence-list-block').addClass('hidden');
        },
        testTrigger: function(e)
        {
            e.preventDefault();
            var blockEl = $(e.currentTarget).closest('.single-trigger-row'),
                sequenceId = blockEl.data('sequence-id'),
                triggerId = blockEl.data('trigger-id'),
                cid = blockEl.data('cid-id'),
                self = this,
                model = this.emailSequenceTriggersCollection.get(cid);

            //showConfirm(_.isUndefined(i18n['Are you sure you want to send test notification?'])?'Are you sure you want to send test notification?':i18n['Are you sure you want to send test notification?'], function() {
                $.ajax({
                    'url': $('#website_url').val()+'plugin/emailsequence/run/testStatusEmail/',
                    'data': {
                        period:            model.get('period'),
                        cartStatus:        model.get('cartStatus'),
                        productsRule:      model.get('productsRule'),
                        emailTemplate:     model.get('emailTemplate'),
                        emailFrom:         model.get('emailFrom'),
                        emailFromLabel:    model.get('emailFromLabel'),
                        emailMessage:      model.get('emailMessage'),
                        productsIds:       model.get('productsIds'),
                        secureToken:       $('#email-sequence-grid-token').val(),
                        cartId:            model.get('id'),
                        schedulePeriod:    model.get('schedulePeriod'),
                        schedulePeriodType:model.get('schedulePeriodType'),
                        lagType:           model.get('lagType'),
                        sequenceOnly:      model.get('sequenceOnly'),
                        triggerName:       model.get('triggerName'),
                        subject:           model.get('subject'),
                        preheader:         model.get('preheader'),
                        type:              model.get('type'),
                        smsMessage:        model.get('emailMessage')
                    },
                    'type' : 'POST',
                    'dataType': 'json'
                }).done(function(response){
                    if (response.error == '1') {
                        showMessage(response.responseText, true, 5000);
                    } else {
                        showMessage(response.responseText, false, 5000);
                    }
                });
            //});
        },
        deleteTrigger: function(e)
        {
            e.preventDefault();
            var blockEl = $(e.currentTarget).closest('.single-trigger-row'),
                sequenceId = blockEl.data('sequence-id'),
                triggerId = blockEl.data('trigger-id'),
                self = this;

            $.ajax({
                url: $('#website_url').val()+'api/emailsequence/emailsequencetrigger/trigger_id/'+triggerId+'/sequence_id/'+sequenceId,
                type: 'DELETE',
                dataType: 'json'
            }).done(function(responseData) {
                showMessage(_.isUndefined(i18n['Trigger deleted'])?'Trigger deleted':i18n['Trigger deleted']);
                self.$el.unbind();
                self.emailSequenceTriggersView = new EmailSequenceTriggersView(sequenceId);
                self.emailSequenceTriggersView.render();
            }).fail(function(response){
                  showMessage(response.responseJSON, true, 5000);
            });

        },
        switchTrigger: function(e)
        {
            e.preventDefault();
            var blockEl = $(e.currentTarget).closest('.single-trigger-row'),
                sequenceId = blockEl.data('sequence-id'),
                triggerId = blockEl.data('trigger-id'),
                cid = blockEl.data('cid-id'),
                self = this,
                model = this.emailSequenceTriggersCollection.get(cid),
                triggerStatus = 0;

                if ($(e.currentTarget).is(':checked')) {
                    triggerStatus = 1;
                }

                model.set('secureToken', $('#email-sequence-secure-token').val());
                model.set('trigger_enabled', triggerStatus);
                model.save(null, {
                    success: function(model, response){
                        showMessage(response.responseText.message, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });
        },
        switchCartStatus: function(e)
        {
            var row = $(e.currentTarget),
                tabId = row.data('tab-id');

            $('.sequence-switch-cart-status').removeClass('active');
            row.addClass('active');
            $('.triggers-single-block').addClass('hidden');
            $('#'+tabId).removeClass('hidden');
        }

    });

    return EmailSequenceTriggersView;
});
