import merge from 'lodash/merge';
import unescape from 'lodash/unescape';
import moment from 'moment';
import lodash from 'lodash';

let defaultState = {
    configDataInfo: [],
    additionalInfo: [],
    selectedUserId: '',
    selectedDate:'',
    filterDateFrom:'',
    filterDateTo:'',
    changedDate:'',
    leadMeetingsNotesData:[],
    opportunitiesClosingSoonData:[],
    opportunitiesAdditionalInfo: [],
    engagedLeadsData: [],
    engagedLeadsAdditionalInfo: [],
    latestLeadsData: [],
    currencyInfo :[],
    oppStats :[],
    funnelGraphData:[],
    opportunityStagePerSourceGraphData:[],
    oppSalesGeneralInfo: [],
    salesGoalData: [],
    opportunityGoalData: [],
    opportunityGoalGraphData: [],
    opportunityGoalAdditionalInfo:[],
    latestLeadsAdditionalInfo:[],
    salesAdditionalInfo:[],
    salesGoalGraphData:[],
    filterPeriodMonths:[],
    checkedTasksItemsData: [],
    activeTaskMassAction: 0,
    isMassActionTaskActive: false,
    totalItemsFound:0,
    filterData:{},
    allCheckedTasksItemsTracking:{},
    changedTaskMeetingNotesGrid:''

};

let state = {};
merge(state, defaultState);

const actions = {

};

const mutations = {
    setFilterPeriodMonths: (state, payload) => {
        state.filterPeriodMonths = payload;
    },
    setSalesGoalGraphData: (state, payload) => {
        state.salesGoalGraphData = payload;
    },
    setSalesAdditionalInfo: (state, payload) => {
        state.salesAdditionalInfo = payload;
    },
    setOpportunityGoalAdditionalInfo: (state, payload) => {
        state.opportunityGoalAdditionalInfo = payload;
    },
    setOpportunityGoalGraphData: (state, payload) => {
        state.opportunityGoalGraphData = payload;
    },
    setOpportunityGoalData: (state, payload) => {
        state.opportunityGoalData = payload;
    },
    setSalesGoalData: (state, payload) => {
        state.salesGoalData = payload;
    },
    setChangedDate: (state, payload) => {
        state.changedDate = payload;
    },
    setSelectedDate : (state, payload) => {
        state.selectedDate = payload;
    },
    setFilterDateFrom : (state, payload) => {
        state.filterDateFrom = payload;
    },
    setFilterDateTo : (state, payload) => {
        state.filterDateTo = payload;
    },
    setConfigDataInfo : (state, payload) => {
        state.configDataInfo = payload;
    },
    setAdditionalInfo : (state, payload) => {
        state.additionalInfo = payload;
    },
    setSelectedUserId : (state, payload) => {
        state.selectedUserId = payload;
    },
    setLeadMeetingsNotesData : (state, payload) => {
        state.leadMeetingsNotesData = payload;
    },
    setOpportunitiesClosingSoonData: (state, payload) => {
        state.opportunitiesClosingSoonData = payload;
    },
    setOpportunitiesAdditionalInfo : (state, payload) => {
        state.opportunitiesAdditionalInfo = payload;
    },
    setEngagedLeadsInfo : (state, payload) => {
        state.engagedLeadsData = payload;
    },
    setEngagedLeadsAdditionalInfo : (state, payload) => {
        state.engagedLeadsAdditionalInfo = payload;
    },
    setLatestLeadsInfo : (state, payload) => {
        state.latestLeadsData = payload;
    },
    setCurrencyInfo : (state, payload) => {
        state.currencyInfo = payload;
    },
    setOppStats : (state, payload) => {
        state.oppStats = payload;
    },
    setOppSalesGeneralInfo: (state, payload) => {
        state.oppSalesGeneralInfo = payload;
    },
    setLatestLeadsAdditionalInfo: (state, payload) => {
        state.latestLeadsAdditionalInfo = payload;
    },
    setCheckedTasksItemsData: (state, payload) => {
        state.checkedTasksItemsData = payload;
    },
    setActiveTaskMassAction: (state, payload) => {
        state.activeTaskMassAction = payload;
    },
    setIsMassActionTaskActive: (state, payload) => {
        state.isMassActionTaskActive = payload;
    },
    setTotalItemsFound: (state, payload) => {
        state.totalItemsFound = payload;
    },
    setFilterData: (state, payload) => {
        state.filterData = payload;
    },
    setAllCheckedTasksItemsTracking: (state, payload) => {
        state.allCheckedTasksItemsTracking = payload;
    },
    setChangedTaskMeetingNotesGrid: (state, payload) => {
        state.changedTaskMeetingNotesGrid = payload;
    },
    setState: (state, payload) => {
        lodash.mergeWith(state, payload, (objValue, srcValue) => {
            if (lodash.isArray(objValue) ) {
                return srcValue;
            }
        });
    }
};

const getters = {
    getFilterPeriodMonths: (state) => {
        return state.filterPeriodMonths
    },
    getSalesGoalGraphData: (state) => {
        return state.salesGoalGraphData
    },
    getSalesAdditionalInfo: (state) => {
        return state.salesAdditionalInfo
    },
    getOpportunityGoalGraphData: (state) => {
        return state.opportunityGoalGraphData
    },
    getOpportunityGoalAdditionalInfo: (state) => {
        return state.opportunityGoalAdditionalInfo
    },
    getLatestLeadsAdditionalInfo: (state) => {
        return state.latestLeadsAdditionalInfo
    },
    getEngagedLeadsAdditionalInfo: (state) => {
        return state.engagedLeadsAdditionalInfo
    },
    getOpportunityGoalData: (state) => {
        return state.opportunityGoalData
    },
    getSalesGoalData: (state) => {
        return state.salesGoalData
    },
    getChangedDate: (state) => {
        return state.changedDate
    },
    getSelectedDate : (state) => {
        return state.selectedDate
    },
    getFilterDateFrom : (state) => {
        return state.filterDateFrom
    },
    getFilterDateTo : (state) => {
        return state.filterDateTo
    },
    getConfigDataInfo : (state) => {
        return state.configDataInfo
    },
    getAdditionalInfo : (state) => {
        return state.additionalInfo
    },
    getSelectedUserId : (state) => {
        return state.selectedUserId
    },
    getLeadMeetingsNotesData : (state) => {
        return state.leadMeetingsNotesData
    },
    getOpportunitiesClosingSoonData : (state) => {
        return state.opportunitiesClosingSoonData
    },
    getOpportunitiesAdditionalInfo : (state) => {
        return state.opportunitiesAdditionalInfo
    },
    getEngagedLeadsInfo : (state) => {
        return state.engagedLeadsData
    },
    getLatestLeadsInfo : (state) => {
        return state.latestLeadsData
    },
    getCurrencyInfo: (state) => {
        return state.currencyInfo
    },
    getOppStats: (state) => {
        return state.oppStats
    },
    getGraphFunnelData: (state) => {
        return state.funnelGraphData
    },
    getOpportunityStagePerSourceGraphData: (state) => {
        return state.opportunityStagePerSourceGraphData
    },
    getOppSalesGeneralInfo: (state) => {
        return state.oppSalesGeneralInfo
    },
    getCheckedTasksItemsData: (state) => {
        return state.checkedTasksItemsData
    },
    getActiveTaskMassAction: (state) => {
        return state.activeTaskMassAction
    },
    getIsMassActionTaskActive: (state) => {
        return state.isMassActionTaskActive
    },
    getTotalItemsFound: (state) => {
        return state.totalItemsFound
    },
    getFilterData: (state) => {
        return state.filterData
    },
    getAllCheckedTasksItemsTracking: (state) => {
        return state.allCheckedTasksItemsTracking
    },
    getChangedTaskMeetingNotesGrid: (state) => {
        return state.changedTaskMeetingNotesGrid
    },
    formatDate : (state) => {
        return (date) => {
            let finalDate =  moment(date).format('DD MMM YYYY hh:mm a');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatOnlyDate: (state) => {
        return (date) => {
            let finalDate = moment(date).format('DD MMM YYYY');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeOnly: (state) => {
        return (date) => {
            let finalDate = moment(date).format('hh:mm');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatTimeFull: (state) => {
        return (date) => {
            let finalDate = moment(date).format('hh:mm A');
            if (finalDate === 'Invalid date') {
                return '';
            }

            return finalDate;
        }
    },
    formatDateForGraphs : (state) => {
        return (date) => {
            return moment(date).format('DD-MMM-YYYY');
        }
    },
    sortByColumn : (state) => {
        return (data, columnName, reverse) => {
            if (typeof reverse !== 'undefined') {
                return _.orderBy(data, columnName).reverse();
            }

            return _.orderBy(data, columnName);
        }
    },
    truncateText : (state) => {
        return (text, limit) => {
            if (text.length > limit) {
                text = text.substring(0, (limit - 3)) + '...';
            }

            return text;
        }
    },
    cleanText : (state) => {
        return (text, replaceTo) => {
            let replaceToSymbol = '';

            if (typeof replaceTo !== 'undefined') {
                replaceToSymbol = replaceTo;
            }

            text = text.replace(/(<([^>]+)>)/gi, replaceToSymbol);

            return text;
        }
    },
    toCurrency : (state) => {
        return (value, decimals) => {
            let result = parseFloat(value),
                minDecimals = 2;

            if (typeof decimals !== 'undefined') {
                minDecimals = decimals;
            }

            if (isNaN(result)) {
                return '';
            }

            if (state.currencyInfo) {
                result = result.toLocaleString(state.currencyInfo.locale, { style: 'currency', currency: state.currencyInfo.currency, minimumFractionDigits: minDecimals, maximumFractionDigits: minDecimals });
            }

            return result;
        }
    },
    processWidth : (state) => {
        return (percent, element) => {
            if (typeof window.device !== 'undefined') {
                if (window.device.tablet() || window.device.mobile()) {
                    if (window.device.landscape()) {
                        if (window.device.mobile()) {
                            percent = 90;
                        } else {
                            percent = 45;
                        }
                    } else {
                        percent = 90;
                    }

                }
            }
            if (typeof element !== 'undefined') {
                return (($(element).width() * percent) / 100);
            } else {
                return (($(document).width() * percent) / 100);
            }
        }
    },
    unescapeValue: (state) => {
        return (value) => {
            return unescape(value);
        }
    }
};
export default {
    state,
    actions,
    getters,
    mutations
};
