define([
    'backbone',
    '../models/lead-type.js',
    'backbone.paginator'
], function(Backbone, LeadTypeModel){

    var LeadTypeCollection = Backbone.Paginator.requestPager.extend({
        model: LeadTypeModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadtype/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     5,
            totalPages:  5
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            excludeSystemValues: function(){ return this.excludeSystemValues; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadTypeCollection;
});