define([
    'backbone',
    './lead-imap-form.js',
    './lead-imap-grid.js'
], function(Backbone,
            LeadImapFormView, LeadImapGridView){
    var LeadCrmImapConfigMainView = Backbone.View.extend({
        el: $('#lead-crm-imap-config-block'),
        events:{
            'click a.copy-path-link-information-info': 'imapCopyPathInfo'
        },
        templates: {},
        initialize: function(){
            showSpinner();

            this.LeadImapForm = new LeadImapFormView();
            this.LeadImapForm.render();

            this.LeadImapGrid = new LeadImapGridView();
            this.LeadImapGrid.render();

            this.LeadImapForm.$el.on('LeadImapForm:created', _.bind(this.LeadImapGrid.render, this.LeadImapGrid));
        },
        imapCopyPathInfo: function(e)
        {
            e.preventDefault();
            if (document.queryCommandSupported("copy")) {
                var copyFromEl = $('<textarea/>');
                copyFromEl.text($(e.currentTarget).data('element-id'));
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage('Has been copied to clipboard.', false, 2000);
            }
        }
    });

    return LeadCrmImapConfigMainView;
});