define([
    'backbone',
    '../collections/lead-imap.js',
    'text!../templates/paginator.html',
    'text!../templates/imap-row.html',
    'i18n!../../../nls/config_'+$('#lead-crm-imap-config-system-language').val()+'_ln.js'
], function(Backbone,
            LeadsImapCollection, PaginatorTmpl, LeadImapRowTmpl, i18n
){

    var LeadImapGridView = Backbone.View.extend({
        el: $('#lead-crm-imap-config-grid-table'),
        events: {
            'click a[data-role=delete]': 'deleteLeadImap',
            'blur .lead-imap-edit-attribute'  : 'editLeadImap',
            'change .lead-imap-edit-attribute-select'  : 'editLeadImap',
            'click td.lead-crm-imap-config-grid-paginator a.page': 'navigate',
            'click a[data-role=edit]' : 'editLeadImapRow'
        },
        templates: {
            paginator: _.template(PaginatorTmpl)
        },
        initialize: function(options){
            this.leadImap = new LeadsImapCollection();
            this.$el =  $('#lead-crm-imap-config-grid-table');
            this.leadImap.on('reset', this.renderLeadImaps, this);
            this.leadImap.on('add', this.renderLeadImaps, this);
            this.leadImap.on('destroy', this.renderLeadImaps, this);
        },
        render: function(){
            this.leadImap.pager();
        },
        renderLeadImaps: function(){
            this.$el.find('tbody').empty();
            this.leadImap.each(this.renderLeadImap, this);
            this.leadImap.info()['i18n'] = i18n;
            if((this.leadImap.length == 0) && (this.leadImap.currentPage != 0)){
                this.leadImap.requestPreviousPage();
            }
            this.$('td.lead-crm-imap-config-grid-paginator').html(this.templates.paginator(this.leadImap.information));

            this.checkImapStatus();

        },
        renderLeadImap: function(leadsImapData){
            this.$el.find('tbody').append(_.template(LeadImapRowTmpl, {'leadsImapData': leadsImapData, 'leadOwners': this.leadImap.leadOwners, 'i18n' : i18n}));
            return false;
        },
        checkImapStatus: function() {
            var leadImapRows = $('#lead-crm-imap-config-grid-table').find('tr.lead-imap-row');

            if(leadImapRows.length) {
               var imapRowIds = [];
                _.each(leadImapRows, function(el){
                    var imapRowId = $(el).data('lead-imap-id');
                    imapRowIds.push(imapRowId);
                });

                $.ajax({
                    url:  $('#website_url').val()+'plugin/leads/run/checkImapConnections/' ,
                    type: 'POST',
                    data: {'imapRowsIds' : imapRowIds},
                    dataType: 'json'
                }).done(function(response) {
                    if(response.error != 1) {
                        var connectionStatus = response.responseText.connectionStatus;
                        _.each(connectionStatus, function(status , id){
                           var statusColor = (status == 'Connected') ? 'success' : 'error';
                            $('.lead-imap-row-status-'+id).empty().append('<span class="service_status '+ statusColor +'" style="padding:0 15px;">'+ status +'</span>');
                        });
                    } else {
                        showMessage(response.responseText, true, 5000);
                    }
                });
            }
        },
        deleteLeadImap: function(e){
            var self = this,
                cid = $(e.currentTarget).data('cid'),
                model = this.leadImap.get(cid);

            showConfirm(_.isUndefined(i18n['Are you sure want to delete'])?'Are you sure want to delete':i18n['Are you sure want to delete'], function(){
                if (model){
                    model.destroy();
                    self.render();
                }
            });
        },
        editLeadImapRow: function(e)
        {
            var el = $(e.currentTarget),
                leadImapId = el.closest('tr').data('lead-imap-id'),
                leadImapModel = this.leadImap.get(leadImapId),
                form = $('#lead-crm-imap-config-form');

            form.find('.service_name').val(leadImapModel.get('service_name'));
            form.find('.owner_id').val(leadImapModel.get('owner_id'));
            form.find('.host').val(leadImapModel.get('host'));
            form.find('.login').val(leadImapModel.get('login'));
            form.find('.password').prop('placeholder', '********').val('');
            form.find('.encryption').val(leadImapModel.get('encryption'));
            form.find('#update-imap-config').val('yes');
            form.find('#update-imap-config-id').val(leadImapId);
            var processAllEmails = leadImapModel.get('process_all_emails');

            if (processAllEmails == '0') {
                processAllEmails = false;
            } else {
                processAllEmails = true;
            }

            $('#lead-crm-imap-form-cancel').removeClass('hidden');
            form.find('#process-all-emails').prop('checked', processAllEmails);
            form.find('#lead-crm-imap-form-save').val(_.isUndefined(i18n['Update'])?'Update':i18n['Update']);

        },
        editLeadImap: function(e)
        {
            var el = $(e.currentTarget),
                currentValue = el.val(),
                oldValue = el.data('old-value'),
                leadImapId = el.closest('tr').data('lead-imap-id'),
                leadImapModel = this.leadImap.get(leadImapId),
                attrName =  el.data('attrName');

            if (currentValue != oldValue) {
                el.data('old-value', currentValue);
                leadImapModel.set(attrName, currentValue);
                leadImapModel.set('secureToken', $('#lead-imap-secure-token').val());
                leadImapModel.set('fastSave', 1);
                leadImapModel.save(null, {
                    success: function(model, response){
                        showMessage(response.message, false, 5000);
                    },
                    error: function(model, response){
                        showMessage(response.responseJSON, true, 5000);
                    }
                });

            }

        },
        navigate: function(e){
            e.preventDefault();

            var page = $(e.currentTarget).data('page');
            if ($.isNumeric(page)){
                this.leadImap.goTo(page);
            } else {
                switch(page){
                    case 'first':
                        this.leadImap.goTo(this.leadImap.firstPage);
                        break;
                    case 'last':
                        this.leadImap.goTo(this.leadImap.information.lastPage);
                        break;
                    case 'prev':
                        this.leadImap.requestPreviousPage();
                        break;
                    case 'next':
                        this.leadImap.requestNextPage();
                        break;
                }
            }
        }
    });

    return LeadImapGridView;
});
