define([
    'backbone',
    '../models/lead-general-reports',
    'backbone.paginator'
], function(Backbone, LeadGeneralReportsModel){

    var LeadGeneralReportsCollection = Backbone.Paginator.requestPager.extend({
        model: LeadGeneralReportsModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadgeneralreports/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            statsTypes: function(){ return this.statsTypes; },
            tabContentName: function(){ return this.tabContentName; },
            leadReportsCompare: function(){ return this.leadReportsCompare; },
            leadReportsFilterStartDate: function(){ return this.leadReportsFilterStartDate; },
            leadReportsFilterEndDate: function(){ return this.leadReportsFilterEndDate; },
            leadReportsCompareFilterStartDate: function(){ return this.leadReportsCompareFilterStartDate; },
            leadReportsCompareFilterEndDate: function(){ return this.leadReportsCompareFilterEndDate; }

        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.stats = response.stats;
            this.comparedTo = response.comparedTo;
            this.currencySymbol = response.currencySymbol;
            this.tabContentName = response.tabContentName;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadGeneralReportsCollection;
});