define([
    'backbone',
    '../models/lead-documents-data',
    'backbone.paginator'
], function(Backbone, LeadDocumentsModel){
    var LeadDocumentsCollection = Backbone.Paginator.requestPager.extend({
        model: LeadDocumentsModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leaddocuments/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     5,
            totalPages:  5
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            this.imageMagnificPopupExtensions = response.imageMagnificPopupExtensions;
            return this.server_api.count ? response.data : response;

        }

    });

    return LeadDocumentsCollection;
});