<?php

/**
 * Categories
 * @author: iamne <eugene@seotoaster.com> Seotoaster core team
 * Date: 7/3/12
 * Time: 5:37 PM
 */
class Api_Newslog_Tags extends Api_Service_Abstract
{

    const NEWS_TAGS_SECURE_TOKEN =  'NewsTags';

    protected $_accessList = array(
        Tools_Security_Acl::ROLE_GUEST => array('allow' => array('get')),
        Tools_Security_Acl::ROLE_USER => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_ADMIN => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_SUPERADMIN => array('allow' => array('get', 'post', 'put', 'delete'))
    );

    public function getAction()
    {
        $tags = Newslog_Models_Mapper_TagMapper::getInstance()->fetchAll();
        $tagsMap = array_map(
            function ($tag) {
                return array(
                    'id' => $tag->getId(),
                    'name' => $tag->getName()
                );
            },
            $tags
        );

        usort($tagsMap, function($a, $b) {
            return mb_strtolower($a['name']) <=> mb_strtolower($b['name']);
        });

        return $tagsMap;
    }

    public function postAction()
    {
        $tagData = Zend_Json::decode($this->_request->getRawBody());
        $tokenToValidate = $tagData[Tools_System_Tools::CSRF_SECURE_TOKEN];
        $valid = Tools_System_Tools::validateToken($tokenToValidate, self::NEWS_TAGS_SECURE_TOKEN);
        if (!$valid) {
            exit;
        }
        unset($tagData[Tools_System_Tools::CSRF_SECURE_TOKEN]);
        $tag = Newslog_Models_Mapper_TagMapper::getInstance()->save(
            new Newslog_Models_Model_Tag(array(
                    'name' => trim($tagData['name'])
                )
            )
        );
        return $tag->toArray();
    }

    public function putAction()
    {

    }

    public function deleteAction()
    {
        $ids = array_filter(filter_var_array(explode(',', $this->_request->getParam('id')), FILTER_VALIDATE_INT));
        if (!empty($ids)) {
            $tagMapper = Newslog_Models_Mapper_TagMapper::getInstance();
            $tags = Newslog_Models_Mapper_TagMapper::getInstance()->find($ids);
            if (is_array($tags)) {
                foreach ($tags as $tag) {
                    $tagMapper->delete($tag);
                }
            } else {
                $tagMapper->delete($tags);
            }
        }
    }
}
