<?php

class Api_Notifier_Subscribe extends Api_Service_Abstract{

    /**
     * Container mapper
     *
     * @var Application_Model_Mappers_ContainerMapper
     */
    private $_subscriptionMapper = null;

    protected $_accessList = array(
        Tools_Security_Acl::ROLE_GUEST => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_USER => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_SUPERADMIN => array('allow' => array('get', 'post', 'put', 'delete')),
        Tools_Security_Acl::ROLE_ADMIN => array('allow' => array('get', 'post', 'put', 'delete'))
    );

    public function init()
    {
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_subscriptionMapper = Notifier_Models_Mappers_NotifierSubscriptionsMapper::getInstance();
    }

    public function getAction()
    {
        // TODO: Implement getAction() method.
    }

    public function postAction()
    {
        if($this->_request->isPost()) {
            $rawSubscription = json_decode($this->_request->getRawBody(), true);
            if (empty($rawSubscription['endpoint']) || empty($rawSubscription['keys']['auth']) || empty($rawSubscription['keys']['p256dh'])) {
                return false;
            }
            $token = basename(filter_var($rawSubscription['endpoint'], FILTER_SANITIZE_URL));
            $subscription = new Notifier_Models_Models_NotifierSubscriptionsModel();
            $subscription->setToken($token);
            $subscription->setEndpoint(filter_var($rawSubscription['endpoint'], FILTER_SANITIZE_STRING));
            $subscription->setAuth(filter_var($rawSubscription['keys']['auth'], FILTER_SANITIZE_STRING));
            $subscription->setP256dh(filter_var($rawSubscription['keys']['p256dh'], FILTER_SANITIZE_STRING));
            return $this->_subscriptionMapper->save($subscription);
        }
    }

    public function putAction()
    {
        // TODO: Implement putAction() method.
    }

    public function deleteAction()
    {
        // TODO: Implement deleteAction() method.
    }

}