<?php

/**
 * AppsSettingsMapper.php
 *
 *
 * @method Apps_Models_Mapper_AppsSettingsMapper   getInstance()   getInstance()   Returns an instance of itself
 * @method Zend_Db_Table    getDbTable()    getDbTable()    Returns an instance of DbTable
 */
class Apps_Models_Mapper_AppsSettingsMapper extends Application_Model_Mappers_Abstract {

	protected $_dbTable = 'Apps_Models_Dbtables_AppsSettingDbtable';

	protected $_model   = 'Apps_Models_Models_AppsSettingsModel';

    /**
     * @param $settings Apps_Models_Models_AppsSettingsModel
     * @return int
     * @throws Exceptions_SeotoasterException
     */
    public function save($settings) {
        if(!$settings instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }
        $data = array(
            'service_name'  => $settings->getServiceName(),
            'status'        => $settings->getStatus(),
            'category'      => $settings->getCategory(),
            'detailed_info' => $settings->getDetailedInfo()
        );
        $serviceName = $settings->getServiceName();
        $where = $this->getDbTable()->getAdapter()->quoteInto("service_name=?", $serviceName);
        $existForm = $this->getByServiceName($serviceName);
        if(!empty($existForm)){
            return $this->getDbTable()->update($data, $where);
        }
        return $this->getDbTable()->insert($data);

    }

    public function getByServiceName($serviceName) {
        $where = $this->getDbTable()->getAdapter()->quoteInto("service_name=?", $serviceName);
        return $this->fetchAll($where);
    }

    public function selectConfig() {
        return $this->getDbTable()->getAdapter()->fetchPairs($this->getDbTable()->select()->from('plugin_apps_settings'));
    }

    /**
     * Find by service name
     *
     * @param string $serviceName service name
     * @return null
     */
    public function findByServiceName($serviceName)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("service_name=?", $serviceName);

        return $this->_findWhere($where);
    }

    /**
     * Select config by service status and type
     *
     * @param string $status service status ('0', '1')
     * @param string $categoryType category type ('sms', 'crm', 'email')
     * @param bool $fetchPairs return result as service name => status
     * @return array
     */
    public function selectConfigByStatusCategory($status, $categoryType, $fetchPairs = true)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto("status=?", $status);
        $where .= ' AND ' . $this->getDbTable()->getAdapter()->quoteInto("category=?", $categoryType);
        $select = $this->getDbTable()->select()->from('plugin_apps_settings')->where($where);
        if ($fetchPairs === true) {
            return $this->getDbTable()->getAdapter()->fetchPairs($select);
        } else {
            return $this->getDbTable()->getAdapter()->fetchAssoc($select);
        }
    }

}

