<?php

class Api_Crm_Crm extends Api_Service_Abstract
{


    /**
     * Crm secure token
     */
    const CRM_SECURE_TOKEN = 'CrmToken';

    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;


    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
    }


    /**
     *
     * Resource:
     * : /api/crm/crm/
     *
     * HttpMethod:
     * : GET
     *
     * @return JSON
     */
    public function getAction()
    {


    }

    /**
     *
     * Resource:
     * : /api/crm/crm/
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON
     */
    public function postAction()
    {

    }

    /**
     *
     * Resource:
     * : /api/crm/crm/
     *
     * HttpMethod:
     * : PUT
     *
     * ## Parameters:
     * id (type integer)
     * : crm id to update
     *
     * @return JSON
     */
    public function putAction()
    {

    }

    /**
     *
     * Resource:
     * : /api/crm/crm/
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (type integer)
     * : crm id to delete
     *
     * @return JSON
     */
    public function deleteAction()
    {

    }

}
