<?php

/**
 * Class Tools_CrmTools
 */
class Tools_CrmTools
{

    /**
     * Get js translation file translation path
     *
     *
     * @param string $pluginName plugin name
     * @param string $translationPrefix translation sub folder
     * @return string
     * @throws Zend_Exception
     */
    public static function getJsTranslationLanguage($pluginName, $translationPrefix = '')
    {
        $miscConfig = Zend_Registry::get('misc');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $translator = Zend_Registry::get('Zend_Translate');
        $locale = $translator->getLocale();
        $translationFolderFilePath = $websiteHelper->getPath(). $miscConfig['pluginsPath'] . $pluginName . DIRECTORY_SEPARATOR . 'web' . DIRECTORY_SEPARATOR . 'js' . DIRECTORY_SEPARATOR . 'nls' . DIRECTORY_SEPARATOR;
        if (!empty($translationPrefix)) {
            $translationFolderFilePath .= $translationPrefix.'_';
        }
        $translationFolderFilePath =  $translationFolderFilePath. $locale . '_ln.js';
        if (!file_exists($translationFolderFilePath)) {
            return 'en_US';
        }

        return $locale;

    }

    /**
     * Get js translation file translation path
     *
     *
     * @param string $pluginName plugin name
     * @return string
     * @throws Zend_Exception
     */
    public static function getVueJsTranslationLanguage($pluginName)
    {
        $miscConfig = Zend_Registry::get('misc');
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $translator = Zend_Registry::get('Zend_Translate');
        $locale = $translator->getLocale();
        return $locale;

    }

}