<?php
/**
 *
 *
 */
class Api_Emailtrigger_Emailtrigger extends Api_Service_Abstract
{

    /**
     * @var array Access Control List
     */
    protected $_accessList = array(
        Tools_Security_Acl::ROLE_SUPERADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Tools_Security_Acl::ROLE_ADMIN => array(
            'allow' => array('get', 'post', 'put', 'delete')
        ),
        Shopping::ROLE_SALESPERSON => array(
            'allow' => array('get', 'post', 'put', 'delete')
        )
    );

    /**
     * User restricted id access
     *
     * @var null
     */
    protected $_restrictedUserId = null;

    /**
     * System translate helper
     *
     * @var null
     */
    protected $_translator = null;

    /**
     * System response helper
     *
     * @var null
     */
    protected $_responseHelper = null;


    /**
     * init
     */
    public function init()
    {
        parent::init();
        $this->_responseHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('response');
        $this->_translator = Zend_Registry::get('Zend_Translate');
        $this->_restrictedUserId = Tools_EmailSequenceTools::getUserIdIfActionNotAllowed(Shopping::ROLE_SALESPERSON);
    }

    /**
     * Get cart status email data
     *
     * Resourse:
     * : /api/emailtrigger/emailtrigger/id/:id
     *
     * HttpMethod:
     * : GET
     *
     * ## Parameters:
     * * id (type integer)
     * : id
     *
     * pairs (type sting)
     * : If given data will be returned as key-value array
     *
     * @return JSON List of groups
     */
    public function getAction()
    {
        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $isGrid = filter_var($this->_request->getParam('isGrid'), FILTER_SANITIZE_NUMBER_INT);
        $limit = filter_var($this->_request->getParam('limit'), FILTER_SANITIZE_NUMBER_INT);
        $offset = filter_var($this->_request->getParam('offset'), FILTER_SANITIZE_NUMBER_INT);
        $sortOrder = filter_var($this->_request->getParam('order'), FILTER_SANITIZE_STRING);
        $filterSequenceName = filter_var($this->_request->getParam('filterSequenceName'), FILTER_SANITIZE_STRING);
        $filterTemplate = filter_var($this->_request->getParam('filterTemplate'), FILTER_SANITIZE_STRING);
        $filterType = $this->_request->getParam('filterType', array());
        $filterCartStatus = $this->_request->getParam('filterCartStatus', array());
        $customPaginate = filter_var($this->_request->getParam('customPaginate'), FILTER_SANITIZE_NUMBER_INT);
        if(!empty($customPaginate)) {
            $limit = $customPaginate;
        }
        $emailTriggerSettingsMapper = Emailsequence_Models_Mapper_EmailTriggerSettingsMapper::getInstance();
        $emailTriggerDbtable = new Emailsequence_Models_Dbtables_EmailTriggerSettingsDbtable();
        if (!empty($isGrid)) {
            $where = null;
            if (!empty($filterType['type'])) {
                $where = '';
                $where .= $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('pcs.type = ?',
                    $filterType['type']);
            }

            if (!empty($filterCartStatus['cartStatus'])) {
                if (!empty($where)) {
                    $where .= ' AND ';
                }
                $where .= $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('pcs.cartStatus = ?',
                    $filterCartStatus['cartStatus']);
            }
            $select = $emailTriggerDbtable->select()->from(
                'plugin_cartstatusemail_settings',
                array('productsIds' => new Zend_Db_Expr("GROUP_CONCAT(productsIds, ',', productsIds)"))
            );

            if ($id) {
                $where = $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
                $select->where($where);
            }
            $allProductIdsData = $emailTriggerSettingsMapper->getDbTable()->getAdapter()->fetchAll($select);
            if (!empty($allProductIdsData)) {
                $result = $this->_getAllProductIds($allProductIdsData);
            }
            if ($id) {
                $where = $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('pcs.id = ?', $id);
                $data = $emailTriggerSettingsMapper->fetchTriggersData($where,null, null, null, true, true);
                if (!empty($result)) {
                    $data['prodData'] = $result;
                }

                $templateInfo = Tools_EmailSequenceTools::getEmailTemplatesInfo($data['emailTemplate']);
                if (!empty($templateInfo)) {
                    $data['templateInfo'] = current($templateInfo);
                } else {
                    $data['templateInfo'] = array();
                }
                $additionalStatuses = Tools_EmailSequenceTools::getAdditionalStatuses();

                $zeroDefaultStatus = array(
                    '0' => $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Select'));

                $defaultStatuses = $zeroDefaultStatus + $additionalStatuses;

                $defaultStatuses += array(
                    Models_Model_CartSession::CART_STATUS_NEW => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_NEW),
                    Tools_Misc::CS_ALIAS_PROCESSING => Tools_EmailSequenceTools::getCartStatusLabel(Tools_Misc::CS_ALIAS_PROCESSING),
                    Tools_Misc::CS_ALIAS_PENDING => Tools_EmailSequenceTools::getCartStatusLabel(Tools_Misc::CS_ALIAS_PENDING),
                    Models_Model_CartSession::CART_STATUS_COMPLETED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_COMPLETED),
                    Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY => Tools_EmailSequenceTools::getCartStatusLabel(Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY),
                    Models_Model_CartSession::CART_STATUS_PENDING => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_PENDING),
                    Models_Model_CartSession::CART_STATUS_PROCESSING => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_PROCESSING),
                    Models_Model_CartSession::CART_STATUS_SHIPPED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_SHIPPED),
                    Models_Model_CartSession::CART_STATUS_DELIVERED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_DELIVERED),
                    Models_Model_CartSession::CART_STATUS_REFUNDED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_REFUNDED)
                );

                $allStatuses = $defaultStatuses;

                $data['cartStatuses'] = $allStatuses;
                $emailTemplates = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(Application_Model_Models_Template::TYPE_MAIL);
                foreach ($emailTemplates as $emailTemplateModel) {
                    $emailTemplatesData[$emailTemplateModel->getName()] = $emailTemplateModel->toArray();
                }
                $data['emailTemplates'] = $emailTemplatesData;
                $data['limitedAccess'] =  $this->_restrictedUserId;

                $shoppingConfigMapper =  Models_Mapper_ShoppingConfig::getInstance();
                $storeTimezone = $shoppingConfigMapper->getConfigParam('timezone');
                $data['storeTimezone'] = $storeTimezone;

                if($data['type'] == Emailsequence::SEQUENCE_TYPE_SMS) {
                    $mmsFiles = $emailTriggerSettingsMapper->getMmsBySequence($id);

                    if(!empty($mmsFiles['mmsFiles'])) {
                        $mmsMediaFiles = explode(',', $mmsFiles['mmsFiles']);
                        $mmsMediaFilesOriginalNames = explode(',', $mmsFiles['mmsFilesOriginalNames']);

                        $mmsMediaFilesData = [];
                        $generalFileSize = 0;
                        $maxUploadedFiles = 0;
                        if(is_array($mmsMediaFiles)) {
                            $maxUploadedFiles = count($mmsMediaFiles);

                            foreach ($mmsMediaFiles as $key => $mFile) {
                                $mmsMediaFilesData[$key]['file'] = $mFile;
                                $mmsMediaFilesData[$key]['fileOriginalName'] = $mmsMediaFilesOriginalNames[$key];

                               $filePath =  Tools_EmailSequenceTools::getFilePath($mFile, $id);

                               if(file_exists($filePath)) {
                                   $fileSize = filesize($filePath);

                                   if(!empty($fileSize)) {
                                       $mmsMediaFilesData[$key]['fileSize'] = $fileSize;
                                       $fileSize = round($fileSize/1024/1024,2);

                                       $generalFileSize += $fileSize;
                                   }
                               }
                            }
                        }

                        $data['mmsFiles'] = $mmsMediaFilesData;
                        $data['generalFileSize'] = $generalFileSize;
                        $data['maxUploadedFiles'] = $maxUploadedFiles;
                        $data['uploadedFiles'] = $mmsMediaFiles;
                        $data['uploadedFilesOriginalNames'] = $mmsMediaFilesOriginalNames;
                    }
                }

            } else {
                if(empty($sortOrder)) {
                    $sortOrder = 'pcs.id DESC';
                }

                if (!empty($filterSequenceName)) {
                    if (!empty($where)) {
                        $where .= ' AND ';
                    }
                    $where .= $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('pet.sequence_settings_id = ?',
                        $filterSequenceName);
                }

                if (!empty($filterTemplate)) {
                    if (!empty($where)) {
                        $where .= ' AND ';
                    }
                    $where .= $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('pcs.emailTemplate = ?',
                        $filterTemplate);
                }


                $data = $emailTriggerSettingsMapper->fetchTriggersData($where, $sortOrder, $limit, $offset);
                if (!empty($data) && !empty($data['data'])) {
                    if (!empty($result)) {
                        foreach ($data['data'] as $key => $cartStatus) {
                            $data['data'][$key]['prodData'] = !empty($result) ? $result : '';
                        }
                    }
                }
                $data['templateNames'] = $emailTriggerSettingsMapper->getUsedTemplates();
                $data['sequenceNames'] = $emailTriggerSettingsMapper->getSequenceNames();
            }
        } else {
            if ($id) {
                $where = $emailTriggerSettingsMapper->getDbTable()->getAdapter()->quoteInto('id=?', $id);
                $data = $emailTriggerSettingsMapper->fetchAll($where);
                if (!empty($data)) {
                    $allProductIdsData[0]['productsIds'] = $data[0]->getProductsIds();
                }
            } else {
                $data = $emailTriggerSettingsMapper->fetchAll();
                $select = $emailTriggerDbtable->select()->from(
                    'plugin_cartstatusemail_settings',
                    array('productsIds' => new Zend_Db_Expr("GROUP_CONCAT(productsIds, ',', productsIds)"))
                );
                $allProductIdsData = $emailTriggerSettingsMapper->getDbTable()->getAdapter()->fetchAll($select);
            }

            if (!empty($allProductIdsData)) {
                $productIdArray = explode(',', $allProductIdsData[0]['productsIds']);
                $productIdArray = array_unique($productIdArray);
                $select = $emailTriggerDbtable->select()
                    ->setIntegrityCheck(false)
                    ->from(array('p' => 'page'), array('productId' => 'product.id', 'pageUrl' => 'p.url'))
                    ->joinleft(array('product' => 'shopping_product'), 'product.page_id = p.id')
                    ->where('product.id IN (?)', $productIdArray);
                $result = $emailTriggerSettingsMapper->getDbTable()->getAdapter()->fetchAssoc($select);
            }

            if (!empty($data)) {
                foreach ($data as $key => $cartStatus) {
                    $cartStatusData[$key]['cartStatus'] = $cartStatus->getCartStatus();
                    $cartStatusData[$key]['period'] = $cartStatus->getPeriod();
                    $cartStatusData[$key]['productsIds'] = $cartStatus->getProductsIds();
                    $cartStatusData[$key]['emailTemplate'] = $cartStatus->getEmailTemplate();
                    $cartStatusData[$key]['emailFrom'] = $cartStatus->getEmailFrom();
                    $cartStatusData[$key]['emailFromLabel'] = $cartStatus->getEmailFromLabel();
                    $cartStatusData[$key]['emailMessage'] = $cartStatus->getEmailMessage();
                    $cartStatusData[$key]['productsRule'] = $cartStatus->getProductsRule();
                    $cartStatusData[$key]['schedulePeriod'] = $cartStatus->getSchedulePeriod();
                    $cartStatusData[$key]['lagType'] = $cartStatus->getLagType();
                    $cartStatusData[$key]['sequenceOnly'] = $cartStatus->getSequenceOnly();
                    $cartStatusData[$key]['triggerName'] = $cartStatus->getTriggerName();
                    $cartStatusData[$key]['schedulePeriodType'] = $cartStatus->getSchedulePeriodType();
                    $cartStatusData[$key]['id'] = $cartStatus->getId();
                    $cartStatusData[$key]['prodData'] = !empty($result) ? $result : '';
                    $cartStatusData[$key]['subject'] = $cartStatus->getSubject();
                    $cartStatusData[$key]['preheader'] = $cartStatus->getPreheader();

                }
            }

            if (!empty($cartStatusData)) {
                return array_values($cartStatusData);
            }
        }

        if (empty($data)) {
            $data = array();
        }

        return $data;

    }

    /**
     * New cart status email config settings
     *
     * Resourse:
     * : /api/cartstatusemail/emailtrigger/
     *
     * HttpMethod:
     * : POST
     *
     * @return JSON New cart status email model
     */
    public function postAction()
    {

        if (!empty($this->_restrictedUserId)) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to create trigger'));
        }

        $data = $this->getRequest()->getPost();
        $cache = Zend_Controller_Action_HelperBroker::getStaticHelper('Cache');

        $secureToken = $this->getRequest()->getParam(Tools_System_Tools::CSRF_SECURE_TOKEN, false);
        $tokenValid = Tools_System_Tools::validateToken($secureToken, Emailsequence::EMAIL_SEQUENCE_SECURE_TOKEN);
        if (!$tokenValid) {
            $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
            $websiteUrl = $websiteHelper->getUrl();
            $this->_responseHelper->fail($this->_translator->translate('Your session has timed-out. Please Log back in '.'<a href="'.$websiteUrl.'go">here</a>'));
        }

        if (!isset($data['periodDays']) && !isset($data['cartStatus'])) {
            $this->_responseHelper->fail();
        }
        if ($data['cartStatus'] == '0') {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Please select the action required'));
        }

        if (!isset($data['productsIds'])) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Please add products'));
        }

        if (empty($data['lagType'])) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Empty lag type'));
        }

        if (empty($data['schedulePeriodType'])) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Empty schedule period type'));
        }

        if (!in_array($data['lagType'], Emailsequence_Models_Models_EmailTriggerSettingsModel::$_lagTypes)) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Wrong lag type'));
        }

        if (!in_array($data['schedulePeriodType'], Emailsequence_Models_Models_EmailTriggerSettingsModel::$_schedulePeriodTypes)) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Wrong period type'));
        }

        if (!empty($data['schedulePeriod']) && is_array($data['schedulePeriod'])) {
            $data['schedulePeriod'] = implode(',' ,$data['schedulePeriod']);
        }

        $data['period'] = filter_var(trim($data['period']), FILTER_SANITIZE_NUMBER_INT);

        if (empty($data['period'])) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Period of time can\'t be empty'));
        }


        if ($data['productsRule'] != 'without' && in_array($data['cartStatus'], Emailsequence::$cartStatuses)) {
            if (empty($data['productsIds'])) {
                $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Please add products'));
            }
        } else {
            $data['productsIds'] = '';
        }

        if (!in_array($data['cartStatus'], Emailsequence::$cartStatuses)) {
            $data['productsRule'] = 'without';
        }

        if($data['type'] == Emailsequence::SEQUENCE_TYPE_SMS) {
            $data['emailMessage'] = strip_tags($data['smsMessage']);
        }

        $cartId = !empty($data['cartId']) ? $data['cartId'] : false;

        if($data['type'] == Emailsequence::SEQUENCE_TYPE_EMAIL) {
            if(!in_array($data['emailFrom'], Tools_EmailSequenceTools::emailFromLexems())) {
                $emailIsValid = Tools_System_Tools::isEmailValid(trim($data['emailFrom']));
                if (!$emailIsValid) {
                    $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Not valid email address'));
                }
            }
        }

        $cartStatusSettingsMapper = Emailsequence_Models_Mapper_EmailTriggerSettingsMapper::getInstance();

        $model = $cartStatusSettingsMapper->find($cartId);
        if (!$model instanceof Emailsequence_Models_Models_EmailTriggerSettingsModel) {
            $model = new Emailsequence_Models_Models_EmailTriggerSettingsModel();
        }

        if (is_array($data)) {
            foreach ($data as $key => $value) {
                if (method_exists($model, 'set' . ucfirst($key))) {
                    $model->{'set' . ucfirst($key)}($value);
                }
            }
        }

        $model = $cartStatusSettingsMapper->save($model);

        if (!empty($data['mediaFiles'])) {
            $mediaFiles = explode(',', $data['mediaFiles']);

            if(!empty($mediaFiles) && is_array($mediaFiles)) {
                $mmsMediaFilesPath = Tools_EmailSequenceTools::getMmsDirectoryPath('temporary-mms-media');
                if(!empty($mmsMediaFilesPath)) {
                    if($model instanceof Emailsequence_Models_Models_EmailTriggerSettingsModel) {
                        $emailsequenceHasMmsMapper = Emailsequence_Models_Mapper_EmailsequenceHasMmsMapper::getInstance();

                        $emailsequenceHasMmsModel = $emailsequenceHasMmsMapper->findMmsBySequenceId($model->getId());

                        if(!$emailsequenceHasMmsModel instanceof Emailsequence_Models_Models_EmailsequenceHasMmsModel) {
                            $emailsequenceHasMmsModel = new Emailsequence_Models_Models_EmailsequenceHasMmsModel();

                            $emailsequenceHasMmsModel->setSequenceId($model->getId());
                        }

                        $emailsequenceHasMmsModel->setMmsFiles($data['mediaFiles']);
                        if(!empty($data['mediaFilesOriginalNames'])) {
                            $emailsequenceHasMmsModel->setMmsFilesOriginalNames($data['mediaFilesOriginalNames']);
                        }

                        $emailsequenceHasMmsMapper->save($emailsequenceHasMmsModel);

                        $savedMmsMediaFilesPath = Tools_EmailSequenceTools::getMmsDirectoryPath($model->getId());

                        $folderContent = [];
                        if(is_dir($savedMmsMediaFilesPath)) {
                            $folderContent = Tools_Filesystem_Tools::scanDirectory($savedMmsMediaFilesPath, false, true);
                        }

                        foreach ($mediaFiles as $mFile) {
                            $savePathToCopy = Tools_EmailSequenceTools::getFilePath($mFile, $model->getId());
                            $savePath = Tools_EmailSequenceTools::getFilePath($mFile, 'temporary-mms-media');


                            if(!empty($savePathToCopy)) {
                                $mmsFilePath = $mmsMediaFilesPath . DIRECTORY_SEPARATOR . $mFile;
                                if (file_exists($mmsFilePath)) {
                                    Tools_Filesystem_Tools::copy($savePath, $savePathToCopy);

                                    Tools_Filesystem_Tools::deleteFile($mmsFilePath);
                                }
                            }

                            if(in_array($mFile, $folderContent)) {
                                $existedFileKey = array_search($mFile, $folderContent);
                                unset($folderContent[$existedFileKey]);
                            }
                        }

                        if(!empty($folderContent)) {
                            foreach ($folderContent as $file) {
                                $mmsUnusedFilePath = $savedMmsMediaFilesPath . DIRECTORY_SEPARATOR . $file;

                                if (file_exists($mmsUnusedFilePath)) {
                                    Tools_Filesystem_Tools::deleteFile($mmsUnusedFilePath);
                                }
                            }
                        }
                    }
                }
            }
        }

        $cache->clean('cartstatus_configdata', 'cart_status');
        return $model->toArray();
    }

    public function putAction()
    {

    }

    /**
     * Delete cart status email
     *
     * Resourse:
     * : /api/emailtrigger/emailtrigger/
     *
     * HttpMethod:
     * : DELETE
     *
     * ## Parameters:
     * id (type integer)
     * : cart id to delete
     *
     * @return JSON Result of removing cart status email
     */
    public function deleteAction()
    {
        if (!empty($this->_restrictedUserId)) {
            $this->_responseHelper->fail($this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'You don\'t have permission to delete trigger'));
        }

        $id = filter_var($this->_request->getParam('id'), FILTER_SANITIZE_NUMBER_INT);
        $cache = Zend_Controller_Action_HelperBroker::getStaticHelper('Cache');

        if (!$id) {
            $this->_responseHelper->fail();
        }
        Emailsequence_Models_Mapper_EmailsequenceQueueMapper::getInstance()->deleteQueueByCartStatusId($id, array('0'));

        Tools_EmailSequenceTools::deleteMmsMediaFiles($id);

        $cache->clean('cartstatus_configdata', 'cart_status');
        return Emailsequence_Models_Mapper_EmailTriggerSettingsMapper::getInstance()->deleteCartStatus($id);
    }


    private function _getAllProductIds($allProductIdsData)
    {
        $emailTriggerSettingsMapper = Emailsequence_Models_Mapper_EmailTriggerSettingsMapper::getInstance();
        $emailTriggerDbtable = new Emailsequence_Models_Dbtables_EmailTriggerSettingsDbtable();
        $productIdArray = explode(',', $allProductIdsData[0]['productsIds']);
        $productIdArray = array_filter(array_unique($productIdArray));
        if (!empty($productIdArray)) {
            $select = $emailTriggerDbtable->select()
                ->setIntegrityCheck(false)
                ->from(array('p' => 'page'), array('productId' => 'product.id', 'pageUrl' => 'p.url'))
                ->joinleft(array('product' => 'shopping_product'), 'product.page_id = p.id')
                ->where('product.id IN (?)', $productIdArray);

            return $emailTriggerSettingsMapper->getDbTable()->getAdapter()->fetchAssoc($select);
        }

        return false;

    }
}
