<?php

class Emailsequence_Models_Mapper_EmailsequenceHasMmsMapper extends Application_Model_Mappers_Abstract
{

    protected $_dbTable = 'Emailsequence_Models_Dbtables_EmailsequenceHasMmsDbTable';

    protected $_model = 'Emailsequence_Models_Models_EmailsequenceHasMmsModel';

    public function save($model)
    {
        if (!$model instanceof $this->_model) {
            throw new Exceptions_SeotoasterException('Given parameter should be ' . $this->_model . ' instance');
        }

        $data = array(
            'sequence_id'              => $model->getSequenceId(),
            'mms_files'                => $model->getMmsFiles(),
            'mms_files_original_names' => $model->getMmsFilesOriginalNames(),
        );

        $id = $model->getId();
        if (!empty($id)) {
            $where = $this->getDbTable()->getAdapter()->quoteInto('id = ?', $id);
            $this->getDbTable()->update($data, $where);
        } else {
            $id = $this->getDbTable()->insert($data);
            $model->setId($id);
        }

        return $model;
    }

    public function findMmsBySequenceId($sequenceId)
    {
        $where = $this->getDbTable()->getAdapter()->quoteInto('sequence_id = ?', $sequenceId);
        return $this->_findWhere($where);
    }

}

