<?php

/**
 * Class Tools_EmailSequenceTools
 */
class Tools_EmailSequenceTools
{

    public static $_acceptedFileTypesMms = array(
        'jpg,jpeg,png,bmp,gif,mp3,avi,mpeg,mp4,webm,mov'
    );

    public static $_acceptedFilesMimeTypesMms = array(
        'image/png',
        'image/jpeg',
        'image/jpg',
        'image/gif',
        'image/bmp',
        'audio/mpeg3',
        'audio/mpeg',
        'video/avi',
        'video/x-msvideo',
        'video/mp4',
        'video/mpeg',
        'video/quicktime'
    );

    /**
     * Get additional statuses
     *
     * @return array
     * @throws Zend_Reflection_Exception
     */
    public static function getAdditionalStatuses()
    {
        $additionalStatuses = array();
        $availablePlugins = Tools_Plugins_Tools::getPluginsByTags(array('cartstatusemail'));
        if (!empty($availablePlugins)) {
            foreach ($availablePlugins as $additionalStatusPlugin) {
                $pluginClassName = $additionalStatusPlugin->getName();
                $pluginClass = new Zend_Reflection_Class($pluginClassName);
                $cartStatusEmailStatusesMethod = 'cartStatusEmailStatuses';
                $additionalStatusesActionExists = $pluginClass->hasMethod($cartStatusEmailStatusesMethod);
                if (!$additionalStatusesActionExists) {
                    continue;
                }
                $verifyAction = $pluginClass->getMethod($cartStatusEmailStatusesMethod);
                if (!$verifyAction->isStatic()) {
                    continue;
                }
                $additionalStatuses = $pluginClassName::$cartStatusEmailStatusesMethod();
            }
        }

        return $additionalStatuses;
    }

    /**
     * @param $timezoneFrom
     * @param $timeZoneToShift
     * @return float|int
     */
    public static function getTimezoneShift($timezoneFrom, $timeZoneToShift)
    {
        $dateTimeZoneServer = new DateTimeZone($timezoneFrom);
        $dateTimeZoneStore = new DateTimeZone($timeZoneToShift);
        $dateTimeServer = new DateTime("now", $dateTimeZoneServer);

        $timeOffsetInHours = $dateTimeZoneStore->getOffset($dateTimeServer) / 3600;

        return $timeOffsetInHours;
    }

    /**
     * @param string $templateName template name
     * @return mixed
     */
    public static function getEmailTemplatesInfo($templateName = '')
    {
        $templateMapper = Application_Model_Mappers_TemplateMapper::getInstance();
        $where = $templateMapper->getDbtable()->getAdapter()->quoteInto('t.type = ?', Application_Model_Models_Template::TYPE_MAIL);
        if (!empty($templateName)) {
            $where .= ' AND '.$templateMapper->getDbtable()->getAdapter()->quoteInto('t.name = ?', $templateName);
        }
        $select = $templateMapper->getDbtable()->getAdapter()->select()
            ->from(array('t' => 'template'), array('t.name', 't.content', 't.type', 'p.url'))
            ->joinLeft(array('p' => 'page'), 't.name=p.template_id', array());

        $select->where($where);

        return $templateMapper->getDbtable()->getAdapter()->fetchAssoc($select);
    }

    /**
     * Glue and normalize phone
     *
     * @param string $userMobileCode
     * @param string $userMobile
     * @param string $userPhoneCode
     * @param string $userPhone
     * @return bool|string
     */
    public static function glueUserPhone($userMobileCode = '', $userMobile = '', $userPhoneCode = '', $userPhone = '') {
        $mobilePhoneUser = '';

        if(!empty($userMobileCode) && !empty($userMobile)) {
            $mobilePhoneUser = $userMobileCode. $userMobile;
            $mobilePhoneUser = Apps_Tools_Twilio::normalizePhoneNumberToE164($mobilePhoneUser);
        } else if(!empty($userPhoneCode) && !empty($userPhone)) {
            $mobilePhoneUser = $userPhoneCode. $userPhone;
            $mobilePhoneUser = Apps_Tools_Twilio::normalizePhoneNumberToE164($mobilePhoneUser);
        }

        return $mobilePhoneUser;
    }

    /**
     * Parse widgets lexems
     *
     * @param $smsMessage
     * @param $leadData
     * @param $websiteUrl
     * @return string
     */
    public static function addDictionarySmsFields($smsMessage, $leadData, $websiteUrl, $isDemo = false) {
        $leadFirstName = '';
        $leadLastName = '';
        $leadMiddleName = '';
        $leadPosition = '';
        $leadPrefix = '';
        $leadSuffix = '';
        $leadFullMobilePhone = '';
        $leadFullDesktopPhone = '';
        $leadOrganizationName = '';
        $leadOrganizationWebsite = '';

        $leadOwnerFullName = '';
        $leadOwnerEmail = '';
        $leadOwnerMobileCountryCode = '';
        $leadOwnerMobilePhone = '';
        $leadOwnerDesktopCountryCode = '';
        $leadOwnerDesktopPhone = '';
        $leadOwnerFullDesktopPhone = '';
        $leadOwnerFullMobilePhone = '';
        $leadOwnerSignature = '';
        $leadOwnerPersonalcalendarurl = '';
        $leadOwneravatarlink = '';

        if($isDemo) {
            $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
            $websiteUrl = $websiteHelper->getUrl();

            $leadFirstName                = Tools_LeadTools::$_demoData['firstname'];
            $leadLastName                 = Tools_LeadTools::$_demoData['lastname'];
            $leadSource                   = Tools_LeadTools::$_demoData['source'];
            $leadMiddleName               = Tools_LeadTools::$_demoData['middlename'];
            $leadPosition                 = Tools_LeadTools::$_demoData['position'];
            $leadPrefix                   = Tools_LeadTools::$_demoData['prefix'];
            $leadSuffix                   = Tools_LeadTools::$_demoData['prefix'];
            $leadFullMobilePhone          = Tools_LeadTools::$_demoData['fullmobilephone'];
            $leadFullDesktopPhone         = Tools_LeadTools::$_demoData['fulldesktopphone'];
            $leadOrganizationName         = Tools_LeadTools::$_demoData['organizationname'];
            $leadOrganizationWebsite      = $websiteUrl;

            $leadOwnerFullName            = Tools_LeadTools::$_demoData['leadownerfullname'];
            $leadOwnerEmail               = Tools_LeadTools::$_demoData['leadowneremail'];
            $leadOwnerMobileCountryCode   = Tools_LeadTools::$_demoData['leadownermobilecountrycode'];
            $leadOwnerMobilePhone         = Tools_LeadTools::$_demoData['leadownermobilephone'];
            $leadOwnerDesktopCountryCode  = Tools_LeadTools::$_demoData['leadownerdesktopcountrycode'];
            $leadOwnerDesktopPhone        = Tools_LeadTools::$_demoData['leadownerdesktopphone'];
            $leadOwnerFullDesktopPhone    = Tools_LeadTools::$_demoData['leadownerfulldesktopphone'];
            $leadOwnerFullMobilePhone     = Tools_LeadTools::$_demoData['leadownerfullmobilephone'];
            $leadOwnerSignature           = Tools_LeadTools::$_demoData['leadownersignature'];
            $leadOwnerPersonalcalendarurl = Tools_LeadTools::$_demoData['personalcalendarurl'];
            $leadOwneravatarlink          = Tools_LeadTools::$_demoData['avatarlink'];

            $loggedUser = Zend_Controller_Action_HelperBroker::getStaticHelper('session')->getCurrentUser();
            if($loggedUser instanceof Application_Model_Models_User) {
                $userSignature = $loggedUser->getSignature();
                if(!empty($userSignature)) {
                    $leadOwnerSignature = $userSignature;
                }
            }
        } else {
            $userMapper = Application_Model_Mappers_UserMapper::getInstance();
            $leadOwnerId = $leadData->getOwnerId();

            $leadFirstName        = $leadData->getLeadFirstName();
            $leadLastName         = $leadData->getLeadLastName();
            $leadSource           = $leadData->getLeadSource();
            $leadMiddleName       = $leadData->getMiddleName();
            $leadPosition         = $leadData->getLeadPosition();
            $leadPrefix           = $leadData->getPrefix();
            $leadSuffix           = $leadData->getPrefix();
            $leadFullMobilePhone  = $leadData->getLeadMobileCountryCodeValue() . $leadData->getLeadMobile();
            $leadFullDesktopPhone = $leadData->getLeadPhoneCountryCodeValue() . $leadData->getLeadPhone();

            if(!empty($leadOwnerId)) {
                $ownerModel = $userMapper->find($leadOwnerId);

                if ($ownerModel instanceof Application_Model_Models_User) {
                    $leadOwnerFullname           = $ownerModel->getFullName();
                    $leadOwnerEmail              = $ownerModel->getEmail();
                    $leadOwnerMobileCountryCode  = $ownerModel->getMobileCountryCode();
                    $leadOwnerMobilePhone        = $ownerModel->getMobilePhone();
                    $leadOwnerDesktopCountryCode = $ownerModel->getDesktopCountryCode();
                    $leadOwnerDesktopPhone       = $ownerModel->getDesktopPhone();
                    $leadOwnerFullDesktopPhone   = $ownerModel->getDesktopCountryCodeValue() . $ownerModel->getDesktopPhone();
                    $leadOwnerFullMobilePhone    = $ownerModel->getMobileCountryCodeValue() . $ownerModel->getMobilePhone();
                    $leadOwnerPersonalcalendarurl = $ownerModel->getPersonalCalendarUrl();
                    $leadOwneravatarlink = $ownerModel->getPersonalCalendarUrl();
                }
            }
            $organizationId = $leadData->getOrganizationId();
            if(!empty($organizationId)) {
                $leadOrganizationMapper = Leads_Mapper_LeadsOrganizationMapper::getInstance();
                $leadOrganization = $leadOrganizationMapper->find($organizationId);

                if($leadOrganization instanceof Leads_Model_LeadsOrganizationModel) {
                    $leadOrganizationName = $leadOrganization->getOrganizationName();
                    $leadOrganizationWebsite = $leadOrganization->getOrganizationWebsite();
                }
            }
        }

        $dictionary = array(
            '$website:url'                   => $websiteUrl,
            '$lead:firstname'                => $leadFirstName,
            '$lead:lastname'                 => $leadLastName,
            '$lead:source'                   => $leadSource,
            '$lead:middlename'               => $leadMiddleName,
            '$lead:position'                 => $leadPosition,
            '$lead:prefix'                   => $leadPrefix,
            '$lead:suffix'                   => $leadSuffix,
            '$lead:fullmobilephone'          => $leadFullMobilePhone,
            '$lead:fulldesktopphone'         => $leadFullDesktopPhone,
            '$lead:organizationname'         => $leadOrganizationName,
            '$lead:organizationwebsite'      => $leadOrganizationWebsite,
            '$lead:organizationlogo'         => '',
            '$lead:organizationlogo:src'     => '',
            '$leadowner:fullname'            => $leadOwnerFullName,
            '$leadowner:email'               => $leadOwnerEmail,
            '$leadowner:mobilecountrycode'   => $leadOwnerMobileCountryCode,
            '$leadowner:mobilephone'         => $leadOwnerMobilePhone,
            '$leadowner:desktopcountrycode'  => $leadOwnerDesktopCountryCode,
            '$leadowner:desktopphone'        => $leadOwnerDesktopPhone,
            '$leadowner:fulldesktopphone'    => $leadOwnerFullDesktopPhone,
            '$leadowner:fullmobilephone'     => $leadOwnerFullMobilePhone,
            '$leadowner:signature'           => $leadOwnerSignature,
            '$leadowner:personalcalendarurl' => $leadOwnerPersonalcalendarurl,
            '$leadowner:avatarlink'          => '',
            '$leadowner:avatarlink:src'      => $leadOwneravatarlink,
        );

        $entityParser = new Tools_Content_EntityParser();

        $entityParser->addToDictionary($dictionary);

        return $entityParser->parse(strip_tags($smsMessage));
    }

    /**
     * Check exist plugin and status
     *
     * @param string $pluginName plugin name
     * @return bool
     */
    public static function verifyPluginEnabled($pluginName)
    {
        $pluginExistsAndEnabled = false;
        $pluginMapper = Application_Model_Mappers_PluginMapper::getInstance()->findByName($pluginName);
        if ($pluginMapper instanceof Application_Model_Models_Plugin) {
            $pluginStatus = $pluginMapper->getStatus();
            if ($pluginStatus === 'enabled') {
                $pluginExistsAndEnabled = true;
            }
        }

        return $pluginExistsAndEnabled;
    }

    /**
     * Returned Labeled cart status
     *
     * @param $status
     * @return mixed
     * @throws Zend_Exception
     */
    public static function getCartStatusLabel($status)
    {
        $translator = Zend_Registry::get('Zend_Translate');

        $cartStatuses = array(
           Models_Model_CartSession::CART_STATUS_COMPLETED  => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_COMPLETED) . ' / ' . $translator->translate(Emailsequence::TRANSLATION_PREFIX.'Closed quote'),
           Tools_Misc::CS_ALIAS_PENDING                     => $translator->translate('cs_' . Tools_Misc::CS_ALIAS_PENDING),
           Tools_Misc::CS_ALIAS_PROCESSING                  => $translator->translate('cs_' . Tools_Misc::CS_ALIAS_PROCESSING),
           Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY            => $translator->translate('cs_' . Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY),
           Models_Model_CartSession::CART_STATUS_NEW        => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_NEW),
           Models_Model_CartSession::CART_STATUS_PENDING    => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_PENDING),
           Models_Model_CartSession::CART_STATUS_PROCESSING => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_PROCESSING),
           Models_Model_CartSession::CART_STATUS_SHIPPED    => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_SHIPPED),
           Models_Model_CartSession::CART_STATUS_DELIVERED  => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_DELIVERED),
           Models_Model_CartSession::CART_STATUS_REFUNDED   => $translator->translate('cs_' . Models_Model_CartSession::CART_STATUS_REFUNDED)
        );

        if(array_key_exists($status, $cartStatuses)) {
            return $cartStatuses[$status];
        } else {
            return $status;
        }
    }

    /**
     *
     * Get current logged id if action partially allowed
     * for example if full access allowed only for the admin and su-admin
     * and not allowed for the sales person
     *
     * @param string $roleId role id
     *
     * @return int
     */
    public static function getUserIdIfActionNotAllowed($roleId)
    {
        $leadsEnabled = Tools_Plugins_Tools::findPluginByName('leads');
        if ($leadsEnabled->getStatus() == Application_Model_Models_Plugin::ENABLED) {
           return Tools_LeadTools::getUserIdIfActionNotAllowed($roleId);
        }

        return 0;
    }

    /**
     * Special lexems for "email from" section
     *
     * @return string[]
     */
    public static function emailFromLexems()
    {
       return array(
            '{$leadowner:email}'
        );
    }

    public static function getSequencesByTrigger($triggerId)
    {
        $emailSequenceMapper = Emailsequence_Models_Mapper_EmailTriggerSettingsMapper::getInstance();
        $where = $emailSequenceMapper->getDbTable()->getAdapter()->quoteInto('pet.trigger_id = ?', $triggerId);
        $select = $emailSequenceMapper->getDbTable()->getAdapter()->select()
            ->from(array('pet' => 'plugin_emailsequence_triggers'), array(
                'pes.id',
                'pes.sequence_name'
            ))
            ->join(array('pes' => 'plugin_emailsequence_settings'), 'pes.id=pet.sequence_settings_id', array());

        $select->where($where);

        return $emailSequenceMapper->getDbTable()->getAdapter()->fetchPairs($select);

    }

    /**
     * Get path to file
     *
     * @param string $fileStoredName file stored name
     * @return string
     */
    public static function getFilePath($fileStoredName, $dirName)
    {
        $mmsPath = self::getMmsDirectoryPath($dirName);

        if(!empty($mmsPath)) {
            if(!is_dir($mmsPath)) {
                try {
                    Tools_Filesystem_Tools::mkDir($mmsPath);
                } catch (Exceptions_SeotoasterException $e) {
                    error_log($e->getMessage());
                }
            }

            return $mmsPath . DIRECTORY_SEPARATOR . $fileStoredName;
        }

        return '';
    }

    /**
     * Get MMS directory path
     *
     * @param $dirName
     * @return string
     */
    public static function getMmsDirectoryPath($dirName, $getUrl = false)
    {
        $websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');

        if(!empty($dirName)) {
            if($getUrl) {
                $pathUrl = $websiteHelper->getUrl();
            } else {
                $pathUrl = $websiteHelper->getPath();
            }

            $mmsPath = $pathUrl . 'plugins' . DIRECTORY_SEPARATOR . 'emailsequence' .
                DIRECTORY_SEPARATOR . 'web' . DIRECTORY_SEPARATOR . 'files'
                . DIRECTORY_SEPARATOR . 'mms-media-files' . DIRECTORY_SEPARATOR . $dirName;

            return $mmsPath;
        }

        return '';
    }

    /**
     * Delete MMS media files by sequenceId
     *
     * @param $sequenceId
     * @return void
     * @throws Exceptions_SeotoasterException
     */
    public static function deleteMmsMediaFiles($sequenceId)
    {
        $leadMmsMediaFilesPath = self::getMmsDirectoryPath($sequenceId);

        if(!empty($leadMmsMediaFilesPath) && is_dir($leadMmsMediaFilesPath)) {
            $folderContent = Tools_Filesystem_Tools::scanDirectory($leadMmsMediaFilesPath, false, true);
            if(!empty($folderContent)) {
                try {
                    Tools_Filesystem_Tools::deleteDir($leadMmsMediaFilesPath);
                } catch (Exception $e) {
                    //$e->getMessage();
                }
            }
        }
    }
}
