<?php

/**
 * Class Widgets_Emailsequence_Emailsequence
 */
class Widgets_Emailsequence_Emailsequence extends Widgets_Abstract
{

    /**
     * Website helper
     *
     * @var null
     */
    protected $_websiteHelper = null;

    /**
     * @var bool
     */
    protected $_cacheable = false;

    /**
     * Session helper
     *
     * @var bool
     */
    protected $_sessionHelper = false;

    /**
     * leads data model
     *
     * @var bool
     */
    protected $_leadDataModel = false;

    /**
     * @var null
     */
    protected $_layout = null;

    /**
     * @throws Zend_Exception
     */
    protected function _init()
    {
        parent::_init();
        $this->_view = new Zend_View(array(
            'scriptPath' => __DIR__ . '/views/'
        ));


        $this->_layout = new Zend_Layout();
        $this->_layout->setLayoutPath(Zend_Layout::getMvcInstance()->getLayoutPath());

        $this->_websiteHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('website');
        $this->_view->websiteUrl = $this->_websiteHelper->getUrl();
        $this->_websiteUrl = $this->_websiteHelper->getUrl();
        $this->_translator = Zend_Registry::get('Zend_Translate');

        $this->_view->setHelperPath(APPLICATION_PATH . '/views/helpers/');
        $this->_view->addHelperPath('ZendX/JQuery/View/Helper/', 'ZendX_JQuery_View_Helper');
        $this->_view->addScriptPath($this->_websiteHelper->getPath() . 'seotoaster_core/application/views/scripts/');
        // init helpers
        $this->_configHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('config');
        $this->_sessionHelper = Zend_Controller_Action_HelperBroker::getStaticHelper('session');
    }

    /**
     * @return mixed
     */
    protected function _load()
    {
        if (empty($this->_options[0])) {
            return $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Option not specified');
        }

        $methodName = '_render' . ucfirst($this->_options[0]);
        if (method_exists($this, $methodName)) {
            return $this->$methodName();

        }

        return $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Method doesn\'t exists');
    }

    /**
     * Dashboard email sequence tab widget
     *
     * @return string
     * @throws Zend_Reflection_Exception
     */
    protected function _renderGrid()
    {

        if (Tools_Security_Acl::isAllowed(Shopping::RESOURCE_STORE_MANAGEMENT)) {
            $this->_view->mailTemplates = Application_Model_Mappers_TemplateMapper::getInstance()->findByType(Application_Model_Models_Template::TYPE_MAIL);
            $additionalStatuses = Tools_EmailSequenceTools::getAdditionalStatuses();

            $zeroDefaultStatus = array(
                '0' => $this->_translator->translate(Emailsequence::TRANSLATION_PREFIX.'Select'));

            $defaultStatuses = $zeroDefaultStatus + $additionalStatuses;

            $defaultStatuses += array(
                Models_Model_CartSession::CART_STATUS_NEW => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_NEW),
                Tools_Misc::CS_ALIAS_PROCESSING => Tools_EmailSequenceTools::getCartStatusLabel(Tools_Misc::CS_ALIAS_PROCESSING),
                Tools_Misc::CS_ALIAS_PENDING => Tools_EmailSequenceTools::getCartStatusLabel(Tools_Misc::CS_ALIAS_PENDING),
                Models_Model_CartSession::CART_STATUS_COMPLETED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_COMPLETED),
                Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY => Tools_EmailSequenceTools::getCartStatusLabel(Tools_Misc::CS_ALIAS_LOST_OPPORTUNITY),
                Models_Model_CartSession::CART_STATUS_PENDING => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_PENDING),
                Models_Model_CartSession::CART_STATUS_PROCESSING => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_PROCESSING),
                Models_Model_CartSession::CART_STATUS_SHIPPED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_SHIPPED),
                Models_Model_CartSession::CART_STATUS_DELIVERED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_DELIVERED),
                Models_Model_CartSession::CART_STATUS_REFUNDED => Tools_EmailSequenceTools::getCartStatusLabel(Models_Model_CartSession::CART_STATUS_REFUNDED)
            );

            $allStatuses = $defaultStatuses;
            $this->_view->cartStatusStatuses = $allStatuses;
            $this->_view->websiteConfig = Zend_Registry::get('website');
            $this->_view->restrictedUserId = Tools_LeadTools::getUserIdIfActionNotAllowed(Shopping::ROLE_SALESPERSON);

            $shoppingConfigMapper =  Models_Mapper_ShoppingConfig::getInstance();
            $storeTimezone = $shoppingConfigMapper->getConfigParam('timezone');
            $this->_view->storeTimezone = $storeTimezone;
            $operationalHoursStoreConfig = $shoppingConfigMapper->getConfigParam('operationalHours');
            if (empty($operationalHoursStoreConfig)) {
                $operationalHoursStoreConfig = array();
            } else {
                $operationalHoursStoreConfig = unserialize($operationalHoursStoreConfig);
                $operationsEmpty = true;
                foreach ($operationalHoursStoreConfig as $operationalHoursStore) {
                    if (!empty($operationalHoursStore['from']) || !empty($operationalHoursStore['to'])) {
                        $operationsEmpty = false;
                    }
                }

                if ($operationsEmpty === true) {
                    $operationalHoursStoreConfig = array();
                }
            }

            $this->_view->operationalHoursStoreConfig = $operationalHoursStoreConfig;

            return $this->_view->render('sequence-grid.phtml');
        }

        return '';

    }

}
