-- version: 2.2.0

-- 07/02/2017
-- version: 2.2.1
ALTER TABLE `plugin_leads_registration_log` ADD COLUMN `user_id` INT(10) UNSIGNED DEFAULT NULL;

-- 09/02/2017
-- version: 2.2.2
CREATE TABLE IF NOT EXISTS `plugin_leads_has_email_sequence` (
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `sequence_id` INT (10) UNSIGNED NOT NULL,
  `sequence_date` TIMESTAMP,
  PRIMARY KEY (`lead_id`, `sequence_id`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_email_sequence_status` (
  `lead_id` INT(10) UNSIGNED NOT NULL,
  `sequence_id` INT (10) UNSIGNED NOT NULL,
  `cart_status_settings_id` INT(10) UNSIGNED NOT NULL,
  `sequence_applied_date` TIMESTAMP,
  PRIMARY KEY (`sequence_id`, `cart_status_settings_id`, `lead_id`),
  FOREIGN KEY (`lead_id`) REFERENCES `plugin_leads_data` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_has_email_sequence` ADD COLUMN  `sequence_date` TIMESTAMP;

-- 15/03/2017
-- version: 2.2.3
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `email_bcc` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL;

-- 02/03/2017
-- version: 2.2.4
ALTER TABLE `plugin_leads_opportunity` ADD COLUMN  `created_at` TIMESTAMP NULL;

-- 22/03/2017
-- version: 2.2.5
ALTER TABLE `plugin_leads_type` ADD COLUMN `default` ENUM('0', '1') DEFAULT '0';

-- 03/04/2017
-- version: 2.2.6
ALTER TABLE `plugin_leads_opportunity` ADD COLUMN  `change_stage_date` TIMESTAMP NULL;

-- 11/04/2017
-- version: 2.2.7
ALTER TABLE `plugin_leads_tasks` ADD COLUMN  `creation_type` ENUM('local','import','user') DEFAULT 'local';
ALTER TABLE `plugin_leads_tasks` ADD COLUMN  `task_external_id` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL;

-- 19/04/2017
-- version: 2.2.8
ALTER TABLE `plugin_leads_email_log` MODIFY COLUMN `email_status` ENUM('sent', 'opened', 'openattachment');
ALTER TABLE `plugin_leads_email_log` ADD COLUMN `attachment_id` INT(10) UNSIGNED DEFAULT NULL;

CREATE TABLE IF NOT EXISTS `plugin_leads_email_link_attachment_log` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `file_name` VARCHAR (255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `file_folder_name` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email_log_sent_hash` CHAR(64) NOT NULL,
  `file_hash` CHAR(64) NOT NULL,
  PRIMARY KEY(`id`),
  INDEX(`email_log_sent_hash`),
  INDEX(`file_hash`),
  UNIQUE(`email_log_sent_hash`, `file_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 21/04/2017
-- version: 2.2.9
ALTER TABLE `plugin_leads_ip_user_profile_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_registration_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_downloader_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_purchase_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_call_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_tasks_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_meeting_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_email_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_form_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_quote_log` ADD INDEX `action_log_id` (`action_log_id`);
ALTER TABLE `plugin_leads_action_log` ADD INDEX `lead_id` (`lead_id`);
ALTER TABLE `plugin_leads_action_log` ADD INDEX `created_at_lead_id` (`created_at`,`lead_id`);
ALTER TABLE `plugin_leads_action_log` ADD INDEX `lead_id_created_at` (`lead_id`,`created_at`);

-- 01/04/2017
-- version: 2.3.0
ALTER TABLE `plugin_leads_lead_custom_params_data` ADD COLUMN `params_option_id` int(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_lead_custom_params_config` DROP `params_data`;

CREATE TABLE IF NOT EXISTS `plugin_leads_lead_custom_params_options_data` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `custom_param_id` INT UNSIGNED NOT NULL,
  `option_value` VARCHAR(255) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_plugin_leads_lead_custom_params_options_data_plugin_lead_idx` (`custom_param_id` ASC),
  CONSTRAINT `fk_plugin_leads_lead_custom_params_options_data_plugin_leads_1`
    FOREIGN KEY (`custom_param_id`) REFERENCES `plugin_leads_lead_custom_params_config` (`id`)
    ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci;

ALTER TABLE `plugin_leads_organization_custom_params_data` ADD COLUMN `params_option_id` int(10) UNSIGNED DEFAULT NULL;
ALTER TABLE `plugin_leads_organization_custom_params_config` DROP `params_data`;

CREATE TABLE IF NOT EXISTS `plugin_leads_organization_custom_params_options_data` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `custom_param_id` INT UNSIGNED NOT NULL,
  `option_value` VARCHAR(255) NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_plugin_leads_organ_custom_params_options_data_plugin_lead_idx` (`custom_param_id` ASC),
  CONSTRAINT `fk_plugin_leads_organ_custom_params_options_data_plugin_leads_1`
    FOREIGN KEY (`custom_param_id`) REFERENCES `plugin_leads_organization_custom_params_config` (`id`)
    ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE = utf8_unicode_ci;

-- 24/04/2017
-- version: 2.3.1
INSERT INTO `plugin_crm_checklist` (`checklist_status`, `closed_by`, `checklist_name`) VALUES
('0',	NULL,	'leads_import'),
('0',	NULL,	'add_products_screen'),
('0',	NULL,	'paypal_account_screen'),
('0',	NULL,	'dashboard_leads_tab'),
('0',	NULL,	'create_groups'),
('0',	NULL,	'manage_users_screen'),
('0',	NULL,	'mojo_registartion');

-- 25/04/2017
-- version: 2.3.2
INSERT INTO `plugin_leads_stage` (`stage_name`) VALUES
('Subscriber'),
('Lead'),
('Marketing qualified lead'),
('Sales qualified lead'),
('Opportunity'),
('Customer'),
('Evangelist'),
('Other');

INSERT INTO `plugin_leads_social_services_config` (`service_name`, `service_label`, `image_name`) VALUES
('instagram',	'instagram',	'icon-instagram.png'),
('gplus', 'google +', 'google-plus.png'),
('pinterest', 'pinterest', 'pinterest.png');

INSERT INTO `plugin_leads_industry` (`type`, `label`) VALUES
('Accommodations', 'Accommodations'),
('Accounting', 'Accounting'),
('Advertising', 'Advertising'),
('Aerospace', 'Aerospace'),
('Agriculture_Agribusiness', 'Agriculture & Agribusiness'),
('Air_Transportation', 'Air Transportation'),
('Apparel_Accessories', 'Apparel & Accessories'),
('Auto', 'Auto'),
('Banking', 'Banking'),
('Beauty_Cosmetics', 'Beauty & Cosmetics'),
('Biotechnology', 'Biotechnology'),
('Chemical', 'Chemical'),
('Communications', 'Communications'),
('Computer', 'Computer'),
('Construction', 'Construction'),
('Consulting', 'Consulting'),
('Consumer Products', 'Consumer Products'),
('Education', 'Education'),
('Electronics', 'Electronics'),
('Employment', 'Employment'),
('Energy', 'Energy'),
('Entertainment_Recreation', 'Entertainment & Recreation'),
('Fashion', 'Fashion'),
('Financial_Services', 'Financial Services'),
('Fine_Arts', 'Fine Arts'),
('Food_Beverage', 'Food & Beverage'),
('Health', 'Health'),
('Information', 'Information'),
('Information_Technology', 'Information Technology'),
('Insurance', 'Insurance'),
('Journalism_News', 'Journalism & News'),
('Legal_Services', 'Legal Services'),
('Manufacturing', 'Manufacturing'),
('Media_Broadcasting', 'Media & Broadcasting'),
('Medical_Devices_Supplies', 'Medical Devices & Supplies'),
('Music', 'Music'),
('Pharmaceutical', 'Pharmaceutical'),
('Public_Administration', 'Public Administration'),
('Publishing', 'Publishing'),
('Real_Estate', 'Real Estate'),
('Retail', 'Retail'),
('Telecommunications', 'Telecommunications'),
('Tourism', 'Tourism'),
('Transportation', 'Transportation'),
('Web_Services', 'Web Services');

ALTER TABLE `plugin_lead_organization` MODIFY COLUMN `external_id` VARCHAR (255) COLLATE utf8_bin DEFAULT NULL;
ALTER TABLE `plugin_leads_data` MODIFY COLUMN `external_id` VARCHAR (255) COLLATE utf8_bin DEFAULT NULL;
ALTER TABLE `plugin_leads_tasks` MODIFY COLUMN `task_external_id` VARCHAR (255) COLLATE utf8_bin DEFAULT NULL;

-- 28/04/2017
-- version: 2.3.3
INSERT INTO `email_triggers` (`enabled`, `trigger_name`, `observer`) VALUES
('1', 'leads_licenselimit', 'Tools_LeadsMailWatchdog');

INSERT INTO `email_triggers_actions` (`service`, `trigger`, `template`, `recipient`, `message`, `from`, `subject`) VALUES
('email',	'leads_licenselimit',	'email',	'admin',	'Congratulations! You’re getting noticed and folks are interested in what you’re doing.\r\n\r\nWe hope that you’re enjoying using our CRM. Unfortunately, you’ve reached your software subscription limit.\r\nAs a result, no additional named lead contacts can be created. As it stands, you won’t be able to know what web pages your prospective clients have looked at, which documents they’ve downloaded, which emails and attachments they’ve opened. And you won’t have access to a history of phone conversations, all conveniently located under their client profiles.\r\nThe good news is that it’s super simple to fix this: Don’t lose any more valuable opportunities. Click <a href=\"{lead:subscriptionlink}\">here </a>to upgrade your CRM subscription now',	'store@example.com',	'You\'re losing out on critical sales data. Upgrade your CRM subscription now.');

-- 12/05/2017
-- version: 2.3.4
CREATE TABLE IF NOT EXISTS `plugin_leads_opportunity_type` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `type_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `type_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_opportunity` ADD COLUMN `opportunity_type_id` INT(10) UNSIGNED DEFAULT NULL;

-- 16/05/2017
-- version: 2.3.5
ALTER TABLE `plugin_leads_data` ADD COLUMN `use_organization_address` ENUM('0', '1') DEFAULT '0' NOT NULL;

-- 22/05/2017
-- version: 2.3.6
ALTER TABLE `plugin_leads_downloader_log` ADD COLUMN `content` TEXT COLLATE utf8_unicode_ci DEFAULT NULL;

-- 22/05/2017
-- version: 2.3.7
ALTER TABLE `plugin_lead_organization` ADD COLUMN `first_contact_creation_date` TIMESTAMP NULL;


-- 19/07/2017
-- version: 2.3.8
ALTER TABLE `plugin_leads_data` ADD COLUMN `last_activity_subtype` VARCHAR(255) COLLATE utf8_unicode_ci DEFAULT NULL;

-- 15/07/2017
-- version: 2.3.9
CREATE TABLE IF NOT EXISTS `plugin_leads_form_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `form_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `form_type` ENUM('internal', 'external') DEFAULT 'internal',
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  UNIQUE (`rule_name`, `form_name`, `form_type`),
  INDEX (`form_name`, `form_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_form_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_form_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_form_rules_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_form_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 18/09/2017
-- version: 2.4.0
UPDATE `plugin` SET `tags`='crm,hiddenemail' WHERE `name` = 'leads';

-- 03/10/2017
-- version: 2.4.1
CREATE TABLE IF NOT EXISTS `plugin_leads_templates_and_directories_config` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `type` VARCHAR(45) NOT NULL,
  `item_name` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`)
)ENGINE = InnoDB DEFAULT CHARACTER SET = utf8 COLLATE = utf8_unicode_ci;

-- 09/10/2017
-- version: 2.4.2
CREATE TABLE IF NOT EXISTS `plugin_leads_events` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `event_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `event_label` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_events_relation` (
  `event_id` INT(10) UNSIGNED NOT NULL,
  `external_id` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`event_id`, `external_id`),
  FOREIGN KEY(`event_id`) REFERENCES `plugin_leads_events` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_general_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `event_id` INT(10) UNSIGNED NOT NULL,
  `rule_name` VARCHAR(255) COLLATE utf8_unicode_ci NOT NULL,
  `created_at` TIMESTAMP NOT NULL,
  `creator_id` INT(10) UNSIGNED DEFAULT NULL,
  `updated_at` TIMESTAMP NOT NULL,
  `editor_id` INT(10) UNSIGNED DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`creator_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`editor_id`) REFERENCES `user` (`id`) ON DELETE SET NULL ON UPDATE NO ACTION,
  FOREIGN KEY (`event_id`) REFERENCES `plugin_leads_events` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION,
  UNIQUE (`rule_name`, `event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_config` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `field_name` VARCHAR (255) COLLATE utf8_unicode_ci NOT NULL,
  `rule_comparison_operator` ENUM('equal', 'notequal', 'like', 'in') DEFAULT 'equal',
  `field_value` MEDIUMTEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_event_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

CREATE TABLE IF NOT EXISTS `plugin_leads_event_rules_actions` (
  `id` INT(10) UNSIGNED AUTO_INCREMENT NOT NULL,
  `rule_id` INT(10) UNSIGNED NOT NULL,
  `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle') DEFAULT 'assign_owner',
  `action_config` TEXT COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY(`id`),
  UNIQUE(`rule_id`, `action_type`),
  FOREIGN KEY (`rule_id`) REFERENCES `plugin_leads_event_rules_general_config` (`id`) ON DELETE CASCADE ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

ALTER TABLE `plugin_leads_form_rules_actions` MODIFY COLUMN `action_type` ENUM ('assign_owner', 'assign_task', 'assign_tags', 'assign_lifecycle') DEFAULT 'assign_owner';
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `call_source` VARCHAR(255) DEFAULT NULL;
ALTER TABLE `plugin_leads_call_log` ADD COLUMN `receiver` VARCHAR(20) COLLATE utf8_unicode_ci DEFAULT NULL;

-- These alters are always the latest and updated version of the database
UPDATE `plugin` SET `version`='2.4.3' WHERE `name`='leads';
SELECT version FROM `plugin` WHERE `name` = 'leads';

