import {mapGetters} from 'vuex';
//import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
export default {
    props:['id'],
    data () {
        return {
            loadedScreen: false,
            goalId: 0,
            companyName: '',
            websiteUrl: $('#website_url').val(),
            localeMapping: localeMapping,
            locale: $('#system-language-goal-app').val(),
            quota: '',
            meetingsHeld:'',
            callsPlaced:'',
            emailsSent:'',
            oppType:0,
            oppAmount:'',
            oppCount:'',
            displayOppDetails: false,
            quoteObjective: '',
            fiscalYearStart: '',
            fiscalYears: [
                {text: 'January',   value: '1'},
                {text: 'February',  value: '2'},
                {text: 'March',     value: '3'},
                {text: 'April',     value: '4'},
                {text: 'May',       value: '5'},
                {text: 'June',      value: '6'},
                {text: 'July',      value: '7'},
                {text: 'August',    value: '8'},
                {text: 'September', value: '9'},
                {text: 'October',   value: '10'},
                {text: 'November',  value: '11'},
                {text: 'December',  value: '12'}
            ]
        }
    },
    components: {

    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            configDataInfo:'getConfigDataInfo',
            additionalInfo: 'getAdditionalInfo',
            oppGoalStats: 'getOppGoalStats',
            globalStats: 'getGlobalStats',
            sortByColumn: 'sortByColumn'
        }),
    },
    methods: {
        async updateConfig(){

            const result = await this.$store.dispatch('updateConfigData', {
                'id':this.id,
                'quotes_amount':this.quota,
                'meetings_held':this.meetingsHeld,
                'emails_sent':this.emailsSent,
                'calls_placed':this.callsPlaced,
                'quote_objective':this.quoteObjective
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {

                showMessage(result.message, false, 2000);

                const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                if(result.status === 'error') {

                } else {
                    this.loadedScreen = true;
                }
            }

        },
        async changeOpportunityType()
        {
            if (this.oppType == '0') {
                this.displayOppDetails = false;
            } else {
                const result = await this.$store.dispatch('getOppDataInfo', {
                    'goalId':this.id,
                    'opportunityId':this.oppType
                });
                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                }
                let data = result.data;

                this.oppAmount = data.opportunityAmount;
                this.oppCount = data.opportunityCount;

                this.displayOppDetails = true;
            }
        },
        async updateOpportunityConfig()
        {
            const result = await this.$store.dispatch('saveOppDataInfo', {
                'goalId':this.id,
                'opportunityId':this.oppType,
                'oppAmount': this.oppAmount,
                'oppCount': this.oppCount
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                const resultInfo = await this.$store.dispatch('getOppDataInfo', {
                    'goalId':this.id,
                    'opportunityId':this.oppType
                });
            }


        },
        async fiscalYearStartChange(e) {
            let fiscalYearStartMonth = e.target.value;

            const result = await this.$store.dispatch('saveFiscalYearStart', {'fiscalYearStartMonth': fiscalYearStartMonth});
            if(result.error) {
                showMessage(result.responseText, true, 2000);
            } else {
                showMessage(result.responseText, false, 2000);
            }
        }
    },
    async created(){
        this.goalId = this.$route.params.id;

        const resultConfigData = await this.$store.dispatch('getConfigDetailedData', {'router':this.$router, 'id':this.goalId, 'leadGoalDetailed': '1'});
        if (resultConfigData.status === 'error') {

        } else {
            console.log(resultConfigData);
            let data = resultConfigData.data;

            this.fiscalYearStart = resultConfigData.fiscalYearStart;
            this.quota = data.quotes_amount;
            this.meetingsHeld = data.meetings_held;
            this.callsPlaced = data.calls_placed;
            this.emailsSent = data.emails_sent;
            this.quoteObjective = data.quote_objective;
            this.loadedScreen = true;
        }

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }

}
