import {mapGetters} from 'vuex';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';
import each from 'lodash/each';
export default {
    data () {
        return {
            loadedForm: false,
            loadedGrid: false,
            loadedDetails:false,
            isUpdate: false,
            activeTab:'basic',
            serviceId: '',
            temporaryBlock:false,
            temporaryRecordId:0,
            temporaryRecordProcessing:false,
            updateConfigProcessing:false,
            oauth2AuthLink:'',
            emailsPath: '',
            historicalEmailsPath: '',
            configId: 0,
            updated_at:'',
            serviceName: '',
            leadOwnerId: 0,
            host: '',
            login: '',
            password: '',
            encryption: 'none',
            isOauth2: 0,
            processAllEmails: false,
            configConnectionStatus:false,
            websiteUrl: $('#website_url').val(),
            verificationDone: false,
            isRestricted: false,
            localeMapping: localeMapping,
            locale: $('#system-language-imap-config').val(),
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            watchVerification:'getForceConnectionVerification',
            gridStatuses:'getGridStatuses',
        }),
    },
    watch: {
        watchVerification(newVal, oldVal) {
            if (typeof newVal !== 'undefined') {
                this.verificationDone = false;
                this.$store.commit('setGridStatuses', []);
                this.verifyConnections();
            }
        }
    },
    methods: {
        async addEditImapConfig()
        {
            let countConfigRows = this.configDataInfo.length;
            let serviceName = this.serviceName;
            let host = this.host;
            let login = this.login;
            let password = this.password;
            let isOauth2 = 0;

            if (this.isRestricted === true && parseInt(countConfigRows) === 3 && !this.isUpdate) {
                showMessage(this.$t('message.limitWasExceeded'), true, 2000);
                return false;
            }

            if (serviceName === '') {
                showMessage(this.$t('message.notEmptyService'), true, 2000);
                return false;
            }

            if (parseInt(this.leadOwnerId) === 0 && this.isRestricted === false) {
                showMessage(this.$t('message.selectLeadOwner'), true, 2000);
                return false;
            }

            if (host === '') {
                showMessage(this.$t('message.notEmptyHost'), true, 2000);
                return false;
            }

            if (login === '') {
                showMessage(this.$t('message.notEmptyLogin'), true, 2000);
                return false;
            }

            if (password === '' && !this.isUpdate) {
                showMessage(this.$t('message.notEmptyPassword'), true, 2000);
                return false;
            }

            let imapAction = 'saveConfigData';
            if (this.isUpdate) {
                imapAction = 'updateImapConfig';
            }

            const result = await this.$store.dispatch(imapAction, {
                'configId'          :this.configId,
                'serviceName'       :this.serviceName.replace(/[^a-zA-Z0-9-_ ]/g, ''),
                'leadOwner'         :this.leadOwnerId,
                'host'              :this.host,
                'login'             :this.login,
                'password'          :this.password,
                'encryption'        :this.encryption,
                'processAllEmails'  :(this.processAllEmails) ? 1 : 0,
                'isOauth2'          : isOauth2,
                'isTemporary'       : 0
            });

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                if (!this.isUpdate) {
                    this.resetParams();
                }

                showMessage(result.message, false, 2000);

                if (!this.isUpdate) {
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router': this.$router});
                    if (result.status !== 'error') {
                        this.loadedGrid = true;

                        this.$store.commit('setForceConnectionVerification', Date.now());
                    }
                }
            }
        },
        async createTemporaryRecord()
        {
            let countConfigRows = this.configDataInfo.length;
            let serviceName = this.serviceName;
            let isOauth2 = 0;
            let login = this.login;

            if (this.activeTab !== 'oauth2') {
                return false;
            }

            if (this.temporaryBlock === true) {
                return false;
            }

            if (this.temporaryRecordProcessing === true) {
                return false;
            }

            this.temporaryRecordProcessing = true;

            isOauth2 = 1;

            if (this.isRestricted === true && parseInt(countConfigRows) === 3 && !this.isUpdate) {
                this.temporaryRecordProcessing = false;
                showMessage(this.$t('message.limitWasExceeded'), true, 2000);
                return false;
            }

            if (serviceName === '') {
                this.temporaryRecordProcessing = false;
                showMessage(this.$t('message.notEmptyService'), true, 2000);
                return false;
            }

            if (login === '') {
                this.temporaryRecordProcessing = false;
                showMessage(this.$t('message.notEmptyEmailAddress'), true, 2000);
                return false;
            }

            if (parseInt(this.leadOwnerId) === 0 && this.isRestricted === false) {
                this.temporaryRecordProcessing = false;
                showMessage(this.$t('message.selectLeadOwner'), true, 2000);
                return false;
            }

            if (this.serviceId === '') {
                this.temporaryRecordProcessing = false;
                showMessage(this.$t('message.pleaseChooseService'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('saveConfigData', {
                'configId'          :this.configId,
                'serviceName'       :this.serviceName.replace(/[^a-zA-Z0-9-_ ]/g, ''),
                'leadOwner'         :this.leadOwnerId,
                'processAllEmails'  :(this.processAllEmails) ? 1 : 0,
                'isOauth2'          :isOauth2,
                'login'             :this.login,
                'isTemporary'       : 1,
                'oauth2ServiceAppName' : this.serviceId
            });

            if (result.status === 'error') {
                this.temporaryBlock = false;
                this.temporaryRecordProcessing = false;
                showMessage(result.message, true, 2000);
                return false;
            } else {
                if (typeof result.imapInfo === 'undefined') {
                    showMessage('', true, 2000);
                    return false;
                }

                this.temporaryBlock = true;
                this.temporaryRecordId = parseInt(result.imapInfo.id);
                this.temporaryRecordProcessing = false;
                this.oauth2AuthLink = result.imapInfo.authLink;
            }

        },
        async updateOauth2Config()
        {
            let countConfigRows = this.configDataInfo.length;
            let serviceName = this.serviceName;
            let isOauth2 = 0;
            let login = this.login;

            if (this.updateConfigProcessing === true) {
                return false;
            }

            this.updateConfigProcessing = true;

            isOauth2 = 1;

            if (this.isRestricted === true && parseInt(countConfigRows) === 3 && !this.isUpdate) {
                this.updateConfigProcessing = false;
                showMessage(this.$t('message.limitWasExceeded'), true, 2000);
                return false;
            }

            if (serviceName === '') {
                this.updateConfigProcessing = false;
                showMessage(this.$t('message.notEmptyService'), true, 2000);
                return false;
            }

            if (login === '') {
                this.updateConfigProcessing = false;
                showMessage(this.$t('message.notEmptyEmailAddress'), true, 2000);
                return false;
            }

            if (parseInt(this.leadOwnerId) === 0 && this.isRestricted === false) {
                this.updateConfigProcessing = false;
                showMessage(this.$t('message.selectLeadOwner'), true, 2000);
                return false;
            }

            if (this.serviceId === '') {
                this.updateConfigProcessing = false;
                showMessage(this.$t('message.pleaseChooseService'), true, 2000);
                return false;
            }

            const result = await this.$store.dispatch('updateImapConfig', {
                'configId'          :this.configId,
                'serviceName'       :this.serviceName.replace(/[^a-zA-Z0-9-_ ]/g, ''),
                'leadOwner'         :this.leadOwnerId,
                'processAllEmails'  :(this.processAllEmails) ? 1 : 0,
                'isOauth2'          :isOauth2,
                'login'             :this.login,
                'oauth2ServiceAppName' : this.serviceId
            });

            if (result.status === 'error') {
                this.updateConfigProcessing = false;
                showMessage(result.message, true, 2000);
                return false;
            } else {
                showMessage(result.message, false, 2000);
                this.updateConfigProcessing = false;
                this.configConnectionStatus = true;
            }
        },
        async updateServiceName(id, oldName, event)
        {
            event.preventDefault();
            let serviceParam = event.target.value;

            serviceParam = serviceParam.replace(/[^a-zA-Z0-9'-_ ]/g, '');

            if (serviceParam.length < 1) {
                showMessage(this.$t('message.notEmptyService'), true, 2000);
                event.target.value = oldName;
                return false;
            } else {
                const result = await this.$store.dispatch('updateImapServiceName', {'id': id, 'serviceName': serviceParam});

                if (result.status === 'error') {
                    event.target.value = oldName;
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    event.target.value = serviceParam;
                    showMessage(result.message, false, 2000);
                    return true;
                }
            }
        },
        async updateOwner(id, oldName, event)
        {
            event.preventDefault();
            let ownerId = event.target.value;

            if (!ownerId) {
                showMessage(this.$t('message.selectLeadOwner'), true, 2000);
                event.target.value = oldName;
                return false;
            } else {
                const result = await this.$store.dispatch('updateOwnerId', {'id': id, 'ownerId': ownerId});

                if (result.status === 'error') {
                    event.target.value = oldName;
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    event.target.value = ownerId;
                    showMessage(result.message, false, 2000);
                    return true;
                }
            }
        },
        async editImapConfig(id)
        {
            const result = await this.$store.dispatch('getConfigDetails',  {'router':this.$router, 'id':id});

            if (result.status === 'error') {
                showMessage(this.$t('message.pleaseRelogin'), true, 3000);
                return false;
            } else {
                if (result.id) {
                    this.configId = result.id;
                    this.serviceName = result.service_name;
                    this.leadOwnerId = result.owner_id;
                    this.host = result.host;
                    this.login = result.login;
                    this.encryption = result.encryption;
                    this.isOauth2 = parseInt(result.is_oauth2);
                    if (this.isOauth2 === 1) {
                        this.oauth2AuthLink = result.authLink;
                        this.serviceId = result.oauth2_service_app_name;
                    }
                    this.updated_at = result.updated_at;

                    this.processAllEmails = false;
                    if (parseInt(result.process_all_emails) === 1) {
                        this.processAllEmails = true;
                    }

                    this.isUpdate = true;
                }

                this.configConnectionStatus = 'processing';
                this.checkImapConnection(this.configId);
                this.loadedGrid = false;
                this.loadedDetails = true;
            }
        },
        changeTab(activeTabName){
            this.activeTab = activeTabName;
        },
        backToMainGrid()
        {
            this.verificationDone = false;
            this.loadData();
        },
        async imapCopyPathInfo(param, event)
        {
            event.preventDefault();

            let emailPath = '';

            if (param === 'emailsPath') {
                emailPath = this.emailsPath;
            } else {
                emailPath = this.historicalEmailsPath;
            }

            if (document.queryCommandSupported("copy")) {
                let copyFromEl = $('<textarea/>');
                copyFromEl.text(emailPath);
                $('body').append(copyFromEl);
                copyFromEl.select();
                document.execCommand('copy', true);
                copyFromEl.remove();
                showMessage(this.$t('message.copiedToClipboard'), false, 2000);
            }

            return true;
        },
        async loginPopup(id, matchType) {
            let parameters = "location=1,width=800,height=650";
            parameters += ",left=" + (screen.width - 800) / 2 + ",top=" + (screen.height - 650) / 2;

            let self = this;
            let setupCompleted = false;

            let win = window.open(this.oauth2AuthLink, 'connectPopup', parameters);
            let pollOAuth = window.setInterval(async function () {
                const result = await self.$store.dispatch('getConfigDetails',  {'router':self.$router, 'id':id, 'spinner':false});
                if (result.status !== 'error' && result.id) {
                    if (matchType === 'temporary' && parseInt(result.is_temporary) === 0) {
                        setupCompleted = true;
                    }

                    console.log(result.updated_at);
                    console.log(self.updated_at);

                    if (matchType === 'updated' && result.updated_at !== self.updated_at) {
                        setupCompleted = true;
                    }

                    if (setupCompleted === true) {
                        window.clearInterval(pollOAuth);
                        win.close();
                        self.editImapConfig(id);
                    }
                } else {
                    window.clearInterval(pollOAuth);
                    win.close();
                }

            }, 500);
        },
        async cancelTemporaryConfig()
        {
            const result = await this.$store.dispatch('deleteConfigRecord', {'id': this.temporaryRecordId, 'temporaryRecord': 1});

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            }

            this.temporaryBlock = false;
            this.temporaryRecordId = 0;
        },
        async deleteConfigItem(id)
        {
            showConfirm(this.$t('message.areYouSureYouWantToDelete'), async () => {
                const result = await this.$store.dispatch('deleteConfigRecord', {'id': id});

                if (result.status === 'error') {
                    showMessage(result.message, true, 2000);
                    return false;
                } else {
                    showMessage(result.message, false, 2000);
                    const resultConfigData = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});
                    if(result.status !== 'error') {
                        this.verificationDone = false;
                        this.verifyConnections();
                    }
                }
            });
        },
        async checkImapConnection(id)
        {
            const result = await this.$store.dispatch('checkImapStatusData', {'id': id});

            if (result.status === 'error') {
                this.configConnectionStatus = false;
                showMessage(result.message, true, 2000);
                return false;
            } else {
                let connectionStatus = result.responseText.connectionStatus;
                let self = this;

                each(connectionStatus, function(status, key){
                    if (status === 'Connected') {
                        self.configConnectionStatus = true;
                    } else {
                        self.configConnectionStatus = false;
                    }
                });
            }
        },
        async checkImapStatus(id)
        {
            const result = await this.$store.dispatch('checkImapStatusData', {'id': id});

            if (result.status === 'error') {
                showMessage(result.message, true, 2000);
                return false;
            } else {
                let self = this;
                let connectionStatus = result.responseText.connectionStatus;

                each(connectionStatus, function(status, key){
                    let gridStatuses = self.gridStatuses;
                    gridStatuses[key] = {'status':status};
                });
            }
        },
        async verifyConnections()
        {
            if (!this.verificationDone) {
                let imapConfigInfo = this.configDataInfo;
                if (imapConfigInfo.length) {
                    let self = this;
                    each(imapConfigInfo, function (config, key) {
                        self.checkImapStatus(config.id);
                    });
                }

                this.verificationDone = true;
            }
        },
        resetParams()
        {
            this.configId = 0;
            this.serviceName = '';
            this.leadOwnerId = 0;
            this.host = '';
            this.login = '';
            this.password = '';
            this.encryption = 'none';
            this.processAllEmails = false;
            this.isUpdate = false;
            this.activeTab = 'basic';
            this.serviceId = '';
            this.temporaryBlock = false;
            this.temporaryRecordId = 0;
            this.oauth2AuthLink = '';
        },
        async loadData(resetConnectionStatus)
        {
            const result = await this.$store.dispatch('getConfigSavedData', {'router':this.$router});

            if (result.status === 'error') {
                showMessage(this.$t('message.pleaseRelogin'), true, 3000);
                return false;
            } else {
                this.loadedForm = true;
                this.emailsPath = result.emailsPath;
                this.historicalEmailsPath = result.historicalEmailsPath;
                if (parseInt(result.isRestricted) === 1) {
                    this.isRestricted = true;
                } else {
                    this.isRestricted = false;
                }
            }

            this.resetParams();
            this.loadedGrid = true;
            this.loadedDetails = false;
            this.$store.commit('setForceConnectionVerification', Date.now());
        }
    },
    async created()
    {
        if (typeof this.localeMapping[this.locale] !== 'undefined') {
            this.$i18n.locale = this.localeMapping[this.locale];
        }

        this.loadData();
    },
    async updated()
    {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    }
}
