import {mapGetters} from 'vuex';
import lodash from 'lodash';
import localeMapping from '../../../localizationLanguages';
import pagination from '../../pagination';

export default {
    data () {
        return {
            loadedScreen: false,
            websiteUrl: $('#website_url').val(),
            graphType: 'opportunityStagePerSource',
            graphDataExists: false,
            graphDataNotExists: false,
            elName:'#opportunity-stages-per-source-graph-block'
        }
    },
    components: {
        pagination: pagination
    },
    computed: {
        ...mapGetters({
            formatDate: 'formatDate',
            formatOnlyDate: 'formatOnlyDate',
            formatTimeOnly: 'formatTimeOnly',
            configDataInfo:'getConfigDataInfo',
            additionalInfo:'getAdditionalInfo',
            sortByColumn: 'sortByColumn',
            truncateText: 'truncateText',
            filterDateFrom: 'getFilterDateFrom',
            filterDateTo: 'getFilterDateTo',
            changedDate: 'getChangedDate',
            selectedUserId: 'getSelectedUserId',
            formatDateForGraphs:'formatDateForGraphs',
            opportunityStagePerSourceGraphData:'getOpportunityStagePerSourceGraphData'
        })
    },
    watch: {
        selectedUserId (newUserId, oldUseId) {
            console.log(`Old user id ${oldUseId} - new user id ${newUserId}`);
            if (newUserId !== oldUseId) {
                this.drawGraph();
            }
        },
        changedDate () {
            this.drawGraph();
        }
    },
    methods: {
        async drawGraph() {
            const result = await this.$store.dispatch('getGraphData', {'router':this.$router, 'userId':this.selectedUserId, 'graphType':this.graphType, 'filterDateFrom':this.filterDateFrom, 'filterDateTo':this.filterDateTo, 'elName':this.elName});

            this.$store.dispatch('destroyGraph', {
                'elId': '#lead-report-opportunity-stage-per-source'
            });

            this.$store.dispatch('deleteCustomLegend', {
                    'legend':'#lead-report-opportunity-stage-per-source-legend',
                }
            );

            if(result.status === 'error') {
                showMessage('Please re-login', true, 3000);
            } else {
                let opportunityStagePerSourceGraphData = this.opportunityStagePerSourceGraphData,
                    chartData = [];

                if (typeof opportunityStagePerSourceGraphData[this.graphType].axes !== 'undefined') {
                    chartData = [
                        opportunityStagePerSourceGraphData[this.graphType].axes
                    ];

                    let opportunitiesGroupFrom = opportunityStagePerSourceGraphData[this.graphType].opportunitiesGroupFrom,
                        groups = [],
                        onlyData = [],
                        compare = false;

                    groups.push(opportunitiesGroupFrom);

                    _.each(opportunityStagePerSourceGraphData[this.graphType].data, function(opportunityData, opportunity){
                        let cleanLegendId = '';
                        if (!_.isArray(opportunityData)) {
                            let dataArr = [];
                            _.each(opportunityData, function(elem, key){
                                dataArr[key] = elem;
                            });
                            chartData.push(dataArr);
                        } else {
                            chartData.push(opportunityData);
                        }

                        if (opportunityData[0].match(/\*/) !== null) {
                            cleanLegendId = opportunityData[0].substring(1);
                        } else {
                            cleanLegendId = opportunityData[0];
                        }
                        if (_.indexOf(onlyData, cleanLegendId) == '-1') {
                            onlyData.push(cleanLegendId);
                        }
                    });

                    if (typeof opportunityStagePerSourceGraphData[this.graphType].dataToCompare !== 'undefined') {
                        groups.push(opportunityStagePerSourceGraphData[this.graphType].opportunitiesGroupTo);
                        compare = true;
                    }

                    this.graphDataExists = true;
                    this.graphDataNotExists = false;

                    let leadOwnerId = this.selectedUserId;
                    if (this.selectedUserId == '-2') {
                        leadOwnerId = this.additionalInfo.loggedUserId;
                    }

                    if (this.selectedUserId == '-1') {
                        leadOwnerId = 0;
                    }

                    if (this.selectedUserId == '') {
                        leadOwnerId = this.additionalInfo.loggedUserId;
                    }

                    this.$store.dispatch('drawBarGraph', {
                        'elId': '#lead-report-opportunity-stage-per-source',
                        'chartData': chartData,
                        'percentWidth': 45,
                        'customParamsData': {
                            'axesAdditionalInfo': opportunityStagePerSourceGraphData[this.graphType].axesAdditionalInfo,
                            'groups':groups,
                            'colorPattern':opportunityStagePerSourceGraphData[this.graphType].colorPattern,
                            //'title':opportunityStagePerSourceGraphData[this.graphType].title,
                            'title':'',
                            'customYAxisFormat': {
                                type: 'onlyInteger'
                            },
                            'tooltip': {
                                filterFromDate: opportunityStagePerSourceGraphData[this.graphType].filterFromDate,
                                filterToDate: opportunityStagePerSourceGraphData[this.graphType].filterToDate,
                                compare: compare
                            },
                            'filterStartDate':this.formatDateForGraphs(opportunityStagePerSourceGraphData[this.graphType].filterStartDate),
                            'filterEndDate':this.formatDateForGraphs(opportunityStagePerSourceGraphData[this.graphType].filterEndDate),
                            'rangeOptions':'custom',
                            'predefinedParams':'lead_opportunity_stages=10,20,30,40,50,60,70,80,90,100',
                            'defaultFilterFromDateNameField':'opportunity_created_at_from',
                            'defaultFilterToDateNameField':'opportunity_created_at_to',
                            'filterType':'lead_source_type',
                            'additionalFilter':'',
                            'filterFromDateNameAlternative':'',
                            'filterToDateNameAlternative':'',
                            'leadOwnerId':leadOwnerId
                        },
                        'router': this.$router
                    });

                    this.$store.dispatch('createCustomLegend',
                        {
                            'legend':'#lead-report-opportunity-stage-per-source-legend',
                            'chartEl':'#lead-report-opportunity-stage-per-source',
                            'xValues':onlyData,
                            'fullColorPattern':opportunityStagePerSourceGraphData[this.graphType].fullColorPattern
                        }
                    );

                } else {
                    this.graphDataNotExists = true;

                }

                this.loadedScreen = true;

            }

        }
    },
    async created(){

    },
    async updated() {
        this.$nextTick(function () {
            if (typeof checkboxRadioStyle !== 'undefined' && typeof checkboxRadioStyle() === "function") {
                checkboxRadioStyle();
            }
        })
    },
    async mounted()  {
        this.graphDataExists = true;
        this.drawGraph();
    }
}
