define([
    'backbone',
    './industry-type-form.js',
    './industry-type-grid.js',
    'i18n!../../../nls/config_'+$('#lead-industry-types-config-system-language').val()+'_ln.js'
], function(Backbone,
            IndustryTypeFormView, IndustryTypeGridView, i18n){
    var LeadCrmConfigMainView = Backbone.View.extend({
        el: $('#industry-crm-config-block'),
        events:{
            'submit #industry-type-search-form' : 'search',
            'change #allow-industries-creation': 'allowIndustriesCreation',
            'click .clear-input': 'clearInput',
        },
        templates: {},
        initialize: function(){
            showSpinner();

            this.$el = $('#industry-crm-config-block');

            this.IndustryTypeForm = new IndustryTypeFormView();
            this.IndustryTypeForm.render();

            this.IndustryTypeGrid = new IndustryTypeGridView();
            this.IndustryTypeGrid.IndustryTypes.server_api.searchTerm = '';
            this.IndustryTypeGrid.render();

            this.IndustryTypeForm.$el.on('IndustryTypeForm:created', _.bind(this.IndustryTypeGrid.render, this.IndustryTypeGrid));

        },
        clearInput: function () {
            $('#industry-type-search-form').find('input#search-term').val('').trigger('submit');
        },
        search : function (e) {
            e.preventDefault();
            this.IndustryTypeGrid.IndustryTypes.server_api.searchTerm = $('#search-term').val();
            this.IndustryTypeForm.$el.trigger('IndustryTypeForm:created');
        },
        allowIndustriesCreation: function (e) {
            e.preventDefault();
            var currentEl = $(e.currentTarget),
                self = this,
                allowIndustriesCreation = 0;

            if (currentEl.is(':checked')) {
                showConfirm(_.isUndefined(i18n['Attention! external services can create Organization industries! Are you sure want to enable this ability?'])?'Attention! external services can create Organization industries! Are you sure want to enable this ability?':i18n['Attention! external services can create Organization industries! Are you sure want to enable this ability?'], function(){
                    currentEl.prop('checked', true);
                    allowIndustriesCreation = 1;

                    self.sendAjaxAllowIndustriesCreation(allowIndustriesCreation ,true);
                }, function () {
                    currentEl.prop('checked', false);
                    return false;
                });
            } else {
                allowIndustriesCreation = 0;

                self.sendAjaxAllowIndustriesCreation(allowIndustriesCreation, false);
            }
        },
        sendAjaxAllowIndustriesCreation: function (allowIndustriesCreation, action) {
            $.ajax({
                url: $('#website_url').val()+'plugin/leads/run/allowIndustriesCreation/',
                type: 'POST',
                dataType: 'json',
                data:{'secureToken' : $('#lead-industry-secure-token').val(), 'allowIndustriesCreation' : allowIndustriesCreation}
            }).done(function(response){
                if (response.error == '1') {
                    showMessage(response.responseText, true, 5000);
                } else {
                    var msg = _.isUndefined(i18n['Activated'])?'Activated':i18n['Activated'];
                    if(!action) {
                        msg = _.isUndefined(i18n['Deactivated'])?'Deactivated':i18n['Deactivated'];
                    }
                    showMessage(msg, false, 3000);
                }
            });
        }
    });

    return LeadCrmConfigMainView;
});
