define([
    'backbone',
    '../models/event-rule',
    'backbone.paginator'
], function(Backbone, EventRuleModel){

    var EventRulesCollection = Backbone.Paginator.requestPager.extend({
        model: EventRuleModel,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/eventrules/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     10,
            totalPages:  10
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            detailedInfo: function(){ return this.detailedInfo; },
            order: function(){ return this.order; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.limitedAccess = response.limitedAccess;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return EventRulesCollection;
});