define([
    'backbone',
    '../models/lead-workflows',
    'backbone.paginator'
], function(Backbone, LeadWorkflow){

    var LeadWorkflowCollection = Backbone.Paginator.requestPager.extend({
        model: LeadWorkflow,
        paginator_core: {
            type: 'GET',
            dataType: 'json',
            url: function(){
                return $('#website_url').val() + 'api/leads/leadworkflowattr/';
            }
        },
        paginator_ui: {
            firstPage:    0,
            currentPage:  0,
            perPage:     1000,
            totalPages:  1000
        },
        server_api: {
            count: true,
            limit: function() { return this.perPage; },
            offset: function() { return this.currentPage * this.perPage },
            key: function(){ return this.key; },
            isGrid: function(){ return this.isGrid; },
            detailedInfo: function(){ return this.detailedInfo; },
            order: function(){ return this.order; }
        },
        parse: function(response, xhr){
            if (this.server_api.count){
                this.totalRecords = response.totalRecords;
            } else {
                this.totalRecords = response.length;
            }

            this.forms = response.forms;
            this.leadOwners = response.leadOwners;
            this.taskPresets = response.taskPresets;
            this.taskPresetsFull = response.taskPresetsFull;
            this.customerGroups = response.customerGroups;
            this.countryCodes = response.countryCodes;
            this.scorePropertyActions = response.scorePropertyActions;
            this.scoreActions = response.scoreActions;
            this.stages = response.stages;
            this.industries = response.industries;
            this.leadTags = response.leadTags;
            this.leadsPredefinedValues = response.leadsPredefinedValues;
            this.opportunityStages = response.opportunityStages;
            this.opportunityTypes = response.opportunityTypes;
            this.cronScriptPath = response.cronScriptPath;
            this.cronScriptPathAudiences = response.cronScriptPathAudiences;
            this.userTimezoneOffset = response.userTimezoneOffset;
            this.userTimezone = response.userTimezone;
            this.timezoneOffset = response.timezoneOffset;
            this.currentUserId = response.currentUserId;
            this.emailSequencies = response.emailSequencies;
            this.emailTemplates = response.emailTemplates;
            this.emailServices = response.emailServices;
            this.limitedAccess = response.limitedAccess;
            this.desktopMasks = response.desktopMasks;
            this.phoneCountryCodes = response.phoneCountryCodes;
            this.userDefaultPhoneMobileCode = response.userDefaultPhoneMobileCode;
            this.advertisingList = response.advertisingList;
            this.totalPages = Math.floor(this.totalRecords / this.perPage);
            return this.server_api.count ? response.data : response;
        }

    });

    return LeadWorkflowCollection;
});
